/* tracker-sparql-scanner.c generated by valac 0.30.0, the Vala compiler
 * generated from tracker-sparql-scanner.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "libtracker-sparql/tracker-sparql.h"
#include <stdlib.h>
#include <string.h>


#define TRACKER_TYPE_SPARQL_SCANNER (tracker_sparql_scanner_get_type ())
#define TRACKER_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner))
#define TRACKER_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))
#define TRACKER_IS_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_IS_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_SPARQL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))

typedef struct _TrackerSparqlScanner TrackerSparqlScanner;
typedef struct _TrackerSparqlScannerClass TrackerSparqlScannerClass;
typedef struct _TrackerSparqlScannerPrivate TrackerSparqlScannerPrivate;

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

struct _TrackerSparqlScanner {
	GObject parent_instance;
	TrackerSparqlScannerPrivate * priv;
};

struct _TrackerSparqlScannerClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlScannerPrivate {
	gchar* current;
	gchar* end;
	gint line;
	gint column;
};

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_ABS,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CEIL,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COALESCE,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_CONTAINS,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DAY,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FLOOR,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_HAVING,
	TRACKER_SPARQL_TOKEN_TYPE_HOURS,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LCASE,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MD5,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_MINUTES,
	TRACKER_SPARQL_TOKEN_TYPE_MONTH,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_NULL,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_ROUND,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SECONDS,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SHA1,
	TRACKER_SPARQL_TOKEN_TYPE_SHA256,
	TRACKER_SPARQL_TOKEN_TYPE_SHA512,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRAFTER,
	TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE,
	TRACKER_SPARQL_TOKEN_TYPE_STRENDS,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_STRLEN,
	TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS,
	TRACKER_SPARQL_TOKEN_TYPE_SUBSTR,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UCASE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH,
	TRACKER_SPARQL_TOKEN_TYPE_YEAR
} TrackerSparqlTokenType;


static gpointer tracker_sparql_scanner_parent_class = NULL;

GType tracker_sparql_scanner_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerPrivate))
enum  {
	TRACKER_SPARQL_SCANNER_DUMMY_PROPERTY
};
TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input, gsize len);
TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type, gchar* input, gsize len);
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
void tracker_sparql_scanner_seek (TrackerSparqlScanner* self, TrackerSourceLocation* location);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
static TrackerSparqlTokenType tracker_sparql_scanner_get_identifier_or_keyword (TrackerSparqlScanner* self, gchar* begin, gint len);
static gboolean tracker_sparql_scanner_matches (TrackerSparqlScanner* self, gchar* begin, const gchar* keyword);
static TrackerSparqlTokenType tracker_sparql_scanner_read_number (TrackerSparqlScanner* self);
static gboolean tracker_sparql_scanner_is_pn_char (TrackerSparqlScanner* self, gchar c);
static gboolean tracker_sparql_scanner_is_pn_local_char (TrackerSparqlScanner* self, gchar c);
static gboolean tracker_sparql_scanner_is_varname_char (TrackerSparqlScanner* self, gchar c);
TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self, TrackerSourceLocation* token_begin, TrackerSourceLocation* token_end, GError** error);
static void tracker_sparql_scanner_space (TrackerSparqlScanner* self);
void tracker_source_location_init (TrackerSourceLocation *self, gchar* pos, gint line, gint column);
static gboolean tracker_sparql_scanner_whitespace (TrackerSparqlScanner* self);
static gboolean tracker_sparql_scanner_comment (TrackerSparqlScanner* self);
static void tracker_sparql_scanner_finalize (GObject* obj);
const gchar* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self);


TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type, gchar* input, gsize len) {
	TrackerSparqlScanner * self = NULL;
	gchar* begin = NULL;
	gchar* _tmp0_ = NULL;
	gsize _tmp1_ = 0UL;
#line 27 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self = (TrackerSparqlScanner*) g_object_new (object_type, NULL);
#line 28 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp0_ = input;
#line 28 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	begin = _tmp0_;
#line 29 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = len;
#line 29 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->end = begin + _tmp1_;
#line 31 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->current = begin;
#line 33 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->line = 1;
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->column = 1;
#line 27 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return self;
#line 248 "tracker-sparql-scanner.c"
}


TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input, gsize len) {
#line 27 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return tracker_sparql_scanner_construct (TRACKER_TYPE_SPARQL_SCANNER, input, len);
#line 255 "tracker-sparql-scanner.c"
}


void tracker_sparql_scanner_seek (TrackerSparqlScanner* self, TrackerSourceLocation* location) {
	TrackerSourceLocation _tmp0_ = {0};
	gchar* _tmp1_ = NULL;
	TrackerSourceLocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	TrackerSourceLocation _tmp4_ = {0};
	gint _tmp5_ = 0;
#line 37 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_if_fail (self != NULL);
#line 37 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_if_fail (location != NULL);
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp0_ = *location;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = _tmp0_.pos;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->current = _tmp1_;
#line 39 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = *location;
#line 39 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp3_ = _tmp2_.line;
#line 39 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->line = _tmp3_;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp4_ = *location;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp5_ = _tmp4_.column;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->column = _tmp5_;
#line 288 "tracker-sparql-scanner.c"
}


static TrackerSparqlTokenType tracker_sparql_scanner_get_identifier_or_keyword (TrackerSparqlScanner* self, gchar* begin, gint len) {
	TrackerSparqlTokenType result = 0;
	gint _tmp0_ = 0;
#line 43 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp0_ = len;
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	switch (_tmp0_) {
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 1:
#line 303 "tracker-sparql-scanner.c"
		{
			gchar* _tmp1_ = NULL;
			gchar _tmp2_ = '\0';
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp1_ = begin;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp2_ = _tmp1_[0];
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp2_) {
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'A':
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'a':
#line 317 "tracker-sparql-scanner.c"
				{
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					result = TRACKER_SPARQL_TOKEN_TYPE_A;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					return result;
#line 323 "tracker-sparql-scanner.c"
				}
				default:
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 328 "tracker-sparql-scanner.c"
			}
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 332 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 2:
#line 336 "tracker-sparql-scanner.c"
		{
			gchar* _tmp3_ = NULL;
			gchar _tmp4_ = '\0';
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp3_ = begin;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp4_ = _tmp3_[0];
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp4_) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'A':
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'a':
#line 350 "tracker-sparql-scanner.c"
				{
					gchar* _tmp5_ = NULL;
					gboolean _tmp6_ = FALSE;
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp5_ = begin;
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp6_ = tracker_sparql_scanner_matches (self, _tmp5_, "AS");
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp6_) {
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_AS;
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 364 "tracker-sparql-scanner.c"
					}
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 368 "tracker-sparql-scanner.c"
				}
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'B':
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'b':
#line 374 "tracker-sparql-scanner.c"
				{
					gchar* _tmp7_ = NULL;
					gboolean _tmp8_ = FALSE;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp7_ = begin;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp8_ = tracker_sparql_scanner_matches (self, _tmp7_, "BY");
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp8_) {
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_BY;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 388 "tracker-sparql-scanner.c"
					}
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 392 "tracker-sparql-scanner.c"
				}
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 398 "tracker-sparql-scanner.c"
				{
					gchar* _tmp9_ = NULL;
					gchar _tmp10_ = '\0';
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp9_ = begin;
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp10_ = _tmp9_[1];
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp10_) {
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'F':
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'f':
#line 412 "tracker-sparql-scanner.c"
						{
							gchar* _tmp11_ = NULL;
							gboolean _tmp12_ = FALSE;
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp11_ = begin;
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp12_ = tracker_sparql_scanner_matches (self, _tmp11_, "IF");
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp12_) {
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_IF;
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 426 "tracker-sparql-scanner.c"
							}
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 430 "tracker-sparql-scanner.c"
						}
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'N':
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'n':
#line 436 "tracker-sparql-scanner.c"
						{
							gchar* _tmp13_ = NULL;
							gboolean _tmp14_ = FALSE;
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp13_ = begin;
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp14_ = tracker_sparql_scanner_matches (self, _tmp13_, "IN");
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp14_) {
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_OP_IN;
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 450 "tracker-sparql-scanner.c"
							}
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 454 "tracker-sparql-scanner.c"
						}
						default:
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 459 "tracker-sparql-scanner.c"
					}
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 463 "tracker-sparql-scanner.c"
				}
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'O':
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'o':
#line 469 "tracker-sparql-scanner.c"
				{
					gchar* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp15_ = begin;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp16_ = tracker_sparql_scanner_matches (self, _tmp15_, "OR");
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp16_) {
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_OR;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 483 "tracker-sparql-scanner.c"
					}
#line 78 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 487 "tracker-sparql-scanner.c"
				}
				default:
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 492 "tracker-sparql-scanner.c"
			}
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 496 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 3:
#line 500 "tracker-sparql-scanner.c"
		{
			gchar* _tmp17_ = NULL;
			gchar _tmp18_ = '\0';
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp17_ = begin;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp18_ = _tmp17_[0];
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp18_) {
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'A':
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'a':
#line 514 "tracker-sparql-scanner.c"
				{
					gchar* _tmp19_ = NULL;
					gchar _tmp20_ = '\0';
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp19_ = begin;
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp20_ = _tmp19_[1];
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp20_) {
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'S':
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 's':
#line 528 "tracker-sparql-scanner.c"
						{
							gchar* _tmp21_ = NULL;
							gchar _tmp22_ = '\0';
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp21_ = begin;
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp22_ = _tmp21_[2];
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp22_) {
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'C':
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'c':
#line 542 "tracker-sparql-scanner.c"
								{
									gchar* _tmp23_ = NULL;
									gboolean _tmp24_ = FALSE;
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp23_ = begin;
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp24_ = tracker_sparql_scanner_matches (self, _tmp23_, "ASC");
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (_tmp24_) {
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ASC;
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 556 "tracker-sparql-scanner.c"
									}
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 560 "tracker-sparql-scanner.c"
								}
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'K':
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'k':
#line 566 "tracker-sparql-scanner.c"
								{
									gchar* _tmp25_ = NULL;
									gboolean _tmp26_ = FALSE;
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp25_ = begin;
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp26_ = tracker_sparql_scanner_matches (self, _tmp25_, "ASK");
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (_tmp26_) {
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ASK;
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 580 "tracker-sparql-scanner.c"
									}
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 584 "tracker-sparql-scanner.c"
								}
								default:
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 589 "tracker-sparql-scanner.c"
							}
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 593 "tracker-sparql-scanner.c"
						}
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'B':
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'b':
#line 599 "tracker-sparql-scanner.c"
						{
							gchar* _tmp27_ = NULL;
							gboolean _tmp28_ = FALSE;
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp27_ = begin;
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp28_ = tracker_sparql_scanner_matches (self, _tmp27_, "ABS");
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp28_) {
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_ABS;
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 613 "tracker-sparql-scanner.c"
							}
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 617 "tracker-sparql-scanner.c"
						}
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'V':
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'v':
#line 623 "tracker-sparql-scanner.c"
						{
							gchar* _tmp29_ = NULL;
							gboolean _tmp30_ = FALSE;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp29_ = begin;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp30_ = tracker_sparql_scanner_matches (self, _tmp29_, "AVG");
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp30_) {
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_AVG;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 637 "tracker-sparql-scanner.c"
							}
#line 106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 641 "tracker-sparql-scanner.c"
						}
						default:
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 646 "tracker-sparql-scanner.c"
					}
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 650 "tracker-sparql-scanner.c"
				}
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'D':
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'd':
#line 656 "tracker-sparql-scanner.c"
				{
					gchar* _tmp31_ = NULL;
					gboolean _tmp32_ = FALSE;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp31_ = begin;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp32_ = tracker_sparql_scanner_matches (self, _tmp31_, "DAY");
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp32_) {
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_DAY;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 670 "tracker-sparql-scanner.c"
					}
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 674 "tracker-sparql-scanner.c"
				}
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'M':
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'm':
#line 680 "tracker-sparql-scanner.c"
				{
					gchar* _tmp33_ = NULL;
					gchar _tmp34_ = '\0';
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp33_ = begin;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp34_ = _tmp33_[1];
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp34_) {
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 694 "tracker-sparql-scanner.c"
						{
							gchar* _tmp35_ = NULL;
							gboolean _tmp36_ = FALSE;
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp35_ = begin;
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp36_ = tracker_sparql_scanner_matches (self, _tmp35_, "MAX");
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp36_) {
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_MAX;
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 708 "tracker-sparql-scanner.c"
							}
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 712 "tracker-sparql-scanner.c"
						}
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'D':
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'd':
#line 718 "tracker-sparql-scanner.c"
						{
							gchar* _tmp37_ = NULL;
							gboolean _tmp38_ = FALSE;
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp37_ = begin;
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp38_ = tracker_sparql_scanner_matches (self, _tmp37_, "MD5");
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp38_) {
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_MD5;
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 732 "tracker-sparql-scanner.c"
							}
#line 123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 736 "tracker-sparql-scanner.c"
						}
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'I':
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'i':
#line 742 "tracker-sparql-scanner.c"
						{
							gchar* _tmp39_ = NULL;
							gboolean _tmp40_ = FALSE;
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp39_ = begin;
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp40_ = tracker_sparql_scanner_matches (self, _tmp39_, "MIN");
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp40_) {
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_MIN;
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 756 "tracker-sparql-scanner.c"
							}
#line 127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 760 "tracker-sparql-scanner.c"
						}
						default:
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 765 "tracker-sparql-scanner.c"
					}
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 769 "tracker-sparql-scanner.c"
				}
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'N':
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'n':
#line 775 "tracker-sparql-scanner.c"
				{
					gchar* _tmp41_ = NULL;
					gboolean _tmp42_ = FALSE;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp41_ = begin;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp42_ = tracker_sparql_scanner_matches (self, _tmp41_, "NOT");
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp42_) {
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_NOT;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 789 "tracker-sparql-scanner.c"
					}
#line 133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 793 "tracker-sparql-scanner.c"
				}
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 799 "tracker-sparql-scanner.c"
				{
					gchar* _tmp43_ = NULL;
					gchar _tmp44_ = '\0';
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp43_ = begin;
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp44_ = _tmp43_[1];
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp44_) {
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'T':
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 't':
#line 813 "tracker-sparql-scanner.c"
						{
							gchar* _tmp45_ = NULL;
							gboolean _tmp46_ = FALSE;
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp45_ = begin;
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp46_ = tracker_sparql_scanner_matches (self, _tmp45_, "STR");
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp46_) {
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STR;
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 827 "tracker-sparql-scanner.c"
							}
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 831 "tracker-sparql-scanner.c"
						}
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'U':
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'u':
#line 837 "tracker-sparql-scanner.c"
						{
							gchar* _tmp47_ = NULL;
							gboolean _tmp48_ = FALSE;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp47_ = begin;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp48_ = tracker_sparql_scanner_matches (self, _tmp47_, "SUM");
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp48_) {
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SUM;
#line 143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 851 "tracker-sparql-scanner.c"
							}
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 855 "tracker-sparql-scanner.c"
						}
						default:
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 860 "tracker-sparql-scanner.c"
					}
#line 146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 864 "tracker-sparql-scanner.c"
				}
				default:
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 869 "tracker-sparql-scanner.c"
			}
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 873 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 4:
#line 877 "tracker-sparql-scanner.c"
		{
			gchar* _tmp49_ = NULL;
			gchar _tmp50_ = '\0';
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp49_ = begin;
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp50_ = _tmp49_[0];
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp50_) {
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'B':
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'b':
#line 891 "tracker-sparql-scanner.c"
				{
					gchar* _tmp51_ = NULL;
					gboolean _tmp52_ = FALSE;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp51_ = begin;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp52_ = tracker_sparql_scanner_matches (self, _tmp51_, "BASE");
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp52_) {
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_BASE;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 905 "tracker-sparql-scanner.c"
					}
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 909 "tracker-sparql-scanner.c"
				}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 915 "tracker-sparql-scanner.c"
				{
					gchar* _tmp53_ = NULL;
					gboolean _tmp54_ = FALSE;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp53_ = begin;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp54_ = tracker_sparql_scanner_matches (self, _tmp53_, "CEIL");
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp54_) {
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_CEIL;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 929 "tracker-sparql-scanner.c"
					}
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 933 "tracker-sparql-scanner.c"
				}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'D':
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'd':
#line 939 "tracker-sparql-scanner.c"
				{
					gchar* _tmp55_ = NULL;
					gchar _tmp56_ = '\0';
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp55_ = begin;
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp56_ = _tmp55_[1];
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp56_) {
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 953 "tracker-sparql-scanner.c"
						{
							gchar* _tmp57_ = NULL;
							gboolean _tmp58_ = FALSE;
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp57_ = begin;
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp58_ = tracker_sparql_scanner_matches (self, _tmp57_, "DATA");
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp58_) {
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DATA;
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 967 "tracker-sparql-scanner.c"
							}
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 971 "tracker-sparql-scanner.c"
						}
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 977 "tracker-sparql-scanner.c"
						{
							gchar* _tmp59_ = NULL;
							gboolean _tmp60_ = FALSE;
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp59_ = begin;
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp60_ = tracker_sparql_scanner_matches (self, _tmp59_, "DESC");
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp60_) {
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DESC;
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 991 "tracker-sparql-scanner.c"
							}
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 995 "tracker-sparql-scanner.c"
						}
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'R':
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'r':
#line 1001 "tracker-sparql-scanner.c"
						{
							gchar* _tmp61_ = NULL;
							gboolean _tmp62_ = FALSE;
#line 172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp61_ = begin;
#line 172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp62_ = tracker_sparql_scanner_matches (self, _tmp61_, "DROP");
#line 172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp62_) {
#line 172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DROP;
#line 172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1015 "tracker-sparql-scanner.c"
							}
#line 173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1019 "tracker-sparql-scanner.c"
						}
						default:
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1024 "tracker-sparql-scanner.c"
					}
#line 175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1028 "tracker-sparql-scanner.c"
				}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'F':
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'f':
#line 1034 "tracker-sparql-scanner.c"
				{
					gchar* _tmp63_ = NULL;
					gboolean _tmp64_ = FALSE;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp63_ = begin;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp64_ = tracker_sparql_scanner_matches (self, _tmp63_, "FROM");
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp64_) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_FROM;
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1048 "tracker-sparql-scanner.c"
					}
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1052 "tracker-sparql-scanner.c"
				}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 1058 "tracker-sparql-scanner.c"
				{
					gchar* _tmp65_ = NULL;
					gboolean _tmp66_ = FALSE;
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp65_ = begin;
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp66_ = tracker_sparql_scanner_matches (self, _tmp65_, "INTO");
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp66_) {
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_INTO;
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1072 "tracker-sparql-scanner.c"
					}
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1076 "tracker-sparql-scanner.c"
				}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'L':
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'l':
#line 1082 "tracker-sparql-scanner.c"
				{
					gchar* _tmp67_ = NULL;
					gboolean _tmp68_ = FALSE;
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp67_ = begin;
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp68_ = tracker_sparql_scanner_matches (self, _tmp67_, "LANG");
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp68_) {
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_LANG;
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1096 "tracker-sparql-scanner.c"
					}
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1100 "tracker-sparql-scanner.c"
				}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'N':
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'n':
#line 1106 "tracker-sparql-scanner.c"
				{
					gchar* _tmp69_ = NULL;
					gboolean _tmp70_ = FALSE;
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp69_ = begin;
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp70_ = tracker_sparql_scanner_matches (self, _tmp69_, "NULL");
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp70_) {
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_NULL;
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1120 "tracker-sparql-scanner.c"
					}
#line 191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1124 "tracker-sparql-scanner.c"
				}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 1130 "tracker-sparql-scanner.c"
				{
					gchar* _tmp71_ = NULL;
					gboolean _tmp72_ = FALSE;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp71_ = begin;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp72_ = tracker_sparql_scanner_matches (self, _tmp71_, "SHA1");
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp72_) {
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_SHA1;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1144 "tracker-sparql-scanner.c"
					}
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1148 "tracker-sparql-scanner.c"
				}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'T':
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 't':
#line 1154 "tracker-sparql-scanner.c"
				{
					gchar* _tmp73_ = NULL;
					gboolean _tmp74_ = FALSE;
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp73_ = begin;
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp74_ = tracker_sparql_scanner_matches (self, _tmp73_, "TRUE");
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp74_) {
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_TRUE;
#line 198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1168 "tracker-sparql-scanner.c"
					}
#line 199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1172 "tracker-sparql-scanner.c"
				}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'W':
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'w':
#line 1178 "tracker-sparql-scanner.c"
				{
					gchar* _tmp75_ = NULL;
					gboolean _tmp76_ = FALSE;
#line 202 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp75_ = begin;
#line 202 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp76_ = tracker_sparql_scanner_matches (self, _tmp75_, "WITH");
#line 202 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp76_) {
#line 202 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_WITH;
#line 202 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1192 "tracker-sparql-scanner.c"
					}
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1196 "tracker-sparql-scanner.c"
				}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'Y':
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'y':
#line 1202 "tracker-sparql-scanner.c"
				{
					gchar* _tmp77_ = NULL;
					gboolean _tmp78_ = FALSE;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp77_ = begin;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp78_ = tracker_sparql_scanner_matches (self, _tmp77_, "YEAR");
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp78_) {
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_YEAR;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1216 "tracker-sparql-scanner.c"
					}
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1220 "tracker-sparql-scanner.c"
				}
				default:
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 1225 "tracker-sparql-scanner.c"
			}
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 1229 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 5:
#line 1233 "tracker-sparql-scanner.c"
		{
			gchar* _tmp79_ = NULL;
			gchar _tmp80_ = '\0';
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp79_ = begin;
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp80_ = _tmp79_[0];
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp80_) {
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'B':
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'b':
#line 1247 "tracker-sparql-scanner.c"
				{
					gchar* _tmp81_ = NULL;
					gboolean _tmp82_ = FALSE;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp81_ = begin;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp82_ = tracker_sparql_scanner_matches (self, _tmp81_, "BOUND");
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp82_) {
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_BOUND;
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1261 "tracker-sparql-scanner.c"
					}
#line 215 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1265 "tracker-sparql-scanner.c"
				}
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 1271 "tracker-sparql-scanner.c"
				{
					gchar* _tmp83_ = NULL;
					gboolean _tmp84_ = FALSE;
#line 218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp83_ = begin;
#line 218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp84_ = tracker_sparql_scanner_matches (self, _tmp83_, "COUNT");
#line 218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp84_) {
#line 218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_COUNT;
#line 218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1285 "tracker-sparql-scanner.c"
					}
#line 219 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1289 "tracker-sparql-scanner.c"
				}
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'G':
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'g':
#line 1295 "tracker-sparql-scanner.c"
				{
					gchar* _tmp85_ = NULL;
					gchar _tmp86_ = '\0';
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp85_ = begin;
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp86_ = _tmp85_[2];
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp86_) {
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 1309 "tracker-sparql-scanner.c"
						{
							gchar* _tmp87_ = NULL;
							gboolean _tmp88_ = FALSE;
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp87_ = begin;
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp88_ = tracker_sparql_scanner_matches (self, _tmp87_, "GRAPH");
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp88_) {
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_GRAPH;
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1323 "tracker-sparql-scanner.c"
							}
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1327 "tracker-sparql-scanner.c"
						}
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'O':
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'o':
#line 1333 "tracker-sparql-scanner.c"
						{
							gchar* _tmp89_ = NULL;
							gboolean _tmp90_ = FALSE;
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp89_ = begin;
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp90_ = tracker_sparql_scanner_matches (self, _tmp89_, "GROUP");
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp90_) {
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_GROUP;
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1347 "tracker-sparql-scanner.c"
							}
#line 230 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1351 "tracker-sparql-scanner.c"
						}
						default:
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1356 "tracker-sparql-scanner.c"
					}
#line 232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1360 "tracker-sparql-scanner.c"
				}
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'H':
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'h':
#line 1366 "tracker-sparql-scanner.c"
				{
					gchar* _tmp91_ = NULL;
					gboolean _tmp92_ = FALSE;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp91_ = begin;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp92_ = tracker_sparql_scanner_matches (self, _tmp91_, "HOURS");
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp92_) {
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_HOURS;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1380 "tracker-sparql-scanner.c"
					}
#line 236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1384 "tracker-sparql-scanner.c"
				}
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'L':
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'l':
#line 1390 "tracker-sparql-scanner.c"
				{
					gchar* _tmp93_ = NULL;
					gchar _tmp94_ = '\0';
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp93_ = begin;
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp94_ = _tmp93_[1];
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp94_) {
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'C':
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'c':
#line 1404 "tracker-sparql-scanner.c"
						{
							gchar* _tmp95_ = NULL;
							gboolean _tmp96_ = FALSE;
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp95_ = begin;
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp96_ = tracker_sparql_scanner_matches (self, _tmp95_, "LCASE");
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp96_) {
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_LCASE;
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1418 "tracker-sparql-scanner.c"
							}
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1422 "tracker-sparql-scanner.c"
						}
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'I':
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'i':
#line 1428 "tracker-sparql-scanner.c"
						{
							gchar* _tmp97_ = NULL;
							gboolean _tmp98_ = FALSE;
#line 246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp97_ = begin;
#line 246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp98_ = tracker_sparql_scanner_matches (self, _tmp97_, "LIMIT");
#line 246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp98_) {
#line 246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_LIMIT;
#line 246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1442 "tracker-sparql-scanner.c"
							}
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1446 "tracker-sparql-scanner.c"
						}
						default:
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1451 "tracker-sparql-scanner.c"
					}
#line 249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1455 "tracker-sparql-scanner.c"
				}
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'M':
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'm':
#line 1461 "tracker-sparql-scanner.c"
				{
					gchar* _tmp99_ = NULL;
					gboolean _tmp100_ = FALSE;
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp99_ = begin;
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp100_ = tracker_sparql_scanner_matches (self, _tmp99_, "MONTH");
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp100_) {
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_MONTH;
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1475 "tracker-sparql-scanner.c"
					}
#line 253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1479 "tracker-sparql-scanner.c"
				}
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'N':
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'n':
#line 1485 "tracker-sparql-scanner.c"
				{
					gchar* _tmp101_ = NULL;
					gboolean _tmp102_ = FALSE;
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp101_ = begin;
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp102_ = tracker_sparql_scanner_matches (self, _tmp101_, "NAMED");
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp102_) {
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_NAMED;
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1499 "tracker-sparql-scanner.c"
					}
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1503 "tracker-sparql-scanner.c"
				}
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'O':
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'o':
#line 1509 "tracker-sparql-scanner.c"
				{
					gchar* _tmp103_ = NULL;
					gboolean _tmp104_ = FALSE;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp103_ = begin;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp104_ = tracker_sparql_scanner_matches (self, _tmp103_, "ORDER");
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp104_) {
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_ORDER;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1523 "tracker-sparql-scanner.c"
					}
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1527 "tracker-sparql-scanner.c"
				}
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'R':
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'r':
#line 1533 "tracker-sparql-scanner.c"
				{
					gchar* _tmp105_ = NULL;
					gchar _tmp106_ = '\0';
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp105_ = begin;
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp106_ = _tmp105_[1];
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp106_) {
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 1547 "tracker-sparql-scanner.c"
						{
							gchar* _tmp107_ = NULL;
							gboolean _tmp108_ = FALSE;
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp107_ = begin;
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp108_ = tracker_sparql_scanner_matches (self, _tmp107_, "REGEX");
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp108_) {
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_REGEX;
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1561 "tracker-sparql-scanner.c"
							}
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1565 "tracker-sparql-scanner.c"
						}
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'O':
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'o':
#line 1571 "tracker-sparql-scanner.c"
						{
							gchar* _tmp109_ = NULL;
							gboolean _tmp110_ = FALSE;
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp109_ = begin;
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp110_ = tracker_sparql_scanner_matches (self, _tmp109_, "ROUND");
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp110_) {
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_ROUND;
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1585 "tracker-sparql-scanner.c"
							}
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1589 "tracker-sparql-scanner.c"
						}
						default:
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1594 "tracker-sparql-scanner.c"
					}
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1598 "tracker-sparql-scanner.c"
				}
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'U':
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'u':
#line 1604 "tracker-sparql-scanner.c"
				{
					gchar* _tmp111_ = NULL;
					gchar _tmp112_ = '\0';
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp111_ = begin;
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp112_ = _tmp111_[1];
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp112_) {
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'N':
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'n':
#line 1618 "tracker-sparql-scanner.c"
						{
							gchar* _tmp113_ = NULL;
							gboolean _tmp114_ = FALSE;
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp113_ = begin;
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp114_ = tracker_sparql_scanner_matches (self, _tmp113_, "UNION");
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp114_) {
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_UNION;
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1632 "tracker-sparql-scanner.c"
							}
#line 281 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1636 "tracker-sparql-scanner.c"
						}
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'C':
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'c':
#line 1642 "tracker-sparql-scanner.c"
						{
							gchar* _tmp115_ = NULL;
							gboolean _tmp116_ = FALSE;
#line 284 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp115_ = begin;
#line 284 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp116_ = tracker_sparql_scanner_matches (self, _tmp115_, "UCASE");
#line 284 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp116_) {
#line 284 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_UCASE;
#line 284 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1656 "tracker-sparql-scanner.c"
							}
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1660 "tracker-sparql-scanner.c"
						}
						default:
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1665 "tracker-sparql-scanner.c"
					}
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1669 "tracker-sparql-scanner.c"
				}
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'W':
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'w':
#line 1675 "tracker-sparql-scanner.c"
				{
					gchar* _tmp117_ = NULL;
					gboolean _tmp118_ = FALSE;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp117_ = begin;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp118_ = tracker_sparql_scanner_matches (self, _tmp117_, "WHERE");
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp118_) {
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_WHERE;
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1689 "tracker-sparql-scanner.c"
					}
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1693 "tracker-sparql-scanner.c"
				}
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'F':
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'f':
#line 1699 "tracker-sparql-scanner.c"
				{
					gchar* _tmp119_ = NULL;
					gchar _tmp120_ = '\0';
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp119_ = begin;
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp120_ = _tmp119_[1];
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp120_) {
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 1713 "tracker-sparql-scanner.c"
						{
							gchar* _tmp121_ = NULL;
							gboolean _tmp122_ = FALSE;
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp121_ = begin;
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp122_ = tracker_sparql_scanner_matches (self, _tmp121_, "FALSE");
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp122_) {
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_FALSE;
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1727 "tracker-sparql-scanner.c"
							}
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1731 "tracker-sparql-scanner.c"
						}
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'L':
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'l':
#line 1737 "tracker-sparql-scanner.c"
						{
							gchar* _tmp123_ = NULL;
							gboolean _tmp124_ = FALSE;
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp123_ = begin;
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp124_ = tracker_sparql_scanner_matches (self, _tmp123_, "FLOOR");
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp124_) {
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_FLOOR;
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1751 "tracker-sparql-scanner.c"
							}
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1755 "tracker-sparql-scanner.c"
						}
						default:
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1760 "tracker-sparql-scanner.c"
					}
#line 304 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1764 "tracker-sparql-scanner.c"
				}
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 1770 "tracker-sparql-scanner.c"
				{
					gchar* _tmp125_ = NULL;
					gchar _tmp126_ = '\0';
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp125_ = begin;
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp126_ = _tmp125_[1];
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp126_) {
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'S':
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 's':
#line 1784 "tracker-sparql-scanner.c"
						{
							gchar* _tmp127_ = NULL;
							gchar _tmp128_ = '\0';
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp127_ = begin;
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp128_ = _tmp127_[2];
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp128_) {
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'I':
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'i':
#line 1798 "tracker-sparql-scanner.c"
								{
									gchar* _tmp129_ = NULL;
									gboolean _tmp130_ = FALSE;
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp129_ = begin;
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp130_ = tracker_sparql_scanner_matches (self, _tmp129_, "ISIRI");
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (_tmp130_) {
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ISIRI;
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 1812 "tracker-sparql-scanner.c"
									}
#line 314 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 1816 "tracker-sparql-scanner.c"
								}
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'U':
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'u':
#line 1822 "tracker-sparql-scanner.c"
								{
									gchar* _tmp131_ = NULL;
									gboolean _tmp132_ = FALSE;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp131_ = begin;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp132_ = tracker_sparql_scanner_matches (self, _tmp131_, "ISURI");
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (_tmp132_) {
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ISURI;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 1836 "tracker-sparql-scanner.c"
									}
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 1840 "tracker-sparql-scanner.c"
								}
								default:
#line 310 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 1845 "tracker-sparql-scanner.c"
							}
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1849 "tracker-sparql-scanner.c"
						}
						default:
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1854 "tracker-sparql-scanner.c"
					}
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1858 "tracker-sparql-scanner.c"
				}
				default:
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 1863 "tracker-sparql-scanner.c"
			}
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 1867 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 6:
#line 1871 "tracker-sparql-scanner.c"
		{
			gchar* _tmp133_ = NULL;
			gchar _tmp134_ = '\0';
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp133_ = begin;
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp134_ = _tmp133_[0];
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp134_) {
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 1885 "tracker-sparql-scanner.c"
				{
					gchar* _tmp135_ = NULL;
					gboolean _tmp136_ = FALSE;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp135_ = begin;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp136_ = tracker_sparql_scanner_matches (self, _tmp135_, "CONCAT");
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp136_) {
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_CONCAT;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1899 "tracker-sparql-scanner.c"
					}
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1903 "tracker-sparql-scanner.c"
				}
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'D':
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'd':
#line 1909 "tracker-sparql-scanner.c"
				{
					gchar* _tmp137_ = NULL;
					gboolean _tmp138_ = FALSE;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp137_ = begin;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp138_ = tracker_sparql_scanner_matches (self, _tmp137_, "DELETE");
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp138_) {
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_DELETE;
#line 333 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1923 "tracker-sparql-scanner.c"
					}
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1927 "tracker-sparql-scanner.c"
				}
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'E':
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'e':
#line 1933 "tracker-sparql-scanner.c"
				{
					gchar* _tmp139_ = NULL;
					gboolean _tmp140_ = FALSE;
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp139_ = begin;
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp140_ = tracker_sparql_scanner_matches (self, _tmp139_, "EXISTS");
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp140_) {
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_EXISTS;
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1947 "tracker-sparql-scanner.c"
					}
#line 338 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1951 "tracker-sparql-scanner.c"
				}
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'F':
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'f':
#line 1957 "tracker-sparql-scanner.c"
				{
					gchar* _tmp141_ = NULL;
					gboolean _tmp142_ = FALSE;
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp141_ = begin;
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp142_ = tracker_sparql_scanner_matches (self, _tmp141_, "FILTER");
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp142_) {
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_FILTER;
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1971 "tracker-sparql-scanner.c"
					}
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1975 "tracker-sparql-scanner.c"
				}
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'H':
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'h':
#line 1981 "tracker-sparql-scanner.c"
				{
					gchar* _tmp143_ = NULL;
					gboolean _tmp144_ = FALSE;
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp143_ = begin;
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp144_ = tracker_sparql_scanner_matches (self, _tmp143_, "HAVING");
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp144_) {
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_HAVING;
#line 345 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1995 "tracker-sparql-scanner.c"
					}
#line 346 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1999 "tracker-sparql-scanner.c"
				}
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 2005 "tracker-sparql-scanner.c"
				{
					gchar* _tmp145_ = NULL;
					gboolean _tmp146_ = FALSE;
#line 349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp145_ = begin;
#line 349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp146_ = tracker_sparql_scanner_matches (self, _tmp145_, "INSERT");
#line 349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp146_) {
#line 349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_INSERT;
#line 349 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2019 "tracker-sparql-scanner.c"
					}
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2023 "tracker-sparql-scanner.c"
				}
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'O':
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'o':
#line 2029 "tracker-sparql-scanner.c"
				{
					gchar* _tmp147_ = NULL;
					gboolean _tmp148_ = FALSE;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp147_ = begin;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp148_ = tracker_sparql_scanner_matches (self, _tmp147_, "OFFSET");
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp148_) {
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2043 "tracker-sparql-scanner.c"
					}
#line 354 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2047 "tracker-sparql-scanner.c"
				}
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'P':
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'p':
#line 2053 "tracker-sparql-scanner.c"
				{
					gchar* _tmp149_ = NULL;
					gboolean _tmp150_ = FALSE;
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp149_ = begin;
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp150_ = tracker_sparql_scanner_matches (self, _tmp149_, "PREFIX");
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp150_) {
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_PREFIX;
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2067 "tracker-sparql-scanner.c"
					}
#line 358 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2071 "tracker-sparql-scanner.c"
				}
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 2077 "tracker-sparql-scanner.c"
				{
					gchar* _tmp151_ = NULL;
					gchar _tmp152_ = '\0';
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp151_ = begin;
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp152_ = _tmp151_[1];
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp152_) {
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 2091 "tracker-sparql-scanner.c"
						{
							gchar* _tmp153_ = NULL;
							gboolean _tmp154_ = FALSE;
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp153_ = begin;
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp154_ = tracker_sparql_scanner_matches (self, _tmp153_, "SELECT");
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp154_) {
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SELECT;
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2105 "tracker-sparql-scanner.c"
							}
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2109 "tracker-sparql-scanner.c"
						}
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'I':
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'i':
#line 2115 "tracker-sparql-scanner.c"
						{
							gchar* _tmp155_ = NULL;
							gboolean _tmp156_ = FALSE;
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp155_ = begin;
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp156_ = tracker_sparql_scanner_matches (self, _tmp155_, "SILENT");
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp156_) {
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SILENT;
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2129 "tracker-sparql-scanner.c"
							}
#line 369 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2133 "tracker-sparql-scanner.c"
						}
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'T':
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 't':
#line 2139 "tracker-sparql-scanner.c"
						{
							gchar* _tmp157_ = NULL;
							gboolean _tmp158_ = FALSE;
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp157_ = begin;
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp158_ = tracker_sparql_scanner_matches (self, _tmp157_, "STRLEN");
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp158_) {
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRLEN;
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2153 "tracker-sparql-scanner.c"
							}
#line 373 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2157 "tracker-sparql-scanner.c"
						}
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'U':
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'u':
#line 2163 "tracker-sparql-scanner.c"
						{
							gchar* _tmp159_ = NULL;
							gboolean _tmp160_ = FALSE;
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp159_ = begin;
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp160_ = tracker_sparql_scanner_matches (self, _tmp159_, "SUBSTR");
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp160_) {
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SUBSTR;
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2177 "tracker-sparql-scanner.c"
							}
#line 377 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2181 "tracker-sparql-scanner.c"
						}
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'H':
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'h':
#line 2187 "tracker-sparql-scanner.c"
						{
							gchar* _tmp161_ = NULL;
							gchar _tmp162_ = '\0';
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp161_ = begin;
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp162_ = _tmp161_[3];
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp162_) {
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '2':
#line 2199 "tracker-sparql-scanner.c"
								{
									gchar* _tmp163_ = NULL;
									gboolean _tmp164_ = FALSE;
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp163_ = begin;
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp164_ = tracker_sparql_scanner_matches (self, _tmp163_, "SHA256");
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (_tmp164_) {
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_SHA256;
#line 382 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 2213 "tracker-sparql-scanner.c"
									}
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 2217 "tracker-sparql-scanner.c"
								}
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '5':
#line 2221 "tracker-sparql-scanner.c"
								{
									gchar* _tmp165_ = NULL;
									gboolean _tmp166_ = FALSE;
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp165_ = begin;
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp166_ = tracker_sparql_scanner_matches (self, _tmp165_, "SHA512");
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (_tmp166_) {
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_SHA512;
#line 385 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 2235 "tracker-sparql-scanner.c"
									}
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 2239 "tracker-sparql-scanner.c"
								}
								default:
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 2244 "tracker-sparql-scanner.c"
							}
#line 388 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2248 "tracker-sparql-scanner.c"
						}
						default:
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 2253 "tracker-sparql-scanner.c"
					}
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2257 "tracker-sparql-scanner.c"
				}
				default:
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2262 "tracker-sparql-scanner.c"
			}
#line 392 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2266 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 7:
#line 2270 "tracker-sparql-scanner.c"
		{
			gchar* _tmp167_ = NULL;
			gchar _tmp168_ = '\0';
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp167_ = begin;
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp168_ = _tmp167_[0];
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp168_) {
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'M':
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'm':
#line 2284 "tracker-sparql-scanner.c"
				{
					gchar* _tmp169_ = NULL;
					gboolean _tmp170_ = FALSE;
#line 397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp169_ = begin;
#line 397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp170_ = tracker_sparql_scanner_matches (self, _tmp169_, "MINUTES");
#line 397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp170_) {
#line 397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_MINUTES;
#line 397 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2298 "tracker-sparql-scanner.c"
					}
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2302 "tracker-sparql-scanner.c"
				}
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'R':
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'r':
#line 2308 "tracker-sparql-scanner.c"
				{
					gchar* _tmp171_ = NULL;
					gchar _tmp172_ = '\0';
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp171_ = begin;
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp172_ = _tmp171_[2];
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp172_) {
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'D':
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'd':
#line 2322 "tracker-sparql-scanner.c"
						{
							gchar* _tmp173_ = NULL;
							gboolean _tmp174_ = FALSE;
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp173_ = begin;
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp174_ = tracker_sparql_scanner_matches (self, _tmp173_, "REDUCED");
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp174_) {
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_REDUCED;
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2336 "tracker-sparql-scanner.c"
							}
#line 405 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2340 "tracker-sparql-scanner.c"
						}
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'P':
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'p':
#line 2346 "tracker-sparql-scanner.c"
						{
							gchar* _tmp175_ = NULL;
							gboolean _tmp176_ = FALSE;
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp175_ = begin;
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp176_ = tracker_sparql_scanner_matches (self, _tmp175_, "REPLACE");
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp176_) {
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_REPLACE;
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2360 "tracker-sparql-scanner.c"
							}
#line 409 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2364 "tracker-sparql-scanner.c"
						}
						default:
#line 401 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 2369 "tracker-sparql-scanner.c"
					}
#line 411 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2373 "tracker-sparql-scanner.c"
				}
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 2379 "tracker-sparql-scanner.c"
				{
					gchar* _tmp177_ = NULL;
					gchar _tmp178_ = '\0';
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp177_ = begin;
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp178_ = _tmp177_[1];
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp178_) {
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 2393 "tracker-sparql-scanner.c"
						{
							gchar* _tmp179_ = NULL;
							gboolean _tmp180_ = FALSE;
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp179_ = begin;
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp180_ = tracker_sparql_scanner_matches (self, _tmp179_, "SECONDS");
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp180_) {
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SECONDS;
#line 417 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2407 "tracker-sparql-scanner.c"
							}
#line 418 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2411 "tracker-sparql-scanner.c"
						}
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'T':
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 't':
#line 2417 "tracker-sparql-scanner.c"
						{
							gchar* _tmp181_ = NULL;
							gboolean _tmp182_ = FALSE;
#line 421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp181_ = begin;
#line 421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp182_ = tracker_sparql_scanner_matches (self, _tmp181_, "STRENDS");
#line 421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp182_) {
#line 421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRENDS;
#line 421 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2431 "tracker-sparql-scanner.c"
							}
#line 422 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2435 "tracker-sparql-scanner.c"
						}
						default:
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 2440 "tracker-sparql-scanner.c"
					}
#line 424 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2444 "tracker-sparql-scanner.c"
				}
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 2450 "tracker-sparql-scanner.c"
				{
					gchar* _tmp183_ = NULL;
					gboolean _tmp184_ = FALSE;
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp183_ = begin;
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp184_ = tracker_sparql_scanner_matches (self, _tmp183_, "ISBLANK");
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp184_) {
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_ISBLANK;
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2464 "tracker-sparql-scanner.c"
					}
#line 428 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2468 "tracker-sparql-scanner.c"
				}
				default:
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2473 "tracker-sparql-scanner.c"
			}
#line 430 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2477 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 8:
#line 2481 "tracker-sparql-scanner.c"
		{
			gchar* _tmp185_ = NULL;
			gchar _tmp186_ = '\0';
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp185_ = begin;
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp186_ = _tmp185_[0];
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp186_) {
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 2495 "tracker-sparql-scanner.c"
				{
					gchar* _tmp187_ = NULL;
					gchar _tmp188_ = '\0';
#line 435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp187_ = begin;
#line 435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp188_ = _tmp187_[2];
#line 435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp188_) {
#line 435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 2509 "tracker-sparql-scanner.c"
						{
							gchar* _tmp189_ = NULL;
							gboolean _tmp190_ = FALSE;
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp189_ = begin;
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp190_ = tracker_sparql_scanner_matches (self, _tmp189_, "COALESCE");
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp190_) {
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_COALESCE;
#line 438 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2523 "tracker-sparql-scanner.c"
							}
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2527 "tracker-sparql-scanner.c"
						}
#line 435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'N':
#line 435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'n':
#line 2533 "tracker-sparql-scanner.c"
						{
							gchar* _tmp191_ = NULL;
							gboolean _tmp192_ = FALSE;
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp191_ = begin;
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp192_ = tracker_sparql_scanner_matches (self, _tmp191_, "CONTAINS");
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp192_) {
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_CONTAINS;
#line 442 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2547 "tracker-sparql-scanner.c"
							}
#line 443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2551 "tracker-sparql-scanner.c"
						}
						default:
#line 435 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 2556 "tracker-sparql-scanner.c"
					}
#line 445 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2560 "tracker-sparql-scanner.c"
				}
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'D':
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'd':
#line 2566 "tracker-sparql-scanner.c"
				{
					gchar* _tmp193_ = NULL;
					gchar _tmp194_ = '\0';
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp193_ = begin;
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp194_ = _tmp193_[1];
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp194_) {
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 2580 "tracker-sparql-scanner.c"
						{
							gchar* _tmp195_ = NULL;
							gboolean _tmp196_ = FALSE;
#line 451 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp195_ = begin;
#line 451 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp196_ = tracker_sparql_scanner_matches (self, _tmp195_, "DATATYPE");
#line 451 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp196_) {
#line 451 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DATATYPE;
#line 451 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2594 "tracker-sparql-scanner.c"
							}
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2598 "tracker-sparql-scanner.c"
						}
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 2604 "tracker-sparql-scanner.c"
						{
							gchar* _tmp197_ = NULL;
							gboolean _tmp198_ = FALSE;
#line 455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp197_ = begin;
#line 455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp198_ = tracker_sparql_scanner_matches (self, _tmp197_, "DESCRIBE");
#line 455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp198_) {
#line 455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE;
#line 455 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2618 "tracker-sparql-scanner.c"
							}
#line 456 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2622 "tracker-sparql-scanner.c"
						}
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'I':
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'i':
#line 2628 "tracker-sparql-scanner.c"
						{
							gchar* _tmp199_ = NULL;
							gboolean _tmp200_ = FALSE;
#line 459 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp199_ = begin;
#line 459 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp200_ = tracker_sparql_scanner_matches (self, _tmp199_, "DISTINCT");
#line 459 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp200_) {
#line 459 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DISTINCT;
#line 459 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2642 "tracker-sparql-scanner.c"
							}
#line 460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2646 "tracker-sparql-scanner.c"
						}
						default:
#line 448 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 2651 "tracker-sparql-scanner.c"
					}
#line 462 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2655 "tracker-sparql-scanner.c"
				}
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'O':
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'o':
#line 2661 "tracker-sparql-scanner.c"
				{
					gchar* _tmp201_ = NULL;
					gboolean _tmp202_ = FALSE;
#line 465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp201_ = begin;
#line 465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp202_ = tracker_sparql_scanner_matches (self, _tmp201_, "OPTIONAL");
#line 465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp202_) {
#line 465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL;
#line 465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2675 "tracker-sparql-scanner.c"
					}
#line 466 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2679 "tracker-sparql-scanner.c"
				}
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 2685 "tracker-sparql-scanner.c"
				{
					gchar* _tmp203_ = NULL;
					gchar _tmp204_ = '\0';
#line 469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp203_ = begin;
#line 469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp204_ = _tmp203_[1];
#line 469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp204_) {
#line 469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 2699 "tracker-sparql-scanner.c"
						{
							gchar* _tmp205_ = NULL;
							gboolean _tmp206_ = FALSE;
#line 472 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp205_ = begin;
#line 472 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp206_ = tracker_sparql_scanner_matches (self, _tmp205_, "SAMETERM");
#line 472 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp206_) {
#line 472 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SAMETERM;
#line 472 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2713 "tracker-sparql-scanner.c"
							}
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2717 "tracker-sparql-scanner.c"
						}
#line 469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'T':
#line 469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 't':
#line 2723 "tracker-sparql-scanner.c"
						{
							gchar* _tmp207_ = NULL;
							gboolean _tmp208_ = FALSE;
#line 476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp207_ = begin;
#line 476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp208_ = tracker_sparql_scanner_matches (self, _tmp207_, "STRAFTER");
#line 476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp208_) {
#line 476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRAFTER;
#line 476 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2737 "tracker-sparql-scanner.c"
							}
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2741 "tracker-sparql-scanner.c"
						}
						default:
#line 469 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 2746 "tracker-sparql-scanner.c"
					}
#line 479 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2750 "tracker-sparql-scanner.c"
				}
				default:
#line 432 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2755 "tracker-sparql-scanner.c"
			}
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2759 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 9:
#line 2763 "tracker-sparql-scanner.c"
		{
			gchar* _tmp209_ = NULL;
			gchar _tmp210_ = '\0';
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp209_ = begin;
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp210_ = _tmp209_[0];
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp210_) {
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 2777 "tracker-sparql-scanner.c"
				{
					gchar* _tmp211_ = NULL;
					gboolean _tmp212_ = FALSE;
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp211_ = begin;
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp212_ = tracker_sparql_scanner_matches (self, _tmp211_, "CONSTRUCT");
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp212_) {
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT;
#line 486 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2791 "tracker-sparql-scanner.c"
					}
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2795 "tracker-sparql-scanner.c"
				}
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 2801 "tracker-sparql-scanner.c"
				{
					gchar* _tmp213_ = NULL;
					gboolean _tmp214_ = FALSE;
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp213_ = begin;
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp214_ = tracker_sparql_scanner_matches (self, _tmp213_, "ISLITERAL");
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp214_) {
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL;
#line 490 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2815 "tracker-sparql-scanner.c"
					}
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2819 "tracker-sparql-scanner.c"
				}
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 2825 "tracker-sparql-scanner.c"
				{
					gchar* _tmp215_ = NULL;
					gchar _tmp216_ = '\0';
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp215_ = begin;
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp216_ = _tmp215_[3];
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp216_) {
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'B':
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'b':
#line 2839 "tracker-sparql-scanner.c"
						{
							gchar* _tmp217_ = NULL;
							gboolean _tmp218_ = FALSE;
#line 497 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp217_ = begin;
#line 497 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp218_ = tracker_sparql_scanner_matches (self, _tmp217_, "STRBEFORE");
#line 497 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp218_) {
#line 497 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE;
#line 497 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2853 "tracker-sparql-scanner.c"
							}
#line 498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2857 "tracker-sparql-scanner.c"
						}
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'S':
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 's':
#line 2863 "tracker-sparql-scanner.c"
						{
							gchar* _tmp219_ = NULL;
							gboolean _tmp220_ = FALSE;
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp219_ = begin;
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp220_ = tracker_sparql_scanner_matches (self, _tmp219_, "STRSTARTS");
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp220_) {
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS;
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2877 "tracker-sparql-scanner.c"
							}
#line 502 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2881 "tracker-sparql-scanner.c"
						}
						default:
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 2886 "tracker-sparql-scanner.c"
					}
#line 504 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2890 "tracker-sparql-scanner.c"
				}
				default:
#line 483 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2895 "tracker-sparql-scanner.c"
			}
#line 506 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2899 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 11:
#line 2903 "tracker-sparql-scanner.c"
		{
			gchar* _tmp221_ = NULL;
			gboolean _tmp222_ = FALSE;
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp221_ = begin;
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp222_ = tracker_sparql_scanner_matches (self, _tmp221_, "LANGMATCHES");
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp222_) {
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				result = TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES;
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				return result;
#line 2917 "tracker-sparql-scanner.c"
			}
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2921 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 12:
#line 2925 "tracker-sparql-scanner.c"
		{
			gchar* _tmp223_ = NULL;
			gboolean _tmp224_ = FALSE;
#line 511 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp223_ = begin;
#line 511 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp224_ = tracker_sparql_scanner_matches (self, _tmp223_, "GROUP_CONCAT");
#line 511 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp224_) {
#line 511 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				result = TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT;
#line 511 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				return result;
#line 2939 "tracker-sparql-scanner.c"
			}
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2943 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 14:
#line 2947 "tracker-sparql-scanner.c"
		{
			gchar* _tmp225_ = NULL;
			gboolean _tmp226_ = FALSE;
#line 514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp225_ = begin;
#line 514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp226_ = tracker_sparql_scanner_matches (self, _tmp225_, "ENCODE_FOR_URI");
#line 514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp226_) {
#line 514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				result = TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI;
#line 514 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				return result;
#line 2961 "tracker-sparql-scanner.c"
			}
#line 515 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2965 "tracker-sparql-scanner.c"
		}
		default:
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		break;
#line 2970 "tracker-sparql-scanner.c"
	}
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX;
#line 517 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 2976 "tracker-sparql-scanner.c"
}


static TrackerSparqlTokenType tracker_sparql_scanner_read_number (TrackerSparqlScanner* self) {
	TrackerSparqlTokenType result = 0;
	TrackerSparqlTokenType type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gboolean _tmp44_ = FALSE;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
#line 520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 521 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	type = TRACKER_SPARQL_TOKEN_TYPE_INTEGER;
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp3_ = self->priv->current;
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp4_ = self->priv->end;
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp3_ < (_tmp4_ - 2)) {
#line 3007 "tracker-sparql-scanner.c"
		gchar* _tmp5_ = NULL;
		gchar _tmp6_ = '\0';
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp5_ = self->priv->current;
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp6_ = _tmp5_[0];
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = _tmp6_ == '0';
#line 3016 "tracker-sparql-scanner.c"
	} else {
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = FALSE;
#line 3020 "tracker-sparql-scanner.c"
	}
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp2_) {
#line 3024 "tracker-sparql-scanner.c"
		gchar* _tmp7_ = NULL;
		gchar _tmp8_ = '\0';
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp7_ = self->priv->current;
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp8_ = _tmp7_[1];
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = _tmp8_ == 'x';
#line 3033 "tracker-sparql-scanner.c"
	} else {
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = FALSE;
#line 3037 "tracker-sparql-scanner.c"
	}
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp1_) {
#line 3041 "tracker-sparql-scanner.c"
		gchar* _tmp9_ = NULL;
		gchar _tmp10_ = '\0';
		gboolean _tmp11_ = FALSE;
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp9_ = self->priv->current;
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp10_ = _tmp9_[2];
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp11_ = g_ascii_isxdigit (_tmp10_);
#line 525 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = _tmp11_;
#line 3053 "tracker-sparql-scanner.c"
	} else {
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = FALSE;
#line 3057 "tracker-sparql-scanner.c"
	}
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp0_) {
#line 3061 "tracker-sparql-scanner.c"
		gchar* _tmp12_ = NULL;
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp12_ = self->priv->current;
#line 527 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp12_ + 2;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		while (TRUE) {
#line 3069 "tracker-sparql-scanner.c"
			gboolean _tmp13_ = FALSE;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp19_ = NULL;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp14_ = self->priv->current;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp15_ = self->priv->end;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp14_ < _tmp15_) {
#line 3080 "tracker-sparql-scanner.c"
				gchar* _tmp16_ = NULL;
				gchar _tmp17_ = '\0';
				gboolean _tmp18_ = FALSE;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp16_ = self->priv->current;
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp17_ = _tmp16_[0];
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp18_ = g_ascii_isxdigit (_tmp17_);
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp13_ = _tmp18_;
#line 3092 "tracker-sparql-scanner.c"
			} else {
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp13_ = FALSE;
#line 3096 "tracker-sparql-scanner.c"
			}
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (!_tmp13_) {
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 3102 "tracker-sparql-scanner.c"
			}
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp19_ = self->priv->current;
#line 529 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp19_ + 1;
#line 3108 "tracker-sparql-scanner.c"
		}
	} else {
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		while (TRUE) {
#line 3113 "tracker-sparql-scanner.c"
			gboolean _tmp20_ = FALSE;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp26_ = NULL;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp21_ = self->priv->current;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp22_ = self->priv->end;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp21_ < _tmp22_) {
#line 3124 "tracker-sparql-scanner.c"
				gchar* _tmp23_ = NULL;
				gchar _tmp24_ = '\0';
				gboolean _tmp25_ = FALSE;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp23_ = self->priv->current;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp24_ = _tmp23_[0];
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp25_ = g_ascii_isdigit (_tmp24_);
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp20_ = _tmp25_;
#line 3136 "tracker-sparql-scanner.c"
			} else {
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp20_ = FALSE;
#line 3140 "tracker-sparql-scanner.c"
			}
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (!_tmp20_) {
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 3146 "tracker-sparql-scanner.c"
			}
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp26_ = self->priv->current;
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp26_ + 1;
#line 3152 "tracker-sparql-scanner.c"
		}
	}
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp29_ = self->priv->current;
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp30_ = self->priv->end;
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp29_ < (_tmp30_ - 1)) {
#line 3161 "tracker-sparql-scanner.c"
		gchar* _tmp31_ = NULL;
		gchar _tmp32_ = '\0';
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp31_ = self->priv->current;
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp32_ = _tmp31_[0];
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp28_ = _tmp32_ == '.';
#line 3170 "tracker-sparql-scanner.c"
	} else {
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp28_ = FALSE;
#line 3174 "tracker-sparql-scanner.c"
	}
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp28_) {
#line 3178 "tracker-sparql-scanner.c"
		gchar* _tmp33_ = NULL;
		gchar _tmp34_ = '\0';
		gboolean _tmp35_ = FALSE;
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp33_ = self->priv->current;
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp34_ = _tmp33_[1];
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp35_ = g_ascii_isdigit (_tmp34_);
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp27_ = _tmp35_;
#line 3190 "tracker-sparql-scanner.c"
	} else {
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp27_ = FALSE;
#line 3194 "tracker-sparql-scanner.c"
	}
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp27_) {
#line 3198 "tracker-sparql-scanner.c"
		gchar* _tmp36_ = NULL;
#line 540 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp36_ = self->priv->current;
#line 541 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp36_ + 1;
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		while (TRUE) {
#line 3208 "tracker-sparql-scanner.c"
			gboolean _tmp37_ = FALSE;
			gchar* _tmp38_ = NULL;
			gchar* _tmp39_ = NULL;
			gchar* _tmp43_ = NULL;
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp38_ = self->priv->current;
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp39_ = self->priv->end;
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp38_ < _tmp39_) {
#line 3219 "tracker-sparql-scanner.c"
				gchar* _tmp40_ = NULL;
				gchar _tmp41_ = '\0';
				gboolean _tmp42_ = FALSE;
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp40_ = self->priv->current;
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp41_ = _tmp40_[0];
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp42_ = g_ascii_isdigit (_tmp41_);
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp37_ = _tmp42_;
#line 3231 "tracker-sparql-scanner.c"
			} else {
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp37_ = FALSE;
#line 3235 "tracker-sparql-scanner.c"
			}
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (!_tmp37_) {
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 3241 "tracker-sparql-scanner.c"
			}
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp43_ = self->priv->current;
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp43_ + 1;
#line 3247 "tracker-sparql-scanner.c"
		}
	}
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp45_ = self->priv->current;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp46_ = self->priv->end;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp45_ < _tmp46_) {
#line 3256 "tracker-sparql-scanner.c"
		gchar* _tmp47_ = NULL;
		gchar _tmp48_ = '\0';
		gchar _tmp49_ = '\0';
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp47_ = self->priv->current;
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp48_ = _tmp47_[0];
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp49_ = g_ascii_tolower (_tmp48_);
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp44_ = _tmp49_ == 'e';
#line 3268 "tracker-sparql-scanner.c"
	} else {
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp44_ = FALSE;
#line 3272 "tracker-sparql-scanner.c"
	}
#line 548 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp44_) {
#line 3276 "tracker-sparql-scanner.c"
		gchar* _tmp50_ = NULL;
		gboolean _tmp51_ = FALSE;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp50_ = self->priv->current;
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp50_ + 1;
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp52_ = self->priv->current;
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp53_ = self->priv->end;
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp52_ < _tmp53_) {
#line 3293 "tracker-sparql-scanner.c"
			gboolean _tmp54_ = FALSE;
			gchar* _tmp55_ = NULL;
			gchar _tmp56_ = '\0';
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp55_ = self->priv->current;
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp56_ = _tmp55_[0];
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp56_ == '+') {
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp54_ = TRUE;
#line 3305 "tracker-sparql-scanner.c"
			} else {
				gchar* _tmp57_ = NULL;
				gchar _tmp58_ = '\0';
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp57_ = self->priv->current;
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp58_ = _tmp57_[0];
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp54_ = _tmp58_ == '-';
#line 3315 "tracker-sparql-scanner.c"
			}
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp51_ = _tmp54_;
#line 3319 "tracker-sparql-scanner.c"
		} else {
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp51_ = FALSE;
#line 3323 "tracker-sparql-scanner.c"
		}
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp51_) {
#line 3327 "tracker-sparql-scanner.c"
			gchar* _tmp59_ = NULL;
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp59_ = self->priv->current;
#line 552 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp59_ + 1;
#line 3333 "tracker-sparql-scanner.c"
		}
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		while (TRUE) {
#line 3337 "tracker-sparql-scanner.c"
			gboolean _tmp60_ = FALSE;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_ = NULL;
			gchar* _tmp66_ = NULL;
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp61_ = self->priv->current;
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp62_ = self->priv->end;
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp61_ < _tmp62_) {
#line 3348 "tracker-sparql-scanner.c"
				gchar* _tmp63_ = NULL;
				gchar _tmp64_ = '\0';
				gboolean _tmp65_ = FALSE;
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp63_ = self->priv->current;
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp64_ = _tmp63_[0];
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp65_ = g_ascii_isdigit (_tmp64_);
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp60_ = _tmp65_;
#line 3360 "tracker-sparql-scanner.c"
			} else {
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp60_ = FALSE;
#line 3364 "tracker-sparql-scanner.c"
			}
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (!_tmp60_) {
#line 554 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 3370 "tracker-sparql-scanner.c"
			}
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp66_ = self->priv->current;
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp66_ + 1;
#line 3376 "tracker-sparql-scanner.c"
		}
	}
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp67_ = self->priv->current;
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp68_ = self->priv->end;
#line 560 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp67_ < _tmp68_) {
#line 3385 "tracker-sparql-scanner.c"
		gchar* _tmp69_ = NULL;
		gchar _tmp70_ = '\0';
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp69_ = self->priv->current;
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp70_ = _tmp69_[0];
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		switch (_tmp70_) {
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'l':
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'L':
#line 3398 "tracker-sparql-scanner.c"
			{
				TrackerSparqlTokenType _tmp71_ = 0;
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp71_ = type;
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (_tmp71_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
#line 3405 "tracker-sparql-scanner.c"
					gchar* _tmp72_ = NULL;
					gboolean _tmp73_ = FALSE;
					gchar* _tmp74_ = NULL;
					gchar* _tmp75_ = NULL;
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp72_ = self->priv->current;
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					self->priv->current = _tmp72_ + 1;
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp74_ = self->priv->current;
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp75_ = self->priv->end;
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp74_ < _tmp75_) {
#line 3420 "tracker-sparql-scanner.c"
						gchar* _tmp76_ = NULL;
						gchar _tmp77_ = '\0';
						gchar _tmp78_ = '\0';
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp76_ = self->priv->current;
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp77_ = _tmp76_[0];
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp78_ = g_ascii_tolower (_tmp77_);
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp73_ = _tmp78_ == 'l';
#line 3432 "tracker-sparql-scanner.c"
					} else {
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp73_ = FALSE;
#line 3436 "tracker-sparql-scanner.c"
					}
#line 566 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp73_) {
#line 3440 "tracker-sparql-scanner.c"
						gchar* _tmp79_ = NULL;
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp79_ = self->priv->current;
#line 567 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp79_ + 1;
#line 3446 "tracker-sparql-scanner.c"
					}
				}
#line 570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 3451 "tracker-sparql-scanner.c"
			}
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'u':
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'U':
#line 3457 "tracker-sparql-scanner.c"
			{
				TrackerSparqlTokenType _tmp80_ = 0;
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp80_ = type;
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (_tmp80_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
#line 3464 "tracker-sparql-scanner.c"
					gchar* _tmp81_ = NULL;
					gboolean _tmp82_ = FALSE;
					gchar* _tmp83_ = NULL;
					gchar* _tmp84_ = NULL;
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp81_ = self->priv->current;
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					self->priv->current = _tmp81_ + 1;
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp83_ = self->priv->current;
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp84_ = self->priv->end;
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp83_ < _tmp84_) {
#line 3479 "tracker-sparql-scanner.c"
						gchar* _tmp85_ = NULL;
						gchar _tmp86_ = '\0';
						gchar _tmp87_ = '\0';
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp85_ = self->priv->current;
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp86_ = _tmp85_[0];
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp87_ = g_ascii_tolower (_tmp86_);
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp82_ = _tmp87_ == 'l';
#line 3491 "tracker-sparql-scanner.c"
					} else {
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp82_ = FALSE;
#line 3495 "tracker-sparql-scanner.c"
					}
#line 575 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp82_) {
#line 3499 "tracker-sparql-scanner.c"
						gchar* _tmp88_ = NULL;
						gboolean _tmp89_ = FALSE;
						gchar* _tmp90_ = NULL;
						gchar* _tmp91_ = NULL;
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp88_ = self->priv->current;
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp88_ + 1;
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp90_ = self->priv->current;
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp91_ = self->priv->end;
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp90_ < _tmp91_) {
#line 3514 "tracker-sparql-scanner.c"
							gchar* _tmp92_ = NULL;
							gchar _tmp93_ = '\0';
							gchar _tmp94_ = '\0';
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp92_ = self->priv->current;
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp93_ = _tmp92_[0];
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp94_ = g_ascii_tolower (_tmp93_);
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp89_ = _tmp94_ == 'l';
#line 3526 "tracker-sparql-scanner.c"
						} else {
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp89_ = FALSE;
#line 3530 "tracker-sparql-scanner.c"
						}
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp89_) {
#line 3534 "tracker-sparql-scanner.c"
							gchar* _tmp95_ = NULL;
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp95_ = self->priv->current;
#line 578 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp95_ + 1;
#line 3540 "tracker-sparql-scanner.c"
						}
					}
				}
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 3546 "tracker-sparql-scanner.c"
			}
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'f':
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'F':
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'd':
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'D':
#line 3556 "tracker-sparql-scanner.c"
			{
				gchar* _tmp96_ = NULL;
#line 587 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
#line 588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp96_ = self->priv->current;
#line 588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				self->priv->current = _tmp96_ + 1;
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 3567 "tracker-sparql-scanner.c"
			}
			default:
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 3572 "tracker-sparql-scanner.c"
		}
	}
#line 593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = type;
#line 593 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 3579 "tracker-sparql-scanner.c"
}


static gboolean tracker_sparql_scanner_is_pn_char (TrackerSparqlScanner* self, gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar _tmp2_ = '\0';
	gboolean _tmp3_ = FALSE;
#line 596 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = c;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp3_ = g_ascii_isalnum (_tmp2_);
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp3_) {
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = TRUE;
#line 3599 "tracker-sparql-scanner.c"
	} else {
		gchar _tmp4_ = '\0';
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp4_ = c;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = _tmp4_ == '_';
#line 3606 "tracker-sparql-scanner.c"
	}
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp1_) {
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 3612 "tracker-sparql-scanner.c"
	} else {
		gchar _tmp5_ = '\0';
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp5_ = c;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = _tmp5_ == '-';
#line 3619 "tracker-sparql-scanner.c"
	}
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = _tmp0_;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 3625 "tracker-sparql-scanner.c"
}


static gboolean tracker_sparql_scanner_is_pn_local_char (TrackerSparqlScanner* self, gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar _tmp3_ = '\0';
	gboolean _tmp4_ = FALSE;
#line 600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp3_ = c;
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp4_ = g_ascii_isalnum (_tmp3_);
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp4_) {
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = TRUE;
#line 3646 "tracker-sparql-scanner.c"
	} else {
		gchar _tmp5_ = '\0';
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp5_ = c;
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = _tmp5_ == '_';
#line 3653 "tracker-sparql-scanner.c"
	}
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp2_) {
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = TRUE;
#line 3659 "tracker-sparql-scanner.c"
	} else {
		gchar _tmp6_ = '\0';
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp6_ = c;
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = _tmp6_ == '-';
#line 3666 "tracker-sparql-scanner.c"
	}
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp1_) {
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 3672 "tracker-sparql-scanner.c"
	} else {
		gchar _tmp7_ = '\0';
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp7_ = c;
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = _tmp7_ == '.';
#line 3679 "tracker-sparql-scanner.c"
	}
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = _tmp0_;
#line 601 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 3685 "tracker-sparql-scanner.c"
}


static gboolean tracker_sparql_scanner_is_varname_char (TrackerSparqlScanner* self, gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar _tmp1_ = '\0';
	gboolean _tmp2_ = FALSE;
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = c;
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = g_ascii_isalnum (_tmp1_);
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp2_) {
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 3704 "tracker-sparql-scanner.c"
	} else {
		gchar _tmp3_ = '\0';
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp3_ = c;
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = _tmp3_ == '_';
#line 3711 "tracker-sparql-scanner.c"
	}
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = _tmp0_;
#line 605 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 3717 "tracker-sparql-scanner.c"
}


TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self, TrackerSourceLocation* token_begin, TrackerSourceLocation* token_end, GError** error) {
	TrackerSourceLocation _vala_token_begin = {0};
	TrackerSourceLocation _vala_token_end = {0};
	TrackerSparqlTokenType result = 0;
	TrackerSparqlTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint token_length_in_chars = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp299_ = 0;
	gchar* _tmp305_ = NULL;
	gint _tmp306_ = 0;
	gint _tmp307_ = 0;
	GError * _inner_error_ = NULL;
#line 608 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	tracker_sparql_scanner_space (self);
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp0_ = self->priv->current;
#line 612 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	begin = _tmp0_;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = begin;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = self->priv->line;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp3_ = self->priv->column;
#line 613 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	tracker_source_location_init (&_vala_token_begin, _tmp1_, _tmp2_, _tmp3_);
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	token_length_in_chars = -1;
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp4_ = self->priv->current;
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp5_ = self->priv->end;
#line 617 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp4_ >= _tmp5_) {
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		type = TRACKER_SPARQL_TOKEN_TYPE_EOF;
#line 3765 "tracker-sparql-scanner.c"
	} else {
		gchar* _tmp6_ = NULL;
		gchar _tmp7_ = '\0';
		gboolean _tmp8_ = FALSE;
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp6_ = self->priv->current;
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp7_ = _tmp6_[0];
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp8_ = g_ascii_isalpha (_tmp7_);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp8_) {
#line 3778 "tracker-sparql-scanner.c"
			gint len = 0;
			gchar* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			TrackerSparqlTokenType _tmp19_ = 0;
#line 621 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			len = 0;
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			while (TRUE) {
#line 3787 "tracker-sparql-scanner.c"
				gboolean _tmp9_ = FALSE;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar* _tmp15_ = NULL;
				gint _tmp16_ = 0;
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp10_ = self->priv->current;
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp11_ = self->priv->end;
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (_tmp10_ < _tmp11_) {
#line 3799 "tracker-sparql-scanner.c"
					gchar* _tmp12_ = NULL;
					gchar _tmp13_ = '\0';
					gboolean _tmp14_ = FALSE;
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp12_ = self->priv->current;
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp13_ = _tmp12_[0];
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp14_ = tracker_sparql_scanner_is_pn_char (self, _tmp13_);
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp9_ = _tmp14_;
#line 3811 "tracker-sparql-scanner.c"
				} else {
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp9_ = FALSE;
#line 3815 "tracker-sparql-scanner.c"
				}
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (!_tmp9_) {
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 3821 "tracker-sparql-scanner.c"
				}
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp15_ = self->priv->current;
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				self->priv->current = _tmp15_ + 1;
#line 624 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp16_ = len;
#line 624 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				len = _tmp16_ + 1;
#line 3831 "tracker-sparql-scanner.c"
			}
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp17_ = begin;
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp18_ = len;
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp19_ = tracker_sparql_scanner_get_identifier_or_keyword (self, _tmp17_, _tmp18_);
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			type = _tmp19_;
#line 3841 "tracker-sparql-scanner.c"
		} else {
			gchar* _tmp20_ = NULL;
			gchar _tmp21_ = '\0';
			gboolean _tmp22_ = FALSE;
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp20_ = self->priv->current;
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp21_ = _tmp20_[0];
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp22_ = g_ascii_isdigit (_tmp21_);
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp22_) {
#line 3854 "tracker-sparql-scanner.c"
				TrackerSparqlTokenType _tmp23_ = 0;
#line 628 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp23_ = tracker_sparql_scanner_read_number (self);
#line 628 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				type = _tmp23_;
#line 3860 "tracker-sparql-scanner.c"
			} else {
				gchar* _tmp24_ = NULL;
				gchar _tmp25_ = '\0';
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp24_ = self->priv->current;
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp25_ = _tmp24_[0];
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				switch (_tmp25_) {
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '{':
#line 3872 "tracker-sparql-scanner.c"
					{
						gchar* _tmp26_ = NULL;
#line 632 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE;
#line 633 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp26_ = self->priv->current;
#line 633 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp26_ + 1;
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3883 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '}':
#line 3887 "tracker-sparql-scanner.c"
					{
						gchar* _tmp27_ = NULL;
#line 636 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
#line 637 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp27_ = self->priv->current;
#line 637 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp27_ + 1;
#line 638 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3898 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '(':
#line 3902 "tracker-sparql-scanner.c"
					{
						gchar* _tmp28_ = NULL;
#line 640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS;
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp28_ = self->priv->current;
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp28_ + 1;
#line 642 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3913 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ')':
#line 3917 "tracker-sparql-scanner.c"
					{
						gchar* _tmp29_ = NULL;
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
#line 645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp29_ = self->priv->current;
#line 645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp29_ + 1;
#line 646 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3928 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '[':
#line 3932 "tracker-sparql-scanner.c"
					{
						gchar* _tmp30_ = NULL;
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET;
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp30_ = self->priv->current;
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp30_ + 1;
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3943 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ']':
#line 3947 "tracker-sparql-scanner.c"
					{
						gchar* _tmp31_ = NULL;
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET;
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp31_ = self->priv->current;
#line 653 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp31_ + 1;
#line 654 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3958 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '.':
#line 3962 "tracker-sparql-scanner.c"
					{
						gchar* _tmp32_ = NULL;
#line 656 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_DOT;
#line 657 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp32_ = self->priv->current;
#line 657 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp32_ + 1;
#line 658 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3973 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ':':
#line 3977 "tracker-sparql-scanner.c"
					{
						gchar* _tmp33_ = NULL;
						gchar* _tmp41_ = NULL;
						gchar _tmp42_ = '\0';
#line 660 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_COLON;
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp33_ = self->priv->current;
#line 661 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp33_ + 1;
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						while (TRUE) {
#line 3990 "tracker-sparql-scanner.c"
							gboolean _tmp34_ = FALSE;
							gchar* _tmp35_ = NULL;
							gchar* _tmp36_ = NULL;
							gchar* _tmp40_ = NULL;
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp35_ = self->priv->current;
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp36_ = self->priv->end;
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp35_ < _tmp36_) {
#line 4001 "tracker-sparql-scanner.c"
								gchar* _tmp37_ = NULL;
								gchar _tmp38_ = '\0';
								gboolean _tmp39_ = FALSE;
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp37_ = self->priv->current;
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp38_ = _tmp37_[0];
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp39_ = tracker_sparql_scanner_is_pn_local_char (self, _tmp38_);
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp34_ = _tmp39_;
#line 4013 "tracker-sparql-scanner.c"
							} else {
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp34_ = FALSE;
#line 4017 "tracker-sparql-scanner.c"
							}
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (!_tmp34_) {
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 4023 "tracker-sparql-scanner.c"
							}
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp40_ = self->priv->current;
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp40_ + 1;
#line 4029 "tracker-sparql-scanner.c"
						}
#line 665 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp41_ = self->priv->current;
#line 665 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp42_ = _tmp41_[-1];
#line 665 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp42_ == '.') {
#line 4037 "tracker-sparql-scanner.c"
							gchar* _tmp43_ = NULL;
#line 667 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp43_ = self->priv->current;
#line 667 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp43_ - 1;
#line 4043 "tracker-sparql-scanner.c"
						}
#line 669 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4047 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ',':
#line 4051 "tracker-sparql-scanner.c"
					{
						gchar* _tmp44_ = NULL;
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_COMMA;
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp44_ = self->priv->current;
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp44_ + 1;
#line 673 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4062 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ';':
#line 4066 "tracker-sparql-scanner.c"
					{
						gchar* _tmp45_ = NULL;
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON;
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp45_ = self->priv->current;
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp45_ + 1;
#line 677 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4077 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '?':
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '$':
#line 4083 "tracker-sparql-scanner.c"
					{
						gchar* _tmp46_ = NULL;
#line 680 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp46_ = self->priv->current;
#line 681 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp46_ + 1;
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						while (TRUE) {
#line 4094 "tracker-sparql-scanner.c"
							gboolean _tmp47_ = FALSE;
							gchar* _tmp48_ = NULL;
							gchar* _tmp49_ = NULL;
							gchar* _tmp53_ = NULL;
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp48_ = self->priv->current;
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp49_ = self->priv->end;
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp48_ < _tmp49_) {
#line 4105 "tracker-sparql-scanner.c"
								gchar* _tmp50_ = NULL;
								gchar _tmp51_ = '\0';
								gboolean _tmp52_ = FALSE;
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp50_ = self->priv->current;
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp51_ = _tmp50_[0];
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp52_ = tracker_sparql_scanner_is_varname_char (self, _tmp51_);
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp47_ = _tmp52_;
#line 4117 "tracker-sparql-scanner.c"
							} else {
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp47_ = FALSE;
#line 4121 "tracker-sparql-scanner.c"
							}
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (!_tmp47_) {
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 4127 "tracker-sparql-scanner.c"
							}
#line 683 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_VAR;
#line 684 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp53_ = self->priv->current;
#line 684 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp53_ + 1;
#line 4135 "tracker-sparql-scanner.c"
						}
#line 686 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4139 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '@':
#line 4143 "tracker-sparql-scanner.c"
					{
						gchar* _tmp54_ = NULL;
						gboolean _tmp55_ = FALSE;
						gchar* _tmp56_ = NULL;
						gchar* _tmp57_ = NULL;
						gint _tmp58_ = 0;
						gint _tmp59_ = 0;
#line 688 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 689 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp54_ = self->priv->current;
#line 689 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp54_ + 1;
#line 690 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp56_ = self->priv->current;
#line 690 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp57_ = self->priv->end;
#line 690 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp58_ = strlen ("prefix");
#line 690 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp59_ = _tmp58_;
#line 690 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp56_ < (_tmp57_ - _tmp59_)) {
#line 4167 "tracker-sparql-scanner.c"
							gchar* _tmp60_ = NULL;
							gboolean _tmp61_ = FALSE;
#line 690 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp60_ = self->priv->current;
#line 690 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp61_ = tracker_sparql_scanner_matches (self, _tmp60_, "PREFIX");
#line 690 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp55_ = _tmp61_;
#line 4176 "tracker-sparql-scanner.c"
						} else {
#line 690 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp55_ = FALSE;
#line 4180 "tracker-sparql-scanner.c"
						}
#line 690 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp55_) {
#line 4184 "tracker-sparql-scanner.c"
							gchar* _tmp62_ = NULL;
							gint _tmp63_ = 0;
							gint _tmp64_ = 0;
#line 691 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX;
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp62_ = self->priv->current;
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp63_ = strlen ("prefix");
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp64_ = _tmp63_;
#line 692 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp62_ + _tmp64_;
#line 4198 "tracker-sparql-scanner.c"
						} else {
							gboolean _tmp65_ = FALSE;
							gchar* _tmp66_ = NULL;
							gchar* _tmp67_ = NULL;
							gint _tmp68_ = 0;
							gint _tmp69_ = 0;
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp66_ = self->priv->current;
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp67_ = self->priv->end;
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp68_ = strlen ("base");
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp69_ = _tmp68_;
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp66_ < (_tmp67_ - _tmp69_)) {
#line 4215 "tracker-sparql-scanner.c"
								gchar* _tmp70_ = NULL;
								gboolean _tmp71_ = FALSE;
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp70_ = self->priv->current;
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp71_ = tracker_sparql_scanner_matches (self, _tmp70_, "BASE");
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp65_ = _tmp71_;
#line 4224 "tracker-sparql-scanner.c"
							} else {
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp65_ = FALSE;
#line 4228 "tracker-sparql-scanner.c"
							}
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp65_) {
#line 4232 "tracker-sparql-scanner.c"
								gchar* _tmp72_ = NULL;
								gint _tmp73_ = 0;
								gint _tmp74_ = 0;
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_ATBASE;
#line 695 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp72_ = self->priv->current;
#line 695 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp73_ = strlen ("base");
#line 695 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp74_ = _tmp73_;
#line 695 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp72_ + _tmp74_;
#line 4246 "tracker-sparql-scanner.c"
							}
						}
#line 697 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4251 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '|':
#line 4255 "tracker-sparql-scanner.c"
					{
						gchar* _tmp75_ = NULL;
						gchar* _tmp76_ = NULL;
						gchar* _tmp77_ = NULL;
#line 699 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 700 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp75_ = self->priv->current;
#line 700 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp75_ + 1;
#line 701 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp76_ = self->priv->current;
#line 701 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp77_ = self->priv->end;
#line 701 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp76_ < _tmp77_) {
#line 4272 "tracker-sparql-scanner.c"
							gchar* _tmp78_ = NULL;
							gchar _tmp79_ = '\0';
#line 702 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp78_ = self->priv->current;
#line 702 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp79_ = _tmp78_[0];
#line 702 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp79_) {
#line 702 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '|':
#line 4283 "tracker-sparql-scanner.c"
								{
									gchar* _tmp80_ = NULL;
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_OR;
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp80_ = self->priv->current;
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									self->priv->current = _tmp80_ + 1;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4294 "tracker-sparql-scanner.c"
								}
								default:
#line 702 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 4299 "tracker-sparql-scanner.c"
							}
						}
#line 709 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4304 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '&':
#line 4308 "tracker-sparql-scanner.c"
					{
						gchar* _tmp81_ = NULL;
						gchar* _tmp82_ = NULL;
						gchar* _tmp83_ = NULL;
#line 711 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 712 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp81_ = self->priv->current;
#line 712 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp81_ + 1;
#line 713 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp82_ = self->priv->current;
#line 713 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp83_ = self->priv->end;
#line 713 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp82_ < _tmp83_) {
#line 4325 "tracker-sparql-scanner.c"
							gchar* _tmp84_ = NULL;
							gchar _tmp85_ = '\0';
#line 714 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp84_ = self->priv->current;
#line 714 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp85_ = _tmp84_[0];
#line 714 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp85_) {
#line 714 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '&':
#line 4336 "tracker-sparql-scanner.c"
								{
									gchar* _tmp86_ = NULL;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_AND;
#line 717 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp86_ = self->priv->current;
#line 717 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									self->priv->current = _tmp86_ + 1;
#line 718 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4347 "tracker-sparql-scanner.c"
								}
								default:
#line 714 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 4352 "tracker-sparql-scanner.c"
							}
						}
#line 721 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4357 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '=':
#line 4361 "tracker-sparql-scanner.c"
					{
						gchar* _tmp87_ = NULL;
#line 723 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_EQ;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp87_ = self->priv->current;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp87_ + 1;
#line 725 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4372 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '<':
#line 4376 "tracker-sparql-scanner.c"
					{
						gchar* _tmp88_ = NULL;
						gchar* _tmp89_ = NULL;
						gchar* _tmp90_ = NULL;
#line 727 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_LT;
#line 728 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp88_ = self->priv->current;
#line 728 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp88_ + 1;
#line 729 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp89_ = self->priv->current;
#line 729 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp90_ = self->priv->end;
#line 729 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp89_ < _tmp90_) {
#line 4393 "tracker-sparql-scanner.c"
							gboolean _tmp104_ = FALSE;
							gchar* _tmp105_ = NULL;
							gchar* _tmp106_ = NULL;
							gchar* _tmp111_ = NULL;
							gchar _tmp112_ = '\0';
#line 731 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							while (TRUE) {
#line 4401 "tracker-sparql-scanner.c"
								gboolean _tmp91_ = FALSE;
								gchar* _tmp92_ = NULL;
								gchar* _tmp93_ = NULL;
								gboolean _tmp96_ = FALSE;
								gchar* _tmp97_ = NULL;
								gchar _tmp98_ = '\0';
								gchar* _tmp101_ = NULL;
								gchar _tmp102_ = '\0';
#line 731 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp92_ = self->priv->current;
#line 731 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp93_ = self->priv->end;
#line 731 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp92_ < _tmp93_) {
#line 4416 "tracker-sparql-scanner.c"
									gchar* _tmp94_ = NULL;
									gchar _tmp95_ = '\0';
#line 731 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp94_ = self->priv->current;
#line 731 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp95_ = _tmp94_[0];
#line 731 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp91_ = _tmp95_ != '>';
#line 4425 "tracker-sparql-scanner.c"
								} else {
#line 731 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp91_ = FALSE;
#line 4429 "tracker-sparql-scanner.c"
								}
#line 731 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (!_tmp91_) {
#line 731 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4435 "tracker-sparql-scanner.c"
								}
#line 732 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp97_ = self->priv->current;
#line 732 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp98_ = _tmp97_[0];
#line 732 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (((gint) _tmp98_) >= 0x00) {
#line 4443 "tracker-sparql-scanner.c"
									gchar* _tmp99_ = NULL;
									gchar _tmp100_ = '\0';
#line 732 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp99_ = self->priv->current;
#line 732 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp100_ = _tmp99_[0];
#line 732 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp96_ = ((gint) _tmp100_) < 0x20;
#line 4452 "tracker-sparql-scanner.c"
								} else {
#line 732 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp96_ = FALSE;
#line 4456 "tracker-sparql-scanner.c"
								}
#line 732 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp96_) {
#line 734 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4462 "tracker-sparql-scanner.c"
								}
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp101_ = self->priv->current;
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp102_ = _tmp101_[0];
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								switch (_tmp102_) {
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '<':
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '>':
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '"':
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case ' ':
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '{':
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '}':
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '|':
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '^':
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '`':
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '\\':
#line 4490 "tracker-sparql-scanner.c"
									{
#line 748 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										break;
#line 4494 "tracker-sparql-scanner.c"
									}
									default:
									{
										gchar* _tmp103_ = NULL;
#line 750 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp103_ = self->priv->current;
#line 750 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp103_ + 1;
#line 751 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										continue;
#line 4505 "tracker-sparql-scanner.c"
									}
								}
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 4510 "tracker-sparql-scanner.c"
							}
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp105_ = self->priv->current;
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp106_ = self->priv->end;
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp105_ < _tmp106_) {
#line 4518 "tracker-sparql-scanner.c"
								gchar* _tmp107_ = NULL;
								gchar _tmp108_ = '\0';
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp107_ = self->priv->current;
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp108_ = _tmp107_[0];
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp104_ = _tmp108_ == '>';
#line 4527 "tracker-sparql-scanner.c"
							} else {
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp104_ = FALSE;
#line 4531 "tracker-sparql-scanner.c"
							}
#line 755 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp104_) {
#line 4535 "tracker-sparql-scanner.c"
								gchar* _tmp109_ = NULL;
#line 756 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_IRI_REF;
#line 757 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp109_ = self->priv->current;
#line 757 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp109_ + 1;
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 4545 "tracker-sparql-scanner.c"
							} else {
								gchar* _tmp110_ = NULL;
#line 760 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp110_ = begin;
#line 760 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp110_ + 1;
#line 4552 "tracker-sparql-scanner.c"
							}
#line 762 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp111_ = self->priv->current;
#line 762 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp112_ = _tmp111_[0];
#line 762 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp112_) {
#line 762 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '=':
#line 4562 "tracker-sparql-scanner.c"
								{
									gchar* _tmp113_ = NULL;
#line 764 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_LE;
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp113_ = self->priv->current;
#line 765 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									self->priv->current = _tmp113_ + 1;
#line 766 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4573 "tracker-sparql-scanner.c"
								}
								default:
#line 762 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 4578 "tracker-sparql-scanner.c"
							}
						}
#line 769 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4583 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '>':
#line 4587 "tracker-sparql-scanner.c"
					{
						gchar* _tmp114_ = NULL;
						gboolean _tmp115_ = FALSE;
						gchar* _tmp116_ = NULL;
						gchar* _tmp117_ = NULL;
#line 771 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_GT;
#line 772 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp114_ = self->priv->current;
#line 772 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp114_ + 1;
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp116_ = self->priv->current;
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp117_ = self->priv->end;
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp116_ < _tmp117_) {
#line 4605 "tracker-sparql-scanner.c"
							gchar* _tmp118_ = NULL;
							gchar _tmp119_ = '\0';
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp118_ = self->priv->current;
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp119_ = _tmp118_[0];
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp115_ = _tmp119_ == '=';
#line 4614 "tracker-sparql-scanner.c"
						} else {
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp115_ = FALSE;
#line 4618 "tracker-sparql-scanner.c"
						}
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp115_) {
#line 4622 "tracker-sparql-scanner.c"
							gchar* _tmp120_ = NULL;
#line 774 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_OP_GE;
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp120_ = self->priv->current;
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp120_ + 1;
#line 4630 "tracker-sparql-scanner.c"
						}
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4634 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '!':
#line 4638 "tracker-sparql-scanner.c"
					{
						gchar* _tmp121_ = NULL;
						gboolean _tmp122_ = FALSE;
						gchar* _tmp123_ = NULL;
						gchar* _tmp124_ = NULL;
#line 779 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_NEG;
#line 780 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp121_ = self->priv->current;
#line 780 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp121_ + 1;
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp123_ = self->priv->current;
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp124_ = self->priv->end;
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp123_ < _tmp124_) {
#line 4656 "tracker-sparql-scanner.c"
							gchar* _tmp125_ = NULL;
							gchar _tmp126_ = '\0';
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp125_ = self->priv->current;
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp126_ = _tmp125_[0];
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp122_ = _tmp126_ == '=';
#line 4665 "tracker-sparql-scanner.c"
						} else {
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp122_ = FALSE;
#line 4669 "tracker-sparql-scanner.c"
						}
#line 781 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp122_) {
#line 4673 "tracker-sparql-scanner.c"
							gchar* _tmp127_ = NULL;
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_OP_NE;
#line 783 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp127_ = self->priv->current;
#line 783 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp127_ + 1;
#line 4681 "tracker-sparql-scanner.c"
						}
#line 785 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4685 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '+':
#line 4689 "tracker-sparql-scanner.c"
					{
						gchar* _tmp128_ = NULL;
#line 787 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_PLUS;
#line 788 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp128_ = self->priv->current;
#line 788 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp128_ + 1;
#line 789 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4700 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '-':
#line 4704 "tracker-sparql-scanner.c"
					{
						gchar* _tmp129_ = NULL;
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_MINUS;
#line 792 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp129_ = self->priv->current;
#line 792 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp129_ + 1;
#line 793 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4715 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '*':
#line 4719 "tracker-sparql-scanner.c"
					{
						gchar* _tmp130_ = NULL;
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_STAR;
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp130_ = self->priv->current;
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp130_ + 1;
#line 797 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4730 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '/':
#line 4734 "tracker-sparql-scanner.c"
					{
						gchar* _tmp131_ = NULL;
#line 799 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_DIV;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp131_ = self->priv->current;
#line 800 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp131_ + 1;
#line 801 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4745 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '\'':
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '"':
#line 4751 "tracker-sparql-scanner.c"
					{
						gboolean _tmp132_ = FALSE;
						gboolean _tmp133_ = FALSE;
						gchar* _tmp134_ = NULL;
						gchar* _tmp135_ = NULL;
						gchar* _tmp203_ = NULL;
						gchar _tmp204_ = '\0';
						gchar* _tmp205_ = NULL;
						gboolean _tmp264_ = FALSE;
						gchar* _tmp265_ = NULL;
						gchar* _tmp266_ = NULL;
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp134_ = self->priv->current;
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp135_ = self->priv->end;
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp134_ < (_tmp135_ - 6)) {
#line 4769 "tracker-sparql-scanner.c"
							gchar* _tmp136_ = NULL;
							gchar _tmp137_ = '\0';
							gchar* _tmp138_ = NULL;
							gchar _tmp139_ = '\0';
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp136_ = begin;
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp137_ = _tmp136_[1];
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp138_ = begin;
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp139_ = _tmp138_[0];
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp133_ = _tmp137_ == _tmp139_;
#line 4784 "tracker-sparql-scanner.c"
						} else {
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp133_ = FALSE;
#line 4788 "tracker-sparql-scanner.c"
						}
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp133_) {
#line 4792 "tracker-sparql-scanner.c"
							gchar* _tmp140_ = NULL;
							gchar _tmp141_ = '\0';
							gchar* _tmp142_ = NULL;
							gchar _tmp143_ = '\0';
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp140_ = begin;
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp141_ = _tmp140_[2];
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp142_ = begin;
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp143_ = _tmp142_[0];
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp132_ = _tmp141_ == _tmp143_;
#line 4807 "tracker-sparql-scanner.c"
						} else {
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp132_ = FALSE;
#line 4811 "tracker-sparql-scanner.c"
						}
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp132_) {
#line 4815 "tracker-sparql-scanner.c"
							gchar* _tmp144_ = NULL;
							gchar _tmp145_ = '\0';
							gchar* _tmp146_ = NULL;
							gboolean _tmp184_ = FALSE;
							gboolean _tmp185_ = FALSE;
							gchar* _tmp186_ = NULL;
							gchar _tmp187_ = '\0';
							gchar* _tmp188_ = NULL;
							gchar _tmp189_ = '\0';
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp144_ = begin;
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp145_ = _tmp144_[0];
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp145_ == '\'') {
#line 806 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1;
#line 4833 "tracker-sparql-scanner.c"
							} else {
#line 808 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2;
#line 4837 "tracker-sparql-scanner.c"
							}
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							token_length_in_chars = 6;
#line 812 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp146_ = self->priv->current;
#line 812 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp146_ + 3;
#line 813 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							while (TRUE) {
#line 4847 "tracker-sparql-scanner.c"
								gchar* _tmp147_ = NULL;
								gchar* _tmp148_ = NULL;
								gboolean _tmp149_ = FALSE;
								gboolean _tmp150_ = FALSE;
								gchar* _tmp151_ = NULL;
								gchar _tmp152_ = '\0';
								gchar* _tmp153_ = NULL;
								gchar _tmp154_ = '\0';
#line 813 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp147_ = self->priv->current;
#line 813 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp148_ = self->priv->end;
#line 813 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (!(_tmp147_ < (_tmp148_ - 4))) {
#line 813 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4864 "tracker-sparql-scanner.c"
								}
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp151_ = self->priv->current;
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp152_ = _tmp151_[0];
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp153_ = begin;
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp154_ = _tmp153_[0];
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp152_ == _tmp154_) {
#line 4876 "tracker-sparql-scanner.c"
									gchar* _tmp155_ = NULL;
									gchar _tmp156_ = '\0';
									gchar* _tmp157_ = NULL;
									gchar _tmp158_ = '\0';
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp155_ = self->priv->current;
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp156_ = _tmp155_[1];
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp157_ = begin;
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp158_ = _tmp157_[0];
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp150_ = _tmp156_ == _tmp158_;
#line 4891 "tracker-sparql-scanner.c"
								} else {
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp150_ = FALSE;
#line 4895 "tracker-sparql-scanner.c"
								}
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp150_) {
#line 4899 "tracker-sparql-scanner.c"
									gchar* _tmp159_ = NULL;
									gchar _tmp160_ = '\0';
									gchar* _tmp161_ = NULL;
									gchar _tmp162_ = '\0';
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp159_ = self->priv->current;
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp160_ = _tmp159_[2];
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp161_ = begin;
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp162_ = _tmp161_[0];
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp149_ = _tmp160_ == _tmp162_;
#line 4914 "tracker-sparql-scanner.c"
								} else {
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp149_ = FALSE;
#line 4918 "tracker-sparql-scanner.c"
								}
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp149_) {
#line 815 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4924 "tracker-sparql-scanner.c"
								} else {
									gchar* _tmp163_ = NULL;
									gchar _tmp164_ = '\0';
#line 816 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp163_ = self->priv->current;
#line 816 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp164_ = _tmp163_[0];
#line 816 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (_tmp164_ == '\n') {
#line 4934 "tracker-sparql-scanner.c"
										gchar* _tmp165_ = NULL;
										gint _tmp166_ = 0;
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp165_ = self->priv->current;
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp165_ + 1;
#line 818 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp166_ = self->priv->line;
#line 818 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->line = _tmp166_ + 1;
#line 819 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->column = 1;
#line 820 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										token_length_in_chars = 3;
#line 4949 "tracker-sparql-scanner.c"
									} else {
										gchar* _tmp167_ = NULL;
										gchar _tmp168_ = '\0';
#line 821 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp167_ = self->priv->current;
#line 821 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp168_ = _tmp167_[0];
#line 821 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										if (((gint) ((guchar) _tmp168_)) <= 0x7f) {
#line 4959 "tracker-sparql-scanner.c"
											gchar* _tmp169_ = NULL;
											gint _tmp170_ = 0;
#line 823 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp169_ = self->priv->current;
#line 823 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											self->priv->current = _tmp169_ + 1;
#line 824 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp170_ = token_length_in_chars;
#line 824 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											token_length_in_chars = _tmp170_ + 1;
#line 4970 "tracker-sparql-scanner.c"
										} else {
											gunichar u = 0U;
											gchar* _tmp171_ = NULL;
											gchar* _tmp172_ = NULL;
											gchar* _tmp173_ = NULL;
											gunichar _tmp174_ = 0U;
											gunichar _tmp175_ = 0U;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp171_ = self->priv->current;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp172_ = self->priv->end;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp173_ = self->priv->current;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp174_ = g_utf8_get_char_validated ((const gchar*) _tmp171_, (gssize) ((glong) (_tmp172_ - _tmp173_)));
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											u = _tmp174_;
#line 827 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp175_ = u;
#line 827 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											if (_tmp175_ != ((gunichar) -1)) {
#line 4992 "tracker-sparql-scanner.c"
												gchar* _tmp176_ = NULL;
												gunichar _tmp177_ = 0U;
												gint _tmp178_ = 0;
												gint _tmp179_ = 0;
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp176_ = self->priv->current;
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp177_ = u;
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp178_ = g_unichar_to_utf8 (_tmp177_, NULL);
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												self->priv->current = _tmp176_ + _tmp178_;
#line 829 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp179_ = token_length_in_chars;
#line 829 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												token_length_in_chars = _tmp179_ + 1;
#line 5009 "tracker-sparql-scanner.c"
											} else {
												gint _tmp180_ = 0;
												gint _tmp181_ = 0;
												gint _tmp182_ = 0;
												GError* _tmp183_ = NULL;
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp180_ = self->priv->line;
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp181_ = self->priv->column;
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp182_ = token_length_in_chars;
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp183_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", _tmp180_, _tmp181_ + _tmp182_);
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_inner_error_ = _tmp183_;
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													g_propagate_error (error, _inner_error_);
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													return 0;
#line 5031 "tracker-sparql-scanner.c"
												} else {
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													g_clear_error (&_inner_error_);
#line 831 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													return 0;
#line 5039 "tracker-sparql-scanner.c"
												}
											}
										}
									}
								}
							}
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp186_ = self->priv->current;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp187_ = _tmp186_[0];
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp188_ = begin;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp189_ = _tmp188_[0];
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp187_ == _tmp189_) {
#line 5056 "tracker-sparql-scanner.c"
								gchar* _tmp190_ = NULL;
								gchar _tmp191_ = '\0';
								gchar* _tmp192_ = NULL;
								gchar _tmp193_ = '\0';
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp190_ = self->priv->current;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp191_ = _tmp190_[1];
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp192_ = begin;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp193_ = _tmp192_[0];
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp185_ = _tmp191_ == _tmp193_;
#line 5071 "tracker-sparql-scanner.c"
							} else {
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp185_ = FALSE;
#line 5075 "tracker-sparql-scanner.c"
							}
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp185_) {
#line 5079 "tracker-sparql-scanner.c"
								gchar* _tmp194_ = NULL;
								gchar _tmp195_ = '\0';
								gchar* _tmp196_ = NULL;
								gchar _tmp197_ = '\0';
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp194_ = self->priv->current;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp195_ = _tmp194_[2];
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp196_ = begin;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp197_ = _tmp196_[0];
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp184_ = _tmp195_ == _tmp197_;
#line 5094 "tracker-sparql-scanner.c"
							} else {
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp184_ = FALSE;
#line 5098 "tracker-sparql-scanner.c"
							}
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp184_) {
#line 5102 "tracker-sparql-scanner.c"
								gchar* _tmp198_ = NULL;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp198_ = self->priv->current;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp198_ + 3;
#line 5108 "tracker-sparql-scanner.c"
							} else {
								gint _tmp199_ = 0;
								gint _tmp200_ = 0;
								gint _tmp201_ = 0;
								GError* _tmp202_ = NULL;
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp199_ = self->priv->line;
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp200_ = self->priv->column;
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp201_ = token_length_in_chars;
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp202_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, expected \"\"\"", _tmp199_, _tmp200_ + _tmp201_);
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_inner_error_ = _tmp202_;
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									g_propagate_error (error, _inner_error_);
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									return 0;
#line 5130 "tracker-sparql-scanner.c"
								} else {
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									g_clear_error (&_inner_error_);
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									return 0;
#line 5138 "tracker-sparql-scanner.c"
								}
							}
#line 840 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 5143 "tracker-sparql-scanner.c"
						}
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp203_ = begin;
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp204_ = _tmp203_[0];
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp204_ == '\'') {
#line 844 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1;
#line 5153 "tracker-sparql-scanner.c"
						} else {
#line 846 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2;
#line 5157 "tracker-sparql-scanner.c"
						}
#line 849 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						token_length_in_chars = 2;
#line 850 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp205_ = self->priv->current;
#line 850 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp205_ + 1;
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						while (TRUE) {
#line 5167 "tracker-sparql-scanner.c"
							gboolean _tmp206_ = FALSE;
							gchar* _tmp207_ = NULL;
							gchar* _tmp208_ = NULL;
							gchar* _tmp213_ = NULL;
							gchar _tmp214_ = '\0';
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp207_ = self->priv->current;
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp208_ = self->priv->end;
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp207_ < _tmp208_) {
#line 5179 "tracker-sparql-scanner.c"
								gchar* _tmp209_ = NULL;
								gchar _tmp210_ = '\0';
								gchar* _tmp211_ = NULL;
								gchar _tmp212_ = '\0';
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp209_ = self->priv->current;
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp210_ = _tmp209_[0];
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp211_ = begin;
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp212_ = _tmp211_[0];
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp206_ = _tmp210_ != _tmp212_;
#line 5194 "tracker-sparql-scanner.c"
							} else {
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp206_ = FALSE;
#line 5198 "tracker-sparql-scanner.c"
							}
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (!_tmp206_) {
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 5204 "tracker-sparql-scanner.c"
							}
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp213_ = self->priv->current;
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp214_ = _tmp213_[0];
#line 852 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp214_ == '\\') {
#line 5212 "tracker-sparql-scanner.c"
								gchar* _tmp215_ = NULL;
								gint _tmp216_ = 0;
								gchar* _tmp217_ = NULL;
								gchar* _tmp218_ = NULL;
								gchar* _tmp219_ = NULL;
								gchar _tmp220_ = '\0';
#line 853 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp215_ = self->priv->current;
#line 853 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp215_ + 1;
#line 854 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp216_ = token_length_in_chars;
#line 854 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								token_length_in_chars = _tmp216_ + 1;
#line 855 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp217_ = self->priv->current;
#line 855 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp218_ = self->priv->end;
#line 855 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp217_ >= _tmp218_) {
#line 856 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 5235 "tracker-sparql-scanner.c"
								}
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp219_ = self->priv->current;
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp220_ = _tmp219_[0];
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								switch (_tmp220_) {
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '\'':
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '"':
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '\\':
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'b':
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'f':
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'n':
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'r':
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 't':
#line 5259 "tracker-sparql-scanner.c"
									{
										gchar* _tmp221_ = NULL;
										gint _tmp222_ = 0;
#line 868 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp221_ = self->priv->current;
#line 868 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp221_ + 1;
#line 869 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp222_ = token_length_in_chars;
#line 869 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										token_length_in_chars = _tmp222_ + 1;
#line 870 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										break;
#line 5273 "tracker-sparql-scanner.c"
									}
#line 859 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'u':
#line 5277 "tracker-sparql-scanner.c"
									{
										gchar* _tmp238_ = NULL;
										gint _tmp239_ = 0;
										{
											gint i = 0;
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											i = 0;
#line 5285 "tracker-sparql-scanner.c"
											{
												gboolean _tmp223_ = FALSE;
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp223_ = TRUE;
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												while (TRUE) {
#line 5292 "tracker-sparql-scanner.c"
													gint _tmp225_ = 0;
													gboolean _tmp226_ = FALSE;
													gchar* _tmp227_ = NULL;
													gint _tmp228_ = 0;
													gchar* _tmp229_ = NULL;
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													if (!_tmp223_) {
#line 5300 "tracker-sparql-scanner.c"
														gint _tmp224_ = 0;
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp224_ = i;
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														i = _tmp224_ + 1;
#line 5306 "tracker-sparql-scanner.c"
													}
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp223_ = FALSE;
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp225_ = i;
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													if (!(_tmp225_ < 4)) {
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														break;
#line 5316 "tracker-sparql-scanner.c"
													}
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp227_ = self->priv->current;
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp228_ = i;
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp229_ = self->priv->end;
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													if (((_tmp227_ + _tmp228_) + 1) >= _tmp229_) {
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp226_ = TRUE;
#line 5328 "tracker-sparql-scanner.c"
													} else {
														gchar* _tmp230_ = NULL;
														gint _tmp231_ = 0;
														gchar _tmp232_ = '\0';
														gboolean _tmp233_ = FALSE;
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp230_ = self->priv->current;
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp231_ = i;
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp232_ = _tmp230_[_tmp231_ + 1];
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp233_ = g_ascii_isxdigit (_tmp232_);
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp226_ = !_tmp233_;
#line 5344 "tracker-sparql-scanner.c"
													}
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													if (_tmp226_) {
#line 5348 "tracker-sparql-scanner.c"
														gint _tmp234_ = 0;
														gint _tmp235_ = 0;
														gint _tmp236_ = 0;
														GError* _tmp237_ = NULL;
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp234_ = self->priv->line;
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp235_ = self->priv->column;
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp236_ = token_length_in_chars;
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp237_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid escape sequence", _tmp234_, _tmp235_ + _tmp236_);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_inner_error_ = _tmp237_;
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															g_propagate_error (error, _inner_error_);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															return 0;
#line 5369 "tracker-sparql-scanner.c"
														} else {
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															g_clear_error (&_inner_error_);
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															return 0;
#line 5377 "tracker-sparql-scanner.c"
														}
													}
												}
											}
										}
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp238_ = self->priv->current;
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp238_ + 5;
#line 878 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp239_ = token_length_in_chars;
#line 878 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										token_length_in_chars = _tmp239_ + 5;
#line 879 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										break;
#line 5393 "tracker-sparql-scanner.c"
									}
									default:
									{
										gint _tmp240_ = 0;
										gint _tmp241_ = 0;
										gint _tmp242_ = 0;
										GError* _tmp243_ = NULL;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp240_ = self->priv->line;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp241_ = self->priv->column;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp242_ = token_length_in_chars;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp243_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid escape sequence", _tmp240_, _tmp241_ + _tmp242_);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_inner_error_ = _tmp243_;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											g_propagate_error (error, _inner_error_);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											return 0;
#line 5417 "tracker-sparql-scanner.c"
										} else {
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											g_clear_error (&_inner_error_);
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											return 0;
#line 5425 "tracker-sparql-scanner.c"
										}
									}
								}
							} else {
								gchar* _tmp244_ = NULL;
								gchar _tmp245_ = '\0';
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp244_ = self->priv->current;
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp245_ = _tmp244_[0];
#line 883 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp245_ == '\n') {
#line 884 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 5440 "tracker-sparql-scanner.c"
								} else {
									gchar* _tmp246_ = NULL;
									gchar _tmp247_ = '\0';
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp246_ = self->priv->current;
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp247_ = _tmp246_[0];
#line 885 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (((gint) ((guchar) _tmp247_)) <= 0x7f) {
#line 5450 "tracker-sparql-scanner.c"
										gchar* _tmp248_ = NULL;
										gint _tmp249_ = 0;
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp248_ = self->priv->current;
#line 887 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp248_ + 1;
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp249_ = token_length_in_chars;
#line 888 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										token_length_in_chars = _tmp249_ + 1;
#line 5461 "tracker-sparql-scanner.c"
									} else {
										gunichar u = 0U;
										gchar* _tmp250_ = NULL;
										gchar* _tmp251_ = NULL;
										gchar* _tmp252_ = NULL;
										gunichar _tmp253_ = 0U;
										gunichar _tmp254_ = 0U;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp250_ = self->priv->current;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp251_ = self->priv->end;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp252_ = self->priv->current;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp253_ = g_utf8_get_char_validated ((const gchar*) _tmp250_, (gssize) ((glong) (_tmp251_ - _tmp252_)));
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										u = _tmp253_;
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp254_ = u;
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										if (_tmp254_ != ((gunichar) -1)) {
#line 5483 "tracker-sparql-scanner.c"
											gchar* _tmp255_ = NULL;
											gunichar _tmp256_ = 0U;
											gint _tmp257_ = 0;
											gint _tmp258_ = 0;
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp255_ = self->priv->current;
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp256_ = u;
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp257_ = g_unichar_to_utf8 (_tmp256_, NULL);
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											self->priv->current = _tmp255_ + _tmp257_;
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp258_ = token_length_in_chars;
#line 893 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											token_length_in_chars = _tmp258_ + 1;
#line 5500 "tracker-sparql-scanner.c"
										} else {
											gchar* _tmp259_ = NULL;
											gint _tmp260_ = 0;
											gint _tmp261_ = 0;
											gint _tmp262_ = 0;
											GError* _tmp263_ = NULL;
#line 895 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp259_ = self->priv->current;
#line 895 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											self->priv->current = _tmp259_ + 1;
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp260_ = self->priv->line;
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp261_ = self->priv->column;
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp262_ = token_length_in_chars;
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp263_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", _tmp260_, _tmp261_ + _tmp262_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_inner_error_ = _tmp263_;
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												g_propagate_error (error, _inner_error_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												return 0;
#line 5527 "tracker-sparql-scanner.c"
											} else {
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												g_clear_error (&_inner_error_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												return 0;
#line 5535 "tracker-sparql-scanner.c"
											}
										}
									}
								}
							}
						}
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp265_ = self->priv->current;
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp266_ = self->priv->end;
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp265_ < _tmp266_) {
#line 5548 "tracker-sparql-scanner.c"
							gchar* _tmp267_ = NULL;
							gchar _tmp268_ = '\0';
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp267_ = self->priv->current;
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp268_ = _tmp267_[0];
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp264_ = _tmp268_ != '\n';
#line 5557 "tracker-sparql-scanner.c"
						} else {
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp264_ = FALSE;
#line 5561 "tracker-sparql-scanner.c"
						}
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp264_) {
#line 5565 "tracker-sparql-scanner.c"
							gchar* _tmp269_ = NULL;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp269_ = self->priv->current;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp269_ + 1;
#line 5571 "tracker-sparql-scanner.c"
						} else {
							gint _tmp270_ = 0;
							gint _tmp271_ = 0;
							gint _tmp272_ = 0;
							gchar* _tmp273_ = NULL;
							gchar _tmp274_ = '\0';
							GError* _tmp275_ = NULL;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp270_ = self->priv->line;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp271_ = self->priv->column;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp272_ = token_length_in_chars;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp273_ = begin;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp274_ = _tmp273_[0];
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp275_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, expected %c", _tmp270_, _tmp271_ + _tmp272_, (gint) _tmp274_);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_inner_error_ = _tmp275_;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error_);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5599 "tracker-sparql-scanner.c"
							} else {
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error_);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5607 "tracker-sparql-scanner.c"
							}
						}
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 5612 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '^':
#line 5616 "tracker-sparql-scanner.c"
					{
						gboolean _tmp276_ = FALSE;
						gchar* _tmp277_ = NULL;
						gchar* _tmp278_ = NULL;
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp277_ = self->priv->current;
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp278_ = self->priv->end;
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp277_ < (_tmp278_ - 2)) {
#line 5629 "tracker-sparql-scanner.c"
							gchar* _tmp279_ = NULL;
							gchar _tmp280_ = '\0';
							gchar* _tmp281_ = NULL;
							gchar _tmp282_ = '\0';
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp279_ = self->priv->current;
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp280_ = _tmp279_[0];
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp281_ = self->priv->current;
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp282_ = _tmp281_[1];
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp276_ = _tmp280_ == _tmp282_;
#line 5644 "tracker-sparql-scanner.c"
						} else {
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp276_ = FALSE;
#line 5648 "tracker-sparql-scanner.c"
						}
#line 908 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp276_) {
#line 5652 "tracker-sparql-scanner.c"
							gchar* _tmp283_ = NULL;
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX;
#line 910 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp283_ = self->priv->current;
#line 910 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp283_ + 2;
#line 5660 "tracker-sparql-scanner.c"
						} else {
							gint _tmp284_ = 0;
							gint _tmp285_ = 0;
							GError* _tmp286_ = NULL;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp284_ = self->priv->line;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp285_ = self->priv->column;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp286_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, unexpected character", _tmp284_, _tmp285_);
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_inner_error_ = _tmp286_;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error_);
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5679 "tracker-sparql-scanner.c"
							} else {
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error_);
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5687 "tracker-sparql-scanner.c"
							}
						}
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 5692 "tracker-sparql-scanner.c"
					}
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '_':
#line 5696 "tracker-sparql-scanner.c"
					{
						gchar* _tmp287_ = NULL;
#line 916 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE;
#line 917 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp287_ = self->priv->current;
#line 917 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp287_ + 1;
#line 918 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 5707 "tracker-sparql-scanner.c"
					}
					default:
					{
						gunichar u = 0U;
						gchar* _tmp288_ = NULL;
						gchar* _tmp289_ = NULL;
						gchar* _tmp290_ = NULL;
						gunichar _tmp291_ = 0U;
						gunichar _tmp292_ = 0U;
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp288_ = self->priv->current;
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp289_ = self->priv->end;
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp290_ = self->priv->current;
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp291_ = g_utf8_get_char_validated ((const gchar*) _tmp288_, (gssize) ((glong) (_tmp289_ - _tmp290_)));
#line 920 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						u = _tmp291_;
#line 921 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp292_ = u;
#line 921 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp292_ != ((gunichar) -1)) {
#line 5731 "tracker-sparql-scanner.c"
							gint _tmp293_ = 0;
							gint _tmp294_ = 0;
							GError* _tmp295_ = NULL;
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp293_ = self->priv->line;
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp294_ = self->priv->column;
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp295_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, unexpected character", _tmp293_, _tmp294_);
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_inner_error_ = _tmp295_;
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error_);
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5749 "tracker-sparql-scanner.c"
							} else {
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error_);
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5757 "tracker-sparql-scanner.c"
							}
						} else {
							gint _tmp296_ = 0;
							gint _tmp297_ = 0;
							GError* _tmp298_ = NULL;
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp296_ = self->priv->line;
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp297_ = self->priv->column;
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp298_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", _tmp296_, _tmp297_);
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_inner_error_ = _tmp298_;
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error_);
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5777 "tracker-sparql-scanner.c"
							} else {
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error_);
#line 924 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5785 "tracker-sparql-scanner.c"
							}
						}
					}
				}
			}
		}
	}
#line 929 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp299_ = token_length_in_chars;
#line 929 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp299_ < 0) {
#line 5797 "tracker-sparql-scanner.c"
		gint _tmp300_ = 0;
		gchar* _tmp301_ = NULL;
		gchar* _tmp302_ = NULL;
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp300_ = self->priv->column;
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp301_ = self->priv->current;
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp302_ = begin;
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->column = _tmp300_ + ((gint) (_tmp301_ - _tmp302_));
#line 5809 "tracker-sparql-scanner.c"
	} else {
		gint _tmp303_ = 0;
		gint _tmp304_ = 0;
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp303_ = self->priv->column;
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp304_ = token_length_in_chars;
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->column = _tmp303_ + _tmp304_;
#line 5819 "tracker-sparql-scanner.c"
	}
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp305_ = self->priv->current;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp306_ = self->priv->line;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp307_ = self->priv->column;
#line 935 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	tracker_source_location_init (&_vala_token_end, _tmp305_, _tmp306_, _tmp307_ - 1);
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = type;
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (token_begin) {
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		*token_begin = _vala_token_begin;
#line 5835 "tracker-sparql-scanner.c"
	}
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (token_end) {
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		*token_end = _vala_token_end;
#line 5841 "tracker-sparql-scanner.c"
	}
#line 937 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 5845 "tracker-sparql-scanner.c"
}


static gboolean tracker_sparql_scanner_matches (TrackerSparqlScanner* self, gchar* begin, const gchar* keyword) {
	gboolean result = FALSE;
	gchar* keyword_array = NULL;
	const gchar* _tmp0_ = NULL;
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (keyword != NULL, FALSE);
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp0_ = keyword;
#line 941 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	keyword_array = _tmp0_;
#line 5861 "tracker-sparql-scanner.c"
	{
		gint i = 0;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		i = 0;
#line 5866 "tracker-sparql-scanner.c"
		{
			gboolean _tmp1_ = FALSE;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp1_ = TRUE;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			while (TRUE) {
#line 5873 "tracker-sparql-scanner.c"
				gchar* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gchar _tmp5_ = '\0';
				gchar* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gchar _tmp8_ = '\0';
				gchar _tmp9_ = '\0';
				gchar* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gchar _tmp12_ = '\0';
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (!_tmp1_) {
#line 5886 "tracker-sparql-scanner.c"
					gint _tmp2_ = 0;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp2_ = i;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					i = _tmp2_ + 1;
#line 5892 "tracker-sparql-scanner.c"
				}
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp1_ = FALSE;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp3_ = keyword_array;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp4_ = i;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp5_ = _tmp3_[_tmp4_];
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (!(((gint) _tmp5_) != 0)) {
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 5906 "tracker-sparql-scanner.c"
				}
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp6_ = begin;
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp7_ = i;
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp8_ = _tmp6_[_tmp7_];
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp9_ = g_ascii_toupper (_tmp8_);
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp10_ = keyword_array;
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp11_ = i;
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp12_ = _tmp10_[_tmp11_];
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (_tmp9_ != _tmp12_) {
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					result = FALSE;
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					return result;
#line 5928 "tracker-sparql-scanner.c"
				}
			}
		}
	}
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = TRUE;
#line 947 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 5937 "tracker-sparql-scanner.c"
}


static gboolean tracker_sparql_scanner_whitespace (TrackerSparqlScanner* self) {
	gboolean result = FALSE;
	gboolean found = FALSE;
#line 950 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 951 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	found = FALSE;
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	while (TRUE) {
#line 5950 "tracker-sparql-scanner.c"
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar _tmp7_ = '\0';
		gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = self->priv->current;
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = self->priv->end;
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp1_ < _tmp2_) {
#line 5964 "tracker-sparql-scanner.c"
			gchar* _tmp3_ = NULL;
			gchar _tmp4_ = '\0';
			gboolean _tmp5_ = FALSE;
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp3_ = self->priv->current;
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp4_ = _tmp3_[0];
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp5_ = g_ascii_isspace (_tmp4_);
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = _tmp5_;
#line 5976 "tracker-sparql-scanner.c"
		} else {
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = FALSE;
#line 5980 "tracker-sparql-scanner.c"
		}
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (!_tmp0_) {
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 5986 "tracker-sparql-scanner.c"
		}
#line 953 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp6_ = self->priv->current;
#line 953 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp7_ = _tmp6_[0];
#line 953 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp7_ == '\n') {
#line 5994 "tracker-sparql-scanner.c"
			gint _tmp8_ = 0;
#line 954 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp8_ = self->priv->line;
#line 954 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->line = _tmp8_ + 1;
#line 955 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->column = 0;
#line 6002 "tracker-sparql-scanner.c"
		}
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		found = TRUE;
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp9_ = self->priv->current;
#line 958 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp9_ + 1;
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp10_ = self->priv->column;
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->column = _tmp10_ + 1;
#line 6014 "tracker-sparql-scanner.c"
	}
#line 961 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = found;
#line 961 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 6020 "tracker-sparql-scanner.c"
}


static gboolean tracker_sparql_scanner_comment (TrackerSparqlScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 964 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = self->priv->current;
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = self->priv->end;
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp1_ >= _tmp2_) {
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 6039 "tracker-sparql-scanner.c"
	} else {
		gchar* _tmp3_ = NULL;
		gchar _tmp4_ = '\0';
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp3_ = self->priv->current;
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp4_ = _tmp3_[0];
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = _tmp4_ != '#';
#line 6049 "tracker-sparql-scanner.c"
	}
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp0_) {
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		result = FALSE;
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		return result;
#line 6057 "tracker-sparql-scanner.c"
	}
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	while (TRUE) {
#line 6061 "tracker-sparql-scanner.c"
		gboolean _tmp5_ = FALSE;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp10_ = NULL;
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp6_ = self->priv->current;
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp7_ = self->priv->end;
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp6_ < _tmp7_) {
#line 6072 "tracker-sparql-scanner.c"
			gchar* _tmp8_ = NULL;
			gchar _tmp9_ = '\0';
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp8_ = self->priv->current;
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp9_ = _tmp8_[0];
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp5_ = _tmp9_ != '\n';
#line 6081 "tracker-sparql-scanner.c"
		} else {
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp5_ = FALSE;
#line 6085 "tracker-sparql-scanner.c"
		}
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (!_tmp5_) {
#line 971 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 6091 "tracker-sparql-scanner.c"
		}
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp10_ = self->priv->current;
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp10_ + 1;
#line 6097 "tracker-sparql-scanner.c"
	}
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = TRUE;
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 6103 "tracker-sparql-scanner.c"
}


static void tracker_sparql_scanner_space (TrackerSparqlScanner* self) {
#line 978 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_if_fail (self != NULL);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	while (TRUE) {
#line 6112 "tracker-sparql-scanner.c"
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = tracker_sparql_scanner_whitespace (self);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp1_) {
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = TRUE;
#line 6121 "tracker-sparql-scanner.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp2_ = tracker_sparql_scanner_comment (self);
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = _tmp2_;
#line 6128 "tracker-sparql-scanner.c"
		}
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (!_tmp0_) {
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 6134 "tracker-sparql-scanner.c"
		}
	}
}


static void tracker_sparql_scanner_class_init (TrackerSparqlScannerClass * klass) {
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	tracker_sparql_scanner_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlScannerPrivate));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_scanner_finalize;
#line 6147 "tracker-sparql-scanner.c"
}


static void tracker_sparql_scanner_instance_init (TrackerSparqlScanner * self) {
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv = TRACKER_SPARQL_SCANNER_GET_PRIVATE (self);
#line 6154 "tracker-sparql-scanner.c"
}


static void tracker_sparql_scanner_finalize (GObject* obj) {
	TrackerSparqlScanner * self;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner);
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	G_OBJECT_CLASS (tracker_sparql_scanner_parent_class)->finalize (obj);
#line 6164 "tracker-sparql-scanner.c"
}


GType tracker_sparql_scanner_get_type (void) {
	static volatile gsize tracker_sparql_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlScanner), 0, (GInstanceInitFunc) tracker_sparql_scanner_instance_init, NULL };
		GType tracker_sparql_scanner_type_id;
		tracker_sparql_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlScanner", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_scanner_type_id__volatile, tracker_sparql_scanner_type_id);
	}
	return tracker_sparql_scanner_type_id__volatile;
}


void tracker_source_location_init (TrackerSourceLocation *self, gchar* pos, gint line, gint column) {
	gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 992 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	memset (self, 0, sizeof (TrackerSourceLocation));
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp0_ = pos;
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	(*self).pos = _tmp0_;
#line 994 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = line;
#line 994 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	(*self).line = _tmp1_;
#line 995 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = column;
#line 995 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	(*self).column = _tmp2_;
#line 6198 "tracker-sparql-scanner.c"
}


TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self) {
	TrackerSourceLocation* dup;
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	dup = g_new0 (TrackerSourceLocation, 1);
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	memcpy (dup, self, sizeof (TrackerSourceLocation));
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return dup;
#line 6210 "tracker-sparql-scanner.c"
}


void tracker_source_location_free (TrackerSourceLocation* self) {
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_free (self);
#line 6217 "tracker-sparql-scanner.c"
}


GType tracker_source_location_get_type (void) {
	static volatile gsize tracker_source_location_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_source_location_type_id__volatile)) {
		GType tracker_source_location_type_id;
		tracker_source_location_type_id = g_boxed_type_register_static ("TrackerSourceLocation", (GBoxedCopyFunc) tracker_source_location_dup, (GBoxedFreeFunc) tracker_source_location_free);
		g_once_init_leave (&tracker_source_location_type_id__volatile, tracker_source_location_type_id);
	}
	return tracker_source_location_type_id__volatile;
}


const gchar* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self) {
	const gchar* result = NULL;
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	switch (self) {
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_A:
#line 6238 "tracker-sparql-scanner.c"
		{
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`a'";
#line 1126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6244 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ABS:
#line 6248 "tracker-sparql-scanner.c"
		{
#line 1127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ABS'";
#line 1127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6254 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_AS:
#line 6258 "tracker-sparql-scanner.c"
		{
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`AS'";
#line 1128 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6264 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ASC:
#line 6268 "tracker-sparql-scanner.c"
		{
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ASC'";
#line 1129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6274 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ASK:
#line 6278 "tracker-sparql-scanner.c"
		{
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ASK'";
#line 1130 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6284 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ATBASE:
#line 6288 "tracker-sparql-scanner.c"
		{
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`@base'";
#line 1131 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6294 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX:
#line 6298 "tracker-sparql-scanner.c"
		{
#line 1132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`@prefix'";
#line 1132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6304 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_AVG:
#line 6308 "tracker-sparql-scanner.c"
		{
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`AVG'";
#line 1133 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6314 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BASE:
#line 6318 "tracker-sparql-scanner.c"
		{
#line 1134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`BASE'";
#line 1134 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6324 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE:
#line 6328 "tracker-sparql-scanner.c"
		{
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "blank node";
#line 1135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6334 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 6338 "tracker-sparql-scanner.c"
		{
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`BOUND'";
#line 1136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6344 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BY:
#line 6348 "tracker-sparql-scanner.c"
		{
#line 1137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`BY'";
#line 1137 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6354 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CEIL:
#line 6358 "tracker-sparql-scanner.c"
		{
#line 1138 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`CEIL'";
#line 1138 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6364 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE:
#line 6368 "tracker-sparql-scanner.c"
		{
#line 1139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`}'";
#line 1139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6374 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET:
#line 6378 "tracker-sparql-scanner.c"
		{
#line 1140 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`]'";
#line 1140 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6384 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS:
#line 6388 "tracker-sparql-scanner.c"
		{
#line 1141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`)'";
#line 1141 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6394 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COALESCE:
#line 6398 "tracker-sparql-scanner.c"
		{
#line 1142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`COALESCE'";
#line 1142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6404 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
#line 6408 "tracker-sparql-scanner.c"
		{
#line 1143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`:'";
#line 1143 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6414 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CONCAT:
#line 6418 "tracker-sparql-scanner.c"
		{
#line 1144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`CONCAT'";
#line 1144 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6424 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CONTAINS:
#line 6428 "tracker-sparql-scanner.c"
		{
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`CONTAINS'";
#line 1145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6434 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COMMA:
#line 6438 "tracker-sparql-scanner.c"
		{
#line 1146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`,'";
#line 1146 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6444 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT:
#line 6448 "tracker-sparql-scanner.c"
		{
#line 1147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`CONSTRUCT'";
#line 1147 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6454 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COUNT:
#line 6458 "tracker-sparql-scanner.c"
		{
#line 1148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`COUNT'";
#line 1148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6464 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 6468 "tracker-sparql-scanner.c"
		{
#line 1149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DATATYPE'";
#line 1149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6474 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DAY:
#line 6478 "tracker-sparql-scanner.c"
		{
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DAY'";
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6484 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DECIMAL:
#line 6488 "tracker-sparql-scanner.c"
		{
#line 1151 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DECIMAL'";
#line 1151 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6494 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DELETE:
#line 6498 "tracker-sparql-scanner.c"
		{
#line 1152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DELETE'";
#line 1152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6504 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DESC:
#line 6508 "tracker-sparql-scanner.c"
		{
#line 1153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DESC'";
#line 1153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6514 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE:
#line 6518 "tracker-sparql-scanner.c"
		{
#line 1154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DESCRIBE'";
#line 1154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6524 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DISTINCT:
#line 6528 "tracker-sparql-scanner.c"
		{
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DISTINCT'";
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6534 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE:
#line 6538 "tracker-sparql-scanner.c"
		{
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DOUBLE'";
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6544 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX:
#line 6548 "tracker-sparql-scanner.c"
		{
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`^^'";
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6554 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DROP:
#line 6558 "tracker-sparql-scanner.c"
		{
#line 1158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DROP'";
#line 1158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6564 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI:
#line 6568 "tracker-sparql-scanner.c"
		{
#line 1159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ENCODE_FOR_URI'";
#line 1159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6574 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 6578 "tracker-sparql-scanner.c"
		{
#line 1160 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "end of file";
#line 1160 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6584 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
#line 6588 "tracker-sparql-scanner.c"
		{
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`EXISTS'";
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6594 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FALSE:
#line 6598 "tracker-sparql-scanner.c"
		{
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`false'";
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6604 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FILTER:
#line 6608 "tracker-sparql-scanner.c"
		{
#line 1163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`FILTER'";
#line 1163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6614 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FLOOR:
#line 6618 "tracker-sparql-scanner.c"
		{
#line 1164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`FLOOR'";
#line 1164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6624 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FROM:
#line 6628 "tracker-sparql-scanner.c"
		{
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`FROM'";
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6634 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GRAPH:
#line 6638 "tracker-sparql-scanner.c"
		{
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`GRAPH'";
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6644 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
#line 6648 "tracker-sparql-scanner.c"
		{
#line 1167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`GROUP'";
#line 1167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6654 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT:
#line 6658 "tracker-sparql-scanner.c"
		{
#line 1168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`GROUP_CONCAT'";
#line 1168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6664 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_HAVING:
#line 6668 "tracker-sparql-scanner.c"
		{
#line 1169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`HAVING'";
#line 1169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6674 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_HOURS:
#line 6678 "tracker-sparql-scanner.c"
		{
#line 1170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`HOURS'";
#line 1170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6684 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
#line 6688 "tracker-sparql-scanner.c"
		{
#line 1171 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`IF'";
#line 1171 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6694 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INSERT:
#line 6698 "tracker-sparql-scanner.c"
		{
#line 1172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`INSERT'";
#line 1172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6704 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INTEGER:
#line 6708 "tracker-sparql-scanner.c"
		{
#line 1173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`INTEGER'";
#line 1173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6714 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INTO:
#line 6718 "tracker-sparql-scanner.c"
		{
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`INTO'";
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6724 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
#line 6728 "tracker-sparql-scanner.c"
		{
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "IRI reference";
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6734 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 6738 "tracker-sparql-scanner.c"
		{
#line 1176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ISBLANK'";
#line 1176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6744 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 6748 "tracker-sparql-scanner.c"
		{
#line 1177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ISIRI'";
#line 1177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6754 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 6758 "tracker-sparql-scanner.c"
		{
#line 1178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ISLITERAL'";
#line 1178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6764 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 6768 "tracker-sparql-scanner.c"
		{
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ISURI'";
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6774 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 6778 "tracker-sparql-scanner.c"
		{
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`LANG'";
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6784 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 6788 "tracker-sparql-scanner.c"
		{
#line 1181 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`LANGMATCHES'";
#line 1181 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6794 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LCASE:
#line 6798 "tracker-sparql-scanner.c"
		{
#line 1182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`LCASE'";
#line 1182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6804 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
#line 6808 "tracker-sparql-scanner.c"
		{
#line 1183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`LIMIT'";
#line 1183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6814 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MAX:
#line 6818 "tracker-sparql-scanner.c"
		{
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`MAX'";
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6824 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MD5:
#line 6828 "tracker-sparql-scanner.c"
		{
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`MD5'";
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6834 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MIN:
#line 6838 "tracker-sparql-scanner.c"
		{
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`MIN'";
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6844 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MINUS:
#line 6848 "tracker-sparql-scanner.c"
		{
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`-'";
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6854 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MINUTES:
#line 6858 "tracker-sparql-scanner.c"
		{
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`MINUTES'";
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6864 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MONTH:
#line 6868 "tracker-sparql-scanner.c"
		{
#line 1189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`MONTH'";
#line 1189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6874 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NAMED:
#line 6878 "tracker-sparql-scanner.c"
		{
#line 1190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`NAMED'";
#line 1190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6884 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
#line 6888 "tracker-sparql-scanner.c"
		{
#line 1191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`NOT'";
#line 1191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6894 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
#line 6898 "tracker-sparql-scanner.c"
		{
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`OFFSET'";
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6904 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_AND:
#line 6908 "tracker-sparql-scanner.c"
		{
#line 1193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`&&'";
#line 1193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6914 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_EQ:
#line 6918 "tracker-sparql-scanner.c"
		{
#line 1194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`='";
#line 1194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6924 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_GE:
#line 6928 "tracker-sparql-scanner.c"
		{
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`>='";
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6934 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_GT:
#line 6938 "tracker-sparql-scanner.c"
		{
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`>'";
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6944 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_LE:
#line 6948 "tracker-sparql-scanner.c"
		{
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`<='";
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6954 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_LT:
#line 6958 "tracker-sparql-scanner.c"
		{
#line 1198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`<'";
#line 1198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6964 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_NE:
#line 6968 "tracker-sparql-scanner.c"
		{
#line 1199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`!='";
#line 1199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6974 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_NEG:
#line 6978 "tracker-sparql-scanner.c"
		{
#line 1200 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`!'";
#line 1200 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6984 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_OR:
#line 6988 "tracker-sparql-scanner.c"
		{
#line 1201 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`||'";
#line 1201 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6994 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_IN:
#line 6998 "tracker-sparql-scanner.c"
		{
#line 1202 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`IN'";
#line 1202 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7004 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
#line 7008 "tracker-sparql-scanner.c"
		{
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`{'";
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7014 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET:
#line 7018 "tracker-sparql-scanner.c"
		{
#line 1204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`['";
#line 1204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7024 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 7028 "tracker-sparql-scanner.c"
		{
#line 1205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`('";
#line 1205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7034 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL:
#line 7038 "tracker-sparql-scanner.c"
		{
#line 1206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`OPTIONAL'";
#line 1206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7044 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OR:
#line 7048 "tracker-sparql-scanner.c"
		{
#line 1207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`OR'";
#line 1207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7054 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
#line 7058 "tracker-sparql-scanner.c"
		{
#line 1208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ORDER'";
#line 1208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7064 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PLUS:
#line 7068 "tracker-sparql-scanner.c"
		{
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`+'";
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7074 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
#line 7078 "tracker-sparql-scanner.c"
		{
#line 1210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "prefixed name";
#line 1210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7084 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PREFIX:
#line 7088 "tracker-sparql-scanner.c"
		{
#line 1211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`PREFIX'";
#line 1211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7094 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REDUCED:
#line 7098 "tracker-sparql-scanner.c"
		{
#line 1212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`REDUCED'";
#line 1212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7104 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 7108 "tracker-sparql-scanner.c"
		{
#line 1213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`REGEX'";
#line 1213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7114 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REPLACE:
#line 7118 "tracker-sparql-scanner.c"
		{
#line 1214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`REPLACE'";
#line 1214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7124 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ROUND:
#line 7128 "tracker-sparql-scanner.c"
		{
#line 1215 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ROUND'";
#line 1215 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7134 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 7138 "tracker-sparql-scanner.c"
		{
#line 1216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SAMETERM'";
#line 1216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7144 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SECONDS:
#line 7148 "tracker-sparql-scanner.c"
		{
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SECONDS'";
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7154 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SELECT:
#line 7158 "tracker-sparql-scanner.c"
		{
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SELECT'";
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7164 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON:
#line 7168 "tracker-sparql-scanner.c"
		{
#line 1219 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`;'";
#line 1219 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7174 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SHA1:
#line 7178 "tracker-sparql-scanner.c"
		{
#line 1220 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SHA1'";
#line 1220 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7184 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SHA256:
#line 7188 "tracker-sparql-scanner.c"
		{
#line 1221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SHA256'";
#line 1221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7194 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SHA512:
#line 7198 "tracker-sparql-scanner.c"
		{
#line 1222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SHA512'";
#line 1222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7204 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SILENT:
#line 7208 "tracker-sparql-scanner.c"
		{
#line 1223 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SILENT'";
#line 1223 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7214 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STAR:
#line 7218 "tracker-sparql-scanner.c"
		{
#line 1224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`*'";
#line 1224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7224 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 7228 "tracker-sparql-scanner.c"
		{
#line 1225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STR'";
#line 1225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7234 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRAFTER:
#line 7238 "tracker-sparql-scanner.c"
		{
#line 1226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STRAFTER'";
#line 1226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7244 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE:
#line 7248 "tracker-sparql-scanner.c"
		{
#line 1227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STRBEFORE'";
#line 1227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7254 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRENDS:
#line 7258 "tracker-sparql-scanner.c"
		{
#line 1228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STRENDS'";
#line 1228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7264 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
#line 7268 "tracker-sparql-scanner.c"
		{
#line 1229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "string literal";
#line 1229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7274 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
#line 7278 "tracker-sparql-scanner.c"
		{
#line 1230 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "string literal";
#line 1230 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7284 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
#line 7288 "tracker-sparql-scanner.c"
		{
#line 1231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "string literal";
#line 1231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7294 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
#line 7298 "tracker-sparql-scanner.c"
		{
#line 1232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "string literal";
#line 1232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7304 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRLEN:
#line 7308 "tracker-sparql-scanner.c"
		{
#line 1233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STRLEN'";
#line 1233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7314 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS:
#line 7318 "tracker-sparql-scanner.c"
		{
#line 1234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STRSTARTS'";
#line 1234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7324 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SUBSTR:
#line 7328 "tracker-sparql-scanner.c"
		{
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SUBSTR'";
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7334 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SUM:
#line 7338 "tracker-sparql-scanner.c"
		{
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SUM'";
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7344 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_TRUE:
#line 7348 "tracker-sparql-scanner.c"
		{
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`true'";
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7354 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_UCASE:
#line 7358 "tracker-sparql-scanner.c"
		{
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`UCASE'";
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7364 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_UNION:
#line 7368 "tracker-sparql-scanner.c"
		{
#line 1239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`UNION'";
#line 1239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7374 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_VAR:
#line 7378 "tracker-sparql-scanner.c"
		{
#line 1240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "variable";
#line 1240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7384 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
#line 7388 "tracker-sparql-scanner.c"
		{
#line 1241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`WHERE'";
#line 1241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7394 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_WITH:
#line 7398 "tracker-sparql-scanner.c"
		{
#line 1242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`WITH'";
#line 1242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7404 "tracker-sparql-scanner.c"
		}
#line 1125 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_YEAR:
#line 7408 "tracker-sparql-scanner.c"
		{
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`YEAR'";
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7414 "tracker-sparql-scanner.c"
		}
		default:
		{
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "unknown token";
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 7422 "tracker-sparql-scanner.c"
		}
	}
}


GType tracker_sparql_token_type_get_type (void) {
	static volatile gsize tracker_sparql_token_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_token_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_TOKEN_TYPE_NONE, "TRACKER_SPARQL_TOKEN_TYPE_NONE", "none"}, {TRACKER_SPARQL_TOKEN_TYPE_A, "TRACKER_SPARQL_TOKEN_TYPE_A", "a"}, {TRACKER_SPARQL_TOKEN_TYPE_ABS, "TRACKER_SPARQL_TOKEN_TYPE_ABS", "abs"}, {TRACKER_SPARQL_TOKEN_TYPE_AS, "TRACKER_SPARQL_TOKEN_TYPE_AS", "as"}, {TRACKER_SPARQL_TOKEN_TYPE_ASC, "TRACKER_SPARQL_TOKEN_TYPE_ASC", "asc"}, {TRACKER_SPARQL_TOKEN_TYPE_ASK, "TRACKER_SPARQL_TOKEN_TYPE_ASK", "ask"}, {TRACKER_SPARQL_TOKEN_TYPE_ATBASE, "TRACKER_SPARQL_TOKEN_TYPE_ATBASE", "atbase"}, {TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX, "TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX", "atprefix"}, {TRACKER_SPARQL_TOKEN_TYPE_AVG, "TRACKER_SPARQL_TOKEN_TYPE_AVG", "avg"}, {TRACKER_SPARQL_TOKEN_TYPE_BASE, "TRACKER_SPARQL_TOKEN_TYPE_BASE", "base"}, {TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, "TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE", "blank-node"}, {TRACKER_SPARQL_TOKEN_TYPE_BOUND, "TRACKER_SPARQL_TOKEN_TYPE_BOUND", "bound"}, {TRACKER_SPARQL_TOKEN_TYPE_BY, "TRACKER_SPARQL_TOKEN_TYPE_BY", "by"}, {TRACKER_SPARQL_TOKEN_TYPE_CEIL, "TRACKER_SPARQL_TOKEN_TYPE_CEIL", "ceil"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE", "close-brace"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET", "close-bracket"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS", "close-parens"}, {TRACKER_SPARQL_TOKEN_TYPE_COALESCE, "TRACKER_SPARQL_TOKEN_TYPE_COALESCE", "coalesce"}, {TRACKER_SPARQL_TOKEN_TYPE_COLON, "TRACKER_SPARQL_TOKEN_TYPE_COLON", "colon"}, {TRACKER_SPARQL_TOKEN_TYPE_CONCAT, "TRACKER_SPARQL_TOKEN_TYPE_CONCAT", "concat"}, {TRACKER_SPARQL_TOKEN_TYPE_CONTAINS, "TRACKER_SPARQL_TOKEN_TYPE_CONTAINS", "contains"}, {TRACKER_SPARQL_TOKEN_TYPE_COMMA, "TRACKER_SPARQL_TOKEN_TYPE_COMMA", "comma"}, {TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT, "TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT", "construct"}, {TRACKER_SPARQL_TOKEN_TYPE_COUNT, "TRACKER_SPARQL_TOKEN_TYPE_COUNT", "count"}, {TRACKER_SPARQL_TOKEN_TYPE_DATA, "TRACKER_SPARQL_TOKEN_TYPE_DATA", "data"}, {TRACKER_SPARQL_TOKEN_TYPE_DATATYPE, "TRACKER_SPARQL_TOKEN_TYPE_DATATYPE", "datatype"}, {TRACKER_SPARQL_TOKEN_TYPE_DAY, "TRACKER_SPARQL_TOKEN_TYPE_DAY", "day"}, {TRACKER_SPARQL_TOKEN_TYPE_DECIMAL, "TRACKER_SPARQL_TOKEN_TYPE_DECIMAL", "decimal"}, {TRACKER_SPARQL_TOKEN_TYPE_DELETE, "TRACKER_SPARQL_TOKEN_TYPE_DELETE", "delete"}, {TRACKER_SPARQL_TOKEN_TYPE_DESC, "TRACKER_SPARQL_TOKEN_TYPE_DESC", "desc"}, {TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE, "TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE", "describe"}, {TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, "TRACKER_SPARQL_TOKEN_TYPE_DISTINCT", "distinct"}, {TRACKER_SPARQL_TOKEN_TYPE_DIV, "TRACKER_SPARQL_TOKEN_TYPE_DIV", "div"}, {TRACKER_SPARQL_TOKEN_TYPE_DOT, "TRACKER_SPARQL_TOKEN_TYPE_DOT", "dot"}, {TRACKER_SPARQL_TOKEN_TYPE_DOUBLE, "TRACKER_SPARQL_TOKEN_TYPE_DOUBLE", "double"}, {TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, "TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX", "double-circumflex"}, {TRACKER_SPARQL_TOKEN_TYPE_DROP, "TRACKER_SPARQL_TOKEN_TYPE_DROP", "drop"}, {TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI, "TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI", "encode-for-uri"}, {TRACKER_SPARQL_TOKEN_TYPE_EOF, "TRACKER_SPARQL_TOKEN_TYPE_EOF", "eof"}, {TRACKER_SPARQL_TOKEN_TYPE_EXISTS, "TRACKER_SPARQL_TOKEN_TYPE_EXISTS", "exists"}, {TRACKER_SPARQL_TOKEN_TYPE_FALSE, "TRACKER_SPARQL_TOKEN_TYPE_FALSE", "false"}, {TRACKER_SPARQL_TOKEN_TYPE_FILTER, "TRACKER_SPARQL_TOKEN_TYPE_FILTER", "filter"}, {TRACKER_SPARQL_TOKEN_TYPE_FLOOR, "TRACKER_SPARQL_TOKEN_TYPE_FLOOR", "floor"}, {TRACKER_SPARQL_TOKEN_TYPE_FROM, "TRACKER_SPARQL_TOKEN_TYPE_FROM", "from"}, {TRACKER_SPARQL_TOKEN_TYPE_GRAPH, "TRACKER_SPARQL_TOKEN_TYPE_GRAPH", "graph"}, {TRACKER_SPARQL_TOKEN_TYPE_GROUP, "TRACKER_SPARQL_TOKEN_TYPE_GROUP", "group"}, {TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT, "TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT", "group-concat"}, {TRACKER_SPARQL_TOKEN_TYPE_HAVING, "TRACKER_SPARQL_TOKEN_TYPE_HAVING", "having"}, {TRACKER_SPARQL_TOKEN_TYPE_HOURS, "TRACKER_SPARQL_TOKEN_TYPE_HOURS", "hours"}, {TRACKER_SPARQL_TOKEN_TYPE_IF, "TRACKER_SPARQL_TOKEN_TYPE_IF", "if"}, {TRACKER_SPARQL_TOKEN_TYPE_INSERT, "TRACKER_SPARQL_TOKEN_TYPE_INSERT", "insert"}, {TRACKER_SPARQL_TOKEN_TYPE_INTEGER, "TRACKER_SPARQL_TOKEN_TYPE_INTEGER", "integer"}, {TRACKER_SPARQL_TOKEN_TYPE_INTO, "TRACKER_SPARQL_TOKEN_TYPE_INTO", "into"}, {TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, "TRACKER_SPARQL_TOKEN_TYPE_IRI_REF", "iri-ref"}, {TRACKER_SPARQL_TOKEN_TYPE_ISBLANK, "TRACKER_SPARQL_TOKEN_TYPE_ISBLANK", "isblank"}, {TRACKER_SPARQL_TOKEN_TYPE_ISIRI, "TRACKER_SPARQL_TOKEN_TYPE_ISIRI", "isiri"}, {TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL, "TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL", "isliteral"}, {TRACKER_SPARQL_TOKEN_TYPE_ISURI, "TRACKER_SPARQL_TOKEN_TYPE_ISURI", "isuri"}, {TRACKER_SPARQL_TOKEN_TYPE_LANG, "TRACKER_SPARQL_TOKEN_TYPE_LANG", "lang"}, {TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES, "TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES", "langmatches"}, {TRACKER_SPARQL_TOKEN_TYPE_LCASE, "TRACKER_SPARQL_TOKEN_TYPE_LCASE", "lcase"}, {TRACKER_SPARQL_TOKEN_TYPE_LIMIT, "TRACKER_SPARQL_TOKEN_TYPE_LIMIT", "limit"}, {TRACKER_SPARQL_TOKEN_TYPE_MAX, "TRACKER_SPARQL_TOKEN_TYPE_MAX", "max"}, {TRACKER_SPARQL_TOKEN_TYPE_MD5, "TRACKER_SPARQL_TOKEN_TYPE_MD5", "md5"}, {TRACKER_SPARQL_TOKEN_TYPE_MIN, "TRACKER_SPARQL_TOKEN_TYPE_MIN", "min"}, {TRACKER_SPARQL_TOKEN_TYPE_MINUS, "TRACKER_SPARQL_TOKEN_TYPE_MINUS", "minus"}, {TRACKER_SPARQL_TOKEN_TYPE_MINUTES, "TRACKER_SPARQL_TOKEN_TYPE_MINUTES", "minutes"}, {TRACKER_SPARQL_TOKEN_TYPE_MONTH, "TRACKER_SPARQL_TOKEN_TYPE_MONTH", "month"}, {TRACKER_SPARQL_TOKEN_TYPE_NAMED, "TRACKER_SPARQL_TOKEN_TYPE_NAMED", "named"}, {TRACKER_SPARQL_TOKEN_TYPE_NOT, "TRACKER_SPARQL_TOKEN_TYPE_NOT", "not"}, {TRACKER_SPARQL_TOKEN_TYPE_NULL, "TRACKER_SPARQL_TOKEN_TYPE_NULL", "null"}, {TRACKER_SPARQL_TOKEN_TYPE_OFFSET, "TRACKER_SPARQL_TOKEN_TYPE_OFFSET", "offset"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_AND, "TRACKER_SPARQL_TOKEN_TYPE_OP_AND", "op-and"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_EQ, "TRACKER_SPARQL_TOKEN_TYPE_OP_EQ", "op-eq"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_GE, "TRACKER_SPARQL_TOKEN_TYPE_OP_GE", "op-ge"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_GT, "TRACKER_SPARQL_TOKEN_TYPE_OP_GT", "op-gt"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_LE, "TRACKER_SPARQL_TOKEN_TYPE_OP_LE", "op-le"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_LT, "TRACKER_SPARQL_TOKEN_TYPE_OP_LT", "op-lt"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_NE, "TRACKER_SPARQL_TOKEN_TYPE_OP_NE", "op-ne"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_NEG, "TRACKER_SPARQL_TOKEN_TYPE_OP_NEG", "op-neg"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_OR, "TRACKER_SPARQL_TOKEN_TYPE_OP_OR", "op-or"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_IN, "TRACKER_SPARQL_TOKEN_TYPE_OP_IN", "op-in"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE", "open-brace"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET", "open-bracket"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS", "open-parens"}, {TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL, "TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL", "optional"}, {TRACKER_SPARQL_TOKEN_TYPE_OR, "TRACKER_SPARQL_TOKEN_TYPE_OR", "or"}, {TRACKER_SPARQL_TOKEN_TYPE_ORDER, "TRACKER_SPARQL_TOKEN_TYPE_ORDER", "order"}, {TRACKER_SPARQL_TOKEN_TYPE_PLUS, "TRACKER_SPARQL_TOKEN_TYPE_PLUS", "plus"}, {TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, "TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX", "pn-prefix"}, {TRACKER_SPARQL_TOKEN_TYPE_PREFIX, "TRACKER_SPARQL_TOKEN_TYPE_PREFIX", "prefix"}, {TRACKER_SPARQL_TOKEN_TYPE_REDUCED, "TRACKER_SPARQL_TOKEN_TYPE_REDUCED", "reduced"}, {TRACKER_SPARQL_TOKEN_TYPE_REGEX, "TRACKER_SPARQL_TOKEN_TYPE_REGEX", "regex"}, {TRACKER_SPARQL_TOKEN_TYPE_REPLACE, "TRACKER_SPARQL_TOKEN_TYPE_REPLACE", "replace"}, {TRACKER_SPARQL_TOKEN_TYPE_ROUND, "TRACKER_SPARQL_TOKEN_TYPE_ROUND", "round"}, {TRACKER_SPARQL_TOKEN_TYPE_SAMETERM, "TRACKER_SPARQL_TOKEN_TYPE_SAMETERM", "sameterm"}, {TRACKER_SPARQL_TOKEN_TYPE_SECONDS, "TRACKER_SPARQL_TOKEN_TYPE_SECONDS", "seconds"}, {TRACKER_SPARQL_TOKEN_TYPE_SELECT, "TRACKER_SPARQL_TOKEN_TYPE_SELECT", "select"}, {TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, "TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON", "semicolon"}, {TRACKER_SPARQL_TOKEN_TYPE_SHA1, "TRACKER_SPARQL_TOKEN_TYPE_SHA1", "sha1"}, {TRACKER_SPARQL_TOKEN_TYPE_SHA256, "TRACKER_SPARQL_TOKEN_TYPE_SHA256", "sha256"}, {TRACKER_SPARQL_TOKEN_TYPE_SHA512, "TRACKER_SPARQL_TOKEN_TYPE_SHA512", "sha512"}, {TRACKER_SPARQL_TOKEN_TYPE_SILENT, "TRACKER_SPARQL_TOKEN_TYPE_SILENT", "silent"}, {TRACKER_SPARQL_TOKEN_TYPE_STAR, "TRACKER_SPARQL_TOKEN_TYPE_STAR", "star"}, {TRACKER_SPARQL_TOKEN_TYPE_STR, "TRACKER_SPARQL_TOKEN_TYPE_STR", "str"}, {TRACKER_SPARQL_TOKEN_TYPE_STRAFTER, "TRACKER_SPARQL_TOKEN_TYPE_STRAFTER", "strafter"}, {TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE, "TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE", "strbefore"}, {TRACKER_SPARQL_TOKEN_TYPE_STRENDS, "TRACKER_SPARQL_TOKEN_TYPE_STRENDS", "strends"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1", "string-literal1"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2", "string-literal2"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1", "string-literal-long1"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2", "string-literal-long2"}, {TRACKER_SPARQL_TOKEN_TYPE_STRLEN, "TRACKER_SPARQL_TOKEN_TYPE_STRLEN", "strlen"}, {TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS, "TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS", "strstarts"}, {TRACKER_SPARQL_TOKEN_TYPE_SUBSTR, "TRACKER_SPARQL_TOKEN_TYPE_SUBSTR", "substr"}, {TRACKER_SPARQL_TOKEN_TYPE_SUM, "TRACKER_SPARQL_TOKEN_TYPE_SUM", "sum"}, {TRACKER_SPARQL_TOKEN_TYPE_TRUE, "TRACKER_SPARQL_TOKEN_TYPE_TRUE", "true"}, {TRACKER_SPARQL_TOKEN_TYPE_UCASE, "TRACKER_SPARQL_TOKEN_TYPE_UCASE", "ucase"}, {TRACKER_SPARQL_TOKEN_TYPE_UNION, "TRACKER_SPARQL_TOKEN_TYPE_UNION", "union"}, {TRACKER_SPARQL_TOKEN_TYPE_VAR, "TRACKER_SPARQL_TOKEN_TYPE_VAR", "var"}, {TRACKER_SPARQL_TOKEN_TYPE_WHERE, "TRACKER_SPARQL_TOKEN_TYPE_WHERE", "where"}, {TRACKER_SPARQL_TOKEN_TYPE_WITH, "TRACKER_SPARQL_TOKEN_TYPE_WITH", "with"}, {TRACKER_SPARQL_TOKEN_TYPE_YEAR, "TRACKER_SPARQL_TOKEN_TYPE_YEAR", "year"}, {0, NULL, NULL}};
		GType tracker_sparql_token_type_type_id;
		tracker_sparql_token_type_type_id = g_enum_register_static ("TrackerSparqlTokenType", values);
		g_once_init_leave (&tracker_sparql_token_type_type_id__volatile, tracker_sparql_token_type_type_id);
	}
	return tracker_sparql_token_type_type_id__volatile;
}



