/* math-buttons.c generated by valac 0.29.3.11-7fa8-dirty, the Vala compiler
 * generated from math-buttons.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "libcalculator.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtksourceview/gtksource.h>
#include <gdk/gdk.h>
#include <atk/atk.h>
#include <cairo.h>


#define TYPE_BUTTON_MODE (button_mode_get_type ())

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
typedef struct _MathButtonsPrivate MathButtonsPrivate;

#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MATH_VARIABLE_POPUP (math_variable_popup_get_type ())
#define MATH_VARIABLE_POPUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_VARIABLE_POPUP, MathVariablePopup))
#define MATH_VARIABLE_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_VARIABLE_POPUP, MathVariablePopupClass))
#define IS_MATH_VARIABLE_POPUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_VARIABLE_POPUP))
#define IS_MATH_VARIABLE_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_VARIABLE_POPUP))
#define MATH_VARIABLE_POPUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_VARIABLE_POPUP, MathVariablePopupClass))

typedef struct _MathVariablePopup MathVariablePopup;
typedef struct _MathVariablePopupClass MathVariablePopupClass;

#define TYPE_MATH_FUNCTION_POPUP (math_function_popup_get_type ())
#define MATH_FUNCTION_POPUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_FUNCTION_POPUP, MathFunctionPopup))
#define MATH_FUNCTION_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_FUNCTION_POPUP, MathFunctionPopupClass))
#define IS_MATH_FUNCTION_POPUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_FUNCTION_POPUP))
#define IS_MATH_FUNCTION_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_FUNCTION_POPUP))
#define MATH_FUNCTION_POPUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_FUNCTION_POPUP, MathFunctionPopupClass))

typedef struct _MathFunctionPopup MathFunctionPopup;
typedef struct _MathFunctionPopupClass MathFunctionPopupClass;

typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING,
	BUTTON_MODE_KEYBOARD
} ButtonMode;

struct _MathButtons {
	GtkBox parent_instance;
	MathButtonsPrivate * priv;
};

struct _MathButtonsClass {
	GtkBoxClass parent_class;
};

struct _MathButtonsPrivate {
	MathEquation* equation;
	ButtonMode _mode;
	gint _programming_base;
	MathConverter* converter;
	GtkBuilder* basic_ui;
	GtkBuilder* advanced_ui;
	GtkBuilder* financial_ui;
	GtkBuilder* programming_ui;
	GtkWidget* bas_panel;
	GtkWidget* adv_panel;
	GtkWidget* fin_panel;
	GtkWidget* prog_panel;
	GtkWidget* active_panel;
	GtkMenu* shift_left_menu;
	GtkMenu* shift_right_menu;
	GList* superscript_toggles;
	GList* subscript_toggles;
	GtkComboBox* base_combo;
	GtkLabel* base_label;
	GtkWidget* bit_panel;
	GList* bit_labels;
	GtkDialog* character_code_dialog;
	GtkEntry* character_code_entry;
};


static gpointer math_buttons_parent_class = NULL;

GType button_mode_get_type (void) G_GNUC_CONST;
GType math_buttons_get_type (void) G_GNUC_CONST;
GType math_converter_get_type (void) G_GNUC_CONST;
#define MATH_BUTTONS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_BUTTONS, MathButtonsPrivate))
enum  {
	MATH_BUTTONS_DUMMY_PROPERTY,
	MATH_BUTTONS_MODE,
	MATH_BUTTONS_PROGRAMMING_BASE
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
MathButtons* math_buttons_new (MathEquation* equation);
MathButtons* math_buttons_construct (GType object_type, MathEquation* equation);
static void math_buttons_load_buttons (MathButtons* self);
static void _math_buttons_load_buttons_gtk_widget_show (GtkWidget* _sender, gpointer self);
static void __lambda23_ (MathButtons* self, GParamSpec* pspec);
static void math_buttons_update_bit_panel (MathButtons* self);
static void ___lambda23__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda24_ (MathButtons* self, GParamSpec* pspec);
static void math_buttons_number_mode_changed_cb (MathButtons* self);
static void ___lambda24__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda25_ (MathButtons* self, GParamSpec* pspec);
static void ___lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda26_ (MathButtons* self, GParamSpec* pspec);
static void ___lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void math_buttons_load_finc_dialogs (MathButtons* self);
static void math_buttons_load_finc_dialog (MathButtons* self, const gchar* name, gchar** entry_names, int entry_names_length1, FinancialDialog function);
static void math_buttons_finc_response_cb (MathButtons* self, GtkWidget* widget, gint response_id);
static void _math_buttons_finc_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void math_buttons_finc_activate_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_finc_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void math_buttons_base_combobox_changed_cb (MathButtons* self, GtkComboBox* combo);
void math_buttons_set_programming_base (MathButtons* self, gint value);
static void math_buttons_base_changed_cb (MathButtons* self);
ButtonMode math_buttons_get_mode (MathButtons* self);
gint math_buttons_get_programming_base (MathButtons* self);
static GtkWidget* math_buttons_load_mode (MathButtons* self, ButtonMode mode);
static void math_buttons_setup_button (MathButtons* self, GtkBuilder* builder, const gchar* name, const gchar* data, const gchar* tooltip, gboolean connect);
static void ______lambda9_ (MathButtons* self, GtkButton* widget);
static void _______lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda10_ (MathButtons* self);
static void ____lambda10__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda11_ (MathButtons* self);
static void ____lambda11__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda12_ (MathButtons* self);
static void ____lambda12__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda13_ (MathButtons* self);
static void ____lambda13__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda14_ (MathButtons* self);
static void ____lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_memory_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_memory_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_function_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_function_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda17_ (MathButtons* self);
static void ____lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda18_ (MathButtons* self);
static void ____lambda18__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_shift_left_cb (MathButtons* self, GtkButton* button);
static void _math_buttons_shift_left_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_shift_right_cb (MathButtons* self, GtkButton* button);
static void _math_buttons_shift_right_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_insert_character_code_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_insert_character_code_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda21_ (MathButtons* self);
static void ____lambda21__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_set_superscript_cb (MathButtons* self, GtkButton* widget);
static void _math_buttons_set_superscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_set_subscript_cb (MathButtons* self, GtkButton* widget);
static void _math_buttons_set_subscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_character_code_dialog_response_cb (MathButtons* self, GtkWidget* dialog, gint response_id);
static void _math_buttons_character_code_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean math_buttons_character_code_dialog_delete_cb (MathButtons* self, GtkWidget* dialog, GdkEventAny* event);
static gboolean _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void math_buttons_character_code_dialog_activate_cb (MathButtons* self, GtkWidget* entry);
static void _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static gboolean math_buttons_bit_toggle_cb (MathButtons* self, GtkWidget* event_box, GdkEventButton* event);
static gboolean _math_buttons_bit_toggle_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void ___lambda22_ (MathButtons* self, GParamSpec* pspec);
static void ____lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void math_buttons_finc_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_finc_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ____lambda8_ (MathButtons* self, GtkButton* widget);
static void _____lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_converter_changed_cb (MathButtons* self);
void math_converter_get_conversion (MathConverter* self, Unit** from_unit, Unit** to_unit);
MathConverter* math_converter_new (MathEquation* equation);
MathConverter* math_converter_construct (GType object_type, MathEquation* equation);
static void _math_buttons_converter_changed_cb_math_converter_changed (MathConverter* _sender, gpointer self);
static void math_buttons_popup_button_menu (MathButtons* self, GtkButton* button, GtkMenu* menu);
static void math_buttons_button_menu_position_func (MathButtons* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in);
static void _math_buttons_button_menu_position_func_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
GType math_variable_popup_get_type (void) G_GNUC_CONST;
MathVariablePopup* math_variable_popup_new (MathEquation* equation);
MathVariablePopup* math_variable_popup_construct (GType object_type, MathEquation* equation);
static void ______lambda19_ (MathButtons* self, GtkMenuItem* widget);
static void _______lambda19__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ______lambda20_ (MathButtons* self, GtkMenuItem* widget);
static void _______lambda20__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
GType math_function_popup_get_type (void) G_GNUC_CONST;
MathFunctionPopup* math_function_popup_new (MathEquation* equation);
MathFunctionPopup* math_function_popup_construct (GType object_type, MathEquation* equation);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gchar** _vala_array_dup6 (gchar** self, int length);
static gchar** _vala_array_dup7 (gchar** self, int length);
static gchar** _vala_array_dup8 (gchar** self, int length);
static gchar** _vala_array_dup9 (gchar** self, int length);
static gchar** _vala_array_dup10 (gchar** self, int length);
static void math_buttons_remove_trailing_spaces (MathButtons* self);
void math_buttons_set_mode (MathButtons* self, ButtonMode value);
void math_converter_set_category (MathConverter* self, const gchar* category);
void math_converter_set_conversion (MathConverter* self, const gchar* unit_a, const gchar* unit_b);
static void math_buttons_finalize (GObject* obj);
static void _vala_math_buttons_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_math_buttons_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* MATH_BUTTONS_ctrm_entries[3] = {"ctrm_pint", "ctrm_fv", "ctrm_pv"};
static const gchar* MATH_BUTTONS_ddb_entries[3] = {"ddb_cost", "ddb_life", "ddb_period"};
static const gchar* MATH_BUTTONS_fv_entries[3] = {"fv_pmt", "fv_pint", "fv_n"};
static const gchar* MATH_BUTTONS_gpm_entries[2] = {"gpm_cost", "gpm_margin"};
static const gchar* MATH_BUTTONS_pmt_entries[3] = {"pmt_prin", "pmt_pint", "pmt_n"};
static const gchar* MATH_BUTTONS_pv_entries[3] = {"pv_pmt", "pv_pint", "pv_n"};
static const gchar* MATH_BUTTONS_rate_entries[3] = {"rate_fv", "rate_pv", "rate_n"};
static const gchar* MATH_BUTTONS_sln_entries[3] = {"sln_cost", "sln_salvage", "sln_life"};
static const gchar* MATH_BUTTONS_syd_entries[3] = {"syd_cost", "syd_salvage", "syd_life"};
static const gchar* MATH_BUTTONS_term_entries[3] = {"term_pmt", "term_fv", "term_pint"};

GType button_mode_get_type (void) {
	static volatile gsize button_mode_type_id__volatile = 0;
	if (g_once_init_enter (&button_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{BUTTON_MODE_BASIC, "BUTTON_MODE_BASIC", "basic"}, {BUTTON_MODE_ADVANCED, "BUTTON_MODE_ADVANCED", "advanced"}, {BUTTON_MODE_FINANCIAL, "BUTTON_MODE_FINANCIAL", "financial"}, {BUTTON_MODE_PROGRAMMING, "BUTTON_MODE_PROGRAMMING", "programming"}, {BUTTON_MODE_KEYBOARD, "BUTTON_MODE_KEYBOARD", "keyboard"}, {0, NULL, NULL}};
		GType button_mode_type_id;
		button_mode_type_id = g_enum_register_static ("ButtonMode", values);
		g_once_init_leave (&button_mode_type_id__volatile, button_mode_type_id);
	}
	return button_mode_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _math_buttons_load_buttons_gtk_widget_show (GtkWidget* _sender, gpointer self) {
	math_buttons_load_buttons ((MathButtons*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda23_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void ___lambda23__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda23_ ((MathButtons*) self, pspec);
}


static void __lambda24_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_number_mode_changed_cb (self);
}


static void ___lambda24__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda24_ ((MathButtons*) self, pspec);
}


static void __lambda25_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void ___lambda25__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda25_ ((MathButtons*) self, pspec);
}


static void __lambda26_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void ___lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda26_ ((MathButtons*) self, pspec);
}


MathButtons* math_buttons_construct (GType object_type, MathEquation* equation) {
	MathButtons * self = NULL;
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	MathEquation* _tmp2_ = NULL;
	MathEquation* _tmp3_ = NULL;
	MathEquation* _tmp4_ = NULL;
	MathEquation* _tmp5_ = NULL;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathButtons*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, NULL);
	gtk_box_set_spacing ((GtkBox*) self, 6);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) _math_buttons_load_buttons_gtk_widget_show, self, 0);
	_tmp0_ = equation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->equation);
	self->priv->equation = _tmp1_;
	_tmp2_ = equation;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::display", (GCallback) ___lambda23__g_object_notify, self, 0);
	_tmp3_ = equation;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::number-mode", (GCallback) ___lambda24__g_object_notify, self, 0);
	_tmp4_ = equation;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::angle-units", (GCallback) ___lambda25__g_object_notify, self, 0);
	_tmp5_ = equation;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::number-format", (GCallback) ___lambda26__g_object_notify, self, 0);
	math_buttons_number_mode_changed_cb (self);
	math_buttons_update_bit_panel (self);
	return self;
}


MathButtons* math_buttons_new (MathEquation* equation) {
	return math_buttons_construct (TYPE_MATH_BUTTONS, equation);
}


static void math_buttons_load_finc_dialogs (MathButtons* self) {
	g_return_if_fail (self != NULL);
	math_buttons_load_finc_dialog (self, "ctrm_dialog", MATH_BUTTONS_ctrm_entries, G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries), FINANCIAL_DIALOG_CTRM_DIALOG);
	math_buttons_load_finc_dialog (self, "ddb_dialog", MATH_BUTTONS_ddb_entries, G_N_ELEMENTS (MATH_BUTTONS_ddb_entries), FINANCIAL_DIALOG_DDB_DIALOG);
	math_buttons_load_finc_dialog (self, "fv_dialog", MATH_BUTTONS_fv_entries, G_N_ELEMENTS (MATH_BUTTONS_fv_entries), FINANCIAL_DIALOG_FV_DIALOG);
	math_buttons_load_finc_dialog (self, "gpm_dialog", MATH_BUTTONS_gpm_entries, G_N_ELEMENTS (MATH_BUTTONS_gpm_entries), FINANCIAL_DIALOG_GPM_DIALOG);
	math_buttons_load_finc_dialog (self, "pmt_dialog", MATH_BUTTONS_pmt_entries, G_N_ELEMENTS (MATH_BUTTONS_pmt_entries), FINANCIAL_DIALOG_PMT_DIALOG);
	math_buttons_load_finc_dialog (self, "pv_dialog", MATH_BUTTONS_pv_entries, G_N_ELEMENTS (MATH_BUTTONS_pv_entries), FINANCIAL_DIALOG_PV_DIALOG);
	math_buttons_load_finc_dialog (self, "rate_dialog", MATH_BUTTONS_rate_entries, G_N_ELEMENTS (MATH_BUTTONS_rate_entries), FINANCIAL_DIALOG_RATE_DIALOG);
	math_buttons_load_finc_dialog (self, "sln_dialog", MATH_BUTTONS_sln_entries, G_N_ELEMENTS (MATH_BUTTONS_sln_entries), FINANCIAL_DIALOG_SLN_DIALOG);
	math_buttons_load_finc_dialog (self, "syd_dialog", MATH_BUTTONS_syd_entries, G_N_ELEMENTS (MATH_BUTTONS_syd_entries), FINANCIAL_DIALOG_SYD_DIALOG);
	math_buttons_load_finc_dialog (self, "term_dialog", MATH_BUTTONS_term_entries, G_N_ELEMENTS (MATH_BUTTONS_term_entries), FINANCIAL_DIALOG_TERM_DIALOG);
}


static void _math_buttons_finc_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	math_buttons_finc_response_cb ((MathButtons*) self, _sender, response_id);
}


static void _math_buttons_finc_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	math_buttons_finc_activate_cb ((MathButtons*) self, _sender);
}


static void math_buttons_load_finc_dialog (MathButtons* self, const gchar* name, gchar** entry_names, int entry_names_length1, FinancialDialog function) {
	GtkDialog* dialog = NULL;
	GtkBuilder* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	GtkDialog* _tmp3_ = NULL;
	GtkDialog* _tmp4_ = NULL;
	FinancialDialog _tmp5_ = 0;
	GtkDialog* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->financial_ui;
	_tmp1_ = name;
	_tmp2_ = gtk_builder_get_object (_tmp0_, _tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp2_) : NULL);
	dialog = _tmp3_;
	_tmp4_ = dialog;
	_tmp5_ = function;
	g_object_set_data_full ((GObject*) _tmp4_, "finc-function", (gpointer) ((gintptr) ((gint) _tmp5_)), NULL);
	_tmp6_ = dialog;
	g_signal_connect_object (_tmp6_, "response", (GCallback) _math_buttons_finc_response_cb_gtk_dialog_response, self, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				GtkEntry* entry = NULL;
				GtkBuilder* _tmp11_ = NULL;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gint _tmp13_ = 0;
				const gchar* _tmp14_ = NULL;
				GObject* _tmp15_ = NULL;
				GtkEntry* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				GtkEntry* _tmp25_ = NULL;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = entry_names;
				_tmp10__length1 = entry_names_length1;
				if (!(_tmp9_ < _tmp10__length1)) {
					break;
				}
				_tmp11_ = self->priv->financial_ui;
				_tmp12_ = entry_names;
				_tmp12__length1 = entry_names_length1;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_];
				_tmp15_ = gtk_builder_get_object (_tmp11_, _tmp14_);
				_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp15_) : NULL);
				entry = _tmp16_;
				_tmp17_ = i;
				if (_tmp17_ != (G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries) - 1)) {
					GtkEntry* _tmp18_ = NULL;
					GtkBuilder* _tmp19_ = NULL;
					gchar** _tmp20_ = NULL;
					gint _tmp20__length1 = 0;
					gint _tmp21_ = 0;
					const gchar* _tmp22_ = NULL;
					GObject* _tmp23_ = NULL;
					GtkEntry* _tmp24_ = NULL;
					_tmp18_ = entry;
					_tmp19_ = self->priv->financial_ui;
					_tmp20_ = entry_names;
					_tmp20__length1 = entry_names_length1;
					_tmp21_ = i;
					_tmp22_ = _tmp20_[_tmp21_ + 1];
					_tmp23_ = gtk_builder_get_object (_tmp19_, _tmp22_);
					_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp23_) : NULL);
					g_object_set_data_full ((GObject*) _tmp18_, "next-entry", _tmp24_, g_object_unref);
				}
				_tmp25_ = entry;
				g_signal_connect_object (_tmp25_, "activate", (GCallback) _math_buttons_finc_activate_cb_gtk_entry_activate, self, 0);
				_g_object_unref0 (entry);
			}
		}
	}
	_g_object_unref0 (dialog);
}


static void math_buttons_update_bit_panel (MathButtons* self) {
	GtkWidget* _tmp0_ = NULL;
	Number* x = NULL;
	MathEquation* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	guint64 bits = 0ULL;
	gboolean enabled = FALSE;
	Number* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GtkWidget* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	GtkLabel* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gint i = 0;
	GList* _tmp25_ = NULL;
	gint number_base = 0;
	MathEquation* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gchar* label = NULL;
	gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp44_ = 0;
	gint _tmp53_ = 0;
	GtkLabel* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bit_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->equation;
	_tmp2_ = math_equation_get_number (_tmp1_);
	_tmp3_ = _tmp2_;
	x = _tmp3_;
	bits = (guint64) 0;
	_tmp4_ = x;
	enabled = _tmp4_ != NULL;
	_tmp5_ = enabled;
	if (_tmp5_) {
		Number* max = NULL;
		Number* _tmp6_ = NULL;
		Number* fraction = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		Number* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		_tmp6_ = number_new_unsigned_integer (G_MAXUINT64);
		max = _tmp6_;
		_tmp7_ = x;
		_tmp8_ = number_fractional_part (_tmp7_);
		fraction = _tmp8_;
		_tmp11_ = x;
		_tmp12_ = number_is_negative (_tmp11_);
		if (_tmp12_) {
			_tmp10_ = TRUE;
		} else {
			Number* _tmp13_ = NULL;
			Number* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			_tmp13_ = x;
			_tmp14_ = max;
			_tmp15_ = number_compare (_tmp13_, _tmp14_);
			_tmp10_ = _tmp15_ > 0;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			Number* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			_tmp16_ = fraction;
			_tmp17_ = number_is_zero (_tmp16_);
			_tmp9_ = !_tmp17_;
		}
		if (_tmp9_) {
			enabled = FALSE;
		} else {
			Number* _tmp18_ = NULL;
			guint64 _tmp19_ = 0ULL;
			_tmp18_ = x;
			_tmp19_ = number_to_unsigned_integer (_tmp18_);
			bits = _tmp19_;
		}
		_g_object_unref0 (fraction);
		_g_object_unref0 (max);
	}
	_tmp20_ = self->priv->bit_panel;
	_tmp21_ = enabled;
	gtk_widget_set_sensitive (_tmp20_, _tmp21_);
	_tmp22_ = self->priv->base_label;
	_tmp23_ = enabled;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp22_, _tmp23_);
	_tmp24_ = enabled;
	if (!_tmp24_) {
		_g_object_unref0 (x);
		return;
	}
	i = 0;
	_tmp25_ = self->priv->bit_labels;
	{
		GList* label_collection = NULL;
		GList* label_it = NULL;
		label_collection = _tmp25_;
		for (label_it = label_collection; label_it != NULL; label_it = label_it->next) {
			GtkLabel* _tmp26_ = NULL;
			GtkLabel* label = NULL;
			_tmp26_ = _g_object_ref0 ((GtkLabel*) label_it->data);
			label = _tmp26_;
			{
				gchar* text = NULL;
				gchar* _tmp27_ = NULL;
				guint64 _tmp28_ = 0ULL;
				gint _tmp29_ = 0;
				GtkLabel* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				_tmp27_ = g_strdup (" 0");
				text = _tmp27_;
				_tmp28_ = bits;
				_tmp29_ = i;
				if ((_tmp28_ & (1LL << _tmp29_)) != ((guint64) 0)) {
					gchar* _tmp30_ = NULL;
					_tmp30_ = g_strdup (" 1");
					_g_free0 (text);
					text = _tmp30_;
				}
				_tmp31_ = label;
				_tmp32_ = text;
				gtk_label_set_text (_tmp31_, _tmp32_);
				_tmp33_ = i;
				i = _tmp33_ + 1;
				_g_free0 (text);
				_g_object_unref0 (label);
			}
		}
	}
	_tmp34_ = self->priv->equation;
	_tmp35_ = math_equation_get_number_base (_tmp34_);
	_tmp36_ = _tmp35_;
	number_base = _tmp36_;
	_tmp37_ = g_strdup ("");
	label = _tmp37_;
	_tmp38_ = number_base;
	if (_tmp38_ != 8) {
		const gchar* _tmp39_ = NULL;
		guint64 _tmp40_ = 0ULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		_tmp39_ = label;
		_tmp40_ = bits;
		_tmp41_ = g_strdup_printf ("%llo₈", _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_strconcat (_tmp39_, _tmp42_, NULL);
		_g_free0 (label);
		label = _tmp43_;
		_g_free0 (_tmp42_);
	}
	_tmp44_ = number_base;
	if (_tmp44_ != 10) {
		const gchar* _tmp45_ = NULL;
		const gchar* _tmp48_ = NULL;
		guint64 _tmp49_ = 0ULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		_tmp45_ = label;
		if (g_strcmp0 (_tmp45_, "") != 0) {
			const gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
			_tmp46_ = label;
			_tmp47_ = g_strconcat (_tmp46_, " = ", NULL);
			_g_free0 (label);
			label = _tmp47_;
		}
		_tmp48_ = label;
		_tmp49_ = bits;
		_tmp50_ = g_strdup_printf ("%llu₁₀", _tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_strconcat (_tmp48_, _tmp51_, NULL);
		_g_free0 (label);
		label = _tmp52_;
		_g_free0 (_tmp51_);
	}
	_tmp53_ = number_base;
	if (_tmp53_ != 16) {
		const gchar* _tmp54_ = NULL;
		const gchar* _tmp57_ = NULL;
		guint64 _tmp58_ = 0ULL;
		gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		_tmp54_ = label;
		if (g_strcmp0 (_tmp54_, "") != 0) {
			const gchar* _tmp55_ = NULL;
			gchar* _tmp56_ = NULL;
			_tmp55_ = label;
			_tmp56_ = g_strconcat (_tmp55_, " = ", NULL);
			_g_free0 (label);
			label = _tmp56_;
		}
		_tmp57_ = label;
		_tmp58_ = bits;
		_tmp59_ = g_strdup_printf ("%llX₁₆", _tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = g_strconcat (_tmp57_, _tmp60_, NULL);
		_g_free0 (label);
		label = _tmp61_;
		_g_free0 (_tmp60_);
	}
	_tmp62_ = self->priv->base_label;
	_tmp63_ = label;
	gtk_label_set_text (_tmp62_, _tmp63_);
	_g_free0 (label);
	_g_object_unref0 (x);
}


static void math_buttons_base_combobox_changed_cb (MathButtons* self, GtkComboBox* combo) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gint value = 0;
	GtkTreeIter _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = combo;
	gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	_tmp5_ = iter;
	gtk_tree_model_get (model, &_tmp5_, 1, &value, -1, -1);
	math_buttons_set_programming_base (self, value);
	_g_object_unref0 (model);
}


static void math_buttons_base_changed_cb (MathButtons* self) {
	ButtonMode _tmp0_ = 0;
	ButtonMode _tmp1_ = 0;
	MathEquation* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeIter iter = {0};
	gboolean valid = FALSE;
	GtkTreeModel* _tmp8_ = NULL;
	GtkTreeIter _tmp9_ = {0};
	gboolean _tmp10_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GtkComboBox* _tmp23_ = NULL;
	GtkTreeIter _tmp24_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = math_buttons_get_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != BUTTON_MODE_PROGRAMMING) {
		return;
	}
	_tmp2_ = self->priv->equation;
	_tmp3_ = math_equation_get_number_base (_tmp2_);
	_tmp4_ = _tmp3_;
	self->priv->_programming_base = _tmp4_;
	_tmp5_ = self->priv->base_combo;
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	model = _tmp7_;
	_tmp8_ = model;
	_tmp10_ = gtk_tree_model_get_iter_first (_tmp8_, &_tmp9_);
	iter = _tmp9_;
	valid = _tmp10_;
	while (TRUE) {
		gboolean _tmp11_ = FALSE;
		gint v = 0;
		GtkTreeModel* _tmp12_ = NULL;
		GtkTreeIter _tmp13_ = {0};
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		GtkTreeModel* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		_tmp11_ = valid;
		if (!_tmp11_) {
			break;
		}
		_tmp12_ = model;
		_tmp13_ = iter;
		gtk_tree_model_get (_tmp12_, &_tmp13_, 1, &v, -1, -1);
		_tmp14_ = v;
		_tmp15_ = math_buttons_get_programming_base (self);
		_tmp16_ = _tmp15_;
		if (_tmp14_ == _tmp16_) {
			break;
		}
		_tmp17_ = model;
		_tmp18_ = gtk_tree_model_iter_next (_tmp17_, &iter);
		valid = _tmp18_;
	}
	_tmp19_ = valid;
	if (!_tmp19_) {
		GtkTreeModel* _tmp20_ = NULL;
		GtkTreeIter _tmp21_ = {0};
		gboolean _tmp22_ = FALSE;
		_tmp20_ = model;
		_tmp22_ = gtk_tree_model_get_iter_first (_tmp20_, &_tmp21_);
		iter = _tmp21_;
		valid = _tmp22_;
	}
	_tmp23_ = self->priv->base_combo;
	_tmp24_ = iter;
	gtk_combo_box_set_active_iter (_tmp23_, &_tmp24_);
	_g_object_unref0 (model);
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static void ______lambda9_ (MathButtons* self, GtkButton* widget) {
	MathEquation* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "calc_digit");
	math_equation_insert_digit (_tmp0_, (guint) ((gint) ((gintptr) _tmp2_)));
}


static void _______lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	______lambda9_ ((MathButtons*) self, _sender);
}


static void ___lambda10_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_insert_subtract (_tmp0_);
}


static void ____lambda10__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda10_ ((MathButtons*) self);
}


static void ___lambda11_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_insert_square (_tmp0_);
}


static void ____lambda11__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda11_ ((MathButtons*) self);
}


static void ___lambda12_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	gtk_source_buffer_undo ((GtkSourceBuffer*) _tmp0_);
}


static void ____lambda12__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda12_ ((MathButtons*) self);
}


static void ___lambda13_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_solve (_tmp0_);
}


static void ____lambda13__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda13_ ((MathButtons*) self);
}


static void ___lambda14_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_clear (_tmp0_);
}


static void ____lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda14_ ((MathButtons*) self);
}


static void _math_buttons_memory_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_memory_cb ((MathButtons*) self, _sender);
}


static void _math_buttons_function_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_function_cb ((MathButtons*) self, _sender);
}


static void ___lambda17_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_factorize (_tmp0_);
}


static void ____lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda17_ ((MathButtons*) self);
}


static void ___lambda18_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_insert_exponent (_tmp0_);
}


static void ____lambda18__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda18_ ((MathButtons*) self);
}


static void _math_buttons_shift_left_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_shift_left_cb ((MathButtons*) self, _sender);
}


static void _math_buttons_shift_right_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_shift_right_cb ((MathButtons*) self, _sender);
}


static void _math_buttons_insert_character_code_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_insert_character_code_cb ((MathButtons*) self, _sender);
}


static void ___lambda21_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_insert_numeric_point (_tmp0_);
}


static void ____lambda21__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda21_ ((MathButtons*) self);
}


static void _math_buttons_set_superscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_set_superscript_cb ((MathButtons*) self, _sender);
}


static void _math_buttons_set_subscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_set_subscript_cb ((MathButtons*) self, _sender);
}


static void _math_buttons_character_code_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	math_buttons_character_code_dialog_response_cb ((MathButtons*) self, _sender, response_id);
}


static gboolean _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = math_buttons_character_code_dialog_delete_cb ((MathButtons*) self, _sender, event);
	return result;
}


static void _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	math_buttons_character_code_dialog_activate_cb ((MathButtons*) self, _sender);
}


static gboolean _math_buttons_bit_toggle_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = math_buttons_bit_toggle_cb ((MathButtons*) self, _sender, event);
	return result;
}


static void _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	math_buttons_base_combobox_changed_cb ((MathButtons*) self, _sender);
}


static void ___lambda22_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_base_changed_cb (self);
}


static void ____lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda22_ ((MathButtons*) self, pspec);
}


static void _math_buttons_finc_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_finc_cb ((MathButtons*) self, _sender);
}


static GtkWidget* math_buttons_load_mode (MathButtons* self, ButtonMode mode) {
	GtkWidget* result = NULL;
	GtkBuilder* builder = NULL;
	gchar* builder_resource = NULL;
	ButtonMode _tmp0_ = 0;
	GtkWidget* panel = NULL;
	GtkBuilder* _tmp34_ = NULL;
	GObject* _tmp35_ = NULL;
	GtkWidget* _tmp36_ = NULL;
	GtkWidget* _tmp37_ = NULL;
	ButtonMode _tmp38_ = 0;
	GtkBuilder* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	GtkBuilder* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	GtkBuilder* _tmp51_ = NULL;
	GtkBuilder* _tmp52_ = NULL;
	GtkBuilder* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	GtkBuilder* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	GtkBuilder* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	GtkBuilder* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	GtkBuilder* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	GtkBuilder* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	GtkBuilder* _tmp65_ = NULL;
	const gchar* _tmp66_ = NULL;
	GtkBuilder* _tmp67_ = NULL;
	const gchar* _tmp68_ = NULL;
	GtkBuilder* _tmp69_ = NULL;
	const gchar* _tmp70_ = NULL;
	GtkBuilder* _tmp71_ = NULL;
	const gchar* _tmp72_ = NULL;
	GtkBuilder* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	GtkBuilder* _tmp75_ = NULL;
	const gchar* _tmp76_ = NULL;
	GtkBuilder* _tmp77_ = NULL;
	const gchar* _tmp78_ = NULL;
	GtkBuilder* _tmp79_ = NULL;
	const gchar* _tmp80_ = NULL;
	GtkBuilder* _tmp81_ = NULL;
	const gchar* _tmp82_ = NULL;
	GtkBuilder* _tmp83_ = NULL;
	const gchar* _tmp84_ = NULL;
	GtkBuilder* _tmp85_ = NULL;
	const gchar* _tmp86_ = NULL;
	GtkBuilder* _tmp87_ = NULL;
	const gchar* _tmp88_ = NULL;
	GtkBuilder* _tmp89_ = NULL;
	const gchar* _tmp90_ = NULL;
	GtkBuilder* _tmp91_ = NULL;
	const gchar* _tmp92_ = NULL;
	GtkBuilder* _tmp93_ = NULL;
	const gchar* _tmp94_ = NULL;
	GtkBuilder* _tmp95_ = NULL;
	const gchar* _tmp96_ = NULL;
	GtkBuilder* _tmp97_ = NULL;
	const gchar* _tmp98_ = NULL;
	GtkBuilder* _tmp99_ = NULL;
	const gchar* _tmp100_ = NULL;
	GtkBuilder* _tmp101_ = NULL;
	const gchar* _tmp102_ = NULL;
	GtkBuilder* _tmp103_ = NULL;
	const gchar* _tmp104_ = NULL;
	GtkBuilder* _tmp105_ = NULL;
	const gchar* _tmp106_ = NULL;
	GtkBuilder* _tmp107_ = NULL;
	const gchar* _tmp108_ = NULL;
	GtkBuilder* _tmp109_ = NULL;
	const gchar* _tmp110_ = NULL;
	GtkBuilder* _tmp111_ = NULL;
	const gchar* _tmp112_ = NULL;
	GtkBuilder* _tmp113_ = NULL;
	const gchar* _tmp114_ = NULL;
	GtkBuilder* _tmp115_ = NULL;
	const gchar* _tmp116_ = NULL;
	GtkBuilder* _tmp117_ = NULL;
	const gchar* _tmp118_ = NULL;
	GtkBuilder* _tmp119_ = NULL;
	const gchar* _tmp120_ = NULL;
	GtkBuilder* _tmp121_ = NULL;
	const gchar* _tmp122_ = NULL;
	GtkBuilder* _tmp123_ = NULL;
	const gchar* _tmp124_ = NULL;
	GtkBuilder* _tmp125_ = NULL;
	const gchar* _tmp126_ = NULL;
	GtkBuilder* _tmp127_ = NULL;
	const gchar* _tmp128_ = NULL;
	GtkBuilder* _tmp129_ = NULL;
	const gchar* _tmp130_ = NULL;
	GtkBuilder* _tmp131_ = NULL;
	const gchar* _tmp132_ = NULL;
	GtkBuilder* _tmp133_ = NULL;
	const gchar* _tmp134_ = NULL;
	GtkBuilder* _tmp135_ = NULL;
	const gchar* _tmp136_ = NULL;
	GtkBuilder* _tmp137_ = NULL;
	const gchar* _tmp138_ = NULL;
	GtkBuilder* _tmp139_ = NULL;
	const gchar* _tmp140_ = NULL;
	GtkBuilder* _tmp141_ = NULL;
	const gchar* _tmp142_ = NULL;
	GtkBuilder* _tmp143_ = NULL;
	const gchar* _tmp144_ = NULL;
	GtkBuilder* _tmp145_ = NULL;
	const gchar* _tmp146_ = NULL;
	GtkBuilder* _tmp147_ = NULL;
	const gchar* _tmp148_ = NULL;
	GtkBuilder* _tmp149_ = NULL;
	const gchar* _tmp150_ = NULL;
	GtkBuilder* _tmp151_ = NULL;
	const gchar* _tmp152_ = NULL;
	GtkBuilder* _tmp153_ = NULL;
	const gchar* _tmp154_ = NULL;
	GtkBuilder* _tmp155_ = NULL;
	const gchar* _tmp156_ = NULL;
	GtkBuilder* _tmp157_ = NULL;
	const gchar* _tmp158_ = NULL;
	GtkBuilder* _tmp159_ = NULL;
	const gchar* _tmp160_ = NULL;
	GtkBuilder* _tmp161_ = NULL;
	const gchar* _tmp162_ = NULL;
	GtkBuilder* _tmp163_ = NULL;
	const gchar* _tmp164_ = NULL;
	GtkButton* button = NULL;
	GtkBuilder* _tmp184_ = NULL;
	GObject* _tmp185_ = NULL;
	GtkButton* _tmp186_ = NULL;
	GtkButton* _tmp187_ = NULL;
	GtkBuilder* _tmp189_ = NULL;
	GObject* _tmp190_ = NULL;
	GtkButton* _tmp191_ = NULL;
	GtkButton* _tmp192_ = NULL;
	GtkBuilder* _tmp196_ = NULL;
	GObject* _tmp197_ = NULL;
	GtkButton* _tmp198_ = NULL;
	GtkButton* _tmp199_ = NULL;
	GtkBuilder* _tmp201_ = NULL;
	GObject* _tmp202_ = NULL;
	GtkButton* _tmp203_ = NULL;
	GtkButton* _tmp204_ = NULL;
	GtkBuilder* _tmp206_ = NULL;
	GObject* _tmp207_ = NULL;
	GtkButton* _tmp208_ = NULL;
	GtkButton* _tmp209_ = NULL;
	GtkBuilder* _tmp211_ = NULL;
	GObject* _tmp212_ = NULL;
	GtkButton* _tmp213_ = NULL;
	GtkButton* _tmp214_ = NULL;
	GtkBuilder* _tmp216_ = NULL;
	GObject* _tmp217_ = NULL;
	GtkButton* _tmp218_ = NULL;
	GtkButton* _tmp219_ = NULL;
	GtkBuilder* _tmp221_ = NULL;
	GObject* _tmp222_ = NULL;
	GtkButton* _tmp223_ = NULL;
	GtkButton* _tmp224_ = NULL;
	GtkBuilder* _tmp226_ = NULL;
	GObject* _tmp227_ = NULL;
	GtkButton* _tmp228_ = NULL;
	GtkButton* _tmp229_ = NULL;
	GtkBuilder* _tmp231_ = NULL;
	GObject* _tmp232_ = NULL;
	GtkButton* _tmp233_ = NULL;
	GtkButton* _tmp234_ = NULL;
	GtkBuilder* _tmp236_ = NULL;
	GObject* _tmp237_ = NULL;
	GtkButton* _tmp238_ = NULL;
	GtkButton* _tmp239_ = NULL;
	GtkBuilder* _tmp241_ = NULL;
	GObject* _tmp242_ = NULL;
	GtkButton* _tmp243_ = NULL;
	GtkButton* _tmp244_ = NULL;
	GtkBuilder* _tmp246_ = NULL;
	GObject* _tmp247_ = NULL;
	GtkButton* _tmp248_ = NULL;
	GtkButton* _tmp249_ = NULL;
	GtkToggleButton* toggle_button = NULL;
	GtkBuilder* _tmp258_ = NULL;
	GObject* _tmp259_ = NULL;
	GtkToggleButton* _tmp260_ = NULL;
	GtkToggleButton* _tmp261_ = NULL;
	GtkBuilder* _tmp269_ = NULL;
	GObject* _tmp270_ = NULL;
	GtkToggleButton* _tmp271_ = NULL;
	GtkToggleButton* _tmp272_ = NULL;
	ButtonMode _tmp280_ = 0;
	ButtonMode _tmp348_ = 0;
	GtkBuilder* _tmp419_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = mode;
	switch (_tmp0_) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkWidget* _tmp1_ = NULL;
			GtkBuilder* _tmp4_ = NULL;
			GtkBuilder* _tmp5_ = NULL;
			GtkBuilder* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			_tmp1_ = self->priv->bas_panel;
			if (_tmp1_ != NULL) {
				GtkWidget* _tmp2_ = NULL;
				GtkWidget* _tmp3_ = NULL;
				_tmp2_ = self->priv->bas_panel;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				result = _tmp3_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp4_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->basic_ui);
			self->priv->basic_ui = _tmp4_;
			_tmp5_ = self->priv->basic_ui;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			_g_object_unref0 (builder);
			builder = _tmp6_;
			_tmp7_ = g_strdup ("buttons-basic.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp7_;
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkWidget* _tmp8_ = NULL;
			GtkBuilder* _tmp11_ = NULL;
			GtkBuilder* _tmp12_ = NULL;
			GtkBuilder* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			_tmp8_ = self->priv->adv_panel;
			if (_tmp8_ != NULL) {
				GtkWidget* _tmp9_ = NULL;
				GtkWidget* _tmp10_ = NULL;
				_tmp9_ = self->priv->adv_panel;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				result = _tmp10_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp11_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->advanced_ui);
			self->priv->advanced_ui = _tmp11_;
			_tmp12_ = self->priv->advanced_ui;
			_tmp13_ = _g_object_ref0 (_tmp12_);
			_g_object_unref0 (builder);
			builder = _tmp13_;
			_tmp14_ = g_strdup ("buttons-advanced.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp14_;
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkWidget* _tmp15_ = NULL;
			GtkBuilder* _tmp18_ = NULL;
			GtkBuilder* _tmp19_ = NULL;
			GtkBuilder* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			_tmp15_ = self->priv->fin_panel;
			if (_tmp15_ != NULL) {
				GtkWidget* _tmp16_ = NULL;
				GtkWidget* _tmp17_ = NULL;
				_tmp16_ = self->priv->fin_panel;
				_tmp17_ = _g_object_ref0 (_tmp16_);
				result = _tmp17_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp18_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->financial_ui);
			self->priv->financial_ui = _tmp18_;
			_tmp19_ = self->priv->financial_ui;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_g_object_unref0 (builder);
			builder = _tmp20_;
			_tmp21_ = g_strdup ("buttons-financial.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp21_;
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkWidget* _tmp22_ = NULL;
			GtkBuilder* _tmp25_ = NULL;
			GtkBuilder* _tmp26_ = NULL;
			GtkBuilder* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			_tmp22_ = self->priv->prog_panel;
			if (_tmp22_ != NULL) {
				GtkWidget* _tmp23_ = NULL;
				GtkWidget* _tmp24_ = NULL;
				_tmp23_ = self->priv->prog_panel;
				_tmp24_ = _g_object_ref0 (_tmp23_);
				result = _tmp24_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp25_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->programming_ui);
			self->priv->programming_ui = _tmp25_;
			_tmp26_ = self->priv->programming_ui;
			_tmp27_ = _g_object_ref0 (_tmp26_);
			_g_object_unref0 (builder);
			builder = _tmp27_;
			_tmp28_ = g_strdup ("buttons-programming.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp28_;
			break;
		}
	}
	{
		GtkBuilder* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		_tmp29_ = builder;
		_tmp30_ = builder_resource;
		_tmp31_ = g_strdup_printf ("/org/gnome/calculator/%s", _tmp30_);
		_tmp32_ = _tmp31_;
		gtk_builder_add_from_resource (_tmp29_, _tmp32_, &_inner_error_);
		_g_free0 (_tmp32_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp33_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp33_ = e->message;
		g_error ("math-buttons.vala:267: Error loading button UI: %s", _tmp33_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (builder_resource);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp34_ = builder;
	_tmp35_ = gtk_builder_get_object (_tmp34_, "button_panel");
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp35_) : NULL);
	panel = _tmp36_;
	_tmp37_ = panel;
	gtk_box_pack_end ((GtkBox*) self, _tmp37_, TRUE, TRUE, (guint) 0);
	_tmp38_ = mode;
	switch (_tmp38_) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkWidget* _tmp39_ = NULL;
			GtkWidget* _tmp40_ = NULL;
			_tmp39_ = panel;
			_tmp40_ = _g_object_ref0 (_tmp39_);
			_g_object_unref0 (self->priv->bas_panel);
			self->priv->bas_panel = _tmp40_;
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkWidget* _tmp41_ = NULL;
			GtkWidget* _tmp42_ = NULL;
			_tmp41_ = panel;
			_tmp42_ = _g_object_ref0 (_tmp41_);
			_g_object_unref0 (self->priv->adv_panel);
			self->priv->adv_panel = _tmp42_;
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkWidget* _tmp43_ = NULL;
			GtkWidget* _tmp44_ = NULL;
			_tmp43_ = panel;
			_tmp44_ = _g_object_ref0 (_tmp43_);
			_g_object_unref0 (self->priv->fin_panel);
			self->priv->fin_panel = _tmp44_;
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkWidget* _tmp45_ = NULL;
			GtkWidget* _tmp46_ = NULL;
			_tmp45_ = panel;
			_tmp46_ = _g_object_ref0 (_tmp45_);
			_g_object_unref0 (self->priv->prog_panel);
			self->priv->prog_panel = _tmp46_;
			break;
		}
	}
	_tmp47_ = builder;
	_tmp48_ = _ ("Pi [Ctrl+P]");
	math_buttons_setup_button (self, _tmp47_, "pi", "π", _tmp48_, TRUE);
	_tmp49_ = builder;
	_tmp50_ = _ ("Euler’s Number");
	math_buttons_setup_button (self, _tmp49_, "eulers_number", "e", _tmp50_, TRUE);
	_tmp51_ = builder;
	math_buttons_setup_button (self, _tmp51_, "imaginary", "i", NULL, TRUE);
	_tmp52_ = builder;
	math_buttons_setup_button (self, _tmp52_, "numeric_point", NULL, NULL, TRUE);
	_tmp53_ = builder;
	_tmp54_ = _ ("Subscript mode [Alt]");
	math_buttons_setup_button (self, _tmp53_, "subscript", NULL, _tmp54_, TRUE);
	_tmp55_ = builder;
	_tmp56_ = _ ("Superscript mode [Ctrl]");
	math_buttons_setup_button (self, _tmp55_, "superscript", NULL, _tmp56_, TRUE);
	_tmp57_ = builder;
	_tmp58_ = _ ("Scientific exponent [Ctrl+E]");
	math_buttons_setup_button (self, _tmp57_, "exponential", NULL, _tmp58_, TRUE);
	_tmp59_ = builder;
	_tmp60_ = _ ("Add [+]");
	math_buttons_setup_button (self, _tmp59_, "add", "+", _tmp60_, TRUE);
	_tmp61_ = builder;
	_tmp62_ = _ ("Subtract [-]");
	math_buttons_setup_button (self, _tmp61_, "subtract", "−", _tmp62_, FALSE);
	_tmp63_ = builder;
	_tmp64_ = _ ("Multiply [*]");
	math_buttons_setup_button (self, _tmp63_, "multiply", "×", _tmp64_, TRUE);
	_tmp65_ = builder;
	_tmp66_ = _ ("Divide [/]");
	math_buttons_setup_button (self, _tmp65_, "divide", "÷", _tmp66_, TRUE);
	_tmp67_ = builder;
	_tmp68_ = _ ("Modulus divide");
	math_buttons_setup_button (self, _tmp67_, "modulus_divide", " mod ", _tmp68_, TRUE);
	_tmp69_ = builder;
	_tmp70_ = _ ("Additional Functions");
	math_buttons_setup_button (self, _tmp69_, "function", NULL, _tmp70_, TRUE);
	_tmp71_ = builder;
	_tmp72_ = _ ("Exponent [^ or **]");
	math_buttons_setup_button (self, _tmp71_, "x_pow_y", "^", _tmp72_, TRUE);
	_tmp73_ = builder;
	_tmp74_ = _ ("Percentage [%]");
	math_buttons_setup_button (self, _tmp73_, "percentage", "%", _tmp74_, TRUE);
	_tmp75_ = builder;
	_tmp76_ = _ ("Factorial [!]");
	math_buttons_setup_button (self, _tmp75_, "factorial", "!", _tmp76_, TRUE);
	_tmp77_ = builder;
	_tmp78_ = _ ("Absolute value [|]");
	math_buttons_setup_button (self, _tmp77_, "abs", "|", _tmp78_, TRUE);
	_tmp79_ = builder;
	_tmp80_ = _ ("Complex argument");
	math_buttons_setup_button (self, _tmp79_, "arg", "Arg ", _tmp80_, TRUE);
	_tmp81_ = builder;
	_tmp82_ = _ ("Complex conjugate");
	math_buttons_setup_button (self, _tmp81_, "conjugate", "conj ", _tmp82_, TRUE);
	_tmp83_ = builder;
	_tmp84_ = _ ("Root [Ctrl+R]");
	math_buttons_setup_button (self, _tmp83_, "root", "√", _tmp84_, TRUE);
	_tmp85_ = builder;
	_tmp86_ = _ ("Square root [Ctrl+R]");
	math_buttons_setup_button (self, _tmp85_, "square_root", "√", _tmp86_, TRUE);
	_tmp87_ = builder;
	_tmp88_ = _ ("Logarithm");
	math_buttons_setup_button (self, _tmp87_, "logarithm", "log ", _tmp88_, TRUE);
	_tmp89_ = builder;
	_tmp90_ = _ ("Natural Logarithm");
	math_buttons_setup_button (self, _tmp89_, "natural_logarithm", "ln ", _tmp90_, TRUE);
	_tmp91_ = builder;
	_tmp92_ = _ ("Sine");
	math_buttons_setup_button (self, _tmp91_, "sine", "sin ", _tmp92_, TRUE);
	_tmp93_ = builder;
	_tmp94_ = _ ("Cosine");
	math_buttons_setup_button (self, _tmp93_, "cosine", "cos ", _tmp94_, TRUE);
	_tmp95_ = builder;
	_tmp96_ = _ ("Tangent");
	math_buttons_setup_button (self, _tmp95_, "tangent", "tan ", _tmp96_, TRUE);
	_tmp97_ = builder;
	_tmp98_ = _ ("Hyperbolic Sine");
	math_buttons_setup_button (self, _tmp97_, "hyperbolic_sine", "sinh ", _tmp98_, TRUE);
	_tmp99_ = builder;
	_tmp100_ = _ ("Hyperbolic Cosine");
	math_buttons_setup_button (self, _tmp99_, "hyperbolic_cosine", "cosh ", _tmp100_, TRUE);
	_tmp101_ = builder;
	_tmp102_ = _ ("Hyperbolic Tangent");
	math_buttons_setup_button (self, _tmp101_, "hyperbolic_tangent", "tanh ", _tmp102_, TRUE);
	_tmp103_ = builder;
	_tmp104_ = _ ("Inverse [Ctrl+I]");
	math_buttons_setup_button (self, _tmp103_, "inverse", "⁻¹", _tmp104_, TRUE);
	_tmp105_ = builder;
	_tmp106_ = _ ("Boolean AND");
	math_buttons_setup_button (self, _tmp105_, "and", "∧", _tmp106_, TRUE);
	_tmp107_ = builder;
	_tmp108_ = _ ("Boolean OR");
	math_buttons_setup_button (self, _tmp107_, "or", "∨", _tmp108_, TRUE);
	_tmp109_ = builder;
	_tmp110_ = _ ("Boolean Exclusive OR");
	math_buttons_setup_button (self, _tmp109_, "xor", "⊻", _tmp110_, TRUE);
	_tmp111_ = builder;
	_tmp112_ = _ ("Boolean NOT");
	math_buttons_setup_button (self, _tmp111_, "not", "¬", _tmp112_, TRUE);
	_tmp113_ = builder;
	_tmp114_ = _ ("Integer Component");
	math_buttons_setup_button (self, _tmp113_, "integer_portion", "int ", _tmp114_, TRUE);
	_tmp115_ = builder;
	_tmp116_ = _ ("Fractional Component");
	math_buttons_setup_button (self, _tmp115_, "fractional_portion", "frac ", _tmp116_, TRUE);
	_tmp117_ = builder;
	_tmp118_ = _ ("Real Component");
	math_buttons_setup_button (self, _tmp117_, "real_portion", "Re ", _tmp118_, TRUE);
	_tmp119_ = builder;
	_tmp120_ = _ ("Imaginary Component");
	math_buttons_setup_button (self, _tmp119_, "imaginary_portion", "Im ", _tmp120_, TRUE);
	_tmp121_ = builder;
	_tmp122_ = _ ("Ones' Complement");
	math_buttons_setup_button (self, _tmp121_, "ones_complement", "ones ", _tmp122_, TRUE);
	_tmp123_ = builder;
	_tmp124_ = _ ("Two's Complement");
	math_buttons_setup_button (self, _tmp123_, "twos_complement", "twos ", _tmp124_, TRUE);
	_tmp125_ = builder;
	_tmp126_ = _ ("Start Group [(]");
	math_buttons_setup_button (self, _tmp125_, "start_group", "(", _tmp126_, TRUE);
	_tmp127_ = builder;
	_tmp128_ = _ ("End Group [)]");
	math_buttons_setup_button (self, _tmp127_, "end_group", ")", _tmp128_, TRUE);
	_tmp129_ = builder;
	_tmp130_ = _ ("Memory");
	math_buttons_setup_button (self, _tmp129_, "memory", NULL, _tmp130_, TRUE);
	_tmp131_ = builder;
	_tmp132_ = _ ("Insert Character Code");
	math_buttons_setup_button (self, _tmp131_, "character", NULL, _tmp132_, TRUE);
	_tmp133_ = builder;
	_tmp134_ = _ ("Calculate Result");
	math_buttons_setup_button (self, _tmp133_, "result", NULL, _tmp134_, TRUE);
	_tmp135_ = builder;
	_tmp136_ = _ ("Factorize [Ctrl+F]");
	math_buttons_setup_button (self, _tmp135_, "factor", NULL, _tmp136_, TRUE);
	_tmp137_ = builder;
	_tmp138_ = _ ("Clear Display [Escape]");
	math_buttons_setup_button (self, _tmp137_, "clear", NULL, _tmp138_, TRUE);
	_tmp139_ = builder;
	_tmp140_ = _ ("Undo [Ctrl+Z]");
	math_buttons_setup_button (self, _tmp139_, "undo", NULL, _tmp140_, TRUE);
	_tmp141_ = builder;
	_tmp142_ = _ ("Shift Left");
	math_buttons_setup_button (self, _tmp141_, "shift_left", NULL, _tmp142_, TRUE);
	_tmp143_ = builder;
	_tmp144_ = _ ("Shift Right");
	math_buttons_setup_button (self, _tmp143_, "shift_right", NULL, _tmp144_, TRUE);
	_tmp145_ = builder;
	_tmp146_ = _ ("Compounding Term");
	math_buttons_setup_button (self, _tmp145_, "finc_compounding_term", NULL, _tmp146_, TRUE);
	_tmp147_ = builder;
	_tmp148_ = _ ("Double Declining Depreciation");
	math_buttons_setup_button (self, _tmp147_, "finc_double_declining_depreciation", NULL, _tmp148_, TRUE);
	_tmp149_ = builder;
	_tmp150_ = _ ("Future Value");
	math_buttons_setup_button (self, _tmp149_, "finc_future_value", NULL, _tmp150_, TRUE);
	_tmp151_ = builder;
	_tmp152_ = _ ("Financial Term");
	math_buttons_setup_button (self, _tmp151_, "finc_term", NULL, _tmp152_, TRUE);
	_tmp153_ = builder;
	_tmp154_ = _ ("Sum of the Years Digits Depreciation");
	math_buttons_setup_button (self, _tmp153_, "finc_sum_of_the_years_digits_depreciation", NULL, _tmp154_, TRUE);
	_tmp155_ = builder;
	_tmp156_ = _ ("Straight Line Depreciation");
	math_buttons_setup_button (self, _tmp155_, "finc_straight_line_depreciation", NULL, _tmp156_, TRUE);
	_tmp157_ = builder;
	_tmp158_ = _ ("Periodic Interest Rate");
	math_buttons_setup_button (self, _tmp157_, "finc_periodic_interest_rate", NULL, _tmp158_, TRUE);
	_tmp159_ = builder;
	_tmp160_ = _ ("Present Value");
	math_buttons_setup_button (self, _tmp159_, "finc_present_value", NULL, _tmp160_, TRUE);
	_tmp161_ = builder;
	_tmp162_ = _ ("Periodic Payment");
	math_buttons_setup_button (self, _tmp161_, "finc_periodic_payment", NULL, _tmp162_, TRUE);
	_tmp163_ = builder;
	_tmp164_ = _ ("Gross Profit Margin");
	math_buttons_setup_button (self, _tmp163_, "finc_gross_profit_margin", NULL, _tmp164_, TRUE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp165_ = FALSE;
			_tmp165_ = TRUE;
			while (TRUE) {
				gint _tmp167_ = 0;
				gchar* name = NULL;
				gint _tmp168_ = 0;
				gchar* _tmp169_ = NULL;
				GtkButton* button = NULL;
				GtkBuilder* _tmp170_ = NULL;
				const gchar* _tmp171_ = NULL;
				GObject* _tmp172_ = NULL;
				GtkButton* _tmp173_ = NULL;
				GtkButton* _tmp174_ = NULL;
				if (!_tmp165_) {
					gint _tmp166_ = 0;
					_tmp166_ = i;
					i = _tmp166_ + 1;
				}
				_tmp165_ = FALSE;
				_tmp167_ = i;
				if (!(_tmp167_ < 16)) {
					break;
				}
				_tmp168_ = i;
				_tmp169_ = g_strdup_printf ("calc_%d_button", _tmp168_);
				name = _tmp169_;
				_tmp170_ = builder;
				_tmp171_ = name;
				_tmp172_ = gtk_builder_get_object (_tmp170_, _tmp171_);
				_tmp173_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp172_, gtk_button_get_type ()) ? ((GtkButton*) _tmp172_) : NULL);
				button = _tmp173_;
				_tmp174_ = button;
				if (_tmp174_ != NULL) {
					GtkButton* _tmp175_ = NULL;
					gint _tmp176_ = 0;
					GtkButton* _tmp177_ = NULL;
					MathEquation* _tmp178_ = NULL;
					gint _tmp179_ = 0;
					gunichar _tmp180_ = 0U;
					gchar* _tmp181_ = NULL;
					gchar* _tmp182_ = NULL;
					GtkButton* _tmp183_ = NULL;
					_tmp175_ = button;
					_tmp176_ = i;
					g_object_set_data_full ((GObject*) _tmp175_, "calc_digit", (gpointer) ((gintptr) _tmp176_), NULL);
					_tmp177_ = button;
					_tmp178_ = self->priv->equation;
					_tmp179_ = i;
					_tmp180_ = math_equation_get_digit_text (_tmp178_, (guint) _tmp179_);
					_tmp181_ = g_unichar_to_string (_tmp180_);
					_tmp182_ = _tmp181_;
					gtk_button_set_label (_tmp177_, _tmp182_);
					_g_free0 (_tmp182_);
					_tmp183_ = button;
					g_signal_connect_object (_tmp183_, "clicked", (GCallback) _______lambda9__gtk_button_clicked, self, 0);
				}
				_g_object_unref0 (button);
				_g_free0 (name);
			}
		}
	}
	_tmp184_ = builder;
	_tmp185_ = gtk_builder_get_object (_tmp184_, "calc_subtract_button");
	_tmp186_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp185_, gtk_button_get_type ()) ? ((GtkButton*) _tmp185_) : NULL);
	button = _tmp186_;
	_tmp187_ = button;
	if (_tmp187_ != NULL) {
		GtkButton* _tmp188_ = NULL;
		_tmp188_ = button;
		g_signal_connect_object (_tmp188_, "clicked", (GCallback) ____lambda10__gtk_button_clicked, self, 0);
	}
	_tmp189_ = builder;
	_tmp190_ = gtk_builder_get_object (_tmp189_, "calc_x_squared_button");
	_tmp191_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp190_, gtk_button_get_type ()) ? ((GtkButton*) _tmp190_) : NULL);
	_g_object_unref0 (button);
	button = _tmp191_;
	_tmp192_ = button;
	if (_tmp192_ != NULL) {
		GtkButton* _tmp193_ = NULL;
		GtkButton* _tmp194_ = NULL;
		const gchar* _tmp195_ = NULL;
		_tmp193_ = button;
		g_signal_connect_object (_tmp193_, "clicked", (GCallback) ____lambda11__gtk_button_clicked, self, 0);
		_tmp194_ = button;
		_tmp195_ = _ ("Square [Ctrl+2]");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp194_, _tmp195_);
	}
	_tmp196_ = builder;
	_tmp197_ = gtk_builder_get_object (_tmp196_, "calc_undo_button");
	_tmp198_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp197_, gtk_button_get_type ()) ? ((GtkButton*) _tmp197_) : NULL);
	_g_object_unref0 (button);
	button = _tmp198_;
	_tmp199_ = button;
	if (_tmp199_ != NULL) {
		GtkButton* _tmp200_ = NULL;
		_tmp200_ = button;
		g_signal_connect_object (_tmp200_, "clicked", (GCallback) ____lambda12__gtk_button_clicked, self, 0);
	}
	_tmp201_ = builder;
	_tmp202_ = gtk_builder_get_object (_tmp201_, "calc_result_button");
	_tmp203_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp202_, gtk_button_get_type ()) ? ((GtkButton*) _tmp202_) : NULL);
	_g_object_unref0 (button);
	button = _tmp203_;
	_tmp204_ = button;
	if (_tmp204_ != NULL) {
		GtkButton* _tmp205_ = NULL;
		_tmp205_ = button;
		g_signal_connect_object (_tmp205_, "clicked", (GCallback) ____lambda13__gtk_button_clicked, self, 0);
	}
	_tmp206_ = builder;
	_tmp207_ = gtk_builder_get_object (_tmp206_, "calc_clear_button");
	_tmp208_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp207_, gtk_button_get_type ()) ? ((GtkButton*) _tmp207_) : NULL);
	_g_object_unref0 (button);
	button = _tmp208_;
	_tmp209_ = button;
	if (_tmp209_ != NULL) {
		GtkButton* _tmp210_ = NULL;
		_tmp210_ = button;
		g_signal_connect_object (_tmp210_, "clicked", (GCallback) ____lambda14__gtk_button_clicked, self, 0);
	}
	_tmp211_ = builder;
	_tmp212_ = gtk_builder_get_object (_tmp211_, "calc_memory_button");
	_tmp213_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp212_, gtk_button_get_type ()) ? ((GtkButton*) _tmp212_) : NULL);
	_g_object_unref0 (button);
	button = _tmp213_;
	_tmp214_ = button;
	if (_tmp214_ != NULL) {
		GtkButton* _tmp215_ = NULL;
		_tmp215_ = button;
		g_signal_connect_object (_tmp215_, "clicked", (GCallback) _math_buttons_memory_cb_gtk_button_clicked, self, 0);
	}
	_tmp216_ = builder;
	_tmp217_ = gtk_builder_get_object (_tmp216_, "calc_function_button");
	_tmp218_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp217_, gtk_button_get_type ()) ? ((GtkButton*) _tmp217_) : NULL);
	_g_object_unref0 (button);
	button = _tmp218_;
	_tmp219_ = button;
	if (_tmp219_ != NULL) {
		GtkButton* _tmp220_ = NULL;
		_tmp220_ = button;
		g_signal_connect_object (_tmp220_, "clicked", (GCallback) _math_buttons_function_cb_gtk_button_clicked, self, 0);
	}
	_tmp221_ = builder;
	_tmp222_ = gtk_builder_get_object (_tmp221_, "calc_factor_button");
	_tmp223_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp222_, gtk_button_get_type ()) ? ((GtkButton*) _tmp222_) : NULL);
	_g_object_unref0 (button);
	button = _tmp223_;
	_tmp224_ = button;
	if (_tmp224_ != NULL) {
		GtkButton* _tmp225_ = NULL;
		_tmp225_ = button;
		g_signal_connect_object (_tmp225_, "clicked", (GCallback) ____lambda17__gtk_button_clicked, self, 0);
	}
	_tmp226_ = builder;
	_tmp227_ = gtk_builder_get_object (_tmp226_, "calc_exponential_button");
	_tmp228_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp227_, gtk_button_get_type ()) ? ((GtkButton*) _tmp227_) : NULL);
	_g_object_unref0 (button);
	button = _tmp228_;
	_tmp229_ = button;
	if (_tmp229_ != NULL) {
		GtkButton* _tmp230_ = NULL;
		_tmp230_ = button;
		g_signal_connect_object (_tmp230_, "clicked", (GCallback) ____lambda18__gtk_button_clicked, self, 0);
	}
	_tmp231_ = builder;
	_tmp232_ = gtk_builder_get_object (_tmp231_, "calc_shift_left_button");
	_tmp233_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp232_, gtk_button_get_type ()) ? ((GtkButton*) _tmp232_) : NULL);
	_g_object_unref0 (button);
	button = _tmp233_;
	_tmp234_ = button;
	if (_tmp234_ != NULL) {
		GtkButton* _tmp235_ = NULL;
		_tmp235_ = button;
		g_signal_connect_object (_tmp235_, "clicked", (GCallback) _math_buttons_shift_left_cb_gtk_button_clicked, self, 0);
	}
	_tmp236_ = builder;
	_tmp237_ = gtk_builder_get_object (_tmp236_, "calc_shift_right_button");
	_tmp238_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp237_, gtk_button_get_type ()) ? ((GtkButton*) _tmp237_) : NULL);
	_g_object_unref0 (button);
	button = _tmp238_;
	_tmp239_ = button;
	if (_tmp239_ != NULL) {
		GtkButton* _tmp240_ = NULL;
		_tmp240_ = button;
		g_signal_connect_object (_tmp240_, "clicked", (GCallback) _math_buttons_shift_right_cb_gtk_button_clicked, self, 0);
	}
	_tmp241_ = builder;
	_tmp242_ = gtk_builder_get_object (_tmp241_, "calc_character_button");
	_tmp243_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp242_, gtk_button_get_type ()) ? ((GtkButton*) _tmp242_) : NULL);
	_g_object_unref0 (button);
	button = _tmp243_;
	_tmp244_ = button;
	if (_tmp244_ != NULL) {
		GtkButton* _tmp245_ = NULL;
		_tmp245_ = button;
		g_signal_connect_object (_tmp245_, "clicked", (GCallback) _math_buttons_insert_character_code_cb_gtk_button_clicked, self, 0);
	}
	_tmp246_ = builder;
	_tmp247_ = gtk_builder_get_object (_tmp246_, "calc_numeric_point_button");
	_tmp248_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp247_, gtk_button_get_type ()) ? ((GtkButton*) _tmp247_) : NULL);
	_g_object_unref0 (button);
	button = _tmp248_;
	_tmp249_ = button;
	if (_tmp249_ != NULL) {
		GtkButton* _tmp250_ = NULL;
		MathEquation* _tmp251_ = NULL;
		Serializer* _tmp252_ = NULL;
		Serializer* _tmp253_ = NULL;
		gunichar _tmp254_ = 0U;
		gchar* _tmp255_ = NULL;
		gchar* _tmp256_ = NULL;
		GtkButton* _tmp257_ = NULL;
		_tmp250_ = button;
		_tmp251_ = self->priv->equation;
		_tmp252_ = math_equation_get_serializer (_tmp251_);
		_tmp253_ = _tmp252_;
		_tmp254_ = serializer_get_radix (_tmp253_);
		_tmp255_ = g_unichar_to_string (_tmp254_);
		_tmp256_ = _tmp255_;
		gtk_button_set_label (_tmp250_, _tmp256_);
		_g_free0 (_tmp256_);
		_tmp257_ = button;
		g_signal_connect_object (_tmp257_, "clicked", (GCallback) ____lambda21__gtk_button_clicked, self, 0);
	}
	_tmp258_ = builder;
	_tmp259_ = gtk_builder_get_object (_tmp258_, "calc_superscript_button");
	_tmp260_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp259_, gtk_toggle_button_get_type ()) ? ((GtkToggleButton*) _tmp259_) : NULL);
	toggle_button = _tmp260_;
	_tmp261_ = toggle_button;
	if (_tmp261_ != NULL) {
		GtkToggleButton* _tmp262_ = NULL;
		GtkToggleButton* _tmp263_ = NULL;
		MathEquation* _tmp264_ = NULL;
		NumberMode _tmp265_ = 0;
		NumberMode _tmp266_ = 0;
		GtkToggleButton* _tmp268_ = NULL;
		_tmp262_ = toggle_button;
		_tmp263_ = _g_object_ref0 (_tmp262_);
		self->priv->superscript_toggles = g_list_append (self->priv->superscript_toggles, _tmp263_);
		_tmp264_ = self->priv->equation;
		_tmp265_ = math_equation_get_number_mode (_tmp264_);
		_tmp266_ = _tmp265_;
		if (_tmp266_ == NUMBER_MODE_SUPERSCRIPT) {
			GtkToggleButton* _tmp267_ = NULL;
			_tmp267_ = toggle_button;
			gtk_toggle_button_set_active (_tmp267_, TRUE);
		}
		_tmp268_ = toggle_button;
		g_signal_connect_object ((GtkButton*) _tmp268_, "clicked", (GCallback) _math_buttons_set_superscript_cb_gtk_button_clicked, self, 0);
	}
	_tmp269_ = builder;
	_tmp270_ = gtk_builder_get_object (_tmp269_, "calc_subscript_button");
	_tmp271_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp270_, gtk_toggle_button_get_type ()) ? ((GtkToggleButton*) _tmp270_) : NULL);
	_g_object_unref0 (toggle_button);
	toggle_button = _tmp271_;
	_tmp272_ = toggle_button;
	if (_tmp272_ != NULL) {
		GtkToggleButton* _tmp273_ = NULL;
		GtkToggleButton* _tmp274_ = NULL;
		MathEquation* _tmp275_ = NULL;
		NumberMode _tmp276_ = 0;
		NumberMode _tmp277_ = 0;
		GtkToggleButton* _tmp279_ = NULL;
		_tmp273_ = toggle_button;
		_tmp274_ = _g_object_ref0 (_tmp273_);
		self->priv->subscript_toggles = g_list_append (self->priv->subscript_toggles, _tmp274_);
		_tmp275_ = self->priv->equation;
		_tmp276_ = math_equation_get_number_mode (_tmp275_);
		_tmp277_ = _tmp276_;
		if (_tmp277_ == NUMBER_MODE_SUBSCRIPT) {
			GtkToggleButton* _tmp278_ = NULL;
			_tmp278_ = toggle_button;
			gtk_toggle_button_set_active (_tmp278_, TRUE);
		}
		_tmp279_ = toggle_button;
		g_signal_connect_object ((GtkButton*) _tmp279_, "clicked", (GCallback) _math_buttons_set_subscript_cb_gtk_button_clicked, self, 0);
	}
	_tmp280_ = mode;
	if (_tmp280_ == BUTTON_MODE_PROGRAMMING) {
		GtkBuilder* _tmp281_ = NULL;
		GObject* _tmp282_ = NULL;
		GtkLabel* _tmp283_ = NULL;
		GtkBuilder* _tmp284_ = NULL;
		GObject* _tmp285_ = NULL;
		GtkDialog* _tmp286_ = NULL;
		GtkDialog* _tmp287_ = NULL;
		GtkDialog* _tmp288_ = NULL;
		GtkBuilder* _tmp289_ = NULL;
		GObject* _tmp290_ = NULL;
		GtkEntry* _tmp291_ = NULL;
		GtkEntry* _tmp292_ = NULL;
		GtkBuilder* _tmp293_ = NULL;
		GObject* _tmp294_ = NULL;
		GtkWidget* _tmp295_ = NULL;
		gint i = 0;
		GtkBuilder* _tmp315_ = NULL;
		GObject* _tmp316_ = NULL;
		GtkComboBox* _tmp317_ = NULL;
		GtkListStore* model = NULL;
		GtkListStore* _tmp318_ = NULL;
		GtkComboBox* _tmp319_ = NULL;
		GtkListStore* _tmp320_ = NULL;
		GtkTreeIter iter = {0};
		GtkListStore* _tmp321_ = NULL;
		GtkTreeIter _tmp322_ = {0};
		GtkListStore* _tmp323_ = NULL;
		GtkTreeIter _tmp324_ = {0};
		const gchar* _tmp325_ = NULL;
		GtkListStore* _tmp326_ = NULL;
		GtkTreeIter _tmp327_ = {0};
		GtkListStore* _tmp328_ = NULL;
		GtkTreeIter _tmp329_ = {0};
		const gchar* _tmp330_ = NULL;
		GtkListStore* _tmp331_ = NULL;
		GtkTreeIter _tmp332_ = {0};
		GtkListStore* _tmp333_ = NULL;
		GtkTreeIter _tmp334_ = {0};
		const gchar* _tmp335_ = NULL;
		GtkListStore* _tmp336_ = NULL;
		GtkTreeIter _tmp337_ = {0};
		GtkListStore* _tmp338_ = NULL;
		GtkTreeIter _tmp339_ = {0};
		const gchar* _tmp340_ = NULL;
		GtkCellRendererText* renderer = NULL;
		GtkCellRendererText* _tmp341_ = NULL;
		GtkComboBox* _tmp342_ = NULL;
		GtkCellRendererText* _tmp343_ = NULL;
		GtkComboBox* _tmp344_ = NULL;
		GtkCellRendererText* _tmp345_ = NULL;
		GtkComboBox* _tmp346_ = NULL;
		MathEquation* _tmp347_ = NULL;
		_tmp281_ = builder;
		_tmp282_ = gtk_builder_get_object (_tmp281_, "base_label");
		_tmp283_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp282_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp282_) : NULL);
		_g_object_unref0 (self->priv->base_label);
		self->priv->base_label = _tmp283_;
		_tmp284_ = builder;
		_tmp285_ = gtk_builder_get_object (_tmp284_, "character_code_dialog");
		_tmp286_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp285_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp285_) : NULL);
		_g_object_unref0 (self->priv->character_code_dialog);
		self->priv->character_code_dialog = _tmp286_;
		_tmp287_ = self->priv->character_code_dialog;
		g_signal_connect_object (_tmp287_, "response", (GCallback) _math_buttons_character_code_dialog_response_cb_gtk_dialog_response, self, 0);
		_tmp288_ = self->priv->character_code_dialog;
		g_signal_connect_object ((GtkWidget*) _tmp288_, "delete-event", (GCallback) _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event, self, 0);
		_tmp289_ = builder;
		_tmp290_ = gtk_builder_get_object (_tmp289_, "character_code_entry");
		_tmp291_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp290_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp290_) : NULL);
		_g_object_unref0 (self->priv->character_code_entry);
		self->priv->character_code_entry = _tmp291_;
		_tmp292_ = self->priv->character_code_entry;
		g_signal_connect_object (_tmp292_, "activate", (GCallback) _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate, self, 0);
		_tmp293_ = builder;
		_tmp294_ = gtk_builder_get_object (_tmp293_, "bit_table");
		_tmp295_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp294_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp294_) : NULL);
		_g_object_unref0 (self->priv->bit_panel);
		self->priv->bit_panel = _tmp295_;
		__g_list_free__g_object_unref0_0 (self->priv->bit_labels);
		self->priv->bit_labels = NULL;
		i = 0;
		while (TRUE) {
			gchar* name = NULL;
			gint _tmp296_ = 0;
			gchar* _tmp297_ = NULL;
			GtkLabel* label = NULL;
			GtkBuilder* _tmp298_ = NULL;
			const gchar* _tmp299_ = NULL;
			GObject* _tmp300_ = NULL;
			GtkLabel* _tmp301_ = NULL;
			GtkLabel* _tmp302_ = NULL;
			GtkLabel* _tmp303_ = NULL;
			GtkLabel* _tmp304_ = NULL;
			gint _tmp305_ = 0;
			gchar* _tmp306_ = NULL;
			GtkEventBox* box = NULL;
			GtkBuilder* _tmp307_ = NULL;
			const gchar* _tmp308_ = NULL;
			GObject* _tmp309_ = NULL;
			GtkEventBox* _tmp310_ = NULL;
			GtkEventBox* _tmp311_ = NULL;
			gint _tmp312_ = 0;
			GtkEventBox* _tmp313_ = NULL;
			gint _tmp314_ = 0;
			_tmp296_ = i;
			_tmp297_ = g_strdup_printf ("bit_label_%d", _tmp296_);
			name = _tmp297_;
			_tmp298_ = builder;
			_tmp299_ = name;
			_tmp300_ = gtk_builder_get_object (_tmp298_, _tmp299_);
			_tmp301_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp300_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp300_) : NULL);
			label = _tmp301_;
			_tmp302_ = label;
			if (_tmp302_ == NULL) {
				_g_object_unref0 (label);
				_g_free0 (name);
				break;
			}
			_tmp303_ = label;
			_tmp304_ = _g_object_ref0 (_tmp303_);
			self->priv->bit_labels = g_list_append (self->priv->bit_labels, _tmp304_);
			_tmp305_ = i;
			_tmp306_ = g_strdup_printf ("bit_eventbox_%d", _tmp305_);
			_g_free0 (name);
			name = _tmp306_;
			_tmp307_ = builder;
			_tmp308_ = name;
			_tmp309_ = gtk_builder_get_object (_tmp307_, _tmp308_);
			_tmp310_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp309_, gtk_event_box_get_type ()) ? ((GtkEventBox*) _tmp309_) : NULL);
			box = _tmp310_;
			_tmp311_ = box;
			_tmp312_ = i;
			g_object_set_data_full ((GObject*) _tmp311_, "bit_index", (gpointer) ((gintptr) _tmp312_), NULL);
			_tmp313_ = box;
			g_signal_connect_object ((GtkWidget*) _tmp313_, "button-press-event", (GCallback) _math_buttons_bit_toggle_cb_gtk_widget_button_press_event, self, 0);
			_tmp314_ = i;
			i = _tmp314_ + 1;
			_g_object_unref0 (box);
			_g_object_unref0 (label);
			_g_free0 (name);
		}
		self->priv->bit_labels = g_list_reverse (self->priv->bit_labels);
		_tmp315_ = builder;
		_tmp316_ = gtk_builder_get_object (_tmp315_, "base_combo");
		_tmp317_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp316_, gtk_combo_box_get_type ()) ? ((GtkComboBox*) _tmp316_) : NULL);
		_g_object_unref0 (self->priv->base_combo);
		self->priv->base_combo = _tmp317_;
		_tmp318_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT, -1);
		model = _tmp318_;
		_tmp319_ = self->priv->base_combo;
		_tmp320_ = model;
		gtk_combo_box_set_model (_tmp319_, (GtkTreeModel*) _tmp320_);
		_tmp321_ = model;
		gtk_list_store_append (_tmp321_, &_tmp322_);
		iter = _tmp322_;
		_tmp323_ = model;
		_tmp324_ = iter;
		_tmp325_ = _ ("Binary");
		gtk_list_store_set (_tmp323_, &_tmp324_, 0, _tmp325_, 1, 2, -1, -1);
		_tmp326_ = model;
		gtk_list_store_append (_tmp326_, &_tmp327_);
		iter = _tmp327_;
		_tmp328_ = model;
		_tmp329_ = iter;
		_tmp330_ = _ ("Octal");
		gtk_list_store_set (_tmp328_, &_tmp329_, 0, _tmp330_, 1, 8, -1, -1);
		_tmp331_ = model;
		gtk_list_store_append (_tmp331_, &_tmp332_);
		iter = _tmp332_;
		_tmp333_ = model;
		_tmp334_ = iter;
		_tmp335_ = _ ("Decimal");
		gtk_list_store_set (_tmp333_, &_tmp334_, 0, _tmp335_, 1, 10, -1, -1);
		_tmp336_ = model;
		gtk_list_store_append (_tmp336_, &_tmp337_);
		iter = _tmp337_;
		_tmp338_ = model;
		_tmp339_ = iter;
		_tmp340_ = _ ("Hexadecimal");
		gtk_list_store_set (_tmp338_, &_tmp339_, 0, _tmp340_, 1, 16, -1, -1);
		_tmp341_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		g_object_ref_sink (_tmp341_);
		renderer = _tmp341_;
		_tmp342_ = self->priv->base_combo;
		_tmp343_ = renderer;
		gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp342_, (GtkCellRenderer*) _tmp343_, TRUE);
		_tmp344_ = self->priv->base_combo;
		_tmp345_ = renderer;
		gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp344_, (GtkCellRenderer*) _tmp345_, "text", 0);
		_tmp346_ = self->priv->base_combo;
		g_signal_connect_object (_tmp346_, "changed", (GCallback) _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed, self, 0);
		_tmp347_ = self->priv->equation;
		g_signal_connect_object ((GObject*) _tmp347_, "notify::number-base", (GCallback) ____lambda22__g_object_notify, self, 0);
		math_buttons_base_changed_cb (self);
		_g_object_unref0 (renderer);
		_g_object_unref0 (model);
	}
	_tmp348_ = mode;
	if (_tmp348_ == BUTTON_MODE_FINANCIAL) {
		GtkBuilder* _tmp349_ = NULL;
		GObject* _tmp350_ = NULL;
		GtkButton* _tmp351_ = NULL;
		GtkButton* _tmp352_ = NULL;
		GtkBuilder* _tmp356_ = NULL;
		GObject* _tmp357_ = NULL;
		GtkButton* _tmp358_ = NULL;
		GtkButton* _tmp359_ = NULL;
		GtkBuilder* _tmp363_ = NULL;
		GObject* _tmp364_ = NULL;
		GtkButton* _tmp365_ = NULL;
		GtkButton* _tmp366_ = NULL;
		GtkBuilder* _tmp370_ = NULL;
		GObject* _tmp371_ = NULL;
		GtkButton* _tmp372_ = NULL;
		GtkButton* _tmp373_ = NULL;
		GtkBuilder* _tmp377_ = NULL;
		GObject* _tmp378_ = NULL;
		GtkButton* _tmp379_ = NULL;
		GtkButton* _tmp380_ = NULL;
		GtkBuilder* _tmp384_ = NULL;
		GObject* _tmp385_ = NULL;
		GtkButton* _tmp386_ = NULL;
		GtkButton* _tmp387_ = NULL;
		GtkBuilder* _tmp391_ = NULL;
		GObject* _tmp392_ = NULL;
		GtkButton* _tmp393_ = NULL;
		GtkButton* _tmp394_ = NULL;
		GtkBuilder* _tmp398_ = NULL;
		GObject* _tmp399_ = NULL;
		GtkButton* _tmp400_ = NULL;
		GtkButton* _tmp401_ = NULL;
		GtkBuilder* _tmp405_ = NULL;
		GObject* _tmp406_ = NULL;
		GtkButton* _tmp407_ = NULL;
		GtkButton* _tmp408_ = NULL;
		GtkBuilder* _tmp412_ = NULL;
		GObject* _tmp413_ = NULL;
		GtkButton* _tmp414_ = NULL;
		GtkButton* _tmp415_ = NULL;
		math_buttons_load_finc_dialogs (self);
		_tmp349_ = builder;
		_tmp350_ = gtk_builder_get_object (_tmp349_, "calc_finc_compounding_term_button");
		_tmp351_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp350_, gtk_button_get_type ()) ? ((GtkButton*) _tmp350_) : NULL);
		_g_object_unref0 (button);
		button = _tmp351_;
		_tmp352_ = button;
		if (_tmp352_ != NULL) {
			GtkButton* _tmp353_ = NULL;
			gchar* _tmp354_ = NULL;
			GtkButton* _tmp355_ = NULL;
			_tmp353_ = button;
			_tmp354_ = g_strdup ("ctrm_dialog");
			g_object_set_data_full ((GObject*) _tmp353_, "finc-dialog-name", _tmp354_, g_free);
			_tmp355_ = button;
			g_signal_connect_object (_tmp355_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp356_ = builder;
		_tmp357_ = gtk_builder_get_object (_tmp356_, "calc_finc_double_declining_depreciation_button");
		_tmp358_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp357_, gtk_button_get_type ()) ? ((GtkButton*) _tmp357_) : NULL);
		_g_object_unref0 (button);
		button = _tmp358_;
		_tmp359_ = button;
		if (_tmp359_ != NULL) {
			GtkButton* _tmp360_ = NULL;
			gchar* _tmp361_ = NULL;
			GtkButton* _tmp362_ = NULL;
			_tmp360_ = button;
			_tmp361_ = g_strdup ("ddb_dialog");
			g_object_set_data_full ((GObject*) _tmp360_, "finc-dialog-name", _tmp361_, g_free);
			_tmp362_ = button;
			g_signal_connect_object (_tmp362_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp363_ = builder;
		_tmp364_ = gtk_builder_get_object (_tmp363_, "calc_finc_future_value_button");
		_tmp365_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp364_, gtk_button_get_type ()) ? ((GtkButton*) _tmp364_) : NULL);
		_g_object_unref0 (button);
		button = _tmp365_;
		_tmp366_ = button;
		if (_tmp366_ != NULL) {
			GtkButton* _tmp367_ = NULL;
			gchar* _tmp368_ = NULL;
			GtkButton* _tmp369_ = NULL;
			_tmp367_ = button;
			_tmp368_ = g_strdup ("fv_dialog");
			g_object_set_data_full ((GObject*) _tmp367_, "finc-dialog-name", _tmp368_, g_free);
			_tmp369_ = button;
			g_signal_connect_object (_tmp369_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp370_ = builder;
		_tmp371_ = gtk_builder_get_object (_tmp370_, "calc_finc_gross_profit_margin_button");
		_tmp372_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp371_, gtk_button_get_type ()) ? ((GtkButton*) _tmp371_) : NULL);
		_g_object_unref0 (button);
		button = _tmp372_;
		_tmp373_ = button;
		if (_tmp373_ != NULL) {
			GtkButton* _tmp374_ = NULL;
			gchar* _tmp375_ = NULL;
			GtkButton* _tmp376_ = NULL;
			_tmp374_ = button;
			_tmp375_ = g_strdup ("gpm_dialog");
			g_object_set_data_full ((GObject*) _tmp374_, "finc-dialog-name", _tmp375_, g_free);
			_tmp376_ = button;
			g_signal_connect_object (_tmp376_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp377_ = builder;
		_tmp378_ = gtk_builder_get_object (_tmp377_, "calc_finc_periodic_payment_button");
		_tmp379_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp378_, gtk_button_get_type ()) ? ((GtkButton*) _tmp378_) : NULL);
		_g_object_unref0 (button);
		button = _tmp379_;
		_tmp380_ = button;
		if (_tmp380_ != NULL) {
			GtkButton* _tmp381_ = NULL;
			gchar* _tmp382_ = NULL;
			GtkButton* _tmp383_ = NULL;
			_tmp381_ = button;
			_tmp382_ = g_strdup ("pmt_dialog");
			g_object_set_data_full ((GObject*) _tmp381_, "finc-dialog-name", _tmp382_, g_free);
			_tmp383_ = button;
			g_signal_connect_object (_tmp383_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp384_ = builder;
		_tmp385_ = gtk_builder_get_object (_tmp384_, "calc_finc_present_value_button");
		_tmp386_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp385_, gtk_button_get_type ()) ? ((GtkButton*) _tmp385_) : NULL);
		_g_object_unref0 (button);
		button = _tmp386_;
		_tmp387_ = button;
		if (_tmp387_ != NULL) {
			GtkButton* _tmp388_ = NULL;
			gchar* _tmp389_ = NULL;
			GtkButton* _tmp390_ = NULL;
			_tmp388_ = button;
			_tmp389_ = g_strdup ("pv_dialog");
			g_object_set_data_full ((GObject*) _tmp388_, "finc-dialog-name", _tmp389_, g_free);
			_tmp390_ = button;
			g_signal_connect_object (_tmp390_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp391_ = builder;
		_tmp392_ = gtk_builder_get_object (_tmp391_, "calc_finc_periodic_interest_rate_button");
		_tmp393_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp392_, gtk_button_get_type ()) ? ((GtkButton*) _tmp392_) : NULL);
		_g_object_unref0 (button);
		button = _tmp393_;
		_tmp394_ = button;
		if (_tmp394_ != NULL) {
			GtkButton* _tmp395_ = NULL;
			gchar* _tmp396_ = NULL;
			GtkButton* _tmp397_ = NULL;
			_tmp395_ = button;
			_tmp396_ = g_strdup ("rate_dialog");
			g_object_set_data_full ((GObject*) _tmp395_, "finc-dialog-name", _tmp396_, g_free);
			_tmp397_ = button;
			g_signal_connect_object (_tmp397_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp398_ = builder;
		_tmp399_ = gtk_builder_get_object (_tmp398_, "calc_finc_straight_line_depreciation_button");
		_tmp400_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp399_, gtk_button_get_type ()) ? ((GtkButton*) _tmp399_) : NULL);
		_g_object_unref0 (button);
		button = _tmp400_;
		_tmp401_ = button;
		if (_tmp401_ != NULL) {
			GtkButton* _tmp402_ = NULL;
			gchar* _tmp403_ = NULL;
			GtkButton* _tmp404_ = NULL;
			_tmp402_ = button;
			_tmp403_ = g_strdup ("sln_dialog");
			g_object_set_data_full ((GObject*) _tmp402_, "finc-dialog-name", _tmp403_, g_free);
			_tmp404_ = button;
			g_signal_connect_object (_tmp404_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp405_ = builder;
		_tmp406_ = gtk_builder_get_object (_tmp405_, "calc_finc_sum_of_the_years_digits_depreciation_button");
		_tmp407_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp406_, gtk_button_get_type ()) ? ((GtkButton*) _tmp406_) : NULL);
		_g_object_unref0 (button);
		button = _tmp407_;
		_tmp408_ = button;
		if (_tmp408_ != NULL) {
			GtkButton* _tmp409_ = NULL;
			gchar* _tmp410_ = NULL;
			GtkButton* _tmp411_ = NULL;
			_tmp409_ = button;
			_tmp410_ = g_strdup ("syd_dialog");
			g_object_set_data_full ((GObject*) _tmp409_, "finc-dialog-name", _tmp410_, g_free);
			_tmp411_ = button;
			g_signal_connect_object (_tmp411_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp412_ = builder;
		_tmp413_ = gtk_builder_get_object (_tmp412_, "calc_finc_term_button");
		_tmp414_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp413_, gtk_button_get_type ()) ? ((GtkButton*) _tmp413_) : NULL);
		_g_object_unref0 (button);
		button = _tmp414_;
		_tmp415_ = button;
		if (_tmp415_ != NULL) {
			GtkButton* _tmp416_ = NULL;
			gchar* _tmp417_ = NULL;
			GtkButton* _tmp418_ = NULL;
			_tmp416_ = button;
			_tmp417_ = g_strdup ("term_dialog");
			g_object_set_data_full ((GObject*) _tmp416_, "finc-dialog-name", _tmp417_, g_free);
			_tmp418_ = button;
			g_signal_connect_object (_tmp418_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
	}
	_tmp419_ = builder;
	gtk_builder_connect_signals (_tmp419_, self);
	math_buttons_update_bit_panel (self);
	result = panel;
	_g_object_unref0 (toggle_button);
	_g_object_unref0 (button);
	_g_free0 (builder_resource);
	_g_object_unref0 (builder);
	return result;
}


static void ____lambda8_ (MathButtons* self, GtkButton* widget) {
	MathEquation* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "calc_text");
	math_equation_insert (_tmp0_, (const gchar*) _tmp2_);
}


static void _____lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	____lambda8_ ((MathButtons*) self, _sender);
}


static void math_buttons_setup_button (MathButtons* self, GtkBuilder* builder, const gchar* name, const gchar* data, const gchar* tooltip, gboolean connect) {
	gchar* widget_name = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkButton* button = NULL;
	GtkBuilder* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkButton* _tmp19_ = NULL;
	AtkObject* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup_printf ("calc_%s_button", _tmp0_);
	widget_name = _tmp1_;
	_tmp2_ = builder;
	_tmp3_ = widget_name;
	_tmp4_ = gtk_builder_get_object (_tmp2_, _tmp3_);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_button_get_type ()) ? ((GtkButton*) _tmp4_) : NULL);
	button = _tmp5_;
	_tmp6_ = button;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (button);
		_g_free0 (widget_name);
		return;
	}
	_tmp7_ = name;
	if (g_strcmp0 (_tmp7_, "result") == 0) {
		GtkButton* _tmp8_ = NULL;
		GtkStyleContext* _tmp9_ = NULL;
		_tmp8_ = button;
		_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
		gtk_style_context_add_class (_tmp9_, "suggested-action");
	}
	_tmp10_ = data;
	if (_tmp10_ != NULL) {
		GtkButton* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		_tmp11_ = button;
		_tmp12_ = data;
		_tmp13_ = g_strdup (_tmp12_);
		g_object_set_data_full ((GObject*) _tmp11_, "calc_text", _tmp13_, g_free);
		_tmp14_ = connect;
		if (_tmp14_) {
			GtkButton* _tmp15_ = NULL;
			_tmp15_ = button;
			g_signal_connect_object (_tmp15_, "clicked", (GCallback) _____lambda8__gtk_button_clicked, self, 0);
		}
	}
	_tmp16_ = tooltip;
	if (_tmp16_ != NULL) {
		GtkButton* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		_tmp17_ = button;
		_tmp18_ = tooltip;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp17_, _tmp18_);
	}
	_tmp19_ = button;
	_tmp20_ = gtk_widget_get_accessible ((GtkWidget*) _tmp19_);
	_tmp21_ = name;
	atk_object_set_name (_tmp20_, _tmp21_);
	_g_object_unref0 (button);
	_g_free0 (widget_name);
}


static void math_buttons_converter_changed_cb (MathButtons* self) {
	Unit* from_unit = NULL;
	Unit* to_unit = NULL;
	MathConverter* _tmp0_ = NULL;
	Unit* _tmp1_ = NULL;
	Unit* _tmp2_ = NULL;
	ButtonMode _tmp3_ = 0;
	ButtonMode _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->converter;
	math_converter_get_conversion (_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (from_unit);
	from_unit = _tmp1_;
	_g_object_unref0 (to_unit);
	to_unit = _tmp2_;
	_tmp3_ = math_buttons_get_mode (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_FINANCIAL) {
		MathEquation* _tmp5_ = NULL;
		Unit* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		MathEquation* _tmp10_ = NULL;
		Unit* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp5_ = self->priv->equation;
		_tmp6_ = from_unit;
		_tmp7_ = unit_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		math_equation_set_source_currency (_tmp5_, _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = self->priv->equation;
		_tmp11_ = to_unit;
		_tmp12_ = unit_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		math_equation_set_target_currency (_tmp10_, _tmp14_);
		_g_free0 (_tmp14_);
	} else {
		MathEquation* _tmp15_ = NULL;
		Unit* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		MathEquation* _tmp20_ = NULL;
		Unit* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		_tmp15_ = self->priv->equation;
		_tmp16_ = from_unit;
		_tmp17_ = unit_get_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		math_equation_set_source_units (_tmp15_, _tmp19_);
		_g_free0 (_tmp19_);
		_tmp20_ = self->priv->equation;
		_tmp21_ = to_unit;
		_tmp22_ = unit_get_name (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		math_equation_set_target_units (_tmp20_, _tmp24_);
		_g_free0 (_tmp24_);
	}
	_g_object_unref0 (to_unit);
	_g_object_unref0 (from_unit);
}


static void _math_buttons_converter_changed_cb_math_converter_changed (MathConverter* _sender, gpointer self) {
	math_buttons_converter_changed_cb ((MathButtons*) self);
}


static void math_buttons_load_buttons (MathButtons* self) {
	gboolean _tmp0_ = FALSE;
	MathConverter* _tmp1_ = NULL;
	GtkWidget* panel = NULL;
	ButtonMode _tmp6_ = 0;
	ButtonMode _tmp7_ = 0;
	GtkWidget* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkWidget* _tmp11_ = NULL;
	GtkWidget* _tmp13_ = NULL;
	GtkWidget* _tmp14_ = NULL;
	GtkWidget* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->converter;
	if (_tmp1_ == NULL) {
		MathEquation* _tmp2_ = NULL;
		MathConverter* _tmp3_ = NULL;
		MathConverter* _tmp4_ = NULL;
		MathConverter* _tmp5_ = NULL;
		_tmp2_ = self->priv->equation;
		_tmp3_ = math_converter_new (_tmp2_);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->converter);
		self->priv->converter = _tmp3_;
		_tmp4_ = self->priv->converter;
		g_signal_connect_object (_tmp4_, "changed", (GCallback) _math_buttons_converter_changed_cb_math_converter_changed, self, 0);
		_tmp5_ = self->priv->converter;
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp5_, FALSE, TRUE, (guint) 0);
	}
	_tmp6_ = math_buttons_get_mode (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = math_buttons_load_mode (self, _tmp7_);
	panel = _tmp8_;
	_tmp9_ = self->priv->active_panel;
	_tmp10_ = panel;
	if (_tmp9_ == _tmp10_) {
		_g_object_unref0 (panel);
		return;
	}
	_tmp11_ = self->priv->active_panel;
	if (_tmp11_ != NULL) {
		GtkWidget* _tmp12_ = NULL;
		_tmp12_ = self->priv->active_panel;
		gtk_widget_hide (_tmp12_);
	}
	_tmp13_ = panel;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_g_object_unref0 (self->priv->active_panel);
	self->priv->active_panel = _tmp14_;
	_tmp15_ = panel;
	if (_tmp15_ != NULL) {
		GtkWidget* _tmp16_ = NULL;
		_tmp16_ = panel;
		gtk_widget_show (_tmp16_);
	}
	_g_object_unref0 (panel);
}


static void _math_buttons_button_menu_position_func_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	math_buttons_button_menu_position_func ((MathButtons*) self, menu, x, y, push_in);
}


static void math_buttons_popup_button_menu (MathButtons* self, GtkButton* button, GtkMenu* menu) {
	GtkMenu* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkMenu* _tmp3_ = NULL;
	guint32 _tmp4_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = menu;
	_tmp1_ = button;
	_tmp2_ = _g_object_ref0 ((GtkWidget*) _tmp1_);
	g_object_set_data_full ((GObject*) _tmp0_, "button", _tmp2_, g_object_unref);
	_tmp3_ = menu;
	_tmp4_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp3_, NULL, NULL, _math_buttons_button_menu_position_func_gtk_menu_position_func, self, (guint) 1, _tmp4_);
}


static void math_buttons_button_menu_position_func (MathButtons* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _vala_push_in = FALSE;
	GtkButton* button = NULL;
	GtkMenu* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	gint origin_x = 0;
	gint origin_y = 0;
	GdkWindow* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	guint border = 0U;
	guint _tmp6_ = 0U;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp7_ = {0};
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	GtkAllocation _tmp10_ = {0};
	gint _tmp11_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = menu;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "button");
	_tmp2_ = _g_object_ref0 ((GtkButton*) _tmp1_);
	button = _tmp2_;
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) button);
	gdk_window_get_origin (_tmp3_, &_tmp4_, &_tmp5_);
	origin_x = _tmp4_;
	origin_y = _tmp5_;
	_tmp6_ = gtk_container_get_border_width ((GtkContainer*) button);
	border = _tmp6_;
	gtk_widget_get_allocation ((GtkWidget*) button, &_tmp7_);
	allocation = _tmp7_;
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.x;
	_vala_x = (gint) ((origin_x + _tmp9_) + border);
	_tmp10_ = allocation;
	_tmp11_ = _tmp10_.y;
	_vala_y = (gint) ((origin_y + _tmp11_) + border);
	_vala_push_in = FALSE;
	_g_object_unref0 (button);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (push_in) {
		*push_in = _vala_push_in;
	}
}


static void math_buttons_memory_cb (MathButtons* self, GtkWidget* widget) {
	MathVariablePopup* popup = NULL;
	MathEquation* _tmp0_ = NULL;
	MathVariablePopup* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkAllocation allocation = {0};
	GtkWidget* _tmp4_ = NULL;
	GtkAllocation _tmp5_ = {0};
	gint x = 0;
	gint y = 0;
	GtkWidget* _tmp6_ = NULL;
	GdkWindow* _tmp7_ = NULL;
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	GtkAllocation _tmp10_ = {0};
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_variable_popup_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	popup = _tmp1_;
	_tmp2_ = widget;
	_tmp3_ = gtk_widget_get_toplevel (_tmp2_);
	gtk_window_set_transient_for ((GtkWindow*) popup, G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp3_) : NULL);
	_tmp4_ = widget;
	gtk_widget_get_allocation (_tmp4_, &_tmp5_);
	allocation = _tmp5_;
	_tmp6_ = widget;
	_tmp7_ = gtk_widget_get_window (_tmp6_);
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.x;
	_tmp10_ = allocation;
	_tmp11_ = _tmp10_.y;
	gdk_window_get_root_coords (_tmp7_, _tmp9_, _tmp11_, &_tmp12_, &_tmp13_);
	x = _tmp12_;
	y = _tmp13_;
	gtk_window_move ((GtkWindow*) popup, x, y);
	gtk_widget_show ((GtkWidget*) popup);
	_g_object_unref0 (popup);
}


static void ______lambda19_ (MathButtons* self, GtkMenuItem* widget) {
	MathEquation* _tmp0_ = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "shiftcount");
	math_equation_shift (_tmp0_, (gint) ((gintptr) _tmp2_));
}


static void _______lambda19__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	______lambda19_ ((MathButtons*) self, _sender);
}


static void math_buttons_shift_left_cb (MathButtons* self, GtkButton* button) {
	GtkMenu* _tmp0_ = NULL;
	GtkButton* _tmp28_ = NULL;
	GtkMenu* _tmp29_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->shift_left_menu;
	if (_tmp0_ == NULL) {
		GtkMenu* _tmp1_ = NULL;
		GtkMenu* _tmp2_ = NULL;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->shift_left_menu);
		self->priv->shift_left_menu = _tmp1_;
		_tmp2_ = self->priv->shift_left_menu;
		gtk_menu_set_reserve_toggle_size (_tmp2_, FALSE);
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gint _tmp5_ = 0;
					gchar* format = NULL;
					gint _tmp6_ = 0;
					gchar* text = NULL;
					const gchar* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					gchar* _tmp15_ = NULL;
					GtkLabel* label = NULL;
					const gchar* _tmp16_ = NULL;
					GtkLabel* _tmp17_ = NULL;
					GtkMenuItem* item = NULL;
					GtkMenuItem* _tmp18_ = NULL;
					GtkMenuItem* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					GtkMenuItem* _tmp21_ = NULL;
					GtkLabel* _tmp22_ = NULL;
					GtkMenu* _tmp23_ = NULL;
					GtkMenuItem* _tmp24_ = NULL;
					GtkMenuItem* _tmp25_ = NULL;
					GtkLabel* _tmp26_ = NULL;
					GtkMenuItem* _tmp27_ = NULL;
					if (!_tmp3_) {
						gint _tmp4_ = 0;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp5_ = i;
					if (!(_tmp5_ < 16)) {
						break;
					}
					_tmp6_ = i;
					if (_tmp6_ < 10) {
						gint _tmp7_ = 0;
						const gchar* _tmp8_ = NULL;
						gchar* _tmp9_ = NULL;
						_tmp7_ = i;
						_tmp8_ = ngettext ("_%d place", "_%d places", (gulong) _tmp7_);
						_tmp9_ = g_strdup (_tmp8_);
						_g_free0 (format);
						format = _tmp9_;
					} else {
						gint _tmp10_ = 0;
						const gchar* _tmp11_ = NULL;
						gchar* _tmp12_ = NULL;
						_tmp10_ = i;
						_tmp11_ = ngettext ("%d place", "%d places", (gulong) _tmp10_);
						_tmp12_ = g_strdup (_tmp11_);
						_g_free0 (format);
						format = _tmp12_;
					}
					_tmp13_ = format;
					_tmp14_ = i;
					_tmp15_ = g_strdup_printf (_tmp13_, _tmp14_);
					text = _tmp15_;
					_tmp16_ = text;
					_tmp17_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp16_);
					g_object_ref_sink (_tmp17_);
					label = _tmp17_;
					_tmp18_ = (GtkMenuItem*) gtk_menu_item_new ();
					g_object_ref_sink (_tmp18_);
					item = _tmp18_;
					_tmp19_ = item;
					_tmp20_ = i;
					g_object_set_data_full ((GObject*) _tmp19_, "shiftcount", (gpointer) ((gintptr) _tmp20_), NULL);
					_tmp21_ = item;
					_tmp22_ = label;
					gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
					_tmp23_ = self->priv->shift_left_menu;
					_tmp24_ = item;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp23_, (GtkWidget*) _tmp24_);
					_tmp25_ = item;
					g_signal_connect_object (_tmp25_, "activate", (GCallback) _______lambda19__gtk_menu_item_activate, self, 0);
					_tmp26_ = label;
					gtk_widget_show ((GtkWidget*) _tmp26_);
					_tmp27_ = item;
					gtk_widget_show ((GtkWidget*) _tmp27_);
					_g_object_unref0 (item);
					_g_object_unref0 (label);
					_g_free0 (text);
					_g_free0 (format);
				}
			}
		}
	}
	_tmp28_ = button;
	_tmp29_ = self->priv->shift_left_menu;
	math_buttons_popup_button_menu (self, _tmp28_, _tmp29_);
}


static void ______lambda20_ (MathButtons* self, GtkMenuItem* widget) {
	MathEquation* _tmp0_ = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "shiftcount");
	math_equation_shift (_tmp0_, (gint) ((gintptr) _tmp2_));
}


static void _______lambda20__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	______lambda20_ ((MathButtons*) self, _sender);
}


static void math_buttons_shift_right_cb (MathButtons* self, GtkButton* button) {
	GtkMenu* _tmp0_ = NULL;
	GtkButton* _tmp28_ = NULL;
	GtkMenu* _tmp29_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->shift_right_menu;
	if (_tmp0_ == NULL) {
		GtkMenu* _tmp1_ = NULL;
		GtkMenu* _tmp2_ = NULL;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->shift_right_menu);
		self->priv->shift_right_menu = _tmp1_;
		_tmp2_ = self->priv->shift_right_menu;
		gtk_menu_set_reserve_toggle_size (_tmp2_, FALSE);
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gint _tmp5_ = 0;
					gchar* format = NULL;
					gint _tmp6_ = 0;
					gchar* text = NULL;
					const gchar* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					gchar* _tmp15_ = NULL;
					GtkLabel* label = NULL;
					const gchar* _tmp16_ = NULL;
					GtkLabel* _tmp17_ = NULL;
					GtkMenuItem* item = NULL;
					GtkMenuItem* _tmp18_ = NULL;
					GtkMenuItem* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					GtkMenuItem* _tmp21_ = NULL;
					GtkLabel* _tmp22_ = NULL;
					GtkMenu* _tmp23_ = NULL;
					GtkMenuItem* _tmp24_ = NULL;
					GtkMenuItem* _tmp25_ = NULL;
					GtkLabel* _tmp26_ = NULL;
					GtkMenuItem* _tmp27_ = NULL;
					if (!_tmp3_) {
						gint _tmp4_ = 0;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp5_ = i;
					if (!(_tmp5_ < 16)) {
						break;
					}
					_tmp6_ = i;
					if (_tmp6_ < 10) {
						gint _tmp7_ = 0;
						const gchar* _tmp8_ = NULL;
						gchar* _tmp9_ = NULL;
						_tmp7_ = i;
						_tmp8_ = ngettext ("_%d place", "_%d places", (gulong) _tmp7_);
						_tmp9_ = g_strdup (_tmp8_);
						_g_free0 (format);
						format = _tmp9_;
					} else {
						gint _tmp10_ = 0;
						const gchar* _tmp11_ = NULL;
						gchar* _tmp12_ = NULL;
						_tmp10_ = i;
						_tmp11_ = ngettext ("%d place", "%d places", (gulong) _tmp10_);
						_tmp12_ = g_strdup (_tmp11_);
						_g_free0 (format);
						format = _tmp12_;
					}
					_tmp13_ = format;
					_tmp14_ = i;
					_tmp15_ = g_strdup_printf (_tmp13_, _tmp14_);
					text = _tmp15_;
					_tmp16_ = text;
					_tmp17_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp16_);
					g_object_ref_sink (_tmp17_);
					label = _tmp17_;
					_tmp18_ = (GtkMenuItem*) gtk_menu_item_new ();
					g_object_ref_sink (_tmp18_);
					item = _tmp18_;
					_tmp19_ = item;
					_tmp20_ = i;
					g_object_set_data_full ((GObject*) _tmp19_, "shiftcount", (gpointer) ((gintptr) (-_tmp20_)), NULL);
					_tmp21_ = item;
					_tmp22_ = label;
					gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
					_tmp23_ = self->priv->shift_right_menu;
					_tmp24_ = item;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp23_, (GtkWidget*) _tmp24_);
					_tmp25_ = item;
					g_signal_connect_object (_tmp25_, "activate", (GCallback) _______lambda20__gtk_menu_item_activate, self, 0);
					_tmp26_ = label;
					gtk_widget_show ((GtkWidget*) _tmp26_);
					_tmp27_ = item;
					gtk_widget_show ((GtkWidget*) _tmp27_);
					_g_object_unref0 (item);
					_g_object_unref0 (label);
					_g_free0 (text);
					_g_free0 (format);
				}
			}
		}
	}
	_tmp28_ = button;
	_tmp29_ = self->priv->shift_right_menu;
	math_buttons_popup_button_menu (self, _tmp28_, _tmp29_);
}


static void math_buttons_function_cb (MathButtons* self, GtkWidget* widget) {
	MathFunctionPopup* popup = NULL;
	MathEquation* _tmp0_ = NULL;
	MathFunctionPopup* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkAllocation allocation = {0};
	GtkWidget* _tmp4_ = NULL;
	GtkAllocation _tmp5_ = {0};
	gint x = 0;
	gint y = 0;
	GtkWidget* _tmp6_ = NULL;
	GdkWindow* _tmp7_ = NULL;
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	GtkAllocation _tmp10_ = {0};
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_function_popup_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	popup = _tmp1_;
	_tmp2_ = widget;
	_tmp3_ = gtk_widget_get_toplevel (_tmp2_);
	gtk_window_set_transient_for ((GtkWindow*) popup, G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp3_) : NULL);
	_tmp4_ = widget;
	gtk_widget_get_allocation (_tmp4_, &_tmp5_);
	allocation = _tmp5_;
	_tmp6_ = widget;
	_tmp7_ = gtk_widget_get_window (_tmp6_);
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.x;
	_tmp10_ = allocation;
	_tmp11_ = _tmp10_.y;
	gdk_window_get_root_coords (_tmp7_, _tmp9_, _tmp11_, &_tmp12_, &_tmp13_);
	x = _tmp12_;
	y = _tmp13_;
	gtk_window_move ((GtkWindow*) popup, x, y);
	gtk_widget_show ((GtkWidget*) popup);
	_g_object_unref0 (popup);
}


static void math_buttons_finc_cb (MathButtons* self, GtkWidget* widget) {
	gchar* name = NULL;
	GtkWidget* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GtkDialog* dialog = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkDialog* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "finc-dialog-name");
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	name = _tmp2_;
	_tmp3_ = self->priv->financial_ui;
	_tmp4_ = gtk_builder_get_object (_tmp3_, name);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp4_) : NULL);
	dialog = _tmp5_;
	gtk_dialog_run (dialog);
	gtk_widget_hide ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
	_g_free0 (name);
}


static void math_buttons_insert_character_code_cb (MathButtons* self, GtkWidget* widget) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->character_code_dialog;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


static void math_buttons_finc_activate_cb (MathButtons* self, GtkWidget* widget) {
	GtkEntry* next_entry = NULL;
	GtkWidget* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GtkEntry* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "next-entry");
	_tmp2_ = _g_object_ref0 ((GtkEntry*) _tmp1_);
	next_entry = _tmp2_;
	_tmp3_ = next_entry;
	if (_tmp3_ == NULL) {
		GtkDialog* dialog = NULL;
		GtkWidget* _tmp4_ = NULL;
		GtkWidget* _tmp5_ = NULL;
		GtkDialog* _tmp6_ = NULL;
		GtkDialog* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp4_ = widget;
		_tmp5_ = gtk_widget_get_toplevel (_tmp4_);
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp5_) : NULL);
		dialog = _tmp6_;
		_tmp7_ = dialog;
		_tmp8_ = gtk_widget_is_toplevel ((GtkWidget*) _tmp7_);
		if (_tmp8_) {
			GtkDialog* _tmp9_ = NULL;
			_tmp9_ = dialog;
			gtk_dialog_response (_tmp9_, (gint) GTK_RESPONSE_OK);
			_g_object_unref0 (dialog);
			_g_object_unref0 (next_entry);
			return;
		}
		_g_object_unref0 (dialog);
	} else {
		GtkEntry* _tmp10_ = NULL;
		_tmp10_ = next_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
	}
	_g_object_unref0 (next_entry);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup9 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup10 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void math_buttons_finc_response_cb (MathButtons* self, GtkWidget* widget, gint response_id) {
	gint _tmp0_ = 0;
	FinancialDialog function = 0;
	GtkWidget* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gchar** entries = NULL;
	gchar** _tmp3_ = NULL;
	gint entries_length1 = 0;
	gint _entries_size_ = 0;
	FinancialDialog _tmp4_ = 0;
	Number* arg[4] = {0};
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	Number* _tmp18_ = NULL;
	Number* _tmp19_[4] = {0};
	GtkEntry* first_entry = NULL;
	GtkBuilder* _tmp36_ = NULL;
	gchar** _tmp37_ = NULL;
	gint _tmp37__length1 = 0;
	const gchar* _tmp38_ = NULL;
	GObject* _tmp39_ = NULL;
	GtkEntry* _tmp40_ = NULL;
	GtkEntry* _tmp41_ = NULL;
	MathEquation* _tmp42_ = NULL;
	FinancialDialog _tmp43_ = 0;
	Number* _tmp44_ = NULL;
	Number* _tmp45_ = NULL;
	Number* _tmp46_ = NULL;
	Number* _tmp47_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = response_id;
	if (_tmp0_ != ((gint) GTK_RESPONSE_OK)) {
		return;
	}
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "finc-function");
	function = (FinancialDialog) ((gint) ((gintptr) _tmp2_));
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	entries = _tmp3_;
	entries_length1 = 0;
	_entries_size_ = entries_length1;
	_tmp4_ = function;
	switch (_tmp4_) {
		case FINANCIAL_DIALOG_CTRM_DIALOG:
		{
			gchar** _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
			_tmp5_ = (MATH_BUTTONS_ctrm_entries != NULL) ? _vala_array_dup1 (MATH_BUTTONS_ctrm_entries, G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries)) : ((gpointer) MATH_BUTTONS_ctrm_entries);
			_tmp5__length1 = G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp5_;
			entries_length1 = _tmp5__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_DDB_DIALOG:
		{
			gchar** _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			_tmp6_ = (MATH_BUTTONS_ddb_entries != NULL) ? _vala_array_dup2 (MATH_BUTTONS_ddb_entries, G_N_ELEMENTS (MATH_BUTTONS_ddb_entries)) : ((gpointer) MATH_BUTTONS_ddb_entries);
			_tmp6__length1 = G_N_ELEMENTS (MATH_BUTTONS_ddb_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp6_;
			entries_length1 = _tmp6__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_FV_DIALOG:
		{
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			_tmp7_ = (MATH_BUTTONS_fv_entries != NULL) ? _vala_array_dup3 (MATH_BUTTONS_fv_entries, G_N_ELEMENTS (MATH_BUTTONS_fv_entries)) : ((gpointer) MATH_BUTTONS_fv_entries);
			_tmp7__length1 = G_N_ELEMENTS (MATH_BUTTONS_fv_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp7_;
			entries_length1 = _tmp7__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_GPM_DIALOG:
		{
			gchar** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			_tmp8_ = (MATH_BUTTONS_gpm_entries != NULL) ? _vala_array_dup4 (MATH_BUTTONS_gpm_entries, G_N_ELEMENTS (MATH_BUTTONS_gpm_entries)) : ((gpointer) MATH_BUTTONS_gpm_entries);
			_tmp8__length1 = G_N_ELEMENTS (MATH_BUTTONS_gpm_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp8_;
			entries_length1 = _tmp8__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_PMT_DIALOG:
		{
			gchar** _tmp9_ = NULL;
			gint _tmp9__length1 = 0;
			_tmp9_ = (MATH_BUTTONS_pmt_entries != NULL) ? _vala_array_dup5 (MATH_BUTTONS_pmt_entries, G_N_ELEMENTS (MATH_BUTTONS_pmt_entries)) : ((gpointer) MATH_BUTTONS_pmt_entries);
			_tmp9__length1 = G_N_ELEMENTS (MATH_BUTTONS_pmt_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp9_;
			entries_length1 = _tmp9__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_PV_DIALOG:
		{
			gchar** _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			_tmp10_ = (MATH_BUTTONS_pv_entries != NULL) ? _vala_array_dup6 (MATH_BUTTONS_pv_entries, G_N_ELEMENTS (MATH_BUTTONS_pv_entries)) : ((gpointer) MATH_BUTTONS_pv_entries);
			_tmp10__length1 = G_N_ELEMENTS (MATH_BUTTONS_pv_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp10_;
			entries_length1 = _tmp10__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_RATE_DIALOG:
		{
			gchar** _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
			_tmp11_ = (MATH_BUTTONS_rate_entries != NULL) ? _vala_array_dup7 (MATH_BUTTONS_rate_entries, G_N_ELEMENTS (MATH_BUTTONS_rate_entries)) : ((gpointer) MATH_BUTTONS_rate_entries);
			_tmp11__length1 = G_N_ELEMENTS (MATH_BUTTONS_rate_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp11_;
			entries_length1 = _tmp11__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_SLN_DIALOG:
		{
			gchar** _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			_tmp12_ = (MATH_BUTTONS_sln_entries != NULL) ? _vala_array_dup8 (MATH_BUTTONS_sln_entries, G_N_ELEMENTS (MATH_BUTTONS_sln_entries)) : ((gpointer) MATH_BUTTONS_sln_entries);
			_tmp12__length1 = G_N_ELEMENTS (MATH_BUTTONS_sln_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp12_;
			entries_length1 = _tmp12__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_SYD_DIALOG:
		{
			gchar** _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			_tmp13_ = (MATH_BUTTONS_syd_entries != NULL) ? _vala_array_dup9 (MATH_BUTTONS_syd_entries, G_N_ELEMENTS (MATH_BUTTONS_syd_entries)) : ((gpointer) MATH_BUTTONS_syd_entries);
			_tmp13__length1 = G_N_ELEMENTS (MATH_BUTTONS_syd_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp13_;
			entries_length1 = _tmp13__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_TERM_DIALOG:
		{
			gchar** _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			_tmp14_ = (MATH_BUTTONS_term_entries != NULL) ? _vala_array_dup10 (MATH_BUTTONS_term_entries, G_N_ELEMENTS (MATH_BUTTONS_term_entries)) : ((gpointer) MATH_BUTTONS_term_entries);
			_tmp14__length1 = G_N_ELEMENTS (MATH_BUTTONS_term_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp14_;
			entries_length1 = _tmp14__length1;
			_entries_size_ = entries_length1;
			break;
		}
		default:
		break;
	}
	_tmp15_ = number_new_integer ((gint64) 0);
	_tmp16_ = number_new_integer ((gint64) 0);
	_tmp17_ = number_new_integer ((gint64) 0);
	_tmp18_ = number_new_integer ((gint64) 0);
	_tmp19_[0] = _tmp15_;
	_tmp19_[1] = _tmp16_;
	_tmp19_[2] = _tmp17_;
	_tmp19_[3] = _tmp18_;
	memcpy (arg, _tmp19_, 4 * sizeof (Number*));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				gint _tmp22_ = 0;
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				GtkEntry* entry = NULL;
				GtkBuilder* _tmp24_ = NULL;
				gchar** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				gint _tmp26_ = 0;
				const gchar* _tmp27_ = NULL;
				GObject* _tmp28_ = NULL;
				GtkEntry* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				GtkEntry* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				Number* _tmp33_ = NULL;
				Number* _tmp34_ = NULL;
				GtkEntry* _tmp35_ = NULL;
				if (!_tmp20_) {
					gint _tmp21_ = 0;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp22_ = i;
				_tmp23_ = entries;
				_tmp23__length1 = entries_length1;
				if (!(_tmp22_ < _tmp23__length1)) {
					break;
				}
				_tmp24_ = self->priv->financial_ui;
				_tmp25_ = entries;
				_tmp25__length1 = entries_length1;
				_tmp26_ = i;
				_tmp27_ = _tmp25_[_tmp26_];
				_tmp28_ = gtk_builder_get_object (_tmp24_, _tmp27_);
				_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp28_) : NULL);
				entry = _tmp29_;
				_tmp30_ = i;
				_tmp31_ = entry;
				_tmp32_ = gtk_entry_get_text (_tmp31_);
				_tmp33_ = mp_set_from_string (_tmp32_, 10);
				_g_object_unref0 (arg[_tmp30_]);
				arg[_tmp30_] = _tmp33_;
				_tmp34_ = arg[_tmp30_];
				_tmp35_ = entry;
				gtk_entry_set_text (_tmp35_, "0");
				_g_object_unref0 (entry);
			}
		}
	}
	_tmp36_ = self->priv->financial_ui;
	_tmp37_ = entries;
	_tmp37__length1 = entries_length1;
	_tmp38_ = _tmp37_[0];
	_tmp39_ = gtk_builder_get_object (_tmp36_, _tmp38_);
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp39_) : NULL);
	first_entry = _tmp40_;
	_tmp41_ = first_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp41_);
	_tmp42_ = self->priv->equation;
	_tmp43_ = function;
	_tmp44_ = arg[0];
	_tmp45_ = arg[1];
	_tmp46_ = arg[2];
	_tmp47_ = arg[3];
	do_finc_expression (_tmp42_, _tmp43_, _tmp44_, _tmp45_, _tmp46_, _tmp47_);
	_g_object_unref0 (first_entry);
	_vala_array_destroy (arg, 4, (GDestroyNotify) g_object_unref);
	entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void math_buttons_character_code_dialog_response_cb (MathButtons* self, GtkWidget* dialog, gint response_id) {
	gchar* text = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkWidget* _tmp21_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_tmp0_ = self->priv->character_code_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	text = _tmp2_;
	_tmp3_ = response_id;
	if (_tmp3_ == ((gint) GTK_RESPONSE_OK)) {
		Number* x = NULL;
		Number* _tmp4_ = NULL;
		MathEquation* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		_tmp4_ = number_new_integer ((gint64) 0);
		x = _tmp4_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					const gchar* _tmp7_ = NULL;
					gint _tmp8_ = 0;
					gchar _tmp9_ = '\0';
					Number* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					gchar _tmp13_ = '\0';
					Number* _tmp14_ = NULL;
					Number* _tmp15_ = NULL;
					Number* _tmp16_ = NULL;
					Number* _tmp17_ = NULL;
					Number* _tmp18_ = NULL;
					if (!_tmp5_) {
						gint _tmp6_ = 0;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = text;
					_tmp8_ = i;
					_tmp9_ = string_get (_tmp7_, (glong) _tmp8_);
					if (!(_tmp9_ != '\0')) {
						break;
					}
					_tmp10_ = x;
					_tmp11_ = text;
					_tmp12_ = i;
					_tmp13_ = string_get (_tmp11_, (glong) _tmp12_);
					_tmp14_ = number_new_integer ((gint64) _tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = number_add (_tmp10_, _tmp15_);
					_g_object_unref0 (x);
					x = _tmp16_;
					_g_object_unref0 (_tmp15_);
					_tmp17_ = x;
					_tmp18_ = number_shift (_tmp17_, 8);
					_g_object_unref0 (x);
					x = _tmp18_;
				}
			}
		}
		_tmp19_ = self->priv->equation;
		_tmp20_ = x;
		math_equation_insert_number (_tmp19_, _tmp20_);
		_g_object_unref0 (x);
	}
	_tmp21_ = dialog;
	gtk_widget_hide (_tmp21_);
	_g_free0 (text);
}


static void math_buttons_character_code_dialog_activate_cb (MathButtons* self, GtkWidget* entry) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = self->priv->character_code_dialog;
	math_buttons_character_code_dialog_response_cb (self, (GtkWidget*) _tmp0_, (gint) GTK_RESPONSE_OK);
}


static gboolean math_buttons_character_code_dialog_delete_cb (MathButtons* self, GtkWidget* dialog, GdkEventAny* event) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dialog != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = dialog;
	math_buttons_character_code_dialog_response_cb (self, _tmp0_, (gint) GTK_RESPONSE_CANCEL);
	result = TRUE;
	return result;
}


static gboolean math_buttons_bit_toggle_cb (MathButtons* self, GtkWidget* event_box, GdkEventButton* event) {
	gboolean result = FALSE;
	MathEquation* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event_box != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->equation;
	_tmp1_ = event_box;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "bit_index");
	math_equation_toggle_bit (_tmp0_, (guint) ((gint) ((gintptr) _tmp2_)));
	result = TRUE;
	return result;
}


static void math_buttons_remove_trailing_spaces (MathButtons* self) {
	GtkTextMark* insert_mark = NULL;
	MathEquation* _tmp0_ = NULL;
	GtkTextMark* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	MathEquation* _tmp3_ = NULL;
	GtkTextMark* _tmp4_ = NULL;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	MathEquation* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	insert_mark = _tmp2_;
	_tmp3_ = self->priv->equation;
	_tmp4_ = insert_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp3_, &_tmp5_, _tmp4_);
	end = _tmp5_;
	_tmp6_ = end;
	start = _tmp6_;
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		gunichar _tmp8_ = 0U;
		gboolean _tmp9_ = FALSE;
		_tmp7_ = gtk_text_iter_backward_char (&start);
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = gtk_text_iter_get_char (&start);
		_tmp9_ = g_unichar_isspace (_tmp8_);
		if (!_tmp9_) {
			gtk_text_iter_forward_char (&start);
			break;
		}
	}
	_tmp10_ = self->priv->equation;
	gtk_text_buffer_delete ((GtkTextBuffer*) _tmp10_, &start, &end);
	_g_object_unref0 (insert_mark);
}


static void math_buttons_set_superscript_cb (MathButtons* self, GtkButton* widget) {
	GtkToggleButton* button = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkToggleButton* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_toggle_button_get_type ()) ? ((GtkToggleButton*) _tmp0_) : NULL);
	button = _tmp1_;
	_tmp2_ = button;
	_tmp3_ = gtk_toggle_button_get_active (_tmp2_);
	if (_tmp3_) {
		MathEquation* _tmp4_ = NULL;
		MathEquation* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = self->priv->equation;
		math_equation_set_number_mode (_tmp4_, NUMBER_MODE_SUPERSCRIPT);
		_tmp5_ = self->priv->equation;
		_tmp6_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp5_);
		_tmp7_ = _tmp6_;
		if (!_tmp7_) {
			math_buttons_remove_trailing_spaces (self);
		}
	} else {
		MathEquation* _tmp8_ = NULL;
		NumberMode _tmp9_ = 0;
		NumberMode _tmp10_ = 0;
		_tmp8_ = self->priv->equation;
		_tmp9_ = math_equation_get_number_mode (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == NUMBER_MODE_SUPERSCRIPT) {
			MathEquation* _tmp11_ = NULL;
			_tmp11_ = self->priv->equation;
			math_equation_set_number_mode (_tmp11_, NUMBER_MODE_NORMAL);
		}
	}
	_g_object_unref0 (button);
}


static void math_buttons_set_subscript_cb (MathButtons* self, GtkButton* widget) {
	GtkToggleButton* button = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkToggleButton* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_toggle_button_get_type ()) ? ((GtkToggleButton*) _tmp0_) : NULL);
	button = _tmp1_;
	_tmp2_ = button;
	_tmp3_ = gtk_toggle_button_get_active (_tmp2_);
	if (_tmp3_) {
		MathEquation* _tmp4_ = NULL;
		MathEquation* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = self->priv->equation;
		math_equation_set_number_mode (_tmp4_, NUMBER_MODE_SUBSCRIPT);
		_tmp5_ = self->priv->equation;
		_tmp6_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp5_);
		_tmp7_ = _tmp6_;
		if (!_tmp7_) {
			math_buttons_remove_trailing_spaces (self);
		}
	} else {
		MathEquation* _tmp8_ = NULL;
		NumberMode _tmp9_ = 0;
		NumberMode _tmp10_ = 0;
		_tmp8_ = self->priv->equation;
		_tmp9_ = math_equation_get_number_mode (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == NUMBER_MODE_SUBSCRIPT) {
			MathEquation* _tmp11_ = NULL;
			_tmp11_ = self->priv->equation;
			math_equation_set_number_mode (_tmp11_, NUMBER_MODE_NORMAL);
		}
	}
	_g_object_unref0 (button);
}


static void math_buttons_number_mode_changed_cb (MathButtons* self) {
	NumberMode mode = 0;
	MathEquation* _tmp0_ = NULL;
	NumberMode _tmp1_ = 0;
	NumberMode _tmp2_ = 0;
	GList* _tmp3_ = NULL;
	GList* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_equation_get_number_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	mode = _tmp2_;
	_tmp3_ = self->priv->superscript_toggles;
	{
		GList* toggle_collection = NULL;
		GList* toggle_it = NULL;
		toggle_collection = _tmp3_;
		for (toggle_it = toggle_collection; toggle_it != NULL; toggle_it = toggle_it->next) {
			GtkToggleButton* _tmp4_ = NULL;
			GtkToggleButton* toggle = NULL;
			_tmp4_ = _g_object_ref0 ((GtkToggleButton*) toggle_it->data);
			toggle = _tmp4_;
			{
				GtkToggleButton* _tmp5_ = NULL;
				NumberMode _tmp6_ = 0;
				_tmp5_ = toggle;
				_tmp6_ = mode;
				gtk_toggle_button_set_active (_tmp5_, _tmp6_ == NUMBER_MODE_SUPERSCRIPT);
				_g_object_unref0 (toggle);
			}
		}
	}
	_tmp7_ = self->priv->subscript_toggles;
	{
		GList* toggle_collection = NULL;
		GList* toggle_it = NULL;
		toggle_collection = _tmp7_;
		for (toggle_it = toggle_collection; toggle_it != NULL; toggle_it = toggle_it->next) {
			GtkToggleButton* _tmp8_ = NULL;
			GtkToggleButton* toggle = NULL;
			_tmp8_ = _g_object_ref0 ((GtkToggleButton*) toggle_it->data);
			toggle = _tmp8_;
			{
				GtkToggleButton* _tmp9_ = NULL;
				NumberMode _tmp10_ = 0;
				_tmp9_ = toggle;
				_tmp10_ = mode;
				gtk_toggle_button_set_active (_tmp9_, _tmp10_ == NUMBER_MODE_SUBSCRIPT);
				_g_object_unref0 (toggle);
			}
		}
	}
}


ButtonMode math_buttons_get_mode (MathButtons* self) {
	ButtonMode result;
	ButtonMode _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_mode;
	result = _tmp0_;
	return result;
}


void math_buttons_set_mode (MathButtons* self, ButtonMode value) {
	ButtonMode _tmp0_ = 0;
	ButtonMode _tmp1_ = 0;
	ButtonMode _tmp2_ = 0;
	ButtonMode _tmp3_ = 0;
	ButtonMode _tmp4_ = 0;
	gboolean _tmp8_ = FALSE;
	ButtonMode _tmp9_ = 0;
	ButtonMode _tmp10_ = 0;
	MathConverter* _tmp13_ = NULL;
	ButtonMode _tmp14_ = 0;
	ButtonMode _tmp15_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_mode;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->_mode = _tmp2_;
	_tmp3_ = math_buttons_get_mode (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_PROGRAMMING) {
		MathEquation* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp5_ = self->priv->equation;
		_tmp6_ = self->priv->_programming_base;
		math_equation_set_number_base (_tmp5_, _tmp6_);
	} else {
		MathEquation* _tmp7_ = NULL;
		_tmp7_ = self->priv->equation;
		math_equation_set_number_base (_tmp7_, 10);
	}
	math_buttons_load_buttons (self);
	_tmp9_ = math_buttons_get_mode (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == BUTTON_MODE_ADVANCED) {
		_tmp8_ = TRUE;
	} else {
		ButtonMode _tmp11_ = 0;
		ButtonMode _tmp12_ = 0;
		_tmp11_ = math_buttons_get_mode (self);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_ == BUTTON_MODE_FINANCIAL;
	}
	_tmp13_ = self->priv->converter;
	gtk_widget_set_visible ((GtkWidget*) _tmp13_, _tmp8_);
	_tmp14_ = math_buttons_get_mode (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == BUTTON_MODE_ADVANCED) {
		MathConverter* _tmp16_ = NULL;
		MathConverter* _tmp17_ = NULL;
		MathEquation* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		MathEquation* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		_tmp16_ = self->priv->converter;
		math_converter_set_category (_tmp16_, NULL);
		_tmp17_ = self->priv->converter;
		_tmp18_ = self->priv->equation;
		_tmp19_ = math_equation_get_source_units (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->equation;
		_tmp23_ = math_equation_get_target_units (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_;
		math_converter_set_conversion (_tmp17_, _tmp21_, _tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp21_);
	} else {
		ButtonMode _tmp26_ = 0;
		ButtonMode _tmp27_ = 0;
		_tmp26_ = math_buttons_get_mode (self);
		_tmp27_ = _tmp26_;
		if (_tmp27_ == BUTTON_MODE_FINANCIAL) {
			MathConverter* _tmp28_ = NULL;
			MathConverter* _tmp29_ = NULL;
			MathEquation* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			MathEquation* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			_tmp28_ = self->priv->converter;
			math_converter_set_category (_tmp28_, "currency");
			_tmp29_ = self->priv->converter;
			_tmp30_ = self->priv->equation;
			_tmp31_ = math_equation_get_source_currency (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = _tmp32_;
			_tmp34_ = self->priv->equation;
			_tmp35_ = math_equation_get_target_currency (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _tmp36_;
			math_converter_set_conversion (_tmp29_, _tmp33_, _tmp37_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp33_);
		}
	}
	g_object_notify ((GObject *) self, "mode");
}


gint math_buttons_get_programming_base (MathButtons* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_programming_base;
	result = _tmp0_;
	return result;
}


void math_buttons_set_programming_base (MathButtons* self, gint value) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ButtonMode _tmp3_ = 0;
	ButtonMode _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_programming_base;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->_programming_base = _tmp2_;
	_tmp3_ = math_buttons_get_mode (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_PROGRAMMING) {
		MathEquation* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp5_ = self->priv->equation;
		_tmp6_ = value;
		math_equation_set_number_base (_tmp5_, _tmp6_);
	}
	g_object_notify ((GObject *) self, "programming-base");
}


static void math_buttons_class_init (MathButtonsClass * klass) {
	math_buttons_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathButtonsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_math_buttons_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_buttons_set_property;
	G_OBJECT_CLASS (klass)->finalize = math_buttons_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_MODE, g_param_spec_enum ("mode", "mode", "mode", TYPE_BUTTON_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_PROGRAMMING_BASE, g_param_spec_int ("programming-base", "programming-base", "programming-base", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void math_buttons_instance_init (MathButtons * self) {
	self->priv = MATH_BUTTONS_GET_PRIVATE (self);
	self->priv->_programming_base = 10;
	self->priv->active_panel = NULL;
}


static void math_buttons_finalize (GObject* obj) {
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_BUTTONS, MathButtons);
	_g_object_unref0 (self->priv->equation);
	_g_object_unref0 (self->priv->converter);
	_g_object_unref0 (self->priv->basic_ui);
	_g_object_unref0 (self->priv->advanced_ui);
	_g_object_unref0 (self->priv->financial_ui);
	_g_object_unref0 (self->priv->programming_ui);
	_g_object_unref0 (self->priv->bas_panel);
	_g_object_unref0 (self->priv->adv_panel);
	_g_object_unref0 (self->priv->fin_panel);
	_g_object_unref0 (self->priv->prog_panel);
	_g_object_unref0 (self->priv->active_panel);
	_g_object_unref0 (self->priv->shift_left_menu);
	_g_object_unref0 (self->priv->shift_right_menu);
	__g_list_free__g_object_unref0_0 (self->priv->superscript_toggles);
	__g_list_free__g_object_unref0_0 (self->priv->subscript_toggles);
	_g_object_unref0 (self->priv->base_combo);
	_g_object_unref0 (self->priv->base_label);
	_g_object_unref0 (self->priv->bit_panel);
	__g_list_free__g_object_unref0_0 (self->priv->bit_labels);
	_g_object_unref0 (self->priv->character_code_dialog);
	_g_object_unref0 (self->priv->character_code_entry);
	G_OBJECT_CLASS (math_buttons_parent_class)->finalize (obj);
}


GType math_buttons_get_type (void) {
	static volatile gsize math_buttons_type_id__volatile = 0;
	if (g_once_init_enter (&math_buttons_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathButtonsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_buttons_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathButtons), 0, (GInstanceInitFunc) math_buttons_instance_init, NULL };
		GType math_buttons_type_id;
		math_buttons_type_id = g_type_register_static (gtk_box_get_type (), "MathButtons", &g_define_type_info, 0);
		g_once_init_leave (&math_buttons_type_id__volatile, math_buttons_type_id);
	}
	return math_buttons_type_id__volatile;
}


static void _vala_math_buttons_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
	switch (property_id) {
		case MATH_BUTTONS_MODE:
		g_value_set_enum (value, math_buttons_get_mode (self));
		break;
		case MATH_BUTTONS_PROGRAMMING_BASE:
		g_value_set_int (value, math_buttons_get_programming_base (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_math_buttons_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
	switch (property_id) {
		case MATH_BUTTONS_MODE:
		math_buttons_set_mode (self, g_value_get_enum (value));
		break;
		case MATH_BUTTONS_PROGRAMMING_BASE:
		math_buttons_set_programming_base (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



