/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valacodegen.h>
#include <version.h>
#include <config.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gchar** vala_compiler_gresources;
static gchar** vala_compiler_gresources = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gboolean vala_compiler_vapi_comments;
static gboolean vala_compiler_vapi_comments = FALSE;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_thread;
static gboolean vala_compiler_thread = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_hide_internal;
static gboolean vala_compiler_hide_internal = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_pkg_config_command;
static gchar* vala_compiler_pkg_config_command = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gboolean vala_compiler_disable_diagnostic_colors;
static gboolean vala_compiler_disable_diagnostic_colors = FALSE;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;

gpointer vala_compiler_ref (gpointer instance);
void vala_compiler_unref (gpointer instance);
GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_compiler (GValue* value, gpointer v_object);
void vala_value_take_compiler (GValue* value, gpointer v_object);
gpointer vala_value_get_compiler (const GValue* value);
GType vala_compiler_get_type (void) G_GNUC_CONST;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
enum  {
	VALA_COMPILER_DUMMY_PROPERTY
};
#define VALA_COMPILER_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gint vala_compiler_run_source (gchar** args, int args_length1);
ValaCompiler* vala_compiler_new (void);
ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_, GPid pid, gint status);
static void ____lambda4__gchild_watch_func (GPid pid, gint status, gpointer self);
static gint vala_compiler_main (gchar** args, int args_length1);
static void vala_compiler_finalize (ValaCompiler* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[54] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Output directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"vapi-comments", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_vapi_comments, "Include comments in generated vapi", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_thread, "Enable multithreading support", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"hide-internal", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_hide_internal, "Hide symbols marked as internal", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"pkg-config", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_pkg_config_command, "Use COMMAND as pkg-config command", "COMMAND"}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"no-color", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_diagnostic_colors, "Disable colored output", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"gresources", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_gresources, "XML of gresources", "FILE..."}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static gint vala_compiler_quit (ValaCompiler* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_ = NULL;
	ValaReport* _tmp2_ = NULL;
	ValaReport* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp9_ = FALSE;
	ValaCodeContext* _tmp10_ = NULL;
	ValaReport* _tmp11_ = NULL;
	ValaReport* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_report_get_errors (_tmp3_);
	if (_tmp4_ == 0) {
		ValaCodeContext* _tmp5_ = NULL;
		ValaReport* _tmp6_ = NULL;
		ValaReport* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp5_ = self->priv->context;
		_tmp6_ = vala_code_context_get_report (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_report_get_warnings (_tmp7_);
		_tmp0_ = _tmp8_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp10_ = self->priv->context;
	_tmp11_ = vala_code_context_get_report (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_report_get_errors (_tmp12_);
	if (_tmp13_ == 0) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		_tmp15_ = vala_compiler_fatal_warnings;
		if (!_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			ValaCodeContext* _tmp16_ = NULL;
			ValaReport* _tmp17_ = NULL;
			ValaReport* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			_tmp16_ = self->priv->context;
			_tmp17_ = vala_code_context_get_report (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_report_get_warnings (_tmp18_);
			_tmp14_ = _tmp19_ == 0;
		}
		_tmp9_ = _tmp14_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean _tmp20_ = FALSE;
		_tmp20_ = vala_compiler_quiet_mode;
		if (!_tmp20_) {
			FILE* _tmp21_ = NULL;
			ValaCodeContext* _tmp22_ = NULL;
			ValaReport* _tmp23_ = NULL;
			ValaReport* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			_tmp21_ = stdout;
			_tmp22_ = self->priv->context;
			_tmp23_ = vala_code_context_get_report (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_report_get_warnings (_tmp24_);
			fprintf (_tmp21_, "Compilation succeeded - %d warning(s)\n", _tmp25_);
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp26_ = FALSE;
		_tmp26_ = vala_compiler_quiet_mode;
		if (!_tmp26_) {
			FILE* _tmp27_ = NULL;
			ValaCodeContext* _tmp28_ = NULL;
			ValaReport* _tmp29_ = NULL;
			ValaReport* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			ValaCodeContext* _tmp32_ = NULL;
			ValaReport* _tmp33_ = NULL;
			ValaReport* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			_tmp27_ = stdout;
			_tmp28_ = self->priv->context;
			_tmp29_ = vala_code_context_get_report (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_report_get_errors (_tmp30_);
			_tmp32_ = self->priv->context;
			_tmp33_ = vala_code_context_get_report (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_report_get_warnings (_tmp34_);
			fprintf (_tmp27_, "Compilation failed: %d error(s), %d warning(s)\n", _tmp31_, _tmp35_);
		}
		result = 1;
		return result;
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint vala_compiler_run (ValaCompiler* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	ValaCodeContext* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	ValaCodeContext* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	ValaCodeContext* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	ValaCodeContext* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	ValaCodeContext* _tmp37_ = NULL;
	gboolean _tmp38_ = FALSE;
	ValaCodeContext* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	ValaCodeContext* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	ValaCodeContext* _tmp43_ = NULL;
	ValaReport* _tmp44_ = NULL;
	ValaReport* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	ValaCodeContext* _tmp47_ = NULL;
	ValaReport* _tmp48_ = NULL;
	ValaReport* _tmp49_ = NULL;
	gboolean _tmp50_ = FALSE;
	ValaCodeContext* _tmp51_ = NULL;
	gboolean _tmp52_ = FALSE;
	ValaCodeContext* _tmp53_ = NULL;
	gboolean _tmp54_ = FALSE;
	ValaCodeContext* _tmp55_ = NULL;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp57_ = FALSE;
	gboolean _tmp58_ = FALSE;
	ValaCodeContext* _tmp60_ = NULL;
	gboolean _tmp61_ = FALSE;
	ValaCodeContext* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
	gboolean _tmp64_ = FALSE;
	const gchar* _tmp65_ = NULL;
	ValaCodeContext* _tmp67_ = NULL;
	gboolean _tmp68_ = FALSE;
	ValaCodeContext* _tmp69_ = NULL;
	const gchar* _tmp70_ = NULL;
	ValaCodeContext* _tmp71_ = NULL;
	const gchar* _tmp72_ = NULL;
	ValaCodeContext* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	ValaCodeContext* _tmp75_ = NULL;
	const gchar* _tmp76_ = NULL;
	gboolean _tmp77_ = FALSE;
	const gchar* _tmp78_ = NULL;
	const gchar* _tmp80_ = NULL;
	const gchar* _tmp88_ = NULL;
	ValaCodeContext* _tmp97_ = NULL;
	gchar** _tmp98_ = NULL;
	gint _tmp98__length1 = 0;
	gchar** _tmp99_ = NULL;
	gint _tmp99__length1 = 0;
	ValaCodeContext* _tmp100_ = NULL;
	gboolean _tmp101_ = FALSE;
	ValaCodeContext* _tmp102_ = NULL;
	gchar** _tmp103_ = NULL;
	gint _tmp103__length1 = 0;
	gchar** _tmp104_ = NULL;
	gint _tmp104__length1 = 0;
	ValaCodeContext* _tmp105_ = NULL;
	gchar** _tmp106_ = NULL;
	gint _tmp106__length1 = 0;
	gchar** _tmp107_ = NULL;
	gint _tmp107__length1 = 0;
	ValaCodeContext* _tmp108_ = NULL;
	gboolean _tmp109_ = FALSE;
	ValaCodeContext* _tmp110_ = NULL;
	gboolean _tmp111_ = FALSE;
	ValaCodeContext* _tmp112_ = NULL;
	gboolean _tmp113_ = FALSE;
	ValaCodeContext* _tmp114_ = NULL;
	gboolean _tmp115_ = FALSE;
	gboolean _tmp116_ = FALSE;
	gboolean _tmp117_ = FALSE;
	gboolean _tmp119_ = FALSE;
	gboolean _tmp120_ = FALSE;
	const gchar* _tmp121_ = NULL;
	gboolean _tmp129_ = FALSE;
	const gchar* _tmp130_ = NULL;
	ValaCodeContext* _tmp131_ = NULL;
	gboolean _tmp132_ = FALSE;
	ValaCodeContext* _tmp133_ = NULL;
	const gchar* _tmp134_ = NULL;
	ValaCodeContext* _tmp135_ = NULL;
	gboolean _tmp136_ = FALSE;
	gchar** _tmp137_ = NULL;
	gint _tmp137__length1 = 0;
	gint glib_major = 0;
	gint glib_minor = 0;
	gboolean _tmp149_ = FALSE;
	const gchar* _tmp150_ = NULL;
	ValaCodeContext* _tmp153_ = NULL;
	gint _tmp154_ = 0;
	ValaCodeContext* _tmp155_ = NULL;
	gint _tmp156_ = 0;
	ValaCodeContext* _tmp157_ = NULL;
	gint _tmp158_ = 0;
	gint _tmp159_ = 0;
	gboolean _tmp168_ = FALSE;
	gchar** _tmp171_ = NULL;
	gint _tmp171__length1 = 0;
	gchar** _tmp176_ = NULL;
	gint _tmp176__length1 = 0;
	ValaCodeContext* _tmp187_ = NULL;
	gchar** _tmp188_ = NULL;
	gint _tmp188__length1 = 0;
	gchar** _tmp189_ = NULL;
	gint _tmp189__length1 = 0;
	gboolean _tmp190_ = FALSE;
	ValaCodeContext* _tmp191_ = NULL;
	ValaReport* _tmp192_ = NULL;
	ValaReport* _tmp193_ = NULL;
	gint _tmp194_ = 0;
	ValaCodeContext* _tmp202_ = NULL;
	ValaGDBusServerModule* _tmp203_ = NULL;
	ValaGDBusServerModule* _tmp204_ = NULL;
	gboolean has_c_files = FALSE;
	gboolean has_h_files = FALSE;
	gchar** _tmp205_ = NULL;
	gint _tmp205__length1 = 0;
	gboolean _tmp215_ = FALSE;
	gboolean _tmp216_ = FALSE;
	gboolean _tmp220_ = FALSE;
	ValaCodeContext* _tmp221_ = NULL;
	ValaReport* _tmp222_ = NULL;
	ValaReport* _tmp223_ = NULL;
	gint _tmp224_ = 0;
	ValaParser* parser = NULL;
	ValaParser* _tmp232_ = NULL;
	ValaParser* _tmp233_ = NULL;
	ValaCodeContext* _tmp234_ = NULL;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp235_ = NULL;
	ValaGenieParser* _tmp236_ = NULL;
	ValaCodeContext* _tmp237_ = NULL;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp238_ = NULL;
	ValaGirParser* _tmp239_ = NULL;
	ValaCodeContext* _tmp240_ = NULL;
	gboolean _tmp241_ = FALSE;
	ValaCodeContext* _tmp242_ = NULL;
	ValaReport* _tmp243_ = NULL;
	ValaReport* _tmp244_ = NULL;
	gint _tmp245_ = 0;
	const gchar* _tmp253_ = NULL;
	ValaCodeContext* _tmp259_ = NULL;
	gboolean _tmp260_ = FALSE;
	ValaCodeContext* _tmp261_ = NULL;
	ValaReport* _tmp262_ = NULL;
	ValaReport* _tmp263_ = NULL;
	gint _tmp264_ = 0;
	gboolean _tmp272_ = FALSE;
	gboolean _tmp273_ = FALSE;
	gboolean _tmp274_ = FALSE;
	const gchar* _tmp282_ = NULL;
	gboolean _tmp287_ = FALSE;
	ValaCodeContext* _tmp288_ = NULL;
	ValaReport* _tmp289_ = NULL;
	ValaReport* _tmp290_ = NULL;
	gint _tmp291_ = 0;
	ValaCodeContext* _tmp299_ = NULL;
	ValaCodeGenerator* _tmp300_ = NULL;
	ValaCodeGenerator* _tmp301_ = NULL;
	ValaCodeContext* _tmp302_ = NULL;
	gboolean _tmp303_ = FALSE;
	ValaCodeContext* _tmp304_ = NULL;
	ValaReport* _tmp305_ = NULL;
	ValaReport* _tmp306_ = NULL;
	gint _tmp307_ = 0;
	gboolean _tmp315_ = FALSE;
	const gchar* _tmp316_ = NULL;
	const gchar* _tmp320_ = NULL;
	const gchar* _tmp372_ = NULL;
	const gchar* _tmp386_ = NULL;
	const gchar* _tmp409_ = NULL;
	ValaCodeContext* _tmp412_ = NULL;
	ValaUsedAttr* _tmp413_ = NULL;
	ValaUsedAttr* _tmp414_ = NULL;
	ValaCodeContext* _tmp415_ = NULL;
	gboolean _tmp416_ = FALSE;
	ValaCodeContext* _tmp417_ = NULL;
	ValaReport* _tmp418_ = NULL;
	ValaReport* _tmp419_ = NULL;
	gint _tmp420_ = 0;
	gboolean _tmp428_ = FALSE;
	gint _tmp452_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	_tmp2_ = vala_compiler_disable_diagnostic_colors;
	if (_tmp2_ == FALSE) {
		const gchar* env_colors = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = g_getenv ("VALA_COLORS");
		env_colors = _tmp3_;
		_tmp4_ = env_colors;
		if (_tmp4_ != NULL) {
			ValaCodeContext* _tmp5_ = NULL;
			ValaReport* _tmp6_ = NULL;
			ValaReport* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			_tmp5_ = self->priv->context;
			_tmp6_ = vala_code_context_get_report (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = env_colors;
			vala_report_set_colors (_tmp7_, _tmp8_);
		} else {
			ValaCodeContext* _tmp9_ = NULL;
			ValaReport* _tmp10_ = NULL;
			ValaReport* _tmp11_ = NULL;
			_tmp9_ = self->priv->context;
			_tmp10_ = vala_code_context_get_report (_tmp9_);
			_tmp11_ = _tmp10_;
			vala_report_set_colors (_tmp11_, VALA_COMPILER_DEFAULT_COLORS);
		}
	}
	_tmp14_ = vala_compiler_ccode_only;
	if (!_tmp14_) {
		gboolean _tmp15_ = FALSE;
		_tmp15_ = vala_compiler_compile_only;
		_tmp13_ = !_tmp15_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		const gchar* _tmp16_ = NULL;
		_tmp16_ = vala_compiler_output;
		_tmp12_ = _tmp16_ == NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		const gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		_tmp17_ = vala_compiler_sources;
		_tmp17__length1 = _vala_array_length (vala_compiler_sources);
		_tmp18_ = _tmp17_[0];
		_tmp19_ = string_last_index_of_char (_tmp18_, (gunichar) '.', 0);
		if (_tmp19_ != -1) {
			gint dot = 0;
			gchar** _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			const gchar* _tmp21_ = NULL;
			gint _tmp22_ = 0;
			gchar** _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			const gchar* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			_tmp20_ = vala_compiler_sources;
			_tmp20__length1 = _vala_array_length (vala_compiler_sources);
			_tmp21_ = _tmp20_[0];
			_tmp22_ = string_last_index_of_char (_tmp21_, (gunichar) '.', 0);
			dot = _tmp22_;
			_tmp23_ = vala_compiler_sources;
			_tmp23__length1 = _vala_array_length (vala_compiler_sources);
			_tmp24_ = _tmp23_[0];
			_tmp25_ = dot;
			_tmp26_ = string_substring (_tmp24_, (glong) 0, (glong) _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_path_get_basename (_tmp27_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp28_;
			_g_free0 (_tmp27_);
		}
	}
	_tmp29_ = self->priv->context;
	_tmp30_ = vala_compiler_disable_assert;
	vala_code_context_set_assert (_tmp29_, !_tmp30_);
	_tmp31_ = self->priv->context;
	_tmp32_ = vala_compiler_enable_checking;
	vala_code_context_set_checking (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->context;
	_tmp34_ = vala_compiler_deprecated;
	vala_code_context_set_deprecated (_tmp33_, _tmp34_);
	_tmp35_ = self->priv->context;
	_tmp36_ = vala_compiler_hide_internal;
	vala_code_context_set_hide_internal (_tmp35_, _tmp36_);
	_tmp37_ = self->priv->context;
	_tmp38_ = vala_compiler_experimental;
	vala_code_context_set_experimental (_tmp37_, _tmp38_);
	_tmp39_ = self->priv->context;
	_tmp40_ = vala_compiler_experimental_non_null;
	vala_code_context_set_experimental_non_null (_tmp39_, _tmp40_);
	_tmp41_ = self->priv->context;
	_tmp42_ = vala_compiler_gobject_tracing;
	vala_code_context_set_gobject_tracing (_tmp41_, _tmp42_);
	_tmp43_ = self->priv->context;
	_tmp44_ = vala_code_context_get_report (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_compiler_disable_warnings;
	vala_report_set_enable_warnings (_tmp45_, !_tmp46_);
	_tmp47_ = self->priv->context;
	_tmp48_ = vala_code_context_get_report (_tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = vala_compiler_quiet_mode;
	vala_report_set_verbose_errors (_tmp49_, !_tmp50_);
	_tmp51_ = self->priv->context;
	_tmp52_ = vala_compiler_verbose_mode;
	vala_code_context_set_verbose_mode (_tmp51_, _tmp52_);
	_tmp53_ = self->priv->context;
	_tmp54_ = vala_compiler_disable_version_header;
	vala_code_context_set_version_header (_tmp53_, !_tmp54_);
	_tmp55_ = self->priv->context;
	_tmp56_ = vala_compiler_ccode_only;
	vala_code_context_set_ccode_only (_tmp55_, _tmp56_);
	_tmp58_ = vala_compiler_ccode_only;
	if (_tmp58_) {
		gchar** _tmp59_ = NULL;
		gint _tmp59__length1 = 0;
		_tmp59_ = vala_compiler_cc_options;
		_tmp59__length1 = _vala_array_length (vala_compiler_cc_options);
		_tmp57_ = _tmp59_ != NULL;
	} else {
		_tmp57_ = FALSE;
	}
	if (_tmp57_) {
		vala_report_warning (NULL, "-X has no effect when -C or --ccode is set");
	}
	_tmp60_ = self->priv->context;
	_tmp61_ = vala_compiler_compile_only;
	vala_code_context_set_compile_only (_tmp60_, _tmp61_);
	_tmp62_ = self->priv->context;
	_tmp63_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp62_, _tmp63_);
	_tmp65_ = vala_compiler_header_filename;
	if (_tmp65_ == NULL) {
		gboolean _tmp66_ = FALSE;
		_tmp66_ = vala_compiler_use_header;
		_tmp64_ = _tmp66_;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp67_ = self->priv->context;
	_tmp68_ = vala_compiler_use_header;
	vala_code_context_set_use_header (_tmp67_, _tmp68_);
	_tmp69_ = self->priv->context;
	_tmp70_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp69_, _tmp70_);
	_tmp71_ = self->priv->context;
	_tmp72_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp71_, _tmp72_);
	_tmp73_ = self->priv->context;
	_tmp74_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp73_, _tmp74_);
	_tmp75_ = self->priv->context;
	_tmp76_ = vala_compiler_output;
	vala_code_context_set_output (_tmp75_, _tmp76_);
	_tmp78_ = vala_compiler_output;
	if (_tmp78_ != NULL) {
		gboolean _tmp79_ = FALSE;
		_tmp79_ = vala_compiler_ccode_only;
		_tmp77_ = _tmp79_;
	} else {
		_tmp77_ = FALSE;
	}
	if (_tmp77_) {
		vala_report_warning (NULL, "--output and -o have no effect when -C or --ccode is set");
	}
	_tmp80_ = vala_compiler_basedir;
	if (_tmp80_ == NULL) {
		ValaCodeContext* _tmp81_ = NULL;
		gchar* _tmp82_ = NULL;
		gchar* _tmp83_ = NULL;
		_tmp81_ = self->priv->context;
		_tmp82_ = vala_code_context_realpath (".");
		_tmp83_ = _tmp82_;
		vala_code_context_set_basedir (_tmp81_, _tmp83_);
		_g_free0 (_tmp83_);
	} else {
		ValaCodeContext* _tmp84_ = NULL;
		const gchar* _tmp85_ = NULL;
		gchar* _tmp86_ = NULL;
		gchar* _tmp87_ = NULL;
		_tmp84_ = self->priv->context;
		_tmp85_ = vala_compiler_basedir;
		_tmp86_ = vala_code_context_realpath (_tmp85_);
		_tmp87_ = _tmp86_;
		vala_code_context_set_basedir (_tmp84_, _tmp87_);
		_g_free0 (_tmp87_);
	}
	_tmp88_ = vala_compiler_directory;
	if (_tmp88_ != NULL) {
		ValaCodeContext* _tmp89_ = NULL;
		const gchar* _tmp90_ = NULL;
		gchar* _tmp91_ = NULL;
		gchar* _tmp92_ = NULL;
		_tmp89_ = self->priv->context;
		_tmp90_ = vala_compiler_directory;
		_tmp91_ = vala_code_context_realpath (_tmp90_);
		_tmp92_ = _tmp91_;
		vala_code_context_set_directory (_tmp89_, _tmp92_);
		_g_free0 (_tmp92_);
	} else {
		ValaCodeContext* _tmp93_ = NULL;
		ValaCodeContext* _tmp94_ = NULL;
		const gchar* _tmp95_ = NULL;
		const gchar* _tmp96_ = NULL;
		_tmp93_ = self->priv->context;
		_tmp94_ = self->priv->context;
		_tmp95_ = vala_code_context_get_basedir (_tmp94_);
		_tmp96_ = _tmp95_;
		vala_code_context_set_directory (_tmp93_, _tmp96_);
	}
	_tmp97_ = self->priv->context;
	_tmp98_ = vala_compiler_vapi_directories;
	_tmp98__length1 = _vala_array_length (vala_compiler_vapi_directories);
	_tmp99_ = (_tmp98_ != NULL) ? _vala_array_dup1 (_tmp98_, _tmp98__length1) : ((gpointer) _tmp98_);
	_tmp99__length1 = _tmp98__length1;
	_tmp97_->vapi_directories = (_vala_array_free (_tmp97_->vapi_directories, _tmp97_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp97_->vapi_directories = _tmp99_;
	_tmp97_->vapi_directories_length1 = _tmp99__length1;
	_tmp100_ = self->priv->context;
	_tmp101_ = vala_compiler_vapi_comments;
	vala_code_context_set_vapi_comments (_tmp100_, _tmp101_);
	_tmp102_ = self->priv->context;
	_tmp103_ = vala_compiler_gir_directories;
	_tmp103__length1 = _vala_array_length (vala_compiler_gir_directories);
	_tmp104_ = (_tmp103_ != NULL) ? _vala_array_dup2 (_tmp103_, _tmp103__length1) : ((gpointer) _tmp103_);
	_tmp104__length1 = _tmp103__length1;
	_tmp102_->gir_directories = (_vala_array_free (_tmp102_->gir_directories, _tmp102_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp102_->gir_directories = _tmp104_;
	_tmp102_->gir_directories_length1 = _tmp104__length1;
	_tmp105_ = self->priv->context;
	_tmp106_ = vala_compiler_metadata_directories;
	_tmp106__length1 = _vala_array_length (vala_compiler_metadata_directories);
	_tmp107_ = (_tmp106_ != NULL) ? _vala_array_dup3 (_tmp106_, _tmp106__length1) : ((gpointer) _tmp106_);
	_tmp107__length1 = _tmp106__length1;
	_tmp105_->metadata_directories = (_vala_array_free (_tmp105_->metadata_directories, _tmp105_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp105_->metadata_directories = _tmp107_;
	_tmp105_->metadata_directories_length1 = _tmp107__length1;
	_tmp108_ = self->priv->context;
	_tmp109_ = vala_compiler_debug;
	vala_code_context_set_debug (_tmp108_, _tmp109_);
	_tmp110_ = self->priv->context;
	_tmp111_ = vala_compiler_thread;
	vala_code_context_set_thread (_tmp110_, _tmp111_);
	_tmp112_ = self->priv->context;
	_tmp113_ = vala_compiler_mem_profiler;
	vala_code_context_set_mem_profiler (_tmp112_, _tmp113_);
	_tmp114_ = self->priv->context;
	_tmp115_ = vala_compiler_save_temps;
	vala_code_context_set_save_temps (_tmp114_, _tmp115_);
	_tmp117_ = vala_compiler_ccode_only;
	if (_tmp117_) {
		gboolean _tmp118_ = FALSE;
		_tmp118_ = vala_compiler_save_temps;
		_tmp116_ = _tmp118_;
	} else {
		_tmp116_ = FALSE;
	}
	if (_tmp116_) {
		vala_report_warning (NULL, "--save-temps has no effect when -C or --ccode is set");
	}
	_tmp121_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp121_, "gobject-2.0") == 0) {
		_tmp120_ = TRUE;
	} else {
		const gchar* _tmp122_ = NULL;
		_tmp122_ = vala_compiler_profile;
		_tmp120_ = g_strcmp0 (_tmp122_, "gobject") == 0;
	}
	if (_tmp120_) {
		_tmp119_ = TRUE;
	} else {
		const gchar* _tmp123_ = NULL;
		_tmp123_ = vala_compiler_profile;
		_tmp119_ = _tmp123_ == NULL;
	}
	if (_tmp119_) {
		ValaCodeContext* _tmp124_ = NULL;
		ValaCodeContext* _tmp125_ = NULL;
		_tmp124_ = self->priv->context;
		vala_code_context_set_profile (_tmp124_, VALA_PROFILE_GOBJECT);
		_tmp125_ = self->priv->context;
		vala_code_context_add_define (_tmp125_, "GOBJECT");
	} else {
		const gchar* _tmp126_ = NULL;
		gchar* _tmp127_ = NULL;
		gchar* _tmp128_ = NULL;
		_tmp126_ = vala_compiler_profile;
		_tmp127_ = g_strdup_printf ("Unknown profile %s", _tmp126_);
		_tmp128_ = _tmp127_;
		vala_report_error (NULL, _tmp128_);
		_g_free0 (_tmp128_);
	}
	_tmp129_ = vala_compiler_nostdpkg;
	_tmp130_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = _tmp129_ | (_tmp130_ != NULL);
	_tmp131_ = self->priv->context;
	_tmp132_ = vala_compiler_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp131_, _tmp132_);
	_tmp133_ = self->priv->context;
	_tmp134_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp133_, _tmp134_);
	_tmp135_ = self->priv->context;
	_tmp136_ = vala_compiler_run_output;
	vala_code_context_set_run_output (_tmp135_, _tmp136_);
	_tmp137_ = vala_compiler_defines;
	_tmp137__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp137_ != NULL) {
		gchar** _tmp138_ = NULL;
		gint _tmp138__length1 = 0;
		_tmp138_ = vala_compiler_defines;
		_tmp138__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp138_;
			define_collection_length1 = _tmp138__length1;
			for (define_it = 0; define_it < _tmp138__length1; define_it = define_it + 1) {
				gchar* _tmp139_ = NULL;
				gchar* define = NULL;
				_tmp139_ = g_strdup (define_collection[define_it]);
				define = _tmp139_;
				{
					ValaCodeContext* _tmp140_ = NULL;
					const gchar* _tmp141_ = NULL;
					_tmp140_ = self->priv->context;
					_tmp141_ = define;
					vala_code_context_add_define (_tmp140_, _tmp141_);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp142_ = FALSE;
			_tmp142_ = TRUE;
			while (TRUE) {
				gint _tmp144_ = 0;
				ValaCodeContext* _tmp145_ = NULL;
				gint _tmp146_ = 0;
				gchar* _tmp147_ = NULL;
				gchar* _tmp148_ = NULL;
				if (!_tmp142_) {
					gint _tmp143_ = 0;
					_tmp143_ = i;
					i = _tmp143_ + 2;
				}
				_tmp142_ = FALSE;
				_tmp144_ = i;
				if (!(_tmp144_ <= 30)) {
					break;
				}
				_tmp145_ = self->priv->context;
				_tmp146_ = i;
				_tmp147_ = g_strdup_printf ("VALA_0_%d", _tmp146_);
				_tmp148_ = _tmp147_;
				vala_code_context_add_define (_tmp145_, _tmp148_);
				_g_free0 (_tmp148_);
			}
		}
	}
	glib_major = 2;
	glib_minor = 24;
	_tmp150_ = vala_compiler_target_glib;
	if (_tmp150_ != NULL) {
		const gchar* _tmp151_ = NULL;
		gint _tmp152_ = 0;
		_tmp151_ = vala_compiler_target_glib;
		_tmp152_ = sscanf (_tmp151_, "%d.%d", &glib_major, &glib_minor);
		_tmp149_ = _tmp152_ != 2;
	} else {
		_tmp149_ = FALSE;
	}
	if (_tmp149_) {
		vala_report_error (NULL, "Invalid format for --target-glib");
	}
	_tmp153_ = self->priv->context;
	_tmp154_ = glib_major;
	vala_code_context_set_target_glib_major (_tmp153_, _tmp154_);
	_tmp155_ = self->priv->context;
	_tmp156_ = glib_minor;
	vala_code_context_set_target_glib_minor (_tmp155_, _tmp156_);
	_tmp157_ = self->priv->context;
	_tmp158_ = vala_code_context_get_target_glib_major (_tmp157_);
	_tmp159_ = _tmp158_;
	if (_tmp159_ != 2) {
		vala_report_error (NULL, "This version of valac only supports GLib 2");
	}
	{
		gint i = 0;
		i = 16;
		{
			gboolean _tmp160_ = FALSE;
			_tmp160_ = TRUE;
			while (TRUE) {
				gint _tmp162_ = 0;
				gint _tmp163_ = 0;
				ValaCodeContext* _tmp164_ = NULL;
				gint _tmp165_ = 0;
				gchar* _tmp166_ = NULL;
				gchar* _tmp167_ = NULL;
				if (!_tmp160_) {
					gint _tmp161_ = 0;
					_tmp161_ = i;
					i = _tmp161_ + 2;
				}
				_tmp160_ = FALSE;
				_tmp162_ = i;
				_tmp163_ = glib_minor;
				if (!(_tmp162_ <= _tmp163_)) {
					break;
				}
				_tmp164_ = self->priv->context;
				_tmp165_ = i;
				_tmp166_ = g_strdup_printf ("GLIB_2_%d", _tmp165_);
				_tmp167_ = _tmp166_;
				vala_code_context_add_define (_tmp164_, _tmp167_);
				_g_free0 (_tmp167_);
			}
		}
	}
	_tmp168_ = vala_compiler_nostdpkg;
	if (!_tmp168_) {
		ValaCodeContext* _tmp169_ = NULL;
		ValaCodeContext* _tmp170_ = NULL;
		_tmp169_ = self->priv->context;
		vala_code_context_add_external_package (_tmp169_, "glib-2.0");
		_tmp170_ = self->priv->context;
		vala_code_context_add_external_package (_tmp170_, "gobject-2.0");
	}
	_tmp171_ = vala_compiler_packages;
	_tmp171__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp171_ != NULL) {
		gchar** _tmp172_ = NULL;
		gint _tmp172__length1 = 0;
		_tmp172_ = vala_compiler_packages;
		_tmp172__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp172_;
			package_collection_length1 = _tmp172__length1;
			for (package_it = 0; package_it < _tmp172__length1; package_it = package_it + 1) {
				gchar* _tmp173_ = NULL;
				gchar* package = NULL;
				_tmp173_ = g_strdup (package_collection[package_it]);
				package = _tmp173_;
				{
					ValaCodeContext* _tmp174_ = NULL;
					const gchar* _tmp175_ = NULL;
					_tmp174_ = self->priv->context;
					_tmp175_ = package;
					vala_code_context_add_external_package (_tmp174_, _tmp175_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp176_ = vala_compiler_fast_vapis;
	_tmp176__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp176_ != NULL) {
		gchar** _tmp177_ = NULL;
		gint _tmp177__length1 = 0;
		ValaCodeContext* _tmp186_ = NULL;
		_tmp177_ = vala_compiler_fast_vapis;
		_tmp177__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp177_;
			vapi_collection_length1 = _tmp177__length1;
			for (vapi_it = 0; vapi_it < _tmp177__length1; vapi_it = vapi_it + 1) {
				gchar* _tmp178_ = NULL;
				gchar* vapi = NULL;
				_tmp178_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp178_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp179_ = NULL;
					gchar* _tmp180_ = NULL;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp181_ = NULL;
					const gchar* _tmp182_ = NULL;
					ValaSourceFile* _tmp183_ = NULL;
					ValaCodeContext* _tmp184_ = NULL;
					ValaSourceFile* _tmp185_ = NULL;
					_tmp179_ = vapi;
					_tmp180_ = vala_code_context_realpath (_tmp179_);
					rpath = _tmp180_;
					_tmp181_ = self->priv->context;
					_tmp182_ = rpath;
					_tmp183_ = vala_source_file_new (_tmp181_, VALA_SOURCE_FILE_TYPE_FAST, _tmp182_, NULL, FALSE);
					source_file = _tmp183_;
					_tmp184_ = self->priv->context;
					_tmp185_ = source_file;
					vala_code_context_add_source_file (_tmp184_, _tmp185_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp186_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp186_, TRUE);
	}
	_tmp187_ = self->priv->context;
	_tmp188_ = vala_compiler_gresources;
	_tmp188__length1 = _vala_array_length (vala_compiler_gresources);
	_tmp189_ = (_tmp188_ != NULL) ? _vala_array_dup4 (_tmp188_, _tmp188__length1) : ((gpointer) _tmp188_);
	_tmp189__length1 = _tmp188__length1;
	_tmp187_->gresources = (_vala_array_free (_tmp187_->gresources, _tmp187_->gresources_length1, (GDestroyNotify) g_free), NULL);
	_tmp187_->gresources = _tmp189_;
	_tmp187_->gresources_length1 = _tmp189__length1;
	_tmp191_ = self->priv->context;
	_tmp192_ = vala_code_context_get_report (_tmp191_);
	_tmp193_ = _tmp192_;
	_tmp194_ = vala_report_get_errors (_tmp193_);
	if (_tmp194_ > 0) {
		_tmp190_ = TRUE;
	} else {
		gboolean _tmp195_ = FALSE;
		gboolean _tmp196_ = FALSE;
		_tmp196_ = vala_compiler_fatal_warnings;
		if (_tmp196_) {
			ValaCodeContext* _tmp197_ = NULL;
			ValaReport* _tmp198_ = NULL;
			ValaReport* _tmp199_ = NULL;
			gint _tmp200_ = 0;
			_tmp197_ = self->priv->context;
			_tmp198_ = vala_code_context_get_report (_tmp197_);
			_tmp199_ = _tmp198_;
			_tmp200_ = vala_report_get_warnings (_tmp199_);
			_tmp195_ = _tmp200_ > 0;
		} else {
			_tmp195_ = FALSE;
		}
		_tmp190_ = _tmp195_;
	}
	if (_tmp190_) {
		gint _tmp201_ = 0;
		_tmp201_ = vala_compiler_quit (self);
		result = _tmp201_;
		return result;
	}
	_tmp202_ = self->priv->context;
	_tmp203_ = vala_gd_bus_server_module_new ();
	_tmp204_ = _tmp203_;
	vala_code_context_set_codegen (_tmp202_, (ValaCodeGenerator*) _tmp204_);
	_vala_code_visitor_unref0 (_tmp204_);
	has_c_files = FALSE;
	has_h_files = FALSE;
	_tmp205_ = vala_compiler_sources;
	_tmp205__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp205_;
		source_collection_length1 = _tmp205__length1;
		for (source_it = 0; source_it < _tmp205__length1; source_it = source_it + 1) {
			gchar* _tmp206_ = NULL;
			gchar* source = NULL;
			_tmp206_ = g_strdup (source_collection[source_it]);
			source = _tmp206_;
			{
				ValaCodeContext* _tmp207_ = NULL;
				const gchar* _tmp208_ = NULL;
				gboolean _tmp209_ = FALSE;
				gboolean _tmp210_ = FALSE;
				_tmp207_ = self->priv->context;
				_tmp208_ = source;
				_tmp209_ = vala_compiler_run_output;
				_tmp210_ = vala_code_context_add_source_filename (_tmp207_, _tmp208_, _tmp209_, TRUE);
				if (_tmp210_) {
					const gchar* _tmp211_ = NULL;
					gboolean _tmp212_ = FALSE;
					_tmp211_ = source;
					_tmp212_ = g_str_has_suffix (_tmp211_, ".c");
					if (_tmp212_) {
						has_c_files = TRUE;
					} else {
						const gchar* _tmp213_ = NULL;
						gboolean _tmp214_ = FALSE;
						_tmp213_ = source;
						_tmp214_ = g_str_has_suffix (_tmp213_, ".h");
						if (_tmp214_) {
							has_h_files = TRUE;
						}
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	_tmp216_ = vala_compiler_ccode_only;
	if (_tmp216_) {
		gboolean _tmp217_ = FALSE;
		gboolean _tmp218_ = FALSE;
		_tmp218_ = has_c_files;
		if (_tmp218_) {
			_tmp217_ = TRUE;
		} else {
			gboolean _tmp219_ = FALSE;
			_tmp219_ = has_h_files;
			_tmp217_ = _tmp219_;
		}
		_tmp215_ = _tmp217_;
	} else {
		_tmp215_ = FALSE;
	}
	if (_tmp215_) {
		vala_report_warning (NULL, "C header and source files are ignored when -C or --ccode is set");
	}
	_tmp221_ = self->priv->context;
	_tmp222_ = vala_code_context_get_report (_tmp221_);
	_tmp223_ = _tmp222_;
	_tmp224_ = vala_report_get_errors (_tmp223_);
	if (_tmp224_ > 0) {
		_tmp220_ = TRUE;
	} else {
		gboolean _tmp225_ = FALSE;
		gboolean _tmp226_ = FALSE;
		_tmp226_ = vala_compiler_fatal_warnings;
		if (_tmp226_) {
			ValaCodeContext* _tmp227_ = NULL;
			ValaReport* _tmp228_ = NULL;
			ValaReport* _tmp229_ = NULL;
			gint _tmp230_ = 0;
			_tmp227_ = self->priv->context;
			_tmp228_ = vala_code_context_get_report (_tmp227_);
			_tmp229_ = _tmp228_;
			_tmp230_ = vala_report_get_warnings (_tmp229_);
			_tmp225_ = _tmp230_ > 0;
		} else {
			_tmp225_ = FALSE;
		}
		_tmp220_ = _tmp225_;
	}
	if (_tmp220_) {
		gint _tmp231_ = 0;
		_tmp231_ = vala_compiler_quit (self);
		result = _tmp231_;
		return result;
	}
	_tmp232_ = vala_parser_new ();
	parser = _tmp232_;
	_tmp233_ = parser;
	_tmp234_ = self->priv->context;
	vala_parser_parse (_tmp233_, _tmp234_);
	_tmp235_ = vala_genie_parser_new ();
	genie_parser = _tmp235_;
	_tmp236_ = genie_parser;
	_tmp237_ = self->priv->context;
	vala_genie_parser_parse (_tmp236_, _tmp237_);
	_tmp238_ = vala_gir_parser_new ();
	gir_parser = _tmp238_;
	_tmp239_ = gir_parser;
	_tmp240_ = self->priv->context;
	vala_gir_parser_parse (_tmp239_, _tmp240_);
	_tmp242_ = self->priv->context;
	_tmp243_ = vala_code_context_get_report (_tmp242_);
	_tmp244_ = _tmp243_;
	_tmp245_ = vala_report_get_errors (_tmp244_);
	if (_tmp245_ > 0) {
		_tmp241_ = TRUE;
	} else {
		gboolean _tmp246_ = FALSE;
		gboolean _tmp247_ = FALSE;
		_tmp247_ = vala_compiler_fatal_warnings;
		if (_tmp247_) {
			ValaCodeContext* _tmp248_ = NULL;
			ValaReport* _tmp249_ = NULL;
			ValaReport* _tmp250_ = NULL;
			gint _tmp251_ = 0;
			_tmp248_ = self->priv->context;
			_tmp249_ = vala_code_context_get_report (_tmp248_);
			_tmp250_ = _tmp249_;
			_tmp251_ = vala_report_get_warnings (_tmp250_);
			_tmp246_ = _tmp251_ > 0;
		} else {
			_tmp246_ = FALSE;
		}
		_tmp241_ = _tmp246_;
	}
	if (_tmp241_) {
		gint _tmp252_ = 0;
		_tmp252_ = vala_compiler_quit (self);
		result = _tmp252_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp253_ = vala_compiler_fast_vapi_filename;
	if (_tmp253_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp254_ = NULL;
		ValaCodeWriter* _tmp255_ = NULL;
		ValaCodeContext* _tmp256_ = NULL;
		const gchar* _tmp257_ = NULL;
		gint _tmp258_ = 0;
		_tmp254_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp254_;
		_tmp255_ = interface_writer;
		_tmp256_ = self->priv->context;
		_tmp257_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp255_, _tmp256_, _tmp257_);
		_tmp258_ = vala_compiler_quit (self);
		result = _tmp258_;
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp259_ = self->priv->context;
	vala_code_context_check (_tmp259_);
	_tmp261_ = self->priv->context;
	_tmp262_ = vala_code_context_get_report (_tmp261_);
	_tmp263_ = _tmp262_;
	_tmp264_ = vala_report_get_errors (_tmp263_);
	if (_tmp264_ > 0) {
		_tmp260_ = TRUE;
	} else {
		gboolean _tmp265_ = FALSE;
		gboolean _tmp266_ = FALSE;
		_tmp266_ = vala_compiler_fatal_warnings;
		if (_tmp266_) {
			ValaCodeContext* _tmp267_ = NULL;
			ValaReport* _tmp268_ = NULL;
			ValaReport* _tmp269_ = NULL;
			gint _tmp270_ = 0;
			_tmp267_ = self->priv->context;
			_tmp268_ = vala_code_context_get_report (_tmp267_);
			_tmp269_ = _tmp268_;
			_tmp270_ = vala_report_get_warnings (_tmp269_);
			_tmp265_ = _tmp270_ > 0;
		} else {
			_tmp265_ = FALSE;
		}
		_tmp260_ = _tmp265_;
	}
	if (_tmp260_) {
		gint _tmp271_ = 0;
		_tmp271_ = vala_compiler_quit (self);
		result = _tmp271_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp274_ = vala_compiler_ccode_only;
	if (!_tmp274_) {
		gboolean _tmp275_ = FALSE;
		_tmp275_ = vala_compiler_compile_only;
		_tmp273_ = !_tmp275_;
	} else {
		_tmp273_ = FALSE;
	}
	if (_tmp273_) {
		const gchar* _tmp276_ = NULL;
		_tmp276_ = vala_compiler_library;
		_tmp272_ = _tmp276_ == NULL;
	} else {
		_tmp272_ = FALSE;
	}
	if (_tmp272_) {
		gboolean _tmp277_ = FALSE;
		gboolean _tmp278_ = FALSE;
		_tmp278_ = has_c_files;
		if (!_tmp278_) {
			ValaCodeContext* _tmp279_ = NULL;
			ValaMethod* _tmp280_ = NULL;
			ValaMethod* _tmp281_ = NULL;
			_tmp279_ = self->priv->context;
			_tmp280_ = vala_code_context_get_entry_point (_tmp279_);
			_tmp281_ = _tmp280_;
			_tmp277_ = _tmp281_ == NULL;
		} else {
			_tmp277_ = FALSE;
		}
		if (_tmp277_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp282_ = vala_compiler_dump_tree;
	if (_tmp282_ != NULL) {
		ValaCodeWriter* code_writer = NULL;
		ValaCodeWriter* _tmp283_ = NULL;
		ValaCodeWriter* _tmp284_ = NULL;
		ValaCodeContext* _tmp285_ = NULL;
		const gchar* _tmp286_ = NULL;
		_tmp283_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp283_;
		_tmp284_ = code_writer;
		_tmp285_ = self->priv->context;
		_tmp286_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp284_, _tmp285_, _tmp286_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp288_ = self->priv->context;
	_tmp289_ = vala_code_context_get_report (_tmp288_);
	_tmp290_ = _tmp289_;
	_tmp291_ = vala_report_get_errors (_tmp290_);
	if (_tmp291_ > 0) {
		_tmp287_ = TRUE;
	} else {
		gboolean _tmp292_ = FALSE;
		gboolean _tmp293_ = FALSE;
		_tmp293_ = vala_compiler_fatal_warnings;
		if (_tmp293_) {
			ValaCodeContext* _tmp294_ = NULL;
			ValaReport* _tmp295_ = NULL;
			ValaReport* _tmp296_ = NULL;
			gint _tmp297_ = 0;
			_tmp294_ = self->priv->context;
			_tmp295_ = vala_code_context_get_report (_tmp294_);
			_tmp296_ = _tmp295_;
			_tmp297_ = vala_report_get_warnings (_tmp296_);
			_tmp292_ = _tmp297_ > 0;
		} else {
			_tmp292_ = FALSE;
		}
		_tmp287_ = _tmp292_;
	}
	if (_tmp287_) {
		gint _tmp298_ = 0;
		_tmp298_ = vala_compiler_quit (self);
		result = _tmp298_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp299_ = self->priv->context;
	_tmp300_ = vala_code_context_get_codegen (_tmp299_);
	_tmp301_ = _tmp300_;
	_tmp302_ = self->priv->context;
	vala_code_generator_emit (_tmp301_, _tmp302_);
	_tmp304_ = self->priv->context;
	_tmp305_ = vala_code_context_get_report (_tmp304_);
	_tmp306_ = _tmp305_;
	_tmp307_ = vala_report_get_errors (_tmp306_);
	if (_tmp307_ > 0) {
		_tmp303_ = TRUE;
	} else {
		gboolean _tmp308_ = FALSE;
		gboolean _tmp309_ = FALSE;
		_tmp309_ = vala_compiler_fatal_warnings;
		if (_tmp309_) {
			ValaCodeContext* _tmp310_ = NULL;
			ValaReport* _tmp311_ = NULL;
			ValaReport* _tmp312_ = NULL;
			gint _tmp313_ = 0;
			_tmp310_ = self->priv->context;
			_tmp311_ = vala_code_context_get_report (_tmp310_);
			_tmp312_ = _tmp311_;
			_tmp313_ = vala_report_get_warnings (_tmp312_);
			_tmp308_ = _tmp313_ > 0;
		} else {
			_tmp308_ = FALSE;
		}
		_tmp303_ = _tmp308_;
	}
	if (_tmp303_) {
		gint _tmp314_ = 0;
		_tmp314_ = vala_compiler_quit (self);
		result = _tmp314_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp316_ = vala_compiler_vapi_filename;
	if (_tmp316_ == NULL) {
		const gchar* _tmp317_ = NULL;
		_tmp317_ = vala_compiler_library;
		_tmp315_ = _tmp317_ != NULL;
	} else {
		_tmp315_ = FALSE;
	}
	if (_tmp315_) {
		const gchar* _tmp318_ = NULL;
		gchar* _tmp319_ = NULL;
		_tmp318_ = vala_compiler_library;
		_tmp319_ = g_strdup_printf ("%s.vapi", _tmp318_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp319_;
	}
	_tmp320_ = vala_compiler_library;
	if (_tmp320_ != NULL) {
		const gchar* _tmp321_ = NULL;
		_tmp321_ = vala_compiler_gir;
		if (_tmp321_ != NULL) {
			gchar* gir_base = NULL;
			const gchar* _tmp322_ = NULL;
			gchar* _tmp323_ = NULL;
			glong gir_len = 0L;
			const gchar* _tmp324_ = NULL;
			gint _tmp325_ = 0;
			gint _tmp326_ = 0;
			gint last_hyphen = 0;
			const gchar* _tmp327_ = NULL;
			gint _tmp328_ = 0;
			gboolean _tmp329_ = FALSE;
			gint _tmp330_ = 0;
			_tmp322_ = vala_compiler_gir;
			_tmp323_ = g_path_get_basename (_tmp322_);
			gir_base = _tmp323_;
			_tmp324_ = gir_base;
			_tmp325_ = strlen (_tmp324_);
			_tmp326_ = _tmp325_;
			gir_len = (glong) _tmp326_;
			_tmp327_ = gir_base;
			_tmp328_ = string_last_index_of_char (_tmp327_, (gunichar) '-', 0);
			last_hyphen = _tmp328_;
			_tmp330_ = last_hyphen;
			if (_tmp330_ == -1) {
				_tmp329_ = TRUE;
			} else {
				const gchar* _tmp331_ = NULL;
				gboolean _tmp332_ = FALSE;
				_tmp331_ = gir_base;
				_tmp332_ = g_str_has_suffix (_tmp331_, ".gir");
				_tmp329_ = !_tmp332_;
			}
			if (_tmp329_) {
				const gchar* _tmp333_ = NULL;
				gchar* _tmp334_ = NULL;
				gchar* _tmp335_ = NULL;
				_tmp333_ = vala_compiler_gir;
				_tmp334_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp333_);
				_tmp335_ = _tmp334_;
				vala_report_error (NULL, _tmp335_);
				_g_free0 (_tmp335_);
			} else {
				gchar* gir_namespace = NULL;
				const gchar* _tmp336_ = NULL;
				gint _tmp337_ = 0;
				gchar* _tmp338_ = NULL;
				gchar* gir_version = NULL;
				const gchar* _tmp339_ = NULL;
				gint _tmp340_ = 0;
				glong _tmp341_ = 0L;
				gint _tmp342_ = 0;
				gchar* _tmp343_ = NULL;
				const gchar* _tmp344_ = NULL;
				gboolean _tmp345_ = FALSE;
				gboolean _tmp346_ = FALSE;
				gboolean _tmp347_ = FALSE;
				const gchar* _tmp348_ = NULL;
				_tmp336_ = gir_base;
				_tmp337_ = last_hyphen;
				_tmp338_ = string_substring (_tmp336_, (glong) 0, (glong) _tmp337_);
				gir_namespace = _tmp338_;
				_tmp339_ = gir_base;
				_tmp340_ = last_hyphen;
				_tmp341_ = gir_len;
				_tmp342_ = last_hyphen;
				_tmp343_ = string_substring (_tmp339_, (glong) (_tmp340_ + 1), (_tmp341_ - _tmp342_) - 5);
				gir_version = _tmp343_;
				_tmp344_ = gir_version;
				g_strcanon (_tmp344_, "0123456789.", '?');
				_tmp348_ = gir_namespace;
				if (g_strcmp0 (_tmp348_, "") == 0) {
					_tmp347_ = TRUE;
				} else {
					const gchar* _tmp349_ = NULL;
					_tmp349_ = gir_version;
					_tmp347_ = g_strcmp0 (_tmp349_, "") == 0;
				}
				if (_tmp347_) {
					_tmp346_ = TRUE;
				} else {
					const gchar* _tmp350_ = NULL;
					gchar _tmp351_ = '\0';
					gboolean _tmp352_ = FALSE;
					_tmp350_ = gir_version;
					_tmp351_ = string_get (_tmp350_, (glong) 0);
					_tmp352_ = g_ascii_isdigit (_tmp351_);
					_tmp346_ = !_tmp352_;
				}
				if (_tmp346_) {
					_tmp345_ = TRUE;
				} else {
					const gchar* _tmp353_ = NULL;
					gboolean _tmp354_ = FALSE;
					_tmp353_ = gir_version;
					_tmp354_ = string_contains (_tmp353_, "?");
					_tmp345_ = _tmp354_;
				}
				if (_tmp345_) {
					const gchar* _tmp355_ = NULL;
					gchar* _tmp356_ = NULL;
					gchar* _tmp357_ = NULL;
					_tmp355_ = vala_compiler_gir;
					_tmp356_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp355_);
					_tmp357_ = _tmp356_;
					vala_report_error (NULL, _tmp357_);
					_g_free0 (_tmp357_);
				} else {
					ValaGIRWriter* gir_writer = NULL;
					ValaGIRWriter* _tmp358_ = NULL;
					gchar* gir_directory = NULL;
					gchar* _tmp359_ = NULL;
					const gchar* _tmp360_ = NULL;
					ValaGIRWriter* _tmp365_ = NULL;
					ValaCodeContext* _tmp366_ = NULL;
					const gchar* _tmp367_ = NULL;
					const gchar* _tmp368_ = NULL;
					const gchar* _tmp369_ = NULL;
					const gchar* _tmp370_ = NULL;
					const gchar* _tmp371_ = NULL;
					_tmp358_ = vala_gir_writer_new ();
					gir_writer = _tmp358_;
					_tmp359_ = g_strdup (".");
					gir_directory = _tmp359_;
					_tmp360_ = vala_compiler_directory;
					if (_tmp360_ != NULL) {
						ValaCodeContext* _tmp361_ = NULL;
						const gchar* _tmp362_ = NULL;
						const gchar* _tmp363_ = NULL;
						gchar* _tmp364_ = NULL;
						_tmp361_ = self->priv->context;
						_tmp362_ = vala_code_context_get_directory (_tmp361_);
						_tmp363_ = _tmp362_;
						_tmp364_ = g_strdup (_tmp363_);
						_g_free0 (gir_directory);
						gir_directory = _tmp364_;
					}
					_tmp365_ = gir_writer;
					_tmp366_ = self->priv->context;
					_tmp367_ = gir_directory;
					_tmp368_ = vala_compiler_gir;
					_tmp369_ = gir_namespace;
					_tmp370_ = gir_version;
					_tmp371_ = vala_compiler_library;
					vala_gir_writer_write_file (_tmp365_, _tmp366_, _tmp367_, _tmp368_, _tmp369_, _tmp370_, _tmp371_);
					_g_free0 (gir_directory);
					_vala_code_visitor_unref0 (gir_writer);
				}
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
			_g_free0 (gir_base);
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	}
	_tmp372_ = vala_compiler_vapi_filename;
	if (_tmp372_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp373_ = NULL;
		gboolean _tmp374_ = FALSE;
		const gchar* _tmp375_ = NULL;
		ValaCodeWriter* _tmp383_ = NULL;
		ValaCodeContext* _tmp384_ = NULL;
		const gchar* _tmp385_ = NULL;
		_tmp373_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp373_;
		_tmp375_ = vala_compiler_directory;
		if (_tmp375_ != NULL) {
			const gchar* _tmp376_ = NULL;
			gboolean _tmp377_ = FALSE;
			_tmp376_ = vala_compiler_vapi_filename;
			_tmp377_ = g_path_is_absolute (_tmp376_);
			_tmp374_ = !_tmp377_;
		} else {
			_tmp374_ = FALSE;
		}
		if (_tmp374_) {
			ValaCodeContext* _tmp378_ = NULL;
			const gchar* _tmp379_ = NULL;
			const gchar* _tmp380_ = NULL;
			const gchar* _tmp381_ = NULL;
			gchar* _tmp382_ = NULL;
			_tmp378_ = self->priv->context;
			_tmp379_ = vala_code_context_get_directory (_tmp378_);
			_tmp380_ = _tmp379_;
			_tmp381_ = vala_compiler_vapi_filename;
			_tmp382_ = g_strdup_printf ("%s%c%s", _tmp380_, (gint) G_DIR_SEPARATOR, _tmp381_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp382_;
		}
		_tmp383_ = interface_writer;
		_tmp384_ = self->priv->context;
		_tmp385_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp383_, _tmp384_, _tmp385_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp386_ = vala_compiler_internal_vapi_filename;
	if (_tmp386_ != NULL) {
		gboolean _tmp387_ = FALSE;
		const gchar* _tmp388_ = NULL;
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp391_ = NULL;
		ValaCodeWriter* _tmp392_ = NULL;
		const gchar* _tmp393_ = NULL;
		const gchar* _tmp394_ = NULL;
		gchar* vapi_filename = NULL;
		const gchar* _tmp395_ = NULL;
		gchar* _tmp396_ = NULL;
		gboolean _tmp397_ = FALSE;
		const gchar* _tmp398_ = NULL;
		ValaCodeWriter* _tmp406_ = NULL;
		ValaCodeContext* _tmp407_ = NULL;
		const gchar* _tmp408_ = NULL;
		_tmp388_ = vala_compiler_internal_header_filename;
		if (_tmp388_ == NULL) {
			_tmp387_ = TRUE;
		} else {
			const gchar* _tmp389_ = NULL;
			_tmp389_ = vala_compiler_header_filename;
			_tmp387_ = _tmp389_ == NULL;
		}
		if (_tmp387_) {
			gint _tmp390_ = 0;
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			_tmp390_ = vala_compiler_quit (self);
			result = _tmp390_;
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp391_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp391_;
		_tmp392_ = interface_writer;
		_tmp393_ = vala_compiler_header_filename;
		_tmp394_ = vala_compiler_internal_header_filename;
		vala_code_writer_set_cheader_override (_tmp392_, _tmp393_, _tmp394_);
		_tmp395_ = vala_compiler_internal_vapi_filename;
		_tmp396_ = g_strdup (_tmp395_);
		vapi_filename = _tmp396_;
		_tmp398_ = vala_compiler_directory;
		if (_tmp398_ != NULL) {
			const gchar* _tmp399_ = NULL;
			gboolean _tmp400_ = FALSE;
			_tmp399_ = vapi_filename;
			_tmp400_ = g_path_is_absolute (_tmp399_);
			_tmp397_ = !_tmp400_;
		} else {
			_tmp397_ = FALSE;
		}
		if (_tmp397_) {
			ValaCodeContext* _tmp401_ = NULL;
			const gchar* _tmp402_ = NULL;
			const gchar* _tmp403_ = NULL;
			const gchar* _tmp404_ = NULL;
			gchar* _tmp405_ = NULL;
			_tmp401_ = self->priv->context;
			_tmp402_ = vala_code_context_get_directory (_tmp401_);
			_tmp403_ = _tmp402_;
			_tmp404_ = vapi_filename;
			_tmp405_ = g_strdup_printf ("%s%c%s", _tmp403_, (gint) G_DIR_SEPARATOR, _tmp404_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp405_;
		}
		_tmp406_ = interface_writer;
		_tmp407_ = self->priv->context;
		_tmp408_ = vapi_filename;
		vala_code_writer_write_file (_tmp406_, _tmp407_, _tmp408_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp409_ = vala_compiler_dependencies;
	if (_tmp409_ != NULL) {
		ValaCodeContext* _tmp410_ = NULL;
		const gchar* _tmp411_ = NULL;
		_tmp410_ = self->priv->context;
		_tmp411_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp410_, _tmp411_);
	}
	_tmp412_ = self->priv->context;
	_tmp413_ = vala_code_context_get_used_attr (_tmp412_);
	_tmp414_ = _tmp413_;
	_tmp415_ = self->priv->context;
	vala_used_attr_check_unused (_tmp414_, _tmp415_);
	_tmp417_ = self->priv->context;
	_tmp418_ = vala_code_context_get_report (_tmp417_);
	_tmp419_ = _tmp418_;
	_tmp420_ = vala_report_get_errors (_tmp419_);
	if (_tmp420_ > 0) {
		_tmp416_ = TRUE;
	} else {
		gboolean _tmp421_ = FALSE;
		gboolean _tmp422_ = FALSE;
		_tmp422_ = vala_compiler_fatal_warnings;
		if (_tmp422_) {
			ValaCodeContext* _tmp423_ = NULL;
			ValaReport* _tmp424_ = NULL;
			ValaReport* _tmp425_ = NULL;
			gint _tmp426_ = 0;
			_tmp423_ = self->priv->context;
			_tmp424_ = vala_code_context_get_report (_tmp423_);
			_tmp425_ = _tmp424_;
			_tmp426_ = vala_report_get_warnings (_tmp425_);
			_tmp421_ = _tmp426_ > 0;
		} else {
			_tmp421_ = FALSE;
		}
		_tmp416_ = _tmp421_;
	}
	if (_tmp416_) {
		gint _tmp427_ = 0;
		_tmp427_ = vala_compiler_quit (self);
		result = _tmp427_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp428_ = vala_compiler_ccode_only;
	if (!_tmp428_) {
		ValaCCodeCompiler* ccompiler = NULL;
		ValaCCodeCompiler* _tmp429_ = NULL;
		gboolean _tmp430_ = FALSE;
		const gchar* _tmp431_ = NULL;
		gboolean _tmp435_ = FALSE;
		const gchar* _tmp436_ = NULL;
		gchar** _tmp440_ = NULL;
		gint _tmp440__length1 = 0;
		_tmp429_ = vala_ccode_compiler_new ();
		ccompiler = _tmp429_;
		_tmp431_ = vala_compiler_cc_command;
		if (_tmp431_ == NULL) {
			const gchar* _tmp432_ = NULL;
			_tmp432_ = g_getenv ("CC");
			_tmp430_ = _tmp432_ != NULL;
		} else {
			_tmp430_ = FALSE;
		}
		if (_tmp430_) {
			const gchar* _tmp433_ = NULL;
			gchar* _tmp434_ = NULL;
			_tmp433_ = g_getenv ("CC");
			_tmp434_ = g_strdup (_tmp433_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp434_;
		}
		_tmp436_ = vala_compiler_pkg_config_command;
		if (_tmp436_ == NULL) {
			const gchar* _tmp437_ = NULL;
			_tmp437_ = g_getenv ("PKG_CONFIG");
			_tmp435_ = _tmp437_ != NULL;
		} else {
			_tmp435_ = FALSE;
		}
		if (_tmp435_) {
			const gchar* _tmp438_ = NULL;
			gchar* _tmp439_ = NULL;
			_tmp438_ = g_getenv ("PKG_CONFIG");
			_tmp439_ = g_strdup (_tmp438_);
			_g_free0 (vala_compiler_pkg_config_command);
			vala_compiler_pkg_config_command = _tmp439_;
		}
		_tmp440_ = vala_compiler_cc_options;
		_tmp440__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp440_ == NULL) {
			ValaCCodeCompiler* _tmp441_ = NULL;
			ValaCodeContext* _tmp442_ = NULL;
			const gchar* _tmp443_ = NULL;
			gchar** _tmp444_ = NULL;
			gchar** _tmp445_ = NULL;
			gint _tmp445__length1 = 0;
			const gchar* _tmp446_ = NULL;
			_tmp441_ = ccompiler;
			_tmp442_ = self->priv->context;
			_tmp443_ = vala_compiler_cc_command;
			_tmp444_ = g_new0 (gchar*, 0 + 1);
			_tmp445_ = _tmp444_;
			_tmp445__length1 = 0;
			_tmp446_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp441_, _tmp442_, _tmp443_, _tmp445_, 0, _tmp446_);
			_tmp445_ = (_vala_array_free (_tmp445_, _tmp445__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp447_ = NULL;
			ValaCodeContext* _tmp448_ = NULL;
			const gchar* _tmp449_ = NULL;
			gchar** _tmp450_ = NULL;
			gint _tmp450__length1 = 0;
			const gchar* _tmp451_ = NULL;
			_tmp447_ = ccompiler;
			_tmp448_ = self->priv->context;
			_tmp449_ = vala_compiler_cc_command;
			_tmp450_ = vala_compiler_cc_options;
			_tmp450__length1 = _vala_array_length (vala_compiler_cc_options);
			_tmp451_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp447_, _tmp448_, _tmp449_, _tmp450_, _tmp450__length1, _tmp451_);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	_tmp452_ = vala_compiler_quit (self);
	result = _tmp452_;
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda4_ (Block1Data* _data1_, GPid pid, gint status) {
	gint _tmp0_ = 0;
	GMainLoop* _tmp1_ = NULL;
	_tmp0_ = status;
	_data1_->child_status = (_tmp0_ & 0xff00) >> 8;
	_tmp1_ = _data1_->loop;
	g_main_loop_quit (_tmp1_);
}


static void ____lambda4__gchild_watch_func (GPid pid, gint status, gpointer self) {
	___lambda4_ (self, pid, status);
}


static gint vala_compiler_run_source (gchar** args, int args_length1) {
	gint result = 0;
	gint i = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp29_ = FALSE;
	gchar** _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	gint _tmp36_ = 0;
	const gchar* _tmp37_ = NULL;
	gchar** _tmp39_ = NULL;
	gint _tmp39__length1 = 0;
	gint _tmp40_ = 0;
	const gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar** _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	gchar** _tmp45_ = NULL;
	gint _tmp45__length1 = 0;
	gint _tmp46_ = 0;
	const gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gint outputfd = 0;
	const gchar* _tmp51_ = NULL;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp54_ = NULL;
	gint ret = 0;
	ValaCompiler* _tmp55_ = NULL;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	gint _tmp58_ = 0;
	const gchar* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gchar** target_args = NULL;
	const gchar* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	gchar** _tmp64_ = NULL;
	gint target_args_length1 = 0;
	gint _target_args_size_ = 0;
	GError * _inner_error_ = NULL;
	i = 1;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = i;
	_tmp3_ = _tmp1_[_tmp2_];
	if (_tmp3_ != NULL) {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gint _tmp5_ = 0;
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = args;
		_tmp4__length1 = args_length1;
		_tmp5_ = i;
		_tmp6_ = _tmp4_[_tmp5_];
		_tmp7_ = g_str_has_prefix (_tmp6_, "-");
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp28_ = 0;
		{
			gchar** compile_args = NULL;
			gint compile_args_length1 = 0;
			gint _compile_args_size_ = 0;
			gchar** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar** _tmp12_ = NULL;
			gint _tmp13_ = 0;
			GOptionContext* opt_context = NULL;
			GOptionContext* _tmp14_ = NULL;
			GOptionContext* _tmp15_ = NULL;
			GOptionContext* _tmp16_ = NULL;
			gchar** temp_args = NULL;
			gchar** _tmp17_ = NULL;
			gint _tmp17__length1 = 0;
			gint temp_args_length1 = 0;
			gint _temp_args_size_ = 0;
			GOptionContext* _tmp18_ = NULL;
			_tmp8_ = args;
			_tmp8__length1 = args_length1;
			_tmp9_ = _tmp8_[1];
			_tmp10_ = g_strconcat ("valac ", _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			g_shell_parse_argv (_tmp11_, &_tmp13_, &_tmp12_, &_inner_error_);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
			compile_args = _tmp12_;
			compile_args_length1 = _tmp13_;
			_compile_args_size_ = compile_args_length1;
			_g_free0 (_tmp11_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_tmp14_ = g_option_context_new ("- Vala");
			opt_context = _tmp14_;
			_tmp15_ = opt_context;
			g_option_context_set_help_enabled (_tmp15_, TRUE);
			_tmp16_ = opt_context;
			g_option_context_add_main_entries (_tmp16_, VALA_COMPILER_options, NULL);
			_tmp17_ = compile_args;
			_tmp17__length1 = compile_args_length1;
			temp_args = _tmp17_;
			temp_args_length1 = _tmp17__length1;
			_temp_args_size_ = temp_args_length1;
			_tmp18_ = opt_context;
			g_option_context_parse (_tmp18_, &temp_args_length1, &temp_args, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_g_option_context_free0 (opt_context);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally0;
		__catch0_g_shell_error:
		{
			GError* e = NULL;
			FILE* _tmp19_ = NULL;
			GError* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp19_ = stdout;
			_tmp20_ = e;
			_tmp21_ = _tmp20_->message;
			fprintf (_tmp19_, "%s\n", _tmp21_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		goto __finally0;
		__catch0_g_option_error:
		{
			GError* e = NULL;
			FILE* _tmp22_ = NULL;
			GError* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			FILE* _tmp25_ = NULL;
			gchar** _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			const gchar* _tmp27_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp22_ = stdout;
			_tmp23_ = e;
			_tmp24_ = _tmp23_->message;
			fprintf (_tmp22_, "%s\n", _tmp24_);
			_tmp25_ = stdout;
			_tmp26_ = args;
			_tmp26__length1 = args_length1;
			_tmp27_ = _tmp26_[0];
			fprintf (_tmp25_, "Run '%s --help' to see a full list of available command line options.\n", _tmp27_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp28_ = i;
		i = _tmp28_ + 1;
	}
	_tmp29_ = vala_compiler_version;
	if (_tmp29_) {
		FILE* _tmp30_ = NULL;
		_tmp30_ = stdout;
		fprintf (_tmp30_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp31_ = FALSE;
		_tmp31_ = vala_compiler_api_version;
		if (_tmp31_) {
			FILE* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			_tmp32_ = stdout;
			_tmp33_ = string_substring (PACKAGE_SUFFIX, (glong) 1, (glong) -1);
			_tmp34_ = _tmp33_;
			fprintf (_tmp32_, "%s\n", _tmp34_);
			_g_free0 (_tmp34_);
			result = 0;
			return result;
		}
	}
	_tmp35_ = args;
	_tmp35__length1 = args_length1;
	_tmp36_ = i;
	_tmp37_ = _tmp35_[_tmp36_];
	if (_tmp37_ == NULL) {
		FILE* _tmp38_ = NULL;
		_tmp38_ = stderr;
		fprintf (_tmp38_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp39_ = args;
	_tmp39__length1 = args_length1;
	_tmp40_ = i;
	_tmp41_ = _tmp39_[_tmp40_];
	_tmp42_ = g_strdup (_tmp41_);
	_tmp43_ = g_new0 (gchar*, 1 + 1);
	_tmp43_[0] = _tmp42_;
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = _tmp43_;
	_tmp44_ = g_get_tmp_dir ();
	_tmp45_ = args;
	_tmp45__length1 = args_length1;
	_tmp46_ = i;
	_tmp47_ = _tmp45_[_tmp46_];
	_tmp48_ = g_path_get_basename (_tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp44_, _tmp49_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp50_;
	_g_free0 (_tmp49_);
	_tmp51_ = vala_compiler_output;
	_tmp52_ = g_mkstemp (_tmp51_);
	outputfd = _tmp52_;
	_tmp53_ = outputfd;
	if (_tmp53_ < 0) {
		result = 1;
		return result;
	}
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_tmp54_ = vala_compiler_new ();
	compiler = _tmp54_;
	_tmp55_ = compiler;
	_tmp56_ = vala_compiler_run (_tmp55_);
	ret = _tmp56_;
	_tmp57_ = ret;
	if (_tmp57_ != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp58_ = outputfd;
	close (_tmp58_);
	_tmp59_ = vala_compiler_output;
	_tmp60_ = g_chmod (_tmp59_, 0700);
	if (_tmp60_ != 0) {
		const gchar* _tmp61_ = NULL;
		_tmp61_ = vala_compiler_output;
		g_unlink (_tmp61_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp62_ = vala_compiler_output;
	_tmp63_ = g_strdup (_tmp62_);
	_tmp64_ = g_new0 (gchar*, 1 + 1);
	_tmp64_[0] = _tmp63_;
	target_args = _tmp64_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	while (TRUE) {
		gint _tmp65_ = 0;
		gchar** _tmp66_ = NULL;
		gint _tmp66__length1 = 0;
		gchar** _tmp67_ = NULL;
		gint _tmp67__length1 = 0;
		gchar** _tmp68_ = NULL;
		gint _tmp68__length1 = 0;
		gint _tmp69_ = 0;
		const gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		gint _tmp72_ = 0;
		_tmp65_ = i;
		_tmp66_ = args;
		_tmp66__length1 = args_length1;
		if (!(_tmp65_ < _tmp66__length1)) {
			break;
		}
		_tmp67_ = target_args;
		_tmp67__length1 = target_args_length1;
		_tmp68_ = args;
		_tmp68__length1 = args_length1;
		_tmp69_ = i;
		_tmp70_ = _tmp68_[_tmp69_];
		_tmp71_ = g_strdup (_tmp70_);
		_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp71_);
		_tmp72_ = i;
		i = _tmp72_ + 1;
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp73_ = NULL;
		gchar** _tmp74_ = NULL;
		gint _tmp74__length1 = 0;
		GPid _tmp75_ = 0;
		const gchar* _tmp76_ = NULL;
		GPid _tmp77_ = 0;
		GMainLoop* _tmp78_ = NULL;
		gint _tmp79_ = 0;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp73_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp73_;
		_data1_->child_status = 0;
		_tmp74_ = target_args;
		_tmp74__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp74_, NULL, (G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_FILE_AND_ARGV_ZERO, NULL, NULL, &_tmp75_, &_inner_error_);
		pid = _tmp75_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp76_ = vala_compiler_output;
		g_unlink (_tmp76_);
		_tmp77_ = pid;
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp77_, ____lambda4__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp78_ = _data1_->loop;
		g_main_loop_run (_tmp78_);
		_tmp79_ = _data1_->child_status;
		result = _tmp79_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp80_ = NULL;
		GError* _tmp81_ = NULL;
		const gchar* _tmp82_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp80_ = stdout;
		_tmp81_ = e;
		_tmp82_ = _tmp81_->message;
		fprintf (_tmp80_, "%s\n", _tmp82_);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


static gint vala_compiler_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp32_ = NULL;
	ValaCompiler* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_path_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "vala") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = g_path_get_basename (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = g_strcmp0 (_tmp9_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp9_);
	}
	if (_tmp0_) {
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		gint _tmp11_ = 0;
		_tmp10_ = args;
		_tmp10__length1 = args_length1;
		_tmp11_ = vala_compiler_run_source (_tmp10_, _tmp10__length1);
		result = _tmp11_;
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp12_ = NULL;
		GOptionContext* _tmp13_ = NULL;
		GOptionContext* _tmp14_ = NULL;
		GOptionContext* _tmp15_ = NULL;
		_tmp12_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp12_;
		_tmp13_ = opt_context;
		g_option_context_set_help_enabled (_tmp13_, TRUE);
		_tmp14_ = opt_context;
		g_option_context_add_main_entries (_tmp14_, VALA_COMPILER_options, NULL);
		_tmp15_ = opt_context;
		g_option_context_parse (_tmp15_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		FILE* _tmp19_ = NULL;
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		const gchar* _tmp21_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = stdout;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		fprintf (_tmp16_, "%s\n", _tmp18_);
		_tmp19_ = stdout;
		_tmp20_ = args;
		_tmp20__length1 = args_length1;
		_tmp21_ = _tmp20_[0];
		fprintf (_tmp19_, "Run '%s --help' to see a full list of available command line options.\n", _tmp21_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp22_ = vala_compiler_version;
	if (_tmp22_) {
		FILE* _tmp23_ = NULL;
		_tmp23_ = stdout;
		fprintf (_tmp23_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp24_ = FALSE;
		_tmp24_ = vala_compiler_api_version;
		if (_tmp24_) {
			FILE* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			_tmp25_ = stdout;
			_tmp26_ = string_substring (PACKAGE_SUFFIX, (glong) 1, (glong) -1);
			_tmp27_ = _tmp26_;
			fprintf (_tmp25_, "%s\n", _tmp27_);
			_g_free0 (_tmp27_);
			result = 0;
			return result;
		}
	}
	_tmp29_ = vala_compiler_sources;
	_tmp29__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp29_ == NULL) {
		gchar** _tmp30_ = NULL;
		gint _tmp30__length1 = 0;
		_tmp30_ = vala_compiler_fast_vapis;
		_tmp30__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp28_ = _tmp30_ == NULL;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		FILE* _tmp31_ = NULL;
		_tmp31_ = stderr;
		fprintf (_tmp31_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp32_ = vala_compiler_new ();
	compiler = _tmp32_;
	_tmp33_ = compiler;
	_tmp34_ = vala_compiler_run (_tmp33_);
	result = _tmp34_;
	_vala_compiler_unref0 (compiler);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return vala_compiler_main (argv, argc);
}


ValaCompiler* vala_compiler_construct (GType object_type) {
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCompiler* vala_compiler_new (void) {
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void vala_value_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCompiler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCompiler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


void vala_value_take_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void vala_compiler_class_init (ValaCompilerClass * klass) {
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCompilerClass *) klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void vala_compiler_instance_init (ValaCompiler * self) {
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_compiler_finalize (ValaCompiler* obj) {
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}


GType vala_compiler_get_type (void) {
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


gpointer vala_compiler_ref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_compiler_unref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



