/* math-function.c generated by valac 0.27.2.2-e6bbc, the Vala compiler
 * generated from math-function.vala, do not modify */

/*
 * Copyright (C) 2013 Garima Joshi
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_MATH_FUNCTION (math_function_get_type ())
#define MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_FUNCTION, MathFunction))
#define MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_FUNCTION, MathFunctionClass))
#define IS_MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_FUNCTION))
#define IS_MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_FUNCTION))
#define MATH_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_FUNCTION, MathFunctionClass))

typedef struct _MathFunction MathFunction;
typedef struct _MathFunctionClass MathFunctionClass;
typedef struct _MathFunctionPrivate MathFunctionPrivate;

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;

#define TYPE_PARSER (parser_get_type ())
#define PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PARSER, Parser))
#define PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PARSER, ParserClass))
#define IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PARSER))
#define IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PARSER))
#define PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PARSER, ParserClass))

typedef struct _Parser Parser;
typedef struct _ParserClass ParserClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_EXPRESSION_PARSER (expression_parser_get_type ())
#define EXPRESSION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPRESSION_PARSER, ExpressionParser))
#define EXPRESSION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPRESSION_PARSER, ExpressionParserClass))
#define IS_EXPRESSION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPRESSION_PARSER))
#define IS_EXPRESSION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPRESSION_PARSER))
#define EXPRESSION_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPRESSION_PARSER, ExpressionParserClass))

typedef struct _ExpressionParser ExpressionParser;
typedef struct _ExpressionParserClass ExpressionParserClass;

#define TYPE_FUNCTION_PARSER (function_parser_get_type ())
#define FUNCTION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_PARSER, FunctionParser))
#define FUNCTION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_PARSER, FunctionParserClass))
#define IS_FUNCTION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_PARSER))
#define IS_FUNCTION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_PARSER))
#define FUNCTION_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_PARSER, FunctionParserClass))

typedef struct _FunctionParser FunctionParser;
typedef struct _FunctionParserClass FunctionParserClass;

#define TYPE_ERROR_CODE (error_code_get_type ())
#define _parser_unref0(var) ((var == NULL) ? NULL : (var = (parser_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParserPrivate ParserPrivate;

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())
typedef struct _ExpressionParserPrivate ExpressionParserPrivate;
typedef struct _FunctionParserPrivate FunctionParserPrivate;

#define TYPE_BUILT_IN_MATH_FUNCTION (built_in_math_function_get_type ())
#define BUILT_IN_MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILT_IN_MATH_FUNCTION, BuiltInMathFunction))
#define BUILT_IN_MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILT_IN_MATH_FUNCTION, BuiltInMathFunctionClass))
#define IS_BUILT_IN_MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILT_IN_MATH_FUNCTION))
#define IS_BUILT_IN_MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILT_IN_MATH_FUNCTION))
#define BUILT_IN_MATH_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILT_IN_MATH_FUNCTION, BuiltInMathFunctionClass))

typedef struct _BuiltInMathFunction BuiltInMathFunction;
typedef struct _BuiltInMathFunctionClass BuiltInMathFunctionClass;
typedef struct _BuiltInMathFunctionPrivate BuiltInMathFunctionPrivate;

struct _MathFunction {
	GObject parent_instance;
	MathFunctionPrivate * priv;
};

struct _MathFunctionClass {
	GObjectClass parent_class;
	Number* (*evaluate) (MathFunction* self, Number** args, int args_length1, Parser* root_parser);
	gboolean (*is_custom_function) (MathFunction* self);
};

struct _MathFunctionPrivate {
	gchar* _name;
	gchar** _arguments;
	gint _arguments_length1;
	gint __arguments_size_;
	gchar* _expression;
	gchar* _description;
};

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _Parser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ParserPrivate * priv;
	gint number_base;
	gint wordlen;
	AngleUnit angle_units;
};

struct _ParserClass {
	GTypeClass parent_class;
	void (*finalize) (Parser *self);
	gboolean (*variable_is_defined) (Parser* self, const gchar* name);
	Number* (*get_variable) (Parser* self, const gchar* name);
	void (*set_variable) (Parser* self, const gchar* name, Number* x);
	gboolean (*function_is_defined) (Parser* self, const gchar* name);
	Number* (*convert) (Parser* self, Number* x, const gchar* x_units, const gchar* z_units);
};

struct _ExpressionParser {
	Parser parent_instance;
	ExpressionParserPrivate * priv;
};

struct _ExpressionParserClass {
	ParserClass parent_class;
};

struct _ExpressionParserPrivate {
	Parser* _root_parser;
};

struct _FunctionParser {
	ExpressionParser parent_instance;
	FunctionParserPrivate * priv;
};

struct _FunctionParserClass {
	ExpressionParserClass parent_class;
};

struct _FunctionParserPrivate {
	Number** _parameters;
	gint _parameters_length1;
	gint __parameters_size_;
	MathFunction* _function;
};

struct _BuiltInMathFunction {
	MathFunction parent_instance;
	BuiltInMathFunctionPrivate * priv;
};

struct _BuiltInMathFunctionClass {
	MathFunctionClass parent_class;
};


static gpointer math_function_parent_class = NULL;
static gpointer expression_parser_parent_class = NULL;
static gpointer function_parser_parent_class = NULL;
static gpointer built_in_math_function_parent_class = NULL;

GType math_function_get_type (void) G_GNUC_CONST;
GType number_get_type (void) G_GNUC_CONST;
gpointer parser_ref (gpointer instance);
void parser_unref (gpointer instance);
GParamSpec* param_spec_parser (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_parser (GValue* value, gpointer v_object);
void value_take_parser (GValue* value, gpointer v_object);
gpointer value_get_parser (const GValue* value);
GType parser_get_type (void) G_GNUC_CONST;
#define MATH_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_FUNCTION, MathFunctionPrivate))
enum  {
	MATH_FUNCTION_DUMMY_PROPERTY,
	MATH_FUNCTION_NAME,
	MATH_FUNCTION_ARGUMENTS,
	MATH_FUNCTION_EXPRESSION,
	MATH_FUNCTION_DESCRIPTION
};
MathFunction* math_function_new (const gchar* function_name, gchar** arguments, int arguments_length1, const gchar* expression, const gchar* description);
MathFunction* math_function_construct (GType object_type, const gchar* function_name, gchar** arguments, int arguments_length1, const gchar* expression, const gchar* description);
static gchar** _vala_array_dup12 (gchar** self, int length);
Number* math_function_evaluate (MathFunction* self, Number** args, int args_length1, Parser* root_parser);
static Number* math_function_real_evaluate (MathFunction* self, Number** args, int args_length1, Parser* root_parser);
GType expression_parser_get_type (void) G_GNUC_CONST;
GType function_parser_get_type (void) G_GNUC_CONST;
FunctionParser* function_parser_new (MathFunction* function, Parser* root_parser, Number** parameters, int parameters_length1);
FunctionParser* function_parser_construct (GType object_type, MathFunction* function, Parser* root_parser, Number** parameters, int parameters_length1);
GType error_code_get_type (void) G_GNUC_CONST;
Number* parser_parse (Parser* self, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint* error_start, guint* error_end);
void parser_set_error (Parser* self, ErrorCode errorno, const gchar* token, guint token_start, guint token_end);
gboolean math_function_validate (MathFunction* self, Parser* root_parser);
static gboolean math_function_is_name_valid (MathFunction* self, const gchar* x);
const gchar* math_function_get_name (MathFunction* self);
gchar** math_function_get_arguments (MathFunction* self, int* result_length1);
gboolean parser_create_parse_tree (Parser* self, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint* error_start, guint* error_end);
gboolean math_function_is_custom_function (MathFunction* self);
static gboolean math_function_real_is_custom_function (MathFunction* self);
const gchar* math_function_get_expression (MathFunction* self);
const gchar* math_function_get_description (MathFunction* self);
static void math_function_finalize (GObject* obj);
static void _vala_math_function_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType angle_unit_get_type (void) G_GNUC_CONST;
#define EXPRESSION_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXPRESSION_PARSER, ExpressionParserPrivate))
enum  {
	EXPRESSION_PARSER_DUMMY_PROPERTY
};
ExpressionParser* expression_parser_new (const gchar* expression, Parser* root_parser);
ExpressionParser* expression_parser_construct (GType object_type, const gchar* expression, Parser* root_parser);
Parser* parser_new (const gchar* input, gint number_base, gint wordlen, AngleUnit angle_units);
Parser* parser_construct (GType object_type, const gchar* input, gint number_base, gint wordlen, AngleUnit angle_units);
static gboolean expression_parser_real_variable_is_defined (Parser* base, const gchar* name);
gboolean parser_variable_is_defined (Parser* self, const gchar* name);
static Number* expression_parser_real_get_variable (Parser* base, const gchar* name);
Number* parser_get_variable (Parser* self, const gchar* name);
static gboolean expression_parser_real_function_is_defined (Parser* base, const gchar* name);
gboolean parser_function_is_defined (Parser* self, const gchar* name);
static void expression_parser_finalize (Parser* obj);
#define FUNCTION_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_FUNCTION_PARSER, FunctionParserPrivate))
enum  {
	FUNCTION_PARSER_DUMMY_PROPERTY
};
static Number** _vala_array_dup13 (Number** self, int length);
static gboolean function_parser_real_variable_is_defined (Parser* base, const gchar* name);
static gchar** _vala_array_dup14 (gchar** self, int length);
static Number* function_parser_real_get_variable (Parser* base, const gchar* name);
static gchar** _vala_array_dup15 (gchar** self, int length);
static void function_parser_finalize (Parser* obj);
GType built_in_math_function_get_type (void) G_GNUC_CONST;
enum  {
	BUILT_IN_MATH_FUNCTION_DUMMY_PROPERTY
};
BuiltInMathFunction* built_in_math_function_new (const gchar* function_name, const gchar* description);
BuiltInMathFunction* built_in_math_function_construct (GType object_type, const gchar* function_name, const gchar* description);
static Number* built_in_math_function_real_evaluate (MathFunction* base, Number** args, int args_length1, Parser* root_parser);
Number* evaluate_built_in_function (const gchar* name, Number** args, int args_length1, Parser* root_parser);
static gboolean built_in_math_function_real_is_custom_function (MathFunction* base);
Number* number_logarithm (Number* self, gint64 n);
gint64 number_to_integer (Number* self);
Number* number_ln (Number* self);
Number* number_sqrt (Number* self);
Number* number_abs (Number* self);
Number* number_sgn (Number* self);
Number* number_arg (Number* self, AngleUnit unit);
Number* number_conjugate (Number* self);
Number* number_integer_component (Number* self);
Number* number_fractional_component (Number* self);
Number* number_floor (Number* self);
Number* number_ceiling (Number* self);
Number* number_round (Number* self);
Number* number_real_component (Number* self);
Number* number_imaginary_component (Number* self);
Number* number_sin (Number* self, AngleUnit unit);
Number* number_cos (Number* self, AngleUnit unit);
Number* number_tan (Number* self, AngleUnit unit);
Number* number_asin (Number* self, AngleUnit unit);
Number* number_acos (Number* self, AngleUnit unit);
Number* number_atan (Number* self, AngleUnit unit);
Number* number_sinh (Number* self);
Number* number_cosh (Number* self);
Number* number_tanh (Number* self);
Number* number_asinh (Number* self);
Number* number_acosh (Number* self);
Number* number_atanh (Number* self);
Number* number_ones_complement (Number* self, gint wordlen);
Number* number_twos_complement (Number* self, gint wordlen);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gchar** _vala_array_dup12 (gchar** self, int length) {
	gchar** result;
	int i;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = g_new0 (gchar*, length + 1);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	for (i = 0; i < length; i++) {
#line 307 "math-function.c"
		gchar* _tmp0_ = NULL;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_tmp0_ = g_strdup (self[i]);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		result[i] = _tmp0_;
#line 313 "math-function.c"
	}
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 317 "math-function.c"
}


MathFunction* math_function_construct (GType object_type, const gchar* function_name, gchar** arguments, int arguments_length1, const gchar* expression, const gchar* description) {
	MathFunction * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (function_name != NULL, NULL);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self = (MathFunction*) g_object_new (object_type, NULL);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0_ = function_name;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_g_free0 (self->priv->_name);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self->priv->_name = _tmp1_;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2_ = arguments;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2__length1 = arguments_length1;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup12 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp3__length1 = _tmp2__length1;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self->priv->_arguments = (_vala_array_free (self->priv->_arguments, self->priv->_arguments_length1, (GDestroyNotify) g_free), NULL);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self->priv->_arguments = _tmp3_;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self->priv->_arguments_length1 = _tmp3__length1;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self->priv->__arguments_size_ = self->priv->_arguments_length1;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp4_ = expression;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	if (_tmp4_ != NULL) {
#line 363 "math-function.c"
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_tmp5_ = expression;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_g_free0 (self->priv->_expression);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		self->priv->_expression = _tmp6_;
#line 374 "math-function.c"
	} else {
		gchar* _tmp7_ = NULL;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_tmp7_ = g_strdup ("");
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_g_free0 (self->priv->_expression);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		self->priv->_expression = _tmp7_;
#line 383 "math-function.c"
	}
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp8_ = description;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	if (_tmp8_ != NULL) {
#line 389 "math-function.c"
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_tmp9_ = description;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_tmp10_ = g_strdup (_tmp9_);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_g_free0 (self->priv->_description);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		self->priv->_description = _tmp10_;
#line 400 "math-function.c"
	} else {
		gchar* _tmp11_ = NULL;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_tmp11_ = g_strdup ("");
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_g_free0 (self->priv->_description);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		self->priv->_description = _tmp11_;
#line 409 "math-function.c"
	}
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return self;
#line 413 "math-function.c"
}


MathFunction* math_function_new (const gchar* function_name, gchar** arguments, int arguments_length1, const gchar* expression, const gchar* description) {
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return math_function_construct (TYPE_MATH_FUNCTION, function_name, arguments, arguments_length1, expression, description);
#line 420 "math-function.c"
}


static Number* math_function_real_evaluate (MathFunction* self, Number** args, int args_length1, Parser* root_parser) {
	Number* result = NULL;
	FunctionParser* parser = NULL;
	Parser* _tmp0_ = NULL;
	Number** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	FunctionParser* _tmp2_ = NULL;
	guint representation_base = 0U;
	ErrorCode error_code = 0;
	gchar* error_token = NULL;
	guint error_start = 0U;
	guint error_end = 0U;
	Number* ans = NULL;
	FunctionParser* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	ErrorCode _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	Number* _tmp9_ = NULL;
	ErrorCode _tmp10_ = 0;
	Parser* _tmp11_ = NULL;
	ErrorCode _tmp12_ = 0;
	const gchar* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0_ = root_parser;
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp1_ = args;
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp1__length1 = args_length1;
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2_ = function_parser_new (self, _tmp0_, _tmp1_, _tmp1__length1);
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	parser = _tmp2_;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp3_ = parser;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp9_ = parser_parse ((Parser*) _tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	representation_base = _tmp4_;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	error_code = _tmp5_;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_g_free0 (error_token);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	error_token = _tmp6_;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	error_start = _tmp7_;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	error_end = _tmp8_;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	ans = _tmp9_;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp10_ = error_code;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	if (_tmp10_ == ERROR_CODE_NONE) {
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		result = ans;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_g_free0 (error_token);
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_parser_unref0 (parser);
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		return result;
#line 490 "math-function.c"
	}
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp11_ = root_parser;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp12_ = error_code;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp13_ = error_token;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp14_ = error_start;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp15_ = error_end;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	parser_set_error (_tmp11_, _tmp12_, _tmp13_, _tmp14_, _tmp15_);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = NULL;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_g_object_unref0 (ans);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_g_free0 (error_token);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_parser_unref0 (parser);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 514 "math-function.c"
}


Number* math_function_evaluate (MathFunction* self, Number** args, int args_length1, Parser* root_parser) {
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return MATH_FUNCTION_GET_CLASS (self)->evaluate (self, args, args_length1, root_parser);
#line 523 "math-function.c"
}


gboolean math_function_validate (MathFunction* self, Parser* root_parser) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	Number** args = NULL;
	Number** _tmp10_ = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	FunctionParser* parser = NULL;
	Parser* _tmp11_ = NULL;
	Number** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	FunctionParser* _tmp13_ = NULL;
	guint representation_base = 0U;
	ErrorCode error_code = 0;
	gchar* error_token = NULL;
	guint error_start = 0U;
	guint error_end = 0U;
	FunctionParser* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	ErrorCode _tmp16_ = 0;
	gchar* _tmp17_ = NULL;
	guint _tmp18_ = 0U;
	guint _tmp19_ = 0U;
	ErrorCode _tmp20_ = 0;
	Parser* _tmp21_ = NULL;
	ErrorCode _tmp22_ = 0;
	const gchar* _tmp23_ = NULL;
	guint _tmp24_ = 0U;
	guint _tmp25_ = 0U;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0_ = math_function_get_name (self);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp1_ = _tmp0_;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2_ = math_function_is_name_valid (self, _tmp1_);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	if (!_tmp2_) {
#line 572 "math-function.c"
		Parser* _tmp3_ = NULL;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_tmp3_ = root_parser;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		parser_set_error (_tmp3_, ERROR_CODE_INVALID, NULL, (guint) 0, (guint) 0);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		result = FALSE;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		return result;
#line 582 "math-function.c"
	}
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp4_ = math_function_get_arguments (self, &_tmp4__length1);
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp5_ = _tmp4_;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp5__length1 = _tmp4__length1;
#line 590 "math-function.c"
	{
		gchar** argument_collection = NULL;
		gint argument_collection_length1 = 0;
		gint _argument_collection_size_ = 0;
		gint argument_it = 0;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		argument_collection = _tmp5_;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		argument_collection_length1 = _tmp5__length1;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		for (argument_it = 0; argument_it < _tmp5__length1; argument_it = argument_it + 1) {
#line 602 "math-function.c"
			gchar* _tmp6_ = NULL;
			gchar* argument = NULL;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_tmp6_ = g_strdup (argument_collection[argument_it]);
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			argument = _tmp6_;
#line 609 "math-function.c"
			{
				const gchar* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp7_ = argument;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp8_ = math_function_is_name_valid (self, _tmp7_);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				if (!_tmp8_) {
#line 619 "math-function.c"
					Parser* _tmp9_ = NULL;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					_tmp9_ = root_parser;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					parser_set_error (_tmp9_, ERROR_CODE_INVALID, NULL, (guint) 0, (guint) 0);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					result = FALSE;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					_g_free0 (argument);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					return result;
#line 631 "math-function.c"
				}
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_g_free0 (argument);
#line 635 "math-function.c"
			}
		}
	}
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp10_ = g_new0 (Number*, 0 + 1);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	args = _tmp10_;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	args_length1 = 0;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_args_size_ = args_length1;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp11_ = root_parser;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp12_ = args;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp12__length1 = args_length1;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp13_ = function_parser_new (self, _tmp11_, _tmp12_, _tmp12__length1);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	parser = _tmp13_;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp14_ = parser;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	parser_create_parse_tree ((Parser*) _tmp14_, &_tmp15_, &_tmp16_, &_tmp17_, &_tmp18_, &_tmp19_);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	representation_base = _tmp15_;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	error_code = _tmp16_;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_g_free0 (error_token);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	error_token = _tmp17_;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	error_start = _tmp18_;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	error_end = _tmp19_;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp20_ = error_code;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	if (_tmp20_ == ERROR_CODE_NONE) {
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		result = TRUE;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_g_free0 (error_token);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_parser_unref0 (parser);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		return result;
#line 687 "math-function.c"
	}
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp21_ = root_parser;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp22_ = error_code;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp23_ = error_token;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp24_ = error_start;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp25_ = error_end;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	parser_set_error (_tmp21_, _tmp22_, _tmp23_, _tmp24_, _tmp25_);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = FALSE;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_g_free0 (error_token);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_parser_unref0 (parser);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 711 "math-function.c"
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
#line 1026 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 729 "math-function.c"
}


static gboolean math_function_is_name_valid (MathFunction* self, const gchar* x) {
	gboolean result = FALSE;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (x != NULL, FALSE);
#line 739 "math-function.c"
	{
		gint i = 0;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		i = 0;
#line 744 "math-function.c"
		{
			gboolean _tmp0_ = FALSE;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_tmp0_ = TRUE;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			while (TRUE) {
#line 751 "math-function.c"
				gint _tmp2_ = 0;
				const gchar* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gunichar current_char = 0U;
				const gchar* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gunichar _tmp8_ = 0U;
				gunichar _tmp9_ = 0U;
				gboolean _tmp10_ = FALSE;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				if (!_tmp0_) {
#line 764 "math-function.c"
					gint _tmp1_ = 0;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					_tmp1_ = i;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					i = _tmp1_ + 1;
#line 770 "math-function.c"
				}
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp0_ = FALSE;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp2_ = i;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp3_ = x;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp4_ = strlen (_tmp3_);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp5_ = _tmp4_;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				if (!(_tmp2_ < _tmp5_)) {
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					break;
#line 786 "math-function.c"
				}
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp6_ = x;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp7_ = i;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp8_ = string_get_char (_tmp6_, (glong) _tmp7_);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				current_char = _tmp8_;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp9_ = current_char;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp10_ = g_unichar_isalpha (_tmp9_);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				if (!_tmp10_) {
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					result = FALSE;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					return result;
#line 806 "math-function.c"
				}
			}
		}
	}
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = TRUE;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 815 "math-function.c"
}


static gboolean math_function_real_is_custom_function (MathFunction* self) {
	gboolean result = FALSE;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = TRUE;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 825 "math-function.c"
}


gboolean math_function_is_custom_function (MathFunction* self) {
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return MATH_FUNCTION_GET_CLASS (self)->is_custom_function (self);
#line 834 "math-function.c"
}


const gchar* math_function_get_name (MathFunction* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0_ = self->priv->_name;
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = _tmp0_;
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 849 "math-function.c"
}


gchar** math_function_get_arguments (MathFunction* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0_ = self->priv->_arguments;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0__length1 = self->priv->_arguments_length1;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp1_ = _tmp0_;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp1__length1 = _tmp0__length1;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	if (result_length1) {
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		*result_length1 = _tmp1__length1;
#line 873 "math-function.c"
	}
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = _tmp1_;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 879 "math-function.c"
}


const gchar* math_function_get_expression (MathFunction* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0_ = self->priv->_expression;
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = _tmp0_;
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 894 "math-function.c"
}


const gchar* math_function_get_description (MathFunction* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0_ = self->priv->_description;
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = _tmp0_;
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 909 "math-function.c"
}


static void math_function_class_init (MathFunctionClass * klass) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	math_function_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_type_class_add_private (klass, sizeof (MathFunctionPrivate));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	((MathFunctionClass *) klass)->evaluate = math_function_real_evaluate;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	((MathFunctionClass *) klass)->is_custom_function = math_function_real_is_custom_function;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_math_function_get_property;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	G_OBJECT_CLASS (klass)->finalize = math_function_finalize;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_ARGUMENTS, g_param_spec_boxed ("arguments", "arguments", "arguments", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_EXPRESSION, g_param_spec_string ("expression", "expression", "expression", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 934 "math-function.c"
}


static void math_function_instance_init (MathFunction * self) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self->priv = MATH_FUNCTION_GET_PRIVATE (self);
#line 941 "math-function.c"
}


static void math_function_finalize (GObject* obj) {
	MathFunction * self;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_FUNCTION, MathFunction);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_g_free0 (self->priv->_name);
#line 14 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self->priv->_arguments = (_vala_array_free (self->priv->_arguments, self->priv->_arguments_length1, (GDestroyNotify) g_free), NULL);
#line 15 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_g_free0 (self->priv->_expression);
#line 16 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_g_free0 (self->priv->_description);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	G_OBJECT_CLASS (math_function_parent_class)->finalize (obj);
#line 959 "math-function.c"
}


GType math_function_get_type (void) {
	static volatile gsize math_function_type_id__volatile = 0;
	if (g_once_init_enter (&math_function_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathFunction), 0, (GInstanceInitFunc) math_function_instance_init, NULL };
		GType math_function_type_id;
		math_function_type_id = g_type_register_static (G_TYPE_OBJECT, "MathFunction", &g_define_type_info, 0);
		g_once_init_leave (&math_function_type_id__volatile, math_function_type_id);
	}
	return math_function_type_id__volatile;
}


static void _vala_math_function_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathFunction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_FUNCTION, MathFunction);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	switch (property_id) {
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		case MATH_FUNCTION_NAME:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		g_value_set_string (value, math_function_get_name (self));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		break;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		case MATH_FUNCTION_ARGUMENTS:
#line 988 "math-function.c"
		{
			int length;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			g_value_set_boxed (value, math_function_get_arguments (self, &length));
#line 993 "math-function.c"
		}
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		break;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		case MATH_FUNCTION_EXPRESSION:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		g_value_set_string (value, math_function_get_expression (self));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		break;
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		case MATH_FUNCTION_DESCRIPTION:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		g_value_set_string (value, math_function_get_description (self));
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		break;
#line 1009 "math-function.c"
		default:
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 11 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		break;
#line 1015 "math-function.c"
	}
}


static gpointer _parser_ref0 (gpointer self) {
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return self ? parser_ref (self) : NULL;
#line 1023 "math-function.c"
}


ExpressionParser* expression_parser_construct (GType object_type, const gchar* expression, Parser* root_parser) {
	ExpressionParser* self = NULL;
	const gchar* _tmp0_ = NULL;
	Parser* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Parser* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	Parser* _tmp5_ = NULL;
	AngleUnit _tmp6_ = 0;
	Parser* _tmp7_ = NULL;
	Parser* _tmp8_ = NULL;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (expression != NULL, NULL);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0_ = expression;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp1_ = root_parser;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2_ = _tmp1_->number_base;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp3_ = root_parser;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp4_ = _tmp3_->wordlen;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp5_ = root_parser;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp6_ = _tmp5_->angle_units;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self = (ExpressionParser*) parser_construct (object_type, _tmp0_, _tmp2_, _tmp4_, _tmp6_);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp7_ = root_parser;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp8_ = _parser_ref0 (_tmp7_);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_parser_unref0 (self->priv->_root_parser);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self->priv->_root_parser = _tmp8_;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return self;
#line 1066 "math-function.c"
}


ExpressionParser* expression_parser_new (const gchar* expression, Parser* root_parser) {
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return expression_parser_construct (TYPE_EXPRESSION_PARSER, expression, root_parser);
#line 1073 "math-function.c"
}


static gboolean expression_parser_real_variable_is_defined (Parser* base, const gchar* name) {
	ExpressionParser * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Parser* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self = (ExpressionParser*) base;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0_ = name;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp1_ = PARSER_CLASS (expression_parser_parent_class)->variable_is_defined (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PARSER, Parser), _tmp0_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	if (_tmp1_) {
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		result = TRUE;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		return result;
#line 1099 "math-function.c"
	}
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2_ = self->priv->_root_parser;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp3_ = name;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp4_ = parser_variable_is_defined (_tmp2_, _tmp3_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = _tmp4_;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 1111 "math-function.c"
}


static Number* expression_parser_real_get_variable (Parser* base, const gchar* name) {
	ExpressionParser * self;
	Number* result = NULL;
	Number* value = NULL;
	const gchar* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Parser* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self = (ExpressionParser*) base;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0_ = name;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp1_ = PARSER_CLASS (expression_parser_parent_class)->get_variable (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PARSER, Parser), _tmp0_);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	value = _tmp1_;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2_ = value;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	if (_tmp2_ != NULL) {
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		result = value;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		return result;
#line 1143 "math-function.c"
	}
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp3_ = self->priv->_root_parser;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp4_ = name;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp5_ = parser_get_variable (_tmp3_, _tmp4_);
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = _tmp5_;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_g_object_unref0 (value);
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 1157 "math-function.c"
}


static gboolean expression_parser_real_function_is_defined (Parser* base, const gchar* name) {
	ExpressionParser * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Parser* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self = (ExpressionParser*) base;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0_ = name;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp1_ = PARSER_CLASS (expression_parser_parent_class)->function_is_defined (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PARSER, Parser), _tmp0_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	if (_tmp1_) {
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		result = TRUE;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		return result;
#line 1183 "math-function.c"
	}
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2_ = self->priv->_root_parser;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp3_ = name;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp4_ = parser_function_is_defined (_tmp2_, _tmp3_);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = _tmp4_;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 1195 "math-function.c"
}


static void expression_parser_class_init (ExpressionParserClass * klass) {
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	expression_parser_parent_class = g_type_class_peek_parent (klass);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	((ParserClass *) klass)->finalize = expression_parser_finalize;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_type_class_add_private (klass, sizeof (ExpressionParserPrivate));
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	((ParserClass *) klass)->variable_is_defined = expression_parser_real_variable_is_defined;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	((ParserClass *) klass)->get_variable = expression_parser_real_get_variable;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	((ParserClass *) klass)->function_is_defined = expression_parser_real_function_is_defined;
#line 1212 "math-function.c"
}


static void expression_parser_instance_init (ExpressionParser * self) {
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self->priv = EXPRESSION_PARSER_GET_PRIVATE (self);
#line 1219 "math-function.c"
}


static void expression_parser_finalize (Parser* obj) {
	ExpressionParser * self;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPRESSION_PARSER, ExpressionParser);
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_parser_unref0 (self->priv->_root_parser);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	PARSER_CLASS (expression_parser_parent_class)->finalize (obj);
#line 1231 "math-function.c"
}


GType expression_parser_get_type (void) {
	static volatile gsize expression_parser_type_id__volatile = 0;
	if (g_once_init_enter (&expression_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ExpressionParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) expression_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExpressionParser), 0, (GInstanceInitFunc) expression_parser_instance_init, NULL };
		GType expression_parser_type_id;
		expression_parser_type_id = g_type_register_static (TYPE_PARSER, "ExpressionParser", &g_define_type_info, 0);
		g_once_init_leave (&expression_parser_type_id__volatile, expression_parser_type_id);
	}
	return expression_parser_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return self ? g_object_ref (self) : NULL;
#line 1250 "math-function.c"
}


static Number** _vala_array_dup13 (Number** self, int length) {
	Number** result;
	int i;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = g_new0 (Number*, length + 1);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	for (i = 0; i < length; i++) {
#line 1261 "math-function.c"
		Number* _tmp0_ = NULL;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_tmp0_ = _g_object_ref0 (self[i]);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		result[i] = _tmp0_;
#line 1267 "math-function.c"
	}
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 1271 "math-function.c"
}


FunctionParser* function_parser_construct (GType object_type, MathFunction* function, Parser* root_parser, Number** parameters, int parameters_length1) {
	FunctionParser* self = NULL;
	MathFunction* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	Parser* _tmp3_ = NULL;
	MathFunction* _tmp4_ = NULL;
	MathFunction* _tmp5_ = NULL;
	Number** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	Number** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (function != NULL, NULL);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0_ = function;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp1_ = math_function_get_expression (_tmp0_);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2_ = _tmp1_;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp3_ = root_parser;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self = (FunctionParser*) expression_parser_construct (object_type, _tmp2_, _tmp3_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp4_ = function;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_g_object_unref0 (self->priv->_function);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self->priv->_function = _tmp5_;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp6_ = parameters;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp6__length1 = parameters_length1;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup13 (_tmp6_, _tmp6__length1) : ((gpointer) _tmp6_);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp7__length1 = _tmp6__length1;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self->priv->_parameters = (_vala_array_free (self->priv->_parameters, self->priv->_parameters_length1, (GDestroyNotify) g_object_unref), NULL);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self->priv->_parameters = _tmp7_;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self->priv->_parameters_length1 = _tmp7__length1;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self->priv->__parameters_size_ = self->priv->_parameters_length1;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return self;
#line 1325 "math-function.c"
}


FunctionParser* function_parser_new (MathFunction* function, Parser* root_parser, Number** parameters, int parameters_length1) {
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return function_parser_construct (TYPE_FUNCTION_PARSER, function, root_parser, parameters, parameters_length1);
#line 1332 "math-function.c"
}


static gchar** _vala_array_dup14 (gchar** self, int length) {
	gchar** result;
	int i;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = g_new0 (gchar*, length + 1);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	for (i = 0; i < length; i++) {
#line 1343 "math-function.c"
		gchar* _tmp0_ = NULL;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_tmp0_ = g_strdup (self[i]);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		result[i] = _tmp0_;
#line 1349 "math-function.c"
	}
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 1353 "math-function.c"
}


static gboolean function_parser_real_variable_is_defined (Parser* base, const gchar* name) {
	FunctionParser * self;
	gboolean result = FALSE;
	gchar** argument_names = NULL;
	MathFunction* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint argument_names_length1 = 0;
	gint _argument_names_size_ = 0;
	const gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self = (FunctionParser*) base;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0_ = self->priv->_function;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp1_ = math_function_get_arguments (_tmp0_, &_tmp1__length1);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2_ = _tmp1_;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2__length1 = _tmp1__length1;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup14 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp3__length1 = _tmp2__length1;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	argument_names = _tmp3_;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	argument_names_length1 = _tmp3__length1;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_argument_names_size_ = argument_names_length1;
#line 1394 "math-function.c"
	{
		gint i = 0;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		i = 0;
#line 1399 "math-function.c"
		{
			gboolean _tmp4_ = FALSE;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_tmp4_ = TRUE;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			while (TRUE) {
#line 1406 "math-function.c"
				gint _tmp6_ = 0;
				gchar** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gchar** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				const gchar* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				if (!_tmp4_) {
#line 1417 "math-function.c"
					gint _tmp5_ = 0;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					_tmp5_ = i;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					i = _tmp5_ + 1;
#line 1423 "math-function.c"
				}
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp4_ = FALSE;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp6_ = i;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp7_ = argument_names;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp7__length1 = argument_names_length1;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				if (!(_tmp6_ < _tmp7__length1)) {
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					break;
#line 1437 "math-function.c"
				}
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp8_ = argument_names;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp8__length1 = argument_names_length1;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp9_ = i;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp10_ = _tmp8_[_tmp9_];
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp11_ = name;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					result = TRUE;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					return result;
#line 1457 "math-function.c"
				}
			}
		}
	}
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp12_ = name;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp13_ = PARSER_CLASS (function_parser_parent_class)->variable_is_defined ((Parser*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EXPRESSION_PARSER, ExpressionParser), _tmp12_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = _tmp13_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 1472 "math-function.c"
}


static gchar** _vala_array_dup15 (gchar** self, int length) {
	gchar** result;
	int i;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = g_new0 (gchar*, length + 1);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	for (i = 0; i < length; i++) {
#line 1483 "math-function.c"
		gchar* _tmp0_ = NULL;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_tmp0_ = g_strdup (self[i]);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		result[i] = _tmp0_;
#line 1489 "math-function.c"
	}
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 1493 "math-function.c"
}


static Number* function_parser_real_get_variable (Parser* base, const gchar* name) {
	FunctionParser * self;
	Number* result = NULL;
	gchar** argument_names = NULL;
	MathFunction* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint argument_names_length1 = 0;
	gint _argument_names_size_ = 0;
	const gchar* _tmp18_ = NULL;
	Number* _tmp19_ = NULL;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self = (FunctionParser*) base;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0_ = self->priv->_function;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp1_ = math_function_get_arguments (_tmp0_, &_tmp1__length1);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2_ = _tmp1_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2__length1 = _tmp1__length1;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup15 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp3__length1 = _tmp2__length1;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	argument_names = _tmp3_;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	argument_names_length1 = _tmp3__length1;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_argument_names_size_ = argument_names_length1;
#line 1534 "math-function.c"
	{
		gint i = 0;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		i = 0;
#line 1539 "math-function.c"
		{
			gboolean _tmp4_ = FALSE;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_tmp4_ = TRUE;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			while (TRUE) {
#line 1546 "math-function.c"
				gint _tmp6_ = 0;
				gchar** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gchar** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				const gchar* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				if (!_tmp4_) {
#line 1557 "math-function.c"
					gint _tmp5_ = 0;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					_tmp5_ = i;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					i = _tmp5_ + 1;
#line 1563 "math-function.c"
				}
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp4_ = FALSE;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp6_ = i;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp7_ = argument_names;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp7__length1 = argument_names_length1;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				if (!(_tmp6_ < _tmp7__length1)) {
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					break;
#line 1577 "math-function.c"
				}
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp8_ = argument_names;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp8__length1 = argument_names_length1;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp9_ = i;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp10_ = _tmp8_[_tmp9_];
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp11_ = name;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
#line 1591 "math-function.c"
					Number** _tmp12_ = NULL;
					gint _tmp12__length1 = 0;
					gint _tmp13_ = 0;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					_tmp12_ = self->priv->_parameters;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					_tmp12__length1 = self->priv->_parameters_length1;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					_tmp13_ = i;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					if (_tmp12__length1 > _tmp13_) {
#line 1603 "math-function.c"
						Number** _tmp14_ = NULL;
						gint _tmp14__length1 = 0;
						gint _tmp15_ = 0;
						Number* _tmp16_ = NULL;
						Number* _tmp17_ = NULL;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
						_tmp14_ = self->priv->_parameters;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
						_tmp14__length1 = self->priv->_parameters_length1;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
						_tmp15_ = i;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
						_tmp16_ = _tmp14_[_tmp15_];
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
						_tmp17_ = _g_object_ref0 (_tmp16_);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
						result = _tmp17_;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
						argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
						return result;
#line 1625 "math-function.c"
					}
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					result = NULL;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					return result;
#line 1633 "math-function.c"
				}
			}
		}
	}
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp18_ = name;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp19_ = PARSER_CLASS (function_parser_parent_class)->get_variable ((Parser*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EXPRESSION_PARSER, ExpressionParser), _tmp18_);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = _tmp19_;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 1648 "math-function.c"
}


static void function_parser_class_init (FunctionParserClass * klass) {
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	function_parser_parent_class = g_type_class_peek_parent (klass);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	((ParserClass *) klass)->finalize = function_parser_finalize;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_type_class_add_private (klass, sizeof (FunctionParserPrivate));
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	((ParserClass *) klass)->variable_is_defined = function_parser_real_variable_is_defined;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	((ParserClass *) klass)->get_variable = function_parser_real_get_variable;
#line 1663 "math-function.c"
}


static void function_parser_instance_init (FunctionParser * self) {
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self->priv = FUNCTION_PARSER_GET_PRIVATE (self);
#line 1670 "math-function.c"
}


static void function_parser_finalize (Parser* obj) {
	FunctionParser * self;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FUNCTION_PARSER, FunctionParser);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self->priv->_parameters = (_vala_array_free (self->priv->_parameters, self->priv->_parameters_length1, (GDestroyNotify) g_object_unref), NULL);
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_g_object_unref0 (self->priv->_function);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	PARSER_CLASS (function_parser_parent_class)->finalize (obj);
#line 1684 "math-function.c"
}


GType function_parser_get_type (void) {
	static volatile gsize function_parser_type_id__volatile = 0;
	if (g_once_init_enter (&function_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionParser), 0, (GInstanceInitFunc) function_parser_instance_init, NULL };
		GType function_parser_type_id;
		function_parser_type_id = g_type_register_static (TYPE_EXPRESSION_PARSER, "FunctionParser", &g_define_type_info, 0);
		g_once_init_leave (&function_parser_type_id__volatile, function_parser_type_id);
	}
	return function_parser_type_id__volatile;
}


BuiltInMathFunction* built_in_math_function_construct (GType object_type, const gchar* function_name, const gchar* description) {
	BuiltInMathFunction * self = NULL;
	gchar** arguments = NULL;
	gchar** _tmp0_ = NULL;
	gint arguments_length1 = 0;
	gint _arguments_size_ = 0;
	gchar* expression = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (function_name != NULL, NULL);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	arguments = _tmp0_;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	arguments_length1 = 0;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_arguments_size_ = arguments_length1;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp1_ = g_strdup ("");
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	expression = _tmp1_;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2_ = function_name;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp3_ = description;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self = (BuiltInMathFunction*) math_function_construct (object_type, _tmp2_, arguments, arguments_length1, expression, _tmp3_);
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_g_free0 (expression);
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return self;
#line 1736 "math-function.c"
}


BuiltInMathFunction* built_in_math_function_new (const gchar* function_name, const gchar* description) {
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return built_in_math_function_construct (TYPE_BUILT_IN_MATH_FUNCTION, function_name, description);
#line 1743 "math-function.c"
}


static Number* built_in_math_function_real_evaluate (MathFunction* base, Number** args, int args_length1, Parser* root_parser) {
	BuiltInMathFunction * self;
	Number* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Number** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	Parser* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self = (BuiltInMathFunction*) base;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0_ = math_function_get_name ((MathFunction*) self);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp1_ = _tmp0_;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2_ = args;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2__length1 = args_length1;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp3_ = root_parser;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp4_ = evaluate_built_in_function (_tmp1_, _tmp2_, _tmp2__length1, _tmp3_);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = _tmp4_;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 1774 "math-function.c"
}


static gboolean built_in_math_function_real_is_custom_function (MathFunction* base) {
	BuiltInMathFunction * self;
	gboolean result = FALSE;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	self = (BuiltInMathFunction*) base;
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = FALSE;
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 1787 "math-function.c"
}


static void built_in_math_function_class_init (BuiltInMathFunctionClass * klass) {
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	built_in_math_function_parent_class = g_type_class_peek_parent (klass);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	((MathFunctionClass *) klass)->evaluate = built_in_math_function_real_evaluate;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	((MathFunctionClass *) klass)->is_custom_function = built_in_math_function_real_is_custom_function;
#line 1798 "math-function.c"
}


static void built_in_math_function_instance_init (BuiltInMathFunction * self) {
}


GType built_in_math_function_get_type (void) {
	static volatile gsize built_in_math_function_type_id__volatile = 0;
	if (g_once_init_enter (&built_in_math_function_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuiltInMathFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) built_in_math_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuiltInMathFunction), 0, (GInstanceInitFunc) built_in_math_function_instance_init, NULL };
		GType built_in_math_function_type_id;
		built_in_math_function_type_id = g_type_register_static (TYPE_MATH_FUNCTION, "BuiltInMathFunction", &g_define_type_info, 0);
		g_once_init_leave (&built_in_math_function_type_id__volatile, built_in_math_function_type_id);
	}
	return built_in_math_function_type_id__volatile;
}


Number* evaluate_built_in_function (const gchar* name, Number** args, int args_length1, Parser* root_parser) {
	Number* result = NULL;
	gchar* lower_name = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	Number* x = NULL;
	Number** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp0_ = name;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) (-1));
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	lower_name = _tmp1_;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2_ = args;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp2__length1 = args_length1;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp3_ = _tmp2_[0];
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	x = _tmp4_;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_tmp5_ = lower_name;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	if (g_strcmp0 (_tmp5_, "log") == 0) {
#line 1851 "math-function.c"
		Number** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_tmp6_ = args;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_tmp6__length1 = args_length1;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		if (_tmp6__length1 <= 1) {
#line 1860 "math-function.c"
			Number* _tmp7_ = NULL;
			Number* _tmp8_ = NULL;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_tmp7_ = x;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_tmp8_ = number_logarithm (_tmp7_, (gint64) 10);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			result = _tmp8_;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_g_object_unref0 (x);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_g_free0 (lower_name);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			return result;
#line 1875 "math-function.c"
		} else {
			gint64 log_base = 0LL;
			Number** _tmp9_ = NULL;
			gint _tmp9__length1 = 0;
			Number* _tmp10_ = NULL;
			gint64 _tmp11_ = 0LL;
			gint64 _tmp12_ = 0LL;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_tmp9_ = args;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_tmp9__length1 = args_length1;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_tmp10_ = _tmp9_[1];
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_tmp11_ = number_to_integer (_tmp10_);
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			log_base = _tmp11_;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_tmp12_ = log_base;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			if (_tmp12_ < ((gint64) 0)) {
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				result = NULL;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_g_object_unref0 (x);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_g_free0 (lower_name);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				return result;
#line 1905 "math-function.c"
			} else {
				Number* _tmp13_ = NULL;
				gint64 _tmp14_ = 0LL;
				Number* _tmp15_ = NULL;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp13_ = x;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp14_ = log_base;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp15_ = number_logarithm (_tmp13_, _tmp14_);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				result = _tmp15_;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_g_object_unref0 (x);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_g_free0 (lower_name);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				return result;
#line 1924 "math-function.c"
			}
		}
	} else {
		const gchar* _tmp16_ = NULL;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		_tmp16_ = lower_name;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
		if (g_strcmp0 (_tmp16_, "ln") == 0) {
#line 1933 "math-function.c"
			Number* _tmp17_ = NULL;
			Number* _tmp18_ = NULL;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_tmp17_ = x;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_tmp18_ = number_ln (_tmp17_);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			result = _tmp18_;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_g_object_unref0 (x);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_g_free0 (lower_name);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			return result;
#line 1948 "math-function.c"
		} else {
			const gchar* _tmp19_ = NULL;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			_tmp19_ = lower_name;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
			if (g_strcmp0 (_tmp19_, "sqrt") == 0) {
#line 1955 "math-function.c"
				Number* _tmp20_ = NULL;
				Number* _tmp21_ = NULL;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp20_ = x;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp21_ = number_sqrt (_tmp20_);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				result = _tmp21_;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_g_object_unref0 (x);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_g_free0 (lower_name);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				return result;
#line 1970 "math-function.c"
			} else {
				const gchar* _tmp22_ = NULL;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				_tmp22_ = lower_name;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
				if (g_strcmp0 (_tmp22_, "abs") == 0) {
#line 1977 "math-function.c"
					Number* _tmp23_ = NULL;
					Number* _tmp24_ = NULL;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					_tmp23_ = x;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					_tmp24_ = number_abs (_tmp23_);
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					result = _tmp24_;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					_g_object_unref0 (x);
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					_g_free0 (lower_name);
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					return result;
#line 1992 "math-function.c"
				} else {
					const gchar* _tmp25_ = NULL;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					_tmp25_ = lower_name;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
					if (g_strcmp0 (_tmp25_, "sgn") == 0) {
#line 1999 "math-function.c"
						Number* _tmp26_ = NULL;
						Number* _tmp27_ = NULL;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
						_tmp26_ = x;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
						_tmp27_ = number_sgn (_tmp26_);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
						result = _tmp27_;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
						_g_object_unref0 (x);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
						_g_free0 (lower_name);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
						return result;
#line 2014 "math-function.c"
					} else {
						const gchar* _tmp28_ = NULL;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
						_tmp28_ = lower_name;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
						if (g_strcmp0 (_tmp28_, "arg") == 0) {
#line 2021 "math-function.c"
							Number* _tmp29_ = NULL;
							Parser* _tmp30_ = NULL;
							AngleUnit _tmp31_ = 0;
							Number* _tmp32_ = NULL;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
							_tmp29_ = x;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
							_tmp30_ = root_parser;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
							_tmp31_ = _tmp30_->angle_units;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
							_tmp32_ = number_arg (_tmp29_, _tmp31_);
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
							result = _tmp32_;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
							_g_object_unref0 (x);
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
							_g_free0 (lower_name);
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
							return result;
#line 2042 "math-function.c"
						} else {
							const gchar* _tmp33_ = NULL;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
							_tmp33_ = lower_name;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
							if (g_strcmp0 (_tmp33_, "conj") == 0) {
#line 2049 "math-function.c"
								Number* _tmp34_ = NULL;
								Number* _tmp35_ = NULL;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
								_tmp34_ = x;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
								_tmp35_ = number_conjugate (_tmp34_);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
								result = _tmp35_;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
								_g_object_unref0 (x);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
								_g_free0 (lower_name);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
								return result;
#line 2064 "math-function.c"
							} else {
								const gchar* _tmp36_ = NULL;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
								_tmp36_ = lower_name;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
								if (g_strcmp0 (_tmp36_, "int") == 0) {
#line 2071 "math-function.c"
									Number* _tmp37_ = NULL;
									Number* _tmp38_ = NULL;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
									_tmp37_ = x;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
									_tmp38_ = number_integer_component (_tmp37_);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
									result = _tmp38_;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
									_g_object_unref0 (x);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
									_g_free0 (lower_name);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
									return result;
#line 2086 "math-function.c"
								} else {
									const gchar* _tmp39_ = NULL;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
									_tmp39_ = lower_name;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
									if (g_strcmp0 (_tmp39_, "frac") == 0) {
#line 2093 "math-function.c"
										Number* _tmp40_ = NULL;
										Number* _tmp41_ = NULL;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
										_tmp40_ = x;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
										_tmp41_ = number_fractional_component (_tmp40_);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
										result = _tmp41_;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
										_g_object_unref0 (x);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
										_g_free0 (lower_name);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
										return result;
#line 2108 "math-function.c"
									} else {
										const gchar* _tmp42_ = NULL;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
										_tmp42_ = lower_name;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
										if (g_strcmp0 (_tmp42_, "floor") == 0) {
#line 2115 "math-function.c"
											Number* _tmp43_ = NULL;
											Number* _tmp44_ = NULL;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
											_tmp43_ = x;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
											_tmp44_ = number_floor (_tmp43_);
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
											result = _tmp44_;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
											_g_object_unref0 (x);
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
											_g_free0 (lower_name);
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
											return result;
#line 2130 "math-function.c"
										} else {
											const gchar* _tmp45_ = NULL;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
											_tmp45_ = lower_name;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
											if (g_strcmp0 (_tmp45_, "ceil") == 0) {
#line 2137 "math-function.c"
												Number* _tmp46_ = NULL;
												Number* _tmp47_ = NULL;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
												_tmp46_ = x;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
												_tmp47_ = number_ceiling (_tmp46_);
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
												result = _tmp47_;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
												_g_object_unref0 (x);
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
												_g_free0 (lower_name);
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
												return result;
#line 2152 "math-function.c"
											} else {
												const gchar* _tmp48_ = NULL;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
												_tmp48_ = lower_name;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
												if (g_strcmp0 (_tmp48_, "round") == 0) {
#line 2159 "math-function.c"
													Number* _tmp49_ = NULL;
													Number* _tmp50_ = NULL;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
													_tmp49_ = x;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
													_tmp50_ = number_round (_tmp49_);
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
													result = _tmp50_;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
													_g_object_unref0 (x);
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
													_g_free0 (lower_name);
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
													return result;
#line 2174 "math-function.c"
												} else {
													const gchar* _tmp51_ = NULL;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
													_tmp51_ = lower_name;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
													if (g_strcmp0 (_tmp51_, "re") == 0) {
#line 2181 "math-function.c"
														Number* _tmp52_ = NULL;
														Number* _tmp53_ = NULL;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
														_tmp52_ = x;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
														_tmp53_ = number_real_component (_tmp52_);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
														result = _tmp53_;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
														_g_object_unref0 (x);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
														_g_free0 (lower_name);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
														return result;
#line 2196 "math-function.c"
													} else {
														const gchar* _tmp54_ = NULL;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
														_tmp54_ = lower_name;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
														if (g_strcmp0 (_tmp54_, "im") == 0) {
#line 2203 "math-function.c"
															Number* _tmp55_ = NULL;
															Number* _tmp56_ = NULL;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
															_tmp55_ = x;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
															_tmp56_ = number_imaginary_component (_tmp55_);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
															result = _tmp56_;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
															_g_object_unref0 (x);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
															_g_free0 (lower_name);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
															return result;
#line 2218 "math-function.c"
														} else {
															const gchar* _tmp57_ = NULL;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
															_tmp57_ = lower_name;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
															if (g_strcmp0 (_tmp57_, "sin") == 0) {
#line 2225 "math-function.c"
																Number* _tmp58_ = NULL;
																Parser* _tmp59_ = NULL;
																AngleUnit _tmp60_ = 0;
																Number* _tmp61_ = NULL;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																_tmp58_ = x;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																_tmp59_ = root_parser;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																_tmp60_ = _tmp59_->angle_units;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																_tmp61_ = number_sin (_tmp58_, _tmp60_);
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																result = _tmp61_;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																_g_object_unref0 (x);
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																_g_free0 (lower_name);
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																return result;
#line 2246 "math-function.c"
															} else {
																const gchar* _tmp62_ = NULL;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																_tmp62_ = lower_name;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																if (g_strcmp0 (_tmp62_, "cos") == 0) {
#line 2253 "math-function.c"
																	Number* _tmp63_ = NULL;
																	Parser* _tmp64_ = NULL;
																	AngleUnit _tmp65_ = 0;
																	Number* _tmp66_ = NULL;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																	_tmp63_ = x;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																	_tmp64_ = root_parser;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																	_tmp65_ = _tmp64_->angle_units;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																	_tmp66_ = number_cos (_tmp63_, _tmp65_);
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																	result = _tmp66_;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																	_g_object_unref0 (x);
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																	_g_free0 (lower_name);
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																	return result;
#line 2274 "math-function.c"
																} else {
																	const gchar* _tmp67_ = NULL;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																	_tmp67_ = lower_name;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																	if (g_strcmp0 (_tmp67_, "tan") == 0) {
#line 2281 "math-function.c"
																		Number* _tmp68_ = NULL;
																		Parser* _tmp69_ = NULL;
																		AngleUnit _tmp70_ = 0;
																		Number* _tmp71_ = NULL;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																		_tmp68_ = x;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																		_tmp69_ = root_parser;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																		_tmp70_ = _tmp69_->angle_units;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																		_tmp71_ = number_tan (_tmp68_, _tmp70_);
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																		result = _tmp71_;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																		_g_object_unref0 (x);
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																		_g_free0 (lower_name);
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																		return result;
#line 2302 "math-function.c"
																	} else {
																		gboolean _tmp72_ = FALSE;
																		const gchar* _tmp73_ = NULL;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																		_tmp73_ = lower_name;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																		if (g_strcmp0 (_tmp73_, "sin⁻¹") == 0) {
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																			_tmp72_ = TRUE;
#line 2312 "math-function.c"
																		} else {
																			const gchar* _tmp74_ = NULL;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																			_tmp74_ = lower_name;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																			_tmp72_ = g_strcmp0 (_tmp74_, "asin") == 0;
#line 2319 "math-function.c"
																		}
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																		if (_tmp72_) {
#line 2323 "math-function.c"
																			Number* _tmp75_ = NULL;
																			Parser* _tmp76_ = NULL;
																			AngleUnit _tmp77_ = 0;
																			Number* _tmp78_ = NULL;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																			_tmp75_ = x;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																			_tmp76_ = root_parser;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																			_tmp77_ = _tmp76_->angle_units;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																			_tmp78_ = number_asin (_tmp75_, _tmp77_);
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																			result = _tmp78_;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																			_g_object_unref0 (x);
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																			_g_free0 (lower_name);
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																			return result;
#line 2344 "math-function.c"
																		} else {
																			gboolean _tmp79_ = FALSE;
																			const gchar* _tmp80_ = NULL;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																			_tmp80_ = lower_name;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																			if (g_strcmp0 (_tmp80_, "cos⁻¹") == 0) {
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																				_tmp79_ = TRUE;
#line 2354 "math-function.c"
																			} else {
																				const gchar* _tmp81_ = NULL;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																				_tmp81_ = lower_name;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																				_tmp79_ = g_strcmp0 (_tmp81_, "acos") == 0;
#line 2361 "math-function.c"
																			}
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																			if (_tmp79_) {
#line 2365 "math-function.c"
																				Number* _tmp82_ = NULL;
																				Parser* _tmp83_ = NULL;
																				AngleUnit _tmp84_ = 0;
																				Number* _tmp85_ = NULL;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																				_tmp82_ = x;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																				_tmp83_ = root_parser;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																				_tmp84_ = _tmp83_->angle_units;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																				_tmp85_ = number_acos (_tmp82_, _tmp84_);
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																				result = _tmp85_;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																				_g_object_unref0 (x);
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																				_g_free0 (lower_name);
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																				return result;
#line 2386 "math-function.c"
																			} else {
																				gboolean _tmp86_ = FALSE;
																				const gchar* _tmp87_ = NULL;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																				_tmp87_ = lower_name;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																				if (g_strcmp0 (_tmp87_, "tan⁻¹") == 0) {
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																					_tmp86_ = TRUE;
#line 2396 "math-function.c"
																				} else {
																					const gchar* _tmp88_ = NULL;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																					_tmp88_ = lower_name;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																					_tmp86_ = g_strcmp0 (_tmp88_, "atan") == 0;
#line 2403 "math-function.c"
																				}
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																				if (_tmp86_) {
#line 2407 "math-function.c"
																					Number* _tmp89_ = NULL;
																					Parser* _tmp90_ = NULL;
																					AngleUnit _tmp91_ = 0;
																					Number* _tmp92_ = NULL;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																					_tmp89_ = x;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																					_tmp90_ = root_parser;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																					_tmp91_ = _tmp90_->angle_units;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																					_tmp92_ = number_atan (_tmp89_, _tmp91_);
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																					result = _tmp92_;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																					_g_object_unref0 (x);
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																					_g_free0 (lower_name);
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																					return result;
#line 2428 "math-function.c"
																				} else {
																					const gchar* _tmp93_ = NULL;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																					_tmp93_ = lower_name;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																					if (g_strcmp0 (_tmp93_, "sinh") == 0) {
#line 2435 "math-function.c"
																						Number* _tmp94_ = NULL;
																						Number* _tmp95_ = NULL;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																						_tmp94_ = x;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																						_tmp95_ = number_sinh (_tmp94_);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																						result = _tmp95_;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																						_g_object_unref0 (x);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																						_g_free0 (lower_name);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																						return result;
#line 2450 "math-function.c"
																					} else {
																						const gchar* _tmp96_ = NULL;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																						_tmp96_ = lower_name;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																						if (g_strcmp0 (_tmp96_, "cosh") == 0) {
#line 2457 "math-function.c"
																							Number* _tmp97_ = NULL;
																							Number* _tmp98_ = NULL;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																							_tmp97_ = x;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																							_tmp98_ = number_cosh (_tmp97_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																							result = _tmp98_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																							_g_object_unref0 (x);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																							_g_free0 (lower_name);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																							return result;
#line 2472 "math-function.c"
																						} else {
																							const gchar* _tmp99_ = NULL;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																							_tmp99_ = lower_name;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																							if (g_strcmp0 (_tmp99_, "tanh") == 0) {
#line 2479 "math-function.c"
																								Number* _tmp100_ = NULL;
																								Number* _tmp101_ = NULL;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																								_tmp100_ = x;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																								_tmp101_ = number_tanh (_tmp100_);
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																								result = _tmp101_;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																								_g_object_unref0 (x);
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																								_g_free0 (lower_name);
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																								return result;
#line 2494 "math-function.c"
																							} else {
																								gboolean _tmp102_ = FALSE;
																								const gchar* _tmp103_ = NULL;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																								_tmp103_ = lower_name;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																								if (g_strcmp0 (_tmp103_, "sinh⁻¹") == 0) {
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																									_tmp102_ = TRUE;
#line 2504 "math-function.c"
																								} else {
																									const gchar* _tmp104_ = NULL;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																									_tmp104_ = lower_name;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																									_tmp102_ = g_strcmp0 (_tmp104_, "asinh") == 0;
#line 2511 "math-function.c"
																								}
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																								if (_tmp102_) {
#line 2515 "math-function.c"
																									Number* _tmp105_ = NULL;
																									Number* _tmp106_ = NULL;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																									_tmp105_ = x;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																									_tmp106_ = number_asinh (_tmp105_);
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																									result = _tmp106_;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																									_g_object_unref0 (x);
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																									_g_free0 (lower_name);
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																									return result;
#line 2530 "math-function.c"
																								} else {
																									gboolean _tmp107_ = FALSE;
																									const gchar* _tmp108_ = NULL;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																									_tmp108_ = lower_name;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																									if (g_strcmp0 (_tmp108_, "cosh⁻¹") == 0) {
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																										_tmp107_ = TRUE;
#line 2540 "math-function.c"
																									} else {
																										const gchar* _tmp109_ = NULL;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																										_tmp109_ = lower_name;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																										_tmp107_ = g_strcmp0 (_tmp109_, "acosh") == 0;
#line 2547 "math-function.c"
																									}
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																									if (_tmp107_) {
#line 2551 "math-function.c"
																										Number* _tmp110_ = NULL;
																										Number* _tmp111_ = NULL;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																										_tmp110_ = x;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																										_tmp111_ = number_acosh (_tmp110_);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																										result = _tmp111_;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																										_g_object_unref0 (x);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																										_g_free0 (lower_name);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																										return result;
#line 2566 "math-function.c"
																									} else {
																										gboolean _tmp112_ = FALSE;
																										const gchar* _tmp113_ = NULL;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																										_tmp113_ = lower_name;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																										if (g_strcmp0 (_tmp113_, "tanh⁻¹") == 0) {
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																											_tmp112_ = TRUE;
#line 2576 "math-function.c"
																										} else {
																											const gchar* _tmp114_ = NULL;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																											_tmp114_ = lower_name;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																											_tmp112_ = g_strcmp0 (_tmp114_, "atanh") == 0;
#line 2583 "math-function.c"
																										}
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																										if (_tmp112_) {
#line 2587 "math-function.c"
																											Number* _tmp115_ = NULL;
																											Number* _tmp116_ = NULL;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																											_tmp115_ = x;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																											_tmp116_ = number_atanh (_tmp115_);
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																											result = _tmp116_;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																											_g_object_unref0 (x);
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																											_g_free0 (lower_name);
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																											return result;
#line 2602 "math-function.c"
																										} else {
																											const gchar* _tmp117_ = NULL;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																											_tmp117_ = lower_name;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																											if (g_strcmp0 (_tmp117_, "ones") == 0) {
#line 2609 "math-function.c"
																												Number* _tmp118_ = NULL;
																												Parser* _tmp119_ = NULL;
																												gint _tmp120_ = 0;
																												Number* _tmp121_ = NULL;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																												_tmp118_ = x;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																												_tmp119_ = root_parser;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																												_tmp120_ = _tmp119_->wordlen;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																												_tmp121_ = number_ones_complement (_tmp118_, _tmp120_);
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																												result = _tmp121_;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																												_g_object_unref0 (x);
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																												_g_free0 (lower_name);
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																												return result;
#line 2630 "math-function.c"
																											} else {
																												const gchar* _tmp122_ = NULL;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																												_tmp122_ = lower_name;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																												if (g_strcmp0 (_tmp122_, "twos") == 0) {
#line 2637 "math-function.c"
																													Number* _tmp123_ = NULL;
																													Parser* _tmp124_ = NULL;
																													gint _tmp125_ = 0;
																													Number* _tmp126_ = NULL;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																													_tmp123_ = x;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																													_tmp124_ = root_parser;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																													_tmp125_ = _tmp124_->wordlen;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																													_tmp126_ = number_twos_complement (_tmp123_, _tmp125_);
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																													result = _tmp126_;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																													_g_object_unref0 (x);
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																													_g_free0 (lower_name);
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
																													return result;
#line 2658 "math-function.c"
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	result = NULL;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_g_object_unref0 (x);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	_g_free0 (lower_name);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-function.vala"
	return result;
#line 2695 "math-function.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



