/* contacts-avatar-dialog.c generated by valac 0.27.1.3-61291, the Vala compiler
 * generated from contacts-avatar-dialog.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libgnome-desktop/gnome-desktop-thumbnail.h>
#include <um-crop-area.h>
#include <cheese-flash.h>
#include <cheese/cheese-camera-device-monitor.h>
#include <cheese/cheese-widget.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <math.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <cheese/cheese-camera-device.h>
#include <cheese/cheese-camera.h>


#define CONTACTS_TYPE_AVATAR_DIALOG (contacts_avatar_dialog_get_type ())
#define CONTACTS_AVATAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialog))
#define CONTACTS_AVATAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogClass))
#define CONTACTS_IS_AVATAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR_DIALOG))
#define CONTACTS_IS_AVATAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR_DIALOG))
#define CONTACTS_AVATAR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogClass))

typedef struct _ContactsAvatarDialog ContactsAvatarDialog;
typedef struct _ContactsAvatarDialogClass ContactsAvatarDialogClass;
typedef struct _ContactsAvatarDialogPrivate ContactsAvatarDialogPrivate;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;

#define CONTACTS_TYPE_CONTACT_FRAME (contacts_contact_frame_get_type ())
#define CONTACTS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrame))
#define CONTACTS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))
#define CONTACTS_IS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_IS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_CONTACT_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))

typedef struct _ContactsContactFrame ContactsContactFrame;
typedef struct _ContactsContactFrameClass ContactsContactFrameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block37Data Block37Data;
typedef struct _ContactsContactPrivate ContactsContactPrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block38Data Block38Data;
typedef struct _Block39Data Block39Data;

#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
typedef struct _ContactsAppPrivate ContactsAppPrivate;

#define CONTACTS_TYPE_WINDOW (contacts_window_get_type ())
#define CONTACTS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_WINDOW, ContactsWindow))
#define CONTACTS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_WINDOW, ContactsWindowClass))
#define CONTACTS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_WINDOW))
#define CONTACTS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_WINDOW))
#define CONTACTS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_WINDOW, ContactsWindowClass))

typedef struct _ContactsWindow ContactsWindow;
typedef struct _ContactsWindowClass ContactsWindowClass;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

struct _ContactsAvatarDialog {
	GtkDialog parent_instance;
	ContactsAvatarDialogPrivate * priv;
};

struct _ContactsAvatarDialogClass {
	GtkDialogClass parent_class;
};

struct _ContactsAvatarDialogPrivate {
	GnomeDesktopThumbnailFactory* thumbnail_factory;
	ContactsContact* contact;
	GtkStack* views_stack;
	UmCropArea* crop_area;
	GtkGrid* view_grid;
	ContactsContactFrame* main_frame;
	CheeseFlash* flash;
	CheeseCameraDeviceMonitor* camera_monitor;
	CheeseWidget* cheese;
	gint num_cameras;
	GdkPixbuf* new_pixbuf;
};

struct _Block37Data {
	int _ref_count_;
	ContactsAvatarDialog* self;
	GdkPixbuf* avatar_pixbuf;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	gboolean is_main;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
	FolksPersona* fake_persona;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block38Data {
	int _ref_count_;
	ContactsAvatarDialog* self;
	GtkFileChooserDialog* chooser;
};

struct _Block39Data {
	int _ref_count_;
	ContactsAvatarDialog* self;
	GtkButton* webcam_button;
	ContactsContact* contact;
};

struct _ContactsApp {
	GtkApplication parent_instance;
	ContactsAppPrivate * priv;
	GSettings* settings;
	ContactsStore* contacts_store;
	ContactsWindow* window;
};

struct _ContactsAppClass {
	GtkApplicationClass parent_class;
};


static gpointer contacts_avatar_dialog_parent_class = NULL;
extern ContactsApp* contacts_app_app;

GType contacts_avatar_dialog_get_type (void) G_GNUC_CONST;
GType contacts_contact_get_type (void) G_GNUC_CONST;
GType contacts_contact_frame_get_type (void) G_GNUC_CONST;
#define CONTACTS_AVATAR_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogPrivate))
enum  {
	CONTACTS_AVATAR_DIALOG_DUMMY_PROPERTY
};
#define CONTACTS_AVATAR_DIALOG_main_size 128
#define CONTACTS_AVATAR_DIALOG_icons_size 64
#define CONTACTS_AVATAR_DIALOG_n_columns 6
static GdkPixbuf* contacts_avatar_dialog_scale_pixbuf_for_avatar_use (ContactsAvatarDialog* self, GdkPixbuf* pixbuf);
static ContactsContactFrame* contacts_avatar_dialog_create_frame (ContactsAvatarDialog* self, GdkPixbuf* source_pixbuf);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (void * _userdata_);
ContactsContactFrame* contacts_contact_frame_new (gint size, gboolean with_button);
ContactsContactFrame* contacts_contact_frame_construct (GType object_type, gint size, gboolean with_button);
void contacts_contact_frame_set_pixbuf (ContactsContactFrame* self, GdkPixbuf* a_pixbuf);
static void __lambda56_ (Block37Data* _data37_);
static void contacts_avatar_dialog_selected_pixbuf (ContactsAvatarDialog* self, GdkPixbuf* pixbuf);
static void ___lambda56__contacts_contact_frame_clicked (ContactsContactFrame* _sender, gpointer self);
static ContactsContactFrame* contacts_avatar_dialog_frame_for_persona (ContactsAvatarDialog* self, FolksPersona* persona);
static ContactsContactFrame* contacts_avatar_dialog_frame_for_filename (ContactsAvatarDialog* self, const gchar* filename);
static void contacts_avatar_dialog_update_grid (ContactsAvatarDialog* self);
GType contacts_store_get_type (void) G_GNUC_CONST;
gchar** contacts_utils_get_stock_avatars (int* result_length1);
void contacts_avatar_dialog_update_preview (ContactsAvatarDialog* self, GtkFileChooser* chooser);
static void contacts_avatar_dialog_set_crop_widget (ContactsAvatarDialog* self, GdkPixbuf* pixbuf);
static void contacts_avatar_dialog_select_avatar_file_cb (ContactsAvatarDialog* self);
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
static void _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview (GtkFileChooser* _sender, gpointer self);
static void __lambda57_ (Block38Data* _data38_, gint response);
static void ___lambda57__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
ContactsAvatarDialog* contacts_avatar_dialog_new (ContactsContact* contact);
ContactsAvatarDialog* contacts_avatar_dialog_construct (GType object_type, ContactsContact* contact);
static Block39Data* block39_data_ref (Block39Data* _data39_);
static void block39_data_unref (void * _userdata_);
GType contacts_app_get_type (void) G_GNUC_CONST;
GType contacts_window_get_type (void) G_GNUC_CONST;
void contacts_contact_keep_widget_uptodate (ContactsContact* self, GtkWidget* w, GtkCallback callback, void* callback_target, GDestroyNotify callback_target_destroy_notify);
static void ___lambda58_ (Block39Data* _data39_, GtkWidget* w);
void contacts_contact_frame_set_image (ContactsContactFrame* self, FolksAvatarDetails* details, ContactsContact* contact);
static void ____lambda58__gtk_callback (GtkWidget* widget, gpointer self);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static void _contacts_avatar_dialog_select_avatar_file_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda59_ (Block39Data* _data39_);
static void ___lambda59__cheese_camera_device_monitor_added (CheeseCameraDeviceMonitor* _sender, CheeseCameraDevice* device, gpointer self);
static void __lambda60_ (Block39Data* _data39_);
static void ___lambda60__cheese_camera_device_monitor_removed (CheeseCameraDeviceMonitor* _sender, const gchar* uuid, gpointer self);
static void __lambda61_ (ContactsAvatarDialog* self, GtkButton* button);
static void ___lambda61__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda62_ (ContactsAvatarDialog* self, GtkButton* button);
static void ___lambda62__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda63_ (ContactsAvatarDialog* self, GtkButton* button);
static void ___lambda63__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda64_ (ContactsAvatarDialog* self, GtkButton* button);
static void __lambda65_ (ContactsAvatarDialog* self, GdkPixbuf* pix);
static void ___lambda65__cheese_camera_photo_taken (CheeseCamera* _sender, GdkPixbuf* pixbuf, gpointer self);
static void ___lambda64__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda66_ (ContactsAvatarDialog* self, GtkButton* button);
static void ___lambda66__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda67_ (ContactsAvatarDialog* self, gint response_id);
static void ___lambda67__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void contacts_avatar_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
#line 49 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	return self ? g_object_ref (self) : NULL;
#line 259 "contacts-avatar-dialog.c"
}


static GdkPixbuf* contacts_avatar_dialog_scale_pixbuf_for_avatar_use (ContactsAvatarDialog* self, GdkPixbuf* pixbuf) {
	GdkPixbuf* result = NULL;
	gint w = 0;
	GdkPixbuf* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint h = 0;
	GdkPixbuf* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GdkPixbuf* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	GdkPixbuf* _tmp20_ = NULL;
#line 44 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_val_if_fail (pixbuf != NULL, NULL);
#line 45 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = pixbuf;
#line 45 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp1_ = gdk_pixbuf_get_width (_tmp0_);
#line 45 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	w = _tmp1_;
#line 46 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp2_ = pixbuf;
#line 46 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp3_ = gdk_pixbuf_get_height (_tmp2_);
#line 46 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	h = _tmp3_;
#line 48 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp5_ = w;
#line 48 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (_tmp5_ <= 128) {
#line 299 "contacts-avatar-dialog.c"
		gint _tmp6_ = 0;
#line 48 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp6_ = h;
#line 48 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp4_ = _tmp6_ <= 128;
#line 305 "contacts-avatar-dialog.c"
	} else {
#line 48 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp4_ = FALSE;
#line 309 "contacts-avatar-dialog.c"
	}
#line 48 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (_tmp4_) {
#line 313 "contacts-avatar-dialog.c"
		GdkPixbuf* _tmp7_ = NULL;
		GdkPixbuf* _tmp8_ = NULL;
#line 49 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp7_ = pixbuf;
#line 49 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 49 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		result = _tmp8_;
#line 49 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		return result;
#line 324 "contacts-avatar-dialog.c"
	}
#line 51 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp9_ = w;
#line 51 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp10_ = h;
#line 51 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (_tmp9_ > _tmp10_) {
#line 332 "contacts-avatar-dialog.c"
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gdouble _tmp13_ = 0.0;
#line 52 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp11_ = h;
#line 52 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp12_ = w;
#line 52 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp13_ = round ((_tmp11_ * 128.0) / _tmp12_);
#line 52 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		h = (gint) _tmp13_;
#line 53 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		w = 128;
#line 346 "contacts-avatar-dialog.c"
	} else {
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gdouble _tmp16_ = 0.0;
#line 55 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp14_ = w;
#line 55 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp15_ = h;
#line 55 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp16_ = round ((_tmp14_ * 128.0) / _tmp15_);
#line 55 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		w = (gint) _tmp16_;
#line 56 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		h = 128;
#line 361 "contacts-avatar-dialog.c"
	}
#line 59 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp17_ = pixbuf;
#line 59 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp18_ = w;
#line 59 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp19_ = h;
#line 59 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp20_ = gdk_pixbuf_scale_simple (_tmp17_, _tmp18_, _tmp19_, GDK_INTERP_HYPER);
#line 59 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	result = _tmp20_;
#line 59 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	return result;
#line 375 "contacts-avatar-dialog.c"
}


static Block37Data* block37_data_ref (Block37Data* _data37_) {
#line 62 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_atomic_int_inc (&_data37_->_ref_count_);
#line 62 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	return _data37_;
#line 384 "contacts-avatar-dialog.c"
}


static void block37_data_unref (void * _userdata_) {
	Block37Data* _data37_;
	_data37_ = (Block37Data*) _userdata_;
#line 62 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
#line 393 "contacts-avatar-dialog.c"
		ContactsAvatarDialog* self;
#line 62 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		self = _data37_->self;
#line 62 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (_data37_->avatar_pixbuf);
#line 62 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (self);
#line 62 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		g_slice_free (Block37Data, _data37_);
#line 403 "contacts-avatar-dialog.c"
	}
}


static void __lambda56_ (Block37Data* _data37_) {
	ContactsAvatarDialog* self;
#line 67 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self = _data37_->self;
#line 68 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	contacts_avatar_dialog_selected_pixbuf (self, _data37_->avatar_pixbuf);
#line 414 "contacts-avatar-dialog.c"
}


static void ___lambda56__contacts_contact_frame_clicked (ContactsContactFrame* _sender, gpointer self) {
#line 67 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	__lambda56_ (self);
#line 421 "contacts-avatar-dialog.c"
}


static ContactsContactFrame* contacts_avatar_dialog_create_frame (ContactsAvatarDialog* self, GdkPixbuf* source_pixbuf) {
	ContactsContactFrame* result = NULL;
	Block37Data* _data37_;
	ContactsContactFrame* image_frame = NULL;
	ContactsContactFrame* _tmp0_ = NULL;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
#line 62 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 62 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_val_if_fail (source_pixbuf != NULL, NULL);
#line 62 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_data37_ = g_slice_new0 (Block37Data);
#line 62 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_data37_->_ref_count_ = 1;
#line 62 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_data37_->self = g_object_ref (self);
#line 63 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = contacts_contact_frame_new (CONTACTS_AVATAR_DIALOG_icons_size, TRUE);
#line 63 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp0_);
#line 63 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	image_frame = _tmp0_;
#line 64 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp1_ = source_pixbuf;
#line 64 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp2_ = gdk_pixbuf_scale_simple (_tmp1_, CONTACTS_AVATAR_DIALOG_icons_size, CONTACTS_AVATAR_DIALOG_icons_size, GDK_INTERP_HYPER);
#line 64 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	pixbuf = _tmp2_;
#line 65 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	contacts_contact_frame_set_pixbuf (image_frame, pixbuf);
#line 66 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp3_ = source_pixbuf;
#line 66 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp4_ = contacts_avatar_dialog_scale_pixbuf_for_avatar_use (self, _tmp3_);
#line 66 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_data37_->avatar_pixbuf = _tmp4_;
#line 67 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_signal_connect_data (image_frame, "clicked", (GCallback) ___lambda56__contacts_contact_frame_clicked, block37_data_ref (_data37_), (GClosureNotify) block37_data_unref, 0);
#line 70 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	result = image_frame;
#line 70 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (pixbuf);
#line 70 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	block37_data_unref (_data37_);
#line 70 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_data37_ = NULL;
#line 70 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	return result;
#line 477 "contacts-avatar-dialog.c"
}


static ContactsContactFrame* contacts_avatar_dialog_frame_for_persona (ContactsAvatarDialog* self, FolksPersona* persona) {
	ContactsContactFrame* result = NULL;
	FolksAvatarDetails* details = NULL;
	FolksPersona* _tmp0_ = NULL;
	FolksAvatarDetails* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	FolksAvatarDetails* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 73 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 73 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_val_if_fail (persona != NULL, NULL);
#line 74 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = persona;
#line 74 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, FOLKS_TYPE_AVATAR_DETAILS) ? ((FolksAvatarDetails*) _tmp0_) : NULL);
#line 74 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	details = _tmp1_;
#line 75 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp3_ = details;
#line 75 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (_tmp3_ == NULL) {
#line 75 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp2_ = TRUE;
#line 505 "contacts-avatar-dialog.c"
	} else {
		FolksAvatarDetails* _tmp4_ = NULL;
		GLoadableIcon* _tmp5_ = NULL;
		GLoadableIcon* _tmp6_ = NULL;
#line 75 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp4_ = details;
#line 75 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp5_ = folks_avatar_details_get_avatar (_tmp4_);
#line 75 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp6_ = _tmp5_;
#line 75 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp2_ = _tmp6_ == NULL;
#line 518 "contacts-avatar-dialog.c"
	}
#line 75 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (_tmp2_) {
#line 76 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		result = NULL;
#line 76 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (details);
#line 76 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		return result;
#line 528 "contacts-avatar-dialog.c"
	}
	{
		GInputStream* stream = NULL;
		FolksAvatarDetails* _tmp7_ = NULL;
		GLoadableIcon* _tmp8_ = NULL;
		GLoadableIcon* _tmp9_ = NULL;
		GInputStream* _tmp10_ = NULL;
		GdkPixbuf* pixbuf = NULL;
		GInputStream* _tmp11_ = NULL;
		GdkPixbuf* _tmp12_ = NULL;
		GdkPixbuf* _tmp13_ = NULL;
		ContactsContactFrame* _tmp14_ = NULL;
#line 79 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp7_ = details;
#line 79 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp8_ = folks_avatar_details_get_avatar (_tmp7_);
#line 79 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp9_ = _tmp8_;
#line 79 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp10_ = g_loadable_icon_load (_tmp9_, 128, NULL, NULL, &_inner_error_);
#line 79 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		stream = _tmp10_;
#line 79 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 553 "contacts-avatar-dialog.c"
			goto __catch36_g_error;
		}
#line 80 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp11_ = stream;
#line 80 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp12_ = gdk_pixbuf_new_from_stream (_tmp11_, NULL, &_inner_error_);
#line 80 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		pixbuf = _tmp12_;
#line 80 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 80 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_g_object_unref0 (stream);
#line 566 "contacts-avatar-dialog.c"
			goto __catch36_g_error;
		}
#line 81 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp13_ = pixbuf;
#line 81 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp14_ = contacts_avatar_dialog_create_frame (self, _tmp13_);
#line 81 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		result = _tmp14_;
#line 81 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (pixbuf);
#line 81 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (stream);
#line 81 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (details);
#line 81 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		return result;
#line 583 "contacts-avatar-dialog.c"
	}
	goto __finally36;
	__catch36_g_error:
	{
#line 78 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		g_clear_error (&_inner_error_);
#line 78 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_inner_error_ = NULL;
#line 592 "contacts-avatar-dialog.c"
	}
	__finally36:
#line 78 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 78 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (details);
#line 78 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 78 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		g_clear_error (&_inner_error_);
#line 78 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		return NULL;
#line 605 "contacts-avatar-dialog.c"
	}
#line 86 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	result = NULL;
#line 86 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (details);
#line 86 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	return result;
#line 613 "contacts-avatar-dialog.c"
}


static ContactsContactFrame* contacts_avatar_dialog_frame_for_filename (ContactsAvatarDialog* self, const gchar* filename) {
	ContactsContactFrame* result = NULL;
	ContactsContactFrame* image_frame = NULL;
	GError * _inner_error_ = NULL;
#line 89 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 89 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 90 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	image_frame = NULL;
#line 627 "contacts-avatar-dialog.c"
	{
		GdkPixbuf* pixbuf = NULL;
		const gchar* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_ = NULL;
		ContactsContactFrame* _tmp2_ = NULL;
#line 92 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp0_ = filename;
#line 92 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp1_ = gdk_pixbuf_new_from_file (_tmp0_, &_inner_error_);
#line 92 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		pixbuf = _tmp1_;
#line 92 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 641 "contacts-avatar-dialog.c"
			goto __catch37_g_error;
		}
#line 93 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp2_ = contacts_avatar_dialog_create_frame (self, pixbuf);
#line 93 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		result = _tmp2_;
#line 93 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (pixbuf);
#line 93 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (image_frame);
#line 93 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		return result;
#line 654 "contacts-avatar-dialog.c"
	}
	goto __finally37;
	__catch37_g_error:
	{
#line 91 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		g_clear_error (&_inner_error_);
#line 91 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_inner_error_ = NULL;
#line 663 "contacts-avatar-dialog.c"
	}
	__finally37:
#line 91 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 91 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (image_frame);
#line 91 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 91 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		g_clear_error (&_inner_error_);
#line 91 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		return NULL;
#line 676 "contacts-avatar-dialog.c"
	}
#line 96 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	result = image_frame;
#line 96 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	return result;
#line 682 "contacts-avatar-dialog.c"
}


static void contacts_avatar_dialog_selected_pixbuf (ContactsAvatarDialog* self, GdkPixbuf* pixbuf) {
	GdkPixbuf* p = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	ContactsContactFrame* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
#line 99 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_if_fail (pixbuf != NULL);
#line 100 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = pixbuf;
#line 100 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp1_ = gdk_pixbuf_scale_simple (_tmp0_, CONTACTS_AVATAR_DIALOG_main_size, CONTACTS_AVATAR_DIALOG_main_size, GDK_INTERP_HYPER);
#line 100 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	p = _tmp1_;
#line 101 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp2_ = self->priv->main_frame;
#line 101 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	contacts_contact_frame_set_pixbuf (_tmp2_, p);
#line 103 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp3_ = pixbuf;
#line 103 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 103 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->new_pixbuf);
#line 103 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self->priv->new_pixbuf = _tmp4_;
#line 104 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, (gint) GTK_RESPONSE_OK, TRUE);
#line 99 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (p);
#line 719 "contacts-avatar-dialog.c"
}


static void contacts_avatar_dialog_update_grid (ContactsAvatarDialog* self) {
	gint i = 0;
	gint j = 0;
	ContactsContact* _tmp0_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp23_ = 0;
	gchar** stock_files = NULL;
	gint _tmp28_ = 0;
	gchar** _tmp29_ = NULL;
	gint stock_files_length1 = 0;
	gint _stock_files_size_ = 0;
	gchar** _tmp30_ = NULL;
	gint _tmp30__length1 = 0;
	GtkGrid* _tmp43_ = NULL;
#line 107 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_if_fail (self != NULL);
#line 108 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	i = 0;
#line 109 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	j = 0;
#line 111 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = self->priv->contact;
#line 111 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (_tmp0_ != NULL) {
#line 747 "contacts-avatar-dialog.c"
		{
			GeeIterator* _p_it = NULL;
			ContactsContact* _tmp1_ = NULL;
			FolksIndividual* _tmp2_ = NULL;
			GeeSet* _tmp3_ = NULL;
			GeeSet* _tmp4_ = NULL;
			GeeIterator* _tmp5_ = NULL;
#line 112 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp1_ = self->priv->contact;
#line 112 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp2_ = _tmp1_->individual;
#line 112 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp3_ = folks_individual_get_personas (_tmp2_);
#line 112 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp4_ = _tmp3_;
#line 112 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 112 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_p_it = _tmp5_;
#line 112 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			while (TRUE) {
#line 769 "contacts-avatar-dialog.c"
				GeeIterator* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				FolksPersona* p = NULL;
				GeeIterator* _tmp8_ = NULL;
				gpointer _tmp9_ = NULL;
				ContactsContactFrame* frame = NULL;
				FolksPersona* _tmp10_ = NULL;
				ContactsContactFrame* _tmp11_ = NULL;
				ContactsContactFrame* _tmp12_ = NULL;
#line 112 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_tmp6_ = _p_it;
#line 112 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_tmp7_ = gee_iterator_next (_tmp6_);
#line 112 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				if (!_tmp7_) {
#line 112 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					break;
#line 787 "contacts-avatar-dialog.c"
				}
#line 112 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_tmp8_ = _p_it;
#line 112 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_tmp9_ = gee_iterator_get (_tmp8_);
#line 112 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				p = (FolksPersona*) _tmp9_;
#line 113 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_tmp10_ = p;
#line 113 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_tmp11_ = contacts_avatar_dialog_frame_for_persona (self, _tmp10_);
#line 113 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				frame = _tmp11_;
#line 114 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_tmp12_ = frame;
#line 114 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				if (_tmp12_ != NULL) {
#line 805 "contacts-avatar-dialog.c"
					GtkGrid* _tmp13_ = NULL;
					ContactsContactFrame* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
#line 115 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp13_ = self->priv->view_grid;
#line 115 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp14_ = frame;
#line 115 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp15_ = i;
#line 115 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp16_ = j;
#line 115 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					gtk_grid_attach (_tmp13_, (GtkWidget*) _tmp14_, _tmp15_, _tmp16_, 1, 1);
#line 116 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp17_ = i;
#line 116 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					i = _tmp17_ + 1;
#line 117 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp18_ = i;
#line 117 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					if (_tmp18_ >= CONTACTS_AVATAR_DIALOG_n_columns) {
#line 830 "contacts-avatar-dialog.c"
						gint _tmp19_ = 0;
						gint _tmp20_ = 0;
#line 118 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
						_tmp19_ = i;
#line 118 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
						i = _tmp19_ - CONTACTS_AVATAR_DIALOG_n_columns;
#line 119 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
						_tmp20_ = j;
#line 119 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
						j = _tmp20_ + 1;
#line 841 "contacts-avatar-dialog.c"
					}
				}
#line 112 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_g_object_unref0 (frame);
#line 112 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_g_object_unref0 (p);
#line 848 "contacts-avatar-dialog.c"
			}
#line 112 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_g_object_unref0 (_p_it);
#line 852 "contacts-avatar-dialog.c"
		}
	}
#line 125 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp21_ = i;
#line 125 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (_tmp21_ != 0) {
#line 859 "contacts-avatar-dialog.c"
		gint _tmp22_ = 0;
#line 126 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		i = 0;
#line 127 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp22_ = j;
#line 127 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		j = _tmp22_ + 1;
#line 867 "contacts-avatar-dialog.c"
	}
#line 130 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp23_ = j;
#line 130 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (_tmp23_ != 0) {
#line 873 "contacts-avatar-dialog.c"
		GtkSeparator* s = NULL;
		GtkSeparator* _tmp24_ = NULL;
		GtkGrid* _tmp25_ = NULL;
		GtkSeparator* _tmp26_ = NULL;
		gint _tmp27_ = 0;
#line 131 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp24_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
#line 131 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		g_object_ref_sink (_tmp24_);
#line 131 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		s = _tmp24_;
#line 132 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp25_ = self->priv->view_grid;
#line 132 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp26_ = s;
#line 132 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp27_ = j;
#line 132 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		j = _tmp27_ + 1;
#line 132 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		gtk_grid_attach (_tmp25_, (GtkWidget*) _tmp26_, 0, _tmp27_, CONTACTS_AVATAR_DIALOG_n_columns, 1);
#line 130 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (s);
#line 897 "contacts-avatar-dialog.c"
	}
#line 135 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp29_ = contacts_utils_get_stock_avatars (&_tmp28_);
#line 135 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	stock_files = _tmp29_;
#line 135 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	stock_files_length1 = _tmp28_;
#line 135 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_stock_files_size_ = stock_files_length1;
#line 136 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp30_ = stock_files;
#line 136 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp30__length1 = stock_files_length1;
#line 911 "contacts-avatar-dialog.c"
	{
		gchar** file_name_collection = NULL;
		gint file_name_collection_length1 = 0;
		gint _file_name_collection_size_ = 0;
		gint file_name_it = 0;
#line 136 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		file_name_collection = _tmp30_;
#line 136 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		file_name_collection_length1 = _tmp30__length1;
#line 136 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		for (file_name_it = 0; file_name_it < _tmp30__length1; file_name_it = file_name_it + 1) {
#line 923 "contacts-avatar-dialog.c"
			gchar* _tmp31_ = NULL;
			gchar* file_name = NULL;
#line 136 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp31_ = g_strdup (file_name_collection[file_name_it]);
#line 136 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			file_name = _tmp31_;
#line 930 "contacts-avatar-dialog.c"
			{
				ContactsContactFrame* frame = NULL;
				const gchar* _tmp32_ = NULL;
				ContactsContactFrame* _tmp33_ = NULL;
				ContactsContactFrame* _tmp34_ = NULL;
#line 137 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_tmp32_ = file_name;
#line 137 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_tmp33_ = contacts_avatar_dialog_frame_for_filename (self, _tmp32_);
#line 137 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				frame = _tmp33_;
#line 138 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_tmp34_ = frame;
#line 138 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				if (_tmp34_ != NULL) {
#line 946 "contacts-avatar-dialog.c"
					GtkGrid* _tmp35_ = NULL;
					ContactsContactFrame* _tmp36_ = NULL;
					gint _tmp37_ = 0;
					gint _tmp38_ = 0;
					gint _tmp39_ = 0;
					gint _tmp40_ = 0;
#line 139 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp35_ = self->priv->view_grid;
#line 139 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp36_ = frame;
#line 139 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp37_ = i;
#line 139 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp38_ = j;
#line 139 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					gtk_grid_attach (_tmp35_, (GtkWidget*) _tmp36_, _tmp37_, _tmp38_, 1, 1);
#line 140 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp39_ = i;
#line 140 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					i = _tmp39_ + 1;
#line 141 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp40_ = i;
#line 141 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					if (_tmp40_ >= CONTACTS_AVATAR_DIALOG_n_columns) {
#line 971 "contacts-avatar-dialog.c"
						gint _tmp41_ = 0;
						gint _tmp42_ = 0;
#line 142 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
						_tmp41_ = i;
#line 142 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
						i = _tmp41_ - CONTACTS_AVATAR_DIALOG_n_columns;
#line 143 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
						_tmp42_ = j;
#line 143 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
						j = _tmp42_ + 1;
#line 982 "contacts-avatar-dialog.c"
					}
				}
#line 136 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_g_object_unref0 (frame);
#line 136 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_g_free0 (file_name);
#line 989 "contacts-avatar-dialog.c"
			}
		}
	}
#line 148 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp43_ = self->priv->view_grid;
#line 148 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp43_);
#line 107 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	stock_files = (_vala_array_free (stock_files, stock_files_length1, (GDestroyNotify) g_free), NULL);
#line 999 "contacts-avatar-dialog.c"
}


void contacts_avatar_dialog_update_preview (ContactsAvatarDialog* self, GtkFileChooser* chooser) {
	gchar* uri = NULL;
	GtkFileChooser* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkFileChooser* _tmp26_ = NULL;
	GError * _inner_error_ = NULL;
#line 151 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_if_fail (self != NULL);
#line 151 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_if_fail (chooser != NULL);
#line 152 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = chooser;
#line 152 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp1_ = gtk_file_chooser_get_preview_uri (_tmp0_);
#line 152 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	uri = _tmp1_;
#line 153 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp2_ = uri;
#line 153 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (_tmp2_ != NULL) {
#line 1024 "contacts-avatar-dialog.c"
		GdkPixbuf* pixbuf = NULL;
		GtkImage* preview = NULL;
		GtkFileChooser* _tmp3_ = NULL;
		GtkWidget* _tmp4_ = NULL;
		GtkImage* _tmp5_ = NULL;
		GFile* file = NULL;
		const gchar* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GtkFileChooser* _tmp20_ = NULL;
		GdkPixbuf* _tmp21_ = NULL;
		GdkPixbuf* _tmp22_ = NULL;
#line 154 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		pixbuf = NULL;
#line 156 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp3_ = chooser;
#line 156 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp4_ = gtk_file_chooser_get_preview_widget (_tmp3_);
#line 156 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_image_get_type ()) ? ((GtkImage*) _tmp4_) : NULL);
#line 156 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		preview = _tmp5_;
#line 158 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp6_ = uri;
#line 158 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp7_ = g_file_new_for_uri (_tmp6_);
#line 158 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		file = _tmp7_;
#line 1052 "contacts-avatar-dialog.c"
		{
			GFileInfo* file_info = NULL;
			GFile* _tmp8_ = NULL;
			GFileInfo* _tmp9_ = NULL;
			GFileInfo* _tmp10_ = NULL;
#line 160 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp8_ = file;
#line 160 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp9_ = g_file_query_info (_tmp8_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 160 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			file_info = _tmp9_;
#line 160 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1066 "contacts-avatar-dialog.c"
				goto __catch38_g_error;
			}
#line 162 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp10_ = file_info;
#line 162 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			if (_tmp10_ != NULL) {
#line 1073 "contacts-avatar-dialog.c"
				gchar* mime_type = NULL;
				GFileInfo* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
#line 163 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_tmp11_ = file_info;
#line 163 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_tmp12_ = g_file_info_get_content_type (_tmp11_);
#line 163 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_tmp13_ = g_strdup (_tmp12_);
#line 163 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				mime_type = _tmp13_;
#line 165 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_tmp14_ = mime_type;
#line 165 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				if (_tmp14_ != NULL) {
#line 1091 "contacts-avatar-dialog.c"
					GnomeDesktopThumbnailFactory* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					GdkPixbuf* _tmp18_ = NULL;
					GdkPixbuf* _tmp19_ = NULL;
#line 166 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp15_ = self->priv->thumbnail_factory;
#line 166 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp16_ = uri;
#line 166 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp17_ = mime_type;
#line 166 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp18_ = gnome_desktop_thumbnail_factory_generate_thumbnail (_tmp15_, _tmp16_, _tmp17_);
#line 166 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp19_ = _g_object_ref0 (_tmp18_);
#line 166 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_g_object_unref0 (pixbuf);
#line 166 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					pixbuf = _tmp19_;
#line 1111 "contacts-avatar-dialog.c"
				}
#line 162 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_g_free0 (mime_type);
#line 1115 "contacts-avatar-dialog.c"
			}
#line 159 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_g_object_unref0 (file_info);
#line 1119 "contacts-avatar-dialog.c"
		}
		goto __finally38;
		__catch38_g_error:
		{
			GError* e = NULL;
#line 159 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			e = _inner_error_;
#line 159 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_inner_error_ = NULL;
#line 159 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_g_error_free0 (e);
#line 1131 "contacts-avatar-dialog.c"
		}
		__finally38:
#line 159 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 159 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_g_object_unref0 (file);
#line 159 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_g_object_unref0 (preview);
#line 159 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_g_object_unref0 (pixbuf);
#line 159 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_g_free0 (uri);
#line 159 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 159 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			g_clear_error (&_inner_error_);
#line 159 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			return;
#line 1150 "contacts-avatar-dialog.c"
		}
#line 171 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp20_ = chooser;
#line 171 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp21_ = pixbuf;
#line 171 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		gtk_dialog_set_response_sensitive (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp20_) : NULL, (gint) GTK_RESPONSE_ACCEPT, _tmp21_ != NULL);
#line 174 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp22_ = pixbuf;
#line 174 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		if (_tmp22_ != NULL) {
#line 1162 "contacts-avatar-dialog.c"
			GtkImage* _tmp23_ = NULL;
			GdkPixbuf* _tmp24_ = NULL;
#line 175 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp23_ = preview;
#line 175 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp24_ = pixbuf;
#line 175 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			gtk_image_set_from_pixbuf (_tmp23_, _tmp24_);
#line 1171 "contacts-avatar-dialog.c"
		} else {
			GtkImage* _tmp25_ = NULL;
#line 177 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp25_ = preview;
#line 177 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			gtk_image_set_from_icon_name (_tmp25_, "dialog-question", GTK_ICON_SIZE_DIALOG);
#line 1178 "contacts-avatar-dialog.c"
		}
#line 153 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (file);
#line 153 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (preview);
#line 153 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (pixbuf);
#line 1186 "contacts-avatar-dialog.c"
	}
#line 181 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp26_ = chooser;
#line 181 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_file_chooser_set_preview_widget_active (_tmp26_, TRUE);
#line 151 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_free0 (uri);
#line 1194 "contacts-avatar-dialog.c"
}


static void contacts_avatar_dialog_set_crop_widget (ContactsAvatarDialog* self, GdkPixbuf* pixbuf) {
	GtkGrid* frame_grid = NULL;
	GtkStack* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkGrid* _tmp2_ = NULL;
	UmCropArea* _tmp3_ = NULL;
	UmCropArea* _tmp4_ = NULL;
	UmCropArea* _tmp5_ = NULL;
	UmCropArea* _tmp6_ = NULL;
	UmCropArea* _tmp7_ = NULL;
	UmCropArea* _tmp8_ = NULL;
	GdkPixbuf* _tmp9_ = NULL;
	UmCropArea* _tmp10_ = NULL;
	GtkStack* _tmp11_ = NULL;
#line 184 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_if_fail (self != NULL);
#line 184 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_if_fail (pixbuf != NULL);
#line 185 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = self->priv->views_stack;
#line 185 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp1_ = gtk_stack_get_child_by_name (_tmp0_, "crop-page");
#line 185 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_grid_get_type ()) ? ((GtkGrid*) _tmp1_) : NULL);
#line 185 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	frame_grid = _tmp2_;
#line 186 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp3_ = (UmCropArea*) um_crop_area_new ();
#line 186 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp3_);
#line 186 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->crop_area);
#line 186 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self->priv->crop_area = _tmp3_;
#line 187 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp4_ = self->priv->crop_area;
#line 187 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_set_vexpand ((GtkWidget*) _tmp4_, TRUE);
#line 188 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp5_ = self->priv->crop_area;
#line 188 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp5_, TRUE);
#line 189 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp6_ = self->priv->crop_area;
#line 189 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	um_crop_area_set_min_size (_tmp6_, 48, 48);
#line 190 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp7_ = self->priv->crop_area;
#line 190 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	um_crop_area_set_constrain_aspect (_tmp7_, TRUE);
#line 191 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp8_ = self->priv->crop_area;
#line 191 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp9_ = pixbuf;
#line 191 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	um_crop_area_set_picture (_tmp8_, _tmp9_);
#line 193 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp10_ = self->priv->crop_area;
#line 193 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_grid_attach (frame_grid, (GtkWidget*) _tmp10_, 0, 0, 1, 1);
#line 194 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_show_all ((GtkWidget*) frame_grid);
#line 196 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp11_ = self->priv->views_stack;
#line 196 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_stack_set_visible_child_name (_tmp11_, "crop-page");
#line 184 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (frame_grid);
#line 1266 "contacts-avatar-dialog.c"
}


static Block38Data* block38_data_ref (Block38Data* _data38_) {
#line 199 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_atomic_int_inc (&_data38_->_ref_count_);
#line 199 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	return _data38_;
#line 1275 "contacts-avatar-dialog.c"
}


static void block38_data_unref (void * _userdata_) {
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
#line 199 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
#line 1284 "contacts-avatar-dialog.c"
		ContactsAvatarDialog* self;
#line 199 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		self = _data38_->self;
#line 199 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (_data38_->chooser);
#line 199 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (self);
#line 199 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		g_slice_free (Block38Data, _data38_);
#line 1294 "contacts-avatar-dialog.c"
	}
}


static void _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview (GtkFileChooser* _sender, gpointer self) {
#line 213 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	contacts_avatar_dialog_update_preview ((ContactsAvatarDialog*) self, _sender);
#line 1302 "contacts-avatar-dialog.c"
}


static void __lambda57_ (Block38Data* _data38_, gint response) {
	ContactsAvatarDialog* self;
	gint _tmp0_ = 0;
	GtkFileChooserDialog* _tmp21_ = NULL;
	GError * _inner_error_ = NULL;
#line 219 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self = _data38_->self;
#line 220 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = response;
#line 220 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (_tmp0_ != ((gint) GTK_RESPONSE_ACCEPT)) {
#line 1317 "contacts-avatar-dialog.c"
		GtkFileChooserDialog* _tmp1_ = NULL;
#line 221 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp1_ = _data38_->chooser;
#line 221 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp1_);
#line 222 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		return;
#line 1325 "contacts-avatar-dialog.c"
	}
	{
		GFile* file = NULL;
		GtkFileChooserDialog* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		GFileInputStream* in_stream = NULL;
		GFile* _tmp7_ = NULL;
		GFileInputStream* _tmp8_ = NULL;
		GdkPixbuf* pixbuf = NULL;
		GFileInputStream* _tmp9_ = NULL;
		GdkPixbuf* _tmp10_ = NULL;
		GFileInputStream* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		GdkPixbuf* _tmp13_ = NULL;
		gint _tmp14_ = 0;
#line 225 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp2_ = _data38_->chooser;
#line 225 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp3_ = gtk_file_chooser_get_uri ((GtkFileChooser*) _tmp2_);
#line 225 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp4_ = _tmp3_;
#line 225 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp5_ = g_file_new_for_uri (_tmp4_);
#line 225 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp6_ = _tmp5_;
#line 225 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_free0 (_tmp4_);
#line 225 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		file = _tmp6_;
#line 226 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp7_ = file;
#line 226 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp8_ = g_file_read (_tmp7_, NULL, &_inner_error_);
#line 226 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		in_stream = _tmp8_;
#line 226 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 226 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_g_object_unref0 (file);
#line 1368 "contacts-avatar-dialog.c"
			goto __catch39_g_error;
		}
#line 227 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp9_ = in_stream;
#line 227 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp10_ = gdk_pixbuf_new_from_stream ((GInputStream*) _tmp9_, NULL, &_inner_error_);
#line 227 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		pixbuf = _tmp10_;
#line 227 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 227 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_g_object_unref0 (in_stream);
#line 227 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_g_object_unref0 (file);
#line 1383 "contacts-avatar-dialog.c"
			goto __catch39_g_error;
		}
#line 228 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp11_ = in_stream;
#line 228 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		g_input_stream_close ((GInputStream*) _tmp11_, NULL, &_inner_error_);
#line 228 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 228 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_g_object_unref0 (pixbuf);
#line 228 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_g_object_unref0 (in_stream);
#line 228 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_g_object_unref0 (file);
#line 1398 "contacts-avatar-dialog.c"
			goto __catch39_g_error;
		}
#line 229 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp13_ = pixbuf;
#line 229 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp14_ = gdk_pixbuf_get_width (_tmp13_);
#line 229 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		if (_tmp14_ > 128) {
#line 229 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp12_ = TRUE;
#line 1409 "contacts-avatar-dialog.c"
		} else {
			GdkPixbuf* _tmp15_ = NULL;
			gint _tmp16_ = 0;
#line 229 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp15_ = pixbuf;
#line 229 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp16_ = gdk_pixbuf_get_height (_tmp15_);
#line 229 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp12_ = _tmp16_ > 128;
#line 1419 "contacts-avatar-dialog.c"
		}
#line 229 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		if (_tmp12_) {
#line 1423 "contacts-avatar-dialog.c"
			GdkPixbuf* _tmp17_ = NULL;
#line 230 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp17_ = pixbuf;
#line 230 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			contacts_avatar_dialog_set_crop_widget (self, _tmp17_);
#line 1429 "contacts-avatar-dialog.c"
		} else {
			GdkPixbuf* _tmp18_ = NULL;
			GdkPixbuf* _tmp19_ = NULL;
			GdkPixbuf* _tmp20_ = NULL;
#line 232 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp18_ = pixbuf;
#line 232 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp19_ = contacts_avatar_dialog_scale_pixbuf_for_avatar_use (self, _tmp18_);
#line 232 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_tmp20_ = _tmp19_;
#line 232 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			contacts_avatar_dialog_selected_pixbuf (self, _tmp20_);
#line 232 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			_g_object_unref0 (_tmp20_);
#line 1444 "contacts-avatar-dialog.c"
		}
#line 234 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		contacts_avatar_dialog_update_grid (self);
#line 224 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (pixbuf);
#line 224 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (in_stream);
#line 224 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (file);
#line 1454 "contacts-avatar-dialog.c"
	}
	goto __finally39;
	__catch39_g_error:
	{
#line 224 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		g_clear_error (&_inner_error_);
#line 224 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_inner_error_ = NULL;
#line 1463 "contacts-avatar-dialog.c"
	}
	__finally39:
#line 224 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 224 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 224 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		g_clear_error (&_inner_error_);
#line 224 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		return;
#line 1474 "contacts-avatar-dialog.c"
	}
#line 238 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp21_ = _data38_->chooser;
#line 238 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp21_);
#line 1480 "contacts-avatar-dialog.c"
}


static void ___lambda57__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 219 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	__lambda57_ (self, response_id);
#line 1487 "contacts-avatar-dialog.c"
}


static void contacts_avatar_dialog_select_avatar_file_cb (ContactsAvatarDialog* self) {
	Block38Data* _data38_;
	const gchar* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkFileChooserDialog* _tmp4_ = NULL;
	GtkFileChooserDialog* _tmp5_ = NULL;
	GtkFileChooserDialog* _tmp6_ = NULL;
	GtkImage* preview = NULL;
	GtkImage* _tmp7_ = NULL;
	GtkImage* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_ = NULL;
	GtkImage* _tmp10_ = NULL;
	GtkFileChooserDialog* _tmp11_ = NULL;
	GtkImage* _tmp12_ = NULL;
	GtkFileChooserDialog* _tmp13_ = NULL;
	gchar* folder = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkFileChooserDialog* _tmp19_ = NULL;
	GtkFileChooserDialog* _tmp20_ = NULL;
#line 199 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_if_fail (self != NULL);
#line 199 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_data38_ = g_slice_new0 (Block38Data);
#line 199 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_data38_->_ref_count_ = 1;
#line 199 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_data38_->self = g_object_ref (self);
#line 200 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = _ ("Browse for more pictures");
#line 200 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
#line 200 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp2_ = _ ("_Cancel");
#line 200 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp3_ = _ ("_Open");
#line 200 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp4_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow), GTK_FILE_CHOOSER_ACTION_OPEN, _tmp2_, GTK_RESPONSE_CANCEL, _tmp3_, GTK_RESPONSE_ACCEPT, NULL);
#line 200 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp4_);
#line 200 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_data38_->chooser = _tmp4_;
#line 205 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp5_ = _data38_->chooser;
#line 205 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_window_set_modal ((GtkWindow*) _tmp5_, TRUE);
#line 206 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp6_ = _data38_->chooser;
#line 206 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp6_, FALSE);
#line 207 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp7_ = (GtkImage*) gtk_image_new ();
#line 207 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp7_);
#line 207 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	preview = _tmp7_;
#line 208 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp8_ = preview;
#line 208 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp8_, 128, -1);
#line 209 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp9_ = _data38_->chooser;
#line 209 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp10_ = preview;
#line 209 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_file_chooser_set_preview_widget ((GtkFileChooser*) _tmp9_, (GtkWidget*) _tmp10_);
#line 210 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp11_ = _data38_->chooser;
#line 210 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_file_chooser_set_use_preview_label ((GtkFileChooser*) _tmp11_, FALSE);
#line 211 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp12_ = preview;
#line 211 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_show ((GtkWidget*) _tmp12_);
#line 213 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp13_ = _data38_->chooser;
#line 213 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_signal_connect_object ((GtkFileChooser*) _tmp13_, "update-preview", (GCallback) _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview, self, 0);
#line 215 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp14_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
#line 215 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp15_ = g_strdup (_tmp14_);
#line 215 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	folder = _tmp15_;
#line 216 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp16_ = folder;
#line 216 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (_tmp16_ != NULL) {
#line 1582 "contacts-avatar-dialog.c"
		GtkFileChooserDialog* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
#line 217 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp17_ = _data38_->chooser;
#line 217 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp18_ = folder;
#line 217 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp17_, _tmp18_);
#line 1591 "contacts-avatar-dialog.c"
	}
#line 219 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp19_ = _data38_->chooser;
#line 219 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_signal_connect_data ((GtkDialog*) _tmp19_, "response", (GCallback) ___lambda57__gtk_dialog_response, block38_data_ref (_data38_), (GClosureNotify) block38_data_unref, 0);
#line 241 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp20_ = _data38_->chooser;
#line 241 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_window_present ((GtkWindow*) _tmp20_);
#line 199 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_free0 (folder);
#line 199 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (preview);
#line 199 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	block38_data_unref (_data38_);
#line 199 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_data38_ = NULL;
#line 1609 "contacts-avatar-dialog.c"
}


static Block39Data* block39_data_ref (Block39Data* _data39_) {
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_atomic_int_inc (&_data39_->_ref_count_);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	return _data39_;
#line 1618 "contacts-avatar-dialog.c"
}


static void block39_data_unref (void * _userdata_) {
	Block39Data* _data39_;
	_data39_ = (Block39Data*) _userdata_;
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (g_atomic_int_dec_and_test (&_data39_->_ref_count_)) {
#line 1627 "contacts-avatar-dialog.c"
		ContactsAvatarDialog* self;
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		self = _data39_->self;
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (_data39_->webcam_button);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (_data39_->contact);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_object_unref0 (self);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		g_slice_free (Block39Data, _data39_);
#line 1639 "contacts-avatar-dialog.c"
	}
}


static void ___lambda58_ (Block39Data* _data39_, GtkWidget* w) {
	ContactsAvatarDialog* self;
	GtkWidget* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	FolksIndividual* _tmp2_ = NULL;
	ContactsContact* _tmp3_ = NULL;
#line 268 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self = _data39_->self;
#line 268 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_if_fail (w != NULL);
#line 269 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = w;
#line 269 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp1_ = _data39_->contact;
#line 269 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp2_ = _tmp1_->individual;
#line 269 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp3_ = _data39_->contact;
#line 269 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	contacts_contact_frame_set_image (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, CONTACTS_TYPE_CONTACT_FRAME) ? ((ContactsContactFrame*) _tmp0_) : NULL, (FolksAvatarDetails*) _tmp2_, _tmp3_);
#line 1664 "contacts-avatar-dialog.c"
}


static void ____lambda58__gtk_callback (GtkWidget* widget, gpointer self) {
#line 268 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	___lambda58_ (self, widget);
#line 1671 "contacts-avatar-dialog.c"
}


static void _contacts_avatar_dialog_select_avatar_file_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 321 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	contacts_avatar_dialog_select_avatar_file_cb ((ContactsAvatarDialog*) self);
#line 1678 "contacts-avatar-dialog.c"
}


static void __lambda59_ (Block39Data* _data39_) {
	ContactsAvatarDialog* self;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 329 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self = _data39_->self;
#line 330 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = self->priv->num_cameras;
#line 330 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self->priv->num_cameras = _tmp0_ + 1;
#line 331 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp1_ = self->priv->num_cameras;
#line 331 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data39_->webcam_button, _tmp1_ > 0);
#line 1696 "contacts-avatar-dialog.c"
}


static void ___lambda59__cheese_camera_device_monitor_added (CheeseCameraDeviceMonitor* _sender, CheeseCameraDevice* device, gpointer self) {
#line 329 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	__lambda59_ (self);
#line 1703 "contacts-avatar-dialog.c"
}


static void __lambda60_ (Block39Data* _data39_) {
	ContactsAvatarDialog* self;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 333 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self = _data39_->self;
#line 334 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = self->priv->num_cameras;
#line 334 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self->priv->num_cameras = _tmp0_ - 1;
#line 335 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp1_ = self->priv->num_cameras;
#line 335 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data39_->webcam_button, _tmp1_ > 0);
#line 1721 "contacts-avatar-dialog.c"
}


static void ___lambda60__cheese_camera_device_monitor_removed (CheeseCameraDeviceMonitor* _sender, const gchar* uuid, gpointer self) {
#line 333 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	__lambda60_ (self);
#line 1728 "contacts-avatar-dialog.c"
}


static void __lambda61_ (ContactsAvatarDialog* self, GtkButton* button) {
	GtkStack* _tmp0_ = NULL;
	CheeseWidget* _tmp1_ = NULL;
#line 339 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_if_fail (button != NULL);
#line 340 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = self->priv->views_stack;
#line 340 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "photobooth-page");
#line 341 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp1_ = self->priv->cheese;
#line 341 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_show ((GtkWidget*) _tmp1_);
#line 1745 "contacts-avatar-dialog.c"
}


static void ___lambda61__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 339 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	__lambda61_ ((ContactsAvatarDialog*) self, _sender);
#line 1752 "contacts-avatar-dialog.c"
}


static void __lambda62_ (ContactsAvatarDialog* self, GtkButton* button) {
	GdkPixbuf* pix = NULL;
	UmCropArea* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	UmCropArea* _tmp4_ = NULL;
	GtkStack* _tmp5_ = NULL;
#line 366 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_if_fail (button != NULL);
#line 367 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = self->priv->crop_area;
#line 367 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp1_ = um_crop_area_get_picture (_tmp0_);
#line 367 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	pix = _tmp1_;
#line 368 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp2_ = contacts_avatar_dialog_scale_pixbuf_for_avatar_use (self, pix);
#line 368 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp3_ = _tmp2_;
#line 368 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	contacts_avatar_dialog_selected_pixbuf (self, _tmp3_);
#line 368 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (_tmp3_);
#line 369 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp4_ = self->priv->crop_area;
#line 369 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
#line 370 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp5_ = self->priv->views_stack;
#line 370 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_stack_set_visible_child_name (_tmp5_, "thumbnail-factory");
#line 366 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (pix);
#line 1790 "contacts-avatar-dialog.c"
}


static void ___lambda62__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 366 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	__lambda62_ ((ContactsAvatarDialog*) self, _sender);
#line 1797 "contacts-avatar-dialog.c"
}


static void __lambda63_ (ContactsAvatarDialog* self, GtkButton* button) {
	UmCropArea* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
#line 375 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_if_fail (button != NULL);
#line 376 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = self->priv->crop_area;
#line 376 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 377 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp1_ = self->priv->views_stack;
#line 377 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_stack_set_visible_child_name (_tmp1_, "thumbnail-factory");
#line 1814 "contacts-avatar-dialog.c"
}


static void ___lambda63__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 375 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	__lambda63_ ((ContactsAvatarDialog*) self, _sender);
#line 1821 "contacts-avatar-dialog.c"
}


static void __lambda65_ (ContactsAvatarDialog* self, GdkPixbuf* pix) {
	GdkPixbuf* _tmp0_ = NULL;
	CheeseWidget* _tmp1_ = NULL;
#line 413 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_if_fail (pix != NULL);
#line 414 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = pix;
#line 414 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	contacts_avatar_dialog_set_crop_widget (self, _tmp0_);
#line 415 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp1_ = self->priv->cheese;
#line 415 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 1838 "contacts-avatar-dialog.c"
}


static void ___lambda65__cheese_camera_photo_taken (CheeseCamera* _sender, GdkPixbuf* pixbuf, gpointer self) {
#line 413 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	__lambda65_ ((ContactsAvatarDialog*) self, pixbuf);
#line 1845 "contacts-avatar-dialog.c"
}


static void __lambda64_ (ContactsAvatarDialog* self, GtkButton* button) {
	CheeseCamera* camera = NULL;
	CheeseWidget* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	CheeseCamera* _tmp2_ = NULL;
	CheeseFlash* _tmp3_ = NULL;
	CheeseCamera* _tmp4_ = NULL;
	CheeseCamera* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 408 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_if_fail (button != NULL);
#line 409 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = self->priv->cheese;
#line 409 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp1_ = cheese_widget_get_camera (_tmp0_);
#line 409 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, CHEESE_TYPE_CAMERA) ? ((CheeseCamera*) _tmp1_) : NULL);
#line 409 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	camera = _tmp2_;
#line 411 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp3_ = self->priv->flash;
#line 411 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	cheese_flash_fire (_tmp3_);
#line 413 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp4_ = camera;
#line 413 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_signal_connect_object (_tmp4_, "photo-taken", (GCallback) ___lambda65__cheese_camera_photo_taken, self, 0);
#line 418 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp5_ = camera;
#line 418 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp6_ = cheese_camera_take_photo_pixbuf (_tmp5_);
#line 418 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (!_tmp6_) {
#line 419 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		g_warning ("contacts-avatar-dialog.vala:419: Unable to take photo");
#line 1884 "contacts-avatar-dialog.c"
	}
#line 408 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (camera);
#line 1888 "contacts-avatar-dialog.c"
}


static void ___lambda64__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 408 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	__lambda64_ ((ContactsAvatarDialog*) self, _sender);
#line 1895 "contacts-avatar-dialog.c"
}


static void __lambda66_ (ContactsAvatarDialog* self, GtkButton* button) {
	GtkStack* _tmp0_ = NULL;
	CheeseWidget* _tmp1_ = NULL;
#line 425 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_return_if_fail (button != NULL);
#line 426 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = self->priv->views_stack;
#line 426 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "thumbnail-factory");
#line 427 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp1_ = self->priv->cheese;
#line 427 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 1912 "contacts-avatar-dialog.c"
}


static void ___lambda66__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 425 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	__lambda66_ ((ContactsAvatarDialog*) self, _sender);
#line 1919 "contacts-avatar-dialog.c"
}


static void __lambda67_ (ContactsAvatarDialog* self, gint response_id) {
	gint _tmp0_ = 0;
	GError * _inner_error_ = NULL;
#line 452 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = response_id;
#line 452 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 1930 "contacts-avatar-dialog.c"
		GdkPixbuf* _tmp1_ = NULL;
#line 453 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp1_ = self->priv->new_pixbuf;
#line 453 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		if (_tmp1_ != NULL) {
#line 1936 "contacts-avatar-dialog.c"
			{
				guint8* buffer = NULL;
				gint buffer_length1 = 0;
				gint _buffer_size_ = 0;
				gboolean _tmp2_ = FALSE;
				GdkPixbuf* _tmp3_ = NULL;
				guint8* _tmp4_ = NULL;
				gsize _tmp5_;
				gboolean _tmp6_ = FALSE;
#line 456 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_tmp3_ = self->priv->new_pixbuf;
#line 456 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_tmp6_ = gdk_pixbuf_save_to_buffer (_tmp3_, (gchar**) (&_tmp4_), &_tmp5_, "png", &_inner_error_, NULL, NULL);
#line 456 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				buffer = (g_free (buffer), NULL);
#line 456 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				buffer = _tmp4_;
#line 456 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				buffer_length1 = _tmp5_;
#line 456 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_buffer_size_ = buffer_length1;
#line 456 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_tmp2_ = _tmp6_;
#line 456 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 456 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					buffer = (g_free (buffer), NULL);
#line 1964 "contacts-avatar-dialog.c"
					goto __catch40_g_error;
				}
#line 456 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				if (_tmp2_) {
#line 1969 "contacts-avatar-dialog.c"
					GBytesIcon* icon = NULL;
					guint8* _tmp7_ = NULL;
					gint _tmp7__length1 = 0;
					GBytes* _tmp8_ = NULL;
					GBytes* _tmp9_ = NULL;
					GBytesIcon* _tmp10_ = NULL;
					GBytesIcon* _tmp11_ = NULL;
					GBytesIcon* _tmp12_ = NULL;
#line 457 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp7_ = buffer;
#line 457 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp7__length1 = buffer_length1;
#line 457 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp8_ = g_bytes_new (_tmp7_, _tmp7__length1);
#line 457 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp9_ = _tmp8_;
#line 457 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp10_ = (GBytesIcon*) g_bytes_icon_new (_tmp9_);
#line 457 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp11_ = _tmp10_;
#line 457 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_g_bytes_unref0 (_tmp9_);
#line 457 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					icon = _tmp11_;
#line 458 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_tmp12_ = icon;
#line 458 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					g_signal_emit_by_name (self, "set-avatar", (GIcon*) _tmp12_);
#line 456 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
					_g_object_unref0 (icon);
#line 2000 "contacts-avatar-dialog.c"
				} else {
				}
#line 454 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				buffer = (g_free (buffer), NULL);
#line 2005 "contacts-avatar-dialog.c"
			}
			goto __finally40;
			__catch40_g_error:
			{
#line 454 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				g_clear_error (&_inner_error_);
#line 454 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				_inner_error_ = NULL;
#line 2014 "contacts-avatar-dialog.c"
			}
			__finally40:
#line 454 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 454 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 454 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				g_clear_error (&_inner_error_);
#line 454 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
				return;
#line 2025 "contacts-avatar-dialog.c"
			}
		}
	}
#line 472 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->cheese);
#line 472 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self->priv->cheese = NULL;
#line 475 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_destroy ((GtkWidget*) self);
#line 2035 "contacts-avatar-dialog.c"
}


static void ___lambda67__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 451 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	__lambda67_ ((ContactsAvatarDialog*) self, response_id);
#line 2042 "contacts-avatar-dialog.c"
}


ContactsAvatarDialog* contacts_avatar_dialog_construct (GType object_type, ContactsContact* contact) {
	ContactsAvatarDialog * self = NULL;
	Block39Data* _data39_;
	ContactsContact* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	GnomeDesktopThumbnailFactory* _tmp2_ = NULL;
	ContactsContact* _tmp3_ = NULL;
	ContactsContact* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	ContactsApp* _tmp6_ = NULL;
	ContactsWindow* _tmp7_ = NULL;
	GtkWidget* btn = NULL;
	const gchar* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkWidget* _tmp11_ = NULL;
	GtkStyleContext* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp14_ = NULL;
	GtkGrid* _tmp15_ = NULL;
	GtkGrid* _tmp16_ = NULL;
	GtkContainer* container = NULL;
	GtkBox* _tmp17_ = NULL;
	GtkContainer* _tmp18_ = NULL;
	GtkContainer* _tmp19_ = NULL;
	GtkGrid* _tmp20_ = NULL;
	ContactsContactFrame* _tmp21_ = NULL;
	ContactsContact* _tmp22_ = NULL;
	ContactsContactFrame* _tmp26_ = NULL;
	GtkGrid* _tmp27_ = NULL;
	ContactsContactFrame* _tmp28_ = NULL;
	GtkLabel* label = NULL;
	GtkLabel* _tmp29_ = NULL;
	ContactsContact* _tmp30_ = NULL;
	GtkLabel* _tmp41_ = NULL;
	GtkLabel* _tmp42_ = NULL;
	GtkLabel* _tmp43_ = NULL;
	GtkLabel* _tmp44_ = NULL;
	GtkLabel* _tmp45_ = NULL;
	GtkLabel* _tmp46_ = NULL;
	GtkGrid* _tmp47_ = NULL;
	GtkLabel* _tmp48_ = NULL;
	GtkGrid* _tmp49_ = NULL;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp50_ = NULL;
	GtkStyleContext* _tmp51_ = NULL;
	GtkGrid* _tmp52_ = NULL;
	GtkStack* _tmp53_ = NULL;
	GtkStack* _tmp54_ = NULL;
	GtkGrid* frame_grid = NULL;
	GtkGrid* _tmp55_ = NULL;
	GtkGrid* _tmp56_ = NULL;
	GtkScrolledWindow* scrolled = NULL;
	GtkScrolledWindow* _tmp57_ = NULL;
	GtkGrid* _tmp58_ = NULL;
	GtkGrid* _tmp59_ = NULL;
	GtkGrid* _tmp60_ = NULL;
	GtkActionBar* actionbar = NULL;
	GtkActionBar* _tmp61_ = NULL;
	GtkGrid* _tmp62_ = NULL;
	GtkActionBar* _tmp63_ = NULL;
	GtkButton* the_add_button = NULL;
	GtkButton* _tmp64_ = NULL;
	GtkButton* _tmp65_ = NULL;
	CheeseCameraDeviceMonitor* _tmp66_ = NULL;
	CheeseCameraDeviceMonitor* _tmp67_ = NULL;
	CheeseCameraDeviceMonitor* _tmp68_ = NULL;
	CheeseCameraDeviceMonitor* _tmp69_ = NULL;
	GtkBox* bbox = NULL;
	GtkBox* _tmp70_ = NULL;
	GtkStyleContext* _tmp71_ = NULL;
	GtkActionBar* _tmp72_ = NULL;
	GtkGrid* _tmp73_ = NULL;
	GtkStack* _tmp74_ = NULL;
	GtkGrid* _tmp75_ = NULL;
	GtkGrid* _tmp76_ = NULL;
	GtkGrid* _tmp77_ = NULL;
	GtkActionBar* _tmp78_ = NULL;
	GtkGrid* _tmp79_ = NULL;
	GtkActionBar* _tmp80_ = NULL;
	GtkButton* accept_button = NULL;
	GtkButton* _tmp81_ = NULL;
	GtkButton* _tmp82_ = NULL;
	GtkButton* cancel_button = NULL;
	GtkButton* _tmp83_ = NULL;
	GtkButton* _tmp84_ = NULL;
	GtkBox* bbox1 = NULL;
	GtkBox* _tmp85_ = NULL;
	GtkBox* _tmp86_ = NULL;
	GtkStyleContext* _tmp87_ = NULL;
	GtkBox* _tmp88_ = NULL;
	GtkButton* _tmp89_ = NULL;
	GtkBox* _tmp90_ = NULL;
	GtkButton* _tmp91_ = NULL;
	GtkActionBar* _tmp92_ = NULL;
	GtkBox* _tmp93_ = NULL;
	GtkGrid* _tmp94_ = NULL;
	GtkStack* _tmp95_ = NULL;
	GtkGrid* _tmp96_ = NULL;
	GtkGrid* _tmp97_ = NULL;
	GtkGrid* _tmp98_ = NULL;
	CheeseWidget* _tmp99_ = NULL;
	CheeseWidget* _tmp100_ = NULL;
	CheeseWidget* _tmp101_ = NULL;
	CheeseWidget* _tmp102_ = NULL;
	GtkGrid* _tmp103_ = NULL;
	CheeseWidget* _tmp104_ = NULL;
	CheeseFlash* _tmp105_ = NULL;
	GtkActionBar* _tmp106_ = NULL;
	GtkGrid* _tmp107_ = NULL;
	GtkActionBar* _tmp108_ = NULL;
	GtkButton* _tmp109_ = NULL;
	GtkButton* _tmp110_ = NULL;
	GtkButton* _tmp111_ = NULL;
	GtkButton* _tmp112_ = NULL;
	GtkBox* _tmp113_ = NULL;
	GtkBox* _tmp114_ = NULL;
	GtkStyleContext* _tmp115_ = NULL;
	GtkBox* _tmp116_ = NULL;
	GtkButton* _tmp117_ = NULL;
	GtkBox* _tmp118_ = NULL;
	GtkButton* _tmp119_ = NULL;
	GtkActionBar* _tmp120_ = NULL;
	GtkBox* _tmp121_ = NULL;
	GtkGrid* _tmp122_ = NULL;
	GtkStack* _tmp123_ = NULL;
	GtkGrid* _tmp124_ = NULL;
	GtkStack* _tmp125_ = NULL;
	GtkGrid* _tmp126_ = NULL;
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_data39_ = g_slice_new0 (Block39Data);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_data39_->_ref_count_ = 1;
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp0_ = contact;
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (_data39_->contact);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_data39_->contact = _tmp1_;
#line 245 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self = (ContactsAvatarDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
#line 245 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_data39_->self = g_object_ref (self);
#line 247 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp2_ = gnome_desktop_thumbnail_factory_new (GNOME_DESKTOP_THUMBNAIL_SIZE_NORMAL);
#line 247 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->thumbnail_factory);
#line 247 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self->priv->thumbnail_factory = _tmp2_;
#line 248 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp3_ = _data39_->contact;
#line 248 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 248 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->contact);
#line 248 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self->priv->contact = _tmp4_;
#line 249 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp5_ = _ ("Select Picture");
#line 249 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_window_set_title ((GtkWindow*) self, _tmp5_);
#line 250 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp6_ = contacts_app_app;
#line 250 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp7_ = _tmp6_->window;
#line 250 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_window_set_transient_for ((GtkWindow*) self, (GtkWindow*) _tmp7_);
#line 251 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
#line 253 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp8_ = _ ("Select");
#line 253 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp9_ = gtk_dialog_add_button ((GtkDialog*) self, _tmp8_, (gint) GTK_RESPONSE_OK);
#line 253 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 253 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	btn = _tmp10_;
#line 254 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp11_ = btn;
#line 254 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp12_ = gtk_widget_get_style_context (_tmp11_);
#line 254 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_style_context_add_class (_tmp12_, "suggested-action");
#line 255 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp13_ = _ ("Cancel");
#line 255 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_dialog_add_button ((GtkDialog*) self, _tmp13_, (gint) GTK_RESPONSE_CANCEL);
#line 257 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_dialog_set_default_response ((GtkDialog*) self, (gint) GTK_RESPONSE_OK);
#line 258 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, (gint) GTK_RESPONSE_OK, FALSE);
#line 260 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp14_ = (GtkGrid*) gtk_grid_new ();
#line 260 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp14_);
#line 260 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	grid = _tmp14_;
#line 261 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp15_ = grid;
#line 261 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp15_, (guint) 8);
#line 262 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp16_ = grid;
#line 262 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_grid_set_column_spacing (_tmp16_, (guint) 16);
#line 263 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp17_ = (GtkBox*) gtk_dialog_get_content_area ((GtkDialog*) self);
#line 263 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, gtk_container_get_type ()) ? ((GtkContainer*) _tmp17_) : NULL);
#line 263 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	container = _tmp18_;
#line 264 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp19_ = container;
#line 264 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp20_ = grid;
#line 264 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_container_add (_tmp19_, (GtkWidget*) _tmp20_);
#line 266 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp21_ = contacts_contact_frame_new (CONTACTS_AVATAR_DIALOG_main_size, FALSE);
#line 266 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp21_);
#line 266 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->main_frame);
#line 266 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self->priv->main_frame = _tmp21_;
#line 267 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp22_ = _data39_->contact;
#line 267 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (_tmp22_ != NULL) {
#line 2278 "contacts-avatar-dialog.c"
		ContactsContact* _tmp23_ = NULL;
		ContactsContactFrame* _tmp24_ = NULL;
#line 268 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp23_ = _data39_->contact;
#line 268 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp24_ = self->priv->main_frame;
#line 268 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		contacts_contact_keep_widget_uptodate (_tmp23_, (GtkWidget*) _tmp24_, ____lambda58__gtk_callback, block39_data_ref (_data39_), block39_data_unref);
#line 2287 "contacts-avatar-dialog.c"
	} else {
		ContactsContactFrame* _tmp25_ = NULL;
#line 272 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp25_ = self->priv->main_frame;
#line 272 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		contacts_contact_frame_set_image (_tmp25_, NULL, NULL);
#line 2294 "contacts-avatar-dialog.c"
	}
#line 274 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp26_ = self->priv->main_frame;
#line 274 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp26_, FALSE);
#line 275 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp27_ = grid;
#line 275 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp28_ = self->priv->main_frame;
#line 275 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_grid_attach (_tmp27_, (GtkWidget*) _tmp28_, 0, 0, 1, 1);
#line 277 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp29_ = (GtkLabel*) gtk_label_new ("");
#line 277 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp29_);
#line 277 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	label = _tmp29_;
#line 278 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp30_ = _data39_->contact;
#line 278 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	if (_tmp30_ != NULL) {
#line 2316 "contacts-avatar-dialog.c"
		GtkLabel* _tmp31_ = NULL;
		ContactsContact* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
#line 279 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp31_ = label;
#line 279 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp32_ = _data39_->contact;
#line 279 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp33_ = contacts_contact_get_display_name (_tmp32_);
#line 279 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp34_ = _tmp33_;
#line 279 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp35_ = g_markup_printf_escaped ("<span font='16'>%s</span>", _tmp34_);
#line 279 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp36_ = _tmp35_;
#line 279 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		gtk_label_set_markup (_tmp31_, _tmp36_);
#line 279 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_free0 (_tmp36_);
#line 2339 "contacts-avatar-dialog.c"
	} else {
		GtkLabel* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
#line 281 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp37_ = label;
#line 281 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp38_ = _ ("New Contact");
#line 281 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp39_ = g_markup_printf_escaped ("<span font='16'>%s</span>", _tmp38_);
#line 281 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_tmp40_ = _tmp39_;
#line 281 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		gtk_label_set_markup (_tmp37_, _tmp40_);
#line 281 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
		_g_free0 (_tmp40_);
#line 2357 "contacts-avatar-dialog.c"
	}
#line 283 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp41_ = label;
#line 283 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp41_, GTK_ALIGN_START);
#line 284 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp42_ = label;
#line 284 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp42_, GTK_ALIGN_START);
#line 285 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp43_ = label;
#line 285 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp43_, TRUE);
#line 286 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp44_ = label;
#line 286 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp44_, 4);
#line 287 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp45_ = label;
#line 287 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_label_set_xalign (_tmp45_, 0.0f);
#line 288 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp46_ = label;
#line 288 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_label_set_ellipsize (_tmp46_, PANGO_ELLIPSIZE_END);
#line 289 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp47_ = grid;
#line 289 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp48_ = label;
#line 289 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_grid_attach (_tmp47_, (GtkWidget*) _tmp48_, 1, 0, 1, 1);
#line 291 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp49_ = grid;
#line 291 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_grid_set_row_spacing (_tmp49_, (guint) 11);
#line 293 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp50_ = (GtkFrame*) gtk_frame_new (NULL);
#line 293 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp50_);
#line 293 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	frame = _tmp50_;
#line 294 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp51_ = gtk_widget_get_style_context ((GtkWidget*) frame);
#line 294 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_style_context_add_class (_tmp51_, "contacts-avatar-frame");
#line 295 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp52_ = grid;
#line 295 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_grid_attach (_tmp52_, (GtkWidget*) frame, 0, 1, 2, 1);
#line 297 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp53_ = (GtkStack*) gtk_stack_new ();
#line 297 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp53_);
#line 297 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->views_stack);
#line 297 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self->priv->views_stack = _tmp53_;
#line 299 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp54_ = self->priv->views_stack;
#line 299 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) _tmp54_);
#line 301 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp55_ = (GtkGrid*) gtk_grid_new ();
#line 301 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp55_);
#line 301 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	frame_grid = _tmp55_;
#line 302 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp56_ = frame_grid;
#line 302 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp56_, GTK_ORIENTATION_VERTICAL);
#line 305 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp57_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 305 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp57_);
#line 305 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	scrolled = _tmp57_;
#line 306 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_scrolled_window_set_policy (scrolled, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
#line 307 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_set_vexpand ((GtkWidget*) scrolled, TRUE);
#line 308 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_set_hexpand ((GtkWidget*) scrolled, TRUE);
#line 309 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_set_size_request ((GtkWidget*) scrolled, -1, 300);
#line 311 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp58_ = frame_grid;
#line 311 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_container_add ((GtkContainer*) _tmp58_, (GtkWidget*) scrolled);
#line 313 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp59_ = (GtkGrid*) gtk_grid_new ();
#line 313 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp59_);
#line 313 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->view_grid);
#line 313 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self->priv->view_grid = _tmp59_;
#line 314 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp60_ = self->priv->view_grid;
#line 314 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_container_add ((GtkContainer*) scrolled, (GtkWidget*) _tmp60_);
#line 316 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp61_ = (GtkActionBar*) gtk_action_bar_new ();
#line 316 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp61_);
#line 316 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	actionbar = _tmp61_;
#line 317 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp62_ = frame_grid;
#line 317 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp63_ = actionbar;
#line 317 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_container_add ((GtkContainer*) _tmp62_, (GtkWidget*) _tmp63_);
#line 319 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp64_ = (GtkButton*) gtk_button_new_from_icon_name ("list-add-symbolic", GTK_ICON_SIZE_MENU);
#line 319 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp64_);
#line 319 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	the_add_button = _tmp64_;
#line 321 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_signal_connect_object (the_add_button, "clicked", (GCallback) _contacts_avatar_dialog_select_avatar_file_cb_gtk_button_clicked, self, 0);
#line 324 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp65_ = (GtkButton*) gtk_button_new_from_icon_name ("camera-photo-symbolic", GTK_ICON_SIZE_MENU);
#line 324 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp65_);
#line 324 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_data39_->webcam_button = _tmp65_;
#line 326 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data39_->webcam_button, FALSE);
#line 328 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp66_ = (CheeseCameraDeviceMonitor*) cheese_camera_device_monitor_new ();
#line 328 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->camera_monitor);
#line 328 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self->priv->camera_monitor = _tmp66_;
#line 329 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp67_ = self->priv->camera_monitor;
#line 329 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_signal_connect_data (_tmp67_, "added", (GCallback) ___lambda59__cheese_camera_device_monitor_added, block39_data_ref (_data39_), (GClosureNotify) block39_data_unref, 0);
#line 333 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp68_ = self->priv->camera_monitor;
#line 333 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_signal_connect_data (_tmp68_, "removed", (GCallback) ___lambda60__cheese_camera_device_monitor_removed, block39_data_ref (_data39_), (GClosureNotify) block39_data_unref, 0);
#line 337 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp69_ = self->priv->camera_monitor;
#line 337 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	cheese_camera_device_monitor_coldplug (_tmp69_);
#line 339 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_signal_connect_object (_data39_->webcam_button, "clicked", (GCallback) ___lambda61__gtk_button_clicked, self, 0);
#line 344 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp70_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 344 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp70_);
#line 344 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	bbox = _tmp70_;
#line 345 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp71_ = gtk_widget_get_style_context ((GtkWidget*) bbox);
#line 345 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_style_context_add_class (_tmp71_, "linked");
#line 346 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_container_add ((GtkContainer*) bbox, (GtkWidget*) the_add_button);
#line 347 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_container_add ((GtkContainer*) bbox, (GtkWidget*) _data39_->webcam_button);
#line 348 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp72_ = actionbar;
#line 348 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_action_bar_pack_start (_tmp72_, (GtkWidget*) bbox);
#line 354 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp73_ = frame_grid;
#line 354 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp73_);
#line 355 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp74_ = self->priv->views_stack;
#line 355 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp75_ = frame_grid;
#line 355 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_stack_add_named (_tmp74_, (GtkWidget*) _tmp75_, "thumbnail-factory");
#line 358 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp76_ = (GtkGrid*) gtk_grid_new ();
#line 358 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp76_);
#line 358 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (frame_grid);
#line 358 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	frame_grid = _tmp76_;
#line 359 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp77_ = frame_grid;
#line 359 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp77_, GTK_ORIENTATION_VERTICAL);
#line 361 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp78_ = (GtkActionBar*) gtk_action_bar_new ();
#line 361 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp78_);
#line 361 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (actionbar);
#line 361 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	actionbar = _tmp78_;
#line 362 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp79_ = frame_grid;
#line 362 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp80_ = actionbar;
#line 362 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_grid_attach (_tmp79_, (GtkWidget*) _tmp80_, 0, 1, 1, 1);
#line 364 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp81_ = (GtkButton*) gtk_button_new_from_icon_name ("object-select-symbolic", GTK_ICON_SIZE_MENU);
#line 364 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp81_);
#line 364 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	accept_button = _tmp81_;
#line 366 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp82_ = accept_button;
#line 366 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_signal_connect_object (_tmp82_, "clicked", (GCallback) ___lambda62__gtk_button_clicked, self, 0);
#line 373 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp83_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo-symbolic", GTK_ICON_SIZE_MENU);
#line 373 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp83_);
#line 373 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	cancel_button = _tmp83_;
#line 375 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp84_ = cancel_button;
#line 375 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_signal_connect_object (_tmp84_, "clicked", (GCallback) ___lambda63__gtk_button_clicked, self, 0);
#line 380 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp85_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 380 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp85_);
#line 380 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	bbox1 = _tmp85_;
#line 381 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp86_ = bbox1;
#line 381 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp87_ = gtk_widget_get_style_context ((GtkWidget*) _tmp86_);
#line 381 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_style_context_add_class (_tmp87_, "linked");
#line 382 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp88_ = bbox1;
#line 382 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp89_ = accept_button;
#line 382 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_container_add ((GtkContainer*) _tmp88_, (GtkWidget*) _tmp89_);
#line 383 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp90_ = bbox1;
#line 383 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp91_ = cancel_button;
#line 383 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_container_add ((GtkContainer*) _tmp90_, (GtkWidget*) _tmp91_);
#line 384 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp92_ = actionbar;
#line 384 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp93_ = bbox1;
#line 384 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_action_bar_pack_start (_tmp92_, (GtkWidget*) _tmp93_);
#line 386 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp94_ = frame_grid;
#line 386 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp94_);
#line 387 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp95_ = self->priv->views_stack;
#line 387 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp96_ = frame_grid;
#line 387 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_stack_add_named (_tmp95_, (GtkWidget*) _tmp96_, "crop-page");
#line 391 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp97_ = (GtkGrid*) gtk_grid_new ();
#line 391 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp97_);
#line 391 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (frame_grid);
#line 391 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	frame_grid = _tmp97_;
#line 392 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp98_ = frame_grid;
#line 392 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp98_, GTK_ORIENTATION_VERTICAL);
#line 394 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp99_ = (CheeseWidget*) cheese_widget_new ();
#line 394 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp99_);
#line 394 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->cheese);
#line 394 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self->priv->cheese = _tmp99_;
#line 395 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp100_ = self->priv->cheese;
#line 395 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_set_vexpand ((GtkWidget*) _tmp100_, TRUE);
#line 396 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp101_ = self->priv->cheese;
#line 396 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp101_, TRUE);
#line 397 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp102_ = self->priv->cheese;
#line 397 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp102_, TRUE);
#line 398 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp103_ = frame_grid;
#line 398 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp104_ = self->priv->cheese;
#line 398 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_container_add ((GtkContainer*) _tmp103_, (GtkWidget*) _tmp104_);
#line 400 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp105_ = (CheeseFlash*) cheese_flash_new ((GtkWidget*) self);
#line 400 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp105_);
#line 400 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->flash);
#line 400 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self->priv->flash = _tmp105_;
#line 402 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp106_ = (GtkActionBar*) gtk_action_bar_new ();
#line 402 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp106_);
#line 402 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (actionbar);
#line 402 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	actionbar = _tmp106_;
#line 403 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp107_ = frame_grid;
#line 403 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp108_ = actionbar;
#line 403 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_grid_attach (_tmp107_, (GtkWidget*) _tmp108_, 0, 1, 1, 1);
#line 405 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp109_ = (GtkButton*) gtk_button_new_from_icon_name ("object-select-symbolic", GTK_ICON_SIZE_MENU);
#line 405 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp109_);
#line 405 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (accept_button);
#line 405 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	accept_button = _tmp109_;
#line 408 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp110_ = accept_button;
#line 408 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_signal_connect_object (_tmp110_, "clicked", (GCallback) ___lambda64__gtk_button_clicked, self, 0);
#line 423 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp111_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo-symbolic", GTK_ICON_SIZE_MENU);
#line 423 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp111_);
#line 423 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (cancel_button);
#line 423 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	cancel_button = _tmp111_;
#line 425 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp112_ = cancel_button;
#line 425 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_signal_connect_object (_tmp112_, "clicked", (GCallback) ___lambda66__gtk_button_clicked, self, 0);
#line 430 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp113_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 430 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_object_ref_sink (_tmp113_);
#line 430 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (bbox1);
#line 430 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	bbox1 = _tmp113_;
#line 431 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp114_ = bbox1;
#line 431 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp115_ = gtk_widget_get_style_context ((GtkWidget*) _tmp114_);
#line 431 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_style_context_add_class (_tmp115_, "linked");
#line 432 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp116_ = bbox1;
#line 432 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp117_ = accept_button;
#line 432 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_container_add ((GtkContainer*) _tmp116_, (GtkWidget*) _tmp117_);
#line 433 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp118_ = bbox1;
#line 433 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp119_ = cancel_button;
#line 433 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_container_add ((GtkContainer*) _tmp118_, (GtkWidget*) _tmp119_);
#line 434 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp120_ = actionbar;
#line 434 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp121_ = bbox1;
#line 434 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_action_bar_pack_start (_tmp120_, (GtkWidget*) _tmp121_);
#line 436 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp122_ = frame_grid;
#line 436 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp122_);
#line 437 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp123_ = self->priv->views_stack;
#line 437 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp124_ = frame_grid;
#line 437 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_stack_add_named (_tmp123_, (GtkWidget*) _tmp124_, "photobooth-page");
#line 440 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp125_ = self->priv->views_stack;
#line 440 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_stack_set_visible_child_name (_tmp125_, "thumbnail-factory");
#line 451 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) ___lambda67__gtk_dialog_response, self, 0);
#line 478 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	contacts_avatar_dialog_update_grid (self);
#line 480 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_tmp126_ = grid;
#line 480 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp126_);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (bbox1);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (cancel_button);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (accept_button);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (bbox);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (the_add_button);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (actionbar);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (scrolled);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (frame_grid);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (frame);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (label);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (container);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (grid);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (btn);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	block39_data_unref (_data39_);
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_data39_ = NULL;
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	return self;
#line 2791 "contacts-avatar-dialog.c"
}


ContactsAvatarDialog* contacts_avatar_dialog_new (ContactsContact* contact) {
#line 244 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	return contacts_avatar_dialog_construct (CONTACTS_TYPE_AVATAR_DIALOG, contact);
#line 2798 "contacts-avatar-dialog.c"
}


static void contacts_avatar_dialog_class_init (ContactsAvatarDialogClass * klass) {
#line 22 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	contacts_avatar_dialog_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_type_class_add_private (klass, sizeof (ContactsAvatarDialogPrivate));
#line 22 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	G_OBJECT_CLASS (klass)->finalize = contacts_avatar_dialog_finalize;
#line 22 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	g_signal_new ("set_avatar", CONTACTS_TYPE_AVATAR_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_ICON);
#line 2811 "contacts-avatar-dialog.c"
}


static void contacts_avatar_dialog_instance_init (ContactsAvatarDialog * self) {
#line 22 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self->priv = CONTACTS_AVATAR_DIALOG_GET_PRIVATE (self);
#line 2818 "contacts-avatar-dialog.c"
}


static void contacts_avatar_dialog_finalize (GObject* obj) {
	ContactsAvatarDialog * self;
#line 22 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialog);
#line 23 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->thumbnail_factory);
#line 27 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->contact);
#line 28 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->views_stack);
#line 29 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->crop_area);
#line 30 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->view_grid);
#line 31 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->main_frame);
#line 34 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->flash);
#line 35 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->camera_monitor);
#line 36 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->cheese);
#line 40 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	_g_object_unref0 (self->priv->new_pixbuf);
#line 22 "/home/erickpc/sources/vala/gnome-contacts/src/contacts-avatar-dialog.vala"
	G_OBJECT_CLASS (contacts_avatar_dialog_parent_class)->finalize (obj);
#line 2848 "contacts-avatar-dialog.c"
}


GType contacts_avatar_dialog_get_type (void) {
	static volatile gsize contacts_avatar_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_avatar_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsAvatarDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_avatar_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsAvatarDialog), 0, (GInstanceInitFunc) contacts_avatar_dialog_instance_init, NULL };
		GType contacts_avatar_dialog_type_id;
		contacts_avatar_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "ContactsAvatarDialog", &g_define_type_info, 0);
		g_once_init_leave (&contacts_avatar_dialog_type_id__volatile, contacts_avatar_dialog_type_id);
	}
	return contacts_avatar_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



