/* math-buttons.c generated by valac 0.26.0.50-d9a75, the Vala compiler
 * generated from math-buttons.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksource.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <atk/atk.h>
#include <cairo.h>


#define TYPE_BUTTON_MODE (button_mode_get_type ())

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
typedef struct _MathButtonsPrivate MathButtonsPrivate;

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;

#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_FINANCIAL_DIALOG (financial_dialog_get_type ())

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;

#define TYPE_NUMBER_MODE (number_mode_get_type ())

#define TYPE_UNIT (unit_get_type ())
#define UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT, Unit))
#define UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT, UnitClass))
#define IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT))
#define IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT))
#define UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT, UnitClass))

typedef struct _Unit Unit;
typedef struct _UnitClass UnitClass;

#define TYPE_MATH_VARIABLE_POPUP (math_variable_popup_get_type ())
#define MATH_VARIABLE_POPUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_VARIABLE_POPUP, MathVariablePopup))
#define MATH_VARIABLE_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_VARIABLE_POPUP, MathVariablePopupClass))
#define IS_MATH_VARIABLE_POPUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_VARIABLE_POPUP))
#define IS_MATH_VARIABLE_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_VARIABLE_POPUP))
#define MATH_VARIABLE_POPUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_VARIABLE_POPUP, MathVariablePopupClass))

typedef struct _MathVariablePopup MathVariablePopup;
typedef struct _MathVariablePopupClass MathVariablePopupClass;

#define TYPE_MATH_FUNCTION_POPUP (math_function_popup_get_type ())
#define MATH_FUNCTION_POPUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_FUNCTION_POPUP, MathFunctionPopup))
#define MATH_FUNCTION_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_FUNCTION_POPUP, MathFunctionPopupClass))
#define IS_MATH_FUNCTION_POPUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_FUNCTION_POPUP))
#define IS_MATH_FUNCTION_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_FUNCTION_POPUP))
#define MATH_FUNCTION_POPUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_FUNCTION_POPUP, MathFunctionPopupClass))

typedef struct _MathFunctionPopup MathFunctionPopup;
typedef struct _MathFunctionPopupClass MathFunctionPopupClass;

typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING
} ButtonMode;

struct _MathButtons {
	GtkBox parent_instance;
	MathButtonsPrivate * priv;
};

struct _MathButtonsClass {
	GtkBoxClass parent_class;
};

struct _MathButtonsPrivate {
	MathEquation* equation;
	ButtonMode _mode;
	gint _programming_base;
	MathConverter* converter;
	GtkBuilder* basic_ui;
	GtkBuilder* advanced_ui;
	GtkBuilder* financial_ui;
	GtkBuilder* programming_ui;
	GtkWidget* bas_panel;
	GtkWidget* adv_panel;
	GtkWidget* fin_panel;
	GtkWidget* prog_panel;
	GtkWidget* active_panel;
	GtkMenu* shift_left_menu;
	GtkMenu* shift_right_menu;
	GList* superscript_toggles;
	GList* subscript_toggles;
	GtkComboBox* base_combo;
	GtkLabel* base_label;
	GtkWidget* bit_panel;
	GList* bit_labels;
	GtkDialog* character_code_dialog;
	GtkEntry* character_code_entry;
};

typedef enum  {
	FINANCIAL_DIALOG_CTRM_DIALOG,
	FINANCIAL_DIALOG_DDB_DIALOG,
	FINANCIAL_DIALOG_FV_DIALOG,
	FINANCIAL_DIALOG_GPM_DIALOG,
	FINANCIAL_DIALOG_PMT_DIALOG,
	FINANCIAL_DIALOG_PV_DIALOG,
	FINANCIAL_DIALOG_RATE_DIALOG,
	FINANCIAL_DIALOG_SLN_DIALOG,
	FINANCIAL_DIALOG_SYD_DIALOG,
	FINANCIAL_DIALOG_TERM_DIALOG
} FinancialDialog;

typedef enum  {
	NUMBER_MODE_NORMAL,
	NUMBER_MODE_SUPERSCRIPT,
	NUMBER_MODE_SUBSCRIPT
} NumberMode;


static gpointer math_buttons_parent_class = NULL;

GType button_mode_get_type (void) G_GNUC_CONST;
GType math_buttons_get_type (void) G_GNUC_CONST;
GType math_equation_get_type (void) G_GNUC_CONST;
GType math_converter_get_type (void) G_GNUC_CONST;
#define MATH_BUTTONS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_BUTTONS, MathButtonsPrivate))
enum  {
	MATH_BUTTONS_DUMMY_PROPERTY,
	MATH_BUTTONS_MODE,
	MATH_BUTTONS_PROGRAMMING_BASE
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
MathButtons* math_buttons_new (MathEquation* equation);
MathButtons* math_buttons_construct (GType object_type, MathEquation* equation);
static void math_buttons_load_buttons (MathButtons* self);
static void _math_buttons_load_buttons_gtk_widget_show (GtkWidget* _sender, gpointer self);
static void __lambda30_ (MathButtons* self, GParamSpec* pspec);
static void math_buttons_update_bit_panel (MathButtons* self);
static void ___lambda30__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda31_ (MathButtons* self, GParamSpec* pspec);
static void math_buttons_number_mode_changed_cb (MathButtons* self);
static void ___lambda31__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda32_ (MathButtons* self, GParamSpec* pspec);
static void ___lambda32__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda33_ (MathButtons* self, GParamSpec* pspec);
static void ___lambda33__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void math_buttons_load_finc_dialogs (MathButtons* self);
GType financial_dialog_get_type (void) G_GNUC_CONST;
static void math_buttons_load_finc_dialog (MathButtons* self, const gchar* name, gchar** entry_names, int entry_names_length1, FinancialDialog function);
static void math_buttons_finc_response_cb (MathButtons* self, GtkWidget* widget, gint response_id);
static void _math_buttons_finc_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void math_buttons_finc_activate_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_finc_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self);
GType number_get_type (void) G_GNUC_CONST;
Number* math_equation_get_number (MathEquation* self);
Number* number_new_unsigned_integer (guint64 x);
Number* number_construct_unsigned_integer (GType object_type, guint64 x);
Number* number_fractional_part (Number* self);
gboolean number_is_negative (Number* self);
gint number_compare (Number* self, Number* y);
gboolean number_is_zero (Number* self);
guint64 number_to_unsigned_integer (Number* self);
gint math_equation_get_number_base (MathEquation* self);
static void math_buttons_base_combobox_changed_cb (MathButtons* self, GtkComboBox* combo);
void math_buttons_set_programming_base (MathButtons* self, gint value);
static void math_buttons_base_changed_cb (MathButtons* self);
ButtonMode math_buttons_get_mode (MathButtons* self);
gint math_buttons_get_programming_base (MathButtons* self);
static GtkWidget* math_buttons_load_mode (MathButtons* self, ButtonMode mode);
static void math_buttons_setup_button (MathButtons* self, GtkBuilder* builder, const gchar* name, const gchar* data, const gchar* tooltip, gboolean connect);
gunichar math_equation_get_digit_text (MathEquation* self, guint digit);
static void ______lambda16_ (MathButtons* self, GtkButton* widget);
void math_equation_insert_digit (MathEquation* self, guint digit);
static void _______lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda17_ (MathButtons* self);
void math_equation_insert_subtract (MathEquation* self);
static void ____lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda18_ (MathButtons* self);
void math_equation_insert_square (MathEquation* self);
static void ____lambda18__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda19_ (MathButtons* self);
static void ____lambda19__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda20_ (MathButtons* self);
void math_equation_solve (MathEquation* self);
static void ____lambda20__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda21_ (MathButtons* self);
void math_equation_clear (MathEquation* self);
static void ____lambda21__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_memory_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_memory_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_function_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_function_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda24_ (MathButtons* self);
void math_equation_factorize (MathEquation* self);
static void ____lambda24__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda25_ (MathButtons* self);
void math_equation_insert_exponent (MathEquation* self);
static void ____lambda25__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_shift_left_cb (MathButtons* self, GtkButton* button);
static void _math_buttons_shift_left_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_shift_right_cb (MathButtons* self, GtkButton* button);
static void _math_buttons_shift_right_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_insert_character_code_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_insert_character_code_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
GType serializer_get_type (void) G_GNUC_CONST;
Serializer* math_equation_get_serializer (MathEquation* self);
gunichar serializer_get_radix (Serializer* self);
static void ___lambda28_ (MathButtons* self);
void math_equation_insert_numeric_point (MathEquation* self);
static void ____lambda28__gtk_button_clicked (GtkButton* _sender, gpointer self);
GType number_mode_get_type (void) G_GNUC_CONST;
NumberMode math_equation_get_number_mode (MathEquation* self);
static void math_buttons_set_superscript_cb (MathButtons* self, GtkButton* widget);
static void _math_buttons_set_superscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_set_subscript_cb (MathButtons* self, GtkButton* widget);
static void _math_buttons_set_subscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_character_code_dialog_response_cb (MathButtons* self, GtkWidget* dialog, gint response_id);
static void _math_buttons_character_code_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean math_buttons_character_code_dialog_delete_cb (MathButtons* self, GtkWidget* dialog, GdkEventAny* event);
static gboolean _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void math_buttons_character_code_dialog_activate_cb (MathButtons* self, GtkWidget* entry);
static void _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static gboolean math_buttons_bit_toggle_cb (MathButtons* self, GtkWidget* event_box, GdkEventButton* event);
static gboolean _math_buttons_bit_toggle_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void ___lambda29_ (MathButtons* self, GParamSpec* pspec);
static void ____lambda29__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void math_buttons_finc_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_finc_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ____lambda15_ (MathButtons* self, GtkButton* widget);
void math_equation_insert (MathEquation* self, const gchar* text);
static void _____lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_converter_changed_cb (MathButtons* self);
GType unit_get_type (void) G_GNUC_CONST;
void math_converter_get_conversion (MathConverter* self, Unit** from_unit, Unit** to_unit);
gchar* unit_get_name (Unit* self);
void math_equation_set_source_currency (MathEquation* self, const gchar* value);
void math_equation_set_target_currency (MathEquation* self, const gchar* value);
void math_equation_set_source_units (MathEquation* self, const gchar* value);
void math_equation_set_target_units (MathEquation* self, const gchar* value);
MathConverter* math_converter_new (MathEquation* equation);
MathConverter* math_converter_construct (GType object_type, MathEquation* equation);
static void _math_buttons_converter_changed_cb_math_converter_changed (MathConverter* _sender, gpointer self);
static void math_buttons_popup_button_menu (MathButtons* self, GtkButton* button, GtkMenu* menu);
static void math_buttons_button_menu_position_func (MathButtons* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in);
static void _math_buttons_button_menu_position_func_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
GType math_variable_popup_get_type (void) G_GNUC_CONST;
MathVariablePopup* math_variable_popup_new (MathEquation* equation);
MathVariablePopup* math_variable_popup_construct (GType object_type, MathEquation* equation);
static void ______lambda26_ (MathButtons* self, GtkMenuItem* widget);
void math_equation_shift (MathEquation* self, gint count);
static void _______lambda26__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ______lambda27_ (MathButtons* self, GtkMenuItem* widget);
static void _______lambda27__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
GType math_function_popup_get_type (void) G_GNUC_CONST;
MathFunctionPopup* math_function_popup_new (MathEquation* equation);
MathFunctionPopup* math_function_popup_construct (GType object_type, MathEquation* equation);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gchar** _vala_array_dup6 (gchar** self, int length);
static gchar** _vala_array_dup7 (gchar** self, int length);
static gchar** _vala_array_dup8 (gchar** self, int length);
static gchar** _vala_array_dup9 (gchar** self, int length);
static gchar** _vala_array_dup10 (gchar** self, int length);
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
Number* mp_set_from_string (const gchar* str, gint default_base);
void do_finc_expression (MathEquation* equation, FinancialDialog function, Number* arg1, Number* arg2, Number* arg3, Number* arg4);
Number* number_add (Number* self, Number* y);
Number* number_shift (Number* self, gint count);
void math_equation_insert_number (MathEquation* self, Number* x);
void math_equation_toggle_bit (MathEquation* self, guint bit);
static void math_buttons_remove_trailing_spaces (MathButtons* self);
void math_equation_set_number_mode (MathEquation* self, NumberMode value);
void math_buttons_set_mode (MathButtons* self, ButtonMode value);
void math_equation_set_number_base (MathEquation* self, gint value);
void math_converter_set_category (MathConverter* self, const gchar* category);
void math_converter_set_conversion (MathConverter* self, const gchar* unit_a, const gchar* unit_b);
gchar* math_equation_get_source_units (MathEquation* self);
gchar* math_equation_get_target_units (MathEquation* self);
gchar* math_equation_get_source_currency (MathEquation* self);
gchar* math_equation_get_target_currency (MathEquation* self);
static void math_buttons_finalize (GObject* obj);
static void _vala_math_buttons_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_math_buttons_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* MATH_BUTTONS_ctrm_entries[3] = {"ctrm_pint", "ctrm_fv", "ctrm_pv"};
static const gchar* MATH_BUTTONS_ddb_entries[3] = {"ddb_cost", "ddb_life", "ddb_period"};
static const gchar* MATH_BUTTONS_fv_entries[3] = {"fv_pmt", "fv_pint", "fv_n"};
static const gchar* MATH_BUTTONS_gpm_entries[2] = {"gpm_cost", "gpm_margin"};
static const gchar* MATH_BUTTONS_pmt_entries[3] = {"pmt_prin", "pmt_pint", "pmt_n"};
static const gchar* MATH_BUTTONS_pv_entries[3] = {"pv_pmt", "pv_pint", "pv_n"};
static const gchar* MATH_BUTTONS_rate_entries[3] = {"rate_fv", "rate_pv", "rate_n"};
static const gchar* MATH_BUTTONS_sln_entries[3] = {"sln_cost", "sln_salvage", "sln_life"};
static const gchar* MATH_BUTTONS_syd_entries[3] = {"syd_cost", "syd_salvage", "syd_life"};
static const gchar* MATH_BUTTONS_term_entries[3] = {"term_pmt", "term_fv", "term_pint"};

GType button_mode_get_type (void) {
	static volatile gsize button_mode_type_id__volatile = 0;
	if (g_once_init_enter (&button_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{BUTTON_MODE_BASIC, "BUTTON_MODE_BASIC", "basic"}, {BUTTON_MODE_ADVANCED, "BUTTON_MODE_ADVANCED", "advanced"}, {BUTTON_MODE_FINANCIAL, "BUTTON_MODE_FINANCIAL", "financial"}, {BUTTON_MODE_PROGRAMMING, "BUTTON_MODE_PROGRAMMING", "programming"}, {0, NULL, NULL}};
		GType button_mode_type_id;
		button_mode_type_id = g_enum_register_static ("ButtonMode", values);
		g_once_init_leave (&button_mode_type_id__volatile, button_mode_type_id);
	}
	return button_mode_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 379 "math-buttons.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_list_free (self);
#line 388 "math-buttons.c"
}


static void _math_buttons_load_buttons_gtk_widget_show (GtkWidget* _sender, gpointer self) {
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_load_buttons ((MathButtons*) self);
#line 395 "math-buttons.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return self ? g_object_ref (self) : NULL;
#line 402 "math-buttons.c"
}


static void __lambda30_ (MathButtons* self, GParamSpec* pspec) {
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (pspec != NULL);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_update_bit_panel (self);
#line 411 "math-buttons.c"
}


static void ___lambda30__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	__lambda30_ ((MathButtons*) self, pspec);
#line 418 "math-buttons.c"
}


static void __lambda31_ (MathButtons* self, GParamSpec* pspec) {
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (pspec != NULL);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_number_mode_changed_cb (self);
#line 427 "math-buttons.c"
}


static void ___lambda31__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	__lambda31_ ((MathButtons*) self, pspec);
#line 434 "math-buttons.c"
}


static void __lambda32_ (MathButtons* self, GParamSpec* pspec) {
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (pspec != NULL);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_update_bit_panel (self);
#line 443 "math-buttons.c"
}


static void ___lambda32__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	__lambda32_ ((MathButtons*) self, pspec);
#line 450 "math-buttons.c"
}


static void __lambda33_ (MathButtons* self, GParamSpec* pspec) {
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (pspec != NULL);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_update_bit_panel (self);
#line 459 "math-buttons.c"
}


static void ___lambda33__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	__lambda33_ ((MathButtons*) self, pspec);
#line 466 "math-buttons.c"
}


MathButtons* math_buttons_construct (GType object_type, MathEquation* equation) {
	MathButtons * self = NULL;
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	MathEquation* _tmp2_ = NULL;
	MathEquation* _tmp3_ = NULL;
	MathEquation* _tmp4_ = NULL;
	MathEquation* _tmp5_ = NULL;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_val_if_fail (equation != NULL, NULL);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	self = (MathButtons*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, NULL);
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_box_set_spacing ((GtkBox*) self, 6);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) _math_buttons_load_buttons_gtk_widget_show, self, 0);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = equation;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->equation);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	self->priv->equation = _tmp1_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = equation;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_signal_connect_object ((GObject*) _tmp2_, "notify::display", (GCallback) ___lambda30__g_object_notify, self, 0);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = equation;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_signal_connect_object ((GObject*) _tmp3_, "notify::number-mode", (GCallback) ___lambda31__g_object_notify, self, 0);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp4_ = equation;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_signal_connect_object ((GObject*) _tmp4_, "notify::angle-units", (GCallback) ___lambda32__g_object_notify, self, 0);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp5_ = equation;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_signal_connect_object ((GObject*) _tmp5_, "notify::number-format", (GCallback) ___lambda33__g_object_notify, self, 0);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_number_mode_changed_cb (self);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_update_bit_panel (self);
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return self;
#line 516 "math-buttons.c"
}


MathButtons* math_buttons_new (MathEquation* equation) {
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return math_buttons_construct (TYPE_MATH_BUTTONS, equation);
#line 523 "math-buttons.c"
}


static void math_buttons_load_finc_dialogs (MathButtons* self) {
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_load_finc_dialog (self, "ctrm_dialog", MATH_BUTTONS_ctrm_entries, G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries), FINANCIAL_DIALOG_CTRM_DIALOG);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_load_finc_dialog (self, "ddb_dialog", MATH_BUTTONS_ddb_entries, G_N_ELEMENTS (MATH_BUTTONS_ddb_entries), FINANCIAL_DIALOG_DDB_DIALOG);
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_load_finc_dialog (self, "fv_dialog", MATH_BUTTONS_fv_entries, G_N_ELEMENTS (MATH_BUTTONS_fv_entries), FINANCIAL_DIALOG_FV_DIALOG);
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_load_finc_dialog (self, "gpm_dialog", MATH_BUTTONS_gpm_entries, G_N_ELEMENTS (MATH_BUTTONS_gpm_entries), FINANCIAL_DIALOG_GPM_DIALOG);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_load_finc_dialog (self, "pmt_dialog", MATH_BUTTONS_pmt_entries, G_N_ELEMENTS (MATH_BUTTONS_pmt_entries), FINANCIAL_DIALOG_PMT_DIALOG);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_load_finc_dialog (self, "pv_dialog", MATH_BUTTONS_pv_entries, G_N_ELEMENTS (MATH_BUTTONS_pv_entries), FINANCIAL_DIALOG_PV_DIALOG);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_load_finc_dialog (self, "rate_dialog", MATH_BUTTONS_rate_entries, G_N_ELEMENTS (MATH_BUTTONS_rate_entries), FINANCIAL_DIALOG_RATE_DIALOG);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_load_finc_dialog (self, "sln_dialog", MATH_BUTTONS_sln_entries, G_N_ELEMENTS (MATH_BUTTONS_sln_entries), FINANCIAL_DIALOG_SLN_DIALOG);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_load_finc_dialog (self, "syd_dialog", MATH_BUTTONS_syd_entries, G_N_ELEMENTS (MATH_BUTTONS_syd_entries), FINANCIAL_DIALOG_SYD_DIALOG);
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_load_finc_dialog (self, "term_dialog", MATH_BUTTONS_term_entries, G_N_ELEMENTS (MATH_BUTTONS_term_entries), FINANCIAL_DIALOG_TERM_DIALOG);
#line 550 "math-buttons.c"
}


static void _math_buttons_finc_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_finc_response_cb ((MathButtons*) self, _sender, response_id);
#line 557 "math-buttons.c"
}


static void _math_buttons_finc_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_finc_activate_cb ((MathButtons*) self, _sender);
#line 564 "math-buttons.c"
}


static void math_buttons_load_finc_dialog (MathButtons* self, const gchar* name, gchar** entry_names, int entry_names_length1, FinancialDialog function) {
	GtkDialog* dialog = NULL;
	GtkBuilder* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	GtkDialog* _tmp3_ = NULL;
	GtkDialog* _tmp4_ = NULL;
	FinancialDialog _tmp5_ = 0;
	GtkDialog* _tmp6_ = NULL;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (name != NULL);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->financial_ui;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = name;
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = gtk_builder_get_object (_tmp0_, _tmp1_);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp2_) : NULL);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	dialog = _tmp3_;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp4_ = dialog;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp5_ = function;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_object_set_data_full ((GObject*) _tmp4_, "finc-function", (gpointer) ((gintptr) ((gint) _tmp5_)), NULL);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp6_ = dialog;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_signal_connect_object (_tmp6_, "response", (GCallback) _math_buttons_finc_response_cb_gtk_dialog_response, self, 0);
#line 601 "math-buttons.c"
	{
		gint i = 0;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		i = 0;
#line 606 "math-buttons.c"
		{
			gboolean _tmp7_ = FALSE;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp7_ = TRUE;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			while (TRUE) {
#line 613 "math-buttons.c"
				gint _tmp9_ = 0;
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				GtkEntry* entry = NULL;
				GtkBuilder* _tmp11_ = NULL;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gint _tmp13_ = 0;
				const gchar* _tmp14_ = NULL;
				GObject* _tmp15_ = NULL;
				GtkEntry* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				GtkEntry* _tmp25_ = NULL;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				if (!_tmp7_) {
#line 629 "math-buttons.c"
					gint _tmp8_ = 0;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp8_ = i;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					i = _tmp8_ + 1;
#line 635 "math-buttons.c"
				}
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp7_ = FALSE;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp9_ = i;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp10_ = entry_names;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp10__length1 = entry_names_length1;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				if (!(_tmp9_ < _tmp10__length1)) {
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					break;
#line 649 "math-buttons.c"
				}
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp11_ = self->priv->financial_ui;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp12_ = entry_names;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp12__length1 = entry_names_length1;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp13_ = i;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp14_ = _tmp12_[_tmp13_];
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp15_ = gtk_builder_get_object (_tmp11_, _tmp14_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp15_) : NULL);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				entry = _tmp16_;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp17_ = i;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				if (_tmp17_ != (G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries) - 1)) {
#line 671 "math-buttons.c"
					GtkEntry* _tmp18_ = NULL;
					GtkBuilder* _tmp19_ = NULL;
					gchar** _tmp20_ = NULL;
					gint _tmp20__length1 = 0;
					gint _tmp21_ = 0;
					const gchar* _tmp22_ = NULL;
					GObject* _tmp23_ = NULL;
					GtkEntry* _tmp24_ = NULL;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp18_ = entry;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp19_ = self->priv->financial_ui;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp20_ = entry_names;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp20__length1 = entry_names_length1;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp21_ = i;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp22_ = _tmp20_[_tmp21_ + 1];
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp23_ = gtk_builder_get_object (_tmp19_, _tmp22_);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp23_) : NULL);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					g_object_set_data_full ((GObject*) _tmp18_, "next-entry", _tmp24_, g_object_unref);
#line 698 "math-buttons.c"
				}
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp25_ = entry;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				g_signal_connect_object (_tmp25_, "activate", (GCallback) _math_buttons_finc_activate_cb_gtk_entry_activate, self, 0);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_object_unref0 (entry);
#line 706 "math-buttons.c"
			}
		}
	}
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (dialog);
#line 712 "math-buttons.c"
}


static void math_buttons_update_bit_panel (MathButtons* self) {
	GtkWidget* _tmp0_ = NULL;
	Number* x = NULL;
	MathEquation* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	guint64 bits = 0ULL;
	gboolean enabled = FALSE;
	Number* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GtkWidget* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	GtkLabel* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gint i = 0;
	GList* _tmp25_ = NULL;
	gint number_base = 0;
	MathEquation* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gchar* label = NULL;
	gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp44_ = 0;
	gint _tmp53_ = 0;
	GtkLabel* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->bit_panel;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp0_ == NULL) {
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		return;
#line 752 "math-buttons.c"
	}
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = self->priv->equation;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = math_equation_get_number (_tmp1_);
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = _tmp2_;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	x = _tmp3_;
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	bits = (guint64) 0;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp4_ = x;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	enabled = _tmp4_ != NULL;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp5_ = enabled;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp5_) {
#line 772 "math-buttons.c"
		Number* max = NULL;
		Number* _tmp6_ = NULL;
		Number* fraction = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		Number* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp6_ = number_new_unsigned_integer (G_MAXUINT64);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		max = _tmp6_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp7_ = x;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp8_ = number_fractional_part (_tmp7_);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		fraction = _tmp8_;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp11_ = x;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp12_ = number_is_negative (_tmp11_);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp12_) {
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp10_ = TRUE;
#line 800 "math-buttons.c"
		} else {
			Number* _tmp13_ = NULL;
			Number* _tmp14_ = NULL;
			gint _tmp15_ = 0;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp13_ = x;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp14_ = max;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp15_ = number_compare (_tmp13_, _tmp14_);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp10_ = _tmp15_ > 0;
#line 813 "math-buttons.c"
		}
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp10_) {
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp9_ = TRUE;
#line 819 "math-buttons.c"
		} else {
			Number* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp16_ = fraction;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp17_ = number_is_zero (_tmp16_);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp9_ = !_tmp17_;
#line 829 "math-buttons.c"
		}
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp9_) {
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			enabled = FALSE;
#line 835 "math-buttons.c"
		} else {
			Number* _tmp18_ = NULL;
			guint64 _tmp19_ = 0ULL;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp18_ = x;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp19_ = number_to_unsigned_integer (_tmp18_);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			bits = _tmp19_;
#line 845 "math-buttons.c"
		}
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (fraction);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (max);
#line 851 "math-buttons.c"
	}
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp20_ = self->priv->bit_panel;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp21_ = enabled;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_widget_set_sensitive (_tmp20_, _tmp21_);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp22_ = self->priv->base_label;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp23_ = enabled;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp22_, _tmp23_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp24_ = enabled;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (!_tmp24_) {
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (x);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		return;
#line 873 "math-buttons.c"
	}
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	i = 0;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp25_ = self->priv->bit_labels;
#line 879 "math-buttons.c"
	{
		GList* label_collection = NULL;
		GList* label_it = NULL;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		label_collection = _tmp25_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		for (label_it = label_collection; label_it != NULL; label_it = label_it->next) {
#line 887 "math-buttons.c"
			GtkLabel* _tmp26_ = NULL;
			GtkLabel* label = NULL;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp26_ = _g_object_ref0 ((GtkLabel*) label_it->data);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			label = _tmp26_;
#line 894 "math-buttons.c"
			{
				gchar* text = NULL;
				gchar* _tmp27_ = NULL;
				guint64 _tmp28_ = 0ULL;
				gint _tmp29_ = 0;
				GtkLabel* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				gint _tmp33_ = 0;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp27_ = g_strdup (" 0");
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				text = _tmp27_;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp28_ = bits;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp29_ = i;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				if ((_tmp28_ & (1LL << _tmp29_)) != ((guint64) 0)) {
#line 913 "math-buttons.c"
					gchar* _tmp30_ = NULL;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp30_ = g_strdup (" 1");
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_g_free0 (text);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					text = _tmp30_;
#line 921 "math-buttons.c"
				}
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp31_ = label;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp32_ = text;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				gtk_label_set_text (_tmp31_, _tmp32_);
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp33_ = i;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				i = _tmp33_ + 1;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_free0 (text);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_object_unref0 (label);
#line 937 "math-buttons.c"
			}
		}
	}
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp34_ = self->priv->equation;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp35_ = math_equation_get_number_base (_tmp34_);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp36_ = _tmp35_;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	number_base = _tmp36_;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp37_ = g_strdup ("");
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	label = _tmp37_;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp38_ = number_base;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp38_ != 8) {
#line 957 "math-buttons.c"
		const gchar* _tmp39_ = NULL;
		guint64 _tmp40_ = 0ULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp39_ = label;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp40_ = bits;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp41_ = g_strdup_printf ("%llo₈", _tmp40_);
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp42_ = _tmp41_;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp43_ = g_strconcat (_tmp39_, _tmp42_, NULL);
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_free0 (label);
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		label = _tmp43_;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_free0 (_tmp42_);
#line 979 "math-buttons.c"
	}
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp44_ = number_base;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp44_ != 10) {
#line 985 "math-buttons.c"
		const gchar* _tmp45_ = NULL;
		const gchar* _tmp48_ = NULL;
		guint64 _tmp49_ = 0ULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp45_ = label;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (g_strcmp0 (_tmp45_, "") != 0) {
#line 996 "math-buttons.c"
			const gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp46_ = label;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp47_ = g_strconcat (_tmp46_, " = ", NULL);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_free0 (label);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			label = _tmp47_;
#line 1007 "math-buttons.c"
		}
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp48_ = label;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp49_ = bits;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp50_ = g_strdup_printf ("%llu₁₀", _tmp49_);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp51_ = _tmp50_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp52_ = g_strconcat (_tmp48_, _tmp51_, NULL);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_free0 (label);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		label = _tmp52_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_free0 (_tmp51_);
#line 1025 "math-buttons.c"
	}
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp53_ = number_base;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp53_ != 16) {
#line 1031 "math-buttons.c"
		const gchar* _tmp54_ = NULL;
		const gchar* _tmp57_ = NULL;
		guint64 _tmp58_ = 0ULL;
		gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp54_ = label;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (g_strcmp0 (_tmp54_, "") != 0) {
#line 1042 "math-buttons.c"
			const gchar* _tmp55_ = NULL;
			gchar* _tmp56_ = NULL;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp55_ = label;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp56_ = g_strconcat (_tmp55_, " = ", NULL);
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_free0 (label);
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			label = _tmp56_;
#line 1053 "math-buttons.c"
		}
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp57_ = label;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp58_ = bits;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp59_ = g_strdup_printf ("%llX₁₆", _tmp58_);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp60_ = _tmp59_;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp61_ = g_strconcat (_tmp57_, _tmp60_, NULL);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_free0 (label);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		label = _tmp61_;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_free0 (_tmp60_);
#line 1071 "math-buttons.c"
	}
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp62_ = self->priv->base_label;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp63_ = label;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_label_set_text (_tmp62_, _tmp63_);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_free0 (label);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (x);
#line 1083 "math-buttons.c"
}


static void math_buttons_base_combobox_changed_cb (MathButtons* self, GtkComboBox* combo) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gint value = 0;
	GtkTreeIter _tmp5_ = {0};
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (combo != NULL);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = combo;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	model = _tmp2_;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = combo;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	iter = _tmp4_;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp5_ = iter;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_tree_model_get (model, &_tmp5_, 1, &value, -1, -1);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_set_programming_base (self, value);
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (model);
#line 1123 "math-buttons.c"
}


static void math_buttons_base_changed_cb (MathButtons* self) {
	ButtonMode _tmp0_ = 0;
	ButtonMode _tmp1_ = 0;
	MathEquation* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeIter iter = {0};
	gboolean valid = FALSE;
	GtkTreeModel* _tmp8_ = NULL;
	GtkTreeIter _tmp9_ = {0};
	gboolean _tmp10_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GtkComboBox* _tmp23_ = NULL;
	GtkTreeIter _tmp24_ = {0};
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = math_buttons_get_mode (self);
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = _tmp0_;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp1_ != BUTTON_MODE_PROGRAMMING) {
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		return;
#line 1155 "math-buttons.c"
	}
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = self->priv->equation;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = math_equation_get_number_base (_tmp2_);
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp4_ = _tmp3_;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	self->priv->_programming_base = _tmp4_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp5_ = self->priv->base_combo;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	model = _tmp7_;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp8_ = model;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp10_ = gtk_tree_model_get_iter_first (_tmp8_, &_tmp9_);
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	iter = _tmp9_;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	valid = _tmp10_;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	while (TRUE) {
#line 1183 "math-buttons.c"
		gboolean _tmp11_ = FALSE;
		gint v = 0;
		GtkTreeModel* _tmp12_ = NULL;
		GtkTreeIter _tmp13_ = {0};
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		GtkTreeModel* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp11_ = valid;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (!_tmp11_) {
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 1199 "math-buttons.c"
		}
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp12_ = model;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp13_ = iter;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_tree_model_get (_tmp12_, &_tmp13_, 1, &v, -1, -1);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp14_ = v;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp15_ = math_buttons_get_programming_base (self);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp16_ = _tmp15_;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp14_ == _tmp16_) {
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 1217 "math-buttons.c"
		}
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp17_ = model;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp18_ = gtk_tree_model_iter_next (_tmp17_, &iter);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		valid = _tmp18_;
#line 1225 "math-buttons.c"
	}
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp19_ = valid;
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (!_tmp19_) {
#line 1231 "math-buttons.c"
		GtkTreeModel* _tmp20_ = NULL;
		GtkTreeIter _tmp21_ = {0};
		gboolean _tmp22_ = FALSE;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp20_ = model;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp22_ = gtk_tree_model_get_iter_first (_tmp20_, &_tmp21_);
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		iter = _tmp21_;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		valid = _tmp22_;
#line 1243 "math-buttons.c"
	}
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp23_ = self->priv->base_combo;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp24_ = iter;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_combo_box_set_active_iter (_tmp23_, &_tmp24_);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (model);
#line 1253 "math-buttons.c"
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 857 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 7);
#line 857 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	str = (gchar*) _tmp0_;
#line 858 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = str;
#line 858 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_unichar_to_utf8 (self, _tmp1_);
#line 859 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = str;
#line 859 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 1274 "math-buttons.c"
}


static void ______lambda16_ (MathButtons* self, GtkButton* widget) {
	MathEquation* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (widget != NULL);
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->equation;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = widget;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "calc_digit");
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_equation_insert_digit (_tmp0_, (guint) ((gint) ((gintptr) _tmp2_)));
#line 1292 "math-buttons.c"
}


static void _______lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	______lambda16_ ((MathButtons*) self, _sender);
#line 1299 "math-buttons.c"
}


static void ___lambda17_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->equation;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_equation_insert_subtract (_tmp0_);
#line 1309 "math-buttons.c"
}


static void ____lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	___lambda17_ ((MathButtons*) self);
#line 1316 "math-buttons.c"
}


static void ___lambda18_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->equation;
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_equation_insert_square (_tmp0_);
#line 1326 "math-buttons.c"
}


static void ____lambda18__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	___lambda18_ ((MathButtons*) self);
#line 1333 "math-buttons.c"
}


static void ___lambda19_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->equation;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_source_buffer_undo ((GtkSourceBuffer*) _tmp0_);
#line 1343 "math-buttons.c"
}


static void ____lambda19__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	___lambda19_ ((MathButtons*) self);
#line 1350 "math-buttons.c"
}


static void ___lambda20_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->equation;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_equation_solve (_tmp0_);
#line 1360 "math-buttons.c"
}


static void ____lambda20__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	___lambda20_ ((MathButtons*) self);
#line 1367 "math-buttons.c"
}


static void ___lambda21_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->equation;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_equation_clear (_tmp0_);
#line 1377 "math-buttons.c"
}


static void ____lambda21__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	___lambda21_ ((MathButtons*) self);
#line 1384 "math-buttons.c"
}


static void _math_buttons_memory_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_memory_cb ((MathButtons*) self, _sender);
#line 1391 "math-buttons.c"
}


static void _math_buttons_function_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_function_cb ((MathButtons*) self, _sender);
#line 1398 "math-buttons.c"
}


static void ___lambda24_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->equation;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_equation_factorize (_tmp0_);
#line 1408 "math-buttons.c"
}


static void ____lambda24__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	___lambda24_ ((MathButtons*) self);
#line 1415 "math-buttons.c"
}


static void ___lambda25_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->equation;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_equation_insert_exponent (_tmp0_);
#line 1425 "math-buttons.c"
}


static void ____lambda25__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	___lambda25_ ((MathButtons*) self);
#line 1432 "math-buttons.c"
}


static void _math_buttons_shift_left_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_shift_left_cb ((MathButtons*) self, _sender);
#line 1439 "math-buttons.c"
}


static void _math_buttons_shift_right_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_shift_right_cb ((MathButtons*) self, _sender);
#line 1446 "math-buttons.c"
}


static void _math_buttons_insert_character_code_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_insert_character_code_cb ((MathButtons*) self, _sender);
#line 1453 "math-buttons.c"
}


static void ___lambda28_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->equation;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_equation_insert_numeric_point (_tmp0_);
#line 1463 "math-buttons.c"
}


static void ____lambda28__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	___lambda28_ ((MathButtons*) self);
#line 1470 "math-buttons.c"
}


static void _math_buttons_set_superscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_set_superscript_cb ((MathButtons*) self, _sender);
#line 1477 "math-buttons.c"
}


static void _math_buttons_set_subscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_set_subscript_cb ((MathButtons*) self, _sender);
#line 1484 "math-buttons.c"
}


static void _math_buttons_character_code_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_character_code_dialog_response_cb ((MathButtons*) self, _sender, response_id);
#line 1491 "math-buttons.c"
}


static gboolean _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = math_buttons_character_code_dialog_delete_cb ((MathButtons*) self, _sender, event);
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return result;
#line 1500 "math-buttons.c"
}


static void _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_character_code_dialog_activate_cb ((MathButtons*) self, _sender);
#line 1507 "math-buttons.c"
}


static gboolean _math_buttons_bit_toggle_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = math_buttons_bit_toggle_cb ((MathButtons*) self, _sender, event);
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return result;
#line 1516 "math-buttons.c"
}


static void _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_base_combobox_changed_cb ((MathButtons*) self, _sender);
#line 1523 "math-buttons.c"
}


static void ___lambda29_ (MathButtons* self, GParamSpec* pspec) {
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (pspec != NULL);
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_base_changed_cb (self);
#line 1532 "math-buttons.c"
}


static void ____lambda29__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	___lambda29_ ((MathButtons*) self, pspec);
#line 1539 "math-buttons.c"
}


static void _math_buttons_finc_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_finc_cb ((MathButtons*) self, _sender);
#line 1546 "math-buttons.c"
}


static GtkWidget* math_buttons_load_mode (MathButtons* self, ButtonMode mode) {
	GtkWidget* result = NULL;
	GtkBuilder* builder = NULL;
	gchar* builder_resource = NULL;
	ButtonMode _tmp0_ = 0;
	GtkWidget* panel = NULL;
	GtkBuilder* _tmp34_ = NULL;
	GObject* _tmp35_ = NULL;
	GtkWidget* _tmp36_ = NULL;
	GtkWidget* _tmp37_ = NULL;
	ButtonMode _tmp38_ = 0;
	GtkBuilder* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	GtkBuilder* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	GtkBuilder* _tmp51_ = NULL;
	GtkBuilder* _tmp52_ = NULL;
	GtkBuilder* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	GtkBuilder* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	GtkBuilder* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	GtkBuilder* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	GtkBuilder* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	GtkBuilder* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	GtkBuilder* _tmp65_ = NULL;
	const gchar* _tmp66_ = NULL;
	GtkBuilder* _tmp67_ = NULL;
	const gchar* _tmp68_ = NULL;
	GtkBuilder* _tmp69_ = NULL;
	const gchar* _tmp70_ = NULL;
	GtkBuilder* _tmp71_ = NULL;
	const gchar* _tmp72_ = NULL;
	GtkBuilder* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	GtkBuilder* _tmp75_ = NULL;
	const gchar* _tmp76_ = NULL;
	GtkBuilder* _tmp77_ = NULL;
	const gchar* _tmp78_ = NULL;
	GtkBuilder* _tmp79_ = NULL;
	const gchar* _tmp80_ = NULL;
	GtkBuilder* _tmp81_ = NULL;
	const gchar* _tmp82_ = NULL;
	GtkBuilder* _tmp83_ = NULL;
	const gchar* _tmp84_ = NULL;
	GtkBuilder* _tmp85_ = NULL;
	const gchar* _tmp86_ = NULL;
	GtkBuilder* _tmp87_ = NULL;
	const gchar* _tmp88_ = NULL;
	GtkBuilder* _tmp89_ = NULL;
	const gchar* _tmp90_ = NULL;
	GtkBuilder* _tmp91_ = NULL;
	const gchar* _tmp92_ = NULL;
	GtkBuilder* _tmp93_ = NULL;
	const gchar* _tmp94_ = NULL;
	GtkBuilder* _tmp95_ = NULL;
	const gchar* _tmp96_ = NULL;
	GtkBuilder* _tmp97_ = NULL;
	const gchar* _tmp98_ = NULL;
	GtkBuilder* _tmp99_ = NULL;
	const gchar* _tmp100_ = NULL;
	GtkBuilder* _tmp101_ = NULL;
	const gchar* _tmp102_ = NULL;
	GtkBuilder* _tmp103_ = NULL;
	const gchar* _tmp104_ = NULL;
	GtkBuilder* _tmp105_ = NULL;
	const gchar* _tmp106_ = NULL;
	GtkBuilder* _tmp107_ = NULL;
	const gchar* _tmp108_ = NULL;
	GtkBuilder* _tmp109_ = NULL;
	const gchar* _tmp110_ = NULL;
	GtkBuilder* _tmp111_ = NULL;
	const gchar* _tmp112_ = NULL;
	GtkBuilder* _tmp113_ = NULL;
	const gchar* _tmp114_ = NULL;
	GtkBuilder* _tmp115_ = NULL;
	const gchar* _tmp116_ = NULL;
	GtkBuilder* _tmp117_ = NULL;
	const gchar* _tmp118_ = NULL;
	GtkBuilder* _tmp119_ = NULL;
	const gchar* _tmp120_ = NULL;
	GtkBuilder* _tmp121_ = NULL;
	const gchar* _tmp122_ = NULL;
	GtkBuilder* _tmp123_ = NULL;
	const gchar* _tmp124_ = NULL;
	GtkBuilder* _tmp125_ = NULL;
	const gchar* _tmp126_ = NULL;
	GtkBuilder* _tmp127_ = NULL;
	const gchar* _tmp128_ = NULL;
	GtkBuilder* _tmp129_ = NULL;
	const gchar* _tmp130_ = NULL;
	GtkBuilder* _tmp131_ = NULL;
	const gchar* _tmp132_ = NULL;
	GtkBuilder* _tmp133_ = NULL;
	const gchar* _tmp134_ = NULL;
	GtkBuilder* _tmp135_ = NULL;
	const gchar* _tmp136_ = NULL;
	GtkBuilder* _tmp137_ = NULL;
	const gchar* _tmp138_ = NULL;
	GtkBuilder* _tmp139_ = NULL;
	const gchar* _tmp140_ = NULL;
	GtkBuilder* _tmp141_ = NULL;
	const gchar* _tmp142_ = NULL;
	GtkBuilder* _tmp143_ = NULL;
	const gchar* _tmp144_ = NULL;
	GtkBuilder* _tmp145_ = NULL;
	const gchar* _tmp146_ = NULL;
	GtkBuilder* _tmp147_ = NULL;
	const gchar* _tmp148_ = NULL;
	GtkBuilder* _tmp149_ = NULL;
	const gchar* _tmp150_ = NULL;
	GtkBuilder* _tmp151_ = NULL;
	const gchar* _tmp152_ = NULL;
	GtkBuilder* _tmp153_ = NULL;
	const gchar* _tmp154_ = NULL;
	GtkBuilder* _tmp155_ = NULL;
	const gchar* _tmp156_ = NULL;
	GtkBuilder* _tmp157_ = NULL;
	const gchar* _tmp158_ = NULL;
	GtkBuilder* _tmp159_ = NULL;
	const gchar* _tmp160_ = NULL;
	GtkBuilder* _tmp161_ = NULL;
	const gchar* _tmp162_ = NULL;
	GtkBuilder* _tmp163_ = NULL;
	const gchar* _tmp164_ = NULL;
	GtkButton* button = NULL;
	GtkBuilder* _tmp184_ = NULL;
	GObject* _tmp185_ = NULL;
	GtkButton* _tmp186_ = NULL;
	GtkButton* _tmp187_ = NULL;
	GtkBuilder* _tmp189_ = NULL;
	GObject* _tmp190_ = NULL;
	GtkButton* _tmp191_ = NULL;
	GtkButton* _tmp192_ = NULL;
	GtkBuilder* _tmp196_ = NULL;
	GObject* _tmp197_ = NULL;
	GtkButton* _tmp198_ = NULL;
	GtkButton* _tmp199_ = NULL;
	GtkBuilder* _tmp201_ = NULL;
	GObject* _tmp202_ = NULL;
	GtkButton* _tmp203_ = NULL;
	GtkButton* _tmp204_ = NULL;
	GtkBuilder* _tmp206_ = NULL;
	GObject* _tmp207_ = NULL;
	GtkButton* _tmp208_ = NULL;
	GtkButton* _tmp209_ = NULL;
	GtkBuilder* _tmp211_ = NULL;
	GObject* _tmp212_ = NULL;
	GtkButton* _tmp213_ = NULL;
	GtkButton* _tmp214_ = NULL;
	GtkBuilder* _tmp216_ = NULL;
	GObject* _tmp217_ = NULL;
	GtkButton* _tmp218_ = NULL;
	GtkButton* _tmp219_ = NULL;
	GtkBuilder* _tmp221_ = NULL;
	GObject* _tmp222_ = NULL;
	GtkButton* _tmp223_ = NULL;
	GtkButton* _tmp224_ = NULL;
	GtkBuilder* _tmp226_ = NULL;
	GObject* _tmp227_ = NULL;
	GtkButton* _tmp228_ = NULL;
	GtkButton* _tmp229_ = NULL;
	GtkBuilder* _tmp231_ = NULL;
	GObject* _tmp232_ = NULL;
	GtkButton* _tmp233_ = NULL;
	GtkButton* _tmp234_ = NULL;
	GtkBuilder* _tmp236_ = NULL;
	GObject* _tmp237_ = NULL;
	GtkButton* _tmp238_ = NULL;
	GtkButton* _tmp239_ = NULL;
	GtkBuilder* _tmp241_ = NULL;
	GObject* _tmp242_ = NULL;
	GtkButton* _tmp243_ = NULL;
	GtkButton* _tmp244_ = NULL;
	GtkBuilder* _tmp246_ = NULL;
	GObject* _tmp247_ = NULL;
	GtkButton* _tmp248_ = NULL;
	GtkButton* _tmp249_ = NULL;
	GtkToggleButton* toggle_button = NULL;
	GtkBuilder* _tmp258_ = NULL;
	GObject* _tmp259_ = NULL;
	GtkToggleButton* _tmp260_ = NULL;
	GtkToggleButton* _tmp261_ = NULL;
	GtkBuilder* _tmp269_ = NULL;
	GObject* _tmp270_ = NULL;
	GtkToggleButton* _tmp271_ = NULL;
	GtkToggleButton* _tmp272_ = NULL;
	ButtonMode _tmp280_ = 0;
	ButtonMode _tmp348_ = 0;
	GtkBuilder* _tmp419_ = NULL;
	GError * _inner_error_ = NULL;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = mode;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	switch (_tmp0_) {
#line 1751 "math-buttons.c"
		default:
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case BUTTON_MODE_BASIC:
#line 1755 "math-buttons.c"
		{
			GtkWidget* _tmp1_ = NULL;
			GtkBuilder* _tmp4_ = NULL;
			GtkBuilder* _tmp5_ = NULL;
			GtkBuilder* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp1_ = self->priv->bas_panel;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			if (_tmp1_ != NULL) {
#line 1766 "math-buttons.c"
				GtkWidget* _tmp2_ = NULL;
				GtkWidget* _tmp3_ = NULL;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp2_ = self->priv->bas_panel;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp3_ = _g_object_ref0 (_tmp2_);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				result = _tmp3_;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_free0 (builder_resource);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_object_unref0 (builder);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				return result;
#line 1781 "math-buttons.c"
			}
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp4_ = gtk_builder_new ();
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_object_unref0 (self->priv->basic_ui);
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			self->priv->basic_ui = _tmp4_;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp5_ = self->priv->basic_ui;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp6_ = _g_object_ref0 (_tmp5_);
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_object_unref0 (builder);
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			builder = _tmp6_;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp7_ = g_strdup ("buttons-basic.ui");
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_free0 (builder_resource);
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			builder_resource = _tmp7_;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 1805 "math-buttons.c"
		}
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case BUTTON_MODE_ADVANCED:
#line 1809 "math-buttons.c"
		{
			GtkWidget* _tmp8_ = NULL;
			GtkBuilder* _tmp11_ = NULL;
			GtkBuilder* _tmp12_ = NULL;
			GtkBuilder* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp8_ = self->priv->adv_panel;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			if (_tmp8_ != NULL) {
#line 1820 "math-buttons.c"
				GtkWidget* _tmp9_ = NULL;
				GtkWidget* _tmp10_ = NULL;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp9_ = self->priv->adv_panel;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp10_ = _g_object_ref0 (_tmp9_);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				result = _tmp10_;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_free0 (builder_resource);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_object_unref0 (builder);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				return result;
#line 1835 "math-buttons.c"
			}
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp11_ = gtk_builder_new ();
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_object_unref0 (self->priv->advanced_ui);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			self->priv->advanced_ui = _tmp11_;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp12_ = self->priv->advanced_ui;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp13_ = _g_object_ref0 (_tmp12_);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_object_unref0 (builder);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			builder = _tmp13_;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp14_ = g_strdup ("buttons-advanced.ui");
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_free0 (builder_resource);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			builder_resource = _tmp14_;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 1859 "math-buttons.c"
		}
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case BUTTON_MODE_FINANCIAL:
#line 1863 "math-buttons.c"
		{
			GtkWidget* _tmp15_ = NULL;
			GtkBuilder* _tmp18_ = NULL;
			GtkBuilder* _tmp19_ = NULL;
			GtkBuilder* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp15_ = self->priv->fin_panel;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			if (_tmp15_ != NULL) {
#line 1874 "math-buttons.c"
				GtkWidget* _tmp16_ = NULL;
				GtkWidget* _tmp17_ = NULL;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp16_ = self->priv->fin_panel;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp17_ = _g_object_ref0 (_tmp16_);
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				result = _tmp17_;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_free0 (builder_resource);
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_object_unref0 (builder);
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				return result;
#line 1889 "math-buttons.c"
			}
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp18_ = gtk_builder_new ();
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_object_unref0 (self->priv->financial_ui);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			self->priv->financial_ui = _tmp18_;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp19_ = self->priv->financial_ui;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp20_ = _g_object_ref0 (_tmp19_);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_object_unref0 (builder);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			builder = _tmp20_;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp21_ = g_strdup ("buttons-financial.ui");
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_free0 (builder_resource);
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			builder_resource = _tmp21_;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 1913 "math-buttons.c"
		}
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case BUTTON_MODE_PROGRAMMING:
#line 1917 "math-buttons.c"
		{
			GtkWidget* _tmp22_ = NULL;
			GtkBuilder* _tmp25_ = NULL;
			GtkBuilder* _tmp26_ = NULL;
			GtkBuilder* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp22_ = self->priv->prog_panel;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			if (_tmp22_ != NULL) {
#line 1928 "math-buttons.c"
				GtkWidget* _tmp23_ = NULL;
				GtkWidget* _tmp24_ = NULL;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp23_ = self->priv->prog_panel;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp24_ = _g_object_ref0 (_tmp23_);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				result = _tmp24_;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_free0 (builder_resource);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_object_unref0 (builder);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				return result;
#line 1943 "math-buttons.c"
			}
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp25_ = gtk_builder_new ();
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_object_unref0 (self->priv->programming_ui);
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			self->priv->programming_ui = _tmp25_;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp26_ = self->priv->programming_ui;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp27_ = _g_object_ref0 (_tmp26_);
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_object_unref0 (builder);
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			builder = _tmp27_;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp28_ = g_strdup ("buttons-programming.ui");
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_free0 (builder_resource);
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			builder_resource = _tmp28_;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 1967 "math-buttons.c"
		}
	}
	{
		GtkBuilder* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp29_ = builder;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp30_ = builder_resource;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp31_ = g_strdup_printf ("/org/gnome/calculator/%s", _tmp30_);
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp32_ = _tmp31_;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_builder_add_from_resource (_tmp29_, _tmp32_, &_inner_error_);
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_free0 (_tmp32_);
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1989 "math-buttons.c"
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp33_ = NULL;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		e = _inner_error_;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_inner_error_ = NULL;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp33_ = e->message;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_error ("math-buttons.vala:266: Error loading button UI: %s", _tmp33_);
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_error_free0 (e);
#line 2008 "math-buttons.c"
	}
	__finally7:
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_free0 (builder_resource);
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (builder);
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_clear_error (&_inner_error_);
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		return NULL;
#line 2023 "math-buttons.c"
	}
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp34_ = builder;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp35_ = gtk_builder_get_object (_tmp34_, "button_panel");
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp35_) : NULL);
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	panel = _tmp36_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp37_ = panel;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_box_pack_end ((GtkBox*) self, _tmp37_, TRUE, TRUE, (guint) 0);
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp38_ = mode;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	switch (_tmp38_) {
#line 2041 "math-buttons.c"
		default:
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case BUTTON_MODE_BASIC:
#line 2045 "math-buttons.c"
		{
			GtkWidget* _tmp39_ = NULL;
			GtkWidget* _tmp40_ = NULL;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp39_ = panel;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp40_ = _g_object_ref0 (_tmp39_);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_object_unref0 (self->priv->bas_panel);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			self->priv->bas_panel = _tmp40_;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 2059 "math-buttons.c"
		}
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case BUTTON_MODE_ADVANCED:
#line 2063 "math-buttons.c"
		{
			GtkWidget* _tmp41_ = NULL;
			GtkWidget* _tmp42_ = NULL;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp41_ = panel;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp42_ = _g_object_ref0 (_tmp41_);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_object_unref0 (self->priv->adv_panel);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			self->priv->adv_panel = _tmp42_;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 2077 "math-buttons.c"
		}
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case BUTTON_MODE_FINANCIAL:
#line 2081 "math-buttons.c"
		{
			GtkWidget* _tmp43_ = NULL;
			GtkWidget* _tmp44_ = NULL;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp43_ = panel;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp44_ = _g_object_ref0 (_tmp43_);
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_object_unref0 (self->priv->fin_panel);
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			self->priv->fin_panel = _tmp44_;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 2095 "math-buttons.c"
		}
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case BUTTON_MODE_PROGRAMMING:
#line 2099 "math-buttons.c"
		{
			GtkWidget* _tmp45_ = NULL;
			GtkWidget* _tmp46_ = NULL;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp45_ = panel;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp46_ = _g_object_ref0 (_tmp45_);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_object_unref0 (self->priv->prog_panel);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			self->priv->prog_panel = _tmp46_;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 2113 "math-buttons.c"
		}
	}
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp47_ = builder;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp48_ = _ ("Pi [Ctrl+P]");
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp47_, "pi", "π", _tmp48_, TRUE);
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp49_ = builder;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp50_ = _ ("Euler’s Number");
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp49_, "eulers_number", "e", _tmp50_, TRUE);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp51_ = builder;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp51_, "imaginary", "i", NULL, TRUE);
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp52_ = builder;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp52_, "numeric_point", NULL, NULL, TRUE);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp53_ = builder;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp54_ = _ ("Subscript mode [Alt]");
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp53_, "subscript", NULL, _tmp54_, TRUE);
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp55_ = builder;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp56_ = _ ("Superscript mode [Ctrl]");
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp55_, "superscript", NULL, _tmp56_, TRUE);
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp57_ = builder;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp58_ = _ ("Scientific exponent [Ctrl+E]");
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp57_, "exponential", NULL, _tmp58_, TRUE);
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp59_ = builder;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp60_ = _ ("Add [+]");
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp59_, "add", "+", _tmp60_, TRUE);
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp61_ = builder;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp62_ = _ ("Subtract [-]");
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp61_, "subtract", "−", _tmp62_, FALSE);
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp63_ = builder;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp64_ = _ ("Multiply [*]");
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp63_, "multiply", "×", _tmp64_, TRUE);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp65_ = builder;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp66_ = _ ("Divide [/]");
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp65_, "divide", "÷", _tmp66_, TRUE);
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp67_ = builder;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp68_ = _ ("Modulus divide");
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp67_, "modulus_divide", " mod ", _tmp68_, TRUE);
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp69_ = builder;
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp70_ = _ ("Additional Functions");
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp69_, "function", NULL, _tmp70_, TRUE);
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp71_ = builder;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp72_ = _ ("Exponent [^ or **]");
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp71_, "x_pow_y", "^", _tmp72_, TRUE);
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp73_ = builder;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp74_ = _ ("Percentage [%]");
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp73_, "percentage", "%", _tmp74_, TRUE);
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp75_ = builder;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp76_ = _ ("Factorial [!]");
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp75_, "factorial", "!", _tmp76_, TRUE);
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp77_ = builder;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp78_ = _ ("Absolute value [|]");
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp77_, "abs", "|", _tmp78_, TRUE);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp79_ = builder;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp80_ = _ ("Complex argument");
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp79_, "arg", "Arg ", _tmp80_, TRUE);
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp81_ = builder;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp82_ = _ ("Complex conjugate");
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp81_, "conjugate", "conj ", _tmp82_, TRUE);
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp83_ = builder;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp84_ = _ ("Root [Ctrl+R]");
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp83_, "root", "√", _tmp84_, TRUE);
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp85_ = builder;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp86_ = _ ("Square root [Ctrl+R]");
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp85_, "square_root", "√", _tmp86_, TRUE);
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp87_ = builder;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp88_ = _ ("Logarithm");
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp87_, "logarithm", "log ", _tmp88_, TRUE);
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp89_ = builder;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp90_ = _ ("Natural Logarithm");
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp89_, "natural_logarithm", "ln ", _tmp90_, TRUE);
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp91_ = builder;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp92_ = _ ("Sine");
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp91_, "sine", "sin ", _tmp92_, TRUE);
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp93_ = builder;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp94_ = _ ("Cosine");
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp93_, "cosine", "cos ", _tmp94_, TRUE);
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp95_ = builder;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp96_ = _ ("Tangent");
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp95_, "tangent", "tan ", _tmp96_, TRUE);
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp97_ = builder;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp98_ = _ ("Hyperbolic Sine");
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp97_, "hyperbolic_sine", "sinh ", _tmp98_, TRUE);
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp99_ = builder;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp100_ = _ ("Hyperbolic Cosine");
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp99_, "hyperbolic_cosine", "cosh ", _tmp100_, TRUE);
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp101_ = builder;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp102_ = _ ("Hyperbolic Tangent");
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp101_, "hyperbolic_tangent", "tanh ", _tmp102_, TRUE);
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp103_ = builder;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp104_ = _ ("Inverse [Ctrl+I]");
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp103_, "inverse", "⁻¹", _tmp104_, TRUE);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp105_ = builder;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp106_ = _ ("Boolean AND");
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp105_, "and", "∧", _tmp106_, TRUE);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp107_ = builder;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp108_ = _ ("Boolean OR");
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp107_, "or", "∨", _tmp108_, TRUE);
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp109_ = builder;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp110_ = _ ("Boolean Exclusive OR");
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp109_, "xor", "⊻", _tmp110_, TRUE);
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp111_ = builder;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp112_ = _ ("Boolean NOT");
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp111_, "not", "¬", _tmp112_, TRUE);
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp113_ = builder;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp114_ = _ ("Integer Component");
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp113_, "integer_portion", "int ", _tmp114_, TRUE);
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp115_ = builder;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp116_ = _ ("Fractional Component");
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp115_, "fractional_portion", "frac ", _tmp116_, TRUE);
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp117_ = builder;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp118_ = _ ("Real Component");
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp117_, "real_portion", "Re ", _tmp118_, TRUE);
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp119_ = builder;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp120_ = _ ("Imaginary Component");
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp119_, "imaginary_portion", "Im ", _tmp120_, TRUE);
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp121_ = builder;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp122_ = _ ("Ones' Complement");
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp121_, "ones_complement", "ones ", _tmp122_, TRUE);
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp123_ = builder;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp124_ = _ ("Two's Complement");
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp123_, "twos_complement", "twos ", _tmp124_, TRUE);
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp125_ = builder;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp126_ = _ ("Start Group [(]");
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp125_, "start_group", "(", _tmp126_, TRUE);
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp127_ = builder;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp128_ = _ ("End Group [)]");
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp127_, "end_group", ")", _tmp128_, TRUE);
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp129_ = builder;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp130_ = _ ("Memory");
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp129_, "memory", NULL, _tmp130_, TRUE);
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp131_ = builder;
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp132_ = _ ("Insert Character Code");
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp131_, "character", NULL, _tmp132_, TRUE);
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp133_ = builder;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp134_ = _ ("Calculate Result");
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp133_, "result", NULL, _tmp134_, TRUE);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp135_ = builder;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp136_ = _ ("Factorize [Ctrl+F]");
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp135_, "factor", NULL, _tmp136_, TRUE);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp137_ = builder;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp138_ = _ ("Clear Display [Escape]");
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp137_, "clear", NULL, _tmp138_, TRUE);
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp139_ = builder;
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp140_ = _ ("Undo [Ctrl+Z]");
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp139_, "undo", NULL, _tmp140_, TRUE);
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp141_ = builder;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp142_ = _ ("Shift Left");
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp141_, "shift_left", NULL, _tmp142_, TRUE);
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp143_ = builder;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp144_ = _ ("Shift Right");
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp143_, "shift_right", NULL, _tmp144_, TRUE);
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp145_ = builder;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp146_ = _ ("Compounding Term");
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp145_, "finc_compounding_term", NULL, _tmp146_, TRUE);
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp147_ = builder;
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp148_ = _ ("Double Declining Depreciation");
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp147_, "finc_double_declining_depreciation", NULL, _tmp148_, TRUE);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp149_ = builder;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp150_ = _ ("Future Value");
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp149_, "finc_future_value", NULL, _tmp150_, TRUE);
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp151_ = builder;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp152_ = _ ("Financial Term");
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp151_, "finc_term", NULL, _tmp152_, TRUE);
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp153_ = builder;
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp154_ = _ ("Sum of the Years Digits Depreciation");
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp153_, "finc_sum_of_the_years_digits_depreciation", NULL, _tmp154_, TRUE);
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp155_ = builder;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp156_ = _ ("Straight Line Depreciation");
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp155_, "finc_straight_line_depreciation", NULL, _tmp156_, TRUE);
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp157_ = builder;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp158_ = _ ("Periodic Interest Rate");
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp157_, "finc_periodic_interest_rate", NULL, _tmp158_, TRUE);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp159_ = builder;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp160_ = _ ("Present Value");
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp159_, "finc_present_value", NULL, _tmp160_, TRUE);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp161_ = builder;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp162_ = _ ("Periodic Payment");
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp161_, "finc_periodic_payment", NULL, _tmp162_, TRUE);
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp163_ = builder;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp164_ = _ ("Gross Profit Margin");
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_setup_button (self, _tmp163_, "finc_gross_profit_margin", NULL, _tmp164_, TRUE);
#line 2472 "math-buttons.c"
	{
		gint i = 0;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		i = 0;
#line 2477 "math-buttons.c"
		{
			gboolean _tmp165_ = FALSE;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp165_ = TRUE;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			while (TRUE) {
#line 2484 "math-buttons.c"
				gint _tmp167_ = 0;
				gchar* name = NULL;
				gint _tmp168_ = 0;
				gchar* _tmp169_ = NULL;
				GtkButton* button = NULL;
				GtkBuilder* _tmp170_ = NULL;
				const gchar* _tmp171_ = NULL;
				GObject* _tmp172_ = NULL;
				GtkButton* _tmp173_ = NULL;
				GtkButton* _tmp174_ = NULL;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				if (!_tmp165_) {
#line 2497 "math-buttons.c"
					gint _tmp166_ = 0;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp166_ = i;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					i = _tmp166_ + 1;
#line 2503 "math-buttons.c"
				}
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp165_ = FALSE;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp167_ = i;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				if (!(_tmp167_ < 16)) {
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					break;
#line 2513 "math-buttons.c"
				}
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp168_ = i;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp169_ = g_strdup_printf ("calc_%d_button", _tmp168_);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				name = _tmp169_;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp170_ = builder;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp171_ = name;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp172_ = gtk_builder_get_object (_tmp170_, _tmp171_);
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp173_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp172_, gtk_button_get_type ()) ? ((GtkButton*) _tmp172_) : NULL);
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				button = _tmp173_;
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp174_ = button;
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				if (_tmp174_ != NULL) {
#line 2535 "math-buttons.c"
					GtkButton* _tmp175_ = NULL;
					gint _tmp176_ = 0;
					GtkButton* _tmp177_ = NULL;
					MathEquation* _tmp178_ = NULL;
					gint _tmp179_ = 0;
					gunichar _tmp180_ = 0U;
					gchar* _tmp181_ = NULL;
					gchar* _tmp182_ = NULL;
					GtkButton* _tmp183_ = NULL;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp175_ = button;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp176_ = i;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					g_object_set_data_full ((GObject*) _tmp175_, "calc_digit", (gpointer) ((gintptr) _tmp176_), NULL);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp177_ = button;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp178_ = self->priv->equation;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp179_ = i;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp180_ = math_equation_get_digit_text (_tmp178_, (guint) _tmp179_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp181_ = g_unichar_to_string (_tmp180_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp182_ = _tmp181_;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					gtk_button_set_label (_tmp177_, _tmp182_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_g_free0 (_tmp182_);
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp183_ = button;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					g_signal_connect_object (_tmp183_, "clicked", (GCallback) _______lambda16__gtk_button_clicked, self, 0);
#line 2571 "math-buttons.c"
				}
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_object_unref0 (button);
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_free0 (name);
#line 2577 "math-buttons.c"
			}
		}
	}
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp184_ = builder;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp185_ = gtk_builder_get_object (_tmp184_, "calc_subtract_button");
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp186_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp185_, gtk_button_get_type ()) ? ((GtkButton*) _tmp185_) : NULL);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	button = _tmp186_;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp187_ = button;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp187_ != NULL) {
#line 2593 "math-buttons.c"
		GtkButton* _tmp188_ = NULL;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp188_ = button;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object (_tmp188_, "clicked", (GCallback) ____lambda17__gtk_button_clicked, self, 0);
#line 2599 "math-buttons.c"
	}
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp189_ = builder;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp190_ = gtk_builder_get_object (_tmp189_, "calc_x_squared_button");
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp191_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp190_, gtk_button_get_type ()) ? ((GtkButton*) _tmp190_) : NULL);
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (button);
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	button = _tmp191_;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp192_ = button;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp192_ != NULL) {
#line 2615 "math-buttons.c"
		GtkButton* _tmp193_ = NULL;
		GtkButton* _tmp194_ = NULL;
		const gchar* _tmp195_ = NULL;
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp193_ = button;
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object (_tmp193_, "clicked", (GCallback) ____lambda18__gtk_button_clicked, self, 0);
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp194_ = button;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp195_ = _ ("Square [Ctrl+2]");
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp194_, _tmp195_);
#line 2629 "math-buttons.c"
	}
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp196_ = builder;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp197_ = gtk_builder_get_object (_tmp196_, "calc_undo_button");
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp198_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp197_, gtk_button_get_type ()) ? ((GtkButton*) _tmp197_) : NULL);
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (button);
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	button = _tmp198_;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp199_ = button;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp199_ != NULL) {
#line 2645 "math-buttons.c"
		GtkButton* _tmp200_ = NULL;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp200_ = button;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object (_tmp200_, "clicked", (GCallback) ____lambda19__gtk_button_clicked, self, 0);
#line 2651 "math-buttons.c"
	}
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp201_ = builder;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp202_ = gtk_builder_get_object (_tmp201_, "calc_result_button");
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp203_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp202_, gtk_button_get_type ()) ? ((GtkButton*) _tmp202_) : NULL);
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (button);
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	button = _tmp203_;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp204_ = button;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp204_ != NULL) {
#line 2667 "math-buttons.c"
		GtkButton* _tmp205_ = NULL;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp205_ = button;
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object (_tmp205_, "clicked", (GCallback) ____lambda20__gtk_button_clicked, self, 0);
#line 2673 "math-buttons.c"
	}
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp206_ = builder;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp207_ = gtk_builder_get_object (_tmp206_, "calc_clear_button");
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp208_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp207_, gtk_button_get_type ()) ? ((GtkButton*) _tmp207_) : NULL);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (button);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	button = _tmp208_;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp209_ = button;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp209_ != NULL) {
#line 2689 "math-buttons.c"
		GtkButton* _tmp210_ = NULL;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp210_ = button;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object (_tmp210_, "clicked", (GCallback) ____lambda21__gtk_button_clicked, self, 0);
#line 2695 "math-buttons.c"
	}
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp211_ = builder;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp212_ = gtk_builder_get_object (_tmp211_, "calc_memory_button");
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp213_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp212_, gtk_button_get_type ()) ? ((GtkButton*) _tmp212_) : NULL);
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (button);
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	button = _tmp213_;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp214_ = button;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp214_ != NULL) {
#line 2711 "math-buttons.c"
		GtkButton* _tmp215_ = NULL;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp215_ = button;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object (_tmp215_, "clicked", (GCallback) _math_buttons_memory_cb_gtk_button_clicked, self, 0);
#line 2717 "math-buttons.c"
	}
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp216_ = builder;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp217_ = gtk_builder_get_object (_tmp216_, "calc_function_button");
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp218_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp217_, gtk_button_get_type ()) ? ((GtkButton*) _tmp217_) : NULL);
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (button);
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	button = _tmp218_;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp219_ = button;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp219_ != NULL) {
#line 2733 "math-buttons.c"
		GtkButton* _tmp220_ = NULL;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp220_ = button;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object (_tmp220_, "clicked", (GCallback) _math_buttons_function_cb_gtk_button_clicked, self, 0);
#line 2739 "math-buttons.c"
	}
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp221_ = builder;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp222_ = gtk_builder_get_object (_tmp221_, "calc_factor_button");
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp223_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp222_, gtk_button_get_type ()) ? ((GtkButton*) _tmp222_) : NULL);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (button);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	button = _tmp223_;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp224_ = button;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp224_ != NULL) {
#line 2755 "math-buttons.c"
		GtkButton* _tmp225_ = NULL;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp225_ = button;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object (_tmp225_, "clicked", (GCallback) ____lambda24__gtk_button_clicked, self, 0);
#line 2761 "math-buttons.c"
	}
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp226_ = builder;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp227_ = gtk_builder_get_object (_tmp226_, "calc_exponential_button");
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp228_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp227_, gtk_button_get_type ()) ? ((GtkButton*) _tmp227_) : NULL);
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (button);
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	button = _tmp228_;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp229_ = button;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp229_ != NULL) {
#line 2777 "math-buttons.c"
		GtkButton* _tmp230_ = NULL;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp230_ = button;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object (_tmp230_, "clicked", (GCallback) ____lambda25__gtk_button_clicked, self, 0);
#line 2783 "math-buttons.c"
	}
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp231_ = builder;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp232_ = gtk_builder_get_object (_tmp231_, "calc_shift_left_button");
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp233_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp232_, gtk_button_get_type ()) ? ((GtkButton*) _tmp232_) : NULL);
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (button);
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	button = _tmp233_;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp234_ = button;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp234_ != NULL) {
#line 2799 "math-buttons.c"
		GtkButton* _tmp235_ = NULL;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp235_ = button;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object (_tmp235_, "clicked", (GCallback) _math_buttons_shift_left_cb_gtk_button_clicked, self, 0);
#line 2805 "math-buttons.c"
	}
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp236_ = builder;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp237_ = gtk_builder_get_object (_tmp236_, "calc_shift_right_button");
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp238_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp237_, gtk_button_get_type ()) ? ((GtkButton*) _tmp237_) : NULL);
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (button);
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	button = _tmp238_;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp239_ = button;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp239_ != NULL) {
#line 2821 "math-buttons.c"
		GtkButton* _tmp240_ = NULL;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp240_ = button;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object (_tmp240_, "clicked", (GCallback) _math_buttons_shift_right_cb_gtk_button_clicked, self, 0);
#line 2827 "math-buttons.c"
	}
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp241_ = builder;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp242_ = gtk_builder_get_object (_tmp241_, "calc_character_button");
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp243_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp242_, gtk_button_get_type ()) ? ((GtkButton*) _tmp242_) : NULL);
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (button);
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	button = _tmp243_;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp244_ = button;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp244_ != NULL) {
#line 2843 "math-buttons.c"
		GtkButton* _tmp245_ = NULL;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp245_ = button;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object (_tmp245_, "clicked", (GCallback) _math_buttons_insert_character_code_cb_gtk_button_clicked, self, 0);
#line 2849 "math-buttons.c"
	}
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp246_ = builder;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp247_ = gtk_builder_get_object (_tmp246_, "calc_numeric_point_button");
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp248_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp247_, gtk_button_get_type ()) ? ((GtkButton*) _tmp247_) : NULL);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (button);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	button = _tmp248_;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp249_ = button;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp249_ != NULL) {
#line 2865 "math-buttons.c"
		GtkButton* _tmp250_ = NULL;
		MathEquation* _tmp251_ = NULL;
		Serializer* _tmp252_ = NULL;
		Serializer* _tmp253_ = NULL;
		gunichar _tmp254_ = 0U;
		gchar* _tmp255_ = NULL;
		gchar* _tmp256_ = NULL;
		GtkButton* _tmp257_ = NULL;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp250_ = button;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp251_ = self->priv->equation;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp252_ = math_equation_get_serializer (_tmp251_);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp253_ = _tmp252_;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp254_ = serializer_get_radix (_tmp253_);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp255_ = g_unichar_to_string (_tmp254_);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp256_ = _tmp255_;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_button_set_label (_tmp250_, _tmp256_);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_free0 (_tmp256_);
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp257_ = button;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object (_tmp257_, "clicked", (GCallback) ____lambda28__gtk_button_clicked, self, 0);
#line 2896 "math-buttons.c"
	}
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp258_ = builder;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp259_ = gtk_builder_get_object (_tmp258_, "calc_superscript_button");
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp260_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp259_, gtk_toggle_button_get_type ()) ? ((GtkToggleButton*) _tmp259_) : NULL);
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	toggle_button = _tmp260_;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp261_ = toggle_button;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp261_ != NULL) {
#line 2910 "math-buttons.c"
		GtkToggleButton* _tmp262_ = NULL;
		GtkToggleButton* _tmp263_ = NULL;
		MathEquation* _tmp264_ = NULL;
		NumberMode _tmp265_ = 0;
		NumberMode _tmp266_ = 0;
		GtkToggleButton* _tmp268_ = NULL;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp262_ = toggle_button;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp263_ = _g_object_ref0 (_tmp262_);
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		self->priv->superscript_toggles = g_list_append (self->priv->superscript_toggles, _tmp263_);
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp264_ = self->priv->equation;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp265_ = math_equation_get_number_mode (_tmp264_);
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp266_ = _tmp265_;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp266_ == NUMBER_MODE_SUPERSCRIPT) {
#line 2931 "math-buttons.c"
			GtkToggleButton* _tmp267_ = NULL;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp267_ = toggle_button;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			gtk_toggle_button_set_active (_tmp267_, TRUE);
#line 2937 "math-buttons.c"
		}
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp268_ = toggle_button;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object ((GtkButton*) _tmp268_, "clicked", (GCallback) _math_buttons_set_superscript_cb_gtk_button_clicked, self, 0);
#line 2943 "math-buttons.c"
	}
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp269_ = builder;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp270_ = gtk_builder_get_object (_tmp269_, "calc_subscript_button");
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp271_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp270_, gtk_toggle_button_get_type ()) ? ((GtkToggleButton*) _tmp270_) : NULL);
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (toggle_button);
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	toggle_button = _tmp271_;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp272_ = toggle_button;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp272_ != NULL) {
#line 2959 "math-buttons.c"
		GtkToggleButton* _tmp273_ = NULL;
		GtkToggleButton* _tmp274_ = NULL;
		MathEquation* _tmp275_ = NULL;
		NumberMode _tmp276_ = 0;
		NumberMode _tmp277_ = 0;
		GtkToggleButton* _tmp279_ = NULL;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp273_ = toggle_button;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp274_ = _g_object_ref0 (_tmp273_);
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		self->priv->subscript_toggles = g_list_append (self->priv->subscript_toggles, _tmp274_);
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp275_ = self->priv->equation;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp276_ = math_equation_get_number_mode (_tmp275_);
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp277_ = _tmp276_;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp277_ == NUMBER_MODE_SUBSCRIPT) {
#line 2980 "math-buttons.c"
			GtkToggleButton* _tmp278_ = NULL;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp278_ = toggle_button;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			gtk_toggle_button_set_active (_tmp278_, TRUE);
#line 2986 "math-buttons.c"
		}
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp279_ = toggle_button;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object ((GtkButton*) _tmp279_, "clicked", (GCallback) _math_buttons_set_subscript_cb_gtk_button_clicked, self, 0);
#line 2992 "math-buttons.c"
	}
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp280_ = mode;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp280_ == BUTTON_MODE_PROGRAMMING) {
#line 2998 "math-buttons.c"
		GtkBuilder* _tmp281_ = NULL;
		GObject* _tmp282_ = NULL;
		GtkLabel* _tmp283_ = NULL;
		GtkBuilder* _tmp284_ = NULL;
		GObject* _tmp285_ = NULL;
		GtkDialog* _tmp286_ = NULL;
		GtkDialog* _tmp287_ = NULL;
		GtkDialog* _tmp288_ = NULL;
		GtkBuilder* _tmp289_ = NULL;
		GObject* _tmp290_ = NULL;
		GtkEntry* _tmp291_ = NULL;
		GtkEntry* _tmp292_ = NULL;
		GtkBuilder* _tmp293_ = NULL;
		GObject* _tmp294_ = NULL;
		GtkWidget* _tmp295_ = NULL;
		gint i = 0;
		GtkBuilder* _tmp315_ = NULL;
		GObject* _tmp316_ = NULL;
		GtkComboBox* _tmp317_ = NULL;
		GtkListStore* model = NULL;
		GtkListStore* _tmp318_ = NULL;
		GtkComboBox* _tmp319_ = NULL;
		GtkListStore* _tmp320_ = NULL;
		GtkTreeIter iter = {0};
		GtkListStore* _tmp321_ = NULL;
		GtkTreeIter _tmp322_ = {0};
		GtkListStore* _tmp323_ = NULL;
		GtkTreeIter _tmp324_ = {0};
		const gchar* _tmp325_ = NULL;
		GtkListStore* _tmp326_ = NULL;
		GtkTreeIter _tmp327_ = {0};
		GtkListStore* _tmp328_ = NULL;
		GtkTreeIter _tmp329_ = {0};
		const gchar* _tmp330_ = NULL;
		GtkListStore* _tmp331_ = NULL;
		GtkTreeIter _tmp332_ = {0};
		GtkListStore* _tmp333_ = NULL;
		GtkTreeIter _tmp334_ = {0};
		const gchar* _tmp335_ = NULL;
		GtkListStore* _tmp336_ = NULL;
		GtkTreeIter _tmp337_ = {0};
		GtkListStore* _tmp338_ = NULL;
		GtkTreeIter _tmp339_ = {0};
		const gchar* _tmp340_ = NULL;
		GtkCellRendererText* renderer = NULL;
		GtkCellRendererText* _tmp341_ = NULL;
		GtkComboBox* _tmp342_ = NULL;
		GtkCellRendererText* _tmp343_ = NULL;
		GtkComboBox* _tmp344_ = NULL;
		GtkCellRendererText* _tmp345_ = NULL;
		GtkComboBox* _tmp346_ = NULL;
		MathEquation* _tmp347_ = NULL;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp281_ = builder;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp282_ = gtk_builder_get_object (_tmp281_, "base_label");
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp283_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp282_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp282_) : NULL);
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (self->priv->base_label);
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		self->priv->base_label = _tmp283_;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp284_ = builder;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp285_ = gtk_builder_get_object (_tmp284_, "character_code_dialog");
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp286_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp285_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp285_) : NULL);
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (self->priv->character_code_dialog);
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		self->priv->character_code_dialog = _tmp286_;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp287_ = self->priv->character_code_dialog;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object (_tmp287_, "response", (GCallback) _math_buttons_character_code_dialog_response_cb_gtk_dialog_response, self, 0);
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp288_ = self->priv->character_code_dialog;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object ((GtkWidget*) _tmp288_, "delete-event", (GCallback) _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event, self, 0);
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp289_ = builder;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp290_ = gtk_builder_get_object (_tmp289_, "character_code_entry");
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp291_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp290_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp290_) : NULL);
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (self->priv->character_code_entry);
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		self->priv->character_code_entry = _tmp291_;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp292_ = self->priv->character_code_entry;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object (_tmp292_, "activate", (GCallback) _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate, self, 0);
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp293_ = builder;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp294_ = gtk_builder_get_object (_tmp293_, "bit_table");
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp295_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp294_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp294_) : NULL);
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (self->priv->bit_panel);
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		self->priv->bit_panel = _tmp295_;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		__g_list_free__g_object_unref0_0 (self->priv->bit_labels);
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		self->priv->bit_labels = NULL;
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		i = 0;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		while (TRUE) {
#line 3111 "math-buttons.c"
			gchar* name = NULL;
			gint _tmp296_ = 0;
			gchar* _tmp297_ = NULL;
			GtkLabel* label = NULL;
			GtkBuilder* _tmp298_ = NULL;
			const gchar* _tmp299_ = NULL;
			GObject* _tmp300_ = NULL;
			GtkLabel* _tmp301_ = NULL;
			GtkLabel* _tmp302_ = NULL;
			GtkLabel* _tmp303_ = NULL;
			GtkLabel* _tmp304_ = NULL;
			gint _tmp305_ = 0;
			gchar* _tmp306_ = NULL;
			GtkEventBox* box = NULL;
			GtkBuilder* _tmp307_ = NULL;
			const gchar* _tmp308_ = NULL;
			GObject* _tmp309_ = NULL;
			GtkEventBox* _tmp310_ = NULL;
			GtkEventBox* _tmp311_ = NULL;
			gint _tmp312_ = 0;
			GtkEventBox* _tmp313_ = NULL;
			gint _tmp314_ = 0;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp296_ = i;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp297_ = g_strdup_printf ("bit_label_%d", _tmp296_);
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			name = _tmp297_;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp298_ = builder;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp299_ = name;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp300_ = gtk_builder_get_object (_tmp298_, _tmp299_);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp301_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp300_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp300_) : NULL);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			label = _tmp301_;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp302_ = label;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			if (_tmp302_ == NULL) {
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_object_unref0 (label);
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_free0 (name);
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				break;
#line 3160 "math-buttons.c"
			}
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp303_ = label;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp304_ = _g_object_ref0 (_tmp303_);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			self->priv->bit_labels = g_list_append (self->priv->bit_labels, _tmp304_);
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp305_ = i;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp306_ = g_strdup_printf ("bit_eventbox_%d", _tmp305_);
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_free0 (name);
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			name = _tmp306_;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp307_ = builder;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp308_ = name;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp309_ = gtk_builder_get_object (_tmp307_, _tmp308_);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp310_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp309_, gtk_event_box_get_type ()) ? ((GtkEventBox*) _tmp309_) : NULL);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			box = _tmp310_;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp311_ = box;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp312_ = i;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_object_set_data_full ((GObject*) _tmp311_, "bit_index", (gpointer) ((gintptr) _tmp312_), NULL);
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp313_ = box;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_signal_connect_object ((GtkWidget*) _tmp313_, "button-press-event", (GCallback) _math_buttons_bit_toggle_cb_gtk_widget_button_press_event, self, 0);
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp314_ = i;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			i = _tmp314_ + 1;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_object_unref0 (box);
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_object_unref0 (label);
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_free0 (name);
#line 3206 "math-buttons.c"
		}
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		self->priv->bit_labels = g_list_reverse (self->priv->bit_labels);
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp315_ = builder;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp316_ = gtk_builder_get_object (_tmp315_, "base_combo");
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp317_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp316_, gtk_combo_box_get_type ()) ? ((GtkComboBox*) _tmp316_) : NULL);
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (self->priv->base_combo);
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		self->priv->base_combo = _tmp317_;
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp318_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT, -1);
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		model = _tmp318_;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp319_ = self->priv->base_combo;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp320_ = model;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_combo_box_set_model (_tmp319_, (GtkTreeModel*) _tmp320_);
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp321_ = model;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_list_store_append (_tmp321_, &_tmp322_);
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		iter = _tmp322_;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp323_ = model;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp324_ = iter;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp325_ = _ ("Binary");
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_list_store_set (_tmp323_, &_tmp324_, 0, _tmp325_, 1, 2, -1, -1);
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp326_ = model;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_list_store_append (_tmp326_, &_tmp327_);
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		iter = _tmp327_;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp328_ = model;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp329_ = iter;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp330_ = _ ("Octal");
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_list_store_set (_tmp328_, &_tmp329_, 0, _tmp330_, 1, 8, -1, -1);
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp331_ = model;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_list_store_append (_tmp331_, &_tmp332_);
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		iter = _tmp332_;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp333_ = model;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp334_ = iter;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp335_ = _ ("Decimal");
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_list_store_set (_tmp333_, &_tmp334_, 0, _tmp335_, 1, 10, -1, -1);
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp336_ = model;
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_list_store_append (_tmp336_, &_tmp337_);
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		iter = _tmp337_;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp338_ = model;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp339_ = iter;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp340_ = _ ("Hexadecimal");
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_list_store_set (_tmp338_, &_tmp339_, 0, _tmp340_, 1, 16, -1, -1);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp341_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_object_ref_sink (_tmp341_);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		renderer = _tmp341_;
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp342_ = self->priv->base_combo;
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp343_ = renderer;
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp342_, (GtkCellRenderer*) _tmp343_, TRUE);
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp344_ = self->priv->base_combo;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp345_ = renderer;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp344_, (GtkCellRenderer*) _tmp345_, "text", 0);
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp346_ = self->priv->base_combo;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object (_tmp346_, "changed", (GCallback) _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed, self, 0);
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp347_ = self->priv->equation;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object ((GObject*) _tmp347_, "notify::number-base", (GCallback) ____lambda29__g_object_notify, self, 0);
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		math_buttons_base_changed_cb (self);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (renderer);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (model);
#line 3318 "math-buttons.c"
	}
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp348_ = mode;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp348_ == BUTTON_MODE_FINANCIAL) {
#line 3324 "math-buttons.c"
		GtkBuilder* _tmp349_ = NULL;
		GObject* _tmp350_ = NULL;
		GtkButton* _tmp351_ = NULL;
		GtkButton* _tmp352_ = NULL;
		GtkBuilder* _tmp356_ = NULL;
		GObject* _tmp357_ = NULL;
		GtkButton* _tmp358_ = NULL;
		GtkButton* _tmp359_ = NULL;
		GtkBuilder* _tmp363_ = NULL;
		GObject* _tmp364_ = NULL;
		GtkButton* _tmp365_ = NULL;
		GtkButton* _tmp366_ = NULL;
		GtkBuilder* _tmp370_ = NULL;
		GObject* _tmp371_ = NULL;
		GtkButton* _tmp372_ = NULL;
		GtkButton* _tmp373_ = NULL;
		GtkBuilder* _tmp377_ = NULL;
		GObject* _tmp378_ = NULL;
		GtkButton* _tmp379_ = NULL;
		GtkButton* _tmp380_ = NULL;
		GtkBuilder* _tmp384_ = NULL;
		GObject* _tmp385_ = NULL;
		GtkButton* _tmp386_ = NULL;
		GtkButton* _tmp387_ = NULL;
		GtkBuilder* _tmp391_ = NULL;
		GObject* _tmp392_ = NULL;
		GtkButton* _tmp393_ = NULL;
		GtkButton* _tmp394_ = NULL;
		GtkBuilder* _tmp398_ = NULL;
		GObject* _tmp399_ = NULL;
		GtkButton* _tmp400_ = NULL;
		GtkButton* _tmp401_ = NULL;
		GtkBuilder* _tmp405_ = NULL;
		GObject* _tmp406_ = NULL;
		GtkButton* _tmp407_ = NULL;
		GtkButton* _tmp408_ = NULL;
		GtkBuilder* _tmp412_ = NULL;
		GObject* _tmp413_ = NULL;
		GtkButton* _tmp414_ = NULL;
		GtkButton* _tmp415_ = NULL;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		math_buttons_load_finc_dialogs (self);
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp349_ = builder;
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp350_ = gtk_builder_get_object (_tmp349_, "calc_finc_compounding_term_button");
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp351_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp350_, gtk_button_get_type ()) ? ((GtkButton*) _tmp350_) : NULL);
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (button);
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		button = _tmp351_;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp352_ = button;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp352_ != NULL) {
#line 3381 "math-buttons.c"
			GtkButton* _tmp353_ = NULL;
			gchar* _tmp354_ = NULL;
			GtkButton* _tmp355_ = NULL;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp353_ = button;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp354_ = g_strdup ("ctrm_dialog");
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_object_set_data_full ((GObject*) _tmp353_, "finc-dialog-name", _tmp354_, g_free);
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp355_ = button;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_signal_connect_object (_tmp355_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
#line 3395 "math-buttons.c"
		}
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp356_ = builder;
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp357_ = gtk_builder_get_object (_tmp356_, "calc_finc_double_declining_depreciation_button");
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp358_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp357_, gtk_button_get_type ()) ? ((GtkButton*) _tmp357_) : NULL);
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (button);
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		button = _tmp358_;
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp359_ = button;
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp359_ != NULL) {
#line 3411 "math-buttons.c"
			GtkButton* _tmp360_ = NULL;
			gchar* _tmp361_ = NULL;
			GtkButton* _tmp362_ = NULL;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp360_ = button;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp361_ = g_strdup ("ddb_dialog");
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_object_set_data_full ((GObject*) _tmp360_, "finc-dialog-name", _tmp361_, g_free);
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp362_ = button;
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_signal_connect_object (_tmp362_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
#line 3425 "math-buttons.c"
		}
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp363_ = builder;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp364_ = gtk_builder_get_object (_tmp363_, "calc_finc_future_value_button");
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp365_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp364_, gtk_button_get_type ()) ? ((GtkButton*) _tmp364_) : NULL);
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (button);
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		button = _tmp365_;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp366_ = button;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp366_ != NULL) {
#line 3441 "math-buttons.c"
			GtkButton* _tmp367_ = NULL;
			gchar* _tmp368_ = NULL;
			GtkButton* _tmp369_ = NULL;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp367_ = button;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp368_ = g_strdup ("fv_dialog");
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_object_set_data_full ((GObject*) _tmp367_, "finc-dialog-name", _tmp368_, g_free);
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp369_ = button;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_signal_connect_object (_tmp369_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
#line 3455 "math-buttons.c"
		}
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp370_ = builder;
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp371_ = gtk_builder_get_object (_tmp370_, "calc_finc_gross_profit_margin_button");
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp372_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp371_, gtk_button_get_type ()) ? ((GtkButton*) _tmp371_) : NULL);
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (button);
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		button = _tmp372_;
#line 567 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp373_ = button;
#line 567 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp373_ != NULL) {
#line 3471 "math-buttons.c"
			GtkButton* _tmp374_ = NULL;
			gchar* _tmp375_ = NULL;
			GtkButton* _tmp376_ = NULL;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp374_ = button;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp375_ = g_strdup ("gpm_dialog");
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_object_set_data_full ((GObject*) _tmp374_, "finc-dialog-name", _tmp375_, g_free);
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp376_ = button;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_signal_connect_object (_tmp376_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
#line 3485 "math-buttons.c"
		}
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp377_ = builder;
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp378_ = gtk_builder_get_object (_tmp377_, "calc_finc_periodic_payment_button");
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp379_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp378_, gtk_button_get_type ()) ? ((GtkButton*) _tmp378_) : NULL);
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (button);
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		button = _tmp379_;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp380_ = button;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp380_ != NULL) {
#line 3501 "math-buttons.c"
			GtkButton* _tmp381_ = NULL;
			gchar* _tmp382_ = NULL;
			GtkButton* _tmp383_ = NULL;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp381_ = button;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp382_ = g_strdup ("pmt_dialog");
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_object_set_data_full ((GObject*) _tmp381_, "finc-dialog-name", _tmp382_, g_free);
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp383_ = button;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_signal_connect_object (_tmp383_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
#line 3515 "math-buttons.c"
		}
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp384_ = builder;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp385_ = gtk_builder_get_object (_tmp384_, "calc_finc_present_value_button");
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp386_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp385_, gtk_button_get_type ()) ? ((GtkButton*) _tmp385_) : NULL);
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (button);
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		button = _tmp386_;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp387_ = button;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp387_ != NULL) {
#line 3531 "math-buttons.c"
			GtkButton* _tmp388_ = NULL;
			gchar* _tmp389_ = NULL;
			GtkButton* _tmp390_ = NULL;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp388_ = button;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp389_ = g_strdup ("pv_dialog");
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_object_set_data_full ((GObject*) _tmp388_, "finc-dialog-name", _tmp389_, g_free);
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp390_ = button;
#line 582 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_signal_connect_object (_tmp390_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
#line 3545 "math-buttons.c"
		}
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp391_ = builder;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp392_ = gtk_builder_get_object (_tmp391_, "calc_finc_periodic_interest_rate_button");
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp393_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp392_, gtk_button_get_type ()) ? ((GtkButton*) _tmp392_) : NULL);
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (button);
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		button = _tmp393_;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp394_ = button;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp394_ != NULL) {
#line 3561 "math-buttons.c"
			GtkButton* _tmp395_ = NULL;
			gchar* _tmp396_ = NULL;
			GtkButton* _tmp397_ = NULL;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp395_ = button;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp396_ = g_strdup ("rate_dialog");
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_object_set_data_full ((GObject*) _tmp395_, "finc-dialog-name", _tmp396_, g_free);
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp397_ = button;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_signal_connect_object (_tmp397_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
#line 3575 "math-buttons.c"
		}
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp398_ = builder;
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp399_ = gtk_builder_get_object (_tmp398_, "calc_finc_straight_line_depreciation_button");
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp400_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp399_, gtk_button_get_type ()) ? ((GtkButton*) _tmp399_) : NULL);
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (button);
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		button = _tmp400_;
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp401_ = button;
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp401_ != NULL) {
#line 3591 "math-buttons.c"
			GtkButton* _tmp402_ = NULL;
			gchar* _tmp403_ = NULL;
			GtkButton* _tmp404_ = NULL;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp402_ = button;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp403_ = g_strdup ("sln_dialog");
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_object_set_data_full ((GObject*) _tmp402_, "finc-dialog-name", _tmp403_, g_free);
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp404_ = button;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_signal_connect_object (_tmp404_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
#line 3605 "math-buttons.c"
		}
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp405_ = builder;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp406_ = gtk_builder_get_object (_tmp405_, "calc_finc_sum_of_the_years_digits_depreciation_button");
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp407_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp406_, gtk_button_get_type ()) ? ((GtkButton*) _tmp406_) : NULL);
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (button);
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		button = _tmp407_;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp408_ = button;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp408_ != NULL) {
#line 3621 "math-buttons.c"
			GtkButton* _tmp409_ = NULL;
			gchar* _tmp410_ = NULL;
			GtkButton* _tmp411_ = NULL;
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp409_ = button;
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp410_ = g_strdup ("syd_dialog");
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_object_set_data_full ((GObject*) _tmp409_, "finc-dialog-name", _tmp410_, g_free);
#line 600 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp411_ = button;
#line 600 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_signal_connect_object (_tmp411_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
#line 3635 "math-buttons.c"
		}
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp412_ = builder;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp413_ = gtk_builder_get_object (_tmp412_, "calc_finc_term_button");
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp414_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp413_, gtk_button_get_type ()) ? ((GtkButton*) _tmp413_) : NULL);
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (button);
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		button = _tmp414_;
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp415_ = button;
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp415_ != NULL) {
#line 3651 "math-buttons.c"
			GtkButton* _tmp416_ = NULL;
			gchar* _tmp417_ = NULL;
			GtkButton* _tmp418_ = NULL;
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp416_ = button;
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp417_ = g_strdup ("term_dialog");
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_object_set_data_full ((GObject*) _tmp416_, "finc-dialog-name", _tmp417_, g_free);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp418_ = button;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_signal_connect_object (_tmp418_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
#line 3665 "math-buttons.c"
		}
	}
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp419_ = builder;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_builder_connect_signals (_tmp419_, self);
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_update_bit_panel (self);
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	result = panel;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (toggle_button);
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (button);
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_free0 (builder_resource);
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (builder);
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return result;
#line 3686 "math-buttons.c"
}


static void ____lambda15_ (MathButtons* self, GtkButton* widget) {
	MathEquation* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (widget != NULL);
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->equation;
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = widget;
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "calc_text");
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_equation_insert (_tmp0_, (const gchar*) _tmp2_);
#line 3704 "math-buttons.c"
}


static void _____lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	____lambda15_ ((MathButtons*) self, _sender);
#line 3711 "math-buttons.c"
}


static void math_buttons_setup_button (MathButtons* self, GtkBuilder* builder, const gchar* name, const gchar* data, const gchar* tooltip, gboolean connect) {
	gchar* widget_name = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkButton* button = NULL;
	GtkBuilder* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp19_ = NULL;
	GtkButton* _tmp22_ = NULL;
	AtkObject* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (builder != NULL);
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (name != NULL);
#line 619 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = name;
#line 619 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = g_strdup_printf ("calc_%s_button", _tmp0_);
#line 619 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	widget_name = _tmp1_;
#line 620 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = builder;
#line 620 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = widget_name;
#line 620 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp4_ = gtk_builder_get_object (_tmp2_, _tmp3_);
#line 620 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_button_get_type ()) ? ((GtkButton*) _tmp4_) : NULL);
#line 620 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	button = _tmp5_;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp6_ = button;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp6_ == NULL) {
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (button);
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_free0 (widget_name);
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		return;
#line 3764 "math-buttons.c"
	}
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp7_ = name;
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (g_strcmp0 (_tmp7_, "result") == 0) {
#line 3770 "math-buttons.c"
		GtkButton* _tmp8_ = NULL;
		GtkStyleContext* _tmp9_ = NULL;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp8_ = button;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_style_context_add_class (_tmp9_, "suggested-action");
#line 3779 "math-buttons.c"
	}
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp10_ = name;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (g_strcmp0 (_tmp10_, "clear") == 0) {
#line 3785 "math-buttons.c"
		GtkButton* _tmp11_ = NULL;
		GtkStyleContext* _tmp12_ = NULL;
#line 627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp11_ = button;
#line 627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) _tmp11_);
#line 627 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_style_context_add_class (_tmp12_, "destructive-action");
#line 3794 "math-buttons.c"
	}
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp13_ = data;
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp13_ != NULL) {
#line 3800 "math-buttons.c"
		GtkButton* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp14_ = button;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp15_ = data;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp16_ = g_strdup (_tmp15_);
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_object_set_data_full ((GObject*) _tmp14_, "calc_text", _tmp16_, g_free);
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp17_ = connect;
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp17_) {
#line 3817 "math-buttons.c"
			GtkButton* _tmp18_ = NULL;
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp18_ = button;
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			g_signal_connect_object (_tmp18_, "clicked", (GCallback) _____lambda15__gtk_button_clicked, self, 0);
#line 3823 "math-buttons.c"
		}
	}
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp19_ = tooltip;
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp19_ != NULL) {
#line 3830 "math-buttons.c"
		GtkButton* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp20_ = button;
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp21_ = tooltip;
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp20_, _tmp21_);
#line 3839 "math-buttons.c"
	}
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp22_ = button;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp23_ = gtk_widget_get_accessible ((GtkWidget*) _tmp22_);
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp24_ = name;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	atk_object_set_name (_tmp23_, _tmp24_);
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (button);
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_free0 (widget_name);
#line 3853 "math-buttons.c"
}


static void math_buttons_converter_changed_cb (MathButtons* self) {
	Unit* from_unit = NULL;
	Unit* to_unit = NULL;
	MathConverter* _tmp0_ = NULL;
	Unit* _tmp1_ = NULL;
	Unit* _tmp2_ = NULL;
	ButtonMode _tmp3_ = 0;
	ButtonMode _tmp4_ = 0;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->converter;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_converter_get_conversion (_tmp0_, &_tmp1_, &_tmp2_);
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (from_unit);
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	from_unit = _tmp1_;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (to_unit);
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	to_unit = _tmp2_;
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = math_buttons_get_mode (self);
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp4_ = _tmp3_;
#line 648 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp4_ == BUTTON_MODE_FINANCIAL) {
#line 3885 "math-buttons.c"
		MathEquation* _tmp5_ = NULL;
		Unit* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		MathEquation* _tmp10_ = NULL;
		Unit* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp5_ = self->priv->equation;
#line 650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp6_ = from_unit;
#line 650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp7_ = unit_get_name (_tmp6_);
#line 650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp8_ = _tmp7_;
#line 650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp9_ = _tmp8_;
#line 650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		math_equation_set_source_currency (_tmp5_, _tmp9_);
#line 650 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_free0 (_tmp9_);
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp10_ = self->priv->equation;
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp11_ = to_unit;
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp12_ = unit_get_name (_tmp11_);
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp13_ = _tmp12_;
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp14_ = _tmp13_;
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		math_equation_set_target_currency (_tmp10_, _tmp14_);
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_free0 (_tmp14_);
#line 3924 "math-buttons.c"
	} else {
		MathEquation* _tmp15_ = NULL;
		Unit* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		MathEquation* _tmp20_ = NULL;
		Unit* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 655 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp15_ = self->priv->equation;
#line 655 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp16_ = from_unit;
#line 655 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp17_ = unit_get_name (_tmp16_);
#line 655 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp18_ = _tmp17_;
#line 655 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp19_ = _tmp18_;
#line 655 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		math_equation_set_source_units (_tmp15_, _tmp19_);
#line 655 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_free0 (_tmp19_);
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp20_ = self->priv->equation;
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp21_ = to_unit;
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp22_ = unit_get_name (_tmp21_);
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp23_ = _tmp22_;
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp24_ = _tmp23_;
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		math_equation_set_target_units (_tmp20_, _tmp24_);
#line 656 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_free0 (_tmp24_);
#line 3964 "math-buttons.c"
	}
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (to_unit);
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (from_unit);
#line 3970 "math-buttons.c"
}


static void _math_buttons_converter_changed_cb_math_converter_changed (MathConverter* _sender, gpointer self) {
#line 668 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_converter_changed_cb ((MathButtons*) self);
#line 3977 "math-buttons.c"
}


static void math_buttons_load_buttons (MathButtons* self) {
	gboolean _tmp0_ = FALSE;
	MathConverter* _tmp1_ = NULL;
	GtkWidget* panel = NULL;
	ButtonMode _tmp6_ = 0;
	ButtonMode _tmp7_ = 0;
	GtkWidget* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkWidget* _tmp11_ = NULL;
	GtkWidget* _tmp13_ = NULL;
	GtkWidget* _tmp14_ = NULL;
	GtkWidget* _tmp15_ = NULL;
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
#line 662 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (!_tmp0_) {
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		return;
#line 4002 "math-buttons.c"
	}
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = self->priv->converter;
#line 665 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp1_ == NULL) {
#line 4008 "math-buttons.c"
		MathEquation* _tmp2_ = NULL;
		MathConverter* _tmp3_ = NULL;
		MathConverter* _tmp4_ = NULL;
		MathConverter* _tmp5_ = NULL;
#line 667 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp2_ = self->priv->equation;
#line 667 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp3_ = math_converter_new (_tmp2_);
#line 667 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_object_ref_sink (_tmp3_);
#line 667 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (self->priv->converter);
#line 667 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		self->priv->converter = _tmp3_;
#line 668 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp4_ = self->priv->converter;
#line 668 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_signal_connect_object (_tmp4_, "changed", (GCallback) _math_buttons_converter_changed_cb_math_converter_changed, self, 0);
#line 669 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp5_ = self->priv->converter;
#line 669 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp5_, FALSE, TRUE, (guint) 0);
#line 4031 "math-buttons.c"
	}
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp6_ = math_buttons_get_mode (self);
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp7_ = _tmp6_;
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp8_ = math_buttons_load_mode (self, _tmp7_);
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	panel = _tmp8_;
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp9_ = self->priv->active_panel;
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp10_ = panel;
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp9_ == _tmp10_) {
#line 674 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (panel);
#line 674 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		return;
#line 4051 "math-buttons.c"
	}
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp11_ = self->priv->active_panel;
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp11_ != NULL) {
#line 4057 "math-buttons.c"
		GtkWidget* _tmp12_ = NULL;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp12_ = self->priv->active_panel;
#line 678 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_widget_hide (_tmp12_);
#line 4063 "math-buttons.c"
	}
#line 681 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp13_ = panel;
#line 681 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 681 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->active_panel);
#line 681 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	self->priv->active_panel = _tmp14_;
#line 682 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp15_ = panel;
#line 682 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp15_ != NULL) {
#line 4077 "math-buttons.c"
		GtkWidget* _tmp16_ = NULL;
#line 683 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp16_ = panel;
#line 683 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_widget_show (_tmp16_);
#line 4083 "math-buttons.c"
	}
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (panel);
#line 4087 "math-buttons.c"
}


static void _math_buttons_button_menu_position_func_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_button_menu_position_func ((MathButtons*) self, menu, x, y, push_in);
#line 4094 "math-buttons.c"
}


static void math_buttons_popup_button_menu (MathButtons* self, GtkButton* button, GtkMenu* menu) {
	GtkMenu* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkMenu* _tmp3_ = NULL;
	guint32 _tmp4_ = 0U;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (button != NULL);
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (menu != NULL);
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = menu;
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = button;
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = _g_object_ref0 ((GtkWidget*) _tmp1_);
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_object_set_data_full ((GObject*) _tmp0_, "button", _tmp2_, g_object_unref);
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = menu;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp4_ = gtk_get_current_event_time ();
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_menu_popup (_tmp3_, NULL, NULL, _math_buttons_button_menu_position_func_gtk_menu_position_func, self, (guint) 1, _tmp4_);
#line 4124 "math-buttons.c"
}


static void math_buttons_button_menu_position_func (MathButtons* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _vala_push_in = FALSE;
	GtkButton* button = NULL;
	GtkMenu* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	gint origin_x = 0;
	gint origin_y = 0;
	GdkWindow* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	guint border = 0U;
	guint _tmp6_ = 0U;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp7_ = {0};
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	GtkAllocation _tmp10_ = {0};
	gint _tmp11_ = 0;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (menu != NULL);
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = menu;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "button");
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = _g_object_ref0 ((GtkButton*) _tmp1_);
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	button = _tmp2_;
#line 711 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) button);
#line 711 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gdk_window_get_origin (_tmp3_, &_tmp4_, &_tmp5_);
#line 711 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	origin_x = _tmp4_;
#line 711 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	origin_y = _tmp5_;
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp6_ = gtk_container_get_border_width ((GtkContainer*) button);
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	border = _tmp6_;
#line 714 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_widget_get_allocation ((GtkWidget*) button, &_tmp7_);
#line 714 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	allocation = _tmp7_;
#line 715 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp8_ = allocation;
#line 715 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp9_ = _tmp8_.x;
#line 715 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_vala_x = (gint) ((origin_x + _tmp9_) + border);
#line 716 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp10_ = allocation;
#line 716 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp11_ = _tmp10_.y;
#line 716 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_vala_y = (gint) ((origin_y + _tmp11_) + border);
#line 717 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_vala_push_in = FALSE;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (button);
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (x) {
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		*x = _vala_x;
#line 4197 "math-buttons.c"
	}
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (y) {
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		*y = _vala_y;
#line 4203 "math-buttons.c"
	}
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (push_in) {
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		*push_in = _vala_push_in;
#line 4209 "math-buttons.c"
	}
}


static void math_buttons_memory_cb (MathButtons* self, GtkWidget* widget) {
	MathVariablePopup* popup = NULL;
	MathEquation* _tmp0_ = NULL;
	MathVariablePopup* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkAllocation allocation = {0};
	GtkWidget* _tmp4_ = NULL;
	GtkAllocation _tmp5_ = {0};
	gint x = 0;
	gint y = 0;
	GtkWidget* _tmp6_ = NULL;
	GdkWindow* _tmp7_ = NULL;
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	GtkAllocation _tmp10_ = {0};
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (widget != NULL);
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->equation;
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = math_variable_popup_new (_tmp0_);
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_object_ref_sink (_tmp1_);
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	popup = _tmp1_;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = widget;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = gtk_widget_get_toplevel (_tmp2_);
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_window_set_transient_for ((GtkWindow*) popup, G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp3_) : NULL);
#line 726 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp4_ = widget;
#line 726 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_widget_get_allocation (_tmp4_, &_tmp5_);
#line 726 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	allocation = _tmp5_;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp6_ = widget;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp7_ = gtk_widget_get_window (_tmp6_);
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp8_ = allocation;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp9_ = _tmp8_.x;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp10_ = allocation;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp11_ = _tmp10_.y;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gdk_window_get_root_coords (_tmp7_, _tmp9_, _tmp11_, &_tmp12_, &_tmp13_);
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	x = _tmp12_;
#line 728 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	y = _tmp13_;
#line 729 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_window_move ((GtkWindow*) popup, x, y);
#line 730 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_widget_show ((GtkWidget*) popup);
#line 720 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (popup);
#line 4281 "math-buttons.c"
}


static void ______lambda26_ (MathButtons* self, GtkMenuItem* widget) {
	MathEquation* _tmp0_ = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (widget != NULL);
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->equation;
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = widget;
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "shiftcount");
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_equation_shift (_tmp0_, (gint) ((gintptr) _tmp2_));
#line 4299 "math-buttons.c"
}


static void _______lambda26__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	______lambda26_ ((MathButtons*) self, _sender);
#line 4306 "math-buttons.c"
}


static void math_buttons_shift_left_cb (MathButtons* self, GtkButton* button) {
	GtkMenu* _tmp0_ = NULL;
	GtkButton* _tmp28_ = NULL;
	GtkMenu* _tmp29_ = NULL;
#line 733 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 733 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (button != NULL);
#line 735 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->shift_left_menu;
#line 735 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp0_ == NULL) {
#line 4322 "math-buttons.c"
		GtkMenu* _tmp1_ = NULL;
		GtkMenu* _tmp2_ = NULL;
#line 737 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
#line 737 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_object_ref_sink (_tmp1_);
#line 737 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (self->priv->shift_left_menu);
#line 737 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		self->priv->shift_left_menu = _tmp1_;
#line 738 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp2_ = self->priv->shift_left_menu;
#line 738 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_menu_set_reserve_toggle_size (_tmp2_, FALSE);
#line 4337 "math-buttons.c"
		{
			gint i = 0;
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			i = 1;
#line 4342 "math-buttons.c"
			{
				gboolean _tmp3_ = FALSE;
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp3_ = TRUE;
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				while (TRUE) {
#line 4349 "math-buttons.c"
					gint _tmp5_ = 0;
					gchar* format = NULL;
					gint _tmp6_ = 0;
					gchar* text = NULL;
					const gchar* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					gchar* _tmp15_ = NULL;
					GtkLabel* label = NULL;
					const gchar* _tmp16_ = NULL;
					GtkLabel* _tmp17_ = NULL;
					GtkMenuItem* item = NULL;
					GtkMenuItem* _tmp18_ = NULL;
					GtkMenuItem* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					GtkMenuItem* _tmp21_ = NULL;
					GtkLabel* _tmp22_ = NULL;
					GtkMenu* _tmp23_ = NULL;
					GtkMenuItem* _tmp24_ = NULL;
					GtkMenuItem* _tmp25_ = NULL;
					GtkLabel* _tmp26_ = NULL;
					GtkMenuItem* _tmp27_ = NULL;
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					if (!_tmp3_) {
#line 4373 "math-buttons.c"
						gint _tmp4_ = 0;
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_tmp4_ = i;
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						i = _tmp4_ + 1;
#line 4379 "math-buttons.c"
					}
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp3_ = FALSE;
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp5_ = i;
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					if (!(_tmp5_ < 16)) {
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						break;
#line 4389 "math-buttons.c"
					}
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp6_ = i;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					if (_tmp6_ < 10) {
#line 4395 "math-buttons.c"
						gint _tmp7_ = 0;
						const gchar* _tmp8_ = NULL;
						gchar* _tmp9_ = NULL;
#line 746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_tmp7_ = i;
#line 746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_tmp8_ = ngettext ("_%d place", "_%d places", (gulong) _tmp7_);
#line 746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_tmp9_ = g_strdup (_tmp8_);
#line 746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_g_free0 (format);
#line 746 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						format = _tmp9_;
#line 4409 "math-buttons.c"
					} else {
						gint _tmp10_ = 0;
						const gchar* _tmp11_ = NULL;
						gchar* _tmp12_ = NULL;
#line 751 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_tmp10_ = i;
#line 751 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_tmp11_ = ngettext ("%d place", "%d places", (gulong) _tmp10_);
#line 751 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_tmp12_ = g_strdup (_tmp11_);
#line 751 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_g_free0 (format);
#line 751 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						format = _tmp12_;
#line 4424 "math-buttons.c"
					}
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp13_ = format;
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp14_ = i;
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp15_ = g_strdup_printf (_tmp13_, _tmp14_);
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					text = _tmp15_;
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp16_ = text;
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp17_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp16_);
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					g_object_ref_sink (_tmp17_);
#line 754 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					label = _tmp17_;
#line 756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp18_ = (GtkMenuItem*) gtk_menu_item_new ();
#line 756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					g_object_ref_sink (_tmp18_);
#line 756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					item = _tmp18_;
#line 757 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp19_ = item;
#line 757 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp20_ = i;
#line 757 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					g_object_set_data_full ((GObject*) _tmp19_, "shiftcount", (gpointer) ((gintptr) _tmp20_), NULL);
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp21_ = item;
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp22_ = label;
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
#line 759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp23_ = self->priv->shift_left_menu;
#line 759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp24_ = item;
#line 759 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					gtk_menu_shell_append ((GtkMenuShell*) _tmp23_, (GtkWidget*) _tmp24_);
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp25_ = item;
#line 760 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					g_signal_connect_object (_tmp25_, "activate", (GCallback) _______lambda26__gtk_menu_item_activate, self, 0);
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp26_ = label;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					gtk_widget_show ((GtkWidget*) _tmp26_);
#line 763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp27_ = item;
#line 763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					gtk_widget_show ((GtkWidget*) _tmp27_);
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_g_object_unref0 (item);
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_g_object_unref0 (label);
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_g_free0 (text);
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_g_free0 (format);
#line 4486 "math-buttons.c"
				}
			}
		}
	}
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp28_ = button;
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp29_ = self->priv->shift_left_menu;
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_popup_button_menu (self, _tmp28_, _tmp29_);
#line 4497 "math-buttons.c"
}


static void ______lambda27_ (MathButtons* self, GtkMenuItem* widget) {
	MathEquation* _tmp0_ = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
#line 797 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (widget != NULL);
#line 797 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->equation;
#line 797 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = widget;
#line 797 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "shiftcount");
#line 797 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_equation_shift (_tmp0_, (gint) ((gintptr) _tmp2_));
#line 4515 "math-buttons.c"
}


static void _______lambda27__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 797 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	______lambda27_ ((MathButtons*) self, _sender);
#line 4522 "math-buttons.c"
}


static void math_buttons_shift_right_cb (MathButtons* self, GtkButton* button) {
	GtkMenu* _tmp0_ = NULL;
	GtkButton* _tmp28_ = NULL;
	GtkMenu* _tmp29_ = NULL;
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (button != NULL);
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->shift_right_menu;
#line 772 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp0_ == NULL) {
#line 4538 "math-buttons.c"
		GtkMenu* _tmp1_ = NULL;
		GtkMenu* _tmp2_ = NULL;
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_object_ref_sink (_tmp1_);
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (self->priv->shift_right_menu);
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		self->priv->shift_right_menu = _tmp1_;
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp2_ = self->priv->shift_right_menu;
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_menu_set_reserve_toggle_size (_tmp2_, FALSE);
#line 4553 "math-buttons.c"
		{
			gint i = 0;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			i = 1;
#line 4558 "math-buttons.c"
			{
				gboolean _tmp3_ = FALSE;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp3_ = TRUE;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				while (TRUE) {
#line 4565 "math-buttons.c"
					gint _tmp5_ = 0;
					gchar* format = NULL;
					gint _tmp6_ = 0;
					gchar* text = NULL;
					const gchar* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					gchar* _tmp15_ = NULL;
					GtkLabel* label = NULL;
					const gchar* _tmp16_ = NULL;
					GtkLabel* _tmp17_ = NULL;
					GtkMenuItem* item = NULL;
					GtkMenuItem* _tmp18_ = NULL;
					GtkMenuItem* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					GtkMenuItem* _tmp21_ = NULL;
					GtkLabel* _tmp22_ = NULL;
					GtkMenu* _tmp23_ = NULL;
					GtkMenuItem* _tmp24_ = NULL;
					GtkMenuItem* _tmp25_ = NULL;
					GtkLabel* _tmp26_ = NULL;
					GtkMenuItem* _tmp27_ = NULL;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					if (!_tmp3_) {
#line 4589 "math-buttons.c"
						gint _tmp4_ = 0;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_tmp4_ = i;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						i = _tmp4_ + 1;
#line 4595 "math-buttons.c"
					}
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp3_ = FALSE;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp5_ = i;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					if (!(_tmp5_ < 16)) {
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						break;
#line 4605 "math-buttons.c"
					}
#line 780 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp6_ = i;
#line 780 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					if (_tmp6_ < 10) {
#line 4611 "math-buttons.c"
						gint _tmp7_ = 0;
						const gchar* _tmp8_ = NULL;
						gchar* _tmp9_ = NULL;
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_tmp7_ = i;
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_tmp8_ = ngettext ("_%d place", "_%d places", (gulong) _tmp7_);
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_tmp9_ = g_strdup (_tmp8_);
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_g_free0 (format);
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						format = _tmp9_;
#line 4625 "math-buttons.c"
					} else {
						gint _tmp10_ = 0;
						const gchar* _tmp11_ = NULL;
						gchar* _tmp12_ = NULL;
#line 788 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_tmp10_ = i;
#line 788 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_tmp11_ = ngettext ("%d place", "%d places", (gulong) _tmp10_);
#line 788 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_tmp12_ = g_strdup (_tmp11_);
#line 788 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_g_free0 (format);
#line 788 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						format = _tmp12_;
#line 4640 "math-buttons.c"
					}
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp13_ = format;
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp14_ = i;
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp15_ = g_strdup_printf (_tmp13_, _tmp14_);
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					text = _tmp15_;
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp16_ = text;
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp17_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp16_);
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					g_object_ref_sink (_tmp17_);
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					label = _tmp17_;
#line 793 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp18_ = (GtkMenuItem*) gtk_menu_item_new ();
#line 793 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					g_object_ref_sink (_tmp18_);
#line 793 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					item = _tmp18_;
#line 794 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp19_ = item;
#line 794 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp20_ = i;
#line 794 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					g_object_set_data_full ((GObject*) _tmp19_, "shiftcount", (gpointer) ((gintptr) (-_tmp20_)), NULL);
#line 795 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp21_ = item;
#line 795 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp22_ = label;
#line 795 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp23_ = self->priv->shift_right_menu;
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp24_ = item;
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					gtk_menu_shell_append ((GtkMenuShell*) _tmp23_, (GtkWidget*) _tmp24_);
#line 797 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp25_ = item;
#line 797 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					g_signal_connect_object (_tmp25_, "activate", (GCallback) _______lambda27__gtk_menu_item_activate, self, 0);
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp26_ = label;
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					gtk_widget_show ((GtkWidget*) _tmp26_);
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp27_ = item;
#line 800 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					gtk_widget_show ((GtkWidget*) _tmp27_);
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_g_object_unref0 (item);
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_g_object_unref0 (label);
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_g_free0 (text);
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_g_free0 (format);
#line 4702 "math-buttons.c"
				}
			}
		}
	}
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp28_ = button;
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp29_ = self->priv->shift_right_menu;
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_popup_button_menu (self, _tmp28_, _tmp29_);
#line 4713 "math-buttons.c"
}


static void math_buttons_function_cb (MathButtons* self, GtkWidget* widget) {
	MathFunctionPopup* popup = NULL;
	MathEquation* _tmp0_ = NULL;
	MathFunctionPopup* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkAllocation allocation = {0};
	GtkWidget* _tmp4_ = NULL;
	GtkAllocation _tmp5_ = {0};
	gint x = 0;
	gint y = 0;
	GtkWidget* _tmp6_ = NULL;
	GdkWindow* _tmp7_ = NULL;
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	GtkAllocation _tmp10_ = {0};
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (widget != NULL);
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->equation;
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = math_function_popup_new (_tmp0_);
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_object_ref_sink (_tmp1_);
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	popup = _tmp1_;
#line 810 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = widget;
#line 810 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = gtk_widget_get_toplevel (_tmp2_);
#line 810 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_window_set_transient_for ((GtkWindow*) popup, G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp3_) : NULL);
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp4_ = widget;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_widget_get_allocation (_tmp4_, &_tmp5_);
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	allocation = _tmp5_;
#line 815 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp6_ = widget;
#line 815 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp7_ = gtk_widget_get_window (_tmp6_);
#line 815 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp8_ = allocation;
#line 815 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp9_ = _tmp8_.x;
#line 815 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp10_ = allocation;
#line 815 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp11_ = _tmp10_.y;
#line 815 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gdk_window_get_root_coords (_tmp7_, _tmp9_, _tmp11_, &_tmp12_, &_tmp13_);
#line 815 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	x = _tmp12_;
#line 815 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	y = _tmp13_;
#line 816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_window_move ((GtkWindow*) popup, x, y);
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_widget_show ((GtkWidget*) popup);
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (popup);
#line 4784 "math-buttons.c"
}


static void math_buttons_finc_cb (MathButtons* self, GtkWidget* widget) {
	gchar* name = NULL;
	GtkWidget* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GtkDialog* dialog = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkDialog* _tmp5_ = NULL;
#line 820 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 820 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (widget != NULL);
#line 822 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = widget;
#line 822 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "finc-dialog-name");
#line 822 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
#line 822 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	name = _tmp2_;
#line 823 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = self->priv->financial_ui;
#line 823 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp4_ = gtk_builder_get_object (_tmp3_, name);
#line 823 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp4_) : NULL);
#line 823 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	dialog = _tmp5_;
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_dialog_run (dialog);
#line 825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_widget_hide ((GtkWidget*) dialog);
#line 820 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (dialog);
#line 820 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_free0 (name);
#line 4825 "math-buttons.c"
}


static void math_buttons_insert_character_code_cb (MathButtons* self, GtkWidget* widget) {
	GtkDialog* _tmp0_ = NULL;
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (widget != NULL);
#line 830 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->character_code_dialog;
#line 830 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 4839 "math-buttons.c"
}


static void math_buttons_finc_activate_cb (MathButtons* self, GtkWidget* widget) {
	GtkEntry* next_entry = NULL;
	GtkWidget* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GtkEntry* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
#line 833 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 833 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (widget != NULL);
#line 835 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = widget;
#line 835 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "next-entry");
#line 835 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = _g_object_ref0 ((GtkEntry*) _tmp1_);
#line 835 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	next_entry = _tmp2_;
#line 836 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = next_entry;
#line 836 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp3_ == NULL) {
#line 4865 "math-buttons.c"
		GtkDialog* dialog = NULL;
		GtkWidget* _tmp4_ = NULL;
		GtkWidget* _tmp5_ = NULL;
		GtkDialog* _tmp6_ = NULL;
		GtkDialog* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp4_ = widget;
#line 838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp5_ = gtk_widget_get_toplevel (_tmp4_);
#line 838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp5_) : NULL);
#line 838 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		dialog = _tmp6_;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp7_ = dialog;
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp8_ = gtk_widget_is_toplevel ((GtkWidget*) _tmp7_);
#line 839 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp8_) {
#line 4886 "math-buttons.c"
			GtkDialog* _tmp9_ = NULL;
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp9_ = dialog;
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			gtk_dialog_response (_tmp9_, (gint) GTK_RESPONSE_OK);
#line 842 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_object_unref0 (dialog);
#line 842 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_object_unref0 (next_entry);
#line 842 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			return;
#line 4898 "math-buttons.c"
		}
#line 836 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (dialog);
#line 4902 "math-buttons.c"
	} else {
		GtkEntry* _tmp10_ = NULL;
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp10_ = next_entry;
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
#line 4909 "math-buttons.c"
	}
#line 833 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (next_entry);
#line 4913 "math-buttons.c"
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	result = g_new0 (gchar*, length + 1);
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	for (i = 0; i < length; i++) {
#line 4924 "math-buttons.c"
		gchar* _tmp0_ = NULL;
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp0_ = g_strdup (self[i]);
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		result[i] = _tmp0_;
#line 4930 "math-buttons.c"
	}
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return result;
#line 4934 "math-buttons.c"
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	result = g_new0 (gchar*, length + 1);
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	for (i = 0; i < length; i++) {
#line 4945 "math-buttons.c"
		gchar* _tmp0_ = NULL;
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp0_ = g_strdup (self[i]);
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		result[i] = _tmp0_;
#line 4951 "math-buttons.c"
	}
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return result;
#line 4955 "math-buttons.c"
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	result = g_new0 (gchar*, length + 1);
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	for (i = 0; i < length; i++) {
#line 4966 "math-buttons.c"
		gchar* _tmp0_ = NULL;
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp0_ = g_strdup (self[i]);
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		result[i] = _tmp0_;
#line 4972 "math-buttons.c"
	}
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return result;
#line 4976 "math-buttons.c"
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	result = g_new0 (gchar*, length + 1);
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	for (i = 0; i < length; i++) {
#line 4987 "math-buttons.c"
		gchar* _tmp0_ = NULL;
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp0_ = g_strdup (self[i]);
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		result[i] = _tmp0_;
#line 4993 "math-buttons.c"
	}
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return result;
#line 4997 "math-buttons.c"
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	result = g_new0 (gchar*, length + 1);
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	for (i = 0; i < length; i++) {
#line 5008 "math-buttons.c"
		gchar* _tmp0_ = NULL;
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp0_ = g_strdup (self[i]);
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		result[i] = _tmp0_;
#line 5014 "math-buttons.c"
	}
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return result;
#line 5018 "math-buttons.c"
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	result = g_new0 (gchar*, length + 1);
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	for (i = 0; i < length; i++) {
#line 5029 "math-buttons.c"
		gchar* _tmp0_ = NULL;
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp0_ = g_strdup (self[i]);
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		result[i] = _tmp0_;
#line 5035 "math-buttons.c"
	}
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return result;
#line 5039 "math-buttons.c"
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
#line 877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	result = g_new0 (gchar*, length + 1);
#line 877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	for (i = 0; i < length; i++) {
#line 5050 "math-buttons.c"
		gchar* _tmp0_ = NULL;
#line 877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp0_ = g_strdup (self[i]);
#line 877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		result[i] = _tmp0_;
#line 5056 "math-buttons.c"
	}
#line 877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return result;
#line 5060 "math-buttons.c"
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	result = g_new0 (gchar*, length + 1);
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	for (i = 0; i < length; i++) {
#line 5071 "math-buttons.c"
		gchar* _tmp0_ = NULL;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp0_ = g_strdup (self[i]);
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		result[i] = _tmp0_;
#line 5077 "math-buttons.c"
	}
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return result;
#line 5081 "math-buttons.c"
}


static gchar** _vala_array_dup9 (gchar** self, int length) {
	gchar** result;
	int i;
#line 883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	result = g_new0 (gchar*, length + 1);
#line 883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	for (i = 0; i < length; i++) {
#line 5092 "math-buttons.c"
		gchar* _tmp0_ = NULL;
#line 883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp0_ = g_strdup (self[i]);
#line 883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		result[i] = _tmp0_;
#line 5098 "math-buttons.c"
	}
#line 883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return result;
#line 5102 "math-buttons.c"
}


static gchar** _vala_array_dup10 (gchar** self, int length) {
	gchar** result;
	int i;
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	result = g_new0 (gchar*, length + 1);
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	for (i = 0; i < length; i++) {
#line 5113 "math-buttons.c"
		gchar* _tmp0_ = NULL;
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp0_ = g_strdup (self[i]);
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		result[i] = _tmp0_;
#line 5119 "math-buttons.c"
	}
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return result;
#line 5123 "math-buttons.c"
}


static void math_buttons_finc_response_cb (MathButtons* self, GtkWidget* widget, gint response_id) {
	gint _tmp0_ = 0;
	FinancialDialog function = 0;
	GtkWidget* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gchar** entries = NULL;
	gchar** _tmp3_ = NULL;
	gint entries_length1 = 0;
	gint _entries_size_ = 0;
	FinancialDialog _tmp4_ = 0;
	Number* arg[4] = {0};
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	Number* _tmp18_ = NULL;
	Number* _tmp19_[4] = {0};
	GtkEntry* first_entry = NULL;
	GtkBuilder* _tmp36_ = NULL;
	gchar** _tmp37_ = NULL;
	gint _tmp37__length1 = 0;
	const gchar* _tmp38_ = NULL;
	GObject* _tmp39_ = NULL;
	GtkEntry* _tmp40_ = NULL;
	GtkEntry* _tmp41_ = NULL;
	MathEquation* _tmp42_ = NULL;
	FinancialDialog _tmp43_ = 0;
	Number* _tmp44_ = NULL;
	Number* _tmp45_ = NULL;
	Number* _tmp46_ = NULL;
	Number* _tmp47_ = NULL;
#line 849 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 849 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (widget != NULL);
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = response_id;
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp0_ != ((gint) GTK_RESPONSE_OK)) {
#line 852 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		return;
#line 5167 "math-buttons.c"
	}
#line 854 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = widget;
#line 854 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "finc-function");
#line 854 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	function = (FinancialDialog) ((gint) ((gintptr) _tmp2_));
#line 855 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = g_new0 (gchar*, 0 + 1);
#line 855 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	entries = _tmp3_;
#line 855 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	entries_length1 = 0;
#line 855 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_entries_size_ = entries_length1;
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp4_ = function;
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	switch (_tmp4_) {
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case FINANCIAL_DIALOG_CTRM_DIALOG:
#line 5189 "math-buttons.c"
		{
			gchar** _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp5_ = (MATH_BUTTONS_ctrm_entries != NULL) ? _vala_array_dup1 (MATH_BUTTONS_ctrm_entries, G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries)) : ((gpointer) MATH_BUTTONS_ctrm_entries);
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp5__length1 = G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries);
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = _tmp5_;
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries_length1 = _tmp5__length1;
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_entries_size_ = entries_length1;
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 5207 "math-buttons.c"
		}
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case FINANCIAL_DIALOG_DDB_DIALOG:
#line 5211 "math-buttons.c"
		{
			gchar** _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp6_ = (MATH_BUTTONS_ddb_entries != NULL) ? _vala_array_dup2 (MATH_BUTTONS_ddb_entries, G_N_ELEMENTS (MATH_BUTTONS_ddb_entries)) : ((gpointer) MATH_BUTTONS_ddb_entries);
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp6__length1 = G_N_ELEMENTS (MATH_BUTTONS_ddb_entries);
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = _tmp6_;
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries_length1 = _tmp6__length1;
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_entries_size_ = entries_length1;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 5229 "math-buttons.c"
		}
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case FINANCIAL_DIALOG_FV_DIALOG:
#line 5233 "math-buttons.c"
		{
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp7_ = (MATH_BUTTONS_fv_entries != NULL) ? _vala_array_dup3 (MATH_BUTTONS_fv_entries, G_N_ELEMENTS (MATH_BUTTONS_fv_entries)) : ((gpointer) MATH_BUTTONS_fv_entries);
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp7__length1 = G_N_ELEMENTS (MATH_BUTTONS_fv_entries);
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = _tmp7_;
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries_length1 = _tmp7__length1;
#line 865 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_entries_size_ = entries_length1;
#line 866 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 5251 "math-buttons.c"
		}
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case FINANCIAL_DIALOG_GPM_DIALOG:
#line 5255 "math-buttons.c"
		{
			gchar** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp8_ = (MATH_BUTTONS_gpm_entries != NULL) ? _vala_array_dup4 (MATH_BUTTONS_gpm_entries, G_N_ELEMENTS (MATH_BUTTONS_gpm_entries)) : ((gpointer) MATH_BUTTONS_gpm_entries);
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp8__length1 = G_N_ELEMENTS (MATH_BUTTONS_gpm_entries);
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = _tmp8_;
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries_length1 = _tmp8__length1;
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_entries_size_ = entries_length1;
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 5273 "math-buttons.c"
		}
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case FINANCIAL_DIALOG_PMT_DIALOG:
#line 5277 "math-buttons.c"
		{
			gchar** _tmp9_ = NULL;
			gint _tmp9__length1 = 0;
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp9_ = (MATH_BUTTONS_pmt_entries != NULL) ? _vala_array_dup5 (MATH_BUTTONS_pmt_entries, G_N_ELEMENTS (MATH_BUTTONS_pmt_entries)) : ((gpointer) MATH_BUTTONS_pmt_entries);
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp9__length1 = G_N_ELEMENTS (MATH_BUTTONS_pmt_entries);
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = _tmp9_;
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries_length1 = _tmp9__length1;
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_entries_size_ = entries_length1;
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 5295 "math-buttons.c"
		}
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case FINANCIAL_DIALOG_PV_DIALOG:
#line 5299 "math-buttons.c"
		{
			gchar** _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp10_ = (MATH_BUTTONS_pv_entries != NULL) ? _vala_array_dup6 (MATH_BUTTONS_pv_entries, G_N_ELEMENTS (MATH_BUTTONS_pv_entries)) : ((gpointer) MATH_BUTTONS_pv_entries);
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp10__length1 = G_N_ELEMENTS (MATH_BUTTONS_pv_entries);
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = _tmp10_;
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries_length1 = _tmp10__length1;
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_entries_size_ = entries_length1;
#line 875 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 5317 "math-buttons.c"
		}
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case FINANCIAL_DIALOG_RATE_DIALOG:
#line 5321 "math-buttons.c"
		{
			gchar** _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
#line 877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp11_ = (MATH_BUTTONS_rate_entries != NULL) ? _vala_array_dup7 (MATH_BUTTONS_rate_entries, G_N_ELEMENTS (MATH_BUTTONS_rate_entries)) : ((gpointer) MATH_BUTTONS_rate_entries);
#line 877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp11__length1 = G_N_ELEMENTS (MATH_BUTTONS_rate_entries);
#line 877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
#line 877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = _tmp11_;
#line 877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries_length1 = _tmp11__length1;
#line 877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_entries_size_ = entries_length1;
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 5339 "math-buttons.c"
		}
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case FINANCIAL_DIALOG_SLN_DIALOG:
#line 5343 "math-buttons.c"
		{
			gchar** _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp12_ = (MATH_BUTTONS_sln_entries != NULL) ? _vala_array_dup8 (MATH_BUTTONS_sln_entries, G_N_ELEMENTS (MATH_BUTTONS_sln_entries)) : ((gpointer) MATH_BUTTONS_sln_entries);
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp12__length1 = G_N_ELEMENTS (MATH_BUTTONS_sln_entries);
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = _tmp12_;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries_length1 = _tmp12__length1;
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_entries_size_ = entries_length1;
#line 881 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 5361 "math-buttons.c"
		}
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case FINANCIAL_DIALOG_SYD_DIALOG:
#line 5365 "math-buttons.c"
		{
			gchar** _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
#line 883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp13_ = (MATH_BUTTONS_syd_entries != NULL) ? _vala_array_dup9 (MATH_BUTTONS_syd_entries, G_N_ELEMENTS (MATH_BUTTONS_syd_entries)) : ((gpointer) MATH_BUTTONS_syd_entries);
#line 883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp13__length1 = G_N_ELEMENTS (MATH_BUTTONS_syd_entries);
#line 883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
#line 883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = _tmp13_;
#line 883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries_length1 = _tmp13__length1;
#line 883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_entries_size_ = entries_length1;
#line 884 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 5383 "math-buttons.c"
		}
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case FINANCIAL_DIALOG_TERM_DIALOG:
#line 5387 "math-buttons.c"
		{
			gchar** _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp14_ = (MATH_BUTTONS_term_entries != NULL) ? _vala_array_dup10 (MATH_BUTTONS_term_entries, G_N_ELEMENTS (MATH_BUTTONS_term_entries)) : ((gpointer) MATH_BUTTONS_term_entries);
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp14__length1 = G_N_ELEMENTS (MATH_BUTTONS_term_entries);
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries = _tmp14_;
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			entries_length1 = _tmp14__length1;
#line 886 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_entries_size_ = entries_length1;
#line 887 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 5405 "math-buttons.c"
		}
		default:
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		break;
#line 5410 "math-buttons.c"
	}
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp15_ = number_new_integer ((gint64) 0);
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp16_ = number_new_integer ((gint64) 0);
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp17_ = number_new_integer ((gint64) 0);
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp18_ = number_new_integer ((gint64) 0);
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp19_[0] = _tmp15_;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp19_[1] = _tmp16_;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp19_[2] = _tmp17_;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp19_[3] = _tmp18_;
#line 890 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	memcpy (arg, _tmp19_, 4 * sizeof (Number*));
#line 5430 "math-buttons.c"
	{
		gint i = 0;
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		i = 0;
#line 5435 "math-buttons.c"
		{
			gboolean _tmp20_ = FALSE;
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp20_ = TRUE;
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			while (TRUE) {
#line 5442 "math-buttons.c"
				gint _tmp22_ = 0;
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				GtkEntry* entry = NULL;
				GtkBuilder* _tmp24_ = NULL;
				gchar** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				gint _tmp26_ = 0;
				const gchar* _tmp27_ = NULL;
				GObject* _tmp28_ = NULL;
				GtkEntry* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				GtkEntry* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				Number* _tmp33_ = NULL;
				Number* _tmp34_ = NULL;
				GtkEntry* _tmp35_ = NULL;
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				if (!_tmp20_) {
#line 5462 "math-buttons.c"
					gint _tmp21_ = 0;
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp21_ = i;
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					i = _tmp21_ + 1;
#line 5468 "math-buttons.c"
				}
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp20_ = FALSE;
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp22_ = i;
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp23_ = entries;
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp23__length1 = entries_length1;
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				if (!(_tmp22_ < _tmp23__length1)) {
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					break;
#line 5482 "math-buttons.c"
				}
#line 893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp24_ = self->priv->financial_ui;
#line 893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp25_ = entries;
#line 893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp25__length1 = entries_length1;
#line 893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp26_ = i;
#line 893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp27_ = _tmp25_[_tmp26_];
#line 893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp28_ = gtk_builder_get_object (_tmp24_, _tmp27_);
#line 893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp28_) : NULL);
#line 893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				entry = _tmp29_;
#line 894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp30_ = i;
#line 894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp31_ = entry;
#line 894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp32_ = gtk_entry_get_text (_tmp31_);
#line 894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp33_ = mp_set_from_string (_tmp32_, 10);
#line 894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_object_unref0 (arg[_tmp30_]);
#line 894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				arg[_tmp30_] = _tmp33_;
#line 894 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp34_ = arg[_tmp30_];
#line 895 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp35_ = entry;
#line 895 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				gtk_entry_set_text (_tmp35_, "0");
#line 891 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_object_unref0 (entry);
#line 5520 "math-buttons.c"
			}
		}
	}
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp36_ = self->priv->financial_ui;
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp37_ = entries;
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp37__length1 = entries_length1;
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp38_ = _tmp37_[0];
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp39_ = gtk_builder_get_object (_tmp36_, _tmp38_);
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp39_) : NULL);
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	first_entry = _tmp40_;
#line 898 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp41_ = first_entry;
#line 898 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp41_);
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp42_ = self->priv->equation;
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp43_ = function;
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp44_ = arg[0];
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp45_ = arg[1];
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp46_ = arg[2];
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp47_ = arg[3];
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	do_finc_expression (_tmp42_, _tmp43_, _tmp44_, _tmp45_, _tmp46_, _tmp47_);
#line 849 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (first_entry);
#line 849 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_vala_array_destroy (arg, 4, (GDestroyNotify) g_object_unref);
#line 849 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
#line 5562 "math-buttons.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 5580 "math-buttons.c"
}


static void math_buttons_character_code_dialog_response_cb (MathButtons* self, GtkWidget* dialog, gint response_id) {
	gchar* text = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkWidget* _tmp21_ = NULL;
#line 903 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 903 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (dialog != NULL);
#line 905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->character_code_entry;
#line 905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = gtk_entry_get_text (_tmp0_);
#line 905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 905 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	text = _tmp2_;
#line 907 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = response_id;
#line 907 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp3_ == ((gint) GTK_RESPONSE_OK)) {
#line 5607 "math-buttons.c"
		Number* x = NULL;
		Number* _tmp4_ = NULL;
		MathEquation* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp4_ = number_new_integer ((gint64) 0);
#line 909 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		x = _tmp4_;
#line 5616 "math-buttons.c"
		{
			gint i = 0;
#line 910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			i = 0;
#line 5621 "math-buttons.c"
			{
				gboolean _tmp5_ = FALSE;
#line 910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp5_ = TRUE;
#line 910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				while (TRUE) {
#line 5628 "math-buttons.c"
					const gchar* _tmp7_ = NULL;
					gint _tmp8_ = 0;
					gchar _tmp9_ = '\0';
					Number* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					gchar _tmp13_ = '\0';
					Number* _tmp14_ = NULL;
					Number* _tmp15_ = NULL;
					Number* _tmp16_ = NULL;
					Number* _tmp17_ = NULL;
					Number* _tmp18_ = NULL;
#line 910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					if (!_tmp5_) {
#line 5643 "math-buttons.c"
						gint _tmp6_ = 0;
#line 910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						_tmp6_ = i;
#line 910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						i = _tmp6_ + 1;
#line 5649 "math-buttons.c"
					}
#line 910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp5_ = FALSE;
#line 910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp7_ = text;
#line 910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp8_ = i;
#line 910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp9_ = string_get (_tmp7_, (glong) _tmp8_);
#line 910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					if (!(_tmp9_ != '\0')) {
#line 910 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
						break;
#line 5663 "math-buttons.c"
					}
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp10_ = x;
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp11_ = text;
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp12_ = i;
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp13_ = string_get (_tmp11_, (glong) _tmp12_);
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp14_ = number_new_integer ((gint64) _tmp13_);
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp15_ = _tmp14_;
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp16_ = number_add (_tmp10_, _tmp15_);
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_g_object_unref0 (x);
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					x = _tmp16_;
#line 912 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_g_object_unref0 (_tmp15_);
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp17_ = x;
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_tmp18_ = number_shift (_tmp17_, 8);
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					_g_object_unref0 (x);
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
					x = _tmp18_;
#line 5693 "math-buttons.c"
				}
			}
		}
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp19_ = self->priv->equation;
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp20_ = x;
#line 916 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		math_equation_insert_number (_tmp19_, _tmp20_);
#line 907 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_object_unref0 (x);
#line 5705 "math-buttons.c"
	}
#line 919 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp21_ = dialog;
#line 919 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_widget_hide (_tmp21_);
#line 903 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_free0 (text);
#line 5713 "math-buttons.c"
}


static void math_buttons_character_code_dialog_activate_cb (MathButtons* self, GtkWidget* entry) {
	GtkDialog* _tmp0_ = NULL;
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (entry != NULL);
#line 924 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->character_code_dialog;
#line 924 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_character_code_dialog_response_cb (self, (GtkWidget*) _tmp0_, (gint) GTK_RESPONSE_OK);
#line 5727 "math-buttons.c"
}


static gboolean math_buttons_character_code_dialog_delete_cb (MathButtons* self, GtkWidget* dialog, GdkEventAny* event) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
#line 927 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 927 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_val_if_fail (dialog != NULL, FALSE);
#line 927 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 929 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = dialog;
#line 929 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_character_code_dialog_response_cb (self, _tmp0_, (gint) GTK_RESPONSE_CANCEL);
#line 930 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	result = TRUE;
#line 930 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return result;
#line 5748 "math-buttons.c"
}


static gboolean math_buttons_bit_toggle_cb (MathButtons* self, GtkWidget* event_box, GdkEventButton* event) {
	gboolean result = FALSE;
	MathEquation* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_val_if_fail (event_box != NULL, FALSE);
#line 933 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->equation;
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = event_box;
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "bit_index");
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_equation_toggle_bit (_tmp0_, (guint) ((gint) ((gintptr) _tmp2_)));
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	result = TRUE;
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return result;
#line 5775 "math-buttons.c"
}


static void math_buttons_remove_trailing_spaces (MathButtons* self) {
	GtkTextMark* insert_mark = NULL;
	MathEquation* _tmp0_ = NULL;
	GtkTextMark* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	MathEquation* _tmp3_ = NULL;
	GtkTextMark* _tmp4_ = NULL;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	MathEquation* _tmp10_ = NULL;
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 941 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->equation;
#line 941 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) _tmp0_);
#line 941 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 941 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	insert_mark = _tmp2_;
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = self->priv->equation;
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp4_ = insert_mark;
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp3_, &_tmp5_, _tmp4_);
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	end = _tmp5_;
#line 944 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp6_ = end;
#line 944 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	start = _tmp6_;
#line 945 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	while (TRUE) {
#line 5815 "math-buttons.c"
		gboolean _tmp7_ = FALSE;
		gunichar _tmp8_ = 0U;
		gboolean _tmp9_ = FALSE;
#line 945 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp7_ = gtk_text_iter_backward_char (&start);
#line 945 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (!_tmp7_) {
#line 945 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 5825 "math-buttons.c"
		}
#line 947 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp8_ = gtk_text_iter_get_char (&start);
#line 947 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp9_ = g_unichar_isspace (_tmp8_);
#line 947 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (!_tmp9_) {
#line 949 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			gtk_text_iter_forward_char (&start);
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			break;
#line 5837 "math-buttons.c"
		}
	}
#line 953 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp10_ = self->priv->equation;
#line 953 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_text_buffer_delete ((GtkTextBuffer*) _tmp10_, &start, &end);
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (insert_mark);
#line 5846 "math-buttons.c"
}


static void math_buttons_set_superscript_cb (MathButtons* self, GtkButton* widget) {
	GtkToggleButton* button = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkToggleButton* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (widget != NULL);
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = widget;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_toggle_button_get_type ()) ? ((GtkToggleButton*) _tmp0_) : NULL);
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	button = _tmp1_;
#line 960 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = button;
#line 960 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = gtk_toggle_button_get_active (_tmp2_);
#line 960 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp3_) {
#line 5872 "math-buttons.c"
		MathEquation* _tmp4_ = NULL;
		MathEquation* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
#line 962 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp4_ = self->priv->equation;
#line 962 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		math_equation_set_number_mode (_tmp4_, NUMBER_MODE_SUPERSCRIPT);
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp5_ = self->priv->equation;
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp6_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp5_);
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp7_ = _tmp6_;
#line 963 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (!_tmp7_) {
#line 964 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			math_buttons_remove_trailing_spaces (self);
#line 5891 "math-buttons.c"
		}
	} else {
		MathEquation* _tmp8_ = NULL;
		NumberMode _tmp9_ = 0;
		NumberMode _tmp10_ = 0;
#line 966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp8_ = self->priv->equation;
#line 966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp9_ = math_equation_get_number_mode (_tmp8_);
#line 966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp10_ = _tmp9_;
#line 966 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp10_ == NUMBER_MODE_SUPERSCRIPT) {
#line 5905 "math-buttons.c"
			MathEquation* _tmp11_ = NULL;
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp11_ = self->priv->equation;
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			math_equation_set_number_mode (_tmp11_, NUMBER_MODE_NORMAL);
#line 5911 "math-buttons.c"
		}
	}
#line 956 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (button);
#line 5916 "math-buttons.c"
}


static void math_buttons_set_subscript_cb (MathButtons* self, GtkButton* widget) {
	GtkToggleButton* button = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkToggleButton* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (widget != NULL);
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = widget;
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_toggle_button_get_type ()) ? ((GtkToggleButton*) _tmp0_) : NULL);
#line 972 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	button = _tmp1_;
#line 974 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = button;
#line 974 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = gtk_toggle_button_get_active (_tmp2_);
#line 974 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp3_) {
#line 5942 "math-buttons.c"
		MathEquation* _tmp4_ = NULL;
		MathEquation* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
#line 976 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp4_ = self->priv->equation;
#line 976 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		math_equation_set_number_mode (_tmp4_, NUMBER_MODE_SUBSCRIPT);
#line 977 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp5_ = self->priv->equation;
#line 977 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp6_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp5_);
#line 977 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp7_ = _tmp6_;
#line 977 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (!_tmp7_) {
#line 978 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			math_buttons_remove_trailing_spaces (self);
#line 5961 "math-buttons.c"
		}
	} else {
		MathEquation* _tmp8_ = NULL;
		NumberMode _tmp9_ = 0;
		NumberMode _tmp10_ = 0;
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp8_ = self->priv->equation;
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp9_ = math_equation_get_number_mode (_tmp8_);
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp10_ = _tmp9_;
#line 980 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp10_ == NUMBER_MODE_SUBSCRIPT) {
#line 5975 "math-buttons.c"
			MathEquation* _tmp11_ = NULL;
#line 981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp11_ = self->priv->equation;
#line 981 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			math_equation_set_number_mode (_tmp11_, NUMBER_MODE_NORMAL);
#line 5981 "math-buttons.c"
		}
	}
#line 970 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (button);
#line 5986 "math-buttons.c"
}


static void math_buttons_number_mode_changed_cb (MathButtons* self) {
	NumberMode mode = 0;
	MathEquation* _tmp0_ = NULL;
	NumberMode _tmp1_ = 0;
	NumberMode _tmp2_ = 0;
	GList* _tmp3_ = NULL;
	GList* _tmp7_ = NULL;
#line 984 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 986 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->equation;
#line 986 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = math_equation_get_number_mode (_tmp0_);
#line 986 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = _tmp1_;
#line 986 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	mode = _tmp2_;
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = self->priv->superscript_toggles;
#line 6009 "math-buttons.c"
	{
		GList* toggle_collection = NULL;
		GList* toggle_it = NULL;
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		toggle_collection = _tmp3_;
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		for (toggle_it = toggle_collection; toggle_it != NULL; toggle_it = toggle_it->next) {
#line 6017 "math-buttons.c"
			GtkToggleButton* _tmp4_ = NULL;
			GtkToggleButton* toggle = NULL;
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp4_ = _g_object_ref0 ((GtkToggleButton*) toggle_it->data);
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			toggle = _tmp4_;
#line 6024 "math-buttons.c"
			{
				GtkToggleButton* _tmp5_ = NULL;
				NumberMode _tmp6_ = 0;
#line 988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp5_ = toggle;
#line 988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp6_ = mode;
#line 988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				gtk_toggle_button_set_active (_tmp5_, _tmp6_ == NUMBER_MODE_SUPERSCRIPT);
#line 987 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_object_unref0 (toggle);
#line 6036 "math-buttons.c"
			}
		}
	}
#line 989 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp7_ = self->priv->subscript_toggles;
#line 6042 "math-buttons.c"
	{
		GList* toggle_collection = NULL;
		GList* toggle_it = NULL;
#line 989 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		toggle_collection = _tmp7_;
#line 989 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		for (toggle_it = toggle_collection; toggle_it != NULL; toggle_it = toggle_it->next) {
#line 6050 "math-buttons.c"
			GtkToggleButton* _tmp8_ = NULL;
			GtkToggleButton* toggle = NULL;
#line 989 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp8_ = _g_object_ref0 ((GtkToggleButton*) toggle_it->data);
#line 989 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			toggle = _tmp8_;
#line 6057 "math-buttons.c"
			{
				GtkToggleButton* _tmp9_ = NULL;
				NumberMode _tmp10_ = 0;
#line 990 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp9_ = toggle;
#line 990 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_tmp10_ = mode;
#line 990 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				gtk_toggle_button_set_active (_tmp9_, _tmp10_ == NUMBER_MODE_SUBSCRIPT);
#line 989 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
				_g_object_unref0 (toggle);
#line 6069 "math-buttons.c"
			}
		}
	}
}


ButtonMode math_buttons_get_mode (MathButtons* self) {
	ButtonMode result;
	ButtonMode _tmp0_ = 0;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->_mode;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	result = _tmp0_;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return result;
#line 6087 "math-buttons.c"
}


void math_buttons_set_mode (MathButtons* self, ButtonMode value) {
	ButtonMode _tmp0_ = 0;
	ButtonMode _tmp1_ = 0;
	ButtonMode _tmp2_ = 0;
	ButtonMode _tmp3_ = 0;
	ButtonMode _tmp4_ = 0;
	gboolean _tmp8_ = FALSE;
	ButtonMode _tmp9_ = 0;
	ButtonMode _tmp10_ = 0;
	MathConverter* _tmp13_ = NULL;
	ButtonMode _tmp14_ = 0;
	ButtonMode _tmp15_ = 0;
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->_mode;
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = value;
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp0_ == _tmp1_) {
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		return;
#line 6113 "math-buttons.c"
	}
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = value;
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	self->priv->_mode = _tmp2_;
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = math_buttons_get_mode (self);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp4_ = _tmp3_;
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp4_ == BUTTON_MODE_PROGRAMMING) {
#line 6125 "math-buttons.c"
		MathEquation* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp5_ = self->priv->equation;
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp6_ = self->priv->_programming_base;
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		math_equation_set_number_base (_tmp5_, _tmp6_);
#line 6134 "math-buttons.c"
	} else {
		MathEquation* _tmp7_ = NULL;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp7_ = self->priv->equation;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		math_equation_set_number_base (_tmp7_, 10);
#line 6141 "math-buttons.c"
	}
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_load_buttons (self);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp9_ = math_buttons_get_mode (self);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp10_ = _tmp9_;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp10_ == BUTTON_MODE_ADVANCED) {
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp8_ = TRUE;
#line 6153 "math-buttons.c"
	} else {
		ButtonMode _tmp11_ = 0;
		ButtonMode _tmp12_ = 0;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp11_ = math_buttons_get_mode (self);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp12_ = _tmp11_;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp8_ = _tmp12_ == BUTTON_MODE_FINANCIAL;
#line 6163 "math-buttons.c"
	}
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp13_ = self->priv->converter;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp13_, _tmp8_);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp14_ = math_buttons_get_mode (self);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp15_ = _tmp14_;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp15_ == BUTTON_MODE_ADVANCED) {
#line 6175 "math-buttons.c"
		MathConverter* _tmp16_ = NULL;
		MathConverter* _tmp17_ = NULL;
		MathEquation* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		MathEquation* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp16_ = self->priv->converter;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		math_converter_set_category (_tmp16_, NULL);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp17_ = self->priv->converter;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp18_ = self->priv->equation;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp19_ = math_equation_get_source_units (_tmp18_);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp20_ = _tmp19_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp21_ = _tmp20_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp22_ = self->priv->equation;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp23_ = math_equation_get_target_units (_tmp22_);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp24_ = _tmp23_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp25_ = _tmp24_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		math_converter_set_conversion (_tmp17_, _tmp21_, _tmp25_);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_free0 (_tmp25_);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_g_free0 (_tmp21_);
#line 6214 "math-buttons.c"
	} else {
		ButtonMode _tmp26_ = 0;
		ButtonMode _tmp27_ = 0;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp26_ = math_buttons_get_mode (self);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp27_ = _tmp26_;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		if (_tmp27_ == BUTTON_MODE_FINANCIAL) {
#line 6224 "math-buttons.c"
			MathConverter* _tmp28_ = NULL;
			MathConverter* _tmp29_ = NULL;
			MathEquation* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			MathEquation* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp28_ = self->priv->converter;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			math_converter_set_category (_tmp28_, "currency");
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp29_ = self->priv->converter;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp30_ = self->priv->equation;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp31_ = math_equation_get_source_currency (_tmp30_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp32_ = _tmp31_;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp33_ = _tmp32_;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp34_ = self->priv->equation;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp35_ = math_equation_get_target_currency (_tmp34_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp36_ = _tmp35_;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_tmp37_ = _tmp36_;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			math_converter_set_conversion (_tmp29_, _tmp33_, _tmp37_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_free0 (_tmp37_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
			_g_free0 (_tmp33_);
#line 6263 "math-buttons.c"
		}
	}
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_object_notify ((GObject *) self, "mode");
#line 6268 "math-buttons.c"
}


gint math_buttons_get_programming_base (MathButtons* self) {
	gint result;
	gint _tmp0_ = 0;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->_programming_base;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	result = _tmp0_;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	return result;
#line 6283 "math-buttons.c"
}


void math_buttons_set_programming_base (MathButtons* self, gint value) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ButtonMode _tmp3_ = 0;
	ButtonMode _tmp4_ = 0;
#line 689 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_return_if_fail (self != NULL);
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp0_ = self->priv->_programming_base;
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp1_ = value;
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp0_ == _tmp1_) {
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		return;
#line 6303 "math-buttons.c"
	}
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp2_ = value;
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	self->priv->_programming_base = _tmp2_;
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp3_ = math_buttons_get_mode (self);
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_tmp4_ = _tmp3_;
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	if (_tmp4_ == BUTTON_MODE_PROGRAMMING) {
#line 6315 "math-buttons.c"
		MathEquation* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp5_ = self->priv->equation;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		_tmp6_ = value;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		math_equation_set_number_base (_tmp5_, _tmp6_);
#line 6324 "math-buttons.c"
	}
#line 689 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_object_notify ((GObject *) self, "programming-base");
#line 6328 "math-buttons.c"
}


static void math_buttons_class_init (MathButtonsClass * klass) {
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	math_buttons_parent_class = g_type_class_peek_parent (klass);
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_type_class_add_private (klass, sizeof (MathButtonsPrivate));
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_math_buttons_get_property;
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_math_buttons_set_property;
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	G_OBJECT_CLASS (klass)->finalize = math_buttons_finalize;
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_MODE, g_param_spec_enum ("mode", "mode", "mode", TYPE_BUTTON_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_PROGRAMMING_BASE, g_param_spec_int ("programming-base", "programming-base", "programming-base", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 6347 "math-buttons.c"
}


static void math_buttons_instance_init (MathButtons * self) {
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	self->priv = MATH_BUTTONS_GET_PRIVATE (self);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	self->priv->_programming_base = 10;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	self->priv->active_panel = NULL;
#line 6358 "math-buttons.c"
}


static void math_buttons_finalize (GObject* obj) {
	MathButtons * self;
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_BUTTONS, MathButtons);
#line 21 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->equation);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->converter);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->basic_ui);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->advanced_ui);
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->financial_ui);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->programming_ui);
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->bas_panel);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->adv_panel);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->fin_panel);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->prog_panel);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->active_panel);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->shift_left_menu);
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->shift_right_menu);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	__g_list_free__g_object_unref0_0 (self->priv->superscript_toggles);
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	__g_list_free__g_object_unref0_0 (self->priv->subscript_toggles);
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->base_combo);
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->base_label);
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->bit_panel);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	__g_list_free__g_object_unref0_0 (self->priv->bit_labels);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->character_code_dialog);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	_g_object_unref0 (self->priv->character_code_entry);
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	G_OBJECT_CLASS (math_buttons_parent_class)->finalize (obj);
#line 6410 "math-buttons.c"
}


GType math_buttons_get_type (void) {
	static volatile gsize math_buttons_type_id__volatile = 0;
	if (g_once_init_enter (&math_buttons_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathButtonsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_buttons_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathButtons), 0, (GInstanceInitFunc) math_buttons_instance_init, NULL };
		GType math_buttons_type_id;
		math_buttons_type_id = g_type_register_static (gtk_box_get_type (), "MathButtons", &g_define_type_info, 0);
		g_once_init_leave (&math_buttons_type_id__volatile, math_buttons_type_id);
	}
	return math_buttons_type_id__volatile;
}


static void _vala_math_buttons_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	switch (property_id) {
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case MATH_BUTTONS_MODE:
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_value_set_enum (value, math_buttons_get_mode (self));
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		break;
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case MATH_BUTTONS_PROGRAMMING_BASE:
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		g_value_set_int (value, math_buttons_get_programming_base (self));
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		break;
#line 6443 "math-buttons.c"
		default:
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		break;
#line 6449 "math-buttons.c"
	}
}


static void _vala_math_buttons_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
	switch (property_id) {
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case MATH_BUTTONS_MODE:
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		math_buttons_set_mode (self, g_value_get_enum (value));
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		break;
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		case MATH_BUTTONS_PROGRAMMING_BASE:
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		math_buttons_set_programming_base (self, g_value_get_int (value));
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		break;
#line 6471 "math-buttons.c"
		default:
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 19 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/math-buttons.vala"
		break;
#line 6477 "math-buttons.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



