#! /usr/bin/env python

# Copyright (C) 2006 Intel Corporation
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, see <http://www.gnu.org/licenses/>.
#
# Author: Ross Burton <ross@openedhand.com>

import sys

if sys.version_info[0] >= 3:
    stdin = sys.stdin.buffer
    stdout = sys.stdout.buffer
else:
    stdin = sys.stdin
    stdout = sys.stdout

var = None
strings = []

def output():
    stdout.write(b"static const gchar " + var + b"_table[] = {\n")
    for s in strings:
        stdout.write(b"  \"" + s + b"\\0\"\n")
    stdout.write(b"};\n")

    stdout.write(b"static const guint " + var + b"_index[] = {\n")
    index = 0
    for s in strings:
        stdout.write(b"  " + str(index).encode() + b",\n")
        index += len(s) + 1
    stdout.write(b"};\n\n")
    
(S_VAR, S_STRING) = range(0, 2)
state = S_VAR

stdout.write(b"/* This file is generated by gen-western-table.py. DO NOT EDIT */\n")

for l in stdin.readlines():
    l = l.strip()
    if l == b"":
        state = S_VAR
        output()
        var = None
        strings = []
    elif state == S_VAR:
        var = l
        state = S_STRING
    elif state == S_STRING:
        strings.append(l)

output()
