/* gweather-version.h - libgweather versioning information
 *
 * This file is part of libgweather
 * Copyright (C) 2014  Javier Jardón <jjardon@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Based on json-version from json-glib
 * Authored by Emmanuele Bassi <ebassi@gnome.org>
 * Adapted for libgweather by Javier Jardón <jjardon@gnome.org>
 */

#ifndef __GWEATHER_VERSION_H__
#define __GWEATHER_VERSION_H__

/**
 * SECTION:gweatherversion
 * @short_description: libgweather version checking
 *
 * LibGweather provides macros to check the version of the library
 * at compile-time
 */

/**
 * GWEATHER_MAJOR_VERSION:
 *
 * LibGweather major version component (e.g. 1 if %GWEATHER_VERSION is 1.2.3)
 *
 * Since: 3.12
 */
#define GWEATHER_MAJOR_VERSION              (3)

/**
 * GWEATHER_MINOR_VERSION:
 *
 * LibGweather minor version component (e.g. 2 if %GWEATHER_VERSION is 1.2.3)
 *
 * Since: 3.12
 */
#define GWEATHER_MINOR_VERSION              (13)

/**
 * GWEATHER_MICRO_VERSION:
 *
 * LibGweather micro version component (e.g. 3 if %GWEATHER_VERSION is 1.2.3)
 *
 * Since: 3.12
 */
#define GWEATHER_MICRO_VERSION              (91)

/**
 * GWEATHER_VERSION
 *
 * LibGweather version.
 *
 * Since: 3.12
 */
#define GWEATHER_VERSION                    (3.13.91)

/**
 * GWEATHER_VERSION_S:
 *
 * LibGweather version, encoded as a string, useful for printing and
 * concatenation.
 *
 * Since: 3.12
 */
#define GWEATHER_VERSION_S                  "3.13.91"

/**
 * GWEATHER_VERSION_HEX:
 *
 * LibGweather version, encoded as an hexadecimal number, useful for
 * integer comparisons.
 *
 * Since: 3.12
 */
#define GWEATHER_VERSION_HEX                (GWEATHER_MAJOR_VERSION << 24 | \
                                             GWEATHER_MINOR_VERSION << 16 | \
                                             GWEATHER_MICRO_VERSION << 8)

/**
 * GWEATHER_CHECK_VERSION:
 * @major: required major version
 * @minor: required minor version
 * @micro: required micro version
 *
 * Compile-time version checking. Evaluates to %TRUE if the version
 * of LibGweather is greater than the required one.
 *
 * Since: 3.12
 */
#define GWEATHER_CHECK_VERSION(major,minor,micro)   \
        (GWEATHER_MAJOR_VERSION > (major) || \
         (GWEATHER_MAJOR_VERSION == (major) && GWEATHER_MINOR_VERSION > (minor)) || \
         (GWEATHER_MAJOR_VERSION == (major) && GWEATHER_MINOR_VERSION == (minor) && \
          GWEATHER_MICRO_VERSION >= (micro)))

#endif /* __GWEATHER_VERSION_H__ */
