// -*- c++ -*-
// Generated by gmmproc 2.41.2 -- DO NOT MODIFY!
#ifndef _GDKMM_WINDOW_H
#define _GDKMM_WINDOW_H

#include <gdkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright(C) 1998-2010 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glibmm/object.h>
#include <gdkmm/dragcontext.h>
#include <gdkmm/types.h>
#include <cairomm/region.h>
#include <cairomm/pattern.h>
#include <gdkmm/device.h>
#include <gdkmm/visual.h>
#include <gdkmm/rgba.h>
#include <cairomm/context.h>
#include <gdk/gdk.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class Window_Class; } // namespace Gdk
namespace Gdk
{

/** @addtogroup gdkmmEnums gdkmm Enums and Flags */

/** 
 *  @var WindowState WINDOW_STATE_WITHDRAWN
 *  The window is not shown.
 * 
 *  @var WindowState WINDOW_STATE_ICONIFIED
 *  The window is minimized.
 * 
 *  @var WindowState WINDOW_STATE_MAXIMIZED
 *  The window is maximized.
 * 
 *  @var WindowState WINDOW_STATE_STICKY
 *  The window is sticky.
 * 
 *  @var WindowState WINDOW_STATE_FULLSCREEN
 *  The window is maximized without decorations.
 * 
 *  @var WindowState WINDOW_STATE_ABOVE
 *  The window is kept above other windows.
 * 
 *  @var WindowState WINDOW_STATE_BELOW
 *  The window is kept below other windows.
 * 
 *  @var WindowState WINDOW_STATE_FOCUSED
 *  The window is presented as focused (with active decorations).
 * 
 *  @var WindowState WINDOW_STATE_TILED
 *  The window is in a tiled state, Since 3.10.
 * 
 *  @enum WindowState
 * 
 * Specifies the state of a toplevel window.
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%WindowState operator|(WindowState, WindowState)</tt><br>
 * <tt>%WindowState operator&(WindowState, WindowState)</tt><br>
 * <tt>%WindowState operator^(WindowState, WindowState)</tt><br>
 * <tt>%WindowState operator~(WindowState)</tt><br>
 * <tt>%WindowState& operator|=(WindowState&, WindowState)</tt><br>
 * <tt>%WindowState& operator&=(WindowState&, WindowState)</tt><br>
 * <tt>%WindowState& operator^=(WindowState&, WindowState)</tt><br>
 */
enum WindowState
{
  WINDOW_STATE_WITHDRAWN = 1 << 0,
  WINDOW_STATE_ICONIFIED = 1 << 1,
  WINDOW_STATE_MAXIMIZED = 1 << 2,
  WINDOW_STATE_STICKY = 1 << 3,
  WINDOW_STATE_FULLSCREEN = 1 << 4,
  WINDOW_STATE_ABOVE = 1 << 5,
  WINDOW_STATE_BELOW = 1 << 6,
  WINDOW_STATE_FOCUSED = 1 << 7,
  WINDOW_STATE_TILED = 1 << 8
};

/** @ingroup gdkmmEnums */
inline WindowState operator|(WindowState lhs, WindowState rhs)
  { return static_cast<WindowState>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowState operator&(WindowState lhs, WindowState rhs)
  { return static_cast<WindowState>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowState operator^(WindowState lhs, WindowState rhs)
  { return static_cast<WindowState>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowState operator~(WindowState flags)
  { return static_cast<WindowState>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline WindowState& operator|=(WindowState& lhs, WindowState rhs)
  { return (lhs = static_cast<WindowState>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WindowState& operator&=(WindowState& lhs, WindowState rhs)
  { return (lhs = static_cast<WindowState>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WindowState& operator^=(WindowState& lhs, WindowState rhs)
  { return (lhs = static_cast<WindowState>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowState> : public Glib::Value_Flags<Gdk::WindowState>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/** 
 *  @var WindowType WINDOW_ROOT
 *  Root window; this window has no parent, covers the entire screen, and is created by the window system.
 * 
 *  @var WindowType WINDOW_TOPLEVEL
 *  Toplevel window (used to implement Gtk::Window).
 * 
 *  @var WindowType WINDOW_CHILD
 *  Child window (used to implement e.g. Gtk::Entry).
 * 
 *  @var WindowType WINDOW_TEMP
 *  Override redirect temporary window (used to implement Gtk::Menu).
 * 
 *  @var WindowType WINDOW_FOREIGN
 *  Foreign window (see gdk_window_foreign_new()).
 * 
 *  @var WindowType WINDOW_OFFSCREEN
 *  Offscreen window (see [Offscreen Windows][OFFSCREEN-WINDOWS]). Since 2.18.
 * 
 *  @enum WindowType
 * 
 * Describes the kind of window.
 * @ingroup gdkmmEnums
 */
enum WindowType
{
  WINDOW_ROOT,
  WINDOW_TOPLEVEL,
  WINDOW_CHILD,
  WINDOW_TEMP,
  WINDOW_FOREIGN,
  WINDOW_OFFSCREEN
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowType> : public Glib::Value_Enum<Gdk::WindowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/** 
 *  @var WindowAttributesType WA_TITLE
 *  Honor the title field.
 * 
 *  @var WindowAttributesType WA_X
 *  Honor the X coordinate field.
 * 
 *  @var WindowAttributesType WA_Y
 *  Honor the Y coordinate field.
 * 
 *  @var WindowAttributesType WA_CURSOR
 *  Honor the cursor field.
 * 
 *  @var WindowAttributesType WA_VISUAL
 *  Honor the visual field.
 * 
 *  @var WindowAttributesType WA_WMCLASS
 *  Honor the wmclass_class and wmclass_name fields.
 * 
 *  @var WindowAttributesType WA_NOREDIR
 *  Honor the override_redirect field.
 * 
 *  @var WindowAttributesType WA_TYPE_HINT
 *  Honor the type_hint field.
 * 
 *  @enum WindowAttributesType
 * 
 * Used to indicate which fields in the Gdk::WindowAttr struct should be honored.
 * For example, if you filled in the “cursor” and “x” fields of Gdk::WindowAttr,
 * pass “ @a GDK_WA_X | @a GDK_WA_CURSOR” to Gdk::Window::new(). Fields in
 * Gdk::WindowAttr not covered by a bit in this enum are required; for example,
 * the @a width/ @a height, @a wclass, and @a window_type fields are required, they have
 * no corresponding flag in Gdk::WindowAttributesType.
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%WindowAttributesType operator|(WindowAttributesType, WindowAttributesType)</tt><br>
 * <tt>%WindowAttributesType operator&(WindowAttributesType, WindowAttributesType)</tt><br>
 * <tt>%WindowAttributesType operator^(WindowAttributesType, WindowAttributesType)</tt><br>
 * <tt>%WindowAttributesType operator~(WindowAttributesType)</tt><br>
 * <tt>%WindowAttributesType& operator|=(WindowAttributesType&, WindowAttributesType)</tt><br>
 * <tt>%WindowAttributesType& operator&=(WindowAttributesType&, WindowAttributesType)</tt><br>
 * <tt>%WindowAttributesType& operator^=(WindowAttributesType&, WindowAttributesType)</tt><br>
 */
enum WindowAttributesType
{
  WA_TITLE = 1 << 1,
  WA_X = 1 << 2,
  WA_Y = 1 << 3,
  WA_CURSOR = 1 << 4,
  WA_VISUAL = 1 << 5,
  WA_WMCLASS = 1 << 6,
  WA_NOREDIR = 1 << 7,
  WA_TYPE_HINT = 1 << 8
};

/** @ingroup gdkmmEnums */
inline WindowAttributesType operator|(WindowAttributesType lhs, WindowAttributesType rhs)
  { return static_cast<WindowAttributesType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowAttributesType operator&(WindowAttributesType lhs, WindowAttributesType rhs)
  { return static_cast<WindowAttributesType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowAttributesType operator^(WindowAttributesType lhs, WindowAttributesType rhs)
  { return static_cast<WindowAttributesType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowAttributesType operator~(WindowAttributesType flags)
  { return static_cast<WindowAttributesType>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline WindowAttributesType& operator|=(WindowAttributesType& lhs, WindowAttributesType rhs)
  { return (lhs = static_cast<WindowAttributesType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WindowAttributesType& operator&=(WindowAttributesType& lhs, WindowAttributesType rhs)
  { return (lhs = static_cast<WindowAttributesType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WindowAttributesType& operator^=(WindowAttributesType& lhs, WindowAttributesType rhs)
  { return (lhs = static_cast<WindowAttributesType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowAttributesType> : public Glib::Value_Flags<Gdk::WindowAttributesType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/** 
 *  @var WindowHints HINT_POS
 *  Indicates that the program has positioned the window.
 * 
 *  @var WindowHints HINT_MIN_SIZE
 *  Min size fields are set.
 * 
 *  @var WindowHints HINT_MAX_SIZE
 *  Max size fields are set.
 * 
 *  @var WindowHints HINT_BASE_SIZE
 *  Base size fields are set.
 * 
 *  @var WindowHints HINT_ASPECT
 *  Aspect ratio fields are set.
 * 
 *  @var WindowHints HINT_RESIZE_INC
 *  Resize increment fields are set.
 * 
 *  @var WindowHints HINT_WIN_GRAVITY
 *  Window gravity field is set.
 * 
 *  @var WindowHints HINT_USER_POS
 *  Indicates that the window’s position was explicitly set by the user.
 * 
 *  @var WindowHints HINT_USER_SIZE
 *  Indicates that the window’s size was explicitly set by the user.
 * 
 *  @enum WindowHints
 * 
 * Used to indicate which fields of a Gdk::Geometry struct should be paid
 * attention to. Also, the presence/absence of @a GDK_HINT_POS,
 *  @a GDK_HINT_USER_POS, and @a GDK_HINT_USER_SIZE is significant, though they don't
 * directly refer to Gdk::Geometry fields. @a GDK_HINT_USER_POS will be set
 * automatically by Gtk::Window if you call gtk_window_move().
 *  @a GDK_HINT_USER_POS and @a GDK_HINT_USER_SIZE should be set if the user
 * specified a size/position using a --geometry command-line argument;
 * gtk_window_parse_geometry() automatically sets these flags.
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%WindowHints operator|(WindowHints, WindowHints)</tt><br>
 * <tt>%WindowHints operator&(WindowHints, WindowHints)</tt><br>
 * <tt>%WindowHints operator^(WindowHints, WindowHints)</tt><br>
 * <tt>%WindowHints operator~(WindowHints)</tt><br>
 * <tt>%WindowHints& operator|=(WindowHints&, WindowHints)</tt><br>
 * <tt>%WindowHints& operator&=(WindowHints&, WindowHints)</tt><br>
 * <tt>%WindowHints& operator^=(WindowHints&, WindowHints)</tt><br>
 */
enum WindowHints
{
  HINT_POS = 1 << 0,
  HINT_MIN_SIZE = 1 << 1,
  HINT_MAX_SIZE = 1 << 2,
  HINT_BASE_SIZE = 1 << 3,
  HINT_ASPECT = 1 << 4,
  HINT_RESIZE_INC = 1 << 5,
  HINT_WIN_GRAVITY = 1 << 6,
  HINT_USER_POS = 1 << 7,
  HINT_USER_SIZE = 1 << 8
};

/** @ingroup gdkmmEnums */
inline WindowHints operator|(WindowHints lhs, WindowHints rhs)
  { return static_cast<WindowHints>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowHints operator&(WindowHints lhs, WindowHints rhs)
  { return static_cast<WindowHints>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowHints operator^(WindowHints lhs, WindowHints rhs)
  { return static_cast<WindowHints>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WindowHints operator~(WindowHints flags)
  { return static_cast<WindowHints>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline WindowHints& operator|=(WindowHints& lhs, WindowHints rhs)
  { return (lhs = static_cast<WindowHints>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WindowHints& operator&=(WindowHints& lhs, WindowHints rhs)
  { return (lhs = static_cast<WindowHints>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WindowHints& operator^=(WindowHints& lhs, WindowHints rhs)
  { return (lhs = static_cast<WindowHints>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowHints> : public Glib::Value_Flags<Gdk::WindowHints>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/** 
 *  @var WindowTypeHint WINDOW_TYPE_HINT_NORMAL
 *  Normal toplevel window.
 * 
 *  @var WindowTypeHint WINDOW_TYPE_HINT_DIALOG
 *  Dialog window.
 * 
 *  @var WindowTypeHint WINDOW_TYPE_HINT_MENU
 *  Window used to implement a menu; GTK+ uses this hint only for torn-off menus, see Gtk::TearoffMenuItem.
 * 
 *  @var WindowTypeHint WINDOW_TYPE_HINT_TOOLBAR
 *  Window used to implement toolbars.
 * 
 *  @var WindowTypeHint WINDOW_TYPE_HINT_SPLASHSCREEN
 *  Window used to display a splash screen during application startup.
 * 
 *  @var WindowTypeHint WINDOW_TYPE_HINT_UTILITY
 *  Utility windows which are not detached toolbars or dialogs.
 * 
 *  @var WindowTypeHint WINDOW_TYPE_HINT_DOCK
 *  Used for creating dock or panel windows.
 * 
 *  @var WindowTypeHint WINDOW_TYPE_HINT_DESKTOP
 *  Used for creating the desktop background window.
 * 
 *  @var WindowTypeHint WINDOW_TYPE_HINT_DROPDOWN_MENU
 *  A menu that belongs to a menubar.
 * 
 *  @var WindowTypeHint WINDOW_TYPE_HINT_POPUP_MENU
 *  A menu that does not belong to a menubar, e.g. a context menu.
 * 
 *  @var WindowTypeHint WINDOW_TYPE_HINT_TOOLTIP
 *  A tooltip.
 * 
 *  @var WindowTypeHint WINDOW_TYPE_HINT_NOTIFICATION
 *  A notification - typically a “bubble” that belongs to a status icon.
 * 
 *  @var WindowTypeHint WINDOW_TYPE_HINT_COMBO
 *  A popup from a combo box.
 * 
 *  @var WindowTypeHint WINDOW_TYPE_HINT_DND
 *  A window that is used to implement a DND cursor.
 * 
 *  @enum WindowTypeHint
 * 
 * These are hints for the window manager that indicate what type of function
 * the window has. The window manager can use this when determining decoration
 * and behaviour of the window. The hint must be set before mapping the window.
 * 
 * See the [Extended Window Manager Hints](http://www.freedesktop.org/Standards/wm-spec)
 * specification for more details about window types.
 * @ingroup gdkmmEnums
 */
enum WindowTypeHint
{
  WINDOW_TYPE_HINT_NORMAL,
  WINDOW_TYPE_HINT_DIALOG,
  WINDOW_TYPE_HINT_MENU,
  WINDOW_TYPE_HINT_TOOLBAR,
  WINDOW_TYPE_HINT_SPLASHSCREEN,
  WINDOW_TYPE_HINT_UTILITY,
  WINDOW_TYPE_HINT_DOCK,
  WINDOW_TYPE_HINT_DESKTOP,
  WINDOW_TYPE_HINT_DROPDOWN_MENU,
  WINDOW_TYPE_HINT_POPUP_MENU,
  WINDOW_TYPE_HINT_TOOLTIP,
  WINDOW_TYPE_HINT_NOTIFICATION,
  WINDOW_TYPE_HINT_COMBO,
  WINDOW_TYPE_HINT_DND
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowTypeHint> : public Glib::Value_Enum<Gdk::WindowTypeHint>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/** 
 *  @var WMDecoration DECOR_ALL
 *  All decorations should be applied.
 * 
 *  @var WMDecoration DECOR_BORDER
 *  A frame should be drawn around the window.
 * 
 *  @var WMDecoration DECOR_RESIZEH
 *  The frame should have resize handles.
 * 
 *  @var WMDecoration DECOR_TITLE
 *  A titlebar should be placed above the window.
 * 
 *  @var WMDecoration DECOR_MENU
 *  A button for opening a menu should be included.
 * 
 *  @var WMDecoration DECOR_MINIMIZE
 *  A minimize button should be included.
 * 
 *  @var WMDecoration DECOR_MAXIMIZE
 *  A maximize button should be included.
 * 
 *  @enum WMDecoration
 * 
 * These are hints originally defined by the Motif toolkit.
 * The window manager can use them when determining how to decorate
 * the window. The hint must be set before mapping the window.
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%WMDecoration operator|(WMDecoration, WMDecoration)</tt><br>
 * <tt>%WMDecoration operator&(WMDecoration, WMDecoration)</tt><br>
 * <tt>%WMDecoration operator^(WMDecoration, WMDecoration)</tt><br>
 * <tt>%WMDecoration operator~(WMDecoration)</tt><br>
 * <tt>%WMDecoration& operator|=(WMDecoration&, WMDecoration)</tt><br>
 * <tt>%WMDecoration& operator&=(WMDecoration&, WMDecoration)</tt><br>
 * <tt>%WMDecoration& operator^=(WMDecoration&, WMDecoration)</tt><br>
 */
enum WMDecoration
{
  DECOR_ALL = 1 << 0,
  DECOR_BORDER = 1 << 1,
  DECOR_RESIZEH = 1 << 2,
  DECOR_TITLE = 1 << 3,
  DECOR_MENU = 1 << 4,
  DECOR_MINIMIZE = 1 << 5,
  DECOR_MAXIMIZE = 1 << 6
};

/** @ingroup gdkmmEnums */
inline WMDecoration operator|(WMDecoration lhs, WMDecoration rhs)
  { return static_cast<WMDecoration>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMDecoration operator&(WMDecoration lhs, WMDecoration rhs)
  { return static_cast<WMDecoration>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMDecoration operator^(WMDecoration lhs, WMDecoration rhs)
  { return static_cast<WMDecoration>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMDecoration operator~(WMDecoration flags)
  { return static_cast<WMDecoration>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline WMDecoration& operator|=(WMDecoration& lhs, WMDecoration rhs)
  { return (lhs = static_cast<WMDecoration>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WMDecoration& operator&=(WMDecoration& lhs, WMDecoration rhs)
  { return (lhs = static_cast<WMDecoration>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WMDecoration& operator^=(WMDecoration& lhs, WMDecoration rhs)
  { return (lhs = static_cast<WMDecoration>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WMDecoration> : public Glib::Value_Flags<Gdk::WMDecoration>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/** 
 *  @var WMFunction FUNC_ALL
 *  All functions should be offered.
 * 
 *  @var WMFunction FUNC_RESIZE
 *  The window should be resizable.
 * 
 *  @var WMFunction FUNC_MOVE
 *  The window should be movable.
 * 
 *  @var WMFunction FUNC_MINIMIZE
 *  The window should be minimizable.
 * 
 *  @var WMFunction FUNC_MAXIMIZE
 *  The window should be maximizable.
 * 
 *  @var WMFunction FUNC_CLOSE
 *  The window should be closable.
 * 
 *  @enum WMFunction
 * 
 * These are hints originally defined by the Motif toolkit. The window manager
 * can use them when determining the functions to offer for the window. The
 * hint must be set before mapping the window.
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%WMFunction operator|(WMFunction, WMFunction)</tt><br>
 * <tt>%WMFunction operator&(WMFunction, WMFunction)</tt><br>
 * <tt>%WMFunction operator^(WMFunction, WMFunction)</tt><br>
 * <tt>%WMFunction operator~(WMFunction)</tt><br>
 * <tt>%WMFunction& operator|=(WMFunction&, WMFunction)</tt><br>
 * <tt>%WMFunction& operator&=(WMFunction&, WMFunction)</tt><br>
 * <tt>%WMFunction& operator^=(WMFunction&, WMFunction)</tt><br>
 */
enum WMFunction
{
  FUNC_ALL = 1 << 0,
  FUNC_RESIZE = 1 << 1,
  FUNC_MOVE = 1 << 2,
  FUNC_MINIMIZE = 1 << 3,
  FUNC_MAXIMIZE = 1 << 4,
  FUNC_CLOSE = 1 << 5
};

/** @ingroup gdkmmEnums */
inline WMFunction operator|(WMFunction lhs, WMFunction rhs)
  { return static_cast<WMFunction>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMFunction operator&(WMFunction lhs, WMFunction rhs)
  { return static_cast<WMFunction>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMFunction operator^(WMFunction lhs, WMFunction rhs)
  { return static_cast<WMFunction>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline WMFunction operator~(WMFunction flags)
  { return static_cast<WMFunction>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline WMFunction& operator|=(WMFunction& lhs, WMFunction rhs)
  { return (lhs = static_cast<WMFunction>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WMFunction& operator&=(WMFunction& lhs, WMFunction rhs)
  { return (lhs = static_cast<WMFunction>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline WMFunction& operator^=(WMFunction& lhs, WMFunction rhs)
  { return (lhs = static_cast<WMFunction>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WMFunction> : public Glib::Value_Flags<Gdk::WMFunction>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/** 
 *  @var WindowEdge WINDOW_EDGE_NORTH_WEST
 *  The top left corner.
 * 
 *  @var WindowEdge WINDOW_EDGE_NORTH
 *  The top edge.
 * 
 *  @var WindowEdge WINDOW_EDGE_NORTH_EAST
 *  The top right corner.
 * 
 *  @var WindowEdge WINDOW_EDGE_WEST
 *  The left edge.
 * 
 *  @var WindowEdge WINDOW_EDGE_EAST
 *  The right edge.
 * 
 *  @var WindowEdge WINDOW_EDGE_SOUTH_WEST
 *  The lower left corner.
 * 
 *  @var WindowEdge WINDOW_EDGE_SOUTH
 *  The lower edge.
 * 
 *  @var WindowEdge WINDOW_EDGE_SOUTH_EAST
 *  The lower right corner.
 * 
 *  @enum WindowEdge
 * 
 * Determines a window edge or corner.
 * @ingroup gdkmmEnums
 */
enum WindowEdge
{
  WINDOW_EDGE_NORTH_WEST,
  WINDOW_EDGE_NORTH,
  WINDOW_EDGE_NORTH_EAST,
  WINDOW_EDGE_WEST,
  WINDOW_EDGE_EAST,
  WINDOW_EDGE_SOUTH_WEST,
  WINDOW_EDGE_SOUTH,
  WINDOW_EDGE_SOUTH_EAST
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::WindowEdge> : public Glib::Value_Enum<Gdk::WindowEdge>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/** 
 *  @var Gravity GRAVITY_NORTH_WEST
 *  The reference point is at the top left corner.
 * 
 *  @var Gravity GRAVITY_NORTH
 *  The reference point is in the middle of the top edge.
 * 
 *  @var Gravity GRAVITY_NORTH_EAST
 *  The reference point is at the top right corner.
 * 
 *  @var Gravity GRAVITY_WEST
 *  The reference point is at the middle of the left edge.
 * 
 *  @var Gravity GRAVITY_CENTER
 *  The reference point is at the center of the window.
 * 
 *  @var Gravity GRAVITY_EAST
 *  The reference point is at the middle of the right edge.
 * 
 *  @var Gravity GRAVITY_SOUTH_WEST
 *  The reference point is at the lower left corner.
 * 
 *  @var Gravity GRAVITY_SOUTH
 *  The reference point is at the middle of the lower edge.
 * 
 *  @var Gravity GRAVITY_SOUTH_EAST
 *  The reference point is at the lower right corner.
 * 
 *  @var Gravity GRAVITY_STATIC
 *  The reference point is at the top left corner of the window itself, ignoring window manager decorations.
 * 
 *  @enum Gravity
 * 
 * Defines the reference point of a window and the meaning of coordinates
 * passed to gtk_window_move(). See gtk_window_move() and the "implementation
 * notes" section of the
 * [Extended Window Manager Hints](http://www.freedesktop.org/Standards/wm-spec)
 * specification for more details.
 * @ingroup gdkmmEnums
 */
enum Gravity
{
  GRAVITY_NORTH_WEST = 1,
  GRAVITY_NORTH,
  GRAVITY_NORTH_EAST,
  GRAVITY_WEST,
  GRAVITY_CENTER,
  GRAVITY_EAST,
  GRAVITY_SOUTH_WEST,
  GRAVITY_SOUTH,
  GRAVITY_SOUTH_EAST,
  GRAVITY_STATIC
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Gravity> : public Glib::Value_Enum<Gdk::Gravity>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/** 
 *  @var FullscreenMode FULLSCREEN_ON_CURRENT_MONITOR
 *  Fullscreen on current monitor only.
 * 
 *  @var FullscreenMode FULLSCREEN_ON_ALL_MONITORS
 *  Span across all monitors when fullscreen.
 * 
 *  @enum FullscreenMode
 * 
 * Indicates which monitor (in a multi-head setup) a window should span over
 * when in fullscreen mode.
 * 
 * @newin{3,8}
 * @ingroup gdkmmEnums
 */
enum FullscreenMode
{
  FULLSCREEN_ON_CURRENT_MONITOR,
  FULLSCREEN_ON_ALL_MONITORS
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::FullscreenMode> : public Glib::Value_Enum<Gdk::FullscreenMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


class Cursor;
class Pixbuf;

/** A Gdk::Window is a rectangular region on the screen. It's a low-level object, used to implement high-level objects such
 * as Gtk::Widget and Gtk::Window on the GTK+ level. A Gtk::Window is a toplevel window, the thing a user might think of as
 * a "window" with a titlebar and so on; a Gtk::Window may contain many Gdk::Windows. For example, each Gtk::Button has a
 * Gdk::Window associated with it.
 */

class Window : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Window CppObjectType;
  typedef Window_Class CppClassType;
  typedef GdkWindow BaseObjectType;
  typedef GdkWindowClass BaseClassType;

private:  friend class Window_Class;
  static CppClassType window_class_;

private:
  // noncopyable
  Window(const Window&);
  Window& operator=(const Window&);

protected:
  explicit Window(const Glib::ConstructParams& construct_params);
  explicit Window(GdkWindow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Window();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkWindow*       gobj()       { return reinterpret_cast<GdkWindow*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkWindow* gobj() const { return reinterpret_cast<GdkWindow*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkWindow* gobj_copy();

private:

  
protected:
  Window(const Glib::RefPtr<Window>& parent, GdkWindowAttr* attributes, int attributes_mask);

public:
  
  static Glib::RefPtr<Window> create(const Glib::RefPtr<Window>& parent, GdkWindowAttr* attributes, int attributes_mask);


  /** Gets the type of the window. See Gdk::WindowType.
   * 
   * @return Type of window.
   */
  WindowType get_window_type() const;

  
  /** Gets the Gdk::Visual describing the pixel format of @a window.
   * 
   * @newin{2,24}
   * 
   * @return A Gdk::Visual.
   */
  Glib::RefPtr<Visual> get_visual();
  
  /** Gets the Gdk::Visual describing the pixel format of @a window.
   * 
   * @newin{2,24}
   * 
   * @return A Gdk::Visual.
   */
  Glib::RefPtr<const Visual> get_visual() const;

  
  /** Gets the Gdk::Screen associated with a Gdk::Window.
   * 
   * @newin{2,24}
   * 
   * @return The Gdk::Screen associated with @a window.
   */
  Glib::RefPtr<Screen> get_screen();
  
  /** Gets the Gdk::Screen associated with a Gdk::Window.
   * 
   * @newin{2,24}
   * 
   * @return The Gdk::Screen associated with @a window.
   */
  Glib::RefPtr<const Screen> get_screen() const;

  
  /** Gets the Gdk::Display associated with a Gdk::Window.
   * 
   * @newin{2,24}
   * 
   * @return The Gdk::Display associated with @a window.
   */
  Glib::RefPtr<Display> get_display();
  
  /** Gets the Gdk::Display associated with a Gdk::Window.
   * 
   * @newin{2,24}
   * 
   * @return The Gdk::Display associated with @a window.
   */
  Glib::RefPtr<const Display> get_display() const;

  
  /** Like show_unraised(), but also raises the window to the
   * top of the window stack (moves the window to the front of the
   * Z-order).
   * 
   * This function maps a window so it’s visible onscreen. Its opposite
   * is hide().
   * 
   * When implementing a Gtk::Widget, you should call this function on the widget's
   * Gdk::Window as part of the “map” method.
   * 
   */
  void show();
  
  /** For toplevel windows, withdraws them, so they will no longer be
   * known to the window manager; for all windows, unmaps them, so
   * they won’t be displayed. Normally done automatically as
   * part of gtk_widget_hide().
   * 
   */
  void hide();
  
  /** Withdraws a window (unmaps it and asks the window manager to forget about it).
   * This function is not really useful as hide() automatically
   * withdraws toplevel windows before hiding them.
   * 
   */
  void withdraw();
  
  /** Shows a Gdk::Window onscreen, but does not modify its stacking
   * order. In contrast, show() will raise the window
   * to the top of the window stack.
   * 
   * On the X11 platform, in Xlib terms, this function calls
   * XMapWindow() (it also updates some internal GDK state, which means
   * that you can’t really use XMapWindow() directly on a GDK window).
   * 
   */
  void show_unraised();
  
  /** Repositions a window relative to its parent window.
   * For toplevel windows, window managers may ignore or modify the move;
   * you should probably use gtk_window_move() on a Gtk::Window widget
   * anyway, instead of using GDK functions. For child windows,
   * the move will reliably succeed.
   * 
   * If you’re also planning to resize the window, use move_resize()
   * to both move and resize simultaneously, for a nicer visual effect.
   * 
   * @param x X coordinate relative to window’s parent.
   * @param y Y coordinate relative to window’s parent.
   */
  void move(int x, int y);
  
  /** Resizes @a window; for toplevel windows, asks the window manager to resize
   * the window. The window manager may not allow the resize. When using GTK+,
   * use gtk_window_resize() instead of this low-level GDK function.
   * 
   * Windows may not be resized below 1x1.
   * 
   * If you’re also planning to move the window, use move_resize()
   * to both move and resize simultaneously, for a nicer visual effect.
   * 
   * @param width New width of the window.
   * @param height New height of the window.
   */
  void resize(int width, int height);
  
  /** Equivalent to calling move() and resize(),
   * except that both operations are performed at once, avoiding strange
   * visual effects. (i.e. the user may be able to see the window first
   * move, then resize, if you don’t use move_resize().)
   * 
   * @param x New X position relative to window’s parent.
   * @param y New Y position relative to window’s parent.
   * @param width New width.
   * @param height New height.
   */
  void move_resize(int x, int y, int width, int height);
  
  /** Reparents @a window into the given @a new_parent. The window being
   * reparented will be unmapped as a side effect.
   * 
   * @param new_parent New parent to move @a window into.
   * @param x X location inside the new parent.
   * @param y Y location inside the new parent.
   */
  void reparent(const Glib::RefPtr<Window>& new_parent, int x, int y);
  
  /** Raises @a window to the top of the Z-order (stacking order), so that
   * other windows with the same parent window appear below @a window.
   * This is true whether or not the windows are visible.
   * 
   * If @a window is a toplevel, the window manager may choose to deny the
   * request to move the window in the Z-order, raise() only
   * requests the restack, does not guarantee it.
   * 
   */
  void raise();
  
  /** Lowers @a window to the bottom of the Z-order (stacking order), so that
   * other windows with the same parent window appear above @a window.
   * This is true whether or not the other windows are visible.
   * 
   * If @a window is a toplevel, the window manager may choose to deny the
   * request to move the window in the Z-order, lower() only
   * requests the restack, does not guarantee it.
   * 
   * Note that show() raises the window again, so don’t call this
   * function before show(). (Try show_unraised().)
   * 
   */
  void lower();

  
  /** Changes the position of  @a window in the Z-order (stacking order), so that
   * it is above @a sibling (if @a above is <tt>true</tt>) or below @a sibling (if @a above is
   * <tt>false</tt>).
   * 
   * If @a sibling is <tt>0</tt>, then this either raises (if @a above is <tt>true</tt>) or
   * lowers the window.
   * 
   * If @a window is a toplevel, the window manager may choose to deny the
   * request to move the window in the Z-order, restack() only
   * requests the restack, does not guarantee it.
   * 
   * @newin{2,18}
   * 
   * @param sibling A Gdk::Window that is a sibling of @a window, or <tt>0</tt>.
   * @param above A boolean.
   */
  void restack(const Glib::RefPtr<Window>& sibling, bool above);

  /** Changes the position of this window in the Z-order (stacking order). This
   * either raises (if @a above is true) or lowers the window.
   *
   * If this is a toplevel, the window manager may choose to deny the
   * request to move the window in the Z-order. restack() only
   * requests the restack but does not guarantee it.
   *
   * @param above Whether to raise or lower the window.
   *
   * @newin{2,18}
   */
  void restack(bool above);

  
  /** Sets keyboard focus to @a window. In most cases, gtk_window_present()
   * should be used on a Gtk::Window, rather than calling this function.
   * 
   * @param timestamp Timestamp of the event triggering the window focus.
   */
  void focus(guint32 timestamp);
  
  /** For most purposes this function is deprecated in favor of
   * Glib::object_set_data(). However, for historical reasons GTK+ stores
   * the Gtk::Widget that owns a Gdk::Window as user data on the
   * Gdk::Window. So, custom widget implementations should use
   * this function for that. If GTK+ receives an event for a Gdk::Window,
   * and the user data for the window is non-<tt>0</tt>, GTK+ will assume the
   * user data is a Gtk::Widget, and forward the event to that widget.
   * 
   * @param user_data User data.
   */
  void set_user_data(gpointer user_data);
  
  /** An override redirect window is not under the control of the window manager.
   * This means it won’t have a titlebar, won’t be minimizable, etc. - it will
   * be entirely under the control of the application. The window manager
   * can’t see the override redirect window at all.
   * 
   * Override redirect should only be used for short-lived temporary
   * windows, such as popup menus. Gtk::Menu uses an override redirect
   * window in its implementation, for example.
   * 
   * @param override_redirect <tt>true</tt> if window should be override redirect.
   */
  void set_override_redirect(bool override_redirect =  true);

  //We could wrap these with a Slot instead of a C callback, but these methods are very low-level anyway.
  
  /** Adds an event filter to @a window, allowing you to intercept events
   * before they reach GDK. This is a low-level operation and makes it
   * easy to break GDK and/or GTK+, so you have to know what you're
   * doing. Pass <tt>0</tt> for @a window to get all events for all windows,
   * instead of events for a specific window.
   * 
   * If you are interested in X GenericEvents, bear in mind that
   * XGetEventData() has been already called on the event, and
   * XFreeEventData() must not be called within @a function.
   * 
   * @param function Filter callback.
   * @param data Data to pass to filter callback.
   */
  void add_filter(GdkFilterFunc function, gpointer data);
  
  /** Remove a filter previously added with add_filter().
   * 
   * @param function Previously-added filter function.
   * @param data User data for previously-added filter function.
   */
  void remove_filter(GdkFilterFunc function, gpointer data);

  
  /** Scroll the contents of @a window, both pixels and children, by the
   * given amount. @a window itself does not move. Portions of the window
   * that the scroll operation brings in from offscreen areas are
   * invalidated. The invalidated region may be bigger than what would
   * strictly be necessary.
   * 
   * For X11, a minimum area will be invalidated if the window has no
   * subwindows, or if the edges of the window’s parent do not extend
   * beyond the edges of the window. In other cases, a multi-step process
   * is used to scroll the window which may produce temporary visual
   * artifacts and unnecessary invalidations.
   * 
   * @param dx Amount to scroll in the X direction.
   * @param dy Amount to scroll in the Y direction.
   */
  void scroll(int dx, int dy);
  
  /** Move the part of @a window indicated by @a region by @a dy pixels in the Y
   * direction and @a dx pixels in the X direction. The portions of @a region
   * that not covered by the new position of @a region are invalidated.
   * 
   * Child windows are not moved.
   * 
   * @newin{2,8}
   * 
   * @param region The #cairo_region_t to move.
   * @param dx Amount to move in the X direction.
   * @param dy Amount to move in the Y direction.
   */
  void move_region(const ::Cairo::RefPtr< ::Cairo::Region>& region, int dx, int dy);
  
  /** Tries to ensure that there is a window-system native window for this
   * GdkWindow. This may fail in some situations, returning <tt>false</tt>.
   * 
   * Offscreen window and children of them can never have native windows.
   * 
   * Some backends may not support native child windows.
   * 
   * @newin{2,18}
   * 
   * @return <tt>true</tt> if the window has a native window, <tt>false</tt> otherwise.
   */
  bool ensure_native();

  
  /** Makes pixels in @a window outside @a shape_region be transparent,
   * so that the window may be nonrectangular.
   * 
   * If @a shape_region is <tt>0</tt>, the shape will be unset, so the whole
   * window will be opaque again. @a offset_x and @a offset_y are ignored
   * if @a shape_region is <tt>0</tt>.
   * 
   * On the X11 platform, this uses an X server extension which is
   * widely available on most common platforms, but not available on
   * very old X servers, and occasionally the implementation will be
   * buggy. On servers without the shape extension, this function
   * will do nothing.
   * 
   * This function works on both toplevel and child windows.
   * 
   * @param shape_region Region of window to be non-transparent.
   * @param offset_x X position of @a shape_region in @a window coordinates.
   * @param offset_y Y position of @a shape_region in @a window coordinates.
   */
  void shape_combine_region(const ::Cairo::RefPtr< ::Cairo::Region>& shape_region, int offset_x =  0, int offset_y =  0);
  
  /** Sets the shape mask of @a window to the union of shape masks
   * for all children of @a window, ignoring the shape mask of @a window
   * itself. Contrast with merge_child_shapes() which includes
   * the shape mask of @a window in the masks to be merged.
   * 
   */
  void set_child_shapes();
  
  /** Determines whether @a window is composited.
   * 
   * See set_composited().
   * 
   * @newin{2,22}
   * 
   * @return <tt>true</tt> if the window is composited.
   */
  bool get_composited() const;
  
  /** Sets a Gdk::Window as composited, or unsets it. Composited
   * windows do not automatically have their contents drawn to
   * the screen. Drawing is redirected to an offscreen buffer
   * and an expose event is emitted on the parent of the composited
   * window. It is the responsibility of the parent’s expose handler
   * to manually merge the off-screen content onto the screen in
   * whatever way it sees fit.
   * 
   * It only makes sense for child windows to be composited; see
   * set_opacity() if you need translucent toplevel
   * windows.
   * 
   * An additional effect of this call is that the area of this
   * window is no longer clipped from regions marked for
   * invalidation on its parent. Draws done on the parent
   * window are also no longer clipped by the child.
   * 
   * This call is only supported on some systems (currently,
   * only X11 with new enough Xcomposite and Xdamage extensions).
   * You must call Gdk::Display::supports_composite() to check if
   * setting a window as composited is supported before
   * attempting to do so.
   * 
   * @newin{2,12}
   * 
   * @param composited <tt>true</tt> to set the window as composited.
   */
  void set_composited(bool composited =  TRUE);
  
  /** Merges the shape masks for any child windows into the
   * shape mask for @a window. i.e. the union of all masks
   * for @a window and its children will become the new mask
   * for @a window. See shape_combine_region().
   * 
   * This function is distinct from set_child_shapes()
   * because it includes @a window’s shape mask in the set of shapes to
   * be merged.
   * 
   */
  void merge_child_shapes();

  
  /** Like shape_combine_region(), but the shape applies
   * only to event handling. Mouse events which happen while
   * the pointer position corresponds to an unset bit in the
   * mask will be passed on the window below @a window.
   * 
   * An input shape is typically used with RGBA windows.
   * The alpha channel of the window defines which pixels are
   * invisible and allows for nicely antialiased borders,
   * and the input shape controls where the window is
   * “clickable”.
   * 
   * On the X11 platform, this requires version 1.1 of the
   * shape extension.
   * 
   * On the Win32 platform, this functionality is not present and the
   * function does nothing.
   * 
   * @newin{2,10}
   * 
   * @param shape_region Region of window to be non-transparent.
   * @param offset_x X position of @a shape_region in @a window coordinates.
   * @param offset_y Y position of @a shape_region in @a window coordinates.
   */
  void input_shape_combine_region(const ::Cairo::RefPtr< ::Cairo::Region>& shape_region, int offset_x, int offset_y);
  
  /** Sets the input shape mask of @a window to the union of input shape masks
   * for all children of @a window, ignoring the input shape mask of @a window
   * itself. Contrast with merge_child_input_shapes() which includes
   * the input shape mask of @a window in the masks to be merged.
   * 
   * @newin{2,10}
   * 
   */
  void set_child_input_shapes();
  
  /** Merges the input shape masks for any child windows into the
   * input shape mask for @a window. i.e. the union of all input masks
   * for @a window and its children will become the new input mask
   * for @a window. See input_shape_combine_region().
   * 
   * This function is distinct from set_child_input_shapes()
   * because it includes @a window’s input shape mask in the set of
   * shapes to be merged.
   * 
   * @newin{2,10}
   * 
   */
  void merge_child_input_shapes();

  
  /** Checks whether the window has been mapped (with show() or
   * show_unraised()).
   * 
   * @return <tt>true</tt> if the window is mapped.
   */
  bool is_visible() const;
  
  /** Check if the window and all ancestors of the window are
   * mapped. (This is not necessarily "viewable" in the X sense, since
   * we only check as far as we have GDK window parents, not to the root
   * window.)
   * 
   * @return <tt>true</tt> if the window is viewable.
   */
  bool is_viewable() const;
  
  /** Determines whether or not the window is an input only window.
   * 
   * @newin{2,22}
   * 
   * @return <tt>true</tt> if @a window is input only.
   */
  bool is_input_only() const;
  
  /** Determines whether or not the window is shaped.
   * 
   * @newin{2,22}
   * 
   * @return <tt>true</tt> if @a window is shaped.
   */
  bool is_shaped() const;
  
  /** Gets the bitwise OR of the currently active window state flags,
   * from the Gdk::WindowState enumeration.
   * 
   * @return Window state bitfield.
   */
  WindowState get_state() const;
  
  /** Set the bit gravity of the given window to static, and flag it so
   * all children get static subwindow gravity. This is used if you are
   * implementing scary features that involve deep knowledge of the
   * windowing system. Don’t worry about it unless you have to.
   * 
   * @param use_static <tt>true</tt> to turn on static gravity.
   * @return <tt>true</tt> if the server supports static gravity.
   */
  bool set_static_gravities(bool use_static =  true);
  
  /** Checks whether the window has a native window or not. Note that
   * you can use ensure_native() if a native window is needed.
   * 
   * @newin{2,22}
   * 
   * @return <tt>true</tt> if the @a window has a native window, <tt>false</tt> otherwise.
   */
  bool has_native() const;
  
  /** The application can use this call to provide a hint to the window
   * manager about the functionality of a window. The window manager
   * can use this information when determining the decoration and behaviour
   * of the window.
   * 
   * The hint must be set before the window is mapped.
   * 
   * @param hint A hint of the function this window will have.
   */
  void set_type_hint(WindowTypeHint hint);
  
  /** This function returns the type hint set for a window.
   * 
   * @newin{2,10}
   * 
   * @return The type hint set for @a window.
   */
  WindowTypeHint get_type_hint();
  
  /** Determines whether or not the window manager is hinted that @a window
   * has modal behaviour.
   * 
   * @newin{2,22}
   * 
   * @return Whether or not the window has the modal hint set.
   */
  bool get_modal_hint() const;
  
  /** The application can use this hint to tell the window manager
   * that a certain window has modal behaviour. The window manager
   * can use this information to handle modal windows in a special
   * way.
   * 
   * You should only use this on windows for which you have
   * previously called set_transient_for()
   * 
   * @param modal <tt>true</tt> if the window is modal, <tt>false</tt> otherwise.
   */
  void set_modal_hint(bool modal =  true);
  
  /** Sets the geometry hints for @a window. Hints flagged in @a geom_mask
   * are set, hints not flagged in @a geom_mask are unset.
   * To unset all hints, use a @a geom_mask of 0 and a @a geometry of <tt>0</tt>.
   * 
   * This function provides hints to the windowing system about
   * acceptable sizes for a toplevel window. The purpose of
   * this is to constrain user resizing, but the windowing system
   * will typically  (but is not required to) also constrain the
   * current size of the window to the provided values and
   * constrain programatic resizing via resize() or
   * move_resize().
   * 
   * Note that on X11, this effect has no effect on windows
   * of type Gdk::WINDOW_TEMP or windows where override redirect
   * has been turned on via set_override_redirect()
   * since these windows are not resizable by the user.
   * 
   * Since you can’t count on the windowing system doing the
   * constraints for programmatic resizes, you should generally
   * call constrain_size() yourself to determine
   * appropriate sizes.
   * 
   * @param geometry Geometry hints.
   * @param geom_mask Bitmask indicating fields of @a geometry to pay attention to.
   */
  void set_geometry_hints(const Geometry& geometry, WindowHints geom_mask);
  
  /** A convenience wrapper around begin_paint_region() which
   * creates a rectangular region for you. See
   * begin_paint_region() for details.
   * 
   * @param rectangle Rectangle you intend to draw to.
   */
  void begin_paint_rect(const Rectangle& rectangle);
  
  /** Indicates that you are beginning the process of redrawing @a region.
   * A backing store (offscreen buffer) large enough to contain @a region
   * will be created. The backing store will be initialized with the
   * background color or background surface for @a window. Then, all
   * drawing operations performed on @a window will be diverted to the
   * backing store.  When you call end_paint(), the backing
   * store will be copied to @a window, making it visible onscreen. Only
   * the part of @a window contained in @a region will be modified; that is,
   * drawing operations are clipped to @a region.
   * 
   * The net result of all this is to remove flicker, because the user
   * sees the finished product appear all at once when you call
   * end_paint(). If you draw to @a window directly without
   * calling begin_paint_region(), the user may see flicker
   * as individual drawing operations are performed in sequence.  The
   * clipping and background-initializing features of
   * begin_paint_region() are conveniences for the
   * programmer, so you can avoid doing that work yourself.
   * 
   * When using GTK+, the widget system automatically places calls to
   * begin_paint_region() and end_paint() around
   * emissions of the expose_event signal. That is, if you’re writing an
   * expose event handler, you can assume that the exposed area in
   * Gdk::EventExpose has already been cleared to the window background,
   * is already set as the clip region, and already has a backing store.
   * Therefore in most cases, application code need not call
   * begin_paint_region().
   * 
   * If you call this function multiple times before calling the
   * matching end_paint(), the backing stores are pushed onto
   * a stack. end_paint() copies the topmost backing store
   * onscreen, subtracts the topmost region from all other regions in
   * the stack, and pops the stack. All drawing operations affect only
   * the topmost backing store in the stack. One matching call to
   * end_paint() is required for each call to
   * begin_paint_region().
   * 
   * @param region Region you intend to draw to.
   */
  void begin_paint_region(const ::Cairo::RefPtr< ::Cairo::Region>& region);
  
  /** Indicates that the backing store created by the most recent call to
   * begin_paint_region() should be copied onscreen and
   * deleted, leaving the next-most-recent backing store or no backing
   * store at all as the active paint region. See
   * begin_paint_region() for full details. It is an error to
   * call this function without a matching
   * begin_paint_region() first.
   * 
   */
  void end_paint();
  
  /** This function does nothing.
   * 
   * @newin{2,18}
   * 
   * Deprecated: 3.14
   * 
   */
  void flush();
  
  /** Sets the title of a toplevel window, to be displayed in the titlebar.
   * If you haven’t explicitly set the icon name for the window
   * (using set_icon_name()), the icon name will be set to
   *  @a title as well. @a title must be in UTF-8 encoding (as with all
   * user-readable strings in GDK/GTK+). @a title may not be <tt>0</tt>.
   * 
   * @param title Title of @a window.
   */
  void set_title(const Glib::ustring& title);
  
  /** When using GTK+, typically you should use gtk_window_set_role() instead
   * of this low-level function.
   * 
   * The window manager and session manager use a window’s role to
   * distinguish it from other kinds of window in the same application.
   * When an application is restarted after being saved in a previous
   * session, all windows with the same title and role are treated as
   * interchangeable.  So if you have two windows with the same title
   * that should be distinguished for session management purposes, you
   * should set the role on those windows. It doesn’t matter what string
   * you use for the role, as long as you have a different role for each
   * non-interchangeable kind of window.
   * 
   * @param role A string indicating its role.
   */
  void set_role(const Glib::ustring& role);
  
  /** When using GTK+, typically you should use gtk_window_set_startup_id()
   * instead of this low-level function.
   * 
   * @newin{2,12}
   * 
   * @param startup_id A string with startup-notification identifier.
   */
  void set_startup_id(const Glib::ustring& startup_id);
  
  /** Indicates to the window manager that @a window is a transient dialog
   * associated with the application window @a parent. This allows the
   * window manager to do things like center @a window on @a parent and
   * keep @a window above @a parent.
   * 
   * See gtk_window_set_transient_for() if you’re using Gtk::Window or
   * Gtk::Dialog.
   * 
   * @param parent Another toplevel Gdk::Window.
   */
  void set_transient_for(const Glib::RefPtr<Window>& parent);
  
#ifndef GDKMM_DISABLE_DEPRECATED

  /** Sets the background color of @a window. (However, when using GTK+,
   * set the background of a widget with gtk_widget_modify_bg() - if
   * you’re an application - or gtk_style_set_background() - if you're
   * implementing a custom widget.)
   * 
   * See also set_background_pattern().
   * 
   * Deprecated: 3.4: Use set_background_rgba() instead.
   * 
   * @deprecated Use the set_background() method that takes a Gdk::RGBA instead.
   * 
   * @param color A Gdk::Color.
   */
  void set_background(const Color& color);
#endif // GDKMM_DISABLE_DEPRECATED


  /** Sets the background color of @a window.
   * 
   * See also set_background_pattern().
   * 
   * @param rgba A Gdk::RGBA color.
   */
  void set_background(const RGBA& rgba);

 
  /** Sets the background of @a window.
   * 
   * A background of <tt>0</tt> means that the window will inherit its
   * background from its parent window.
   * 
   * The windowing system will normally fill a window with its background
   * when the window is obscured then exposed.
   * 
   * @param pattern A pattern to use, or <tt>0</tt>.
   */
  void set_background(const ::Cairo::RefPtr< ::Cairo::Pattern>& pattern);

   
  /** Gets the pattern used to clear the background on @a window. If @a window
   * does not have its own background and reuses the parent's, <tt>0</tt> is
   * returned and you’ll have to query it yourself.
   * 
   * @newin{2,22}
   * 
   * @return The pattern to use for the
   * background or <tt>0</tt> to use the parent’s background.
   */
  ::Cairo::RefPtr< ::Cairo::Pattern> get_background_pattern();
   

  /** Gets the pattern used to clear the background on @a window. If @a window
   * does not have its own background and reuses the parent's, <tt>0</tt> is
   * returned and you’ll have to query it yourself.
   * 
   * @newin{2,22}
   * 
   * @return The pattern to use for the
   * background or <tt>0</tt> to use the parent’s background.
   */
  ::Cairo::RefPtr<const ::Cairo::Pattern> get_background_pattern() const;


  /** Sets the mouse pointer for a Gdk::Window. 
   * To make the cursor invisible, use gdk_cursor_new_from_pixmap() to create
   * a cursor with no pixels in it.
   * 
   * @param cursor A cursor.
   */
  void set_cursor(const Glib::RefPtr<Cursor>& cursor);

  /** Use the parent window's cursor.
   * For top-level windows this means that it will use the default cursor for the ROOT window.
   */
  void set_cursor();

  
  /** Sets a specific Gdk::Cursor for a given device when it gets inside @a window.
   * Use Gdk::Cursor::new_for_display() or Gdk::Cursor::new_from_pixbuf() to create
   * the cursor. To make the cursor invisible, use Gdk::BLANK_CURSOR. Passing
   * <tt>0</tt> for the @a cursor argument to set_cursor() means that
   *  @a window will use the cursor of its parent window. Most windows should
   * use this default.
   * 
   * @newin{3,0}
   * 
   * @param device A master, pointer Gdk::Device.
   * @param cursor A Gdk::Cursor.
   */
  void set_device_cursor(const Glib::RefPtr<Device>& device, const Glib::RefPtr<Cursor>& cursor);

  /** Use the parent window's cursor.
   * For top-level windows this means that it will use the default cursor for the ROOT window.
   */
  void set_device_cursor(const Glib::RefPtr<Device>& device);

  
  /** Retrieves a Gdk::Cursor pointer for the @a device currently set on the
   * specified Gdk::Window, or <tt>0</tt>.  If the return value is <tt>0</tt> then
   * there is no custom cursor set on the specified window, and it is
   * using the cursor for its parent window.
   * 
   * @newin{3,0}
   * 
   * @param device A master, pointer Gdk::Device.
   * @return A Gdk::Cursor, or <tt>0</tt>. The
   * returned object is owned by the Gdk::Window and should not be
   * unreferenced directly. Use set_cursor() to unset the
   * cursor of the window.
   */
  Glib::RefPtr<Cursor> get_device_cursor(const Glib::RefPtr<Device>& device);
  
  /** Retrieves a Gdk::Cursor pointer for the @a device currently set on the
   * specified Gdk::Window, or <tt>0</tt>.  If the return value is <tt>0</tt> then
   * there is no custom cursor set on the specified window, and it is
   * using the cursor for its parent window.
   * 
   * @newin{3,0}
   * 
   * @param device A master, pointer Gdk::Device.
   * @return A Gdk::Cursor, or <tt>0</tt>. The
   * returned object is owned by the Gdk::Window and should not be
   * unreferenced directly. Use set_cursor() to unset the
   * cursor of the window.
   */
  Glib::RefPtr<const Cursor> get_device_cursor(const Glib::RefPtr<const Device>& device) const;


  /** Retrieves a Gdk::Cursor pointer for the cursor currently set on the
   * specified Gdk::Window, or <tt>0</tt>.  If the return value is <tt>0</tt> then
   * there is no custom cursor set on the specified window, and it is
   * using the cursor for its parent window.
   * 
   * @newin{2,18}
   * 
   * @return A Gdk::Cursor, or <tt>0</tt>. The
   * returned object is owned by the Gdk::Window and should not be
   * unreferenced directly. Use set_cursor() to unset the
   * cursor of the window.
   */
  Glib::RefPtr<Cursor> get_cursor();
  
  /** Retrieves a Gdk::Cursor pointer for the cursor currently set on the
   * specified Gdk::Window, or <tt>0</tt>.  If the return value is <tt>0</tt> then
   * there is no custom cursor set on the specified window, and it is
   * using the cursor for its parent window.
   * 
   * @newin{2,18}
   * 
   * @return A Gdk::Cursor, or <tt>0</tt>. The
   * returned object is owned by the Gdk::Window and should not be
   * unreferenced directly. Use set_cursor() to unset the
   * cursor of the window.
   */
  Glib::RefPtr<const Cursor> get_cursor() const;

  
  /** Retrieves the user data for @a window, which is normally the widget
   * that @a window belongs to. See set_user_data().
   * 
   * @param data Return location for user data.
   */
  void get_user_data(gpointer* data);
  
  /** Any of the return location arguments to this function may be <tt>0</tt>,
   * if you aren’t interested in getting the value of that field.
   * 
   * The X and Y coordinates returned are relative to the parent window
   * of @a window, which for toplevels usually means relative to the
   * window decorations (titlebar, etc.) rather than relative to the
   * root window (screen-size background window).
   * 
   * On the X11 platform, the geometry is obtained from the X server,
   * so reflects the latest position of @a window; this may be out-of-sync
   * with the position of @a window delivered in the most-recently-processed
   * Gdk::EventConfigure. get_position() in contrast gets the
   * position from the most recent configure event.
   * 
   * @note If @a window is not a toplevel, it is much better
   * to call get_position(), get_width() and
   * get_height() instead, because it avoids the roundtrip to
   * the X server and because these functions support the full 32-bit
   * coordinate space, whereas get_geometry() is restricted to
   * the 16-bit coordinates of X11.
   * 
   * @param x Return location for X coordinate of window (relative to its parent).
   * @param y Return location for Y coordinate of window (relative to its parent).
   * @param width Return location for width of window.
   * @param height Return location for height of window.
   */
  void get_geometry(int& x, int& y, int& width, int& height) const;
  
  /** Returns the width of the given @a window.
   * 
   * On the X11 platform the returned size is the size reported in the
   * most-recently-processed configure event, rather than the current
   * size on the X server.
   * 
   * @newin{2,24}
   * 
   * @return The width of @a window.
   */
  int get_width() const;
  
  /** Returns the height of the given @a window.
   * 
   * On the X11 platform the returned size is the size reported in the
   * most-recently-processed configure event, rather than the current
   * size on the X server.
   * 
   * @newin{2,24}
   * 
   * @return The height of @a window.
   */
  int get_height() const;

  
  /** Obtains the position of the window as reported in the
   * most-recently-processed Gdk::EventConfigure. Contrast with
   * get_geometry() which queries the X server for the
   * current window position, regardless of which events have been
   * received or processed.
   * 
   * The position coordinates are relative to the window’s parent window.
   * 
   * @param x X coordinate of window.
   * @param y Y coordinate of window.
   */
  void get_position(int& x, int& y) const;
  
  /** Obtains the position of a window in root window coordinates.
   * (Compare with get_position() and
   * get_geometry() which return the position of a window
   * relative to its parent window.)
   * 
   * @param x Return location for X coordinate.
   * @param y Return location for Y coordinate.
   * @return Not meaningful, ignore.
   */
  int get_origin(int& x, int& y) const;
  
  /** Obtains the position of a window position in root
   * window coordinates. This is similar to
   * get_origin() but allows you go pass
   * in any position in the window, not just the origin.
   * 
   * @newin{2,18}
   * 
   * @param x X coordinate in window.
   * @param y Y coordinate in window.
   * @param root_x Return location for X coordinate.
   * @param root_y Return location for Y coordinate.
   */
  void get_root_coords(int x, int y, int& root_x, int& root_y);
  
  /** Transforms window coordinates from a child window to its parent
   * window, where the parent window is the normal parent as returned by
   * get_parent() for normal windows, and the window's
   * embedder as returned by Gdk::OffscreenWindow::get_embedder() for
   * offscreen windows.
   * 
   * For normal windows, calling this function is equivalent to adding
   * the return values of get_position() to the child coordinates.
   * For offscreen windows however (which can be arbitrarily transformed),
   * this function calls the GdkWindow::to-embedder: signal to translate
   * the coordinates.
   * 
   * You should always use this function when writing generic code that
   * walks up a window hierarchy.
   * 
   * See also: coords_from_parent()
   * 
   * @newin{2,22}
   * 
   * @param x X coordinate in child’s coordinate system.
   * @param y Y coordinate in child’s coordinate system.
   * @param parent_x Return location for X coordinate
   * in parent’s coordinate system, or <tt>0</tt>.
   * @param parent_y Return location for Y coordinate
   * in parent’s coordinate system, or <tt>0</tt>.
   */
  void coords_to_parent(double x, double y, double& parent_x, double& parent_y);
  
  /** Transforms window coordinates from a parent window to a child
   * window, where the parent window is the normal parent as returned by
   * get_parent() for normal windows, and the window's
   * embedder as returned by Gdk::OffscreenWindow::get_embedder() for
   * offscreen windows.
   * 
   * For normal windows, calling this function is equivalent to subtracting
   * the return values of get_position() from the parent coordinates.
   * For offscreen windows however (which can be arbitrarily transformed),
   * this function calls the GdkWindow::from-embedder: signal to translate
   * the coordinates.
   * 
   * You should always use this function when writing generic code that
   * walks down a window hierarchy.
   * 
   * See also: coords_to_parent()
   * 
   * @newin{2,22}
   * 
   * @param parent_x X coordinate in parent’s coordinate system.
   * @param parent_y Y coordinate in parent’s coordinate system.
   * @param x Return location for X coordinate in child’s coordinate system.
   * @param y Return location for Y coordinate in child’s coordinate system.
   */
  void coords_from_parent(double parent_x, double parent_y, double& x, double& y);

  
  /** Obtains the top-left corner of the window manager frame in root
   * window coordinates.
   * 
   * @param x Return location for X position of window frame.
   * @param y Return location for Y position of window frame.
   */
  void get_root_origin(int& x, int& y) const;

  
#ifndef GDKMM_DISABLE_DEPRECATED

  /** Obtains the bounding box of the window, including window manager
   * titlebar/borders if any. The frame position is given in root window
   * coordinates. To get the position of the window itself (rather than
   * the frame) in root window coordinates, use get_origin().
   * 
   * @deprecated Use the const method instead.
   * 
   * @param rect Rectangle to fill with bounding box of the window frame.
   */
  void get_frame_extents(Rectangle& rect);
#endif // GDKMM_DISABLE_DEPRECATED


  /** Obtains the bounding box of the window, including window manager
   * titlebar/borders if any. The frame position is given in root window
   * coordinates. To get the position of the window itself (rather than
   * the frame) in root window coordinates, use get_origin().
   * 
   * @param rect Rectangle to fill with bounding box of the window frame.
   */
  void get_frame_extents(Rectangle& rect) const;

  
  /** Returns the internal scale factor that maps from window coordiantes
   * to the actual device pixels. On traditional systems this is 1, but
   * on very high density outputs this can be a higher value (often 2).
   * 
   * A higher value means that drawing is automatically scaled up to
   * a higher resolution, so any code doing drawing will automatically look
   * nicer. However, if you are supplying pixel-based data the scale
   * value can be used to determine whether to use a pixel resource
   * with higher resolution data.
   * 
   * The scale of a window may change during runtime, if this happens
   * a configure event will be sent to the toplevel window.
   * 
   * @newin{3,10}
   * 
   * @return The scale factor.
   */
  int get_scale_factor() const;
  
#ifndef GDKMM_DISABLE_DEPRECATED

  /** Obtains the current pointer position and modifier state.
   * The position is given in coordinates relative to the upper left
   * corner of @a window.
   * 
   * Deprecated: 3.0: Use get_device_position() instead.
   * 
   * @deprecated Use get_device_position() instead
   * 
   * @param x Return location for X coordinate of pointer or <tt>0</tt> to not
   * return the X coordinate.
   * @param y Return location for Y coordinate of pointer or <tt>0</tt> to not
   * return the Y coordinate.
   * @param mask Return location for modifier mask or <tt>0</tt> to not return the
   * modifier mask.
   * @return The window containing the
   * pointer (as with at_pointer()), or <tt>0</tt> if the window
   * containing the pointer isn’t known to GDK.
   */
  Glib::RefPtr<Window> get_pointer(int& x, int& y, ModifierType& mask);
#endif // GDKMM_DISABLE_DEPRECATED


  /** Obtains the parent of @a window, as known to GDK. Does not query the
   * X server; thus this returns the parent as passed to new(),
   * not the actual parent. This should never matter unless you’re using
   * Xlib calls mixed with GDK calls on the X11 platform. It may also
   * matter for toplevel windows, because the window manager may choose
   * to reparent them.
   * 
   * Note that you should use get_effective_parent() when
   * writing generic code that walks up a window hierarchy, because
   * get_parent() will most likely not do what you expect if
   * there are offscreen windows in the hierarchy.
   * 
   * @return Parent of @a window.
   */
  Glib::RefPtr<Window> get_parent();
  
  /** Obtains the parent of @a window, as known to GDK. Does not query the
   * X server; thus this returns the parent as passed to new(),
   * not the actual parent. This should never matter unless you’re using
   * Xlib calls mixed with GDK calls on the X11 platform. It may also
   * matter for toplevel windows, because the window manager may choose
   * to reparent them.
   * 
   * Note that you should use get_effective_parent() when
   * writing generic code that walks up a window hierarchy, because
   * get_parent() will most likely not do what you expect if
   * there are offscreen windows in the hierarchy.
   * 
   * @return Parent of @a window.
   */
  Glib::RefPtr<const Window> get_parent() const;
  
  /** Gets the toplevel window that’s an ancestor of @a window.
   * 
   * Any window type but Gdk::WINDOW_CHILD is considered a
   * toplevel window, as is a Gdk::WINDOW_CHILD window that
   * has a root window as parent.
   * 
   * Note that you should use get_effective_toplevel() when
   * you want to get to a window’s toplevel as seen on screen, because
   * get_toplevel() will most likely not do what you expect
   * if there are offscreen windows in the hierarchy.
   * 
   * @return The toplevel window containing @a window.
   */
  Glib::RefPtr<Window> get_toplevel();
  
  /** Gets the toplevel window that’s an ancestor of @a window.
   * 
   * Any window type but Gdk::WINDOW_CHILD is considered a
   * toplevel window, as is a Gdk::WINDOW_CHILD window that
   * has a root window as parent.
   * 
   * Note that you should use get_effective_toplevel() when
   * you want to get to a window’s toplevel as seen on screen, because
   * get_toplevel() will most likely not do what you expect
   * if there are offscreen windows in the hierarchy.
   * 
   * @return The toplevel window containing @a window.
   */
  Glib::RefPtr<const Window> get_toplevel() const;

  
  /** Obtains the current device position and modifier state.
   * The position is given in coordinates relative to the upper left
   * corner of @a window.
   * 
   * Use get_device_position_double() if you need subpixel precision.
   * 
   * @newin{3,0}
   * 
   * @param device Pointer Gdk::Device to query to.
   * @param x Return location for the X coordinate of @a device, or <tt>0</tt>.
   * @param y Return location for the Y coordinate of @a device, or <tt>0</tt>.
   * @param mask Return location for the modifier mask, or <tt>0</tt>.
   * @return The window underneath @a device
   * (as with Gdk::Device::get_window_at_position()), or <tt>0</tt> if the
   * window is not known to GDK.
   */
  Glib::RefPtr<Window> get_device_position(const Glib::RefPtr<const Device>& device, int& x, int& y, ModifierType& mask) const;
  
    
  /** Obtains the current device position in doubles and modifier state.
   * The position is given in coordinates relative to the upper left
   * corner of @a window.
   * 
   * @newin{3,10}
   * 
   * @param device Pointer Gdk::Device to query to.
   * @param x Return location for the X coordinate of @a device, or <tt>0</tt>.
   * @param y Return location for the Y coordinate of @a device, or <tt>0</tt>.
   * @param mask Return location for the modifier mask, or <tt>0</tt>.
   * @return The window underneath @a device
   * (as with Gdk::Device::get_window_at_position()), or <tt>0</tt> if the
   * window is not known to GDK.
   */
  Glib::RefPtr<Window> get_device_position(const Glib::RefPtr<const Device>& device, double& x, double& y, ModifierType& mask) const;

  
  /** Obtains the parent of @a window, as known to GDK. Works like
   * get_parent() for normal windows, but returns the
   * window’s embedder for offscreen windows.
   * 
   * See also: Gdk::OffscreenWindow::get_embedder()
   * 
   * @newin{2,22}
   * 
   * @return Effective parent of @a window.
   */
  Glib::RefPtr<Window> get_effective_parent();
  
  /** Obtains the parent of @a window, as known to GDK. Works like
   * get_parent() for normal windows, but returns the
   * window’s embedder for offscreen windows.
   * 
   * See also: Gdk::OffscreenWindow::get_embedder()
   * 
   * @newin{2,22}
   * 
   * @return Effective parent of @a window.
   */
  Glib::RefPtr<const Window> get_effective_parent() const;
  
  /** Gets the toplevel window that’s an ancestor of @a window.
   * 
   * Works like get_toplevel(), but treats an offscreen window's
   * embedder as its parent, using get_effective_parent().
   * 
   * See also: Gdk::OffscreenWindow::get_embedder()
   * 
   * @newin{2,22}
   * 
   * @return The effective toplevel window containing @a window.
   */
  Glib::RefPtr<Window> get_effective_toplevel();
  
  /** Gets the toplevel window that’s an ancestor of @a window.
   * 
   * Works like get_toplevel(), but treats an offscreen window's
   * embedder as its parent, using get_effective_parent().
   * 
   * See also: Gdk::OffscreenWindow::get_embedder()
   * 
   * @newin{2,22}
   * 
   * @return The effective toplevel window containing @a window.
   */
  Glib::RefPtr<const Window> get_effective_toplevel() const;

 
  /** Gets the list of children of @a window known to GDK.
   * This function only returns children created via GDK,
   * so for example it’s useless when used with the root window;
   * it only returns windows an application created itself.
   * 
   * The returned list must be freed, but the elements in the
   * list need not be.
   * 
   * @return List of child windows inside @a window.
   */
  std::vector< Glib::RefPtr<Window> > get_children();
 

  /** Gets the list of children of @a window known to GDK.
   * This function only returns children created via GDK,
   * so for example it’s useless when used with the root window;
   * it only returns windows an application created itself.
   * 
   * The returned list must be freed, but the elements in the
   * list need not be.
   * 
   * @return List of child windows inside @a window.
   */
  std::vector< Glib::RefPtr<const Window> > get_children() const;
   //gdk_window_peek_children() is the same as gdk_window_get_children() with different memory mangement of the list.

  
  /** Gets the event mask for @a window for all master input devices. See
   * set_events().
   * 
   * @return Event mask for @a window.
   */
  EventMask get_events() const;
  
  /** The event mask for a window determines which events will be reported
   * for that window from all master input devices. For example, an event mask
   * including Gdk::BUTTON_PRESS_MASK means the window should report button
   * press events. The event mask is the bitwise OR of values from the
   * Gdk::EventMask enumeration.
   * 
   * @param event_mask Event mask for @a window.
   */
  void set_events(EventMask event_mask);

  
  /** Returns the event mask for @a window corresponding to an specific device.
   * 
   * @newin{3,0}
   * 
   * @param device A Gdk::Device.
   * @return Device event mask for @a window.
   */
  EventMask get_device_events(const Glib::RefPtr<const Device>& device) const;
  
  /** Sets the event mask for a given device (Normally a floating device, not
   * attached to any visible pointer) to @a window. For example, an event mask
   * including Gdk::BUTTON_PRESS_MASK means the window should report button
   * press events. The event mask is the bitwise OR of values from the
   * Gdk::EventMask enumeration.
   * 
   * @newin{3,0}
   * 
   * @param device Gdk::Device to enable events for.
   * @param event_mask Event mask for @a window.
   */
  void set_device_events(const Glib::RefPtr<Device>& device, EventMask event_mask);

  
  /** Returns the event mask for @a window corresponding to the device class specified
   * by @a source.
   * 
   * @param source A Gdk::InputSource to define the source class.
   * @return Source event mask for @a window.
   */
  EventMask get_source_events(InputSource source) const;
  
  /** Sets the event mask for any floating device (i.e.\ not attached to any
   * visible pointer) that has the source defined as @a source. This event
   * mask will be applied both to currently existing, newly added devices
   * after this call, and devices being attached/detached.
   * 
   * @newin{3,0}
   * 
   * @param source A Gdk::InputSource to define the source class.
   * @param event_mask Event mask for @a window.
   */
  void set_source_events(InputSource source, EventMask event_mask);

 
  /** Sets a list of icons for the window. One of these will be used
   * to represent the window when it has been iconified. The icon is
   * usually shown in an icon box or some sort of task bar. Which icon
   * size is shown depends on the window manager. The window manager
   * can scale the icon  but setting several size icons can give better
   * image quality since the window manager may only need to scale the
   * icon by a small amount or not at all.
   * 
   * @param pixbufs A list of pixbufs, of different sizes.
   */
  void set_icon_list(const std::vector< Glib::RefPtr<Gdk::Pixbuf> >& pixbufs);
  void unset_icon();
  
  /** Windows may have a name used while minimized, distinct from the
   * name they display in their titlebar. Most of the time this is a bad
   * idea from a user interface standpoint. But you can set such a name
   * with this function, if you like.
   * 
   * After calling this with a non-<tt>0</tt> @a name, calls to set_title()
   * will not update the icon title.
   * 
   * Using <tt>0</tt> for @a name unsets the icon title; further calls to
   * set_title() will again update the icon title as well.
   * 
   * @param name Name of window while iconified (minimized).
   */
  void set_icon_name(const Glib::ustring& name);

  
  /** Sets the group leader window for @a window. By default,
   * GDK sets the group leader for all toplevel windows
   * to a global window implicitly created by GDK. With this function
   * you can override this default.
   * 
   * The group leader window allows the window manager to distinguish
   * all windows that belong to a single application. It may for example
   * allow users to minimize/unminimize all windows belonging to an
   * application at once. You should only set a non-default group window
   * if your application pretends to be multiple applications.
   * 
   * @param leader Group leader window, or <tt>0</tt> to restore the default group leader window.
   */
  void set_group(const Glib::RefPtr<Window>& leader);
  
  /** Returns the group leader window for @a window. See set_group().
   * 
   * @newin{2,4}
   * 
   * @return The group leader window for @a window.
   */
  Glib::RefPtr<Window> get_group();
  
  /** Returns the group leader window for @a window. See set_group().
   * 
   * @newin{2,4}
   * 
   * @return The group leader window for @a window.
   */
  Glib::RefPtr<const Window> get_group() const;

  
  /** “Decorations” are the features the window manager adds to a toplevel Gdk::Window.
   * This function sets the traditional Motif window manager hints that tell the
   * window manager which decorations you would like your window to have.
   * Usually you should use gtk_window_set_decorated() on a Gtk::Window instead of
   * using the GDK function directly.
   * 
   * The @a decorations argument is the logical OR of the fields in
   * the Gdk::WMDecoration enumeration. If Gdk::DECOR_ALL is included in the
   * mask, the other bits indicate which decorations should be turned off.
   * If Gdk::DECOR_ALL is not included, then the other bits indicate
   * which decorations should be turned on.
   * 
   * Most window managers honor a decorations hint of 0 to disable all decorations,
   * but very few honor all possible combinations of bits.
   * 
   * @param decorations Decoration hint mask.
   */
  void set_decorations(WMDecoration decorations);
  
  /** Returns the decorations set on the GdkWindow with
   * set_decorations().
   * 
   * @param decorations The window decorations will be written here.
   * @return <tt>true</tt> if the window has decorations set, <tt>false</tt> otherwise.
   */
  bool get_decorations(WMDecoration& decorations) const;
  
  /** Sets hints about the window management functions to make available
   * via buttons on the window frame.
   * 
   * On the X backend, this function sets the traditional Motif window
   * manager hint for this purpose. However, few window managers do
   * anything reliable or interesting with this hint. Many ignore it
   * entirely.
   * 
   * The @a functions argument is the logical OR of values from the
   * Gdk::WMFunction enumeration. If the bitmask includes Gdk::FUNC_ALL,
   * then the other bits indicate which functions to disable; if
   * it doesn’t include Gdk::FUNC_ALL, it indicates which functions to
   * enable.
   * 
   * @param functions Bitmask of operations to allow on @a window.
   */
  void set_functions(WMFunction functions);

   //deprecated

   
  /** Create a new surface that is as compatible as possible with the
   * given @a window. For example the new surface will have the same
   * fallback resolution and font options as @a window. Generally, the new
   * surface will also use the same backend as @a window, unless that is
   * not possible for some reason. The type of the returned surface may
   * be examined with cairo_surface_get_type().
   * 
   * Initially the surface contents are all 0 (transparent if contents
   * have transparency, black otherwise.)
   * 
   * @newin{2,22}
   * 
   * @param content The content for the new surface.
   * @param width Width of the new surface.
   * @param height Height of the new surface.
   * @return A pointer to the newly allocated surface. The caller
   * owns the surface and should call cairo_surface_destroy() when done
   * with it.
   * 
   * This function always returns a valid pointer, but it will return a
   * pointer to a “nil” surface if @a other is already in an error state
   * or any other error occurs.
   */
  ::Cairo::RefPtr< ::Cairo::Surface> create_similar_surface(::Cairo::Content content, int width, int height);

   
  /** Create a new image surface that is efficient to draw on the
   * given @a window.
   * 
   * Initially the surface contents are all 0 (transparent if contents
   * have transparency, black otherwise.)
   * 
   * @newin{3,10}
   * 
   * @param format The format for the new surface.
   * @param width Width of the new surface.
   * @param height Height of the new surface.
   * @param scale The scale of the new surface, or 0 to use same as @a window.
   * @return A pointer to the newly allocated surface. The caller
   * owns the surface and should call cairo_surface_destroy() when done
   * with it.
   * 
   * This function always returns a valid pointer, but it will return a
   * pointer to a “nil” surface if @a other is already in an error state
   * or any other error occurs.
   */
  ::Cairo::RefPtr< ::Cairo::Surface> create_similar_image_surface(::Cairo::Format format, int width, int height, int scale);

  
  /** Emits a short beep associated to @a window in the appropriate
   * display, if supported. Otherwise, emits a short beep on
   * the display just as Gdk::Display::beep().
   * 
   * @newin{2,12}
   * 
   */
  void beep();

  
  /** Asks to iconify (minimize) @a window. The window manager may choose
   * to ignore the request, but normally will honor it. Using
   * gtk_window_iconify() is preferred, if you have a Gtk::Window widget.
   * 
   * This function only makes sense when @a window is a toplevel window.
   * 
   */
  void iconify();
  
  /** Attempt to deiconify (unminimize) @a window. On X11 the window manager may
   * choose to ignore the request to deiconify. When using GTK+,
   * use gtk_window_deiconify() instead of the Gdk::Window variant. Or better yet,
   * you probably want to use gtk_window_present(), which raises the window, focuses it,
   * unminimizes it, and puts it on the current desktop.
   * 
   */
  void deiconify();
  
  /** “Pins” a window such that it’s on all workspaces and does not scroll
   * with viewports, for window managers that have scrollable viewports.
   * (When using Gtk::Window, gtk_window_stick() may be more useful.)
   * 
   * On the X11 platform, this function depends on window manager
   * support, so may have no effect with many window managers. However,
   * GDK will do the best it can to convince the window manager to stick
   * the window. For window managers that don’t support this operation,
   * there’s nothing you can do to force it to happen.
   * 
   */
  void stick();
  
  /** Reverse operation for stick(); see stick(),
   * and gtk_window_unstick().
   * 
   */
  void unstick();
  
  /** Maximizes the window. If the window was already maximized, then
   * this function does nothing.
   * 
   * On X11, asks the window manager to maximize @a window, if the window
   * manager supports this operation. Not all window managers support
   * this, and some deliberately ignore it or don’t have a concept of
   * “maximized”; so you can’t rely on the maximization actually
   * happening. But it will happen with most standard window managers,
   * and GDK makes a best effort to get it to happen.
   * 
   * On Windows, reliably maximizes the window.
   * 
   */
  void maximize();
  
  /** Unmaximizes the window. If the window wasn’t maximized, then this
   * function does nothing.
   * 
   * On X11, asks the window manager to unmaximize @a window, if the
   * window manager supports this operation. Not all window managers
   * support this, and some deliberately ignore it or don’t have a
   * concept of “maximized”; so you can’t rely on the unmaximization
   * actually happening. But it will happen with most standard window
   * managers, and GDK makes a best effort to get it to happen.
   * 
   * On Windows, reliably unmaximizes the window.
   * 
   */
  void unmaximize();
  
  /** Registers a window as a potential drop destination.
   * 
   */
  void register_dnd();

  
  /** Finds out the DND protocol supported by a window.
   * 
   * @newin{3,0}
   * 
   * @param target Location of the window
   * where the drop should happen. This may be @a window or a proxy window,
   * or <tt>0</tt> if @a window does not support Drag and Drop.
   * @return The supported DND protocol.
   */

  DragProtocol get_drag_protocol(Glib::RefPtr<Window>& target) const;

  /** Finds out the DND protocol supported by a window.
   * 
   * @newin{3,0}
   * @return The supported DND protocol.
   */
  DragProtocol get_drag_protocol() const;

  
  /** Begins a window resize operation (for a toplevel window).
   * 
   * This function assumes that the drag is controlled by the
   * client pointer device, use begin_resize_drag_for_device()
   * to begin a drag with a different device.
   * 
   * @param edge The edge or corner from which the drag is started.
   * @param button The button being used to drag, or 0 for a keyboard-initiated drag.
   * @param root_x Root window X coordinate of mouse click that began the drag.
   * @param root_y Root window Y coordinate of mouse click that began the drag.
   * @param timestamp Timestamp of mouse click that began the drag (use Gdk::Event::get_time()).
   */
  void begin_resize_drag(WindowEdge edge, int button, int root_x, int root_y, guint32 timestamp);

  
  /** Begins a window resize operation (for a toplevel window).
   * You might use this function to implement a “window resize grip,” for
   * example; in fact Gtk::Statusbar uses it. The function works best
   * with window managers that support the
   * [Extended Window Manager Hints](http://www.freedesktop.org/Standards/wm-spec)
   * but has a fallback implementation for other window managers.
   * 
   * @newin{3,4}
   * 
   * @param edge The edge or corner from which the drag is started.
   * @param device The device used for the operation.
   * @param button The button being used to drag, or 0 for a keyboard-initiated drag.
   * @param root_x Root window X coordinate of mouse click that began the drag.
   * @param root_y Root window Y coordinate of mouse click that began the drag.
   * @param timestamp Timestamp of mouse click that began the drag (use Gdk::Event::get_time()).
   */
  void resize_drag(WindowEdge edge, const Glib::RefPtr<Device>& device, int button, int root_x, int root_y, guint32 timestamp);

  
  /** Begins a window move operation (for a toplevel window).
   * 
   * This function assumes that the drag is controlled by the
   * client pointer device, use begin_move_drag_for_device()
   * to begin a drag with a different device.
   * 
   * @param button The button being used to drag, or 0 for a keyboard-initiated drag.
   * @param root_x Root window X coordinate of mouse click that began the drag.
   * @param root_y Root window Y coordinate of mouse click that began the drag.
   * @param timestamp Timestamp of mouse click that began the drag.
   */
  void begin_move_drag(int button, int root_x, int root_y, guint32 timestamp);

  
  /** Begins a window move operation (for a toplevel window).
   * You might use this function to implement a “window move grip,” for
   * example. The function works best with window managers that support the
   * [Extended Window Manager Hints](http://www.freedesktop.org/Standards/wm-spec)
   * but has a fallback implementation for other window managers.
   * 
   * @newin{3,4}
   * 
   * @param device The device used for the operation.
   * @param button The button being used to drag, or 0 for a keyboard-initiated drag.
   * @param root_x Root window X coordinate of mouse click that began the drag.
   * @param root_y Root window Y coordinate of mouse click that began the drag.
   * @param timestamp Timestamp of mouse click that began the drag.
   */
  void begin_move_drag(const Glib::RefPtr<Device>& device, int button, int root_x, int root_y, guint32 timestamp);

  /** Starts a drag and creates a new drag context for it.
   *
   * This method is called by the drag source.
   * @param targets A list of the offered targets names.
   * @return A newly created Gdk::DragContext.
   *
   * @newin{2,24}
   */
  Glib::RefPtr<DragContext> drag_begin(const std::vector<Glib::ustring>& targets);
  

  /** A convenience wrapper around invalidate_region() which
   * invalidates a rectangular region. See invalidate_region() for details.
   * See also the invalidate_rect() method overload with no rect parameter, to 
   * invalidate the whole region.
   * 
   * @param rect Rectangle to invalidate.
   * @param invalidate_children Whether to also invalidate child windows.
   */
  void invalidate_rect(const Rectangle& rect, bool invalidate_children);

  /** A convenience wrapper around invalidate_region() which
   * invalidates the whole region. See invalidate_region() for details.
   * @param invalidate_children Whether to also invalidate child windows.
   */
  void invalidate(bool invalidate_children);

  
  /** Adds @a region to the update area for @a window. The update area is the
   * region that needs to be redrawn, or “dirty region.” The call
   * process_updates() sends one or more expose events to the
   * window, which together cover the entire update area. An
   * application would normally redraw the contents of @a window in
   * response to those expose events.
   * 
   * GDK will call process_all_updates() on your behalf
   * whenever your program returns to the main loop and becomes idle, so
   * normally there’s no need to do that manually, you just need to
   * invalidate regions that you know should be redrawn.
   * 
   * The @a invalidate_children parameter controls whether the region of
   * each child window that intersects @a region will also be invalidated.
   * If <tt>false</tt>, then the update area for child windows will remain
   * unaffected. See gdk_window_invalidate_maybe_recurse if you need
   * fine grained control over which children are invalidated.
   * 
   * @param region A #cairo_region_t.
   * @param invalidate_children <tt>true</tt> to also invalidate child windows.
   */
  void invalidate_region(const ::Cairo::RefPtr< ::Cairo::Region>& region, bool invalidate_children =  true);

  //TODO:
  /*
  void       gdk_window_invalidate_maybe_recurse  (GdkWindow          *window,
						 const cairo_region_t    *region,
						 gboolean (*child_func) (GdkWindow *, gpointer),
						 gpointer   user_data);
	*/

 
  //This method should not have a const version - see the docs
  
  /** Transfers ownership of the update area from @a window to the caller
   * of the function. That is, after calling this function, @a window will
   * no longer have an invalid/dirty region; the update area is removed
   * from @a window and handed to you. If a window has no update area,
   * get_update_area() returns an invalid Region.
   * 
   * @return The update area for @a window.
   */
  ::Cairo::RefPtr< ::Cairo::Region> get_update_area();

  
  /** Temporarily freezes a window such that it won’t receive expose
   * events.  The window will begin receiving expose events again when
   * thaw_updates() is called. If freeze_updates()
   * has been called more than once, thaw_updates() must be called
   * an equal number of times to begin processing exposes.
   * 
   */
  void freeze_updates();
  
  /** Thaws a window frozen with freeze_updates().
   * 
   */
  void thaw_updates();
  
  /** Calls process_updates() for all windows (see Gdk::Window)
   * in the application.
   * 
   */
  static void process_all_updates();
  
  /** Sends one or more expose events to @a window. The areas in each
   * expose event will cover the entire update area for the window (see
   * invalidate_region() for details). Normally GDK calls
   * process_all_updates() on your behalf, so there’s no
   * need to call this function unless you want to force expose events
   * to be delivered immediately and synchronously (vs. the usual
   * case, where GDK delivers them in an idle handler). Occasionally
   * this is useful to produce nicer scrolling behavior, for example.
   * 
   * @param update_children Whether to also process updates for child windows.
   */
  void process_updates(bool update_children);
  
  /** With update debugging enabled, calls to
   * invalidate_region() clear the invalidated region of the
   * screen to a noticeable color, and GDK pauses for a short time
   * before sending exposes to windows during
   * process_updates().  The net effect is that you can see
   * the invalid region for each window and watch redraws as they
   * occur. This allows you to diagnose inefficiencies in your application.
   * 
   * In essence, because the GDK rendering model prevents all flicker,
   * if you are redrawing the same region 400 times you may never
   * notice, aside from noticing a speed problem. Enabling update
   * debugging causes GTK to flicker slowly and noticeably, so you can
   * see exactly what’s being redrawn when, in what order.
   * 
   * The --gtk-debug=updates command line option passed to GTK+ programs
   * enables this debug option at application startup time. That's
   * usually more useful than calling set_debug_updates()
   * yourself, though you might want to use this function to enable
   * updates sometime after application startup time.
   * 
   * @param setting <tt>true</tt> to turn on update debugging.
   */
  static void set_debug_updates(bool setting =  true);

  //TODO: flags is now an enum. See
  // https://git.gnome.org/browse/gtk+/commit/gdk/gdkwindow.c?id=4b42526e1f33b0ceb9231cee5e15861b97c05726
  // Change it here too?
   

  /** Constrains a desired width and height according to a
   * set of geometry hints (such as minimum and maximum size).
   * 
   * @param geometry A Gdk::Geometry structure.
   * @param flags A mask indicating what portions of @a geometry are set.
   * @param width Desired width of window.
   * @param height Desired height of the window.
   * @param new_width Location to store resulting width.
   * @param new_height Location to store resulting height.
   */
  static void constrain_size(const Geometry& geometry, guint flags, int width, int height, int& new_width, int& new_height);

  
#ifndef GDKMM_DISABLE_DEPRECATED

  /** Does nothing, present only for compatiblity.
   * 
   * @newin{2,6}
   * Deprecated: 3.8: this function is no longer needed
   * 
   * @deprecated This function is no longer needed.
   * 
   */
  void enable_synchronized_configure();
#endif // GDKMM_DISABLE_DEPRECATED


#ifndef GDKMM_DISABLE_DEPRECATED

  /** Does nothing, present only for compatiblity.
   * 
   * @newin{2,6}
   * Deprecated: 3.8: this function is no longer needed
   * 
   * @deprecated This function is no longer needed.
   * 
   */
  void configure_finished();
#endif // GDKMM_DISABLE_DEPRECATED


  /** Toggles whether a window should appear in a task list or window
   * list. If a window’s semantic type as specified with
   * set_type_hint() already fully describes the window, this
   * function should not be called in addition,
   * instead you should allow the window to be treated according to
   * standard policy for its semantic type.
   * 
   * @newin{2,2}
   * 
   * @param skips_taskbar <tt>true</tt> to skip the taskbar.
   */
  void set_skip_taskbar_hint(bool skips_taskbar =  true);
  
  /** Toggles whether a window should appear in a pager (workspace
   * switcher, or other desktop utility program that displays a small
   * thumbnail representation of the windows on the desktop). If a
   * window’s semantic type as specified with set_type_hint()
   * already fully describes the window, this function should
   * not be called in addition, instead you should
   * allow the window to be treated according to standard policy for
   * its semantic type.
   * 
   * @newin{2,2}
   * 
   * @param skips_pager <tt>true</tt> to skip the pager.
   */
  void set_skip_pager_hint(bool skips_pager =  true);

  
  /** Toggles whether a window needs the user's
   * urgent attention.
   * 
   * @newin{2,8}
   * 
   * @param urgent <tt>true</tt> if the window is urgent.
   */
  void set_urgency_hint(bool urgent =  true);

  
  /** Moves the window into fullscreen mode. This means the
   * window covers the entire screen and is above any panels
   * or task bars.
   * 
   * If the window was already fullscreen, then this function does nothing.
   * 
   * On X11, asks the window manager to put @a window in a fullscreen
   * state, if the window manager supports this operation. Not all
   * window managers support this, and some deliberately ignore it or
   * don’t have a concept of “fullscreen”; so you can’t rely on the
   * fullscreenification actually happening. But it will happen with
   * most standard window managers, and GDK makes a best effort to get
   * it to happen.
   * 
   * @newin{2,2}
   * 
   */
  void fullscreen();
  
  /** Specifies whether the @a window should span over all monitors (in a multi-head
   * setup) or only the current monitor when in fullscreen mode.
   * 
   * The @a mode argument is from the Gdk::FullscreenMode enumeration.
   * If Gdk::FULLSCREEN_ON_ALL_MONITORS is specified, the fullscreen @a window will
   * span over all monitors from the Gdk::Screen.
   * 
   * On X11, searches through the list of monitors from the Gdk::Screen the ones
   * which delimit the 4 edges of the entire Gdk::Screen and will ask the window
   * manager to span the @a window over these monitors.
   * 
   * If the XINERAMA extension is not available or not usable, this function
   * has no effect.
   * 
   * Not all window managers support this, so you can’t rely on the fullscreen
   * window to span over the multiple monitors when Gdk::FULLSCREEN_ON_ALL_MONITORS
   * is specified.
   * 
   * @newin{3,8}
   * 
   * @param mode Fullscreen mode.
   */
  void set_fullscreen_mode(FullscreenMode mode);
  
  /** Obtains the Gdk::FullscreenMode of the @a window.
   * 
   * @newin{3,8}
   * 
   * @return The Gdk::FullscreenMode applied to the window when fullscreen.
   */
  FullscreenMode get_fullscreen_mode() const;
  
  /** Moves the window out of fullscreen mode. If the window was not
   * fullscreen, does nothing.
   * 
   * On X11, asks the window manager to move @a window out of the fullscreen
   * state, if the window manager supports this operation. Not all
   * window managers support this, and some deliberately ignore it or
   * don’t have a concept of “fullscreen”; so you can’t rely on the
   * unfullscreenification actually happening. But it will happen with
   * most standard window managers, and GDK makes a best effort to get
   * it to happen.
   * 
   * @newin{2,2}
   * 
   */
  void unfullscreen();

   //deprecated

  
  /** Set if @a window must be kept above other windows. If the
   * window was already above, then this function does nothing.
   * 
   * On X11, asks the window manager to keep @a window above, if the window
   * manager supports this operation. Not all window managers support
   * this, and some deliberately ignore it or don’t have a concept of
   * “keep above”; so you can’t rely on the window being kept above.
   * But it will happen with most standard window managers,
   * and GDK makes a best effort to get it to happen.
   * 
   * @newin{2,4}
   * 
   * @param setting Whether to keep @a window above other windows.
   */
  void set_keep_above(bool setting =  true);
  
  /** Set if @a window must be kept below other windows. If the
   * window was already below, then this function does nothing.
   * 
   * On X11, asks the window manager to keep @a window below, if the window
   * manager supports this operation. Not all window managers support
   * this, and some deliberately ignore it or don’t have a concept of
   * “keep below”; so you can’t rely on the window being kept below.
   * But it will happen with most standard window managers,
   * and GDK makes a best effort to get it to happen.
   * 
   * @newin{2,4}
   * 
   * @param setting Whether to keep @a window below other windows.
   */
  void set_keep_below(bool setting =  true);

  
  /** Set @a window to render as partially transparent,
   * with opacity 0 being fully transparent and 1 fully opaque. (Values
   * of the opacity parameter are clamped to the [0,1] range.) 
   * 
   * For toplevel windows this depends on support from the windowing system
   * that may not always be there. For instance, On X11, this works only on
   * X screens with a compositing manager running.
   * 
   * For child windows this function only works for non-native windows.
   * 
   * For setting up per-pixel alpha topelevels, see Gdk::Screen::get_rgba_visual(),
   * and for non-toplevels, see set_composited().
   * 
   * Support for non-toplevel windows was added in 3.8.
   * 
   * @newin{2,12}
   * 
   * @param opacity Opacity.
   */
  void set_opacity(double opacity);

  
  /** Determines whether or not the desktop environment shuld be hinted that
   * the window does not want to receive input focus.
   * 
   * @newin{2,22}
   * 
   * @return Whether or not the window should receive input focus.
   */
  bool get_accept_focus() const;
  
  /** Setting @a accept_focus to <tt>false</tt> hints the desktop environment that the
   * window doesn’t want to receive input focus.
   * 
   * On X, it is the responsibility of the window manager to interpret this
   * hint. ICCCM-compliant window manager usually respect it.
   * 
   * @newin{2,4}
   * 
   * @param accept_focus <tt>true</tt> if the window should receive input focus.
   */
  void set_accept_focus(bool accept_focus =  true);

  
  /** Determines whether or not the desktop environment should be hinted that the
   * window does not want to receive input focus when it is mapped.
   * 
   * @newin{2,22}
   * 
   * @return Whether or not the window wants to receive input focus when
   * it is mapped.
   */
  bool get_focus_on_map() const;
  
  /** Setting @a focus_on_map to <tt>false</tt> hints the desktop environment that the
   * window doesn’t want to receive input focus when it is mapped.
   * focus_on_map should be turned off for windows that aren’t triggered
   * interactively (such as popups from network activity).
   * 
   * On X, it is the responsibility of the window manager to interpret
   * this hint. %Window managers following the freedesktop.org window
   * manager extension specification should respect it.
   * 
   * @newin{2,6}
   * 
   * @param focus_on_map <tt>true</tt> if the window should receive input focus when mapped.
   */
  void set_focus_on_map(bool focus_on_map);

  
  /** Obtains the root window (parent all other windows are inside)
   * for the default display and screen.
   * 
   * @return The default root window.
   */
  static Glib::RefPtr<Window> get_default_root_window();

  
  /** Gets the offscreen surface that an offscreen window renders into.
   * If you need to keep this around over window resizes, you need to
   * add a reference to it.
   * 
   * @param window A Gdk::Window.
   * @return The offscreen surface, or
   * <tt>0</tt> if not offscreen.
   */
  ::Cairo::RefPtr< ::Cairo::Surface> get_offscreen_surface();
  
  /** Gets the offscreen surface that an offscreen window renders into.
   * If you need to keep this around over window resizes, you need to
   * add a reference to it.
   * 
   * @param window A Gdk::Window.
   * @return The offscreen surface, or
   * <tt>0</tt> if not offscreen.
   */
  ::Cairo::RefPtr<const ::Cairo::Surface> get_offscreen_surface() const;

  
  /** Gets the window that @a window is embedded in.
   * 
   * @newin{2,18}
   * 
   * @param window A Gdk::Window.
   * @return The embedding Gdk::Window, or
   * <tt>0</tt> if @a window is not an mbedded offscreen window.
   */
  Glib::RefPtr<Window> get_offscreen_embedder();
  
  /** Gets the window that @a window is embedded in.
   * 
   * @newin{2,18}
   * 
   * @param window A Gdk::Window.
   * @return The embedding Gdk::Window, or
   * <tt>0</tt> if @a window is not an mbedded offscreen window.
   */
  Glib::RefPtr<const Window> get_offscreen_embedder() const;

  
  /** Sets @a window to be embedded in @a embedder.
   * 
   * To fully embed an offscreen window, in addition to calling this
   * function, it is also necessary to handle the Gdk::Window::signal_pick_embedded_child()
   * signal on the @a embedder and the Gdk::Window::signal_to_embedder() and
   * Gdk::Window::signal_from_embedder() signals on @a window.
   * 
   * @newin{2,18}
   * 
   * @param window A Gdk::Window.
   * @param embedder The Gdk::Window that @a window gets embedded in.
   */
  void set_offscreen_embedder(const Glib::RefPtr<Window>& embedder);

  
  /** This function informs GDK that the geometry of an embedded
   * offscreen window has changed. This is necessary for GDK to keep
   * track of which offscreen window the pointer is in.
   * 
   * @newin{2,18}
   * 
   */
  void geometry_changed();

  
  /** This function will enable multidevice features in @a window.
   * 
   * Multidevice aware windows will need to handle properly multiple,
   * per device enter/leave events, device grabs and grab ownerships.
   * 
   * @newin{3,0}
   * 
   * @param support_multidevice <tt>true</tt> to enable multidevice support in @a window.
   */
  void set_support_multidevice(bool support_multidevice =  true);
  
  /** Returns <tt>true</tt> if the window is aware of the existence of multiple
   * devices.
   * 
   * @newin{3,0}
   * 
   * @return <tt>true</tt> if the window handles multidevice features.
   */
  bool get_support_multidevice();

 
  //This is const because it returns a copy (though that is not very clear from the C documentation)
  
  /** Computes the region of a window that potentially can be written
   * to by drawing primitives. This region may not take into account
   * other factors such as if the window is obscured by other windows,
   * but no area outside of this region will be affected by drawing
   * primitives.
   * 
   * @return A #cairo_region_t. This must be freed with cairo_region_destroy()
   * when you are done.
   */
  ::Cairo::RefPtr< ::Cairo::Region> get_clip_region() const;

  //This is const because it returns a copy (though that is not very clear from the C documentation)
  
  /** Computes the region of the @a window that is potentially visible.
   * This does not necessarily take into account if the window is
   * obscured by other windows, but no area outside of this region
   * is visible.
   * 
   * @return A #cairo_region_t. This must be freed with cairo_region_destroy()
   * when you are done.
   */
  ::Cairo::RefPtr< ::Cairo::Region> get_visible_region() const;

 
  /** Creates a Cairo context for drawing to @a drawable.
   * 
   * @newin{2,10}
   * 
   * @return A newly created Cairo context.
   */
  ::Cairo::RefPtr< ::Cairo::Context> create_cairo_context();

  //TODO: Wrap these? Find out when they are emitted and if they are useful outside of GTK+, and improve the C docs.
  //_WRAP_SIGNAL(Glib::RefPtr<Gdk::Window> pick_embedded_child(double x, double y), pick-embedded-child, no_default_handler)
  //_WRAP_SIGNAL(Glib::RefPtr<Gdk::Window> to_embedder(double offscreen_x, double offscreen_y, double& embedder_x, double& embedder_y), to-embedder, no_default_handler)
  //_WRAP_SIGNAL(Glib::RefPtr<Gdk::Window> from_embedder(double embedder_x, double embedder_y, double& offscreen_x, double& offscreen_y), from-embedder, no_default_handler)

  
  /** For optimizization purposes, compositing window managers may
   * like to not draw obscured regions of windows, or turn off blending
   * during for these regions. With RGB windows with no transparency,
   * this is just the shape of the window, but with ARGB32 windows, the
   * compositor does not know what regions of the window are transparent
   * or not.
   * 
   * This function only works for toplevel windows.
   * 
   * GTK+ will automatically update this property automatically if
   * the @a window background is opaque, as we know where the opaque regions
   * are. If your window background is not opaque, please update this
   * property in your Gtk::Widget::signal_style_updated() handler.
   * 
   * @newin{3,10}
   * 
   * @param region A region.
   */
  void set_opaque_region(const ::Cairo::RefPtr<const ::Cairo::Region>& region);


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Cursor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Cursor> > property_cursor() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Cursor.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Cursor> > property_cursor() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::Window
   */
  Glib::RefPtr<Gdk::Window> wrap(GdkWindow* object, bool take_copy = false);
}


#endif /* _GDKMM_WINDOW_H */

