/* avatar-cache.c generated by valac 0.24.0, the Vala compiler
 * generated from avatar-cache.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_TYPE_AVATAR_CACHE (folks_avatar_cache_get_type ())
#define FOLKS_AVATAR_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_AVATAR_CACHE, FolksAvatarCache))
#define FOLKS_AVATAR_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_AVATAR_CACHE, FolksAvatarCacheClass))
#define FOLKS_IS_AVATAR_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_AVATAR_CACHE))
#define FOLKS_IS_AVATAR_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_AVATAR_CACHE))
#define FOLKS_AVATAR_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_AVATAR_CACHE, FolksAvatarCacheClass))

typedef struct _FolksAvatarCache FolksAvatarCache;
typedef struct _FolksAvatarCacheClass FolksAvatarCacheClass;
typedef struct _FolksAvatarCachePrivate FolksAvatarCachePrivate;
typedef struct _DelegateWrapper DelegateWrapper;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_queue_free__delegate_wrapper_free0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__delegate_wrapper_free0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FolksAvatarCacheLoadAvatarData FolksAvatarCacheLoadAvatarData;
#define _delegate_wrapper_free0(var) ((var == NULL) ? NULL : (var = (delegate_wrapper_free (var), NULL)))
typedef struct _FolksAvatarCacheStoreAvatarData FolksAvatarCacheStoreAvatarData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksAvatarCacheStoreAvatarUnlimitedData FolksAvatarCacheStoreAvatarUnlimitedData;
typedef struct _FolksAvatarCacheRemoveAvatarData FolksAvatarCacheRemoveAvatarData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksAvatarCache {
	GObject parent_instance;
	FolksAvatarCachePrivate * priv;
};

struct _FolksAvatarCacheClass {
	GObjectClass parent_class;
};

struct _FolksAvatarCachePrivate {
	GFile* _cache_directory;
	guint _n_ongoing_stores;
	GQueue* _pending_stores;
};

struct _FolksAvatarCacheLoadAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksAvatarCache* self;
	gchar* id;
	GLoadableIcon* result;
	GFile* avatar_file;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* _tmp6_;
	gboolean _tmp7_;
	GFile* _tmp8_;
	GFileIcon* _tmp9_;
};

struct _DelegateWrapper {
	GSourceFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
};

struct _FolksAvatarCacheStoreAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksAvatarCache* self;
	gchar* id;
	GLoadableIcon* avatar;
	gchar* result;
	gchar* avatar_uri;
	gchar* _tmp0_;
	guint _tmp1_;
	DelegateWrapper* wrapper;
	DelegateWrapper* _tmp2_;
	DelegateWrapper* _tmp3_;
	GQueue* _tmp4_;
	DelegateWrapper* _tmp5_;
	guint _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	GLoadableIcon* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	guint _tmp12_;
	DelegateWrapper* _vala1_wrapper;
	GQueue* _tmp13_;
	gpointer _tmp14_;
	DelegateWrapper* _tmp15_;
	DelegateWrapper* _tmp16_;
	GSourceFunc _tmp17_;
	void* _tmp17__target;
	GError * _inner_error_;
};

struct _FolksAvatarCacheStoreAvatarUnlimitedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksAvatarCache* self;
	gchar* id;
	GLoadableIcon* avatar;
	gchar* result;
	GFile* dest_avatar_file;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GInputStream* src_avatar_stream;
	GLoadableIcon* _tmp6_;
	GInputStream* _tmp7_;
	GOutputStream* dest_avatar_stream;
	GFileOutputStream* _tmp8_;
	GFile* _tmp9_;
	GFileOutputStream* _tmp10_;
	GFileOutputStream* _tmp11_;
	GOutputStream* _tmp12_;
	GInputStream* _tmp13_;
	GOutputStream* _tmp14_;
	GError* e;
	GError* _tmp15_;
	GOutputStream* _tmp16_;
	GOutputStream* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	GInputStream* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	GError * _inner_error_;
};

struct _FolksAvatarCacheRemoveAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksAvatarCache* self;
	gchar* id;
	GFile* avatar_file;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* _tmp6_;
	GError* e;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError * _inner_error_;
};


static gpointer folks_avatar_cache_parent_class = NULL;
static FolksAvatarCache* folks_avatar_cache__instance;
static GStaticRecMutex __lock_folks_avatar_cache__instance = {0};
static FolksAvatarCache* folks_avatar_cache__instance = NULL;

GType folks_avatar_cache_get_type (void) G_GNUC_CONST;
void delegate_wrapper_free (DelegateWrapper* self);
#define FOLKS_AVATAR_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_AVATAR_CACHE, FolksAvatarCachePrivate))
enum  {
	FOLKS_AVATAR_CACHE_DUMMY_PROPERTY
};
static void _delegate_wrapper_free0_ (gpointer var);
static void _g_queue_free__delegate_wrapper_free0_ (GQueue* self);
#define FOLKS_AVATAR_CACHE__max_n_ongoing_stores ((guint) 10)
static FolksAvatarCache* folks_avatar_cache_new (void);
static FolksAvatarCache* folks_avatar_cache_construct (GType object_type);
FolksAvatarCache* folks_avatar_cache_dup (void);
static void folks_avatar_cache_load_avatar_data_free (gpointer _data);
void folks_avatar_cache_load_avatar (FolksAvatarCache* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
GLoadableIcon* folks_avatar_cache_load_avatar_finish (FolksAvatarCache* self, GAsyncResult* _res_, GError** error);
static gboolean folks_avatar_cache_load_avatar_co (FolksAvatarCacheLoadAvatarData* _data_);
static GFile* _folks_avatar_cache_get_avatar_file (FolksAvatarCache* self, const gchar* id);
static void folks_avatar_cache_store_avatar_data_free (gpointer _data);
void folks_avatar_cache_store_avatar (FolksAvatarCache* self, const gchar* id, GLoadableIcon* avatar, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* folks_avatar_cache_store_avatar_finish (FolksAvatarCache* self, GAsyncResult* _res_, GError** error);
static gboolean folks_avatar_cache_store_avatar_co (FolksAvatarCacheStoreAvatarData* _data_);
DelegateWrapper* delegate_wrapper_new (void);
DelegateWrapper* delegate_wrapper_new (void);
static gboolean _folks_avatar_cache_store_avatar_co_gsource_func (gpointer self);
static void _folks_avatar_cache_store_avatar_unlimited (FolksAvatarCache* self, const gchar* id, GLoadableIcon* avatar, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* _folks_avatar_cache_store_avatar_unlimited_finish (FolksAvatarCache* self, GAsyncResult* _res_, GError** error);
static void folks_avatar_cache_store_avatar_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_avatar_cache_store_avatar_unlimited_data_free (gpointer _data);
static gboolean _folks_avatar_cache_store_avatar_unlimited_co (FolksAvatarCacheStoreAvatarUnlimitedData* _data_);
static void _folks_avatar_cache_store_avatar_unlimited_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_avatar_cache_create_cache_directory (FolksAvatarCache* self, GError** error);
gchar* folks_avatar_cache_build_uri_for_avatar (FolksAvatarCache* self, const gchar* id);
static void folks_avatar_cache_remove_avatar_data_free (gpointer _data);
void folks_avatar_cache_remove_avatar (FolksAvatarCache* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_avatar_cache_remove_avatar_finish (FolksAvatarCache* self, GAsyncResult* _res_, GError** error);
static gboolean folks_avatar_cache_remove_avatar_co (FolksAvatarCacheRemoveAvatarData* _data_);
static GObject * folks_avatar_cache_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void folks_avatar_cache_finalize (GObject* obj);
static void delegate_wrapper_instance_init (DelegateWrapper * self);


static void _delegate_wrapper_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (delegate_wrapper_free (var), NULL));
}


static void _g_queue_free__delegate_wrapper_free0_ (GQueue* self) {
	g_queue_foreach (self, (GFunc) _delegate_wrapper_free0_, NULL);
	g_queue_free (self);
}


/**
   * Private constructor for an instance of the avatar cache. The singleton
   * instance should be retrieved by calling {@link AvatarCache.dup()} instead.
   *
   * @since 0.6.0
   */
static FolksAvatarCache* folks_avatar_cache_construct (GType object_type) {
	FolksAvatarCache * self = NULL;
	self = (FolksAvatarCache*) g_object_new (object_type, NULL);
	return self;
}


static FolksAvatarCache* folks_avatar_cache_new (void) {
	return folks_avatar_cache_construct (FOLKS_TYPE_AVATAR_CACHE);
}


/**
   * Create or return the singleton {@link Folks.AvatarCache} class instance.
   * If the instance doesn't exist already, it will be created.
   *
   * This function is thread-safe.
   *
   * @return Singleton {@link Folks.AvatarCache} instance
   * @since 0.6.0
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FolksAvatarCache* folks_avatar_cache_dup (void) {
	FolksAvatarCache* result = NULL;
	GError * _inner_error_ = NULL;
	{
		FolksAvatarCache* _tmp0_ = NULL;
		_tmp0_ = folks_avatar_cache__instance;
		g_static_rec_mutex_lock (&__lock_folks_avatar_cache__instance);
		{
			FolksAvatarCache* _retval = NULL;
			FolksAvatarCache* _tmp1_ = NULL;
			FolksAvatarCache* _tmp2_ = NULL;
			FolksAvatarCache* retval = NULL;
			FolksAvatarCache* _tmp3_ = NULL;
			_tmp1_ = folks_avatar_cache__instance;
			_tmp2_ = _g_object_ref0 (_tmp1_);
			_retval = _tmp2_;
			_tmp3_ = _retval;
			if (_tmp3_ == NULL) {
				FolksAvatarCache* _tmp4_ = NULL;
				FolksAvatarCache* _tmp5_ = NULL;
				_tmp4_ = folks_avatar_cache_new ();
				_g_object_unref0 (retval);
				retval = _tmp4_;
				_tmp5_ = retval;
				folks_avatar_cache__instance = _tmp5_;
			} else {
				FolksAvatarCache* _tmp6_ = NULL;
				FolksAvatarCache* _tmp7_ = NULL;
				_tmp6_ = _retval;
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, FOLKS_TYPE_AVATAR_CACHE, FolksAvatarCache));
				_g_object_unref0 (retval);
				retval = _tmp7_;
			}
			result = retval;
			_g_object_unref0 (_retval);
			{
				FolksAvatarCache* _tmp8_ = NULL;
				_tmp8_ = folks_avatar_cache__instance;
				g_static_rec_mutex_unlock (&__lock_folks_avatar_cache__instance);
			}
			return result;
		}
		__finally36:
		{
			FolksAvatarCache* _tmp9_ = NULL;
			_tmp9_ = folks_avatar_cache__instance;
			g_static_rec_mutex_unlock (&__lock_folks_avatar_cache__instance);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void folks_avatar_cache_load_avatar_data_free (gpointer _data) {
	FolksAvatarCacheLoadAvatarData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksAvatarCacheLoadAvatarData, _data_);
}


void folks_avatar_cache_load_avatar (FolksAvatarCache* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksAvatarCacheLoadAvatarData* _data_;
	FolksAvatarCache* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_data_ = g_slice_new0 (FolksAvatarCacheLoadAvatarData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_avatar_cache_load_avatar);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_avatar_cache_load_avatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	folks_avatar_cache_load_avatar_co (_data_);
}


GLoadableIcon* folks_avatar_cache_load_avatar_finish (FolksAvatarCache* self, GAsyncResult* _res_, GError** error) {
	GLoadableIcon* result;
	FolksAvatarCacheLoadAvatarData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Fetch an avatar from the cache by its globally unique ID.
   *
   * It is up to the caller to ensure that file I/O is rate-limited when loading
   * many avatars in parallel, by limiting calls to {@link LoadableIcon.load}.
   *
   * @param id the globally unique ID for the avatar
   * @return Avatar from the cache, or ``null`` if it doesn't exist in the cache
   * @throws GLib.Error if checking for existence of the cache file failed
   * @since 0.6.0
   */
static gboolean folks_avatar_cache_load_avatar_co (FolksAvatarCacheLoadAvatarData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->id;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _folks_avatar_cache_get_avatar_file (_data_->self, _data_->_tmp0_);
	_data_->avatar_file = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->id;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->avatar_file;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_file_get_uri (_data_->_tmp3_);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	g_debug ("avatar-cache.vala:129: Loading avatar '%s' from file '%s'.", _data_->_tmp2_, _data_->_tmp5_);
	_g_free0 (_data_->_tmp5_);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->avatar_file;
	_data_->_tmp7_ = FALSE;
	_data_->_tmp7_ = g_file_query_exists (_data_->_tmp6_, NULL);
	if (_data_->_tmp7_ == FALSE) {
		_data_->result = NULL;
		_g_object_unref0 (_data_->avatar_file);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->avatar_file;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = (GFileIcon*) g_file_icon_new (_data_->_tmp8_);
	_data_->result = (GLoadableIcon*) _data_->_tmp9_;
	_g_object_unref0 (_data_->avatar_file);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->avatar_file);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_avatar_cache_store_avatar_data_free (gpointer _data) {
	FolksAvatarCacheStoreAvatarData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->avatar);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksAvatarCacheStoreAvatarData, _data_);
}


void folks_avatar_cache_store_avatar (FolksAvatarCache* self, const gchar* id, GLoadableIcon* avatar, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksAvatarCacheStoreAvatarData* _data_;
	FolksAvatarCache* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GLoadableIcon* _tmp3_ = NULL;
	GLoadableIcon* _tmp4_ = NULL;
	_data_ = g_slice_new0 (FolksAvatarCacheStoreAvatarData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_avatar_cache_store_avatar);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_avatar_cache_store_avatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	_tmp3_ = avatar;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->avatar);
	_data_->avatar = _tmp4_;
	folks_avatar_cache_store_avatar_co (_data_);
}


gchar* folks_avatar_cache_store_avatar_finish (FolksAvatarCache* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	FolksAvatarCacheStoreAvatarData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Store an avatar in the cache, assigning the given globally unique ID to it,
   * which can later be used to load and remove the avatar from the cache. For
   * example, this ID could be the UID of a persona. The URI of the cached
   * avatar file will be returned.
   *
   * This method may be called multiple times concurrently for the same avatar
   * ID (e.g. an asynchronous call may be made, and a subsequent asynchronous
   * call may begin before the first has finished).
   *
   * Concurrent file I/O may be rate limited within each {@link AvatarCache}
   * instance to avoid file descriptor exhaustion.
   *
   * @param id the globally unique ID for the avatar
   * @param avatar the avatar data to cache
   * @return a URI for the file storing the cached avatar
   * @throws GLib.Error if the avatar data couldn't be loaded, or if creating
   * the avatar directory or cache file failed
   * @since 0.6.0
   */
static gboolean _folks_avatar_cache_store_avatar_co_gsource_func (gpointer self) {
	gboolean result;
	result = folks_avatar_cache_store_avatar_co (self);
	return result;
}


static void folks_avatar_cache_store_avatar_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksAvatarCacheStoreAvatarData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_avatar_cache_store_avatar_co (_data_);
}


static gboolean folks_avatar_cache_store_avatar_co (FolksAvatarCacheStoreAvatarData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_strdup ("");
	_data_->avatar_uri = _data_->_tmp0_;
	_data_->_tmp1_ = 0U;
	_data_->_tmp1_ = _data_->self->priv->_n_ongoing_stores;
	if (_data_->_tmp1_ > FOLKS_AVATAR_CACHE__max_n_ongoing_stores) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = delegate_wrapper_new ();
		_data_->wrapper = _data_->_tmp2_;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->wrapper;
		(_data_->_tmp3_->cb_target_destroy_notify == NULL) ? NULL : (_data_->_tmp3_->cb_target_destroy_notify (_data_->_tmp3_->cb_target), NULL);
		_data_->_tmp3_->cb = NULL;
		_data_->_tmp3_->cb_target = NULL;
		_data_->_tmp3_->cb_target_destroy_notify = NULL;
		_data_->_tmp3_->cb = _folks_avatar_cache_store_avatar_co_gsource_func;
		_data_->_tmp3_->cb_target = _data_;
		_data_->_tmp3_->cb_target_destroy_notify = NULL;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->self->priv->_pending_stores;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->wrapper;
		_data_->wrapper = NULL;
		g_queue_push_tail (_data_->_tmp4_, _data_->_tmp5_);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_delegate_wrapper_free0 (_data_->wrapper);
	}
	{
		_data_->_tmp6_ = 0U;
		_data_->_tmp6_ = _data_->self->priv->_n_ongoing_stores;
		_data_->self->priv->_n_ongoing_stores = _data_->_tmp6_ + 1;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->id;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->avatar;
		_data_->_state_ = 2;
		_folks_avatar_cache_store_avatar_unlimited (_data_->self, _data_->_tmp8_, _data_->_tmp9_, folks_avatar_cache_store_avatar_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _folks_avatar_cache_store_avatar_unlimited_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp7_ = _data_->_tmp10_;
		if (_data_->_inner_error_ != NULL) {
			goto __finally37;
		}
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->_tmp7_;
		_data_->_tmp7_ = NULL;
		_g_free0 (_data_->avatar_uri);
		_data_->avatar_uri = _data_->_tmp11_;
		_g_free0 (_data_->_tmp7_);
	}
	__finally37:
	{
		_data_->_tmp12_ = 0U;
		_data_->_tmp12_ = _data_->self->priv->_n_ongoing_stores;
		_data_->self->priv->_n_ongoing_stores = _data_->_tmp12_ - 1;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->self->priv->_pending_stores;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = g_queue_pop_head (_data_->_tmp13_);
		_data_->_vala1_wrapper = (DelegateWrapper*) _data_->_tmp14_;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->_vala1_wrapper;
		if (_data_->_tmp15_ != NULL) {
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->_vala1_wrapper;
			_data_->_tmp17_ = NULL;
			_data_->_tmp17__target = NULL;
			_data_->_tmp17_ = _data_->_tmp16_->cb;
			_data_->_tmp17__target = _data_->_tmp16_->cb_target;
			_data_->_tmp17_ (_data_->_tmp17__target);
		}
		_delegate_wrapper_free0 (_data_->_vala1_wrapper);
	}
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->avatar_uri);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->avatar_uri;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_free0 (_data_->avatar_uri);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_avatar_cache_store_avatar_unlimited_data_free (gpointer _data) {
	FolksAvatarCacheStoreAvatarUnlimitedData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->avatar);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksAvatarCacheStoreAvatarUnlimitedData, _data_);
}


static void _folks_avatar_cache_store_avatar_unlimited (FolksAvatarCache* self, const gchar* id, GLoadableIcon* avatar, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksAvatarCacheStoreAvatarUnlimitedData* _data_;
	FolksAvatarCache* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GLoadableIcon* _tmp3_ = NULL;
	GLoadableIcon* _tmp4_ = NULL;
	_data_ = g_slice_new0 (FolksAvatarCacheStoreAvatarUnlimitedData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_avatar_cache_store_avatar_unlimited);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_avatar_cache_store_avatar_unlimited_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	_tmp3_ = avatar;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->avatar);
	_data_->avatar = _tmp4_;
	_folks_avatar_cache_store_avatar_unlimited_co (_data_);
}


static gchar* _folks_avatar_cache_store_avatar_unlimited_finish (FolksAvatarCache* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	FolksAvatarCacheStoreAvatarUnlimitedData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _folks_avatar_cache_store_avatar_unlimited_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksAvatarCacheStoreAvatarUnlimitedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_avatar_cache_store_avatar_unlimited_co (_data_);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean _folks_avatar_cache_store_avatar_unlimited_co (FolksAvatarCacheStoreAvatarUnlimitedData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->id;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _folks_avatar_cache_get_avatar_file (_data_->self, _data_->_tmp0_);
	_data_->dest_avatar_file = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->id;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->dest_avatar_file;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_file_get_uri (_data_->_tmp3_);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	g_debug ("avatar-cache.vala:200: Storing avatar '%s' in file '%s'.", _data_->_tmp2_, _data_->_tmp5_);
	_g_free0 (_data_->_tmp5_);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->avatar;
	_data_->_state_ = 1;
	g_loadable_icon_load_async (_data_->_tmp6_, -1, NULL, _folks_avatar_cache_store_avatar_unlimited_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_loadable_icon_load_finish (_data_->_tmp6_, _data_->_res_, NULL, &_data_->_inner_error_);
	_data_->src_avatar_stream = _data_->_tmp7_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->dest_avatar_file);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	while (TRUE) {
		_data_->dest_avatar_stream = NULL;
		{
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->dest_avatar_file;
			_data_->_state_ = 2;
			g_file_replace_async (_data_->_tmp9_, NULL, FALSE, G_FILE_CREATE_PRIVATE, G_PRIORITY_DEFAULT, NULL, _folks_avatar_cache_store_avatar_unlimited_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = g_file_replace_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp8_ = _data_->_tmp10_;
			if (_data_->_inner_error_ != NULL) {
				goto __catch38_g_error;
			}
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->_tmp8_;
			_data_->_tmp8_ = NULL;
			_g_object_unref0 (_data_->dest_avatar_stream);
			_data_->dest_avatar_stream = (GOutputStream*) _data_->_tmp11_;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->dest_avatar_stream;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->src_avatar_stream;
			_data_->_state_ = 3;
			g_output_stream_splice_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, G_TYPE_OUTPUT_STREAM, GOutputStream), _data_->_tmp13_, G_OUTPUT_STREAM_SPLICE_NONE, G_PRIORITY_DEFAULT, NULL, _folks_avatar_cache_store_avatar_unlimited_ready, _data_);
			return FALSE;
			_state_3:
			g_output_stream_splice_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, G_TYPE_OUTPUT_STREAM, GOutputStream), _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				_g_object_unref0 (_data_->_tmp8_);
				goto __catch38_g_error;
			}
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = _data_->dest_avatar_stream;
			_data_->_state_ = 4;
			g_output_stream_close_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, G_TYPE_OUTPUT_STREAM, GOutputStream), G_PRIORITY_DEFAULT, NULL, _folks_avatar_cache_store_avatar_unlimited_ready, _data_);
			return FALSE;
			_state_4:
			g_output_stream_close_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, G_TYPE_OUTPUT_STREAM, GOutputStream), _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				_g_object_unref0 (_data_->_tmp8_);
				goto __catch38_g_error;
			}
			_g_object_unref0 (_data_->_tmp8_);
			_g_object_unref0 (_data_->dest_avatar_stream);
			break;
		}
		goto __finally38;
		__catch38_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->e;
			if (g_error_matches (_data_->_tmp15_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				_folks_avatar_cache_create_cache_directory (_data_->self, &_data_->_inner_error_);
				if (_data_->_inner_error_ != NULL) {
					_g_error_free0 (_data_->e);
					goto __finally38;
				}
				_g_error_free0 (_data_->e);
				_g_object_unref0 (_data_->dest_avatar_stream);
				continue;
			}
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->dest_avatar_stream;
			if (_data_->_tmp16_ != NULL) {
				_data_->_tmp17_ = NULL;
				_data_->_tmp17_ = _data_->dest_avatar_stream;
				_data_->_state_ = 5;
				g_output_stream_close_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, G_TYPE_OUTPUT_STREAM, GOutputStream), G_PRIORITY_DEFAULT, NULL, _folks_avatar_cache_store_avatar_unlimited_ready, _data_);
				return FALSE;
				_state_5:
				g_output_stream_close_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, G_TYPE_OUTPUT_STREAM, GOutputStream), _data_->_res_, &_data_->_inner_error_);
				if (_data_->_inner_error_ != NULL) {
					_g_error_free0 (_data_->e);
					goto __finally38;
				}
			}
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _data_->e;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _g_error_copy0 (_data_->_tmp18_);
			_data_->_inner_error_ = _data_->_tmp19_;
			_g_error_free0 (_data_->e);
			goto __finally38;
		}
		__finally38:
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->dest_avatar_stream);
		_g_object_unref0 (_data_->src_avatar_stream);
		_g_object_unref0 (_data_->dest_avatar_file);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->src_avatar_stream;
	_data_->_state_ = 6;
	g_input_stream_close_async (_data_->_tmp20_, G_PRIORITY_DEFAULT, NULL, _folks_avatar_cache_store_avatar_unlimited_ready, _data_);
	return FALSE;
	_state_6:
	g_input_stream_close_finish (_data_->_tmp20_, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->src_avatar_stream);
		_g_object_unref0 (_data_->dest_avatar_file);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->id;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = folks_avatar_cache_build_uri_for_avatar (_data_->self, _data_->_tmp21_);
	_data_->result = _data_->_tmp22_;
	_g_object_unref0 (_data_->src_avatar_stream);
	_g_object_unref0 (_data_->dest_avatar_file);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->src_avatar_stream);
	_g_object_unref0 (_data_->dest_avatar_file);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_avatar_cache_remove_avatar_data_free (gpointer _data) {
	FolksAvatarCacheRemoveAvatarData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksAvatarCacheRemoveAvatarData, _data_);
}


void folks_avatar_cache_remove_avatar (FolksAvatarCache* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksAvatarCacheRemoveAvatarData* _data_;
	FolksAvatarCache* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_data_ = g_slice_new0 (FolksAvatarCacheRemoveAvatarData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_avatar_cache_remove_avatar);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_avatar_cache_remove_avatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	folks_avatar_cache_remove_avatar_co (_data_);
}


void folks_avatar_cache_remove_avatar_finish (FolksAvatarCache* self, GAsyncResult* _res_, GError** error) {
	FolksAvatarCacheRemoveAvatarData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Remove an avatar from the cache, if it exists in the cache. If the avatar
   * exists in the cache but there is a problem in removing it, a
   * {@link GLib.Error} will be thrown.
   *
   * @param id the globally unique ID for the avatar
   * @throws GLib.Error if deleting the cache file failed
   * @since 0.6.0
   */
static gboolean folks_avatar_cache_remove_avatar_co (FolksAvatarCacheRemoveAvatarData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->id;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _folks_avatar_cache_get_avatar_file (_data_->self, _data_->_tmp0_);
	_data_->avatar_file = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->id;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->avatar_file;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_file_get_uri (_data_->_tmp3_);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	g_debug ("avatar-cache.vala:263: Removing avatar '%s' in file '%s'.", _data_->_tmp2_, _data_->_tmp5_);
	_g_free0 (_data_->_tmp5_);
	{
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->avatar_file;
		g_file_delete (_data_->_tmp6_, NULL, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch39_g_error;
		}
	}
	goto __finally39;
	__catch39_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->e;
		if (!g_error_matches (_data_->_tmp7_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->e;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _g_error_copy0 (_data_->_tmp8_);
			_data_->_inner_error_ = _data_->_tmp9_;
			_g_error_free0 (_data_->e);
			goto __finally39;
		}
		_g_error_free0 (_data_->e);
	}
	__finally39:
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->avatar_file);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->avatar_file);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Build the URI of an avatar file in the cache from a globally unique ID.
   * This will always succeed, even if the avatar doesn't exist in the cache.
   *
   * @param id the globally unique ID for the avatar
   * @return URI of the avatar file with the given globally unique ID
   * @since 0.6.0
   */
gchar* folks_avatar_cache_build_uri_for_avatar (FolksAvatarCache* self, const gchar* id) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = _folks_avatar_cache_get_avatar_file (self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_uri (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static GFile* _folks_avatar_cache_get_avatar_file (FolksAvatarCache* self, const gchar* id) {
	GFile* result = NULL;
	gchar* escaped_uri = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GFile* file = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = g_uri_escape_string (_tmp0_, "", FALSE);
	escaped_uri = _tmp1_;
	_tmp2_ = self->priv->_cache_directory;
	_tmp3_ = g_file_get_child (_tmp2_, escaped_uri);
	file = _tmp3_;
	_tmp4_ = self->priv->_cache_directory;
	_tmp5_ = g_file_has_parent (file, _tmp4_);
	_vala_assert (_tmp5_ == TRUE, "file.has_parent (this._cache_directory) == true");
	result = file;
	_g_free0 (escaped_uri);
	return result;
}


static void _folks_avatar_cache_create_cache_directory (FolksAvatarCache* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFile* _tmp0_ = NULL;
		_tmp0_ = self->priv->_cache_directory;
		g_file_make_directory_with_parents (_tmp0_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch40_g_error;
		}
	}
	goto __finally40;
	__catch40_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		if (!g_error_matches (_tmp1_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			GError* _tmp2_ = NULL;
			GError* _tmp3_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _g_error_copy0 (_tmp2_);
			_inner_error_ = _tmp3_;
			_g_error_free0 (e);
			goto __finally40;
		}
		_g_error_free0 (e);
	}
	__finally40:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static GObject * folks_avatar_cache_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksAvatarCache * self;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	parent_class = G_OBJECT_CLASS (folks_avatar_cache_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_AVATAR_CACHE, FolksAvatarCache);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_child (_tmp2_, "folks");
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_child (_tmp4_, "avatars");
	_g_object_unref0 (self->priv->_cache_directory);
	self->priv->_cache_directory = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	return obj;
}


static void folks_avatar_cache_class_init (FolksAvatarCacheClass * klass) {
	folks_avatar_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksAvatarCachePrivate));
	G_OBJECT_CLASS (klass)->constructor = folks_avatar_cache_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_avatar_cache_finalize;
	g_static_rec_mutex_init (&__lock_folks_avatar_cache__instance);
}


static void folks_avatar_cache_instance_init (FolksAvatarCache * self) {
	GQueue* _tmp0_ = NULL;
	self->priv = FOLKS_AVATAR_CACHE_GET_PRIVATE (self);
	self->priv->_n_ongoing_stores = (guint) 0;
	_tmp0_ = g_queue_new ();
	self->priv->_pending_stores = _tmp0_;
}


static void folks_avatar_cache_finalize (GObject* obj) {
	FolksAvatarCache * self;
	GError * _inner_error_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_AVATAR_CACHE, FolksAvatarCache);
	{
		FolksAvatarCache* _tmp0_ = NULL;
		_tmp0_ = folks_avatar_cache__instance;
		g_static_rec_mutex_lock (&__lock_folks_avatar_cache__instance);
		{
			folks_avatar_cache__instance = NULL;
		}
		__finally35:
		{
			FolksAvatarCache* _tmp1_ = NULL;
			_tmp1_ = folks_avatar_cache__instance;
			g_static_rec_mutex_unlock (&__lock_folks_avatar_cache__instance);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	_g_object_unref0 (self->priv->_cache_directory);
	__g_queue_free__delegate_wrapper_free0_0 (self->priv->_pending_stores);
	G_OBJECT_CLASS (folks_avatar_cache_parent_class)->finalize (obj);
}


/**
 * A singleton persistent cache for avatars in folks.
 *
 * Avatars may be added to the cache, and referred to by a persistent
 * URI from that point onwards. The avatars will be stored on disk in the user's
 * XDG cache directory.
 *
 * The avatar cache is typically used by backends where retrieving avatars is an
 * expensive operation (for example, they have to be downloaded from the network
 * every time they're used).
 *
 * All avatars from all users of the {@link Folks.AvatarCache} are stored in the
 * same namespace, so callers must ensure that the IDs they use for avatars are
 * globally unique (e.g. by using the corresponding {@link Folks.Persona.uid}).
 *
 * Ongoing store operations ({@link Folks.AvatarCache.store_avatar}) are rate
 * limited to try and prevent file descriptor exhaustion. Load operations
 * ({@link Folks.AvatarCache.load_avatar}) must be rate limited by the client,
 * as the file I/O occurs when calling {@link LoadableIcon.load} rather than
 * when retrieving the {@link LoadableIcon} from the cache.
 *
 * @since 0.6.0
 */
GType folks_avatar_cache_get_type (void) {
	static volatile gsize folks_avatar_cache_type_id__volatile = 0;
	if (g_once_init_enter (&folks_avatar_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksAvatarCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_avatar_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksAvatarCache), 0, (GInstanceInitFunc) folks_avatar_cache_instance_init, NULL };
		GType folks_avatar_cache_type_id;
		folks_avatar_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksAvatarCache", &g_define_type_info, 0);
		g_once_init_leave (&folks_avatar_cache_type_id__volatile, folks_avatar_cache_type_id);
	}
	return folks_avatar_cache_type_id__volatile;
}


DelegateWrapper* delegate_wrapper_new (void) {
	DelegateWrapper* self;
	self = g_slice_new0 (DelegateWrapper);
	delegate_wrapper_instance_init (self);
	return self;
}


static void delegate_wrapper_instance_init (DelegateWrapper * self) {
}


void delegate_wrapper_free (DelegateWrapper* self) {
	(self->cb_target_destroy_notify == NULL) ? NULL : (self->cb_target_destroy_notify (self->cb_target), NULL);
	self->cb = NULL;
	self->cb_target = NULL;
	self->cb_target_destroy_notify = NULL;
	g_slice_free (DelegateWrapper, self);
}



