/* test-number.c generated by valac 0.22.1, the Vala compiler
 * generated from test-number.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <locale.h>


#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _number_unref0(var) ((var == NULL) ? NULL : (var = (number_unref (var), NULL)))

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __g_list_free__number_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__number_unref0_ (var), NULL)))

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;


extern gint fail_count;
gint fail_count = 0;
extern gint pass_count;
gint pass_count = 0;

void pass (const gchar* text);
void fail (const gchar* text);
void test_integer (void);
gpointer number_ref (gpointer instance);
void number_unref (gpointer instance);
GParamSpec* param_spec_number (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_number (GValue* value, gpointer v_object);
void value_take_number (GValue* value, gpointer v_object);
gpointer value_get_number (const GValue* value);
GType number_get_type (void) G_GNUC_CONST;
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
gint64 number_to_integer (Number* self);
void test_unsigned_integer (void);
Number* number_new_unsigned_integer (guint64 x);
Number* number_construct_unsigned_integer (GType object_type, guint64 x);
guint64 number_to_unsigned_integer (Number* self);
void test_fraction (void);
Number* number_new_fraction (gint64 numerator, gint64 denominator);
Number* number_construct_fraction (GType object_type, gint64 numerator, gint64 denominator);
gboolean double_matches (Number* a, gdouble b);
gdouble number_to_double (Number* self);
void test_float (void);
Number* number_new_float (gfloat value);
Number* number_construct_float (GType object_type, gfloat value);
gfloat number_to_float (Number* self);
void test_double (void);
Number* number_new_double (gdouble value);
Number* number_construct_double (GType object_type, gdouble value);
void test_complex (void);
Number* number_new_complex (Number* x, Number* y);
Number* number_construct_complex (GType object_type, Number* x, Number* y);
Number* number_real_component (Number* self);
Number* number_imaginary_component (Number* self);
void test_polar (void);
GType angle_unit_get_type (void) G_GNUC_CONST;
Number* number_new_polar (Number* r, Number* theta, AngleUnit unit);
Number* number_construct_polar (GType object_type, Number* r, Number* theta, AngleUnit unit);
void test_i (void);
Number* number_new_i (void);
Number* number_construct_i (GType object_type);
void test_pi (void);
Number* number_new_pi (void);
Number* number_construct_pi (GType object_type);
void test_eulers (void);
Number* number_new_eulers (void);
Number* number_construct_eulers (GType object_type);
void test_string (void);
Number* mp_set_from_string (const gchar* str, gint default_base);
void test_sgn (void);
Number* number_sgn (Number* self);
void test_invert_sign (void);
Number* number_invert_sign (Number* self);
void test_abs (void);
Number* number_abs (Number* self);
void test_arg (void);
Number* number_arg (Number* self, AngleUnit unit);
gboolean number_is_zero (Number* self);
void test_conjugate (void);
Number* number_conjugate (Number* self);
void test_real_component (void);
void test_imaginary_component (void);
gchar* double_string (gdouble x);
void test_integer_component (void);
Number* number_integer_component (Number* self);
void test_fractional_component (void);
Number* number_fractional_component (Number* self);
void test_fractional_part (void);
Number* number_fractional_part (Number* self);
void test_floor (void);
Number* number_floor (Number* self);
void test_ceiling (void);
Number* number_ceiling (Number* self);
void test_round (void);
Number* number_round (Number* self);
void test_reciprocal (void);
Number* number_reciprocal (Number* self);
void test_epowy (void);
Number* number_epowy (Number* self);
void test_xpowy (void);
Number* number_xpowy (Number* self, Number* y);
void test_xpowy_integer (void);
Number* number_xpowy_integer (Number* self, gint64 n);
void test_root3 (void);
Number* number_root (Number* self, gint64 n);
void test_sqrt (void);
Number* number_sqrt (Number* self);
void test_ln (void);
Number* number_ln (Number* self);
void test_logarithm2 (void);
Number* number_logarithm (Number* self, gint64 n);
void test_logarithm10 (void);
void test_is_zero (void);
void test_is_negative (void);
gboolean number_is_negative (Number* self);
void test_is_integer (void);
gboolean number_is_integer (Number* self);
void test_is_positive_integer (void);
gboolean number_is_positive_integer (Number* self);
void test_is_natural (void);
gboolean number_is_natural (Number* self);
void test_is_complex (void);
gboolean number_is_complex (Number* self);
void test_factorial (void);
Number* number_factorial (Number* self);
void test_add (void);
Number* number_add (Number* self, Number* y);
void test_subtract (void);
Number* number_subtract (Number* self, Number* y);
void test_multiply (void);
Number* number_multiply (Number* self, Number* y);
void test_multiply_integer (void);
Number* number_multiply_integer (Number* self, gint64 y);
void test_divide (void);
Number* number_divide (Number* self, Number* y);
void test_divide_integer (void);
Number* number_divide_integer (Number* self, gint64 y);
void test_modulus_divide (void);
Number* number_modulus_divide (Number* self, Number* y);
void test_sin (void);
Number* number_sin (Number* self, AngleUnit unit);
void test_cos (void);
Number* number_cos (Number* self, AngleUnit unit);
void test_and (void);
Number* number_and (Number* self, Number* y);
void test_or (void);
Number* number_or (Number* self, Number* y);
void test_xor (void);
Number* number_xor (Number* self, Number* y);
void test_not (void);
Number* number_not (Number* self, gint wordlen);
void test_shift (void);
Number* number_shift (Number* self, gint count);
void test_factorize (void);
GList* number_factorize (Number* self);
GList* factorize (gint number);
static void _number_unref0_ (gpointer var);
static void _g_list_free__number_unref0_ (GList* self);
gint _vala_main (gchar** args, int args_length1);


void pass (const gchar* text) {
	gint _tmp0_ = 0;
	_tmp0_ = pass_count;
	pass_count = _tmp0_ + 1;
}


void fail (const gchar* text) {
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_if_fail (text != NULL);
	_tmp0_ = stdout;
	_tmp1_ = text;
	fprintf (_tmp0_, "*FAIL: %s\n", _tmp1_);
	_tmp2_ = fail_count;
	fail_count = _tmp2_ + 1;
}


void test_integer (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				gint64 _tmp7_ = 0LL;
				gint _tmp8_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_integer ((gint64) _tmp4_);
				z = _tmp5_;
				_tmp6_ = z;
				_tmp7_ = number_to_integer (_tmp6_);
				_tmp8_ = a;
				if (_tmp7_ != ((gint64) _tmp8_)) {
					gint _tmp9_ = 0;
					Number* _tmp10_ = NULL;
					gint64 _tmp11_ = 0LL;
					gint _tmp12_ = 0;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					_tmp9_ = a;
					_tmp10_ = z;
					_tmp11_ = number_to_integer (_tmp10_);
					_tmp12_ = a;
					_tmp13_ = g_strdup_printf ("Number.integer (%d).to_integer () -> %lli, expected %i", _tmp9_, _tmp11_, _tmp12_);
					_tmp14_ = _tmp13_;
					fail (_tmp14_);
					_g_free0 (_tmp14_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_unsigned_integer (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				guint64 _tmp7_ = 0ULL;
				gint _tmp8_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_unsigned_integer ((guint64) _tmp4_);
				z = _tmp5_;
				_tmp6_ = z;
				_tmp7_ = number_to_unsigned_integer (_tmp6_);
				_tmp8_ = a;
				if (_tmp7_ != ((guint64) _tmp8_)) {
					gint _tmp9_ = 0;
					Number* _tmp10_ = NULL;
					guint64 _tmp11_ = 0ULL;
					gint _tmp12_ = 0;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					_tmp9_ = a;
					_tmp10_ = z;
					_tmp11_ = number_to_unsigned_integer (_tmp10_);
					_tmp12_ = a;
					_tmp13_ = g_strdup_printf ("Number.unsigned_integer (%d).to_unsigned_integer () -> %i, expected %i", _tmp9_, (gint) _tmp11_, _tmp12_);
					_tmp14_ = _tmp13_;
					fail (_tmp14_);
					_g_free0 (_tmp14_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_fraction (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = 1;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							gint _tmp9_ = 0;
							Number* _tmp10_ = NULL;
							gdouble expected = 0.0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							Number* _tmp13_ = NULL;
							gdouble _tmp14_ = 0.0;
							gboolean _tmp15_ = FALSE;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ <= 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = b;
							_tmp10_ = number_new_fraction ((gint64) _tmp8_, (gint64) _tmp9_);
							z = _tmp10_;
							_tmp11_ = a;
							_tmp12_ = b;
							expected = ((gdouble) _tmp11_) / _tmp12_;
							_tmp13_ = z;
							_tmp14_ = expected;
							_tmp15_ = double_matches (_tmp13_, _tmp14_);
							if (!_tmp15_) {
								gint _tmp16_ = 0;
								gint _tmp17_ = 0;
								Number* _tmp18_ = NULL;
								gdouble _tmp19_ = 0.0;
								gdouble _tmp20_ = 0.0;
								gchar* _tmp21_ = NULL;
								gchar* _tmp22_ = NULL;
								_tmp16_ = a;
								_tmp17_ = b;
								_tmp18_ = z;
								_tmp19_ = number_to_double (_tmp18_);
								_tmp20_ = expected;
								_tmp21_ = g_strdup_printf ("Number.fraction (%d, %d) -> %f, expected %f", _tmp16_, _tmp17_, _tmp19_, _tmp20_);
								_tmp22_ = _tmp21_;
								fail (_tmp22_);
								_g_free0 (_tmp22_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_float (void) {
	{
		gfloat a = 0.0F;
		a = -10.0f;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gfloat _tmp3_ = 0.0F;
				Number* z = NULL;
				gfloat _tmp4_ = 0.0F;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				gfloat _tmp7_ = 0.0F;
				gfloat _tmp8_ = 0.0F;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gfloat _tmp2_ = 0.0F;
					_tmp2_ = a;
					a = _tmp2_ + 0.5f;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10.0f)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_float (_tmp4_);
				z = _tmp5_;
				_tmp6_ = z;
				_tmp7_ = number_to_float (_tmp6_);
				_tmp8_ = a;
				if (_tmp7_ != _tmp8_) {
					gfloat _tmp9_ = 0.0F;
					Number* _tmp10_ = NULL;
					gfloat _tmp11_ = 0.0F;
					gfloat _tmp12_ = 0.0F;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					_tmp9_ = a;
					_tmp10_ = z;
					_tmp11_ = number_to_float (_tmp10_);
					_tmp12_ = a;
					_tmp13_ = g_strdup_printf ("Number.float (%f).to_float () -> %f, expected %f", (gdouble) _tmp9_, (gdouble) _tmp11_, (gdouble) _tmp12_);
					_tmp14_ = _tmp13_;
					fail (_tmp14_);
					_g_free0 (_tmp14_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_double (void) {
	{
		gdouble a = 0.0;
		a = -10.0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gdouble _tmp3_ = 0.0;
				Number* z = NULL;
				gdouble _tmp4_ = 0.0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				gdouble _tmp7_ = 0.0;
				gdouble _tmp8_ = 0.0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gdouble _tmp2_ = 0.0;
					_tmp2_ = a;
					a = _tmp2_ + 0.5;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10.0)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_double (_tmp4_);
				z = _tmp5_;
				_tmp6_ = z;
				_tmp7_ = number_to_double (_tmp6_);
				_tmp8_ = a;
				if (_tmp7_ != _tmp8_) {
					gdouble _tmp9_ = 0.0;
					Number* _tmp10_ = NULL;
					gdouble _tmp11_ = 0.0;
					gdouble _tmp12_ = 0.0;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					_tmp9_ = a;
					_tmp10_ = z;
					_tmp11_ = number_to_double (_tmp10_);
					_tmp12_ = a;
					_tmp13_ = g_strdup_printf ("Number.double (%f).to_double () -> %f, expected %f", _tmp9_, _tmp11_, _tmp12_);
					_tmp14_ = _tmp13_;
					fail (_tmp14_);
					_g_free0 (_tmp14_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_complex (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gint re_expected = 0;
							gint _tmp16_ = 0;
							gint im_expected = 0;
							gint _tmp17_ = 0;
							gboolean _tmp18_ = FALSE;
							Number* _tmp19_ = NULL;
							Number* _tmp20_ = NULL;
							Number* _tmp21_ = NULL;
							gint64 _tmp22_ = 0LL;
							gint _tmp23_ = 0;
							gboolean _tmp24_ = FALSE;
							gboolean _tmp30_ = FALSE;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ <= 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = number_new_integer ((gint64) _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_new_integer ((gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_new_complex (_tmp10_, _tmp13_);
							_tmp15_ = _tmp14_;
							_number_unref0 (_tmp13_);
							_number_unref0 (_tmp10_);
							z = _tmp15_;
							_tmp16_ = a;
							re_expected = _tmp16_;
							_tmp17_ = b;
							im_expected = _tmp17_;
							_tmp19_ = z;
							_tmp20_ = number_real_component (_tmp19_);
							_tmp21_ = _tmp20_;
							_tmp22_ = number_to_integer (_tmp21_);
							_tmp23_ = re_expected;
							_tmp24_ = _tmp22_ != ((gint64) _tmp23_);
							_number_unref0 (_tmp21_);
							if (_tmp24_) {
								_tmp18_ = TRUE;
							} else {
								Number* _tmp25_ = NULL;
								Number* _tmp26_ = NULL;
								Number* _tmp27_ = NULL;
								gint64 _tmp28_ = 0LL;
								gint _tmp29_ = 0;
								_tmp25_ = z;
								_tmp26_ = number_imaginary_component (_tmp25_);
								_tmp27_ = _tmp26_;
								_tmp28_ = number_to_integer (_tmp27_);
								_tmp29_ = im_expected;
								_tmp18_ = _tmp28_ != ((gint64) _tmp29_);
								_number_unref0 (_tmp27_);
							}
							_tmp30_ = _tmp18_;
							if (_tmp30_) {
								gint _tmp31_ = 0;
								gint _tmp32_ = 0;
								Number* _tmp33_ = NULL;
								Number* _tmp34_ = NULL;
								Number* _tmp35_ = NULL;
								gint64 _tmp36_ = 0LL;
								Number* _tmp37_ = NULL;
								Number* _tmp38_ = NULL;
								Number* _tmp39_ = NULL;
								gint64 _tmp40_ = 0LL;
								gint _tmp41_ = 0;
								gint _tmp42_ = 0;
								gchar* _tmp43_ = NULL;
								gchar* _tmp44_ = NULL;
								_tmp31_ = a;
								_tmp32_ = b;
								_tmp33_ = z;
								_tmp34_ = number_real_component (_tmp33_);
								_tmp35_ = _tmp34_;
								_tmp36_ = number_to_integer (_tmp35_);
								_tmp37_ = z;
								_tmp38_ = number_imaginary_component (_tmp37_);
								_tmp39_ = _tmp38_;
								_tmp40_ = number_to_integer (_tmp39_);
								_tmp41_ = re_expected;
								_tmp42_ = im_expected;
								_tmp43_ = g_strdup_printf ("Number.complex (%d%+di) -> %d%+di, expected %d%+di", _tmp31_, _tmp32_, (gint) _tmp36_, (gint) _tmp40_, _tmp41_, _tmp42_);
								_tmp44_ = _tmp43_;
								fail (_tmp44_);
								_g_free0 (_tmp44_);
								_number_unref0 (_tmp39_);
								_number_unref0 (_tmp35_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
}


void test_polar (void) {
	{
		gint ri = 0;
		ri = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = ri;
					ri = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = ri;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				{
					gint theta_i = 0;
					theta_i = -10;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							gdouble r = 0.0;
							gint _tmp8_ = 0;
							gdouble theta = 0.0;
							gint _tmp9_ = 0;
							Number* z = NULL;
							gdouble _tmp10_ = 0.0;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							gdouble _tmp13_ = 0.0;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							Number* _tmp16_ = NULL;
							Number* _tmp17_ = NULL;
							gdouble re_expected = 0.0;
							gdouble _tmp18_ = 0.0;
							gdouble _tmp19_ = 0.0;
							gdouble _tmp20_ = 0.0;
							gdouble im_expected = 0.0;
							gdouble _tmp21_ = 0.0;
							gdouble _tmp22_ = 0.0;
							gdouble _tmp23_ = 0.0;
							gboolean _tmp24_ = FALSE;
							Number* _tmp25_ = NULL;
							Number* _tmp26_ = NULL;
							Number* _tmp27_ = NULL;
							gdouble _tmp28_ = 0.0;
							gboolean _tmp29_ = FALSE;
							gboolean _tmp30_ = FALSE;
							gboolean _tmp36_ = FALSE;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = theta_i;
								theta_i = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = theta_i;
							if (!(_tmp7_ <= 10)) {
								break;
							}
							_tmp8_ = ri;
							r = (gdouble) _tmp8_;
							_tmp9_ = theta_i;
							theta = ((2 * G_PI) * _tmp9_) / 10.0;
							_tmp10_ = r;
							_tmp11_ = number_new_double (_tmp10_);
							_tmp12_ = _tmp11_;
							_tmp13_ = theta;
							_tmp14_ = number_new_double (_tmp13_);
							_tmp15_ = _tmp14_;
							_tmp16_ = number_new_polar (_tmp12_, _tmp15_, ANGLE_UNIT_RADIANS);
							_tmp17_ = _tmp16_;
							_number_unref0 (_tmp15_);
							_number_unref0 (_tmp12_);
							z = _tmp17_;
							_tmp18_ = r;
							_tmp19_ = theta;
							_tmp20_ = cos (_tmp19_);
							re_expected = _tmp18_ * _tmp20_;
							_tmp21_ = r;
							_tmp22_ = theta;
							_tmp23_ = sin (_tmp22_);
							im_expected = _tmp21_ * _tmp23_;
							_tmp25_ = z;
							_tmp26_ = number_real_component (_tmp25_);
							_tmp27_ = _tmp26_;
							_tmp28_ = re_expected;
							_tmp29_ = double_matches (_tmp27_, _tmp28_);
							_tmp30_ = !_tmp29_;
							_number_unref0 (_tmp27_);
							if (_tmp30_) {
								_tmp24_ = TRUE;
							} else {
								Number* _tmp31_ = NULL;
								Number* _tmp32_ = NULL;
								Number* _tmp33_ = NULL;
								gdouble _tmp34_ = 0.0;
								gboolean _tmp35_ = FALSE;
								_tmp31_ = z;
								_tmp32_ = number_imaginary_component (_tmp31_);
								_tmp33_ = _tmp32_;
								_tmp34_ = im_expected;
								_tmp35_ = double_matches (_tmp33_, _tmp34_);
								_tmp24_ = !_tmp35_;
								_number_unref0 (_tmp33_);
							}
							_tmp36_ = _tmp24_;
							if (_tmp36_) {
								gdouble _tmp37_ = 0.0;
								gdouble _tmp38_ = 0.0;
								Number* _tmp39_ = NULL;
								Number* _tmp40_ = NULL;
								Number* _tmp41_ = NULL;
								gdouble _tmp42_ = 0.0;
								Number* _tmp43_ = NULL;
								Number* _tmp44_ = NULL;
								Number* _tmp45_ = NULL;
								gdouble _tmp46_ = 0.0;
								gdouble _tmp47_ = 0.0;
								gdouble _tmp48_ = 0.0;
								gchar* _tmp49_ = NULL;
								gchar* _tmp50_ = NULL;
								_tmp37_ = r;
								_tmp38_ = theta;
								_tmp39_ = z;
								_tmp40_ = number_real_component (_tmp39_);
								_tmp41_ = _tmp40_;
								_tmp42_ = number_to_double (_tmp41_);
								_tmp43_ = z;
								_tmp44_ = number_imaginary_component (_tmp43_);
								_tmp45_ = _tmp44_;
								_tmp46_ = number_to_double (_tmp45_);
								_tmp47_ = re_expected;
								_tmp48_ = im_expected;
								_tmp49_ = g_strdup_printf ("Number.polar (%f, %f) -> %f%+fi, expected %f%+fi", _tmp37_, _tmp38_, _tmp42_, _tmp46_, _tmp47_, _tmp48_);
								_tmp50_ = _tmp49_;
								fail (_tmp50_);
								_g_free0 (_tmp50_);
								_number_unref0 (_tmp45_);
								_number_unref0 (_tmp41_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
}


void test_i (void) {
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp11_ = FALSE;
	_tmp0_ = number_new_i ();
	z = _tmp0_;
	_tmp2_ = z;
	_tmp3_ = number_real_component (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = number_to_integer (_tmp4_);
	_tmp6_ = _tmp5_ != ((gint64) 0);
	_number_unref0 (_tmp4_);
	if (_tmp6_) {
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		gint64 _tmp10_ = 0LL;
		_tmp7_ = z;
		_tmp8_ = number_imaginary_component (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = number_to_integer (_tmp9_);
		_tmp1_ = _tmp10_ != ((gint64) 1);
		_number_unref0 (_tmp9_);
	} else {
		_tmp1_ = FALSE;
	}
	_tmp11_ = _tmp1_;
	if (_tmp11_) {
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		gint64 _tmp15_ = 0LL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		gint64 _tmp19_ = 0LL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp12_ = z;
		_tmp13_ = number_real_component (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = number_to_integer (_tmp14_);
		_tmp16_ = z;
		_tmp17_ = number_imaginary_component (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = number_to_integer (_tmp18_);
		_tmp20_ = g_strdup_printf ("Number.i () -> %d%+di, expected i", (gint) _tmp15_, (gint) _tmp19_);
		_tmp21_ = _tmp20_;
		fail (_tmp21_);
		_g_free0 (_tmp21_);
		_number_unref0 (_tmp18_);
		_number_unref0 (_tmp14_);
		_number_unref0 (z);
		return;
	}
	pass (NULL);
	_number_unref0 (z);
}


void test_pi (void) {
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	gdouble expected = 0.0;
	Number* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = number_new_pi ();
	z = _tmp0_;
	expected = G_PI;
	_tmp1_ = z;
	_tmp2_ = expected;
	_tmp3_ = double_matches (_tmp1_, _tmp2_);
	if (!_tmp3_) {
		Number* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp4_ = z;
		_tmp5_ = number_to_double (_tmp4_);
		_tmp6_ = expected;
		_tmp7_ = g_strdup_printf ("Number.pi () -> %f, expected %f", _tmp5_, _tmp6_);
		_tmp8_ = _tmp7_;
		fail (_tmp8_);
		_g_free0 (_tmp8_);
		_number_unref0 (z);
		return;
	}
	pass (NULL);
	_number_unref0 (z);
}


void test_eulers (void) {
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	gdouble expected = 0.0;
	Number* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = number_new_eulers ();
	z = _tmp0_;
	expected = G_E;
	_tmp1_ = z;
	_tmp2_ = expected;
	_tmp3_ = double_matches (_tmp1_, _tmp2_);
	if (!_tmp3_) {
		Number* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp4_ = z;
		_tmp5_ = number_to_double (_tmp4_);
		_tmp6_ = expected;
		_tmp7_ = g_strdup_printf ("Number.eulers () -> %f, expected %f", _tmp5_, _tmp6_);
		_tmp8_ = _tmp7_;
		fail (_tmp8_);
		_g_free0 (_tmp8_);
		_number_unref0 (z);
		return;
	}
	pass (NULL);
	_number_unref0 (z);
}


void test_string (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gchar* s = NULL;
				gint _tmp4_ = 0;
				gchar* _tmp5_ = NULL;
				Number* z = NULL;
				const gchar* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				Number* _tmp12_ = NULL;
				gint64 _tmp13_ = 0LL;
				gint _tmp14_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = g_strdup_printf ("%d", _tmp4_);
				s = _tmp5_;
				_tmp6_ = s;
				_tmp7_ = mp_set_from_string (_tmp6_, 10);
				z = _tmp7_;
				_tmp8_ = z;
				if (_tmp8_ == NULL) {
					const gchar* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					_tmp9_ = s;
					_tmp10_ = g_strdup_printf ("mp_set_from_string (\"%s\") -> null", _tmp9_);
					_tmp11_ = _tmp10_;
					fail (_tmp11_);
					_g_free0 (_tmp11_);
					_number_unref0 (z);
					_g_free0 (s);
					return;
				}
				_tmp12_ = z;
				_tmp13_ = number_to_integer (_tmp12_);
				_tmp14_ = a;
				if (_tmp13_ != ((gint64) _tmp14_)) {
					const gchar* _tmp15_ = NULL;
					Number* _tmp16_ = NULL;
					gint64 _tmp17_ = 0LL;
					gint _tmp18_ = 0;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					_tmp15_ = s;
					_tmp16_ = z;
					_tmp17_ = number_to_integer (_tmp16_);
					_tmp18_ = a;
					_tmp19_ = g_strdup_printf ("mp_set_from_string (\"%s\").to_integer () -> %d, expected %d", _tmp15_, (gint) _tmp17_, _tmp18_);
					_tmp20_ = _tmp19_;
					fail (_tmp20_);
					_g_free0 (_tmp20_);
					_number_unref0 (z);
					_g_free0 (s);
					return;
				}
				_number_unref0 (z);
				_g_free0 (s);
			}
		}
	}
	pass (NULL);
}


void test_sgn (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				gint expected = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				Number* _tmp10_ = NULL;
				gint64 _tmp11_ = 0LL;
				gint _tmp12_ = 0;
				gboolean _tmp13_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_integer ((gint64) _tmp4_);
				z = _tmp5_;
				expected = 0;
				_tmp6_ = a;
				if (_tmp6_ < 0) {
					expected = -1;
				}
				_tmp7_ = a;
				if (_tmp7_ > 0) {
					expected = 1;
				}
				_tmp8_ = z;
				_tmp9_ = number_sgn (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = number_to_integer (_tmp10_);
				_tmp12_ = expected;
				_tmp13_ = _tmp11_ != ((gint64) _tmp12_);
				_number_unref0 (_tmp10_);
				if (_tmp13_) {
					gint _tmp14_ = 0;
					Number* _tmp15_ = NULL;
					Number* _tmp16_ = NULL;
					Number* _tmp17_ = NULL;
					gint64 _tmp18_ = 0LL;
					gint _tmp19_ = 0;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					_tmp14_ = a;
					_tmp15_ = z;
					_tmp16_ = number_sgn (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = number_to_integer (_tmp17_);
					_tmp19_ = expected;
					_tmp20_ = g_strdup_printf ("(%d).sgn () -> %d, expected %d", _tmp14_, (gint) _tmp18_, _tmp19_);
					_tmp21_ = _tmp20_;
					fail (_tmp21_);
					_g_free0 (_tmp21_);
					_number_unref0 (_tmp17_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_invert_sign (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				gint expected = 0;
				gint _tmp6_ = 0;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				gint64 _tmp10_ = 0LL;
				gint _tmp11_ = 0;
				gboolean _tmp12_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_integer ((gint64) _tmp4_);
				z = _tmp5_;
				_tmp6_ = a;
				expected = -_tmp6_;
				_tmp7_ = z;
				_tmp8_ = number_invert_sign (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = number_to_integer (_tmp9_);
				_tmp11_ = expected;
				_tmp12_ = _tmp10_ != ((gint64) _tmp11_);
				_number_unref0 (_tmp9_);
				if (_tmp12_) {
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					Number* _tmp15_ = NULL;
					Number* _tmp16_ = NULL;
					gint64 _tmp17_ = 0LL;
					gint _tmp18_ = 0;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					_tmp13_ = a;
					_tmp14_ = z;
					_tmp15_ = number_invert_sign (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = number_to_integer (_tmp16_);
					_tmp18_ = expected;
					_tmp19_ = g_strdup_printf ("(%d).invert_sign () -> %d, expected %d", _tmp13_, (gint) _tmp17_, _tmp18_);
					_tmp20_ = _tmp19_;
					fail (_tmp20_);
					_g_free0 (_tmp20_);
					_number_unref0 (_tmp16_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_abs (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				gint expected = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				Number* _tmp10_ = NULL;
				gint64 _tmp11_ = 0LL;
				gint _tmp12_ = 0;
				gboolean _tmp13_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_integer ((gint64) _tmp4_);
				z = _tmp5_;
				_tmp6_ = a;
				_tmp7_ = abs (_tmp6_);
				expected = _tmp7_;
				_tmp8_ = z;
				_tmp9_ = number_abs (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = number_to_integer (_tmp10_);
				_tmp12_ = expected;
				_tmp13_ = _tmp11_ != ((gint64) _tmp12_);
				_number_unref0 (_tmp10_);
				if (_tmp13_) {
					gint _tmp14_ = 0;
					Number* _tmp15_ = NULL;
					Number* _tmp16_ = NULL;
					Number* _tmp17_ = NULL;
					gint64 _tmp18_ = 0LL;
					gint _tmp19_ = 0;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					_tmp14_ = a;
					_tmp15_ = z;
					_tmp16_ = number_abs (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = number_to_integer (_tmp17_);
					_tmp19_ = expected;
					_tmp20_ = g_strdup_printf ("(%d).abs () -> %d, expected %d", _tmp14_, (gint) _tmp18_, _tmp19_);
					_tmp21_ = _tmp20_;
					fail (_tmp21_);
					_g_free0 (_tmp21_);
					_number_unref0 (_tmp17_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_arg (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							Number* _tmp16_ = NULL;
							Number* _tmp17_ = NULL;
							gdouble expected = 0.0;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gdouble _tmp20_ = 0.0;
							gboolean _tmp21_ = FALSE;
							Number* _tmp22_ = NULL;
							Number* _tmp23_ = NULL;
							Number* _tmp24_ = NULL;
							gdouble _tmp25_ = 0.0;
							gboolean _tmp26_ = FALSE;
							gboolean _tmp27_ = FALSE;
							gboolean _tmp32_ = FALSE;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ <= 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = number_new_integer ((gint64) _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_new_integer ((gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_new_complex (_tmp10_, _tmp13_);
							_tmp15_ = _tmp14_;
							_number_unref0 (_tmp13_);
							_number_unref0 (_tmp10_);
							z = _tmp15_;
							_tmp16_ = z;
							_tmp17_ = number_arg (_tmp16_, ANGLE_UNIT_RADIANS);
							_number_unref0 (z);
							z = _tmp17_;
							_tmp18_ = b;
							_tmp19_ = a;
							_tmp20_ = atan2 ((gdouble) _tmp18_, (gdouble) _tmp19_);
							expected = _tmp20_;
							_tmp22_ = z;
							_tmp23_ = number_real_component (_tmp22_);
							_tmp24_ = _tmp23_;
							_tmp25_ = expected;
							_tmp26_ = double_matches (_tmp24_, _tmp25_);
							_tmp27_ = !_tmp26_;
							_number_unref0 (_tmp24_);
							if (_tmp27_) {
								_tmp21_ = TRUE;
							} else {
								Number* _tmp28_ = NULL;
								Number* _tmp29_ = NULL;
								Number* _tmp30_ = NULL;
								gboolean _tmp31_ = FALSE;
								_tmp28_ = z;
								_tmp29_ = number_imaginary_component (_tmp28_);
								_tmp30_ = _tmp29_;
								_tmp31_ = number_is_zero (_tmp30_);
								_tmp21_ = !_tmp31_;
								_number_unref0 (_tmp30_);
							}
							_tmp32_ = _tmp21_;
							if (_tmp32_) {
								gint _tmp33_ = 0;
								gint _tmp34_ = 0;
								Number* _tmp35_ = NULL;
								Number* _tmp36_ = NULL;
								Number* _tmp37_ = NULL;
								gdouble _tmp38_ = 0.0;
								Number* _tmp39_ = NULL;
								Number* _tmp40_ = NULL;
								Number* _tmp41_ = NULL;
								gdouble _tmp42_ = 0.0;
								gdouble _tmp43_ = 0.0;
								gchar* _tmp44_ = NULL;
								gchar* _tmp45_ = NULL;
								_tmp33_ = a;
								_tmp34_ = b;
								_tmp35_ = z;
								_tmp36_ = number_real_component (_tmp35_);
								_tmp37_ = _tmp36_;
								_tmp38_ = number_to_double (_tmp37_);
								_tmp39_ = z;
								_tmp40_ = number_imaginary_component (_tmp39_);
								_tmp41_ = _tmp40_;
								_tmp42_ = number_to_double (_tmp41_);
								_tmp43_ = expected;
								_tmp44_ = g_strdup_printf ("(%d%+di).arg () -> %f%+fi, expected %f", _tmp33_, _tmp34_, _tmp38_, _tmp42_, _tmp43_);
								_tmp45_ = _tmp44_;
								fail (_tmp45_);
								_g_free0 (_tmp45_);
								_number_unref0 (_tmp41_);
								_number_unref0 (_tmp37_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
}


void test_conjugate (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							Number* _tmp16_ = NULL;
							Number* _tmp17_ = NULL;
							gint re_expected = 0;
							gint _tmp18_ = 0;
							gint im_expected = 0;
							gint _tmp19_ = 0;
							gboolean _tmp20_ = FALSE;
							Number* _tmp21_ = NULL;
							Number* _tmp22_ = NULL;
							Number* _tmp23_ = NULL;
							gint64 _tmp24_ = 0LL;
							gint _tmp25_ = 0;
							gboolean _tmp26_ = FALSE;
							gboolean _tmp32_ = FALSE;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ <= 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = number_new_integer ((gint64) _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_new_integer ((gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_new_complex (_tmp10_, _tmp13_);
							_tmp15_ = _tmp14_;
							_number_unref0 (_tmp13_);
							_number_unref0 (_tmp10_);
							z = _tmp15_;
							_tmp16_ = z;
							_tmp17_ = number_conjugate (_tmp16_);
							_number_unref0 (z);
							z = _tmp17_;
							_tmp18_ = a;
							re_expected = _tmp18_;
							_tmp19_ = b;
							im_expected = -_tmp19_;
							_tmp21_ = z;
							_tmp22_ = number_real_component (_tmp21_);
							_tmp23_ = _tmp22_;
							_tmp24_ = number_to_integer (_tmp23_);
							_tmp25_ = re_expected;
							_tmp26_ = _tmp24_ != ((gint64) _tmp25_);
							_number_unref0 (_tmp23_);
							if (_tmp26_) {
								_tmp20_ = TRUE;
							} else {
								Number* _tmp27_ = NULL;
								Number* _tmp28_ = NULL;
								Number* _tmp29_ = NULL;
								gint64 _tmp30_ = 0LL;
								gint _tmp31_ = 0;
								_tmp27_ = z;
								_tmp28_ = number_imaginary_component (_tmp27_);
								_tmp29_ = _tmp28_;
								_tmp30_ = number_to_integer (_tmp29_);
								_tmp31_ = im_expected;
								_tmp20_ = _tmp30_ != ((gint64) _tmp31_);
								_number_unref0 (_tmp29_);
							}
							_tmp32_ = _tmp20_;
							if (_tmp32_) {
								gint _tmp33_ = 0;
								gint _tmp34_ = 0;
								Number* _tmp35_ = NULL;
								Number* _tmp36_ = NULL;
								Number* _tmp37_ = NULL;
								gint64 _tmp38_ = 0LL;
								Number* _tmp39_ = NULL;
								Number* _tmp40_ = NULL;
								Number* _tmp41_ = NULL;
								gint64 _tmp42_ = 0LL;
								gint _tmp43_ = 0;
								gint _tmp44_ = 0;
								gchar* _tmp45_ = NULL;
								gchar* _tmp46_ = NULL;
								_tmp33_ = a;
								_tmp34_ = b;
								_tmp35_ = z;
								_tmp36_ = number_real_component (_tmp35_);
								_tmp37_ = _tmp36_;
								_tmp38_ = number_to_integer (_tmp37_);
								_tmp39_ = z;
								_tmp40_ = number_imaginary_component (_tmp39_);
								_tmp41_ = _tmp40_;
								_tmp42_ = number_to_integer (_tmp41_);
								_tmp43_ = re_expected;
								_tmp44_ = im_expected;
								_tmp45_ = g_strdup_printf ("(%d%+di).real_component () -> %d%+di, expected %d%+di", _tmp33_, _tmp34_, (gint) _tmp38_, (gint) _tmp42_, _tmp43_, _tmp44_);
								_tmp46_ = _tmp45_;
								fail (_tmp46_);
								_g_free0 (_tmp46_);
								_number_unref0 (_tmp41_);
								_number_unref0 (_tmp37_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
}


void test_real_component (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gint expected = 0;
							gint _tmp16_ = 0;
							Number* _tmp17_ = NULL;
							Number* _tmp18_ = NULL;
							Number* _tmp19_ = NULL;
							gint64 _tmp20_ = 0LL;
							gint _tmp21_ = 0;
							gboolean _tmp22_ = FALSE;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ <= 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = number_new_integer ((gint64) _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_new_integer ((gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_new_complex (_tmp10_, _tmp13_);
							_tmp15_ = _tmp14_;
							_number_unref0 (_tmp13_);
							_number_unref0 (_tmp10_);
							z = _tmp15_;
							_tmp16_ = a;
							expected = _tmp16_;
							_tmp17_ = z;
							_tmp18_ = number_real_component (_tmp17_);
							_tmp19_ = _tmp18_;
							_tmp20_ = number_to_integer (_tmp19_);
							_tmp21_ = expected;
							_tmp22_ = _tmp20_ != ((gint64) _tmp21_);
							_number_unref0 (_tmp19_);
							if (_tmp22_) {
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
								Number* _tmp25_ = NULL;
								Number* _tmp26_ = NULL;
								Number* _tmp27_ = NULL;
								gint64 _tmp28_ = 0LL;
								gint _tmp29_ = 0;
								gchar* _tmp30_ = NULL;
								gchar* _tmp31_ = NULL;
								_tmp23_ = a;
								_tmp24_ = b;
								_tmp25_ = z;
								_tmp26_ = number_real_component (_tmp25_);
								_tmp27_ = _tmp26_;
								_tmp28_ = number_to_integer (_tmp27_);
								_tmp29_ = expected;
								_tmp30_ = g_strdup_printf ("(%d+%di).real_component () -> %d, expected %d", _tmp23_, _tmp24_, (gint) _tmp28_, _tmp29_);
								_tmp31_ = _tmp30_;
								fail (_tmp31_);
								_g_free0 (_tmp31_);
								_number_unref0 (_tmp27_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_imaginary_component (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gint expected = 0;
							gint _tmp16_ = 0;
							Number* _tmp17_ = NULL;
							Number* _tmp18_ = NULL;
							Number* _tmp19_ = NULL;
							gint64 _tmp20_ = 0LL;
							gint _tmp21_ = 0;
							gboolean _tmp22_ = FALSE;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ <= 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = number_new_integer ((gint64) _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_new_integer ((gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_new_complex (_tmp10_, _tmp13_);
							_tmp15_ = _tmp14_;
							_number_unref0 (_tmp13_);
							_number_unref0 (_tmp10_);
							z = _tmp15_;
							_tmp16_ = b;
							expected = _tmp16_;
							_tmp17_ = z;
							_tmp18_ = number_imaginary_component (_tmp17_);
							_tmp19_ = _tmp18_;
							_tmp20_ = number_to_integer (_tmp19_);
							_tmp21_ = expected;
							_tmp22_ = _tmp20_ != ((gint64) _tmp21_);
							_number_unref0 (_tmp19_);
							if (_tmp22_) {
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
								Number* _tmp25_ = NULL;
								Number* _tmp26_ = NULL;
								Number* _tmp27_ = NULL;
								gint64 _tmp28_ = 0LL;
								gint _tmp29_ = 0;
								gchar* _tmp30_ = NULL;
								gchar* _tmp31_ = NULL;
								_tmp23_ = a;
								_tmp24_ = b;
								_tmp25_ = z;
								_tmp26_ = number_imaginary_component (_tmp25_);
								_tmp27_ = _tmp26_;
								_tmp28_ = number_to_integer (_tmp27_);
								_tmp29_ = expected;
								_tmp30_ = g_strdup_printf ("(%d+%di).imaginary_component () -> %d, expected %d", _tmp23_, _tmp24_, (gint) _tmp28_, _tmp29_);
								_tmp31_ = _tmp30_;
								fail (_tmp31_);
								_g_free0 (_tmp31_);
								_number_unref0 (_tmp27_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


gboolean double_matches (Number* a, gdouble b) {
	gboolean result = FALSE;
	Number* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	g_return_val_if_fail (a != NULL, FALSE);
	_tmp0_ = a;
	_tmp1_ = number_to_double (_tmp0_);
	_tmp2_ = double_string (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = b;
	_tmp5_ = double_string (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strcmp0 (_tmp3_, _tmp6_) == 0;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	result = _tmp7_;
	return result;
}


gchar* double_string (gdouble x) {
	gchar* result = NULL;
	gchar* value = NULL;
	gdouble _tmp0_ = 0.0;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	_tmp0_ = x;
	_tmp1_ = g_strdup_printf ("%.6f", _tmp0_);
	value = _tmp1_;
	_tmp2_ = value;
	if (g_strcmp0 (_tmp2_, "-0.000000") == 0) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_strdup ("0.000000");
		result = _tmp3_;
		_g_free0 (value);
		return result;
	} else {
		result = value;
		return result;
	}
	_g_free0 (value);
}


void test_integer_component (void) {
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gdouble a = 0.0;
				gint _tmp4_ = 0;
				Number* z = NULL;
				gdouble _tmp5_ = 0.0;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp10_ = 0.0;
				gdouble _tmp11_ = 0.0;
				Number* _tmp12_ = NULL;
				gdouble _tmp13_ = 0.0;
				gboolean _tmp14_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = ai;
					ai = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = ai;
				if (!(_tmp3_ <= 100)) {
					break;
				}
				_tmp4_ = ai;
				a = _tmp4_ / 10.0;
				_tmp5_ = a;
				_tmp6_ = number_new_double (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = number_integer_component (_tmp7_);
				_tmp9_ = _tmp8_;
				_number_unref0 (_tmp7_);
				z = _tmp9_;
				_tmp10_ = a;
				_tmp11_ = trunc (_tmp10_);
				expected = _tmp11_;
				_tmp12_ = z;
				_tmp13_ = expected;
				_tmp14_ = double_matches (_tmp12_, _tmp13_);
				if (!_tmp14_) {
					gdouble _tmp15_ = 0.0;
					Number* _tmp16_ = NULL;
					gdouble _tmp17_ = 0.0;
					gdouble _tmp18_ = 0.0;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					_tmp15_ = a;
					_tmp16_ = z;
					_tmp17_ = number_to_double (_tmp16_);
					_tmp18_ = expected;
					_tmp19_ = g_strdup_printf ("(%f).integer_component () -> %f, expected %f", _tmp15_, _tmp17_, _tmp18_);
					_tmp20_ = _tmp19_;
					fail (_tmp20_);
					_g_free0 (_tmp20_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_fractional_component (void) {
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gdouble a = 0.0;
				gint _tmp4_ = 0;
				Number* z = NULL;
				gdouble _tmp5_ = 0.0;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp10_ = 0.0;
				gdouble _tmp11_ = 0.0;
				gdouble _tmp12_ = 0.0;
				Number* _tmp13_ = NULL;
				gdouble _tmp14_ = 0.0;
				gboolean _tmp15_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = ai;
					ai = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = ai;
				if (!(_tmp3_ <= 100)) {
					break;
				}
				_tmp4_ = ai;
				a = _tmp4_ / 10.0;
				_tmp5_ = a;
				_tmp6_ = number_new_double (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = number_fractional_component (_tmp7_);
				_tmp9_ = _tmp8_;
				_number_unref0 (_tmp7_);
				z = _tmp9_;
				_tmp10_ = a;
				_tmp11_ = a;
				_tmp12_ = trunc (_tmp11_);
				expected = _tmp10_ - _tmp12_;
				_tmp13_ = z;
				_tmp14_ = expected;
				_tmp15_ = double_matches (_tmp13_, _tmp14_);
				if (!_tmp15_) {
					gdouble _tmp16_ = 0.0;
					Number* _tmp17_ = NULL;
					gdouble _tmp18_ = 0.0;
					gdouble _tmp19_ = 0.0;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					_tmp16_ = a;
					_tmp17_ = z;
					_tmp18_ = number_to_double (_tmp17_);
					_tmp19_ = expected;
					_tmp20_ = g_strdup_printf ("(%f).fractional_component () -> %f, expected %f", _tmp16_, _tmp18_, _tmp19_);
					_tmp21_ = _tmp20_;
					fail (_tmp21_);
					_g_free0 (_tmp21_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_fractional_part (void) {
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gdouble a = 0.0;
				gint _tmp4_ = 0;
				Number* z = NULL;
				gdouble _tmp5_ = 0.0;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp10_ = 0.0;
				gdouble _tmp11_ = 0.0;
				gdouble _tmp12_ = 0.0;
				Number* _tmp13_ = NULL;
				gdouble _tmp14_ = 0.0;
				gboolean _tmp15_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = ai;
					ai = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = ai;
				if (!(_tmp3_ <= 100)) {
					break;
				}
				_tmp4_ = ai;
				a = _tmp4_ / 10.0;
				_tmp5_ = a;
				_tmp6_ = number_new_double (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = number_fractional_part (_tmp7_);
				_tmp9_ = _tmp8_;
				_number_unref0 (_tmp7_);
				z = _tmp9_;
				_tmp10_ = a;
				_tmp11_ = a;
				_tmp12_ = floor (_tmp11_);
				expected = _tmp10_ - _tmp12_;
				_tmp13_ = z;
				_tmp14_ = expected;
				_tmp15_ = double_matches (_tmp13_, _tmp14_);
				if (!_tmp15_) {
					gdouble _tmp16_ = 0.0;
					Number* _tmp17_ = NULL;
					gdouble _tmp18_ = 0.0;
					gdouble _tmp19_ = 0.0;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					_tmp16_ = a;
					_tmp17_ = z;
					_tmp18_ = number_to_double (_tmp17_);
					_tmp19_ = expected;
					_tmp20_ = g_strdup_printf ("(%f).fractional_part () -> %f, expected %f", _tmp16_, _tmp18_, _tmp19_);
					_tmp21_ = _tmp20_;
					fail (_tmp21_);
					_g_free0 (_tmp21_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_floor (void) {
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gdouble a = 0.0;
				gint _tmp4_ = 0;
				Number* z = NULL;
				gdouble _tmp5_ = 0.0;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp10_ = 0.0;
				gdouble _tmp11_ = 0.0;
				Number* _tmp12_ = NULL;
				gdouble _tmp13_ = 0.0;
				gboolean _tmp14_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = ai;
					ai = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = ai;
				if (!(_tmp3_ <= 100)) {
					break;
				}
				_tmp4_ = ai;
				a = _tmp4_ / 10.0;
				_tmp5_ = a;
				_tmp6_ = number_new_double (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = number_floor (_tmp7_);
				_tmp9_ = _tmp8_;
				_number_unref0 (_tmp7_);
				z = _tmp9_;
				_tmp10_ = a;
				_tmp11_ = floor (_tmp10_);
				expected = _tmp11_;
				_tmp12_ = z;
				_tmp13_ = expected;
				_tmp14_ = double_matches (_tmp12_, _tmp13_);
				if (!_tmp14_) {
					gdouble _tmp15_ = 0.0;
					Number* _tmp16_ = NULL;
					gdouble _tmp17_ = 0.0;
					gdouble _tmp18_ = 0.0;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					_tmp15_ = a;
					_tmp16_ = z;
					_tmp17_ = number_to_double (_tmp16_);
					_tmp18_ = expected;
					_tmp19_ = g_strdup_printf ("(%f).floor () -> %f, expected %f", _tmp15_, _tmp17_, _tmp18_);
					_tmp20_ = _tmp19_;
					fail (_tmp20_);
					_g_free0 (_tmp20_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_ceiling (void) {
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gdouble a = 0.0;
				gint _tmp4_ = 0;
				Number* z = NULL;
				gdouble _tmp5_ = 0.0;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp10_ = 0.0;
				gdouble _tmp11_ = 0.0;
				Number* _tmp12_ = NULL;
				gdouble _tmp13_ = 0.0;
				gboolean _tmp14_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = ai;
					ai = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = ai;
				if (!(_tmp3_ <= 100)) {
					break;
				}
				_tmp4_ = ai;
				a = _tmp4_ / 10.0;
				_tmp5_ = a;
				_tmp6_ = number_new_double (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = number_ceiling (_tmp7_);
				_tmp9_ = _tmp8_;
				_number_unref0 (_tmp7_);
				z = _tmp9_;
				_tmp10_ = a;
				_tmp11_ = ceil (_tmp10_);
				expected = _tmp11_;
				_tmp12_ = z;
				_tmp13_ = expected;
				_tmp14_ = double_matches (_tmp12_, _tmp13_);
				if (!_tmp14_) {
					gdouble _tmp15_ = 0.0;
					Number* _tmp16_ = NULL;
					gdouble _tmp17_ = 0.0;
					gdouble _tmp18_ = 0.0;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					_tmp15_ = a;
					_tmp16_ = z;
					_tmp17_ = number_to_double (_tmp16_);
					_tmp18_ = expected;
					_tmp19_ = g_strdup_printf ("(%f).ceiling () -> %f, expected %f", _tmp15_, _tmp17_, _tmp18_);
					_tmp20_ = _tmp19_;
					fail (_tmp20_);
					_g_free0 (_tmp20_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_round (void) {
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gdouble a = 0.0;
				gint _tmp4_ = 0;
				Number* z = NULL;
				gdouble _tmp5_ = 0.0;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp10_ = 0.0;
				gdouble _tmp11_ = 0.0;
				Number* _tmp12_ = NULL;
				gdouble _tmp13_ = 0.0;
				gboolean _tmp14_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = ai;
					ai = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = ai;
				if (!(_tmp3_ <= 100)) {
					break;
				}
				_tmp4_ = ai;
				a = _tmp4_ / 10.0;
				_tmp5_ = a;
				_tmp6_ = number_new_double (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = number_round (_tmp7_);
				_tmp9_ = _tmp8_;
				_number_unref0 (_tmp7_);
				z = _tmp9_;
				_tmp10_ = a;
				_tmp11_ = round (_tmp10_);
				expected = _tmp11_;
				_tmp12_ = z;
				_tmp13_ = expected;
				_tmp14_ = double_matches (_tmp12_, _tmp13_);
				if (!_tmp14_) {
					gdouble _tmp15_ = 0.0;
					Number* _tmp16_ = NULL;
					gdouble _tmp17_ = 0.0;
					gdouble _tmp18_ = 0.0;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					_tmp15_ = a;
					_tmp16_ = z;
					_tmp17_ = number_to_double (_tmp16_);
					_tmp18_ = expected;
					_tmp19_ = g_strdup_printf ("(%f).round () -> %f, expected %f", _tmp15_, _tmp17_, _tmp18_);
					_tmp20_ = _tmp19_;
					fail (_tmp20_);
					_g_free0 (_tmp20_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_reciprocal (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				Number* z = NULL;
				gint _tmp5_ = 0;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				gdouble expected = 0.0;
				gint _tmp10_ = 0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
				gdouble _tmp20_ = 0.0;
				Number* _tmp21_ = NULL;
				Number* _tmp22_ = NULL;
				Number* _tmp23_ = NULL;
				Number* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gboolean _tmp26_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				if (_tmp4_ == 0) {
					continue;
				}
				_tmp5_ = a;
				_tmp6_ = number_new_double ((gdouble) _tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = number_reciprocal (_tmp7_);
				_tmp9_ = _tmp8_;
				_number_unref0 (_tmp7_);
				z = _tmp9_;
				_tmp10_ = a;
				expected = 1.0 / _tmp10_;
				_tmp11_ = z;
				_tmp12_ = expected;
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
				if (!_tmp13_) {
					gint _tmp14_ = 0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp14_ = a;
					_tmp15_ = z;
					_tmp16_ = number_to_double (_tmp15_);
					_tmp17_ = expected;
					_tmp18_ = g_strdup_printf ("(%f).reciprocal () -> %f, expected %f", (gdouble) _tmp14_, _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					return;
				}
				_tmp20_ = expected;
				_tmp21_ = number_new_double (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = number_reciprocal (_tmp22_);
				_number_unref0 (z);
				z = _tmp23_;
				_number_unref0 (_tmp22_);
				_tmp24_ = z;
				_tmp25_ = a;
				_tmp26_ = double_matches (_tmp24_, (gdouble) _tmp25_);
				if (!_tmp26_) {
					gdouble _tmp27_ = 0.0;
					Number* _tmp28_ = NULL;
					gdouble _tmp29_ = 0.0;
					gint _tmp30_ = 0;
					gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
					_tmp27_ = expected;
					_tmp28_ = z;
					_tmp29_ = number_to_double (_tmp28_);
					_tmp30_ = a;
					_tmp31_ = g_strdup_printf ("(%f).reciprocal () -> %f, expected %f", _tmp27_, _tmp29_, (gdouble) _tmp30_);
					_tmp32_ = _tmp31_;
					fail (_tmp32_);
					_g_free0 (_tmp32_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_epowy (void) {
	{
		gint ai = 0;
		ai = -100;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gdouble a = 0.0;
				gint _tmp4_ = 0;
				Number* z = NULL;
				gdouble _tmp5_ = 0.0;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp10_ = 0.0;
				gdouble _tmp11_ = 0.0;
				Number* _tmp12_ = NULL;
				gdouble _tmp13_ = 0.0;
				gboolean _tmp14_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = ai;
					ai = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = ai;
				if (!(_tmp3_ <= 100)) {
					break;
				}
				_tmp4_ = ai;
				a = _tmp4_ / 10.0;
				_tmp5_ = a;
				_tmp6_ = number_new_double (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = number_epowy (_tmp7_);
				_tmp9_ = _tmp8_;
				_number_unref0 (_tmp7_);
				z = _tmp9_;
				_tmp10_ = a;
				_tmp11_ = exp (_tmp10_);
				expected = _tmp11_;
				_tmp12_ = z;
				_tmp13_ = expected;
				_tmp14_ = double_matches (_tmp12_, _tmp13_);
				if (!_tmp14_) {
					gdouble _tmp15_ = 0.0;
					Number* _tmp16_ = NULL;
					gdouble _tmp17_ = 0.0;
					gdouble _tmp18_ = 0.0;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					_tmp15_ = a;
					_tmp16_ = z;
					_tmp17_ = number_to_double (_tmp16_);
					_tmp18_ = expected;
					_tmp19_ = g_strdup_printf ("(%f).epowy () -> %f, expected %f", _tmp15_, _tmp17_, _tmp18_);
					_tmp20_ = _tmp19_;
					fail (_tmp20_);
					_g_free0 (_tmp20_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_xpowy (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gdouble expected = 0.0;
							gint _tmp16_ = 0;
							Number* _tmp33_ = NULL;
							gdouble _tmp34_ = 0.0;
							gboolean _tmp35_ = FALSE;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ <= 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = number_new_integer ((gint64) _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_new_integer ((gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_xpowy (_tmp10_, _tmp13_);
							_tmp15_ = _tmp14_;
							_number_unref0 (_tmp13_);
							_number_unref0 (_tmp10_);
							z = _tmp15_;
							expected = 1.0;
							_tmp16_ = a;
							if (_tmp16_ == 0) {
								expected = 0.0;
							} else {
								gint _tmp17_ = 0;
								_tmp17_ = b;
								if (_tmp17_ < 0) {
									{
										gint i = 0;
										i = 0;
										{
											gboolean _tmp18_ = FALSE;
											_tmp18_ = TRUE;
											while (TRUE) {
												gboolean _tmp19_ = FALSE;
												gint _tmp21_ = 0;
												gint _tmp22_ = 0;
												gdouble _tmp23_ = 0.0;
												gint _tmp24_ = 0;
												_tmp19_ = _tmp18_;
												if (!_tmp19_) {
													gint _tmp20_ = 0;
													_tmp20_ = i;
													i = _tmp20_ - 1;
												}
												_tmp18_ = FALSE;
												_tmp21_ = i;
												_tmp22_ = b;
												if (!(_tmp21_ > _tmp22_)) {
													break;
												}
												_tmp23_ = expected;
												_tmp24_ = a;
												expected = _tmp23_ / _tmp24_;
											}
										}
									}
								} else {
									gint _tmp25_ = 0;
									_tmp25_ = b;
									if (_tmp25_ > 0) {
										{
											gint i = 0;
											i = 0;
											{
												gboolean _tmp26_ = FALSE;
												_tmp26_ = TRUE;
												while (TRUE) {
													gboolean _tmp27_ = FALSE;
													gint _tmp29_ = 0;
													gint _tmp30_ = 0;
													gdouble _tmp31_ = 0.0;
													gint _tmp32_ = 0;
													_tmp27_ = _tmp26_;
													if (!_tmp27_) {
														gint _tmp28_ = 0;
														_tmp28_ = i;
														i = _tmp28_ + 1;
													}
													_tmp26_ = FALSE;
													_tmp29_ = i;
													_tmp30_ = b;
													if (!(_tmp29_ < _tmp30_)) {
														break;
													}
													_tmp31_ = expected;
													_tmp32_ = a;
													expected = _tmp31_ * _tmp32_;
												}
											}
										}
									}
								}
							}
							_tmp33_ = z;
							_tmp34_ = expected;
							_tmp35_ = double_matches (_tmp33_, _tmp34_);
							if (!_tmp35_) {
								gint _tmp36_ = 0;
								gint _tmp37_ = 0;
								Number* _tmp38_ = NULL;
								gdouble _tmp39_ = 0.0;
								gdouble _tmp40_ = 0.0;
								gchar* _tmp41_ = NULL;
								gchar* _tmp42_ = NULL;
								_tmp36_ = a;
								_tmp37_ = b;
								_tmp38_ = z;
								_tmp39_ = number_to_double (_tmp38_);
								_tmp40_ = expected;
								_tmp41_ = g_strdup_printf ("(%d).xpowy (%d) -> %f, expected %f", _tmp36_, _tmp37_, _tmp39_, _tmp40_);
								_tmp42_ = _tmp41_;
								fail (_tmp42_);
								_g_free0 (_tmp42_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_xpowy_integer (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gdouble expected = 0.0;
							gint _tmp14_ = 0;
							Number* _tmp31_ = NULL;
							gdouble _tmp32_ = 0.0;
							gboolean _tmp33_ = FALSE;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ <= 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = number_new_integer ((gint64) _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_xpowy_integer (_tmp10_, (gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp10_);
							z = _tmp13_;
							expected = 1.0;
							_tmp14_ = a;
							if (_tmp14_ == 0) {
								expected = 0.0;
							} else {
								gint _tmp15_ = 0;
								_tmp15_ = b;
								if (_tmp15_ < 0) {
									{
										gint i = 0;
										i = 0;
										{
											gboolean _tmp16_ = FALSE;
											_tmp16_ = TRUE;
											while (TRUE) {
												gboolean _tmp17_ = FALSE;
												gint _tmp19_ = 0;
												gint _tmp20_ = 0;
												gdouble _tmp21_ = 0.0;
												gint _tmp22_ = 0;
												_tmp17_ = _tmp16_;
												if (!_tmp17_) {
													gint _tmp18_ = 0;
													_tmp18_ = i;
													i = _tmp18_ - 1;
												}
												_tmp16_ = FALSE;
												_tmp19_ = i;
												_tmp20_ = b;
												if (!(_tmp19_ > _tmp20_)) {
													break;
												}
												_tmp21_ = expected;
												_tmp22_ = a;
												expected = _tmp21_ / _tmp22_;
											}
										}
									}
								} else {
									gint _tmp23_ = 0;
									_tmp23_ = b;
									if (_tmp23_ > 0) {
										{
											gint i = 0;
											i = 0;
											{
												gboolean _tmp24_ = FALSE;
												_tmp24_ = TRUE;
												while (TRUE) {
													gboolean _tmp25_ = FALSE;
													gint _tmp27_ = 0;
													gint _tmp28_ = 0;
													gdouble _tmp29_ = 0.0;
													gint _tmp30_ = 0;
													_tmp25_ = _tmp24_;
													if (!_tmp25_) {
														gint _tmp26_ = 0;
														_tmp26_ = i;
														i = _tmp26_ + 1;
													}
													_tmp24_ = FALSE;
													_tmp27_ = i;
													_tmp28_ = b;
													if (!(_tmp27_ < _tmp28_)) {
														break;
													}
													_tmp29_ = expected;
													_tmp30_ = a;
													expected = _tmp29_ * _tmp30_;
												}
											}
										}
									}
								}
							}
							_tmp31_ = z;
							_tmp32_ = expected;
							_tmp33_ = double_matches (_tmp31_, _tmp32_);
							if (!_tmp33_) {
								gint _tmp34_ = 0;
								gint _tmp35_ = 0;
								Number* _tmp36_ = NULL;
								gdouble _tmp37_ = 0.0;
								gdouble _tmp38_ = 0.0;
								gchar* _tmp39_ = NULL;
								gchar* _tmp40_ = NULL;
								_tmp34_ = a;
								_tmp35_ = b;
								_tmp36_ = z;
								_tmp37_ = number_to_double (_tmp36_);
								_tmp38_ = expected;
								_tmp39_ = g_strdup_printf ("(%d).xpowy_integer (%d) -> %f, expected %f", _tmp34_, _tmp35_, _tmp37_, _tmp38_);
								_tmp40_ = _tmp39_;
								fail (_tmp40_);
								_g_free0 (_tmp40_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_root3 (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gint _tmp9_ = 0;
				gdouble _tmp10_ = 0.0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_double ((gdouble) _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_root (_tmp6_, (gint64) 3);
				_tmp8_ = _tmp7_;
				_number_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				_tmp10_ = cbrt ((gdouble) _tmp9_);
				expected = _tmp10_;
				_tmp11_ = z;
				_tmp12_ = expected;
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
				if (!_tmp13_) {
					gint _tmp14_ = 0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp14_ = a;
					_tmp15_ = z;
					_tmp16_ = number_to_double (_tmp15_);
					_tmp17_ = expected;
					_tmp18_ = g_strdup_printf ("(%f).root (3) -> %f, expected %f", (gdouble) _tmp14_, _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_sqrt (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gint _tmp9_ = 0;
				gdouble _tmp10_ = 0.0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_double ((gdouble) _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_sqrt (_tmp6_);
				_tmp8_ = _tmp7_;
				_number_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				_tmp10_ = sqrt ((gdouble) _tmp9_);
				expected = _tmp10_;
				_tmp11_ = z;
				_tmp12_ = expected;
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
				if (!_tmp13_) {
					gint _tmp14_ = 0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp14_ = a;
					_tmp15_ = z;
					_tmp16_ = number_to_double (_tmp15_);
					_tmp17_ = expected;
					_tmp18_ = g_strdup_printf ("(%f).sqrt () -> %f, expected %f", (gdouble) _tmp14_, _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_ln (void) {
	{
		gint a = 0;
		a = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gint _tmp9_ = 0;
				gdouble _tmp10_ = 0.0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_double ((gdouble) _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_ln (_tmp6_);
				_tmp8_ = _tmp7_;
				_number_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				_tmp10_ = log ((gdouble) _tmp9_);
				expected = _tmp10_;
				_tmp11_ = z;
				_tmp12_ = expected;
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
				if (!_tmp13_) {
					gint _tmp14_ = 0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp14_ = a;
					_tmp15_ = z;
					_tmp16_ = number_to_double (_tmp15_);
					_tmp17_ = expected;
					_tmp18_ = g_strdup_printf ("(%f).ln () -> %f, expected %f", (gdouble) _tmp14_, _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_logarithm2 (void) {
	{
		gint a = 0;
		a = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gint _tmp9_ = 0;
				gdouble _tmp10_ = 0.0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_double ((gdouble) _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_logarithm (_tmp6_, (gint64) 2);
				_tmp8_ = _tmp7_;
				_number_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				_tmp10_ = log2 ((gdouble) _tmp9_);
				expected = _tmp10_;
				_tmp11_ = z;
				_tmp12_ = expected;
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
				if (!_tmp13_) {
					gint _tmp14_ = 0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp14_ = a;
					_tmp15_ = z;
					_tmp16_ = number_to_double (_tmp15_);
					_tmp17_ = expected;
					_tmp18_ = g_strdup_printf ("(%f).logarithm (2) -> %f, expected %f", (gdouble) _tmp14_, _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_logarithm10 (void) {
	{
		gint a = 0;
		a = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gint _tmp9_ = 0;
				gdouble _tmp10_ = 0.0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_double ((gdouble) _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_logarithm (_tmp6_, (gint64) 10);
				_tmp8_ = _tmp7_;
				_number_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				_tmp10_ = log10 ((gdouble) _tmp9_);
				expected = _tmp10_;
				_tmp11_ = z;
				_tmp12_ = expected;
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
				if (!_tmp13_) {
					gint _tmp14_ = 0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp14_ = a;
					_tmp15_ = z;
					_tmp16_ = number_to_double (_tmp15_);
					_tmp17_ = expected;
					_tmp18_ = g_strdup_printf ("(%f).logarithm (10) -> %f, expected %f", (gdouble) _tmp14_, _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_is_zero (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				gboolean expected = FALSE;
				gint _tmp6_ = 0;
				Number* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_integer ((gint64) _tmp4_);
				z = _tmp5_;
				_tmp6_ = a;
				expected = _tmp6_ == 0;
				_tmp7_ = z;
				_tmp8_ = number_is_zero (_tmp7_);
				_tmp9_ = expected;
				if (_tmp8_ != _tmp9_) {
					const gchar* _tmp10_ = NULL;
					Number* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					const gchar* _tmp13_ = NULL;
					gboolean _tmp14_ = FALSE;
					gint _tmp15_ = 0;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp11_ = z;
					_tmp12_ = number_is_zero (_tmp11_);
					if (_tmp12_) {
						_tmp10_ = "true";
					} else {
						_tmp10_ = "false";
					}
					_tmp14_ = expected;
					if (_tmp14_) {
						_tmp13_ = "true";
					} else {
						_tmp13_ = "false";
					}
					_tmp15_ = a;
					_tmp16_ = _tmp10_;
					_tmp17_ = _tmp13_;
					_tmp18_ = g_strdup_printf ("(%d).is_zero () -> %s, expected %s", _tmp15_, _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_is_negative (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				gboolean expected = FALSE;
				gint _tmp6_ = 0;
				Number* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_integer ((gint64) _tmp4_);
				z = _tmp5_;
				_tmp6_ = a;
				expected = _tmp6_ < 0;
				_tmp7_ = z;
				_tmp8_ = number_is_negative (_tmp7_);
				_tmp9_ = expected;
				if (_tmp8_ != _tmp9_) {
					const gchar* _tmp10_ = NULL;
					Number* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					const gchar* _tmp13_ = NULL;
					gboolean _tmp14_ = FALSE;
					gint _tmp15_ = 0;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp11_ = z;
					_tmp12_ = number_is_negative (_tmp11_);
					if (_tmp12_) {
						_tmp10_ = "true";
					} else {
						_tmp10_ = "false";
					}
					_tmp14_ = expected;
					if (_tmp14_) {
						_tmp13_ = "true";
					} else {
						_tmp13_ = "false";
					}
					_tmp15_ = a;
					_tmp16_ = _tmp10_;
					_tmp17_ = _tmp13_;
					_tmp18_ = g_strdup_printf ("(%d).is_negative () -> %s, expected %s", _tmp15_, _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_is_integer (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				gboolean expected = FALSE;
				Number* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_integer ((gint64) _tmp4_);
				z = _tmp5_;
				expected = TRUE;
				_tmp6_ = z;
				_tmp7_ = number_is_integer (_tmp6_);
				_tmp8_ = expected;
				if (_tmp7_ != _tmp8_) {
					const gchar* _tmp9_ = NULL;
					Number* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					const gchar* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					gint _tmp14_ = 0;
					const gchar* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					_tmp10_ = z;
					_tmp11_ = number_is_integer (_tmp10_);
					if (_tmp11_) {
						_tmp9_ = "true";
					} else {
						_tmp9_ = "false";
					}
					_tmp13_ = expected;
					if (_tmp13_) {
						_tmp12_ = "true";
					} else {
						_tmp12_ = "false";
					}
					_tmp14_ = a;
					_tmp15_ = _tmp9_;
					_tmp16_ = _tmp12_;
					_tmp17_ = g_strdup_printf ("(%d).is_integer () -> %s, expected %s", _tmp14_, _tmp15_, _tmp16_);
					_tmp18_ = _tmp17_;
					fail (_tmp18_);
					_g_free0 (_tmp18_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_is_positive_integer (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				gboolean expected = FALSE;
				gint _tmp6_ = 0;
				Number* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_integer ((gint64) _tmp4_);
				z = _tmp5_;
				_tmp6_ = a;
				expected = _tmp6_ >= 0;
				_tmp7_ = z;
				_tmp8_ = number_is_positive_integer (_tmp7_);
				_tmp9_ = expected;
				if (_tmp8_ != _tmp9_) {
					const gchar* _tmp10_ = NULL;
					Number* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					const gchar* _tmp13_ = NULL;
					gboolean _tmp14_ = FALSE;
					gint _tmp15_ = 0;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp11_ = z;
					_tmp12_ = number_is_positive_integer (_tmp11_);
					if (_tmp12_) {
						_tmp10_ = "true";
					} else {
						_tmp10_ = "false";
					}
					_tmp14_ = expected;
					if (_tmp14_) {
						_tmp13_ = "true";
					} else {
						_tmp13_ = "false";
					}
					_tmp15_ = a;
					_tmp16_ = _tmp10_;
					_tmp17_ = _tmp13_;
					_tmp18_ = g_strdup_printf ("(%d).is_positive_integer () -> %s, expected %s", _tmp15_, _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_is_natural (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				gboolean expected = FALSE;
				gint _tmp6_ = 0;
				Number* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_integer ((gint64) _tmp4_);
				z = _tmp5_;
				_tmp6_ = a;
				expected = _tmp6_ > 0;
				_tmp7_ = z;
				_tmp8_ = number_is_natural (_tmp7_);
				_tmp9_ = expected;
				if (_tmp8_ != _tmp9_) {
					const gchar* _tmp10_ = NULL;
					Number* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					const gchar* _tmp13_ = NULL;
					gboolean _tmp14_ = FALSE;
					gint _tmp15_ = 0;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp11_ = z;
					_tmp12_ = number_is_natural (_tmp11_);
					if (_tmp12_) {
						_tmp10_ = "true";
					} else {
						_tmp10_ = "false";
					}
					_tmp14_ = expected;
					if (_tmp14_) {
						_tmp13_ = "true";
					} else {
						_tmp13_ = "false";
					}
					_tmp15_ = a;
					_tmp16_ = _tmp10_;
					_tmp17_ = _tmp13_;
					_tmp18_ = g_strdup_printf ("(%d).is_natural () -> %s, expected %s", _tmp15_, _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_is_complex (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gboolean expected = FALSE;
							gint _tmp16_ = 0;
							Number* _tmp17_ = NULL;
							gboolean _tmp18_ = FALSE;
							gboolean _tmp19_ = FALSE;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ <= 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = number_new_integer ((gint64) _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_new_integer ((gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_new_complex (_tmp10_, _tmp13_);
							_tmp15_ = _tmp14_;
							_number_unref0 (_tmp13_);
							_number_unref0 (_tmp10_);
							z = _tmp15_;
							_tmp16_ = b;
							expected = _tmp16_ != 0;
							_tmp17_ = z;
							_tmp18_ = number_is_complex (_tmp17_);
							_tmp19_ = expected;
							if (_tmp18_ != _tmp19_) {
								const gchar* _tmp20_ = NULL;
								Number* _tmp21_ = NULL;
								gboolean _tmp22_ = FALSE;
								const gchar* _tmp23_ = NULL;
								gboolean _tmp24_ = FALSE;
								gint _tmp25_ = 0;
								gint _tmp26_ = 0;
								const gchar* _tmp27_ = NULL;
								const gchar* _tmp28_ = NULL;
								gchar* _tmp29_ = NULL;
								gchar* _tmp30_ = NULL;
								_tmp21_ = z;
								_tmp22_ = number_is_complex (_tmp21_);
								if (_tmp22_) {
									_tmp20_ = "true";
								} else {
									_tmp20_ = "false";
								}
								_tmp24_ = expected;
								if (_tmp24_) {
									_tmp23_ = "true";
								} else {
									_tmp23_ = "false";
								}
								_tmp25_ = a;
								_tmp26_ = b;
								_tmp27_ = _tmp20_;
								_tmp28_ = _tmp23_;
								_tmp29_ = g_strdup_printf ("(%d+%di).is_complex () -> %s, expected %s", _tmp25_, _tmp26_, _tmp27_, _tmp28_);
								_tmp30_ = _tmp29_;
								fail (_tmp30_);
								_g_free0 (_tmp30_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_factorial (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				gint expected = 0;
				Number* _tmp13_ = NULL;
				Number* _tmp14_ = NULL;
				Number* _tmp15_ = NULL;
				gint64 _tmp16_ = 0LL;
				gint _tmp17_ = 0;
				gboolean _tmp18_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_integer ((gint64) _tmp4_);
				z = _tmp5_;
				expected = 1;
				{
					gint i = 0;
					i = 2;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gboolean _tmp7_ = FALSE;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							_tmp7_ = _tmp6_;
							if (!_tmp7_) {
								gint _tmp8_ = 0;
								_tmp8_ = i;
								i = _tmp8_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp9_ = i;
							_tmp10_ = a;
							if (!(_tmp9_ <= _tmp10_)) {
								break;
							}
							_tmp11_ = expected;
							_tmp12_ = i;
							expected = _tmp11_ * _tmp12_;
						}
					}
				}
				_tmp13_ = z;
				_tmp14_ = number_factorial (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = number_to_integer (_tmp15_);
				_tmp17_ = expected;
				_tmp18_ = _tmp16_ != ((gint64) _tmp17_);
				_number_unref0 (_tmp15_);
				if (_tmp18_) {
					gint _tmp19_ = 0;
					Number* _tmp20_ = NULL;
					Number* _tmp21_ = NULL;
					Number* _tmp22_ = NULL;
					gint64 _tmp23_ = 0LL;
					gint _tmp24_ = 0;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					_tmp19_ = a;
					_tmp20_ = z;
					_tmp21_ = number_factorial (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = number_to_integer (_tmp22_);
					_tmp24_ = expected;
					_tmp25_ = g_strdup_printf ("(%d).factorial () -> %lli, expected %lli", _tmp19_, _tmp23_, _tmp24_);
					_tmp26_ = _tmp25_;
					fail (_tmp26_);
					_g_free0 (_tmp26_);
					_number_unref0 (_tmp22_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_add (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gint expected = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							Number* _tmp18_ = NULL;
							gint64 _tmp19_ = 0LL;
							gint _tmp20_ = 0;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ <= 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = number_new_integer ((gint64) _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_new_integer ((gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_add (_tmp10_, _tmp13_);
							_tmp15_ = _tmp14_;
							_number_unref0 (_tmp13_);
							_number_unref0 (_tmp10_);
							z = _tmp15_;
							_tmp16_ = a;
							_tmp17_ = b;
							expected = _tmp16_ + _tmp17_;
							_tmp18_ = z;
							_tmp19_ = number_to_integer (_tmp18_);
							_tmp20_ = expected;
							if (_tmp19_ != ((gint64) _tmp20_)) {
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								Number* _tmp23_ = NULL;
								gint64 _tmp24_ = 0LL;
								gint _tmp25_ = 0;
								gchar* _tmp26_ = NULL;
								gchar* _tmp27_ = NULL;
								_tmp21_ = a;
								_tmp22_ = b;
								_tmp23_ = z;
								_tmp24_ = number_to_integer (_tmp23_);
								_tmp25_ = expected;
								_tmp26_ = g_strdup_printf ("(%d).add (%d) -> %lli, expected %d", _tmp21_, _tmp22_, _tmp24_, _tmp25_);
								_tmp27_ = _tmp26_;
								fail (_tmp27_);
								_g_free0 (_tmp27_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_subtract (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gint expected = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							Number* _tmp18_ = NULL;
							gint64 _tmp19_ = 0LL;
							gint _tmp20_ = 0;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ <= 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = number_new_integer ((gint64) _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_new_integer ((gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_subtract (_tmp10_, _tmp13_);
							_tmp15_ = _tmp14_;
							_number_unref0 (_tmp13_);
							_number_unref0 (_tmp10_);
							z = _tmp15_;
							_tmp16_ = a;
							_tmp17_ = b;
							expected = _tmp16_ - _tmp17_;
							_tmp18_ = z;
							_tmp19_ = number_to_integer (_tmp18_);
							_tmp20_ = expected;
							if (_tmp19_ != ((gint64) _tmp20_)) {
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								Number* _tmp23_ = NULL;
								gint64 _tmp24_ = 0LL;
								gint _tmp25_ = 0;
								gchar* _tmp26_ = NULL;
								gchar* _tmp27_ = NULL;
								_tmp21_ = a;
								_tmp22_ = b;
								_tmp23_ = z;
								_tmp24_ = number_to_integer (_tmp23_);
								_tmp25_ = expected;
								_tmp26_ = g_strdup_printf ("(%d).subtract (%d) -> %lli, expected %d", _tmp21_, _tmp22_, _tmp24_, _tmp25_);
								_tmp27_ = _tmp26_;
								fail (_tmp27_);
								_g_free0 (_tmp27_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_multiply (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gint expected = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							Number* _tmp18_ = NULL;
							gint64 _tmp19_ = 0LL;
							gint _tmp20_ = 0;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ <= 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = number_new_integer ((gint64) _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_new_integer ((gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_multiply (_tmp10_, _tmp13_);
							_tmp15_ = _tmp14_;
							_number_unref0 (_tmp13_);
							_number_unref0 (_tmp10_);
							z = _tmp15_;
							_tmp16_ = a;
							_tmp17_ = b;
							expected = _tmp16_ * _tmp17_;
							_tmp18_ = z;
							_tmp19_ = number_to_integer (_tmp18_);
							_tmp20_ = expected;
							if (_tmp19_ != ((gint64) _tmp20_)) {
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								Number* _tmp23_ = NULL;
								gint64 _tmp24_ = 0LL;
								gint _tmp25_ = 0;
								gchar* _tmp26_ = NULL;
								gchar* _tmp27_ = NULL;
								_tmp21_ = a;
								_tmp22_ = b;
								_tmp23_ = z;
								_tmp24_ = number_to_integer (_tmp23_);
								_tmp25_ = expected;
								_tmp26_ = g_strdup_printf ("(%d).multiply (%d) -> %lli, expected %d", _tmp21_, _tmp22_, _tmp24_, _tmp25_);
								_tmp27_ = _tmp26_;
								fail (_tmp27_);
								_g_free0 (_tmp27_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_multiply_integer (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							Number* _tmp16_ = NULL;
							gint64 _tmp17_ = 0LL;
							gint _tmp18_ = 0;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ <= 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = number_new_integer ((gint64) _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_multiply_integer (_tmp10_, (gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp10_);
							z = _tmp13_;
							_tmp14_ = a;
							_tmp15_ = b;
							expected = _tmp14_ * _tmp15_;
							_tmp16_ = z;
							_tmp17_ = number_to_integer (_tmp16_);
							_tmp18_ = expected;
							if (_tmp17_ != ((gint64) _tmp18_)) {
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								Number* _tmp21_ = NULL;
								gint64 _tmp22_ = 0LL;
								gint _tmp23_ = 0;
								gchar* _tmp24_ = NULL;
								gchar* _tmp25_ = NULL;
								_tmp19_ = a;
								_tmp20_ = b;
								_tmp21_ = z;
								_tmp22_ = number_to_integer (_tmp21_);
								_tmp23_ = expected;
								_tmp24_ = g_strdup_printf ("(%d).multiply_integer (%d) -> %lli, expected %d", _tmp19_, _tmp20_, _tmp22_, _tmp23_);
								_tmp25_ = _tmp24_;
								fail (_tmp25_);
								_g_free0 (_tmp25_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_divide (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							Number* z = NULL;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							Number* _tmp16_ = NULL;
							Number* _tmp17_ = NULL;
							gint expected = 0;
							gint _tmp18_ = 0;
							Number* _tmp19_ = NULL;
							gint64 _tmp20_ = 0LL;
							gint _tmp21_ = 0;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ <= 10)) {
								break;
							}
							_tmp8_ = b;
							if (_tmp8_ == 0) {
								continue;
							}
							_tmp9_ = a;
							_tmp10_ = b;
							_tmp11_ = number_new_integer ((gint64) (_tmp9_ * _tmp10_));
							_tmp12_ = _tmp11_;
							_tmp13_ = b;
							_tmp14_ = number_new_integer ((gint64) _tmp13_);
							_tmp15_ = _tmp14_;
							_tmp16_ = number_divide (_tmp12_, _tmp15_);
							_tmp17_ = _tmp16_;
							_number_unref0 (_tmp15_);
							_number_unref0 (_tmp12_);
							z = _tmp17_;
							_tmp18_ = a;
							expected = _tmp18_;
							_tmp19_ = z;
							_tmp20_ = number_to_integer (_tmp19_);
							_tmp21_ = expected;
							if (_tmp20_ != ((gint64) _tmp21_)) {
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
								Number* _tmp25_ = NULL;
								gint64 _tmp26_ = 0LL;
								gint _tmp27_ = 0;
								gchar* _tmp28_ = NULL;
								gchar* _tmp29_ = NULL;
								_tmp22_ = a;
								_tmp23_ = b;
								_tmp24_ = b;
								_tmp25_ = z;
								_tmp26_ = number_to_integer (_tmp25_);
								_tmp27_ = expected;
								_tmp28_ = g_strdup_printf ("(%d).divide (%d) -> %lli, expected %d", _tmp22_ * _tmp23_, _tmp24_, _tmp26_, _tmp27_);
								_tmp29_ = _tmp28_;
								fail (_tmp29_);
								_g_free0 (_tmp29_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_divide_integer (void) {
	{
		gint a = 0;
		a = -10;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							Number* z = NULL;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							Number* _tmp11_ = NULL;
							Number* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gint expected = 0;
							gint _tmp16_ = 0;
							Number* _tmp17_ = NULL;
							gint64 _tmp18_ = 0LL;
							gint _tmp19_ = 0;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ <= 10)) {
								break;
							}
							_tmp8_ = b;
							if (_tmp8_ == 0) {
								continue;
							}
							_tmp9_ = a;
							_tmp10_ = b;
							_tmp11_ = number_new_integer ((gint64) (_tmp9_ * _tmp10_));
							_tmp12_ = _tmp11_;
							_tmp13_ = b;
							_tmp14_ = number_divide_integer (_tmp12_, (gint64) _tmp13_);
							_tmp15_ = _tmp14_;
							_number_unref0 (_tmp12_);
							z = _tmp15_;
							_tmp16_ = a;
							expected = _tmp16_;
							_tmp17_ = z;
							_tmp18_ = number_to_integer (_tmp17_);
							_tmp19_ = expected;
							if (_tmp18_ != ((gint64) _tmp19_)) {
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								Number* _tmp23_ = NULL;
								gint64 _tmp24_ = 0LL;
								gint _tmp25_ = 0;
								gchar* _tmp26_ = NULL;
								gchar* _tmp27_ = NULL;
								_tmp20_ = a;
								_tmp21_ = b;
								_tmp22_ = b;
								_tmp23_ = z;
								_tmp24_ = number_to_integer (_tmp23_);
								_tmp25_ = expected;
								_tmp26_ = g_strdup_printf ("(%d).divide_integer (%d) -> %lli, expected %d", _tmp20_ * _tmp21_, _tmp22_, _tmp24_, _tmp25_);
								_tmp27_ = _tmp26_;
								fail (_tmp27_);
								_g_free0 (_tmp27_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_modulus_divide (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= 10)) {
					break;
				}
				{
					gint b = 0;
					b = 1;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gint expected = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							Number* _tmp18_ = NULL;
							gint64 _tmp19_ = 0LL;
							gint _tmp20_ = 0;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ <= 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = number_new_integer ((gint64) _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_new_integer ((gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_modulus_divide (_tmp10_, _tmp13_);
							_tmp15_ = _tmp14_;
							_number_unref0 (_tmp13_);
							_number_unref0 (_tmp10_);
							z = _tmp15_;
							_tmp16_ = a;
							_tmp17_ = b;
							expected = _tmp16_ % _tmp17_;
							_tmp18_ = z;
							_tmp19_ = number_to_integer (_tmp18_);
							_tmp20_ = expected;
							if (_tmp19_ != ((gint64) _tmp20_)) {
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								Number* _tmp23_ = NULL;
								gint64 _tmp24_ = 0LL;
								gint _tmp25_ = 0;
								gchar* _tmp26_ = NULL;
								gchar* _tmp27_ = NULL;
								_tmp21_ = a;
								_tmp22_ = b;
								_tmp23_ = z;
								_tmp24_ = number_to_integer (_tmp23_);
								_tmp25_ = expected;
								_tmp26_ = g_strdup_printf ("(%d).modulus_divide (%d) -> %lli, expected %d", _tmp21_, _tmp22_, _tmp24_, _tmp25_);
								_tmp27_ = _tmp26_;
								fail (_tmp27_);
								_g_free0 (_tmp27_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_sin (void) {
	{
		gdouble a = 0.0;
		a = -G_PI;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gdouble _tmp3_ = 0.0;
				Number* z = NULL;
				gdouble _tmp4_ = 0.0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gdouble _tmp2_ = 0.0;
					_tmp2_ = a;
					a = _tmp2_ + (G_PI / 16);
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= G_PI)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_double (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_sin (_tmp6_, ANGLE_UNIT_RADIANS);
				_tmp8_ = _tmp7_;
				_number_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				_tmp10_ = sin (_tmp9_);
				expected = _tmp10_;
				_tmp11_ = z;
				_tmp12_ = expected;
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
				if (!_tmp13_) {
					gdouble _tmp14_ = 0.0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp14_ = a;
					_tmp15_ = z;
					_tmp16_ = number_to_double (_tmp15_);
					_tmp17_ = expected;
					_tmp18_ = g_strdup_printf ("(%f).sin () -> %f, expected %f", _tmp14_, _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_cos (void) {
	{
		gdouble a = 0.0;
		a = -G_PI;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gdouble _tmp3_ = 0.0;
				Number* z = NULL;
				gdouble _tmp4_ = 0.0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gdouble expected = 0.0;
				gdouble _tmp9_ = 0.0;
				gdouble _tmp10_ = 0.0;
				Number* _tmp11_ = NULL;
				gdouble _tmp12_ = 0.0;
				gboolean _tmp13_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gdouble _tmp2_ = 0.0;
					_tmp2_ = a;
					a = _tmp2_ + (G_PI / 16);
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ <= G_PI)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_double (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_cos (_tmp6_, ANGLE_UNIT_RADIANS);
				_tmp8_ = _tmp7_;
				_number_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				_tmp10_ = cos (_tmp9_);
				expected = _tmp10_;
				_tmp11_ = z;
				_tmp12_ = expected;
				_tmp13_ = double_matches (_tmp11_, _tmp12_);
				if (!_tmp13_) {
					gdouble _tmp14_ = 0.0;
					Number* _tmp15_ = NULL;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp14_ = a;
					_tmp15_ = z;
					_tmp16_ = number_to_double (_tmp15_);
					_tmp17_ = expected;
					_tmp18_ = g_strdup_printf ("(%f).cos () -> %f, expected %f", _tmp14_, _tmp16_, _tmp17_);
					_tmp19_ = _tmp18_;
					fail (_tmp19_);
					_g_free0 (_tmp19_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_and (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ < 10)) {
					break;
				}
				{
					gint b = 0;
					b = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gint expected = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							Number* _tmp18_ = NULL;
							gint64 _tmp19_ = 0LL;
							gint _tmp20_ = 0;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ < 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = number_new_integer ((gint64) _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_new_integer ((gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_and (_tmp10_, _tmp13_);
							_tmp15_ = _tmp14_;
							_number_unref0 (_tmp13_);
							_number_unref0 (_tmp10_);
							z = _tmp15_;
							_tmp16_ = a;
							_tmp17_ = b;
							expected = _tmp16_ & _tmp17_;
							_tmp18_ = z;
							_tmp19_ = number_to_integer (_tmp18_);
							_tmp20_ = expected;
							if (_tmp19_ != ((gint64) _tmp20_)) {
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								Number* _tmp23_ = NULL;
								gint64 _tmp24_ = 0LL;
								gint _tmp25_ = 0;
								gchar* _tmp26_ = NULL;
								gchar* _tmp27_ = NULL;
								_tmp21_ = a;
								_tmp22_ = b;
								_tmp23_ = z;
								_tmp24_ = number_to_integer (_tmp23_);
								_tmp25_ = expected;
								_tmp26_ = g_strdup_printf ("(%d).and (%d) -> %lli, expected %d", _tmp21_, _tmp22_, _tmp24_, _tmp25_);
								_tmp27_ = _tmp26_;
								fail (_tmp27_);
								_g_free0 (_tmp27_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_or (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ < 10)) {
					break;
				}
				{
					gint b = 0;
					b = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gint expected = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							Number* _tmp18_ = NULL;
							gint64 _tmp19_ = 0LL;
							gint _tmp20_ = 0;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ < 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = number_new_integer ((gint64) _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_new_integer ((gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_or (_tmp10_, _tmp13_);
							_tmp15_ = _tmp14_;
							_number_unref0 (_tmp13_);
							_number_unref0 (_tmp10_);
							z = _tmp15_;
							_tmp16_ = a;
							_tmp17_ = b;
							expected = _tmp16_ | _tmp17_;
							_tmp18_ = z;
							_tmp19_ = number_to_integer (_tmp18_);
							_tmp20_ = expected;
							if (_tmp19_ != ((gint64) _tmp20_)) {
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								Number* _tmp23_ = NULL;
								gint64 _tmp24_ = 0LL;
								gint _tmp25_ = 0;
								gchar* _tmp26_ = NULL;
								gchar* _tmp27_ = NULL;
								_tmp21_ = a;
								_tmp22_ = b;
								_tmp23_ = z;
								_tmp24_ = number_to_integer (_tmp23_);
								_tmp25_ = expected;
								_tmp26_ = g_strdup_printf ("(%d).or (%d) -> %lli, expected %d", _tmp21_, _tmp22_, _tmp24_, _tmp25_);
								_tmp27_ = _tmp26_;
								fail (_tmp27_);
								_g_free0 (_tmp27_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_xor (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ < 10)) {
					break;
				}
				{
					gint b = 0;
					b = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							Number* _tmp14_ = NULL;
							Number* _tmp15_ = NULL;
							gint expected = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							Number* _tmp18_ = NULL;
							gint64 _tmp19_ = 0LL;
							gint _tmp20_ = 0;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ < 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = number_new_integer ((gint64) _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_new_integer ((gint64) _tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = number_xor (_tmp10_, _tmp13_);
							_tmp15_ = _tmp14_;
							_number_unref0 (_tmp13_);
							_number_unref0 (_tmp10_);
							z = _tmp15_;
							_tmp16_ = a;
							_tmp17_ = b;
							expected = _tmp16_ ^ _tmp17_;
							_tmp18_ = z;
							_tmp19_ = number_to_integer (_tmp18_);
							_tmp20_ = expected;
							if (_tmp19_ != ((gint64) _tmp20_)) {
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								Number* _tmp23_ = NULL;
								gint64 _tmp24_ = 0LL;
								gint _tmp25_ = 0;
								gchar* _tmp26_ = NULL;
								gchar* _tmp27_ = NULL;
								_tmp21_ = a;
								_tmp22_ = b;
								_tmp23_ = z;
								_tmp24_ = number_to_integer (_tmp23_);
								_tmp25_ = expected;
								_tmp26_ = g_strdup_printf ("(%d).xor (%d) -> %lli, expected %d", _tmp21_, _tmp22_, _tmp24_, _tmp25_);
								_tmp27_ = _tmp26_;
								fail (_tmp27_);
								_g_free0 (_tmp27_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


void test_not (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				Number* z = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				Number* _tmp8_ = NULL;
				gint expected = 0;
				gint _tmp9_ = 0;
				Number* _tmp10_ = NULL;
				gint64 _tmp11_ = 0LL;
				gint _tmp12_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ < 10)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_integer ((gint64) _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_not (_tmp6_, 8);
				_tmp8_ = _tmp7_;
				_number_unref0 (_tmp6_);
				z = _tmp8_;
				_tmp9_ = a;
				expected = (~_tmp9_) & 0xFF;
				_tmp10_ = z;
				_tmp11_ = number_to_integer (_tmp10_);
				_tmp12_ = expected;
				if (_tmp11_ != ((gint64) _tmp12_)) {
					gint _tmp13_ = 0;
					Number* _tmp14_ = NULL;
					gint64 _tmp15_ = 0LL;
					gint _tmp16_ = 0;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					_tmp13_ = a;
					_tmp14_ = z;
					_tmp15_ = number_to_integer (_tmp14_);
					_tmp16_ = expected;
					_tmp17_ = g_strdup_printf ("(%d).not () -> %lli, expected %d", _tmp13_, _tmp15_, _tmp16_);
					_tmp18_ = _tmp17_;
					fail (_tmp18_);
					_g_free0 (_tmp18_);
					_number_unref0 (z);
					return;
				}
				_number_unref0 (z);
			}
		}
	}
	pass (NULL);
}


void test_shift (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ < 10)) {
					break;
				}
				{
					gint b = 0;
					b = -10;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Number* z = NULL;
							gint _tmp8_ = 0;
							Number* _tmp9_ = NULL;
							Number* _tmp10_ = NULL;
							gint _tmp11_ = 0;
							Number* _tmp12_ = NULL;
							Number* _tmp13_ = NULL;
							gint expected = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							Number* _tmp19_ = NULL;
							gint64 _tmp20_ = 0LL;
							gint _tmp21_ = 0;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = b;
								b = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = b;
							if (!(_tmp7_ < 10)) {
								break;
							}
							_tmp8_ = a;
							_tmp9_ = number_new_integer ((gint64) _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = b;
							_tmp12_ = number_shift (_tmp10_, _tmp11_);
							_tmp13_ = _tmp12_;
							_number_unref0 (_tmp10_);
							z = _tmp13_;
							_tmp14_ = a;
							_tmp15_ = b;
							expected = _tmp14_ << _tmp15_;
							_tmp16_ = b;
							if (_tmp16_ < 0) {
								gint _tmp17_ = 0;
								gint _tmp18_ = 0;
								_tmp17_ = a;
								_tmp18_ = b;
								expected = _tmp17_ >> (-_tmp18_);
							}
							_tmp19_ = z;
							_tmp20_ = number_to_integer (_tmp19_);
							_tmp21_ = expected;
							if (_tmp20_ != ((gint64) _tmp21_)) {
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								Number* _tmp24_ = NULL;
								gint64 _tmp25_ = 0LL;
								gint _tmp26_ = 0;
								gchar* _tmp27_ = NULL;
								gchar* _tmp28_ = NULL;
								_tmp22_ = a;
								_tmp23_ = b;
								_tmp24_ = z;
								_tmp25_ = number_to_integer (_tmp24_);
								_tmp26_ = expected;
								_tmp27_ = g_strdup_printf ("(%d).shift (%d) -> %lli, expected %d", _tmp22_, _tmp23_, _tmp25_, _tmp26_);
								_tmp28_ = _tmp27_;
								fail (_tmp28_);
								_g_free0 (_tmp28_);
								_number_unref0 (z);
								return;
							}
							_number_unref0 (z);
						}
					}
				}
			}
		}
	}
	pass (NULL);
}


static gpointer _number_ref0 (gpointer self) {
	return self ? number_ref (self) : NULL;
}


static void _number_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (number_unref (var), NULL));
}


static void _g_list_free__number_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _number_unref0_, NULL);
	g_list_free (self);
}


void test_factorize (void) {
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				GList* factors = NULL;
				gint _tmp4_ = 0;
				Number* _tmp5_ = NULL;
				Number* _tmp6_ = NULL;
				GList* _tmp7_ = NULL;
				GList* _tmp8_ = NULL;
				GList* expected = NULL;
				gint _tmp9_ = 0;
				GList* _tmp10_ = NULL;
				gboolean matches = FALSE;
				GList* _tmp11_ = NULL;
				guint _tmp12_ = 0U;
				GList* _tmp13_ = NULL;
				guint _tmp14_ = 0U;
				gboolean _tmp28_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = a;
					a = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = a;
				if (!(_tmp3_ < 100)) {
					break;
				}
				_tmp4_ = a;
				_tmp5_ = number_new_integer ((gint64) _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = number_factorize (_tmp6_);
				_tmp8_ = _tmp7_;
				_number_unref0 (_tmp6_);
				factors = _tmp8_;
				_tmp9_ = a;
				_tmp10_ = factorize (_tmp9_);
				expected = _tmp10_;
				matches = FALSE;
				_tmp11_ = factors;
				_tmp12_ = g_list_length (_tmp11_);
				_tmp13_ = expected;
				_tmp14_ = g_list_length (_tmp13_);
				if (_tmp12_ == _tmp14_) {
					matches = TRUE;
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp15_ = FALSE;
							_tmp15_ = TRUE;
							while (TRUE) {
								gboolean _tmp16_ = FALSE;
								gint _tmp18_ = 0;
								GList* _tmp19_ = NULL;
								guint _tmp20_ = 0U;
								GList* _tmp21_ = NULL;
								gint _tmp22_ = 0;
								gconstpointer _tmp23_ = NULL;
								gint64 _tmp24_ = 0LL;
								GList* _tmp25_ = NULL;
								gint _tmp26_ = 0;
								gconstpointer _tmp27_ = NULL;
								_tmp16_ = _tmp15_;
								if (!_tmp16_) {
									gint _tmp17_ = 0;
									_tmp17_ = i;
									i = _tmp17_ + 1;
								}
								_tmp15_ = FALSE;
								_tmp18_ = i;
								_tmp19_ = factors;
								_tmp20_ = g_list_length (_tmp19_);
								if (!(((guint) _tmp18_) < _tmp20_)) {
									break;
								}
								_tmp21_ = factors;
								_tmp22_ = i;
								_tmp23_ = g_list_nth_data (_tmp21_, (guint) _tmp22_);
								_tmp24_ = number_to_integer ((Number*) _tmp23_);
								_tmp25_ = expected;
								_tmp26_ = i;
								_tmp27_ = g_list_nth_data (_tmp25_, (guint) _tmp26_);
								if (_tmp24_ != ((gint64) ((gint) ((gintptr) _tmp27_)))) {
									matches = FALSE;
								}
							}
						}
					}
				}
				_tmp28_ = matches;
				if (!_tmp28_) {
					gchar* factors_string = NULL;
					gchar* _tmp29_ = NULL;
					GList* _tmp30_ = NULL;
					gchar* expected_string = NULL;
					gchar* _tmp41_ = NULL;
					GList* _tmp42_ = NULL;
					gint _tmp51_ = 0;
					const gchar* _tmp52_ = NULL;
					const gchar* _tmp53_ = NULL;
					gchar* _tmp54_ = NULL;
					gchar* _tmp55_ = NULL;
					_tmp29_ = g_strdup ("");
					factors_string = _tmp29_;
					_tmp30_ = factors;
					{
						GList* f_collection = NULL;
						GList* f_it = NULL;
						f_collection = _tmp30_;
						for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
							Number* _tmp31_ = NULL;
							Number* f = NULL;
							_tmp31_ = _number_ref0 ((Number*) f_it->data);
							f = _tmp31_;
							{
								const gchar* _tmp32_ = NULL;
								const gchar* _tmp35_ = NULL;
								Number* _tmp36_ = NULL;
								gint64 _tmp37_ = 0LL;
								gchar* _tmp38_ = NULL;
								gchar* _tmp39_ = NULL;
								gchar* _tmp40_ = NULL;
								_tmp32_ = factors_string;
								if (g_strcmp0 (_tmp32_, "") != 0) {
									const gchar* _tmp33_ = NULL;
									gchar* _tmp34_ = NULL;
									_tmp33_ = factors_string;
									_tmp34_ = g_strconcat (_tmp33_, ", ", NULL);
									_g_free0 (factors_string);
									factors_string = _tmp34_;
								}
								_tmp35_ = factors_string;
								_tmp36_ = f;
								_tmp37_ = number_to_integer (_tmp36_);
								_tmp38_ = g_strdup_printf ("%d", (gint) _tmp37_);
								_tmp39_ = _tmp38_;
								_tmp40_ = g_strconcat (_tmp35_, _tmp39_, NULL);
								_g_free0 (factors_string);
								factors_string = _tmp40_;
								_g_free0 (_tmp39_);
								_number_unref0 (f);
							}
						}
					}
					_tmp41_ = g_strdup ("");
					expected_string = _tmp41_;
					_tmp42_ = expected;
					{
						GList* f_collection = NULL;
						GList* f_it = NULL;
						f_collection = _tmp42_;
						for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
							gint f = 0;
							f = (gint) ((gintptr) f_it->data);
							{
								const gchar* _tmp43_ = NULL;
								const gchar* _tmp46_ = NULL;
								gint _tmp47_ = 0;
								gchar* _tmp48_ = NULL;
								gchar* _tmp49_ = NULL;
								gchar* _tmp50_ = NULL;
								_tmp43_ = expected_string;
								if (g_strcmp0 (_tmp43_, "") != 0) {
									const gchar* _tmp44_ = NULL;
									gchar* _tmp45_ = NULL;
									_tmp44_ = expected_string;
									_tmp45_ = g_strconcat (_tmp44_, ", ", NULL);
									_g_free0 (expected_string);
									expected_string = _tmp45_;
								}
								_tmp46_ = expected_string;
								_tmp47_ = f;
								_tmp48_ = g_strdup_printf ("%d", _tmp47_);
								_tmp49_ = _tmp48_;
								_tmp50_ = g_strconcat (_tmp46_, _tmp49_, NULL);
								_g_free0 (expected_string);
								expected_string = _tmp50_;
								_g_free0 (_tmp49_);
							}
						}
					}
					_tmp51_ = a;
					_tmp52_ = factors_string;
					_tmp53_ = expected_string;
					_tmp54_ = g_strdup_printf ("(%d).factorize () -> (%s), expected (%s)", _tmp51_, _tmp52_, _tmp53_);
					_tmp55_ = _tmp54_;
					fail (_tmp55_);
					_g_free0 (_tmp55_);
					_g_free0 (expected_string);
					_g_free0 (factors_string);
					_g_list_free0 (expected);
					__g_list_free__number_unref0_0 (factors);
					return;
				}
				_g_list_free0 (expected);
				__g_list_free__number_unref0_0 (factors);
			}
		}
	}
	pass (NULL);
}


GList* factorize (gint number) {
	GList* result = NULL;
	GList* factors = NULL;
	gint _tmp0_ = 0;
	gint n = 0;
	gint _tmp2_ = 0;
	factors = NULL;
	_tmp0_ = number;
	if (_tmp0_ < 2) {
		gint _tmp1_ = 0;
		_tmp1_ = number;
		factors = g_list_append (factors, (gpointer) ((gintptr) _tmp1_));
		result = factors;
		return result;
	}
	_tmp2_ = number;
	n = _tmp2_;
	while (TRUE) {
		{
			gint factor = 0;
			factor = 2;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gboolean _tmp4_ = FALSE;
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
					_tmp4_ = _tmp3_;
					if (!_tmp4_) {
						gint _tmp5_ = 0;
						_tmp5_ = factor;
						factor = _tmp5_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp6_ = factor;
					_tmp7_ = n;
					if (!(_tmp6_ <= _tmp7_)) {
						break;
					}
					_tmp8_ = n;
					_tmp9_ = factor;
					if ((_tmp8_ % _tmp9_) == 0) {
						gint _tmp10_ = 0;
						gint _tmp11_ = 0;
						gint _tmp12_ = 0;
						gint _tmp13_ = 0;
						_tmp10_ = factor;
						factors = g_list_append (factors, (gpointer) ((gintptr) _tmp10_));
						_tmp11_ = n;
						_tmp12_ = factor;
						n = _tmp11_ / _tmp12_;
						_tmp13_ = n;
						if (_tmp13_ == 1) {
							result = factors;
							return result;
						}
						break;
					}
				}
			}
		}
	}
	_g_list_free0 (factors);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp7_ = 0;
	setlocale (LC_ALL, "C");
	test_integer ();
	test_unsigned_integer ();
	test_fraction ();
	test_float ();
	test_double ();
	test_complex ();
	test_polar ();
	test_string ();
	test_eulers ();
	test_i ();
	test_pi ();
	test_is_zero ();
	test_is_negative ();
	test_is_integer ();
	test_is_positive_integer ();
	test_is_natural ();
	test_is_complex ();
	test_sgn ();
	test_invert_sign ();
	test_abs ();
	test_arg ();
	test_conjugate ();
	test_real_component ();
	test_imaginary_component ();
	test_integer_component ();
	test_fractional_component ();
	test_fractional_part ();
	test_floor ();
	test_ceiling ();
	test_round ();
	test_reciprocal ();
	test_epowy ();
	test_xpowy ();
	test_xpowy_integer ();
	test_root3 ();
	test_sqrt ();
	test_ln ();
	test_logarithm2 ();
	test_logarithm10 ();
	test_factorial ();
	test_add ();
	test_subtract ();
	test_multiply ();
	test_multiply_integer ();
	test_divide ();
	test_divide_integer ();
	test_modulus_divide ();
	test_sin ();
	test_cos ();
	test_and ();
	test_or ();
	test_xor ();
	test_not ();
	test_shift ();
	test_factorize ();
	_tmp0_ = fail_count;
	if (_tmp0_ == 0) {
		FILE* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp1_ = stdout;
		_tmp2_ = pass_count;
		fprintf (_tmp1_, "Passed all %i tests\n", _tmp2_);
	} else {
		FILE* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp3_ = stdout;
		_tmp4_ = fail_count;
		_tmp5_ = pass_count;
		_tmp6_ = fail_count;
		fprintf (_tmp3_, "Failed %i/%d tests\n", _tmp4_, _tmp5_ + _tmp6_);
	}
	_tmp7_ = fail_count;
	result = _tmp7_;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



