/* avatar-details.c generated by valac 0.22.0.42-1ce8b, the Vala compiler
 * generated from avatar-details.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define FOLKS_TYPE_AVATAR_DETAILS (folks_avatar_details_get_type ())
#define FOLKS_AVATAR_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_AVATAR_DETAILS, FolksAvatarDetails))
#define FOLKS_IS_AVATAR_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_AVATAR_DETAILS))
#define FOLKS_AVATAR_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_AVATAR_DETAILS, FolksAvatarDetailsIface))

typedef struct _FolksAvatarDetails FolksAvatarDetails;
typedef struct _FolksAvatarDetailsIface FolksAvatarDetailsIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksAvatarDetailsChangeAvatarData FolksAvatarDetailsChangeAvatarData;

typedef enum  {
	FOLKS_PROPERTY_ERROR_NOT_WRITEABLE,
	FOLKS_PROPERTY_ERROR_INVALID_VALUE,
	FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR,
	FOLKS_PROPERTY_ERROR_UNAVAILABLE
} FolksPropertyError;
#define FOLKS_PROPERTY_ERROR folks_property_error_quark ()
struct _FolksAvatarDetailsIface {
	GTypeInterface parent_iface;
	void (*change_avatar) (FolksAvatarDetails* self, GLoadableIcon* avatar, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_avatar_finish) (FolksAvatarDetails* self, GAsyncResult* _res_, GError** error);
	GLoadableIcon* (*get_avatar) (FolksAvatarDetails* self);
	void (*set_avatar) (FolksAvatarDetails* self, GLoadableIcon* value);
};

struct _FolksAvatarDetailsChangeAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksAvatarDetails* self;
	GLoadableIcon* avatar;
	const gchar* _tmp0_;
	GError* _tmp1_;
	GError * _inner_error_;
};



GQuark folks_property_error_quark (void);
GType folks_avatar_details_get_type (void) G_GNUC_CONST;
static void folks_avatar_details_real_change_avatar_data_free (gpointer _data);
static void folks_avatar_details_real_change_avatar (FolksAvatarDetails* self, GLoadableIcon* avatar, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_avatar_details_change_avatar (FolksAvatarDetails* self, GLoadableIcon* avatar, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_avatar_details_change_avatar_finish (FolksAvatarDetails* self, GAsyncResult* _res_, GError** error);
static gboolean folks_avatar_details_real_change_avatar_co (FolksAvatarDetailsChangeAvatarData* _data_);
GLoadableIcon* folks_avatar_details_get_avatar (FolksAvatarDetails* self);
void folks_avatar_details_set_avatar (FolksAvatarDetails* self, GLoadableIcon* value);


static void folks_avatar_details_real_change_avatar_data_free (gpointer _data) {
	FolksAvatarDetailsChangeAvatarData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->avatar);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksAvatarDetailsChangeAvatarData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_avatar_details_real_change_avatar (FolksAvatarDetails* self, GLoadableIcon* avatar, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksAvatarDetailsChangeAvatarData* _data_;
	FolksAvatarDetails* _tmp0_ = NULL;
	GLoadableIcon* _tmp1_ = NULL;
	GLoadableIcon* _tmp2_ = NULL;
	_data_ = g_slice_new0 (FolksAvatarDetailsChangeAvatarData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_avatar_details_real_change_avatar);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_avatar_details_real_change_avatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = avatar;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->avatar);
	_data_->avatar = _tmp2_;
	folks_avatar_details_real_change_avatar_co (_data_);
}


static void folks_avatar_details_real_change_avatar_finish (FolksAvatarDetails* self, GAsyncResult* _res_, GError** error) {
	FolksAvatarDetailsChangeAvatarData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change the contact's avatar.
   *
   * It's preferred to call this rather than setting
   * {@link AvatarDetails.avatar} directly, as this method gives error
   * notification and will only return once the avatar has been written to the
   * relevant backing store (or the operation's failed).
   *
   * @param avatar the new avatar (or ``null`` to unset the avatar)
   * @throws PropertyError if setting the avatar failed
   * @since 0.6.2
   */
static gboolean folks_avatar_details_real_change_avatar_co (FolksAvatarDetailsChangeAvatarData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _ ("Avatar is not writeable on this contact.");
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp0_);
	_data_->_inner_error_ = _data_->_tmp1_;
	if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void folks_avatar_details_change_avatar (FolksAvatarDetails* self, GLoadableIcon* avatar, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_AVATAR_DETAILS_GET_INTERFACE (self)->change_avatar (self, avatar, _callback_, _user_data_);
}


void folks_avatar_details_change_avatar_finish (FolksAvatarDetails* self, GAsyncResult* _res_, GError** error) {
	FOLKS_AVATAR_DETAILS_GET_INTERFACE (self)->change_avatar_finish (self, _res_, error);
}


GLoadableIcon* folks_avatar_details_get_avatar (FolksAvatarDetails* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_AVATAR_DETAILS_GET_INTERFACE (self)->get_avatar (self);
}


void folks_avatar_details_set_avatar (FolksAvatarDetails* self, GLoadableIcon* value) {
	g_return_if_fail (self != NULL);
	FOLKS_AVATAR_DETAILS_GET_INTERFACE (self)->set_avatar (self, value);
}


static void folks_avatar_details_base_init (FolksAvatarDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * An avatar for the contact.
		   *
		   * The avatar may be ``null`` if unset. Otherwise, the image data may be
		   * asynchronously loaded using the methods of the {@link GLib.LoadableIcon}
		   * implementation.
		   *
		   * @since 0.6.0
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("avatar", "avatar", "avatar", g_loadable_icon_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		iface->change_avatar = folks_avatar_details_real_change_avatar;
		iface->change_avatar_finish = folks_avatar_details_real_change_avatar_finish;
	}
}


/**
 * Avatar for a contact.
 *
 * This allows avatars to be associated with contacts. An avatar is a small
 * image file which represents the contact, such as a photo of them.
 *
 * @since 0.6.0
 */
GType folks_avatar_details_get_type (void) {
	static volatile gsize folks_avatar_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_avatar_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksAvatarDetailsIface), (GBaseInitFunc) folks_avatar_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_avatar_details_type_id;
		folks_avatar_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksAvatarDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_avatar_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_avatar_details_type_id__volatile, folks_avatar_details_type_id);
	}
	return folks_avatar_details_type_id__volatile;
}



