/* tracker-store.c generated by valac 0.23.2.10-fed12, the Vala compiler
 * generated from tracker-store.vala, do not modify */

/*
 * Copyright (C) 2009-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Author: Philip Van Hoof <philip@codeminded.be>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"
#include "libtracker-data/tracker-data-backup.h"
#include "libtracker-data/tracker-db-manager.h"
#include "libtracker-data/tracker-db-interface-sqlite.h"
#include "tracker-store/tracker-events.h"
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_STORE (tracker_store_get_type ())
#define TRACKER_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STORE, TrackerStore))
#define TRACKER_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STORE, TrackerStoreClass))
#define TRACKER_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STORE))
#define TRACKER_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STORE))
#define TRACKER_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STORE, TrackerStoreClass))

typedef struct _TrackerStore TrackerStore;
typedef struct _TrackerStoreClass TrackerStoreClass;
typedef struct _TrackerStorePrivate TrackerStorePrivate;

#define TRACKER_STORE_TYPE_PRIORITY (tracker_store_priority_get_type ())

#define TRACKER_STORE_TYPE_TASK_TYPE (tracker_store_task_type_get_type ())

#define TRACKER_STORE_TYPE_TASK (tracker_store_task_get_type ())
#define TRACKER_STORE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_TASK, TrackerStoreTask))
#define TRACKER_STORE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_TASK, TrackerStoreTaskClass))
#define TRACKER_STORE_IS_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_TASK))
#define TRACKER_STORE_IS_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_TASK))
#define TRACKER_STORE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_TASK, TrackerStoreTaskClass))

typedef struct _TrackerStoreTask TrackerStoreTask;
typedef struct _TrackerStoreTaskClass TrackerStoreTaskClass;
#define _tracker_store_task_unref0(var) ((var == NULL) ? NULL : (var = (tracker_store_task_unref (var), NULL)))

#define TRACKER_STORE_TYPE_QUERY_TASK (tracker_store_query_task_get_type ())
#define TRACKER_STORE_QUERY_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask))
#define TRACKER_STORE_QUERY_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTaskClass))
#define TRACKER_STORE_IS_QUERY_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_QUERY_TASK))
#define TRACKER_STORE_IS_QUERY_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_QUERY_TASK))
#define TRACKER_STORE_QUERY_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTaskClass))

typedef struct _TrackerStoreQueryTask TrackerStoreQueryTask;
typedef struct _TrackerStoreQueryTaskClass TrackerStoreQueryTaskClass;
typedef struct _Block7Data Block7Data;
typedef struct _TrackerStoreTaskPrivate TrackerStoreTaskPrivate;
typedef struct _TrackerStoreQueryTaskPrivate TrackerStoreQueryTaskPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TRACKER_STORE_TYPE_UPDATE_TASK (tracker_store_update_task_get_type ())
#define TRACKER_STORE_UPDATE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask))
#define TRACKER_STORE_UPDATE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTaskClass))
#define TRACKER_STORE_IS_UPDATE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_UPDATE_TASK))
#define TRACKER_STORE_IS_UPDATE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_UPDATE_TASK))
#define TRACKER_STORE_UPDATE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTaskClass))

typedef struct _TrackerStoreUpdateTask TrackerStoreUpdateTask;
typedef struct _TrackerStoreUpdateTaskClass TrackerStoreUpdateTaskClass;
typedef struct _TrackerStoreUpdateTaskPrivate TrackerStoreUpdateTaskPrivate;
typedef struct _Block8Data Block8Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TRACKER_STORE_TYPE_TURTLE_TASK (tracker_store_turtle_task_get_type ())
#define TRACKER_STORE_TURTLE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTask))
#define TRACKER_STORE_TURTLE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTaskClass))
#define TRACKER_STORE_IS_TURTLE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_TURTLE_TASK))
#define TRACKER_STORE_IS_TURTLE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_TURTLE_TASK))
#define TRACKER_STORE_TURTLE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTaskClass))

typedef struct _TrackerStoreTurtleTask TrackerStoreTurtleTask;
typedef struct _TrackerStoreTurtleTaskClass TrackerStoreTurtleTaskClass;
typedef struct _TrackerStoreTurtleTaskPrivate TrackerStoreTurtleTaskPrivate;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define __g_queue_free__tracker_store_task_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__tracker_store_task_unref0_ (var), NULL)))
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerStoreSparqlQueryData TrackerStoreSparqlQueryData;
typedef struct _TrackerStoreSparqlUpdateData TrackerStoreSparqlUpdateData;
typedef struct _TrackerStoreSparqlUpdateBlankData TrackerStoreSparqlUpdateBlankData;
typedef struct _TrackerStoreQueueTurtleImportData TrackerStoreQueueTurtleImportData;
typedef struct _TrackerStorePauseData TrackerStorePauseData;
typedef struct _TrackerStoreParamSpecTask TrackerStoreParamSpecTask;
typedef struct _TrackerParamSpecStore TrackerParamSpecStore;

struct _TrackerStore {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerStorePrivate * priv;
};

struct _TrackerStoreClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerStore *self);
};

typedef enum  {
	TRACKER_STORE_PRIORITY_HIGH,
	TRACKER_STORE_PRIORITY_LOW,
	TRACKER_STORE_PRIORITY_TURTLE,
	TRACKER_STORE_PRIORITY_N_PRIORITIES
} TrackerStorePriority;

typedef enum  {
	TRACKER_STORE_TASK_TYPE_QUERY,
	TRACKER_STORE_TASK_TYPE_UPDATE,
	TRACKER_STORE_TASK_TYPE_UPDATE_BLANK,
	TRACKER_STORE_TASK_TYPE_TURTLE
} TrackerStoreTaskType;

struct _Block7Data {
	int _ref_count_;
	TrackerStoreQueryTask* query_task;
};

struct _TrackerStoreTask {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerStoreTaskPrivate * priv;
	TrackerStoreTaskType type;
	gchar* client_id;
	GError* error;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _TrackerStoreTaskClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerStoreTask *self);
};

typedef void (*TrackerStoreSparqlQueryInThread) (TrackerDBCursor* cursor, void* user_data, GError** error);
struct _TrackerStoreQueryTask {
	TrackerStoreTask parent_instance;
	TrackerStoreQueryTaskPrivate * priv;
	gchar* query;
	GCancellable* cancellable;
	guint watchdog_id;
	TrackerStoreSparqlQueryInThread in_thread;
	gpointer in_thread_target;
};

struct _TrackerStoreQueryTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _TrackerStoreUpdateTask {
	TrackerStoreTask parent_instance;
	TrackerStoreUpdateTaskPrivate * priv;
	gchar* query;
	GVariant* blank_nodes;
	TrackerStorePriority priority;
};

struct _TrackerStoreUpdateTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _Block8Data {
	int _ref_count_;
	TrackerStoreTask* task;
};

struct _TrackerStoreTurtleTask {
	TrackerStoreTask parent_instance;
	TrackerStoreTurtleTaskPrivate * priv;
	gchar* path;
};

struct _TrackerStoreTurtleTaskClass {
	TrackerStoreTaskClass parent_class;
};

struct _TrackerStoreSparqlQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* sparql;
	TrackerStorePriority priority;
	TrackerStoreSparqlQueryInThread in_thread;
	gpointer in_thread_target;
	gchar* client_id;
	TrackerStoreQueryTask* task;
	TrackerStoreQueryTask* _tmp0_;
	TrackerStoreQueryTask* _tmp1_;
	TrackerStoreQueryTask* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	TrackerStoreQueryTask* _tmp5_;
	GCancellable* _tmp6_;
	TrackerStoreQueryTask* _tmp7_;
	TrackerStoreSparqlQueryInThread _tmp8_;
	void* _tmp8__target;
	TrackerStoreQueryTask* _tmp9_;
	TrackerStoreQueryTask* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	TrackerStorePriority _tmp13_;
	GQueue* _tmp14_;
	TrackerStoreQueryTask* _tmp15_;
	TrackerStoreTask* _tmp16_;
	TrackerStoreQueryTask* _tmp17_;
	GError* _tmp18_;
	TrackerStoreQueryTask* _tmp19_;
	GError* _tmp20_;
	GError* _tmp21_;
	GError * _inner_error_;
};

struct _TrackerStoreSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* sparql;
	TrackerStorePriority priority;
	gchar* client_id;
	TrackerStoreUpdateTask* task;
	TrackerStoreUpdateTask* _tmp0_;
	TrackerStoreUpdateTask* _tmp1_;
	TrackerStoreUpdateTask* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	TrackerStoreUpdateTask* _tmp5_;
	TrackerStorePriority _tmp6_;
	TrackerStoreUpdateTask* _tmp7_;
	TrackerStoreUpdateTask* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	TrackerStorePriority _tmp11_;
	GQueue* _tmp12_;
	TrackerStoreUpdateTask* _tmp13_;
	TrackerStoreTask* _tmp14_;
	TrackerStoreUpdateTask* _tmp15_;
	GError* _tmp16_;
	TrackerStoreUpdateTask* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	GError * _inner_error_;
};

struct _TrackerStoreSparqlUpdateBlankData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* sparql;
	TrackerStorePriority priority;
	gchar* client_id;
	GVariant* result;
	TrackerStoreUpdateTask* task;
	TrackerStoreUpdateTask* _tmp0_;
	TrackerStoreUpdateTask* _tmp1_;
	TrackerStoreUpdateTask* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	TrackerStoreUpdateTask* _tmp5_;
	TrackerStorePriority _tmp6_;
	TrackerStoreUpdateTask* _tmp7_;
	TrackerStoreUpdateTask* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	TrackerStorePriority _tmp11_;
	GQueue* _tmp12_;
	TrackerStoreUpdateTask* _tmp13_;
	TrackerStoreTask* _tmp14_;
	TrackerStoreUpdateTask* _tmp15_;
	GError* _tmp16_;
	TrackerStoreUpdateTask* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	TrackerStoreUpdateTask* _tmp20_;
	GVariant* _tmp21_;
	GVariant* _tmp22_;
	GError * _inner_error_;
};

struct _TrackerStoreQueueTurtleImportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* file;
	gchar* client_id;
	TrackerStoreTurtleTask* task;
	TrackerStoreTurtleTask* _tmp0_;
	TrackerStoreTurtleTask* _tmp1_;
	TrackerStoreTurtleTask* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	TrackerStoreTurtleTask* _tmp5_;
	TrackerStoreTurtleTask* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GQueue* _tmp9_;
	TrackerStoreTurtleTask* _tmp10_;
	TrackerStoreTask* _tmp11_;
	TrackerStoreTurtleTask* _tmp12_;
	GError* _tmp13_;
	TrackerStoreTurtleTask* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GError * _inner_error_;
};

struct _TrackerStorePauseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gboolean _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	GThreadPool* _tmp4_;
	GThreadPool* _tmp5_;
	GThreadPool* _tmp6_;
	GError* e;
	GError* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	GError * _inner_error_;
};

struct _TrackerStoreParamSpecTask {
	GParamSpec parent_instance;
};

struct _TrackerParamSpecStore {
	GParamSpec parent_instance;
};


static gpointer tracker_store_parent_class = NULL;
static GQueue* tracker_store_query_queues[3];
static GQueue* tracker_store_query_queues[3] = {0};
static GQueue* tracker_store_update_queues[3];
static GQueue* tracker_store_update_queues[3] = {0};
static gint tracker_store_n_queries_running;
static gint tracker_store_n_queries_running = 0;
static gboolean tracker_store_update_running;
static gboolean tracker_store_update_running = FALSE;
static GThreadPool* tracker_store_update_pool;
static GThreadPool* tracker_store_update_pool = NULL;
static GThreadPool* tracker_store_query_pool;
static GThreadPool* tracker_store_query_pool = NULL;
static GThreadPool* tracker_store_checkpoint_pool;
static GThreadPool* tracker_store_checkpoint_pool = NULL;
static GPtrArray* tracker_store_running_tasks;
static GPtrArray* tracker_store_running_tasks = NULL;
static gint tracker_store_max_task_time;
static gint tracker_store_max_task_time = 0;
static gboolean tracker_store_active;
static gboolean tracker_store_active = FALSE;
static GSourceFunc tracker_store_active_callback;
static gpointer tracker_store_active_callback_target;
static GDestroyNotify tracker_store_active_callback_target_destroy_notify;
static GSourceFunc tracker_store_active_callback = NULL;
static gpointer tracker_store_active_callback_target = NULL;
static GDestroyNotify tracker_store_active_callback_target_destroy_notify = NULL;
static gint tracker_store_checkpointing;
static gint tracker_store_checkpointing = 0;
static gpointer tracker_store_task_parent_class = NULL;
static gpointer tracker_store_query_task_parent_class = NULL;
static gpointer tracker_store_update_task_parent_class = NULL;
static gpointer tracker_store_turtle_task_parent_class = NULL;

gpointer tracker_store_ref (gpointer instance);
void tracker_store_unref (gpointer instance);
GParamSpec* tracker_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_store (GValue* value, gpointer v_object);
void tracker_value_take_store (GValue* value, gpointer v_object);
gpointer tracker_value_get_store (const GValue* value);
GType tracker_store_get_type (void) G_GNUC_CONST;
enum  {
	TRACKER_STORE_DUMMY_PROPERTY
};
GType tracker_store_priority_get_type (void) G_GNUC_CONST;
static GType tracker_store_task_type_get_type (void) G_GNUC_UNUSED;
static gpointer tracker_store_task_ref (gpointer instance);
static void tracker_store_task_unref (gpointer instance);
static GParamSpec* tracker_store_param_spec_task (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void tracker_store_value_set_task (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void tracker_store_value_take_task (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer tracker_store_value_get_task (const GValue* value) G_GNUC_UNUSED;
static GType tracker_store_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_STORE_MAX_CONCURRENT_QUERIES 2
#define TRACKER_STORE_MAX_TASK_TIME 30
static void tracker_store_sched (void);
static GType tracker_store_query_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean ____lambda3_ (Block7Data* _data7_);
static gboolean _____lambda3__gsource_func (gpointer self);
static TrackerDataCommitType tracker_store_commit_type (TrackerStoreTask* task);
static GType tracker_store_update_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean tracker_store_task_finish_cb (TrackerStoreTask* task);
static void tracker_store_pool_dispatch_cb (TrackerStoreTask* task);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void tracker_store_wal_hook (gint n_pages);
static void _tracker_store_wal_hook_tracker_db_wal_callback (gint n_pages);
static GType tracker_store_turtle_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean __lambda4_ (Block8Data* _data8_);
static gboolean ___lambda4__gsource_func (gpointer self);
void tracker_store_wal_checkpoint (void);
static void tracker_store_checkpoint_dispatch_cb (gboolean task);
void tracker_store_init (void);
static void _tracker_store_task_unref0_ (gpointer var);
static void _g_queue_free__tracker_store_task_unref0_ (GQueue* self);
static void _tracker_store_pool_dispatch_cb_gfunc (gconstpointer data, gpointer self);
static void _tracker_store_checkpoint_dispatch_cb_gfunc (gconstpointer data, gpointer self);
void tracker_store_shutdown (void);
static void tracker_store_sparql_query_data_free (gpointer _data);
void tracker_store_sparql_query (const gchar* sparql, TrackerStorePriority priority, TrackerStoreSparqlQueryInThread in_thread, void* in_thread_target, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_query_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_sparql_query_co (TrackerStoreSparqlQueryData* _data_);
static TrackerStoreQueryTask* tracker_store_query_task_new (void);
static TrackerStoreQueryTask* tracker_store_query_task_construct (GType object_type);
static gboolean _tracker_store_sparql_query_co_gsource_func (gpointer self);
static void tracker_store_sparql_update_data_free (gpointer _data);
void tracker_store_sparql_update (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_update_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_sparql_update_co (TrackerStoreSparqlUpdateData* _data_);
static TrackerStoreUpdateTask* tracker_store_update_task_new (void);
static TrackerStoreUpdateTask* tracker_store_update_task_construct (GType object_type);
static gboolean _tracker_store_sparql_update_co_gsource_func (gpointer self);
static void tracker_store_sparql_update_blank_data_free (gpointer _data);
void tracker_store_sparql_update_blank (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_sparql_update_blank_co (TrackerStoreSparqlUpdateBlankData* _data_);
static gboolean _tracker_store_sparql_update_blank_co_gsource_func (gpointer self);
static void tracker_store_queue_turtle_import_data_free (gpointer _data);
void tracker_store_queue_turtle_import (GFile* file, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_, GError** error);
static gboolean tracker_store_queue_turtle_import_co (TrackerStoreQueueTurtleImportData* _data_);
static TrackerStoreTurtleTask* tracker_store_turtle_task_new (void);
static TrackerStoreTurtleTask* tracker_store_turtle_task_construct (GType object_type);
static gboolean _tracker_store_queue_turtle_import_co_gsource_func (gpointer self);
guint tracker_store_get_queue_size (TrackerStore* self);
void tracker_store_unreg_batches (const gchar* client_id);
static void tracker_store_pause_data_free (gpointer _data);
void tracker_store_pause (GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_pause_finish (GAsyncResult* _res_);
static gboolean tracker_store_pause_co (TrackerStorePauseData* _data_);
static gboolean _tracker_store_pause_co_gsource_func (gpointer self);
void tracker_store_resume (void);
TrackerStore* tracker_store_new (void);
TrackerStore* tracker_store_construct (GType object_type);
enum  {
	TRACKER_STORE_TASK_DUMMY_PROPERTY
};
static TrackerStoreTask* tracker_store_task_construct (GType object_type);
static void tracker_store_task_finalize (TrackerStoreTask* obj);
enum  {
	TRACKER_STORE_QUERY_TASK_DUMMY_PROPERTY
};
static void tracker_store_query_task_finalize (TrackerStoreTask* obj);
enum  {
	TRACKER_STORE_UPDATE_TASK_DUMMY_PROPERTY
};
static void tracker_store_update_task_finalize (TrackerStoreTask* obj);
enum  {
	TRACKER_STORE_TURTLE_TASK_DUMMY_PROPERTY
};
static void tracker_store_turtle_task_finalize (TrackerStoreTask* obj);
static void tracker_store_finalize (TrackerStore* obj);


GType tracker_store_priority_get_type (void) {
	static volatile gsize tracker_store_priority_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_priority_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_STORE_PRIORITY_HIGH, "TRACKER_STORE_PRIORITY_HIGH", "high"}, {TRACKER_STORE_PRIORITY_LOW, "TRACKER_STORE_PRIORITY_LOW", "low"}, {TRACKER_STORE_PRIORITY_TURTLE, "TRACKER_STORE_PRIORITY_TURTLE", "turtle"}, {TRACKER_STORE_PRIORITY_N_PRIORITIES, "TRACKER_STORE_PRIORITY_N_PRIORITIES", "n-priorities"}, {0, NULL, NULL}};
		GType tracker_store_priority_type_id;
		tracker_store_priority_type_id = g_enum_register_static ("TrackerStorePriority", values);
		g_once_init_leave (&tracker_store_priority_type_id__volatile, tracker_store_priority_type_id);
	}
	return tracker_store_priority_type_id__volatile;
}


static GType tracker_store_task_type_get_type (void) {
	static volatile gsize tracker_store_task_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_task_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_STORE_TASK_TYPE_QUERY, "TRACKER_STORE_TASK_TYPE_QUERY", "query"}, {TRACKER_STORE_TASK_TYPE_UPDATE, "TRACKER_STORE_TASK_TYPE_UPDATE", "update"}, {TRACKER_STORE_TASK_TYPE_UPDATE_BLANK, "TRACKER_STORE_TASK_TYPE_UPDATE_BLANK", "update-blank"}, {TRACKER_STORE_TASK_TYPE_TURTLE, "TRACKER_STORE_TASK_TYPE_TURTLE", "turtle"}, {0, NULL, NULL}};
		GType tracker_store_task_type_type_id;
		tracker_store_task_type_type_id = g_enum_register_static ("TrackerStoreTaskType", values);
		g_once_init_leave (&tracker_store_task_type_type_id__volatile, tracker_store_task_type_type_id);
	}
	return tracker_store_task_type_type_id__volatile;
}


static gpointer _tracker_store_task_ref0 (gpointer self) {
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self ? tracker_store_task_ref (self) : NULL;
#line 530 "tracker-store.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return _data7_;
#line 539 "tracker-store.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data7_->query_task);
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_slice_free (Block7Data, _data7_);
#line 552 "tracker-store.c"
	}
}


static gboolean ____lambda3_ (Block7Data* _data7_) {
	gboolean result = FALSE;
	TrackerStoreQueryTask* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = _data7_->query_task;
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _tmp0_->cancellable;
#line 108 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_cancellable_cancel (_tmp1_);
#line 109 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = FALSE;
#line 109 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 571 "tracker-store.c"
}


static gboolean _____lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda3_ (self);
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 580 "tracker-store.c"
}


static void tracker_store_sched (void) {
	TrackerStoreTask* task = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp22_ = FALSE;
	GError * _inner_error_ = NULL;
#line 86 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	task = NULL;
#line 88 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = tracker_store_active;
#line 88 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!_tmp0_) {
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (task);
#line 89 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 599 "tracker-store.c"
	}
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	while (TRUE) {
#line 603 "tracker-store.c"
		gint _tmp1_ = 0;
		TrackerStoreTask* _tmp9_ = NULL;
		GPtrArray* _tmp10_ = NULL;
		TrackerStoreTask* _tmp11_ = NULL;
		TrackerStoreTask* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp19_ = 0;
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp1_ = tracker_store_n_queries_running;
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (!(_tmp1_ < TRACKER_STORE_MAX_CONCURRENT_QUERIES)) {
#line 92 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			break;
#line 617 "tracker-store.c"
		}
		{
			gint i = 0;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			i = 0;
#line 623 "tracker-store.c"
			{
				gboolean _tmp2_ = FALSE;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = TRUE;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 630 "tracker-store.c"
					gint _tmp4_ = 0;
					gint _tmp5_ = 0;
					GQueue* _tmp6_ = NULL;
					gpointer _tmp7_ = NULL;
					TrackerStoreTask* _tmp8_ = NULL;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!_tmp2_) {
#line 638 "tracker-store.c"
						gint _tmp3_ = 0;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp3_ = i;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						i = _tmp3_ + 1;
#line 644 "tracker-store.c"
					}
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp2_ = FALSE;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp4_ = i;
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp4_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 93 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 654 "tracker-store.c"
					}
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp5_ = i;
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp6_ = tracker_store_query_queues[_tmp5_];
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp7_ = g_queue_pop_head (_tmp6_);
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (task);
#line 94 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp7_;
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp8_ = task;
#line 95 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp8_ != NULL) {
#line 96 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 672 "tracker-store.c"
					}
				}
			}
		}
#line 99 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp9_ = task;
#line 99 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp9_ == NULL) {
#line 101 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			break;
#line 683 "tracker-store.c"
		}
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp10_ = tracker_store_running_tasks;
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp11_ = task;
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp12_ = _tracker_store_task_ref0 (_tmp11_);
#line 103 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_ptr_array_add (_tmp10_, _tmp12_);
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp13_ = tracker_store_max_task_time;
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp13_ != 0) {
#line 697 "tracker-store.c"
			Block7Data* _data7_;
			TrackerStoreTask* _tmp14_ = NULL;
			TrackerStoreQueryTask* _tmp15_ = NULL;
			TrackerStoreQueryTask* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			guint _tmp18_ = 0U;
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data7_ = g_slice_new0 (Block7Data);
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data7_->_ref_count_ = 1;
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp14_ = task;
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp15_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask));
#line 106 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data7_->query_task = _tmp15_;
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp16_ = _data7_->query_task;
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp17_ = tracker_store_max_task_time;
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp18_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp17_, _____lambda3__gsource_func, block7_data_ref (_data7_), block7_data_unref);
#line 107 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp16_->watchdog_id = _tmp18_;
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			block7_data_unref (_data7_);
#line 105 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data7_ = NULL;
#line 726 "tracker-store.c"
		}
#line 113 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp19_ = tracker_store_n_queries_running;
#line 113 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_n_queries_running = _tmp19_ + 1;
#line 732 "tracker-store.c"
		{
			GThreadPool* _tmp20_ = NULL;
			TrackerStoreTask* _tmp21_ = NULL;
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp20_ = tracker_store_query_pool;
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp21_ = task;
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_thread_pool_push (_tmp20_, _tmp21_, &_inner_error_);
#line 115 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_inner_error_ != NULL) {
#line 744 "tracker-store.c"
				goto __catch18_g_error;
			}
		}
		goto __finally18;
		__catch18_g_error:
		{
			GError* e = NULL;
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			e = _inner_error_;
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_inner_error_ = NULL;
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_error_free0 (e);
#line 758 "tracker-store.c"
		}
		__finally18:
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_inner_error_ != NULL) {
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tracker_store_task_unref0 (task);
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_clear_error (&_inner_error_);
#line 114 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return;
#line 771 "tracker-store.c"
		}
	}
#line 121 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp22_ = tracker_store_update_running;
#line 121 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!_tmp22_) {
#line 778 "tracker-store.c"
		TrackerStoreTask* _tmp30_ = NULL;
		{
			gint i = 0;
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			i = 0;
#line 784 "tracker-store.c"
			{
				gboolean _tmp23_ = FALSE;
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp23_ = TRUE;
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 791 "tracker-store.c"
					gint _tmp25_ = 0;
					gint _tmp26_ = 0;
					GQueue* _tmp27_ = NULL;
					gpointer _tmp28_ = NULL;
					TrackerStoreTask* _tmp29_ = NULL;
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!_tmp23_) {
#line 799 "tracker-store.c"
						gint _tmp24_ = 0;
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp24_ = i;
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						i = _tmp24_ + 1;
#line 805 "tracker-store.c"
					}
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp23_ = FALSE;
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp25_ = i;
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp25_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 122 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 815 "tracker-store.c"
					}
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp26_ = i;
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp27_ = tracker_store_update_queues[_tmp26_];
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp28_ = g_queue_pop_head (_tmp27_);
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (task);
#line 123 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp28_;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp29_ = task;
#line 124 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp29_ != NULL) {
#line 125 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 833 "tracker-store.c"
					}
				}
			}
		}
#line 128 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp30_ = task;
#line 128 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp30_ != NULL) {
#line 129 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			tracker_store_update_running = TRUE;
#line 844 "tracker-store.c"
			{
				GThreadPool* _tmp31_ = NULL;
				TrackerStoreTask* _tmp32_ = NULL;
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp31_ = tracker_store_update_pool;
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp32_ = task;
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_thread_pool_push (_tmp31_, _tmp32_, &_inner_error_);
#line 131 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_inner_error_ != NULL) {
#line 856 "tracker-store.c"
					goto __catch19_g_error;
				}
			}
			goto __finally19;
			__catch19_g_error:
			{
				GError* e = NULL;
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				e = _inner_error_;
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_inner_error_ = NULL;
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_g_error_free0 (e);
#line 870 "tracker-store.c"
			}
			__finally19:
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_inner_error_ != NULL) {
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (task);
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_clear_error (&_inner_error_);
#line 130 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return;
#line 883 "tracker-store.c"
			}
		}
	}
#line 85 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (task);
#line 889 "tracker-store.c"
}


static TrackerDataCommitType tracker_store_commit_type (TrackerStoreTask* task) {
	TrackerDataCommitType result = 0;
	TrackerStoreTask* _tmp0_ = NULL;
	TrackerStoreTaskType _tmp1_ = 0;
#line 139 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (task != NULL, 0);
#line 140 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = task;
#line 140 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _tmp0_->type;
#line 140 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_tmp1_) {
#line 140 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case TRACKER_STORE_TASK_TYPE_UPDATE:
#line 140 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case TRACKER_STORE_TASK_TYPE_UPDATE_BLANK:
#line 909 "tracker-store.c"
		{
			TrackerStoreTask* _tmp2_ = NULL;
			TrackerStorePriority _tmp3_ = 0;
#line 143 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp2_ = task;
#line 143 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask)->priority;
#line 143 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp3_ == TRACKER_STORE_PRIORITY_HIGH) {
#line 144 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				result = TRACKER_DATA_COMMIT_REGULAR;
#line 144 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return result;
#line 923 "tracker-store.c"
			} else {
				GQueue* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = tracker_store_update_queues[TRACKER_STORE_PRIORITY_LOW];
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = g_queue_get_length (_tmp4_);
#line 145 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp5_ > ((guint) 0)) {
#line 146 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					result = TRACKER_DATA_COMMIT_BATCH;
#line 146 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					return result;
#line 937 "tracker-store.c"
				} else {
#line 148 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					result = TRACKER_DATA_COMMIT_BATCH_LAST;
#line 148 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					return result;
#line 943 "tracker-store.c"
				}
			}
		}
#line 140 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case TRACKER_STORE_TASK_TYPE_TURTLE:
#line 949 "tracker-store.c"
		{
			GQueue* _tmp6_ = NULL;
			guint _tmp7_ = 0U;
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp6_ = tracker_store_update_queues[TRACKER_STORE_PRIORITY_TURTLE];
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp7_ = g_queue_get_length (_tmp6_);
#line 151 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp7_ > ((guint) 0)) {
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				result = TRACKER_DATA_COMMIT_BATCH;
#line 152 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return result;
#line 963 "tracker-store.c"
			} else {
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				result = TRACKER_DATA_COMMIT_BATCH_LAST;
#line 154 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return result;
#line 969 "tracker-store.c"
			}
		}
		default:
		{
#line 157 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_warn_if_reached ();
#line 158 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			result = TRACKER_DATA_COMMIT_REGULAR;
#line 158 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return result;
#line 980 "tracker-store.c"
		}
	}
}


static gpointer _g_error_copy0 (gpointer self) {
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self ? g_error_copy (self) : NULL;
#line 989 "tracker-store.c"
}


static gboolean tracker_store_task_finish_cb (TrackerStoreTask* task) {
	gboolean result = FALSE;
	TrackerStoreTask* _tmp0_ = NULL;
	TrackerStoreTaskType _tmp1_ = 0;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gint _tmp40_ = 0;
	GError * _inner_error_ = NULL;
#line 162 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (task != NULL, FALSE);
#line 163 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = task;
#line 163 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _tmp0_->type;
#line 163 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp1_ == TRACKER_STORE_TASK_TYPE_QUERY) {
#line 1009 "tracker-store.c"
		TrackerStoreQueryTask* query_task = NULL;
		TrackerStoreTask* _tmp2_ = NULL;
		TrackerStoreQueryTask* _tmp3_ = NULL;
		TrackerStoreTask* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		TrackerStoreTask* _tmp11_ = NULL;
		GSourceFunc _tmp12_ = NULL;
		void* _tmp12__target = NULL;
		TrackerStoreTask* _tmp13_ = NULL;
		GPtrArray* _tmp14_ = NULL;
		TrackerStoreTask* _tmp15_ = NULL;
		gint _tmp16_ = 0;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp2_ = task;
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp3_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask));
#line 164 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		query_task = _tmp3_;
#line 166 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp4_ = task;
#line 166 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp5_ = _tmp4_->error;
#line 166 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp5_ == NULL) {
#line 1034 "tracker-store.c"
			{
				TrackerStoreQueryTask* _tmp6_ = NULL;
				GCancellable* _tmp7_ = NULL;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = query_task;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp7_ = _tmp6_->cancellable;
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_cancellable_set_error_if_cancelled (_tmp7_, &_inner_error_);
#line 168 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_inner_error_ != NULL) {
#line 1046 "tracker-store.c"
					goto __catch20_g_error;
				}
			}
			goto __finally20;
			__catch20_g_error:
			{
				GError* e = NULL;
				TrackerStoreTask* _tmp8_ = NULL;
				GError* _tmp9_ = NULL;
				GError* _tmp10_ = NULL;
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				e = _inner_error_;
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_inner_error_ = NULL;
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_ = task;
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp9_ = e;
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp10_ = _g_error_copy0 (_tmp9_);
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_g_error_free0 (_tmp8_->error);
#line 170 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_->error = _tmp10_;
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_g_error_free0 (e);
#line 1073 "tracker-store.c"
			}
			__finally20:
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_inner_error_ != NULL) {
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (query_task);
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				g_clear_error (&_inner_error_);
#line 167 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				return FALSE;
#line 1086 "tracker-store.c"
			}
		}
#line 174 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp11_ = task;
#line 174 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp12_ = _tmp11_->callback;
#line 174 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp12__target = _tmp11_->callback_target;
#line 174 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp12_ (_tmp12__target);
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp13_ = task;
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (_tmp13_->error);
#line 175 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp13_->error = NULL;
#line 177 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp14_ = tracker_store_running_tasks;
#line 177 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp15_ = task;
#line 177 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_ptr_array_remove (_tmp14_, _tmp15_);
#line 178 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp16_ = tracker_store_n_queries_running;
#line 178 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_n_queries_running = _tmp16_ - 1;
#line 163 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (query_task);
#line 1115 "tracker-store.c"
	} else {
		gboolean _tmp17_ = FALSE;
		TrackerStoreTask* _tmp18_ = NULL;
		TrackerStoreTaskType _tmp19_ = 0;
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp18_ = task;
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp19_ = _tmp18_->type;
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp19_ == TRACKER_STORE_TASK_TYPE_UPDATE) {
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp17_ = TRUE;
#line 1128 "tracker-store.c"
		} else {
			TrackerStoreTask* _tmp20_ = NULL;
			TrackerStoreTaskType _tmp21_ = 0;
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp20_ = task;
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp21_ = _tmp20_->type;
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp17_ = _tmp21_ == TRACKER_STORE_TASK_TYPE_UPDATE_BLANK;
#line 1138 "tracker-store.c"
		}
#line 179 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp17_) {
#line 1142 "tracker-store.c"
			TrackerStoreTask* _tmp22_ = NULL;
			GError* _tmp23_ = NULL;
			TrackerStoreTask* _tmp26_ = NULL;
			GSourceFunc _tmp27_ = NULL;
			void* _tmp27__target = NULL;
			TrackerStoreTask* _tmp28_ = NULL;
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp22_ = task;
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp23_ = _tmp22_->error;
#line 180 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp23_ == NULL) {
#line 1155 "tracker-store.c"
				TrackerStoreTask* _tmp24_ = NULL;
				TrackerDataCommitType _tmp25_ = 0;
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp24_ = task;
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp25_ = tracker_store_commit_type (_tmp24_);
#line 181 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_data_notify_transaction (_tmp25_);
#line 1164 "tracker-store.c"
			}
#line 184 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp26_ = task;
#line 184 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp27_ = _tmp26_->callback;
#line 184 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp27__target = _tmp26_->callback_target;
#line 184 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp27_ (_tmp27__target);
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp28_ = task;
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_error_free0 (_tmp28_->error);
#line 185 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp28_->error = NULL;
#line 187 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			tracker_store_update_running = FALSE;
#line 1182 "tracker-store.c"
		} else {
			TrackerStoreTask* _tmp29_ = NULL;
			TrackerStoreTaskType _tmp30_ = 0;
#line 188 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp29_ = task;
#line 188 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp30_ = _tmp29_->type;
#line 188 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp30_ == TRACKER_STORE_TASK_TYPE_TURTLE) {
#line 1192 "tracker-store.c"
				TrackerStoreTask* _tmp31_ = NULL;
				GError* _tmp32_ = NULL;
				TrackerStoreTask* _tmp35_ = NULL;
				GSourceFunc _tmp36_ = NULL;
				void* _tmp36__target = NULL;
				TrackerStoreTask* _tmp37_ = NULL;
#line 189 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp31_ = task;
#line 189 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp32_ = _tmp31_->error;
#line 189 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp32_ == NULL) {
#line 1205 "tracker-store.c"
					TrackerStoreTask* _tmp33_ = NULL;
					TrackerDataCommitType _tmp34_ = 0;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp33_ = task;
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp34_ = tracker_store_commit_type (_tmp33_);
#line 190 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					tracker_data_notify_transaction (_tmp34_);
#line 1214 "tracker-store.c"
				}
#line 193 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp35_ = task;
#line 193 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp36_ = _tmp35_->callback;
#line 193 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp36__target = _tmp35_->callback_target;
#line 193 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp36_ (_tmp36__target);
#line 194 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp37_ = task;
#line 194 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_g_error_free0 (_tmp37_->error);
#line 194 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp37_->error = NULL;
#line 196 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_update_running = FALSE;
#line 1232 "tracker-store.c"
			}
		}
	}
#line 199 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp40_ = tracker_store_n_queries_running;
#line 199 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp40_ == 0) {
#line 1240 "tracker-store.c"
		gboolean _tmp41_ = FALSE;
#line 199 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp41_ = tracker_store_update_running;
#line 199 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp39_ = !_tmp41_;
#line 1246 "tracker-store.c"
	} else {
#line 199 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp39_ = FALSE;
#line 1250 "tracker-store.c"
	}
#line 199 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp39_) {
#line 1254 "tracker-store.c"
		GSourceFunc _tmp42_ = NULL;
		void* _tmp42__target = NULL;
#line 199 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp42_ = tracker_store_active_callback;
#line 199 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp42__target = tracker_store_active_callback_target;
#line 199 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp38_ = _tmp42_ != NULL;
#line 1263 "tracker-store.c"
	} else {
#line 199 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp38_ = FALSE;
#line 1267 "tracker-store.c"
	}
#line 199 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp38_) {
#line 1271 "tracker-store.c"
		GSourceFunc _tmp43_ = NULL;
		void* _tmp43__target = NULL;
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp43_ = tracker_store_active_callback;
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp43__target = tracker_store_active_callback_target;
#line 200 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp43_ (_tmp43__target);
#line 1280 "tracker-store.c"
	}
#line 203 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 205 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = FALSE;
#line 205 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 1288 "tracker-store.c"
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return _data8_;
#line 1297 "tracker-store.c"
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data8_->task);
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_slice_free (Block8Data, _data8_);
#line 1310 "tracker-store.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self ? g_object_ref (self) : NULL;
#line 1318 "tracker-store.c"
}


static void _tracker_store_wal_hook_tracker_db_wal_callback (gint n_pages) {
#line 218 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_wal_hook (n_pages);
#line 1325 "tracker-store.c"
}


static gboolean __lambda4_ (Block8Data* _data8_) {
	gboolean result = FALSE;
	TrackerStoreTask* _tmp0_ = NULL;
#line 246 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = _data8_->task;
#line 246 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_task_finish_cb (_tmp0_);
#line 247 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = FALSE;
#line 247 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 1340 "tracker-store.c"
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ (self);
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 1349 "tracker-store.c"
}


static void tracker_store_pool_dispatch_cb (TrackerStoreTask* task) {
	Block8Data* _data8_;
	TrackerStoreTask* _tmp0_ = NULL;
	TrackerStoreTask* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (task != NULL);
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data8_ = g_slice_new0 (Block8Data);
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data8_->_ref_count_ = 1;
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = task;
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _tracker_store_task_ref0 (_tmp0_);
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data8_->task);
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data8_->task = _tmp1_;
#line 1372 "tracker-store.c"
	{
		TrackerStoreTask* _tmp2_ = NULL;
		TrackerStoreTaskType _tmp3_ = 0;
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp2_ = _data8_->task;
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp3_ = _tmp2_->type;
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp3_ == TRACKER_STORE_TASK_TYPE_QUERY) {
#line 1382 "tracker-store.c"
			TrackerStoreQueryTask* query_task = NULL;
			TrackerStoreTask* _tmp4_ = NULL;
			TrackerStoreQueryTask* _tmp5_ = NULL;
			TrackerDBCursor* cursor = NULL;
			TrackerStoreQueryTask* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			TrackerDBCursor* _tmp8_ = NULL;
			TrackerStoreQueryTask* _tmp9_ = NULL;
			TrackerStoreSparqlQueryInThread _tmp10_ = NULL;
			void* _tmp10__target = NULL;
			TrackerDBCursor* _tmp11_ = NULL;
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp4_ = _data8_->task;
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp5_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask));
#line 211 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			query_task = _tmp5_;
#line 213 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp6_ = query_task;
#line 213 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp7_ = _tmp6_->query;
#line 213 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp8_ = tracker_data_query_sparql_cursor (_tmp7_, &_inner_error_);
#line 213 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			cursor = _tmp8_;
#line 213 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_inner_error_ != NULL) {
#line 213 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (query_task);
#line 1412 "tracker-store.c"
				goto __catch21_g_error;
			}
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp9_ = query_task;
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp10_ = _tmp9_->in_thread;
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp10__target = _tmp9_->in_thread_target;
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp11_ = cursor;
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp10_ (_tmp11_, _tmp10__target, &_inner_error_);
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_inner_error_ != NULL) {
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_g_object_unref0 (cursor);
#line 215 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (query_task);
#line 1431 "tracker-store.c"
				goto __catch21_g_error;
			}
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_object_unref0 (cursor);
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tracker_store_task_unref0 (query_task);
#line 1438 "tracker-store.c"
		} else {
			TrackerDBInterface* iface = NULL;
			TrackerDBInterface* _tmp12_ = NULL;
			TrackerDBInterface* _tmp13_ = NULL;
			TrackerDBInterface* _tmp14_ = NULL;
			TrackerStoreTask* _tmp15_ = NULL;
			TrackerStoreTaskType _tmp16_ = 0;
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp12_ = tracker_db_manager_get_db_interface ();
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp13_ = _g_object_ref0 (_tmp12_);
#line 217 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			iface = _tmp13_;
#line 218 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp14_ = iface;
#line 218 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			tracker_db_interface_sqlite_wal_hook (_tmp14_, _tracker_store_wal_hook_tracker_db_wal_callback);
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp15_ = _data8_->task;
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp16_ = _tmp15_->type;
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp16_ == TRACKER_STORE_TASK_TYPE_UPDATE) {
#line 1462 "tracker-store.c"
				TrackerStoreUpdateTask* update_task = NULL;
				TrackerStoreTask* _tmp17_ = NULL;
				TrackerStoreUpdateTask* _tmp18_ = NULL;
				TrackerStoreUpdateTask* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp17_ = _data8_->task;
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp18_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask));
#line 221 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				update_task = _tmp18_;
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp19_ = update_task;
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp20_ = _tmp19_->query;
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_data_update_sparql (_tmp20_, &_inner_error_);
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_inner_error_ != NULL) {
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (update_task);
#line 223 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_object_unref0 (iface);
#line 1486 "tracker-store.c"
					goto __catch21_g_error;
				}
#line 220 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tracker_store_task_unref0 (update_task);
#line 1491 "tracker-store.c"
			} else {
				TrackerStoreTask* _tmp21_ = NULL;
				TrackerStoreTaskType _tmp22_ = 0;
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp21_ = _data8_->task;
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp22_ = _tmp21_->type;
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp22_ == TRACKER_STORE_TASK_TYPE_UPDATE_BLANK) {
#line 1501 "tracker-store.c"
					TrackerStoreUpdateTask* update_task = NULL;
					TrackerStoreTask* _tmp23_ = NULL;
					TrackerStoreUpdateTask* _tmp24_ = NULL;
					GVariant* _tmp25_ = NULL;
					TrackerStoreUpdateTask* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					GVariant* _tmp28_ = NULL;
					TrackerStoreUpdateTask* _tmp29_ = NULL;
					GVariant* _tmp30_ = NULL;
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp23_ = _data8_->task;
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp24_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask));
#line 225 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					update_task = _tmp24_;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp26_ = update_task;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp27_ = _tmp26_->query;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp28_ = tracker_data_update_sparql_blank (_tmp27_, &_inner_error_);
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp25_ = _tmp28_;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_inner_error_ != NULL) {
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tracker_store_task_unref0 (update_task);
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_object_unref0 (iface);
#line 1531 "tracker-store.c"
						goto __catch21_g_error;
					}
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp29_ = update_task;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp30_ = _tmp25_;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp25_ = NULL;
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_variant_unref0 (_tmp29_->blank_nodes);
#line 227 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp29_->blank_nodes = _tmp30_;
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_variant_unref0 (_tmp25_);
#line 224 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tracker_store_task_unref0 (update_task);
#line 1548 "tracker-store.c"
				} else {
					TrackerStoreTask* _tmp31_ = NULL;
					TrackerStoreTaskType _tmp32_ = 0;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp31_ = _data8_->task;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp32_ = _tmp31_->type;
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp32_ == TRACKER_STORE_TASK_TYPE_TURTLE) {
#line 1558 "tracker-store.c"
						TrackerStoreTurtleTask* turtle_task = NULL;
						TrackerStoreTask* _tmp33_ = NULL;
						TrackerStoreTurtleTask* _tmp34_ = NULL;
						GFile* file = NULL;
						TrackerStoreTurtleTask* _tmp35_ = NULL;
						const gchar* _tmp36_ = NULL;
						GFile* _tmp37_ = NULL;
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp33_ = _data8_->task;
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp34_ = _tracker_store_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTask));
#line 229 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						turtle_task = _tmp34_;
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp35_ = turtle_task;
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp36_ = _tmp35_->path;
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp37_ = g_file_new_for_path (_tmp36_);
#line 231 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						file = _tmp37_;
#line 233 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						tracker_events_freeze ();
#line 1582 "tracker-store.c"
						{
							GFile* _tmp38_ = NULL;
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_tmp38_ = file;
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							tracker_data_load_turtle_file (_tmp38_, &_inner_error_);
#line 235 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							if (_inner_error_ != NULL) {
#line 1591 "tracker-store.c"
								goto __finally22;
							}
						}
						__finally22:
						{
#line 237 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							tracker_events_reset_pending ();
#line 1599 "tracker-store.c"
						}
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						if (_inner_error_ != NULL) {
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_g_object_unref0 (file);
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_tracker_store_task_unref0 (turtle_task);
#line 234 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
							_g_object_unref0 (iface);
#line 1609 "tracker-store.c"
							goto __catch21_g_error;
						}
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_object_unref0 (file);
#line 228 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tracker_store_task_unref0 (turtle_task);
#line 1616 "tracker-store.c"
					}
				}
			}
#line 210 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_object_unref0 (iface);
#line 1622 "tracker-store.c"
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		TrackerStoreTask* _tmp39_ = NULL;
		GError* _tmp40_ = NULL;
		GError* _tmp41_ = NULL;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		e = _inner_error_;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_inner_error_ = NULL;
#line 242 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp39_ = _data8_->task;
#line 242 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp40_ = e;
#line 242 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp41_ = _g_error_copy0 (_tmp40_);
#line 242 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (_tmp39_->error);
#line 242 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp39_->error = _tmp41_;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (e);
#line 1648 "tracker-store.c"
	}
	__finally21:
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_inner_error_ != NULL) {
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		block8_data_unref (_data8_);
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data8_ = NULL;
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_clear_error (&_inner_error_);
#line 209 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 1663 "tracker-store.c"
	}
#line 245 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda4__gsource_func, block8_data_ref (_data8_), block8_data_unref);
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	block8_data_unref (_data8_);
#line 208 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data8_ = NULL;
#line 1671 "tracker-store.c"
}


void tracker_store_wal_checkpoint (void) {
	GError * _inner_error_ = NULL;
	{
		TrackerDBInterface* iface = NULL;
		TrackerDBInterface* _tmp0_ = NULL;
		TrackerDBInterface* _tmp1_ = NULL;
#line 253 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_debug ("Checkpointing database...");
#line 254 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp0_ = tracker_db_manager_get_db_interface ();
#line 254 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 254 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		iface = _tmp1_;
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_db_interface_execute_query (iface, &_inner_error_, "PRAGMA wal_checkpoint");
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_inner_error_ != NULL) {
#line 255 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_object_unref0 (iface);
#line 1695 "tracker-store.c"
			goto __catch23_g_error;
		}
#line 256 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_debug ("Checkpointing complete...");
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_object_unref0 (iface);
#line 1702 "tracker-store.c"
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		e = _inner_error_;
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_inner_error_ = NULL;
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp2_ = e;
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp3_ = _tmp2_->message;
#line 258 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_warning ("%s", _tmp3_);
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (e);
#line 1722 "tracker-store.c"
	}
	__finally23:
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_inner_error_ != NULL) {
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_clear_error (&_inner_error_);
#line 252 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 1733 "tracker-store.c"
	}
}


static void tracker_store_wal_hook (gint n_pages) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GError * _inner_error_ = NULL;
#line 267 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = n_pages;
#line 267 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_debug ("WAL: %d pages", _tmp0_);
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = n_pages;
#line 269 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp1_ >= 10000) {
#line 272 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_wal_checkpoint ();
#line 1752 "tracker-store.c"
	} else {
		gint _tmp2_ = 0;
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp2_ = n_pages;
#line 273 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_tmp2_ >= 1000) {
#line 1759 "tracker-store.c"
			gboolean _tmp3_ = FALSE;
#line 274 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp3_ = g_atomic_int_compare_and_exchange ((volatile gint *) (&tracker_store_checkpointing), 0, 1);
#line 274 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_tmp3_) {
#line 1765 "tracker-store.c"
				{
					GThreadPool* _tmp4_ = NULL;
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp4_ = tracker_store_checkpoint_pool;
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_thread_pool_push (_tmp4_, (gpointer) ((gintptr) TRUE), &_inner_error_);
#line 277 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_inner_error_ != NULL) {
#line 1774 "tracker-store.c"
						goto __catch24_g_error;
					}
				}
				goto __finally24;
				__catch24_g_error:
				{
					GError* e = NULL;
					GError* _tmp5_ = NULL;
					const gchar* _tmp6_ = NULL;
#line 276 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					e = _inner_error_;
#line 276 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_inner_error_ = NULL;
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp5_ = e;
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp6_ = _tmp5_->message;
#line 279 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_warning ("%s", _tmp6_);
#line 280 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_atomic_int_set ((volatile gint *) (&tracker_store_checkpointing), 0);
#line 276 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_g_error_free0 (e);
#line 1798 "tracker-store.c"
				}
				__finally24:
#line 276 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_inner_error_ != NULL) {
#line 276 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 276 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_clear_error (&_inner_error_);
#line 276 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					return;
#line 1809 "tracker-store.c"
				}
			}
		}
	}
}


static void tracker_store_checkpoint_dispatch_cb (gboolean task) {
#line 289 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_wal_checkpoint ();
#line 290 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_set ((volatile gint *) (&tracker_store_checkpointing), 0);
#line 1822 "tracker-store.c"
}


static void _tracker_store_task_unref0_ (gpointer var) {
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(var == NULL) ? NULL : (var = (tracker_store_task_unref (var), NULL));
#line 1829 "tracker-store.c"
}


static void _g_queue_free__tracker_store_task_unref0_ (GQueue* self) {
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_foreach (self, (GFunc) _tracker_store_task_unref0_, NULL);
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_free (self);
#line 1838 "tracker-store.c"
}


static void _tracker_store_pool_dispatch_cb_gfunc (gconstpointer data, gpointer self) {
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_pool_dispatch_cb ((TrackerStoreTask*) data);
#line 1845 "tracker-store.c"
}


static void _tracker_store_checkpoint_dispatch_cb_gfunc (gconstpointer data, gpointer self) {
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_checkpoint_dispatch_cb ((gboolean) ((gintptr) data));
#line 1852 "tracker-store.c"
}


void tracker_store_init (void) {
	gchar* max_task_time_env = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GPtrArray* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 294 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = g_getenv ("TRACKER_STORE_MAX_TASK_TIME");
#line 294 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 294 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	max_task_time_env = _tmp1_;
#line 295 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = max_task_time_env;
#line 295 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp2_ != NULL) {
#line 1873 "tracker-store.c"
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 296 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp3_ = max_task_time_env;
#line 296 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp4_ = atoi (_tmp3_);
#line 296 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_max_task_time = _tmp4_;
#line 1882 "tracker-store.c"
	} else {
#line 298 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_max_task_time = TRACKER_STORE_MAX_TASK_TIME;
#line 1886 "tracker-store.c"
	}
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp5_ = g_ptr_array_new_with_free_func (_tracker_store_task_unref0_);
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_ptr_array_unref0 (tracker_store_running_tasks);
#line 301 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_running_tasks = _tmp5_;
#line 1894 "tracker-store.c"
	{
		gint i = 0;
#line 303 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 1899 "tracker-store.c"
		{
			gboolean _tmp6_ = FALSE;
#line 303 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp6_ = TRUE;
#line 303 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 1906 "tracker-store.c"
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				GQueue* _tmp10_ = NULL;
				GQueue* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				GQueue* _tmp13_ = NULL;
				GQueue* _tmp14_ = NULL;
#line 303 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp6_) {
#line 1916 "tracker-store.c"
					gint _tmp7_ = 0;
#line 303 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp7_ = i;
#line 303 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp7_ + 1;
#line 1922 "tracker-store.c"
				}
#line 303 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = FALSE;
#line 303 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_ = i;
#line 303 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp8_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 303 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 1932 "tracker-store.c"
				}
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp9_ = i;
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp10_ = g_queue_new ();
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				__g_queue_free__tracker_store_task_unref0_0 (tracker_store_query_queues[_tmp9_]);
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_query_queues[_tmp9_] = _tmp10_;
#line 304 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp11_ = tracker_store_query_queues[_tmp9_];
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp12_ = i;
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp13_ = g_queue_new ();
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				__g_queue_free__tracker_store_task_unref0_0 (tracker_store_update_queues[_tmp12_]);
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_update_queues[_tmp12_] = _tmp13_;
#line 305 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp14_ = tracker_store_update_queues[_tmp12_];
#line 1954 "tracker-store.c"
			}
		}
	}
	{
		GThreadPool* _tmp15_ = NULL;
		GThreadPool* _tmp16_ = NULL;
		GThreadPool* _tmp17_ = NULL;
		GThreadPool* _tmp18_ = NULL;
		GThreadPool* _tmp19_ = NULL;
		GThreadPool* _tmp20_ = NULL;
		GThreadPool* _tmp21_ = NULL;
		GThreadPool* _tmp22_ = NULL;
		GThreadPool* _tmp23_ = NULL;
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp16_ = g_thread_pool_new (_tracker_store_pool_dispatch_cb_gfunc, NULL, 1, TRUE, &_inner_error_);
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp15_ = _tmp16_;
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_inner_error_ != NULL) {
#line 1974 "tracker-store.c"
			goto __catch25_g_error;
		}
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp17_ = _tmp15_;
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp15_ = NULL;
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_update_pool);
#line 309 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_update_pool = _tmp17_;
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp19_ = g_thread_pool_new (_tracker_store_pool_dispatch_cb_gfunc, NULL, TRACKER_STORE_MAX_CONCURRENT_QUERIES, TRUE, &_inner_error_);
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp18_ = _tmp19_;
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_inner_error_ != NULL) {
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (_tmp15_);
#line 1993 "tracker-store.c"
			goto __catch25_g_error;
		}
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp20_ = _tmp18_;
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp18_ = NULL;
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_query_pool);
#line 310 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_query_pool = _tmp20_;
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp22_ = g_thread_pool_new (_tracker_store_checkpoint_dispatch_cb_gfunc, NULL, 1, TRUE, &_inner_error_);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp21_ = _tmp22_;
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_inner_error_ != NULL) {
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (_tmp18_);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (_tmp15_);
#line 2014 "tracker-store.c"
			goto __catch25_g_error;
		}
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp23_ = _tmp21_;
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp21_ = NULL;
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 311 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_checkpoint_pool = _tmp23_;
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (_tmp21_);
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (_tmp18_);
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (_tmp15_);
#line 2031 "tracker-store.c"
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		e = _inner_error_;
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_inner_error_ = NULL;
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp24_ = e;
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp25_ = _tmp24_->message;
#line 313 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_warning ("%s", _tmp25_);
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_error_free0 (e);
#line 2051 "tracker-store.c"
	}
	__finally25:
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_inner_error_ != NULL) {
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_free0 (max_task_time_env);
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_clear_error (&_inner_error_);
#line 308 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2064 "tracker-store.c"
	}
#line 319 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_thread_pool_set_max_idle_time ((guint) (15 * 1000));
#line 320 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_thread_pool_set_max_unused_threads (2);
#line 293 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (max_task_time_env);
#line 2072 "tracker-store.c"
}


void tracker_store_shutdown (void) {
#line 324 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_thread_pool_free0 (tracker_store_query_pool);
#line 324 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_query_pool = NULL;
#line 325 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_thread_pool_free0 (tracker_store_update_pool);
#line 325 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_update_pool = NULL;
#line 326 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 326 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_checkpoint_pool = NULL;
#line 2089 "tracker-store.c"
	{
		gint i = 0;
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 2094 "tracker-store.c"
		{
			gboolean _tmp0_ = FALSE;
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp0_ = TRUE;
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 2101 "tracker-store.c"
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				GQueue* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				GQueue* _tmp6_ = NULL;
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp0_) {
#line 2109 "tracker-store.c"
					gint _tmp1_ = 0;
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp1_ = i;
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp1_ + 1;
#line 2115 "tracker-store.c"
				}
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp0_ = FALSE;
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = i;
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp2_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 328 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 2125 "tracker-store.c"
				}
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp3_ = i;
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				__g_queue_free__tracker_store_task_unref0_0 (tracker_store_query_queues[_tmp3_]);
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_query_queues[_tmp3_] = NULL;
#line 329 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = tracker_store_query_queues[_tmp3_];
#line 330 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = i;
#line 330 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				__g_queue_free__tracker_store_task_unref0_0 (tracker_store_update_queues[_tmp5_]);
#line 330 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				tracker_store_update_queues[_tmp5_] = NULL;
#line 330 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = tracker_store_update_queues[_tmp5_];
#line 2143 "tracker-store.c"
			}
		}
	}
}


static void tracker_store_sparql_query_data_free (gpointer _data) {
	TrackerStoreSparqlQueryData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreSparqlQueryData, _data_);
#line 2159 "tracker-store.c"
}


void tracker_store_sparql_query (const gchar* sparql, TrackerStorePriority priority, TrackerStoreSparqlQueryInThread in_thread, void* in_thread_target, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreSparqlQueryData* _data_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	TrackerStorePriority _tmp2_ = 0;
	TrackerStoreSparqlQueryInThread _tmp3_ = NULL;
	void* _tmp3__target = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlQueryData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_store_sparql_query);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_store_sparql_query_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = sparql;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->sparql = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = priority;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->priority = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = in_thread;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3__target = in_thread_target;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->in_thread = _tmp3_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->in_thread_target = _tmp3__target;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp4_ = client_id;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp5_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sparql_query_co (_data_);
#line 2208 "tracker-store.c"
}


void tracker_store_sparql_query_finish (GAsyncResult* _res_, GError** error) {
	TrackerStoreSparqlQueryData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2218 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2222 "tracker-store.c"
}


static gboolean _tracker_store_sparql_query_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_sparql_query_co (self);
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2231 "tracker-store.c"
}


static gboolean tracker_store_sparql_query_co (TrackerStoreSparqlQueryData* _data_) {
#line 334 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 334 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 2240 "tracker-store.c"
		goto _state_0;
#line 334 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 2244 "tracker-store.c"
		goto _state_1;
		default:
#line 334 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 2249 "tracker-store.c"
	}
	_state_0:
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = NULL;
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_query_task_new ();
#line 335 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 336 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = NULL;
#line 336 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 336 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_QUERY;
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = NULL;
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = NULL;
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = _data_->sparql;
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = NULL;
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->_tmp2_->query);
#line 337 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->query = _data_->_tmp4_;
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = NULL;
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = NULL;
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = g_cancellable_new ();
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->_tmp5_->cancellable);
#line 338 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_->cancellable = _data_->_tmp6_;
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = NULL;
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->task;
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = NULL;
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8__target = NULL;
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = _data_->in_thread;
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8__target = _data_->in_thread_target;
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_->in_thread = _data_->_tmp8_;
#line 339 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_->in_thread_target = _data_->_tmp8__target;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = NULL;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = _data_->task;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp9_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp9_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp9_)->callback_target), NULL);
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback = NULL;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback_target = NULL;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback_target_destroy_notify = NULL;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback = _tracker_store_sparql_query_co_gsource_func;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback_target = _data_;
#line 340 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp9_)->callback_target_destroy_notify = NULL;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = NULL;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = _data_->task;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = NULL;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _data_->client_id;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = NULL;
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (((TrackerStoreTask*) _data_->_tmp10_)->client_id);
#line 341 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp10_)->client_id = _data_->_tmp12_;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = 0;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = _data_->priority;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = NULL;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = tracker_store_query_queues[_data_->_tmp13_];
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp15_ = NULL;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp15_ = _data_->task;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp16_ = NULL;
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp16_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp15_);
#line 343 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp14_, _data_->_tmp16_);
#line 345 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 347 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 347 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2366 "tracker-store.c"
	_state_1:
	;
#line 349 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp17_ = NULL;
#line 349 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp17_ = _data_->task;
#line 349 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp18_ = NULL;
#line 349 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp18_ = ((TrackerStoreTask*) _data_->_tmp17_)->error;
#line 349 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp18_ != NULL) {
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp19_ = NULL;
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp19_ = _data_->task;
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp20_ = NULL;
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp20_ = ((TrackerStoreTask*) _data_->_tmp19_)->error;
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp21_ = NULL;
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp21_ = _g_error_copy0 (_data_->_tmp20_);
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp21_;
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_error_free (_data_->_inner_error_);
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_data_->_state_ == 0) {
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2403 "tracker-store.c"
		} else {
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2407 "tracker-store.c"
		}
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 350 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 2413 "tracker-store.c"
	}
#line 334 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 334 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ == 0) {
#line 334 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2421 "tracker-store.c"
	} else {
#line 334 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2425 "tracker-store.c"
	}
#line 334 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 334 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2431 "tracker-store.c"
}


static void tracker_store_sparql_update_data_free (gpointer _data) {
	TrackerStoreSparqlUpdateData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreSparqlUpdateData, _data_);
#line 2444 "tracker-store.c"
}


void tracker_store_sparql_update (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreSparqlUpdateData* _data_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	TrackerStorePriority _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlUpdateData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_store_sparql_update);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_store_sparql_update_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = sparql;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->sparql = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = priority;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->priority = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = client_id;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sparql_update_co (_data_);
#line 2483 "tracker-store.c"
}


void tracker_store_sparql_update_finish (GAsyncResult* _res_, GError** error) {
	TrackerStoreSparqlUpdateData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 2493 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2497 "tracker-store.c"
}


static gboolean _tracker_store_sparql_update_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_sparql_update_co (self);
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2506 "tracker-store.c"
}


static gboolean tracker_store_sparql_update_co (TrackerStoreSparqlUpdateData* _data_) {
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 2515 "tracker-store.c"
		goto _state_0;
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 2519 "tracker-store.c"
		goto _state_1;
		default:
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 2524 "tracker-store.c"
	}
	_state_0:
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = NULL;
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_update_task_new ();
#line 355 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 356 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = NULL;
#line 356 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 356 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_UPDATE;
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = NULL;
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = NULL;
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = _data_->sparql;
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = NULL;
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->_tmp2_->query);
#line 357 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->query = _data_->_tmp4_;
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = NULL;
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = 0;
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = _data_->priority;
#line 358 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_->priority = _data_->_tmp6_;
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = NULL;
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->task;
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp7_)->callback_target), NULL);
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = NULL;
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = NULL;
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = _tracker_store_sparql_update_co_gsource_func;
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = _data_;
#line 359 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = NULL;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = _data_->task;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = NULL;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = _data_->client_id;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = NULL;
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (((TrackerStoreTask*) _data_->_tmp8_)->client_id);
#line 360 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp8_)->client_id = _data_->_tmp10_;
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = 0;
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _data_->priority;
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = NULL;
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = tracker_store_update_queues[_data_->_tmp11_];
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = NULL;
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = _data_->task;
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = NULL;
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp13_);
#line 362 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp12_, _data_->_tmp14_);
#line 364 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 366 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 366 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2623 "tracker-store.c"
	_state_1:
	;
#line 368 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp15_ = NULL;
#line 368 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp15_ = _data_->task;
#line 368 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp16_ = NULL;
#line 368 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp16_ = ((TrackerStoreTask*) _data_->_tmp15_)->error;
#line 368 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp16_ != NULL) {
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp17_ = NULL;
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp17_ = _data_->task;
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp18_ = NULL;
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp18_ = ((TrackerStoreTask*) _data_->_tmp17_)->error;
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp19_ = NULL;
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp19_ = _g_error_copy0 (_data_->_tmp18_);
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp19_;
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_error_free (_data_->_inner_error_);
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_data_->_state_ == 0) {
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2660 "tracker-store.c"
		} else {
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2664 "tracker-store.c"
		}
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 369 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 2670 "tracker-store.c"
	}
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ == 0) {
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2678 "tracker-store.c"
	} else {
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2682 "tracker-store.c"
	}
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 354 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2688 "tracker-store.c"
}


static void tracker_store_sparql_update_blank_data_free (gpointer _data) {
	TrackerStoreSparqlUpdateBlankData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_variant_unref0 (_data_->result);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreSparqlUpdateBlankData, _data_);
#line 2703 "tracker-store.c"
}


void tracker_store_sparql_update_blank (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreSparqlUpdateBlankData* _data_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	TrackerStorePriority _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlUpdateBlankData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_store_sparql_update_blank);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_store_sparql_update_blank_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = sparql;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->sparql = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = priority;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->priority = _tmp2_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = client_id;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp4_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sparql_update_blank_co (_data_);
#line 2742 "tracker-store.c"
}


GVariant* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerStoreSparqlUpdateBlankData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return NULL;
#line 2753 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = _data_->result;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->result = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2763 "tracker-store.c"
}


static gboolean _tracker_store_sparql_update_blank_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_sparql_update_blank_co (self);
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 2772 "tracker-store.c"
}


static gpointer _g_variant_ref0 (gpointer self) {
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self ? g_variant_ref (self) : NULL;
#line 2779 "tracker-store.c"
}


static gboolean tracker_store_sparql_update_blank_co (TrackerStoreSparqlUpdateBlankData* _data_) {
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 2788 "tracker-store.c"
		goto _state_0;
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 2792 "tracker-store.c"
		goto _state_1;
		default:
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 2797 "tracker-store.c"
	}
	_state_0:
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = NULL;
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_update_task_new ();
#line 374 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 375 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = NULL;
#line 375 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 375 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_UPDATE_BLANK;
#line 376 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = NULL;
#line 376 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 376 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = NULL;
#line 376 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = _data_->sparql;
#line 376 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = NULL;
#line 376 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 376 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->_tmp2_->query);
#line 376 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->query = _data_->_tmp4_;
#line 377 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = NULL;
#line 377 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 377 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = 0;
#line 377 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = _data_->priority;
#line 377 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_->priority = _data_->_tmp6_;
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = NULL;
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->task;
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp7_)->callback_target), NULL);
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = NULL;
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = NULL;
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback = _tracker_store_sparql_update_blank_co_gsource_func;
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target = _data_;
#line 378 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp7_)->callback_target_destroy_notify = NULL;
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = NULL;
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = _data_->task;
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = NULL;
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = _data_->client_id;
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = NULL;
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (((TrackerStoreTask*) _data_->_tmp8_)->client_id);
#line 379 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp8_)->client_id = _data_->_tmp10_;
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = 0;
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _data_->priority;
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = NULL;
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = tracker_store_update_queues[_data_->_tmp11_];
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = NULL;
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = _data_->task;
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = NULL;
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp14_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp13_);
#line 381 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp12_, _data_->_tmp14_);
#line 383 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 385 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2896 "tracker-store.c"
	_state_1:
	;
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp15_ = NULL;
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp15_ = _data_->task;
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp16_ = NULL;
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp16_ = ((TrackerStoreTask*) _data_->_tmp15_)->error;
#line 387 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp16_ != NULL) {
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp17_ = NULL;
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp17_ = _data_->task;
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp18_ = NULL;
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp18_ = ((TrackerStoreTask*) _data_->_tmp17_)->error;
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp19_ = NULL;
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp19_ = _g_error_copy0 (_data_->_tmp18_);
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp19_;
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_error_free (_data_->_inner_error_);
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_data_->_state_ == 0) {
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2933 "tracker-store.c"
		} else {
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2937 "tracker-store.c"
		}
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 388 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 2943 "tracker-store.c"
	}
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp20_ = NULL;
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp20_ = _data_->task;
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp21_ = NULL;
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp21_ = _data_->_tmp20_->blank_nodes;
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp22_ = NULL;
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp22_ = _g_variant_ref0 (_data_->_tmp21_);
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->result = _data_->_tmp22_;
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ == 0) {
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2965 "tracker-store.c"
	} else {
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2969 "tracker-store.c"
	}
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 391 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ == 0) {
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2981 "tracker-store.c"
	} else {
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2985 "tracker-store.c"
	}
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 373 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 2991 "tracker-store.c"
}


static void tracker_store_queue_turtle_import_data_free (gpointer _data) {
	TrackerStoreQueueTurtleImportData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->file);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStoreQueueTurtleImportData, _data_);
#line 3004 "tracker-store.c"
}


void tracker_store_queue_turtle_import (GFile* file, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStoreQueueTurtleImportData* _data_;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreQueueTurtleImportData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_store_queue_turtle_import);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_store_queue_turtle_import_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = file;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (_data_->file);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->file = _tmp1_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp2_ = client_id;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->client_id = _tmp3_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_queue_turtle_import_co (_data_);
#line 3038 "tracker-store.c"
}


void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_, GError** error) {
	TrackerStoreQueueTurtleImportData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return;
#line 3048 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3052 "tracker-store.c"
}


static gboolean _tracker_store_queue_turtle_import_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_queue_turtle_import_co (self);
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 3061 "tracker-store.c"
}


static gboolean tracker_store_queue_turtle_import_co (TrackerStoreQueueTurtleImportData* _data_) {
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 3070 "tracker-store.c"
		goto _state_0;
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 3074 "tracker-store.c"
		goto _state_1;
		default:
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 3079 "tracker-store.c"
	}
	_state_0:
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = NULL;
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp0_ = tracker_store_turtle_task_new ();
#line 395 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->task = _data_->_tmp0_;
#line 396 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = NULL;
#line 396 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = _data_->task;
#line 396 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp1_)->type = TRACKER_STORE_TASK_TYPE_TURTLE;
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = NULL;
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_ = _data_->task;
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = NULL;
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = _data_->file;
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = NULL;
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp4_ = g_file_get_path (_data_->_tmp3_);
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (_data_->_tmp2_->path);
#line 397 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp2_->path = _data_->_tmp4_;
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = NULL;
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify (((TrackerStoreTask*) _data_->_tmp5_)->callback_target), NULL);
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback = NULL;
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target = NULL;
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify = NULL;
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback = _tracker_store_queue_turtle_import_co_gsource_func;
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target = _data_;
#line 398 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp5_)->callback_target_destroy_notify = NULL;
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = NULL;
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp6_ = _data_->task;
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = NULL;
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp7_ = _data_->client_id;
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = NULL;
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (((TrackerStoreTask*) _data_->_tmp6_)->client_id);
#line 399 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	((TrackerStoreTask*) _data_->_tmp6_)->client_id = _data_->_tmp8_;
#line 401 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = NULL;
#line 401 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = tracker_store_update_queues[TRACKER_STORE_PRIORITY_TURTLE];
#line 401 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = NULL;
#line 401 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp10_ = _data_->task;
#line 401 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = NULL;
#line 401 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp11_ = _tracker_store_task_ref0 ((TrackerStoreTask*) _data_->_tmp10_);
#line 401 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_queue_push_tail (_data_->_tmp9_, _data_->_tmp11_);
#line 403 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 405 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_state_ = 1;
#line 405 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 3164 "tracker-store.c"
	_state_1:
	;
#line 407 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = NULL;
#line 407 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp12_ = _data_->task;
#line 407 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = NULL;
#line 407 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp13_ = ((TrackerStoreTask*) _data_->_tmp12_)->error;
#line 407 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp13_ != NULL) {
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp14_ = NULL;
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp14_ = _data_->task;
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp15_ = NULL;
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp15_ = ((TrackerStoreTask*) _data_->_tmp14_)->error;
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp16_ = NULL;
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_inner_error_ = _data_->_tmp16_;
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_error_free (_data_->_inner_error_);
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tracker_store_task_unref0 (_data_->task);
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_data_->_state_ == 0) {
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3201 "tracker-store.c"
		} else {
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3205 "tracker-store.c"
		}
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 408 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 3211 "tracker-store.c"
	}
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tracker_store_task_unref0 (_data_->task);
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ == 0) {
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3219 "tracker-store.c"
	} else {
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3223 "tracker-store.c"
	}
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 394 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 3229 "tracker-store.c"
}


guint tracker_store_get_queue_size (TrackerStore* self) {
	guint result = 0U;
	guint _result_ = 0U;
#line 412 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 413 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_result_ = (guint) 0;
#line 3240 "tracker-store.c"
	{
		gint i = 0;
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 3245 "tracker-store.c"
		{
			gboolean _tmp0_ = FALSE;
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp0_ = TRUE;
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 3252 "tracker-store.c"
				gint _tmp2_ = 0;
				guint _tmp3_ = 0U;
				gint _tmp4_ = 0;
				GQueue* _tmp5_ = NULL;
				guint _tmp6_ = 0U;
				guint _tmp7_ = 0U;
				gint _tmp8_ = 0;
				GQueue* _tmp9_ = NULL;
				guint _tmp10_ = 0U;
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp0_) {
#line 3264 "tracker-store.c"
					gint _tmp1_ = 0;
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp1_ = i;
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp1_ + 1;
#line 3270 "tracker-store.c"
				}
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp0_ = FALSE;
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = i;
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp2_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 415 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 3280 "tracker-store.c"
				}
#line 416 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp3_ = _result_;
#line 416 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = i;
#line 416 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = tracker_store_query_queues[_tmp4_];
#line 416 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = g_queue_get_length (_tmp5_);
#line 416 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_result_ = _tmp3_ + _tmp6_;
#line 417 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp7_ = _result_;
#line 417 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_ = i;
#line 417 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp9_ = tracker_store_update_queues[_tmp8_];
#line 417 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp10_ = g_queue_get_length (_tmp9_);
#line 417 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_result_ = _tmp7_ + _tmp10_;
#line 3302 "tracker-store.c"
			}
		}
	}
#line 419 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	result = _result_;
#line 419 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 3310 "tracker-store.c"
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
#line 4319 "/home/carlos/Build/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 4319 "/home/carlos/Build/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = self->len;
#line 4319 "/home/carlos/Build/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	result = (gint) _tmp0_;
#line 4319 "/home/carlos/Build/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	return result;
#line 3325 "tracker-store.c"
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
#line 4320 "/home/carlos/Build/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 4320 "/home/carlos/Build/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	_tmp0_ = value;
#line 4320 "/home/carlos/Build/gnome/share/vala-0.24/vapi/glib-2.0.vapi"
	g_ptr_array_set_size (self, _tmp0_);
#line 3337 "tracker-store.c"
}


void tracker_store_unreg_batches (const gchar* client_id) {
	GList* list = NULL;
	GList* cur = NULL;
	GQueue* queue = NULL;
#line 422 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (client_id != NULL);
#line 3347 "tracker-store.c"
	{
		gint i = 0;
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 3352 "tracker-store.c"
		{
			gboolean _tmp0_ = FALSE;
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp0_ = TRUE;
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 3359 "tracker-store.c"
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				TrackerStoreQueryTask* task = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				TrackerStoreTask* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				TrackerStoreQueryTask* _tmp12_ = NULL;
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp0_) {
#line 3374 "tracker-store.c"
					gint _tmp1_ = 0;
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp1_ = i;
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp1_ + 1;
#line 3380 "tracker-store.c"
				}
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp0_ = FALSE;
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp2_ = i;
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp3_ = tracker_store_running_tasks;
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp5_ = _tmp4_;
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp2_ < _tmp5_)) {
#line 426 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 3396 "tracker-store.c"
				}
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp6_ = tracker_store_running_tasks;
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp7_ = i;
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp9_ = (TrackerStoreTask*) _tmp8_;
#line 427 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				task = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, TRACKER_STORE_TYPE_QUERY_TASK) ? ((TrackerStoreQueryTask*) _tmp9_) : NULL;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp12_ = task;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp12_ != NULL) {
#line 3412 "tracker-store.c"
					TrackerStoreQueryTask* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp13_ = task;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp14_ = ((TrackerStoreTask*) _tmp13_)->client_id;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp15_ = client_id;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp11_ = g_strcmp0 (_tmp14_, _tmp15_) == 0;
#line 3424 "tracker-store.c"
				} else {
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp11_ = FALSE;
#line 3428 "tracker-store.c"
				}
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp11_) {
#line 3432 "tracker-store.c"
					TrackerStoreQueryTask* _tmp16_ = NULL;
					GCancellable* _tmp17_ = NULL;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp16_ = task;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp17_ = _tmp16_->cancellable;
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp10_ = _tmp17_ != NULL;
#line 3441 "tracker-store.c"
				} else {
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp10_ = FALSE;
#line 3445 "tracker-store.c"
				}
#line 428 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (_tmp10_) {
#line 3449 "tracker-store.c"
					TrackerStoreQueryTask* _tmp18_ = NULL;
					GCancellable* _tmp19_ = NULL;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp18_ = task;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp19_ = _tmp18_->cancellable;
#line 429 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					g_cancellable_cancel (_tmp19_);
#line 3458 "tracker-store.c"
				}
			}
		}
	}
	{
		gint i = 0;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		i = 0;
#line 3467 "tracker-store.c"
		{
			gboolean _tmp20_ = FALSE;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_tmp20_ = TRUE;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			while (TRUE) {
#line 3474 "tracker-store.c"
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				GQueue* _tmp24_ = NULL;
				GQueue* _tmp25_ = NULL;
				GList* _tmp26_ = NULL;
				gint _tmp44_ = 0;
				GQueue* _tmp45_ = NULL;
				GQueue* _tmp46_ = NULL;
				GList* _tmp47_ = NULL;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!_tmp20_) {
#line 3486 "tracker-store.c"
					gint _tmp21_ = 0;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp21_ = i;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					i = _tmp21_ + 1;
#line 3492 "tracker-store.c"
				}
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp20_ = FALSE;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp22_ = i;
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				if (!(_tmp22_ < ((gint) TRACKER_STORE_PRIORITY_N_PRIORITIES))) {
#line 433 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					break;
#line 3502 "tracker-store.c"
				}
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp23_ = i;
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp24_ = tracker_store_query_queues[_tmp23_];
#line 434 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				queue = _tmp24_;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp25_ = queue;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp26_ = _tmp25_->head;
#line 435 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				list = _tmp26_;
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 3518 "tracker-store.c"
					GList* _tmp27_ = NULL;
					GList* _tmp28_ = NULL;
					GList* _tmp29_ = NULL;
					GList* _tmp30_ = NULL;
					TrackerStoreTask* task = NULL;
					GList* _tmp31_ = NULL;
					gconstpointer _tmp32_ = NULL;
					gboolean _tmp33_ = FALSE;
					TrackerStoreTask* _tmp34_ = NULL;
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp27_ = list;
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp27_ != NULL)) {
#line 436 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 3534 "tracker-store.c"
					}
#line 437 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp28_ = list;
#line 437 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					cur = _tmp28_;
#line 438 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp29_ = list;
#line 438 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp30_ = _tmp29_->next;
#line 438 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					list = _tmp30_;
#line 439 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp31_ = cur;
#line 439 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp32_ = _tmp31_->data;
#line 439 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp32_;
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp34_ = task;
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp34_ != NULL) {
#line 3556 "tracker-store.c"
						TrackerStoreTask* _tmp35_ = NULL;
						const gchar* _tmp36_ = NULL;
						const gchar* _tmp37_ = NULL;
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp35_ = task;
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp36_ = _tmp35_->client_id;
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp37_ = client_id;
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp33_ = g_strcmp0 (_tmp36_, _tmp37_) == 0;
#line 3568 "tracker-store.c"
					} else {
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp33_ = FALSE;
#line 3572 "tracker-store.c"
					}
#line 441 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp33_) {
#line 3576 "tracker-store.c"
						GQueue* _tmp38_ = NULL;
						GList* _tmp39_ = NULL;
						TrackerStoreTask* _tmp40_ = NULL;
						GError* _tmp41_ = NULL;
						TrackerStoreTask* _tmp42_ = NULL;
						GSourceFunc _tmp43_ = NULL;
						void* _tmp43__target = NULL;
#line 442 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp38_ = queue;
#line 442 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp39_ = cur;
#line 442 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						g_queue_delete_link (_tmp38_, _tmp39_);
#line 444 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp40_ = task;
#line 444 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp41_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Client disappeared");
#line 444 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_error_free0 (_tmp40_->error);
#line 444 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp40_->error = _tmp41_;
#line 445 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp42_ = task;
#line 445 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp43_ = _tmp42_->callback;
#line 445 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp43__target = _tmp42_->callback_target;
#line 445 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp43_ (_tmp43__target);
#line 3606 "tracker-store.c"
					}
				}
#line 449 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp44_ = i;
#line 449 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp45_ = tracker_store_update_queues[_tmp44_];
#line 449 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				queue = _tmp45_;
#line 450 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp46_ = queue;
#line 450 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				_tmp47_ = _tmp46_->head;
#line 450 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				list = _tmp47_;
#line 451 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
				while (TRUE) {
#line 3623 "tracker-store.c"
					GList* _tmp48_ = NULL;
					GList* _tmp49_ = NULL;
					GList* _tmp50_ = NULL;
					GList* _tmp51_ = NULL;
					TrackerStoreTask* task = NULL;
					GList* _tmp52_ = NULL;
					gconstpointer _tmp53_ = NULL;
					gboolean _tmp54_ = FALSE;
					TrackerStoreTask* _tmp55_ = NULL;
#line 451 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp48_ = list;
#line 451 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (!(_tmp48_ != NULL)) {
#line 451 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						break;
#line 3639 "tracker-store.c"
					}
#line 452 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp49_ = list;
#line 452 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					cur = _tmp49_;
#line 453 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp50_ = list;
#line 453 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp51_ = _tmp50_->next;
#line 453 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					list = _tmp51_;
#line 454 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp52_ = cur;
#line 454 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp53_ = _tmp52_->data;
#line 454 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					task = (TrackerStoreTask*) _tmp53_;
#line 456 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					_tmp55_ = task;
#line 456 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp55_ != NULL) {
#line 3661 "tracker-store.c"
						TrackerStoreTask* _tmp56_ = NULL;
						const gchar* _tmp57_ = NULL;
						const gchar* _tmp58_ = NULL;
#line 456 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp56_ = task;
#line 456 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp57_ = _tmp56_->client_id;
#line 456 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp58_ = client_id;
#line 456 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp54_ = g_strcmp0 (_tmp57_, _tmp58_) == 0;
#line 3673 "tracker-store.c"
					} else {
#line 456 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp54_ = FALSE;
#line 3677 "tracker-store.c"
					}
#line 456 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
					if (_tmp54_) {
#line 3681 "tracker-store.c"
						GQueue* _tmp59_ = NULL;
						GList* _tmp60_ = NULL;
						TrackerStoreTask* _tmp61_ = NULL;
						GError* _tmp62_ = NULL;
						TrackerStoreTask* _tmp63_ = NULL;
						GSourceFunc _tmp64_ = NULL;
						void* _tmp64__target = NULL;
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp59_ = queue;
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp60_ = cur;
#line 457 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						g_queue_delete_link (_tmp59_, _tmp60_);
#line 459 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp61_ = task;
#line 459 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp62_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Client disappeared");
#line 459 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_g_error_free0 (_tmp61_->error);
#line 459 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp61_->error = _tmp62_;
#line 460 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp63_ = task;
#line 460 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp64_ = _tmp63_->callback;
#line 460 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp64__target = _tmp63_->callback_target;
#line 460 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
						_tmp64_ (_tmp64__target);
#line 3711 "tracker-store.c"
					}
				}
			}
		}
	}
#line 465 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 3719 "tracker-store.c"
}


static void tracker_store_pause_data_free (gpointer _data) {
	TrackerStorePauseData* _data_;
	_data_ = _data;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_slice_free (TrackerStorePauseData, _data_);
#line 3728 "tracker-store.c"
}


void tracker_store_pause (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerStorePauseData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStorePauseData);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tracker_store_pause);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_store_pause_data_free);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_pause_co (_data_);
#line 3742 "tracker-store.c"
}


void tracker_store_pause_finish (GAsyncResult* _res_) {
	TrackerStorePauseData* _data_;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3750 "tracker-store.c"
}


static gboolean _tracker_store_pause_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_store_pause_co (self);
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return result;
#line 3759 "tracker-store.c"
}


static gboolean tracker_store_pause_co (TrackerStorePauseData* _data_) {
#line 468 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	switch (_data_->_state_) {
#line 468 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 0:
#line 3768 "tracker-store.c"
		goto _state_0;
#line 468 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		case 1:
#line 3772 "tracker-store.c"
		goto _state_1;
		default:
#line 468 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_assert_not_reached ();
#line 3777 "tracker-store.c"
	}
	_state_0:
#line 469 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_active = FALSE;
#line 471 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = 0;
#line 471 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp1_ = tracker_store_n_queries_running;
#line 471 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp1_ > 0) {
#line 471 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp0_ = TRUE;
#line 3790 "tracker-store.c"
	} else {
#line 471 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp2_ = FALSE;
#line 471 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp2_ = tracker_store_update_running;
#line 471 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_tmp0_ = _data_->_tmp2_;
#line 3798 "tracker-store.c"
	}
#line 471 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp0_) {
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		(tracker_store_active_callback_target_destroy_notify == NULL) ? NULL : (tracker_store_active_callback_target_destroy_notify (tracker_store_active_callback_target), NULL);
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = NULL;
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = NULL;
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = _tracker_store_pause_co_gsource_func;
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = _data_;
#line 472 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 473 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_data_->_state_ = 1;
#line 473 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return FALSE;
#line 3820 "tracker-store.c"
		_state_1:
		;
#line 474 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		(tracker_store_active_callback_target_destroy_notify == NULL) ? NULL : (tracker_store_active_callback_target_destroy_notify (tracker_store_active_callback_target), NULL);
#line 474 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = NULL;
#line 474 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = NULL;
#line 474 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 474 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback = NULL;
#line 474 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target = NULL;
#line 474 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_active_callback_target_destroy_notify = NULL;
#line 3837 "tracker-store.c"
	}
#line 477 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = 0;
#line 477 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp3_ = g_atomic_int_get ((volatile gint *) (&tracker_store_checkpointing));
#line 477 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp3_ != 0) {
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 479 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_checkpoint_pool = NULL;
#line 3849 "tracker-store.c"
		{
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp5_ = NULL;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp5_ = g_thread_pool_new (_tracker_store_checkpoint_dispatch_cb_gfunc, NULL, 1, TRUE, &_data_->_inner_error_);
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp4_ = _data_->_tmp5_;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			if (_data_->_inner_error_ != NULL) {
#line 3859 "tracker-store.c"
				goto __catch26_g_error;
			}
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp6_ = NULL;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp6_ = _data_->_tmp4_;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp4_ = NULL;
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (tracker_store_checkpoint_pool);
#line 481 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			tracker_store_checkpoint_pool = _data_->_tmp6_;
#line 480 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_thread_pool_free0 (_data_->_tmp4_);
#line 3874 "tracker-store.c"
		}
		goto __finally26;
		__catch26_g_error:
		{
#line 480 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->e = _data_->_inner_error_;
#line 480 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_inner_error_ = NULL;
#line 483 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp7_ = NULL;
#line 483 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp7_ = _data_->e;
#line 483 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp8_ = NULL;
#line 483 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_data_->_tmp8_ = _data_->_tmp7_->message;
#line 483 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_warning ("%s", _data_->_tmp8_);
#line 480 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			_g_error_free0 (_data_->e);
#line 3895 "tracker-store.c"
		}
		__finally26:
#line 480 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (_data_->_inner_error_ != NULL) {
#line 480 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 480 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			g_clear_error (&_data_->_inner_error_);
#line 480 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return FALSE;
#line 3906 "tracker-store.c"
		}
	}
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = FALSE;
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_data_->_tmp9_ = tracker_store_active;
#line 487 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_tmp9_) {
#line 488 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_sched ();
#line 3917 "tracker-store.c"
	}
#line 468 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_data_->_state_ == 0) {
#line 468 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3923 "tracker-store.c"
	} else {
#line 468 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3927 "tracker-store.c"
	}
#line 468 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 468 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return FALSE;
#line 3933 "tracker-store.c"
}


void tracker_store_resume (void) {
#line 493 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_active = TRUE;
#line 495 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_sched ();
#line 3942 "tracker-store.c"
}


TrackerStore* tracker_store_construct (GType object_type) {
	TrackerStore* self = NULL;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStore*) g_type_create_instance (object_type);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 3952 "tracker-store.c"
}


TrackerStore* tracker_store_new (void) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_construct (TRACKER_TYPE_STORE);
#line 3959 "tracker-store.c"
}


static TrackerStoreTask* tracker_store_task_construct (GType object_type) {
	TrackerStoreTask* self = NULL;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreTask*) g_type_create_instance (object_type);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 3969 "tracker-store.c"
}


static void tracker_store_value_task_init (GValue* value) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	value->data[0].v_pointer = NULL;
#line 3976 "tracker-store.c"
}


static void tracker_store_value_task_free_value (GValue* value) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (value->data[0].v_pointer) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_unref (value->data[0].v_pointer);
#line 3985 "tracker-store.c"
	}
}


static void tracker_store_value_task_copy_value (const GValue* src_value, GValue* dest_value) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (src_value->data[0].v_pointer) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = tracker_store_task_ref (src_value->data[0].v_pointer);
#line 3995 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3999 "tracker-store.c"
	}
}


static gpointer tracker_store_value_task_peek_pointer (const GValue* value) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 4007 "tracker-store.c"
}


static gchar* tracker_store_value_task_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (collect_values[0].v_pointer) {
#line 4014 "tracker-store.c"
		TrackerStoreTask* object;
		object = collect_values[0].v_pointer;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (object->parent_instance.g_class == NULL) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4021 "tracker-store.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4025 "tracker-store.c"
		}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = tracker_store_task_ref (object);
#line 4029 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4033 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 4037 "tracker-store.c"
}


static gchar* tracker_store_value_task_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerStoreTask** object_p;
	object_p = collect_values[0].v_pointer;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!object_p) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4048 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!value->data[0].v_pointer) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = NULL;
#line 4054 "tracker-store.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = value->data[0].v_pointer;
#line 4058 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = tracker_store_task_ref (value->data[0].v_pointer);
#line 4062 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 4066 "tracker-store.c"
}


static GParamSpec* tracker_store_param_spec_task (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerStoreParamSpecTask* spec;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_STORE_TYPE_TASK), NULL);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return G_PARAM_SPEC (spec);
#line 4080 "tracker-store.c"
}


static gpointer tracker_store_value_get_task (const GValue* value) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK), NULL);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 4089 "tracker-store.c"
}


static void tracker_store_value_set_task (GValue* value, gpointer v_object) {
	TrackerStoreTask* old;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_ref (value->data[0].v_pointer);
#line 4109 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4113 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_unref (old);
#line 4119 "tracker-store.c"
	}
}


static void tracker_store_value_take_task (GValue* value, gpointer v_object) {
	TrackerStoreTask* old;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_STORE_TYPE_TASK));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 4138 "tracker-store.c"
	} else {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4142 "tracker-store.c"
	}
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_task_unref (old);
#line 4148 "tracker-store.c"
	}
}


static void tracker_store_task_class_init (TrackerStoreTaskClass * klass) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_task_parent_class = g_type_class_peek_parent (klass);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (klass)->finalize = tracker_store_task_finalize;
#line 4158 "tracker-store.c"
}


static void tracker_store_task_instance_init (TrackerStoreTask * self) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->ref_count = 1;
#line 4165 "tracker-store.c"
}


static void tracker_store_task_finalize (TrackerStoreTask* obj) {
	TrackerStoreTask * self;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_TASK, TrackerStoreTask);
#line 57 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (self->client_id);
#line 58 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_error_free0 (self->error);
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->callback = NULL;
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->callback_target = NULL;
#line 59 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->callback_target_destroy_notify = NULL;
#line 4185 "tracker-store.c"
}


static GType tracker_store_task_get_type (void) {
	static volatile gsize tracker_store_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_task_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_store_value_task_init, tracker_store_value_task_free_value, tracker_store_value_task_copy_value, tracker_store_value_task_peek_pointer, "p", tracker_store_value_task_collect_value, "p", tracker_store_value_task_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreTask), 0, (GInstanceInitFunc) tracker_store_task_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_store_task_type_id;
		tracker_store_task_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerStoreTask", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&tracker_store_task_type_id__volatile, tracker_store_task_type_id);
	}
	return tracker_store_task_type_id__volatile;
}


static gpointer tracker_store_task_ref (gpointer instance) {
	TrackerStoreTask* self;
	self = instance;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&self->ref_count);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return instance;
#line 4210 "tracker-store.c"
}


static void tracker_store_task_unref (gpointer instance) {
	TrackerStoreTask* self;
	self = instance;
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		TRACKER_STORE_TASK_GET_CLASS (self)->finalize (self);
#line 55 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4223 "tracker-store.c"
	}
}


static TrackerStoreQueryTask* tracker_store_query_task_construct (GType object_type) {
	TrackerStoreQueryTask* self = NULL;
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreQueryTask*) tracker_store_task_construct (object_type);
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 4234 "tracker-store.c"
}


static TrackerStoreQueryTask* tracker_store_query_task_new (void) {
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_query_task_construct (TRACKER_STORE_TYPE_QUERY_TASK);
#line 4241 "tracker-store.c"
}


static void tracker_store_query_task_class_init (TrackerStoreQueryTaskClass * klass) {
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_query_task_parent_class = g_type_class_peek_parent (klass);
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (klass)->finalize = tracker_store_query_task_finalize;
#line 4250 "tracker-store.c"
}


static void tracker_store_query_task_instance_init (TrackerStoreQueryTask * self) {
}


static void tracker_store_query_task_finalize (TrackerStoreTask* obj) {
	TrackerStoreQueryTask * self;
	guint _tmp0_ = 0U;
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_QUERY_TASK, TrackerStoreQueryTask);
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_tmp0_ = self->watchdog_id;
#line 69 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (_tmp0_ > ((guint) 0)) {
#line 4267 "tracker-store.c"
		guint _tmp1_ = 0U;
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		_tmp1_ = self->watchdog_id;
#line 70 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_source_remove (_tmp1_);
#line 4273 "tracker-store.c"
	}
#line 63 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (self->query);
#line 64 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_object_unref0 (self->cancellable);
#line 62 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (tracker_store_query_task_parent_class)->finalize (obj);
#line 4281 "tracker-store.c"
}


static GType tracker_store_query_task_get_type (void) {
	static volatile gsize tracker_store_query_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_query_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreQueryTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_query_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreQueryTask), 0, (GInstanceInitFunc) tracker_store_query_task_instance_init, NULL };
		GType tracker_store_query_task_type_id;
		tracker_store_query_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreQueryTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_query_task_type_id__volatile, tracker_store_query_task_type_id);
	}
	return tracker_store_query_task_type_id__volatile;
}


static TrackerStoreUpdateTask* tracker_store_update_task_construct (GType object_type) {
	TrackerStoreUpdateTask* self = NULL;
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreUpdateTask*) tracker_store_task_construct (object_type);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 4303 "tracker-store.c"
}


static TrackerStoreUpdateTask* tracker_store_update_task_new (void) {
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_update_task_construct (TRACKER_STORE_TYPE_UPDATE_TASK);
#line 4310 "tracker-store.c"
}


static void tracker_store_update_task_class_init (TrackerStoreUpdateTaskClass * klass) {
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_update_task_parent_class = g_type_class_peek_parent (klass);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (klass)->finalize = tracker_store_update_task_finalize;
#line 4319 "tracker-store.c"
}


static void tracker_store_update_task_instance_init (TrackerStoreUpdateTask * self) {
}


static void tracker_store_update_task_finalize (TrackerStoreTask* obj) {
	TrackerStoreUpdateTask * self;
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_UPDATE_TASK, TrackerStoreUpdateTask);
#line 76 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (self->query);
#line 77 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_variant_unref0 (self->blank_nodes);
#line 75 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (tracker_store_update_task_parent_class)->finalize (obj);
#line 4337 "tracker-store.c"
}


static GType tracker_store_update_task_get_type (void) {
	static volatile gsize tracker_store_update_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_update_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreUpdateTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_update_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreUpdateTask), 0, (GInstanceInitFunc) tracker_store_update_task_instance_init, NULL };
		GType tracker_store_update_task_type_id;
		tracker_store_update_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreUpdateTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_update_task_type_id__volatile, tracker_store_update_task_type_id);
	}
	return tracker_store_update_task_type_id__volatile;
}


static TrackerStoreTurtleTask* tracker_store_turtle_task_construct (GType object_type) {
	TrackerStoreTurtleTask* self = NULL;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = (TrackerStoreTurtleTask*) tracker_store_task_construct (object_type);
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return self;
#line 4359 "tracker-store.c"
}


static TrackerStoreTurtleTask* tracker_store_turtle_task_new (void) {
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return tracker_store_turtle_task_construct (TRACKER_STORE_TYPE_TURTLE_TASK);
#line 4366 "tracker-store.c"
}


static void tracker_store_turtle_task_class_init (TrackerStoreTurtleTaskClass * klass) {
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_turtle_task_parent_class = g_type_class_peek_parent (klass);
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (klass)->finalize = tracker_store_turtle_task_finalize;
#line 4375 "tracker-store.c"
}


static void tracker_store_turtle_task_instance_init (TrackerStoreTurtleTask * self) {
}


static void tracker_store_turtle_task_finalize (TrackerStoreTask* obj) {
	TrackerStoreTurtleTask * self;
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_TURTLE_TASK, TrackerStoreTurtleTask);
#line 82 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	_g_free0 (self->path);
#line 81 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_TASK_CLASS (tracker_store_turtle_task_parent_class)->finalize (obj);
#line 4391 "tracker-store.c"
}


static GType tracker_store_turtle_task_get_type (void) {
	static volatile gsize tracker_store_turtle_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_turtle_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreTurtleTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_turtle_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreTurtleTask), 0, (GInstanceInitFunc) tracker_store_turtle_task_instance_init, NULL };
		GType tracker_store_turtle_task_type_id;
		tracker_store_turtle_task_type_id = g_type_register_static (TRACKER_STORE_TYPE_TASK, "TrackerStoreTurtleTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_store_turtle_task_type_id__volatile, tracker_store_turtle_task_type_id);
	}
	return tracker_store_turtle_task_type_id__volatile;
}


static void tracker_value_store_init (GValue* value) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	value->data[0].v_pointer = NULL;
#line 4410 "tracker-store.c"
}


static void tracker_value_store_free_value (GValue* value) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (value->data[0].v_pointer) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_unref (value->data[0].v_pointer);
#line 4419 "tracker-store.c"
	}
}


static void tracker_value_store_copy_value (const GValue* src_value, GValue* dest_value) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = tracker_store_ref (src_value->data[0].v_pointer);
#line 4429 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4433 "tracker-store.c"
	}
}


static gpointer tracker_value_store_peek_pointer (const GValue* value) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 4441 "tracker-store.c"
}


static gchar* tracker_value_store_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (collect_values[0].v_pointer) {
#line 4448 "tracker-store.c"
		TrackerStore* object;
		object = collect_values[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4455 "tracker-store.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4459 "tracker-store.c"
		}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = tracker_store_ref (object);
#line 4463 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4467 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 4471 "tracker-store.c"
}


static gchar* tracker_value_store_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerStore** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!object_p) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4482 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (!value->data[0].v_pointer) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = NULL;
#line 4488 "tracker-store.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = value->data[0].v_pointer;
#line 4492 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		*object_p = tracker_store_ref (value->data[0].v_pointer);
#line 4496 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return NULL;
#line 4500 "tracker-store.c"
}


GParamSpec* tracker_param_spec_store (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerParamSpecStore* spec;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_STORE), NULL);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return G_PARAM_SPEC (spec);
#line 4514 "tracker-store.c"
}


gpointer tracker_value_get_store (const GValue* value) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE), NULL);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return value->data[0].v_pointer;
#line 4523 "tracker-store.c"
}


void tracker_value_set_store (GValue* value, gpointer v_object) {
	TrackerStore* old;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_STORE));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_ref (value->data[0].v_pointer);
#line 4543 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4547 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_unref (old);
#line 4553 "tracker-store.c"
	}
}


void tracker_value_take_store (GValue* value, gpointer v_object) {
	TrackerStore* old;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	old = value->data[0].v_pointer;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (v_object) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_STORE));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 4572 "tracker-store.c"
	} else {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 4576 "tracker-store.c"
	}
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (old) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		tracker_store_unref (old);
#line 4582 "tracker-store.c"
	}
}


static void tracker_store_class_init (TrackerStoreClass * klass) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	tracker_store_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	TRACKER_STORE_CLASS (klass)->finalize = tracker_store_finalize;
#line 4592 "tracker-store.c"
}


static void tracker_store_instance_init (TrackerStore * self) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self->ref_count = 1;
#line 4599 "tracker-store.c"
}


static void tracker_store_finalize (TrackerStore* obj) {
	TrackerStore * self;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_STORE, TrackerStore);
#line 4607 "tracker-store.c"
}


GType tracker_store_get_type (void) {
	static volatile gsize tracker_store_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_store_init, tracker_value_store_free_value, tracker_value_store_copy_value, tracker_value_store_peek_pointer, "p", tracker_value_store_collect_value, "p", tracker_value_store_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStore), 0, (GInstanceInitFunc) tracker_store_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_store_type_id;
		tracker_store_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerStore", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_store_type_id__volatile, tracker_store_type_id);
	}
	return tracker_store_type_id__volatile;
}


gpointer tracker_store_ref (gpointer instance) {
	TrackerStore* self;
	self = instance;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	return instance;
#line 4632 "tracker-store.c"
}


void tracker_store_unref (gpointer instance) {
	TrackerStore* self;
	self = instance;
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		TRACKER_STORE_GET_CLASS (self)->finalize (self);
#line 22 "/home/carlos/Source/gnome/tracker/src/tracker-store/tracker-store.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4645 "tracker-store.c"
	}
}



