/* baobab-location-list.c generated by valac 0.23.3, the Vala compiler
 * generated from baobab-location-list.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define BAOBAB_TYPE_LOCATION_ROW (baobab_location_row_get_type ())
#define BAOBAB_LOCATION_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRow))
#define BAOBAB_LOCATION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRowClass))
#define BAOBAB_IS_LOCATION_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_LOCATION_ROW))
#define BAOBAB_IS_LOCATION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_LOCATION_ROW))
#define BAOBAB_LOCATION_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRowClass))

typedef struct _BaobabLocationRow BaobabLocationRow;
typedef struct _BaobabLocationRowClass BaobabLocationRowClass;
typedef struct _BaobabLocationRowPrivate BaobabLocationRowPrivate;

#define BAOBAB_TYPE_LOCATION (baobab_location_get_type ())
#define BAOBAB_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_LOCATION, BaobabLocation))
#define BAOBAB_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_LOCATION, BaobabLocationClass))
#define BAOBAB_IS_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_LOCATION))
#define BAOBAB_IS_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_LOCATION))
#define BAOBAB_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_LOCATION, BaobabLocationClass))

typedef struct _BaobabLocation BaobabLocation;
typedef struct _BaobabLocationClass BaobabLocationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _baobab_location_unref0(var) ((var == NULL) ? NULL : (var = (baobab_location_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BAOBAB_TYPE_LOCATION_LIST (baobab_location_list_get_type ())
#define BAOBAB_LOCATION_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_LOCATION_LIST, BaobabLocationList))
#define BAOBAB_LOCATION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_LOCATION_LIST, BaobabLocationListClass))
#define BAOBAB_IS_LOCATION_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_LOCATION_LIST))
#define BAOBAB_IS_LOCATION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_LOCATION_LIST))
#define BAOBAB_LOCATION_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_LOCATION_LIST, BaobabLocationListClass))

typedef struct _BaobabLocationList BaobabLocationList;
typedef struct _BaobabLocationListClass BaobabLocationListClass;
typedef struct _BaobabLocationListPrivate BaobabLocationListPrivate;
#define __g_list_free__baobab_location_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__baobab_location_unref0_ (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define __g_list_free__gtk_recent_info_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_recent_info_unref0_ (var), NULL)))
#define _gtk_recent_info_unref0(var) ((var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL)))

struct _BaobabLocationRow {
	GtkListBoxRow parent_instance;
	BaobabLocationRowPrivate * priv;
};

struct _BaobabLocationRowClass {
	GtkListBoxRowClass parent_class;
};

struct _BaobabLocationRowPrivate {
	GtkImage* image;
	GtkLabel* name_label;
	GtkLabel* path_label;
	GtkLabel* usage_label;
	GtkLevelBar* usage_bar;
	BaobabLocation* _location;
};

struct _BaobabLocationList {
	GtkListBox parent_instance;
	BaobabLocationListPrivate * priv;
};

struct _BaobabLocationListClass {
	GtkListBoxClass parent_class;
};

typedef void (*BaobabLocationListLocationAction) (BaobabLocation* l, void* user_data);
struct _BaobabLocationListPrivate {
	GVolumeMonitor* monitor;
	GList* locations;
	BaobabLocationListLocationAction location_action;
	gpointer location_action_target;
	GDestroyNotify location_action_target_destroy_notify;
};


static gpointer baobab_location_row_parent_class = NULL;
static GtkSizeGroup* baobab_location_row_name_size_group;
static GtkSizeGroup* baobab_location_row_name_size_group = NULL;
static GtkSizeGroup* baobab_location_row_usage_size_group;
static GtkSizeGroup* baobab_location_row_usage_size_group = NULL;
static gpointer baobab_location_list_parent_class = NULL;

GType baobab_location_row_get_type (void) G_GNUC_CONST;
gpointer baobab_location_ref (gpointer instance);
void baobab_location_unref (gpointer instance);
GParamSpec* baobab_param_spec_location (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void baobab_value_set_location (GValue* value, gpointer v_object);
void baobab_value_take_location (GValue* value, gpointer v_object);
gpointer baobab_value_get_location (const GValue* value);
GType baobab_location_get_type (void) G_GNUC_CONST;
#define BAOBAB_LOCATION_ROW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRowPrivate))
enum  {
	BAOBAB_LOCATION_ROW_DUMMY_PROPERTY,
	BAOBAB_LOCATION_ROW_LOCATION
};
static void baobab_location_row_ensure_size_groups (BaobabLocationRow* self);
BaobabLocationRow* baobab_location_row_new (BaobabLocation* l);
BaobabLocationRow* baobab_location_row_construct (GType object_type, BaobabLocation* l);
static void baobab_location_row_set_location (BaobabLocationRow* self, BaobabLocation* value);
BaobabLocation* baobab_location_row_get_location (BaobabLocationRow* self);
GIcon* baobab_location_get_icon (BaobabLocation* self);
const gchar* baobab_location_get_name (BaobabLocation* self);
GFile* baobab_location_get_file (BaobabLocation* self);
gboolean baobab_location_get_is_volume (BaobabLocation* self);
guint64* baobab_location_get_used (BaobabLocation* self);
guint64* baobab_location_get_size (BaobabLocation* self);
static void baobab_location_row_finalize (GObject* obj);
static void _vala_baobab_location_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_baobab_location_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType baobab_location_list_get_type (void) G_GNUC_CONST;
#define BAOBAB_LOCATION_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_LOCATION_LIST, BaobabLocationListPrivate))
enum  {
	BAOBAB_LOCATION_LIST_DUMMY_PROPERTY
};
static void _baobab_location_unref0_ (gpointer var);
static void _g_list_free__baobab_location_unref0_ (GList* self);
#define BAOBAB_LOCATION_LIST_MAX_RECENT_LOCATIONS 5
static void baobab_location_list_update_header (BaobabLocationList* self, GtkListBoxRow* row, GtkListBoxRow* before_row);
static void baobab_location_list_real_row_activated (GtkListBox* base, GtkListBoxRow* row);
static gboolean baobab_location_list_already_present (BaobabLocationList* self, GFile* file);
static void baobab_location_list_append_to_volumes (BaobabLocationList* self, BaobabLocation* location);
BaobabLocation* baobab_location_get_home_location (void);
static void baobab_location_list_volume_changed (BaobabLocationList* self, GVolume* volume);
void baobab_location_list_update (BaobabLocationList* self);
static void baobab_location_list_volume_removed (BaobabLocationList* self, GVolume* volume);
GVolume* baobab_location_get_volume (BaobabLocation* self);
static void baobab_location_list_volume_added (BaobabLocationList* self, GVolume* volume);
BaobabLocation* baobab_location_new_from_volume (GVolume* volume_);
BaobabLocation* baobab_location_construct_from_volume (GType object_type, GVolume* volume_);
static void baobab_location_list_mount_changed (BaobabLocationList* self, GMount* mount);
static void baobab_location_list_mount_removed (BaobabLocationList* self, GMount* mount);
GMount* baobab_location_get_mount (BaobabLocation* self);
static void baobab_location_list_mount_added (BaobabLocationList* self, GMount* mount);
BaobabLocation* baobab_location_new_from_mount (GMount* mount_);
BaobabLocation* baobab_location_construct_from_mount (GType object_type, GMount* mount_);
void baobab_location_update (BaobabLocation* self);
static void baobab_location_list_populate (BaobabLocationList* self);
BaobabLocation* baobab_location_new_for_main_volume (void);
BaobabLocation* baobab_location_construct_for_main_volume (GType object_type);
gboolean baobab_location_get_is_home (BaobabLocation* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gint __lambda5_ (GtkRecentInfo* a, GtkRecentInfo* b);
static gint ___lambda5__gcompare_func (gconstpointer a, gconstpointer b);
static void _gtk_recent_info_unref0_ (gpointer var);
static void _g_list_free__gtk_recent_info_unref0_ (GList* self);
BaobabLocation* baobab_location_new_for_recent_info (GtkRecentInfo* recent_info);
BaobabLocation* baobab_location_construct_for_recent_info (GType object_type, GtkRecentInfo* recent_info);
void baobab_location_list_set_action (BaobabLocationList* self, BaobabLocationListLocationAction action, void* action_target, GDestroyNotify action_target_destroy_notify);
static void __lambda4_ (BaobabLocationList* self, GtkWidget* widget);
static void ___lambda4__gtk_callback (GtkWidget* widget, gpointer self);
void baobab_location_list_add_location (BaobabLocationList* self, BaobabLocation* location);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void gtk_recent_data_destroy (GtkRecentData* self);
BaobabLocationList* baobab_location_list_new (void);
BaobabLocationList* baobab_location_list_construct (GType object_type);
static GObject * baobab_location_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _baobab_location_list_mount_changed_g_volume_monitor_mount_changed (GVolumeMonitor* _sender, GMount* mount, gpointer self);
static void _baobab_location_list_mount_removed_g_volume_monitor_mount_removed (GVolumeMonitor* _sender, GMount* mount, gpointer self);
static void _baobab_location_list_mount_added_g_volume_monitor_mount_added (GVolumeMonitor* _sender, GMount* mount, gpointer self);
static void _baobab_location_list_volume_changed_g_volume_monitor_volume_changed (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void _baobab_location_list_volume_removed_g_volume_monitor_volume_removed (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void _baobab_location_list_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void _baobab_location_list_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
static void baobab_location_list_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void baobab_location_row_ensure_size_groups (BaobabLocationRow* self) {
	GtkSizeGroup* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_location_row_name_size_group;
	if (_tmp0_ == NULL) {
		GtkSizeGroup* _tmp1_ = NULL;
		GtkSizeGroup* _tmp2_ = NULL;
		_tmp1_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
		_g_object_unref0 (baobab_location_row_name_size_group);
		baobab_location_row_name_size_group = _tmp1_;
		_tmp2_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
		_g_object_unref0 (baobab_location_row_usage_size_group);
		baobab_location_row_usage_size_group = _tmp2_;
	}
}


BaobabLocationRow* baobab_location_row_construct (GType object_type, BaobabLocation* l) {
	BaobabLocationRow * self = NULL;
	BaobabLocation* _tmp0_ = NULL;
	GtkImage* _tmp1_ = NULL;
	BaobabLocation* _tmp2_ = NULL;
	GIcon* _tmp3_ = NULL;
	GIcon* _tmp4_ = NULL;
	gchar* escaped = NULL;
	BaobabLocation* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GtkSizeGroup* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	BaobabLocation* _tmp16_ = NULL;
	GFile* _tmp17_ = NULL;
	GFile* _tmp18_ = NULL;
	gchar* _tmp26_ = NULL;
	GtkLabel* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	GtkSizeGroup* _tmp31_ = NULL;
	GtkLabel* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	BaobabLocation* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	g_return_val_if_fail (l != NULL, NULL);
	self = (BaobabLocationRow*) g_object_new (object_type, NULL);
	_tmp0_ = l;
	baobab_location_row_set_location (self, _tmp0_);
	baobab_location_row_ensure_size_groups (self);
	_tmp1_ = self->priv->image;
	_tmp2_ = self->priv->_location;
	_tmp3_ = baobab_location_get_icon (_tmp2_);
	_tmp4_ = _tmp3_;
	g_object_set (_tmp1_, "gicon", _tmp4_, NULL);
	_tmp5_ = self->priv->_location;
	_tmp6_ = baobab_location_get_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_markup_escape_text (_tmp7_, (gssize) (-1));
	escaped = _tmp8_;
	_tmp9_ = self->priv->name_label;
	_tmp10_ = escaped;
	_tmp11_ = g_strdup_printf ("<b>%s</b>", _tmp10_);
	_tmp12_ = _tmp11_;
	gtk_label_set_label (_tmp9_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = baobab_location_row_name_size_group;
	_tmp14_ = self->priv->name_label;
	gtk_size_group_add_widget (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp16_ = self->priv->_location;
	_tmp17_ = baobab_location_get_file (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != NULL) {
		BaobabLocation* _tmp19_ = NULL;
		GFile* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		_tmp19_ = self->priv->_location;
		_tmp20_ = baobab_location_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_file_get_parse_name (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_markup_escape_text (_tmp23_, (gssize) (-1));
		_g_free0 (_tmp15_);
		_tmp15_ = _tmp24_;
		_g_free0 (_tmp23_);
	} else {
		gchar* _tmp25_ = NULL;
		_tmp25_ = g_strdup ("");
		_g_free0 (_tmp15_);
		_tmp15_ = _tmp25_;
	}
	_tmp26_ = g_strdup (_tmp15_);
	_g_free0 (escaped);
	escaped = _tmp26_;
	_tmp27_ = self->priv->path_label;
	_tmp28_ = escaped;
	_tmp29_ = g_strdup_printf ("<small>%s</small>", _tmp28_);
	_tmp30_ = _tmp29_;
	gtk_label_set_label (_tmp27_, _tmp30_);
	_g_free0 (_tmp30_);
	_tmp31_ = baobab_location_row_name_size_group;
	_tmp32_ = self->priv->path_label;
	gtk_size_group_add_widget (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp35_ = self->priv->_location;
	_tmp36_ = baobab_location_get_is_volume (_tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_) {
		BaobabLocation* _tmp38_ = NULL;
		guint64* _tmp39_ = NULL;
		guint64* _tmp40_ = NULL;
		_tmp38_ = self->priv->_location;
		_tmp39_ = baobab_location_get_used (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp34_ = _tmp40_ != NULL;
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		BaobabLocation* _tmp41_ = NULL;
		guint64* _tmp42_ = NULL;
		guint64* _tmp43_ = NULL;
		_tmp41_ = self->priv->_location;
		_tmp42_ = baobab_location_get_size (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp33_ = _tmp43_ != NULL;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		GtkLabel* _tmp44_ = NULL;
		BaobabLocation* _tmp45_ = NULL;
		guint64* _tmp46_ = NULL;
		guint64* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		BaobabLocation* _tmp50_ = NULL;
		guint64* _tmp51_ = NULL;
		guint64* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		gchar* _tmp56_ = NULL;
		GtkSizeGroup* _tmp57_ = NULL;
		GtkLabel* _tmp58_ = NULL;
		GtkLabel* _tmp59_ = NULL;
		GtkSizeGroup* _tmp60_ = NULL;
		GtkLevelBar* _tmp61_ = NULL;
		GtkLevelBar* _tmp62_ = NULL;
		BaobabLocation* _tmp63_ = NULL;
		guint64* _tmp64_ = NULL;
		guint64* _tmp65_ = NULL;
		GtkLevelBar* _tmp66_ = NULL;
		BaobabLocation* _tmp67_ = NULL;
		guint64* _tmp68_ = NULL;
		guint64* _tmp69_ = NULL;
		GtkLevelBar* _tmp70_ = NULL;
		BaobabLocation* _tmp71_ = NULL;
		guint64* _tmp72_ = NULL;
		guint64* _tmp73_ = NULL;
		GtkLevelBar* _tmp74_ = NULL;
		_tmp44_ = self->priv->usage_label;
		_tmp45_ = self->priv->_location;
		_tmp46_ = baobab_location_get_used (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_format_size_full (*_tmp47_, G_FORMAT_SIZE_DEFAULT);
		_tmp49_ = _tmp48_;
		_tmp50_ = self->priv->_location;
		_tmp51_ = baobab_location_get_size (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_format_size_full (*_tmp52_, G_FORMAT_SIZE_DEFAULT);
		_tmp54_ = _tmp53_;
		_tmp55_ = g_strdup_printf ("<small>%s / %s</small>", _tmp49_, _tmp54_);
		_tmp56_ = _tmp55_;
		gtk_label_set_label (_tmp44_, _tmp56_);
		_g_free0 (_tmp56_);
		_g_free0 (_tmp54_);
		_g_free0 (_tmp49_);
		_tmp57_ = baobab_location_row_usage_size_group;
		_tmp58_ = self->priv->usage_label;
		gtk_size_group_add_widget (_tmp57_, (GtkWidget*) _tmp58_);
		_tmp59_ = self->priv->usage_label;
		gtk_widget_show ((GtkWidget*) _tmp59_);
		_tmp60_ = baobab_location_row_usage_size_group;
		_tmp61_ = self->priv->usage_bar;
		gtk_size_group_add_widget (_tmp60_, (GtkWidget*) _tmp61_);
		_tmp62_ = self->priv->usage_bar;
		_tmp63_ = self->priv->_location;
		_tmp64_ = baobab_location_get_size (_tmp63_);
		_tmp65_ = _tmp64_;
		gtk_level_bar_set_max_value (_tmp62_, *_tmp65_);
		_tmp66_ = self->priv->usage_bar;
		_tmp67_ = self->priv->_location;
		_tmp68_ = baobab_location_get_size (_tmp67_);
		_tmp69_ = _tmp68_;
		gtk_level_bar_add_offset_value (_tmp66_, GTK_LEVEL_BAR_OFFSET_LOW, 0.9 * (*_tmp69_));
		_tmp70_ = self->priv->usage_bar;
		_tmp71_ = self->priv->_location;
		_tmp72_ = baobab_location_get_used (_tmp71_);
		_tmp73_ = _tmp72_;
		gtk_level_bar_set_value (_tmp70_, *_tmp73_);
		_tmp74_ = self->priv->usage_bar;
		gtk_widget_show ((GtkWidget*) _tmp74_);
	}
	_g_free0 (_tmp15_);
	_g_free0 (escaped);
	return self;
}


BaobabLocationRow* baobab_location_row_new (BaobabLocation* l) {
	return baobab_location_row_construct (BAOBAB_TYPE_LOCATION_ROW, l);
}


BaobabLocation* baobab_location_row_get_location (BaobabLocationRow* self) {
	BaobabLocation* result;
	BaobabLocation* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}


static gpointer _baobab_location_ref0 (gpointer self) {
	return self ? baobab_location_ref (self) : NULL;
}


static void baobab_location_row_set_location (BaobabLocationRow* self, BaobabLocation* value) {
	BaobabLocation* _tmp0_ = NULL;
	BaobabLocation* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _baobab_location_ref0 (_tmp0_);
	_baobab_location_unref0 (self->priv->_location);
	self->priv->_location = _tmp1_;
	g_object_notify ((GObject *) self, "location");
}


static void baobab_location_row_class_init (BaobabLocationRowClass * klass) {
	gint BaobabLocationRow_private_offset;
	baobab_location_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabLocationRowPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_location_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_location_row_set_property;
	G_OBJECT_CLASS (klass)->finalize = baobab_location_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_LOCATION_ROW_LOCATION, baobab_param_spec_location ("location", "location", "location", BAOBAB_TYPE_LOCATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	BaobabLocationRow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/baobab/ui/baobab-location-row.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image", FALSE, BaobabLocationRow_private_offset + G_STRUCT_OFFSET (BaobabLocationRowPrivate, image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, BaobabLocationRow_private_offset + G_STRUCT_OFFSET (BaobabLocationRowPrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "path_label", FALSE, BaobabLocationRow_private_offset + G_STRUCT_OFFSET (BaobabLocationRowPrivate, path_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "usage_label", FALSE, BaobabLocationRow_private_offset + G_STRUCT_OFFSET (BaobabLocationRowPrivate, usage_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "usage_bar", FALSE, BaobabLocationRow_private_offset + G_STRUCT_OFFSET (BaobabLocationRowPrivate, usage_bar));
}


static void baobab_location_row_instance_init (BaobabLocationRow * self) {
	self->priv = BAOBAB_LOCATION_ROW_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void baobab_location_row_finalize (GObject* obj) {
	BaobabLocationRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRow);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->path_label);
	_g_object_unref0 (self->priv->usage_label);
	_g_object_unref0 (self->priv->usage_bar);
	_baobab_location_unref0 (self->priv->_location);
	G_OBJECT_CLASS (baobab_location_row_parent_class)->finalize (obj);
}


GType baobab_location_row_get_type (void) {
	static volatile gsize baobab_location_row_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_location_row_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabLocationRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_location_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabLocationRow), 0, (GInstanceInitFunc) baobab_location_row_instance_init, NULL };
		GType baobab_location_row_type_id;
		baobab_location_row_type_id = g_type_register_static (GTK_TYPE_LIST_BOX_ROW, "BaobabLocationRow", &g_define_type_info, 0);
		g_once_init_leave (&baobab_location_row_type_id__volatile, baobab_location_row_type_id);
	}
	return baobab_location_row_type_id__volatile;
}


static void _vala_baobab_location_row_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BaobabLocationRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRow);
	switch (property_id) {
		case BAOBAB_LOCATION_ROW_LOCATION:
		baobab_value_set_location (value, baobab_location_row_get_location (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_baobab_location_row_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BaobabLocationRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRow);
	switch (property_id) {
		case BAOBAB_LOCATION_ROW_LOCATION:
		baobab_location_row_set_location (self, baobab_value_get_location (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _baobab_location_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (baobab_location_unref (var), NULL));
}


static void _g_list_free__baobab_location_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _baobab_location_unref0_, NULL);
	g_list_free (self);
}


static void baobab_location_list_update_header (BaobabLocationList* self, GtkListBoxRow* row, GtkListBoxRow* before_row) {
	gboolean _tmp0_ = FALSE;
	GtkListBoxRow* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp1_ = before_row;
	if (_tmp1_ != NULL) {
		GtkListBoxRow* _tmp2_ = NULL;
		GtkWidget* _tmp3_ = NULL;
		_tmp2_ = row;
		_tmp3_ = gtk_list_box_row_get_header (_tmp2_);
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkListBoxRow* _tmp4_ = NULL;
		GtkSeparator* _tmp5_ = NULL;
		GtkSeparator* _tmp6_ = NULL;
		_tmp4_ = row;
		_tmp5_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		g_object_ref_sink (_tmp5_);
		_tmp6_ = _tmp5_;
		gtk_list_box_row_set_header (_tmp4_, (GtkWidget*) _tmp6_);
		_g_object_unref0 (_tmp6_);
	} else {
		GtkListBoxRow* _tmp7_ = NULL;
		_tmp7_ = row;
		gtk_list_box_row_set_header (_tmp7_, NULL);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void baobab_location_list_real_row_activated (GtkListBox* base, GtkListBoxRow* row) {
	BaobabLocationList * self;
	BaobabLocationListLocationAction _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	self = (BaobabLocationList*) base;
	g_return_if_fail (row != NULL);
	_tmp0_ = self->priv->location_action;
	_tmp0__target = self->priv->location_action_target;
	if (_tmp0_ != NULL) {
		BaobabLocationRow* location_widget = NULL;
		GtkListBoxRow* _tmp1_ = NULL;
		BaobabLocationRow* _tmp2_ = NULL;
		BaobabLocationListLocationAction _tmp3_ = NULL;
		void* _tmp3__target = NULL;
		BaobabLocationRow* _tmp4_ = NULL;
		BaobabLocation* _tmp5_ = NULL;
		BaobabLocation* _tmp6_ = NULL;
		_tmp1_ = row;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, BAOBAB_TYPE_LOCATION_ROW) ? ((BaobabLocationRow*) _tmp1_) : NULL);
		location_widget = _tmp2_;
		_tmp3_ = self->priv->location_action;
		_tmp3__target = self->priv->location_action_target;
		_tmp4_ = location_widget;
		_tmp5_ = baobab_location_row_get_location (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp3_ (_tmp6_, _tmp3__target);
		_g_object_unref0 (location_widget);
	}
}


static gboolean baobab_location_list_already_present (BaobabLocationList* self, GFile* file) {
	gboolean result = FALSE;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = self->priv->locations;
	{
		GList* l_collection = NULL;
		GList* l_it = NULL;
		l_collection = _tmp0_;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			BaobabLocation* _tmp1_ = NULL;
			BaobabLocation* l = NULL;
			_tmp1_ = _baobab_location_ref0 ((BaobabLocation*) l_it->data);
			l = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				BaobabLocation* _tmp3_ = NULL;
				GFile* _tmp4_ = NULL;
				GFile* _tmp5_ = NULL;
				_tmp3_ = l;
				_tmp4_ = baobab_location_get_file (_tmp3_);
				_tmp5_ = _tmp4_;
				if (_tmp5_ != NULL) {
					BaobabLocation* _tmp6_ = NULL;
					GFile* _tmp7_ = NULL;
					GFile* _tmp8_ = NULL;
					GFile* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					_tmp6_ = l;
					_tmp7_ = baobab_location_get_file (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = file;
					_tmp10_ = g_file_equal (_tmp8_, _tmp9_);
					_tmp2_ = _tmp10_;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					result = TRUE;
					_baobab_location_unref0 (l);
					return result;
				}
				_baobab_location_unref0 (l);
			}
		}
	}
	result = FALSE;
	return result;
}


static void baobab_location_list_append_to_volumes (BaobabLocationList* self, BaobabLocation* location) {
	GList* _tmp0_ = NULL;
	BaobabLocation* _tmp1_ = NULL;
	BaobabLocation* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	BaobabLocation* _tmp4_ = NULL;
	BaobabLocation* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = self->priv->locations;
	_tmp1_ = baobab_location_get_home_location ();
	_tmp2_ = _tmp1_;
	_tmp3_ = g_list_find (_tmp0_, _tmp2_);
	_tmp4_ = location;
	_tmp5_ = _baobab_location_ref0 (_tmp4_);
	self->priv->locations = g_list_insert_before (self->priv->locations, _tmp3_, _tmp5_);
	_baobab_location_unref0 (_tmp2_);
}


static void baobab_location_list_volume_changed (BaobabLocationList* self, GVolume* volume) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (volume != NULL);
	baobab_location_list_update (self);
}


static void baobab_location_list_volume_removed (BaobabLocationList* self, GVolume* volume) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (volume != NULL);
	_tmp0_ = self->priv->locations;
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp0_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp1_ = NULL;
			BaobabLocation* location = NULL;
			_tmp1_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp1_;
			{
				BaobabLocation* _tmp2_ = NULL;
				GVolume* _tmp3_ = NULL;
				GVolume* _tmp4_ = NULL;
				GVolume* _tmp5_ = NULL;
				_tmp2_ = location;
				_tmp3_ = baobab_location_get_volume (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = volume;
				if (_tmp4_ == _tmp5_) {
					BaobabLocation* _tmp6_ = NULL;
					_tmp6_ = location;
					self->priv->locations = g_list_remove (self->priv->locations, _tmp6_);
					_baobab_location_unref0 (location);
					break;
				}
				_baobab_location_unref0 (location);
			}
		}
	}
	baobab_location_list_update (self);
}


static void baobab_location_list_volume_added (BaobabLocationList* self, GVolume* volume) {
	GList* _tmp0_ = NULL;
	GVolume* _tmp6_ = NULL;
	BaobabLocation* _tmp7_ = NULL;
	BaobabLocation* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (volume != NULL);
	_tmp0_ = self->priv->locations;
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp0_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp1_ = NULL;
			BaobabLocation* location = NULL;
			_tmp1_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp1_;
			{
				BaobabLocation* _tmp2_ = NULL;
				GVolume* _tmp3_ = NULL;
				GVolume* _tmp4_ = NULL;
				GVolume* _tmp5_ = NULL;
				_tmp2_ = location;
				_tmp3_ = baobab_location_get_volume (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = volume;
				if (_tmp4_ == _tmp5_) {
					_baobab_location_unref0 (location);
					return;
				}
				_baobab_location_unref0 (location);
			}
		}
	}
	_tmp6_ = volume;
	_tmp7_ = baobab_location_new_from_volume (_tmp6_);
	_tmp8_ = _tmp7_;
	baobab_location_list_append_to_volumes (self, _tmp8_);
	_baobab_location_unref0 (_tmp8_);
	baobab_location_list_update (self);
}


static void baobab_location_list_mount_changed (BaobabLocationList* self, GMount* mount) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
}


static void baobab_location_list_mount_removed (BaobabLocationList* self, GMount* mount) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
	_tmp0_ = self->priv->locations;
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp0_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp1_ = NULL;
			BaobabLocation* location = NULL;
			_tmp1_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp1_;
			{
				BaobabLocation* _tmp2_ = NULL;
				GMount* _tmp3_ = NULL;
				GMount* _tmp4_ = NULL;
				GMount* _tmp5_ = NULL;
				_tmp2_ = location;
				_tmp3_ = baobab_location_get_mount (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = mount;
				if (_tmp4_ == _tmp5_) {
					BaobabLocation* _tmp6_ = NULL;
					_tmp6_ = location;
					self->priv->locations = g_list_remove (self->priv->locations, _tmp6_);
					_baobab_location_unref0 (location);
					break;
				}
				_baobab_location_unref0 (location);
			}
		}
	}
	baobab_location_list_update (self);
}


static void baobab_location_list_mount_added (BaobabLocationList* self, GMount* mount) {
	GVolume* volume = NULL;
	GMount* _tmp0_ = NULL;
	GVolume* _tmp1_ = NULL;
	GVolume* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
	_tmp0_ = mount;
	_tmp1_ = g_mount_get_volume (_tmp0_);
	volume = _tmp1_;
	_tmp2_ = volume;
	if (_tmp2_ == NULL) {
		GMount* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp3_ = mount;
		_tmp4_ = g_mount_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = baobab_location_list_already_present (self, _tmp5_);
		_tmp7_ = !_tmp6_;
		_g_object_unref0 (_tmp5_);
		if (_tmp7_) {
			GMount* _tmp8_ = NULL;
			BaobabLocation* _tmp9_ = NULL;
			BaobabLocation* _tmp10_ = NULL;
			_tmp8_ = mount;
			_tmp9_ = baobab_location_new_from_mount (_tmp8_);
			_tmp10_ = _tmp9_;
			baobab_location_list_append_to_volumes (self, _tmp10_);
			_baobab_location_unref0 (_tmp10_);
		}
	} else {
		GList* _tmp11_ = NULL;
		_tmp11_ = self->priv->locations;
		{
			GList* location_collection = NULL;
			GList* location_it = NULL;
			location_collection = _tmp11_;
			for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
				BaobabLocation* _tmp12_ = NULL;
				BaobabLocation* location = NULL;
				_tmp12_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
				location = _tmp12_;
				{
					BaobabLocation* _tmp13_ = NULL;
					GVolume* _tmp14_ = NULL;
					GVolume* _tmp15_ = NULL;
					GVolume* _tmp16_ = NULL;
					_tmp13_ = location;
					_tmp14_ = baobab_location_get_volume (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = volume;
					if (_tmp15_ == _tmp16_) {
						BaobabLocation* _tmp17_ = NULL;
						_tmp17_ = location;
						baobab_location_update (_tmp17_);
						_baobab_location_unref0 (location);
						break;
					}
					_baobab_location_unref0 (location);
				}
			}
		}
	}
	baobab_location_list_update (self);
	_g_object_unref0 (volume);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gint __lambda5_ (GtkRecentInfo* a, GtkRecentInfo* b) {
	gint result = 0;
	GtkRecentInfo* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	GtkRecentInfo* _tmp2_ = NULL;
	gulong _tmp3_ = 0UL;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = b;
	_tmp1_ = gtk_recent_info_get_modified (_tmp0_);
	_tmp2_ = a;
	_tmp3_ = gtk_recent_info_get_modified (_tmp2_);
	result = (gint) (_tmp1_ - _tmp3_);
	return result;
}


static gint ___lambda5__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = __lambda5_ ((GtkRecentInfo*) a, (GtkRecentInfo*) b);
	return result;
}


static void _gtk_recent_info_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL));
}


static void _g_list_free__gtk_recent_info_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_recent_info_unref0_, NULL);
	g_list_free (self);
}


static gpointer _gtk_recent_info_ref0 (gpointer self) {
	return self ? gtk_recent_info_ref (self) : NULL;
}


static void baobab_location_list_populate (BaobabLocationList* self) {
	BaobabLocation* _tmp0_ = NULL;
	GVolumeMonitor* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GVolumeMonitor* _tmp11_ = NULL;
	GList* _tmp12_ = NULL;
	BaobabLocation* _tmp25_ = NULL;
	GtkRecentManager* recent_manager = NULL;
	GtkRecentManager* _tmp26_ = NULL;
	GtkRecentManager* _tmp27_ = NULL;
	GList* recent_items = NULL;
	GtkRecentManager* _tmp28_ = NULL;
	GList* _tmp29_ = NULL;
	GList* iter = NULL;
	GList* _tmp30_ = NULL;
	GList* last = NULL;
	GList* _tmp50_ = NULL;
	GList* _tmp51_ = NULL;
	GList* _tmp52_ = NULL;
	GList* _tmp54_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_location_new_for_main_volume ();
	self->priv->locations = g_list_append (self->priv->locations, _tmp0_);
	_tmp1_ = self->priv->monitor;
	_tmp2_ = g_volume_monitor_get_volumes (_tmp1_);
	{
		GList* volume_collection = NULL;
		GList* volume_it = NULL;
		volume_collection = _tmp2_;
		for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
			GVolume* _tmp3_ = NULL;
			GVolume* volume = NULL;
			_tmp3_ = _g_object_ref0 ((GVolume*) volume_it->data);
			volume = _tmp3_;
			{
				BaobabLocation* location = NULL;
				GVolume* _tmp4_ = NULL;
				BaobabLocation* _tmp5_ = NULL;
				BaobabLocation* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				_tmp4_ = volume;
				_tmp5_ = baobab_location_new_from_volume (_tmp4_);
				location = _tmp5_;
				_tmp6_ = location;
				_tmp7_ = baobab_location_get_is_home (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					BaobabLocation* _tmp9_ = NULL;
					BaobabLocation* _tmp10_ = NULL;
					_tmp9_ = location;
					_tmp10_ = _baobab_location_ref0 (_tmp9_);
					self->priv->locations = g_list_append (self->priv->locations, _tmp10_);
				}
				_baobab_location_unref0 (location);
				_g_object_unref0 (volume);
			}
		}
		__g_list_free__g_object_unref0_0 (volume_collection);
	}
	_tmp11_ = self->priv->monitor;
	_tmp12_ = g_volume_monitor_get_mounts (_tmp11_);
	{
		GList* mount_collection = NULL;
		GList* mount_it = NULL;
		mount_collection = _tmp12_;
		for (mount_it = mount_collection; mount_it != NULL; mount_it = mount_it->next) {
			GMount* _tmp13_ = NULL;
			GMount* mount = NULL;
			_tmp13_ = _g_object_ref0 ((GMount*) mount_it->data);
			mount = _tmp13_;
			{
				GMount* _tmp14_ = NULL;
				GVolume* _tmp15_ = NULL;
				GVolume* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
				_tmp14_ = mount;
				_tmp15_ = g_mount_get_volume (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = _tmp16_ == NULL;
				_g_object_unref0 (_tmp16_);
				if (_tmp17_) {
					BaobabLocation* location = NULL;
					GMount* _tmp18_ = NULL;
					BaobabLocation* _tmp19_ = NULL;
					BaobabLocation* _tmp20_ = NULL;
					gboolean _tmp21_ = FALSE;
					gboolean _tmp22_ = FALSE;
					_tmp18_ = mount;
					_tmp19_ = baobab_location_new_from_mount (_tmp18_);
					location = _tmp19_;
					_tmp20_ = location;
					_tmp21_ = baobab_location_get_is_home (_tmp20_);
					_tmp22_ = _tmp21_;
					if (!_tmp22_) {
						BaobabLocation* _tmp23_ = NULL;
						BaobabLocation* _tmp24_ = NULL;
						_tmp23_ = location;
						_tmp24_ = _baobab_location_ref0 (_tmp23_);
						self->priv->locations = g_list_append (self->priv->locations, _tmp24_);
					}
					_baobab_location_unref0 (location);
				} else {
				}
				_g_object_unref0 (mount);
			}
		}
		__g_list_free__g_object_unref0_0 (mount_collection);
	}
	_tmp25_ = baobab_location_get_home_location ();
	self->priv->locations = g_list_append (self->priv->locations, _tmp25_);
	_tmp26_ = gtk_recent_manager_get_default ();
	_tmp27_ = _g_object_ref0 (_tmp26_);
	recent_manager = _tmp27_;
	_tmp28_ = recent_manager;
	_tmp29_ = gtk_recent_manager_get_items (_tmp28_);
	recent_items = _tmp29_;
	_tmp30_ = recent_items;
	iter = _tmp30_;
	while (TRUE) {
		GList* _tmp31_ = NULL;
		GList* next = NULL;
		GList* _tmp32_ = NULL;
		GList* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		GList* _tmp36_ = NULL;
		gconstpointer _tmp37_ = NULL;
		gboolean _tmp38_ = FALSE;
		GList* _tmp49_ = NULL;
		_tmp31_ = iter;
		if (!(_tmp31_ != NULL)) {
			break;
		}
		_tmp32_ = iter;
		_tmp33_ = _tmp32_->next;
		next = _tmp33_;
		_tmp36_ = iter;
		_tmp37_ = _tmp36_->data;
		_tmp38_ = gtk_recent_info_has_group ((GtkRecentInfo*) _tmp37_, "baobab");
		if (!_tmp38_) {
			_tmp35_ = TRUE;
		} else {
			GList* _tmp39_ = NULL;
			gconstpointer _tmp40_ = NULL;
			gboolean _tmp41_ = FALSE;
			_tmp39_ = iter;
			_tmp40_ = _tmp39_->data;
			_tmp41_ = gtk_recent_info_exists ((GtkRecentInfo*) _tmp40_);
			_tmp35_ = !_tmp41_;
		}
		if (_tmp35_) {
			_tmp34_ = TRUE;
		} else {
			GList* _tmp42_ = NULL;
			gconstpointer _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			GFile* _tmp45_ = NULL;
			GFile* _tmp46_ = NULL;
			gboolean _tmp47_ = FALSE;
			_tmp42_ = iter;
			_tmp43_ = _tmp42_->data;
			_tmp44_ = gtk_recent_info_get_uri ((GtkRecentInfo*) _tmp43_);
			_tmp45_ = g_file_new_for_uri (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = baobab_location_list_already_present (self, _tmp46_);
			_tmp34_ = _tmp47_;
			_g_object_unref0 (_tmp46_);
		}
		if (_tmp34_) {
			GList* _tmp48_ = NULL;
			_tmp48_ = iter;
			recent_items = g_list_remove_link (recent_items, _tmp48_);
		}
		_tmp49_ = next;
		iter = _tmp49_;
	}
	recent_items = g_list_sort (recent_items, ___lambda5__gcompare_func);
	_tmp50_ = recent_items;
	_tmp51_ = g_list_nth (_tmp50_, (guint) (BAOBAB_LOCATION_LIST_MAX_RECENT_LOCATIONS - 1));
	last = _tmp51_;
	_tmp52_ = last;
	if (_tmp52_ != NULL) {
		GList* _tmp53_ = NULL;
		_tmp53_ = last;
		__g_list_free__gtk_recent_info_unref0_0 (_tmp53_->next);
		_tmp53_->next = NULL;
	}
	recent_items = g_list_reverse (recent_items);
	_tmp54_ = recent_items;
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp54_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			GtkRecentInfo* _tmp55_ = NULL;
			GtkRecentInfo* info = NULL;
			_tmp55_ = _gtk_recent_info_ref0 ((GtkRecentInfo*) info_it->data);
			info = _tmp55_;
			{
				GtkRecentInfo* _tmp56_ = NULL;
				BaobabLocation* _tmp57_ = NULL;
				_tmp56_ = info;
				_tmp57_ = baobab_location_new_for_recent_info (_tmp56_);
				self->priv->locations = g_list_append (self->priv->locations, _tmp57_);
				_gtk_recent_info_unref0 (info);
			}
		}
	}
	baobab_location_list_update (self);
	__g_list_free__gtk_recent_info_unref0_0 (recent_items);
	_g_object_unref0 (recent_manager);
}


void baobab_location_list_set_action (BaobabLocationList* self, BaobabLocationListLocationAction action, void* action_target, GDestroyNotify action_target_destroy_notify) {
	BaobabLocationListLocationAction _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GDestroyNotify _tmp0__target_destroy_notify = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = action;
	_tmp0__target = action_target;
	_tmp0__target_destroy_notify = action_target_destroy_notify;
	action_target_destroy_notify = NULL;
	(self->priv->location_action_target_destroy_notify == NULL) ? NULL : (self->priv->location_action_target_destroy_notify (self->priv->location_action_target), NULL);
	self->priv->location_action = NULL;
	self->priv->location_action_target = NULL;
	self->priv->location_action_target_destroy_notify = NULL;
	self->priv->location_action = _tmp0_;
	self->priv->location_action_target = _tmp0__target;
	self->priv->location_action_target_destroy_notify = _tmp0__target_destroy_notify;
	(action_target_destroy_notify == NULL) ? NULL : (action_target_destroy_notify (action_target), NULL);
	action = NULL;
	action_target = NULL;
	action_target_destroy_notify = NULL;
}


static void __lambda4_ (BaobabLocationList* self, GtkWidget* widget) {
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_widget_destroy (_tmp0_);
}


static void ___lambda4__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda4_ ((BaobabLocationList*) self, widget);
}


void baobab_location_list_update (BaobabLocationList* self) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_container_foreach ((GtkContainer*) self, ___lambda4__gtk_callback, self);
	_tmp0_ = self->priv->locations;
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp0_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp1_ = NULL;
			BaobabLocation* location = NULL;
			_tmp1_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp1_;
			{
				BaobabLocation* _tmp2_ = NULL;
				BaobabLocationRow* _tmp3_ = NULL;
				BaobabLocationRow* _tmp4_ = NULL;
				_tmp2_ = location;
				_tmp3_ = baobab_location_row_new (_tmp2_);
				g_object_ref_sink (_tmp3_);
				_tmp4_ = _tmp3_;
				gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
				_g_object_unref0 (_tmp4_);
				_baobab_location_unref0 (location);
			}
		}
	}
	gtk_widget_show_all ((GtkWidget*) self);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void gtk_recent_data_destroy (GtkRecentData* self) {
	_g_free0 ((*self).display_name);
	_g_free0 ((*self).description);
	_g_free0 ((*self).mime_type);
	_g_free0 ((*self).app_name);
	_g_free0 ((*self).app_exec);
	(*self).groups = (_vala_array_free ((*self).groups, _vala_array_length ((*self).groups), (GDestroyNotify) g_free), NULL);
}


void baobab_location_list_add_location (BaobabLocationList* self, BaobabLocation* location) {
	BaobabLocation* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	BaobabLocation* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GtkRecentData data = {0};
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar** groups = NULL;
	gchar** _tmp14_ = NULL;
	gint groups_length1 = 0;
	gint _groups_size_ = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gchar* _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	GtkRecentManager* _tmp22_ = NULL;
	BaobabLocation* _tmp23_ = NULL;
	GFile* _tmp24_ = NULL;
	GFile* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GtkRecentData _tmp28_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = location;
	_tmp1_ = baobab_location_get_file (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = location;
	_tmp4_ = baobab_location_get_file (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = baobab_location_list_already_present (self, _tmp5_);
	if (!_tmp6_) {
		BaobabLocation* _tmp7_ = NULL;
		BaobabLocation* _tmp8_ = NULL;
		_tmp7_ = location;
		_tmp8_ = _baobab_location_ref0 (_tmp7_);
		self->priv->locations = g_list_append (self->priv->locations, _tmp8_);
	}
	baobab_location_list_update (self);
	memset (&data, 0, sizeof (GtkRecentData));
	_g_free0 (data.display_name);
	data.display_name = NULL;
	_g_free0 (data.description);
	data.description = NULL;
	_tmp9_ = g_strdup ("inode/directory");
	_g_free0 (data.mime_type);
	data.mime_type = _tmp9_;
	_tmp10_ = g_get_application_name ();
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (data.app_name);
	data.app_name = _tmp11_;
	_tmp12_ = g_get_prgname ();
	_tmp13_ = g_strdup_printf ("%s %%u", _tmp12_);
	_g_free0 (data.app_exec);
	data.app_exec = _tmp13_;
	_tmp14_ = g_new0 (gchar*, 2 + 1);
	groups = _tmp14_;
	groups_length1 = 2;
	_groups_size_ = groups_length1;
	_tmp15_ = groups;
	_tmp15__length1 = groups_length1;
	_tmp16_ = g_strdup ("baobab");
	_g_free0 (_tmp15_[0]);
	_tmp15_[0] = _tmp16_;
	_tmp17_ = _tmp15_[0];
	_tmp18_ = groups;
	_tmp18__length1 = groups_length1;
	_g_free0 (_tmp18_[1]);
	_tmp18_[1] = NULL;
	_tmp19_ = _tmp18_[1];
	_tmp20_ = groups;
	_tmp20__length1 = groups_length1;
	_tmp21_ = (_tmp20_ != NULL) ? _vala_array_dup1 (_tmp20_, _tmp20__length1) : ((gpointer) _tmp20_);
	_tmp21__length1 = _tmp20__length1;
	data.groups = (_vala_array_free (data.groups, _vala_array_length (data.groups), (GDestroyNotify) g_free), NULL);
	data.groups = _tmp21_;
	_tmp22_ = gtk_recent_manager_get_default ();
	_tmp23_ = location;
	_tmp24_ = baobab_location_get_file (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_file_get_uri (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = data;
	gtk_recent_manager_add_full (_tmp22_, _tmp27_, &_tmp28_);
	_g_free0 (_tmp27_);
	groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
	gtk_recent_data_destroy (&data);
}


BaobabLocationList* baobab_location_list_construct (GType object_type) {
	BaobabLocationList * self = NULL;
	self = (BaobabLocationList*) g_object_new (object_type, NULL);
	return self;
}


BaobabLocationList* baobab_location_list_new (void) {
	return baobab_location_list_construct (BAOBAB_TYPE_LOCATION_LIST);
}


static void _baobab_location_list_mount_changed_g_volume_monitor_mount_changed (GVolumeMonitor* _sender, GMount* mount, gpointer self) {
	baobab_location_list_mount_changed ((BaobabLocationList*) self, mount);
}


static void _baobab_location_list_mount_removed_g_volume_monitor_mount_removed (GVolumeMonitor* _sender, GMount* mount, gpointer self) {
	baobab_location_list_mount_removed ((BaobabLocationList*) self, mount);
}


static void _baobab_location_list_mount_added_g_volume_monitor_mount_added (GVolumeMonitor* _sender, GMount* mount, gpointer self) {
	baobab_location_list_mount_added ((BaobabLocationList*) self, mount);
}


static void _baobab_location_list_volume_changed_g_volume_monitor_volume_changed (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	baobab_location_list_volume_changed ((BaobabLocationList*) self, volume);
}


static void _baobab_location_list_volume_removed_g_volume_monitor_volume_removed (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	baobab_location_list_volume_removed ((BaobabLocationList*) self, volume);
}


static void _baobab_location_list_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	baobab_location_list_volume_added ((BaobabLocationList*) self, volume);
}


static void _baobab_location_list_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	baobab_location_list_update_header ((BaobabLocationList*) self, row, before);
}


static GObject * baobab_location_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	BaobabLocationList * self;
	GVolumeMonitor* _tmp0_ = NULL;
	GVolumeMonitor* _tmp1_ = NULL;
	GVolumeMonitor* _tmp2_ = NULL;
	GVolumeMonitor* _tmp3_ = NULL;
	GVolumeMonitor* _tmp4_ = NULL;
	GVolumeMonitor* _tmp5_ = NULL;
	GVolumeMonitor* _tmp6_ = NULL;
	parent_class = G_OBJECT_CLASS (baobab_location_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_LOCATION_LIST, BaobabLocationList);
	_tmp0_ = g_volume_monitor_get ();
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp0_;
	_tmp1_ = self->priv->monitor;
	g_signal_connect_object (_tmp1_, "mount-changed", (GCallback) _baobab_location_list_mount_changed_g_volume_monitor_mount_changed, self, 0);
	_tmp2_ = self->priv->monitor;
	g_signal_connect_object (_tmp2_, "mount-removed", (GCallback) _baobab_location_list_mount_removed_g_volume_monitor_mount_removed, self, 0);
	_tmp3_ = self->priv->monitor;
	g_signal_connect_object (_tmp3_, "mount-added", (GCallback) _baobab_location_list_mount_added_g_volume_monitor_mount_added, self, 0);
	_tmp4_ = self->priv->monitor;
	g_signal_connect_object (_tmp4_, "volume-changed", (GCallback) _baobab_location_list_volume_changed_g_volume_monitor_volume_changed, self, 0);
	_tmp5_ = self->priv->monitor;
	g_signal_connect_object (_tmp5_, "volume-removed", (GCallback) _baobab_location_list_volume_removed_g_volume_monitor_volume_removed, self, 0);
	_tmp6_ = self->priv->monitor;
	g_signal_connect_object (_tmp6_, "volume-added", (GCallback) _baobab_location_list_volume_added_g_volume_monitor_volume_added, self, 0);
	gtk_list_box_set_selection_mode ((GtkListBox*) self, GTK_SELECTION_NONE);
	gtk_list_box_set_header_func ((GtkListBox*) self, _baobab_location_list_update_header_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	baobab_location_list_populate (self);
	return obj;
}


static void baobab_location_list_class_init (BaobabLocationListClass * klass) {
	baobab_location_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabLocationListPrivate));
	GTK_LIST_BOX_CLASS (klass)->row_activated = baobab_location_list_real_row_activated;
	G_OBJECT_CLASS (klass)->constructor = baobab_location_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = baobab_location_list_finalize;
}


static void baobab_location_list_instance_init (BaobabLocationList * self) {
	self->priv = BAOBAB_LOCATION_LIST_GET_PRIVATE (self);
	self->priv->locations = NULL;
}


static void baobab_location_list_finalize (GObject* obj) {
	BaobabLocationList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_LOCATION_LIST, BaobabLocationList);
	_g_object_unref0 (self->priv->monitor);
	__g_list_free__baobab_location_unref0_0 (self->priv->locations);
	(self->priv->location_action_target_destroy_notify == NULL) ? NULL : (self->priv->location_action_target_destroy_notify (self->priv->location_action_target), NULL);
	self->priv->location_action = NULL;
	self->priv->location_action_target = NULL;
	self->priv->location_action_target_destroy_notify = NULL;
	G_OBJECT_CLASS (baobab_location_list_parent_class)->finalize (obj);
}


GType baobab_location_list_get_type (void) {
	static volatile gsize baobab_location_list_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_location_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabLocationListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_location_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabLocationList), 0, (GInstanceInitFunc) baobab_location_list_instance_init, NULL };
		GType baobab_location_list_type_id;
		baobab_location_list_type_id = g_type_register_static (GTK_TYPE_LIST_BOX, "BaobabLocationList", &g_define_type_info, 0);
		g_once_init_leave (&baobab_location_list_type_id__volatile, baobab_location_list_type_id);
	}
	return baobab_location_list_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



