/* dconf-update.c generated by valac 0.22.1, the Vala compiler
 * generated from dconf-update.vala, do not modify */

/*
 * Copyright © 2010 Codethink Limited
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the licence, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Ryan Lortie <desrt@desrt.ca>
 */

#include <glib.h>
#include <glib-object.h>
#include "../gvdb/gvdb-builder.h"
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);



GvdbItem* get_parent (GHashTable* table, const gchar* name);
GSList* list_directory (const gchar* dirname, mode_t mode, GError** error);
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
GHashTable* read_locks_directory (const gchar* dirname, GError** error);
GHashTable* read_directory (const gchar* dirname, GError** error);
void maybe_update_from_directory (const gchar* dirname, GError** error);
void update_all (const gchar* dirname, GError** error);
void dconf_compile (gchar** args, int args_length1, GError** error);
void dconf_update (gchar** args, int args_length1, GError** error);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


GvdbItem* get_parent (GHashTable* table, const gchar* name) {
	GvdbItem* result = NULL;
	GvdbItem* parent = NULL;
	gint end = 0;
	gint _tmp10_ = 0;
	gchar* parent_name = NULL;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	GHashTable* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gconstpointer _tmp16_ = NULL;
	GvdbItem* _tmp17_ = NULL;
	GvdbItem* _tmp25_ = NULL;
	g_return_val_if_fail (table != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	end = 0;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				const gchar* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gchar _tmp5_ = '\0';
				const gchar* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gchar _tmp8_ = '\0';
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = name;
				_tmp4_ = i;
				_tmp5_ = string_get (_tmp3_, (glong) _tmp4_);
				if (!(_tmp5_ != '\0')) {
					break;
				}
				_tmp6_ = name;
				_tmp7_ = i;
				_tmp8_ = string_get (_tmp6_, (glong) (_tmp7_ - 1));
				if (_tmp8_ == '/') {
					gint _tmp9_ = 0;
					_tmp9_ = i;
					end = _tmp9_;
				}
			}
		}
	}
	_tmp10_ = end;
	_vala_assert (_tmp10_ != 0, "end != 0");
	_tmp11_ = name;
	_tmp12_ = end;
	_tmp13_ = string_substring (_tmp11_, (glong) 0, (glong) _tmp12_);
	parent_name = _tmp13_;
	_tmp14_ = table;
	_tmp15_ = parent_name;
	_tmp16_ = g_hash_table_lookup (_tmp14_, _tmp15_);
	parent = (GvdbItem*) _tmp16_;
	_tmp17_ = parent;
	if (_tmp17_ == NULL) {
		GHashTable* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		GvdbItem* _tmp20_ = NULL;
		GvdbItem* _tmp21_ = NULL;
		GHashTable* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		GvdbItem* _tmp24_ = NULL;
		_tmp18_ = table;
		_tmp19_ = parent_name;
		_tmp20_ = gvdb_hash_table_insert (_tmp18_, _tmp19_);
		parent = _tmp20_;
		_tmp21_ = parent;
		_tmp22_ = table;
		_tmp23_ = parent_name;
		_tmp24_ = get_parent (_tmp22_, _tmp23_);
		gvdb_item_set_parent (_tmp21_, _tmp24_);
	}
	_tmp25_ = parent;
	result = _tmp25_;
	_g_free0 (parent_name);
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_slist_free__g_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
	g_slist_free (self);
}


GSList* list_directory (const gchar* dirname, mode_t mode, GError** error) {
	GSList* result = NULL;
	GSList* list = NULL;
	GDir* dir = NULL;
	const gchar* _tmp0_ = NULL;
	GDir* _tmp1_ = NULL;
	const gchar* name = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dirname != NULL, NULL);
	list = NULL;
	_tmp0_ = dirname;
	_tmp1_ = g_dir_open (_tmp0_, (guint) 0, &_inner_error_);
	dir = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		__g_slist_free__g_free0_0 (list);
		return NULL;
	}
	while (TRUE) {
		GDir* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gchar* filename = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		struct stat buf = {0};
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_ = NULL;
		struct stat _tmp12_ = {0};
		gint _tmp13_ = 0;
		gboolean _tmp17_ = FALSE;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		_tmp2_ = dir;
		_tmp3_ = g_dir_read_name (_tmp2_);
		name = _tmp3_;
		_tmp4_ = name;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = name;
		_tmp6_ = g_str_has_prefix (_tmp5_, ".");
		if (_tmp6_) {
			continue;
		}
		_tmp7_ = dirname;
		_tmp8_ = name;
		_tmp9_ = g_build_filename (_tmp7_, _tmp8_, NULL);
		filename = _tmp9_;
		_tmp11_ = filename;
		_tmp13_ = stat (_tmp11_, &_tmp12_);
		buf = _tmp12_;
		if (_tmp13_ < 0) {
			_tmp10_ = TRUE;
		} else {
			struct stat _tmp14_ = {0};
			mode_t _tmp15_ = {0};
			mode_t _tmp16_ = {0};
			_tmp14_ = buf;
			_tmp15_ = _tmp14_.st_mode;
			_tmp16_ = mode;
			_tmp10_ = (_tmp15_ & S_IFMT) != _tmp16_;
		}
		_tmp17_ = _tmp10_;
		if (_tmp17_) {
			_g_free0 (filename);
			continue;
		}
		_tmp18_ = filename;
		_tmp19_ = g_strdup (_tmp18_);
		list = g_slist_prepend (list, _tmp19_);
		_g_free0 (filename);
	}
	result = list;
	_g_dir_close0 (dir);
	return result;
}


GHashTable* read_locks_directory (const gchar* dirname, GError** error) {
	GHashTable* result = NULL;
	GSList* files = NULL;
	GHashTable* table = NULL;
	GHashTable* _tmp3_ = NULL;
	GSList* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dirname != NULL, NULL);
	{
		GSList* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		GSList* _tmp2_ = NULL;
		_tmp1_ = dirname;
		_tmp2_ = list_directory (_tmp1_, S_IFREG, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
				goto __catch0_g_file_error_noent;
			}
			goto __finally0;
		}
		__g_slist_free__g_free0_0 (files);
		files = _tmp0_;
	}
	goto __finally0;
	__catch0_g_file_error_noent:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		__g_slist_free__g_free0_0 (files);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		__g_slist_free__g_free0_0 (files);
		return NULL;
	}
	_tmp3_ = gvdb_hash_table_new (NULL, NULL);
	table = _tmp3_;
	_tmp4_ = files;
	{
		GSList* filename_collection = NULL;
		GSList* filename_it = NULL;
		filename_collection = _tmp4_;
		for (filename_it = filename_collection; filename_it != NULL; filename_it = filename_it->next) {
			gchar* _tmp5_ = NULL;
			gchar* filename = NULL;
			_tmp5_ = g_strdup ((const gchar*) filename_it->data);
			filename = _tmp5_;
			{
				gchar* contents = NULL;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gchar** _tmp9_ = NULL;
				gchar** _tmp10_ = NULL;
				_tmp6_ = filename;
				g_file_get_contents (_tmp6_, &_tmp7_, NULL, &_inner_error_);
				_g_free0 (contents);
				contents = _tmp7_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (contents);
					_g_free0 (filename);
					_g_hash_table_unref0 (table);
					__g_slist_free__g_free0_0 (files);
					return NULL;
				}
				_tmp8_ = contents;
				_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "\n", 0);
				{
					gchar** line_collection = NULL;
					gint line_collection_length1 = 0;
					gint _line_collection_size_ = 0;
					gint line_it = 0;
					line_collection = _tmp10_;
					line_collection_length1 = _vala_array_length (_tmp9_);
					for (line_it = 0; line_it < _vala_array_length (_tmp9_); line_it = line_it + 1) {
						gchar* _tmp11_ = NULL;
						gchar* line = NULL;
						_tmp11_ = g_strdup (line_collection[line_it]);
						line = _tmp11_;
						{
							const gchar* _tmp12_ = NULL;
							gboolean _tmp13_ = FALSE;
							_tmp12_ = line;
							_tmp13_ = g_str_has_prefix (_tmp12_, "/");
							if (_tmp13_) {
								GHashTable* _tmp14_ = NULL;
								const gchar* _tmp15_ = NULL;
								_tmp14_ = table;
								_tmp15_ = line;
								gvdb_hash_table_insert_string (_tmp14_, _tmp15_, "");
							}
							_g_free0 (line);
						}
					}
					line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_free0 (contents);
				_g_free0 (filename);
			}
		}
	}
	result = table;
	__g_slist_free__g_free0_0 (files);
	return result;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


GHashTable* read_directory (const gchar* dirname, GError** error) {
	GHashTable* result = NULL;
	GHashTable* table = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GSList* files = NULL;
	const gchar* _tmp2_ = NULL;
	GSList* _tmp3_ = NULL;
	GCompareFunc _tmp4_ = NULL;
	GSList* _tmp5_ = NULL;
	GHashTable* locks = NULL;
	const gchar* _tmp83_ = NULL;
	gchar* _tmp84_ = NULL;
	gchar* _tmp85_ = NULL;
	GHashTable* _tmp86_ = NULL;
	GHashTable* _tmp87_ = NULL;
	GHashTable* _tmp88_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dirname != NULL, NULL);
	_tmp0_ = gvdb_hash_table_new (NULL, NULL);
	table = _tmp0_;
	_tmp1_ = table;
	gvdb_hash_table_insert (_tmp1_, "/");
	_tmp2_ = dirname;
	_tmp3_ = list_directory (_tmp2_, S_IFREG, &_inner_error_);
	files = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_hash_table_unref0 (table);
		return NULL;
	}
	_tmp4_ = g_strcmp0;
	files = g_slist_sort (files, _tmp4_);
	files = g_slist_reverse (files);
	_tmp5_ = files;
	{
		GSList* filename_collection = NULL;
		GSList* filename_it = NULL;
		filename_collection = _tmp5_;
		for (filename_it = filename_collection; filename_it != NULL; filename_it = filename_it->next) {
			gchar* _tmp6_ = NULL;
			gchar* filename = NULL;
			_tmp6_ = g_strdup ((const gchar*) filename_it->data);
			filename = _tmp6_;
			{
				GKeyFile* kf = NULL;
				GKeyFile* _tmp7_ = NULL;
				_tmp7_ = g_key_file_new ();
				kf = _tmp7_;
				{
					GKeyFile* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					_tmp8_ = kf;
					_tmp9_ = filename;
					g_key_file_load_from_file (_tmp8_, _tmp9_, G_KEY_FILE_NONE, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					GError* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					GError* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					GError* _tmp15_ = NULL;
					GError* _tmp16_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp10_ = e;
					_tmp11_ = filename;
					_tmp12_ = e;
					_tmp13_ = _tmp12_->message;
					_tmp14_ = g_strdup_printf ("warning: Failed to read keyfile '%s': %s", _tmp11_, _tmp13_);
					_g_free0 (_tmp10_->message);
					_tmp10_->message = _tmp14_;
					_tmp15_ = e;
					_tmp16_ = _g_error_copy0 (_tmp15_);
					_inner_error_ = _tmp16_;
					_g_error_free0 (e);
					goto __finally1;
				}
				__finally1:
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_key_file_free0 (kf);
					_g_free0 (filename);
					__g_slist_free__g_free0_0 (files);
					_g_hash_table_unref0 (table);
					return NULL;
				}
				{
					GKeyFile* _tmp17_ = NULL;
					gsize _tmp18_;
					gchar** _tmp19_ = NULL;
					_tmp17_ = kf;
					_tmp19_ = g_key_file_get_groups (_tmp17_, &_tmp18_);
					{
						gchar** group_collection = NULL;
						gint group_collection_length1 = 0;
						gint _group_collection_size_ = 0;
						gint group_it = 0;
						group_collection = _tmp19_;
						group_collection_length1 = _tmp18_;
						for (group_it = 0; group_it < _tmp18_; group_it = group_it + 1) {
							gchar* _tmp20_ = NULL;
							gchar* group = NULL;
							_tmp20_ = g_strdup (group_collection[group_it]);
							group = _tmp20_;
							{
								gboolean _tmp21_ = FALSE;
								gboolean _tmp22_ = FALSE;
								const gchar* _tmp23_ = NULL;
								gboolean _tmp24_ = FALSE;
								gboolean _tmp27_ = FALSE;
								gboolean _tmp30_ = FALSE;
								gchar** _tmp34_ = NULL;
								GKeyFile* _tmp35_ = NULL;
								const gchar* _tmp36_ = NULL;
								gsize _tmp37_;
								gchar** _tmp38_ = NULL;
								gint _tmp34__length1 = 0;
								gint __tmp34__size_ = 0;
								_tmp23_ = group;
								_tmp24_ = g_str_has_prefix (_tmp23_, "/");
								if (_tmp24_) {
									_tmp22_ = TRUE;
								} else {
									const gchar* _tmp25_ = NULL;
									gboolean _tmp26_ = FALSE;
									_tmp25_ = group;
									_tmp26_ = g_str_has_suffix (_tmp25_, "/");
									_tmp22_ = _tmp26_;
								}
								_tmp27_ = _tmp22_;
								if (_tmp27_) {
									_tmp21_ = TRUE;
								} else {
									const gchar* _tmp28_ = NULL;
									gboolean _tmp29_ = FALSE;
									_tmp28_ = group;
									_tmp29_ = string_contains (_tmp28_, "//");
									_tmp21_ = _tmp29_;
								}
								_tmp30_ = _tmp21_;
								if (_tmp30_) {
									FILE* _tmp31_ = NULL;
									const gchar* _tmp32_ = NULL;
									const gchar* _tmp33_ = NULL;
									_tmp31_ = stderr;
									_tmp32_ = filename;
									_tmp33_ = group;
									fprintf (_tmp31_, "%s: ignoring invalid group name: %s\n", _tmp32_, _tmp33_);
									_g_free0 (group);
									continue;
								}
								_tmp35_ = kf;
								_tmp36_ = group;
								_tmp38_ = g_key_file_get_keys (_tmp35_, _tmp36_, &_tmp37_, &_inner_error_);
								_tmp34_ = _tmp38_;
								_tmp34__length1 = _tmp37_;
								__tmp34__size_ = _tmp34__length1;
								if (_inner_error_ != NULL) {
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									if (_inner_error_->domain == G_KEY_FILE_ERROR) {
										goto __catch2_g_key_file_error;
									}
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_free0 (kf);
									_g_free0 (filename);
									__g_slist_free__g_free0_0 (files);
									_g_hash_table_unref0 (table);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
								{
									gchar** key_collection = NULL;
									gint key_collection_length1 = 0;
									gint _key_collection_size_ = 0;
									gint key_it = 0;
									key_collection = _tmp34_;
									key_collection_length1 = _tmp34__length1;
									for (key_it = 0; key_it < _tmp34__length1; key_it = key_it + 1) {
										gchar* _tmp39_ = NULL;
										gchar* key = NULL;
										_tmp39_ = g_strdup (key_collection[key_it]);
										key = _tmp39_;
										{
											const gchar* _tmp40_ = NULL;
											gboolean _tmp41_ = FALSE;
											gchar* path = NULL;
											const gchar* _tmp46_ = NULL;
											gchar* _tmp47_ = NULL;
											gchar* _tmp48_ = NULL;
											gchar* _tmp49_ = NULL;
											gchar* _tmp50_ = NULL;
											const gchar* _tmp51_ = NULL;
											gchar* _tmp52_ = NULL;
											gchar* _tmp53_ = NULL;
											GHashTable* _tmp54_ = NULL;
											const gchar* _tmp55_ = NULL;
											gconstpointer _tmp56_ = NULL;
											gchar* text = NULL;
											GKeyFile* _tmp57_ = NULL;
											const gchar* _tmp58_ = NULL;
											const gchar* _tmp59_ = NULL;
											gchar* _tmp60_ = NULL;
											_tmp40_ = key;
											_tmp41_ = string_contains (_tmp40_, "/");
											if (_tmp41_) {
												const gchar* _tmp42_ = NULL;
												const gchar* _tmp43_ = NULL;
												const gchar* _tmp44_ = NULL;
												GError* _tmp45_ = NULL;
												_tmp42_ = filename;
												_tmp43_ = group;
												_tmp44_ = key;
												_tmp45_ = g_error_new (G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_INVALID_VALUE, "%s: [%s]: invalid key name: %s", _tmp42_, _tmp43_, _tmp44_);
												_inner_error_ = _tmp45_;
												_g_free0 (key);
												key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
												_g_free0 (group);
												group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
												if (_inner_error_->domain == G_KEY_FILE_ERROR) {
													goto __catch2_g_key_file_error;
												}
												_g_free0 (key);
												key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
												_g_free0 (group);
												group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
												_g_key_file_free0 (kf);
												_g_free0 (filename);
												__g_slist_free__g_free0_0 (files);
												_g_hash_table_unref0 (table);
												g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return NULL;
											}
											_tmp46_ = group;
											_tmp47_ = g_strconcat ("/", _tmp46_, NULL);
											_tmp48_ = _tmp47_;
											_tmp49_ = g_strconcat (_tmp48_, "/", NULL);
											_tmp50_ = _tmp49_;
											_tmp51_ = key;
											_tmp52_ = g_strconcat (_tmp50_, _tmp51_, NULL);
											_tmp53_ = _tmp52_;
											_g_free0 (_tmp50_);
											_g_free0 (_tmp48_);
											path = _tmp53_;
											_tmp54_ = table;
											_tmp55_ = path;
											_tmp56_ = g_hash_table_lookup (_tmp54_, _tmp55_);
											if (((GvdbItem*) _tmp56_) != NULL) {
												_g_free0 (path);
												_g_free0 (key);
												continue;
											}
											_tmp57_ = kf;
											_tmp58_ = group;
											_tmp59_ = key;
											_tmp60_ = g_key_file_get_value (_tmp57_, _tmp58_, _tmp59_, &_inner_error_);
											text = _tmp60_;
											if (_inner_error_ != NULL) {
												_g_free0 (path);
												_g_free0 (key);
												key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
												_g_free0 (group);
												group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
												if (_inner_error_->domain == G_KEY_FILE_ERROR) {
													goto __catch2_g_key_file_error;
												}
												_g_free0 (path);
												_g_free0 (key);
												key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
												_g_free0 (group);
												group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
												_g_key_file_free0 (kf);
												_g_free0 (filename);
												__g_slist_free__g_free0_0 (files);
												_g_hash_table_unref0 (table);
												g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return NULL;
											}
											{
												GVariant* value = NULL;
												const gchar* _tmp61_ = NULL;
												GVariant* _tmp62_ = NULL;
												GvdbItem* item = NULL;
												GHashTable* _tmp63_ = NULL;
												const gchar* _tmp64_ = NULL;
												GvdbItem* _tmp65_ = NULL;
												GvdbItem* _tmp66_ = NULL;
												GHashTable* _tmp67_ = NULL;
												const gchar* _tmp68_ = NULL;
												GvdbItem* _tmp69_ = NULL;
												GvdbItem* _tmp70_ = NULL;
												GVariant* _tmp71_ = NULL;
												_tmp61_ = text;
												_tmp62_ = g_variant_parse (NULL, _tmp61_, NULL, NULL, &_inner_error_);
												value = _tmp62_;
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == G_VARIANT_PARSE_ERROR) {
														goto __catch3_g_variant_parse_error;
													}
													_g_free0 (text);
													_g_free0 (path);
													_g_free0 (key);
													key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
													_g_free0 (group);
													group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
													_g_key_file_free0 (kf);
													_g_free0 (filename);
													__g_slist_free__g_free0_0 (files);
													_g_hash_table_unref0 (table);
													g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return NULL;
												}
												_tmp63_ = table;
												_tmp64_ = path;
												_tmp65_ = gvdb_hash_table_insert (_tmp63_, _tmp64_);
												item = _tmp65_;
												_tmp66_ = item;
												_tmp67_ = table;
												_tmp68_ = path;
												_tmp69_ = get_parent (_tmp67_, _tmp68_);
												gvdb_item_set_parent (_tmp66_, _tmp69_);
												_tmp70_ = item;
												_tmp71_ = value;
												gvdb_item_set_value (_tmp70_, _tmp71_);
												_g_variant_unref0 (value);
											}
											goto __finally3;
											__catch3_g_variant_parse_error:
											{
												GError* e = NULL;
												GError* _tmp72_ = NULL;
												const gchar* _tmp73_ = NULL;
												const gchar* _tmp74_ = NULL;
												const gchar* _tmp75_ = NULL;
												const gchar* _tmp76_ = NULL;
												GError* _tmp77_ = NULL;
												const gchar* _tmp78_ = NULL;
												gchar* _tmp79_ = NULL;
												GError* _tmp80_ = NULL;
												GError* _tmp81_ = NULL;
												e = _inner_error_;
												_inner_error_ = NULL;
												_tmp72_ = e;
												_tmp73_ = filename;
												_tmp74_ = group;
												_tmp75_ = key;
												_tmp76_ = text;
												_tmp77_ = e;
												_tmp78_ = _tmp77_->message;
												_tmp79_ = g_strdup_printf ("%s: [%s]: %s: invalid value: %s (%s)", _tmp73_, _tmp74_, _tmp75_, _tmp76_, _tmp78_);
												_g_free0 (_tmp72_->message);
												_tmp72_->message = _tmp79_;
												_tmp80_ = e;
												_tmp81_ = _g_error_copy0 (_tmp80_);
												_inner_error_ = _tmp81_;
												_g_error_free0 (e);
												goto __finally3;
											}
											__finally3:
											if (_inner_error_ != NULL) {
												_g_free0 (text);
												_g_free0 (path);
												_g_free0 (key);
												key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
												_g_free0 (group);
												group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
												if (_inner_error_->domain == G_KEY_FILE_ERROR) {
													goto __catch2_g_key_file_error;
												}
												goto __finally2;
											}
											_g_free0 (text);
											_g_free0 (path);
											_g_free0 (key);
										}
									}
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
								}
								_g_free0 (group);
							}
						}
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
					}
				}
				goto __finally2;
				__catch2_g_key_file_error:
				{
					GError* e = NULL;
					const gchar* _tmp82_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp82_ = e->message;
					g_warning ("dconf-update.vala:152: unexpected keyfile error: %s.  Please file a bu" \
"g.", _tmp82_);
					g_assert_not_reached ();
					_g_error_free0 (e);
				}
				__finally2:
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_key_file_free0 (kf);
					_g_free0 (filename);
					__g_slist_free__g_free0_0 (files);
					_g_hash_table_unref0 (table);
					return NULL;
				}
				_g_key_file_free0 (kf);
				_g_free0 (filename);
			}
		}
	}
	_tmp83_ = dirname;
	_tmp84_ = g_strconcat (_tmp83_, "/locks", NULL);
	_tmp85_ = _tmp84_;
	_tmp86_ = read_locks_directory (_tmp85_, &_inner_error_);
	_tmp87_ = _tmp86_;
	_g_free0 (_tmp85_);
	locks = _tmp87_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		__g_slist_free__g_free0_0 (files);
		_g_hash_table_unref0 (table);
		return NULL;
	}
	_tmp88_ = locks;
	if (_tmp88_ != NULL) {
		GvdbItem* item = NULL;
		GHashTable* _tmp89_ = NULL;
		GvdbItem* _tmp90_ = NULL;
		GvdbItem* _tmp91_ = NULL;
		GHashTable* _tmp92_ = NULL;
		_tmp89_ = table;
		_tmp90_ = gvdb_hash_table_insert (_tmp89_, ".locks");
		item = _tmp90_;
		_tmp91_ = item;
		_tmp92_ = locks;
		gvdb_item_set_hash_table (_tmp91_, _tmp92_);
	}
	result = table;
	_g_hash_table_unref0 (locks);
	__g_slist_free__g_free0_0 (files);
	return result;
}


void maybe_update_from_directory (const gchar* dirname, GError** error) {
	struct stat dir_buf = {0};
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	struct stat _tmp2_ = {0};
	gint _tmp3_ = 0;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dirname != NULL);
	_tmp1_ = dirname;
	_tmp3_ = stat (_tmp1_, &_tmp2_);
	dir_buf = _tmp2_;
	if (_tmp3_ == 0) {
		struct stat _tmp4_ = {0};
		mode_t _tmp5_ = {0};
		gboolean _tmp6_ = FALSE;
		_tmp4_ = dir_buf;
		_tmp5_ = _tmp4_.st_mode;
		_tmp6_ = S_ISDIR (_tmp5_);
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		struct stat lockdir_buf = {0};
		struct stat file_buf = {0};
		gchar* filename = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		struct stat _tmp17_ = {0};
		gint _tmp18_ = 0;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp27_ = FALSE;
		const gchar* _tmp28_ = NULL;
		struct stat _tmp29_ = {0};
		gint _tmp30_ = 0;
		gboolean _tmp35_ = FALSE;
		GHashTable* table = NULL;
		const gchar* _tmp36_ = NULL;
		GHashTable* _tmp37_ = NULL;
		gint fd = 0;
		const gchar* _tmp38_ = NULL;
		gint _tmp39_ = 0;
		gboolean _tmp40_ = FALSE;
		gint _tmp41_ = 0;
		gboolean _tmp43_ = FALSE;
		_tmp8_ = dirname;
		_tmp9_ = dirname;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_substring (_tmp8_, (glong) 0, (glong) (_tmp11_ - 2));
		filename = _tmp12_;
		_tmp14_ = dirname;
		_tmp15_ = g_strconcat (_tmp14_, "/locks", NULL);
		_tmp16_ = _tmp15_;
		_tmp18_ = stat (_tmp16_, &_tmp17_);
		lockdir_buf = _tmp17_;
		_tmp19_ = _tmp18_ == 0;
		_g_free0 (_tmp16_);
		if (_tmp19_) {
			struct stat _tmp20_ = {0};
			time_t _tmp21_ = 0;
			struct stat _tmp22_ = {0};
			time_t _tmp23_ = 0;
			_tmp20_ = lockdir_buf;
			_tmp21_ = _tmp20_.st_mtime;
			_tmp22_ = dir_buf;
			_tmp23_ = _tmp22_.st_mtime;
			_tmp13_ = _tmp21_ > _tmp23_;
		} else {
			_tmp13_ = FALSE;
		}
		_tmp24_ = _tmp13_;
		if (_tmp24_) {
			struct stat _tmp25_ = {0};
			time_t _tmp26_ = 0;
			_tmp25_ = lockdir_buf;
			_tmp26_ = _tmp25_.st_mtime;
			dir_buf.st_mtime = _tmp26_;
		}
		_tmp28_ = filename;
		_tmp30_ = stat (_tmp28_, &_tmp29_);
		file_buf = _tmp29_;
		if (_tmp30_ == 0) {
			struct stat _tmp31_ = {0};
			time_t _tmp32_ = 0;
			struct stat _tmp33_ = {0};
			time_t _tmp34_ = 0;
			_tmp31_ = file_buf;
			_tmp32_ = _tmp31_.st_mtime;
			_tmp33_ = dir_buf;
			_tmp34_ = _tmp33_.st_mtime;
			_tmp27_ = _tmp32_ > _tmp34_;
		} else {
			_tmp27_ = FALSE;
		}
		_tmp35_ = _tmp27_;
		if (_tmp35_) {
			_g_free0 (filename);
			return;
		}
		_tmp36_ = dirname;
		_tmp37_ = read_directory (_tmp36_, &_inner_error_);
		table = _tmp37_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (filename);
			return;
		}
		_tmp38_ = filename;
		_tmp39_ = open (_tmp38_, O_WRONLY, (mode_t) 0);
		fd = _tmp39_;
		_tmp41_ = fd;
		if (_tmp41_ < 0) {
			gint _tmp42_ = 0;
			_tmp42_ = errno;
			_tmp40_ = _tmp42_ != ENOENT;
		} else {
			_tmp40_ = FALSE;
		}
		_tmp43_ = _tmp40_;
		if (_tmp43_) {
			gint saved_error = 0;
			gint _tmp44_ = 0;
			const gchar* _tmp45_ = NULL;
			gint _tmp46_ = 0;
			const gchar* _tmp47_ = NULL;
			_tmp44_ = errno;
			saved_error = _tmp44_;
			_tmp45_ = filename;
			_tmp46_ = saved_error;
			_tmp47_ = g_strerror (_tmp46_);
			g_printerr ("warning: Failed to open '%s' for replacement: %s\n", _tmp45_, _tmp47_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		{
			GHashTable* _tmp48_ = NULL;
			const gchar* _tmp49_ = NULL;
			gint _tmp50_ = 0;
			_tmp48_ = table;
			_tmp49_ = filename;
			gvdb_table_write_contents (_tmp48_, _tmp49_, FALSE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
			_tmp50_ = fd;
			if (_tmp50_ >= 0) {
				gint _tmp51_ = 0;
				_tmp51_ = fd;
				write (_tmp51_, "\0\0\0\0\0\0\0\0", (gsize) 8);
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			GError* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp52_ = e;
			_tmp53_ = _tmp52_->message;
			g_printerr ("warning: %s\n", _tmp53_);
			_g_error_free0 (e);
			{
				gint _tmp54_ = 0;
				_tmp54_ = fd;
				if (_tmp54_ >= 0) {
					gint _tmp55_ = 0;
					_tmp55_ = fd;
					close (_tmp55_);
				}
			}
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		__finally4:
		{
			gint _tmp56_ = 0;
			_tmp56_ = fd;
			if (_tmp56_ >= 0) {
				gint _tmp57_ = 0;
				_tmp57_ = fd;
				close (_tmp57_);
			}
		}
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		{
			GDBusConnection* system_bus = NULL;
			GDBusConnection* _tmp58_ = NULL;
			GDBusConnection* _tmp59_ = NULL;
			const gchar* _tmp60_ = NULL;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_ = NULL;
			gchar* _tmp63_ = NULL;
			gchar* _tmp64_ = NULL;
			GVariant* _tmp65_ = NULL;
			GVariant* _tmp66_ = NULL;
			GDBusConnection* _tmp67_ = NULL;
			_tmp58_ = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &_inner_error_);
			system_bus = _tmp58_;
			if (_inner_error_ != NULL) {
				goto __catch5_g_error;
			}
			_tmp59_ = system_bus;
			_tmp60_ = filename;
			_tmp61_ = g_path_get_basename (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = g_strconcat ("/ca/desrt/dconf/Writer/", _tmp62_, NULL);
			_tmp64_ = _tmp63_;
			_tmp65_ = g_variant_new ("(s)", "/", NULL);
			g_variant_ref_sink (_tmp65_);
			_tmp66_ = _tmp65_;
			g_dbus_connection_emit_signal (_tmp59_, NULL, _tmp64_, "ca.desrt.dconf.Writer", "WritabilityNotify", _tmp66_, &_inner_error_);
			_g_variant_unref0 (_tmp66_);
			_g_free0 (_tmp64_);
			_g_free0 (_tmp62_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (system_bus);
				goto __catch5_g_error;
			}
			_tmp67_ = system_bus;
			g_dbus_connection_flush_sync (_tmp67_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (system_bus);
				goto __catch5_g_error;
			}
			_g_object_unref0 (system_bus);
		}
		goto __finally5;
		__catch5_g_error:
		{
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
		}
		__finally5:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		_g_hash_table_unref0 (table);
		_g_free0 (filename);
	}
}


void update_all (const gchar* dirname, GError** error) {
	GSList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GSList* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dirname != NULL);
	_tmp1_ = dirname;
	_tmp2_ = list_directory (_tmp1_, S_IFDIR, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	{
		GSList* name_collection = NULL;
		GSList* name_it = NULL;
		name_collection = _tmp0_;
		for (name_it = name_collection; name_it != NULL; name_it = name_it->next) {
			gchar* _tmp3_ = NULL;
			gchar* name = NULL;
			_tmp3_ = g_strdup ((const gchar*) name_it->data);
			name = _tmp3_;
			{
				const gchar* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				_tmp4_ = name;
				_tmp5_ = g_str_has_suffix (_tmp4_, ".d");
				if (_tmp5_) {
					{
						const gchar* _tmp6_ = NULL;
						_tmp6_ = name;
						maybe_update_from_directory (_tmp6_, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch6_g_error;
						}
					}
					goto __finally6;
					__catch6_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp7_ = NULL;
						GError* _tmp8_ = NULL;
						const gchar* _tmp9_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp7_ = name;
						_tmp8_ = e;
						_tmp9_ = _tmp8_->message;
						g_printerr ("unable compile %s: %s\n", _tmp7_, _tmp9_);
						_g_error_free0 (e);
					}
					__finally6:
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (name);
						__g_slist_free__g_free0_0 (name_collection);
						return;
					}
				}
				_g_free0 (name);
			}
		}
		__g_slist_free__g_free0_0 (name_collection);
	}
}


void dconf_compile (gchar** args, int args_length1, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp2_ = args;
	_tmp2__length1 = args_length1;
	_tmp3_ = _tmp2_[2];
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = args;
		_tmp4__length1 = args_length1;
		_tmp5_ = _tmp4_[3];
		_tmp1_ = _tmp5_ == NULL;
	}
	_tmp6_ = _tmp1_;
	if (_tmp6_) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		const gchar* _tmp8_ = NULL;
		_tmp7_ = args;
		_tmp7__length1 = args_length1;
		_tmp8_ = _tmp7_[4];
		_tmp0_ = _tmp8_ != NULL;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		GError* _tmp10_ = NULL;
		_tmp10_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "must give output file and .d dir");
		_inner_error_ = _tmp10_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	{
		GHashTable* table = NULL;
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		const gchar* _tmp12_ = NULL;
		GHashTable* _tmp13_ = NULL;
		GHashTable* _tmp14_ = NULL;
		gchar** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		const gchar* _tmp16_ = NULL;
		_tmp11_ = args;
		_tmp11__length1 = args_length1;
		_tmp12_ = _tmp11_[3];
		_tmp13_ = read_directory (_tmp12_, &_inner_error_);
		table = _tmp13_;
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_tmp14_ = table;
		_tmp15_ = args;
		_tmp15__length1 = args_length1;
		_tmp16_ = _tmp15_[2];
		gvdb_table_write_contents (_tmp14_, _tmp16_, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_hash_table_unref0 (table);
			goto __catch7_g_error;
		}
		_g_hash_table_unref0 (table);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp17_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = e->message;
		g_printerr ("%s\n", _tmp17_);
		exit (1);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void dconf_update (gchar** args, int args_length1, GError** error) {
	GError * _inner_error_ = NULL;
	update_all ("/etc/dconf/db", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



