/* A Bison parser, made by GNU Bison 2.7.  */

/* Bison implementation for Yacc-like parsers in C
   
      Copyright (C) 1984, 1989-1990, 2000-2012 Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.7"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
/* Line 371 of yacc.c  */
#line 29 "giscanner/scannerparser.y"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <glib.h>
#include <glib/gstdio.h>
#include "sourcescanner.h"
#include "scannerparser.h"

extern FILE *yyin;
extern int lineno;
extern char linebuf[2000];
extern char *yytext;

extern int yylex (GISourceScanner *scanner);
static void yyerror (GISourceScanner *scanner, const char *str);

extern void ctype_free (GISourceType * type);

static int last_enum_value = -1;
static gboolean is_bitfield;
static GHashTable *const_table = NULL;

/**
 * parse_c_string_literal:
 * @str: A string containing a C string literal
 *
 * Based on g_strcompress(), but also handles
 * hexadecimal escapes.
 */
static char *
parse_c_string_literal (const char *str)
{
  const gchar *p = str, *num;
  gchar *dest = g_malloc (strlen (str) + 1);
  gchar *q = dest;

  while (*p)
    {
      if (*p == '\\')
        {
          p++;
          switch (*p)
            {
            case '\0':
              g_warning ("parse_c_string_literal: trailing \\");
              goto out;
            case '0':  case '1':  case '2':  case '3':  case '4':
            case '5':  case '6':  case '7':
              *q = 0;
              num = p;
              while ((p < num + 3) && (*p >= '0') && (*p <= '7'))
                {
                  *q = (*q * 8) + (*p - '0');
                  p++;
                }
              q++;
              p--;
              break;
	    case 'x':
	      *q = 0;
	      p++;
	      num = p;
	      while ((p < num + 2) && (g_ascii_isxdigit(*p)))
		{
		  *q = (*q * 16) + g_ascii_xdigit_value(*p);
		  p++;
		}
              q++;
              p--;
	      break;
            case 'b':
              *q++ = '\b';
              break;
            case 'f':
              *q++ = '\f';
              break;
            case 'n':
              *q++ = '\n';
              break;
            case 'r':
              *q++ = '\r';
              break;
            case 't':
              *q++ = '\t';
              break;
            default:            /* Also handles \" and \\ */
              *q++ = *p;
              break;
            }
        }
      else
        *q++ = *p;
      p++;
    }
out:
  *q = 0;

  return dest;
}

enum {
  IRRELEVANT = 1,
  NOT_GI_SCANNER = 2,
  FOR_GI_SCANNER = 3,
};

static void
update_skipping (GISourceScanner *scanner)
{
  GList *l;
  for (l = scanner->conditionals.head; l != NULL; l = g_list_next (l))
    {
      if (GPOINTER_TO_INT (l->data) == NOT_GI_SCANNER)
        {
           scanner->skipping = TRUE;
           return;
        }
    }

  scanner->skipping = FALSE;
}

static void
push_conditional (GISourceScanner *scanner,
                  gint type)
{
  g_assert (type != 0);
  g_queue_push_head (&scanner->conditionals, GINT_TO_POINTER (type));
}

static gint
pop_conditional (GISourceScanner *scanner)
{
  gint type = GPOINTER_TO_INT (g_queue_pop_head (&scanner->conditionals));

  if (type == 0)
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      fprintf (stderr, "%s:%d: mismatched %s", filename, lineno, yytext);
      g_free (filename);
    }

  return type;
}

static void
warn_if_cond_has_gi_scanner (GISourceScanner *scanner,
                             const gchar *text)
{
  /* Some other conditional that is not __GI_SCANNER__ */
  if (strstr (text, "__GI_SCANNER__"))
    {
      gchar *filename = g_file_get_path (scanner->current_file);
      fprintf (stderr, "%s:%d: the __GI_SCANNER__ constant should only be used with simple #ifdef or #endif: %s",
               filename, lineno, text);
      g_free (filename);
    }
}

static void
toggle_conditional (GISourceScanner *scanner)
{
  switch (pop_conditional (scanner))
    {
    case FOR_GI_SCANNER:
      push_conditional (scanner, NOT_GI_SCANNER);
      break;
    case NOT_GI_SCANNER:
      push_conditional (scanner, FOR_GI_SCANNER);
      break;
    case 0:
      break;
    default:
      push_conditional (scanner, IRRELEVANT);
      break;
    }
}


/* Line 371 of yacc.c  */
#line 250 "scannerparser.c"

# ifndef YY_NULL
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULL nullptr
#  else
#   define YY_NULL 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 1
#endif

/* In a future release of Bison, this section will be replaced
   by #include "y.tab.h".  */
#ifndef YY_YY_SCANNERPARSER_H_INCLUDED
# define YY_YY_SCANNERPARSER_H_INCLUDED
/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     IDENTIFIER = 258,
     TYPEDEF_NAME = 259,
     INTEGER = 260,
     FLOATING = 261,
     CHARACTER = 262,
     STRING = 263,
     INTL_CONST = 264,
     INTUL_CONST = 265,
     ELLIPSIS = 266,
     ADDEQ = 267,
     SUBEQ = 268,
     MULEQ = 269,
     DIVEQ = 270,
     MODEQ = 271,
     XOREQ = 272,
     ANDEQ = 273,
     OREQ = 274,
     SL = 275,
     SR = 276,
     SLEQ = 277,
     SREQ = 278,
     EQ = 279,
     NOTEQ = 280,
     LTEQ = 281,
     GTEQ = 282,
     ANDAND = 283,
     OROR = 284,
     PLUSPLUS = 285,
     MINUSMINUS = 286,
     ARROW = 287,
     AUTO = 288,
     BOOL = 289,
     BREAK = 290,
     CASE = 291,
     CHAR = 292,
     CONST = 293,
     CONTINUE = 294,
     DEFAULT = 295,
     DO = 296,
     DOUBLE = 297,
     ELSE = 298,
     ENUM = 299,
     EXTENSION = 300,
     EXTERN = 301,
     FLOAT = 302,
     FOR = 303,
     GOTO = 304,
     IF = 305,
     INLINE = 306,
     INT = 307,
     LONG = 308,
     REGISTER = 309,
     RESTRICT = 310,
     RETURN = 311,
     SHORT = 312,
     SIGNED = 313,
     SIZEOF = 314,
     STATIC = 315,
     STRUCT = 316,
     SWITCH = 317,
     TYPEDEF = 318,
     UNION = 319,
     UNSIGNED = 320,
     VOID = 321,
     VOLATILE = 322,
     WHILE = 323,
     FUNCTION_MACRO = 324,
     OBJECT_MACRO = 325,
     IFDEF_GI_SCANNER = 326,
     IFNDEF_GI_SCANNER = 327,
     IFDEF_COND = 328,
     IFNDEF_COND = 329,
     IF_COND = 330,
     ELIF_COND = 331,
     ELSE_COND = 332,
     ENDIF_COND = 333
   };
#endif
/* Tokens.  */
#define IDENTIFIER 258
#define TYPEDEF_NAME 259
#define INTEGER 260
#define FLOATING 261
#define CHARACTER 262
#define STRING 263
#define INTL_CONST 264
#define INTUL_CONST 265
#define ELLIPSIS 266
#define ADDEQ 267
#define SUBEQ 268
#define MULEQ 269
#define DIVEQ 270
#define MODEQ 271
#define XOREQ 272
#define ANDEQ 273
#define OREQ 274
#define SL 275
#define SR 276
#define SLEQ 277
#define SREQ 278
#define EQ 279
#define NOTEQ 280
#define LTEQ 281
#define GTEQ 282
#define ANDAND 283
#define OROR 284
#define PLUSPLUS 285
#define MINUSMINUS 286
#define ARROW 287
#define AUTO 288
#define BOOL 289
#define BREAK 290
#define CASE 291
#define CHAR 292
#define CONST 293
#define CONTINUE 294
#define DEFAULT 295
#define DO 296
#define DOUBLE 297
#define ELSE 298
#define ENUM 299
#define EXTENSION 300
#define EXTERN 301
#define FLOAT 302
#define FOR 303
#define GOTO 304
#define IF 305
#define INLINE 306
#define INT 307
#define LONG 308
#define REGISTER 309
#define RESTRICT 310
#define RETURN 311
#define SHORT 312
#define SIGNED 313
#define SIZEOF 314
#define STATIC 315
#define STRUCT 316
#define SWITCH 317
#define TYPEDEF 318
#define UNION 319
#define UNSIGNED 320
#define VOID 321
#define VOLATILE 322
#define WHILE 323
#define FUNCTION_MACRO 324
#define OBJECT_MACRO 325
#define IFDEF_GI_SCANNER 326
#define IFNDEF_GI_SCANNER 327
#define IFDEF_COND 328
#define IFNDEF_COND 329
#define IF_COND 330
#define ELIF_COND 331
#define ELSE_COND 332
#define ENDIF_COND 333



#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{
/* Line 387 of yacc.c  */
#line 212 "giscanner/scannerparser.y"

  char *str;
  GList *list;
  GISourceSymbol *symbol;
  GISourceType *ctype;
  StorageClassSpecifier storage_class_specifier;
  TypeQualifier type_qualifier;
  FunctionSpecifier function_specifier;
  UnaryOperator unary_operator;


/* Line 387 of yacc.c  */
#line 461 "scannerparser.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif

extern YYSTYPE yylval;

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (GISourceScanner* scanner);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */

#endif /* !YY_YY_SCANNERPARSER_H_INCLUDED  */

/* Copy the second part of user declarations.  */

/* Line 390 of yacc.c  */
#line 489 "scannerparser.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(N) (N)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (YYID (0))
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  76
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2591

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  103
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  77
/* YYNRULES -- Number of rules.  */
#define YYNRULES  255
/* YYNRULES -- Number of states.  */
#define YYNSTATES  425

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   333

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    92,     2,     2,     2,    94,    87,     2,
      79,    80,    88,    89,    86,    90,    85,    93,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   100,   102,
      95,   101,    96,    99,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    83,     2,    84,    97,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    81,    98,    82,    91,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    17,    24,
      26,    29,    31,    33,    35,    37,    42,    47,    51,    55,
      59,    62,    65,    67,    71,    73,    76,    79,    82,    87,
      92,    95,   100,   102,   104,   106,   108,   110,   112,   114,
     119,   121,   125,   129,   133,   135,   139,   143,   145,   149,
     153,   155,   159,   163,   167,   171,   173,   177,   181,   183,
     187,   189,   193,   195,   199,   201,   205,   207,   211,   213,
     219,   221,   225,   227,   229,   231,   233,   235,   237,   239,
     241,   243,   245,   247,   249,   253,   256,   258,   262,   265,
     268,   270,   273,   275,   278,   280,   283,   285,   287,   291,
     293,   297,   299,   301,   303,   305,   307,   309,   311,   313,
     315,   317,   319,   321,   323,   325,   327,   329,   331,   333,
     339,   344,   347,   349,   351,   353,   356,   360,   363,   365,
     368,   370,   372,   376,   377,   379,   382,   386,   392,   397,
     404,   410,   413,   415,   416,   419,   423,   425,   429,   431,
     433,   435,   437,   439,   442,   444,   446,   450,   455,   459,
     464,   469,   473,   476,   478,   482,   485,   487,   490,   492,
     496,   499,   502,   504,   506,   508,   512,   514,   517,   519,
     521,   524,   528,   531,   535,   539,   544,   547,   551,   555,
     560,   562,   564,   568,   573,   575,   579,   581,   583,   585,
     587,   589,   591,   595,   600,   604,   607,   611,   613,   616,
     618,   620,   622,   625,   631,   639,   645,   651,   659,   666,
     674,   682,   691,   699,   708,   717,   727,   731,   734,   737,
     740,   744,   746,   749,   751,   753,   755,   760,   764,   766,
     769,   771,   773,   778,   781,   783,   785,   787,   789,   791,
     793,   795,   797,   799,   801,   803
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     170,     0,    -1,   106,    -1,     5,    -1,     7,    -1,     6,
      -1,   105,    -1,    79,   126,    80,    -1,    45,    79,    81,
     164,    82,    80,    -1,     8,    -1,   105,     8,    -1,     3,
      -1,   106,    -1,   158,    -1,   104,    -1,   108,    83,   126,
      84,    -1,   108,    79,   109,    80,    -1,   108,    79,    80,
      -1,   108,    85,   107,    -1,   108,    32,   107,    -1,   108,
      30,    -1,   108,    31,    -1,   124,    -1,   109,    86,   124,
      -1,   108,    -1,    30,   110,    -1,    31,   110,    -1,   111,
     112,    -1,     9,    79,   110,    80,    -1,    10,    79,   110,
      80,    -1,    59,   110,    -1,    59,    79,   155,    80,    -1,
      87,    -1,    88,    -1,    89,    -1,    90,    -1,    91,    -1,
      92,    -1,   110,    -1,    79,   155,    80,   112,    -1,   112,
      -1,   113,    88,   112,    -1,   113,    93,   112,    -1,   113,
      94,   112,    -1,   113,    -1,   114,    89,   113,    -1,   114,
      90,   113,    -1,   114,    -1,   115,    20,   114,    -1,   115,
      21,   114,    -1,   115,    -1,   116,    95,   115,    -1,   116,
      96,   115,    -1,   116,    26,   115,    -1,   116,    27,   115,
      -1,   116,    -1,   117,    24,   116,    -1,   117,    25,   116,
      -1,   117,    -1,   118,    87,   117,    -1,   118,    -1,   119,
      97,   118,    -1,   119,    -1,   120,    98,   119,    -1,   120,
      -1,   121,    28,   120,    -1,   121,    -1,   122,    29,   121,
      -1,   122,    -1,   122,    99,   126,   100,   126,    -1,   123,
      -1,   110,   125,   124,    -1,   101,    -1,    14,    -1,    15,
      -1,    16,    -1,    12,    -1,    13,    -1,    22,    -1,    23,
      -1,    18,    -1,    17,    -1,    19,    -1,   124,    -1,   126,
      86,   124,    -1,    45,   126,    -1,   123,    -1,   129,   130,
     102,    -1,   129,   102,    -1,   132,   129,    -1,   132,    -1,
     133,   129,    -1,   133,    -1,   146,   129,    -1,   146,    -1,
     147,   129,    -1,   147,    -1,   131,    -1,   130,    86,   131,
      -1,   148,    -1,   148,   101,   159,    -1,    63,    -1,    46,
      -1,    60,    -1,    33,    -1,    54,    -1,    66,    -1,    37,
      -1,    57,    -1,    52,    -1,    53,    -1,    47,    -1,    42,
      -1,    58,    -1,    65,    -1,    34,    -1,   134,    -1,   141,
      -1,   158,    -1,   135,   107,    81,   136,    82,    -1,   135,
      81,   136,    82,    -1,   135,   107,    -1,    61,    -1,    64,
      -1,   137,    -1,   136,   137,    -1,   138,   139,   102,    -1,
     133,   138,    -1,   133,    -1,   146,   138,    -1,   146,    -1,
     140,    -1,   139,    86,   140,    -1,    -1,   148,    -1,   100,
     127,    -1,   148,   100,   127,    -1,   142,   107,    81,   143,
      82,    -1,   142,    81,   143,    82,    -1,   142,   107,    81,
     143,    86,    82,    -1,   142,    81,   143,    86,    82,    -1,
     142,   107,    -1,    44,    -1,    -1,   144,   145,    -1,   143,
      86,   145,    -1,   106,    -1,   106,   101,   127,    -1,    38,
      -1,    55,    -1,    45,    -1,    67,    -1,    51,    -1,   150,
     149,    -1,   149,    -1,   106,    -1,    79,   148,    80,    -1,
     149,    83,   124,    84,    -1,   149,    83,    84,    -1,   149,
      79,   152,    80,    -1,   149,    79,   154,    80,    -1,   149,
      79,    80,    -1,    88,   151,    -1,    88,    -1,    88,   151,
     150,    -1,    88,   150,    -1,   146,    -1,   151,   146,    -1,
     153,    -1,   152,    86,   153,    -1,   129,   148,    -1,   129,
     156,    -1,   129,    -1,    11,    -1,   106,    -1,   154,    86,
     106,    -1,   138,    -1,   138,   156,    -1,   150,    -1,   157,
      -1,   150,   157,    -1,    79,   156,    80,    -1,    83,    84,
      -1,    83,   124,    84,    -1,   157,    83,    84,    -1,   157,
      83,   124,    84,    -1,    79,    80,    -1,    79,   152,    80,
      -1,   157,    79,    80,    -1,   157,    79,   152,    80,    -1,
       4,    -1,   124,    -1,    81,   160,    82,    -1,    81,   160,
      86,    82,    -1,   159,    -1,   160,    86,   159,    -1,   162,
      -1,   163,    -1,   166,    -1,   167,    -1,   168,    -1,   169,
      -1,   107,   100,   161,    -1,    36,   127,   100,   161,    -1,
      40,   100,   161,    -1,    81,    82,    -1,    81,   164,    82,
      -1,   165,    -1,   164,   165,    -1,   128,    -1,   161,    -1,
     102,    -1,   126,   102,    -1,    50,    79,   126,    80,   161,
      -1,    50,    79,   126,    80,   161,    43,   161,    -1,    62,
      79,   126,    80,   161,    -1,    68,    79,   126,    80,   161,
      -1,    41,   161,    68,    79,   126,    80,   102,    -1,    48,
      79,   102,   102,    80,   161,    -1,    48,    79,   126,   102,
     102,    80,   161,    -1,    48,    79,   102,   126,   102,    80,
     161,    -1,    48,    79,   126,   102,   126,   102,    80,   161,
      -1,    48,    79,   102,   102,   126,    80,   161,    -1,    48,
      79,   126,   102,   102,   126,    80,   161,    -1,    48,    79,
     102,   126,   102,   126,    80,   161,    -1,    48,    79,   126,
     102,   126,   102,   126,    80,   161,    -1,    49,   107,   102,
      -1,    39,   102,    -1,    35,   102,    -1,    56,   102,    -1,
      56,   126,   102,    -1,   171,    -1,   170,   171,    -1,   172,
      -1,   128,    -1,   179,    -1,   129,   148,   173,   163,    -1,
     129,   148,   163,    -1,   128,    -1,   173,   128,    -1,    69,
      -1,    70,    -1,   174,    79,   154,    80,    -1,   175,   127,
      -1,    71,    -1,    72,    -1,    73,    -1,    74,    -1,    75,
      -1,    76,    -1,    77,    -1,    78,    -1,   176,    -1,   177,
      -1,   178,    -1,     1,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   304,   304,   313,   329,   335,   342,   343,   347,   355,
     370,   384,   391,   392,   396,   397,   401,   405,   409,   413,
     417,   421,   428,   429,   433,   434,   438,   442,   465,   472,
     479,   483,   491,   495,   499,   503,   507,   511,   518,   519,
     531,   532,   538,   546,   557,   558,   564,   573,   574,   586,
     595,   596,   602,   608,   614,   623,   624,   630,   639,   640,
     649,   650,   659,   660,   669,   670,   681,   682,   693,   694,
     701,   702,   709,   710,   711,   712,   713,   714,   715,   716,
     717,   718,   719,   723,   724,   725,   732,   738,   756,   763,
     768,   773,   786,   787,   792,   797,   802,   810,   814,   821,
     822,   826,   830,   834,   838,   842,   849,   853,   857,   861,
     865,   869,   873,   877,   881,   885,   889,   890,   891,   899,
     919,   924,   932,   937,   945,   946,   953,   973,   978,   979,
     984,   992,   996,  1004,  1007,  1008,  1012,  1023,  1030,  1037,
    1044,  1051,  1058,  1067,  1067,  1076,  1084,  1092,  1104,  1108,
    1112,  1116,  1123,  1130,  1135,  1139,  1144,  1148,  1153,  1158,
    1168,  1175,  1184,  1189,  1193,  1204,  1217,  1218,  1225,  1229,
    1236,  1241,  1246,  1251,  1258,  1264,  1273,  1274,  1278,  1283,
    1284,  1292,  1296,  1301,  1306,  1311,  1316,  1322,  1332,  1338,
    1351,  1358,  1359,  1360,  1364,  1365,  1371,  1372,  1373,  1374,
    1375,  1376,  1380,  1381,  1382,  1386,  1387,  1391,  1392,  1396,
    1397,  1401,  1402,  1406,  1407,  1408,  1412,  1413,  1414,  1415,
    1416,  1417,  1418,  1419,  1420,  1421,  1425,  1426,  1427,  1428,
    1429,  1435,  1436,  1440,  1441,  1442,  1446,  1447,  1451,  1452,
    1458,  1465,  1472,  1476,  1487,  1492,  1497,  1502,  1507,  1512,
    1519,  1524,  1532,  1533,  1534,  1535
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 1
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "\"identifier\"", "\"typedef-name\"",
  "INTEGER", "FLOATING", "CHARACTER", "STRING", "INTL_CONST",
  "INTUL_CONST", "ELLIPSIS", "ADDEQ", "SUBEQ", "MULEQ", "DIVEQ", "MODEQ",
  "XOREQ", "ANDEQ", "OREQ", "SL", "SR", "SLEQ", "SREQ", "EQ", "NOTEQ",
  "LTEQ", "GTEQ", "ANDAND", "OROR", "PLUSPLUS", "MINUSMINUS", "ARROW",
  "AUTO", "BOOL", "BREAK", "CASE", "CHAR", "CONST", "CONTINUE", "DEFAULT",
  "DO", "DOUBLE", "ELSE", "ENUM", "EXTENSION", "EXTERN", "FLOAT", "FOR",
  "GOTO", "IF", "INLINE", "INT", "LONG", "REGISTER", "RESTRICT", "RETURN",
  "SHORT", "SIGNED", "SIZEOF", "STATIC", "STRUCT", "SWITCH", "TYPEDEF",
  "UNION", "UNSIGNED", "VOID", "VOLATILE", "WHILE", "FUNCTION_MACRO",
  "OBJECT_MACRO", "IFDEF_GI_SCANNER", "IFNDEF_GI_SCANNER", "IFDEF_COND",
  "IFNDEF_COND", "IF_COND", "ELIF_COND", "ELSE_COND", "ENDIF_COND", "'('",
  "')'", "'{'", "'}'", "'['", "']'", "'.'", "','", "'&'", "'*'", "'+'",
  "'-'", "'~'", "'!'", "'/'", "'%'", "'<'", "'>'", "'^'", "'|'", "'?'",
  "':'", "'='", "';'", "$accept", "primary_expression", "strings",
  "identifier", "identifier_or_typedef_name", "postfix_expression",
  "argument_expression_list", "unary_expression", "unary_operator",
  "cast_expression", "multiplicative_expression", "additive_expression",
  "shift_expression", "relational_expression", "equality_expression",
  "and_expression", "exclusive_or_expression", "inclusive_or_expression",
  "logical_and_expression", "logical_or_expression",
  "conditional_expression", "assignment_expression", "assignment_operator",
  "expression", "constant_expression", "declaration",
  "declaration_specifiers", "init_declarator_list", "init_declarator",
  "storage_class_specifier", "type_specifier", "struct_or_union_specifier",
  "struct_or_union", "struct_declaration_list", "struct_declaration",
  "specifier_qualifier_list", "struct_declarator_list",
  "struct_declarator", "enum_specifier", "enum_keyword", "enumerator_list",
  "$@1", "enumerator", "type_qualifier", "function_specifier",
  "declarator", "direct_declarator", "pointer", "type_qualifier_list",
  "parameter_list", "parameter_declaration", "identifier_list",
  "type_name", "abstract_declarator", "direct_abstract_declarator",
  "typedef_name", "initializer", "initializer_list", "statement",
  "labeled_statement", "compound_statement", "block_item_list",
  "block_item", "expression_statement", "selection_statement",
  "iteration_statement", "jump_statement", "translation_unit",
  "external_declaration", "function_definition", "declaration_list",
  "function_macro", "object_macro", "function_macro_define",
  "object_macro_define", "preproc_conditional", "macro", YY_NULL
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,    40,
      41,   123,   125,    91,    93,    46,    44,    38,    42,    43,
      45,   126,    33,    47,    37,    60,    62,    94,   124,    63,
      58,    61,    59
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   103,   104,   104,   104,   104,   104,   104,   104,   105,
     105,   106,   107,   107,   108,   108,   108,   108,   108,   108,
     108,   108,   109,   109,   110,   110,   110,   110,   110,   110,
     110,   110,   111,   111,   111,   111,   111,   111,   112,   112,
     113,   113,   113,   113,   114,   114,   114,   115,   115,   115,
     116,   116,   116,   116,   116,   117,   117,   117,   118,   118,
     119,   119,   120,   120,   121,   121,   122,   122,   123,   123,
     124,   124,   125,   125,   125,   125,   125,   125,   125,   125,
     125,   125,   125,   126,   126,   126,   127,   128,   128,   129,
     129,   129,   129,   129,   129,   129,   129,   130,   130,   131,
     131,   132,   132,   132,   132,   132,   133,   133,   133,   133,
     133,   133,   133,   133,   133,   133,   133,   133,   133,   134,
     134,   134,   135,   135,   136,   136,   137,   138,   138,   138,
     138,   139,   139,   140,   140,   140,   140,   141,   141,   141,
     141,   141,   142,   144,   143,   143,   145,   145,   146,   146,
     146,   146,   147,   148,   148,   149,   149,   149,   149,   149,
     149,   149,   150,   150,   150,   150,   151,   151,   152,   152,
     153,   153,   153,   153,   154,   154,   155,   155,   156,   156,
     156,   157,   157,   157,   157,   157,   157,   157,   157,   157,
     158,   159,   159,   159,   160,   160,   161,   161,   161,   161,
     161,   161,   162,   162,   162,   163,   163,   164,   164,   165,
     165,   166,   166,   167,   167,   167,   168,   168,   168,   168,
     168,   168,   168,   168,   168,   168,   169,   169,   169,   169,
     169,   170,   170,   171,   171,   171,   172,   172,   173,   173,
     174,   175,   176,   177,   178,   178,   178,   178,   178,   178,
     178,   178,   179,   179,   179,   179
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     3,     6,     1,
       2,     1,     1,     1,     1,     4,     4,     3,     3,     3,
       2,     2,     1,     3,     1,     2,     2,     2,     4,     4,
       2,     4,     1,     1,     1,     1,     1,     1,     1,     4,
       1,     3,     3,     3,     1,     3,     3,     1,     3,     3,
       1,     3,     3,     3,     3,     1,     3,     3,     1,     3,
       1,     3,     1,     3,     1,     3,     1,     3,     1,     5,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     2,     1,     3,     2,     2,
       1,     2,     1,     2,     1,     2,     1,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     5,
       4,     2,     1,     1,     1,     2,     3,     2,     1,     2,
       1,     1,     3,     0,     1,     2,     3,     5,     4,     6,
       5,     2,     1,     0,     2,     3,     1,     3,     1,     1,
       1,     1,     1,     2,     1,     1,     3,     4,     3,     4,
       4,     3,     2,     1,     3,     2,     1,     2,     1,     3,
       2,     2,     1,     1,     1,     3,     1,     2,     1,     1,
       2,     3,     2,     3,     3,     4,     2,     3,     3,     4,
       1,     1,     3,     4,     1,     3,     1,     1,     1,     1,
       1,     1,     3,     4,     3,     2,     3,     1,     2,     1,
       1,     1,     2,     5,     7,     5,     5,     7,     6,     7,
       7,     8,     7,     8,     8,     9,     3,     2,     2,     2,
       3,     1,     2,     1,     1,     1,     4,     3,     1,     2,
       1,     1,     4,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       0,   255,   190,   104,   115,   107,   148,   112,   142,   150,
     102,   111,   152,   109,   110,   105,   149,   108,   113,   103,
     122,   101,   123,   114,   106,   151,   240,   241,   244,   245,
     246,   247,   248,   249,   250,   251,   234,     0,    90,    92,
     116,     0,   117,     0,    94,    96,   118,     0,   231,   233,
       0,     0,   252,   253,   254,   235,    11,     0,   163,    88,
     155,     0,    97,    99,   154,     0,    89,    91,     0,    12,
     121,    13,   143,   141,    93,    95,     1,   232,     0,     3,
       5,     4,     9,     0,     0,     0,     0,     0,     0,     0,
      32,    33,    34,    35,    36,    37,    14,     6,     2,    24,
      38,     0,    40,    44,    47,    50,    55,    58,    60,    62,
      64,    66,    68,    86,   243,     0,   166,   165,   162,     0,
      87,     0,     0,   238,     0,   237,     0,     0,     0,   153,
     128,     0,   124,   133,   130,     0,     0,     0,   143,   174,
       0,     0,     0,     0,    25,    26,     0,     0,    30,   150,
      38,    70,    83,     0,   176,     0,    10,    20,    21,     0,
       0,     0,     0,    27,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   156,   167,   164,    98,    99,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
     211,     2,     0,     0,   209,   118,   210,   196,   197,     0,
     207,   198,   199,   200,   201,     0,   191,   100,   239,   236,
     173,   161,   172,     0,   168,     0,   158,     0,   127,   120,
     125,     0,     0,   131,   134,   129,     0,   138,     0,   146,
     144,     0,   242,     0,     0,     0,     0,     0,     0,     0,
      85,    76,    77,    73,    74,    75,    81,    80,    82,    78,
      79,    72,     0,     7,     0,     0,     0,   178,   177,   179,
       0,    19,    17,     0,    22,     0,    18,    41,    42,    43,
      45,    46,    48,    49,    53,    54,    51,    52,    56,    57,
      59,    61,    63,    65,    67,     0,   228,     0,   227,     0,
       0,     0,     0,     0,   229,     0,     0,     0,     0,   212,
     206,   208,   194,     0,     0,   170,   178,   171,   159,     0,
     160,   157,   135,   133,   126,     0,   119,   140,   145,     0,
     137,     0,   175,    28,    29,     0,    31,    71,    84,   186,
       0,     0,   182,     0,   180,     0,     0,    39,    16,     0,
      15,     0,     0,   204,     0,     0,     0,   226,     0,   230,
       0,     0,   202,   192,     0,   169,   132,   136,   147,   139,
       0,   187,   181,   183,   188,     0,   184,     0,    23,    69,
     203,     0,     0,     0,     0,     0,     0,     0,   193,   195,
       8,   189,   185,     0,     0,     0,     0,     0,     0,   213,
     215,   216,     0,   218,     0,     0,     0,     0,     0,     0,
       0,   217,   222,   220,     0,   219,     0,     0,     0,   214,
     224,   223,   221,     0,   225
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    96,    97,    98,   202,    99,   273,   150,   101,   102,
     103,   104,   105,   106,   107,   108,   109,   110,   111,   112,
     151,   152,   262,   203,   114,   204,   124,    61,    62,    38,
      39,    40,    41,   131,   132,   133,   232,   233,    42,    43,
     136,   137,   328,    44,    45,   115,    64,    65,   118,   340,
     224,   140,   155,   341,   269,    46,   217,   313,   206,   207,
     208,   209,   210,   211,   212,   213,   214,    47,    48,    49,
     126,    50,    51,    52,    53,    54,    55
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -249
static const yytype_int16 yypact[] =
{
    2259,  -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,
    -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,
    -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,
    -249,  -249,  -249,  -249,  -249,  -249,  -249,    15,  2489,  2489,
    -249,    34,  -249,    39,  2489,  2489,  -249,  2139,  -249,  -249,
     -54,  1761,  -249,  -249,  -249,  -249,  -249,    47,   177,  -249,
    -249,   -39,  -249,  1086,   -22,    37,  -249,  -249,  2524,  -249,
     -10,  -249,  -249,     2,  -249,  -249,  -249,  -249,    85,  -249,
    -249,  -249,  -249,    60,    77,  1802,  1802,    80,  1857,  1216,
    -249,  -249,  -249,  -249,  -249,  -249,  -249,   168,  -249,   156,
    -249,  1761,  -249,    43,   -56,   246,    97,   245,   103,    67,
     106,   181,     6,  -249,  -249,   138,  -249,  -249,   177,    47,
    -249,   467,  1322,  -249,    15,  -249,  2372,  2335,  1377,   -22,
    2524,  2184,  -249,    33,  2524,  2524,    93,    85,  -249,  -249,
      -5,  1802,  1802,  1898,  -249,  -249,   166,  1216,  -249,  1953,
     211,  -249,  -249,    74,    62,   170,  -249,  -249,  -249,   270,
    1418,  1898,   270,  -249,  1761,  1761,  1761,  1761,  1761,  1761,
    1761,  1761,  1761,  1761,  1761,  1761,  1761,  1761,  1761,  1761,
    1761,  1761,  1898,  -249,  -249,  -249,  -249,   184,   173,  1761,
     185,   178,   816,   220,   270,   225,   880,   227,   228,  -249,
    -249,   209,   214,   -38,  -249,   217,  -249,  -249,  -249,   568,
    -249,  -249,  -249,  -249,  -249,  1322,  -249,  -249,  -249,  -249,
    -249,  -249,    64,    87,  -249,    91,  -249,   234,  -249,  -249,
    -249,  1761,   -28,  -249,   230,  -249,  2220,  -249,    13,   224,
    -249,   134,  -249,    85,   247,   248,  1953,   748,   253,  1151,
     249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,  -249,
    -249,  -249,  1761,  -249,  1761,  2071,  1473,   159,  -249,   176,
    1761,  -249,  -249,    94,  -249,   -24,  -249,  -249,  -249,  -249,
      43,    43,   -56,   -56,   246,   246,   246,   246,    97,    97,
     245,   103,    67,   106,   181,   -30,  -249,   236,  -249,   816,
     269,   921,   237,  1898,  -249,   -17,  1898,  1898,   816,  -249,
    -249,  -249,  -249,   182,  2013,  -249,    23,  -249,  -249,  2454,
    -249,  -249,  -249,    33,  -249,  1761,  -249,  -249,  -249,  1761,
    -249,    26,  -249,  -249,  -249,   658,  -249,  -249,  -249,  -249,
     109,   258,  -249,   256,   176,  2417,  1514,  -249,  -249,  1761,
    -249,  1898,   816,  -249,   263,   984,    27,  -249,   114,  -249,
     117,   122,  -249,  -249,  1281,  -249,  -249,  -249,  -249,  -249,
     264,  -249,  -249,  -249,  -249,   131,  -249,   259,  -249,   249,
    -249,  1898,  1569,    42,  1025,   816,   816,   816,  -249,  -249,
    -249,  -249,  -249,   133,   816,   151,  1610,  1665,    56,   302,
    -249,  -249,   260,  -249,   816,   816,   160,   816,   163,  1706,
     816,  -249,  -249,  -249,   816,  -249,   816,   816,   174,  -249,
    -249,  -249,  -249,   816,  -249
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -249,  -249,  -249,   -37,   -32,  -249,  -249,   268,  -249,   -86,
     128,   120,   110,   127,   183,   180,   172,   175,   190,  -249,
     -49,  -101,  -249,   -50,  -176,    44,     7,  -249,   242,  -249,
     -58,  -249,  -249,   229,  -117,   -81,  -249,    40,  -249,  -249,
     240,  -249,   235,   332,  -249,   -15,   -64,   -53,  -249,  -124,
      46,   239,   238,  -130,  -248,   -11,  -198,  -249,   -94,  -249,
     -40,   135,  -197,  -249,  -249,  -249,  -249,  -249,   334,  -249,
    -249,  -249,  -249,  -249,  -249,  -249,  -249
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -14
static const yytype_int16 yytable[] =
{
      60,   129,   113,   223,    69,   117,    69,    37,   154,    70,
     130,    73,   311,   297,   230,   163,    56,   312,    56,   344,
      60,   216,    63,   125,   268,    78,    56,   227,    60,    56,
      71,   130,    71,   167,   168,   181,    56,    56,     2,   153,
      56,   139,    56,     2,    36,    66,    67,   119,   264,   228,
      56,    74,    75,   235,    37,   322,   264,   127,   323,   274,
     350,   128,   264,   120,   309,   185,   154,    56,   344,   264,
     351,   135,   130,   130,   324,   242,   130,   130,   277,   278,
     279,   243,    60,   138,   201,   359,   219,    60,    56,   130,
     139,    36,   317,   153,    57,   327,    60,   153,   300,   250,
     239,   267,   314,    58,   187,   182,   266,   123,   369,   187,
     205,   275,    57,   264,   216,    68,    57,    59,   234,   230,
      72,    58,    69,   171,   172,    69,    57,   271,   264,   384,
     276,   164,   295,   231,   222,    58,   165,   166,   311,   141,
     113,   265,   264,   314,   396,   266,   305,   266,    71,   367,
      58,    71,    58,   368,   263,   201,   142,    69,   409,   146,
     264,   337,   302,   338,   178,   343,   389,   318,   154,   316,
     218,   320,   201,   319,   348,   237,   156,   243,   130,   238,
     349,    71,   113,    71,   347,    60,   157,   158,   159,   371,
     177,   130,   173,   174,   385,   319,   250,   386,   205,   153,
     264,   239,   387,   264,   179,   353,   332,   315,   264,   180,
     201,   391,   267,   402,   362,     6,   330,   319,   183,   264,
     331,   375,     9,   251,   252,   253,   254,   255,   256,   257,
     258,   404,    16,   259,   260,   160,   205,   264,   265,   161,
     414,   162,   266,   416,    25,   377,   264,   247,   378,   264,
     270,   356,   129,   358,   423,   345,   360,   361,   380,   346,
     264,   316,   201,   216,   363,    58,   169,   170,   364,   175,
     176,   201,   222,    56,     2,   296,   113,    60,   299,    60,
     113,   284,   285,   286,   287,   122,    60,   298,    71,   282,
     283,   399,   400,   401,   239,   280,   281,    71,   201,   301,
     403,   379,   288,   289,   303,   383,   306,   307,   234,   -12,
     412,   413,   261,   415,   308,   201,   419,   -13,   321,   100,
     420,   222,   421,   422,   205,   329,   222,   333,   334,   424,
     325,   393,   395,   336,   398,   264,   352,   354,   372,   357,
     373,    71,   381,   392,   390,   410,   406,   408,   201,   201,
     201,   292,   222,   144,   145,   293,   148,   201,   291,   418,
     290,   186,   411,   366,   236,   365,   225,   201,   201,   100,
     201,   294,   240,   201,    71,    71,    71,   201,   241,   201,
     201,    77,   335,    71,     0,   248,   201,     0,     0,     0,
     116,     0,     0,    71,    71,     0,    71,     0,     0,    71,
     134,     0,     0,    71,     0,    71,    71,     0,     0,   244,
     245,     0,    71,     0,     0,     0,     0,     0,     0,     0,
       0,   134,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   100,   100,   100,   100,   100,   100,   100,   100,
     100,   100,   100,   100,   100,   100,   100,   100,   100,   100,
     184,     0,     0,     0,     0,     0,     0,   100,     0,     0,
       0,     0,   134,   134,     0,     0,   134,   134,     0,     0,
      56,     2,    79,    80,    81,    82,    83,    84,     0,   134,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    85,    86,   100,
       3,     4,   188,   189,     5,     6,   190,   191,   192,     7,
       0,     8,   149,    10,    11,   193,   194,   195,    12,    13,
      14,    15,    16,   196,    17,    18,    88,    19,    20,   197,
      21,    22,    23,    24,    25,   198,     0,     0,   100,     0,
       0,     0,     0,     0,     0,     0,    89,     0,   121,   199,
       0,     0,     0,     0,    90,    91,    92,    93,    94,    95,
       0,     0,     0,     0,     0,     0,     0,     0,   134,   200,
       0,    56,     2,    79,    80,    81,    82,    83,    84,     0,
       0,   134,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   100,     0,     0,     0,   100,    85,    86,
       0,     3,     4,   188,   189,     5,     6,   190,   191,   192,
       7,     0,     8,   149,    10,    11,   193,   194,   195,    12,
      13,    14,    15,    16,   196,    17,    18,    88,    19,    20,
     197,    21,    22,    23,    24,    25,   198,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    89,     0,   121,
     310,     0,     0,     0,     0,    90,    91,    92,    93,    94,
      95,    56,     2,    79,    80,    81,    82,    83,    84,     0,
     200,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    85,    86,
       0,     3,     4,   188,   189,     5,     6,   190,   191,   192,
       7,     0,     8,   149,    10,    11,   193,   194,   195,    12,
      13,    14,    15,    16,   196,    17,    18,    88,    19,    20,
     197,    21,    22,    23,    24,    25,   198,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    89,     0,   121,
     370,     0,     0,     0,     0,    90,    91,    92,    93,    94,
      95,    56,     2,    79,    80,    81,    82,    83,    84,     0,
     200,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    85,    86,
       0,     3,     4,   188,   189,     5,     6,   190,   191,   192,
       7,     0,     8,   149,    10,    11,   193,   194,   195,    12,
      13,    14,    15,    16,   196,    17,    18,    88,    19,    20,
     197,    21,    22,    23,    24,    25,   198,     0,     0,    56,
       2,    79,    80,    81,    82,    83,    84,    89,     0,   121,
       0,     0,     0,     0,     0,    90,    91,    92,    93,    94,
      95,     0,     0,     0,     0,     0,    85,    86,     0,     0,
     200,   188,   189,     0,     0,   190,   191,   192,     0,     0,
       0,   246,     0,     0,   193,   194,   195,     0,     0,     0,
       0,     0,   196,     0,     0,    88,     0,     0,   197,     0,
       0,     0,     0,    56,   198,    79,    80,    81,    82,    83,
      84,     0,     0,     0,     0,    89,     0,   121,     0,     0,
       0,     0,     0,    90,    91,    92,    93,    94,    95,     0,
      85,    86,     0,     0,     0,     0,     0,     0,   200,     0,
       0,     0,     0,     0,    56,   246,    79,    80,    81,    82,
      83,    84,     0,     0,     0,     0,     0,     0,     0,    88,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    85,    86,     0,     0,     0,     0,     0,     0,    89,
       0,     0,     0,     0,     0,     0,   246,    90,    91,    92,
      93,    94,    95,     0,     0,     0,     0,     0,     0,     0,
      88,     0,   304,     0,     0,     0,     0,    56,     0,    79,
      80,    81,    82,    83,    84,     0,     0,     0,     0,     0,
      89,     0,     0,     0,     0,     0,     0,     0,    90,    91,
      92,    93,    94,    95,    85,    86,     0,     0,     0,     0,
       0,     0,     0,   355,     0,     0,     0,     0,    56,   246,
      79,    80,    81,    82,    83,    84,     0,     0,     0,     0,
       0,     0,     0,    88,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    85,    86,     0,     0,     0,
       0,     0,     0,    89,     0,     0,     0,     0,     0,     0,
     246,    90,    91,    92,    93,    94,    95,     0,     0,     0,
       0,     0,     0,     0,    88,     0,   382,     0,     0,     0,
       2,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    89,     0,     0,     0,     0,     0,
       0,     0,    90,    91,    92,    93,    94,    95,     0,     3,
       4,     0,     0,     5,     6,     0,     0,   397,     7,     0,
       8,     9,    10,    11,     0,     0,     0,    12,    13,    14,
      15,    16,     0,    17,    18,     0,    19,    20,     0,    21,
      22,    23,    24,    25,    56,     2,    79,    80,    81,    82,
      83,    84,     0,     0,     0,     0,     0,   121,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    85,    86,     0,     0,     4,     0,   122,     5,     6,
       0,     0,     0,     7,     0,     8,   149,     0,    11,     0,
       0,     0,     0,    13,    14,     0,    16,     0,    17,    18,
      88,     0,    20,     0,     0,    22,    23,    24,    25,    56,
       2,    79,    80,    81,    82,    83,    84,     0,     0,     0,
      89,     0,   247,     0,     0,     0,     0,     0,    90,    91,
      92,    93,    94,    95,     0,     0,    85,    86,     0,     0,
       4,     0,     0,     5,     6,     0,     0,     0,     7,     0,
       8,   149,     0,    11,     0,     0,     0,     0,    13,    14,
       0,    16,     0,    17,    18,    88,     0,    20,     0,     0,
      22,    23,    24,    25,    56,     0,    79,    80,    81,    82,
      83,    84,     0,     0,     0,    89,     0,     0,     0,     0,
       0,     0,     0,    90,    91,    92,    93,    94,    95,     0,
       0,    85,    86,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    56,    87,    79,    80,    81,
      82,    83,    84,     0,     0,     0,     0,     0,     0,     0,
      88,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    85,    86,     0,     0,     0,     0,     0,     0,
      89,     0,   215,   388,     0,     0,     0,    87,    90,    91,
      92,    93,    94,    95,     0,     0,     0,     0,     0,     0,
      56,    88,    79,    80,    81,    82,    83,    84,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    89,     0,   215,     0,     0,     0,    85,    86,    90,
      91,    92,    93,    94,    95,     0,     0,     0,     0,     0,
       0,    56,    87,    79,    80,    81,    82,    83,    84,     0,
       0,     0,     0,     0,     0,     0,    88,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    85,    86,
       0,     0,     0,     0,     0,     0,    89,     0,     0,     0,
       0,   226,     0,    87,    90,    91,    92,    93,    94,    95,
       0,     0,     0,     0,     0,     0,    56,    88,    79,    80,
      81,    82,    83,    84,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    89,   272,     0,
       0,     0,     0,    85,    86,    90,    91,    92,    93,    94,
      95,     0,     0,     0,     0,     0,     0,    56,    87,    79,
      80,    81,    82,    83,    84,     0,     0,     0,     0,     0,
       0,     0,    88,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    85,    86,     0,     0,     0,     0,
       0,     0,    89,     0,     0,     0,     0,   342,     0,    87,
      90,    91,    92,    93,    94,    95,     0,     0,     0,     0,
       0,     0,    56,    88,    79,    80,    81,    82,    83,    84,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    89,     0,     0,     0,     0,   376,    85,
      86,    90,    91,    92,    93,    94,    95,     0,     0,     0,
       0,     0,     0,    56,   246,    79,    80,    81,    82,    83,
      84,     0,     0,     0,     0,     0,     0,     0,    88,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      85,    86,     0,     0,     0,     0,     0,     0,    89,   394,
       0,     0,     0,     0,     0,   246,    90,    91,    92,    93,
      94,    95,     0,     0,     0,     0,     0,     0,    56,    88,
      79,    80,    81,    82,    83,    84,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    89,
     405,     0,     0,     0,     0,    85,    86,    90,    91,    92,
      93,    94,    95,     0,     0,     0,     0,     0,     0,    56,
     246,    79,    80,    81,    82,    83,    84,     0,     0,     0,
       0,     0,     0,     0,    88,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    85,    86,     0,     0,
       0,     0,     0,     0,    89,   407,     0,     0,     0,     0,
       0,   246,    90,    91,    92,    93,    94,    95,     0,     0,
       0,     0,     0,     0,    56,    88,    79,    80,    81,    82,
      83,    84,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    89,   417,     0,     0,     0,
       0,    85,    86,    90,    91,    92,    93,    94,    95,     0,
       0,     0,     0,     0,     0,    56,    87,    79,    80,    81,
      82,    83,    84,     0,     0,     0,     0,     0,     0,     0,
      88,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    85,    86,     0,     0,     0,     0,     0,     0,
      89,     0,     0,     0,     0,     0,     0,    87,    90,    91,
      92,    93,    94,    95,     0,     0,     0,     0,     0,     0,
      56,    88,    79,    80,    81,    82,    83,    84,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   143,     0,     0,     0,     0,     0,    85,    86,    90,
      91,    92,    93,    94,    95,     0,     0,     0,     0,     0,
       0,    56,    87,    79,    80,    81,    82,    83,    84,     0,
       0,     0,     0,     0,     0,     0,    88,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    85,    86,
       0,     0,     0,     0,     0,     0,   147,     0,     0,     0,
       0,     0,     0,   246,    90,    91,    92,    93,    94,    95,
       0,     0,     0,     0,     0,     0,    56,    88,    79,    80,
      81,    82,    83,    84,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    89,     0,     0,
       0,     0,     0,    85,    86,    90,    91,    92,    93,    94,
      95,     0,     0,     0,     0,     0,     0,     0,   246,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    88,     0,     0,     0,    56,     2,     0,     0,
       0,     0,     0,     0,   220,     0,     0,     0,     0,     0,
       0,     0,   249,     0,     0,     0,     0,     0,     0,     0,
      90,    91,    92,    93,    94,    95,     3,     4,     0,     0,
       5,     6,     0,     0,     0,     7,     0,     8,     9,    10,
      11,     0,     0,     0,    12,    13,    14,    15,    16,     0,
      17,    18,     0,    19,    20,     2,    21,    22,    23,    24,
      25,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   314,   339,     0,     0,   266,     0,     0,     0,
       0,    58,     0,     0,     3,     4,     0,     0,     5,     6,
       0,     0,     0,     7,     0,     8,     9,    10,    11,     0,
       0,     0,    12,    13,    14,    15,    16,     0,    17,    18,
       0,    19,    20,     0,    21,    22,    23,    24,    25,    76,
       1,     0,     0,     2,     0,     0,     0,     0,     0,     0,
     265,   339,     0,     0,   266,     0,     0,     0,     0,    58,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     3,     4,     0,     0,     5,     6,     0,     0,
       0,     7,     0,     8,     9,    10,    11,     0,     2,     0,
      12,    13,    14,    15,    16,     0,    17,    18,     0,    19,
      20,     0,    21,    22,    23,    24,    25,     0,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,     4,     0,
       0,     5,     6,     0,     2,     0,     7,     0,     8,     9,
       0,    11,     0,     0,     0,     0,    13,    14,     0,    16,
       0,    17,    18,     0,     0,    20,     0,     0,    22,    23,
      24,    25,     0,     0,     4,     0,     0,     5,     6,     0,
       1,     0,     7,     2,     8,     9,   229,    11,     0,     0,
       0,     0,    13,    14,     0,    16,     0,    17,    18,     0,
       0,    20,     0,     0,    22,    23,    24,    25,     0,     0,
       0,     0,     3,     4,     0,     0,     5,     6,     0,     0,
       0,     7,   326,     8,     9,    10,    11,     0,     0,     0,
      12,    13,    14,    15,    16,     0,    17,    18,     0,    19,
      20,     0,    21,    22,    23,    24,    25,     0,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    56,     2,
       0,     0,     0,     0,     0,     0,   220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     3,     4,
       0,     0,     5,     6,     0,     0,     2,     7,     0,     8,
       9,    10,    11,     0,     0,     0,    12,    13,    14,    15,
      16,     0,    17,    18,     0,    19,    20,     0,    21,    22,
      23,    24,    25,     0,     0,     3,     4,     0,     0,     5,
       6,     0,     0,     0,     7,   221,     8,     9,    10,    11,
       0,     2,     0,    12,    13,    14,    15,    16,   220,    17,
      18,     0,    19,    20,     0,    21,    22,    23,    24,    25,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       3,     4,     0,   121,     5,     6,     0,     0,     2,     7,
       0,     8,     9,    10,    11,   220,     0,     0,    12,    13,
      14,    15,    16,     0,    17,    18,     0,    19,    20,     0,
      21,    22,    23,    24,    25,     0,     0,     3,     4,     0,
       0,     5,     6,     2,     0,     0,     7,   374,     8,     9,
      10,    11,     0,     0,     0,    12,    13,    14,    15,    16,
       0,    17,    18,     0,    19,    20,     0,    21,    22,    23,
      24,    25,     3,     4,     0,     0,     5,     6,     2,     0,
       0,     7,     0,     8,     9,    10,    11,     0,     0,     0,
      12,    13,    14,    15,    16,     0,    17,    18,     0,    19,
      20,     0,    21,    22,    23,    24,    25,     0,     4,     0,
       0,     5,     6,     0,     0,     0,     7,     0,     8,     9,
       0,    11,     0,     0,     0,     0,    13,    14,     0,    16,
       0,    17,    18,     0,     0,    20,     0,     0,    22,    23,
      24,    25
};

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-249)))

#define yytable_value_is_error(Yytable_value) \
  YYID (0)

static const yytype_int16 yycheck[] =
{
      37,    65,    51,   127,    41,    58,    43,     0,    89,    41,
      68,    43,   209,   189,   131,   101,     3,   215,     3,   267,
      57,   122,    37,    63,   154,    79,     3,   128,    65,     3,
      41,    89,    43,    89,    90,    29,     3,     3,     4,    89,
       3,    78,     3,     4,     0,    38,    39,    86,    86,   130,
       3,    44,    45,   134,    47,   231,    86,    79,    86,   160,
      84,    83,    86,   102,   102,   118,   147,     3,   316,    86,
     100,    81,   130,   131,   102,    80,   134,   135,   164,   165,
     166,    86,   119,    81,   121,   102,   126,   124,     3,   147,
     127,    47,   222,   143,    79,    82,   133,   147,   192,   149,
     137,   154,    79,    88,   119,    99,    83,    63,    82,   124,
     121,   161,    79,    86,   215,    81,    79,   102,   133,   236,
      81,    88,   159,    26,    27,   162,    79,   159,    86,   102,
     162,    88,   182,   100,   127,    88,    93,    94,   335,    79,
     189,    79,    86,    79,   102,    83,   196,    83,   159,   325,
      88,   162,    88,   329,    80,   192,    79,   194,   102,    79,
      86,   262,   194,   264,    97,   266,   364,    80,   249,   222,
     126,    80,   209,    86,    80,    82,     8,    86,   236,    86,
      86,   192,   231,   194,   270,   222,    30,    31,    32,    80,
      87,   249,    95,    96,    80,    86,   246,    80,   209,   249,
      86,   238,    80,    86,    98,   299,   243,   222,    86,    28,
     247,    80,   265,    80,   308,    38,    82,    86,    80,    86,
      86,   345,    45,    12,    13,    14,    15,    16,    17,    18,
      19,    80,    55,    22,    23,    79,   247,    86,    79,    83,
      80,    85,    83,    80,    67,   346,    86,    81,   349,    86,
      80,   301,   316,   303,    80,    79,   306,   307,   352,    83,
      86,   314,   299,   364,    82,    88,    20,    21,    86,    24,
      25,   308,   265,     3,     4,   102,   325,   314,   100,   316,
     329,   171,   172,   173,   174,   101,   323,   102,   299,   169,
     170,   385,   386,   387,   331,   167,   168,   308,   335,    79,
     394,   351,   175,   176,    79,   355,    79,    79,   323,   100,
     404,   405,   101,   407,   100,   352,   410,   100,    84,    51,
     414,   314,   416,   417,   335,   101,   319,    80,    80,   423,
     100,   381,   382,    80,   384,    86,   100,    68,    80,   102,
      84,   352,    79,    84,    80,    43,   396,   397,   385,   386,
     387,   179,   345,    85,    86,   180,    88,   394,   178,   409,
     177,   119,   102,   323,   135,   319,   127,   404,   405,   101,
     407,   181,   137,   410,   385,   386,   387,   414,   138,   416,
     417,    47,   247,   394,    -1,   147,   423,    -1,    -1,    -1,
      58,    -1,    -1,   404,   405,    -1,   407,    -1,    -1,   410,
      68,    -1,    -1,   414,    -1,   416,   417,    -1,    -1,   141,
     142,    -1,   423,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   164,   165,   166,   167,   168,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   180,   181,
     118,    -1,    -1,    -1,    -1,    -1,    -1,   189,    -1,    -1,
      -1,    -1,   130,   131,    -1,    -1,   134,   135,    -1,    -1,
       3,     4,     5,     6,     7,     8,     9,    10,    -1,   147,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    30,    31,   231,
      33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    -1,    -1,   270,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    79,    -1,    81,    82,
      -1,    -1,    -1,    -1,    87,    88,    89,    90,    91,    92,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   236,   102,
      -1,     3,     4,     5,     6,     7,     8,     9,    10,    -1,
      -1,   249,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   325,    -1,    -1,    -1,   329,    30,    31,
      -1,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    -1,    81,
      82,    -1,    -1,    -1,    -1,    87,    88,    89,    90,    91,
      92,     3,     4,     5,     6,     7,     8,     9,    10,    -1,
     102,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    30,    31,
      -1,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    -1,    81,
      82,    -1,    -1,    -1,    -1,    87,    88,    89,    90,    91,
      92,     3,     4,     5,     6,     7,     8,     9,    10,    -1,
     102,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    30,    31,
      -1,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    -1,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    -1,    -1,     3,
       4,     5,     6,     7,     8,     9,    10,    79,    -1,    81,
      -1,    -1,    -1,    -1,    -1,    87,    88,    89,    90,    91,
      92,    -1,    -1,    -1,    -1,    -1,    30,    31,    -1,    -1,
     102,    35,    36,    -1,    -1,    39,    40,    41,    -1,    -1,
      -1,    45,    -1,    -1,    48,    49,    50,    -1,    -1,    -1,
      -1,    -1,    56,    -1,    -1,    59,    -1,    -1,    62,    -1,
      -1,    -1,    -1,     3,    68,     5,     6,     7,     8,     9,
      10,    -1,    -1,    -1,    -1,    79,    -1,    81,    -1,    -1,
      -1,    -1,    -1,    87,    88,    89,    90,    91,    92,    -1,
      30,    31,    -1,    -1,    -1,    -1,    -1,    -1,   102,    -1,
      -1,    -1,    -1,    -1,     3,    45,     5,     6,     7,     8,
       9,    10,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    59,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    30,    31,    -1,    -1,    -1,    -1,    -1,    -1,    79,
      -1,    -1,    -1,    -1,    -1,    -1,    45,    87,    88,    89,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      59,    -1,   102,    -1,    -1,    -1,    -1,     3,    -1,     5,
       6,     7,     8,     9,    10,    -1,    -1,    -1,    -1,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    88,
      89,    90,    91,    92,    30,    31,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,     3,    45,
       5,     6,     7,     8,     9,    10,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    59,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    30,    31,    -1,    -1,    -1,
      -1,    -1,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,
      45,    87,    88,    89,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    59,    -1,   102,    -1,    -1,    -1,
       4,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    79,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    87,    88,    89,    90,    91,    92,    -1,    33,
      34,    -1,    -1,    37,    38,    -1,    -1,   102,    42,    -1,
      44,    45,    46,    47,    -1,    -1,    -1,    51,    52,    53,
      54,    55,    -1,    57,    58,    -1,    60,    61,    -1,    63,
      64,    65,    66,    67,     3,     4,     5,     6,     7,     8,
       9,    10,    -1,    -1,    -1,    -1,    -1,    81,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    30,    31,    -1,    -1,    34,    -1,   101,    37,    38,
      -1,    -1,    -1,    42,    -1,    44,    45,    -1,    47,    -1,
      -1,    -1,    -1,    52,    53,    -1,    55,    -1,    57,    58,
      59,    -1,    61,    -1,    -1,    64,    65,    66,    67,     3,
       4,     5,     6,     7,     8,     9,    10,    -1,    -1,    -1,
      79,    -1,    81,    -1,    -1,    -1,    -1,    -1,    87,    88,
      89,    90,    91,    92,    -1,    -1,    30,    31,    -1,    -1,
      34,    -1,    -1,    37,    38,    -1,    -1,    -1,    42,    -1,
      44,    45,    -1,    47,    -1,    -1,    -1,    -1,    52,    53,
      -1,    55,    -1,    57,    58,    59,    -1,    61,    -1,    -1,
      64,    65,    66,    67,     3,    -1,     5,     6,     7,     8,
       9,    10,    -1,    -1,    -1,    79,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    87,    88,    89,    90,    91,    92,    -1,
      -1,    30,    31,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     3,    45,     5,     6,     7,
       8,     9,    10,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      59,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    30,    31,    -1,    -1,    -1,    -1,    -1,    -1,
      79,    -1,    81,    82,    -1,    -1,    -1,    45,    87,    88,
      89,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
       3,    59,     5,     6,     7,     8,     9,    10,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    79,    -1,    81,    -1,    -1,    -1,    30,    31,    87,
      88,    89,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,     3,    45,     5,     6,     7,     8,     9,    10,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    59,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    30,    31,
      -1,    -1,    -1,    -1,    -1,    -1,    79,    -1,    -1,    -1,
      -1,    84,    -1,    45,    87,    88,    89,    90,    91,    92,
      -1,    -1,    -1,    -1,    -1,    -1,     3,    59,     5,     6,
       7,     8,     9,    10,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,    -1,
      -1,    -1,    -1,    30,    31,    87,    88,    89,    90,    91,
      92,    -1,    -1,    -1,    -1,    -1,    -1,     3,    45,     5,
       6,     7,     8,     9,    10,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    59,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    30,    31,    -1,    -1,    -1,    -1,
      -1,    -1,    79,    -1,    -1,    -1,    -1,    84,    -1,    45,
      87,    88,    89,    90,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,     3,    59,     5,     6,     7,     8,     9,    10,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    79,    -1,    -1,    -1,    -1,    84,    30,
      31,    87,    88,    89,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,     3,    45,     5,     6,     7,     8,     9,
      10,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    59,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      30,    31,    -1,    -1,    -1,    -1,    -1,    -1,    79,    80,
      -1,    -1,    -1,    -1,    -1,    45,    87,    88,    89,    90,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,     3,    59,
       5,     6,     7,     8,     9,    10,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,
      80,    -1,    -1,    -1,    -1,    30,    31,    87,    88,    89,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,     3,
      45,     5,     6,     7,     8,     9,    10,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    59,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    30,    31,    -1,    -1,
      -1,    -1,    -1,    -1,    79,    80,    -1,    -1,    -1,    -1,
      -1,    45,    87,    88,    89,    90,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,     3,    59,     5,     6,     7,     8,
       9,    10,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    79,    80,    -1,    -1,    -1,
      -1,    30,    31,    87,    88,    89,    90,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,     3,    45,     5,     6,     7,
       8,     9,    10,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      59,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    30,    31,    -1,    -1,    -1,    -1,    -1,    -1,
      79,    -1,    -1,    -1,    -1,    -1,    -1,    45,    87,    88,
      89,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
       3,    59,     5,     6,     7,     8,     9,    10,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    79,    -1,    -1,    -1,    -1,    -1,    30,    31,    87,
      88,    89,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,     3,    45,     5,     6,     7,     8,     9,    10,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    59,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    30,    31,
      -1,    -1,    -1,    -1,    -1,    -1,    79,    -1,    -1,    -1,
      -1,    -1,    -1,    45,    87,    88,    89,    90,    91,    92,
      -1,    -1,    -1,    -1,    -1,    -1,     3,    59,     5,     6,
       7,     8,     9,    10,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    79,    -1,    -1,
      -1,    -1,    -1,    30,    31,    87,    88,    89,    90,    91,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    59,    -1,    -1,    -1,     3,     4,    -1,    -1,
      -1,    -1,    -1,    -1,    11,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    79,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      87,    88,    89,    90,    91,    92,    33,    34,    -1,    -1,
      37,    38,    -1,    -1,    -1,    42,    -1,    44,    45,    46,
      47,    -1,    -1,    -1,    51,    52,    53,    54,    55,    -1,
      57,    58,    -1,    60,    61,     4,    63,    64,    65,    66,
      67,    -1,    11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    79,    80,    -1,    -1,    83,    -1,    -1,    -1,
      -1,    88,    -1,    -1,    33,    34,    -1,    -1,    37,    38,
      -1,    -1,    -1,    42,    -1,    44,    45,    46,    47,    -1,
      -1,    -1,    51,    52,    53,    54,    55,    -1,    57,    58,
      -1,    60,    61,    -1,    63,    64,    65,    66,    67,     0,
       1,    -1,    -1,     4,    -1,    -1,    -1,    -1,    -1,    -1,
      79,    80,    -1,    -1,    83,    -1,    -1,    -1,    -1,    88,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    33,    34,    -1,    -1,    37,    38,    -1,    -1,
      -1,    42,    -1,    44,    45,    46,    47,    -1,     4,    -1,
      51,    52,    53,    54,    55,    -1,    57,    58,    -1,    60,
      61,    -1,    63,    64,    65,    66,    67,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    34,    -1,
      -1,    37,    38,    -1,     4,    -1,    42,    -1,    44,    45,
      -1,    47,    -1,    -1,    -1,    -1,    52,    53,    -1,    55,
      -1,    57,    58,    -1,    -1,    61,    -1,    -1,    64,    65,
      66,    67,    -1,    -1,    34,    -1,    -1,    37,    38,    -1,
       1,    -1,    42,     4,    44,    45,    82,    47,    -1,    -1,
      -1,    -1,    52,    53,    -1,    55,    -1,    57,    58,    -1,
      -1,    61,    -1,    -1,    64,    65,    66,    67,    -1,    -1,
      -1,    -1,    33,    34,    -1,    -1,    37,    38,    -1,    -1,
      -1,    42,    82,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    53,    54,    55,    -1,    57,    58,    -1,    60,
      61,    -1,    63,    64,    65,    66,    67,    -1,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,     3,     4,
      -1,    -1,    -1,    -1,    -1,    -1,    11,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    33,    34,
      -1,    -1,    37,    38,    -1,    -1,     4,    42,    -1,    44,
      45,    46,    47,    -1,    -1,    -1,    51,    52,    53,    54,
      55,    -1,    57,    58,    -1,    60,    61,    -1,    63,    64,
      65,    66,    67,    -1,    -1,    33,    34,    -1,    -1,    37,
      38,    -1,    -1,    -1,    42,    80,    44,    45,    46,    47,
      -1,     4,    -1,    51,    52,    53,    54,    55,    11,    57,
      58,    -1,    60,    61,    -1,    63,    64,    65,    66,    67,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      33,    34,    -1,    81,    37,    38,    -1,    -1,     4,    42,
      -1,    44,    45,    46,    47,    11,    -1,    -1,    51,    52,
      53,    54,    55,    -1,    57,    58,    -1,    60,    61,    -1,
      63,    64,    65,    66,    67,    -1,    -1,    33,    34,    -1,
      -1,    37,    38,     4,    -1,    -1,    42,    80,    44,    45,
      46,    47,    -1,    -1,    -1,    51,    52,    53,    54,    55,
      -1,    57,    58,    -1,    60,    61,    -1,    63,    64,    65,
      66,    67,    33,    34,    -1,    -1,    37,    38,     4,    -1,
      -1,    42,    -1,    44,    45,    46,    47,    -1,    -1,    -1,
      51,    52,    53,    54,    55,    -1,    57,    58,    -1,    60,
      61,    -1,    63,    64,    65,    66,    67,    -1,    34,    -1,
      -1,    37,    38,    -1,    -1,    -1,    42,    -1,    44,    45,
      -1,    47,    -1,    -1,    -1,    -1,    52,    53,    -1,    55,
      -1,    57,    58,    -1,    -1,    61,    -1,    -1,    64,    65,
      66,    67
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     4,    33,    34,    37,    38,    42,    44,    45,
      46,    47,    51,    52,    53,    54,    55,    57,    58,    60,
      61,    63,    64,    65,    66,    67,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,   128,   129,   132,   133,
     134,   135,   141,   142,   146,   147,   158,   170,   171,   172,
     174,   175,   176,   177,   178,   179,     3,    79,    88,   102,
     106,   130,   131,   148,   149,   150,   129,   129,    81,   106,
     107,   158,    81,   107,   129,   129,     0,   171,    79,     5,
       6,     7,     8,     9,    10,    30,    31,    45,    59,    79,
      87,    88,    89,    90,    91,    92,   104,   105,   106,   108,
     110,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   127,   148,   146,   150,   151,    86,
     102,    81,   101,   128,   129,   163,   173,    79,    83,   149,
     133,   136,   137,   138,   146,    81,   143,   144,    81,   106,
     154,    79,    79,    79,   110,   110,    79,    79,   110,    45,
     110,   123,   124,   126,   138,   155,     8,    30,    31,    32,
      79,    83,    85,   112,    88,    93,    94,    89,    90,    20,
      21,    26,    27,    95,    96,    24,    25,    87,    97,    98,
      28,    29,    99,    80,   146,   150,   131,   148,    35,    36,
      39,    40,    41,    48,    49,    50,    56,    62,    68,    82,
     102,   106,   107,   126,   128,   158,   161,   162,   163,   164,
     165,   166,   167,   168,   169,    81,   124,   159,   128,   163,
      11,    80,   129,   152,   153,   154,    84,   124,   138,    82,
     137,   100,   139,   140,   148,   138,   136,    82,    86,   106,
     145,   143,    80,    86,   110,   110,    45,    81,   155,    79,
     126,    12,    13,    14,    15,    16,    17,    18,    19,    22,
      23,   101,   125,    80,    86,    79,    83,   150,   156,   157,
      80,   107,    80,   109,   124,   126,   107,   112,   112,   112,
     113,   113,   114,   114,   115,   115,   115,   115,   116,   116,
     117,   118,   119,   120,   121,   126,   102,   127,   102,   100,
     161,    79,   107,    79,   102,   126,    79,    79,   100,   102,
      82,   165,   159,   160,    79,   148,   150,   156,    80,    86,
      80,    84,   127,    86,   102,   100,    82,    82,   145,   101,
      82,    86,   106,    80,    80,   164,    80,   124,   124,    80,
     152,   156,    84,   124,   157,    79,    83,   112,    80,    86,
      84,   100,   100,   161,    68,   102,   126,   102,   126,   102,
     126,   126,   161,    82,    86,   153,   140,   127,   127,    82,
      82,    80,    80,    84,    80,   152,    84,   124,   124,   126,
     161,    79,   102,   126,   102,    80,    80,    80,    82,   159,
      80,    80,    84,   126,    80,   126,   102,   102,   126,   161,
     161,   161,    80,   161,    80,    80,   126,    80,   126,   102,
      43,   102,   161,   161,    80,   161,    80,    80,   126,   161,
     161,   161,   161,    80,   161
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  However,
   YYFAIL appears to be in use.  Nevertheless, it is formally deprecated
   in Bison 2.4.2's NEWS entry, where a plan to phase it out is
   discussed.  */

#define YYFAIL		goto yyerrlab
#if defined YYFAIL
  /* This is here to suppress warnings from the GCC cpp's
     -Wunused-macros.  Normally we don't worry about that warning, but
     some users do, and we want to make it easy for users to remove
     YYFAIL uses, which will produce warnings from Bison 2.5.  */
#endif

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (scanner, YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))

/* Error token number */
#define YYTERROR	1
#define YYERRCODE	256


/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */
#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex (scanner)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value, scanner); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, GISourceScanner* scanner)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep, scanner)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    GISourceScanner* scanner;
#endif
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  if (!yyvaluep)
    return;
  YYUSE (scanner);
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
        break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, GISourceScanner* scanner)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep, scanner)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    GISourceScanner* scanner;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep, scanner);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule, GISourceScanner* scanner)
#else
static void
yy_reduce_print (yyvsp, yyrule, scanner)
    YYSTYPE *yyvsp;
    int yyrule;
    GISourceScanner* scanner;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       , scanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule, scanner); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULL, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULL;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - Assume YYFAIL is not used.  It's too flawed to consider.  See
       <http://lists.gnu.org/archive/html/bison-patches/2009-12/msg00024.html>
       for details.  YYERROR is fine as it does not invoke this
       function.
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULL, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, GISourceScanner* scanner)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, scanner)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    GISourceScanner* scanner;
#endif
{
  YYUSE (yyvaluep);
  YYUSE (scanner);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}




/* The lookahead symbol.  */
int yychar;


#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval YY_INITIAL_VALUE(yyval_default);

/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (GISourceScanner* scanner)
#else
int
yyparse (scanner)
    GISourceScanner* scanner;
#endif
#endif
{
    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
/* Line 1792 of yacc.c  */
#line 305 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = g_hash_table_lookup (const_table, (yyvsp[(1) - (1)].str));
		if ((yyval.symbol) == NULL) {
			(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		} else {
			(yyval.symbol) = gi_source_symbol_ref ((yyval.symbol));
		}
	  }
    break;

  case 3:
/* Line 1792 of yacc.c  */
#line 314 "giscanner/scannerparser.y"
    {
		char *rest;
		guint64 value;
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if (g_str_has_prefix (yytext, "0x") && strlen (yytext) > 2) {
			value = g_ascii_strtoull (yytext + 2, &rest, 16);
		} else if (g_str_has_prefix (yytext, "0") && strlen (yytext) > 1) {
			value = g_ascii_strtoull (yytext + 1, &rest, 8);
		} else {
			value = g_ascii_strtoull (yytext, &rest, 10);
		}
		(yyval.symbol)->const_int = value;
		(yyval.symbol)->const_int_is_unsigned = (rest && (rest[0] == 'U'));
	  }
    break;

  case 4:
/* Line 1792 of yacc.c  */
#line 330 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = g_utf8_get_char(yytext + 1);
	  }
    break;

  case 5:
/* Line 1792 of yacc.c  */
#line 336 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_double_set = TRUE;
		(yyval.symbol)->const_double = 0.0;
        sscanf (yytext, "%lf", &((yyval.symbol)->const_double));
	  }
    break;

  case 7:
/* Line 1792 of yacc.c  */
#line 344 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(2) - (3)].symbol);
	  }
    break;

  case 8:
/* Line 1792 of yacc.c  */
#line 348 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
    break;

  case 9:
/* Line 1792 of yacc.c  */
#line 356 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		yytext[strlen (yytext) - 1] = '\0';
		(yyval.symbol)->const_string = parse_c_string_literal (yytext + 1);
                if (!g_utf8_validate ((yyval.symbol)->const_string, -1, NULL))
                  {
#if 0
                    g_warning ("Ignoring non-UTF-8 constant string \"%s\"", yytext + 1);
#endif
                    g_free((yyval.symbol)->const_string);
                    (yyval.symbol)->const_string = NULL;
                  }

	  }
    break;

  case 10:
/* Line 1792 of yacc.c  */
#line 371 "giscanner/scannerparser.y"
    {
		char *strings, *string2;
		(yyval.symbol) = (yyvsp[(1) - (2)].symbol);
		yytext[strlen (yytext) - 1] = '\0';
		string2 = parse_c_string_literal (yytext + 1);
		strings = g_strconcat ((yyval.symbol)->const_string, string2, NULL);
		g_free ((yyval.symbol)->const_string);
		g_free (string2);
		(yyval.symbol)->const_string = strings;
	  }
    break;

  case 11:
/* Line 1792 of yacc.c  */
#line 385 "giscanner/scannerparser.y"
    {
		(yyval.str) = g_strdup (yytext);
	  }
    break;

  case 15:
/* Line 1792 of yacc.c  */
#line 398 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
    break;

  case 16:
/* Line 1792 of yacc.c  */
#line 402 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
    break;

  case 17:
/* Line 1792 of yacc.c  */
#line 406 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
    break;

  case 18:
/* Line 1792 of yacc.c  */
#line 410 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
    break;

  case 19:
/* Line 1792 of yacc.c  */
#line 414 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
    break;

  case 20:
/* Line 1792 of yacc.c  */
#line 418 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
    break;

  case 21:
/* Line 1792 of yacc.c  */
#line 422 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
    break;

  case 25:
/* Line 1792 of yacc.c  */
#line 435 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
    break;

  case 26:
/* Line 1792 of yacc.c  */
#line 439 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
    break;

  case 27:
/* Line 1792 of yacc.c  */
#line 443 "giscanner/scannerparser.y"
    {
		switch ((yyvsp[(1) - (2)].unary_operator)) {
		case UNARY_PLUS:
			(yyval.symbol) = (yyvsp[(2) - (2)].symbol);
			break;
		case UNARY_MINUS:
			(yyval.symbol) = gi_source_symbol_copy ((yyvsp[(2) - (2)].symbol));
			(yyval.symbol)->const_int = -(yyvsp[(2) - (2)].symbol)->const_int;
			break;
		case UNARY_BITWISE_COMPLEMENT:
			(yyval.symbol) = gi_source_symbol_copy ((yyvsp[(2) - (2)].symbol));
			(yyval.symbol)->const_int = ~(yyvsp[(2) - (2)].symbol)->const_int;
			break;
		case UNARY_LOGICAL_NEGATION:
			(yyval.symbol) = gi_source_symbol_copy ((yyvsp[(2) - (2)].symbol));
			(yyval.symbol)->const_int = !gi_source_symbol_get_const_boolean ((yyvsp[(2) - (2)].symbol));
			break;
		default:
			(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
			break;
		}
	  }
    break;

  case 28:
/* Line 1792 of yacc.c  */
#line 466 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(3) - (4)].symbol);
		if ((yyval.symbol)->const_int_set) {
			(yyval.symbol)->base_type = gi_source_basic_type_new ((yyval.symbol)->const_int_is_unsigned ? "guint64" : "gint64");
		}
	  }
    break;

  case 29:
/* Line 1792 of yacc.c  */
#line 473 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(3) - (4)].symbol);
		if ((yyval.symbol)->const_int_set) {
			(yyval.symbol)->base_type = gi_source_basic_type_new ("guint64");
		}
	  }
    break;

  case 30:
/* Line 1792 of yacc.c  */
#line 480 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
    break;

  case 31:
/* Line 1792 of yacc.c  */
#line 484 "giscanner/scannerparser.y"
    {
		ctype_free ((yyvsp[(3) - (4)].ctype));
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
    break;

  case 32:
/* Line 1792 of yacc.c  */
#line 492 "giscanner/scannerparser.y"
    {
		(yyval.unary_operator) = UNARY_ADDRESS_OF;
	  }
    break;

  case 33:
/* Line 1792 of yacc.c  */
#line 496 "giscanner/scannerparser.y"
    {
		(yyval.unary_operator) = UNARY_POINTER_INDIRECTION;
	  }
    break;

  case 34:
/* Line 1792 of yacc.c  */
#line 500 "giscanner/scannerparser.y"
    {
		(yyval.unary_operator) = UNARY_PLUS;
	  }
    break;

  case 35:
/* Line 1792 of yacc.c  */
#line 504 "giscanner/scannerparser.y"
    {
		(yyval.unary_operator) = UNARY_MINUS;
	  }
    break;

  case 36:
/* Line 1792 of yacc.c  */
#line 508 "giscanner/scannerparser.y"
    {
		(yyval.unary_operator) = UNARY_BITWISE_COMPLEMENT;
	  }
    break;

  case 37:
/* Line 1792 of yacc.c  */
#line 512 "giscanner/scannerparser.y"
    {
		(yyval.unary_operator) = UNARY_LOGICAL_NEGATION;
	  }
    break;

  case 39:
/* Line 1792 of yacc.c  */
#line 520 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(4) - (4)].symbol);
		if ((yyval.symbol)->const_int_set || (yyval.symbol)->const_double_set || (yyval.symbol)->const_string != NULL) {
			(yyval.symbol)->base_type = (yyvsp[(2) - (4)].ctype);
		} else {
			ctype_free ((yyvsp[(2) - (4)].ctype));
		}
	  }
    break;

  case 41:
/* Line 1792 of yacc.c  */
#line 533 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int * (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 42:
/* Line 1792 of yacc.c  */
#line 539 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if ((yyvsp[(3) - (3)].symbol)->const_int != 0) {
			(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int / (yyvsp[(3) - (3)].symbol)->const_int;
		}
	  }
    break;

  case 43:
/* Line 1792 of yacc.c  */
#line 547 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		if ((yyvsp[(3) - (3)].symbol)->const_int != 0) {
			(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int % (yyvsp[(3) - (3)].symbol)->const_int;
		}
	  }
    break;

  case 45:
/* Line 1792 of yacc.c  */
#line 559 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int + (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 46:
/* Line 1792 of yacc.c  */
#line 565 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int - (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 48:
/* Line 1792 of yacc.c  */
#line 575 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int << (yyvsp[(3) - (3)].symbol)->const_int;

		/* assume this is a bitfield/flags declaration
		 * if a left shift operator is sued in an enum value
                 * This mimics the glib-mkenum behavior.
		 */
		is_bitfield = TRUE;
	  }
    break;

  case 49:
/* Line 1792 of yacc.c  */
#line 587 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int >> (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 51:
/* Line 1792 of yacc.c  */
#line 597 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int < (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 52:
/* Line 1792 of yacc.c  */
#line 603 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int > (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 53:
/* Line 1792 of yacc.c  */
#line 609 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int <= (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 54:
/* Line 1792 of yacc.c  */
#line 615 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int >= (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 56:
/* Line 1792 of yacc.c  */
#line 625 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int == (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 57:
/* Line 1792 of yacc.c  */
#line 631 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int != (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 59:
/* Line 1792 of yacc.c  */
#line 641 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int & (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 61:
/* Line 1792 of yacc.c  */
#line 651 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int ^ (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 63:
/* Line 1792 of yacc.c  */
#line 661 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(1) - (3)].symbol)->const_int | (yyvsp[(3) - (3)].symbol)->const_int;
	  }
    break;

  case 65:
/* Line 1792 of yacc.c  */
#line 671 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int =
		  gi_source_symbol_get_const_boolean ((yyvsp[(1) - (3)].symbol)) &&
		  gi_source_symbol_get_const_boolean ((yyvsp[(3) - (3)].symbol));
	  }
    break;

  case 67:
/* Line 1792 of yacc.c  */
#line 683 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_CONST, scanner->current_file, lineno);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int =
		  gi_source_symbol_get_const_boolean ((yyvsp[(1) - (3)].symbol)) ||
		  gi_source_symbol_get_const_boolean ((yyvsp[(3) - (3)].symbol));
	  }
    break;

  case 69:
/* Line 1792 of yacc.c  */
#line 695 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_get_const_boolean ((yyvsp[(1) - (5)].symbol)) ? (yyvsp[(3) - (5)].symbol) : (yyvsp[(5) - (5)].symbol);
	  }
    break;

  case 71:
/* Line 1792 of yacc.c  */
#line 703 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
    break;

  case 85:
/* Line 1792 of yacc.c  */
#line 726 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
    break;

  case 87:
/* Line 1792 of yacc.c  */
#line 739 "giscanner/scannerparser.y"
    {
		GList *l;
		for (l = (yyvsp[(2) - (3)].list); l != NULL; l = l->next) {
			GISourceSymbol *sym = l->data;
			gi_source_symbol_merge_type (sym, gi_source_type_copy ((yyvsp[(1) - (3)].ctype)));
			if ((yyvsp[(1) - (3)].ctype)->storage_class_specifier & STORAGE_CLASS_TYPEDEF) {
				sym->type = CSYMBOL_TYPE_TYPEDEF;
			} else if (sym->base_type->type == CTYPE_FUNCTION) {
				sym->type = CSYMBOL_TYPE_FUNCTION;
			} else {
				sym->type = CSYMBOL_TYPE_OBJECT;
			}
			gi_source_scanner_add_symbol (scanner, sym);
			gi_source_symbol_unref (sym);
		}
		ctype_free ((yyvsp[(1) - (3)].ctype));
	  }
    break;

  case 88:
/* Line 1792 of yacc.c  */
#line 757 "giscanner/scannerparser.y"
    {
		ctype_free ((yyvsp[(1) - (2)].ctype));
	  }
    break;

  case 89:
/* Line 1792 of yacc.c  */
#line 764 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = (yyvsp[(2) - (2)].ctype);
		(yyval.ctype)->storage_class_specifier |= (yyvsp[(1) - (2)].storage_class_specifier);
	  }
    break;

  case 90:
/* Line 1792 of yacc.c  */
#line 769 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->storage_class_specifier |= (yyvsp[(1) - (1)].storage_class_specifier);
	  }
    break;

  case 91:
/* Line 1792 of yacc.c  */
#line 774 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = (yyvsp[(1) - (2)].ctype);
		/* combine basic types like unsigned int and long long */
		if ((yyval.ctype)->type == CTYPE_BASIC_TYPE && (yyvsp[(2) - (2)].ctype)->type == CTYPE_BASIC_TYPE) {
			char *name = g_strdup_printf ("%s %s", (yyval.ctype)->name, (yyvsp[(2) - (2)].ctype)->name);
			g_free ((yyval.ctype)->name);
			(yyval.ctype)->name = name;
			ctype_free ((yyvsp[(2) - (2)].ctype));
		} else {
			(yyval.ctype)->base_type = (yyvsp[(2) - (2)].ctype);
		}
	  }
    break;

  case 93:
/* Line 1792 of yacc.c  */
#line 788 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = (yyvsp[(2) - (2)].ctype);
		(yyval.ctype)->type_qualifier |= (yyvsp[(1) - (2)].type_qualifier);
	  }
    break;

  case 94:
/* Line 1792 of yacc.c  */
#line 793 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->type_qualifier |= (yyvsp[(1) - (1)].type_qualifier);
	  }
    break;

  case 95:
/* Line 1792 of yacc.c  */
#line 798 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = (yyvsp[(2) - (2)].ctype);
		(yyval.ctype)->function_specifier |= (yyvsp[(1) - (2)].function_specifier);
	  }
    break;

  case 96:
/* Line 1792 of yacc.c  */
#line 803 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->function_specifier |= (yyvsp[(1) - (1)].function_specifier);
	  }
    break;

  case 97:
/* Line 1792 of yacc.c  */
#line 811 "giscanner/scannerparser.y"
    {
		(yyval.list) = g_list_append (NULL, (yyvsp[(1) - (1)].symbol));
	  }
    break;

  case 98:
/* Line 1792 of yacc.c  */
#line 815 "giscanner/scannerparser.y"
    {
		(yyval.list) = g_list_append ((yyvsp[(1) - (3)].list), (yyvsp[(3) - (3)].symbol));
	  }
    break;

  case 101:
/* Line 1792 of yacc.c  */
#line 827 "giscanner/scannerparser.y"
    {
		(yyval.storage_class_specifier) = STORAGE_CLASS_TYPEDEF;
	  }
    break;

  case 102:
/* Line 1792 of yacc.c  */
#line 831 "giscanner/scannerparser.y"
    {
		(yyval.storage_class_specifier) = STORAGE_CLASS_EXTERN;
	  }
    break;

  case 103:
/* Line 1792 of yacc.c  */
#line 835 "giscanner/scannerparser.y"
    {
		(yyval.storage_class_specifier) = STORAGE_CLASS_STATIC;
	  }
    break;

  case 104:
/* Line 1792 of yacc.c  */
#line 839 "giscanner/scannerparser.y"
    {
		(yyval.storage_class_specifier) = STORAGE_CLASS_AUTO;
	  }
    break;

  case 105:
/* Line 1792 of yacc.c  */
#line 843 "giscanner/scannerparser.y"
    {
		(yyval.storage_class_specifier) = STORAGE_CLASS_REGISTER;
	  }
    break;

  case 106:
/* Line 1792 of yacc.c  */
#line 850 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_type_new (CTYPE_VOID);
	  }
    break;

  case 107:
/* Line 1792 of yacc.c  */
#line 854 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("char");
	  }
    break;

  case 108:
/* Line 1792 of yacc.c  */
#line 858 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("short");
	  }
    break;

  case 109:
/* Line 1792 of yacc.c  */
#line 862 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("int");
	  }
    break;

  case 110:
/* Line 1792 of yacc.c  */
#line 866 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("long");
	  }
    break;

  case 111:
/* Line 1792 of yacc.c  */
#line 870 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("float");
	  }
    break;

  case 112:
/* Line 1792 of yacc.c  */
#line 874 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("double");
	  }
    break;

  case 113:
/* Line 1792 of yacc.c  */
#line 878 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("signed");
	  }
    break;

  case 114:
/* Line 1792 of yacc.c  */
#line 882 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("unsigned");
	  }
    break;

  case 115:
/* Line 1792 of yacc.c  */
#line 886 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_basic_type_new ("bool");
	  }
    break;

  case 118:
/* Line 1792 of yacc.c  */
#line 892 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_typedef_new ((yyvsp[(1) - (1)].str));
		g_free ((yyvsp[(1) - (1)].str));
	  }
    break;

  case 119:
/* Line 1792 of yacc.c  */
#line 900 "giscanner/scannerparser.y"
    {
		GISourceSymbol *sym;
		(yyval.ctype) = (yyvsp[(1) - (5)].ctype);
		(yyval.ctype)->name = (yyvsp[(2) - (5)].str);
		(yyval.ctype)->child_list = (yyvsp[(4) - (5)].list);

		sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		if ((yyval.ctype)->type == CTYPE_STRUCT) {
			sym->type = CSYMBOL_TYPE_STRUCT;
		} else if ((yyval.ctype)->type == CTYPE_UNION) {
			sym->type = CSYMBOL_TYPE_UNION;
		} else {
			g_assert_not_reached ();
		}
		sym->ident = g_strdup ((yyval.ctype)->name);
		sym->base_type = gi_source_type_copy ((yyval.ctype));
		gi_source_scanner_add_symbol (scanner, sym);
		gi_source_symbol_unref (sym);
	  }
    break;

  case 120:
/* Line 1792 of yacc.c  */
#line 920 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = (yyvsp[(1) - (4)].ctype);
		(yyval.ctype)->child_list = (yyvsp[(3) - (4)].list);
	  }
    break;

  case 121:
/* Line 1792 of yacc.c  */
#line 925 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = (yyvsp[(1) - (2)].ctype);
		(yyval.ctype)->name = (yyvsp[(2) - (2)].str);
	  }
    break;

  case 122:
/* Line 1792 of yacc.c  */
#line 933 "giscanner/scannerparser.y"
    {
                scanner->private = FALSE;
		(yyval.ctype) = gi_source_struct_new (NULL);
	  }
    break;

  case 123:
/* Line 1792 of yacc.c  */
#line 938 "giscanner/scannerparser.y"
    {
                scanner->private = FALSE;
		(yyval.ctype) = gi_source_union_new (NULL);
	  }
    break;

  case 125:
/* Line 1792 of yacc.c  */
#line 947 "giscanner/scannerparser.y"
    {
		(yyval.list) = g_list_concat ((yyvsp[(1) - (2)].list), (yyvsp[(2) - (2)].list));
	  }
    break;

  case 126:
/* Line 1792 of yacc.c  */
#line 954 "giscanner/scannerparser.y"
    {
	    GList *l;
	    (yyval.list) = NULL;
	    for (l = (yyvsp[(2) - (3)].list); l != NULL; l = l->next)
	      {
		GISourceSymbol *sym = l->data;
		if ((yyvsp[(1) - (3)].ctype)->storage_class_specifier & STORAGE_CLASS_TYPEDEF)
		    sym->type = CSYMBOL_TYPE_TYPEDEF;
		else
		    sym->type = CSYMBOL_TYPE_MEMBER;
		gi_source_symbol_merge_type (sym, gi_source_type_copy ((yyvsp[(1) - (3)].ctype)));
                sym->private = scanner->private;
                (yyval.list) = g_list_append ((yyval.list), sym);
	      }
	    ctype_free ((yyvsp[(1) - (3)].ctype));
	  }
    break;

  case 127:
/* Line 1792 of yacc.c  */
#line 974 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = (yyvsp[(1) - (2)].ctype);
		(yyval.ctype)->base_type = (yyvsp[(2) - (2)].ctype);
	  }
    break;

  case 129:
/* Line 1792 of yacc.c  */
#line 980 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = (yyvsp[(2) - (2)].ctype);
		(yyval.ctype)->type_qualifier |= (yyvsp[(1) - (2)].type_qualifier);
	  }
    break;

  case 130:
/* Line 1792 of yacc.c  */
#line 985 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_type_new (CTYPE_INVALID);
		(yyval.ctype)->type_qualifier |= (yyvsp[(1) - (1)].type_qualifier);
	  }
    break;

  case 131:
/* Line 1792 of yacc.c  */
#line 993 "giscanner/scannerparser.y"
    {
		(yyval.list) = g_list_append (NULL, (yyvsp[(1) - (1)].symbol));
	  }
    break;

  case 132:
/* Line 1792 of yacc.c  */
#line 997 "giscanner/scannerparser.y"
    {
		(yyval.list) = g_list_append ((yyvsp[(1) - (3)].list), (yyvsp[(3) - (3)].symbol));
	  }
    break;

  case 133:
/* Line 1792 of yacc.c  */
#line 1004 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
    break;

  case 135:
/* Line 1792 of yacc.c  */
#line 1009 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
	  }
    break;

  case 136:
/* Line 1792 of yacc.c  */
#line 1013 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(1) - (3)].symbol);
		if ((yyvsp[(3) - (3)].symbol)->const_int_set) {
		  (yyval.symbol)->const_int_set = TRUE;
		  (yyval.symbol)->const_int = (yyvsp[(3) - (3)].symbol)->const_int;
		}
	  }
    break;

  case 137:
/* Line 1792 of yacc.c  */
#line 1024 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[(2) - (5)].str));
		(yyval.ctype)->child_list = (yyvsp[(4) - (5)].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
    break;

  case 138:
/* Line 1792 of yacc.c  */
#line 1031 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_enum_new (NULL);
		(yyval.ctype)->child_list = (yyvsp[(3) - (4)].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
    break;

  case 139:
/* Line 1792 of yacc.c  */
#line 1038 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[(2) - (6)].str));
		(yyval.ctype)->child_list = (yyvsp[(4) - (6)].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
    break;

  case 140:
/* Line 1792 of yacc.c  */
#line 1045 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_enum_new (NULL);
		(yyval.ctype)->child_list = (yyvsp[(3) - (5)].list);
		(yyval.ctype)->is_bitfield = is_bitfield || scanner->flags;
		last_enum_value = -1;
	  }
    break;

  case 141:
/* Line 1792 of yacc.c  */
#line 1052 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_enum_new ((yyvsp[(2) - (2)].str));
	  }
    break;

  case 142:
/* Line 1792 of yacc.c  */
#line 1059 "giscanner/scannerparser.y"
    {
                scanner->flags = FALSE;
                scanner->private = FALSE;
          }
    break;

  case 143:
/* Line 1792 of yacc.c  */
#line 1067 "giscanner/scannerparser.y"
    {
		/* reset flag before the first enum value */
		is_bitfield = FALSE;
	  }
    break;

  case 144:
/* Line 1792 of yacc.c  */
#line 1072 "giscanner/scannerparser.y"
    {
            (yyvsp[(2) - (2)].symbol)->private = scanner->private;
            (yyval.list) = g_list_append (NULL, (yyvsp[(2) - (2)].symbol));
	  }
    break;

  case 145:
/* Line 1792 of yacc.c  */
#line 1077 "giscanner/scannerparser.y"
    {
            (yyvsp[(3) - (3)].symbol)->private = scanner->private;
            (yyval.list) = g_list_append ((yyvsp[(1) - (3)].list), (yyvsp[(3) - (3)].symbol));
	  }
    break;

  case 146:
/* Line 1792 of yacc.c  */
#line 1085 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_OBJECT, scanner->current_file, lineno);
		(yyval.symbol)->ident = (yyvsp[(1) - (1)].str);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = ++last_enum_value;
		g_hash_table_insert (const_table, g_strdup ((yyval.symbol)->ident), gi_source_symbol_ref ((yyval.symbol)));
	  }
    break;

  case 147:
/* Line 1792 of yacc.c  */
#line 1093 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_OBJECT, scanner->current_file, lineno);
		(yyval.symbol)->ident = (yyvsp[(1) - (3)].str);
		(yyval.symbol)->const_int_set = TRUE;
		(yyval.symbol)->const_int = (yyvsp[(3) - (3)].symbol)->const_int;
		last_enum_value = (yyval.symbol)->const_int;
		g_hash_table_insert (const_table, g_strdup ((yyval.symbol)->ident), gi_source_symbol_ref ((yyval.symbol)));
	  }
    break;

  case 148:
/* Line 1792 of yacc.c  */
#line 1105 "giscanner/scannerparser.y"
    {
		(yyval.type_qualifier) = TYPE_QUALIFIER_CONST;
	  }
    break;

  case 149:
/* Line 1792 of yacc.c  */
#line 1109 "giscanner/scannerparser.y"
    {
		(yyval.type_qualifier) = TYPE_QUALIFIER_RESTRICT;
	  }
    break;

  case 150:
/* Line 1792 of yacc.c  */
#line 1113 "giscanner/scannerparser.y"
    {
		(yyval.type_qualifier) = TYPE_QUALIFIER_EXTENSION;
	  }
    break;

  case 151:
/* Line 1792 of yacc.c  */
#line 1117 "giscanner/scannerparser.y"
    {
		(yyval.type_qualifier) = TYPE_QUALIFIER_VOLATILE;
	  }
    break;

  case 152:
/* Line 1792 of yacc.c  */
#line 1124 "giscanner/scannerparser.y"
    {
		(yyval.function_specifier) = FUNCTION_INLINE;
	  }
    break;

  case 153:
/* Line 1792 of yacc.c  */
#line 1131 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(2) - (2)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[(1) - (2)].ctype));
	  }
    break;

  case 155:
/* Line 1792 of yacc.c  */
#line 1140 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		(yyval.symbol)->ident = (yyvsp[(1) - (1)].str);
	  }
    break;

  case 156:
/* Line 1792 of yacc.c  */
#line 1145 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(2) - (3)].symbol);
	  }
    break;

  case 157:
/* Line 1792 of yacc.c  */
#line 1149 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(1) - (4)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[(3) - (4)].symbol)));
	  }
    break;

  case 158:
/* Line 1792 of yacc.c  */
#line 1154 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(1) - (3)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
    break;

  case 159:
/* Line 1792 of yacc.c  */
#line 1159 "giscanner/scannerparser.y"
    {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[(3) - (4)].list) != NULL && ((yyvsp[(3) - (4)].list)->next != NULL || ((GISourceSymbol *) (yyvsp[(3) - (4)].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[(3) - (4)].list);
		}
		(yyval.symbol) = (yyvsp[(1) - (4)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
    break;

  case 160:
/* Line 1792 of yacc.c  */
#line 1169 "giscanner/scannerparser.y"
    {
		GISourceType *func = gi_source_function_new ();
		func->child_list = (yyvsp[(3) - (4)].list);
		(yyval.symbol) = (yyvsp[(1) - (4)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
    break;

  case 161:
/* Line 1792 of yacc.c  */
#line 1176 "giscanner/scannerparser.y"
    {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = (yyvsp[(1) - (3)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
    break;

  case 162:
/* Line 1792 of yacc.c  */
#line 1185 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_pointer_new (NULL);
		(yyval.ctype)->type_qualifier = (yyvsp[(2) - (2)].type_qualifier);
	  }
    break;

  case 163:
/* Line 1792 of yacc.c  */
#line 1190 "giscanner/scannerparser.y"
    {
		(yyval.ctype) = gi_source_pointer_new (NULL);
	  }
    break;

  case 164:
/* Line 1792 of yacc.c  */
#line 1194 "giscanner/scannerparser.y"
    {
		GISourceType **base = &((yyvsp[(3) - (3)].ctype)->base_type);

		while (*base != NULL) {
			base = &((*base)->base_type);
		}
		*base = gi_source_pointer_new (NULL);
		(*base)->type_qualifier = (yyvsp[(2) - (3)].type_qualifier);
		(yyval.ctype) = (yyvsp[(3) - (3)].ctype);
	  }
    break;

  case 165:
/* Line 1792 of yacc.c  */
#line 1205 "giscanner/scannerparser.y"
    {
		GISourceType **base = &((yyvsp[(2) - (2)].ctype)->base_type);

		while (*base != NULL) {
			base = &((*base)->base_type);
		}
		*base = gi_source_pointer_new (NULL);
		(yyval.ctype) = (yyvsp[(2) - (2)].ctype);
	  }
    break;

  case 167:
/* Line 1792 of yacc.c  */
#line 1219 "giscanner/scannerparser.y"
    {
		(yyval.type_qualifier) = (yyvsp[(1) - (2)].type_qualifier) | (yyvsp[(2) - (2)].type_qualifier);
	  }
    break;

  case 168:
/* Line 1792 of yacc.c  */
#line 1226 "giscanner/scannerparser.y"
    {
		(yyval.list) = g_list_append (NULL, (yyvsp[(1) - (1)].symbol));
	  }
    break;

  case 169:
/* Line 1792 of yacc.c  */
#line 1230 "giscanner/scannerparser.y"
    {
		(yyval.list) = g_list_append ((yyvsp[(1) - (3)].list), (yyvsp[(3) - (3)].symbol));
	  }
    break;

  case 170:
/* Line 1792 of yacc.c  */
#line 1237 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(2) - (2)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[(1) - (2)].ctype));
	  }
    break;

  case 171:
/* Line 1792 of yacc.c  */
#line 1242 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(2) - (2)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[(1) - (2)].ctype));
	  }
    break;

  case 172:
/* Line 1792 of yacc.c  */
#line 1247 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		(yyval.symbol)->base_type = (yyvsp[(1) - (1)].ctype);
	  }
    break;

  case 173:
/* Line 1792 of yacc.c  */
#line 1252 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_ELLIPSIS, scanner->current_file, lineno);
	  }
    break;

  case 174:
/* Line 1792 of yacc.c  */
#line 1259 "giscanner/scannerparser.y"
    {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		sym->ident = (yyvsp[(1) - (1)].str);
		(yyval.list) = g_list_append (NULL, sym);
	  }
    break;

  case 175:
/* Line 1792 of yacc.c  */
#line 1265 "giscanner/scannerparser.y"
    {
		GISourceSymbol *sym = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		sym->ident = (yyvsp[(3) - (3)].str);
		(yyval.list) = g_list_append ((yyvsp[(1) - (3)].list), sym);
	  }
    break;

  case 178:
/* Line 1792 of yacc.c  */
#line 1279 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[(1) - (1)].ctype));
	  }
    break;

  case 180:
/* Line 1792 of yacc.c  */
#line 1285 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(2) - (2)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), (yyvsp[(1) - (2)].ctype));
	  }
    break;

  case 181:
/* Line 1792 of yacc.c  */
#line 1293 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(2) - (3)].symbol);
	  }
    break;

  case 182:
/* Line 1792 of yacc.c  */
#line 1297 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
    break;

  case 183:
/* Line 1792 of yacc.c  */
#line 1302 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[(2) - (3)].symbol)));
	  }
    break;

  case 184:
/* Line 1792 of yacc.c  */
#line 1307 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(1) - (3)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new (NULL));
	  }
    break;

  case 185:
/* Line 1792 of yacc.c  */
#line 1312 "giscanner/scannerparser.y"
    {
		(yyval.symbol) = (yyvsp[(1) - (4)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), gi_source_array_new ((yyvsp[(3) - (4)].symbol)));
	  }
    break;

  case 186:
/* Line 1792 of yacc.c  */
#line 1317 "giscanner/scannerparser.y"
    {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
    break;

  case 187:
/* Line 1792 of yacc.c  */
#line 1323 "giscanner/scannerparser.y"
    {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[(2) - (3)].list) != NULL && ((yyvsp[(2) - (3)].list)->next != NULL || ((GISourceSymbol *) (yyvsp[(2) - (3)].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[(2) - (3)].list);
		}
		(yyval.symbol) = gi_source_symbol_new (CSYMBOL_TYPE_INVALID, scanner->current_file, lineno);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
    break;

  case 188:
/* Line 1792 of yacc.c  */
#line 1333 "giscanner/scannerparser.y"
    {
		GISourceType *func = gi_source_function_new ();
		(yyval.symbol) = (yyvsp[(1) - (3)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
    break;

  case 189:
/* Line 1792 of yacc.c  */
#line 1339 "giscanner/scannerparser.y"
    {
		GISourceType *func = gi_source_function_new ();
		// ignore (void) parameter list
		if ((yyvsp[(3) - (4)].list) != NULL && ((yyvsp[(3) - (4)].list)->next != NULL || ((GISourceSymbol *) (yyvsp[(3) - (4)].list)->data)->base_type->type != CTYPE_VOID)) {
			func->child_list = (yyvsp[(3) - (4)].list);
		}
		(yyval.symbol) = (yyvsp[(1) - (4)].symbol);
		gi_source_symbol_merge_type ((yyval.symbol), func);
	  }
    break;

  case 190:
/* Line 1792 of yacc.c  */
#line 1352 "giscanner/scannerparser.y"
    {
		(yyval.str) = g_strdup (yytext);
	  }
    break;

  case 240:
/* Line 1792 of yacc.c  */
#line 1459 "giscanner/scannerparser.y"
    {
		(yyval.str) = g_strdup (yytext + strlen ("#define "));
	  }
    break;

  case 241:
/* Line 1792 of yacc.c  */
#line 1466 "giscanner/scannerparser.y"
    {
		(yyval.str) = g_strdup (yytext + strlen ("#define "));
	  }
    break;

  case 243:
/* Line 1792 of yacc.c  */
#line 1477 "giscanner/scannerparser.y"
    {
		if ((yyvsp[(2) - (2)].symbol)->const_int_set || (yyvsp[(2) - (2)].symbol)->const_double_set || (yyvsp[(2) - (2)].symbol)->const_string != NULL) {
			(yyvsp[(2) - (2)].symbol)->ident = (yyvsp[(1) - (2)].str);
			gi_source_scanner_add_symbol (scanner, (yyvsp[(2) - (2)].symbol));
			gi_source_symbol_unref ((yyvsp[(2) - (2)].symbol));
		}
	  }
    break;

  case 244:
/* Line 1792 of yacc.c  */
#line 1488 "giscanner/scannerparser.y"
    {
		push_conditional (scanner, FOR_GI_SCANNER);
		update_skipping (scanner);
	  }
    break;

  case 245:
/* Line 1792 of yacc.c  */
#line 1493 "giscanner/scannerparser.y"
    {
		push_conditional (scanner, NOT_GI_SCANNER);
		update_skipping (scanner);
	  }
    break;

  case 246:
/* Line 1792 of yacc.c  */
#line 1498 "giscanner/scannerparser.y"
    {
	 	warn_if_cond_has_gi_scanner (scanner, yytext);
		push_conditional (scanner, IRRELEVANT);
	  }
    break;

  case 247:
/* Line 1792 of yacc.c  */
#line 1503 "giscanner/scannerparser.y"
    {
		warn_if_cond_has_gi_scanner (scanner, yytext);
		push_conditional (scanner, IRRELEVANT);
	  }
    break;

  case 248:
/* Line 1792 of yacc.c  */
#line 1508 "giscanner/scannerparser.y"
    {
		warn_if_cond_has_gi_scanner (scanner, yytext);
		push_conditional (scanner, IRRELEVANT);
	  }
    break;

  case 249:
/* Line 1792 of yacc.c  */
#line 1513 "giscanner/scannerparser.y"
    {
		warn_if_cond_has_gi_scanner (scanner, yytext);
		pop_conditional (scanner);
		push_conditional (scanner, IRRELEVANT);
		update_skipping (scanner);
	  }
    break;

  case 250:
/* Line 1792 of yacc.c  */
#line 1520 "giscanner/scannerparser.y"
    {
		toggle_conditional (scanner);
		update_skipping (scanner);
	  }
    break;

  case 251:
/* Line 1792 of yacc.c  */
#line 1525 "giscanner/scannerparser.y"
    {
		pop_conditional (scanner);
		update_skipping (scanner);
	  }
    break;


/* Line 1792 of yacc.c  */
#line 4075 "scannerparser.c"
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (scanner, YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (scanner, yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval, scanner);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp, scanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (scanner, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, scanner);
    }
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp, scanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}


/* Line 2055 of yacc.c  */
#line 1538 "giscanner/scannerparser.y"

static void
yyerror (GISourceScanner *scanner, const char *s)
{
  /* ignore errors while doing a macro scan as not all object macros
   * have valid expressions */
  if (!scanner->macro_scan)
    {
      fprintf(stderr, "%s:%d: %s in '%s' at '%s'\n",
	      g_file_get_parse_name (scanner->current_file), lineno, s, linebuf, yytext);
    }
}

static int
eat_hspace (FILE * f)
{
  int c;
  do
    {
      c = fgetc (f);
    }
  while (c == ' ' || c == '\t');
  return c;
}

static int
pass_line (FILE * f, int c,
           FILE *out)
{
  while (c != EOF && c != '\n')
    {
      if (out)
        fputc (c, out);
      c = fgetc (f);
    }
  if (c == '\n')
    {
      if (out)
        fputc (c, out);
      c = fgetc (f);
      if (c == ' ' || c == '\t')
        {
          c = eat_hspace (f);
        }
    }
  return c;
}

static int
eat_line (FILE * f, int c)
{
  return pass_line (f, c, NULL);
}

static int
read_identifier (FILE * f, int c, char **identifier)
{
  GString *id = g_string_new ("");
  while (g_ascii_isalnum (c) || c == '_')
    {
      g_string_append_c (id, c);
      c = fgetc (f);
    }
  *identifier = g_string_free (id, FALSE);
  return c;
}

void
gi_source_scanner_parse_macros (GISourceScanner *scanner, GList *filenames)
{
  GError *error = NULL;
  char *tmp_name = NULL;
  FILE *fmacros =
    fdopen (g_file_open_tmp ("gen-introspect-XXXXXX.h", &tmp_name, &error),
            "w+");
  GList *l;
  g_unlink (tmp_name);

  for (l = filenames; l != NULL; l = l->next)
    {
      FILE *f = fopen (l->data, "r");
      int line = 1;

      GString *define_line;
      char *str;
      gboolean error_line = FALSE;
      gboolean end_of_word;
      int c = eat_hspace (f);
      while (c != EOF)
        {
          if (c != '#')
            {
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }

          /* print current location */
          str = g_strescape (l->data, "");
          fprintf (fmacros, "# %d \"%s\"\n", line, str);
          g_free (str);

          c = eat_hspace (f);
          c = read_identifier (f, c, &str);
          end_of_word = (c == ' ' || c == '\t' || c == '\n' || c == EOF);
          if (end_of_word &&
              (g_str_equal (str, "if") ||
               g_str_equal (str, "endif") ||
               g_str_equal (str, "ifndef") ||
               g_str_equal (str, "ifdef") ||
               g_str_equal (str, "else") ||
               g_str_equal (str, "elif")))
            {
              fprintf (fmacros, "#%s ", str);
              g_free (str);
              c = pass_line (f, c, fmacros);
              line++;
              continue;
            }
          else if (strcmp (str, "define") != 0 || !end_of_word)
            {
              g_free (str);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          g_free (str);
          c = eat_hspace (f);
          c = read_identifier (f, c, &str);
          if (strlen (str) == 0 || (c != ' ' && c != '\t' && c != '('))
            {
              g_free (str);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          define_line = g_string_new ("#define ");
          g_string_append (define_line, str);
          g_free (str);
          if (c == '(')
            {
              while (c != ')')
                {
                  g_string_append_c (define_line, c);
                  c = fgetc (f);
                  if (c == EOF || c == '\n')
                    {
                      error_line = TRUE;
                      break;
                    }
                }
              if (error_line)
                {
                  g_string_free (define_line, TRUE);
                  /* ignore line */
                  c = eat_line (f, c);
                  line++;
                  continue;
                }

              g_assert (c == ')');
              g_string_append_c (define_line, c);
              c = fgetc (f);

              /* found function-like macro */
              fprintf (fmacros, "%s\n", define_line->str);

              g_string_free (define_line, TRUE);
              /* ignore rest of line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          if (c != ' ' && c != '\t')
            {
              g_string_free (define_line, TRUE);
              /* ignore line */
              c = eat_line (f, c);
              line++;
              continue;
            }
          while (c != EOF && c != '\n')
            {
              g_string_append_c (define_line, c);
              c = fgetc (f);
              if (c == '\\')
                {
                  c = fgetc (f);
                  if (c == '\n')
                    {
                      /* fold lines when seeing backslash new-line sequence */
                      c = fgetc (f);
                    }
                  else
                    {
                      g_string_append_c (define_line, '\\');
                    }
                }
            }

          /* found object-like macro */
          fprintf (fmacros, "%s\n", define_line->str);

          c = eat_line (f, c);
          line++;
        }

      fclose (f);
    }

  rewind (fmacros);
  gi_source_scanner_parse_file (scanner, fmacros);
}

gboolean
gi_source_scanner_parse_file (GISourceScanner *scanner, FILE *file)
{
  g_return_val_if_fail (file != NULL, FALSE);

  const_table = g_hash_table_new_full (g_str_hash, g_str_equal,
				       g_free, (GDestroyNotify)gi_source_symbol_unref);

  lineno = 1;
  yyin = file;
  yyparse (scanner);

  g_hash_table_destroy (const_table);
  const_table = NULL;

  yyin = NULL;

  return TRUE;
}

gboolean
gi_source_scanner_lex_filename (GISourceScanner *scanner, const gchar *filename)
{
  lineno = 1;
  yyin = fopen (filename, "r");

  while (yylex (scanner) != YYEOF)
    ;

  fclose (yyin);

  return TRUE;
}
