/* math-equation.c generated by valac 0.18.1, the Vala compiler
 * generated from math-equation.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>


#define TYPE_NUMBER_MODE (number_mode_get_type ())

#define TYPE_MATH_EQUATION_STATE (math_equation_state_get_type ())
#define MATH_EQUATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION_STATE, MathEquationState))
#define MATH_EQUATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION_STATE, MathEquationStateClass))
#define IS_MATH_EQUATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION_STATE))
#define IS_MATH_EQUATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION_STATE))
#define MATH_EQUATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION_STATE, MathEquationStateClass))

typedef struct _MathEquationState MathEquationState;
typedef struct _MathEquationStateClass MathEquationStateClass;
typedef struct _MathEquationStatePrivate MathEquationStatePrivate;

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _number_unref0(var) ((var == NULL) ? NULL : (var = (number_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecMathEquationState ParamSpecMathEquationState;

#define TYPE_SOLVE_DATA (solve_data_get_type ())
#define SOLVE_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOLVE_DATA, SolveData))
#define SOLVE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOLVE_DATA, SolveDataClass))
#define IS_SOLVE_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOLVE_DATA))
#define IS_SOLVE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOLVE_DATA))
#define SOLVE_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOLVE_DATA, SolveDataClass))

typedef struct _SolveData SolveData;
typedef struct _SolveDataClass SolveDataClass;
typedef struct _SolveDataPrivate SolveDataPrivate;
typedef struct _ParamSpecSolveData ParamSpecSolveData;

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;
typedef struct _MathEquationPrivate MathEquationPrivate;

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())

#define TYPE_MATH_VARIABLES (math_variables_get_type ())
#define MATH_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_VARIABLES, MathVariables))
#define MATH_VARIABLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_VARIABLES, MathVariablesClass))
#define IS_MATH_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_VARIABLES))
#define IS_MATH_VARIABLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_VARIABLES))
#define MATH_VARIABLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_VARIABLES, MathVariablesClass))

typedef struct _MathVariables MathVariables;
typedef struct _MathVariablesClass MathVariablesClass;

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _math_equation_state_unref0(var) ((var == NULL) ? NULL : (var = (math_equation_state_unref (var), NULL)))
#define __g_list_free__math_equation_state_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__math_equation_state_unref0_ (var), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

#define TYPE_ERROR_CODE (error_code_get_type ())

#define TYPE_EQUATION (equation_get_type ())
#define EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EQUATION, Equation))
#define EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EQUATION, EquationClass))
#define IS_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EQUATION))
#define IS_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EQUATION))
#define EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EQUATION, EquationClass))

typedef struct _Equation Equation;
typedef struct _EquationClass EquationClass;

#define TYPE_MEQUATION (mequation_get_type ())
#define MEQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEQUATION, MEquation))
#define MEQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEQUATION, MEquationClass))
#define IS_MEQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEQUATION))
#define IS_MEQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEQUATION))
#define MEQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEQUATION, MEquationClass))

typedef struct _MEquation MEquation;
typedef struct _MEquationClass MEquationClass;
typedef struct _EquationPrivate EquationPrivate;
#define _equation_unref0(var) ((var == NULL) ? NULL : (var = (equation_unref (var), NULL)))
#define _solve_data_unref0(var) ((var == NULL) ? NULL : (var = (solve_data_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define __g_list_free__number_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__number_unref0_ (var), NULL)))
typedef struct _MEquationPrivate MEquationPrivate;

#define TYPE_UNIT_MANAGER (unit_manager_get_type ())
#define UNIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT_MANAGER, UnitManager))
#define UNIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT_MANAGER, UnitManagerClass))
#define IS_UNIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT_MANAGER))
#define IS_UNIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT_MANAGER))
#define UNIT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT_MANAGER, UnitManagerClass))

typedef struct _UnitManager UnitManager;
typedef struct _UnitManagerClass UnitManagerClass;

typedef enum  {
	NUMBER_MODE_NORMAL,
	NUMBER_MODE_SUPERSCRIPT,
	NUMBER_MODE_SUBSCRIPT
} NumberMode;

struct _MathEquationState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MathEquationStatePrivate * priv;
	Number* ans;
	guint ans_base;
	gchar* expression;
	gint ans_start;
	gint ans_end;
	gint cursor;
	NumberMode number_mode;
	gboolean can_super_minus;
	gboolean entered_multiply;
	gchar* status;
	guint error_token_start;
	guint error_token_end;
};

struct _MathEquationStateClass {
	GTypeClass parent_class;
	void (*finalize) (MathEquationState *self);
};

struct _ParamSpecMathEquationState {
	GParamSpec parent_instance;
};

struct _SolveData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SolveDataPrivate * priv;
	Number* number_result;
	gchar* text_result;
	gchar* error;
	guint error_start;
	guint error_end;
	guint representation_base;
};

struct _SolveDataClass {
	GTypeClass parent_class;
	void (*finalize) (SolveData *self);
};

struct _ParamSpecSolveData {
	GParamSpec parent_instance;
};

struct _MathEquation {
	GtkTextBuffer parent_instance;
	MathEquationPrivate * priv;
};

struct _MathEquationClass {
	GtkTextBufferClass parent_class;
};

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _MathEquationPrivate {
	GtkTextTag* ans_tag;
	gint _word_size;
	gchar* _source_currency;
	gchar* _target_currency;
	gchar* _source_units;
	gchar* _target_units;
	AngleUnit _angle_units;
	NumberMode _number_mode;
	gboolean can_super_minus;
	gunichar digits[16];
	GtkTextMark* ans_start_mark;
	GtkTextMark* ans_end_mark;
	MathEquationState* state;
	GList* undo_stack;
	GList* redo_stack;
	gboolean in_undo_operation;
	gboolean in_reformat;
	gboolean in_delete;
	gboolean _in_solve;
	MathVariables* _variables;
	Serializer* _serializer;
	GAsyncQueue* queue;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;

struct _Equation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EquationPrivate * priv;
	gint base;
	gint wordlen;
	AngleUnit angle_units;
};

struct _EquationClass {
	GTypeClass parent_class;
	void (*finalize) (Equation *self);
	gboolean (*variable_is_defined) (Equation* self, const gchar* name);
	Number* (*get_variable) (Equation* self, const gchar* name);
	void (*set_variable) (Equation* self, const gchar* name, Number* x);
	gboolean (*function_is_defined) (Equation* self, const gchar* name);
	Number* (*get_function) (Equation* self, const gchar* name, Number* x);
	Number* (*convert) (Equation* self, Number* x, const gchar* x_units, const gchar* z_units);
};

struct _MEquation {
	Equation parent_instance;
	MEquationPrivate * priv;
};

struct _MEquationClass {
	EquationClass parent_class;
};

struct _MEquationPrivate {
	MathEquation* m_equation;
};


static gpointer math_equation_state_parent_class = NULL;
static gpointer solve_data_parent_class = NULL;
static gpointer math_equation_parent_class = NULL;
static gpointer mequation_parent_class = NULL;

GType number_mode_get_type (void) G_GNUC_CONST;
gpointer math_equation_state_ref (gpointer instance);
void math_equation_state_unref (gpointer instance);
GParamSpec* param_spec_math_equation_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_math_equation_state (GValue* value, gpointer v_object);
void value_take_math_equation_state (GValue* value, gpointer v_object);
gpointer value_get_math_equation_state (const GValue* value);
GType math_equation_state_get_type (void) G_GNUC_CONST;
gpointer number_ref (gpointer instance);
void number_unref (gpointer instance);
GParamSpec* param_spec_number (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_number (GValue* value, gpointer v_object);
void value_take_number (GValue* value, gpointer v_object);
gpointer value_get_number (const GValue* value);
GType number_get_type (void) G_GNUC_CONST;
enum  {
	MATH_EQUATION_STATE_DUMMY_PROPERTY
};
MathEquationState* math_equation_state_new (void);
MathEquationState* math_equation_state_construct (GType object_type);
static void math_equation_state_finalize (MathEquationState* obj);
gpointer solve_data_ref (gpointer instance);
void solve_data_unref (gpointer instance);
GParamSpec* param_spec_solve_data (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_solve_data (GValue* value, gpointer v_object);
void value_take_solve_data (GValue* value, gpointer v_object);
gpointer value_get_solve_data (const GValue* value);
GType solve_data_get_type (void) G_GNUC_CONST;
enum  {
	SOLVE_DATA_DUMMY_PROPERTY
};
SolveData* solve_data_new (void);
SolveData* solve_data_construct (GType object_type);
static void solve_data_finalize (SolveData* obj);
GType math_equation_get_type (void) G_GNUC_CONST;
GType angle_unit_get_type (void) G_GNUC_CONST;
GType math_variables_get_type (void) G_GNUC_CONST;
GType serializer_get_type (void) G_GNUC_CONST;
#define MATH_EQUATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_EQUATION, MathEquationPrivate))
enum  {
	MATH_EQUATION_DUMMY_PROPERTY,
	MATH_EQUATION_WORD_SIZE,
	MATH_EQUATION_SOURCE_CURRENCY,
	MATH_EQUATION_TARGET_CURRENCY,
	MATH_EQUATION_SOURCE_UNITS,
	MATH_EQUATION_TARGET_UNITS,
	MATH_EQUATION_DISPLAY,
	MATH_EQUATION_IN_SOLVE,
	MATH_EQUATION_VARIABLES,
	MATH_EQUATION_SERIALIZER,
	MATH_EQUATION_ACCURACY,
	MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS,
	MATH_EQUATION_SHOW_TRAILING_ZEROES,
	MATH_EQUATION_NUMBER_FORMAT,
	MATH_EQUATION_NUMBER_BASE,
	MATH_EQUATION_ANGLE_UNITS,
	MATH_EQUATION_STATUS,
	MATH_EQUATION_ERROR_TOKEN_START,
	MATH_EQUATION_ERROR_TOKEN_END,
	MATH_EQUATION_IS_EMPTY,
	MATH_EQUATION_IS_RESULT,
	MATH_EQUATION_EQUATION,
	MATH_EQUATION_NUMBER,
	MATH_EQUATION_NUMBER_MODE,
	MATH_EQUATION_ANSWER
};
static void _math_equation_state_unref0_ (gpointer var);
static void _g_list_free__math_equation_state_unref0_ (GList* self);
MathEquation* math_equation_new (void);
MathEquation* math_equation_construct (GType object_type);
MathVariables* math_variables_new (void);
MathVariables* math_variables_construct (GType object_type);
void math_equation_set_word_size (MathEquation* self, gint value);
void math_equation_set_source_currency (MathEquation* self, const gchar* value);
void math_equation_set_target_currency (MathEquation* self, const gchar* value);
void math_equation_set_source_units (MathEquation* self, const gchar* value);
void math_equation_set_target_units (MathEquation* self, const gchar* value);
GType display_format_get_type (void) G_GNUC_CONST;
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
static void _solve_data_unref0_ (gpointer var);
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
static void math_equation_get_ans_offsets (MathEquation* self, gint* start, gint* end);
static void math_equation_reformat_ans (MathEquation* self);
Serializer* math_equation_get_serializer (MathEquation* self);
gchar* serializer_to_string (Serializer* self, Number* x);
static void math_equation_reformat_separators (MathEquation* self);
gchar* math_equation_get_display (MathEquation* self);
gint math_equation_get_number_base (MathEquation* self);
gboolean serializer_get_show_thousands_separators (Serializer* self);
gint serializer_get_thousands_separator_count (Serializer* self);
static gint math_equation_count_digits (MathEquation* self, const gchar* text, gint index);
gunichar serializer_get_thousands_separator (Serializer* self);
gunichar serializer_get_radix (Serializer* self);
static void math_equation_reformat_display (MathEquation* self);
static MathEquationState* math_equation_get_current_state (MathEquation* self);
NumberMode math_equation_get_number_mode (MathEquation* self);
static void math_equation_push_undo_stack (MathEquation* self);
void math_equation_set_status (MathEquation* self, const gchar* value);
static void math_equation_clear_ans (MathEquation* self, gboolean do_remove_tag);
static void math_equation_apply_state (MathEquation* self, MathEquationState* s);
void math_equation_set_number_mode (MathEquation* self, NumberMode value);
void math_equation_copy (MathEquation* self);
void math_equation_paste (MathEquation* self);
static void math_equation_on_paste (MathEquation* self, GtkClipboard* clipboard, const gchar* text);
static void _math_equation_on_paste_gtk_clipboard_text_received_func (GtkClipboard* clipboard, const gchar* text, gpointer self);
void math_equation_insert (MathEquation* self, const gchar* text);
void math_equation_undo (MathEquation* self);
void math_equation_redo (MathEquation* self);
gunichar math_equation_get_digit_text (MathEquation* self, guint digit);
void math_equation_store (MathEquation* self, const gchar* name);
Number* math_equation_get_number (MathEquation* self);
MathVariables* math_equation_get_variables (MathEquation* self);
void math_variables_set (MathVariables* self, const gchar* name, Number* value);
void math_equation_recall (MathEquation* self, const gchar* name);
void math_equation_set (MathEquation* self, const gchar* text);
void math_equation_set_number (MathEquation* self, Number* x, guint representation_base);
void serializer_set_representation_base (Serializer* self, guint representation_base);
gint serializer_get_base (Serializer* self);
void math_equation_insert_square (MathEquation* self);
void math_equation_insert_digit (MathEquation* self, guint digit);
void math_equation_insert_numeric_point (MathEquation* self);
void math_equation_insert_number (MathEquation* self, Number* x);
void math_equation_insert_exponent (MathEquation* self);
void math_equation_insert_subtract (MathEquation* self);
GType error_code_get_type (void) G_GNUC_CONST;
static Number* math_equation_parse (MathEquation* self, const gchar* text, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint* error_start, guint* error_end);
MEquation* mequation_new (MathEquation* m_equation, const gchar* equation);
MEquation* mequation_construct (GType object_type, MathEquation* m_equation, const gchar* equation);
gpointer equation_ref (gpointer instance);
void equation_unref (gpointer instance);
GParamSpec* param_spec_equation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_equation (GValue* value, gpointer v_object);
void value_take_equation (GValue* value, gpointer v_object);
gpointer value_get_equation (const GValue* value);
GType equation_get_type (void) G_GNUC_CONST;
GType mequation_get_type (void) G_GNUC_CONST;
gint math_equation_get_word_size (MathEquation* self);
AngleUnit math_equation_get_angle_units (MathEquation* self);
Number* equation_parse (Equation* self, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint* error_start, guint* error_end);
static void* math_equation_solve_real (MathEquation* self);
gchar* math_equation_get_equation (MathEquation* self);
gchar* mp_get_error (void);
static gboolean math_equation_show_in_progress (MathEquation* self);
gboolean math_equation_get_in_solve (MathEquation* self);
static gboolean math_equation_look_for_answer (MathEquation* self);
static void math_equation_error_token_fix_thousands_separator (MathEquation* self);
void math_equation_solve (MathEquation* self);
gboolean math_equation_get_is_empty (MathEquation* self);
gboolean math_equation_get_is_result (MathEquation* self);
static gpointer _math_equation_solve_real_gthread_func (gpointer self);
static gboolean _math_equation_look_for_answer_gsource_func (gpointer self);
static gboolean _math_equation_show_in_progress_gsource_func (gpointer self);
guint math_equation_get_error_token_start (MathEquation* self);
guint math_equation_get_error_token_end (MathEquation* self);
static void* math_equation_factorize_real (MathEquation* self);
GList* number_factorize (Number* self);
static void _number_unref0_ (gpointer var);
static void _g_list_free__number_unref0_ (GList* self);
void math_equation_factorize (MathEquation* self);
gboolean number_is_integer (Number* self);
static gpointer _math_equation_factorize_real_gthread_func (gpointer self);
void math_equation_delete_next (MathEquation* self);
void math_equation_backspace (MathEquation* self);
void math_equation_clear (MathEquation* self);
void math_equation_shift (MathEquation* self, gint count);
Number* number_shift (Number* self, gint count);
void math_equation_toggle_bit (MathEquation* self, guint bit);
Number* number_new_unsigned_integer (guint64 x);
Number* number_construct_unsigned_integer (GType object_type, guint64 x);
gboolean number_is_negative (Number* self);
gint number_compare (Number* self, Number* y);
guint64 number_to_unsigned_integer (Number* self);
static void math_equation_real_insert_text (GtkTextBuffer* base, GtkTextIter* location, const gchar* text, gint len);
static void math_equation_real_delete_range (GtkTextBuffer* base, GtkTextIter* start, GtkTextIter* end);
static gboolean __lambda8_ (MathEquation* self);
static gboolean ___lambda8__gsource_func (gpointer self);
gchar* math_equation_get_source_currency (MathEquation* self);
gchar* math_equation_get_target_currency (MathEquation* self);
gchar* math_equation_get_source_units (MathEquation* self);
gchar* math_equation_get_target_units (MathEquation* self);
gint math_equation_get_accuracy (MathEquation* self);
gint serializer_get_trailing_digits (Serializer* self);
void math_equation_set_accuracy (MathEquation* self, gint value);
void serializer_set_trailing_digits (Serializer* self, gint trailing_digits);
gboolean math_equation_get_show_thousands_separators (MathEquation* self);
void math_equation_set_show_thousands_separators (MathEquation* self, gboolean value);
void serializer_set_show_thousands_separators (Serializer* self, gboolean visible);
gboolean math_equation_get_show_trailing_zeroes (MathEquation* self);
gboolean serializer_get_show_trailing_zeroes (Serializer* self);
void math_equation_set_show_trailing_zeroes (MathEquation* self, gboolean value);
void serializer_set_show_trailing_zeroes (Serializer* self, gboolean visible);
DisplayFormat math_equation_get_number_format (MathEquation* self);
DisplayFormat serializer_get_number_format (Serializer* self);
void math_equation_set_number_format (MathEquation* self, DisplayFormat value);
void serializer_set_number_format (Serializer* self, DisplayFormat format);
void math_equation_set_number_base (MathEquation* self, gint value);
guint serializer_get_representation_base (Serializer* self);
void serializer_set_base (Serializer* self, gint number_base);
void math_equation_set_angle_units (MathEquation* self, AngleUnit value);
gchar* math_equation_get_status (MathEquation* self);
Number* math_equation_get_answer (MathEquation* self);
Number* serializer_from_string (Serializer* self, const gchar* str);
static void math_equation_finalize (GObject* obj);
static void _vala_math_equation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_math_equation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define MEQUATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MEQUATION, MEquationPrivate))
enum  {
	MEQUATION_DUMMY_PROPERTY
};
Equation* equation_new (const gchar* expression);
Equation* equation_construct (GType object_type, const gchar* expression);
static gboolean mequation_real_variable_is_defined (Equation* base, const gchar* name);
Number* math_variables_get (MathVariables* self, const gchar* name);
static Number* mequation_real_get_variable (Equation* base, const gchar* name);
Number* number_new_random (void);
Number* number_construct_random (GType object_type);
static void mequation_real_set_variable (Equation* base, const gchar* name, Number* x);
static Number* mequation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units);
GType unit_manager_get_type (void) G_GNUC_CONST;
UnitManager* unit_manager_get_default (void);
Number* unit_manager_convert_by_symbol (UnitManager* self, Number* x, const gchar* x_symbol, const gchar* z_symbol);
static void mequation_finalize (Equation* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType number_mode_get_type (void) {
	static volatile gsize number_mode_type_id__volatile = 0;
	if (g_once_init_enter (&number_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{NUMBER_MODE_NORMAL, "NUMBER_MODE_NORMAL", "normal"}, {NUMBER_MODE_SUPERSCRIPT, "NUMBER_MODE_SUPERSCRIPT", "superscript"}, {NUMBER_MODE_SUBSCRIPT, "NUMBER_MODE_SUBSCRIPT", "subscript"}, {0, NULL, NULL}};
		GType number_mode_type_id;
		number_mode_type_id = g_enum_register_static ("NumberMode", values);
		g_once_init_leave (&number_mode_type_id__volatile, number_mode_type_id);
	}
	return number_mode_type_id__volatile;
}


MathEquationState* math_equation_state_construct (GType object_type) {
	MathEquationState* self = NULL;
	self = (MathEquationState*) g_type_create_instance (object_type);
	return self;
}


MathEquationState* math_equation_state_new (void) {
	return math_equation_state_construct (TYPE_MATH_EQUATION_STATE);
}


static void value_math_equation_state_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_math_equation_state_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		math_equation_state_unref (value->data[0].v_pointer);
	}
}


static void value_math_equation_state_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = math_equation_state_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_math_equation_state_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_math_equation_state_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		MathEquationState* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = math_equation_state_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_math_equation_state_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	MathEquationState** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = math_equation_state_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_math_equation_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMathEquationState* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MATH_EQUATION_STATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_math_equation_state (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MATH_EQUATION_STATE), NULL);
	return value->data[0].v_pointer;
}


void value_set_math_equation_state (GValue* value, gpointer v_object) {
	MathEquationState* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MATH_EQUATION_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MATH_EQUATION_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		math_equation_state_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		math_equation_state_unref (old);
	}
}


void value_take_math_equation_state (GValue* value, gpointer v_object) {
	MathEquationState* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MATH_EQUATION_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MATH_EQUATION_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		math_equation_state_unref (old);
	}
}


static void math_equation_state_class_init (MathEquationStateClass * klass) {
	math_equation_state_parent_class = g_type_class_peek_parent (klass);
	MATH_EQUATION_STATE_CLASS (klass)->finalize = math_equation_state_finalize;
}


static void math_equation_state_instance_init (MathEquationState * self) {
	self->ref_count = 1;
}


static void math_equation_state_finalize (MathEquationState* obj) {
	MathEquationState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_EQUATION_STATE, MathEquationState);
	_number_unref0 (self->ans);
	_g_free0 (self->expression);
	_g_free0 (self->status);
}


GType math_equation_state_get_type (void) {
	static volatile gsize math_equation_state_type_id__volatile = 0;
	if (g_once_init_enter (&math_equation_state_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_math_equation_state_init, value_math_equation_state_free_value, value_math_equation_state_copy_value, value_math_equation_state_peek_pointer, "p", value_math_equation_state_collect_value, "p", value_math_equation_state_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MathEquationStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_equation_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathEquationState), 0, (GInstanceInitFunc) math_equation_state_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType math_equation_state_type_id;
		math_equation_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MathEquationState", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&math_equation_state_type_id__volatile, math_equation_state_type_id);
	}
	return math_equation_state_type_id__volatile;
}


gpointer math_equation_state_ref (gpointer instance) {
	MathEquationState* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void math_equation_state_unref (gpointer instance) {
	MathEquationState* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MATH_EQUATION_STATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


SolveData* solve_data_construct (GType object_type) {
	SolveData* self = NULL;
	self = (SolveData*) g_type_create_instance (object_type);
	return self;
}


SolveData* solve_data_new (void) {
	return solve_data_construct (TYPE_SOLVE_DATA);
}


static void value_solve_data_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_solve_data_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		solve_data_unref (value->data[0].v_pointer);
	}
}


static void value_solve_data_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = solve_data_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_solve_data_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_solve_data_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SolveData* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = solve_data_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_solve_data_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SolveData** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = solve_data_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_solve_data (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSolveData* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SOLVE_DATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_solve_data (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOLVE_DATA), NULL);
	return value->data[0].v_pointer;
}


void value_set_solve_data (GValue* value, gpointer v_object) {
	SolveData* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOLVE_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOLVE_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		solve_data_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		solve_data_unref (old);
	}
}


void value_take_solve_data (GValue* value, gpointer v_object) {
	SolveData* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SOLVE_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SOLVE_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		solve_data_unref (old);
	}
}


static void solve_data_class_init (SolveDataClass * klass) {
	solve_data_parent_class = g_type_class_peek_parent (klass);
	SOLVE_DATA_CLASS (klass)->finalize = solve_data_finalize;
}


static void solve_data_instance_init (SolveData * self) {
	self->ref_count = 1;
}


static void solve_data_finalize (SolveData* obj) {
	SolveData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOLVE_DATA, SolveData);
	_number_unref0 (self->number_result);
	_g_free0 (self->text_result);
	_g_free0 (self->error);
}


GType solve_data_get_type (void) {
	static volatile gsize solve_data_type_id__volatile = 0;
	if (g_once_init_enter (&solve_data_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_solve_data_init, value_solve_data_free_value, value_solve_data_copy_value, value_solve_data_peek_pointer, "p", value_solve_data_collect_value, "p", value_solve_data_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SolveDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) solve_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SolveData), 0, (GInstanceInitFunc) solve_data_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType solve_data_type_id;
		solve_data_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SolveData", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&solve_data_type_id__volatile, solve_data_type_id);
	}
	return solve_data_type_id__volatile;
}


gpointer solve_data_ref (gpointer instance) {
	SolveData* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void solve_data_unref (gpointer instance) {
	SolveData* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SOLVE_DATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _math_equation_state_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (math_equation_state_unref (var), NULL));
}


static void _g_list_free__math_equation_state_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _math_equation_state_unref0_, NULL);
	g_list_free (self);
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static void _solve_data_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (solve_data_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


MathEquation* math_equation_construct (GType object_type) {
	MathEquation * self = NULL;
	gboolean use_default_digits;
	static const gunichar default_digits[] = {(gunichar) '0', (gunichar) '1', (gunichar) '2', (gunichar) '3', (gunichar) '4', (gunichar) '5', (gunichar) '6', (gunichar) '7', (gunichar) '8', (gunichar) '9', (gunichar) 'A', (gunichar) 'B', (gunichar) 'C', (gunichar) 'D', (gunichar) 'E', (gunichar) 'F'};
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** ds;
	gint ds_length1;
	gint _ds_size_;
	MathVariables* _tmp23_;
	MathEquationState* _tmp24_;
	MathEquationState* _tmp25_;
	gchar* _tmp26_;
	Serializer* _tmp27_;
	GAsyncQueue* _tmp28_;
	MathEquationState* _tmp29_;
	Number* _tmp30_;
	MathEquationState* _tmp31_;
	GtkTextTag* _tmp32_ = NULL;
	GtkTextTag* _tmp33_;
	self = (MathEquation*) g_object_new (object_type, NULL);
	__g_list_free__math_equation_state_unref0_0 (self->priv->undo_stack);
	self->priv->undo_stack = NULL;
	__g_list_free__math_equation_state_unref0_0 (self->priv->redo_stack);
	self->priv->redo_stack = NULL;
	use_default_digits = TRUE;
	_tmp0_ = _ ("0,1,2,3,4,5,6,7,8,9,A,B,C,D,E,F");
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ",", -1);
	ds = _tmp2_;
	ds_length1 = _vala_array_length (_tmp1_);
	_ds_size_ = ds_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_;
				gboolean _tmp12_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ < 16)) {
					break;
				}
				_tmp8_ = use_default_digits;
				if (_tmp8_) {
					_tmp7_ = TRUE;
				} else {
					gchar** _tmp9_;
					gint _tmp9__length1;
					gint _tmp10_;
					const gchar* _tmp11_;
					_tmp9_ = ds;
					_tmp9__length1 = ds_length1;
					_tmp10_ = i;
					_tmp11_ = _tmp9_[_tmp10_];
					_tmp7_ = _tmp11_ == NULL;
				}
				_tmp12_ = _tmp7_;
				if (_tmp12_) {
					gint _tmp13_;
					gint _tmp14_;
					gunichar _tmp15_;
					gunichar _tmp16_;
					use_default_digits = TRUE;
					_tmp13_ = i;
					_tmp14_ = i;
					_tmp15_ = default_digits[_tmp14_];
					self->priv->digits[_tmp13_] = _tmp15_;
					_tmp16_ = self->priv->digits[_tmp13_];
				} else {
					gint _tmp17_;
					gchar** _tmp18_;
					gint _tmp18__length1;
					gint _tmp19_;
					const gchar* _tmp20_;
					gunichar _tmp21_ = 0U;
					gunichar _tmp22_;
					_tmp17_ = i;
					_tmp18_ = ds;
					_tmp18__length1 = ds_length1;
					_tmp19_ = i;
					_tmp20_ = _tmp18_[_tmp19_];
					_tmp21_ = string_get_char (_tmp20_, (glong) 0);
					self->priv->digits[_tmp17_] = _tmp21_;
					_tmp22_ = self->priv->digits[_tmp17_];
				}
			}
		}
	}
	_tmp23_ = math_variables_new ();
	_g_object_unref0 (self->priv->_variables);
	self->priv->_variables = _tmp23_;
	_tmp24_ = math_equation_state_new ();
	_math_equation_state_unref0 (self->priv->state);
	self->priv->state = _tmp24_;
	_tmp25_ = self->priv->state;
	_tmp26_ = g_strdup ("");
	_g_free0 (_tmp25_->status);
	_tmp25_->status = _tmp26_;
	math_equation_set_word_size (self, 32);
	self->priv->_angle_units = ANGLE_UNIT_DEGREES;
	math_equation_set_source_currency (self, "");
	math_equation_set_target_currency (self, "");
	math_equation_set_source_units (self, "");
	math_equation_set_target_units (self, "");
	_tmp27_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
	_g_object_unref0 (self->priv->_serializer);
	self->priv->_serializer = _tmp27_;
	_tmp28_ = g_async_queue_new_full (_solve_data_unref0_);
	_g_async_queue_unref0 (self->priv->queue);
	self->priv->queue = _tmp28_;
	_tmp29_ = self->priv->state;
	_tmp30_ = number_new_integer ((gint64) 0);
	_number_unref0 (_tmp29_->ans);
	_tmp29_->ans = _tmp30_;
	_tmp31_ = self->priv->state;
	_tmp31_->ans_base = (guint) 10;
	_tmp32_ = gtk_text_buffer_create_tag ((GtkTextBuffer*) self, NULL, "weight", PANGO_WEIGHT_BOLD, NULL, NULL);
	_tmp33_ = _g_object_ref0 (_tmp32_);
	_g_object_unref0 (self->priv->ans_tag);
	self->priv->ans_tag = _tmp33_;
	ds = (_vala_array_free (ds, ds_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


MathEquation* math_equation_new (void) {
	return math_equation_construct (TYPE_MATH_EQUATION);
}


static void math_equation_get_ans_offsets (MathEquation* self, gint* start, gint* end) {
	gint _vala_start = 0;
	gint _vala_end = 0;
	GtkTextMark* _tmp0_;
	GtkTextIter iter = {0};
	GtkTextMark* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	gint _tmp3_ = 0;
	GtkTextMark* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->ans_start_mark;
	if (_tmp0_ == NULL) {
		_vala_start = -1;
		_vala_end = -1;
		if (start) {
			*start = _vala_start;
		}
		if (end) {
			*end = _vala_end;
		}
		return;
	}
	_tmp1_ = self->priv->ans_start_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = gtk_text_iter_get_offset (&iter);
	_vala_start = _tmp3_;
	_tmp4_ = self->priv->ans_end_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
	iter = _tmp5_;
	_tmp6_ = gtk_text_iter_get_offset (&iter);
	_vala_end = _tmp6_;
	if (start) {
		*start = _vala_start;
	}
	if (end) {
		*end = _vala_end;
	}
}


static void math_equation_reformat_ans (MathEquation* self) {
	GtkTextMark* _tmp0_;
	GtkTextIter ans_start = {0};
	GtkTextIter ans_end = {0};
	GtkTextMark* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextMark* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_;
	GtkTextIter _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* orig_ans_text;
	Serializer* _tmp8_;
	Serializer* _tmp9_;
	MathEquationState* _tmp10_;
	Number* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* ans_text;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GtkTextMark* _tmp22_;
	GtkTextIter _tmp23_ = {0};
	GtkTextMark* _tmp24_;
	GtkTextIter _tmp25_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->ans_start_mark;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->ans_start_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
	ans_start = _tmp2_;
	_tmp3_ = self->priv->ans_end_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp4_, _tmp3_);
	ans_end = _tmp4_;
	_tmp5_ = ans_start;
	_tmp6_ = ans_end;
	_tmp7_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp5_, &_tmp6_, FALSE);
	orig_ans_text = _tmp7_;
	_tmp8_ = math_equation_get_serializer (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->state;
	_tmp11_ = _tmp10_->ans;
	_tmp12_ = serializer_to_string (_tmp9_, _tmp11_);
	ans_text = _tmp12_;
	_tmp13_ = orig_ans_text;
	_tmp14_ = ans_text;
	if (g_strcmp0 (_tmp13_, _tmp14_) != 0) {
		GtkTextMark* _tmp15_;
		GtkTextIter _tmp16_ = {0};
		GtkTextMark* _tmp17_;
		GtkTextIter _tmp18_ = {0};
		GtkTextIter _tmp19_;
		const gchar* _tmp20_;
		GtkTextTag* _tmp21_;
		self->priv->in_undo_operation = TRUE;
		self->priv->in_reformat = TRUE;
		gtk_text_buffer_delete ((GtkTextBuffer*) self, &ans_start, &ans_end);
		_tmp15_ = self->priv->ans_start_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp16_, _tmp15_);
		ans_start = _tmp16_;
		_tmp17_ = self->priv->ans_end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp18_, _tmp17_);
		ans_end = _tmp18_;
		_tmp19_ = ans_end;
		_tmp20_ = ans_text;
		_tmp21_ = self->priv->ans_tag;
		gtk_text_buffer_insert_with_tags ((GtkTextBuffer*) self, &_tmp19_, _tmp20_, -1, _tmp21_, NULL);
		self->priv->in_reformat = FALSE;
		self->priv->in_undo_operation = FALSE;
	}
	_tmp22_ = self->priv->ans_start_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp23_, _tmp22_);
	ans_start = _tmp23_;
	_tmp24_ = self->priv->ans_end_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp25_, _tmp24_);
	ans_end = _tmp25_;
	_g_free0 (ans_text);
	_g_free0 (orig_ans_text);
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static void math_equation_reformat_separators (MathEquation* self) {
	gboolean in_number;
	gboolean in_radix;
	gboolean last_is_tsep;
	gint digit_offset;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* text;
	gint ans_start = 0;
	gint ans_end = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint offset;
	gint index;
	gunichar c = 0U;
	g_return_if_fail (self != NULL);
	in_number = FALSE;
	in_radix = FALSE;
	last_is_tsep = FALSE;
	digit_offset = 0;
	self->priv->in_undo_operation = TRUE;
	self->priv->in_reformat = TRUE;
	_tmp0_ = math_equation_get_display (self);
	_tmp1_ = _tmp0_;
	text = _tmp1_;
	math_equation_get_ans_offsets (self, &_tmp2_, &_tmp3_);
	ans_start = _tmp2_;
	ans_end = _tmp3_;
	offset = -1;
	index = 0;
	while (TRUE) {
		const gchar* _tmp4_;
		gunichar _tmp5_ = 0U;
		gboolean _tmp6_ = FALSE;
		gint _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gint _tmp14_;
		gint _tmp15_;
		gboolean _tmp19_;
		gboolean _tmp21_;
		gboolean _tmp23_;
		gboolean _tmp25_;
		gboolean _tmp27_;
		gboolean _tmp32_;
		gboolean expect_tsep;
		gboolean _tmp33_ = FALSE;
		gint _tmp34_;
		gint _tmp35_;
		gboolean _tmp38_;
		gunichar _tmp40_;
		gboolean _tmp41_ = FALSE;
		_tmp4_ = text;
		_tmp6_ = string_get_next_char (_tmp4_, &index, &_tmp5_);
		c = _tmp5_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = offset;
		offset = _tmp7_ + 1;
		_tmp14_ = math_equation_get_number_base (self);
		_tmp15_ = _tmp14_;
		if (_tmp15_ == 10) {
			Serializer* _tmp16_;
			Serializer* _tmp17_;
			gboolean _tmp18_ = FALSE;
			_tmp16_ = math_equation_get_serializer (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = serializer_get_show_thousands_separators (_tmp17_);
			_tmp13_ = _tmp18_;
		} else {
			_tmp13_ = FALSE;
		}
		_tmp19_ = _tmp13_;
		if (_tmp19_) {
			gboolean _tmp20_;
			_tmp20_ = in_number;
			_tmp12_ = _tmp20_;
		} else {
			_tmp12_ = FALSE;
		}
		_tmp21_ = _tmp12_;
		if (_tmp21_) {
			gboolean _tmp22_;
			_tmp22_ = in_radix;
			_tmp11_ = !_tmp22_;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp23_ = _tmp11_;
		if (_tmp23_) {
			gboolean _tmp24_;
			_tmp24_ = last_is_tsep;
			_tmp10_ = !_tmp24_;
		} else {
			_tmp10_ = FALSE;
		}
		_tmp25_ = _tmp10_;
		if (_tmp25_) {
			gint _tmp26_;
			_tmp26_ = digit_offset;
			_tmp9_ = _tmp26_ > 0;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp27_ = _tmp9_;
		if (_tmp27_) {
			gint _tmp28_;
			Serializer* _tmp29_;
			Serializer* _tmp30_;
			gint _tmp31_ = 0;
			_tmp28_ = digit_offset;
			_tmp29_ = math_equation_get_serializer (self);
			_tmp30_ = _tmp29_;
			_tmp31_ = serializer_get_thousands_separator_count (_tmp30_);
			_tmp8_ = (_tmp28_ % _tmp31_) == 0;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp32_ = _tmp8_;
		expect_tsep = _tmp32_;
		last_is_tsep = FALSE;
		_tmp34_ = offset;
		_tmp35_ = ans_start;
		if (_tmp34_ >= _tmp35_) {
			gint _tmp36_;
			gint _tmp37_;
			_tmp36_ = offset;
			_tmp37_ = ans_end;
			_tmp33_ = _tmp36_ <= _tmp37_;
		} else {
			_tmp33_ = FALSE;
		}
		_tmp38_ = _tmp33_;
		if (_tmp38_) {
			gboolean _tmp39_;
			in_radix = FALSE;
			_tmp39_ = in_radix;
			in_number = _tmp39_;
			continue;
		}
		_tmp40_ = c;
		_tmp41_ = g_unichar_isdigit (_tmp40_);
		if (_tmp41_) {
			gboolean _tmp42_;
			gboolean _tmp46_;
			gint _tmp55_;
			_tmp42_ = in_number;
			if (!_tmp42_) {
				const gchar* _tmp43_;
				gint _tmp44_;
				gint _tmp45_ = 0;
				_tmp43_ = text;
				_tmp44_ = index;
				_tmp45_ = math_equation_count_digits (self, _tmp43_, _tmp44_);
				digit_offset = _tmp45_ + 1;
			}
			in_number = TRUE;
			_tmp46_ = expect_tsep;
			if (_tmp46_) {
				GtkTextIter iter = {0};
				gint _tmp47_;
				GtkTextIter _tmp48_ = {0};
				Serializer* _tmp49_;
				Serializer* _tmp50_;
				gunichar _tmp51_ = 0U;
				gchar* _tmp52_ = NULL;
				gchar* _tmp53_;
				gint _tmp54_;
				_tmp47_ = offset;
				gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp48_, _tmp47_);
				iter = _tmp48_;
				_tmp49_ = math_equation_get_serializer (self);
				_tmp50_ = _tmp49_;
				_tmp51_ = serializer_get_thousands_separator (_tmp50_);
				_tmp52_ = g_unichar_to_string (_tmp51_);
				_tmp53_ = _tmp52_;
				gtk_text_buffer_insert (G_TYPE_CHECK_INSTANCE_TYPE (self, GTK_TYPE_TEXT_BUFFER) ? ((GtkTextBuffer*) self) : NULL, &iter, _tmp53_, -1);
				_g_free0 (_tmp53_);
				_tmp54_ = offset;
				offset = _tmp54_ + 1;
				last_is_tsep = TRUE;
			}
			_tmp55_ = digit_offset;
			digit_offset = _tmp55_ - 1;
		} else {
			gunichar _tmp56_;
			Serializer* _tmp57_;
			Serializer* _tmp58_;
			gunichar _tmp59_ = 0U;
			_tmp56_ = c;
			_tmp57_ = math_equation_get_serializer (self);
			_tmp58_ = _tmp57_;
			_tmp59_ = serializer_get_radix (_tmp58_);
			if (_tmp56_ == _tmp59_) {
				in_number = TRUE;
				in_radix = TRUE;
			} else {
				gunichar _tmp60_;
				Serializer* _tmp61_;
				Serializer* _tmp62_;
				gunichar _tmp63_ = 0U;
				_tmp60_ = c;
				_tmp61_ = math_equation_get_serializer (self);
				_tmp62_ = _tmp61_;
				_tmp63_ = serializer_get_thousands_separator (_tmp62_);
				if (_tmp60_ == _tmp63_) {
					gboolean _tmp64_ = FALSE;
					gboolean _tmp65_;
					gboolean _tmp67_;
					_tmp65_ = expect_tsep;
					if (!_tmp65_) {
						gboolean _tmp66_;
						_tmp66_ = in_number;
						_tmp64_ = _tmp66_;
					} else {
						_tmp64_ = FALSE;
					}
					_tmp67_ = _tmp64_;
					if (_tmp67_) {
						GtkTextIter start = {0};
						GtkTextIter end = {0};
						gint _tmp68_;
						GtkTextIter _tmp69_ = {0};
						gint _tmp70_;
						GtkTextIter _tmp71_ = {0};
						gint _tmp72_;
						_tmp68_ = offset;
						gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp69_, _tmp68_);
						start = _tmp69_;
						_tmp70_ = offset;
						gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp71_, _tmp70_ + 1);
						end = _tmp71_;
						gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
						_tmp72_ = offset;
						offset = _tmp72_ - 1;
					} else {
						last_is_tsep = TRUE;
					}
				} else {
					in_number = FALSE;
					in_radix = FALSE;
				}
			}
		}
	}
	self->priv->in_reformat = FALSE;
	self->priv->in_undo_operation = FALSE;
	_g_free0 (text);
}


static gint math_equation_count_digits (MathEquation* self, const gchar* text, gint index) {
	gint result = 0;
	gint count;
	gboolean following_separator;
	gunichar c = 0U;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (text != NULL, 0);
	count = 0;
	following_separator = FALSE;
	while (TRUE) {
		const gchar* _tmp0_;
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_ = FALSE;
		gunichar _tmp3_;
		Serializer* _tmp4_;
		Serializer* _tmp5_;
		gunichar _tmp6_ = 0U;
		_tmp0_ = text;
		_tmp2_ = string_get_next_char (_tmp0_, &index, &_tmp1_);
		c = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		_tmp3_ = c;
		_tmp4_ = math_equation_get_serializer (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = serializer_get_thousands_separator (_tmp5_);
		if (_tmp3_ == _tmp6_) {
			gboolean _tmp7_;
			_tmp7_ = following_separator;
			if (_tmp7_) {
				result = count;
				return result;
			}
			following_separator = TRUE;
		} else {
			gunichar _tmp8_;
			gboolean _tmp9_ = FALSE;
			_tmp8_ = c;
			_tmp9_ = g_unichar_isdigit (_tmp8_);
			if (_tmp9_) {
				gint _tmp10_;
				following_separator = FALSE;
				_tmp10_ = count;
				count = _tmp10_ + 1;
			} else {
				result = count;
				return result;
			}
		}
	}
	result = count;
	return result;
}


static void math_equation_reformat_display (MathEquation* self) {
	g_return_if_fail (self != NULL);
	math_equation_reformat_ans (self);
	math_equation_reformat_separators (self);
}


static gpointer _number_ref0 (gpointer self) {
	return self ? number_ref (self) : NULL;
}


static MathEquationState* math_equation_get_current_state (MathEquation* self) {
	MathEquationState* result = NULL;
	gint ans_start;
	gint ans_end;
	GtkTextMark* _tmp0_;
	MathEquationState* _tmp7_;
	MathEquationState* s;
	MathEquationState* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	MathEquationState* _tmp11_;
	guint _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	NumberMode _tmp17_;
	NumberMode _tmp18_;
	gboolean _tmp19_;
	MathEquationState* _tmp20_;
	gboolean _tmp21_;
	MathEquationState* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	g_return_val_if_fail (self != NULL, NULL);
	ans_start = -1;
	ans_end = -1;
	_tmp0_ = self->priv->ans_start_mark;
	if (_tmp0_ != NULL) {
		GtkTextIter iter = {0};
		GtkTextMark* _tmp1_;
		GtkTextIter _tmp2_ = {0};
		gint _tmp3_ = 0;
		GtkTextMark* _tmp4_;
		GtkTextIter _tmp5_ = {0};
		gint _tmp6_ = 0;
		_tmp1_ = self->priv->ans_start_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
		iter = _tmp2_;
		_tmp3_ = gtk_text_iter_get_offset (&iter);
		ans_start = _tmp3_;
		_tmp4_ = self->priv->ans_end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
		iter = _tmp5_;
		_tmp6_ = gtk_text_iter_get_offset (&iter);
		ans_end = _tmp6_;
	}
	_tmp7_ = math_equation_state_new ();
	s = _tmp7_;
	_tmp8_ = self->priv->state;
	_tmp9_ = _tmp8_->ans;
	_tmp10_ = _number_ref0 (_tmp9_);
	_number_unref0 (s->ans);
	s->ans = _tmp10_;
	_tmp11_ = self->priv->state;
	_tmp12_ = _tmp11_->ans_base;
	s->ans_base = _tmp12_;
	_tmp13_ = math_equation_get_display (self);
	_tmp14_ = _tmp13_;
	_g_free0 (s->expression);
	s->expression = _tmp14_;
	_tmp15_ = ans_start;
	s->ans_start = _tmp15_;
	_tmp16_ = ans_end;
	s->ans_end = _tmp16_;
	g_object_get ((GObject*) self, "cursor-position", &s->cursor, NULL, NULL);
	_tmp17_ = math_equation_get_number_mode (self);
	_tmp18_ = _tmp17_;
	s->number_mode = _tmp18_;
	_tmp19_ = self->priv->can_super_minus;
	s->can_super_minus = _tmp19_;
	_tmp20_ = self->priv->state;
	_tmp21_ = _tmp20_->entered_multiply;
	s->entered_multiply = _tmp21_;
	_tmp22_ = self->priv->state;
	_tmp23_ = _tmp22_->status;
	_tmp24_ = g_strdup (_tmp23_);
	_g_free0 (s->status);
	s->status = _tmp24_;
	result = s;
	return result;
}


static gpointer _math_equation_state_ref0 (gpointer self) {
	return self ? math_equation_state_ref (self) : NULL;
}


static void math_equation_push_undo_stack (MathEquation* self) {
	gboolean _tmp0_;
	MathEquationState* _tmp1_ = NULL;
	MathEquationState* _tmp2_;
	MathEquationState* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->in_undo_operation;
	if (_tmp0_) {
		return;
	}
	math_equation_set_status (self, "");
	__g_list_free__math_equation_state_unref0_0 (self->priv->redo_stack);
	self->priv->redo_stack = NULL;
	_tmp1_ = math_equation_get_current_state (self);
	_math_equation_state_unref0 (self->priv->state);
	self->priv->state = _tmp1_;
	_tmp2_ = self->priv->state;
	_tmp3_ = _math_equation_state_ref0 (_tmp2_);
	self->priv->undo_stack = g_list_prepend (self->priv->undo_stack, _tmp3_);
}


static void math_equation_clear_ans (MathEquation* self, gboolean do_remove_tag) {
	GtkTextMark* _tmp0_;
	gboolean _tmp1_;
	GtkTextMark* _tmp9_;
	GtkTextMark* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->ans_start_mark;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = do_remove_tag;
	if (_tmp1_) {
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		GtkTextMark* _tmp2_;
		GtkTextIter _tmp3_ = {0};
		GtkTextMark* _tmp4_;
		GtkTextIter _tmp5_ = {0};
		GtkTextTag* _tmp6_;
		GtkTextIter _tmp7_;
		GtkTextIter _tmp8_;
		_tmp2_ = self->priv->ans_start_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
		start = _tmp3_;
		_tmp4_ = self->priv->ans_end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
		end = _tmp5_;
		_tmp6_ = self->priv->ans_tag;
		_tmp7_ = start;
		_tmp8_ = end;
		gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, _tmp6_, &_tmp7_, &_tmp8_);
	}
	_tmp9_ = self->priv->ans_start_mark;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp9_);
	_tmp10_ = self->priv->ans_end_mark;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp10_);
	_g_object_unref0 (self->priv->ans_start_mark);
	self->priv->ans_start_mark = NULL;
	_g_object_unref0 (self->priv->ans_end_mark);
	self->priv->ans_end_mark = NULL;
}


static void math_equation_apply_state (MathEquation* self, MathEquationState* s) {
	MathEquationState* _tmp0_;
	MathEquationState* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	MathEquationState* _tmp4_;
	MathEquationState* _tmp5_;
	guint _tmp6_;
	MathEquationState* _tmp7_;
	const gchar* _tmp8_;
	GtkTextIter cursor = {0};
	MathEquationState* _tmp9_;
	gint _tmp10_;
	GtkTextIter _tmp11_ = {0};
	GtkTextIter _tmp12_;
	MathEquationState* _tmp13_;
	gint _tmp14_;
	MathEquationState* _tmp30_;
	NumberMode _tmp31_;
	MathEquationState* _tmp32_;
	gboolean _tmp33_;
	MathEquationState* _tmp34_;
	MathEquationState* _tmp35_;
	gboolean _tmp36_;
	MathEquationState* _tmp37_;
	const gchar* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	self->priv->in_undo_operation = TRUE;
	_tmp0_ = self->priv->state;
	_tmp1_ = s;
	_tmp2_ = _tmp1_->ans;
	_tmp3_ = _number_ref0 (_tmp2_);
	_number_unref0 (_tmp0_->ans);
	_tmp0_->ans = _tmp3_;
	_tmp4_ = self->priv->state;
	_tmp5_ = s;
	_tmp6_ = _tmp5_->ans_base;
	_tmp4_->ans_base = _tmp6_;
	_tmp7_ = s;
	_tmp8_ = _tmp7_->expression;
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp8_, -1);
	_tmp9_ = s;
	_tmp10_ = _tmp9_->cursor;
	gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp11_, _tmp10_);
	cursor = _tmp11_;
	_tmp12_ = cursor;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &_tmp12_);
	math_equation_clear_ans (self, FALSE);
	_tmp13_ = s;
	_tmp14_ = _tmp13_->ans_start;
	if (_tmp14_ >= 0) {
		GtkTextIter start = {0};
		MathEquationState* _tmp15_;
		gint _tmp16_;
		GtkTextIter _tmp17_ = {0};
		GtkTextIter _tmp18_;
		GtkTextMark* _tmp19_ = NULL;
		GtkTextMark* _tmp20_;
		GtkTextIter end = {0};
		MathEquationState* _tmp21_;
		gint _tmp22_;
		GtkTextIter _tmp23_ = {0};
		GtkTextIter _tmp24_;
		GtkTextMark* _tmp25_ = NULL;
		GtkTextMark* _tmp26_;
		GtkTextTag* _tmp27_;
		GtkTextIter _tmp28_;
		GtkTextIter _tmp29_;
		_tmp15_ = s;
		_tmp16_ = _tmp15_->ans_start;
		gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp17_, _tmp16_);
		start = _tmp17_;
		_tmp18_ = start;
		_tmp19_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp18_, FALSE);
		_tmp20_ = _g_object_ref0 (_tmp19_);
		_g_object_unref0 (self->priv->ans_start_mark);
		self->priv->ans_start_mark = _tmp20_;
		_tmp21_ = s;
		_tmp22_ = _tmp21_->ans_end;
		gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp23_, _tmp22_);
		end = _tmp23_;
		_tmp24_ = end;
		_tmp25_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp24_, TRUE);
		_tmp26_ = _g_object_ref0 (_tmp25_);
		_g_object_unref0 (self->priv->ans_end_mark);
		self->priv->ans_end_mark = _tmp26_;
		_tmp27_ = self->priv->ans_tag;
		_tmp28_ = start;
		_tmp29_ = end;
		gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, _tmp27_, &_tmp28_, &_tmp29_);
	}
	_tmp30_ = s;
	_tmp31_ = _tmp30_->number_mode;
	math_equation_set_number_mode (self, _tmp31_);
	_tmp32_ = s;
	_tmp33_ = _tmp32_->can_super_minus;
	self->priv->can_super_minus = _tmp33_;
	_tmp34_ = self->priv->state;
	_tmp35_ = s;
	_tmp36_ = _tmp35_->entered_multiply;
	_tmp34_->entered_multiply = _tmp36_;
	_tmp37_ = s;
	_tmp38_ = _tmp37_->status;
	math_equation_set_status (self, _tmp38_);
	self->priv->in_undo_operation = FALSE;
}


void math_equation_copy (MathEquation* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkTextIter _tmp5_;
	GtkTextIter _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* text;
	GdkAtom _tmp8_;
	GtkClipboard* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp2_ = gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	if (!_tmp2_) {
		GtkTextIter _tmp3_ = {0};
		GtkTextIter _tmp4_ = {0};
		gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp3_, &_tmp4_);
		start = _tmp3_;
		end = _tmp4_;
	}
	_tmp5_ = start;
	_tmp6_ = end;
	_tmp7_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp5_, &_tmp6_, FALSE);
	text = _tmp7_;
	_tmp8_ = GDK_NONE;
	_tmp9_ = gtk_clipboard_get (_tmp8_);
	gtk_clipboard_set_text (_tmp9_, text, -1);
	_g_free0 (text);
}


static void _math_equation_on_paste_gtk_clipboard_text_received_func (GtkClipboard* clipboard, const gchar* text, gpointer self) {
	math_equation_on_paste (self, clipboard, text);
}


void math_equation_paste (MathEquation* self) {
	GdkAtom _tmp0_;
	GtkClipboard* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = GDK_NONE;
	_tmp1_ = gtk_clipboard_get (_tmp0_);
	gtk_clipboard_request_text (_tmp1_, _math_equation_on_paste_gtk_clipboard_text_received_func, self);
}


static gchar* string_delimit (const gchar* self, const gchar* delimiters, gchar new_delimiter) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	_tmp2_ = delimiters;
	_tmp3_ = new_delimiter;
	g_strdelimit (_tmp1_, _tmp2_, _tmp3_);
	result = _result_;
	return result;
}


static void math_equation_on_paste (MathEquation* self, GtkClipboard* clipboard, const gchar* text) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clipboard != NULL);
	_tmp0_ = text;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp1_ = text;
		_tmp2_ = string_delimit (_tmp1_, "\n", ' ');
		_tmp3_ = _tmp2_;
		math_equation_insert (self, _tmp3_);
		_g_free0 (_tmp3_);
	}
}


void math_equation_undo (MathEquation* self) {
	GList* _tmp0_;
	GList* _tmp2_;
	gconstpointer _tmp3_ = NULL;
	MathEquationState* _tmp4_;
	MathEquationState* _tmp5_;
	MathEquationState* _tmp6_ = NULL;
	MathEquationState* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undo_stack;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("No undo history");
		math_equation_set_status (self, _tmp1_);
		return;
	}
	_tmp2_ = self->priv->undo_stack;
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
	_tmp4_ = _math_equation_state_ref0 ((MathEquationState*) _tmp3_);
	_math_equation_state_unref0 (self->priv->state);
	self->priv->state = _tmp4_;
	math_equation_set_status (self, "");
	_tmp5_ = self->priv->state;
	self->priv->undo_stack = g_list_remove (self->priv->undo_stack, _tmp5_);
	_tmp6_ = math_equation_get_current_state (self);
	self->priv->redo_stack = g_list_prepend (self->priv->redo_stack, _tmp6_);
	_tmp7_ = self->priv->state;
	math_equation_apply_state (self, _tmp7_);
}


void math_equation_redo (MathEquation* self) {
	GList* _tmp0_;
	GList* _tmp2_;
	gconstpointer _tmp3_ = NULL;
	MathEquationState* _tmp4_;
	MathEquationState* _tmp5_;
	MathEquationState* _tmp6_ = NULL;
	MathEquationState* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->redo_stack;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("No redo history");
		math_equation_set_status (self, _tmp1_);
		return;
	}
	_tmp2_ = self->priv->redo_stack;
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
	_tmp4_ = _math_equation_state_ref0 ((MathEquationState*) _tmp3_);
	_math_equation_state_unref0 (self->priv->state);
	self->priv->state = _tmp4_;
	_tmp5_ = self->priv->state;
	self->priv->redo_stack = g_list_remove (self->priv->redo_stack, _tmp5_);
	_tmp6_ = math_equation_get_current_state (self);
	self->priv->undo_stack = g_list_prepend (self->priv->undo_stack, _tmp6_);
	_tmp7_ = self->priv->state;
	math_equation_apply_state (self, _tmp7_);
}


gunichar math_equation_get_digit_text (MathEquation* self, guint digit) {
	gunichar result = 0U;
	guint _tmp0_;
	guint _tmp1_;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = digit;
	if (_tmp0_ >= ((guint) 16)) {
		result = (gunichar) '?';
		return result;
	}
	_tmp1_ = digit;
	_tmp2_ = self->priv->digits[_tmp1_];
	result = _tmp2_;
	return result;
}


void math_equation_store (MathEquation* self, const gchar* name) {
	Number* _tmp0_;
	Number* _tmp1_;
	Number* t;
	Number* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = math_equation_get_number (self);
	_tmp1_ = _tmp0_;
	t = _tmp1_;
	_tmp2_ = t;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = _ ("No sane value to store");
		math_equation_set_status (self, _tmp3_);
	} else {
		MathVariables* _tmp4_;
		MathVariables* _tmp5_;
		const gchar* _tmp6_;
		Number* _tmp7_;
		_tmp4_ = math_equation_get_variables (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = name;
		_tmp7_ = t;
		math_variables_set (_tmp5_, _tmp6_, _tmp7_);
	}
	_number_unref0 (t);
}


void math_equation_recall (MathEquation* self, const gchar* name) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	math_equation_insert (self, _tmp0_);
}


void math_equation_set (MathEquation* self, const gchar* text) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp0_, -1);
	math_equation_clear_ans (self, FALSE);
}


void math_equation_set_number (MathEquation* self, Number* x, guint representation_base) {
	guint _tmp0_;
	Serializer* _tmp4_;
	Serializer* _tmp5_;
	Number* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* text;
	guint _tmp8_;
	const gchar* _tmp14_;
	MathEquationState* _tmp15_;
	Number* _tmp16_;
	Number* _tmp17_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp18_ = {0};
	GtkTextIter _tmp19_ = {0};
	GtkTextIter _tmp20_;
	GtkTextMark* _tmp21_ = NULL;
	GtkTextMark* _tmp22_;
	GtkTextIter _tmp23_;
	GtkTextMark* _tmp24_ = NULL;
	GtkTextMark* _tmp25_;
	GtkTextTag* _tmp26_;
	GtkTextIter _tmp27_;
	GtkTextIter _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (x != NULL);
	_tmp0_ = representation_base;
	if (_tmp0_ != ((guint) 0)) {
		Serializer* _tmp1_;
		Serializer* _tmp2_;
		guint _tmp3_;
		_tmp1_ = math_equation_get_serializer (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = representation_base;
		serializer_set_representation_base (_tmp2_, _tmp3_);
	}
	_tmp4_ = math_equation_get_serializer (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = x;
	_tmp7_ = serializer_to_string (_tmp5_, _tmp6_);
	text = _tmp7_;
	_tmp8_ = representation_base;
	if (_tmp8_ != ((guint) 0)) {
		Serializer* _tmp9_;
		Serializer* _tmp10_;
		Serializer* _tmp11_;
		Serializer* _tmp12_;
		gint _tmp13_ = 0;
		_tmp9_ = math_equation_get_serializer (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = math_equation_get_serializer (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = serializer_get_base (_tmp12_);
		serializer_set_representation_base (_tmp10_, (guint) _tmp13_);
	}
	_tmp14_ = text;
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp14_, -1);
	_tmp15_ = self->priv->state;
	_tmp16_ = x;
	_tmp17_ = _number_ref0 (_tmp16_);
	_number_unref0 (_tmp15_->ans);
	_tmp15_->ans = _tmp17_;
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp18_, &_tmp19_);
	start = _tmp18_;
	end = _tmp19_;
	math_equation_clear_ans (self, FALSE);
	_tmp20_ = start;
	_tmp21_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp20_, FALSE);
	_tmp22_ = _g_object_ref0 (_tmp21_);
	_g_object_unref0 (self->priv->ans_start_mark);
	self->priv->ans_start_mark = _tmp22_;
	_tmp23_ = end;
	_tmp24_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp23_, TRUE);
	_tmp25_ = _g_object_ref0 (_tmp24_);
	_g_object_unref0 (self->priv->ans_end_mark);
	self->priv->ans_end_mark = _tmp25_;
	_tmp26_ = self->priv->ans_tag;
	_tmp27_ = start;
	_tmp28_ = end;
	gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, _tmp26_, &_tmp27_, &_tmp28_);
	_g_free0 (text);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


void math_equation_insert (MathEquation* self, const gchar* text) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp8_;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	gint _tmp14_ = 0;
	gboolean _tmp16_;
	const gchar* _tmp17_;
	gint _tmp18_ = 0;
	const gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp2_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) self);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		const gchar* _tmp4_;
		_tmp4_ = text;
		_tmp1_ = g_strcmp0 (_tmp4_, "×") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp5_ = _tmp1_;
	if (_tmp5_) {
		MathEquationState* _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = self->priv->state;
		_tmp7_ = _tmp6_->entered_multiply;
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		GtkTextIter iter = {0};
		GtkTextMark* _tmp9_ = NULL;
		GtkTextIter _tmp10_ = {0};
		GtkTextIter _tmp11_;
		_tmp9_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp10_, _tmp9_);
		iter = _tmp10_;
		_tmp11_ = iter;
		gtk_text_buffer_backspace (G_TYPE_CHECK_INSTANCE_TYPE (self, GTK_TYPE_TEXT_BUFFER) ? ((GtkTextBuffer*) self) : NULL, &_tmp11_, TRUE, TRUE);
		gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self, "^", -1);
		return;
	}
	_tmp13_ = text;
	_tmp14_ = string_index_of ("⁰¹²³⁴⁵⁶⁷⁸⁹", _tmp13_, 0);
	if (_tmp14_ >= 0) {
		_tmp12_ = TRUE;
	} else {
		const gchar* _tmp15_;
		_tmp15_ = text;
		_tmp12_ = g_strcmp0 (_tmp15_, "⁻") == 0;
	}
	_tmp16_ = _tmp12_;
	if (_tmp16_) {
		self->priv->can_super_minus = FALSE;
	}
	_tmp17_ = text;
	_tmp18_ = string_index_of ("⁻⁰¹²³⁴⁵⁶⁷⁸⁹₀₁₂₃₄₅₆₇₈₉", _tmp17_, 0);
	if (_tmp18_ < 0) {
		math_equation_set_number_mode (self, NUMBER_MODE_NORMAL);
	}
	gtk_text_buffer_delete_selection ((GtkTextBuffer*) self, FALSE, FALSE);
	_tmp19_ = text;
	gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self, _tmp19_, -1);
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


void math_equation_insert_square (MathEquation* self) {
	gboolean space_required;
	GtkTextIter iter = {0};
	GtkTextMark* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	space_required = FALSE;
	_tmp0_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp1_, _tmp0_);
	iter = _tmp1_;
	_tmp2_ = gtk_text_iter_backward_char (&iter);
	if (_tmp2_) {
		gunichar _tmp3_ = 0U;
		gunichar previous_character;
		gunichar _tmp4_;
		gint _tmp5_ = 0;
		_tmp3_ = gtk_text_iter_get_char (&iter);
		previous_character = _tmp3_;
		_tmp4_ = previous_character;
		_tmp5_ = string_index_of_char ("⁰¹²³⁴⁵⁶⁷⁸⁹", _tmp4_, 0);
		if (_tmp5_ >= 0) {
			space_required = TRUE;
		}
	}
	_tmp6_ = space_required;
	if (_tmp6_) {
		math_equation_insert (self, " ²");
	} else {
		math_equation_insert (self, "²");
	}
}


void math_equation_insert_digit (MathEquation* self, guint digit) {
	static const gunichar subscript_digits[] = {8320U, 8321U, 8322U, 8323U, 8324U, 8325U, 8326U, 8327U, 8328U, 8329U};
	static const gunichar superscript_digits[] = {8304U, 185U, 178U, 179U, 8308U, 8309U, 8310U, 8311U, 8312U, 8313U};
	guint _tmp0_;
	gboolean _tmp1_ = FALSE;
	NumberMode _tmp2_;
	NumberMode _tmp3_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = digit;
	if (_tmp0_ >= ((guint) 16)) {
		return;
	}
	_tmp2_ = math_equation_get_number_mode (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NUMBER_MODE_NORMAL) {
		_tmp1_ = TRUE;
	} else {
		guint _tmp4_;
		_tmp4_ = digit;
		_tmp1_ = _tmp4_ >= ((guint) 10);
	}
	_tmp5_ = _tmp1_;
	if (_tmp5_) {
		guint _tmp6_;
		gunichar _tmp7_ = 0U;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp6_ = digit;
		_tmp7_ = math_equation_get_digit_text (self, _tmp6_);
		_tmp8_ = g_unichar_to_string (_tmp7_);
		_tmp9_ = _tmp8_;
		math_equation_insert (self, _tmp9_);
		_g_free0 (_tmp9_);
	} else {
		NumberMode _tmp10_;
		NumberMode _tmp11_;
		_tmp10_ = math_equation_get_number_mode (self);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NUMBER_MODE_SUPERSCRIPT) {
			guint _tmp12_;
			gunichar _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			_tmp12_ = digit;
			_tmp13_ = superscript_digits[_tmp12_];
			_tmp14_ = g_unichar_to_string (_tmp13_);
			_tmp15_ = _tmp14_;
			math_equation_insert (self, _tmp15_);
			_g_free0 (_tmp15_);
		} else {
			NumberMode _tmp16_;
			NumberMode _tmp17_;
			_tmp16_ = math_equation_get_number_mode (self);
			_tmp17_ = _tmp16_;
			if (_tmp17_ == NUMBER_MODE_SUBSCRIPT) {
				guint _tmp18_;
				gunichar _tmp19_;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_;
				_tmp18_ = digit;
				_tmp19_ = subscript_digits[_tmp18_];
				_tmp20_ = g_unichar_to_string (_tmp19_);
				_tmp21_ = _tmp20_;
				math_equation_insert (self, _tmp21_);
				_g_free0 (_tmp21_);
			}
		}
	}
}


void math_equation_insert_numeric_point (MathEquation* self) {
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	gunichar _tmp2_ = 0U;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_radix (_tmp1_);
	_tmp3_ = g_unichar_to_string (_tmp2_);
	_tmp4_ = _tmp3_;
	math_equation_insert (self, _tmp4_);
	_g_free0 (_tmp4_);
}


void math_equation_insert_number (MathEquation* self, Number* x) {
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	Number* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (x != NULL);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = serializer_to_string (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	math_equation_insert (self, _tmp4_);
	_g_free0 (_tmp4_);
}


void math_equation_insert_exponent (MathEquation* self) {
	g_return_if_fail (self != NULL);
	math_equation_insert (self, "×10");
	math_equation_set_number_mode (self, NUMBER_MODE_SUPERSCRIPT);
}


void math_equation_insert_subtract (MathEquation* self) {
	gboolean _tmp0_ = FALSE;
	NumberMode _tmp1_;
	NumberMode _tmp2_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = math_equation_get_number_mode (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NUMBER_MODE_SUPERSCRIPT) {
		gboolean _tmp3_;
		_tmp3_ = self->priv->can_super_minus;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		math_equation_insert (self, "⁻");
		self->priv->can_super_minus = FALSE;
	} else {
		math_equation_insert (self, "−");
		math_equation_set_number_mode (self, NUMBER_MODE_NORMAL);
	}
}


static Number* math_equation_parse (MathEquation* self, const gchar* text, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint* error_start, guint* error_end) {
	guint _vala_representation_base = 0U;
	ErrorCode _vala_error_code = 0;
	gchar* _vala_error_token = NULL;
	guint _vala_error_start = 0U;
	guint _vala_error_end = 0U;
	Number* result = NULL;
	const gchar* _tmp0_;
	MEquation* _tmp1_;
	MEquation* equation;
	Serializer* _tmp2_;
	Serializer* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_;
	gint _tmp6_;
	AngleUnit _tmp7_;
	AngleUnit _tmp8_;
	guint _tmp9_ = 0U;
	ErrorCode _tmp10_ = 0;
	gchar* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	Number* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = text;
	_tmp1_ = mequation_new (self, _tmp0_);
	equation = _tmp1_;
	_tmp2_ = math_equation_get_serializer (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = serializer_get_base (_tmp3_);
	((Equation*) equation)->base = _tmp4_;
	_tmp5_ = math_equation_get_word_size (self);
	_tmp6_ = _tmp5_;
	((Equation*) equation)->wordlen = _tmp6_;
	_tmp7_ = math_equation_get_angle_units (self);
	_tmp8_ = _tmp7_;
	((Equation*) equation)->angle_units = _tmp8_;
	_tmp14_ = equation_parse ((Equation*) equation, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_);
	_vala_representation_base = _tmp9_;
	_vala_error_code = _tmp10_;
	_g_free0 (_vala_error_token);
	_vala_error_token = _tmp11_;
	_vala_error_start = _tmp12_;
	_vala_error_end = _tmp13_;
	result = _tmp14_;
	_equation_unref0 (equation);
	if (representation_base) {
		*representation_base = _vala_representation_base;
	}
	if (error_code) {
		*error_code = _vala_error_code;
	}
	if (error_token) {
		*error_token = _vala_error_token;
	} else {
		_g_free0 (_vala_error_token);
	}
	if (error_start) {
		*error_start = _vala_error_start;
	}
	if (error_end) {
		*error_end = _vala_error_end;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gpointer _solve_data_ref0 (gpointer self) {
	return self ? solve_data_ref (self) : NULL;
}


static void* math_equation_solve_real (MathEquation* self) {
	void* result = NULL;
	SolveData* _tmp0_;
	SolveData* solvedata;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* text;
	gint n_brackets;
	ErrorCode error_code = 0;
	gchar* error_token = NULL;
	guint error_start = 0U;
	guint error_end = 0U;
	guint representation_base = 0U;
	const gchar* _tmp21_;
	guint _tmp22_ = 0U;
	ErrorCode _tmp23_ = 0;
	gchar* _tmp24_ = NULL;
	guint _tmp25_ = 0U;
	guint _tmp26_ = 0U;
	Number* _tmp27_ = NULL;
	Number* z;
	SolveData* _tmp28_;
	guint _tmp29_;
	ErrorCode _tmp30_;
	GAsyncQueue* _tmp76_;
	SolveData* _tmp77_;
	SolveData* _tmp78_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = solve_data_new ();
	solvedata = _tmp0_;
	_tmp1_ = math_equation_get_equation (self);
	_tmp2_ = _tmp1_;
	text = _tmp2_;
	n_brackets = 0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				const gchar* _tmp6_;
				gint _tmp7_;
				gchar _tmp8_ = '\0';
				const gchar* _tmp9_;
				gint _tmp10_;
				gchar _tmp11_ = '\0';
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = text;
				_tmp7_ = i;
				_tmp8_ = string_get (_tmp6_, (glong) _tmp7_);
				if (!(_tmp8_ != '\0')) {
					break;
				}
				_tmp9_ = text;
				_tmp10_ = i;
				_tmp11_ = string_get (_tmp9_, (glong) _tmp10_);
				if (_tmp11_ == '(') {
					gint _tmp12_;
					_tmp12_ = n_brackets;
					n_brackets = _tmp12_ + 1;
				} else {
					const gchar* _tmp13_;
					gint _tmp14_;
					gchar _tmp15_ = '\0';
					_tmp13_ = text;
					_tmp14_ = i;
					_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
					if (_tmp15_ == ')') {
						gint _tmp16_;
						_tmp16_ = n_brackets;
						n_brackets = _tmp16_ - 1;
					}
				}
			}
		}
	}
	while (TRUE) {
		gint _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gint _tmp20_;
		_tmp17_ = n_brackets;
		if (!(_tmp17_ > 0)) {
			break;
		}
		_tmp18_ = text;
		_tmp19_ = g_strconcat (_tmp18_, ")", NULL);
		_g_free0 (text);
		text = _tmp19_;
		_tmp20_ = n_brackets;
		n_brackets = _tmp20_ - 1;
	}
	_tmp21_ = text;
	_tmp27_ = math_equation_parse (self, _tmp21_, &_tmp22_, &_tmp23_, &_tmp24_, &_tmp25_, &_tmp26_);
	representation_base = _tmp22_;
	error_code = _tmp23_;
	_g_free0 (error_token);
	error_token = _tmp24_;
	error_start = _tmp25_;
	error_end = _tmp26_;
	z = _tmp27_;
	_tmp28_ = solvedata;
	_tmp29_ = representation_base;
	_tmp28_->representation_base = _tmp29_;
	_tmp30_ = error_code;
	switch (_tmp30_) {
		case ERROR_CODE_NONE:
		{
			SolveData* _tmp31_;
			Number* _tmp32_;
			Number* _tmp33_;
			_tmp31_ = solvedata;
			_tmp32_ = z;
			_tmp33_ = _number_ref0 (_tmp32_);
			_number_unref0 (_tmp31_->number_result);
			_tmp31_->number_result = _tmp33_;
			break;
		}
		case ERROR_CODE_OVERFLOW:
		{
			SolveData* _tmp34_;
			const gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			_tmp34_ = solvedata;
			_tmp35_ = _ ("Overflow. Try a bigger word size");
			_tmp36_ = g_strdup (_tmp35_);
			_g_free0 (_tmp34_->error);
			_tmp34_->error = _tmp36_;
			break;
		}
		case ERROR_CODE_UNKNOWN_VARIABLE:
		{
			SolveData* _tmp37_;
			const gchar* _tmp38_ = NULL;
			const gchar* _tmp39_;
			gchar* _tmp40_ = NULL;
			SolveData* _tmp41_;
			guint _tmp42_;
			SolveData* _tmp43_;
			guint _tmp44_;
			_tmp37_ = solvedata;
			_tmp38_ = _ ("Unknown variable '%s'");
			_tmp39_ = error_token;
			_tmp40_ = g_strdup_printf (_tmp38_, _tmp39_);
			_g_free0 (_tmp37_->error);
			_tmp37_->error = _tmp40_;
			_tmp41_ = solvedata;
			_tmp42_ = error_start;
			_tmp41_->error_start = _tmp42_;
			_tmp43_ = solvedata;
			_tmp44_ = error_end;
			_tmp43_->error_end = _tmp44_;
			break;
		}
		case ERROR_CODE_UNKNOWN_FUNCTION:
		{
			SolveData* _tmp45_;
			const gchar* _tmp46_ = NULL;
			const gchar* _tmp47_;
			gchar* _tmp48_ = NULL;
			SolveData* _tmp49_;
			guint _tmp50_;
			SolveData* _tmp51_;
			guint _tmp52_;
			_tmp45_ = solvedata;
			_tmp46_ = _ ("Function '%s' is not defined");
			_tmp47_ = error_token;
			_tmp48_ = g_strdup_printf (_tmp46_, _tmp47_);
			_g_free0 (_tmp45_->error);
			_tmp45_->error = _tmp48_;
			_tmp49_ = solvedata;
			_tmp50_ = error_start;
			_tmp49_->error_start = _tmp50_;
			_tmp51_ = solvedata;
			_tmp52_ = error_end;
			_tmp51_->error_end = _tmp52_;
			break;
		}
		case ERROR_CODE_UNKNOWN_CONVERSION:
		{
			SolveData* _tmp53_;
			const gchar* _tmp54_ = NULL;
			gchar* _tmp55_;
			_tmp53_ = solvedata;
			_tmp54_ = _ ("Unknown conversion");
			_tmp55_ = g_strdup (_tmp54_);
			_g_free0 (_tmp53_->error);
			_tmp53_->error = _tmp55_;
			break;
		}
		case ERROR_CODE_MP:
		{
			gchar* _tmp56_ = NULL;
			gchar* _tmp57_;
			gboolean _tmp58_;
			_tmp56_ = mp_get_error ();
			_tmp57_ = _tmp56_;
			_tmp58_ = _tmp57_ != NULL;
			_g_free0 (_tmp57_);
			if (_tmp58_) {
				SolveData* _tmp59_;
				gchar* _tmp60_ = NULL;
				_tmp59_ = solvedata;
				_tmp60_ = mp_get_error ();
				_g_free0 (_tmp59_->error);
				_tmp59_->error = _tmp60_;
			} else {
				const gchar* _tmp61_;
				_tmp61_ = error_token;
				if (_tmp61_ != NULL) {
					SolveData* _tmp62_;
					const gchar* _tmp63_ = NULL;
					const gchar* _tmp64_;
					gchar* _tmp65_ = NULL;
					SolveData* _tmp66_;
					guint _tmp67_;
					SolveData* _tmp68_;
					guint _tmp69_;
					_tmp62_ = solvedata;
					_tmp63_ = _ ("Malformed expression at token '%s'");
					_tmp64_ = error_token;
					_tmp65_ = g_strdup_printf (_tmp63_, _tmp64_);
					_g_free0 (_tmp62_->error);
					_tmp62_->error = _tmp65_;
					_tmp66_ = solvedata;
					_tmp67_ = error_start;
					_tmp66_->error_start = _tmp67_;
					_tmp68_ = solvedata;
					_tmp69_ = error_end;
					_tmp68_->error_end = _tmp69_;
				} else {
					SolveData* _tmp70_;
					const gchar* _tmp71_ = NULL;
					gchar* _tmp72_;
					_tmp70_ = solvedata;
					_tmp71_ = _ ("Malformed expression");
					_tmp72_ = g_strdup (_tmp71_);
					_g_free0 (_tmp70_->error);
					_tmp70_->error = _tmp72_;
				}
			}
			break;
		}
		default:
		{
			SolveData* _tmp73_;
			const gchar* _tmp74_ = NULL;
			gchar* _tmp75_;
			_tmp73_ = solvedata;
			_tmp74_ = _ ("Malformed expression");
			_tmp75_ = g_strdup (_tmp74_);
			_g_free0 (_tmp73_->error);
			_tmp73_->error = _tmp75_;
			break;
		}
	}
	_tmp76_ = self->priv->queue;
	_tmp77_ = solvedata;
	_tmp78_ = _solve_data_ref0 (_tmp77_);
	g_async_queue_push (_tmp76_, _tmp78_);
	result = NULL;
	_number_unref0 (z);
	_g_free0 (error_token);
	_g_free0 (text);
	_solve_data_unref0 (solvedata);
	return result;
}


static gboolean math_equation_show_in_progress (MathEquation* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = math_equation_get_in_solve (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = _ ("Calculating");
		math_equation_set_status (self, _tmp2_);
	}
	result = FALSE;
	return result;
}


static gboolean math_equation_look_for_answer (MathEquation* self) {
	gboolean result = FALSE;
	GAsyncQueue* _tmp0_;
	gpointer _tmp1_ = NULL;
	SolveData* _result_;
	SolveData* _tmp2_;
	SolveData* _tmp3_;
	const gchar* _tmp4_;
	SolveData* _tmp5_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->queue;
	_tmp1_ = g_async_queue_try_pop (_tmp0_);
	_result_ = (SolveData*) _tmp1_;
	_tmp2_ = _result_;
	if (_tmp2_ == NULL) {
		result = TRUE;
		_solve_data_unref0 (_result_);
		return result;
	}
	self->priv->_in_solve = FALSE;
	_tmp3_ = _result_;
	_tmp4_ = _tmp3_->error;
	if (_tmp4_ == NULL) {
		math_equation_set_status (self, "");
	}
	_tmp5_ = _result_;
	_tmp6_ = _tmp5_->error;
	if (_tmp6_ != NULL) {
		SolveData* _tmp7_;
		const gchar* _tmp8_;
		MathEquationState* _tmp9_;
		SolveData* _tmp10_;
		guint _tmp11_;
		MathEquationState* _tmp12_;
		SolveData* _tmp13_;
		guint _tmp14_;
		_tmp7_ = _result_;
		_tmp8_ = _tmp7_->error;
		math_equation_set_status (self, _tmp8_);
		_tmp9_ = self->priv->state;
		_tmp10_ = _result_;
		_tmp11_ = _tmp10_->error_start;
		_tmp9_->error_token_start = _tmp11_;
		_tmp12_ = self->priv->state;
		_tmp13_ = _result_;
		_tmp14_ = _tmp13_->error_end;
		_tmp12_->error_token_end = _tmp14_;
		math_equation_error_token_fix_thousands_separator (self);
		g_object_notify ((GObject*) self, "error-token-end");
	} else {
		SolveData* _tmp15_;
		Number* _tmp16_;
		_tmp15_ = _result_;
		_tmp16_ = _tmp15_->number_result;
		if (_tmp16_ != NULL) {
			SolveData* _tmp17_;
			Number* _tmp18_;
			SolveData* _tmp19_;
			guint _tmp20_;
			_tmp17_ = _result_;
			_tmp18_ = _tmp17_->number_result;
			_tmp19_ = _result_;
			_tmp20_ = _tmp19_->representation_base;
			math_equation_set_number (self, _tmp18_, _tmp20_);
		} else {
			SolveData* _tmp21_;
			const gchar* _tmp22_;
			_tmp21_ = _result_;
			_tmp22_ = _tmp21_->text_result;
			if (_tmp22_ != NULL) {
				SolveData* _tmp23_;
				const gchar* _tmp24_;
				_tmp23_ = _result_;
				_tmp24_ = _tmp23_->text_result;
				math_equation_set (self, _tmp24_);
			}
		}
	}
	result = FALSE;
	_solve_data_unref0 (_result_);
	return result;
}


static gpointer _math_equation_solve_real_gthread_func (gpointer self) {
	gpointer result;
	result = math_equation_solve_real (self);
	g_object_unref (self);
	return result;
}


static gboolean _math_equation_look_for_answer_gsource_func (gpointer self) {
	gboolean result;
	result = math_equation_look_for_answer (self);
	return result;
}


static gboolean _math_equation_show_in_progress_gsource_func (gpointer self) {
	gboolean result;
	result = math_equation_show_in_progress (self);
	return result;
}


void math_equation_solve (MathEquation* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GThread* _tmp6_;
	GThread* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_in_solve (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = math_equation_get_is_empty (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		return;
	}
	_tmp4_ = math_equation_get_is_result (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		math_equation_undo (self);
		return;
	}
	self->priv->_in_solve = TRUE;
	math_equation_set_number_mode (self, NUMBER_MODE_NORMAL);
	_tmp6_ = g_thread_new ("", _math_equation_solve_real_gthread_func, g_object_ref (self));
	_tmp7_ = _tmp6_;
	_g_thread_unref0 (_tmp7_);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 50, _math_equation_look_for_answer_gsource_func, g_object_ref (self), g_object_unref);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _math_equation_show_in_progress_gsource_func, g_object_ref (self), g_object_unref);
}


static void math_equation_error_token_fix_thousands_separator (MathEquation* self) {
	GtkTextIter start = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_;
	GtkTextIter temp;
	GtkTextIter _tmp2_;
	GtkTextIter end;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	Serializer* _tmp7_;
	Serializer* _tmp8_;
	gunichar _tmp9_ = 0U;
	gchar* _tmp10_ = NULL;
	gchar* str;
	const gchar* _tmp11_;
	gint _tmp12_ = 0;
	gint length;
	GtkTextIter _tmp27_;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp0_);
	start = _tmp0_;
	_tmp1_ = start;
	temp = _tmp1_;
	_tmp2_ = start;
	end = _tmp2_;
	_tmp3_ = math_equation_get_error_token_start (self);
	_tmp4_ = _tmp3_;
	gtk_text_iter_set_offset (&start, (gint) _tmp4_);
	_tmp5_ = math_equation_get_error_token_end (self);
	_tmp6_ = _tmp5_;
	gtk_text_iter_set_offset (&end, (gint) _tmp6_);
	_tmp7_ = math_equation_get_serializer (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = serializer_get_thousands_separator (_tmp8_);
	_tmp10_ = g_unichar_to_string (_tmp9_);
	str = _tmp10_;
	_tmp11_ = str;
	_tmp12_ = g_utf8_strlen (_tmp11_, (gssize) (-1));
	length = _tmp12_;
	while (TRUE) {
		const gchar* _tmp13_;
		GtkTextIter _tmp14_;
		GtkTextIter _tmp15_ = {0};
		gboolean _tmp16_ = FALSE;
		MathEquationState* _tmp17_;
		MathEquationState* _tmp18_;
		guint _tmp19_;
		gint _tmp20_;
		MathEquationState* _tmp21_;
		MathEquationState* _tmp22_;
		guint _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		_tmp13_ = str;
		_tmp14_ = start;
		_tmp16_ = gtk_text_iter_forward_search (&temp, _tmp13_, GTK_TEXT_SEARCH_TEXT_ONLY, NULL, &_tmp15_, &_tmp14_);
		temp = _tmp15_;
		if (!_tmp16_) {
			break;
		}
		_tmp17_ = self->priv->state;
		_tmp18_ = self->priv->state;
		_tmp19_ = _tmp18_->error_token_start;
		_tmp20_ = length;
		_tmp18_->error_token_start = _tmp19_ + _tmp20_;
		_tmp21_ = self->priv->state;
		_tmp22_ = self->priv->state;
		_tmp23_ = _tmp22_->error_token_end;
		_tmp24_ = length;
		_tmp22_->error_token_end = _tmp23_ + _tmp24_;
		_tmp25_ = length;
		gtk_text_iter_forward_chars (&start, _tmp25_);
		_tmp26_ = length;
		gtk_text_iter_forward_chars (&start, _tmp26_);
	}
	_tmp27_ = start;
	temp = _tmp27_;
	while (TRUE) {
		const gchar* _tmp28_;
		GtkTextIter _tmp29_;
		GtkTextIter _tmp30_ = {0};
		gboolean _tmp31_ = FALSE;
		MathEquationState* _tmp32_;
		MathEquationState* _tmp33_;
		guint _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		_tmp28_ = str;
		_tmp29_ = end;
		_tmp31_ = gtk_text_iter_forward_search (&temp, _tmp28_, GTK_TEXT_SEARCH_TEXT_ONLY, NULL, &_tmp30_, &_tmp29_);
		temp = _tmp30_;
		if (!_tmp31_) {
			break;
		}
		_tmp32_ = self->priv->state;
		_tmp33_ = self->priv->state;
		_tmp34_ = _tmp33_->error_token_end;
		_tmp35_ = length;
		_tmp33_->error_token_end = _tmp34_ + _tmp35_;
		_tmp36_ = length;
		gtk_text_iter_forward_chars (&end, _tmp36_);
	}
	_g_free0 (str);
}


static void _number_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (number_unref (var), NULL));
}


static void _g_list_free__number_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _number_unref0_, NULL);
	g_list_free (self);
}


static void* math_equation_factorize_real (MathEquation* self) {
	void* result = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* x;
	Number* _tmp2_;
	GList* _tmp3_ = NULL;
	GList* factors;
	gchar* _tmp4_;
	gchar* text;
	gint i;
	GList* _tmp5_;
	SolveData* _tmp18_;
	SolveData* _result_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	GAsyncQueue* _tmp21_;
	SolveData* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = math_equation_get_number (self);
	_tmp1_ = _tmp0_;
	x = _tmp1_;
	_tmp2_ = x;
	_tmp3_ = number_factorize (_tmp2_);
	factors = _tmp3_;
	_tmp4_ = g_strdup ("");
	text = _tmp4_;
	i = 0;
	_tmp5_ = factors;
	{
		GList* factor_collection = NULL;
		GList* factor_it = NULL;
		factor_collection = _tmp5_;
		for (factor_it = factor_collection; factor_it != NULL; factor_it = factor_it->next) {
			Number* _tmp6_;
			Number* factor = NULL;
			_tmp6_ = _number_ref0 ((Number*) factor_it->data);
			factor = _tmp6_;
			{
				gint _tmp7_;
				const gchar* _tmp10_;
				Serializer* _tmp11_;
				Serializer* _tmp12_;
				Number* _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gint _tmp17_;
				_tmp7_ = i;
				if (_tmp7_ != 0) {
					const gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = text;
					_tmp9_ = g_strconcat (_tmp8_, "×", NULL);
					_g_free0 (text);
					text = _tmp9_;
				}
				_tmp10_ = text;
				_tmp11_ = math_equation_get_serializer (self);
				_tmp12_ = _tmp11_;
				_tmp13_ = factor;
				_tmp14_ = serializer_to_string (_tmp12_, _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat (_tmp10_, _tmp15_, NULL);
				_g_free0 (text);
				text = _tmp16_;
				_g_free0 (_tmp15_);
				_tmp17_ = i;
				i = _tmp17_ + 1;
				_number_unref0 (factor);
			}
		}
	}
	_tmp18_ = solve_data_new ();
	_result_ = _tmp18_;
	_tmp19_ = text;
	_tmp20_ = g_strdup (_tmp19_);
	_g_free0 (_result_->text_result);
	_result_->text_result = _tmp20_;
	_tmp21_ = self->priv->queue;
	_tmp22_ = _solve_data_ref0 (_result_);
	g_async_queue_push (_tmp21_, _tmp22_);
	result = NULL;
	_solve_data_unref0 (_result_);
	_g_free0 (text);
	__g_list_free__number_unref0_0 (factors);
	_number_unref0 (x);
	return result;
}


static gpointer _math_equation_factorize_real_gthread_func (gpointer self) {
	gpointer result;
	result = math_equation_factorize_real (self);
	g_object_unref (self);
	return result;
}


void math_equation_factorize (MathEquation* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* x;
	gboolean _tmp4_ = FALSE;
	Number* _tmp5_;
	gboolean _tmp8_;
	GThread* _tmp10_;
	GThread* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_in_solve (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = math_equation_get_number (self);
	_tmp3_ = _tmp2_;
	x = _tmp3_;
	_tmp5_ = x;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		Number* _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = x;
		_tmp7_ = number_is_integer (_tmp6_);
		_tmp4_ = !_tmp7_;
	}
	_tmp8_ = _tmp4_;
	if (_tmp8_) {
		const gchar* _tmp9_ = NULL;
		_tmp9_ = _ ("Need an integer to factorize");
		math_equation_set_status (self, _tmp9_);
		_number_unref0 (x);
		return;
	}
	self->priv->_in_solve = TRUE;
	_tmp10_ = g_thread_new ("", _math_equation_factorize_real_gthread_func, g_object_ref (self));
	_tmp11_ = _tmp10_;
	_g_thread_unref0 (_tmp11_);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 50, _math_equation_look_for_answer_gsource_func, g_object_ref (self), g_object_unref);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _math_equation_show_in_progress_gsource_func, g_object_ref (self), g_object_unref);
	_number_unref0 (x);
}


void math_equation_delete_next (MathEquation* self) {
	gint cursor = 0;
	gint _tmp0_;
	gint _tmp1_ = 0;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	gint _tmp2_;
	GtkTextIter _tmp3_ = {0};
	gint _tmp4_;
	GtkTextIter _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	g_object_get ((GObject*) self, "cursor-position", &cursor, NULL, NULL);
	_tmp0_ = cursor;
	_tmp1_ = gtk_text_buffer_get_char_count ((GtkTextBuffer*) self);
	if (_tmp0_ >= _tmp1_) {
		return;
	}
	_tmp2_ = cursor;
	gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
	start = _tmp3_;
	_tmp4_ = cursor;
	gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp5_, _tmp4_ + 1);
	end = _tmp5_;
	gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
}


void math_equation_backspace (MathEquation* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_is_empty (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gtk_text_buffer_delete_selection ((GtkTextBuffer*) self, FALSE, FALSE);
	} else {
		GtkTextIter iter = {0};
		GtkTextMark* _tmp4_ = NULL;
		GtkTextIter _tmp5_ = {0};
		GtkTextIter _tmp6_;
		_tmp4_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
		iter = _tmp5_;
		_tmp6_ = iter;
		gtk_text_buffer_backspace (G_TYPE_CHECK_INSTANCE_TYPE (self, GTK_TYPE_TEXT_BUFFER) ? ((GtkTextBuffer*) self) : NULL, &_tmp6_, TRUE, TRUE);
	}
}


void math_equation_clear (MathEquation* self) {
	g_return_if_fail (self != NULL);
	math_equation_set_number_mode (self, NUMBER_MODE_NORMAL);
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, "", -1);
	math_equation_clear_ans (self, FALSE);
}


void math_equation_shift (MathEquation* self, gint count) {
	Number* _tmp0_;
	Number* _tmp1_;
	Number* z;
	Number* _tmp2_;
	Number* _tmp4_;
	gint _tmp5_;
	Number* _tmp6_ = NULL;
	Number* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_number (self);
	_tmp1_ = _tmp0_;
	z = _tmp1_;
	_tmp2_ = z;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = _ ("No sane value to bitwise shift");
		math_equation_set_status (self, _tmp3_);
		_number_unref0 (z);
		return;
	}
	_tmp4_ = z;
	_tmp5_ = count;
	_tmp6_ = number_shift (_tmp4_, _tmp5_);
	_tmp7_ = _tmp6_;
	math_equation_set_number (self, _tmp7_, (guint) 0);
	_number_unref0 (_tmp7_);
	_number_unref0 (z);
}


void math_equation_toggle_bit (MathEquation* self, guint bit) {
	Number* _tmp0_;
	Number* _tmp1_;
	Number* x;
	guint64 _tmp2_;
	Number* _tmp3_;
	Number* max;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	Number* _tmp6_;
	gboolean _tmp9_;
	gboolean _tmp13_;
	Number* _tmp15_;
	guint64 _tmp16_ = 0ULL;
	guint64 bits;
	guint64 _tmp17_;
	guint _tmp18_;
	guint64 _tmp19_;
	Number* _tmp20_;
	Number* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_number (self);
	_tmp1_ = _tmp0_;
	x = _tmp1_;
	_tmp2_ = G_MAXUINT64;
	_tmp3_ = number_new_unsigned_integer (_tmp2_);
	max = _tmp3_;
	_tmp6_ = x;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		Number* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = x;
		_tmp8_ = number_is_negative (_tmp7_);
		_tmp5_ = _tmp8_;
	}
	_tmp9_ = _tmp5_;
	if (_tmp9_) {
		_tmp4_ = TRUE;
	} else {
		Number* _tmp10_;
		Number* _tmp11_;
		gint _tmp12_ = 0;
		_tmp10_ = x;
		_tmp11_ = max;
		_tmp12_ = number_compare (_tmp10_, _tmp11_);
		_tmp4_ = _tmp12_ > 0;
	}
	_tmp13_ = _tmp4_;
	if (_tmp13_) {
		const gchar* _tmp14_ = NULL;
		_tmp14_ = _ ("Displayed value not an integer");
		math_equation_set_status (self, _tmp14_);
		_number_unref0 (max);
		_number_unref0 (x);
		return;
	}
	_tmp15_ = x;
	_tmp16_ = number_to_unsigned_integer (_tmp15_);
	bits = _tmp16_;
	_tmp17_ = bits;
	_tmp18_ = bit;
	bits = _tmp17_ ^ (1LL << (63 - _tmp18_));
	_tmp19_ = bits;
	_tmp20_ = number_new_unsigned_integer (_tmp19_);
	_number_unref0 (x);
	x = _tmp20_;
	_tmp21_ = x;
	math_equation_set_number (self, _tmp21_, (guint) 0);
	_number_unref0 (max);
	_number_unref0 (x);
}


static void math_equation_real_insert_text (GtkTextBuffer* base, GtkTextIter* location, const gchar* text, gint len) {
	MathEquation * self;
	gboolean _tmp0_;
	gboolean _tmp3_;
	const gchar* _tmp4_;
	gunichar _tmp5_ = 0U;
	gunichar c;
	gint cursor = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gunichar _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp15_;
	gboolean _tmp18_;
	gboolean _tmp21_;
	GtkTextMark* _tmp23_;
	const gchar* _tmp33_;
	gint _tmp34_;
	MathEquationState* _tmp35_;
	const gchar* _tmp36_;
	self = (MathEquation*) base;
	g_return_if_fail (location != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->in_reformat;
	if (_tmp0_) {
		const gchar* _tmp1_;
		gint _tmp2_;
		_tmp1_ = text;
		_tmp2_ = len;
		GTK_TEXT_BUFFER_CLASS (math_equation_parent_class)->insert_text (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_TEXT_BUFFER, GtkTextBuffer), location, _tmp1_, _tmp2_);
		return;
	}
	_tmp3_ = self->priv->in_delete;
	if (!_tmp3_) {
		math_equation_push_undo_stack (self);
	}
	_tmp4_ = text;
	_tmp5_ = string_get_char (_tmp4_, (glong) 0);
	c = _tmp5_;
	g_object_get ((GObject*) self, "cursor-position", &cursor, NULL, NULL);
	_tmp9_ = c;
	_tmp10_ = g_unichar_isdigit (_tmp9_);
	if (_tmp10_) {
		_tmp8_ = TRUE;
	} else {
		gunichar _tmp11_;
		Serializer* _tmp12_;
		Serializer* _tmp13_;
		gunichar _tmp14_ = 0U;
		_tmp11_ = c;
		_tmp12_ = math_equation_get_serializer (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = serializer_get_radix (_tmp13_);
		_tmp8_ = _tmp11_ == _tmp14_;
	}
	_tmp15_ = _tmp8_;
	if (_tmp15_) {
		gboolean _tmp16_;
		gboolean _tmp17_;
		_tmp16_ = math_equation_get_is_result (self);
		_tmp17_ = _tmp16_;
		_tmp7_ = _tmp17_;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp18_ = _tmp7_;
	if (_tmp18_) {
		gint _tmp19_;
		gint _tmp20_ = 0;
		_tmp19_ = cursor;
		_tmp20_ = gtk_text_buffer_get_char_count ((GtkTextBuffer*) self);
		_tmp6_ = _tmp19_ >= _tmp20_;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp21_ = _tmp6_;
	if (_tmp21_) {
		GtkTextIter _tmp22_ = {0};
		gtk_text_buffer_set_text ((GtkTextBuffer*) self, "", -1);
		math_equation_clear_ans (self, FALSE);
		gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp22_);
		*location = _tmp22_;
	}
	_tmp23_ = self->priv->ans_start_mark;
	if (_tmp23_ != NULL) {
		gint _tmp24_ = 0;
		gint offset;
		gint ans_start = 0;
		gint ans_end = 0;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		gboolean _tmp27_ = FALSE;
		gint _tmp28_;
		gint _tmp29_;
		gboolean _tmp32_;
		_tmp24_ = gtk_text_iter_get_offset (location);
		offset = _tmp24_;
		math_equation_get_ans_offsets (self, &_tmp25_, &_tmp26_);
		ans_start = _tmp25_;
		ans_end = _tmp26_;
		_tmp28_ = offset;
		_tmp29_ = ans_start;
		if (_tmp28_ > _tmp29_) {
			gint _tmp30_;
			gint _tmp31_;
			_tmp30_ = offset;
			_tmp31_ = ans_end;
			_tmp27_ = _tmp30_ < _tmp31_;
		} else {
			_tmp27_ = FALSE;
		}
		_tmp32_ = _tmp27_;
		if (_tmp32_) {
			math_equation_clear_ans (self, TRUE);
		}
	}
	_tmp33_ = text;
	_tmp34_ = len;
	GTK_TEXT_BUFFER_CLASS (math_equation_parent_class)->insert_text (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_TEXT_BUFFER, GtkTextBuffer), location, _tmp33_, _tmp34_);
	_tmp35_ = self->priv->state;
	_tmp36_ = text;
	_tmp35_->entered_multiply = g_strcmp0 (_tmp36_, "×") == 0;
	math_equation_reformat_separators (self);
	g_object_notify ((GObject*) self, "display");
}


static gboolean __lambda8_ (MathEquation* self) {
	gboolean result = FALSE;
	self->priv->in_delete = FALSE;
	result = FALSE;
	return result;
}


static gboolean ___lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda8_ (self);
	return result;
}


static void math_equation_real_delete_range (GtkTextBuffer* base, GtkTextIter* start, GtkTextIter* end) {
	MathEquation * self;
	gboolean _tmp0_;
	GtkTextMark* _tmp3_;
	GtkTextIter _tmp14_;
	GtkTextIter _tmp15_;
	MathEquationState* _tmp16_;
	self = (MathEquation*) base;
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	_tmp0_ = self->priv->in_reformat;
	if (_tmp0_) {
		GtkTextIter _tmp1_;
		GtkTextIter _tmp2_;
		_tmp1_ = *start;
		_tmp2_ = *end;
		GTK_TEXT_BUFFER_CLASS (math_equation_parent_class)->delete_range (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_TEXT_BUFFER, GtkTextBuffer), &_tmp1_, &_tmp2_);
		return;
	}
	math_equation_push_undo_stack (self);
	self->priv->in_delete = TRUE;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda8__gsource_func, g_object_ref (self), g_object_unref);
	_tmp3_ = self->priv->ans_start_mark;
	if (_tmp3_ != NULL) {
		gint _tmp4_ = 0;
		gint start_offset;
		gint _tmp5_ = 0;
		gint end_offset;
		gint ans_start = 0;
		gint ans_end = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
		gint _tmp9_;
		gint _tmp10_;
		gboolean _tmp13_;
		_tmp4_ = gtk_text_iter_get_offset (start);
		start_offset = _tmp4_;
		_tmp5_ = gtk_text_iter_get_offset (end);
		end_offset = _tmp5_;
		math_equation_get_ans_offsets (self, &_tmp6_, &_tmp7_);
		ans_start = _tmp6_;
		ans_end = _tmp7_;
		_tmp9_ = start_offset;
		_tmp10_ = ans_end;
		if (_tmp9_ < _tmp10_) {
			gint _tmp11_;
			gint _tmp12_;
			_tmp11_ = end_offset;
			_tmp12_ = ans_start;
			_tmp8_ = _tmp11_ > _tmp12_;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp13_ = _tmp8_;
		if (_tmp13_) {
			math_equation_clear_ans (self, TRUE);
		}
	}
	_tmp14_ = *start;
	_tmp15_ = *end;
	GTK_TEXT_BUFFER_CLASS (math_equation_parent_class)->delete_range (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_TEXT_BUFFER, GtkTextBuffer), &_tmp14_, &_tmp15_);
	_tmp16_ = self->priv->state;
	_tmp16_->entered_multiply = FALSE;
	math_equation_reformat_separators (self);
	g_object_notify ((GObject*) self, "display");
}


gint math_equation_get_word_size (MathEquation* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_word_size;
	result = _tmp0_;
	return result;
}


void math_equation_set_word_size (MathEquation* self, gint value) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_word_size;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->_word_size = _tmp2_;
	g_object_notify ((GObject*) self, "word-size");
	g_object_notify ((GObject *) self, "word-size");
}


gchar* math_equation_get_source_currency (MathEquation* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_currency;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


void math_equation_set_source_currency (MathEquation* self, const gchar* value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_source_currency;
	_tmp1_ = value;
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
		return;
	}
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_source_currency);
	self->priv->_source_currency = _tmp3_;
	g_object_notify ((GObject *) self, "source-currency");
}


gchar* math_equation_get_target_currency (MathEquation* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_target_currency;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


void math_equation_set_target_currency (MathEquation* self, const gchar* value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_target_currency;
	_tmp1_ = value;
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
		return;
	}
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_target_currency);
	self->priv->_target_currency = _tmp3_;
	g_object_notify ((GObject *) self, "target-currency");
}


gchar* math_equation_get_source_units (MathEquation* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_units;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


void math_equation_set_source_units (MathEquation* self, const gchar* value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_source_units;
	_tmp1_ = value;
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
		return;
	}
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_source_units);
	self->priv->_source_units = _tmp3_;
	g_object_notify ((GObject *) self, "source-units");
}


gchar* math_equation_get_target_units (MathEquation* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_target_units;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


void math_equation_set_target_units (MathEquation* self, const gchar* value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_target_units;
	_tmp1_ = value;
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
		return;
	}
	_tmp2_ = value;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_target_units);
	self->priv->_target_units = _tmp3_;
	g_object_notify ((GObject *) self, "target-units");
}


gchar* math_equation_get_display (MathEquation* self) {
	gchar* result;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_;
	GtkTextIter _tmp3_;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	_tmp2_ = start;
	_tmp3_ = end;
	_tmp4_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp2_, &_tmp3_, FALSE);
	result = _tmp4_;
	return result;
}


gboolean math_equation_get_in_solve (MathEquation* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_in_solve;
	result = _tmp0_;
	return result;
}


MathVariables* math_equation_get_variables (MathEquation* self) {
	MathVariables* result;
	MathVariables* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_variables;
	result = _tmp0_;
	return result;
}


Serializer* math_equation_get_serializer (MathEquation* self) {
	Serializer* result;
	Serializer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_serializer;
	result = _tmp0_;
	return result;
}


gint math_equation_get_accuracy (MathEquation* self) {
	gint result;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_trailing_digits (_tmp1_);
	result = _tmp2_;
	return result;
}


void math_equation_set_accuracy (MathEquation* self, gint value) {
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_;
	Serializer* _tmp4_;
	Serializer* _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_trailing_digits (_tmp1_);
	_tmp3_ = value;
	if (_tmp2_ == _tmp3_) {
		return;
	}
	_tmp4_ = math_equation_get_serializer (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = value;
	serializer_set_trailing_digits (_tmp5_, _tmp6_);
	math_equation_reformat_display (self);
	g_object_notify ((GObject*) self, "accuracy");
	g_object_notify ((GObject *) self, "accuracy");
}


gboolean math_equation_get_show_thousands_separators (MathEquation* self) {
	gboolean result;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_show_thousands_separators (_tmp1_);
	result = _tmp2_;
	return result;
}


void math_equation_set_show_thousands_separators (MathEquation* self, gboolean value) {
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	Serializer* _tmp4_;
	Serializer* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_show_thousands_separators (_tmp1_);
	_tmp3_ = value;
	if (_tmp2_ == _tmp3_) {
		return;
	}
	_tmp4_ = math_equation_get_serializer (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = value;
	serializer_set_show_thousands_separators (_tmp5_, _tmp6_);
	math_equation_reformat_display (self);
	g_object_notify ((GObject*) self, "show-thousands-separators");
	g_object_notify ((GObject *) self, "show-thousands-separators");
}


gboolean math_equation_get_show_trailing_zeroes (MathEquation* self) {
	gboolean result;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_show_trailing_zeroes (_tmp1_);
	result = _tmp2_;
	return result;
}


void math_equation_set_show_trailing_zeroes (MathEquation* self, gboolean value) {
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	Serializer* _tmp4_;
	Serializer* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_show_trailing_zeroes (_tmp1_);
	_tmp3_ = value;
	if (_tmp2_ == _tmp3_) {
		return;
	}
	_tmp4_ = math_equation_get_serializer (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = value;
	serializer_set_show_trailing_zeroes (_tmp5_, _tmp6_);
	math_equation_reformat_display (self);
	g_object_notify ((GObject*) self, "show-trailing-zeroes");
	g_object_notify ((GObject *) self, "show-trailing-zeroes");
}


DisplayFormat math_equation_get_number_format (MathEquation* self) {
	DisplayFormat result;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	DisplayFormat _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_number_format (_tmp1_);
	result = _tmp2_;
	return result;
}


void math_equation_set_number_format (MathEquation* self, DisplayFormat value) {
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	DisplayFormat _tmp2_ = 0;
	DisplayFormat _tmp3_;
	Serializer* _tmp4_;
	Serializer* _tmp5_;
	DisplayFormat _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_number_format (_tmp1_);
	_tmp3_ = value;
	if (_tmp2_ == _tmp3_) {
		return;
	}
	_tmp4_ = math_equation_get_serializer (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = value;
	serializer_set_number_format (_tmp5_, _tmp6_);
	math_equation_reformat_display (self);
	g_object_notify ((GObject*) self, "number-format");
	g_object_notify ((GObject *) self, "number-format");
}


gint math_equation_get_number_base (MathEquation* self) {
	gint result;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = math_equation_get_serializer (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_get_base (_tmp1_);
	result = _tmp2_;
	return result;
}


void math_equation_set_number_base (MathEquation* self, gint value) {
	gboolean _tmp0_ = FALSE;
	Serializer* _tmp1_;
	Serializer* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gboolean _tmp9_;
	Serializer* _tmp10_;
	Serializer* _tmp11_;
	gint _tmp12_;
	Serializer* _tmp13_;
	Serializer* _tmp14_;
	gint _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp1_ = math_equation_get_serializer (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = serializer_get_base (_tmp2_);
	_tmp4_ = value;
	if (_tmp3_ == _tmp4_) {
		Serializer* _tmp5_;
		Serializer* _tmp6_;
		guint _tmp7_ = 0U;
		gint _tmp8_;
		_tmp5_ = math_equation_get_serializer (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = serializer_get_representation_base (_tmp6_);
		_tmp8_ = value;
		_tmp0_ = _tmp7_ == ((guint) _tmp8_);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		return;
	}
	_tmp10_ = math_equation_get_serializer (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = value;
	serializer_set_base (_tmp11_, _tmp12_);
	_tmp13_ = math_equation_get_serializer (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = value;
	serializer_set_representation_base (_tmp14_, (guint) _tmp15_);
	math_equation_reformat_display (self);
	g_object_notify ((GObject*) self, "number-base");
	g_object_notify ((GObject *) self, "number-base");
}


AngleUnit math_equation_get_angle_units (MathEquation* self) {
	AngleUnit result;
	AngleUnit _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_angle_units;
	result = _tmp0_;
	return result;
}


void math_equation_set_angle_units (MathEquation* self, AngleUnit value) {
	AngleUnit _tmp0_;
	AngleUnit _tmp1_;
	AngleUnit _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_angle_units;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->_angle_units = _tmp2_;
	g_object_notify ((GObject*) self, "angle-units");
	g_object_notify ((GObject *) self, "angle-units");
}


gchar* math_equation_get_status (MathEquation* self) {
	gchar* result;
	MathEquationState* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = _tmp0_->status;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}


void math_equation_set_status (MathEquation* self, const gchar* value) {
	MathEquationState* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	MathEquationState* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = _tmp0_->status;
	_tmp2_ = value;
	if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
		return;
	}
	_tmp3_ = self->priv->state;
	_tmp4_ = value;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (_tmp3_->status);
	_tmp3_->status = _tmp5_;
	g_object_notify ((GObject*) self, "status");
	g_object_notify ((GObject *) self, "status");
}


guint math_equation_get_error_token_start (MathEquation* self) {
	guint result;
	gint ans_start = 0;
	gint ans_end = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	gboolean _tmp7_;
	MathEquationState* _tmp12_;
	guint _tmp13_;
	g_return_val_if_fail (self != NULL, 0U);
	math_equation_get_ans_offsets (self, &_tmp0_, &_tmp1_);
	ans_start = _tmp0_;
	ans_end = _tmp1_;
	_tmp3_ = ans_start;
	if (_tmp3_ != (-1)) {
		gint _tmp4_;
		MathEquationState* _tmp5_;
		guint _tmp6_;
		_tmp4_ = ans_start;
		_tmp5_ = self->priv->state;
		_tmp6_ = _tmp5_->error_token_start;
		_tmp2_ = ((guint) _tmp4_) < _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		MathEquationState* _tmp8_;
		guint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp8_ = self->priv->state;
		_tmp9_ = _tmp8_->error_token_start;
		_tmp10_ = ans_end;
		_tmp11_ = ans_start;
		result = ((_tmp9_ + _tmp10_) - _tmp11_) - 3;
		return result;
	}
	_tmp12_ = self->priv->state;
	_tmp13_ = _tmp12_->error_token_start;
	result = _tmp13_;
	return result;
}


guint math_equation_get_error_token_end (MathEquation* self) {
	guint result;
	gint ans_start = 0;
	gint ans_end = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	gboolean _tmp7_;
	MathEquationState* _tmp12_;
	guint _tmp13_;
	g_return_val_if_fail (self != NULL, 0U);
	math_equation_get_ans_offsets (self, &_tmp0_, &_tmp1_);
	ans_start = _tmp0_;
	ans_end = _tmp1_;
	_tmp3_ = ans_start;
	if (_tmp3_ != (-1)) {
		gint _tmp4_;
		MathEquationState* _tmp5_;
		guint _tmp6_;
		_tmp4_ = ans_start;
		_tmp5_ = self->priv->state;
		_tmp6_ = _tmp5_->error_token_end;
		_tmp2_ = ((guint) _tmp4_) < _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		MathEquationState* _tmp8_;
		guint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp8_ = self->priv->state;
		_tmp9_ = _tmp8_->error_token_end;
		_tmp10_ = ans_end;
		_tmp11_ = ans_start;
		result = ((_tmp9_ + _tmp10_) - _tmp11_) - 3;
		return result;
	}
	_tmp12_ = self->priv->state;
	_tmp13_ = _tmp12_->error_token_end;
	result = _tmp13_;
	return result;
}


gboolean math_equation_get_is_empty (MathEquation* self) {
	gboolean result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_text_buffer_get_char_count ((GtkTextBuffer*) self);
	result = _tmp0_ == 0;
	return result;
}


gboolean math_equation_get_is_result (MathEquation* self) {
	gboolean result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = math_equation_get_equation (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "ans") == 0;
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* string_splice (const gchar* self, glong start, glong end, const gchar* str) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	gsize str_size = 0UL;
	const gchar* _tmp20_;
	gint _tmp24_;
	gint _tmp25_;
	glong _tmp26_;
	glong _tmp27_;
	gsize _tmp28_;
	void* _tmp29_ = NULL;
	const gchar* _result_;
	const gchar* _tmp30_;
	gchar* dest;
	gchar* _tmp31_;
	glong _tmp32_;
	gchar* _tmp33_;
	glong _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	gsize _tmp37_;
	gchar* _tmp38_;
	gsize _tmp39_;
	gchar* _tmp40_;
	glong _tmp41_;
	glong _tmp42_;
	glong _tmp43_;
	const gchar* _tmp44_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = str;
	if (_tmp20_ == NULL) {
		str_size = (gsize) 0;
	} else {
		const gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp21_ = str;
		_tmp22_ = strlen ((const gchar*) _tmp21_);
		_tmp23_ = _tmp22_;
		str_size = (gsize) _tmp23_;
	}
	_tmp24_ = strlen (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = end;
	_tmp27_ = start;
	_tmp28_ = str_size;
	_tmp29_ = g_malloc0 (((_tmp25_ - (_tmp26_ - _tmp27_)) + _tmp28_) + 1);
	_result_ = _tmp29_;
	_tmp30_ = _result_;
	dest = (gchar*) _tmp30_;
	_tmp31_ = dest;
	_tmp32_ = start;
	memcpy (_tmp31_, self, (gsize) _tmp32_);
	_tmp33_ = dest;
	_tmp34_ = start;
	dest = _tmp33_ + _tmp34_;
	_tmp35_ = dest;
	_tmp36_ = str;
	_tmp37_ = str_size;
	memcpy (_tmp35_, _tmp36_, _tmp37_);
	_tmp38_ = dest;
	_tmp39_ = str_size;
	dest = _tmp38_ + _tmp39_;
	_tmp40_ = dest;
	_tmp41_ = end;
	_tmp42_ = string_length;
	_tmp43_ = end;
	memcpy (_tmp40_, ((gchar*) self) + _tmp41_, (gsize) (_tmp42_ - _tmp43_));
	_tmp44_ = _result_;
	_result_ = NULL;
	result = (gchar*) _tmp44_;
	return result;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


gchar* math_equation_get_equation (MathEquation* self) {
	gchar* result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* text;
	gchar* _tmp2_;
	gchar* eq_text;
	gint ans_start;
	gint ans_end;
	GtkTextMark* _tmp3_;
	gint _tmp6_;
	gboolean last_is_digit;
	gint index;
	gunichar c = 0U;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = math_equation_get_display (self);
	_tmp1_ = _tmp0_;
	text = _tmp1_;
	_tmp2_ = g_strdup ("");
	eq_text = _tmp2_;
	ans_start = -1;
	ans_end = -1;
	_tmp3_ = self->priv->ans_start_mark;
	if (_tmp3_ != NULL) {
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		math_equation_get_ans_offsets (self, &_tmp4_, &_tmp5_);
		ans_start = _tmp4_;
		ans_end = _tmp5_;
	}
	_tmp6_ = ans_start;
	if (_tmp6_ >= 0) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_ = 0;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_ = 0;
		gchar* _tmp14_ = NULL;
		_tmp7_ = text;
		_tmp8_ = text;
		_tmp9_ = ans_start;
		_tmp10_ = string_index_of_nth_char (_tmp8_, (glong) _tmp9_);
		_tmp11_ = text;
		_tmp12_ = ans_end;
		_tmp13_ = string_index_of_nth_char (_tmp11_, (glong) _tmp12_);
		_tmp14_ = string_splice (_tmp7_, (glong) _tmp10_, (glong) _tmp13_, "ans");
		_g_free0 (text);
		text = _tmp14_;
	}
	last_is_digit = FALSE;
	index = 0;
	while (TRUE) {
		const gchar* _tmp15_;
		gunichar _tmp16_ = 0U;
		gboolean _tmp17_ = FALSE;
		gunichar _tmp18_;
		gboolean _tmp19_ = FALSE;
		gboolean is_digit;
		gboolean next_is_digit;
		gunichar next_char = 0U;
		gint _tmp20_;
		gint i;
		const gchar* _tmp21_;
		gunichar _tmp22_ = 0U;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		gunichar _tmp28_;
		Serializer* _tmp29_;
		Serializer* _tmp30_;
		gunichar _tmp31_ = 0U;
		gboolean _tmp33_;
		gboolean _tmp35_;
		gboolean _tmp53_;
		_tmp15_ = text;
		_tmp17_ = string_get_next_char (_tmp15_, &index, &_tmp16_);
		c = _tmp16_;
		if (!_tmp17_) {
			break;
		}
		_tmp18_ = c;
		_tmp19_ = g_unichar_isdigit (_tmp18_);
		is_digit = _tmp19_;
		next_is_digit = FALSE;
		_tmp20_ = index;
		i = _tmp20_;
		_tmp21_ = text;
		_tmp23_ = string_get_next_char (_tmp21_, &i, &_tmp22_);
		next_char = _tmp22_;
		if (_tmp23_) {
			gunichar _tmp24_;
			gboolean _tmp25_ = FALSE;
			_tmp24_ = next_char;
			_tmp25_ = g_unichar_isdigit (_tmp24_);
			next_is_digit = _tmp25_;
		}
		_tmp28_ = c;
		_tmp29_ = math_equation_get_serializer (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = serializer_get_thousands_separator (_tmp30_);
		if (_tmp28_ == _tmp31_) {
			gboolean _tmp32_;
			_tmp32_ = last_is_digit;
			_tmp27_ = _tmp32_;
		} else {
			_tmp27_ = FALSE;
		}
		_tmp33_ = _tmp27_;
		if (_tmp33_) {
			gboolean _tmp34_;
			_tmp34_ = next_is_digit;
			_tmp26_ = _tmp34_;
		} else {
			_tmp26_ = FALSE;
		}
		_tmp35_ = _tmp26_;
		if (_tmp35_) {
		} else {
			gboolean _tmp36_ = FALSE;
			gunichar _tmp37_;
			Serializer* _tmp38_;
			Serializer* _tmp39_;
			gunichar _tmp40_ = 0U;
			gboolean _tmp45_;
			_tmp37_ = c;
			_tmp38_ = math_equation_get_serializer (self);
			_tmp39_ = _tmp38_;
			_tmp40_ = serializer_get_radix (_tmp39_);
			if (_tmp37_ == _tmp40_) {
				gboolean _tmp41_ = FALSE;
				gboolean _tmp42_;
				gboolean _tmp44_;
				_tmp42_ = last_is_digit;
				if (_tmp42_) {
					_tmp41_ = TRUE;
				} else {
					gboolean _tmp43_;
					_tmp43_ = next_is_digit;
					_tmp41_ = _tmp43_;
				}
				_tmp44_ = _tmp41_;
				_tmp36_ = _tmp44_;
			} else {
				_tmp36_ = FALSE;
			}
			_tmp45_ = _tmp36_;
			if (_tmp45_) {
				const gchar* _tmp46_;
				gchar* _tmp47_;
				_tmp46_ = eq_text;
				_tmp47_ = g_strconcat (_tmp46_, ".", NULL);
				_g_free0 (eq_text);
				eq_text = _tmp47_;
			} else {
				const gchar* _tmp48_;
				gunichar _tmp49_;
				gchar* _tmp50_ = NULL;
				gchar* _tmp51_;
				gchar* _tmp52_;
				_tmp48_ = eq_text;
				_tmp49_ = c;
				_tmp50_ = g_unichar_to_string (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = g_strconcat (_tmp48_, _tmp51_, NULL);
				_g_free0 (eq_text);
				eq_text = _tmp52_;
				_g_free0 (_tmp51_);
			}
		}
		_tmp53_ = is_digit;
		last_is_digit = _tmp53_;
	}
	result = eq_text;
	_g_free0 (text);
	return result;
}


Number* math_equation_get_number (MathEquation* self) {
	Number* result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = math_equation_get_is_result (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		Number* _tmp2_;
		Number* _tmp3_;
		Number* _tmp4_;
		_tmp2_ = math_equation_get_answer (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _number_ref0 (_tmp3_);
		result = _tmp4_;
		return result;
	} else {
		Serializer* _tmp5_;
		Serializer* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		Number* _tmp10_ = NULL;
		Number* _tmp11_;
		_tmp5_ = math_equation_get_serializer (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = math_equation_get_equation (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = serializer_from_string (_tmp6_, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		result = _tmp11_;
		return result;
	}
}


NumberMode math_equation_get_number_mode (MathEquation* self) {
	NumberMode result;
	NumberMode _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_number_mode;
	result = _tmp0_;
	return result;
}


void math_equation_set_number_mode (MathEquation* self, NumberMode value) {
	NumberMode _tmp0_;
	NumberMode _tmp1_;
	NumberMode _tmp2_;
	NumberMode _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_number_mode;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->can_super_minus = _tmp2_ == NUMBER_MODE_SUPERSCRIPT;
	_tmp3_ = value;
	self->priv->_number_mode = _tmp3_;
	g_object_notify ((GObject*) self, "number-mode");
	g_object_notify ((GObject *) self, "number-mode");
}


Number* math_equation_get_answer (MathEquation* self) {
	Number* result;
	MathEquationState* _tmp0_;
	Number* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = _tmp0_->ans;
	result = _tmp1_;
	return result;
}


static void math_equation_class_init (MathEquationClass * klass) {
	math_equation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathEquationPrivate));
	GTK_TEXT_BUFFER_CLASS (klass)->insert_text = math_equation_real_insert_text;
	GTK_TEXT_BUFFER_CLASS (klass)->delete_range = math_equation_real_delete_range;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_equation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_equation_set_property;
	G_OBJECT_CLASS (klass)->finalize = math_equation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_WORD_SIZE, g_param_spec_int ("word-size", "word-size", "word-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SOURCE_CURRENCY, g_param_spec_string ("source-currency", "source-currency", "source-currency", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_TARGET_CURRENCY, g_param_spec_string ("target-currency", "target-currency", "target-currency", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SOURCE_UNITS, g_param_spec_string ("source-units", "source-units", "source-units", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_TARGET_UNITS, g_param_spec_string ("target-units", "target-units", "target-units", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_DISPLAY, g_param_spec_string ("display", "display", "display", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_IN_SOLVE, g_param_spec_boolean ("in-solve", "in-solve", "in-solve", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_VARIABLES, g_param_spec_object ("variables", "variables", "variables", TYPE_MATH_VARIABLES, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SERIALIZER, g_param_spec_object ("serializer", "serializer", "serializer", TYPE_SERIALIZER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ACCURACY, g_param_spec_int ("accuracy", "accuracy", "accuracy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS, g_param_spec_boolean ("show-thousands-separators", "show-thousands-separators", "show-thousands-separators", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SHOW_TRAILING_ZEROES, g_param_spec_boolean ("show-trailing-zeroes", "show-trailing-zeroes", "show-trailing-zeroes", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_NUMBER_FORMAT, g_param_spec_enum ("number-format", "number-format", "number-format", TYPE_DISPLAY_FORMAT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_NUMBER_BASE, g_param_spec_int ("number-base", "number-base", "number-base", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ANGLE_UNITS, g_param_spec_enum ("angle-units", "angle-units", "angle-units", TYPE_ANGLE_UNIT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_STATUS, g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ERROR_TOKEN_START, g_param_spec_uint ("error-token-start", "error-token-start", "error-token-start", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ERROR_TOKEN_END, g_param_spec_uint ("error-token-end", "error-token-end", "error-token-end", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_IS_EMPTY, g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_IS_RESULT, g_param_spec_boolean ("is-result", "is-result", "is-result", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_EQUATION, g_param_spec_string ("equation", "equation", "equation", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_NUMBER, param_spec_number ("number", "number", "number", TYPE_NUMBER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_NUMBER_MODE, g_param_spec_enum ("number-mode", "number-mode", "number-mode", TYPE_NUMBER_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ANSWER, param_spec_number ("answer", "answer", "answer", TYPE_NUMBER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void math_equation_instance_init (MathEquation * self) {
	self->priv = MATH_EQUATION_GET_PRIVATE (self);
	self->priv->ans_start_mark = NULL;
	self->priv->ans_end_mark = NULL;
}


static void math_equation_finalize (GObject* obj) {
	MathEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_EQUATION, MathEquation);
	_g_object_unref0 (self->priv->ans_tag);
	_g_free0 (self->priv->_source_currency);
	_g_free0 (self->priv->_target_currency);
	_g_free0 (self->priv->_source_units);
	_g_free0 (self->priv->_target_units);
	_g_object_unref0 (self->priv->ans_start_mark);
	_g_object_unref0 (self->priv->ans_end_mark);
	_math_equation_state_unref0 (self->priv->state);
	__g_list_free__math_equation_state_unref0_0 (self->priv->undo_stack);
	__g_list_free__math_equation_state_unref0_0 (self->priv->redo_stack);
	_g_object_unref0 (self->priv->_variables);
	_g_object_unref0 (self->priv->_serializer);
	_g_async_queue_unref0 (self->priv->queue);
	G_OBJECT_CLASS (math_equation_parent_class)->finalize (obj);
}


GType math_equation_get_type (void) {
	static volatile gsize math_equation_type_id__volatile = 0;
	if (g_once_init_enter (&math_equation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathEquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_equation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathEquation), 0, (GInstanceInitFunc) math_equation_instance_init, NULL };
		GType math_equation_type_id;
		math_equation_type_id = g_type_register_static (GTK_TYPE_TEXT_BUFFER, "MathEquation", &g_define_type_info, 0);
		g_once_init_leave (&math_equation_type_id__volatile, math_equation_type_id);
	}
	return math_equation_type_id__volatile;
}


static void _vala_math_equation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_EQUATION, MathEquation);
	switch (property_id) {
		case MATH_EQUATION_WORD_SIZE:
		g_value_set_int (value, math_equation_get_word_size (self));
		break;
		case MATH_EQUATION_SOURCE_CURRENCY:
		g_value_take_string (value, math_equation_get_source_currency (self));
		break;
		case MATH_EQUATION_TARGET_CURRENCY:
		g_value_take_string (value, math_equation_get_target_currency (self));
		break;
		case MATH_EQUATION_SOURCE_UNITS:
		g_value_take_string (value, math_equation_get_source_units (self));
		break;
		case MATH_EQUATION_TARGET_UNITS:
		g_value_take_string (value, math_equation_get_target_units (self));
		break;
		case MATH_EQUATION_DISPLAY:
		g_value_take_string (value, math_equation_get_display (self));
		break;
		case MATH_EQUATION_IN_SOLVE:
		g_value_set_boolean (value, math_equation_get_in_solve (self));
		break;
		case MATH_EQUATION_VARIABLES:
		g_value_set_object (value, math_equation_get_variables (self));
		break;
		case MATH_EQUATION_SERIALIZER:
		g_value_set_object (value, math_equation_get_serializer (self));
		break;
		case MATH_EQUATION_ACCURACY:
		g_value_set_int (value, math_equation_get_accuracy (self));
		break;
		case MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS:
		g_value_set_boolean (value, math_equation_get_show_thousands_separators (self));
		break;
		case MATH_EQUATION_SHOW_TRAILING_ZEROES:
		g_value_set_boolean (value, math_equation_get_show_trailing_zeroes (self));
		break;
		case MATH_EQUATION_NUMBER_FORMAT:
		g_value_set_enum (value, math_equation_get_number_format (self));
		break;
		case MATH_EQUATION_NUMBER_BASE:
		g_value_set_int (value, math_equation_get_number_base (self));
		break;
		case MATH_EQUATION_ANGLE_UNITS:
		g_value_set_enum (value, math_equation_get_angle_units (self));
		break;
		case MATH_EQUATION_STATUS:
		g_value_take_string (value, math_equation_get_status (self));
		break;
		case MATH_EQUATION_ERROR_TOKEN_START:
		g_value_set_uint (value, math_equation_get_error_token_start (self));
		break;
		case MATH_EQUATION_ERROR_TOKEN_END:
		g_value_set_uint (value, math_equation_get_error_token_end (self));
		break;
		case MATH_EQUATION_IS_EMPTY:
		g_value_set_boolean (value, math_equation_get_is_empty (self));
		break;
		case MATH_EQUATION_IS_RESULT:
		g_value_set_boolean (value, math_equation_get_is_result (self));
		break;
		case MATH_EQUATION_EQUATION:
		g_value_take_string (value, math_equation_get_equation (self));
		break;
		case MATH_EQUATION_NUMBER:
		value_take_number (value, math_equation_get_number (self));
		break;
		case MATH_EQUATION_NUMBER_MODE:
		g_value_set_enum (value, math_equation_get_number_mode (self));
		break;
		case MATH_EQUATION_ANSWER:
		value_set_number (value, math_equation_get_answer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_math_equation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MathEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_EQUATION, MathEquation);
	switch (property_id) {
		case MATH_EQUATION_WORD_SIZE:
		math_equation_set_word_size (self, g_value_get_int (value));
		break;
		case MATH_EQUATION_SOURCE_CURRENCY:
		math_equation_set_source_currency (self, g_value_get_string (value));
		break;
		case MATH_EQUATION_TARGET_CURRENCY:
		math_equation_set_target_currency (self, g_value_get_string (value));
		break;
		case MATH_EQUATION_SOURCE_UNITS:
		math_equation_set_source_units (self, g_value_get_string (value));
		break;
		case MATH_EQUATION_TARGET_UNITS:
		math_equation_set_target_units (self, g_value_get_string (value));
		break;
		case MATH_EQUATION_ACCURACY:
		math_equation_set_accuracy (self, g_value_get_int (value));
		break;
		case MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS:
		math_equation_set_show_thousands_separators (self, g_value_get_boolean (value));
		break;
		case MATH_EQUATION_SHOW_TRAILING_ZEROES:
		math_equation_set_show_trailing_zeroes (self, g_value_get_boolean (value));
		break;
		case MATH_EQUATION_NUMBER_FORMAT:
		math_equation_set_number_format (self, g_value_get_enum (value));
		break;
		case MATH_EQUATION_NUMBER_BASE:
		math_equation_set_number_base (self, g_value_get_int (value));
		break;
		case MATH_EQUATION_ANGLE_UNITS:
		math_equation_set_angle_units (self, g_value_get_enum (value));
		break;
		case MATH_EQUATION_STATUS:
		math_equation_set_status (self, g_value_get_string (value));
		break;
		case MATH_EQUATION_NUMBER_MODE:
		math_equation_set_number_mode (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


MEquation* mequation_construct (GType object_type, MathEquation* m_equation, const gchar* equation) {
	MEquation* self = NULL;
	const gchar* _tmp0_;
	MathEquation* _tmp1_;
	MathEquation* _tmp2_;
	g_return_val_if_fail (m_equation != NULL, NULL);
	g_return_val_if_fail (equation != NULL, NULL);
	_tmp0_ = equation;
	self = (MEquation*) equation_construct (object_type, _tmp0_);
	_tmp1_ = m_equation;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->m_equation);
	self->priv->m_equation = _tmp2_;
	return self;
}


MEquation* mequation_new (MathEquation* m_equation, const gchar* equation) {
	return mequation_construct (TYPE_MEQUATION, m_equation, equation);
}


static gboolean mequation_real_variable_is_defined (Equation* base, const gchar* name) {
	MEquation * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* lower_name;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_;
	MathEquation* _tmp6_;
	MathVariables* _tmp7_;
	MathVariables* _tmp8_;
	const gchar* _tmp9_;
	Number* _tmp10_ = NULL;
	Number* _tmp11_;
	gboolean _tmp12_;
	self = (MEquation*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = name;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) (-1));
	lower_name = _tmp1_;
	_tmp3_ = lower_name;
	if (g_strcmp0 (_tmp3_, "rand") == 0) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = lower_name;
		_tmp2_ = g_strcmp0 (_tmp4_, "ans") == 0;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		result = TRUE;
		_g_free0 (lower_name);
		return result;
	}
	_tmp6_ = self->priv->m_equation;
	_tmp7_ = math_equation_get_variables (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = name;
	_tmp10_ = math_variables_get (_tmp8_, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_ != NULL;
	_number_unref0 (_tmp11_);
	result = _tmp12_;
	_g_free0 (lower_name);
	return result;
}


static Number* mequation_real_get_variable (Equation* base, const gchar* name) {
	MEquation * self;
	Number* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* lower_name;
	const gchar* _tmp2_;
	self = (MEquation*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) (-1));
	lower_name = _tmp1_;
	_tmp2_ = lower_name;
	if (g_strcmp0 (_tmp2_, "rand") == 0) {
		Number* _tmp3_;
		_tmp3_ = number_new_random ();
		result = _tmp3_;
		_g_free0 (lower_name);
		return result;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = lower_name;
		if (g_strcmp0 (_tmp4_, "ans") == 0) {
			MathEquation* _tmp5_;
			Number* _tmp6_;
			Number* _tmp7_;
			Number* _tmp8_;
			_tmp5_ = self->priv->m_equation;
			_tmp6_ = math_equation_get_answer (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _number_ref0 (_tmp7_);
			result = _tmp8_;
			_g_free0 (lower_name);
			return result;
		} else {
			MathEquation* _tmp9_;
			MathVariables* _tmp10_;
			MathVariables* _tmp11_;
			const gchar* _tmp12_;
			Number* _tmp13_ = NULL;
			_tmp9_ = self->priv->m_equation;
			_tmp10_ = math_equation_get_variables (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = name;
			_tmp13_ = math_variables_get (_tmp11_, _tmp12_);
			result = _tmp13_;
			_g_free0 (lower_name);
			return result;
		}
	}
	_g_free0 (lower_name);
}


static void mequation_real_set_variable (Equation* base, const gchar* name, Number* x) {
	MEquation * self;
	MathEquation* _tmp0_;
	MathVariables* _tmp1_;
	MathVariables* _tmp2_;
	const gchar* _tmp3_;
	Number* _tmp4_;
	self = (MEquation*) base;
	g_return_if_fail (name != NULL);
	g_return_if_fail (x != NULL);
	_tmp0_ = self->priv->m_equation;
	_tmp1_ = math_equation_get_variables (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = name;
	_tmp4_ = x;
	math_variables_set (_tmp2_, _tmp3_, _tmp4_);
}


static Number* mequation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units) {
	MEquation * self;
	Number* result = NULL;
	UnitManager* _tmp0_ = NULL;
	UnitManager* _tmp1_;
	Number* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	Number* _tmp5_ = NULL;
	Number* _tmp6_;
	self = (MEquation*) base;
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_units != NULL, NULL);
	g_return_val_if_fail (z_units != NULL, NULL);
	_tmp0_ = unit_manager_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = x_units;
	_tmp4_ = z_units;
	_tmp5_ = unit_manager_convert_by_symbol (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp1_);
	result = _tmp6_;
	return result;
}


static void mequation_class_init (MEquationClass * klass) {
	mequation_parent_class = g_type_class_peek_parent (klass);
	EQUATION_CLASS (klass)->finalize = mequation_finalize;
	g_type_class_add_private (klass, sizeof (MEquationPrivate));
	EQUATION_CLASS (klass)->variable_is_defined = mequation_real_variable_is_defined;
	EQUATION_CLASS (klass)->get_variable = mequation_real_get_variable;
	EQUATION_CLASS (klass)->set_variable = mequation_real_set_variable;
	EQUATION_CLASS (klass)->convert = mequation_real_convert;
}


static void mequation_instance_init (MEquation * self) {
	self->priv = MEQUATION_GET_PRIVATE (self);
}


static void mequation_finalize (Equation* obj) {
	MEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEQUATION, MEquation);
	_g_object_unref0 (self->priv->m_equation);
	EQUATION_CLASS (mequation_parent_class)->finalize (obj);
}


GType mequation_get_type (void) {
	static volatile gsize mequation_type_id__volatile = 0;
	if (g_once_init_enter (&mequation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MEquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mequation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MEquation), 0, (GInstanceInitFunc) mequation_instance_init, NULL };
		GType mequation_type_id;
		mequation_type_id = g_type_register_static (TYPE_EQUATION, "MEquation", &g_define_type_info, 0);
		g_once_init_leave (&mequation_type_id__volatile, mequation_type_id);
	}
	return mequation_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



