/* contacts-contact-sheet.c generated by valac 0.22.0, the Vala compiler
 * generated from contacts-contact-sheet.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <folks/folks.h>
#include <gee.h>
#include <gio/gio.h>
#include <telepathy-glib/telepathy-glib.h>
#include <folks/folks-telepathy.h>
#include <glib/gi18n-lib.h>


#define CONTACTS_TYPE_CONTACT_SHEET (contacts_contact_sheet_get_type ())
#define CONTACTS_CONTACT_SHEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheet))
#define CONTACTS_CONTACT_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheetClass))
#define CONTACTS_IS_CONTACT_SHEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_SHEET))
#define CONTACTS_IS_CONTACT_SHEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_SHEET))
#define CONTACTS_CONTACT_SHEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_SHEET, ContactsContactSheetClass))

typedef struct _ContactsContactSheet ContactsContactSheet;
typedef struct _ContactsContactSheetClass ContactsContactSheetClass;
typedef struct _ContactsContactSheetPrivate ContactsContactSheetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
typedef struct _Block15Data Block15Data;

#define CONTACTS_TYPE_CONTACT_FRAME (contacts_contact_frame_get_type ())
#define CONTACTS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrame))
#define CONTACTS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))
#define CONTACTS_IS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_IS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_CONTACT_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))

typedef struct _ContactsContactFrame ContactsContactFrame;
typedef struct _ContactsContactFrameClass ContactsContactFrameClass;
typedef struct _ContactsContactPrivate ContactsContactPrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block16Data Block16Data;

#define CONTACTS_TYPE_TYPESET (contacts_typeset_get_type ())
#define CONTACTS_TYPESET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_TYPESET, ContactsTypeSet))
#define CONTACTS_TYPESET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_TYPESET, ContactsTypeSetClass))
#define CONTACTS_IS_TYPESET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_TYPESET))
#define CONTACTS_IS_TYPESET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_TYPESET))
#define CONTACTS_TYPESET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_TYPESET, ContactsTypeSetClass))

typedef struct _ContactsTypeSet ContactsTypeSet;
typedef struct _ContactsTypeSetClass ContactsTypeSetClass;
typedef struct _Block17Data Block17Data;

#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
typedef struct _ContactsAppPrivate ContactsAppPrivate;

#define CONTACTS_TYPE_WINDOW (contacts_window_get_type ())
#define CONTACTS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_WINDOW, ContactsWindow))
#define CONTACTS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_WINDOW, ContactsWindowClass))
#define CONTACTS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_WINDOW))
#define CONTACTS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_WINDOW))
#define CONTACTS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_WINDOW, ContactsWindowClass))

typedef struct _ContactsWindow ContactsWindow;
typedef struct _ContactsWindowClass ContactsWindowClass;
typedef struct _ContactsStorePrivate ContactsStorePrivate;
typedef struct _Block18Data Block18Data;
typedef struct _Block19Data Block19Data;

#define CONTACTS_CONTACT_TYPE_IM_DISPLAY (contacts_contact_im_display_get_type ())
typedef struct _Block20Data Block20Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _ContactsContactSheet {
	GtkGrid parent_instance;
	ContactsContactSheetPrivate * priv;
};

struct _ContactsContactSheetClass {
	GtkGridClass parent_class;
};

struct _Block15Data {
	int _ref_count_;
	ContactsContactSheet * self;
	ContactsContact* c;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	gboolean is_main;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block16Data {
	int _ref_count_;
	Block15Data * _data15_;
	FolksEmailFieldDetails* email;
};

struct _Block17Data {
	int _ref_count_;
	Block15Data * _data15_;
	FolksPhoneFieldDetails* phone;
};

struct _ContactsApp {
	GtkApplication parent_instance;
	ContactsAppPrivate * priv;
	GSettings* settings;
	ContactsStore* contacts_store;
	ContactsWindow* window;
};

struct _ContactsAppClass {
	GtkApplicationClass parent_class;
};

struct _ContactsStore {
	GObject parent_instance;
	ContactsStorePrivate * priv;
	GeeHashMap* calling_accounts;
	GeeHashMultiMap* dont_suggest_link;
};

struct _ContactsStoreClass {
	GObjectClass parent_class;
};

struct _Block18Data {
	int _ref_count_;
	Block15Data * _data15_;
	gchar* protocol;
};

struct _Block19Data {
	int _ref_count_;
	Block18Data * _data18_;
	FolksImFieldDetails* id;
};

typedef enum  {
	CONTACTS_CONTACT_IM_DISPLAY_DEFAULT,
	CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE
} ContactsContactImDisplay;

struct _Block20Data {
	int _ref_count_;
	Block15Data * _data15_;
	FolksUrlFieldDetails* url;
};


static gpointer contacts_contact_sheet_parent_class = NULL;
extern ContactsApp* contacts_app_app;

GType contacts_contact_sheet_get_type (void) G_GNUC_CONST;
enum  {
	CONTACTS_CONTACT_SHEET_DUMMY_PROPERTY
};
static GtkButton* contacts_contact_sheet_add_row_with_button (ContactsContactSheet* self, gint* row, const gchar* label_value, const gchar* value);
static void contacts_contact_sheet_add_row_with_label (ContactsContactSheet* self, gint* row, const gchar* label_value, const gchar* value);
ContactsContactSheet* contacts_contact_sheet_new (void);
ContactsContactSheet* contacts_contact_sheet_construct (GType object_type);
GType contacts_contact_get_type (void) G_GNUC_CONST;
void contacts_contact_sheet_update (ContactsContactSheet* self, ContactsContact* c);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
GType contacts_contact_frame_get_type (void) G_GNUC_CONST;
#define PROFILE_SIZE 96
ContactsContactFrame* contacts_contact_frame_new (gint size, gboolean with_button);
ContactsContactFrame* contacts_contact_frame_construct (GType object_type, gint size, gboolean with_button);
void contacts_contact_keep_widget_uptodate (ContactsContact* self, GtkWidget* w, GtkCallback callback, void* callback_target, GDestroyNotify callback_target_destroy_notify);
static void __lambda32_ (Block15Data* _data15_, GtkWidget* w);
void contacts_contact_frame_set_image (ContactsContactFrame* self, FolksAvatarDetails* details, ContactsContact* contact);
GType contacts_store_get_type (void) G_GNUC_CONST;
static void ___lambda32__gtk_callback (GtkWidget* widget, gpointer self);
static void __lambda33_ (Block15Data* _data15_, GtkWidget* w);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static void ___lambda33__gtk_callback (GtkWidget* widget, gpointer self);
GeeList* contacts_contact_get_personas_for_display (ContactsContact* self);
gchar* contacts_contact_format_persona_store_name_for_contact (FolksPersona* persona);
GeeArrayList* contacts_contact_sort_fields (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeCollection* fields);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
GType contacts_typeset_get_type (void) G_GNUC_CONST;
ContactsTypeSet* contacts_typeset_get_email (void);
gchar* contacts_typeset_format_type (ContactsTypeSet* self, FolksAbstractFieldDetails* detail);
static void _______lambda34_ (Block16Data* _data16_);
void contacts_utils_compose_mail (const gchar* email);
static void ________lambda34__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
GType contacts_app_get_type (void) G_GNUC_CONST;
GType contacts_window_get_type (void) G_GNUC_CONST;
gboolean contacts_store_get_can_call (ContactsStore* self);
ContactsTypeSet* contacts_typeset_get_phone (void);
static void ________lambda35_ (Block17Data* _data17_);
void contacts_utils_start_call (const gchar* contact_id, GeeHashMap* accounts);
static void _________lambda35__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
GType contacts_contact_im_display_get_type (void) G_GNUC_CONST;
gchar* contacts_contact_format_im_service (const gchar* service, ContactsContactImDisplay* display);
static void __________lambda36_ (Block19Data* _data19_);
TpfPersona* contacts_contact_find_im_persona (ContactsContact* self, const gchar* protocol, const gchar* im_address);
void contacts_utils_start_chat (ContactsContact* contact, const gchar* protocol, const gchar* id);
static void ___________lambda36__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
gchar* contacts_contact_format_uri_link_text (FolksUrlFieldDetails* detail);
static void _______lambda37_ (Block20Data* _data20_);
static void ________lambda37__gtk_button_clicked (GtkButton* _sender, gpointer self);
gboolean contacts_is_set (const gchar* str);
gchar** contacts_contact_format_address (FolksPostalAddress* addr, int* result_length1);
ContactsTypeSet* contacts_typeset_get_general (void);
void contacts_contact_sheet_clear (ContactsContactSheet* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GtkButton* contacts_contact_sheet_add_row_with_button (ContactsContactSheet* self, gint* row, const gchar* label_value, const gchar* value) {
	GtkButton* result = NULL;
	GtkLabel* type_label = NULL;
	const gchar* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkButton* value_button = NULL;
	const gchar* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GtkWidget* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label_value != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = label_value;
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	type_label = _tmp1_;
	g_object_set ((GtkMisc*) type_label, "xalign", 1.0f, NULL);
	gtk_widget_set_halign ((GtkWidget*) type_label, GTK_ALIGN_END);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) type_label);
	gtk_style_context_add_class (_tmp2_, "dim-label");
	_tmp3_ = *row;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) type_label, 0, _tmp3_, 1, 1);
	_tmp4_ = value;
	_tmp5_ = (GtkButton*) gtk_button_new_with_label (_tmp4_);
	g_object_ref_sink (_tmp5_);
	value_button = _tmp5_;
	gtk_button_set_focus_on_click (value_button, FALSE);
	gtk_button_set_relief (value_button, GTK_RELIEF_NONE);
	g_object_set (value_button, "xalign", 0.0f, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) value_button, TRUE);
	_tmp6_ = *row;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) value_button, 1, _tmp6_, 1, 1);
	_tmp7_ = *row;
	*row = _tmp7_ + 1;
	_tmp8_ = gtk_bin_get_child ((GtkBin*) value_button);
	gtk_label_set_ellipsize (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp8_) : NULL, PANGO_ELLIPSIZE_END);
	_tmp9_ = gtk_bin_get_child ((GtkBin*) value_button);
	g_object_set (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp9_) : NULL, "wrap-mode", PANGO_WRAP_CHAR, NULL);
	result = value_button;
	_g_object_unref0 (type_label);
	return result;
}


static void contacts_contact_sheet_add_row_with_label (ContactsContactSheet* self, gint* row, const gchar* label_value, const gchar* value) {
	GtkLabel* type_label = NULL;
	const gchar* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	GtkLabel* value_label = NULL;
	const gchar* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	GtkTextDirection _tmp18_ = 0;
	GtkLabel* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label_value != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = label_value;
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	type_label = _tmp1_;
	_tmp2_ = type_label;
	g_object_set ((GtkMisc*) _tmp2_, "xalign", 1.0f, NULL);
	_tmp3_ = type_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_END);
	_tmp4_ = type_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
	_tmp5_ = type_label;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_add_class (_tmp6_, "dim-label");
	_tmp7_ = type_label;
	_tmp8_ = *row;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp7_, 0, _tmp8_, 1, 1);
	_tmp9_ = value;
	_tmp10_ = (GtkLabel*) gtk_label_new (_tmp9_);
	g_object_ref_sink (_tmp10_);
	value_label = _tmp10_;
	_tmp11_ = value_label;
	gtk_label_set_line_wrap (_tmp11_, TRUE);
	_tmp12_ = value_label;
	g_object_set ((GtkMisc*) _tmp12_, "xalign", 0.0f, NULL);
	_tmp13_ = value_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_START);
	_tmp14_ = value_label;
	gtk_label_set_ellipsize (_tmp14_, PANGO_ELLIPSIZE_END);
	_tmp15_ = value_label;
	g_object_set (_tmp15_, "wrap-mode", PANGO_WRAP_CHAR, NULL);
	_tmp16_ = type_label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp16_, 3);
	_tmp17_ = value_label;
	_tmp18_ = gtk_widget_get_direction ((GtkWidget*) _tmp17_);
	if (_tmp18_ == GTK_TEXT_DIR_LTR) {
		GtkLabel* _tmp19_ = NULL;
		_tmp19_ = value_label;
		gtk_widget_set_margin_left ((GtkWidget*) _tmp19_, 6);
	} else {
		GtkLabel* _tmp20_ = NULL;
		_tmp20_ = value_label;
		gtk_widget_set_margin_right ((GtkWidget*) _tmp20_, 6);
	}
	_tmp21_ = value_label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp21_, 3);
	_tmp22_ = value_label;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp22_, 3);
	_tmp23_ = value_label;
	_tmp24_ = *row;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp23_, 1, _tmp24_, 1, 1);
	_tmp25_ = *row;
	*row = _tmp25_ + 1;
	_g_object_unref0 (value_label);
	_g_object_unref0 (type_label);
}


ContactsContactSheet* contacts_contact_sheet_construct (GType object_type) {
	ContactsContactSheet * self = NULL;
	self = (ContactsContactSheet*) g_object_new (object_type, NULL);
	gtk_grid_set_row_spacing ((GtkGrid*) self, (guint) 12);
	gtk_grid_set_column_spacing ((GtkGrid*) self, (guint) 16);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	return self;
}


ContactsContactSheet* contacts_contact_sheet_new (void) {
	return contacts_contact_sheet_construct (CONTACTS_TYPE_CONTACT_SHEET);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}


static void block15_data_unref (void * _userdata_) {
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		ContactsContactSheet * self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->c);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}


static void __lambda32_ (Block15Data* _data15_, GtkWidget* w) {
	ContactsContactSheet * self;
	GtkWidget* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	FolksIndividual* _tmp2_ = NULL;
	ContactsContact* _tmp3_ = NULL;
	self = _data15_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	_tmp1_ = _data15_->c;
	_tmp2_ = _tmp1_->individual;
	_tmp3_ = _data15_->c;
	contacts_contact_frame_set_image (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, CONTACTS_TYPE_CONTACT_FRAME) ? ((ContactsContactFrame*) _tmp0_) : NULL, (FolksAvatarDetails*) _tmp2_, _tmp3_);
}


static void ___lambda32__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda32_ (self, widget);
}


static void __lambda33_ (Block15Data* _data15_, GtkWidget* w) {
	ContactsContactSheet * self;
	GtkWidget* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	self = _data15_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	_tmp1_ = _data15_->c;
	_tmp2_ = contacts_contact_get_display_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_markup_printf_escaped ("<span font='16'>%s</span>", _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp0_) : NULL, _tmp5_);
	_g_free0 (_tmp5_);
}


static void ___lambda33__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda33_ (self, widget);
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}


static void block16_data_unref (void * _userdata_) {
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		ContactsContactSheet * self;
		self = _data16_->_data15_->self;
		_g_object_unref0 (_data16_->email);
		block15_data_unref (_data16_->_data15_);
		_data16_->_data15_ = NULL;
		g_slice_free (Block16Data, _data16_);
	}
}


static void _______lambda34_ (Block16Data* _data16_) {
	Block15Data* _data15_;
	ContactsContactSheet * self;
	ContactsContact* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	FolksEmailFieldDetails* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	_data15_ = _data16_->_data15_;
	self = _data15_->self;
	_tmp0_ = _data15_->c;
	_tmp1_ = contacts_contact_get_display_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _data16_->email;
	_tmp4_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s <%s>", _tmp2_, (const gchar*) _tmp5_);
	_tmp7_ = _tmp6_;
	contacts_utils_compose_mail (_tmp7_);
	_g_free0 (_tmp7_);
}


static void ________lambda34__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_______lambda34_ (self);
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}


static void block17_data_unref (void * _userdata_) {
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		ContactsContactSheet * self;
		self = _data17_->_data15_->self;
		_g_object_unref0 (_data17_->phone);
		block15_data_unref (_data17_->_data15_);
		_data17_->_data15_ = NULL;
		g_slice_free (Block17Data, _data17_);
	}
}


static void ________lambda35_ (Block17Data* _data17_) {
	Block15Data* _data15_;
	ContactsContactSheet * self;
	FolksPhoneFieldDetails* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	ContactsApp* _tmp3_ = NULL;
	ContactsStore* _tmp4_ = NULL;
	GeeHashMap* _tmp5_ = NULL;
	_data15_ = _data17_->_data15_;
	self = _data15_->self;
	_tmp0_ = _data17_->phone;
	_tmp1_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = contacts_app_app;
	_tmp4_ = _tmp3_->contacts_store;
	_tmp5_ = _tmp4_->calling_accounts;
	contacts_utils_start_call ((const gchar*) _tmp2_, _tmp5_);
}


static void _________lambda35__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	________lambda35_ (self);
}


static Block18Data* block18_data_ref (Block18Data* _data18_) {
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}


static void block18_data_unref (void * _userdata_) {
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		ContactsContactSheet * self;
		self = _data18_->_data15_->self;
		_g_free0 (_data18_->protocol);
		block15_data_unref (_data18_->_data15_);
		_data18_->_data15_ = NULL;
		g_slice_free (Block18Data, _data18_);
	}
}


static Block19Data* block19_data_ref (Block19Data* _data19_) {
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}


static void block19_data_unref (void * _userdata_) {
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		ContactsContactSheet * self;
		self = _data19_->_data18_->_data15_->self;
		_g_object_unref0 (_data19_->id);
		block18_data_unref (_data19_->_data18_);
		_data19_->_data18_ = NULL;
		g_slice_free (Block19Data, _data19_);
	}
}


static void __________lambda36_ (Block19Data* _data19_) {
	Block18Data* _data18_;
	Block15Data* _data15_;
	ContactsContactSheet * self;
	TpfPersona* im_persona = NULL;
	ContactsContact* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	FolksImFieldDetails* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	TpfPersona* _tmp5_ = NULL;
	TpfPersona* _tmp6_ = NULL;
	_data18_ = _data19_->_data18_;
	_data15_ = _data18_->_data15_;
	self = _data15_->self;
	_tmp0_ = _data15_->c;
	_tmp1_ = _data18_->protocol;
	_tmp2_ = _data19_->id;
	_tmp3_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = contacts_contact_find_im_persona (_tmp0_, _tmp1_, (const gchar*) _tmp4_);
	im_persona = _tmp5_;
	_tmp6_ = im_persona;
	if (_tmp6_ != NULL) {
		FolksPresenceType type = 0;
		TpfPersona* _tmp7_ = NULL;
		FolksPresenceType _tmp8_ = 0;
		FolksPresenceType _tmp9_ = 0;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		FolksPresenceType _tmp13_ = 0;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp19_ = FALSE;
		_tmp7_ = im_persona;
		_tmp8_ = folks_presence_details_get_presence_type ((FolksPresenceDetails*) _tmp7_);
		_tmp9_ = _tmp8_;
		type = _tmp9_;
		_tmp13_ = type;
		if (_tmp13_ != FOLKS_PRESENCE_TYPE_UNSET) {
			FolksPresenceType _tmp14_ = 0;
			_tmp14_ = type;
			_tmp12_ = _tmp14_ != FOLKS_PRESENCE_TYPE_ERROR;
		} else {
			_tmp12_ = FALSE;
		}
		_tmp15_ = _tmp12_;
		if (_tmp15_) {
			FolksPresenceType _tmp16_ = 0;
			_tmp16_ = type;
			_tmp11_ = _tmp16_ != FOLKS_PRESENCE_TYPE_OFFLINE;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp17_ = _tmp11_;
		if (_tmp17_) {
			FolksPresenceType _tmp18_ = 0;
			_tmp18_ = type;
			_tmp10_ = _tmp18_ != FOLKS_PRESENCE_TYPE_UNKNOWN;
		} else {
			_tmp10_ = FALSE;
		}
		_tmp19_ = _tmp10_;
		if (_tmp19_) {
			ContactsContact* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			FolksImFieldDetails* _tmp22_ = NULL;
			gconstpointer _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			_tmp20_ = _data15_->c;
			_tmp21_ = _data18_->protocol;
			_tmp22_ = _data19_->id;
			_tmp23_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp22_);
			_tmp24_ = _tmp23_;
			contacts_utils_start_chat (_tmp20_, _tmp21_, (const gchar*) _tmp24_);
		}
	}
	_g_object_unref0 (im_persona);
}


static void ___________lambda36__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__________lambda36_ (self);
}


static Block20Data* block20_data_ref (Block20Data* _data20_) {
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}


static void block20_data_unref (void * _userdata_) {
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		ContactsContactSheet * self;
		self = _data20_->_data15_->self;
		_g_object_unref0 (_data20_->url);
		block15_data_unref (_data20_->_data15_);
		_data20_->_data15_ = NULL;
		g_slice_free (Block20Data, _data20_);
	}
}


static void _______lambda37_ (Block20Data* _data20_) {
	Block15Data* _data15_;
	ContactsContactSheet * self;
	GError * _inner_error_ = NULL;
	_data15_ = _data20_->_data15_;
	self = _data15_->self;
	{
		FolksUrlFieldDetails* _tmp0_ = NULL;
		gconstpointer _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp0_ = _data20_->url;
		_tmp1_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp0_);
		_tmp2_ = _tmp1_;
		gtk_show_uri (NULL, (const gchar*) _tmp2_, (guint32) 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e1 = NULL;
		FolksUrlFieldDetails* _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _data20_->url;
		_tmp4_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = e1;
		_tmp7_ = _tmp6_->message;
		g_warning ("contacts-contact-sheet.vala:186: Error opening website ‘%s’: %s", (const gchar*) _tmp5_, _tmp7_);
		_g_error_free0 (e1);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ________lambda37__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_______lambda37_ (self);
}


void contacts_contact_sheet_update (ContactsContactSheet* self, ContactsContact* c) {
	Block15Data* _data15_;
	ContactsContact* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	ContactsContactFrame* image_frame = NULL;
	ContactsContactFrame* _tmp2_ = NULL;
	ContactsContactFrame* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	ContactsContactFrame* _tmp5_ = NULL;
	ContactsContactFrame* _tmp6_ = NULL;
	ContactsContactFrame* _tmp7_ = NULL;
	ContactsContact* _tmp8_ = NULL;
	ContactsContactFrame* _tmp9_ = NULL;
	ContactsContactFrame* _tmp10_ = NULL;
	GtkLabel* name_label = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkTextDirection _tmp16_ = 0;
	GtkLabel* _tmp19_ = NULL;
	GtkLabel* _tmp20_ = NULL;
	ContactsContact* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	gint i = 0;
	gint last_store_position = 0;
	gboolean is_first_persona = FALSE;
	GeeList* personas = NULL;
	ContactsContact* _tmp24_ = NULL;
	GeeList* _tmp25_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = c;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data15_->c);
	_data15_->c = _tmp1_;
	_tmp2_ = contacts_contact_frame_new (PROFILE_SIZE, FALSE);
	g_object_ref_sink (_tmp2_);
	image_frame = _tmp2_;
	_tmp3_ = image_frame;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_add_class (_tmp4_, "main-avatar-frame");
	_tmp5_ = image_frame;
	gtk_frame_set_shadow_type ((GtkFrame*) _tmp5_, GTK_SHADOW_IN);
	_tmp6_ = image_frame;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp6_, FALSE);
	_tmp7_ = image_frame;
	gtk_widget_set_valign ((GtkWidget*) _tmp7_, GTK_ALIGN_START);
	_tmp8_ = _data15_->c;
	_tmp9_ = image_frame;
	contacts_contact_keep_widget_uptodate (_tmp8_, (GtkWidget*) _tmp9_, ___lambda32__gtk_callback, block15_data_ref (_data15_), block15_data_unref);
	_tmp10_ = image_frame;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp10_, 0, 0, 1, 3);
	_tmp11_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp11_);
	name_label = _tmp11_;
	_tmp12_ = name_label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
	_tmp13_ = name_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_START);
	_tmp14_ = name_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp14_, GTK_ALIGN_CENTER);
	_tmp15_ = name_label;
	_tmp16_ = gtk_widget_get_direction ((GtkWidget*) _tmp15_);
	if (_tmp16_ == GTK_TEXT_DIR_LTR) {
		GtkLabel* _tmp17_ = NULL;
		_tmp17_ = name_label;
		gtk_widget_set_margin_left ((GtkWidget*) _tmp17_, 6);
	} else {
		GtkLabel* _tmp18_ = NULL;
		_tmp18_ = name_label;
		gtk_widget_set_margin_right ((GtkWidget*) _tmp18_, 6);
	}
	_tmp19_ = name_label;
	gtk_label_set_ellipsize (_tmp19_, PANGO_ELLIPSIZE_END);
	_tmp20_ = name_label;
	g_object_set ((GtkMisc*) _tmp20_, "xalign", 0.0f, NULL);
	_tmp21_ = _data15_->c;
	_tmp22_ = name_label;
	contacts_contact_keep_widget_uptodate (_tmp21_, (GtkWidget*) _tmp22_, ___lambda33__gtk_callback, block15_data_ref (_data15_), block15_data_unref);
	_tmp23_ = name_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp23_, 1, 0, 1, 3);
	i = 3;
	last_store_position = 0;
	is_first_persona = TRUE;
	_tmp24_ = _data15_->c;
	_tmp25_ = contacts_contact_get_personas_for_display (_tmp24_);
	personas = _tmp25_;
	{
		GeeList* _p_list = NULL;
		GeeList* _tmp26_ = NULL;
		GeeList* _tmp27_ = NULL;
		gint _p_size = 0;
		GeeList* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gint _p_index = 0;
		_tmp26_ = personas;
		_tmp27_ = _g_object_ref0 (_tmp26_);
		_p_list = _tmp27_;
		_tmp28_ = _p_list;
		_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_p_size = _tmp30_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			FolksPersona* p = NULL;
			GeeList* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			gpointer _tmp36_ = NULL;
			gboolean _tmp37_ = FALSE;
			FolksEmailDetails* details = NULL;
			FolksPersona* _tmp55_ = NULL;
			FolksEmailDetails* _tmp56_ = NULL;
			FolksEmailDetails* _tmp57_ = NULL;
			FolksPhoneDetails* phone_details = NULL;
			FolksPersona* _tmp84_ = NULL;
			FolksPhoneDetails* _tmp85_ = NULL;
			FolksPhoneDetails* _tmp86_ = NULL;
			FolksImDetails* im_details = NULL;
			FolksPersona* _tmp125_ = NULL;
			FolksImDetails* _tmp126_ = NULL;
			FolksImDetails* _tmp127_ = NULL;
			FolksUrlDetails* url_details = NULL;
			FolksPersona* _tmp161_ = NULL;
			FolksUrlDetails* _tmp162_ = NULL;
			FolksUrlDetails* _tmp163_ = NULL;
			FolksNameDetails* name_details = NULL;
			FolksPersona* _tmp179_ = NULL;
			FolksNameDetails* _tmp180_ = NULL;
			FolksNameDetails* _tmp181_ = NULL;
			FolksBirthdayDetails* birthday_details = NULL;
			FolksPersona* _tmp190_ = NULL;
			FolksBirthdayDetails* _tmp191_ = NULL;
			FolksBirthdayDetails* _tmp192_ = NULL;
			FolksNoteDetails* note_details = NULL;
			FolksPersona* _tmp204_ = NULL;
			FolksNoteDetails* _tmp205_ = NULL;
			FolksNoteDetails* _tmp206_ = NULL;
			FolksPostalAddressDetails* addr_details = NULL;
			FolksPersona* _tmp219_ = NULL;
			FolksPostalAddressDetails* _tmp220_ = NULL;
			FolksPostalAddressDetails* _tmp221_ = NULL;
			gint _tmp249_ = 0;
			gint _tmp250_ = 0;
			gint _tmp251_ = 0;
			_tmp31_ = _p_index;
			_p_index = _tmp31_ + 1;
			_tmp32_ = _p_index;
			_tmp33_ = _p_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = _p_list;
			_tmp35_ = _p_index;
			_tmp36_ = gee_list_get (_tmp34_, _tmp35_);
			p = (FolksPersona*) _tmp36_;
			_tmp37_ = is_first_persona;
			if (!_tmp37_) {
				GtkLabel* store_name = NULL;
				GtkLabel* _tmp38_ = NULL;
				GtkLabel* _tmp39_ = NULL;
				FolksPersona* _tmp40_ = NULL;
				gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				GtkLabel* _tmp45_ = NULL;
				GtkLabel* _tmp46_ = NULL;
				GtkLabel* _tmp47_ = NULL;
				GtkTextDirection _tmp48_ = 0;
				GtkLabel* _tmp51_ = NULL;
				gint _tmp52_ = 0;
				gint _tmp53_ = 0;
				gint _tmp54_ = 0;
				_tmp38_ = (GtkLabel*) gtk_label_new ("");
				g_object_ref_sink (_tmp38_);
				store_name = _tmp38_;
				_tmp39_ = store_name;
				_tmp40_ = p;
				_tmp41_ = contacts_contact_format_persona_store_name_for_contact (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_markup_printf_escaped ("<span font='16px bold'>%s</span>", _tmp42_);
				_tmp44_ = _tmp43_;
				gtk_label_set_markup (_tmp39_, _tmp44_);
				_g_free0 (_tmp44_);
				_g_free0 (_tmp42_);
				_tmp45_ = store_name;
				gtk_widget_set_halign ((GtkWidget*) _tmp45_, GTK_ALIGN_START);
				_tmp46_ = store_name;
				g_object_set ((GtkMisc*) _tmp46_, "xalign", 0.0f, NULL);
				_tmp47_ = store_name;
				_tmp48_ = gtk_widget_get_direction ((GtkWidget*) _tmp47_);
				if (_tmp48_ == GTK_TEXT_DIR_LTR) {
					GtkLabel* _tmp49_ = NULL;
					_tmp49_ = store_name;
					gtk_widget_set_margin_left ((GtkWidget*) _tmp49_, 6);
				} else {
					GtkLabel* _tmp50_ = NULL;
					_tmp50_ = store_name;
					gtk_widget_set_margin_right ((GtkWidget*) _tmp50_, 6);
				}
				_tmp51_ = store_name;
				_tmp52_ = i;
				gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp51_, 0, _tmp52_, 3, 1);
				_tmp53_ = i;
				i = _tmp53_ + 1;
				_tmp54_ = i;
				last_store_position = _tmp54_;
				_g_object_unref0 (store_name);
			}
			_tmp55_ = p;
			_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, FOLKS_TYPE_EMAIL_DETAILS) ? ((FolksEmailDetails*) _tmp55_) : NULL);
			details = _tmp56_;
			_tmp57_ = details;
			if (_tmp57_ != NULL) {
				GeeArrayList* emails = NULL;
				FolksEmailDetails* _tmp58_ = NULL;
				GeeSet* _tmp59_ = NULL;
				GeeSet* _tmp60_ = NULL;
				GeeArrayList* _tmp61_ = NULL;
				_tmp58_ = details;
				_tmp59_ = folks_email_details_get_email_addresses (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = contacts_contact_sort_fields (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeCollection*) _tmp60_);
				emails = _tmp61_;
				{
					GeeArrayList* _email_list = NULL;
					GeeArrayList* _tmp62_ = NULL;
					GeeArrayList* _tmp63_ = NULL;
					gint _email_size = 0;
					GeeArrayList* _tmp64_ = NULL;
					gint _tmp65_ = 0;
					gint _tmp66_ = 0;
					gint _email_index = 0;
					_tmp62_ = emails;
					_tmp63_ = _g_object_ref0 (_tmp62_);
					_email_list = _tmp63_;
					_tmp64_ = _email_list;
					_tmp65_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp64_);
					_tmp66_ = _tmp65_;
					_email_size = _tmp66_;
					_email_index = -1;
					while (TRUE) {
						Block16Data* _data16_;
						gint _tmp67_ = 0;
						gint _tmp68_ = 0;
						gint _tmp69_ = 0;
						GeeArrayList* _tmp70_ = NULL;
						gint _tmp71_ = 0;
						gpointer _tmp72_ = NULL;
						GtkButton* button = NULL;
						ContactsTypeSet* _tmp73_ = NULL;
						ContactsTypeSet* _tmp74_ = NULL;
						FolksEmailFieldDetails* _tmp75_ = NULL;
						gchar* _tmp76_ = NULL;
						gchar* _tmp77_ = NULL;
						FolksEmailFieldDetails* _tmp78_ = NULL;
						gconstpointer _tmp79_ = NULL;
						const gchar* _tmp80_ = NULL;
						GtkButton* _tmp81_ = NULL;
						GtkButton* _tmp82_ = NULL;
						GtkButton* _tmp83_ = NULL;
						_data16_ = g_slice_new0 (Block16Data);
						_data16_->_ref_count_ = 1;
						_data16_->_data15_ = block15_data_ref (_data15_);
						_tmp67_ = _email_index;
						_email_index = _tmp67_ + 1;
						_tmp68_ = _email_index;
						_tmp69_ = _email_size;
						if (!(_tmp68_ < _tmp69_)) {
							block16_data_unref (_data16_);
							_data16_ = NULL;
							break;
						}
						_tmp70_ = _email_list;
						_tmp71_ = _email_index;
						_tmp72_ = gee_abstract_list_get ((GeeAbstractList*) _tmp70_, _tmp71_);
						_data16_->email = (FolksEmailFieldDetails*) _tmp72_;
						_tmp73_ = contacts_typeset_get_email ();
						_tmp74_ = _tmp73_;
						_tmp75_ = _data16_->email;
						_tmp76_ = contacts_typeset_format_type (_tmp74_, (FolksAbstractFieldDetails*) _tmp75_);
						_tmp77_ = _tmp76_;
						_tmp78_ = _data16_->email;
						_tmp79_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp78_);
						_tmp80_ = _tmp79_;
						_tmp81_ = contacts_contact_sheet_add_row_with_button (self, &i, _tmp77_, (const gchar*) _tmp80_);
						_tmp82_ = _tmp81_;
						_g_free0 (_tmp77_);
						button = _tmp82_;
						_tmp83_ = button;
						g_signal_connect_data (_tmp83_, "clicked", (GCallback) ________lambda34__gtk_button_clicked, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
						_g_object_unref0 (button);
						block16_data_unref (_data16_);
						_data16_ = NULL;
					}
					_g_object_unref0 (_email_list);
				}
				_g_object_unref0 (emails);
			}
			_tmp84_ = p;
			_tmp85_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp84_, FOLKS_TYPE_PHONE_DETAILS) ? ((FolksPhoneDetails*) _tmp84_) : NULL);
			phone_details = _tmp85_;
			_tmp86_ = phone_details;
			if (_tmp86_ != NULL) {
				GeeArrayList* phones = NULL;
				FolksPhoneDetails* _tmp87_ = NULL;
				GeeSet* _tmp88_ = NULL;
				GeeSet* _tmp89_ = NULL;
				GeeArrayList* _tmp90_ = NULL;
				_tmp87_ = phone_details;
				_tmp88_ = folks_phone_details_get_phone_numbers (_tmp87_);
				_tmp89_ = _tmp88_;
				_tmp90_ = contacts_contact_sort_fields (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeCollection*) _tmp89_);
				phones = _tmp90_;
				{
					GeeArrayList* _phone_list = NULL;
					GeeArrayList* _tmp91_ = NULL;
					GeeArrayList* _tmp92_ = NULL;
					gint _phone_size = 0;
					GeeArrayList* _tmp93_ = NULL;
					gint _tmp94_ = 0;
					gint _tmp95_ = 0;
					gint _phone_index = 0;
					_tmp91_ = phones;
					_tmp92_ = _g_object_ref0 (_tmp91_);
					_phone_list = _tmp92_;
					_tmp93_ = _phone_list;
					_tmp94_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp93_);
					_tmp95_ = _tmp94_;
					_phone_size = _tmp95_;
					_phone_index = -1;
					while (TRUE) {
						Block17Data* _data17_;
						gint _tmp96_ = 0;
						gint _tmp97_ = 0;
						gint _tmp98_ = 0;
						GeeArrayList* _tmp99_ = NULL;
						gint _tmp100_ = 0;
						gpointer _tmp101_ = NULL;
						ContactsApp* _tmp102_ = NULL;
						ContactsStore* _tmp103_ = NULL;
						gboolean _tmp104_ = FALSE;
						gboolean _tmp105_ = FALSE;
						_data17_ = g_slice_new0 (Block17Data);
						_data17_->_ref_count_ = 1;
						_data17_->_data15_ = block15_data_ref (_data15_);
						_tmp96_ = _phone_index;
						_phone_index = _tmp96_ + 1;
						_tmp97_ = _phone_index;
						_tmp98_ = _phone_size;
						if (!(_tmp97_ < _tmp98_)) {
							block17_data_unref (_data17_);
							_data17_ = NULL;
							break;
						}
						_tmp99_ = _phone_list;
						_tmp100_ = _phone_index;
						_tmp101_ = gee_abstract_list_get ((GeeAbstractList*) _tmp99_, _tmp100_);
						_data17_->phone = (FolksPhoneFieldDetails*) _tmp101_;
						_tmp102_ = contacts_app_app;
						_tmp103_ = _tmp102_->contacts_store;
						_tmp104_ = contacts_store_get_can_call (_tmp103_);
						_tmp105_ = _tmp104_;
						if (_tmp105_) {
							GtkButton* button = NULL;
							ContactsTypeSet* _tmp106_ = NULL;
							ContactsTypeSet* _tmp107_ = NULL;
							FolksPhoneFieldDetails* _tmp108_ = NULL;
							gchar* _tmp109_ = NULL;
							gchar* _tmp110_ = NULL;
							FolksPhoneFieldDetails* _tmp111_ = NULL;
							gconstpointer _tmp112_ = NULL;
							const gchar* _tmp113_ = NULL;
							GtkButton* _tmp114_ = NULL;
							GtkButton* _tmp115_ = NULL;
							GtkButton* _tmp116_ = NULL;
							_tmp106_ = contacts_typeset_get_phone ();
							_tmp107_ = _tmp106_;
							_tmp108_ = _data17_->phone;
							_tmp109_ = contacts_typeset_format_type (_tmp107_, (FolksAbstractFieldDetails*) _tmp108_);
							_tmp110_ = _tmp109_;
							_tmp111_ = _data17_->phone;
							_tmp112_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp111_);
							_tmp113_ = _tmp112_;
							_tmp114_ = contacts_contact_sheet_add_row_with_button (self, &i, _tmp110_, (const gchar*) _tmp113_);
							_tmp115_ = _tmp114_;
							_g_free0 (_tmp110_);
							button = _tmp115_;
							_tmp116_ = button;
							g_signal_connect_data (_tmp116_, "clicked", (GCallback) _________lambda35__gtk_button_clicked, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
							_g_object_unref0 (button);
						} else {
							ContactsTypeSet* _tmp117_ = NULL;
							ContactsTypeSet* _tmp118_ = NULL;
							FolksPhoneFieldDetails* _tmp119_ = NULL;
							gchar* _tmp120_ = NULL;
							gchar* _tmp121_ = NULL;
							FolksPhoneFieldDetails* _tmp122_ = NULL;
							gconstpointer _tmp123_ = NULL;
							const gchar* _tmp124_ = NULL;
							_tmp117_ = contacts_typeset_get_phone ();
							_tmp118_ = _tmp117_;
							_tmp119_ = _data17_->phone;
							_tmp120_ = contacts_typeset_format_type (_tmp118_, (FolksAbstractFieldDetails*) _tmp119_);
							_tmp121_ = _tmp120_;
							_tmp122_ = _data17_->phone;
							_tmp123_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp122_);
							_tmp124_ = _tmp123_;
							contacts_contact_sheet_add_row_with_label (self, &i, _tmp121_, (const gchar*) _tmp124_);
							_g_free0 (_tmp121_);
						}
						block17_data_unref (_data17_);
						_data17_ = NULL;
					}
					_g_object_unref0 (_phone_list);
				}
				_g_object_unref0 (phones);
			}
			_tmp125_ = p;
			_tmp126_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp125_, FOLKS_TYPE_IM_DETAILS) ? ((FolksImDetails*) _tmp125_) : NULL);
			im_details = _tmp126_;
			_tmp127_ = im_details;
			if (_tmp127_ != NULL) {
				{
					GeeIterator* _protocol_it = NULL;
					FolksImDetails* _tmp128_ = NULL;
					GeeMultiMap* _tmp129_ = NULL;
					GeeMultiMap* _tmp130_ = NULL;
					GeeSet* _tmp131_ = NULL;
					GeeSet* _tmp132_ = NULL;
					GeeIterator* _tmp133_ = NULL;
					GeeIterator* _tmp134_ = NULL;
					_tmp128_ = im_details;
					_tmp129_ = folks_im_details_get_im_addresses (_tmp128_);
					_tmp130_ = _tmp129_;
					_tmp131_ = gee_multi_map_get_keys (_tmp130_);
					_tmp132_ = _tmp131_;
					_tmp133_ = gee_iterable_iterator ((GeeIterable*) _tmp132_);
					_tmp134_ = _tmp133_;
					_g_object_unref0 (_tmp132_);
					_protocol_it = _tmp134_;
					while (TRUE) {
						Block18Data* _data18_;
						GeeIterator* _tmp135_ = NULL;
						gboolean _tmp136_ = FALSE;
						GeeIterator* _tmp137_ = NULL;
						gpointer _tmp138_ = NULL;
						_data18_ = g_slice_new0 (Block18Data);
						_data18_->_ref_count_ = 1;
						_data18_->_data15_ = block15_data_ref (_data15_);
						_tmp135_ = _protocol_it;
						_tmp136_ = gee_iterator_next (_tmp135_);
						if (!_tmp136_) {
							block18_data_unref (_data18_);
							_data18_ = NULL;
							break;
						}
						_tmp137_ = _protocol_it;
						_tmp138_ = gee_iterator_get (_tmp137_);
						_data18_->protocol = (gchar*) _tmp138_;
						{
							GeeIterator* _id_it = NULL;
							FolksImDetails* _tmp139_ = NULL;
							GeeMultiMap* _tmp140_ = NULL;
							GeeMultiMap* _tmp141_ = NULL;
							const gchar* _tmp142_ = NULL;
							GeeCollection* _tmp143_ = NULL;
							GeeCollection* _tmp144_ = NULL;
							GeeIterator* _tmp145_ = NULL;
							GeeIterator* _tmp146_ = NULL;
							_tmp139_ = im_details;
							_tmp140_ = folks_im_details_get_im_addresses (_tmp139_);
							_tmp141_ = _tmp140_;
							_tmp142_ = _data18_->protocol;
							_tmp143_ = gee_multi_map_get (_tmp141_, _tmp142_);
							_tmp144_ = _tmp143_;
							_tmp145_ = gee_iterable_iterator ((GeeIterable*) _tmp144_);
							_tmp146_ = _tmp145_;
							_g_object_unref0 (_tmp144_);
							_id_it = _tmp146_;
							while (TRUE) {
								Block19Data* _data19_;
								GeeIterator* _tmp147_ = NULL;
								gboolean _tmp148_ = FALSE;
								GeeIterator* _tmp149_ = NULL;
								gpointer _tmp150_ = NULL;
								FolksPersona* _tmp151_ = NULL;
								_data19_ = g_slice_new0 (Block19Data);
								_data19_->_ref_count_ = 1;
								_data19_->_data18_ = block18_data_ref (_data18_);
								_tmp147_ = _id_it;
								_tmp148_ = gee_iterator_next (_tmp147_);
								if (!_tmp148_) {
									block19_data_unref (_data19_);
									_data19_ = NULL;
									break;
								}
								_tmp149_ = _id_it;
								_tmp150_ = gee_iterator_get (_tmp149_);
								_data19_->id = (FolksImFieldDetails*) _tmp150_;
								_tmp151_ = p;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp151_, TPF_TYPE_PERSONA)) {
									GtkButton* button = NULL;
									const gchar* _tmp152_ = NULL;
									gchar* _tmp153_ = NULL;
									gchar* _tmp154_ = NULL;
									FolksImFieldDetails* _tmp155_ = NULL;
									gconstpointer _tmp156_ = NULL;
									const gchar* _tmp157_ = NULL;
									GtkButton* _tmp158_ = NULL;
									GtkButton* _tmp159_ = NULL;
									GtkButton* _tmp160_ = NULL;
									_tmp152_ = _data18_->protocol;
									_tmp153_ = contacts_contact_format_im_service (_tmp152_, NULL);
									_tmp154_ = _tmp153_;
									_tmp155_ = _data19_->id;
									_tmp156_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp155_);
									_tmp157_ = _tmp156_;
									_tmp158_ = contacts_contact_sheet_add_row_with_button (self, &i, _tmp154_, (const gchar*) _tmp157_);
									_tmp159_ = _tmp158_;
									_g_free0 (_tmp154_);
									button = _tmp159_;
									_tmp160_ = button;
									g_signal_connect_data (_tmp160_, "clicked", (GCallback) ___________lambda36__gtk_button_clicked, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
									_g_object_unref0 (button);
								}
								block19_data_unref (_data19_);
								_data19_ = NULL;
							}
							_g_object_unref0 (_id_it);
						}
						block18_data_unref (_data18_);
						_data18_ = NULL;
					}
					_g_object_unref0 (_protocol_it);
				}
			}
			_tmp161_ = p;
			_tmp162_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, FOLKS_TYPE_URL_DETAILS) ? ((FolksUrlDetails*) _tmp161_) : NULL);
			url_details = _tmp162_;
			_tmp163_ = url_details;
			if (_tmp163_ != NULL) {
				{
					GeeIterator* _url_it = NULL;
					FolksUrlDetails* _tmp164_ = NULL;
					GeeSet* _tmp165_ = NULL;
					GeeSet* _tmp166_ = NULL;
					GeeIterator* _tmp167_ = NULL;
					_tmp164_ = url_details;
					_tmp165_ = folks_url_details_get_urls (_tmp164_);
					_tmp166_ = _tmp165_;
					_tmp167_ = gee_iterable_iterator ((GeeIterable*) _tmp166_);
					_url_it = _tmp167_;
					while (TRUE) {
						Block20Data* _data20_;
						GeeIterator* _tmp168_ = NULL;
						gboolean _tmp169_ = FALSE;
						GeeIterator* _tmp170_ = NULL;
						gpointer _tmp171_ = NULL;
						GtkButton* button = NULL;
						const gchar* _tmp172_ = NULL;
						FolksUrlFieldDetails* _tmp173_ = NULL;
						gchar* _tmp174_ = NULL;
						gchar* _tmp175_ = NULL;
						GtkButton* _tmp176_ = NULL;
						GtkButton* _tmp177_ = NULL;
						GtkButton* _tmp178_ = NULL;
						_data20_ = g_slice_new0 (Block20Data);
						_data20_->_ref_count_ = 1;
						_data20_->_data15_ = block15_data_ref (_data15_);
						_tmp168_ = _url_it;
						_tmp169_ = gee_iterator_next (_tmp168_);
						if (!_tmp169_) {
							block20_data_unref (_data20_);
							_data20_ = NULL;
							break;
						}
						_tmp170_ = _url_it;
						_tmp171_ = gee_iterator_get (_tmp170_);
						_data20_->url = (FolksUrlFieldDetails*) _tmp171_;
						_tmp172_ = _ ("Website");
						_tmp173_ = _data20_->url;
						_tmp174_ = contacts_contact_format_uri_link_text (_tmp173_);
						_tmp175_ = _tmp174_;
						_tmp176_ = contacts_contact_sheet_add_row_with_button (self, &i, _tmp172_, _tmp175_);
						_tmp177_ = _tmp176_;
						_g_free0 (_tmp175_);
						button = _tmp177_;
						_tmp178_ = button;
						g_signal_connect_data (_tmp178_, "clicked", (GCallback) ________lambda37__gtk_button_clicked, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
						_g_object_unref0 (button);
						block20_data_unref (_data20_);
						_data20_ = NULL;
					}
					_g_object_unref0 (_url_it);
				}
			}
			_tmp179_ = p;
			_tmp180_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp179_, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) _tmp179_) : NULL);
			name_details = _tmp180_;
			_tmp181_ = name_details;
			if (_tmp181_ != NULL) {
				FolksNameDetails* _tmp182_ = NULL;
				const gchar* _tmp183_ = NULL;
				const gchar* _tmp184_ = NULL;
				gboolean _tmp185_ = FALSE;
				_tmp182_ = name_details;
				_tmp183_ = folks_name_details_get_nickname (_tmp182_);
				_tmp184_ = _tmp183_;
				_tmp185_ = contacts_is_set (_tmp184_);
				if (_tmp185_) {
					const gchar* _tmp186_ = NULL;
					FolksNameDetails* _tmp187_ = NULL;
					const gchar* _tmp188_ = NULL;
					const gchar* _tmp189_ = NULL;
					_tmp186_ = _ ("Nickname");
					_tmp187_ = name_details;
					_tmp188_ = folks_name_details_get_nickname (_tmp187_);
					_tmp189_ = _tmp188_;
					contacts_contact_sheet_add_row_with_label (self, &i, _tmp186_, _tmp189_);
				}
			}
			_tmp190_ = p;
			_tmp191_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp190_, FOLKS_TYPE_BIRTHDAY_DETAILS) ? ((FolksBirthdayDetails*) _tmp190_) : NULL);
			birthday_details = _tmp191_;
			_tmp192_ = birthday_details;
			if (_tmp192_ != NULL) {
				FolksBirthdayDetails* _tmp193_ = NULL;
				GDateTime* _tmp194_ = NULL;
				GDateTime* _tmp195_ = NULL;
				_tmp193_ = birthday_details;
				_tmp194_ = folks_birthday_details_get_birthday (_tmp193_);
				_tmp195_ = _tmp194_;
				if (_tmp195_ != NULL) {
					const gchar* _tmp196_ = NULL;
					FolksBirthdayDetails* _tmp197_ = NULL;
					GDateTime* _tmp198_ = NULL;
					GDateTime* _tmp199_ = NULL;
					GDateTime* _tmp200_ = NULL;
					GDateTime* _tmp201_ = NULL;
					gchar* _tmp202_ = NULL;
					gchar* _tmp203_ = NULL;
					_tmp196_ = _ ("Birthday");
					_tmp197_ = birthday_details;
					_tmp198_ = folks_birthday_details_get_birthday (_tmp197_);
					_tmp199_ = _tmp198_;
					_tmp200_ = g_date_time_to_local (_tmp199_);
					_tmp201_ = _tmp200_;
					_tmp202_ = g_date_time_format (_tmp201_, "%d %B");
					_tmp203_ = _tmp202_;
					contacts_contact_sheet_add_row_with_label (self, &i, _tmp196_, _tmp203_);
					_g_free0 (_tmp203_);
					_g_date_time_unref0 (_tmp201_);
				}
			}
			_tmp204_ = p;
			_tmp205_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp204_, FOLKS_TYPE_NOTE_DETAILS) ? ((FolksNoteDetails*) _tmp204_) : NULL);
			note_details = _tmp205_;
			_tmp206_ = note_details;
			if (_tmp206_ != NULL) {
				{
					GeeIterator* _note_it = NULL;
					FolksNoteDetails* _tmp207_ = NULL;
					GeeSet* _tmp208_ = NULL;
					GeeSet* _tmp209_ = NULL;
					GeeIterator* _tmp210_ = NULL;
					_tmp207_ = note_details;
					_tmp208_ = folks_note_details_get_notes (_tmp207_);
					_tmp209_ = _tmp208_;
					_tmp210_ = gee_iterable_iterator ((GeeIterable*) _tmp209_);
					_note_it = _tmp210_;
					while (TRUE) {
						GeeIterator* _tmp211_ = NULL;
						gboolean _tmp212_ = FALSE;
						FolksNoteFieldDetails* note = NULL;
						GeeIterator* _tmp213_ = NULL;
						gpointer _tmp214_ = NULL;
						const gchar* _tmp215_ = NULL;
						FolksNoteFieldDetails* _tmp216_ = NULL;
						gconstpointer _tmp217_ = NULL;
						const gchar* _tmp218_ = NULL;
						_tmp211_ = _note_it;
						_tmp212_ = gee_iterator_next (_tmp211_);
						if (!_tmp212_) {
							break;
						}
						_tmp213_ = _note_it;
						_tmp214_ = gee_iterator_get (_tmp213_);
						note = (FolksNoteFieldDetails*) _tmp214_;
						_tmp215_ = _ ("Note");
						_tmp216_ = note;
						_tmp217_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp216_);
						_tmp218_ = _tmp217_;
						contacts_contact_sheet_add_row_with_label (self, &i, _tmp215_, (const gchar*) _tmp218_);
						_g_object_unref0 (note);
					}
					_g_object_unref0 (_note_it);
				}
			}
			_tmp219_ = p;
			_tmp220_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp219_, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS) ? ((FolksPostalAddressDetails*) _tmp219_) : NULL);
			addr_details = _tmp220_;
			_tmp221_ = addr_details;
			if (_tmp221_ != NULL) {
				{
					GeeIterator* _addr_it = NULL;
					FolksPostalAddressDetails* _tmp222_ = NULL;
					GeeSet* _tmp223_ = NULL;
					GeeSet* _tmp224_ = NULL;
					GeeIterator* _tmp225_ = NULL;
					_tmp222_ = addr_details;
					_tmp223_ = folks_postal_address_details_get_postal_addresses (_tmp222_);
					_tmp224_ = _tmp223_;
					_tmp225_ = gee_iterable_iterator ((GeeIterable*) _tmp224_);
					_addr_it = _tmp225_;
					while (TRUE) {
						GeeIterator* _tmp226_ = NULL;
						gboolean _tmp227_ = FALSE;
						FolksPostalAddressFieldDetails* addr = NULL;
						GeeIterator* _tmp228_ = NULL;
						gpointer _tmp229_ = NULL;
						gchar** strs = NULL;
						FolksPostalAddressFieldDetails* _tmp230_ = NULL;
						gconstpointer _tmp231_ = NULL;
						FolksPostalAddress* _tmp232_ = NULL;
						gint _tmp233_ = 0;
						gchar** _tmp234_ = NULL;
						gint strs_length1 = 0;
						gint _strs_size_ = 0;
						gchar* all_strs = NULL;
						gchar* _tmp235_ = NULL;
						gchar** _tmp236_ = NULL;
						gint _tmp236__length1 = 0;
						ContactsTypeSet* _tmp243_ = NULL;
						ContactsTypeSet* _tmp244_ = NULL;
						FolksPostalAddressFieldDetails* _tmp245_ = NULL;
						gchar* _tmp246_ = NULL;
						gchar* _tmp247_ = NULL;
						const gchar* _tmp248_ = NULL;
						_tmp226_ = _addr_it;
						_tmp227_ = gee_iterator_next (_tmp226_);
						if (!_tmp227_) {
							break;
						}
						_tmp228_ = _addr_it;
						_tmp229_ = gee_iterator_get (_tmp228_);
						addr = (FolksPostalAddressFieldDetails*) _tmp229_;
						_tmp230_ = addr;
						_tmp231_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp230_);
						_tmp232_ = _tmp231_;
						_tmp234_ = contacts_contact_format_address ((FolksPostalAddress*) _tmp232_, &_tmp233_);
						strs = _tmp234_;
						strs_length1 = _tmp233_;
						_strs_size_ = strs_length1;
						_tmp235_ = g_strdup ("");
						all_strs = _tmp235_;
						_tmp236_ = strs;
						_tmp236__length1 = strs_length1;
						{
							gchar** s_collection = NULL;
							gint s_collection_length1 = 0;
							gint _s_collection_size_ = 0;
							gint s_it = 0;
							s_collection = _tmp236_;
							s_collection_length1 = _tmp236__length1;
							for (s_it = 0; s_it < _tmp236__length1; s_it = s_it + 1) {
								gchar* _tmp237_ = NULL;
								gchar* s = NULL;
								_tmp237_ = g_strdup (s_collection[s_it]);
								s = _tmp237_;
								{
									const gchar* _tmp238_ = NULL;
									const gchar* _tmp239_ = NULL;
									gchar* _tmp240_ = NULL;
									gchar* _tmp241_ = NULL;
									gchar* _tmp242_ = NULL;
									_tmp238_ = all_strs;
									_tmp239_ = s;
									_tmp240_ = g_strconcat (_tmp239_, "\n", NULL);
									_tmp241_ = _tmp240_;
									_tmp242_ = g_strconcat (_tmp238_, _tmp241_, NULL);
									_g_free0 (all_strs);
									all_strs = _tmp242_;
									_g_free0 (_tmp241_);
									_g_free0 (s);
								}
							}
						}
						_tmp243_ = contacts_typeset_get_general ();
						_tmp244_ = _tmp243_;
						_tmp245_ = addr;
						_tmp246_ = contacts_typeset_format_type (_tmp244_, (FolksAbstractFieldDetails*) _tmp245_);
						_tmp247_ = _tmp246_;
						_tmp248_ = all_strs;
						contacts_contact_sheet_add_row_with_label (self, &i, _tmp247_, _tmp248_);
						_g_free0 (_tmp247_);
						_g_free0 (all_strs);
						strs = (_vala_array_free (strs, strs_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (addr);
					}
					_g_object_unref0 (_addr_it);
				}
			}
			_tmp249_ = i;
			if (_tmp249_ != 3) {
				is_first_persona = FALSE;
			}
			_tmp250_ = i;
			_tmp251_ = last_store_position;
			if (_tmp250_ == _tmp251_) {
				gint _tmp252_ = 0;
				GtkWidget* _tmp253_ = NULL;
				_tmp252_ = i;
				_tmp253_ = gtk_grid_get_child_at ((GtkGrid*) self, 0, _tmp252_ - 1);
				gtk_widget_destroy (_tmp253_);
			}
			_g_object_unref0 (addr_details);
			_g_object_unref0 (note_details);
			_g_object_unref0 (birthday_details);
			_g_object_unref0 (name_details);
			_g_object_unref0 (url_details);
			_g_object_unref0 (im_details);
			_g_object_unref0 (phone_details);
			_g_object_unref0 (details);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (personas);
	_g_object_unref0 (name_label);
	_g_object_unref0 (image_frame);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}


void contacts_contact_sheet_clear (ContactsContactSheet* self) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp0_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* w = NULL;
			w = (GtkWidget*) w_it->data;
			{
				GtkWidget* _tmp1_ = NULL;
				_tmp1_ = w;
				gtk_widget_destroy (_tmp1_);
			}
		}
		_g_list_free0 (w_collection);
	}
}


static void contacts_contact_sheet_class_init (ContactsContactSheetClass * klass) {
	contacts_contact_sheet_parent_class = g_type_class_peek_parent (klass);
}


static void contacts_contact_sheet_instance_init (ContactsContactSheet * self) {
}


GType contacts_contact_sheet_get_type (void) {
	static volatile gsize contacts_contact_sheet_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_sheet_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsContactSheetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_sheet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactSheet), 0, (GInstanceInitFunc) contacts_contact_sheet_instance_init, NULL };
		GType contacts_contact_sheet_type_id;
		contacts_contact_sheet_type_id = g_type_register_static (GTK_TYPE_GRID, "ContactsContactSheet", &g_define_type_info, 0);
		g_once_init_leave (&contacts_contact_sheet_type_id__volatile, contacts_contact_sheet_type_id);
	}
	return contacts_contact_sheet_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



