/* backend-store.c generated by valac 0.14.0.1-60fb, the Vala compiler
 * generated from backend-store.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *          Travis Reitter <travis.reitter@collabora.co.uk>
 *
 * This file was originally part of Rygel.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gmodule.h>
#include <config.h>
#include <glib/gi18n-lib.h>


#define FOLKS_TYPE_BACKEND_STORE (folks_backend_store_get_type ())
#define FOLKS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStore))
#define FOLKS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))
#define FOLKS_IS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_IS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_BACKEND_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))

typedef struct _FolksBackendStore FolksBackendStore;
typedef struct _FolksBackendStoreClass FolksBackendStoreClass;
typedef struct _FolksBackendStorePrivate FolksBackendStorePrivate;

#define FOLKS_TYPE_BACKEND (folks_backend_get_type ())
#define FOLKS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND, FolksBackend))
#define FOLKS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND, FolksBackendClass))
#define FOLKS_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND))
#define FOLKS_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND))
#define FOLKS_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND, FolksBackendClass))

typedef struct _FolksBackend FolksBackend;
typedef struct _FolksBackendClass FolksBackendClass;

#define FOLKS_TYPE_DEBUG (folks_debug_get_type ())
#define FOLKS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_DEBUG, FolksDebug))
#define FOLKS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_DEBUG, FolksDebugClass))
#define FOLKS_IS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_DEBUG))
#define FOLKS_IS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_DEBUG))
#define FOLKS_DEBUG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_DEBUG, FolksDebugClass))

typedef struct _FolksDebug FolksDebug;
typedef struct _FolksDebugClass FolksDebugClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define FOLKS_TYPE_PERSONA_STORE (folks_persona_store_get_type ())
#define FOLKS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore))
#define FOLKS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))
#define FOLKS_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))

typedef struct _FolksPersonaStore FolksPersonaStore;
typedef struct _FolksPersonaStoreClass FolksPersonaStoreClass;

#define FOLKS_TYPE_PERSONA_STORE_TRUST (folks_persona_store_trust_get_type ())

#define FOLKS_TYPE_PERSONA (folks_persona_get_type ())
#define FOLKS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA, FolksPersona))
#define FOLKS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA, FolksPersonaClass))
#define FOLKS_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA))
#define FOLKS_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA))
#define FOLKS_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA, FolksPersonaClass))

typedef struct _FolksPersona FolksPersona;
typedef struct _FolksPersonaClass FolksPersonaClass;
typedef struct _FolksBackendStorePrepareData FolksBackendStorePrepareData;
typedef struct _FolksBackendStoreLoadBackendsData FolksBackendStoreLoadBackendsData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksBackendStoreBackendLoadIfNeededData FolksBackendStoreBackendLoadIfNeededData;
typedef struct _FolksBackendStoreBackendUnloadIfNeededData FolksBackendStoreBackendUnloadIfNeededData;
typedef struct _FolksBackendStoreEnableBackendData FolksBackendStoreEnableBackendData;
typedef struct _FolksBackendStoreDisableBackendData FolksBackendStoreDisableBackendData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _FolksBackendStoreGetModulesFromDirData FolksBackendStoreGetModulesFromDirData;
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
typedef struct _FolksBackendStoreGetFileInfoData FolksBackendStoreGetFileInfoData;
typedef struct _FolksBackendStoreLoadDisabledBackendNamesData FolksBackendStoreLoadDisabledBackendNamesData;
typedef struct _FolksBackendStoreSaveKeyFileData FolksBackendStoreSaveKeyFileData;

struct _FolksBackendStore {
	GObject parent_instance;
	FolksBackendStorePrivate * priv;
};

struct _FolksBackendStoreClass {
	GObjectClass parent_class;
};

struct _FolksBackendStorePrivate {
	GeeHashMap* _backend_hash;
	GeeHashMap* _prepared_backends;
	GeeMap* _prepared_backends_ro;
	GFile* _config_file;
	GKeyFile* _backends_key_file;
	GeeHashMap* _modules;
	gboolean _is_prepared;
	FolksDebug* _debug;
};

typedef void (*FolksBackendStoreModuleFinalizeFunc) (FolksBackendStore* store);
typedef enum  {
	FOLKS_PERSONA_STORE_TRUST_NONE,
	FOLKS_PERSONA_STORE_TRUST_PARTIAL,
	FOLKS_PERSONA_STORE_TRUST_FULL
} FolksPersonaStoreTrust;

struct _FolksBackendStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	gboolean _tmp0_;
};

struct _FolksBackendStoreLoadBackendsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	gboolean _tmp0_;
	GeeHashMap* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _backend_existing_it;
	GeeIterator* _tmp7_;
	gboolean _tmp8_;
	GeeIterator* _tmp9_;
	gpointer _tmp10_;
	FolksBackend* backend_existing;
	FolksBackend* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* path;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GeeHashMap* _tmp18_;
	GeeHashMap* modules;
	const gchar* _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gchar** path_split;
	gint path_split_length1;
	gint _path_split_size_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar** subpath_collection;
	gint subpath_collection_length1;
	gint _subpath_collection_size_;
	gint subpath_it;
	const gchar* subpath;
	const gchar* _tmp23_;
	GFile* _tmp24_;
	GFile* file;
	GFile* _tmp25_;
	gboolean is_file;
	gboolean is_dir;
	GFile* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	GeeHashMap* _tmp30_;
	const gchar* _tmp31_;
	GFile* _tmp32_;
	gboolean _tmp33_;
	GFile* _tmp34_;
	GeeHashMap* _tmp35_;
	GeeHashMap* cur_modules;
	GeeHashMap* _tmp36_;
	GeeSet* _tmp37_;
	GeeSet* _tmp38_;
	GeeSet* _tmp39_;
	GeeIterator* _tmp40_;
	GeeIterator* _tmp41_;
	GeeIterator* _entry_it;
	GeeIterator* _tmp42_;
	gboolean _tmp43_;
	GeeIterator* _tmp44_;
	gpointer _tmp45_;
	GeeMapEntry* entry;
	GeeHashMap* _tmp46_;
	GeeMapEntry* _tmp47_;
	gconstpointer _tmp48_;
	const gchar* _tmp49_;
	GeeMapEntry* _tmp50_;
	gconstpointer _tmp51_;
	GFile* _tmp52_;
	const gchar* _tmp53_;
	GeeHashMap* _tmp54_;
	GeeCollection* _tmp55_;
	GeeCollection* _tmp56_;
	GeeCollection* _tmp57_;
	GeeIterator* _tmp58_;
	GeeIterator* _tmp59_;
	GeeIterator* _module_it;
	GeeIterator* _tmp60_;
	gboolean _tmp61_;
	GeeIterator* _tmp62_;
	gpointer _tmp63_;
	GFile* module;
	GFile* _tmp64_;
	GeeHashMap* _tmp65_;
	GeeCollection* _tmp66_;
	GeeCollection* _tmp67_;
	GeeCollection* _tmp68_;
	GeeIterator* _tmp69_;
	GeeIterator* _tmp70_;
	GeeIterator* _backend_it;
	GeeIterator* _tmp71_;
	gboolean _tmp72_;
	GeeIterator* _tmp73_;
	gpointer _tmp74_;
	FolksBackend* backend;
	FolksBackend* _tmp75_;
};

struct _FolksBackendStoreBackendLoadIfNeededData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	FolksBackend* backend;
	FolksBackend* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	GeeHashMap* _tmp4_;
	FolksBackend* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	FolksBackend* _tmp9_;
	FolksBackend* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GeeHashMap* _tmp13_;
	FolksBackend* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	FolksBackend* _tmp17_;
	FolksBackend* _tmp18_;
	GError* e;
	const gchar* _tmp19_;
	FolksBackend* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GError* _tmp23_;
	const gchar* _tmp24_;
	GError * _inner_error_;
};

struct _FolksBackendStoreBackendUnloadIfNeededData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	FolksBackend* backend;
	gboolean result;
	gboolean unloaded;
	FolksBackend* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	GeeHashMap* _tmp4_;
	FolksBackend* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gpointer _tmp8_;
	FolksBackend* backend_existing;
	FolksBackend* _tmp9_;
	FolksBackend* _tmp10_;
	GError* e;
	FolksBackend* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GeeHashMap* _tmp16_;
	FolksBackend* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GError * _inner_error_;
};

struct _FolksBackendStoreEnableBackendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	gchar* name;
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
};

struct _FolksBackendStoreDisableBackendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	gchar* name;
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
};

struct _FolksBackendStoreGetModulesFromDirData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	GFile* dir;
	GeeHashMap* result;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* attributes;
	GList* infos;
	GFile* _tmp4_;
	const gchar* _tmp5_;
	GFileEnumerator* _tmp6_;
	GFileEnumerator* enumerator;
	GFileEnumerator* _tmp7_;
	gint _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	GError* _error_;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GHashFunc _tmp17_;
	GEqualFunc _tmp18_;
	GeeHashMap* _tmp19_;
	GeeHashMap* modules_final;
	GList* _tmp20_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp21_;
	GFileInfo* info;
	GFile* _tmp22_;
	GFileInfo* _tmp23_;
	const gchar* _tmp24_;
	GFile* _tmp25_;
	GFile* file;
	GFileInfo* _tmp26_;
	GFileType _tmp27_;
	GFileType file_type;
	GFileInfo* _tmp28_;
	const gchar* _tmp29_;
	const gchar* content_type;
	GFileInfo* _tmp30_;
	gboolean _tmp31_;
	gboolean is_symlink;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* mime;
	GFileType _tmp34_;
	GFile* _tmp35_;
	GeeHashMap* _tmp36_;
	GeeHashMap* modules;
	GeeHashMap* _tmp37_;
	GeeSet* _tmp38_;
	GeeSet* _tmp39_;
	GeeSet* _tmp40_;
	GeeIterator* _tmp41_;
	GeeIterator* _tmp42_;
	GeeIterator* _entry_it;
	GeeIterator* _tmp43_;
	gboolean _tmp44_;
	GeeIterator* _tmp45_;
	gpointer _tmp46_;
	GeeMapEntry* entry;
	GeeHashMap* _tmp47_;
	GeeMapEntry* _tmp48_;
	gconstpointer _tmp49_;
	const gchar* _tmp50_;
	GeeMapEntry* _tmp51_;
	gconstpointer _tmp52_;
	GFile* _tmp53_;
	gboolean _tmp54_;
	const gchar* _tmp55_;
	gboolean _tmp56_;
	gboolean _tmp57_;
	GeeHashMap* _tmp58_;
	GFile* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	GFile* _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	GFile* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	GFile* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	GError * _inner_error_;
};

typedef void (*FolksBackendStoreModuleInitFunc) (FolksBackendStore* store);
struct _FolksBackendStoreGetFileInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* file;
	gboolean is_file;
	gboolean is_dir;
	GFileInfo* file_info;
	GFile* _tmp0_;
	GFileInfo* _tmp1_;
	GFileInfo* _tmp2_;
	GError* _error_;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	GFile* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFileInfo* _tmp12_;
	GFileType _tmp13_;
	GFileInfo* _tmp14_;
	GFileType _tmp15_;
	GError * _inner_error_;
};

struct _FolksBackendStoreLoadDisabledBackendNamesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	GFile* file;
	const gchar* _tmp0_;
	const gchar* path;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	const gchar* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GKeyFile* _tmp16_;
	guint8* contents;
	GFile* _tmp17_;
	guint8* _tmp18_;
	gint _tmp19_;
	guint8* _tmp20_;
	gchar* _tmp21_;
	gchar* contents_s;
	const gchar* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GKeyFile* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GError* e1;
	GError* _tmp30_;
	GFile* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GError* _tmp34_;
	const gchar* _tmp35_;
	GError * _inner_error_;
};

struct _FolksBackendStoreSaveKeyFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendStore* self;
	GKeyFile* _tmp0_;
	gchar* _tmp1_;
	gchar* key_file_data;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GFile* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GError* e;
	GFile* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError * _inner_error_;
};


static gpointer folks_backend_store_parent_class = NULL;
static FolksBackendStore* folks_backend_store__instance;
static FolksBackendStore* folks_backend_store__instance = NULL;
extern gchar* folks_backend_store_KEY_FILE_GROUP_ALL_OTHERS;
gchar* folks_backend_store_KEY_FILE_GROUP_ALL_OTHERS = NULL;

GType folks_backend_store_get_type (void) G_GNUC_CONST;
GType folks_backend_get_type (void) G_GNUC_CONST;
GType folks_debug_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKEND_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_BACKEND_STORE, FolksBackendStorePrivate))
enum  {
	FOLKS_BACKEND_STORE_DUMMY_PROPERTY,
	FOLKS_BACKEND_STORE_ENABLED_BACKENDS,
	FOLKS_BACKEND_STORE_IS_PREPARED
};
static void _folks_backend_store_debug_print_status (FolksBackendStore* self, FolksDebug* debug);
static void __folks_backend_store_debug_print_status_folks_debug_print_status (FolksDebug* _sender, gpointer self);
FolksBackendStore* folks_backend_store_dup (void);
static FolksBackendStore* folks_backend_store_new (void);
static FolksBackendStore* folks_backend_store_construct (GType object_type);
FolksDebug* folks_debug_dup_with_flags (const gchar* debug_flags, gboolean colour_enabled);
void _folks_debug_register_domain (FolksDebug* self, const gchar* domain);
#define FOLKS_DEBUG_STATUS_LOG_DOMAIN "folks-status"
void folks_debug_print_heading (FolksDebug* self, const gchar* domain, GLogLevelFlags level, const gchar* format, ...);
void folks_debug_print_line (FolksDebug* self, const gchar* domain, GLogLevelFlags level, const gchar* format, ...);
void folks_debug_indent (FolksDebug* self);
gboolean folks_backend_get_is_prepared (FolksBackend* self);
gboolean folks_backend_get_is_quiescent (FolksBackend* self);
void folks_debug_print_key_value_pairs (FolksDebug* self, const gchar* domain, GLogLevelFlags level, ...);
const gchar* folks_backend_get_name (FolksBackend* self);
GType folks_persona_store_get_type (void) G_GNUC_CONST;
GeeMap* folks_backend_get_persona_stores (FolksBackend* self);
GType folks_persona_store_trust_get_type (void) G_GNUC_CONST;
FolksPersonaStoreTrust folks_persona_store_get_trust_level (FolksPersonaStore* self);
gchar** folks_persona_store_get_always_writeable_properties (FolksPersonaStore* self, int* result_length1);
gboolean folks_persona_store_get_is_prepared (FolksPersonaStore* self);
gboolean folks_persona_store_get_is_primary_store (FolksPersonaStore* self);
gboolean folks_persona_store_get_is_quiescent (FolksPersonaStore* self);
const gchar* folks_persona_store_get_id (FolksPersonaStore* self);
GType folks_persona_get_type (void) G_GNUC_CONST;
GeeMap* folks_persona_store_get_personas (FolksPersonaStore* self);
void folks_debug_unindent (FolksDebug* self);
static void folks_backend_store_prepare_data_free (gpointer _data);
void folks_backend_store_prepare (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_store_prepare_finish (FolksBackendStore* self, GAsyncResult* _res_);
static gboolean folks_backend_store_prepare_co (FolksBackendStorePrepareData* _data_);
static void _folks_backend_store_load_disabled_backend_names (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backend_store_load_disabled_backend_names_finish (FolksBackendStore* self, GAsyncResult* _res_);
static void folks_backend_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_backend_store_load_backends_data_free (gpointer _data);
void folks_backend_store_load_backends (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_store_load_backends_finish (FolksBackendStore* self, GAsyncResult* _res_, GError** error);
static gboolean folks_backend_store_load_backends_co (FolksBackendStoreLoadBackendsData* _data_);
static void folks_backend_store_load_backends_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_backend_store_backend_unload_if_needed (FolksBackendStore* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean _folks_backend_store_backend_unload_if_needed_finish (FolksBackendStore* self, GAsyncResult* _res_);
static void _folks_backend_store_get_file_info (GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backend_store_get_file_info_finish (GAsyncResult* _res_, gboolean* is_file, gboolean* is_dir);
static void _folks_backend_store_get_modules_from_dir (FolksBackendStore* self, GFile* dir, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GeeHashMap* _folks_backend_store_get_modules_from_dir_finish (FolksBackendStore* self, GAsyncResult* _res_);
static void _folks_backend_store_load_module_from_file (FolksBackendStore* self, GFile* file);
static void _folks_backend_store_backend_load_if_needed (FolksBackendStore* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backend_store_backend_load_if_needed_finish (FolksBackendStore* self, GAsyncResult* _res_);
static void _folks_backend_store_backend_load_if_needed_data_free (gpointer _data);
static gboolean _folks_backend_store_backend_load_if_needed_co (FolksBackendStoreBackendLoadIfNeededData* _data_);
static gboolean _folks_backend_store_backend_is_enabled (FolksBackendStore* self, const gchar* name);
void folks_backend_prepare (FolksBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_prepare_finish (FolksBackend* self, GAsyncResult* _res_, GError** error);
static void _folks_backend_store_backend_load_if_needed_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_backend_store_backend_unload_if_needed_data_free (gpointer _data);
static gboolean _folks_backend_store_backend_unload_if_needed_co (FolksBackendStoreBackendUnloadIfNeededData* _data_);
void folks_backend_unprepare (FolksBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_unprepare_finish (FolksBackend* self, GAsyncResult* _res_, GError** error);
static void _folks_backend_store_backend_unload_if_needed_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_backend_store_add_backend (FolksBackendStore* self, FolksBackend* backend);
FolksBackend* folks_backend_store_dup_backend_by_name (FolksBackendStore* self, const gchar* name);
GeeCollection* folks_backend_store_list_backends (FolksBackendStore* self);
static void folks_backend_store_enable_backend_data_free (gpointer _data);
void folks_backend_store_enable_backend (FolksBackendStore* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_store_enable_backend_finish (FolksBackendStore* self, GAsyncResult* _res_);
static gboolean folks_backend_store_enable_backend_co (FolksBackendStoreEnableBackendData* _data_);
static void _folks_backend_store_save_key_file (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backend_store_save_key_file_finish (FolksBackendStore* self, GAsyncResult* _res_);
static void folks_backend_store_enable_backend_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_backend_store_disable_backend_data_free (gpointer _data);
void folks_backend_store_disable_backend (FolksBackendStore* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_store_disable_backend_finish (FolksBackendStore* self, GAsyncResult* _res_);
static gboolean folks_backend_store_disable_backend_co (FolksBackendStoreDisableBackendData* _data_);
static void folks_backend_store_disable_backend_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_backend_store_get_modules_from_dir_data_free (gpointer _data);
static gboolean _folks_backend_store_get_modules_from_dir_co (FolksBackendStoreGetModulesFromDirData* _data_);
static void _folks_backend_store_get_modules_from_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void _folks_backend_store_get_file_info_data_free (gpointer _data);
static gboolean _folks_backend_store_get_file_info_co (FolksBackendStoreGetFileInfoData* _data_);
static void _folks_backend_store_get_file_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_backend_store_load_disabled_backend_names_data_free (gpointer _data);
static gboolean _folks_backend_store_load_disabled_backend_names_co (FolksBackendStoreLoadDisabledBackendNamesData* _data_);
static void _folks_backend_store_load_disabled_backend_names_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_backend_store_save_key_file_data_free (gpointer _data);
static gboolean _folks_backend_store_save_key_file_co (FolksBackendStoreSaveKeyFileData* _data_);
static void _folks_backend_store_save_key_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GeeMap* folks_backend_store_get_enabled_backends (FolksBackendStore* self);
static void folks_backend_store_set_enabled_backends (FolksBackendStore* self, GeeMap* value);
gboolean folks_backend_store_get_is_prepared (FolksBackendStore* self);
static void folks_backend_store_set_is_prepared (FolksBackendStore* self, gboolean value);
static void folks_backend_store_finalize (GObject* obj);
static void _vala_folks_backend_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_backend_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void __folks_backend_store_debug_print_status_folks_debug_print_status (FolksDebug* _sender, gpointer self) {
	_folks_backend_store_debug_print_status (self, _sender);
}


/**
   * Create a new BackendStore.
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FolksBackendStore* folks_backend_store_dup (void) {
	FolksBackendStore* result = NULL;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* _tmp3_;
	FolksBackendStore* _tmp4_;
	_tmp0_ = folks_backend_store__instance;
	if (_tmp0_ == NULL) {
		FolksBackendStore* _tmp1_;
		FolksBackendStore* new_instance;
		FolksBackendStore* _tmp2_;
		_tmp1_ = folks_backend_store_new ();
		new_instance = _tmp1_;
		_tmp2_ = new_instance;
		folks_backend_store__instance = _tmp2_;
		result = new_instance;
		return result;
	}
	_tmp3_ = folks_backend_store__instance;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}


static FolksBackendStore* folks_backend_store_construct (GType object_type) {
	FolksBackendStore * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* debug_no_colour;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_;
	FolksDebug* _tmp7_ = NULL;
	FolksDebug* _tmp8_;
	FolksDebug* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GeeHashMap* _tmp12_;
	GHashFunc _tmp13_;
	GEqualFunc _tmp14_;
	GeeHashMap* _tmp15_;
	GHashFunc _tmp16_;
	GEqualFunc _tmp17_;
	GeeHashMap* _tmp18_;
	GeeHashMap* _tmp19_;
	GeeMap* _tmp20_;
	GeeMap* _tmp21_;
	self = (FolksBackendStore*) g_object_new (object_type, NULL);
	_tmp0_ = g_getenv ("FOLKS_DEBUG_NO_COLOUR");
	_tmp1_ = g_strdup (_tmp0_);
	debug_no_colour = _tmp1_;
	_tmp3_ = debug_no_colour;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = debug_no_colour;
		_tmp2_ = g_strcmp0 (_tmp4_, "0") == 0;
	}
	_tmp5_ = g_getenv ("FOLKS_DEBUG");
	_tmp6_ = _tmp2_;
	_tmp7_ = folks_debug_dup_with_flags (_tmp5_, _tmp6_);
	_g_object_unref0 (self->priv->_debug);
	self->priv->_debug = _tmp7_;
	_tmp8_ = self->priv->_debug;
	_folks_debug_register_domain (_tmp8_, G_LOG_DOMAIN);
	_tmp9_ = self->priv->_debug;
	g_signal_connect_object (_tmp9_, "print-status", (GCallback) __folks_backend_store_debug_print_status_folks_debug_print_status, self, 0);
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_POINTER, NULL, NULL, _tmp10_, _tmp11_, NULL);
	_g_object_unref0 (self->priv->_modules);
	self->priv->_modules = _tmp12_;
	_tmp13_ = g_str_hash;
	_tmp14_ = g_str_equal;
	_tmp15_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_BACKEND, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp13_, _tmp14_, NULL);
	_g_object_unref0 (self->priv->_backend_hash);
	self->priv->_backend_hash = _tmp15_;
	_tmp16_ = g_str_hash;
	_tmp17_ = g_str_equal;
	_tmp18_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_BACKEND, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp16_, _tmp17_, NULL);
	_g_object_unref0 (self->priv->_prepared_backends);
	self->priv->_prepared_backends = _tmp18_;
	_tmp19_ = self->priv->_prepared_backends;
	_tmp20_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp19_);
	_tmp21_ = _tmp20_;
	_g_object_unref0 (self->priv->_prepared_backends_ro);
	self->priv->_prepared_backends_ro = _tmp21_;
	_g_free0 (debug_no_colour);
	return self;
}


static FolksBackendStore* folks_backend_store_new (void) {
	return folks_backend_store_construct (FOLKS_TYPE_BACKEND_STORE);
}


static void _folks_backend_store_debug_print_status (FolksBackendStore* self, FolksDebug* debug) {
	static const char domain[] = FOLKS_DEBUG_STATUS_LOG_DOMAIN;
	static const GLogLevelFlags level = G_LOG_LEVEL_INFO;
	FolksDebug* _tmp0_;
	FolksDebug* _tmp1_;
	GeeHashMap* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	FolksDebug* _tmp5_;
	FolksDebug* _tmp98_;
	FolksDebug* _tmp99_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (debug != NULL);
	_tmp0_ = debug;
	folks_debug_print_heading (_tmp0_, domain, level, "BackendStore (%p)", self);
	_tmp1_ = debug;
	_tmp2_ = self->priv->_backend_hash;
	_tmp3_ = gee_map_get_size ((GeeMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	folks_debug_print_line (_tmp1_, domain, level, "%u Backends:", (guint) _tmp4_);
	_tmp5_ = debug;
	folks_debug_indent (_tmp5_);
	{
		GeeHashMap* _tmp6_;
		GeeCollection* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeIterator* _tmp10_ = NULL;
		GeeIterator* _tmp11_;
		GeeIterator* _backend_it;
		_tmp6_ = self->priv->_backend_hash;
		_tmp7_ = gee_map_get_values ((GeeMap*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_backend_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			gboolean _tmp13_ = FALSE;
			GeeIterator* _tmp14_;
			gpointer _tmp15_ = NULL;
			FolksBackend* backend;
			FolksDebug* _tmp16_;
			FolksBackend* _tmp17_;
			const gchar* _tmp18_ = NULL;
			FolksBackend* _tmp19_;
			gboolean _tmp20_;
			gboolean _tmp21_;
			const gchar* _tmp22_ = NULL;
			FolksBackend* _tmp23_;
			gboolean _tmp24_;
			gboolean _tmp25_;
			FolksDebug* _tmp26_;
			guint _tmp27_;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_;
			FolksBackend* _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			FolksDebug* _tmp35_;
			FolksBackend* _tmp36_;
			GeeMap* _tmp37_;
			GeeMap* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			FolksDebug* _tmp41_;
			FolksDebug* _tmp97_;
			_tmp12_ = _backend_it;
			_tmp13_ = gee_iterator_next (_tmp12_);
			if (!_tmp13_) {
				break;
			}
			_tmp14_ = _backend_it;
			_tmp15_ = gee_iterator_get (_tmp14_);
			backend = (FolksBackend*) _tmp15_;
			_tmp16_ = debug;
			_tmp17_ = backend;
			folks_debug_print_heading (_tmp16_, domain, level, "Backend (%p)", _tmp17_);
			_tmp19_ = backend;
			_tmp20_ = folks_backend_get_is_prepared (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_) {
				_tmp18_ = "yes";
			} else {
				_tmp18_ = "no";
			}
			_tmp23_ = backend;
			_tmp24_ = folks_backend_get_is_quiescent (_tmp23_);
			_tmp25_ = _tmp24_;
			if (_tmp25_) {
				_tmp22_ = "yes";
			} else {
				_tmp22_ = "no";
			}
			_tmp26_ = debug;
			_tmp27_ = ((GObject*) self)->ref_count;
			_tmp28_ = g_strdup_printf ("%u", _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = backend;
			_tmp31_ = folks_backend_get_name (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = _tmp18_;
			_tmp34_ = _tmp22_;
			folks_debug_print_key_value_pairs (_tmp26_, domain, level, "Ref. count", _tmp29_, "Name", _tmp32_, "Prepared?", _tmp33_, "Quiescent?", _tmp34_, NULL);
			_g_free0 (_tmp29_);
			_tmp35_ = debug;
			_tmp36_ = backend;
			_tmp37_ = folks_backend_get_persona_stores (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = gee_map_get_size (_tmp38_);
			_tmp40_ = _tmp39_;
			folks_debug_print_line (_tmp35_, domain, level, "%u PersonaStores:", (guint) _tmp40_);
			_tmp41_ = debug;
			folks_debug_indent (_tmp41_);
			{
				FolksBackend* _tmp42_;
				GeeMap* _tmp43_;
				GeeMap* _tmp44_;
				GeeCollection* _tmp45_;
				GeeCollection* _tmp46_;
				GeeCollection* _tmp47_;
				GeeIterator* _tmp48_ = NULL;
				GeeIterator* _tmp49_;
				GeeIterator* _persona_store_it;
				_tmp42_ = backend;
				_tmp43_ = folks_backend_get_persona_stores (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = gee_map_get_values (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = _tmp46_;
				_tmp48_ = gee_iterable_iterator ((GeeIterable*) _tmp47_);
				_tmp49_ = _tmp48_;
				_g_object_unref0 (_tmp47_);
				_persona_store_it = _tmp49_;
				while (TRUE) {
					GeeIterator* _tmp50_;
					gboolean _tmp51_ = FALSE;
					GeeIterator* _tmp52_;
					gpointer _tmp53_ = NULL;
					FolksPersonaStore* persona_store;
					gchar* trust_level;
					FolksPersonaStore* _tmp54_;
					FolksPersonaStoreTrust _tmp55_;
					FolksPersonaStoreTrust _tmp56_;
					FolksPersonaStore* _tmp60_;
					gchar** _tmp61_;
					gint _tmp61__length1;
					gchar** _tmp62_;
					gint _tmp62__length1;
					gchar* _tmp63_ = NULL;
					gchar* writeable_props;
					FolksDebug* _tmp64_;
					FolksPersonaStore* _tmp65_;
					const gchar* _tmp66_ = NULL;
					FolksPersonaStore* _tmp67_;
					gboolean _tmp68_;
					gboolean _tmp69_;
					const gchar* _tmp70_ = NULL;
					FolksPersonaStore* _tmp71_;
					gboolean _tmp72_;
					gboolean _tmp73_;
					const gchar* _tmp74_ = NULL;
					FolksPersonaStore* _tmp75_;
					gboolean _tmp76_;
					gboolean _tmp77_;
					FolksDebug* _tmp78_;
					guint _tmp79_;
					gchar* _tmp80_ = NULL;
					gchar* _tmp81_;
					FolksPersonaStore* _tmp82_;
					const gchar* _tmp83_;
					const gchar* _tmp84_;
					const gchar* _tmp85_;
					const gchar* _tmp86_;
					const gchar* _tmp87_;
					const gchar* _tmp88_;
					const gchar* _tmp89_;
					FolksPersonaStore* _tmp90_;
					GeeMap* _tmp91_;
					GeeMap* _tmp92_;
					gint _tmp93_;
					gint _tmp94_;
					gchar* _tmp95_ = NULL;
					gchar* _tmp96_;
					_tmp50_ = _persona_store_it;
					_tmp51_ = gee_iterator_next (_tmp50_);
					if (!_tmp51_) {
						break;
					}
					_tmp52_ = _persona_store_it;
					_tmp53_ = gee_iterator_get (_tmp52_);
					persona_store = (FolksPersonaStore*) _tmp53_;
					trust_level = NULL;
					_tmp54_ = persona_store;
					_tmp55_ = folks_persona_store_get_trust_level (_tmp54_);
					_tmp56_ = _tmp55_;
					switch (_tmp56_) {
						case FOLKS_PERSONA_STORE_TRUST_NONE:
						{
							gchar* _tmp57_;
							_tmp57_ = g_strdup ("none");
							_g_free0 (trust_level);
							trust_level = _tmp57_;
							break;
						}
						case FOLKS_PERSONA_STORE_TRUST_PARTIAL:
						{
							gchar* _tmp58_;
							_tmp58_ = g_strdup ("partial");
							_g_free0 (trust_level);
							trust_level = _tmp58_;
							break;
						}
						case FOLKS_PERSONA_STORE_TRUST_FULL:
						{
							gchar* _tmp59_;
							_tmp59_ = g_strdup ("full");
							_g_free0 (trust_level);
							trust_level = _tmp59_;
							break;
						}
						default:
						{
							g_assert_not_reached ();
						}
					}
					_tmp60_ = persona_store;
					_tmp61_ = folks_persona_store_get_always_writeable_properties (_tmp60_, &_tmp61__length1);
					_tmp62_ = _tmp61_;
					_tmp62__length1 = _tmp61__length1;
					_tmp63_ = g_strjoinv (",", _tmp62_);
					writeable_props = _tmp63_;
					_tmp64_ = debug;
					_tmp65_ = persona_store;
					folks_debug_print_heading (_tmp64_, domain, level, "PersonaStore (%p)", _tmp65_);
					_tmp67_ = persona_store;
					_tmp68_ = folks_persona_store_get_is_prepared (_tmp67_);
					_tmp69_ = _tmp68_;
					if (_tmp69_) {
						_tmp66_ = "yes";
					} else {
						_tmp66_ = "no";
					}
					_tmp71_ = persona_store;
					_tmp72_ = folks_persona_store_get_is_primary_store (_tmp71_);
					_tmp73_ = _tmp72_;
					if (_tmp73_) {
						_tmp70_ = "yes";
					} else {
						_tmp70_ = "no";
					}
					_tmp75_ = persona_store;
					_tmp76_ = folks_persona_store_get_is_quiescent (_tmp75_);
					_tmp77_ = _tmp76_;
					if (_tmp77_) {
						_tmp74_ = "yes";
					} else {
						_tmp74_ = "no";
					}
					_tmp78_ = debug;
					_tmp79_ = ((GObject*) self)->ref_count;
					_tmp80_ = g_strdup_printf ("%u", _tmp79_);
					_tmp81_ = _tmp80_;
					_tmp82_ = persona_store;
					_tmp83_ = folks_persona_store_get_id (_tmp82_);
					_tmp84_ = _tmp83_;
					_tmp85_ = _tmp66_;
					_tmp86_ = _tmp70_;
					_tmp87_ = writeable_props;
					_tmp88_ = _tmp74_;
					_tmp89_ = trust_level;
					_tmp90_ = persona_store;
					_tmp91_ = folks_persona_store_get_personas (_tmp90_);
					_tmp92_ = _tmp91_;
					_tmp93_ = gee_map_get_size (_tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = g_strdup_printf ("%i", _tmp94_);
					_tmp96_ = _tmp95_;
					folks_debug_print_key_value_pairs (_tmp78_, domain, level, "Ref. count", _tmp81_, "ID", _tmp84_, "Prepared?", _tmp85_, "Is primary store?", _tmp86_, "Always writeable properties", _tmp87_, "Quiescent?", _tmp88_, "Trust level", _tmp89_, "Persona count", _tmp96_, NULL);
					_g_free0 (_tmp96_);
					_g_free0 (_tmp81_);
					_g_free0 (writeable_props);
					_g_free0 (trust_level);
					_g_object_unref0 (persona_store);
				}
				_g_object_unref0 (_persona_store_it);
			}
			_tmp97_ = debug;
			folks_debug_unindent (_tmp97_);
			_g_object_unref0 (backend);
		}
		_g_object_unref0 (_backend_it);
	}
	_tmp98_ = debug;
	folks_debug_unindent (_tmp98_);
	_tmp99_ = debug;
	folks_debug_print_line (_tmp99_, domain, level, "");
}


static void folks_backend_store_prepare_data_free (gpointer _data) {
	FolksBackendStorePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStorePrepareData, _data_);
}


void folks_backend_store_prepare (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStorePrepareData* _data_;
	FolksBackendStore* _tmp0_;
	_data_ = g_slice_new0 (FolksBackendStorePrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backend_store_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backend_store_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backend_store_prepare_co (_data_);
}


void folks_backend_store_prepare_finish (FolksBackendStore* self, GAsyncResult* _res_) {
	FolksBackendStorePrepareData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Prepare the BackendStore for use.
   *
   * This must only ever be called before {@link BackendStore.load_backends} is
   * called for the first time. If it isn't called explicitly,
   * {@link BackendStore.load_backends} will call it.
   *
   * @since 0.3.0
   */
static void folks_backend_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStorePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backend_store_prepare_co (_data_);
}


static gboolean folks_backend_store_prepare_co (FolksBackendStorePrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	_folks_backend_store_load_disabled_backend_names (_data_->self, folks_backend_store_prepare_ready, _data_);
	return FALSE;
	_state_1:
	_folks_backend_store_load_disabled_backend_names_finish (_data_->self, _data_->_res_);
	_data_->_tmp0_ = _data_->self->priv->_is_prepared;
	if (_data_->_tmp0_ == TRUE) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->_is_prepared = TRUE;
	g_object_notify ((GObject*) _data_->self, "is-prepared");
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backend_store_load_backends_data_free (gpointer _data) {
	FolksBackendStoreLoadBackendsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStoreLoadBackendsData, _data_);
}


void folks_backend_store_load_backends (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreLoadBackendsData* _data_;
	FolksBackendStore* _tmp0_;
	_data_ = g_slice_new0 (FolksBackendStoreLoadBackendsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backend_store_load_backends);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backend_store_load_backends_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backend_store_load_backends_co (_data_);
}


void folks_backend_store_load_backends_finish (FolksBackendStore* self, GAsyncResult* _res_, GError** error) {
	FolksBackendStoreLoadBackendsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Find, load, and prepare all backends which are not disabled.
   *
   * Backends will be searched for in the path given by the `FOLKS_BACKEND_PATH`
   * environment variable, if it's set. If it's not set, backends will be
   * searched for in a path set at compilation time.
   */
static void folks_backend_store_load_backends_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreLoadBackendsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backend_store_load_backends_co (_data_);
}


static gboolean folks_backend_store_load_backends_co (FolksBackendStoreLoadBackendsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = g_module_supported ();
	g_assert (_data_->_tmp0_);
	_data_->_state_ = 1;
	folks_backend_store_prepare (_data_->self, folks_backend_store_load_backends_ready, _data_);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (_data_->self, _data_->_res_);
	{
		_data_->_tmp1_ = _data_->self->priv->_backend_hash;
		_data_->_tmp2_ = gee_map_get_values ((GeeMap*) _data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_g_object_unref0 (_data_->_tmp4_);
		_data_->_backend_existing_it = _data_->_tmp6_;
		while (TRUE) {
			_data_->_tmp7_ = _data_->_backend_existing_it;
			_data_->_tmp8_ = FALSE;
			_data_->_tmp8_ = gee_iterator_next (_data_->_tmp7_);
			if (!_data_->_tmp8_) {
				break;
			}
			_data_->_tmp9_ = _data_->_backend_existing_it;
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = gee_iterator_get (_data_->_tmp9_);
			_data_->backend_existing = (FolksBackend*) _data_->_tmp10_;
			_data_->_tmp11_ = _data_->backend_existing;
			_data_->_state_ = 2;
			_folks_backend_store_backend_unload_if_needed (_data_->self, _data_->_tmp11_, folks_backend_store_load_backends_ready, _data_);
			return FALSE;
			_state_2:
			_folks_backend_store_backend_unload_if_needed_finish (_data_->self, _data_->_res_);
			_g_object_unref0 (_data_->backend_existing);
		}
		_g_object_unref0 (_data_->_backend_existing_it);
	}
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = g_getenv ("FOLKS_BACKEND_PATH");
	_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
	_data_->path = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->path;
	if (_data_->_tmp14_ == NULL) {
		_data_->_tmp15_ = g_strdup (BACKEND_DIR);
		_g_free0 (_data_->path);
		_data_->path = _data_->_tmp15_;
		_data_->_tmp16_ = _data_->path;
		g_debug ("Using built-in backend dir '%s' (override with " "environment variable FOLKS_BACKEND_PATH)", _data_->_tmp16_);
	} else {
		_data_->_tmp17_ = _data_->path;
		g_debug ("Using environment variable FOLKS_BACKEND_PATH = " "'%s' to look for backends", _data_->_tmp17_);
	}
	_data_->_tmp18_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_data_->modules = _data_->_tmp18_;
	_data_->_tmp19_ = _data_->path;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->_tmp20_ = g_strsplit (_data_->_tmp19_, ":", 0);
	_data_->path_split = _data_->_tmp21_;
	_data_->path_split_length1 = _vala_array_length (_data_->_tmp20_);
	_data_->_path_split_size_ = _data_->path_split_length1;
	_data_->_tmp22_ = _data_->path_split;
	_data_->_tmp22__length1 = _data_->path_split_length1;
	{
		_data_->subpath_collection_length1 = 0;
		_data_->_subpath_collection_size_ = 0;
		_data_->subpath_collection = _data_->_tmp22_;
		_data_->subpath_collection_length1 = _data_->_tmp22__length1;
		_data_->subpath_it = 0;
		for (_data_->subpath_it = 0; _data_->subpath_it < _data_->_tmp22__length1; _data_->subpath_it = _data_->subpath_it + 1) {
			_data_->subpath = _data_->subpath_collection[_data_->subpath_it];
			{
				_data_->_tmp23_ = _data_->subpath;
				_data_->_tmp24_ = NULL;
				_data_->_tmp24_ = g_file_new_for_path (_data_->_tmp23_);
				_data_->file = _data_->_tmp24_;
				_data_->_tmp25_ = _data_->file;
				g_assert (_data_->_tmp25_ != NULL);
				_data_->_tmp26_ = _data_->file;
				_data_->_tmp27_ = FALSE;
				_data_->_tmp28_ = FALSE;
				_data_->_state_ = 3;
				_folks_backend_store_get_file_info (_data_->_tmp26_, folks_backend_store_load_backends_ready, _data_);
				return FALSE;
				_state_3:
				_folks_backend_store_get_file_info_finish (_data_->_res_, &_data_->_tmp27_, &_data_->_tmp28_);
				_data_->is_file = _data_->_tmp27_;
				_data_->is_dir = _data_->_tmp28_;
				_data_->_tmp29_ = _data_->is_file;
				if (_data_->_tmp29_) {
					_data_->_tmp30_ = _data_->modules;
					_data_->_tmp31_ = _data_->subpath;
					_data_->_tmp32_ = _data_->file;
					gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp30_, _data_->_tmp31_, _data_->_tmp32_);
				} else {
					_data_->_tmp33_ = _data_->is_dir;
					if (_data_->_tmp33_) {
						_data_->_tmp34_ = _data_->file;
						_data_->_state_ = 4;
						_folks_backend_store_get_modules_from_dir (_data_->self, _data_->_tmp34_, folks_backend_store_load_backends_ready, _data_);
						return FALSE;
						_state_4:
						_data_->_tmp35_ = NULL;
						_data_->_tmp35_ = _folks_backend_store_get_modules_from_dir_finish (_data_->self, _data_->_res_);
						_data_->cur_modules = _data_->_tmp35_;
						{
							_data_->_tmp36_ = _data_->cur_modules;
							_data_->_tmp37_ = gee_map_get_entries ((GeeMap*) _data_->_tmp36_);
							_data_->_tmp38_ = _data_->_tmp37_;
							_data_->_tmp39_ = _data_->_tmp38_;
							_data_->_tmp40_ = NULL;
							_data_->_tmp40_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp39_);
							_data_->_tmp41_ = _data_->_tmp40_;
							_g_object_unref0 (_data_->_tmp39_);
							_data_->_entry_it = _data_->_tmp41_;
							while (TRUE) {
								_data_->_tmp42_ = _data_->_entry_it;
								_data_->_tmp43_ = FALSE;
								_data_->_tmp43_ = gee_iterator_next (_data_->_tmp42_);
								if (!_data_->_tmp43_) {
									break;
								}
								_data_->_tmp44_ = _data_->_entry_it;
								_data_->_tmp45_ = NULL;
								_data_->_tmp45_ = gee_iterator_get (_data_->_tmp44_);
								_data_->entry = (GeeMapEntry*) _data_->_tmp45_;
								_data_->_tmp46_ = _data_->modules;
								_data_->_tmp47_ = _data_->entry;
								_data_->_tmp48_ = gee_map_entry_get_key (_data_->_tmp47_);
								_data_->_tmp49_ = _data_->_tmp48_;
								_data_->_tmp50_ = _data_->entry;
								_data_->_tmp51_ = gee_map_entry_get_value (_data_->_tmp50_);
								_data_->_tmp52_ = _data_->_tmp51_;
								gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp46_, (const gchar*) _data_->_tmp49_, (GFile*) _data_->_tmp52_);
								_g_object_unref0 (_data_->entry);
							}
							_g_object_unref0 (_data_->_entry_it);
						}
						_g_object_unref0 (_data_->cur_modules);
					} else {
						_data_->_tmp53_ = _data_->subpath;
						g_critical ("FOLKS_BACKEND_PATH component '%s' is not a regular " "file or directory; ignoring...", _data_->_tmp53_);
						g_assert_not_reached ();
					}
				}
				_g_object_unref0 (_data_->file);
			}
		}
	}
	{
		_data_->_tmp54_ = _data_->modules;
		_data_->_tmp55_ = gee_map_get_values ((GeeMap*) _data_->_tmp54_);
		_data_->_tmp56_ = _data_->_tmp55_;
		_data_->_tmp57_ = _data_->_tmp56_;
		_data_->_tmp58_ = NULL;
		_data_->_tmp58_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp57_);
		_data_->_tmp59_ = _data_->_tmp58_;
		_g_object_unref0 (_data_->_tmp57_);
		_data_->_module_it = _data_->_tmp59_;
		while (TRUE) {
			_data_->_tmp60_ = _data_->_module_it;
			_data_->_tmp61_ = FALSE;
			_data_->_tmp61_ = gee_iterator_next (_data_->_tmp60_);
			if (!_data_->_tmp61_) {
				break;
			}
			_data_->_tmp62_ = _data_->_module_it;
			_data_->_tmp63_ = NULL;
			_data_->_tmp63_ = gee_iterator_get (_data_->_tmp62_);
			_data_->module = (GFile*) _data_->_tmp63_;
			_data_->_tmp64_ = _data_->module;
			_folks_backend_store_load_module_from_file (_data_->self, _data_->_tmp64_);
			_g_object_unref0 (_data_->module);
		}
		_g_object_unref0 (_data_->_module_it);
	}
	{
		_data_->_tmp65_ = _data_->self->priv->_backend_hash;
		_data_->_tmp66_ = gee_map_get_values ((GeeMap*) _data_->_tmp65_);
		_data_->_tmp67_ = _data_->_tmp66_;
		_data_->_tmp68_ = _data_->_tmp67_;
		_data_->_tmp69_ = NULL;
		_data_->_tmp69_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp68_);
		_data_->_tmp70_ = _data_->_tmp69_;
		_g_object_unref0 (_data_->_tmp68_);
		_data_->_backend_it = _data_->_tmp70_;
		while (TRUE) {
			_data_->_tmp71_ = _data_->_backend_it;
			_data_->_tmp72_ = FALSE;
			_data_->_tmp72_ = gee_iterator_next (_data_->_tmp71_);
			if (!_data_->_tmp72_) {
				break;
			}
			_data_->_tmp73_ = _data_->_backend_it;
			_data_->_tmp74_ = NULL;
			_data_->_tmp74_ = gee_iterator_get (_data_->_tmp73_);
			_data_->backend = (FolksBackend*) _data_->_tmp74_;
			_data_->_tmp75_ = _data_->backend;
			_data_->_state_ = 5;
			_folks_backend_store_backend_load_if_needed (_data_->self, _data_->_tmp75_, folks_backend_store_load_backends_ready, _data_);
			return FALSE;
			_state_5:
			_folks_backend_store_backend_load_if_needed_finish (_data_->self, _data_->_res_);
			_g_object_unref0 (_data_->backend);
		}
		_g_object_unref0 (_data_->_backend_it);
	}
	_data_->path_split = (_vala_array_free (_data_->path_split, _data_->path_split_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->modules);
	_g_free0 (_data_->path);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_backend_store_backend_load_if_needed_data_free (gpointer _data) {
	FolksBackendStoreBackendLoadIfNeededData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->backend);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStoreBackendLoadIfNeededData, _data_);
}


static void _folks_backend_store_backend_load_if_needed (FolksBackendStore* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreBackendLoadIfNeededData* _data_;
	FolksBackendStore* _tmp0_;
	FolksBackend* _tmp1_;
	FolksBackend* _tmp2_;
	_data_ = g_slice_new0 (FolksBackendStoreBackendLoadIfNeededData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_backend_store_backend_load_if_needed);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_backend_store_backend_load_if_needed_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = backend;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->backend = _tmp2_;
	_folks_backend_store_backend_load_if_needed_co (_data_);
}


static void _folks_backend_store_backend_load_if_needed_finish (FolksBackendStore* self, GAsyncResult* _res_) {
	FolksBackendStoreBackendLoadIfNeededData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _folks_backend_store_backend_load_if_needed_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreBackendLoadIfNeededData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backend_store_backend_load_if_needed_co (_data_);
}


static gboolean _folks_backend_store_backend_load_if_needed_co (FolksBackendStoreBackendLoadIfNeededData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->backend;
	_data_->_tmp1_ = folks_backend_get_name (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = _folks_backend_store_backend_is_enabled (_data_->self, _data_->_tmp2_);
	if (_data_->_tmp3_) {
		_data_->_tmp4_ = _data_->self->priv->_prepared_backends;
		_data_->_tmp5_ = _data_->backend;
		_data_->_tmp6_ = folks_backend_get_name (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = FALSE;
		_data_->_tmp8_ = gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp4_, _data_->_tmp7_);
		if (!_data_->_tmp8_) {
			{
				_data_->_tmp9_ = _data_->backend;
				_data_->_state_ = 1;
				folks_backend_prepare (_data_->_tmp9_, _folks_backend_store_backend_load_if_needed_ready, _data_);
				return FALSE;
				_state_1:
				folks_backend_prepare_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
				if (_data_->_inner_error_ != NULL) {
					goto __catch0_g_error;
				}
				_data_->_tmp10_ = _data_->backend;
				_data_->_tmp11_ = folks_backend_get_name (_data_->_tmp10_);
				_data_->_tmp12_ = _data_->_tmp11_;
				g_debug ("backend-store.vala:346: New backend '%s' prepared", _data_->_tmp12_);
				_data_->_tmp13_ = _data_->self->priv->_prepared_backends;
				_data_->_tmp14_ = _data_->backend;
				_data_->_tmp15_ = folks_backend_get_name (_data_->_tmp14_);
				_data_->_tmp16_ = _data_->_tmp15_;
				_data_->_tmp17_ = _data_->backend;
				gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp13_, _data_->_tmp16_, _data_->_tmp17_);
				_data_->_tmp18_ = _data_->backend;
				g_signal_emit_by_name (_data_->self, "backend-available", _data_->_tmp18_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->e = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_data_->_tmp19_ = NULL;
				_data_->_tmp19_ = _ ("Error preparing Backend '%s': %s");
				_data_->_tmp20_ = _data_->backend;
				_data_->_tmp21_ = folks_backend_get_name (_data_->_tmp20_);
				_data_->_tmp22_ = _data_->_tmp21_;
				_data_->_tmp23_ = _data_->e;
				_data_->_tmp24_ = _data_->_tmp23_->message;
				g_warning (_data_->_tmp19_, _data_->_tmp22_, _data_->_tmp24_);
				_g_error_free0 (_data_->e);
			}
			__finally0:
			if (_data_->_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_backend_store_backend_unload_if_needed_data_free (gpointer _data) {
	FolksBackendStoreBackendUnloadIfNeededData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->backend);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStoreBackendUnloadIfNeededData, _data_);
}


static void _folks_backend_store_backend_unload_if_needed (FolksBackendStore* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreBackendUnloadIfNeededData* _data_;
	FolksBackendStore* _tmp0_;
	FolksBackend* _tmp1_;
	FolksBackend* _tmp2_;
	_data_ = g_slice_new0 (FolksBackendStoreBackendUnloadIfNeededData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_backend_store_backend_unload_if_needed);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_backend_store_backend_unload_if_needed_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = backend;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->backend = _tmp2_;
	_folks_backend_store_backend_unload_if_needed_co (_data_);
}


static gboolean _folks_backend_store_backend_unload_if_needed_finish (FolksBackendStore* self, GAsyncResult* _res_) {
	gboolean result;
	FolksBackendStoreBackendUnloadIfNeededData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void _folks_backend_store_backend_unload_if_needed_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreBackendUnloadIfNeededData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backend_store_backend_unload_if_needed_co (_data_);
}


static gboolean _folks_backend_store_backend_unload_if_needed_co (FolksBackendStoreBackendUnloadIfNeededData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->unloaded = FALSE;
	_data_->_tmp0_ = _data_->backend;
	_data_->_tmp1_ = folks_backend_get_name (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = _folks_backend_store_backend_is_enabled (_data_->self, _data_->_tmp2_);
	if (!_data_->_tmp3_) {
		_data_->_tmp4_ = _data_->self->priv->_backend_hash;
		_data_->_tmp5_ = _data_->backend;
		_data_->_tmp6_ = folks_backend_get_name (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp4_, _data_->_tmp7_);
		_data_->backend_existing = (FolksBackend*) _data_->_tmp8_;
		_data_->_tmp9_ = _data_->backend_existing;
		if (_data_->_tmp9_ != NULL) {
			{
				_data_->_tmp10_ = _data_->backend_existing;
				_data_->_state_ = 1;
				folks_backend_unprepare (_data_->_tmp10_, _folks_backend_store_backend_unload_if_needed_ready, _data_);
				return FALSE;
				_state_1:
				folks_backend_unprepare_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error_);
				if (_data_->_inner_error_ != NULL) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				_data_->e = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_data_->_tmp11_ = _data_->backend;
				_data_->_tmp12_ = folks_backend_get_name (_data_->_tmp11_);
				_data_->_tmp13_ = _data_->_tmp12_;
				_data_->_tmp14_ = _data_->e;
				_data_->_tmp15_ = _data_->_tmp14_->message;
				g_warning ("backend-store.vala:376: Error unpreparing Backend '%s': %s", _data_->_tmp13_, _data_->_tmp15_);
				_g_error_free0 (_data_->e);
			}
			__finally1:
			if (_data_->_inner_error_ != NULL) {
				_g_object_unref0 (_data_->backend_existing);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
			_data_->_tmp16_ = _data_->self->priv->_prepared_backends;
			_data_->_tmp17_ = _data_->backend_existing;
			_data_->_tmp18_ = folks_backend_get_name (_data_->_tmp17_);
			_data_->_tmp19_ = _data_->_tmp18_;
			gee_abstract_map_unset ((GeeAbstractMap*) _data_->_tmp16_, _data_->_tmp19_, NULL);
			_data_->unloaded = TRUE;
		}
		_g_object_unref0 (_data_->backend_existing);
	}
	_data_->result = _data_->unloaded;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Add a new {@link Backend} to the BackendStore.
   *
   * @param backend the {@link Backend} to add
   */
void folks_backend_store_add_backend (FolksBackendStore* self, FolksBackend* backend) {
	GeeHashMap* _tmp0_;
	FolksBackend* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gpointer _tmp4_ = NULL;
	FolksBackend* backend_existing;
	gboolean _tmp5_ = FALSE;
	FolksBackend* _tmp6_;
	gboolean _tmp9_;
	FolksDebug* _tmp15_;
	FolksBackend* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GeeHashMap* _tmp19_;
	FolksBackend* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	FolksBackend* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	_tmp0_ = self->priv->_backend_hash;
	_tmp1_ = backend;
	_tmp2_ = folks_backend_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp3_);
	backend_existing = (FolksBackend*) _tmp4_;
	_tmp6_ = backend_existing;
	if (_tmp6_ != NULL) {
		FolksBackend* _tmp7_;
		FolksBackend* _tmp8_;
		_tmp7_ = backend_existing;
		_tmp8_ = backend;
		_tmp5_ = _tmp7_ != _tmp8_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp9_ = _tmp5_;
	if (_tmp9_) {
		FolksBackend* _tmp10_;
		GeeHashMap* _tmp11_;
		FolksBackend* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp10_ = backend_existing;
		folks_backend_unprepare (_tmp10_, NULL, NULL);
		_tmp11_ = self->priv->_prepared_backends;
		_tmp12_ = backend_existing;
		_tmp13_ = folks_backend_get_name (_tmp12_);
		_tmp14_ = _tmp13_;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp11_, _tmp14_, NULL);
	}
	_tmp15_ = self->priv->_debug;
	_tmp16_ = backend;
	_tmp17_ = folks_backend_get_name (_tmp16_);
	_tmp18_ = _tmp17_;
	_folks_debug_register_domain (_tmp15_, _tmp18_);
	_tmp19_ = self->priv->_backend_hash;
	_tmp20_ = backend;
	_tmp21_ = folks_backend_get_name (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = backend;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, _tmp22_, _tmp23_);
	_g_object_unref0 (backend_existing);
}


static gboolean _folks_backend_store_backend_is_enabled (FolksBackendStore* self, const gchar* name) {
	gboolean result = FALSE;
	gboolean all_others_enabled;
	gboolean enabled;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	all_others_enabled = TRUE;
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		_tmp0_ = self->priv->_backends_key_file;
		_tmp1_ = folks_backend_store_KEY_FILE_GROUP_ALL_OTHERS;
		_tmp2_ = g_key_file_get_boolean (_tmp0_, _tmp1_, "enabled", &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch2_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		all_others_enabled = _tmp3_;
	}
	goto __finally2;
	__catch2_g_key_file_error:
	{
		GError* e = NULL;
		gboolean _tmp4_ = FALSE;
		GError* _tmp5_;
		gboolean _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		if (!g_error_matches (_tmp5_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
			GError* _tmp6_;
			_tmp6_ = e;
			_tmp4_ = !g_error_matches (_tmp6_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND);
		} else {
			_tmp4_ = FALSE;
		}
		_tmp7_ = _tmp4_;
		if (_tmp7_) {
			const gchar* _tmp8_ = NULL;
			gboolean _tmp9_;
			const gchar* _tmp10_;
			_tmp9_ = all_others_enabled;
			if (_tmp9_) {
				_tmp8_ = "enabled";
			} else {
				_tmp8_ = "disabled";
			}
			_tmp10_ = _tmp8_;
			g_warning ("Couldn't determine whether to enable or disable " "backends not listed in backend key file. Defaulting to %s.", _tmp10_);
		} else {
			const gchar* _tmp11_ = NULL;
			gboolean _tmp12_;
			const gchar* _tmp13_;
			_tmp12_ = all_others_enabled;
			if (_tmp12_) {
				_tmp11_ = "Enabling";
			} else {
				_tmp11_ = "Disabling";
			}
			_tmp13_ = _tmp11_;
			g_debug ("No catch-all entry in the backend key file. %s " "unlisted backends.", _tmp13_);
		}
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	enabled = TRUE;
	{
		GKeyFile* _tmp14_;
		const gchar* _tmp15_;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_;
		_tmp14_ = self->priv->_backends_key_file;
		_tmp15_ = name;
		_tmp16_ = g_key_file_get_boolean (_tmp14_, _tmp15_, "enabled", &_inner_error_);
		_tmp17_ = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch3_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		enabled = _tmp17_;
	}
	goto __finally3;
	__catch3_g_key_file_error:
	{
		GError* e = NULL;
		gboolean _tmp18_ = FALSE;
		GError* _tmp19_;
		gboolean _tmp21_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = e;
		if (g_error_matches (_tmp19_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
			_tmp18_ = TRUE;
		} else {
			GError* _tmp20_;
			_tmp20_ = e;
			_tmp18_ = g_error_matches (_tmp20_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND);
		}
		_tmp21_ = _tmp18_;
		if (_tmp21_) {
			const gchar* _tmp22_ = NULL;
			gboolean _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			gboolean _tmp27_;
			_tmp23_ = all_others_enabled;
			if (_tmp23_) {
				_tmp22_ = "Enabling";
			} else {
				_tmp22_ = "Disabling";
			}
			_tmp24_ = name;
			_tmp25_ = _tmp22_;
			_tmp26_ = folks_backend_store_KEY_FILE_GROUP_ALL_OTHERS;
			g_debug ("Found no entry for backend '%s'.enabled in backend " "keyfile. %s according to '%s' setting.", _tmp24_, _tmp25_, _tmp26_);
			_tmp27_ = all_others_enabled;
			enabled = _tmp27_;
		} else {
			gboolean _tmp28_ = FALSE;
			GError* _tmp29_;
			gboolean _tmp31_;
			_tmp29_ = e;
			if (!g_error_matches (_tmp29_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
				GError* _tmp30_;
				_tmp30_ = e;
				_tmp28_ = !g_error_matches (_tmp30_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_KEY_NOT_FOUND);
			} else {
				_tmp28_ = FALSE;
			}
			_tmp31_ = _tmp28_;
			if (_tmp31_) {
				const gchar* _tmp32_;
				GError* _tmp33_;
				const gchar* _tmp34_;
				_tmp32_ = name;
				_tmp33_ = e;
				_tmp34_ = _tmp33_->message;
				g_warning ("Couldn't check enabled state of backend '%s': %s\n" "Disabling backend.", _tmp32_, _tmp34_);
				enabled = FALSE;
			}
		}
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = enabled;
	return result;
}


/**
   * Get a backend from the store by name. If a backend is returned, its
   * reference count is increased.
   *
   * @param name the backend name to retrieve
   * @return the backend, or `null` if none could be found
   *
   * @since 0.3.5
   */
FolksBackend* folks_backend_store_dup_backend_by_name (FolksBackendStore* self, const gchar* name) {
	FolksBackend* result = NULL;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->_backend_hash;
	_tmp1_ = name;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	result = (FolksBackend*) _tmp2_;
	return result;
}


/**
   * List the currently loaded backends.
   *
   * @return a list of the backends currently in the BackendStore
   */
GeeCollection* folks_backend_store_list_backends (FolksBackendStore* self) {
	GeeCollection* result = NULL;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_backend_hash;
	_tmp1_ = gee_map_get_values ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_collection_get_read_only_view (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp3_);
	result = _tmp6_;
	return result;
}


static void folks_backend_store_enable_backend_data_free (gpointer _data) {
	FolksBackendStoreEnableBackendData* _data_;
	_data_ = _data;
	_g_free0 (_data_->name);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStoreEnableBackendData, _data_);
}


void folks_backend_store_enable_backend (FolksBackendStore* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreEnableBackendData* _data_;
	FolksBackendStore* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_data_ = g_slice_new0 (FolksBackendStoreEnableBackendData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backend_store_enable_backend);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backend_store_enable_backend_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = name;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->name = _tmp2_;
	folks_backend_store_enable_backend_co (_data_);
}


void folks_backend_store_enable_backend_finish (FolksBackendStore* self, GAsyncResult* _res_) {
	FolksBackendStoreEnableBackendData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Enable a backend.
   *
   * Mark a backend as enabled, such that the BackendStore will always attempt
   * to load it when {@link BackendStore.load_backends} is called. This will
   * not load the backend if it's not currently loaded.
   *
   * @param name the name of the backend to enable
   * @since 0.3.2
   */
static void folks_backend_store_enable_backend_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreEnableBackendData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backend_store_enable_backend_co (_data_);
}


static gboolean folks_backend_store_enable_backend_co (FolksBackendStoreEnableBackendData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_backends_key_file;
	_data_->_tmp1_ = _data_->name;
	g_key_file_set_boolean (_data_->_tmp0_, _data_->_tmp1_, "enabled", TRUE);
	_data_->_state_ = 1;
	_folks_backend_store_save_key_file (_data_->self, folks_backend_store_enable_backend_ready, _data_);
	return FALSE;
	_state_1:
	_folks_backend_store_save_key_file_finish (_data_->self, _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backend_store_disable_backend_data_free (gpointer _data) {
	FolksBackendStoreDisableBackendData* _data_;
	_data_ = _data;
	_g_free0 (_data_->name);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStoreDisableBackendData, _data_);
}


void folks_backend_store_disable_backend (FolksBackendStore* self, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreDisableBackendData* _data_;
	FolksBackendStore* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_data_ = g_slice_new0 (FolksBackendStoreDisableBackendData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backend_store_disable_backend);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backend_store_disable_backend_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = name;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->name = _tmp2_;
	folks_backend_store_disable_backend_co (_data_);
}


void folks_backend_store_disable_backend_finish (FolksBackendStore* self, GAsyncResult* _res_) {
	FolksBackendStoreDisableBackendData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Disable a backend.
   *
   * Mark a backend as disabled, such that it won't be loaded even when the
   * client application is restarted. This will not remove the backend if it's
   * already loaded.
   *
   * @param name the name of the backend to disable
   * @since 0.3.2
   */
static void folks_backend_store_disable_backend_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreDisableBackendData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backend_store_disable_backend_co (_data_);
}


static gboolean folks_backend_store_disable_backend_co (FolksBackendStoreDisableBackendData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_backends_key_file;
	_data_->_tmp1_ = _data_->name;
	g_key_file_set_boolean (_data_->_tmp0_, _data_->_tmp1_, "enabled", FALSE);
	_data_->_state_ = 1;
	_folks_backend_store_save_key_file (_data_->self, folks_backend_store_disable_backend_ready, _data_);
	return FALSE;
	_state_1:
	_folks_backend_store_save_key_file_finish (_data_->self, _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_backend_store_get_modules_from_dir_data_free (gpointer _data) {
	FolksBackendStoreGetModulesFromDirData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->dir);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStoreGetModulesFromDirData, _data_);
}


static void _folks_backend_store_get_modules_from_dir (FolksBackendStore* self, GFile* dir, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreGetModulesFromDirData* _data_;
	FolksBackendStore* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	_data_ = g_slice_new0 (FolksBackendStoreGetModulesFromDirData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_backend_store_get_modules_from_dir);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_backend_store_get_modules_from_dir_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = dir;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->dir = _tmp2_;
	_folks_backend_store_get_modules_from_dir_co (_data_);
}


static GeeHashMap* _folks_backend_store_get_modules_from_dir_finish (FolksBackendStore* self, GAsyncResult* _res_) {
	GeeHashMap* result;
	FolksBackendStoreGetModulesFromDirData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _folks_backend_store_get_modules_from_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreGetModulesFromDirData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backend_store_get_modules_from_dir_co (_data_);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean _folks_backend_store_get_modules_from_dir_co (FolksBackendStoreGetModulesFromDirData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->dir;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_file_get_path (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	g_debug ("backend-store.vala:525: Searching for modules in folder '%s' ..", _data_->_tmp2_);
	_g_free0 (_data_->_tmp2_);
	_data_->_tmp3_ = g_strdup (G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_SYMLINK "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
	_data_->attributes = _data_->_tmp3_;
	{
		_data_->_tmp4_ = _data_->dir;
		_data_->_tmp5_ = _data_->attributes;
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->_tmp4_, _data_->_tmp5_, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, _folks_backend_store_get_modules_from_dir_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = g_file_enumerate_children_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
		_data_->enumerator = _data_->_tmp6_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_data_->_tmp7_ = _data_->enumerator;
		_data_->_tmp8_ = G_MAXINT;
		_data_->_state_ = 2;
		g_file_enumerator_next_files_async (_data_->_tmp7_, _data_->_tmp8_, G_PRIORITY_DEFAULT, NULL, _folks_backend_store_get_modules_from_dir_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = g_file_enumerator_next_files_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp10_ = _data_->_tmp9_;
		if (_data_->_inner_error_ != NULL) {
			_g_object_unref0 (_data_->enumerator);
			goto __catch4_g_error;
		}
		__g_list_free__g_object_unref0_0 (_data_->infos);
		_data_->infos = _data_->_tmp10_;
		_g_object_unref0 (_data_->enumerator);
	}
	goto __finally4;
	__catch4_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _ ("Error listing contents of folder '%s': %s");
		_data_->_tmp12_ = _data_->dir;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = g_file_get_path (_data_->_tmp12_);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = _data_->_error_;
		_data_->_tmp16_ = _data_->_tmp15_->message;
		g_critical (_data_->_tmp11_, _data_->_tmp14_, _data_->_tmp16_);
		_g_free0 (_data_->_tmp14_);
		_data_->result = NULL;
		_g_error_free0 (_data_->_error_);
		__g_list_free__g_object_unref0_0 (_data_->infos);
		_g_free0 (_data_->attributes);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally4:
	if (_data_->_inner_error_ != NULL) {
		__g_list_free__g_object_unref0_0 (_data_->infos);
		_g_free0 (_data_->attributes);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp17_ = g_str_hash;
	_data_->_tmp18_ = g_str_equal;
	_data_->_tmp19_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, _data_->_tmp17_, _data_->_tmp18_, NULL);
	_data_->modules_final = _data_->_tmp19_;
	_data_->_tmp20_ = _data_->infos;
	{
		_data_->info_collection = _data_->_tmp20_;
		_data_->info_it = NULL;
		for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
			_data_->_tmp21_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
			_data_->info = _data_->_tmp21_;
			{
				_data_->_tmp22_ = _data_->dir;
				_data_->_tmp23_ = _data_->info;
				_data_->_tmp24_ = NULL;
				_data_->_tmp24_ = g_file_info_get_name (_data_->_tmp23_);
				_data_->_tmp25_ = NULL;
				_data_->_tmp25_ = g_file_get_child (_data_->_tmp22_, _data_->_tmp24_);
				_data_->file = _data_->_tmp25_;
				_data_->_tmp26_ = _data_->info;
				_data_->_tmp27_ = 0;
				_data_->_tmp27_ = g_file_info_get_file_type (_data_->_tmp26_);
				_data_->file_type = _data_->_tmp27_;
				_data_->_tmp28_ = _data_->info;
				_data_->_tmp29_ = NULL;
				_data_->_tmp29_ = g_file_info_get_content_type (_data_->_tmp28_);
				_data_->content_type = _data_->_tmp29_;
				_data_->_tmp30_ = _data_->info;
				_data_->_tmp31_ = FALSE;
				_data_->_tmp31_ = g_file_info_get_is_symlink (_data_->_tmp30_);
				_data_->is_symlink = _data_->_tmp31_;
				_data_->_tmp32_ = _data_->content_type;
				_data_->_tmp33_ = NULL;
				_data_->_tmp33_ = g_content_type_get_mime_type (_data_->_tmp32_);
				_data_->mime = _data_->_tmp33_;
				_data_->_tmp34_ = _data_->file_type;
				if (_data_->_tmp34_ == G_FILE_TYPE_DIRECTORY) {
					_data_->_tmp35_ = _data_->file;
					_data_->_state_ = 3;
					_folks_backend_store_get_modules_from_dir (_data_->self, _data_->_tmp35_, _folks_backend_store_get_modules_from_dir_ready, _data_);
					return FALSE;
					_state_3:
					_data_->_tmp36_ = NULL;
					_data_->_tmp36_ = _folks_backend_store_get_modules_from_dir_finish (_data_->self, _data_->_res_);
					_data_->modules = _data_->_tmp36_;
					{
						_data_->_tmp37_ = _data_->modules;
						_data_->_tmp38_ = gee_map_get_entries ((GeeMap*) _data_->_tmp37_);
						_data_->_tmp39_ = _data_->_tmp38_;
						_data_->_tmp40_ = _data_->_tmp39_;
						_data_->_tmp41_ = NULL;
						_data_->_tmp41_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp40_);
						_data_->_tmp42_ = _data_->_tmp41_;
						_g_object_unref0 (_data_->_tmp40_);
						_data_->_entry_it = _data_->_tmp42_;
						while (TRUE) {
							_data_->_tmp43_ = _data_->_entry_it;
							_data_->_tmp44_ = FALSE;
							_data_->_tmp44_ = gee_iterator_next (_data_->_tmp43_);
							if (!_data_->_tmp44_) {
								break;
							}
							_data_->_tmp45_ = _data_->_entry_it;
							_data_->_tmp46_ = NULL;
							_data_->_tmp46_ = gee_iterator_get (_data_->_tmp45_);
							_data_->entry = (GeeMapEntry*) _data_->_tmp46_;
							_data_->_tmp47_ = _data_->modules_final;
							_data_->_tmp48_ = _data_->entry;
							_data_->_tmp49_ = gee_map_entry_get_key (_data_->_tmp48_);
							_data_->_tmp50_ = _data_->_tmp49_;
							_data_->_tmp51_ = _data_->entry;
							_data_->_tmp52_ = gee_map_entry_get_value (_data_->_tmp51_);
							_data_->_tmp53_ = _data_->_tmp52_;
							gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp47_, (const gchar*) _data_->_tmp50_, (GFile*) _data_->_tmp53_);
							_g_object_unref0 (_data_->entry);
						}
						_g_object_unref0 (_data_->_entry_it);
					}
					_g_object_unref0 (_data_->modules);
				} else {
					_data_->_tmp55_ = _data_->mime;
					if (g_strcmp0 (_data_->_tmp55_, "application/x-sharedlib") == 0) {
						_data_->_tmp56_ = _data_->is_symlink;
						_data_->_tmp54_ = !_data_->_tmp56_;
					} else {
						_data_->_tmp54_ = FALSE;
					}
					_data_->_tmp57_ = _data_->_tmp54_;
					if (_data_->_tmp57_) {
						_data_->_tmp58_ = _data_->modules_final;
						_data_->_tmp59_ = _data_->file;
						_data_->_tmp60_ = NULL;
						_data_->_tmp60_ = g_file_get_path (_data_->_tmp59_);
						_data_->_tmp61_ = _data_->_tmp60_;
						_data_->_tmp62_ = _data_->file;
						gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp58_, _data_->_tmp61_, _data_->_tmp62_);
						_g_free0 (_data_->_tmp61_);
					} else {
						_data_->_tmp63_ = _data_->mime;
						if (_data_->_tmp63_ == NULL) {
							_data_->_tmp64_ = NULL;
							_data_->_tmp64_ = _ ("The content type of '%s' could not be determined. Have you installed s" \
"hared-mime-info?");
							_data_->_tmp65_ = _data_->file;
							_data_->_tmp66_ = NULL;
							_data_->_tmp66_ = g_file_get_path (_data_->_tmp65_);
							_data_->_tmp67_ = _data_->_tmp66_;
							g_warning (_data_->_tmp64_, _data_->_tmp67_);
							_g_free0 (_data_->_tmp67_);
						}
					}
				}
				_g_free0 (_data_->mime);
				_g_object_unref0 (_data_->file);
				_g_object_unref0 (_data_->info);
			}
		}
	}
	_data_->_tmp68_ = _data_->dir;
	_data_->_tmp69_ = NULL;
	_data_->_tmp69_ = g_file_get_path (_data_->_tmp68_);
	_data_->_tmp70_ = _data_->_tmp69_;
	g_debug ("backend-store.vala:585: Finished searching for modules in folder '%s'", _data_->_tmp70_);
	_g_free0 (_data_->_tmp70_);
	_data_->result = _data_->modules_final;
	__g_list_free__g_object_unref0_0 (_data_->infos);
	_g_free0 (_data_->attributes);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->modules_final);
	__g_list_free__g_object_unref0_0 (_data_->infos);
	_g_free0 (_data_->attributes);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_backend_store_load_module_from_file (FolksBackendStore* self, GFile* file) {
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* file_path;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	GModule* _tmp6_ = NULL;
	GModule* module;
	GModule* _tmp7_;
	void* function = NULL;
	GModule* _tmp11_;
	void* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	void* _tmp17_;
	FolksBackendStoreModuleInitFunc module_init;
	FolksBackendStoreModuleInitFunc _tmp18_;
	GeeHashMap* _tmp19_;
	const gchar* _tmp20_;
	GModule* _tmp21_;
	GModule* _tmp22_;
	FolksBackendStoreModuleInitFunc _tmp23_;
	GModule* _tmp24_;
	const gchar* _tmp25_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_get_path (_tmp0_);
	file_path = _tmp1_;
	_tmp2_ = self->priv->_modules;
	_tmp3_ = file_path;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp3_);
	if (_tmp4_) {
		_g_free0 (file_path);
		return;
	}
	_tmp5_ = file_path;
	_tmp6_ = g_module_open (_tmp5_, G_MODULE_BIND_LOCAL);
	module = _tmp6_;
	_tmp7_ = module;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_;
		const gchar* _tmp10_ = NULL;
		_tmp8_ = _ ("Failed to load module from path '%s': %s");
		_tmp9_ = file_path;
		_tmp10_ = g_module_error ();
		g_warning (_tmp8_, _tmp9_, _tmp10_);
		_g_module_close0 (module);
		_g_free0 (file_path);
		return;
	}
	_tmp11_ = module;
	_tmp13_ = g_module_symbol (_tmp11_, "module_init", &_tmp12_);
	function = _tmp12_;
	if (!_tmp13_) {
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_;
		const gchar* _tmp16_ = NULL;
		_tmp14_ = _ ("Failed to find entry point function '%s' in '%s': %s");
		_tmp15_ = file_path;
		_tmp16_ = g_module_error ();
		g_warning (_tmp14_, "module_init", _tmp15_, _tmp16_);
		_g_module_close0 (module);
		_g_free0 (file_path);
		return;
	}
	_tmp17_ = function;
	module_init = (FolksBackendStoreModuleInitFunc) _tmp17_;
	_tmp18_ = module_init;
	g_assert (_tmp18_ != NULL);
	_tmp19_ = self->priv->_modules;
	_tmp20_ = file_path;
	_tmp21_ = module;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, _tmp20_, _tmp21_);
	_tmp22_ = module;
	g_module_make_resident (_tmp22_);
	_tmp23_ = module_init;
	_tmp23_ (self);
	_tmp24_ = module;
	_tmp25_ = g_module_name (_tmp24_);
	g_debug ("backend-store.vala:636: Loaded module source: '%s'", _tmp25_);
	_g_module_close0 (module);
	_g_free0 (file_path);
}


static void _folks_backend_store_get_file_info_data_free (gpointer _data) {
	FolksBackendStoreGetFileInfoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	g_slice_free (FolksBackendStoreGetFileInfoData, _data_);
}


static void _folks_backend_store_get_file_info (GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreGetFileInfoData* _data_;
	GFile* _tmp0_;
	GFile* _tmp1_;
	_data_ = g_slice_new0 (FolksBackendStoreGetFileInfoData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, _folks_backend_store_get_file_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_backend_store_get_file_info_data_free);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data_->file = _tmp1_;
	_folks_backend_store_get_file_info_co (_data_);
}


static void _folks_backend_store_get_file_info_finish (GAsyncResult* _res_, gboolean* is_file, gboolean* is_dir) {
	FolksBackendStoreGetFileInfoData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (is_file) {
		*is_file = _data_->is_file;
	}
	if (is_dir) {
		*is_dir = _data_->is_dir;
	}
}


static void _folks_backend_store_get_file_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreGetFileInfoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backend_store_get_file_info_co (_data_);
}


static gboolean _folks_backend_store_get_file_info_co (FolksBackendStoreGetFileInfoData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->is_file = FALSE;
	_data_->is_dir = FALSE;
	{
		_data_->_tmp0_ = _data_->file;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp0_, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, _folks_backend_store_get_file_info_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = g_file_query_info_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp2_ = _data_->_tmp1_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_g_object_unref0 (_data_->file_info);
		_data_->file_info = _data_->_tmp2_;
	}
	goto __finally5;
	__catch5_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp3_ = _data_->_error_;
		if (g_error_matches (_data_->_tmp3_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			_data_->_tmp4_ = NULL;
			_data_->_tmp4_ = _ ("File or directory '%s' does not exist.");
			_data_->_tmp5_ = _data_->file;
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = g_file_get_path (_data_->_tmp5_);
			_data_->_tmp7_ = _data_->_tmp6_;
			g_critical (_data_->_tmp4_, _data_->_tmp7_);
			_g_free0 (_data_->_tmp7_);
		} else {
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _ ("Failed to get content type for '%s'.");
			_data_->_tmp9_ = _data_->file;
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = g_file_get_path (_data_->_tmp9_);
			_data_->_tmp11_ = _data_->_tmp10_;
			g_critical (_data_->_tmp8_, _data_->_tmp11_);
			_g_free0 (_data_->_tmp11_);
		}
		_g_error_free0 (_data_->_error_);
		_g_object_unref0 (_data_->file_info);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally5:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->file_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->file_info;
	_data_->_tmp13_ = 0;
	_data_->_tmp13_ = g_file_info_get_file_type (_data_->_tmp12_);
	_data_->is_file = _data_->_tmp13_ == G_FILE_TYPE_REGULAR;
	_data_->_tmp14_ = _data_->file_info;
	_data_->_tmp15_ = 0;
	_data_->_tmp15_ = g_file_info_get_file_type (_data_->_tmp14_);
	_data_->is_dir = _data_->_tmp15_ == G_FILE_TYPE_DIRECTORY;
	_g_object_unref0 (_data_->file_info);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_backend_store_load_disabled_backend_names_data_free (gpointer _data) {
	FolksBackendStoreLoadDisabledBackendNamesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStoreLoadDisabledBackendNamesData, _data_);
}


static void _folks_backend_store_load_disabled_backend_names (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreLoadDisabledBackendNamesData* _data_;
	FolksBackendStore* _tmp0_;
	_data_ = g_slice_new0 (FolksBackendStoreLoadDisabledBackendNamesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_backend_store_load_disabled_backend_names);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_backend_store_load_disabled_backend_names_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_folks_backend_store_load_disabled_backend_names_co (_data_);
}


static void _folks_backend_store_load_disabled_backend_names_finish (FolksBackendStore* self, GAsyncResult* _res_) {
	FolksBackendStoreLoadDisabledBackendNamesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _folks_backend_store_load_disabled_backend_names_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreLoadDisabledBackendNamesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backend_store_load_disabled_backend_names_co (_data_);
}


static gboolean _folks_backend_store_load_disabled_backend_names_co (FolksBackendStoreLoadDisabledBackendNamesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_getenv ("FOLKS_BACKEND_STORE_KEY_FILE_PATH");
	_data_->path = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->path;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = g_get_user_data_dir ();
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_file_new_for_path (_data_->_tmp2_);
		_g_object_unref0 (_data_->file);
		_data_->file = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->file;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = g_file_get_child (_data_->_tmp4_, "folks");
		_g_object_unref0 (_data_->file);
		_data_->file = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->file;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_file_get_child (_data_->_tmp6_, "backends.ini");
		_g_object_unref0 (_data_->file);
		_data_->file = _data_->_tmp7_;
		_data_->_tmp8_ = _data_->file;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = g_file_get_path (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		g_debug ("Using built-in backends key file '%s' (override with " "environment variable FOLKS_BACKEND_STORE_KEY_FILE_PATH)", _data_->_tmp10_);
		_g_free0 (_data_->_tmp10_);
	} else {
		_data_->_tmp11_ = _data_->path;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_file_new_for_path (_data_->_tmp11_);
		_g_object_unref0 (_data_->file);
		_data_->file = _data_->_tmp12_;
		_data_->_tmp13_ = _data_->path;
		g_debug ("Using environment variable " "FOLKS_BACKEND_STORE_KEY_FILE_PATH = '%s' to load the backends " "key file.", _data_->_tmp13_);
	}
	_data_->_tmp14_ = _data_->file;
	_data_->_tmp15_ = _g_object_ref0 (_data_->_tmp14_);
	_g_object_unref0 (_data_->self->priv->_config_file);
	_data_->self->priv->_config_file = _data_->_tmp15_;
	_data_->_tmp16_ = g_key_file_new ();
	_g_key_file_free0 (_data_->self->priv->_backends_key_file);
	_data_->self->priv->_backends_key_file = _data_->_tmp16_;
	{
		_data_->contents = NULL;
		_data_->_tmp17_ = _data_->file;
		_data_->_tmp18_ = NULL;
		_data_->_tmp19_ = 0;
		_data_->_state_ = 1;
		g_file_load_contents_async (_data_->_tmp17_, NULL, _folks_backend_store_load_disabled_backend_names_ready, _data_);
		return FALSE;
		_state_1:
		g_file_load_contents_finish (_data_->_tmp17_, _data_->_res_, &_data_->_tmp18_, &_data_->_tmp19_, NULL, &_data_->_inner_error_);
		_data_->contents = _data_->_tmp18_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		_data_->_tmp20_ = _data_->contents;
		_data_->_tmp21_ = g_strdup ((const gchar*) _data_->_tmp20_);
		_data_->contents_s = _data_->_tmp21_;
		_data_->_tmp22_ = _data_->contents_s;
		_data_->_tmp23_ = strlen (_data_->_tmp22_);
		_data_->_tmp24_ = _data_->_tmp23_;
		if (_data_->_tmp24_ > 0) {
			_data_->_tmp25_ = _data_->self->priv->_backends_key_file;
			_data_->_tmp26_ = _data_->contents_s;
			_data_->_tmp27_ = _data_->contents_s;
			_data_->_tmp28_ = strlen (_data_->_tmp27_);
			_data_->_tmp29_ = _data_->_tmp28_;
			g_key_file_load_from_data (_data_->_tmp25_, _data_->_tmp26_, (gsize) _data_->_tmp29_, G_KEY_FILE_KEEP_COMMENTS, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				_g_free0 (_data_->contents_s);
				goto __catch6_g_error;
			}
		}
		_g_free0 (_data_->contents_s);
	}
	goto __finally6;
	__catch6_g_error:
	{
		_data_->e1 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp30_ = _data_->e1;
		if (!g_error_matches (_data_->_tmp30_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			_data_->_tmp31_ = _data_->file;
			_data_->_tmp32_ = NULL;
			_data_->_tmp32_ = g_file_get_path (_data_->_tmp31_);
			_data_->_tmp33_ = _data_->_tmp32_;
			_data_->_tmp34_ = _data_->e1;
			_data_->_tmp35_ = _data_->_tmp34_->message;
			g_warning ("backend-store.vala:720: The backends key file '%s' could not be loaded" \
": %s", _data_->_tmp33_, _data_->_tmp35_);
			_g_free0 (_data_->_tmp33_);
			_g_error_free0 (_data_->e1);
			_g_object_unref0 (_data_->file);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_error_free0 (_data_->e1);
	}
	__finally6:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (_data_->file);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_backend_store_save_key_file_data_free (gpointer _data) {
	FolksBackendStoreSaveKeyFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendStoreSaveKeyFileData, _data_);
}


static void _folks_backend_store_save_key_file (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendStoreSaveKeyFileData* _data_;
	FolksBackendStore* _tmp0_;
	_data_ = g_slice_new0 (FolksBackendStoreSaveKeyFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_backend_store_save_key_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_backend_store_save_key_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_folks_backend_store_save_key_file_co (_data_);
}


static void _folks_backend_store_save_key_file_finish (FolksBackendStore* self, GAsyncResult* _res_) {
	FolksBackendStoreSaveKeyFileData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _folks_backend_store_save_key_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendStoreSaveKeyFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backend_store_save_key_file_co (_data_);
}


static gboolean _folks_backend_store_save_key_file_co (FolksBackendStoreSaveKeyFileData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_backends_key_file;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_key_file_to_data (_data_->_tmp0_, NULL, NULL);
	_data_->key_file_data = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->_config_file;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_file_get_path (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	g_debug ("backend-store.vala:731: Saving backend key file '%s'.", _data_->_tmp4_);
	_g_free0 (_data_->_tmp4_);
	{
		_data_->_tmp5_ = _data_->self->priv->_config_file;
		_data_->_tmp6_ = strlen (_data_->key_file_data);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_state_ = 1;
		g_file_replace_contents_async (_data_->_tmp5_, _data_->key_file_data, (gsize) _data_->_tmp7_, NULL, FALSE, G_FILE_CREATE_PRIVATE, NULL, _folks_backend_store_save_key_file_ready, _data_);
		return FALSE;
		_state_1:
		g_file_replace_contents_finish (_data_->_tmp5_, _data_->_res_, NULL, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp8_ = _data_->self->priv->_config_file;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = g_file_get_path (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = _data_->e;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_warning ("backend-store.vala:748: Could not write updated backend key file '%s':" \
" %s", _data_->_tmp10_, _data_->_tmp12_);
		_g_free0 (_data_->_tmp10_);
		_g_error_free0 (_data_->e);
	}
	__finally7:
	if (_data_->_inner_error_ != NULL) {
		_g_free0 (_data_->key_file_data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_free0 (_data_->key_file_data);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


GeeMap* folks_backend_store_get_enabled_backends (FolksBackendStore* self) {
	GeeMap* result;
	GeeMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_prepared_backends_ro;
	result = _tmp0_;
	return result;
}


static void folks_backend_store_set_enabled_backends (FolksBackendStore* self, GeeMap* value) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject *) self, "enabled-backends");
}


gboolean folks_backend_store_get_is_prepared (FolksBackendStore* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static void folks_backend_store_set_is_prepared (FolksBackendStore* self, gboolean value) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject *) self, "is-prepared");
}


static void folks_backend_store_class_init (FolksBackendStoreClass * klass) {
	gchar* _tmp0_;
	folks_backend_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendStorePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backend_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_backend_store_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_backend_store_finalize;
	/**
	   * The list of backends visible to this store which have not been explicitly
	   * disabled.
	   *
	   * This list will be empty before {@link BackendStore.load_backends} has been
	   * called.
	   *
	   * The backends in this list have been prepared and are ready to use.
	   *
	   * @since 0.5.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_STORE_ENABLED_BACKENDS, g_param_spec_object ("enabled-backends", "enabled-backends", "enabled-backends", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether {@link BackendStore.prepare} has successfully completed for this
	   * store.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKEND_STORE_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Emitted when a backend has been added to the BackendStore.
	   *
	   * This will not be emitted until after {@link BackendStore.load_backends}
	   * has been called.
	   *
	   * {@link Backend}s referenced in this signal are also included in
	   * {@link BackendStore.enabled_backends}.
	   *
	   * @param backend the new {@link Backend}
	   */
	g_signal_new ("backend_available", FOLKS_TYPE_BACKEND_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FOLKS_TYPE_BACKEND);
	_tmp0_ = g_strdup ("all-others");
	folks_backend_store_KEY_FILE_GROUP_ALL_OTHERS = _tmp0_;
}


static void folks_backend_store_instance_init (FolksBackendStore * self) {
	self->priv = FOLKS_BACKEND_STORE_GET_PRIVATE (self);
	self->priv->_is_prepared = FALSE;
}


static void folks_backend_store_finalize (GObject* obj) {
	FolksBackendStore * self;
	FolksDebug* _tmp15_;
	guint _tmp16_ = 0U;
	self = FOLKS_BACKEND_STORE (obj);
	{
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _module_it;
		_tmp0_ = self->priv->_modules;
		_tmp1_ = gee_map_get_values ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_module_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			GModule* module;
			void* func = NULL;
			GModule* _tmp10_;
			void* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			_tmp6_ = _module_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _module_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			module = (GModule*) _tmp9_;
			_tmp10_ = module;
			_tmp12_ = g_module_symbol (_tmp10_, "module_finalize", &_tmp11_);
			func = _tmp11_;
			if (_tmp12_) {
				void* _tmp13_;
				FolksBackendStoreModuleFinalizeFunc module_finalize;
				FolksBackendStoreModuleFinalizeFunc _tmp14_;
				_tmp13_ = func;
				module_finalize = (FolksBackendStoreModuleFinalizeFunc) _tmp13_;
				_tmp14_ = module_finalize;
				_tmp14_ (self);
			}
		}
		_g_object_unref0 (_module_it);
	}
	_tmp15_ = self->priv->_debug;
	g_signal_parse_name ("print-status", FOLKS_TYPE_DEBUG, &_tmp16_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp15_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) __folks_backend_store_debug_print_status_folks_debug_print_status, self);
	_g_object_unref0 (self->priv->_debug);
	self->priv->_debug = NULL;
	folks_backend_store__instance = NULL;
	_g_object_unref0 (self->priv->_backend_hash);
	_g_object_unref0 (self->priv->_prepared_backends);
	_g_object_unref0 (self->priv->_prepared_backends_ro);
	_g_object_unref0 (self->priv->_config_file);
	_g_key_file_free0 (self->priv->_backends_key_file);
	_g_object_unref0 (self->priv->_modules);
	_g_object_unref0 (self->priv->_debug);
	G_OBJECT_CLASS (folks_backend_store_parent_class)->finalize (obj);
}


/**
 * Responsible for backend loading.
 *
 * The BackendStore manages the set of available Folks backends. The
 * {@link BackendStore.load_backends} function loads all compatible and enabled
 * backends and the {@link BackendStore.backend_available} signal notifies when
 * these backends are ready.
 */
GType folks_backend_store_get_type (void) {
	static volatile gsize folks_backend_store_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backend_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backend_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendStore), 0, (GInstanceInitFunc) folks_backend_store_instance_init, NULL };
		GType folks_backend_store_type_id;
		folks_backend_store_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksBackendStore", &g_define_type_info, 0);
		g_once_init_leave (&folks_backend_store_type_id__volatile, folks_backend_store_type_id);
	}
	return folks_backend_store_type_id__volatile;
}


static void _vala_folks_backend_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendStore * self;
	self = FOLKS_BACKEND_STORE (object);
	switch (property_id) {
		case FOLKS_BACKEND_STORE_ENABLED_BACKENDS:
		g_value_set_object (value, folks_backend_store_get_enabled_backends (self));
		break;
		case FOLKS_BACKEND_STORE_IS_PREPARED:
		g_value_set_boolean (value, folks_backend_store_get_is_prepared (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_backend_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksBackendStore * self;
	self = FOLKS_BACKEND_STORE (object);
	switch (property_id) {
		case FOLKS_BACKEND_STORE_ENABLED_BACKENDS:
		folks_backend_store_set_enabled_backends (self, g_value_get_object (value));
		break;
		case FOLKS_BACKEND_STORE_IS_PREPARED:
		folks_backend_store_set_is_prepared (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



