/* eds-backend.c generated by valac 0.14.0.1-60fb, the Vala compiler
 * generated from eds-backend.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libedataserver/e-account.h>
#include <libedataserver/e-source.h>
#include <gio/gio.h>
#include <libebook/e-book-client.h>
#include <folks/folks-eds.h>


#define FOLKS_BACKENDS_EDS_TYPE_BACKEND (folks_backends_eds_backend_get_type ())
#define FOLKS_BACKENDS_EDS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_EDS_TYPE_BACKEND, FolksBackendsEdsBackend))
#define FOLKS_BACKENDS_EDS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_EDS_TYPE_BACKEND, FolksBackendsEdsBackendClass))
#define FOLKS_BACKENDS_EDS_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_EDS_TYPE_BACKEND))
#define FOLKS_BACKENDS_EDS_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_EDS_TYPE_BACKEND))
#define FOLKS_BACKENDS_EDS_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_EDS_TYPE_BACKEND, FolksBackendsEdsBackendClass))

typedef struct _FolksBackendsEdsBackend FolksBackendsEdsBackend;
typedef struct _FolksBackendsEdsBackendClass FolksBackendsEdsBackendClass;
typedef struct _FolksBackendsEdsBackendPrivate FolksBackendsEdsBackendPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksBackendsEdsBackendPrepareData FolksBackendsEdsBackendPrepareData;
typedef struct _FolksBackendsEdsBackendUnprepareData FolksBackendsEdsBackendUnprepareData;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _FolksBackendsEdsBackend {
	FolksBackend parent_instance;
	FolksBackendsEdsBackendPrivate * priv;
};

struct _FolksBackendsEdsBackendClass {
	FolksBackendClass parent_class;
};

struct _FolksBackendsEdsBackendPrivate {
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	gboolean _is_quiescent;
	GeeHashMap* _persona_stores;
	GeeMap* _persona_stores_ro;
	ESourceList* _ab_sources;
};

struct _FolksBackendsEdsBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsEdsBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ESourceList* _tmp2_;
	ESourceList* _tmp3_;
	ESourceList* _tmp4_;
	gboolean _tmp5_;
	GError * _inner_error_;
};

struct _FolksBackendsEdsBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsEdsBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GeeHashMap* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _tmp7_;
	GeeIterator* _persona_store_it;
	GeeIterator* _tmp8_;
	gboolean _tmp9_;
	GeeIterator* _tmp10_;
	gpointer _tmp11_;
	FolksPersonaStore* persona_store;
	FolksPersonaStore* _tmp12_;
	ESourceList* _tmp13_;
	guint _tmp14_;
	gboolean _tmp15_;
	GError * _inner_error_;
};


static gpointer folks_backends_eds_backend_parent_class = NULL;

GType folks_backends_eds_backend_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_EDS_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_EDS_TYPE_BACKEND, FolksBackendsEdsBackendPrivate))
enum  {
	FOLKS_BACKENDS_EDS_BACKEND_DUMMY_PROPERTY,
	FOLKS_BACKENDS_EDS_BACKEND_NAME,
	FOLKS_BACKENDS_EDS_BACKEND_PERSONA_STORES,
	FOLKS_BACKENDS_EDS_BACKEND_IS_PREPARED,
	FOLKS_BACKENDS_EDS_BACKEND_IS_QUIESCENT
};
#define FOLKS_BACKENDS_EDS_BACKEND__use_address_books "FOLKS_BACKEND_EDS_USE_ADDRESS_BOOKS"
FolksBackendsEdsBackend* folks_backends_eds_backend_new (void);
FolksBackendsEdsBackend* folks_backends_eds_backend_construct (GType object_type);
static void folks_backends_eds_backend_real_prepare_data_free (gpointer _data);
static void folks_backends_eds_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_eds_backend_real_prepare_co (FolksBackendsEdsBackendPrepareData* _data_);
static void _folks_backends_eds_backend_create_avatars_cache_dir (FolksBackendsEdsBackend* self);
static void _folks_backends_eds_backend_ab_source_list_changed_cb (FolksBackendsEdsBackend* self, ESourceList* list);
static void __folks_backends_eds_backend_ab_source_list_changed_cb_e_source_list_changed (ESourceList* _sender, gpointer self);
static void folks_backends_eds_backend_real_unprepare_data_free (gpointer _data);
static void folks_backends_eds_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_eds_backend_real_unprepare_co (FolksBackendsEdsBackendUnprepareData* _data_);
static void _folks_backends_eds_backend_remove_address_book (FolksBackendsEdsBackend* self, FolksPersonaStore* store);
static gchar** _folks_backends_eds_backend_get_addressbooks_from_env (FolksBackendsEdsBackend* self, int* result_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void _folks_backends_eds_backend_add_address_book (FolksBackendsEdsBackend* self, ESource* s);
static void _folks_backends_eds_backend_store_removed_cb (FolksBackendsEdsBackend* self, FolksPersonaStore* store);
static void __folks_backends_eds_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
static void folks_backends_eds_backend_finalize (GObject* obj);
static void _vala_folks_backends_eds_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
   * {@inheritDoc}
   */
FolksBackendsEdsBackend* folks_backends_eds_backend_construct (GType object_type) {
	FolksBackendsEdsBackend * self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
#line 61 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	self = (FolksBackendsEdsBackend*) folks_backend_construct (object_type);
#line 63 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 63 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_g_object_unref0 (self->priv->_persona_stores);
#line 63 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	self->priv->_persona_stores = _tmp0_;
#line 64 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp1_ = self->priv->_persona_stores;
#line 64 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
#line 64 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp3_ = _tmp2_;
#line 64 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_g_object_unref0 (self->priv->_persona_stores_ro);
#line 64 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	self->priv->_persona_stores_ro = _tmp3_;
#line 61 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	return self;
#line 181 "eds-backend.c"
}


FolksBackendsEdsBackend* folks_backends_eds_backend_new (void) {
#line 61 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	return folks_backends_eds_backend_construct (FOLKS_BACKENDS_EDS_TYPE_BACKEND);
#line 188 "eds-backend.c"
}


static void folks_backends_eds_backend_real_prepare_data_free (gpointer _data) {
	FolksBackendsEdsBackendPrepareData* _data_;
	_data_ = _data;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_g_object_unref0 (_data_->self);
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_slice_free (FolksBackendsEdsBackendPrepareData, _data_);
#line 199 "eds-backend.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	return self ? g_object_ref (self) : NULL;
#line 206 "eds-backend.c"
}


static void folks_backends_eds_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsEdsBackend * self;
	FolksBackendsEdsBackendPrepareData* _data_;
	FolksBackendsEdsBackend* _tmp0_;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	self = (FolksBackendsEdsBackend*) base;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_data_ = g_slice_new0 (FolksBackendsEdsBackendPrepareData);
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_eds_backend_real_prepare);
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_eds_backend_real_prepare_data_free);
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_data_->self = _tmp0_;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	folks_backends_eds_backend_real_prepare_co (_data_);
#line 228 "eds-backend.c"
}


static void folks_backends_eds_backend_real_prepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsEdsBackendPrepareData* _data_;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		return;
#line 238 "eds-backend.c"
	}
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 242 "eds-backend.c"
}


/**
   * {@inheritDoc}
   */
static void __folks_backends_eds_backend_ab_source_list_changed_cb_e_source_list_changed (ESourceList* _sender, gpointer self) {
#line 103 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_folks_backends_eds_backend_ab_source_list_changed_cb (self, _sender);
#line 252 "eds-backend.c"
}


static gboolean folks_backends_eds_backend_real_prepare_co (FolksBackendsEdsBackendPrepareData* _data_) {
#line 94 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	switch (_data_->_state_) {
#line 94 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		case 0:
#line 261 "eds-backend.c"
		goto _state_0;
		default:
#line 94 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		g_assert_not_reached ();
#line 266 "eds-backend.c"
	}
	_state_0:
	{
#line 96 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_data_->_tmp0_ = _data_->self->priv->_is_prepared;
#line 96 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		g_static_rec_mutex_lock (&_data_->self->priv->__lock__is_prepared);
#line 274 "eds-backend.c"
		{
#line 98 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			_data_->_tmp1_ = _data_->self->priv->_is_prepared;
#line 98 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			if (!_data_->_tmp1_) {
#line 100 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				_folks_backends_eds_backend_create_avatars_cache_dir (_data_->self);
#line 102 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				_data_->_tmp2_ = NULL;
#line 102 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				e_book_client_get_sources (&_data_->_tmp2_, &_data_->_inner_error_);
#line 102 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				_g_object_unref0 (_data_->self->priv->_ab_sources);
#line 102 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				_data_->self->priv->_ab_sources = _data_->_tmp2_;
#line 102 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				if (_data_->_inner_error_ != NULL) {
#line 292 "eds-backend.c"
					goto __finally0;
				}
#line 103 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				_data_->_tmp3_ = _data_->self->priv->_ab_sources;
#line 103 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				g_signal_connect_object (_data_->_tmp3_, "changed", (GCallback) __folks_backends_eds_backend_ab_source_list_changed_cb_e_source_list_changed, _data_->self, 0);
#line 105 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				_data_->_tmp4_ = _data_->self->priv->_ab_sources;
#line 105 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				_folks_backends_eds_backend_ab_source_list_changed_cb (_data_->self, _data_->_tmp4_);
#line 107 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				_data_->self->priv->_is_prepared = TRUE;
#line 108 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				g_object_notify ((GObject*) _data_->self, "is-prepared");
#line 110 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				_data_->self->priv->_is_quiescent = TRUE;
#line 111 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				g_object_notify ((GObject*) _data_->self, "is-quiescent");
#line 311 "eds-backend.c"
			}
		}
		__finally0:
		{
#line 96 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			_data_->_tmp5_ = _data_->self->priv->_is_prepared;
#line 96 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
#line 320 "eds-backend.c"
		}
#line 96 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 96 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 96 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 96 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			if (_data_->_state_ == 0) {
#line 96 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 332 "eds-backend.c"
			} else {
#line 96 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 336 "eds-backend.c"
			}
#line 96 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			g_object_unref (_data_->_async_result);
#line 96 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			return FALSE;
#line 342 "eds-backend.c"
		}
	}
#line 94 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	if (_data_->_state_ == 0) {
#line 94 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 349 "eds-backend.c"
	} else {
#line 94 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 353 "eds-backend.c"
	}
#line 94 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_object_unref (_data_->_async_result);
#line 94 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	return FALSE;
#line 359 "eds-backend.c"
}


static void folks_backends_eds_backend_real_unprepare_data_free (gpointer _data) {
	FolksBackendsEdsBackendUnprepareData* _data_;
	_data_ = _data;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_g_object_unref0 (_data_->self);
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_slice_free (FolksBackendsEdsBackendUnprepareData, _data_);
#line 370 "eds-backend.c"
}


static void folks_backends_eds_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsEdsBackend * self;
	FolksBackendsEdsBackendUnprepareData* _data_;
	FolksBackendsEdsBackend* _tmp0_;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	self = (FolksBackendsEdsBackend*) base;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_data_ = g_slice_new0 (FolksBackendsEdsBackendUnprepareData);
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_eds_backend_real_unprepare);
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_eds_backend_real_unprepare_data_free);
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_data_->self = _tmp0_;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	folks_backends_eds_backend_real_unprepare_co (_data_);
#line 392 "eds-backend.c"
}


static void folks_backends_eds_backend_real_unprepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsEdsBackendUnprepareData* _data_;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		return;
#line 402 "eds-backend.c"
	}
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 406 "eds-backend.c"
}


/**
   * {@inheritDoc}
   */
static gboolean folks_backends_eds_backend_real_unprepare_co (FolksBackendsEdsBackendUnprepareData* _data_) {
#line 119 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	switch (_data_->_state_) {
#line 119 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		case 0:
#line 418 "eds-backend.c"
		goto _state_0;
		default:
#line 119 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		g_assert_not_reached ();
#line 423 "eds-backend.c"
	}
	_state_0:
	{
#line 121 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_data_->_tmp0_ = _data_->self->priv->_is_prepared;
#line 121 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		g_static_rec_mutex_lock (&_data_->self->priv->__lock__is_prepared);
#line 431 "eds-backend.c"
		{
#line 123 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			_data_->_tmp1_ = _data_->self->priv->_is_prepared;
#line 123 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			if (_data_->_tmp1_) {
#line 437 "eds-backend.c"
				{
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
					_data_->_tmp2_ = _data_->self->priv->_persona_stores;
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
					_data_->_tmp3_ = gee_map_get_values ((GeeMap*) _data_->_tmp2_);
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
					_data_->_tmp4_ = _data_->_tmp3_;
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
					_data_->_tmp5_ = _data_->_tmp4_;
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
					_data_->_tmp6_ = NULL;
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
					_data_->_tmp6_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp5_);
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
					_data_->_tmp7_ = _data_->_tmp6_;
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
					_g_object_unref0 (_data_->_tmp5_);
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
					_data_->_persona_store_it = _data_->_tmp7_;
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
					while (TRUE) {
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
						_data_->_tmp8_ = _data_->_persona_store_it;
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
						_data_->_tmp9_ = FALSE;
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
						_data_->_tmp9_ = gee_iterator_next (_data_->_tmp8_);
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
						if (!_data_->_tmp9_) {
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
							break;
#line 469 "eds-backend.c"
						}
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
						_data_->_tmp10_ = _data_->_persona_store_it;
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
						_data_->_tmp11_ = NULL;
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
						_data_->_tmp11_ = gee_iterator_get (_data_->_tmp10_);
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
						_data_->persona_store = (FolksPersonaStore*) _data_->_tmp11_;
#line 127 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
						_data_->_tmp12_ = _data_->persona_store;
#line 127 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
						_folks_backends_eds_backend_remove_address_book (_data_->self, _data_->_tmp12_);
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
						_g_object_unref0 (_data_->persona_store);
#line 485 "eds-backend.c"
					}
#line 125 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
					_g_object_unref0 (_data_->_persona_store_it);
#line 489 "eds-backend.c"
				}
#line 130 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				_data_->_tmp13_ = _data_->self->priv->_ab_sources;
#line 130 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				_data_->_tmp14_ = 0U;
#line 130 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				g_signal_parse_name ("changed", e_source_list_get_type (), &_data_->_tmp14_, NULL, FALSE);
#line 130 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				g_signal_handlers_disconnect_matched (_data_->_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp14_, 0, NULL, (GCallback) __folks_backends_eds_backend_ab_source_list_changed_cb_e_source_list_changed, _data_->self);
#line 131 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				_g_object_unref0 (_data_->self->priv->_ab_sources);
#line 131 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				_data_->self->priv->_ab_sources = NULL;
#line 133 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				_data_->self->priv->_is_quiescent = FALSE;
#line 134 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				g_object_notify ((GObject*) _data_->self, "is-quiescent");
#line 136 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				_data_->self->priv->_is_prepared = FALSE;
#line 137 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				g_object_notify ((GObject*) _data_->self, "is-prepared");
#line 511 "eds-backend.c"
			}
		}
		__finally1:
		{
#line 121 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			_data_->_tmp15_ = _data_->self->priv->_is_prepared;
#line 121 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
#line 520 "eds-backend.c"
		}
#line 121 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		if (_data_->_inner_error_ != NULL) {
#line 121 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 121 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			g_error_free (_data_->_inner_error_);
#line 121 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			if (_data_->_state_ == 0) {
#line 121 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 532 "eds-backend.c"
			} else {
#line 121 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 536 "eds-backend.c"
			}
#line 121 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			g_object_unref (_data_->_async_result);
#line 121 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			return FALSE;
#line 542 "eds-backend.c"
		}
	}
#line 119 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	if (_data_->_state_ == 0) {
#line 119 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 549 "eds-backend.c"
	} else {
#line 119 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 553 "eds-backend.c"
	}
#line 119 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_object_unref (_data_->_async_result);
#line 119 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	return FALSE;
#line 559 "eds-backend.c"
}


static void _folks_backends_eds_backend_create_avatars_cache_dir (FolksBackendsEdsBackend* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* avatars_dir;
#line 142 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_return_if_fail (self != NULL);
#line 144 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp0_ = g_get_user_cache_dir ();
#line 144 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp1_ = g_build_filename (_tmp0_, "folks", "avatars", NULL);
#line 144 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	avatars_dir = _tmp1_;
#line 146 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_mkdir_with_parents (avatars_dir, 0700);
#line 142 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_g_free0 (avatars_dir);
#line 579 "eds-backend.c"
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
#line 173 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	for (i = 0; i < stack_length; i++) {
#line 173 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 173 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			return TRUE;
#line 591 "eds-backend.c"
		}
	}
#line 173 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	return FALSE;
#line 596 "eds-backend.c"
}


static void _folks_backends_eds_backend_ab_source_list_changed_cb (FolksBackendsEdsBackend* self, ESourceList* list) {
	gint _tmp0_ = 0;
	gchar** _tmp1_ = NULL;
	gchar** use_addressbooks;
	gint use_addressbooks_length1;
	gint _use_addressbooks_size_;
	ESourceList* _tmp2_;
	GSList* _tmp3_ = NULL;
	GSList* groups;
	GeeLinkedList* _tmp4_;
	GeeLinkedList* added_sources;
	GSList* _tmp5_;
#line 153 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_return_if_fail (self != NULL);
#line 153 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_return_if_fail (list != NULL);
#line 155 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp1_ = _folks_backends_eds_backend_get_addressbooks_from_env (self, &_tmp0_);
#line 155 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	use_addressbooks = _tmp1_;
#line 155 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	use_addressbooks_length1 = _tmp0_;
#line 155 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_use_addressbooks_size_ = use_addressbooks_length1;
#line 156 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp2_ = self->priv->_ab_sources;
#line 156 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp3_ = e_source_list_peek_groups (_tmp2_);
#line 156 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	groups = _tmp3_;
#line 159 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_debug ("eds-backend.vala:159: Address book source list changed.");
#line 164 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp4_ = gee_linked_list_new (e_source_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 164 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	added_sources = _tmp4_;
#line 166 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp5_ = groups;
#line 638 "eds-backend.c"
	{
		GSList* g_collection = NULL;
		GSList* g_it = NULL;
#line 166 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		g_collection = _tmp5_;
#line 166 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		for (g_it = g_collection; g_it != NULL; g_it = g_it->next) {
#line 646 "eds-backend.c"
			ESourceGroup* g = NULL;
#line 166 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			g = (ESourceGroup*) g_it->data;
#line 650 "eds-backend.c"
			{
				ESourceGroup* _tmp6_;
				GSList* _tmp7_ = NULL;
#line 168 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				_tmp6_ = g;
#line 168 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				_tmp7_ = e_source_group_peek_sources (_tmp6_);
#line 658 "eds-backend.c"
				{
					GSList* s_collection = NULL;
					GSList* s_it = NULL;
#line 168 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
					s_collection = _tmp7_;
#line 168 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
					for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
#line 666 "eds-backend.c"
						ESource* _tmp8_;
						ESource* s = NULL;
#line 168 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
						_tmp8_ = _g_object_ref0 ((ESource*) s_it->data);
#line 168 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
						s = _tmp8_;
#line 673 "eds-backend.c"
						{
							gboolean _tmp9_ = FALSE;
							gchar** _tmp10_;
							gint _tmp10__length1;
							gboolean _tmp14_;
							ESource* _tmp15_;
							const gchar* _tmp16_ = NULL;
							gchar* _tmp17_;
							gchar* source_uri;
							GeeHashMap* _tmp18_;
							const gchar* _tmp19_;
							gboolean _tmp20_ = FALSE;
#line 172 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
							_tmp10_ = use_addressbooks;
#line 172 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
							_tmp10__length1 = use_addressbooks_length1;
#line 172 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
							if (_tmp10__length1 > 0) {
#line 692 "eds-backend.c"
								ESource* _tmp11_;
								const gchar* _tmp12_ = NULL;
								gchar** _tmp13_;
								gint _tmp13__length1;
#line 173 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
								_tmp11_ = s;
#line 173 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
								_tmp12_ = e_source_peek_name (_tmp11_);
#line 173 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
								_tmp13_ = use_addressbooks;
#line 173 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
								_tmp13__length1 = use_addressbooks_length1;
#line 173 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
								_tmp9_ = !_vala_string_array_contains (_tmp13_, _tmp13__length1, _tmp12_);
#line 707 "eds-backend.c"
							} else {
#line 172 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
								_tmp9_ = FALSE;
#line 711 "eds-backend.c"
							}
#line 172 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
							_tmp14_ = _tmp9_;
#line 172 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
							if (_tmp14_) {
#line 175 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
								_g_object_unref0 (s);
#line 175 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
								continue;
#line 721 "eds-backend.c"
							}
#line 178 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
							_tmp15_ = s;
#line 178 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
							_tmp16_ = e_source_peek_relative_uri (_tmp15_);
#line 178 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
							_tmp17_ = g_strdup (_tmp16_);
#line 178 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
							source_uri = _tmp17_;
#line 180 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
							_tmp18_ = self->priv->_persona_stores;
#line 180 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
							_tmp19_ = source_uri;
#line 180 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
							_tmp20_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp18_, _tmp19_);
#line 180 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
							if (!_tmp20_) {
#line 739 "eds-backend.c"
								GeeLinkedList* _tmp21_;
								ESource* _tmp22_;
#line 182 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
								_tmp21_ = added_sources;
#line 182 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
								_tmp22_ = s;
#line 182 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
#line 748 "eds-backend.c"
							}
#line 168 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
							_g_free0 (source_uri);
#line 168 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
							_g_object_unref0 (s);
#line 754 "eds-backend.c"
						}
					}
				}
			}
		}
	}
	{
		GeeLinkedList* _tmp23_;
		GeeLinkedList* _tmp24_;
		GeeLinkedList* _source_list;
		GeeLinkedList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _source_size;
		gint _source_index;
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_tmp23_ = added_sources;
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_tmp24_ = _g_object_ref0 (_tmp23_);
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_source_list = _tmp24_;
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_tmp25_ = _source_list;
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_tmp26_ = gee_collection_get_size ((GeeCollection*) _tmp25_);
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_tmp27_ = _tmp26_;
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_source_size = _tmp27_;
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_source_index = -1;
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		while (TRUE) {
#line 788 "eds-backend.c"
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			GeeLinkedList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_ = NULL;
			ESource* source;
			ESource* _tmp34_;
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			_tmp28_ = _source_index;
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			_source_index = _tmp28_ + 1;
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			_tmp29_ = _source_index;
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			_tmp30_ = _source_size;
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			if (!(_tmp29_ < _tmp30_)) {
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
				break;
#line 809 "eds-backend.c"
			}
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			_tmp31_ = _source_list;
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			_tmp32_ = _source_index;
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			source = (ESource*) _tmp33_;
#line 191 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			_tmp34_ = source;
#line 191 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			_folks_backends_eds_backend_add_address_book (self, _tmp34_);
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
			_g_object_unref0 (source);
#line 825 "eds-backend.c"
		}
#line 189 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_g_object_unref0 (_source_list);
#line 829 "eds-backend.c"
	}
#line 153 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_g_object_unref0 (added_sources);
#line 153 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	use_addressbooks = (_vala_array_free (use_addressbooks, use_addressbooks_length1, (GDestroyNotify) g_free), NULL);
#line 835 "eds-backend.c"
}


/**
   * Add a new addressbook connected to a Persona Store.
   */
static void __folks_backends_eds_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
#line 209 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_folks_backends_eds_backend_store_removed_cb (self, _sender);
#line 845 "eds-backend.c"
}


static void _folks_backends_eds_backend_add_address_book (FolksBackendsEdsBackend* self, ESource* s) {
	ESource* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* relative_uri;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	ESource* _tmp7_;
	EdsfPersonaStore* _tmp8_;
	EdsfPersonaStore* store;
	EdsfPersonaStore* _tmp9_;
	GeeHashMap* _tmp10_;
	EdsfPersonaStore* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	EdsfPersonaStore* _tmp14_;
	EdsfPersonaStore* _tmp15_;
#line 198 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_return_if_fail (self != NULL);
#line 198 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_return_if_fail (s != NULL);
#line 200 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp0_ = s;
#line 200 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp1_ = e_source_peek_relative_uri (_tmp0_);
#line 200 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 200 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	relative_uri = _tmp2_;
#line 202 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp3_ = self->priv->_persona_stores;
#line 202 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp4_ = relative_uri;
#line 202 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp5_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp3_, _tmp4_);
#line 202 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	if (_tmp5_) {
#line 203 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_g_free0 (relative_uri);
#line 203 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		return;
#line 892 "eds-backend.c"
	}
#line 205 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp6_ = relative_uri;
#line 205 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_debug ("eds-backend.vala:205: Adding address book '%s'.", _tmp6_);
#line 207 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp7_ = s;
#line 207 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp8_ = edsf_persona_store_new (_tmp7_);
#line 207 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	store = _tmp8_;
#line 209 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp9_ = store;
#line 209 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_signal_connect_object ((FolksPersonaStore*) _tmp9_, "removed", (GCallback) __folks_backends_eds_backend_store_removed_cb_folks_persona_store_removed, self, 0);
#line 211 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp10_ = self->priv->_persona_stores;
#line 211 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp11_ = store;
#line 211 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp12_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp11_);
#line 211 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp13_ = _tmp12_;
#line 211 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp14_ = store;
#line 211 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, _tmp13_, (FolksPersonaStore*) _tmp14_);
#line 212 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_object_notify ((GObject*) self, "persona-stores");
#line 214 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp15_ = store;
#line 214 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-added", (FolksPersonaStore*) _tmp15_);
#line 198 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_g_object_unref0 (store);
#line 198 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_g_free0 (relative_uri);
#line 930 "eds-backend.c"
}


static void _folks_backends_eds_backend_remove_address_book (FolksBackendsEdsBackend* self, FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	FolksPersonaStore* _tmp3_;
	GeeHashMap* _tmp4_;
	FolksPersonaStore* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	FolksPersonaStore* _tmp8_;
	guint _tmp9_ = 0U;
#line 217 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_return_if_fail (self != NULL);
#line 217 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_return_if_fail (store != NULL);
#line 219 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp0_ = store;
#line 219 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp1_ = folks_persona_store_get_id (_tmp0_);
#line 219 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp2_ = _tmp1_;
#line 219 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_debug ("eds-backend.vala:219: Removing address book '%s'.", _tmp2_);
#line 221 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp3_ = store;
#line 221 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", _tmp3_);
#line 223 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp4_ = self->priv->_persona_stores;
#line 223 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp5_ = store;
#line 223 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp6_ = folks_persona_store_get_id (_tmp5_);
#line 223 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp7_ = _tmp6_;
#line 223 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp4_, _tmp7_, NULL);
#line 224 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_object_notify ((GObject*) self, "persona-stores");
#line 226 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp8_ = store;
#line 226 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_tmp9_, NULL, FALSE);
#line 226 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) __folks_backends_eds_backend_store_removed_cb_folks_persona_store_removed, self);
#line 979 "eds-backend.c"
}


static void _folks_backends_eds_backend_store_removed_cb (FolksBackendsEdsBackend* self, FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_;
#line 229 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_return_if_fail (self != NULL);
#line 229 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_return_if_fail (store != NULL);
#line 231 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp0_ = store;
#line 231 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_folks_backends_eds_backend_remove_address_book (self, _tmp0_);
#line 993 "eds-backend.c"
}


static gchar** _folks_backends_eds_backend_get_addressbooks_from_env (FolksBackendsEdsBackend* self, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** addressbooks;
	gint addressbooks_length1;
	gint _addressbooks_size_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* ab_list;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	gchar** _tmp10_;
	gint _tmp10__length1;
#line 234 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 236 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 236 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	addressbooks = _tmp0_;
#line 236 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	addressbooks_length1 = 0;
#line 236 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_addressbooks_size_ = addressbooks_length1;
#line 237 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp1_ = g_getenv (FOLKS_BACKENDS_EDS_BACKEND__use_address_books);
#line 237 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 237 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	ab_list = _tmp2_;
#line 239 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp4_ = ab_list;
#line 239 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	if (_tmp4_ != NULL) {
#line 1031 "eds-backend.c"
		const gchar* _tmp5_;
#line 239 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_tmp5_ = ab_list;
#line 239 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
#line 1037 "eds-backend.c"
	} else {
#line 239 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_tmp3_ = FALSE;
#line 1041 "eds-backend.c"
	}
#line 239 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp6_ = _tmp3_;
#line 239 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	if (_tmp6_) {
#line 1047 "eds-backend.c"
		const gchar* _tmp7_;
		gchar** _tmp8_;
		gchar** _tmp9_ = NULL;
#line 241 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_tmp7_ = ab_list;
#line 241 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, ":", 0);
#line 241 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		addressbooks = (_vala_array_free (addressbooks, addressbooks_length1, (GDestroyNotify) g_free), NULL);
#line 241 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		addressbooks = _tmp9_;
#line 241 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		addressbooks_length1 = _vala_array_length (_tmp8_);
#line 241 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		_addressbooks_size_ = addressbooks_length1;
#line 1063 "eds-backend.c"
	}
#line 244 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp10_ = addressbooks;
#line 244 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp10__length1 = addressbooks_length1;
#line 244 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	if (result_length1) {
#line 244 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		*result_length1 = _tmp10__length1;
#line 1073 "eds-backend.c"
	}
#line 244 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	result = _tmp10_;
#line 244 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_g_free0 (ab_list);
#line 244 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	return result;
#line 1081 "eds-backend.c"
}


static const gchar* folks_backends_eds_backend_real_get_name (FolksBackend* base) {
	const gchar* result;
	FolksBackendsEdsBackend* self;
#line 48 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	self = (FolksBackendsEdsBackend*) base;
#line 48 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	result = BACKEND_NAME;
#line 48 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	return result;
#line 1094 "eds-backend.c"
}


static GeeMap* folks_backends_eds_backend_real_get_persona_stores (FolksBackend* base) {
	GeeMap* result;
	FolksBackendsEdsBackend* self;
	GeeMap* _tmp0_;
#line 55 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	self = (FolksBackendsEdsBackend*) base;
#line 55 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp0_ = self->priv->_persona_stores_ro;
#line 55 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	result = _tmp0_;
#line 55 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	return result;
#line 1110 "eds-backend.c"
}


static gboolean folks_backends_eds_backend_real_get_is_prepared (FolksBackend* base) {
	gboolean result;
	FolksBackendsEdsBackend* self;
	gboolean _tmp0_;
#line 76 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	self = (FolksBackendsEdsBackend*) base;
#line 76 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp0_ = self->priv->_is_prepared;
#line 76 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	result = _tmp0_;
#line 76 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	return result;
#line 1126 "eds-backend.c"
}


static gboolean folks_backends_eds_backend_real_get_is_quiescent (FolksBackend* base) {
	gboolean result;
	FolksBackendsEdsBackend* self;
	gboolean _tmp0_;
#line 88 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	self = (FolksBackendsEdsBackend*) base;
#line 88 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_tmp0_ = self->priv->_is_quiescent;
#line 88 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	result = _tmp0_;
#line 88 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	return result;
#line 1142 "eds-backend.c"
}


static void folks_backends_eds_backend_class_init (FolksBackendsEdsBackendClass * klass) {
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	folks_backends_eds_backend_parent_class = g_type_class_peek_parent (klass);
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_type_class_add_private (klass, sizeof (FolksBackendsEdsBackendPrivate));
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	FOLKS_BACKEND_CLASS (klass)->prepare = folks_backends_eds_backend_real_prepare;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	FOLKS_BACKEND_CLASS (klass)->prepare_finish = folks_backends_eds_backend_real_prepare_finish;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	FOLKS_BACKEND_CLASS (klass)->unprepare = folks_backends_eds_backend_real_unprepare;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	FOLKS_BACKEND_CLASS (klass)->unprepare_finish = folks_backends_eds_backend_real_unprepare_finish;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	FOLKS_BACKEND_CLASS (klass)->get_name = folks_backends_eds_backend_real_get_name;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = folks_backends_eds_backend_real_get_persona_stores;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = folks_backends_eds_backend_real_get_is_prepared;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	FOLKS_BACKEND_CLASS (klass)->get_is_quiescent = folks_backends_eds_backend_real_get_is_quiescent;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_eds_backend_get_property;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	G_OBJECT_CLASS (klass)->finalize = folks_backends_eds_backend_finalize;
#line 1171 "eds-backend.c"
	/**
	   * {@inheritDoc}
	   */
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_EDS_BACKEND_NAME, "name");
#line 1177 "eds-backend.c"
	/**
	   * {@inheritDoc}
	   */
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_EDS_BACKEND_PERSONA_STORES, "persona-stores");
#line 1183 "eds-backend.c"
	/**
	   * Whether this Backend has been prepared.
	   *
	   * See {@link Folks.Backend.is_prepared}.
	   *
	   * @since 0.6.0
	   */
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_EDS_BACKEND_IS_PREPARED, "is-prepared");
#line 1193 "eds-backend.c"
	/**
	   * Whether this Backend has reached a quiescent state.
	   *
	   * See {@link Folks.Backend.is_quiescent}.
	   *
	   * @since 0.6.2
	   */
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_EDS_BACKEND_IS_QUIESCENT, "is-quiescent");
#line 1203 "eds-backend.c"
}


static void folks_backends_eds_backend_instance_init (FolksBackendsEdsBackend * self) {
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	self->priv = FOLKS_BACKENDS_EDS_BACKEND_GET_PRIVATE (self);
#line 39 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
#line 39 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	self->priv->_is_prepared = FALSE;
#line 40 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	self->priv->_is_quiescent = FALSE;
#line 1216 "eds-backend.c"
}


static void folks_backends_eds_backend_finalize (GObject* obj) {
	FolksBackendsEdsBackend * self;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	self = FOLKS_BACKENDS_EDS_BACKEND (obj);
#line 39 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
#line 41 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_g_object_unref0 (self->priv->_persona_stores);
#line 42 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_g_object_unref0 (self->priv->_persona_stores_ro);
#line 43 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	_g_object_unref0 (self->priv->_ab_sources);
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	G_OBJECT_CLASS (folks_backends_eds_backend_parent_class)->finalize (obj);
#line 1234 "eds-backend.c"
}


/**
 * A backend which connects to EDS and creates a {@link PersonaStore}
 * for each service.
 */
GType folks_backends_eds_backend_get_type (void) {
	static volatile gsize folks_backends_eds_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_eds_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsEdsBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_eds_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsEdsBackend), 0, (GInstanceInitFunc) folks_backends_eds_backend_instance_init, NULL };
		GType folks_backends_eds_backend_type_id;
		folks_backends_eds_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksBackendsEdsBackend", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_eds_backend_type_id__volatile, folks_backends_eds_backend_type_id);
	}
	return folks_backends_eds_backend_type_id__volatile;
}


static void _vala_folks_backends_eds_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsEdsBackend * self;
	self = FOLKS_BACKENDS_EDS_BACKEND (object);
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
	switch (property_id) {
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		case FOLKS_BACKENDS_EDS_BACKEND_NAME:
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		break;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		case FOLKS_BACKENDS_EDS_BACKEND_PERSONA_STORES:
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		g_value_set_object (value, folks_backend_get_persona_stores ((FolksBackend*) self));
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		break;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		case FOLKS_BACKENDS_EDS_BACKEND_IS_PREPARED:
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		break;
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		case FOLKS_BACKENDS_EDS_BACKEND_IS_QUIESCENT:
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		g_value_set_boolean (value, folks_backend_get_is_quiescent ((FolksBackend*) self));
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		break;
#line 1283 "eds-backend.c"
		default:
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 35 "/opt/gnome2/source/folks/backends/eds/eds-backend.vala"
		break;
#line 1289 "eds-backend.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



