/* File:       e-gdbus-egdbuscal.c
 *
 * GType name: EGdbusCal
 * D-Bus name: org.gnome.evolution.dataserver.Calendar
 *
 * Generated by GDBus Binding Tool 0.1. DO NOT EDIT.
 */

#include "libedataserver/e-data-server-util.h"

/**
 * SECTION:e-gdbus-egdbuscal
 * @title: EGdbusCal
 * @short_description: Wraps the org.gnome.evolution.dataserver.Calendar D-Bus interface
 * @include: gio/gio.h
 *
 * The abstract #EGdbusCal interface type wraps the <literal>org.gnome.evolution.dataserver.Calendar</literal> D-Bus interface. Two concrete implementations of this type are included: #EGdbusCalProxy and #EGdbusCalStub.
 *
 * The generated proxy type #EGdbusCalProxy is typically used with the generated constructors e_gdbus_cal_proxy_new(), e_gdbus_cal_proxy_new_sync() and e_gdbus_cal_proxy_new_for_bus(), e_gdbus_cal_proxy_new_for_bus_sync().
 *
 * The generated stub type #EGdbusCalStub takes care of handling properties, method invocations and signal emissions. Simply use e_gdbus_cal_stub_new(), set some properties and connect to any of the handle-* signals to handle method invocations. Finally use e_gdbus_cal_register_object() to export the object on a #GDBusConnection.
 * |[
 * /<!-- -->* You can also use g_object_new() with E_GDBUS_TYPE_CAL_STUB
 *  * to set properties at construction time.
 *  *<!-- -->/
 * object = e_gdbus_cal_stub_new ();
 * e_gdbus_cal_set_&lt;property_name&gt; (object, &lt;value_for_property&gt;);
 * [...]
 *
 * g_signal_connect (object,
 *                   "handle-&lt;method-name&gt;",
 *                   G_CALLBACK (on_handle_&lt;method_name&gt;),
 *                   some_user_data);
 * [...]
 *
 * error = NULL;
 * id = e_gdbus_cal_register_object (object,
 *                                   connection,
 *                                   "/path/of/object",
 *                                   &error);
 * ]|
 *
 * You don't <emphasis>have</emphasis> to use the generated stub type to export
 * objects. Any type implementing the #EGdbusCal interface may be used with
 * e_gdbus_cal_register_object().
 *
 * Once exported, you can make the exported object emit D-Bus signals by simply
 * emitting the corresponding GType signals. For better type-safety, you can use,
 * the provided e_gdbus_cal_emit_*() helpers.
 *
 * For property changes, #GObject::notify signal emissions on exported objects
 * will be intercepted and queued. In an idle handler, the queued notifications
 * are processed and a single <literal>PropertiesChanged</literal> signal (on the
 * <literal>org.freedesktop.DBus.Properties</literal> interface) will be emitted
 * for all the properties that changed (possibly containing several properties).
 * Use e_gdbus_cal_drain_notify() to drain the queue immediately.
 */

#include "e-gdbus-egdbuscal.h"
#include "e-gdbus-typemappers.h"
#include "e-gdbus-marshallers.h"

typedef EGdbusCalIface EGdbusCalInterface;
G_DEFINE_INTERFACE (EGdbusCal, e_gdbus_cal, G_TYPE_OBJECT);

enum
{
  _0_SIGNAL,
  __AUTH_REQUIRED_SIGNAL,
  __BACKEND_ERROR_SIGNAL,
  __READONLY_SIGNAL,
  __MODE_SIGNAL,
  __GET_URI_METHOD,
  __GET_CACHE_DIR_METHOD,
  __OPEN_METHOD,
  __REFRESH_METHOD,
  __CLOSE_METHOD,
  __REMOVE_METHOD,
  __IS_READ_ONLY_METHOD,
  __GET_CAL_ADDRESS_METHOD,
  __GET_ALARM_EMAIL_ADDRESS_METHOD,
  __GET_LDAP_ATTRIBUTE_METHOD,
  __GET_SCHEDULING_INFORMATION_METHOD,
  __SET_MODE_METHOD,
  __GET_DEFAULT_OBJECT_METHOD,
  __GET_OBJECT_METHOD,
  __GET_OBJECT_LIST_METHOD,
  __GET_CHANGES_METHOD,
  __GET_FREE_BUSY_METHOD,
  __DISCARD_ALARM_METHOD,
  __CREATE_OBJECT_METHOD,
  __MODIFY_OBJECT_METHOD,
  __REMOVE_OBJECT_METHOD,
  __RECEIVE_OBJECTS_METHOD,
  __SEND_OBJECTS_METHOD,
  __GET_ATTACHMENT_LIST_METHOD,
  __GET_QUERY_METHOD,
  __GET_TIMEZONE_METHOD,
  __ADD_TIMEZONE_METHOD,
  __SET_DEFAULT_TIMEZONE_METHOD,
  __LAST_SIGNAL
};

static guint signals[__LAST_SIGNAL] = {0};

enum
{
  PROP_0,
};

/* ------------------------------------------------------------------------- */

/* Various lookup tables */

static GHashTable *_method_name_to_id = NULL;
static GHashTable *_signal_name_to_id = NULL;
static GHashTable *_property_name_to_id = NULL;
static GHashTable *_property_gname_to_name = NULL;
static GHashTable *_property_name_to_gname = NULL;

static guint
lookup_method_id_from_method_name (const gchar *method_name)
{
  return GPOINTER_TO_UINT (g_hash_table_lookup (_method_name_to_id, method_name));
}

static guint
lookup_signal_id_from_signal_name (const gchar *signal_name)
{
  return GPOINTER_TO_UINT (g_hash_table_lookup (_signal_name_to_id, signal_name));
}

static guint
lookup_property_id_from_property_name (const gchar *property_name)
{
  return GPOINTER_TO_UINT (g_hash_table_lookup (_property_name_to_id, property_name));
}

static const gchar *
lookup_property_name_from_property_gname (const gchar *property_gname)
{
  return g_hash_table_lookup (_property_gname_to_name, property_gname);
}

static const gchar *
lookup_property_gname_from_property_name (const gchar *property_name)
{
  return g_hash_table_lookup (_property_name_to_gname, property_name);
}

/* ------------------------------------------------------------------------- */
static gboolean
signal_emission_hook_cb_auth_required (GSignalInvocationHint *ihint,
                         guint                  n_param_values,
                         const GValue          *param_values,
                         gpointer               user_data)
{
  GObject *object;
  GDBusConnection *connection;
  const gchar *path;
  GVariant *params;

  if (n_param_values < 1 || !G_VALUE_HOLDS (&param_values[0], G_TYPE_OBJECT))
    goto out;
  object = g_value_get_object (&param_values[0]);
  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  if (connection == NULL || path == NULL)
    goto out;

  params = NULL;

  g_dbus_connection_emit_signal (connection,
				 NULL,
				 path,
                                 "org.gnome.evolution.dataserver.Calendar",
                                 "auth_required",
				 params,
				 NULL);
out:
  return TRUE;
}

static gboolean
signal_emission_hook_cb_backend_error (GSignalInvocationHint *ihint,
                         guint                  n_param_values,
                         const GValue          *param_values,
                         gpointer               user_data)
{
  GObject *object;
  GDBusConnection *connection;
  const gchar *path;
  GVariant *params;
  GVariant *item;
  GVariantBuilder *builder;

  if (n_param_values < 1 || !G_VALUE_HOLDS (&param_values[0], G_TYPE_OBJECT))
    goto out;
  object = g_value_get_object (&param_values[0]);
  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  if (connection == NULL || path == NULL)
    goto out;

  builder = g_variant_builder_new (G_VARIANT_TYPE_TUPLE);
  g_assert_cmpint (n_param_values - 1, ==, 1);
  param_values++;
  item = g_variant_new ("s", g_value_get_string (param_values));
  g_variant_builder_add_value (builder, item);
  param_values++;
  params = g_variant_builder_end (builder);
  g_variant_builder_unref (builder);

  g_dbus_connection_emit_signal (connection,
				 NULL,
				 path,
                                 "org.gnome.evolution.dataserver.Calendar",
                                 "backend_error",
				 params,
				 NULL);
out:
  return TRUE;
}

static gboolean
signal_emission_hook_cb_readonly (GSignalInvocationHint *ihint,
                         guint                  n_param_values,
                         const GValue          *param_values,
                         gpointer               user_data)
{
  GObject *object;
  GDBusConnection *connection;
  const gchar *path;
  GVariant *params;
  GVariant *item;
  GVariantBuilder *builder;

  if (n_param_values < 1 || !G_VALUE_HOLDS (&param_values[0], G_TYPE_OBJECT))
    goto out;
  object = g_value_get_object (&param_values[0]);
  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  if (connection == NULL || path == NULL)
    goto out;

  builder = g_variant_builder_new (G_VARIANT_TYPE_TUPLE);
  g_assert_cmpint (n_param_values - 1, ==, 1);
  param_values++;
  item = g_variant_new_boolean (g_value_get_boolean (param_values));
  g_variant_builder_add_value (builder, item);
  param_values++;
  params = g_variant_builder_end (builder);
  g_variant_builder_unref (builder);

  g_dbus_connection_emit_signal (connection,
				 NULL,
				 path,
                                 "org.gnome.evolution.dataserver.Calendar",
                                 "readonly",
				 params,
				 NULL);
out:
  return TRUE;
}

static gboolean
signal_emission_hook_cb_mode (GSignalInvocationHint *ihint,
                         guint                  n_param_values,
                         const GValue          *param_values,
                         gpointer               user_data)
{
  GObject *object;
  GDBusConnection *connection;
  const gchar *path;
  GVariant *params;
  GVariant *item;
  GVariantBuilder *builder;

  if (n_param_values < 1 || !G_VALUE_HOLDS (&param_values[0], G_TYPE_OBJECT))
    goto out;
  object = g_value_get_object (&param_values[0]);
  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  if (connection == NULL || path == NULL)
    goto out;

  builder = g_variant_builder_new (G_VARIANT_TYPE_TUPLE);
  g_assert_cmpint (n_param_values - 1, ==, 1);
  param_values++;
  item = g_variant_new_int32 (g_value_get_int (param_values));
  g_variant_builder_add_value (builder, item);
  param_values++;
  params = g_variant_builder_end (builder);
  g_variant_builder_unref (builder);

  g_dbus_connection_emit_signal (connection,
				 NULL,
				 path,
                                 "org.gnome.evolution.dataserver.Calendar",
                                 "mode",
				 params,
				 NULL);
out:
  return TRUE;
}

static void
e_gdbus_cal_default_init (EGdbusCalIface *iface)
{

  /* Build lookup structures */
  _method_name_to_id = g_hash_table_new (g_str_hash, g_str_equal);
  _signal_name_to_id = g_hash_table_new (g_str_hash, g_str_equal);
  _property_name_to_id = g_hash_table_new (g_str_hash, g_str_equal);
  _property_gname_to_name = g_hash_table_new (g_str_hash, g_str_equal);
  _property_name_to_gname = g_hash_table_new (g_str_hash, g_str_equal);
  g_hash_table_insert (_method_name_to_id, (gpointer) "getUri", GUINT_TO_POINTER (__GET_URI_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getCacheDir", GUINT_TO_POINTER (__GET_CACHE_DIR_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "open", GUINT_TO_POINTER (__OPEN_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "refresh", GUINT_TO_POINTER (__REFRESH_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "close", GUINT_TO_POINTER (__CLOSE_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "remove", GUINT_TO_POINTER (__REMOVE_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "isReadOnly", GUINT_TO_POINTER (__IS_READ_ONLY_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getCalAddress", GUINT_TO_POINTER (__GET_CAL_ADDRESS_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getAlarmEmailAddress", GUINT_TO_POINTER (__GET_ALARM_EMAIL_ADDRESS_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getLdapAttribute", GUINT_TO_POINTER (__GET_LDAP_ATTRIBUTE_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getSchedulingInformation", GUINT_TO_POINTER (__GET_SCHEDULING_INFORMATION_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "setMode", GUINT_TO_POINTER (__SET_MODE_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getDefaultObject", GUINT_TO_POINTER (__GET_DEFAULT_OBJECT_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getObject", GUINT_TO_POINTER (__GET_OBJECT_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getObjectList", GUINT_TO_POINTER (__GET_OBJECT_LIST_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getChanges", GUINT_TO_POINTER (__GET_CHANGES_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getFreeBusy", GUINT_TO_POINTER (__GET_FREE_BUSY_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "discardAlarm", GUINT_TO_POINTER (__DISCARD_ALARM_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "createObject", GUINT_TO_POINTER (__CREATE_OBJECT_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "modifyObject", GUINT_TO_POINTER (__MODIFY_OBJECT_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "removeObject", GUINT_TO_POINTER (__REMOVE_OBJECT_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "receiveObjects", GUINT_TO_POINTER (__RECEIVE_OBJECTS_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "sendObjects", GUINT_TO_POINTER (__SEND_OBJECTS_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getAttachmentList", GUINT_TO_POINTER (__GET_ATTACHMENT_LIST_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getQuery", GUINT_TO_POINTER (__GET_QUERY_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getTimezone", GUINT_TO_POINTER (__GET_TIMEZONE_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "addTimezone", GUINT_TO_POINTER (__ADD_TIMEZONE_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "setDefaultTimezone", GUINT_TO_POINTER (__SET_DEFAULT_TIMEZONE_METHOD));
  g_hash_table_insert (_signal_name_to_id, (gpointer) "auth_required", GUINT_TO_POINTER (__AUTH_REQUIRED_SIGNAL));
  g_hash_table_insert (_signal_name_to_id, (gpointer) "backend_error", GUINT_TO_POINTER (__BACKEND_ERROR_SIGNAL));
  g_hash_table_insert (_signal_name_to_id, (gpointer) "readonly", GUINT_TO_POINTER (__READONLY_SIGNAL));
  g_hash_table_insert (_signal_name_to_id, (gpointer) "mode", GUINT_TO_POINTER (__MODE_SIGNAL));

  /* GObject signals definitions for D-Bus signals: */
  /**
   * EGdbusCal::auth-required:
   * @object: The object emitting the signal.
   *
   * Represents the D-Bus signal <literal>auth_required</literal>.
   *
   * On proxies, connect to this signal to get notified whenever the remote
   * object instances emits the signal (similar to how the
   * #GDBusProxy::g-signal works). The signal is emitted in the
   * thread-default main loop of the thread that the proxy was created in.
   *
   * On exported objects, emitting this signal causes the actual D-Bus signal to be emitted. You can use e_gdbus_cal_emit_auth_required() to do this.
   */  signals[__AUTH_REQUIRED_SIGNAL] =
    g_signal_new ("auth-required",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, auth_required),
		  NULL,
		  NULL,
		  g_cclosure_marshal_VOID__VOID,
		  G_TYPE_NONE,
		  0);
  g_signal_add_emission_hook (signals[__AUTH_REQUIRED_SIGNAL],
			      0,
			      signal_emission_hook_cb_auth_required,
                              (gpointer) "auth_required",
			      NULL);

  /**
   * EGdbusCal::backend-error:
   * @object: The object emitting the signal.
   * @error: Parameter.
   *
   * Represents the D-Bus signal <literal>backend_error</literal>.
   *
   * On proxies, connect to this signal to get notified whenever the remote
   * object instances emits the signal (similar to how the
   * #GDBusProxy::g-signal works). The signal is emitted in the
   * thread-default main loop of the thread that the proxy was created in.
   *
   * On exported objects, emitting this signal causes the actual D-Bus signal to be emitted. You can use e_gdbus_cal_emit_backend_error() to do this.
   */  signals[__BACKEND_ERROR_SIGNAL] =
    g_signal_new ("backend-error",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, backend_error),
		  NULL,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_VOID__STRING,
		  G_TYPE_NONE,
		  1,
		  G_TYPE_STRING);
  g_signal_add_emission_hook (signals[__BACKEND_ERROR_SIGNAL],
			      0,
			      signal_emission_hook_cb_backend_error,
                              (gpointer) "backend_error",
			      NULL);

  /**
   * EGdbusCal::readonly:
   * @object: The object emitting the signal.
   * @is_readonly: Parameter.
   *
   * Represents the D-Bus signal <literal>readonly</literal>.
   *
   * On proxies, connect to this signal to get notified whenever the remote
   * object instances emits the signal (similar to how the
   * #GDBusProxy::g-signal works). The signal is emitted in the
   * thread-default main loop of the thread that the proxy was created in.
   *
   * On exported objects, emitting this signal causes the actual D-Bus signal to be emitted. You can use e_gdbus_cal_emit_readonly() to do this.
   */  signals[__READONLY_SIGNAL] =
    g_signal_new ("readonly",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, readonly),
		  NULL,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_VOID__BOOLEAN,
		  G_TYPE_NONE,
		  1,
		  G_TYPE_BOOLEAN);
  g_signal_add_emission_hook (signals[__READONLY_SIGNAL],
			      0,
			      signal_emission_hook_cb_readonly,
                              (gpointer) "readonly",
			      NULL);

  /**
   * EGdbusCal::mode:
   * @object: The object emitting the signal.
   * @mode: Parameter.
   *
   * Represents the D-Bus signal <literal>mode</literal>.
   *
   * On proxies, connect to this signal to get notified whenever the remote
   * object instances emits the signal (similar to how the
   * #GDBusProxy::g-signal works). The signal is emitted in the
   * thread-default main loop of the thread that the proxy was created in.
   *
   * On exported objects, emitting this signal causes the actual D-Bus signal to be emitted. You can use e_gdbus_cal_emit_mode() to do this.
   */  signals[__MODE_SIGNAL] =
    g_signal_new ("mode",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, mode),
		  NULL,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_VOID__INT,
		  G_TYPE_NONE,
		  1,
		  G_TYPE_INT);
  g_signal_add_emission_hook (signals[__MODE_SIGNAL],
			      0,
			      signal_emission_hook_cb_mode,
                              (gpointer) "mode",
			      NULL);

  /* GObject signals definitions for D-Bus methods: */
  /**
   * EGdbusCal::handle-get-uri:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getUri</literal> D-Bus method on @object. Use e_gdbus_cal_complete_get_uri() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_URI_METHOD] =
    g_signal_new ("handle-get-uri",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_get_uri),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusCal::handle-get-cache-dir:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getCacheDir</literal> D-Bus method on @object. Use e_gdbus_cal_complete_get_cache_dir() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_CACHE_DIR_METHOD] =
    g_signal_new ("handle-get-cache-dir",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_get_cache_dir),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusCal::handle-open:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @only_if_exists: Parameter.
   * @username: Parameter.
   * @password: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>open</literal> D-Bus method on @object. Use e_gdbus_cal_complete_open() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__OPEN_METHOD] =
    g_signal_new ("handle-open",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_open),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_BOOLEAN_STRING_STRING,
		  G_TYPE_BOOLEAN,
		  4,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_BOOLEAN,
		  G_TYPE_STRING,
		  G_TYPE_STRING);
  /**
   * EGdbusCal::handle-refresh:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>refresh</literal> D-Bus method on @object. Use e_gdbus_cal_complete_refresh() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__REFRESH_METHOD] =
    g_signal_new ("handle-refresh",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_refresh),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusCal::handle-close:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>close</literal> D-Bus method on @object. Use e_gdbus_cal_complete_close() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__CLOSE_METHOD] =
    g_signal_new ("handle-close",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_close),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusCal::handle-remove:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>remove</literal> D-Bus method on @object. Use e_gdbus_cal_complete_remove() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__REMOVE_METHOD] =
    g_signal_new ("handle-remove",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_remove),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusCal::handle-is-read-only:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>isReadOnly</literal> D-Bus method on @object. Use e_gdbus_cal_complete_is_read_only() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__IS_READ_ONLY_METHOD] =
    g_signal_new ("handle-is-read-only",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_is_read_only),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusCal::handle-get-cal-address:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getCalAddress</literal> D-Bus method on @object. Use e_gdbus_cal_complete_get_cal_address() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_CAL_ADDRESS_METHOD] =
    g_signal_new ("handle-get-cal-address",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_get_cal_address),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusCal::handle-get-alarm-email-address:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getAlarmEmailAddress</literal> D-Bus method on @object. Use e_gdbus_cal_complete_get_alarm_email_address() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_ALARM_EMAIL_ADDRESS_METHOD] =
    g_signal_new ("handle-get-alarm-email-address",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_get_alarm_email_address),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusCal::handle-get-ldap-attribute:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getLdapAttribute</literal> D-Bus method on @object. Use e_gdbus_cal_complete_get_ldap_attribute() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_LDAP_ATTRIBUTE_METHOD] =
    g_signal_new ("handle-get-ldap-attribute",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_get_ldap_attribute),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusCal::handle-get-scheduling-information:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getSchedulingInformation</literal> D-Bus method on @object. Use e_gdbus_cal_complete_get_scheduling_information() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_SCHEDULING_INFORMATION_METHOD] =
    g_signal_new ("handle-get-scheduling-information",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_get_scheduling_information),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusCal::handle-set-mode:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @mode: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>setMode</literal> D-Bus method on @object. Use e_gdbus_cal_complete_set_mode() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__SET_MODE_METHOD] =
    g_signal_new ("handle-set-mode",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_set_mode),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_UINT,
		  G_TYPE_BOOLEAN,
		  2,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_UINT);
  /**
   * EGdbusCal::handle-get-default-object:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getDefaultObject</literal> D-Bus method on @object. Use e_gdbus_cal_complete_get_default_object() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_DEFAULT_OBJECT_METHOD] =
    g_signal_new ("handle-get-default-object",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_get_default_object),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusCal::handle-get-object:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @uid: Parameter.
   * @rid: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getObject</literal> D-Bus method on @object. Use e_gdbus_cal_complete_get_object() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_OBJECT_METHOD] =
    g_signal_new ("handle-get-object",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_get_object),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING_STRING,
		  G_TYPE_BOOLEAN,
		  3,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING,
		  G_TYPE_STRING);
  /**
   * EGdbusCal::handle-get-object-list:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @sexp: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getObjectList</literal> D-Bus method on @object. Use e_gdbus_cal_complete_get_object_list() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_OBJECT_LIST_METHOD] =
    g_signal_new ("handle-get-object-list",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_get_object_list),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING,
		  G_TYPE_BOOLEAN,
		  2,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING);
  /**
   * EGdbusCal::handle-get-changes:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @change_id: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getChanges</literal> D-Bus method on @object. Use e_gdbus_cal_complete_get_changes() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_CHANGES_METHOD] =
    g_signal_new ("handle-get-changes",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_get_changes),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING,
		  G_TYPE_BOOLEAN,
		  2,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING);
  /**
   * EGdbusCal::handle-get-free-busy:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @user_list: Parameter.
   * @start: Parameter.
   * @end: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getFreeBusy</literal> D-Bus method on @object. Use e_gdbus_cal_complete_get_free_busy() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_FREE_BUSY_METHOD] =
    g_signal_new ("handle-get-free-busy",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_get_free_busy),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_BOXED_UINT_UINT,
		  G_TYPE_BOOLEAN,
		  4,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRV,
		  G_TYPE_UINT,
		  G_TYPE_UINT);
  /**
   * EGdbusCal::handle-discard-alarm:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @uid: Parameter.
   * @auid: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>discardAlarm</literal> D-Bus method on @object. Use e_gdbus_cal_complete_discard_alarm() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__DISCARD_ALARM_METHOD] =
    g_signal_new ("handle-discard-alarm",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_discard_alarm),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING_STRING,
		  G_TYPE_BOOLEAN,
		  3,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING,
		  G_TYPE_STRING);
  /**
   * EGdbusCal::handle-create-object:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @calobj: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>createObject</literal> D-Bus method on @object. Use e_gdbus_cal_complete_create_object() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__CREATE_OBJECT_METHOD] =
    g_signal_new ("handle-create-object",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_create_object),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING,
		  G_TYPE_BOOLEAN,
		  2,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING);
  /**
   * EGdbusCal::handle-modify-object:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @calobj: Parameter.
   * @mod: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>modifyObject</literal> D-Bus method on @object. Use e_gdbus_cal_complete_modify_object() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__MODIFY_OBJECT_METHOD] =
    g_signal_new ("handle-modify-object",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_modify_object),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING_UINT,
		  G_TYPE_BOOLEAN,
		  3,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING,
		  G_TYPE_UINT);
  /**
   * EGdbusCal::handle-remove-object:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @uid: Parameter.
   * @rid: Parameter.
   * @mod: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>removeObject</literal> D-Bus method on @object. Use e_gdbus_cal_complete_remove_object() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__REMOVE_OBJECT_METHOD] =
    g_signal_new ("handle-remove-object",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_remove_object),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING_STRING_UINT,
		  G_TYPE_BOOLEAN,
		  4,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING,
		  G_TYPE_STRING,
		  G_TYPE_UINT);
  /**
   * EGdbusCal::handle-receive-objects:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @calobj: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>receiveObjects</literal> D-Bus method on @object. Use e_gdbus_cal_complete_receive_objects() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__RECEIVE_OBJECTS_METHOD] =
    g_signal_new ("handle-receive-objects",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_receive_objects),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING,
		  G_TYPE_BOOLEAN,
		  2,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING);
  /**
   * EGdbusCal::handle-send-objects:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @calobj: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>sendObjects</literal> D-Bus method on @object. Use e_gdbus_cal_complete_send_objects() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__SEND_OBJECTS_METHOD] =
    g_signal_new ("handle-send-objects",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_send_objects),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING,
		  G_TYPE_BOOLEAN,
		  2,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING);
  /**
   * EGdbusCal::handle-get-attachment-list:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @uid: Parameter.
   * @rid: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getAttachmentList</literal> D-Bus method on @object. Use e_gdbus_cal_complete_get_attachment_list() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_ATTACHMENT_LIST_METHOD] =
    g_signal_new ("handle-get-attachment-list",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_get_attachment_list),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING_STRING,
		  G_TYPE_BOOLEAN,
		  3,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING,
		  G_TYPE_STRING);
  /**
   * EGdbusCal::handle-get-query:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @sexp: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getQuery</literal> D-Bus method on @object. Use e_gdbus_cal_complete_get_query() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_QUERY_METHOD] =
    g_signal_new ("handle-get-query",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_get_query),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING,
		  G_TYPE_BOOLEAN,
		  2,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING);
  /**
   * EGdbusCal::handle-get-timezone:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @tzid: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getTimezone</literal> D-Bus method on @object. Use e_gdbus_cal_complete_get_timezone() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_TIMEZONE_METHOD] =
    g_signal_new ("handle-get-timezone",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_get_timezone),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING,
		  G_TYPE_BOOLEAN,
		  2,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING);
  /**
   * EGdbusCal::handle-add-timezone:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @tz: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>addTimezone</literal> D-Bus method on @object. Use e_gdbus_cal_complete_add_timezone() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__ADD_TIMEZONE_METHOD] =
    g_signal_new ("handle-add-timezone",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_add_timezone),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING,
		  G_TYPE_BOOLEAN,
		  2,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING);
  /**
   * EGdbusCal::handle-set-default-timezone:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @tz: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>setDefaultTimezone</literal> D-Bus method on @object. Use e_gdbus_cal_complete_set_default_timezone() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_cal_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__SET_DEFAULT_TIMEZONE_METHOD] =
    g_signal_new ("handle-set-default-timezone",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusCalIface, handle_set_default_timezone),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING,
		  G_TYPE_BOOLEAN,
		  2,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING);

  /* GObject property definitions for D-Bus properties: */
}

/* C Bindings for properties */

/**
 * e_gdbus_cal_call_get_uri:
 * @proxy: A #EGdbusCal.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.getUri</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_get_uri_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_get_uri_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_get_uri (
        EGdbusCal *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getUri",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_get_uri_finish:
 * @proxy: A #EGdbusCal.
 * @out_str_uri_copy: Return location for out parameter or %NULL. Free with g_free().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_get_uri().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.getUri</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_uri_finish (
        EGdbusCal *proxy,
        gchar **out_str_uri_copy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_str_uri_copy);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_uri_sync:
 * @proxy: A #EGdbusCal.
 * @out_str_uri_copy: Return location for out parameter or %NULL. Free with g_free().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.getUri</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_get_uri() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_uri_sync (
        EGdbusCal *proxy,
        gchar **out_str_uri_copy,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getUri",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_str_uri_copy);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_cache_dir:
 * @proxy: A #EGdbusCal.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.getCacheDir</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_get_cache_dir_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_get_cache_dir_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_get_cache_dir (
        EGdbusCal *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getCacheDir",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_get_cache_dir_finish:
 * @proxy: A #EGdbusCal.
 * @out_dirname: Return location for out parameter or %NULL. Free with g_free().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_get_cache_dir().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.getCacheDir</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_cache_dir_finish (
        EGdbusCal *proxy,
        gchar **out_dirname,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_dirname);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_cache_dir_sync:
 * @proxy: A #EGdbusCal.
 * @out_dirname: Return location for out parameter or %NULL. Free with g_free().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.getCacheDir</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_get_cache_dir() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_cache_dir_sync (
        EGdbusCal *proxy,
        gchar **out_dirname,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getCacheDir",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_dirname);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_open:
 * @proxy: A #EGdbusCal.
 * @in_only_if_exists: Method parameter.
 * @in_username: Method parameter.
 * @in_password: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.open</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_open_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_open_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_open (
        EGdbusCal *proxy,
        gboolean in_only_if_exists,
        const gchar *in_username,
        const gchar *in_password,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(bss)",
			   in_only_if_exists,
			   in_username,
			   in_password);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "open",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_open_finish:
 * @proxy: A #EGdbusCal.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_open().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.open</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_open_finish (
        EGdbusCal *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_open_sync:
 * @proxy: A #EGdbusCal.
 * @in_only_if_exists: Method parameter.
 * @in_username: Method parameter.
 * @in_password: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.open</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_open() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_open_sync (
        EGdbusCal *proxy,
        gboolean in_only_if_exists,
        const gchar *in_username,
        const gchar *in_password,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(bss)",
			   in_only_if_exists,
			   in_username,
			   in_password);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "open",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_refresh:
 * @proxy: A #EGdbusCal.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.refresh</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_refresh_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_refresh_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_refresh (
        EGdbusCal *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "refresh",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_refresh_finish:
 * @proxy: A #EGdbusCal.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_refresh().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.refresh</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_refresh_finish (
        EGdbusCal *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_refresh_sync:
 * @proxy: A #EGdbusCal.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.refresh</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_refresh() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_refresh_sync (
        EGdbusCal *proxy,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "refresh",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_close:
 * @proxy: A #EGdbusCal.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.close</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_close_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_close_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_close (
        EGdbusCal *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "close",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_close_finish:
 * @proxy: A #EGdbusCal.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_close().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.close</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_close_finish (
        EGdbusCal *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_close_sync:
 * @proxy: A #EGdbusCal.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.close</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_close() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_close_sync (
        EGdbusCal *proxy,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "close",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_remove:
 * @proxy: A #EGdbusCal.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.remove</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_remove_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_remove_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_remove (
        EGdbusCal *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "remove",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_remove_finish:
 * @proxy: A #EGdbusCal.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_remove().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.remove</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_remove_finish (
        EGdbusCal *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_remove_sync:
 * @proxy: A #EGdbusCal.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.remove</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_remove() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_remove_sync (
        EGdbusCal *proxy,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "remove",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_is_read_only:
 * @proxy: A #EGdbusCal.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.isReadOnly</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_is_read_only_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_is_read_only_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_is_read_only (
        EGdbusCal *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "isReadOnly",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_is_read_only_finish:
 * @proxy: A #EGdbusCal.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_is_read_only().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.isReadOnly</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_is_read_only_finish (
        EGdbusCal *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_is_read_only_sync:
 * @proxy: A #EGdbusCal.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.isReadOnly</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_is_read_only() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_is_read_only_sync (
        EGdbusCal *proxy,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "isReadOnly",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_cal_address:
 * @proxy: A #EGdbusCal.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.getCalAddress</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_get_cal_address_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_get_cal_address_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_get_cal_address (
        EGdbusCal *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getCalAddress",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_get_cal_address_finish:
 * @proxy: A #EGdbusCal.
 * @out_address: Return location for out parameter or %NULL. Free with g_free().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_get_cal_address().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.getCalAddress</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_cal_address_finish (
        EGdbusCal *proxy,
        gchar **out_address,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_address);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_cal_address_sync:
 * @proxy: A #EGdbusCal.
 * @out_address: Return location for out parameter or %NULL. Free with g_free().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.getCalAddress</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_get_cal_address() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_cal_address_sync (
        EGdbusCal *proxy,
        gchar **out_address,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getCalAddress",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_address);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_alarm_email_address:
 * @proxy: A #EGdbusCal.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.getAlarmEmailAddress</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_get_alarm_email_address_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_get_alarm_email_address_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_get_alarm_email_address (
        EGdbusCal *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getAlarmEmailAddress",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_get_alarm_email_address_finish:
 * @proxy: A #EGdbusCal.
 * @out_address: Return location for out parameter or %NULL. Free with g_free().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_get_alarm_email_address().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.getAlarmEmailAddress</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_alarm_email_address_finish (
        EGdbusCal *proxy,
        gchar **out_address,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_address);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_alarm_email_address_sync:
 * @proxy: A #EGdbusCal.
 * @out_address: Return location for out parameter or %NULL. Free with g_free().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.getAlarmEmailAddress</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_get_alarm_email_address() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_alarm_email_address_sync (
        EGdbusCal *proxy,
        gchar **out_address,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getAlarmEmailAddress",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_address);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_ldap_attribute:
 * @proxy: A #EGdbusCal.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.getLdapAttribute</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_get_ldap_attribute_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_get_ldap_attribute_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_get_ldap_attribute (
        EGdbusCal *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getLdapAttribute",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_get_ldap_attribute_finish:
 * @proxy: A #EGdbusCal.
 * @out_address: Return location for out parameter or %NULL. Free with g_free().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_get_ldap_attribute().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.getLdapAttribute</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_ldap_attribute_finish (
        EGdbusCal *proxy,
        gchar **out_address,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_address);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_ldap_attribute_sync:
 * @proxy: A #EGdbusCal.
 * @out_address: Return location for out parameter or %NULL. Free with g_free().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.getLdapAttribute</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_get_ldap_attribute() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_ldap_attribute_sync (
        EGdbusCal *proxy,
        gchar **out_address,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getLdapAttribute",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_address);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_scheduling_information:
 * @proxy: A #EGdbusCal.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.getSchedulingInformation</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_get_scheduling_information_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_get_scheduling_information_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_get_scheduling_information (
        EGdbusCal *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getSchedulingInformation",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_get_scheduling_information_finish:
 * @proxy: A #EGdbusCal.
 * @out_capabilities: Return location for out parameter or %NULL. Free with g_free().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_get_scheduling_information().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.getSchedulingInformation</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_scheduling_information_finish (
        EGdbusCal *proxy,
        gchar **out_capabilities,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_capabilities);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_scheduling_information_sync:
 * @proxy: A #EGdbusCal.
 * @out_capabilities: Return location for out parameter or %NULL. Free with g_free().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.getSchedulingInformation</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_get_scheduling_information() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_scheduling_information_sync (
        EGdbusCal *proxy,
        gchar **out_capabilities,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getSchedulingInformation",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_capabilities);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_set_mode:
 * @proxy: A #EGdbusCal.
 * @in_mode: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.setMode</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_set_mode_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_set_mode_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_set_mode (
        EGdbusCal *proxy,
        guint in_mode,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(u)",
			   in_mode);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "setMode",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_set_mode_finish:
 * @proxy: A #EGdbusCal.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_set_mode().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.setMode</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_set_mode_finish (
        EGdbusCal *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_set_mode_sync:
 * @proxy: A #EGdbusCal.
 * @in_mode: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.setMode</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_set_mode() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_set_mode_sync (
        EGdbusCal *proxy,
        guint in_mode,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(u)",
			   in_mode);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "setMode",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_default_object:
 * @proxy: A #EGdbusCal.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.getDefaultObject</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_get_default_object_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_get_default_object_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_get_default_object (
        EGdbusCal *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getDefaultObject",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_get_default_object_finish:
 * @proxy: A #EGdbusCal.
 * @out_object: Return location for out parameter or %NULL. Free with g_free().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_get_default_object().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.getDefaultObject</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_default_object_finish (
        EGdbusCal *proxy,
        gchar **out_object,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_object);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_default_object_sync:
 * @proxy: A #EGdbusCal.
 * @out_object: Return location for out parameter or %NULL. Free with g_free().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.getDefaultObject</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_get_default_object() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_default_object_sync (
        EGdbusCal *proxy,
        gchar **out_object,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getDefaultObject",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_object);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_object:
 * @proxy: A #EGdbusCal.
 * @in_uid: Method parameter.
 * @in_rid: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.getObject</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_get_object_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_get_object_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_get_object (
        EGdbusCal *proxy,
        const gchar *in_uid,
        const gchar *in_rid,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(ss)",
			   in_uid,
			   in_rid);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getObject",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_get_object_finish:
 * @proxy: A #EGdbusCal.
 * @out_object: Return location for out parameter or %NULL. Free with g_free().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_get_object().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.getObject</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_object_finish (
        EGdbusCal *proxy,
        gchar **out_object,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_object);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_object_sync:
 * @proxy: A #EGdbusCal.
 * @in_uid: Method parameter.
 * @in_rid: Method parameter.
 * @out_object: Return location for out parameter or %NULL. Free with g_free().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.getObject</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_get_object() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_object_sync (
        EGdbusCal *proxy,
        const gchar *in_uid,
        const gchar *in_rid,
        gchar **out_object,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(ss)",
			   in_uid,
			   in_rid);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getObject",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_object);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_object_list:
 * @proxy: A #EGdbusCal.
 * @in_sexp: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.getObjectList</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_get_object_list_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_get_object_list_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_get_object_list (
        EGdbusCal *proxy,
        const gchar *in_sexp,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   in_sexp);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getObjectList",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_get_object_list_finish:
 * @proxy: A #EGdbusCal.
 * @out_objects: Return location for out parameter or %NULL. Free with g_strfreev().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_get_object_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.getObjectList</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_object_list_finish (
        EGdbusCal *proxy,
        gchar ***out_objects,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^as)",
		   out_objects);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_object_list_sync:
 * @proxy: A #EGdbusCal.
 * @in_sexp: Method parameter.
 * @out_objects: Return location for out parameter or %NULL. Free with g_strfreev().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.getObjectList</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_get_object_list() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_object_list_sync (
        EGdbusCal *proxy,
        const gchar *in_sexp,
        gchar ***out_objects,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(s)",
			   in_sexp);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getObjectList",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^as)",
		   out_objects);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_changes:
 * @proxy: A #EGdbusCal.
 * @in_change_id: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.getChanges</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_get_changes_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_get_changes_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_get_changes (
        EGdbusCal *proxy,
        const gchar *in_change_id,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   in_change_id);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getChanges",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_get_changes_finish:
 * @proxy: A #EGdbusCal.
 * @out_additions: Return location for out parameter or %NULL. Free with g_strfreev().
 * @out_modifications: Return location for out parameter or %NULL. Free with g_strfreev().
 * @out_removals: Return location for out parameter or %NULL. Free with g_strfreev().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_get_changes().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.getChanges</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_changes_finish (
        EGdbusCal *proxy,
        gchar ***out_additions,
        gchar ***out_modifications,
        gchar ***out_removals,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^as^as^as)",
		   out_additions,
		   out_modifications,
		   out_removals);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_changes_sync:
 * @proxy: A #EGdbusCal.
 * @in_change_id: Method parameter.
 * @out_additions: Return location for out parameter or %NULL. Free with g_strfreev().
 * @out_modifications: Return location for out parameter or %NULL. Free with g_strfreev().
 * @out_removals: Return location for out parameter or %NULL. Free with g_strfreev().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.getChanges</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_get_changes() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_changes_sync (
        EGdbusCal *proxy,
        const gchar *in_change_id,
        gchar ***out_additions,
        gchar ***out_modifications,
        gchar ***out_removals,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(s)",
			   in_change_id);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getChanges",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^as^as^as)",
		   out_additions,
		   out_modifications,
		   out_removals);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_free_busy:
 * @proxy: A #EGdbusCal.
 * @in_user_list: Method parameter.
 * @in_start: Method parameter.
 * @in_end: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.getFreeBusy</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_get_free_busy_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_get_free_busy_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_get_free_busy (
        EGdbusCal *proxy,
        const gchar * const *in_user_list,
        guint in_start,
        guint in_end,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(^asuu)",
			   in_user_list,
			   in_start,
			   in_end);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getFreeBusy",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_get_free_busy_finish:
 * @proxy: A #EGdbusCal.
 * @out_freebusy: Return location for out parameter or %NULL. Free with g_strfreev().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_get_free_busy().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.getFreeBusy</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_free_busy_finish (
        EGdbusCal *proxy,
        gchar ***out_freebusy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^as)",
		   out_freebusy);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_free_busy_sync:
 * @proxy: A #EGdbusCal.
 * @in_user_list: Method parameter.
 * @in_start: Method parameter.
 * @in_end: Method parameter.
 * @out_freebusy: Return location for out parameter or %NULL. Free with g_strfreev().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.getFreeBusy</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_get_free_busy() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_free_busy_sync (
        EGdbusCal *proxy,
        const gchar * const *in_user_list,
        guint in_start,
        guint in_end,
        gchar ***out_freebusy,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(^asuu)",
			   in_user_list,
			   in_start,
			   in_end);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getFreeBusy",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^as)",
		   out_freebusy);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_discard_alarm:
 * @proxy: A #EGdbusCal.
 * @in_uid: Method parameter.
 * @in_auid: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.discardAlarm</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_discard_alarm_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_discard_alarm_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_discard_alarm (
        EGdbusCal *proxy,
        const gchar *in_uid,
        const gchar *in_auid,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(ss)",
			   in_uid,
			   in_auid);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "discardAlarm",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_discard_alarm_finish:
 * @proxy: A #EGdbusCal.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_discard_alarm().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.discardAlarm</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_discard_alarm_finish (
        EGdbusCal *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_discard_alarm_sync:
 * @proxy: A #EGdbusCal.
 * @in_uid: Method parameter.
 * @in_auid: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.discardAlarm</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_discard_alarm() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_discard_alarm_sync (
        EGdbusCal *proxy,
        const gchar *in_uid,
        const gchar *in_auid,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(ss)",
			   in_uid,
			   in_auid);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "discardAlarm",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_create_object:
 * @proxy: A #EGdbusCal.
 * @in_calobj: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.createObject</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_create_object_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_create_object_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_create_object (
        EGdbusCal *proxy,
        const gchar *in_calobj,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   in_calobj);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "createObject",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_create_object_finish:
 * @proxy: A #EGdbusCal.
 * @out_uid: Return location for out parameter or %NULL. Free with g_free().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_create_object().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.createObject</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_create_object_finish (
        EGdbusCal *proxy,
        gchar **out_uid,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_uid);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_create_object_sync:
 * @proxy: A #EGdbusCal.
 * @in_calobj: Method parameter.
 * @out_uid: Return location for out parameter or %NULL. Free with g_free().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.createObject</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_create_object() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_create_object_sync (
        EGdbusCal *proxy,
        const gchar *in_calobj,
        gchar **out_uid,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(s)",
			   in_calobj);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "createObject",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_uid);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_modify_object:
 * @proxy: A #EGdbusCal.
 * @in_calobj: Method parameter.
 * @in_mod: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.modifyObject</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_modify_object_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_modify_object_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_modify_object (
        EGdbusCal *proxy,
        const gchar *in_calobj,
        guint in_mod,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(su)",
			   in_calobj,
			   in_mod);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "modifyObject",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_modify_object_finish:
 * @proxy: A #EGdbusCal.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_modify_object().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.modifyObject</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_modify_object_finish (
        EGdbusCal *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_modify_object_sync:
 * @proxy: A #EGdbusCal.
 * @in_calobj: Method parameter.
 * @in_mod: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.modifyObject</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_modify_object() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_modify_object_sync (
        EGdbusCal *proxy,
        const gchar *in_calobj,
        guint in_mod,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(su)",
			   in_calobj,
			   in_mod);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "modifyObject",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_remove_object:
 * @proxy: A #EGdbusCal.
 * @in_uid: Method parameter.
 * @in_rid: Method parameter.
 * @in_mod: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.removeObject</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_remove_object_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_remove_object_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_remove_object (
        EGdbusCal *proxy,
        const gchar *in_uid,
        const gchar *in_rid,
        guint in_mod,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(ssu)",
			   in_uid,
			   in_rid,
			   in_mod);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "removeObject",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_remove_object_finish:
 * @proxy: A #EGdbusCal.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_remove_object().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.removeObject</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_remove_object_finish (
        EGdbusCal *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_remove_object_sync:
 * @proxy: A #EGdbusCal.
 * @in_uid: Method parameter.
 * @in_rid: Method parameter.
 * @in_mod: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.removeObject</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_remove_object() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_remove_object_sync (
        EGdbusCal *proxy,
        const gchar *in_uid,
        const gchar *in_rid,
        guint in_mod,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(ssu)",
			   in_uid,
			   in_rid,
			   in_mod);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "removeObject",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_receive_objects:
 * @proxy: A #EGdbusCal.
 * @in_calobj: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.receiveObjects</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_receive_objects_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_receive_objects_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_receive_objects (
        EGdbusCal *proxy,
        const gchar *in_calobj,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   in_calobj);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "receiveObjects",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_receive_objects_finish:
 * @proxy: A #EGdbusCal.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_receive_objects().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.receiveObjects</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_receive_objects_finish (
        EGdbusCal *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_receive_objects_sync:
 * @proxy: A #EGdbusCal.
 * @in_calobj: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.receiveObjects</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_receive_objects() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_receive_objects_sync (
        EGdbusCal *proxy,
        const gchar *in_calobj,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(s)",
			   in_calobj);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "receiveObjects",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_send_objects:
 * @proxy: A #EGdbusCal.
 * @in_calobj: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.sendObjects</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_send_objects_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_send_objects_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_send_objects (
        EGdbusCal *proxy,
        const gchar *in_calobj,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   in_calobj);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "sendObjects",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_send_objects_finish:
 * @proxy: A #EGdbusCal.
 * @out_users: Return location for out parameter or %NULL. Free with g_strfreev().
 * @out_calobj: Return location for out parameter or %NULL. Free with g_free().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_send_objects().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.sendObjects</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_send_objects_finish (
        EGdbusCal *proxy,
        gchar ***out_users,
        gchar **out_calobj,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^ass)",
		   out_users,
		   out_calobj);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_send_objects_sync:
 * @proxy: A #EGdbusCal.
 * @in_calobj: Method parameter.
 * @out_users: Return location for out parameter or %NULL. Free with g_strfreev().
 * @out_calobj: Return location for out parameter or %NULL. Free with g_free().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.sendObjects</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_send_objects() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_send_objects_sync (
        EGdbusCal *proxy,
        const gchar *in_calobj,
        gchar ***out_users,
        gchar **out_calobj,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(s)",
			   in_calobj);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "sendObjects",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^ass)",
		   out_users,
		   out_calobj);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_attachment_list:
 * @proxy: A #EGdbusCal.
 * @in_uid: Method parameter.
 * @in_rid: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.getAttachmentList</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_get_attachment_list_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_get_attachment_list_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_get_attachment_list (
        EGdbusCal *proxy,
        const gchar *in_uid,
        const gchar *in_rid,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(ss)",
			   in_uid,
			   in_rid);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getAttachmentList",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_get_attachment_list_finish:
 * @proxy: A #EGdbusCal.
 * @out_attachments: Return location for out parameter or %NULL. Free with g_strfreev().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_get_attachment_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.getAttachmentList</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_attachment_list_finish (
        EGdbusCal *proxy,
        gchar ***out_attachments,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^as)",
		   out_attachments);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_attachment_list_sync:
 * @proxy: A #EGdbusCal.
 * @in_uid: Method parameter.
 * @in_rid: Method parameter.
 * @out_attachments: Return location for out parameter or %NULL. Free with g_strfreev().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.getAttachmentList</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_get_attachment_list() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_attachment_list_sync (
        EGdbusCal *proxy,
        const gchar *in_uid,
        const gchar *in_rid,
        gchar ***out_attachments,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(ss)",
			   in_uid,
			   in_rid);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getAttachmentList",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^as)",
		   out_attachments);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_query:
 * @proxy: A #EGdbusCal.
 * @in_sexp: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.getQuery</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_get_query_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_get_query_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_get_query (
        EGdbusCal *proxy,
        const gchar *in_sexp,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   in_sexp);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getQuery",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_get_query_finish:
 * @proxy: A #EGdbusCal.
 * @out_query: Return location for out parameter or %NULL. Free with g_free().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_get_query().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.getQuery</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_query_finish (
        EGdbusCal *proxy,
        gchar **out_query,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(o)",
		   out_query);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_query_sync:
 * @proxy: A #EGdbusCal.
 * @in_sexp: Method parameter.
 * @out_query: Return location for out parameter or %NULL. Free with g_free().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.getQuery</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_get_query() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_query_sync (
        EGdbusCal *proxy,
        const gchar *in_sexp,
        gchar **out_query,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(s)",
			   in_sexp);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getQuery",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(o)",
		   out_query);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_timezone:
 * @proxy: A #EGdbusCal.
 * @in_tzid: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.getTimezone</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_get_timezone_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_get_timezone_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_get_timezone (
        EGdbusCal *proxy,
        const gchar *in_tzid,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   in_tzid);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getTimezone",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_get_timezone_finish:
 * @proxy: A #EGdbusCal.
 * @out_object: Return location for out parameter or %NULL. Free with g_free().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_get_timezone().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.getTimezone</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_timezone_finish (
        EGdbusCal *proxy,
        gchar **out_object,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_object);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_get_timezone_sync:
 * @proxy: A #EGdbusCal.
 * @in_tzid: Method parameter.
 * @out_object: Return location for out parameter or %NULL. Free with g_free().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.getTimezone</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_get_timezone() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_get_timezone_sync (
        EGdbusCal *proxy,
        const gchar *in_tzid,
        gchar **out_object,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(s)",
			   in_tzid);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getTimezone",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_object);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_add_timezone:
 * @proxy: A #EGdbusCal.
 * @in_tz: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.addTimezone</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_add_timezone_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_add_timezone_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_add_timezone (
        EGdbusCal *proxy,
        const gchar *in_tz,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   in_tz);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "addTimezone",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_add_timezone_finish:
 * @proxy: A #EGdbusCal.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_add_timezone().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.addTimezone</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_add_timezone_finish (
        EGdbusCal *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_add_timezone_sync:
 * @proxy: A #EGdbusCal.
 * @in_tz: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.addTimezone</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_add_timezone() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_add_timezone_sync (
        EGdbusCal *proxy,
        const gchar *in_tz,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(s)",
			   in_tz);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "addTimezone",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_set_default_timezone:
 * @proxy: A #EGdbusCal.
 * @in_tz: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.Calendar.setDefaultTimezone</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_cal_call_set_default_timezone_finish() to get the result of the operation.
 *
 * See e_gdbus_cal_call_set_default_timezone_sync() for the synchronous version of this method.
 */
void e_gdbus_cal_call_set_default_timezone (
        EGdbusCal *proxy,
        const gchar *in_tz,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   in_tz);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "setDefaultTimezone",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     e_data_server_util_get_dbus_call_timeout (),
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_cal_call_set_default_timezone_finish:
 * @proxy: A #EGdbusCal.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_cal_call_set_default_timezone().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.Calendar.setDefaultTimezone</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_set_default_timezone_finish (
        EGdbusCal *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_call_set_default_timezone_sync:
 * @proxy: A #EGdbusCal.
 * @in_tz: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.Calendar.setDefaultTimezone</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_cal_call_set_default_timezone() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_cal_call_set_default_timezone_sync (
        EGdbusCal *proxy,
        const gchar *in_tz,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(s)",
			   in_tz);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "setDefaultTimezone",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   e_data_server_util_get_dbus_call_timeout (),
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_cal_complete_get_uri:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 * @out_str_uri_copy: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.getUri</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_get_uri (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation,
        const gchar *out_str_uri_copy)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   out_str_uri_copy);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_cal_complete_get_cache_dir:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 * @out_dirname: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.getCacheDir</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_get_cache_dir (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation,
        const gchar *out_dirname)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   out_dirname);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_cal_complete_open:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.open</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_open (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_cal_complete_refresh:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.refresh</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_refresh (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_cal_complete_close:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.close</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_close (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_cal_complete_remove:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.remove</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_remove (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_cal_complete_is_read_only:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.isReadOnly</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_is_read_only (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_cal_complete_get_cal_address:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 * @out_address: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.getCalAddress</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_get_cal_address (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation,
        const gchar *out_address)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   out_address);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_cal_complete_get_alarm_email_address:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 * @out_address: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.getAlarmEmailAddress</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_get_alarm_email_address (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation,
        const gchar *out_address)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   out_address);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_cal_complete_get_ldap_attribute:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 * @out_address: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.getLdapAttribute</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_get_ldap_attribute (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation,
        const gchar *out_address)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   out_address);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_cal_complete_get_scheduling_information:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 * @out_capabilities: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.getSchedulingInformation</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_get_scheduling_information (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation,
        const gchar *out_capabilities)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   out_capabilities);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_cal_complete_set_mode:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.setMode</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_set_mode (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_cal_complete_get_default_object:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 * @out_object: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.getDefaultObject</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_get_default_object (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation,
        const gchar *out_object)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   out_object);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_cal_complete_get_object:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 * @out_object: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.getObject</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_get_object (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation,
        const gchar *out_object)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   out_object);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_cal_complete_get_object_list:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 * @out_objects: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.getObjectList</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_get_object_list (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation,
        const gchar * const *out_objects)
{
  GVariant *_params;
  _params = g_variant_new ("(^as)",
			   out_objects);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_cal_complete_get_changes:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 * @out_additions: Value to return.
 * @out_modifications: Value to return.
 * @out_removals: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.getChanges</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_get_changes (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation,
        const gchar * const *out_additions,
        const gchar * const *out_modifications,
        const gchar * const *out_removals)
{
  GVariant *_params;
  _params = g_variant_new ("(^as^as^as)",
			   out_additions,
			   out_modifications,
			   out_removals);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_cal_complete_get_free_busy:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 * @out_freebusy: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.getFreeBusy</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_get_free_busy (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation,
        const gchar * const *out_freebusy)
{
  GVariant *_params;
  _params = g_variant_new ("(^as)",
			   out_freebusy);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_cal_complete_discard_alarm:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.discardAlarm</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_discard_alarm (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_cal_complete_create_object:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 * @out_uid: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.createObject</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_create_object (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation,
        const gchar *out_uid)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   out_uid);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_cal_complete_modify_object:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.modifyObject</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_modify_object (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_cal_complete_remove_object:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.removeObject</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_remove_object (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_cal_complete_receive_objects:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.receiveObjects</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_receive_objects (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_cal_complete_send_objects:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 * @out_users: Value to return.
 * @out_calobj: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.sendObjects</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_send_objects (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation,
        const gchar * const *out_users,
        const gchar *out_calobj)
{
  GVariant *_params;
  _params = g_variant_new ("(^ass)",
			   out_users,
			   out_calobj);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_cal_complete_get_attachment_list:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 * @out_attachments: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.getAttachmentList</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_get_attachment_list (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation,
        const gchar * const *out_attachments)
{
  GVariant *_params;
  _params = g_variant_new ("(^as)",
			   out_attachments);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_cal_complete_get_query:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 * @out_query: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.getQuery</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_get_query (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation,
        const gchar *out_query)
{
  GVariant *_params;
  _params = g_variant_new ("(o)",
			   out_query);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_cal_complete_get_timezone:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 * @out_object: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.getTimezone</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_get_timezone (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation,
        const gchar *out_object)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   out_object);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_cal_complete_add_timezone:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.addTimezone</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_add_timezone (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_cal_complete_set_default_timezone:
 * @object: A #EGdbusCal.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.Calendar.setDefaultTimezone</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_cal_complete_set_default_timezone (
        EGdbusCal *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_cal_emit_auth_required:
 * @object: A #EGdbusCal.
 *
 * Emits the <literal>org.gnome.evolution.dataserver.Calendar.auth_required</literal>
 * D-Bus signal.
 */
void e_gdbus_cal_emit_auth_required (
        EGdbusCal *object)
{
  g_signal_emit (object, signals[__AUTH_REQUIRED_SIGNAL], 0);
}

/**
 * e_gdbus_cal_emit_backend_error:
 * @object: A #EGdbusCal.
 * @arg_error: Signal parameter.
 *
 * Emits the <literal>org.gnome.evolution.dataserver.Calendar.backend_error</literal>
 * D-Bus signal.
 */
void e_gdbus_cal_emit_backend_error (
        EGdbusCal *object,
        const gchar *arg_error)
{
  g_signal_emit (object, signals[__BACKEND_ERROR_SIGNAL], 0, arg_error);
}

/**
 * e_gdbus_cal_emit_readonly:
 * @object: A #EGdbusCal.
 * @arg_is_readonly: Signal parameter.
 *
 * Emits the <literal>org.gnome.evolution.dataserver.Calendar.readonly</literal>
 * D-Bus signal.
 */
void e_gdbus_cal_emit_readonly (
        EGdbusCal *object,
        gboolean arg_is_readonly)
{
  g_signal_emit (object, signals[__READONLY_SIGNAL], 0, arg_is_readonly);
}

/**
 * e_gdbus_cal_emit_mode:
 * @object: A #EGdbusCal.
 * @arg_mode: Signal parameter.
 *
 * Emits the <literal>org.gnome.evolution.dataserver.Calendar.mode</literal>
 * D-Bus signal.
 */
void e_gdbus_cal_emit_mode (
        EGdbusCal *object,
        gint arg_mode)
{
  g_signal_emit (object, signals[__MODE_SIGNAL], 0, arg_mode);
}

static const GDBusSignalInfo e_gdbus_cal_signal_auth_required =
{
  -1,
  (gchar *) "auth_required",
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_signal_backend_error_error =
{
  -1,
  (gchar *) "error",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_signal_backend_error_arg_pointers[] =
{
  &e_gdbus_cal_signal_backend_error_error,
  NULL
};

static const GDBusSignalInfo e_gdbus_cal_signal_backend_error =
{
  -1,
  (gchar *) "backend_error",
  (GDBusArgInfo **) &e_gdbus_cal_signal_backend_error_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_signal_readonly_is_readonly =
{
  -1,
  (gchar *) "is_readonly",
  (gchar *) "b",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_signal_readonly_arg_pointers[] =
{
  &e_gdbus_cal_signal_readonly_is_readonly,
  NULL
};

static const GDBusSignalInfo e_gdbus_cal_signal_readonly =
{
  -1,
  (gchar *) "readonly",
  (GDBusArgInfo **) &e_gdbus_cal_signal_readonly_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_signal_mode_mode =
{
  -1,
  (gchar *) "mode",
  (gchar *) "i",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_signal_mode_arg_pointers[] =
{
  &e_gdbus_cal_signal_mode_mode,
  NULL
};

static const GDBusSignalInfo e_gdbus_cal_signal_mode =
{
  -1,
  (gchar *) "mode",
  (GDBusArgInfo **) &e_gdbus_cal_signal_mode_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusSignalInfo * const e_gdbus_cal_signal_info_pointers[] =
{
  &e_gdbus_cal_signal_auth_required,
  &e_gdbus_cal_signal_backend_error,
  &e_gdbus_cal_signal_readonly,
  &e_gdbus_cal_signal_mode,
  NULL
};

static const GDBusArgInfo e_gdbus_cal_method_out_getUri_str_uri_copy =
{
  -1,
  (gchar *) "str_uri_copy",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_out_getUri_arg_pointers[] =
{
  &e_gdbus_cal_method_out_getUri_str_uri_copy,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_getUri =
{
  -1,
  (gchar *) "getUri",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) &e_gdbus_cal_method_out_getUri_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_out_getCacheDir_dirname =
{
  -1,
  (gchar *) "dirname",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_out_getCacheDir_arg_pointers[] =
{
  &e_gdbus_cal_method_out_getCacheDir_dirname,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_getCacheDir =
{
  -1,
  (gchar *) "getCacheDir",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) &e_gdbus_cal_method_out_getCacheDir_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_in_open_only_if_exists =
{
  -1,
  (gchar *) "only_if_exists",
  (gchar *) "b",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo e_gdbus_cal_method_in_open_username =
{
  -1,
  (gchar *) "username",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo e_gdbus_cal_method_in_open_password =
{
  -1,
  (gchar *) "password",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_in_open_arg_pointers[] =
{
  &e_gdbus_cal_method_in_open_only_if_exists,
  &e_gdbus_cal_method_in_open_username,
  &e_gdbus_cal_method_in_open_password,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_open =
{
  -1,
  (gchar *) "open",
  (GDBusArgInfo **) &e_gdbus_cal_method_in_open_arg_pointers,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusMethodInfo e_gdbus_cal_method_refresh =
{
  -1,
  (gchar *) "refresh",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusMethodInfo e_gdbus_cal_method_close =
{
  -1,
  (gchar *) "close",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusMethodInfo e_gdbus_cal_method_remove =
{
  -1,
  (gchar *) "remove",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusMethodInfo e_gdbus_cal_method_isReadOnly =
{
  -1,
  (gchar *) "isReadOnly",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_out_getCalAddress_address =
{
  -1,
  (gchar *) "address",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_out_getCalAddress_arg_pointers[] =
{
  &e_gdbus_cal_method_out_getCalAddress_address,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_getCalAddress =
{
  -1,
  (gchar *) "getCalAddress",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) &e_gdbus_cal_method_out_getCalAddress_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_out_getAlarmEmailAddress_address =
{
  -1,
  (gchar *) "address",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_out_getAlarmEmailAddress_arg_pointers[] =
{
  &e_gdbus_cal_method_out_getAlarmEmailAddress_address,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_getAlarmEmailAddress =
{
  -1,
  (gchar *) "getAlarmEmailAddress",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) &e_gdbus_cal_method_out_getAlarmEmailAddress_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_out_getLdapAttribute_address =
{
  -1,
  (gchar *) "address",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_out_getLdapAttribute_arg_pointers[] =
{
  &e_gdbus_cal_method_out_getLdapAttribute_address,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_getLdapAttribute =
{
  -1,
  (gchar *) "getLdapAttribute",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) &e_gdbus_cal_method_out_getLdapAttribute_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_out_getSchedulingInformation_capabilities =
{
  -1,
  (gchar *) "capabilities",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_out_getSchedulingInformation_arg_pointers[] =
{
  &e_gdbus_cal_method_out_getSchedulingInformation_capabilities,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_getSchedulingInformation =
{
  -1,
  (gchar *) "getSchedulingInformation",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) &e_gdbus_cal_method_out_getSchedulingInformation_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_in_setMode_mode =
{
  -1,
  (gchar *) "mode",
  (gchar *) "u",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_in_setMode_arg_pointers[] =
{
  &e_gdbus_cal_method_in_setMode_mode,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_setMode =
{
  -1,
  (gchar *) "setMode",
  (GDBusArgInfo **) &e_gdbus_cal_method_in_setMode_arg_pointers,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_out_getDefaultObject_object =
{
  -1,
  (gchar *) "object",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_out_getDefaultObject_arg_pointers[] =
{
  &e_gdbus_cal_method_out_getDefaultObject_object,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_getDefaultObject =
{
  -1,
  (gchar *) "getDefaultObject",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) &e_gdbus_cal_method_out_getDefaultObject_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_in_getObject_uid =
{
  -1,
  (gchar *) "uid",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo e_gdbus_cal_method_in_getObject_rid =
{
  -1,
  (gchar *) "rid",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_in_getObject_arg_pointers[] =
{
  &e_gdbus_cal_method_in_getObject_uid,
  &e_gdbus_cal_method_in_getObject_rid,
  NULL
};

static const GDBusArgInfo e_gdbus_cal_method_out_getObject_object =
{
  -1,
  (gchar *) "object",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_out_getObject_arg_pointers[] =
{
  &e_gdbus_cal_method_out_getObject_object,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_getObject =
{
  -1,
  (gchar *) "getObject",
  (GDBusArgInfo **) &e_gdbus_cal_method_in_getObject_arg_pointers,
  (GDBusArgInfo **) &e_gdbus_cal_method_out_getObject_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_in_getObjectList_sexp =
{
  -1,
  (gchar *) "sexp",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_in_getObjectList_arg_pointers[] =
{
  &e_gdbus_cal_method_in_getObjectList_sexp,
  NULL
};

static const GDBusArgInfo e_gdbus_cal_method_out_getObjectList_objects =
{
  -1,
  (gchar *) "objects",
  (gchar *) "as",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_out_getObjectList_arg_pointers[] =
{
  &e_gdbus_cal_method_out_getObjectList_objects,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_getObjectList =
{
  -1,
  (gchar *) "getObjectList",
  (GDBusArgInfo **) &e_gdbus_cal_method_in_getObjectList_arg_pointers,
  (GDBusArgInfo **) &e_gdbus_cal_method_out_getObjectList_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_in_getChanges_change_id =
{
  -1,
  (gchar *) "change_id",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_in_getChanges_arg_pointers[] =
{
  &e_gdbus_cal_method_in_getChanges_change_id,
  NULL
};

static const GDBusArgInfo e_gdbus_cal_method_out_getChanges_additions =
{
  -1,
  (gchar *) "additions",
  (gchar *) "as",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo e_gdbus_cal_method_out_getChanges_modifications =
{
  -1,
  (gchar *) "modifications",
  (gchar *) "as",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo e_gdbus_cal_method_out_getChanges_removals =
{
  -1,
  (gchar *) "removals",
  (gchar *) "as",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_out_getChanges_arg_pointers[] =
{
  &e_gdbus_cal_method_out_getChanges_additions,
  &e_gdbus_cal_method_out_getChanges_modifications,
  &e_gdbus_cal_method_out_getChanges_removals,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_getChanges =
{
  -1,
  (gchar *) "getChanges",
  (GDBusArgInfo **) &e_gdbus_cal_method_in_getChanges_arg_pointers,
  (GDBusArgInfo **) &e_gdbus_cal_method_out_getChanges_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_in_getFreeBusy_user_list =
{
  -1,
  (gchar *) "user_list",
  (gchar *) "as",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo e_gdbus_cal_method_in_getFreeBusy_start =
{
  -1,
  (gchar *) "start",
  (gchar *) "u",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo e_gdbus_cal_method_in_getFreeBusy_end =
{
  -1,
  (gchar *) "end",
  (gchar *) "u",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_in_getFreeBusy_arg_pointers[] =
{
  &e_gdbus_cal_method_in_getFreeBusy_user_list,
  &e_gdbus_cal_method_in_getFreeBusy_start,
  &e_gdbus_cal_method_in_getFreeBusy_end,
  NULL
};

static const GDBusArgInfo e_gdbus_cal_method_out_getFreeBusy_freebusy =
{
  -1,
  (gchar *) "freebusy",
  (gchar *) "as",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_out_getFreeBusy_arg_pointers[] =
{
  &e_gdbus_cal_method_out_getFreeBusy_freebusy,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_getFreeBusy =
{
  -1,
  (gchar *) "getFreeBusy",
  (GDBusArgInfo **) &e_gdbus_cal_method_in_getFreeBusy_arg_pointers,
  (GDBusArgInfo **) &e_gdbus_cal_method_out_getFreeBusy_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_in_discardAlarm_uid =
{
  -1,
  (gchar *) "uid",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo e_gdbus_cal_method_in_discardAlarm_auid =
{
  -1,
  (gchar *) "auid",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_in_discardAlarm_arg_pointers[] =
{
  &e_gdbus_cal_method_in_discardAlarm_uid,
  &e_gdbus_cal_method_in_discardAlarm_auid,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_discardAlarm =
{
  -1,
  (gchar *) "discardAlarm",
  (GDBusArgInfo **) &e_gdbus_cal_method_in_discardAlarm_arg_pointers,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_in_createObject_calobj =
{
  -1,
  (gchar *) "calobj",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_in_createObject_arg_pointers[] =
{
  &e_gdbus_cal_method_in_createObject_calobj,
  NULL
};

static const GDBusArgInfo e_gdbus_cal_method_out_createObject_uid =
{
  -1,
  (gchar *) "uid",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_out_createObject_arg_pointers[] =
{
  &e_gdbus_cal_method_out_createObject_uid,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_createObject =
{
  -1,
  (gchar *) "createObject",
  (GDBusArgInfo **) &e_gdbus_cal_method_in_createObject_arg_pointers,
  (GDBusArgInfo **) &e_gdbus_cal_method_out_createObject_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_in_modifyObject_calobj =
{
  -1,
  (gchar *) "calobj",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo e_gdbus_cal_method_in_modifyObject_mod =
{
  -1,
  (gchar *) "mod",
  (gchar *) "u",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_in_modifyObject_arg_pointers[] =
{
  &e_gdbus_cal_method_in_modifyObject_calobj,
  &e_gdbus_cal_method_in_modifyObject_mod,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_modifyObject =
{
  -1,
  (gchar *) "modifyObject",
  (GDBusArgInfo **) &e_gdbus_cal_method_in_modifyObject_arg_pointers,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_in_removeObject_uid =
{
  -1,
  (gchar *) "uid",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo e_gdbus_cal_method_in_removeObject_rid =
{
  -1,
  (gchar *) "rid",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo e_gdbus_cal_method_in_removeObject_mod =
{
  -1,
  (gchar *) "mod",
  (gchar *) "u",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_in_removeObject_arg_pointers[] =
{
  &e_gdbus_cal_method_in_removeObject_uid,
  &e_gdbus_cal_method_in_removeObject_rid,
  &e_gdbus_cal_method_in_removeObject_mod,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_removeObject =
{
  -1,
  (gchar *) "removeObject",
  (GDBusArgInfo **) &e_gdbus_cal_method_in_removeObject_arg_pointers,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_in_receiveObjects_calobj =
{
  -1,
  (gchar *) "calobj",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_in_receiveObjects_arg_pointers[] =
{
  &e_gdbus_cal_method_in_receiveObjects_calobj,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_receiveObjects =
{
  -1,
  (gchar *) "receiveObjects",
  (GDBusArgInfo **) &e_gdbus_cal_method_in_receiveObjects_arg_pointers,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_in_sendObjects_calobj =
{
  -1,
  (gchar *) "calobj",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_in_sendObjects_arg_pointers[] =
{
  &e_gdbus_cal_method_in_sendObjects_calobj,
  NULL
};

static const GDBusArgInfo e_gdbus_cal_method_out_sendObjects_users =
{
  -1,
  (gchar *) "users",
  (gchar *) "as",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo e_gdbus_cal_method_out_sendObjects_calobj =
{
  -1,
  (gchar *) "calobj",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_out_sendObjects_arg_pointers[] =
{
  &e_gdbus_cal_method_out_sendObjects_users,
  &e_gdbus_cal_method_out_sendObjects_calobj,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_sendObjects =
{
  -1,
  (gchar *) "sendObjects",
  (GDBusArgInfo **) &e_gdbus_cal_method_in_sendObjects_arg_pointers,
  (GDBusArgInfo **) &e_gdbus_cal_method_out_sendObjects_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_in_getAttachmentList_uid =
{
  -1,
  (gchar *) "uid",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo e_gdbus_cal_method_in_getAttachmentList_rid =
{
  -1,
  (gchar *) "rid",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_in_getAttachmentList_arg_pointers[] =
{
  &e_gdbus_cal_method_in_getAttachmentList_uid,
  &e_gdbus_cal_method_in_getAttachmentList_rid,
  NULL
};

static const GDBusArgInfo e_gdbus_cal_method_out_getAttachmentList_attachments =
{
  -1,
  (gchar *) "attachments",
  (gchar *) "as",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_out_getAttachmentList_arg_pointers[] =
{
  &e_gdbus_cal_method_out_getAttachmentList_attachments,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_getAttachmentList =
{
  -1,
  (gchar *) "getAttachmentList",
  (GDBusArgInfo **) &e_gdbus_cal_method_in_getAttachmentList_arg_pointers,
  (GDBusArgInfo **) &e_gdbus_cal_method_out_getAttachmentList_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_in_getQuery_sexp =
{
  -1,
  (gchar *) "sexp",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_in_getQuery_arg_pointers[] =
{
  &e_gdbus_cal_method_in_getQuery_sexp,
  NULL
};

static const GDBusArgInfo e_gdbus_cal_method_out_getQuery_query =
{
  -1,
  (gchar *) "query",
  (gchar *) "o",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_out_getQuery_arg_pointers[] =
{
  &e_gdbus_cal_method_out_getQuery_query,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_getQuery =
{
  -1,
  (gchar *) "getQuery",
  (GDBusArgInfo **) &e_gdbus_cal_method_in_getQuery_arg_pointers,
  (GDBusArgInfo **) &e_gdbus_cal_method_out_getQuery_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_in_getTimezone_tzid =
{
  -1,
  (gchar *) "tzid",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_in_getTimezone_arg_pointers[] =
{
  &e_gdbus_cal_method_in_getTimezone_tzid,
  NULL
};

static const GDBusArgInfo e_gdbus_cal_method_out_getTimezone_object =
{
  -1,
  (gchar *) "object",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_out_getTimezone_arg_pointers[] =
{
  &e_gdbus_cal_method_out_getTimezone_object,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_getTimezone =
{
  -1,
  (gchar *) "getTimezone",
  (GDBusArgInfo **) &e_gdbus_cal_method_in_getTimezone_arg_pointers,
  (GDBusArgInfo **) &e_gdbus_cal_method_out_getTimezone_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_in_addTimezone_tz =
{
  -1,
  (gchar *) "tz",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_in_addTimezone_arg_pointers[] =
{
  &e_gdbus_cal_method_in_addTimezone_tz,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_addTimezone =
{
  -1,
  (gchar *) "addTimezone",
  (GDBusArgInfo **) &e_gdbus_cal_method_in_addTimezone_arg_pointers,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_cal_method_in_setDefaultTimezone_tz =
{
  -1,
  (gchar *) "tz",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_cal_method_in_setDefaultTimezone_arg_pointers[] =
{
  &e_gdbus_cal_method_in_setDefaultTimezone_tz,
  NULL
};

static const GDBusMethodInfo e_gdbus_cal_method_setDefaultTimezone =
{
  -1,
  (gchar *) "setDefaultTimezone",
  (GDBusArgInfo **) &e_gdbus_cal_method_in_setDefaultTimezone_arg_pointers,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusMethodInfo * const e_gdbus_cal_method_info_pointers[] =
{
  &e_gdbus_cal_method_getUri,
  &e_gdbus_cal_method_getCacheDir,
  &e_gdbus_cal_method_open,
  &e_gdbus_cal_method_refresh,
  &e_gdbus_cal_method_close,
  &e_gdbus_cal_method_remove,
  &e_gdbus_cal_method_isReadOnly,
  &e_gdbus_cal_method_getCalAddress,
  &e_gdbus_cal_method_getAlarmEmailAddress,
  &e_gdbus_cal_method_getLdapAttribute,
  &e_gdbus_cal_method_getSchedulingInformation,
  &e_gdbus_cal_method_setMode,
  &e_gdbus_cal_method_getDefaultObject,
  &e_gdbus_cal_method_getObject,
  &e_gdbus_cal_method_getObjectList,
  &e_gdbus_cal_method_getChanges,
  &e_gdbus_cal_method_getFreeBusy,
  &e_gdbus_cal_method_discardAlarm,
  &e_gdbus_cal_method_createObject,
  &e_gdbus_cal_method_modifyObject,
  &e_gdbus_cal_method_removeObject,
  &e_gdbus_cal_method_receiveObjects,
  &e_gdbus_cal_method_sendObjects,
  &e_gdbus_cal_method_getAttachmentList,
  &e_gdbus_cal_method_getQuery,
  &e_gdbus_cal_method_getTimezone,
  &e_gdbus_cal_method_addTimezone,
  &e_gdbus_cal_method_setDefaultTimezone,
  NULL
};

static const GDBusInterfaceInfo _e_gdbus_cal_interface_info =
{
  -1,
  (gchar *) "org.gnome.evolution.dataserver.Calendar",
  (GDBusMethodInfo **) &e_gdbus_cal_method_info_pointers,
  (GDBusSignalInfo **) &e_gdbus_cal_signal_info_pointers,
  (GDBusPropertyInfo **) NULL,
};

static void
handle_method_call (GDBusConnection       *connection,
                    const gchar           *sender,
                    const gchar           *object_path,
                    const gchar           *interface_name,
                    const gchar           *method_name,
                    GVariant              *parameters,
                    GDBusMethodInvocation *invocation,
                    gpointer               user_data)
{
  guint method_id;
  method_id = lookup_method_id_from_method_name (method_name);
  switch (method_id)
    {
    case __GET_URI_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_CACHE_DIR_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __OPEN_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	gboolean arg_only_if_exists;
	const gchar *arg_username;
	const gchar *arg_password;
	g_variant_get (parameters,
                       "(b&s&s)",
		       &arg_only_if_exists,
		       &arg_username,
		       &arg_password);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_only_if_exists, arg_username, arg_password, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __REFRESH_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __CLOSE_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __REMOVE_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __IS_READ_ONLY_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_CAL_ADDRESS_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_ALARM_EMAIL_ADDRESS_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_LDAP_ATTRIBUTE_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_SCHEDULING_INFORMATION_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __SET_MODE_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	guint arg_mode;
	g_variant_get (parameters,
                       "(u)",
		       &arg_mode);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_mode, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_DEFAULT_OBJECT_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_OBJECT_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	const gchar *arg_uid;
	const gchar *arg_rid;
	g_variant_get (parameters,
                       "(&s&s)",
		       &arg_uid,
		       &arg_rid);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_uid, arg_rid, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_OBJECT_LIST_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	const gchar *arg_sexp;
	g_variant_get (parameters,
                       "(&s)",
		       &arg_sexp);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_sexp, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_CHANGES_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	const gchar *arg_change_id;
	g_variant_get (parameters,
                       "(&s)",
		       &arg_change_id);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_change_id, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_FREE_BUSY_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	const gchar * const *arg_user_list;
	guint arg_start;
	guint arg_end;
	g_variant_get (parameters,
                       "(^a&suu)",
		       &arg_user_list,
		       &arg_start,
		       &arg_end);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_user_list, arg_start, arg_end, &handled);
	g_free ((gpointer) arg_user_list);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __DISCARD_ALARM_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	const gchar *arg_uid;
	const gchar *arg_auid;
	g_variant_get (parameters,
                       "(&s&s)",
		       &arg_uid,
		       &arg_auid);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_uid, arg_auid, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __CREATE_OBJECT_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	const gchar *arg_calobj;
	g_variant_get (parameters,
                       "(&s)",
		       &arg_calobj);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_calobj, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __MODIFY_OBJECT_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	const gchar *arg_calobj;
	guint arg_mod;
	g_variant_get (parameters,
                       "(&su)",
		       &arg_calobj,
		       &arg_mod);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_calobj, arg_mod, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __REMOVE_OBJECT_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	const gchar *arg_uid;
	const gchar *arg_rid;
	guint arg_mod;
	g_variant_get (parameters,
                       "(&s&su)",
		       &arg_uid,
		       &arg_rid,
		       &arg_mod);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_uid, arg_rid, arg_mod, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __RECEIVE_OBJECTS_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	const gchar *arg_calobj;
	g_variant_get (parameters,
                       "(&s)",
		       &arg_calobj);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_calobj, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __SEND_OBJECTS_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	const gchar *arg_calobj;
	g_variant_get (parameters,
                       "(&s)",
		       &arg_calobj);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_calobj, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_ATTACHMENT_LIST_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	const gchar *arg_uid;
	const gchar *arg_rid;
	g_variant_get (parameters,
                       "(&s&s)",
		       &arg_uid,
		       &arg_rid);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_uid, arg_rid, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_QUERY_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	const gchar *arg_sexp;
	g_variant_get (parameters,
                       "(&s)",
		       &arg_sexp);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_sexp, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_TIMEZONE_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	const gchar *arg_tzid;
	g_variant_get (parameters,
                       "(&s)",
		       &arg_tzid);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_tzid, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __ADD_TIMEZONE_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	const gchar *arg_tz;
	g_variant_get (parameters,
                       "(&s)",
		       &arg_tz);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_tz, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __SET_DEFAULT_TIMEZONE_METHOD:
      {
	EGdbusCal *object = E_GDBUS_CAL (user_data);
	gboolean handled;
	const gchar *arg_tz;
	g_variant_get (parameters,
                       "(&s)",
		       &arg_tz);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_tz, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    default:
not_implemented:
      g_dbus_method_invocation_return_error (invocation,
					     G_DBUS_ERROR,
					     G_DBUS_ERROR_NOT_SUPPORTED,
                                             "Method `%s' is not implemented",
					     method_name);
      break;
    }
};

static GVariant *
get_property (GDBusConnection  *connection,
              const gchar      *sender,
              const gchar      *object_path,
              const gchar      *interface_name,
              const gchar      *property_name,
              GError          **error,
              gpointer          user_data)
{
  GVariant *ret;
  guint prop_id;
  prop_id = lookup_property_id_from_property_name (property_name);
  ret = NULL;
  switch (prop_id)
    {
    default:
      g_set_error (error,
		   G_DBUS_ERROR,
		   G_DBUS_ERROR_NOT_SUPPORTED,
                   "This implementation does not support property `%s'",
		   property_name);
      break;
    }

  return ret;
};

static gboolean
set_property (GDBusConnection  *connection,
              const gchar      *sender,
              const gchar      *object_path,
              const gchar      *interface_name,
              const gchar      *property_name,
              GVariant         *value,
              GError          **error,
              gpointer          user_data)
{
  gboolean ret;
  guint prop_id;
  prop_id = lookup_property_id_from_property_name (property_name);
  ret = TRUE;
  switch (prop_id)
    {
    default:
      g_set_error (error,
		   G_DBUS_ERROR,
		   G_DBUS_ERROR_NOT_SUPPORTED,
                   "This implementation does not support property `%s'",
		   property_name);
      ret = FALSE;
      break;
    }

  return ret;
};

static const GDBusInterfaceVTable e_gdbus_cal_interface_vtable =
{
  handle_method_call,
  get_property,
  set_property,
};

static gboolean
emit_notifications_in_idle (gpointer user_data)
{
  GObject *object = G_OBJECT (user_data);
  GDBusConnection *connection;
  const gchar *path;
  GHashTable *notification_queue;
  GHashTableIter iter;
  const gchar *property_name;
  GVariant *value;
  GVariantBuilder *builder;
  GVariantBuilder *invalidated_builder;
  GHashTable *pvc;
  gboolean has_changes;

  notification_queue = g_object_get_data (object, "gdbus-codegen-notification-queue");
  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  pvc = g_object_get_data (object, "gdbus-codegen-pvc");
  g_assert (notification_queue != NULL && path != NULL && connection != NULL && pvc != NULL);

  builder = g_variant_builder_new (G_VARIANT_TYPE_ARRAY);
  invalidated_builder = g_variant_builder_new (G_VARIANT_TYPE ("as"));
  g_hash_table_iter_init (&iter, notification_queue);
  has_changes = FALSE;
  while (g_hash_table_iter_next (&iter, (gpointer) &property_name, (gpointer) &value))
    {
      GVariant *cached_value;
      cached_value = g_hash_table_lookup (pvc, property_name);
      if (cached_value == NULL || !g_variant_equal (cached_value, value))
	{
	  g_hash_table_insert (pvc, (gpointer) property_name, (gpointer) g_variant_ref (value));
          g_variant_builder_add (builder, "{sv}", property_name, value);
	  has_changes = TRUE;
	}
    }

  if (has_changes)
    {
      g_dbus_connection_emit_signal (connection,
				     NULL,
				     path,
                                     "org.freedesktop.DBus.Properties",
                                     "PropertiesChanged",
                                     g_variant_new ("(sa{sv}as)",
                                                    "org.gnome.evolution.dataserver.Calendar",
						    builder,
						    invalidated_builder),
				     NULL);
    }
  else
    {
      g_variant_builder_unref (builder);
      g_variant_builder_unref (invalidated_builder);
    }

  g_hash_table_remove_all (notification_queue);
  g_object_set_data (object, "gdbus-codegen-notification-idle-id", GUINT_TO_POINTER (0));
  return FALSE;
}

static void
queue_notification (GObject     *object,
                    const gchar *property_name,
                    GVariant    *value)
{
  GHashTable *notification_queue;
  guint idle_id;
  notification_queue = g_object_get_data (object, "gdbus-codegen-notification-queue");
  if (notification_queue == NULL)
    {
      notification_queue = g_hash_table_new_full (g_str_hash, g_str_equal, NULL, (GDestroyNotify) g_variant_unref);
      g_object_set_data_full (object, "gdbus-codegen-notification-queue", notification_queue, (GDestroyNotify) g_hash_table_unref);
    }
  g_hash_table_insert (notification_queue, (gpointer) property_name, (gpointer) value); /* adopts value */
  idle_id = GPOINTER_TO_UINT (g_object_get_data (object, "gdbus-codegen-notification-idle-id"));
  if (idle_id == 0)
    {
      GSource *idle_source;
      idle_source = g_idle_source_new ();
      g_source_set_priority (idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (idle_source,
			     emit_notifications_in_idle,
			     g_object_ref (object),
			     (GDestroyNotify) g_object_unref);
      idle_id = g_source_attach (idle_source, g_main_context_get_thread_default ());
      g_source_unref (idle_source);
      g_object_set_data (object, "gdbus-codegen-notification-idle-id", GUINT_TO_POINTER (idle_id));
    }
}

/**
 * e_gdbus_cal_drain_notify:
 * @object: A #EGdbusCal that is exported.
 *
 * If @object has queued notifications, empty the queue forcing
 * the <literal>PropertiesChanged</literal> signal to be emitted.
 * See <xref linkend="EGdbusCal.description"/> for more background information.
 */
void
e_gdbus_cal_drain_notify (EGdbusCal *object)
{
  gint idle_id;
  idle_id = GPOINTER_TO_UINT (g_object_get_data (G_OBJECT (object), "gdbus-codegen-notification-idle-id"));
  if (idle_id > 0)
    {
      emit_notifications_in_idle (object);
      g_source_remove (idle_id);
    }
}

static void
on_notify (GObject    *object,
           GParamSpec *pspec,
           gpointer    user_data)
{
  GDBusConnection *connection;
  const gchar *path;
  GVariant *value;
  const gchar *property_name;
  guint prop_id;

  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  if (connection == NULL || path == NULL)
    goto out;

  property_name = lookup_property_name_from_property_gname (pspec->name);
  if (property_name == NULL)
    goto out;
  prop_id = lookup_property_id_from_property_name (property_name);

  value = NULL;
  switch (prop_id)
    {
  }

  if (value != NULL && property_name != NULL)
    {
      queue_notification (object, property_name, g_variant_ref_sink (value));
    }
out:
  ;
}

static void
on_object_unregistered (GObject *object)
{
  gint idle_id;
  idle_id = GPOINTER_TO_UINT (g_object_get_data (G_OBJECT (object), "gdbus-codegen-notification-idle-id"));
  if (idle_id > 0)
    {
      g_source_remove (idle_id);
    }
  g_object_set_data (G_OBJECT (object), "gdbus-codegen-path", NULL);
  g_object_set_data (G_OBJECT (object), "gdbus-codegen-connection", NULL);
  g_signal_handlers_disconnect_by_func (object, on_notify, NULL);
}

/**
 * e_gdbus_cal_register_object:
 * @object: An instance of a #GObject<!-- -->-derived type implementing the #EGdbusCal interface.
 * @connection: A #GDBusConnection.
 * @object_path: The object to register the object at.
 * @error: Return location for error or %NULL.
 *
 * Registers @object at @object_path on @connection.
 *
 * See <xref linkend="EGdbusCal.description"/>
 * for how properties, methods and signals are handled.
 *
 * Returns: 0 if @error is set, otherwise a registration id (never 0) that can be used with g_dbus_connection_unregister_object().
 */
guint
e_gdbus_cal_register_object (EGdbusCal *object,
           GDBusConnection *connection,
           const gchar *object_path,
           GError **error)
{
  G_GNUC_UNUSED GVariant *value;
  GHashTable *pvc;

  pvc = g_hash_table_new_full (g_str_hash, g_str_equal, NULL, (GDestroyNotify) g_variant_unref);

  g_object_set_data_full (G_OBJECT (object), "gdbus-codegen-path", (gpointer) g_strdup (object_path), g_free);
  g_object_set_data (G_OBJECT (object), "gdbus-codegen-connection", (gpointer) connection);
  g_object_set_data_full (G_OBJECT (object), "gdbus-codegen-pvc", (gpointer) pvc, (GDestroyNotify) g_hash_table_unref);
  g_signal_connect (object, "notify", G_CALLBACK (on_notify), NULL);
  return g_dbus_connection_register_object (connection,
	  object_path,
	  (GDBusInterfaceInfo *) &_e_gdbus_cal_interface_info,
	  &e_gdbus_cal_interface_vtable,
	  object,
	  (GDestroyNotify) on_object_unregistered,
	  error);
}

/**
 * e_gdbus_cal_interface_info:
 *
 * Gets interface description for the <literal>org.gnome.evolution.dataserver.Calendar</literal> D-Bus interface.
 *
 * Returns: A #GDBusInterfaceInfo. Do not free, the object is statically allocated.
 */
const GDBusInterfaceInfo *
e_gdbus_cal_interface_info (void)
{
  return &_e_gdbus_cal_interface_info;
}

/* ---------------------------------------------------------------------- */

static void proxy_iface_init (EGdbusCalIface *iface);

G_DEFINE_TYPE_WITH_CODE (EGdbusCalProxy, e_gdbus_cal_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (E_GDBUS_TYPE_CAL, proxy_iface_init));

static void
e_gdbus_cal_proxy_init (EGdbusCalProxy *proxy)
{
  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy),
				   (GDBusInterfaceInfo *) &_e_gdbus_cal_interface_info);
}

static void
g_signal (GDBusProxy  *proxy,
          const gchar *sender_name,
          const gchar *signal_name,
          GVariant    *parameters)
{
  guint signal_id;
  signal_id = lookup_signal_id_from_signal_name (signal_name);
  switch (signal_id)
    {
    case __AUTH_REQUIRED_SIGNAL:
      {
	g_signal_emit (proxy,
		       signals[signal_id],
		       0);
      }
      break;

    case __BACKEND_ERROR_SIGNAL:
      {
	const gchar *arg_error;
	g_variant_get (parameters,
                       "(&s)",
		       &arg_error);
	g_signal_emit (proxy,
		       signals[signal_id],
		       0, arg_error);
      }
      break;

    case __READONLY_SIGNAL:
      {
	gboolean arg_is_readonly;
	g_variant_get (parameters,
                       "(b)",
		       &arg_is_readonly);
	g_signal_emit (proxy,
		       signals[signal_id],
		       0, arg_is_readonly);
      }
      break;

    case __MODE_SIGNAL:
      {
	gint arg_mode;
	g_variant_get (parameters,
                       "(i)",
		       &arg_mode);
	g_signal_emit (proxy,
		       signals[signal_id],
		       0, arg_mode);
      }
      break;

    }
}

static void
e_gdbus_cal_proxy_get_property (GObject      *object,
                       guint         prop_id,
                       GValue       *value,
                       GParamSpec   *pspec)
{
  G_GNUC_UNUSED GVariant *cached;
  switch (prop_id)
    {

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
property_set_cb (GDBusProxy   *proxy,
                 GAsyncResult *res,
                 gpointer      user_data)
{
  const gchar *property_name = user_data;
  GError *error;
  GVariant *result;

  error = NULL;
  result = g_dbus_proxy_call_finish (proxy, res, &error);
  if (result == NULL)
    {
      g_warning ("Error setting property `%s': %s", property_name, error->message);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (result);
    }
}

static void
e_gdbus_cal_proxy_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  GVariant *new_value;
  const gchar *property_name;
  new_value = NULL;
  property_name = NULL;
  switch (prop_id)
    {

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }

  if (new_value != NULL)
    {
      g_variant_ref_sink (new_value);
      g_dbus_proxy_call (G_DBUS_PROXY (object),
                         "org.freedesktop.DBus.Properties.Set",
                         g_variant_new ("(ssv)",
                                        "org.gnome.evolution.dataserver.Calendar",
					property_name,
					new_value),
			 G_DBUS_CALL_FLAGS_NONE,
			 e_data_server_util_get_dbus_call_timeout (),
			 NULL,
			 (GAsyncReadyCallback) property_set_cb,
			 (gpointer) property_name);
      g_variant_unref (new_value);
    }

}

static void
g_properties_changed (GDBusProxy         *proxy,
                      GVariant           *changed_properties,
                      const gchar * const *invalidated_properties)
{
  guint n;
  const gchar *key;
  GVariantIter *iter;
  const gchar *gname;

  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      gname = lookup_property_gname_from_property_name (key);
      if (gname != NULL)
	g_object_notify (G_OBJECT (proxy), gname);
    }

  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      gname = lookup_property_gname_from_property_name (invalidated_properties[n]);
      if (gname != NULL)
	g_object_notify (G_OBJECT (proxy), gname);
    }

}

static void
e_gdbus_cal_proxy_class_init (EGdbusCalProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->get_property = e_gdbus_cal_proxy_get_property;
  gobject_class->set_property = e_gdbus_cal_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = g_signal;
  proxy_class->g_properties_changed = g_properties_changed;

}

static void
proxy_iface_init (EGdbusCalIface *iface)
{
}

/**
 * e_gdbus_cal_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags used when constructing the proxy.
 * @name: A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: Callback function to invoke when the proxy is ready.
 * @user_data: User data to pass to @callback.
 *
 * Like g_dbus_proxy_new() but returns a #EGdbusCalProxy.
 *
 * This is a failable asynchronous constructor - when the proxy is ready, callback will be invoked and you can use e_gdbus_cal_proxy_new_finish() to get the result.
 */
void e_gdbus_cal_proxy_new (GDBusConnection     *connection,
                   GDBusProxyFlags      flags,
                   const gchar         *name,
                   const gchar         *object_path,
                   GCancellable        *cancellable,
                   GAsyncReadyCallback  callback,
                   gpointer             user_data)
{
  g_async_initable_new_async (E_GDBUS_TYPE_CAL_PROXY,
			      G_PRIORITY_DEFAULT,
			      cancellable,
			      callback,
			      user_data,
                              "g-flags", flags,
                              "g-name", name,
                              "g-connection", connection,
                              "g-object-path", object_path,
                              "g-interface-name", "org.gnome.evolution.dataserver.Calendar",
			      NULL);
}

/**
 * e_gdbus_cal_proxy_new_finish:
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback function passed to e_gdbus_cal_proxy_new().
 * @error: Return location for error or %NULL.
 *
 * Finishes creating a #EGdbusCalProxy.
 *
 * Returns: A #EGdbusCalProxy or %NULL if @error is set. Free with g_object_unref().
 */
EGdbusCal *e_gdbus_cal_proxy_new_finish (GAsyncResult  *res,
                        GError       **error)
{
  GObject *object;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  g_assert (source_object != NULL);
  object = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object),
					res,
					error);
  g_object_unref (source_object);
  if (object != NULL)
    return E_GDBUS_CAL (object);
  else
    return NULL;
}

/**
 * e_gdbus_cal_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags used when constructing the proxy.
 * @name: A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Like g_dbus_proxy_new_sync() but returns a #EGdbusCalProxy.
 *
 * This is a synchronous failable constructor. See e_gdbus_cal_proxy_new() and e_gdbus_cal_proxy_new_finish() for the asynchronous version.
 *
 * Returns: A #EGdbusCalProxy or %NULL if error is set. Free with g_object_unref().
 */
EGdbusCal *e_gdbus_cal_proxy_new_sync (GDBusConnection     *connection,
                       GDBusProxyFlags      flags,
                       const gchar         *name,
                       const gchar         *object_path,
                       GCancellable        *cancellable,
                       GError             **error)
{
  GInitable *initable;
  initable = g_initable_new (E_GDBUS_TYPE_CAL_PROXY,
			     cancellable,
			     error,
                             "g-flags", flags,
                             "g-name", name,
                             "g-connection", connection,
                             "g-object-path", object_path,
                             "g-interface-name", "org.gnome.evolution.dataserver.Calendar",
			     NULL);
  if (initable != NULL)
    return E_GDBUS_CAL (initable);
  else
    return NULL;
}

/**
 * e_gdbus_cal_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags used when constructing the proxy.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: Callback function to invoke when the proxy is ready.
 * @user_data: User data to pass to @callback.
 *
 * Like g_dbus_proxy_new_for_bus() but returns a #EGdbusCalProxy.
 *
 * This is a failable asynchronous constructor - when the proxy is ready, callback will be invoked and you can use e_gdbus_cal_proxy_new_for_bus_finish() to get the result.
 */
void e_gdbus_cal_proxy_new_for_bus (GBusType             bus_type,
                           GDBusProxyFlags      flags,
                           const gchar         *name,
                           const gchar         *object_path,
                           GCancellable        *cancellable,
                           GAsyncReadyCallback  callback,
                           gpointer             user_data)
{
  g_async_initable_new_async (E_GDBUS_TYPE_CAL_PROXY,
			      G_PRIORITY_DEFAULT,
			      cancellable,
			      callback,
			      user_data,
                              "g-flags", flags,
                              "g-name", name,
                              "g-bus-type", bus_type,
                              "g-object-path", object_path,
                              "g-interface-name", "org.gnome.evolution.dataserver.Calendar",
			      NULL);
}

/**
 * e_gdbus_cal_proxy_new_for_bus_finish:
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback function passed to e_gdbus_cal_proxy_new_for_bus().
 * @error: Return location for error or %NULL.
 *
 * Finishes creating a #EGdbusCalProxy.
 *
 * Returns: A #EGdbusCalProxy or %NULL if @error is set. Free with g_object_unref().
 */
EGdbusCal *e_gdbus_cal_proxy_new_for_bus_finish (GAsyncResult  *res,
                                GError       **error)
{
  GObject *object;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  g_assert (source_object != NULL);
  object = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object),
					res,
					error);
  g_object_unref (source_object);
  if (object != NULL)
    return E_GDBUS_CAL (object);
  else
    return NULL;
}

/**
 * e_gdbus_cal_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags used when constructing the proxy.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Like g_dbus_proxy_new_for_bus_sync() but returns a #EGdbusCalProxy.
 *
 * This is a synchronous failable constructor. See e_gdbus_cal_proxy_new_for_bus() and e_gdbus_cal_proxy_new_for_bus_finish() for the asynchronous version.
 *
 * Returns: A #EGdbusCalProxy or %NULL if error is set. Free with g_object_unref().
 */
EGdbusCal *e_gdbus_cal_proxy_new_for_bus_sync (GBusType             bus_type,
                               GDBusProxyFlags      flags,
                               const gchar         *name,
                               const gchar         *object_path,
                               GCancellable        *cancellable,
                               GError             **error)
{
  GInitable *initable;
  initable = g_initable_new (E_GDBUS_TYPE_CAL_PROXY,
			     cancellable,
			     error,
                             "g-flags", flags,
                             "g-name", name,
                             "g-bus-type", bus_type,
                             "g-object-path", object_path,
                             "g-interface-name", "org.gnome.evolution.dataserver.Calendar",
			     NULL);
  if (initable != NULL)
    return E_GDBUS_CAL (initable);
  else
    return NULL;
}

/* ---------------------------------------------------------------------- */

struct _EGdbusCalStubPrivate
{
  gint foo;
};

static void stub_iface_init (EGdbusCalIface *iface);

G_DEFINE_TYPE_WITH_CODE (EGdbusCalStub, e_gdbus_cal_stub, G_TYPE_OBJECT,
                         G_IMPLEMENT_INTERFACE (E_GDBUS_TYPE_CAL, stub_iface_init));

static void
e_gdbus_cal_stub_finalize (GObject *object)
{
  G_GNUC_UNUSED EGdbusCalStub *stub = (EGdbusCalStub *) object;
  if (G_OBJECT_CLASS (e_gdbus_cal_stub_parent_class)->finalize != NULL)
    G_OBJECT_CLASS (e_gdbus_cal_stub_parent_class)->finalize (object);
}

static void
e_gdbus_cal_stub_get_property (GObject      *object,
                      guint         prop_id,
                      GValue       *value,
                      GParamSpec   *pspec)
{
  G_GNUC_UNUSED static gchar **strv_of_len_zero = {NULL};
  G_GNUC_UNUSED EGdbusCalStub *stub = (EGdbusCalStub *) object;
  switch (prop_id)
    {

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
e_gdbus_cal_stub_set_property (GObject      *object,
                      guint         prop_id,
                      const GValue *value,
                      GParamSpec   *pspec)
{
  G_GNUC_UNUSED EGdbusCalStub *stub = (EGdbusCalStub *) object;
  switch (prop_id)
    {

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
e_gdbus_cal_stub_init (EGdbusCalStub *stub)
{
  stub->priv = G_TYPE_INSTANCE_GET_PRIVATE (stub, E_GDBUS_TYPE_CAL_STUB, EGdbusCalStubPrivate);
}

static void
e_gdbus_cal_stub_class_init (EGdbusCalStubClass *klass)
{
  GObjectClass *gobject_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = e_gdbus_cal_stub_finalize;
  gobject_class->get_property = e_gdbus_cal_stub_get_property;
  gobject_class->set_property = e_gdbus_cal_stub_set_property;
  g_type_class_add_private (klass, sizeof (EGdbusCalStubPrivate));
}

static void
stub_iface_init (EGdbusCalIface *iface)
{
}

/**
 * e_gdbus_cal_stub_new:
 *
 * Creates a new stub object that can be exported via e_gdbus_cal_register_object().
 *
 * Returns: A #EGdbusCalStub instance. Free with g_object_unref().
 */
EGdbusCal *
e_gdbus_cal_stub_new (void)
{
  return E_GDBUS_CAL (g_object_new (E_GDBUS_TYPE_CAL_STUB, NULL));
}
