// -*- c++ -*-
/* $Id: utils.cc,v 1.1 2004/03/28 19:03:25 murrayc Exp $ */

/* utils.cc
 *
 * Copyright 2004      gnome-vfsmm development team.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomevfsmm/utils.h>
#include <libgnomevfs/gnome-vfs-utils.h>
#include <glibmm/utility.h> //For Glib::convert_const_gchar_ptr_to_ustring()

namespace Gnome
{

namespace Vfs
{

Glib::ustring format_file_size_for_display(FileSize size)
{
  return Glib::convert_const_gchar_ptr_to_ustring( gnome_vfs_format_file_size_for_display(size) );
}

Glib::ustring escape_string(const Glib::ustring& unescaped_string)
{
  return Glib::convert_const_gchar_ptr_to_ustring( gnome_vfs_escape_string(unescaped_string.c_str()) );
}

Glib::ustring escape_path_string(const Glib::ustring& path)
{
  return Glib::convert_const_gchar_ptr_to_ustring( gnome_vfs_escape_path_string(path.c_str()) );
}

Glib::ustring escape_host_and_path_string(const Glib::ustring& path)
{
  return Glib::convert_const_gchar_ptr_to_ustring( gnome_vfs_escape_host_and_path_string(path.c_str()) );
}

Glib::ustring escape_slashes(const Glib::ustring& unescaped_string)
{
  return Glib::convert_const_gchar_ptr_to_ustring( gnome_vfs_escape_slashes(unescaped_string.c_str()) );
}

Glib::ustring unescape_string(const Glib::ustring& escaped_string, const Glib::ustring& illegal_characters)
{
  return Glib::convert_const_gchar_ptr_to_ustring( gnome_vfs_unescape_string(escaped_string.c_str(), (illegal_characters.empty() ? 0 : illegal_characters.c_str())) );
}

Glib::ustring unescape_string_for_display(const Glib::ustring& escaped_string)
{
  return Glib::convert_const_gchar_ptr_to_ustring( gnome_vfs_unescape_string_for_display(escaped_string.c_str()) );
}

Glib::ustring make_uri_canonical(const Glib::ustring& uri)
{
  return Glib::convert_const_gchar_ptr_to_ustring( gnome_vfs_unescape_string_for_display(uri.c_str()) );
}

Glib::ustring make_path_name_canonical(const Glib::ustring& path)
{
  return Glib::convert_const_gchar_ptr_to_ustring( gnome_vfs_unescape_string_for_display(path.c_str()) );
}

Glib::ustring expand_initial_tilde(const Glib::ustring& path)
{
  return Glib::convert_const_gchar_ptr_to_ustring( gnome_vfs_unescape_string_for_display(path.c_str()) );
}

Glib::ustring get_local_path_from_uri (const Glib::ustring& uri)
{
  return Glib::convert_const_gchar_ptr_to_ustring( gnome_vfs_get_local_path_from_uri(uri.c_str()) );
}

Glib::ustring get_uri_from_local_path(const Glib::ustring& local_full_path)
{
  return Glib::convert_const_gchar_ptr_to_ustring( gnome_vfs_get_uri_from_local_path(local_full_path.c_str()) );
}

bool is_executable_command_string(const Glib::ustring& command_string)
{
  return gnome_vfs_is_executable_command_string(command_string.c_str());
}

Glib::ustring icon_path_from_filename (const Glib::ustring& filename)
{
  return Glib::convert_const_gchar_ptr_to_ustring( gnome_vfs_icon_path_from_filename(filename.c_str()) );
}

} //namespace Vfs
} //namespace Gnome



