/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;

/**
 * It is often necessary in Pango to determine if a particular font can
 * represent a particular character, and also how well it can represent that
 * character. The PangoCoverage is a data structure that is used to represent
 * that information.
 */
public class Coverage extends Boxed 
{

	protected Coverage(Handle handle){
		this.handle = handle;
	}

	/**
	 * Create a new Coverage
	 */
	public Coverage(){
		handle = pango_coverage_new ();
	}

	/**
	 * Determine whether a particular index is covered by coverage
	 */
	public CoverageLevel get(int index){
		return CoverageLevel.intern( pango_coverage_get(handle, index) );
	}

	/**
	 * Set the coverage for each index in coverage to be the max (better) value
	 * of the current coverage for the index and the coverage for the
	 * corresponding index in other.
	 */
	public void setMax(Coverage other){
		pango_coverage_max(handle, other.getHandle());
	}

	/**
	 * Modify a particular index within coverage
	 */
	public void set(int index, CoverageLevel level){
		pango_coverage_set(handle, index, level.getValue());
	}



	/****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected Handle pango_coverage_new ();
    native static final protected Handle pango_coverage_ref (Handle coverage);
    native static final protected void pango_coverage_unref (Handle coverage);
    native static final protected Handle pango_coverage_copy (Handle coverage);
    native static final protected int pango_coverage_get (Handle coverage, int index);
    native static final protected void pango_coverage_set (Handle coverage, int index, int level);
    native static final protected void pango_coverage_max (Handle coverage, Handle other);
    native static final protected void pango_coverage_to_bytes (Handle coverage, byte[] bytes, int [] 
        numBytes);
    native static final protected Handle pango_coverage_from_bytes (byte[] bytes, int numBytes);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

