/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.glib;

/**
 * The class represents an internal representation of an Error
 * from the GTK and GNOME libraries.  It should never be returned
 * to the application layer.  The Java-GNOME API should throw an
 * exception that contains the relevant information contained 
 * within this object.  This resource must be freed when you are
 * finished with it via the free() method.
 */
public class Error extends Boxed 
{
	/**
	 * Construct a new Error object.  This object is used to
	 * retrieve errors from the native layer.  The java-gnome
	 * library will rarely return an object of this type.  It
	 * will convert it into an exception that will be thrown
	 * to the application layer.
	 */
	public Error(Quark domain, int code, String message) {
		handle = Error.g_error_new_literal(domain.getHandle(), code, message);
	}
	
	/**
	 * Return the domain for this error.
	 * 
	 * @return The Quark object that represents the domain for
	 * this error.
	 */
	public Quark getDomain() {
		Handle qhndl = Error.getDomain(handle);
		return new Quark(qhndl);
	}
	
	/**
	 * Return the error code associated with this error.
	 * 
	 * @return The error code for this error.
	 */
	public int getErrorCode() {
		return Error.getCode(handle);
	}
	
	/**
	 * Return the error message associated with this error.
	 * 
	 * @return The error message for this error.
	 */
	public String getErrorMessage() {
		return Error.getMessage(handle);
	}
	
	/**
	 * Free the resources associated with this object
	 */
	public void free() {
		Error.g_error_free(handle);
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected Handle getDomain (Handle obj);
    native static final protected int getCode (Handle obj);
    native static final protected String getMessage (Handle obj);
    native static final protected Handle g_error_new_literal (Handle domain, int code, String message);
    native static final protected void g_error_free (Handle error);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

