/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

 /*
  * TODO:
  * - Documentation.
  * - Complete the methods.
  */

package org.gnu.gdk;
import org.gnu.glib.GObject;

/**
 *
 */
 
public class Region extends GObject 
{
	
	public Region(int handle){
		super(handle);
	}
	
	public Region(){
		super(gdk_region_new());
	}	
	
	public Region getPolygon(Point points[], FillRule rule){
		int pointsh[]=new int[points.length];
		for(int i=0;i<points.length;i++)
			pointsh[i]=points[i].getHandle();
		return new Region(gdk_region_polygon(pointsh,pointsh.length,rule.getValue()));
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gdk_region_new ();
    native static final protected int gdk_region_polygon (int [] points, int numPoints, int 
        fillRule);
    native static final protected int gdk_region_rectangle (int rectangle);
    native static final protected void gdk_region_destroy (int region);
    native static final protected void gdk_region_get_clipbox (int region, int rectangle);
    native static final protected void gdk_region_get_rectangles (int region, int [] rectangles, 
        int [] numRectangles);
    native static final protected boolean gdk_region_empty (int region);
    native static final protected boolean gdk_region_equal (int region1, int region2);
    native static final protected boolean gdk_region_point_in (int region, int x, int y);
    native static final protected int gdk_region_rect_in (int region, int rect);
    native static final protected void gdk_region_offset (int retion, int dx, int dy);
    native static final protected void gdk_region_shrink (int region, int dx, int dy);
    native static final protected void gdk_region_union_with_rect (int region, int rect);
    native static final protected void gdk_region_intersect (int source1, int source2);
    native static final protected void gdk_region_union (int source1, int source2);
    native static final protected void gdk_region_subtract (int source1, int source2);
    native static final protected void gdk_region_xor (int source1, int source2);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

