// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGNOMEVFSMM_FILE_INFO_H
#define _LIBGNOMEVFSMM_FILE_INFO_H

#include <glibmm.h>

/* $Id: file-info.hg,v 1.11 2004/04/07 17:39:05 murrayc Exp $ */
// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* Copyright 2003 gnome-vfsmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <libgnomevfsmm/enums.h>
#include <libgnomevfsmm/types.h>


namespace Gnome
{

namespace Vfs
{

class FileInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef FileInfo CppObjectType;
  typedef GnomeVFSFileInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  static Glib::RefPtr<FileInfo> create();

  // For use with Glib::RefPtr<> only.
  void reference()   const;
  void unreference() const;

  ///Provides access to the underlying C instance.
  GnomeVFSFileInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GnomeVFSFileInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GnomeVFSFileInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gnome::Vfs::FileInfo can neither be constructed nor deleted.
  FileInfo();
  void operator delete(void*, size_t);

private:
  // noncopyable
  FileInfo(const FileInfo&);
  FileInfo& operator=(const FileInfo&);


public:

  
  /** Clears the attributes so they are ready to accept new data.
   */
  void clear();
  
  /** Retrieve MIME type from this object.
   * @return A pointer to a string representing the MIME type.
   */
  Glib::ustring get_mime_type() const;
  
  /** Duplicates @a orig  and returns it.
   * @return A new file information struct that duplicates the information in @a orig .
   */
  Glib::RefPtr<FileInfo> duplicate();
  

  /** Get the name property of this FileInfo.
   * @return A string containing the name.
   */
  std::string get_name() const;

	/* Fields which are actually valid in this structure. */
//GnomeVFSFileInfoFields valid_fields;

  /** Get the file type of this FileInfo.
   * @return A FileType representing the file type.
   */
  FileType get_type() const;

  /** Get the permissions of this FileInfo.
   * @return A FilePermissions representing the permissions.
   */
  FilePermissions get_permissions() const;
  
  /** Get the special flags of this FileInfo.
   * @return A FileFlags representing the special flags.
   */
  FileFlags get_flags() const;

  /* These are only valid if `is_local' is TRUE (see below).  */
  //dev_t device;
  //GnomeVFSInodeNumber inode;


  /** Get the link count of this FileInfo.
   * @return The number of links.
   */
  guint get_link_count() const;
    
  /** Get the user id of this FileInfo.
   * @return The uid.
   */
  guint get_uid() const;
  
  /** Get the group id of this FileInfo.
   * @return The gid.
   */
  guint get_gid() const;
  
  /** Get the size of this FileInfo.
   * This is the size of the file in bytes.
   * @return The size.
   */
  FileSize get_size() const;
  
  /** Get the size of this FileInfo.
   * This is the size of the file measured in units of 512-byte blocks.
   * @return The size.
   */
  FileSize get_block_count() const;
  
  /** Get the I/O block size of this FileInfo.
   * This is used to determine the optimal block size for reading/writing the file.
   * @return The block size.
   */
  guint get_io_block_size() const;

  /** Get the access time of this FileInfo.
   * @return The time.
   */
  time_t get_access_time() const;
  
  /** Get the modification time of this FileInfo.
   * @return The time.
   */
  time_t get_modification_time() const;
  
  /** Get the creation time of this FileInfo.
   * @return The time.
   */
  time_t get_creation_time() const;

  /** Get the symlink name of this FileInfo.
   * @return If this FileInfo is a symlink, the file this FileInfo points to.
   */
  std::string get_symlink_name() const;
  
  /** Find out if this FileInfo is a symbolic link.
   * In order for this to work, this FileInfo must be created using FILE_INFO_FOLLOW_LINKS.
   * @return <tt>true</tt> if it is a sym link, otherwise <tt>false</tt>.
   */
  bool is_symlink() const;
          

};

} // namespace Vfs
} // namespace Gnome


namespace Gnome
{

namespace Vfs
{

/** @relates Gnome::Vfs::FileInfo
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator==(const FileInfo& lhs, const FileInfo& rhs);

/** @relates Gnome::Vfs::FileInfo
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator!=(const FileInfo& lhs, const FileInfo& rhs);


} // namespace Vfs

} // namespace Gnome


namespace Glib
{

  /** @relates Gnome::Vfs::FileInfo
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Vfs::FileInfo> wrap(GnomeVFSFileInfo* object, bool take_copy = false);

} // namespace Glib

#endif /* _LIBGNOMEVFSMM_FILE_INFO_H */

