/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome;
import org.gnu.glib.Type;
import org.gnu.gtk.Combo;
/**
 * The Entry widget accepts user input - once accepted, the entry
 * is included in the history of items previously entered. You can save
 * this history information so it can be restored the next time the
 * widget appears.
 * 
 * @deprecated
 */
public class Entry extends Combo {
	
	// reference to the gtk entry widget
	private org.gnu.gtk.Entry myEntry = null;
	
	// I changed this constructor to package level.  I did a quick search and
	// did not find classes in other java-gnome packages which needed access
	// to this constructor.  10/19/2002 PAC.
	/**
	 * Constructs an Entry object referencing an existing gnome Entry native
	 * resource.
	 * @param handle The handle to the gnome Entry widget.
	 */
	public Entry(int handle) {
	    setHandle(handle);
	}

	/**
	 * Constructs a new Entry object.
	 * @param historyID The unique Id used by gnome to save and load history
	 *                  list info.
	 */
	public Entry(String historyID) {
		setHandle(gnome_entry_new(historyID));
		initializeEventHandlers();
	}

	protected void noopInit() {
	}

	/**
	 * Add a string to the end of the list.
	 * @param text The string to append.
	 * @param save If true, the list will be saved to history after the append.
	 */
	public void appendHistory(String text, boolean save) {
		gnome_entry_append_history(getHandle(), save, text);
	}

	/**
	 * Clear the history list.
	 */
	public void clearHistory() {
		gnome_entry_clear_history(getHandle());
	}

	/**
	 * Gets the unique Id used by gnome to save and load history info.
	 */
	public String getHistoryID() {
		return gnome_entry_get_history_id(getHandle());
	}

	// The include file doesn't really say what max_saved does.
	public int getMaxSaved() {
		return gnome_entry_get_max_saved(getHandle());
	}

	/**
	 * Add a string to the beginning of the list.
	 * @param text The string to prepend.
	 * @param save If true, the list will be saved to history after the
	 *             prepend.
	 */
	public void prependHistory(String text, boolean save) {
		gnome_entry_prepend_history(getHandle(), save, text);
	}

	/**
	 * Sets the unique Id used by gnome to save and load history info.  This is
	 * usefull if you want to save and load history lists interactively.  No
	 * no need to create a new control with the appropriate historyID, just
	 * change it.
	 */
	public void setHistoryID(String historyID) {
		gnome_entry_set_history_id(getHandle(), historyID);
	}

	// The include file doesn't really say what max_saved does.
	public void setMaxSaved(int maxSaved) {
		gnome_entry_set_max_saved(getHandle(), maxSaved);
	}

	/**
	 * Return the Gtk Entry for this widget.
	 */
	public org.gnu.gtk.Entry getEntry() {
		if (null == myEntry) {
			myEntry = new org.gnu.gtk.Entry(gnome_entry_gtk_entry(getHandle())); 
		}
		return myEntry;
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_entry_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gnome_entry_get_type();
	native static final protected int gnome_entry_new(String historyId);
	native static final protected int gnome_entry_gtk_entry(int gentry);
	native static final protected void gnome_entry_set_history_id(int gentry, String historyId);
	native static final protected String gnome_entry_get_history_id(int gentry);
	native static final protected void gnome_entry_set_max_saved(int gentry, int maxSaved);
	native static final protected int gnome_entry_get_max_saved(int gentry);
	native static final protected void gnome_entry_prepend_history(int gentry, boolean save, String text);
	native static final protected void gnome_entry_append_history(int gentry, boolean save, String text);
	native static final protected void gnome_entry_clear_history(int gentry);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
