/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_IconTheme
#define _Included_org_gnu_gtk_IconTheme
#ifdef __cplusplus
extern "C" {
#endif
/*
 * Class:     org_gnu_gtk_IconTheme
 * Method:    gtk_icon_theme_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_IconTheme_gtk_1icon_1theme_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_icon_theme_get_type();
}

/*
 * Class:     org_gnu_gtk_IconTheme
 * Method:    gtk_icon_theme_new
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_IconTheme_gtk_1icon_1theme_1new
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_icon_theme_new();
}

/*
 * Class:     org_gnu_gtk_IconTheme
 * Method:    gtk_icon_theme_get_default
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_IconTheme_gtk_1icon_1theme_1get_1default
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_icon_theme_get_default();
}

/*
 * Class:     org_gnu_gtk_IconTheme
 * Method:    gtk_icon_theme_get_for_screen
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_IconTheme_gtk_1icon_1theme_1get_1for_1screen
  (JNIEnv *env, jclass cls, jint screen)
{
	return (jint)gtk_icon_theme_get_for_screen((GdkScreen*)screen);
}

/*
 * Class:     org_gnu_gtk_IconTheme
 * Method:    gtk_icon_theme_set_screen
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_IconTheme_gtk_1icon_1theme_1set_1screen
  (JNIEnv *env, jclass cls, jint itheme, jint screen)
{
	gtk_icon_theme_set_screen((GtkIconTheme*)itheme, (GdkScreen*)screen);
}

/*
 * Class:     org_gnu_gtk_IconTheme
 * Method:    gtk_icon_theme_set_search_path
 * Signature: (I[Ljava/lang/String;I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_IconTheme_gtk_1icon_1theme_1set_1search_1path
  (JNIEnv *env, jclass cls, jint itheme, jobjectArray path, jint numElements)
{
	const gchar** elements = g_malloc(sizeof(gchar*) * (gint)numElements);
	int index;
	jobject obj;
	
	for (index = 0; index < (gint)numElements; index++)
	{
		obj = (*env)->GetObjectArrayElement(env, path, index);
		elements[index] = (*env)->GetStringUTFChars(env, obj, NULL);
	}
	gtk_icon_theme_set_search_path((GtkIconTheme*)itheme, elements, (gint)numElements);
}

/*
 * Class:     org_gnu_gtk_IconTheme
 * Method:    gtk_icon_theme_get_search_path
 * Signature: (I)[Ljava/lang/String;
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_gtk_IconTheme_gtk_1icon_1theme_1get_1search_1path
  (JNIEnv *env, jclass cls, jint itheme)
{
	jobjectArray array;
	jclass strCls;
	gchar** path;
	int numElements;
	int index;
	
	gtk_icon_theme_get_search_path((GtkIconTheme*)itheme, &path, &numElements);
	strCls = (*env)->FindClass(env, "java/lang/String");
	array = (*env)->NewObjectArray(env, numElements, strCls, NULL);
	for (index = 0; index < numElements; index++) {
		(*env)->SetObjectArrayElement(env, array, index, (*env)->NewStringUTF(env, path[index]));
	}
	return array;
}

/*
 * Class:     org_gnu_gtk_IconTheme
 * Method:    gtk_icon_theme_append_search_path
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_IconTheme_gtk_1icon_1theme_1append_1search_1path
  (JNIEnv *env, jclass cls, jint itheme, jstring path)
{
	const gchar* p = (*env)->GetStringUTFChars(env, path, NULL);
	gtk_icon_theme_append_search_path((GtkIconTheme*)itheme, p);
	(*env)->ReleaseStringUTFChars(env, path, p);
}

/*
 * Class:     org_gnu_gtk_IconTheme
 * Method:    gtk_icon_theme_prepend_search_path
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_IconTheme_gtk_1icon_1theme_1prepend_1search_1path
  (JNIEnv *env, jclass cls, jint itheme, jstring path)
{
	const gchar* p = (*env)->GetStringUTFChars(env, path, NULL);
	gtk_icon_theme_prepend_search_path((GtkIconTheme*)itheme, p);
	(*env)->ReleaseStringUTFChars(env, path, p);
}

/*
 * Class:     org_gnu_gtk_IconTheme
 * Method:    gtk_icon_theme_set_custom_theme
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_IconTheme_gtk_1icon_1theme_1set_1custom_1theme
  (JNIEnv *env, jclass cls, jint itheme, jstring name)
{
	const gchar* p = (*env)->GetStringUTFChars(env, name, NULL);
	gtk_icon_theme_prepend_search_path((GtkIconTheme*)itheme, p);
	(*env)->ReleaseStringUTFChars(env, name, p);
}

/*
 * Class:     org_gnu_gtk_IconTheme
 * Method:    gtk_icon_theme_has_icon
 * Signature: (ILjava/lang/String;)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_IconTheme_gtk_1icon_1theme_1has_1icon
  (JNIEnv *env, jclass cls, jint itheme, jstring name)
{
	const gchar* p = (*env)->GetStringUTFChars(env, name, NULL);
	jboolean value = (jboolean)gtk_icon_theme_has_icon((GtkIconTheme*)itheme, p);
	(*env)->ReleaseStringUTFChars(env, name, p);
	return value;
}

/*
 * Class:     org_gnu_gtk_IconTheme
 * Method:    gtk_icon_theme_lookup_icon
 * Signature: (ILjava/lang/String;II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_IconTheme_gtk_1icon_1theme_1lookup_1icon
  (JNIEnv *env, jclass cls, jint itheme, jstring name, jint size, jint flags)
{
	const gchar* p = (*env)->GetStringUTFChars(env, name, NULL);
	return (jint)gtk_icon_theme_lookup_icon((GtkIconTheme*)itheme, p, (gint)size, (GtkIconLookupFlags)flags);
	(*env)->ReleaseStringUTFChars(env, name, p);
}

/*
 * Class:     org_gnu_gtk_IconTheme
 * Method:    gtk_icon_theme_load_icon
 * Signature: (ILjava/lang/String;II[I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_IconTheme_gtk_1icon_1theme_1load_1icon
  (JNIEnv *env, jclass cls, jint itheme, jstring name, jint size, jint flags, jintArray error)
{
	const gchar* p = (*env)->GetStringUTFChars(env, name, NULL);
	GError* e = (GError*)(*env)->GetIntArrayElements(env, error, NULL);
	jint value =  (jint)gtk_icon_theme_load_icon((GtkIconTheme*)itheme, p, (gint)size, (GtkIconLookupFlags)flags, &e);
	(*env)->ReleaseStringUTFChars(env, name, p);
	(*env)->ReleaseIntArrayElements(env, error, (jint*)e, 0);
	return value;
}

/*
 * Class:     org_gnu_gtk_IconTheme
 * Method:    gtk_icon_theme_list_icons
 * Signature: (ILjava/lang/String;)[Ljava/lang/String
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_gtk_IconTheme_gtk_1icon_1theme_1list_1icons
  (JNIEnv *env, jclass cls, jint itheme, jstring context)
{
	const gchar* p = (*env)->GetStringUTFChars(env, context, NULL);
	GList* list = gtk_icon_theme_list_icons((GtkIconTheme*)itheme, p);
	guint len;
	jobjectArray array;
	jclass strCls;
	int index;

	(*env)->ReleaseStringUTFChars(env, context, p);
 	if (NULL == list)
		return NULL;
	 len = g_list_length(list);
	strCls = (*env)->FindClass(env, "java/lang/String");
	array = (*env)->NewObjectArray(env, len, strCls, NULL);
	for (index = 0; index < len; index++) {
		GList *item = g_list_nth(list, index);
		(*env)->SetObjectArrayElement(env, array, index, (*env)->NewStringUTF(env, item->data));
	}
	return array;
}

/*
 * Class:     org_gnu_gtk_IconTheme
 * Method:    gtk_icon_theme_get_example_icon_name
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_IconTheme_gtk_1icon_1theme_1get_1example_1icon_1name
  (JNIEnv *env, jclass cls, jint itheme)
{
	gchar* name = gtk_icon_theme_get_example_icon_name((GtkIconTheme*)itheme);
	return (*env)->NewStringUTF(env, name);
}

/*
 * Class:     org_gnu_gtk_IconTheme
 * Method:    gtk_icon_theme_rescan_if_needed
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_IconTheme_gtk_1icon_1theme_1rescan_1if_1needed
  (JNIEnv *env, jclass cls, jint itheme)
{
	return (jboolean)gtk_icon_theme_rescan_if_needed((GtkIconTheme*)itheme);
}

/*
 * Class:     org_gnu_gtk_IconTheme
 * Method:    gtk_icon_theme_add_builtin_icon
 * Signature: (Ljava/lang/String;II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_IconTheme_gtk_1icon_1theme_1add_1builtin_1icon
  (JNIEnv *env, jclass cls, jstring name, jint size, jint pixbuf)
{
	const gchar* p = (*env)->GetStringUTFChars(env, name, NULL);
	gtk_icon_theme_add_builtin_icon(p, (gint)size, (GdkPixbuf*)pixbuf);
	(*env)->ReleaseStringUTFChars(env, name, p);
}

#ifdef __cplusplus
}
#endif
#endif
