/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_ToolItem
#define _Included_org_gnu_gtk_ToolItem
#ifdef __cplusplus
extern "C" {
#endif
/* Inaccessible static: evtMap */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024LifeCycleListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024FocusListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024KeyListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024MouseListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024DragDestinationListener */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024DragSourceListener */
/* Inaccessible static: evtMap */
/* Inaccessible static: class_00024org_00024gnu_00024gtk_00024event_00024ContainerListener */
/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_tool_item_get_type();
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_new
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1new
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_tool_item_new();
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_set_homogeneous
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1set_1homogeneous
  (JNIEnv *env, jclass cls, jint item, jboolean homo)
{
	gtk_tool_item_set_homogeneous((GtkToolItem*)item, (gboolean)homo);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_get_homogeneous
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1get_1homogeneous
  (JNIEnv *env, jclass cls, jint item)
{
	return (jboolean)gtk_tool_item_get_homogeneous((GtkToolItem*)item);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_set_expand
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1set_1expand
  (JNIEnv *env, jclass cls, jint item, jboolean expand)
{
	gtk_tool_item_set_expand((GtkToolItem*)item, (gboolean)expand);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_get_expand
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1get_1expand
  (JNIEnv *env, jclass cls, jint item)
{
	return (gboolean)gtk_tool_item_get_expand((GtkToolItem*)item);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_set_tooltip
 * Signature: (IILjava/lang/String;Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1set_1tooltip
  (JNIEnv *env, jclass cls, jint item, jint tip, jstring text, jstring private)
{
	const gchar* t = (*env)->GetStringUTFChars(env, text, NULL);
	const gchar* p = (*env)->GetStringUTFChars(env, private, NULL);
	gtk_tool_item_set_tooltip((GtkToolItem*)item, (GtkTooltips*)tip, t, p);
	(*env)->ReleaseStringUTFChars(env, text, t);
	(*env)->ReleaseStringUTFChars(env, private, p);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_set_use_drag_window
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1set_1use_1drag_1window
  (JNIEnv *env, jclass cls, jint item, jboolean drag)
{
	gtk_tool_item_set_use_drag_window((GtkToolItem*)item, (gboolean)drag);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_get_use_drag_window
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1get_1use_1drag_1window
  (JNIEnv *env, jclass cls, jint item)
{
	return (jboolean)gtk_tool_item_get_use_drag_window((GtkToolItem*)item);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_set_visible_horizontal
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1set_1visible_1horizontal
  (JNIEnv *env, jclass cls, jint item, jboolean visible)
{
	gtk_tool_item_set_visible_horizontal((GtkToolItem*)item, (gboolean)visible);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_get_visible_horizontal
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1get_1visible_1horizontal
  (JNIEnv *env, jclass cls, jint item)
{
	return (jboolean)gtk_tool_item_get_visible_horizontal((GtkToolItem*)item);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_set_visible_vertical
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1set_1visible_1vertical
  (JNIEnv *env, jclass cls, jint item, jboolean visible)
{
	gtk_tool_item_set_visible_vertical((GtkToolItem*)item, (gboolean)visible);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_get_visible_vertical
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1get_1visible_1vertical
  (JNIEnv *env, jclass cls, jint item)
{
	return (jboolean)gtk_tool_item_get_visible_vertical((GtkToolItem*)item);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_get_is_important
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1get_1is_1important
  (JNIEnv *env, jclass cls, jint item)
{
	return (jboolean)gtk_tool_item_get_is_important((GtkToolItem*)item);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_set_is_important
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1set_1is_1important
  (JNIEnv *env, jclass cls, jint item, jboolean important)
{
	gtk_tool_item_set_is_important((GtkToolItem*)item, (gboolean)important);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_get_icon_size
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1get_1icon_1size
  (JNIEnv *env, jclass cls, jint item)
{
	return (jint)gtk_tool_item_get_icon_size((GtkToolItem*)item);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_get_orientation
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1get_1orientation
  (JNIEnv *env, jclass cls, jint item)
{
	return (jint)gtk_tool_item_get_orientation((GtkToolItem*)item);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_get_toolbar_style
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1get_1toolbar_1style
  (JNIEnv *env, jclass cls, jint item)
{
	return (jint)gtk_tool_item_get_toolbar_style((GtkToolItem*)item);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_get_relief_style
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1get_1relief_1style
  (JNIEnv *env, jclass cls, jint item)
{
	return (jint)gtk_tool_item_get_relief_style((GtkToolItem*)item);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_retrieve_proxy_menu_item
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1retrieve_1proxy_1menu_1item
  (JNIEnv *env, jclass cls, jint item)
{
	return (jint)gtk_tool_item_retrieve_proxy_menu_item((GtkToolItem*)item);
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_get_proxy_menu_item
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1get_1proxy_1menu_1item
  (JNIEnv *env, jclass cls, jint item, jstring menuId)
{
	const gchar* m = (*env)->GetStringUTFChars(env, menuId, NULL);
	jint ret = (jint)gtk_tool_item_get_proxy_menu_item((GtkToolItem*)item, m);
	(*env)->ReleaseStringUTFChars(env, menuId, m);
	return ret;
}

/*
 * Class:     org_gnu_gtk_ToolItem
 * Method:    gtk_tool_item_set_proxy_menu_item
 * Signature: (ILjava/lang/String;I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToolItem_gtk_1tool_1item_1set_1proxy_1menu_1item
  (JNIEnv *env, jclass cls, jint item, jstring menuId, jint menuItem)
{
	const gchar* m = (*env)->GetStringUTFChars(env, menuId, NULL);
	gtk_tool_item_set_proxy_menu_item((GtkToolItem*)item, m, (GtkWidget*)menuItem);
	(*env)->ReleaseStringUTFChars(env, menuId, m);
}

#ifdef __cplusplus
}
#endif
#endif
