/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_ComboBox
#define _Included_org_gnu_gtk_ComboBox
#ifdef __cplusplus
extern "C" {
#endif
/* Inaccessible static: evtMap */
/* Inaccessible static: class_000240 */
/* Inaccessible static: class_000241 */
/* Inaccessible static: class_000242 */
/* Inaccessible static: class_000243 */
/* Inaccessible static: class_000244 */
/* Inaccessible static: class_000245 */
/* Inaccessible static: evtMap */
/* Inaccessible static: class_000240 */
/*
 * Class:     org_gnu_gtk_ComboBox
 * Method:    gtk_combo_box_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ComboBox_gtk_1combo_1box_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_combo_box_get_type();
}

/*
 * Class:     org_gnu_gtk_ComboBox
 * Method:    gtk_combo_box_new
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ComboBox_gtk_1combo_1box_1new
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_combo_box_new();
}

/*
 * Class:     org_gnu_gtk_ComboBox
 * Method:    gtk_combo_box_new_with_model
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ComboBox_gtk_1combo_1box_1new_1with_1model
  (JNIEnv *env, jclass cls, jint model)
{
	return (jint)gtk_combo_box_new_with_model((GtkTreeModel*)model);
}

/*
 * Class:     org_gnu_gtk_ComboBox
 * Method:    gtk_combo_box_set_wrap_width
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ComboBox_gtk_1combo_1box_1set_1wrap_1width
  (JNIEnv *env, jclass cls, jint combo, jint width)
{
	gtk_combo_box_set_wrap_width((GtkComboBox*)combo, (gint)width);
}

/*
 * Class:     org_gnu_gtk_ComboBox
 * Method:    gtk_combo_box_set_row_span_column
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ComboBox_gtk_1combo_1box_1set_1row_1span_1column
  (JNIEnv *env, jclass cls, jint combo, jint rowSpan)
{
	gtk_combo_box_set_row_span_column((GtkComboBox*)combo, (gint)rowSpan);
}

/*
 * Class:     org_gnu_gtk_ComboBox
 * Method:    gtk_combo_box_set_column_span_column
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ComboBox_gtk_1combo_1box_1set_1column_1span_1column
  (JNIEnv *env, jclass cls, jint combo, jint columnSpan)
{
	gtk_combo_box_set_column_span_column((GtkComboBox*)combo, (gint)columnSpan);
}

/*
 * Class:     org_gnu_gtk_ComboBox
 * Method:    gtk_combo_box_get_active
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ComboBox_gtk_1combo_1box_1get_1active
  (JNIEnv *env, jclass cls, jint combo)
{
	return (jint)gtk_combo_box_get_active((GtkComboBox*)combo);
}

/*
 * Class:     org_gnu_gtk_ComboBox
 * Method:    gtk_combo_box_set_active
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ComboBox_gtk_1combo_1box_1set_1active
  (JNIEnv *env, jclass cls, jint combo, jint index)
{
	gtk_combo_box_set_active((GtkComboBox*)combo, (gint)index);
}

/*
 * Class:     org_gnu_gtk_ComboBox
 * Method:    gtk_combo_box_get_active_iter
 * Signature: (I[I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_ComboBox_gtk_1combo_1box_1get_1active_1iter
  (JNIEnv *env, jclass cls, jint combo, jintArray iter)
{
	gint *i = (gint*)(*env)->GetIntArrayElements(env, iter, NULL);
	gboolean ret = gtk_combo_box_get_active_iter((GtkComboBox*)combo, (GtkTreeIter*)i);
	(*env)->ReleaseIntArrayElements(env, iter, (jint*)i, 0);
	return (jboolean)ret;
}

/*
 * Class:     org_gnu_gtk_ComboBox
 * Method:    gtk_combo_box_set_active_iter
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ComboBox_gtk_1combo_1box_1set_1active_1iter
  (JNIEnv *env, jclass cls, jint combo, jint iter)
{
	gtk_combo_box_set_active_iter((GtkComboBox*)combo, (GtkTreeIter*)iter);
}

/*
 * Class:     org_gnu_gtk_ComboBox
 * Method:    gtk_combo_box_set_model
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ComboBox_gtk_1combo_1box_1set_1model
  (JNIEnv *env, jclass cls, jint combo, jint model)
{
	gtk_combo_box_set_model((GtkComboBox*)combo, (GtkTreeModel*)model);
}

/*
 * Class:     org_gnu_gtk_ComboBox
 * Method:    gtk_combo_box_get_model
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ComboBox_gtk_1combo_1box_1get_1model
  (JNIEnv *env, jclass cls, jint combo)
{
	return (jint)gtk_combo_box_get_model((GtkComboBox*)combo);
}

/*
 * Class:     org_gnu_gtk_ComboBox
 * Method:    gtk_combo_box_new_text
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ComboBox_gtk_1combo_1box_1new_1text
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_combo_box_new_text();
}

/*
 * Class:     org_gnu_gtk_ComboBox
 * Method:    gtk_combo_box_append_text
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ComboBox_gtk_1combo_1box_1append_1text
  (JNIEnv *env, jclass cls, jint combo, jstring text)
{
	const gchar* t = (gchar*)(*env)->GetStringUTFChars(env, text, NULL);
	gtk_combo_box_append_text((GtkComboBox*)combo, t);
	(*env)->ReleaseStringUTFChars(env, text, t);
}

/*
 * Class:     org_gnu_gtk_ComboBox
 * Method:    gtk_combo_box_insert_text
 * Signature: (IILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ComboBox_gtk_1combo_1box_1insert_1text
  (JNIEnv *env, jclass cls, jint combo, int position, jstring text)
{
	const gchar* t = (gchar*)(*env)->GetStringUTFChars(env, text, NULL);
	gtk_combo_box_insert_text((GtkComboBox*)combo, (gint)position, t);
	(*env)->ReleaseStringUTFChars(env, text, t);
}

/*
 * Class:     org_gnu_gtk_ComboBox
 * Method:    gtk_combo_box_prepend_text
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ComboBox_gtk_1combo_1box_1prepend_1text
  (JNIEnv *env, jclass cls, jint combo, jstring text)
{
	const gchar* t = (gchar*)(*env)->GetStringUTFChars(env, text, NULL);
	gtk_combo_box_prepend_text((GtkComboBox*)combo, t);
	(*env)->ReleaseStringUTFChars(env, text, t);
}

/*
 * Class:     org_gnu_gtk_ComboBox
 * Method:    gtk_combo_box_remove_text
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ComboBox_gtk_1combo_1box_1remove_1text
  (JNIEnv *env, jclass cls, jint combo, jint position)
{
	gtk_combo_box_remove_text((GtkComboBox*)combo, position);
}

#ifdef __cplusplus
}
#endif
#endif
