// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_MENUITEM_H
#define _GTKMM_MENUITEM_H

#include <glibmm.h>

/* $Id: menuitem.hg,v 1.4 2003/11/17 18:19:00 murrayc Exp $ */


/* menuitem.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include <gtkmm/item.h>
#include <gtkmm/accelkey.h>
#include <gtkmm/accellabel.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkMenuItem GtkMenuItem;
typedef struct _GtkMenuItemClass GtkMenuItemClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class MenuItem_Class; } // namespace Gtk
namespace Gtk
{

class Menu;
namespace Menu_Helpers { class Element; }

/** Child item for menus.
 * Handle highlighting, alignment, events and submenus.
 * As it derives from Gtk::Bin it can hold any valid child widget, altough only a few are really useful.
 * @ingroup Widgets
 * @ingroup Menus
 */

class MenuItem : public Item
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef MenuItem CppObjectType;
  typedef MenuItem_Class CppClassType;
  typedef GtkMenuItem BaseObjectType;
  typedef GtkMenuItemClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~MenuItem();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class MenuItem_Class;
  static CppClassType menuitem_class_;

  // noncopyable
  MenuItem(const MenuItem&);
  MenuItem& operator=(const MenuItem&);

protected:
  explicit MenuItem(const Glib::ConstructParams& construct_params);
  explicit MenuItem(GtkMenuItem* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkMenuItem*       gobj()       { return reinterpret_cast<GtkMenuItem*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkMenuItem* gobj() const { return reinterpret_cast<GtkMenuItem*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_activate();
  virtual void on_activate_item();
  virtual void on_toggle_size_request(int* requisition);
  virtual void on_toggle_size_allocate(int allocation);


private:

public:

  /// Create an empty menu item
  MenuItem();

  /// Create a menu item with widget
  explicit MenuItem(Widget& widget);

  /// Create a menu item with label
  explicit MenuItem(const Glib::ustring& label, bool mnemonic = false);

  
  void set_submenu(Menu& submenu);
  
  Menu* get_submenu();
  
  const Menu* get_submenu() const;
  bool has_submenu() const;

  
  void remove_submenu();
  
  void select();
  
  void deselect();
  
  void activate();
  
  void toggle_size_request(int& requisition);
  
  void toggle_size_allocate(int allocation);
  
  void set_right_justified(bool right_justified = true);
  
  bool get_right_justified() const;
  
  void set_accel_path(const Glib::ustring& accel_path);
  void unset_accel_path();

  
  /**
   * @par Prototype:
   * <tt>void %activate()</tt>
   */
  Glib::SignalProxy0< void > signal_activate();

  
  /**
   * @par Prototype:
   * <tt>void %activate_item()</tt>
   */
  Glib::SignalProxy0< void > signal_activate_item();

  
  /**
   * @par Prototype:
   * <tt>void %toggle_size_request(int* requisition)</tt>
   */
  Glib::SignalProxy1< void,int* > signal_toggle_size_request();

  
  /**
   * @par Prototype:
   * <tt>void %toggle_size_allocate(int allocation)</tt>
   */
  Glib::SignalProxy1< void,int > signal_toggle_size_allocate();


  void accelerate(Window& window);

protected:

  void add_accel_label(const Glib::ustring& label, bool mnemonic = true);

  void set_accel_key(const AccelKey& accel_key);

private:

  friend class Menu_Helpers::Element;

  //This data is set by MenuElem, and will be used in on_realize(), in the call to add_accelerator().
  AccelKey accel_key_;


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::MenuItem */
  Gtk::MenuItem* wrap(GtkMenuItem* object, bool take_copy = false);
}
#endif /* _GTKMM_MENUITEM_H */

