/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-07-31 13:44:40 EDT
 */

package org.gnu.pango;
import org.gnu.glib.GObject;
/**
 * The PangoAttrList structure represents a list of attributes that apply to a
 * section of text. The attributes are, in general, allowed to overlap in an
 * arbitrary fashion, however, if the attributes are manipulated only through
 * pango_attr_list_change(), the overlap between properties will meet stricter
 * criteria.
 *
 * <p>Since the PangoAttrList structure is stored as a linear list, it is not
 * suitable for storing attributes for large amounts of text. In general, you
 * should not use a single PangoAttrList for more than one paragraph of text.
 */
public class AttrList extends GObject 
{

	protected AttrList(int handle){
		this.handle = handle;
	}
	
	/**
	 * Construct a new AttrList.
	 */
	public AttrList() {
		handle = pango_attr_list_new();
	}
	
	/**
	 * Insert the given attribute into the list.  It will be inserted after all
	 * other attributes with a matching <i>start_index</i>.
	 */
	public void insert(Attribute attr) {
		pango_attr_list_insert(handle, attr.getHandle());
	}
	
	/**
	 * Insert the given attribute into the list.  It will be inserted before all
	 * other attributes with a matching <i>start_index</i>.
	 */
	public void insertBefore(Attribute attr) {
		pango_attr_list_insert_before(handle, attr.getHandle());
	}
	
	/**	
	 * Insert the given attribute into the list.  It will replace any attribute
	 * of the same type on that segment and be merged with any adjoining attributes
	 * that are identical.
	 */
	public void change(Attribute attr) {
		pango_attr_list_change(handle, attr.getHandle());
	}
	
	/**
	 * Splice on list into another.
	 * 
	 * @param other The other AttrList to splice in the current one.
	 * @param pos The position at which to insert.
	 * @param len The length of the spliced segment.
	 */
	public void splice(AttrList other, int pos, int len) {
		pango_attr_list_splice(handle, other.getHandle(), pos, len);
	}
	
	/**
	 * Create an iterator pointing at the beginning of the list.
	 */
	public AttrIterator getIterator() {
		return new AttrIterator(pango_attr_list_get_iterator(handle));
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int pango_attr_list_get_type ();
    native static final protected int pango_attr_list_new ();
    native static final protected void pango_attr_list_ref (int list);
    native static final protected void pango_attr_list_unref (int list);
    native static final protected int pango_attr_list_copy (int list);
    native static final protected void pango_attr_list_insert (int list, int attr);
    native static final protected void pango_attr_list_insert_before (int list, int attr);
    native static final protected void pango_attr_list_change (int list, int attr);
    native static final protected void pango_attr_list_splice (int list, int other, int pos, int 
        len);
    native static final protected int pango_attr_list_get_iterator (int list);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

