/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gnome;

import org.gnu.gtk.Dialog;

/**
 */
public class PasswordDialog extends Dialog {
	
	/**
	 * Construct a new PasswordDialog widget
	 * @param title The title for the dialog.
	 * @param message A message that is displayed on the dialog.
	 * @param username The username to set in the username entry widget.
	 * @param password The password to set in the password entry widget.
	 * @param readonlyUsername Is the username editable?
	 */
	public PasswordDialog(String title, String message, String username, String password, boolean readonlyUsername) {
		handle = gnome_password_dialog_new(title, message, username, password, readonlyUsername);
		initializeEventHandlers();
	}
	
	public boolean runAndBlock() {
		return gnome_password_dialog_run_and_block(handle);
	}
	
	public void setUsername(String username) {
		gnome_password_dialog_set_username(handle, username);
	}
	
	public String getUsername() {
		return gnome_password_dialog_get_username(handle);
	}
	
	public void setPassword(String password) {
		gnome_password_dialog_set_password(handle, password);
	}
	
	public String getPassword() {
		return gnome_password_dialog_get_password(handle);
	}
	
	public void setReadonlyUsername(boolean readonly) {
		gnome_password_dialog_set_readonly_username(handle, readonly);
	}
	
	public void setRemember(boolean remember) {
		gnome_password_dialog_set_remember(handle, remember);
	}
	
	public boolean getRemember() {
		return gnome_password_dialog_get_remember(handle);
	}
	
	public void setRememberLabelText(String labelText) {
		gnome_password_dialog_set_remember_label_text(handle, labelText);
	}

	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gnome_password_dialog_get_type();
	native static final protected int gnome_password_dialog_new(String title, String message, String username, String password, boolean readonlyUsername);
	native static final protected boolean gnome_password_dialog_run_and_block(int dialog);
	native static final protected void gnome_password_dialog_set_username(int dialog, String username);
	native static final protected void gnome_password_dialog_set_password(int dialog, String password);
	native static final protected void gnome_password_dialog_set_readonly_username(int dialog, boolean readonly);
	native static final protected void gnome_password_dialog_set_remember(int dialog, boolean remember);
	native static final protected void gnome_password_dialog_set_remember_label_text(int dialog, String labelText);
	native static final protected String gnome_password_dialog_get_username(int dialog);
	native static final protected String gnome_password_dialog_get_password(int dialog);
	native static final protected boolean gnome_password_dialog_get_remember(int dialog);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
	
}
