// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_WINDOW_H
#define _GTKMM_WINDOW_H

#include <glibmm.h>

/* $Id: window.hg,v 1.10 2003/11/05 17:21:28 murrayc Exp $ */

/* window.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include <glibmm/object.h>
#include <glibmm/listhandle.h>
#include <gtkmm/bin.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkWindow GtkWindow;
typedef struct _GtkWindowClass GtkWindowClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Window_Class; } // namespace Gtk
#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkWindowGroup GtkWindowGroup;
typedef struct _GtkWindowGroupClass GtkWindowGroupClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class WindowGroup_Class; } // namespace Gtk
namespace Gtk
{

class AccelGroup;
class WindowGroup;


/** Toplevel Window
 * This represents all widgets which are physical windows controlled
 * by the window manager.
 *
 * The window will be hidden when the window manager's close button is clicked. Override on_delete_event() to stop this.
 *
 * Gtk::manage() has no effect on Windows because they have no parent Containers.
 * @ingroup Widgets
 */

class Window : public Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Window CppObjectType;
  typedef Window_Class CppClassType;
  typedef GtkWindow BaseObjectType;
  typedef GtkWindowClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Window();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Window_Class;
  static CppClassType window_class_;

  // noncopyable
  Window(const Window&);
  Window& operator=(const Window&);

protected:
  explicit Window(const Glib::ConstructParams& construct_params);
  explicit Window(GtkWindow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkWindow*       gobj()       { return reinterpret_cast<GtkWindow*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkWindow* gobj() const { return reinterpret_cast<GtkWindow*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_set_focus(Widget* focus);
  virtual bool on_frame_event(GdkEvent* event);


private:

  
public:
   explicit Window(WindowType type = WINDOW_TOPLEVEL);

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<Glib::ustring> property_title();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<bool> property_allow_shrink();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<bool> property_allow_grow();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<bool> property_resizable();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<bool> property_modal();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<WindowPosition> property_window_position();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<int> property_default_width();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<int> property_default_height();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<bool> property_destroy_with_parent();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > property_icon();

  
  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy< Glib::RefPtr<Gdk::Screen> > property_screen();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy_ReadOnly<bool> property_is_active();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy_ReadOnly<bool> property_has_toplevel_focus();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<GdkWindowTypeHint> property_type_hint();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<bool> property_skip_taskbar_hint();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<bool> property_skip_pager_hint();
      
  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<bool> property_decorated();

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<Gdk::Gravity> property_gravity();


  bool is_toplevel() const;
  bool is_dialog() const;
  bool is_popup() const;

  WindowType get_window_type() const;

  //: This is special to the GTK+ linux-fb port.
  Glib::RefPtr<Gdk::Window> get_frame();
  Glib::RefPtr<const Gdk::Window> get_frame() const;


  /**
   * @par Prototype:
   * <tt>void %set_focus(Widget* focus)</tt>
   */
  Glib::SignalProxy1< void,Widget* > signal_set_focus();

  
  /**
   * @par Prototype:
   * <tt>bool %frame_event(GdkEvent* event)</tt>
   */
  Glib::SignalProxy1< bool,GdkEvent* > signal_frame_event();


  //Keybinding signals:
  
  
  void set_title(const Glib::ustring& title);

  
  Glib::ustring get_title() const;

  
  void set_wmclass(const Glib::ustring& wmclass_name,
                                const Glib::ustring& wmclass_class);

  
  void set_role(const Glib::ustring& role);

  //: Returns the role of the window.
  //- See {set_role()} for further explanation.
  
  Glib::ustring get_role() const;


  void add_accel_group(const Glib::RefPtr<AccelGroup>& accel_group);

  
  void remove_accel_group(const Glib::RefPtr<AccelGroup>& accel_group);

  
  void set_position(WindowPosition position);

  
  bool activate_focus();

  
  void set_focus(Gtk::Widget& focus);
  void unset_focus();
  
  
  Widget* get_focus();
  
  const Widget* get_focus() const;
  
  void set_default(Gtk::Widget& defaultw);
  void unset_default();
 
  
  bool activate_default();

  
  void set_transient_for(Window& parent);

  
  Window* get_transient_for();
  
  const Window* get_transient_for() const;

  
  void set_type_hint(Gdk::WindowTypeHint hint);

  
  Gdk::WindowTypeHint get_type_hint() const;

  
  void set_skip_taskbar_hint(bool setting = true);
  
  bool get_skip_taskbar_hint() const;

  
  void set_skip_pager_hint(bool setting = true);
  
  bool get_skip_pager_hint() const;

  //_WRAP_METHOD(void set_destroy_with_parent(bool setting = true), gtk_window_set_destroy_with_parent)
  // I don't that that this is ever a good thing for C++.murrayc.

  
  bool get_destroy_with_parent() const;
  // I don't that that this is ever a good thing for C++.murrayc.

  
  void set_resizable(bool resizeable = true);

  
  bool get_resizable() const;

  
  void set_gravity(Gdk::Gravity gravity);

  
  Gdk::Gravity get_gravity() const;

  
  void set_geometry_hints(Widget& geometry_widget,
                                       const Gdk::Geometry& geometry,
                                       Gdk::WindowHints geom_mask);

  
  void set_screen(const Glib::RefPtr<Gdk::Screen>& screen);

  
  Glib::RefPtr<Gdk::Screen> get_screen();
  
  Glib::RefPtr<const Gdk::Screen> get_screen() const;


  void set_has_frame(bool setting = true);

  
  bool get_has_frame() const;

  
  void set_frame_dimensions(int left,  int top,
                                         int right, int bottom);

  
  void get_frame_dimensions(int& left,  int& top,
                                         int& right, int& bottom) const;

  
  void set_decorated(bool setting = true);
  
  bool get_decorated() const;


  Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> > get_icon_list() const;

  
  void set_icon_list(const Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> >& list);

  
  void set_icon(const Glib::RefPtr<Gdk::Pixbuf>& icon);


  bool set_icon_from_file(const std::string& filename);

  
  Glib::RefPtr<Gdk::Pixbuf> get_icon() const;

  
  static void set_default_icon_list(
                   const Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> >& list);

  
  static Glib::ListHandle< Glib::RefPtr<Gdk::Pixbuf> > get_default_icon_list();

  
  static bool set_default_icon_from_file(const std::string& filename);
  
  static void set_auto_startup_notification(bool setting = true);

  
  void set_modal(bool modal = true);

  
  bool get_modal() const;


  static Glib::ListHandle<Window*> list_toplevels();


  void add_mnemonic(guint keyval, Widget& target);

  
  void remove_mnemonic(guint keyval, Widget& target);

  
  bool mnemonic_activate(guint keyval, Gdk::ModifierType modifier);

  
  void set_mnemonic_modifier(Gdk::ModifierType modifier);

  
  Gdk::ModifierType get_mnemonic_modifier();


  void present();

  
  void iconify();
  
  void deiconify();

  
  void stick();
  
  void unstick();

  
  void maximize();
  
  void unmaximize();

  
  void fullscreen();
  
  void unfullscreen();

  
  void begin_resize_drag(Gdk::WindowEdge edge,
                   int button, int root_x, int root_y, guint32 timestamp);

  
  void begin_move_drag(
                   int button, int root_x, int root_y, guint32 timestamp);

  
  void set_default_size(int width, int height);

  
  void get_default_size(int& width, int& height) const;

  
  void resize(int width, int height);

  
  void get_size(int& width, int& height) const;


  void move(int x, int y);

  
  void get_position(int& root_x, int& root_y) const;

  
  bool parse_geometry(const Glib::ustring& geometry);

  
  void reshow_with_initial_size();


  static void set_default_icon(const Glib::RefPtr<Gdk::Pixbuf>& icon);
  
  void set_keep_above(bool setting = true);
  
  void set_keep_below(bool setting = true);

  
  /** Returns a default accel group for this window
   * This is a gtkmm-specific function.  This accel group can not
   * be removed.
   */
  Glib::RefPtr<AccelGroup> get_accel_group();

  /** Brings the window to the front.
   * This is just a more obvious convenience wrapper for get_window()->raise().
   */
  virtual void raise();

  ///Overriden to warn that it doesn't make sense to use Gtk::manage() on this class because it has no parent container.
  virtual void set_manage();

protected:

  //See comments in the implementations:
  void destroy_();
  void _destroy_c_instance();

private:

  //We'll create an accel_group if it's requested, and remember it.
  //Otherwise, you'd have to create it, add it to the window, then remember it somewhere else while you add it to other widgets.
  Glib::RefPtr<AccelGroup> accel_group_;


};


class WindowGroup : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef WindowGroup CppObjectType;
  typedef WindowGroup_Class CppClassType;
  typedef GtkWindowGroup BaseObjectType;
  typedef GtkWindowGroupClass BaseClassType;

private:  friend class WindowGroup_Class;
  static CppClassType windowgroup_class_;

private:
  // noncopyable
  WindowGroup(const WindowGroup&);
  WindowGroup& operator=(const WindowGroup&);

protected:
  explicit WindowGroup(const Glib::ConstructParams& construct_params);
  explicit WindowGroup(GtkWindowGroup* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~WindowGroup();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkWindowGroup*       gobj()       { return reinterpret_cast<GtkWindowGroup*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkWindowGroup* gobj() const { return reinterpret_cast<GtkWindowGroup*>(gobject_); }

  GtkWindowGroup* gobj_copy();

private:


protected:
  WindowGroup();

public:
  
  static Glib::RefPtr<WindowGroup> create();


  void add_window(Window& window);
  
  void remove_window(Window& window);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::Window */
  Gtk::Window* wrap(GtkWindow* object, bool take_copy = false);
}

namespace Glib
{
  /** @relates Gtk::WindowGroup */
  Glib::RefPtr<Gtk::WindowGroup> wrap(GtkWindowGroup* object, bool take_copy = false);
}


#endif /* _GTKMM_WINDOW_H */

