// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_MENU_H
#define _GTKMM_MENU_H

#include <glibmm.h>

/* $Id: menu.hg,v 1.4 2003/12/09 06:42:51 murrayc Exp $ */

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <gtk/gtkmenu.h>
#include <gtkmm/menushell.h>
#include <gtkmm/menuitem.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkMenu GtkMenu;
typedef struct _GtkMenuClass GtkMenuClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Menu_Class; } // namespace Gtk
namespace Gtk
{

class AccelGroup;

/** @defgroup Menus Menu classes
 */

/** A drop-down menu consisting of Gtk::MenuItem objects which can be navigated and activated by the user to perform application functions.
 * Menus are normally placed inside a Gtk::MenuBar or another MenuItem as a sub menu.
 * A Menu can also be popped up, for instance as a right-click context menu, by calling the popup() method.
 * See also Gtk::OptionMenu.
 * @ingroup Widgets
 * @ingroup Menus
 */

class Menu : public MenuShell
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Menu CppObjectType;
  typedef Menu_Class CppClassType;
  typedef GtkMenu BaseObjectType;
  typedef GtkMenuClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Menu();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Menu_Class;
  static CppClassType menu_class_;

  // noncopyable
  Menu(const Menu&);
  Menu& operator=(const Menu&);

protected:
  explicit Menu(const Glib::ConstructParams& construct_params);
  explicit Menu(GtkMenu* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkMenu*       gobj()       { return reinterpret_cast<GtkMenu*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkMenu* gobj() const { return reinterpret_cast<GtkMenu*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

  
   //deprecated.
public:
  Menu();

/* append, prepend, and insert are defined in MenuShell */

  
  void popup(MenuShell& parent_menu_shell, MenuItem& parent_menu_item, GtkMenuPositionFunc func, gpointer data, guint button, guint32 activate_time);

  ///void on_menu_position(int&, int&, bool& push_in);
  typedef SigC::Slot3<void, int&, int&, bool&> SlotPositionCalc;

  /// Displays a menu and makes it available for selection.
  void popup(const SlotPositionCalc& position_calc_slot, guint button, guint32 activate_time);

  /** Displays a menu and makes it available for selection.
   * Applications can use this function to display context-sensitive menus.
   * The default menu positioning function will position the menu at the current pointer position.
   * @param button The button which was pressed to initiate the event.
   * @param activate_time The time at which the activation event occurred.
   */
  void popup(guint button, guint32 activate_time);

  
  void reposition();

  
  void popdown();

  
  MenuItem* get_active();
  
  const MenuItem* get_active() const;
  
  void set_active(guint index);

  
  void set_accel_group(const Glib::RefPtr<AccelGroup>& accel_group);
  void unset_accel_group();
  
  Glib::RefPtr<AccelGroup> get_accel_group();

  
  void set_accel_path(const Glib::ustring& accel_path);

  
  void detach();
  
  Widget* get_attach_widget();
  
  const Widget* get_attach_widget() const;

  
  void set_tearoff_state(bool torn_off = true);
  
  bool get_tearoff_state() const;

  
  void set_title(const Glib::ustring& title);
  void unset_title();
  
  Glib::ustring get_title() const;
  
  void set_screen(const Glib::RefPtr<Gdk::Screen>& screen);

  
  void attach(Gtk::Widget& child, guint left_attach, guint right_attach, guint top_attach, guint bottom_attach);

  
  void set_monitor(int monitor_num);
  
  void reorder_child(const MenuItem& child, int position);
  

  /**
 * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
 * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
 * the value of the property changes.
 */
Glib::PropertyProxy<Glib::ustring> property_tearoff_title();


protected:
  
  void attach_to_widget(Widget& widget, GtkMenuDetachFunc detacher);


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::Menu */
  Gtk::Menu* wrap(GtkMenu* object, bool take_copy = false);
}
#endif /* _GTKMM_MENU_H */

