// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TOOLBAR_H
#define _GTKMM_TOOLBAR_H

#include <gtkmmconfig.h>


#include <glibmm.h>

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

 // This is for including the config header before any code (such as
// the #ifndef GTKMM_DISABLE_DEPRECATED in deprecated classes) is generated:


#include <gtkmm/toolitem.h>
#include <gtkmm/toolbutton.h>
#include <gtkmm/toggletoolbutton.h>
#include <glibmm/helperlist.h>
#include <gtkmm/container.h>
#include <gtkmm/stockid.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkToolbar GtkToolbar;
typedef struct _GtkToolbarClass GtkToolbarClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Toolbar_Class; } // namespace Gtk
namespace Gtk
{

//TODO: Derive from Toolshell when we can break ABI.
/** Bars of buttons and other widgets.
 * @ingroup Widgets
 * @ingroup Containers
 * @ingroup Toolbars
 */

class Toolbar : public Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Toolbar CppObjectType;
  typedef Toolbar_Class CppClassType;
  typedef GtkToolbar BaseObjectType;
  typedef GtkToolbarClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Toolbar();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Toolbar_Class;
  static CppClassType toolbar_class_;

  // noncopyable
  Toolbar(const Toolbar&);
  Toolbar& operator=(const Toolbar&);

protected:
  explicit Toolbar(const Glib::ConstructParams& construct_params);
  explicit Toolbar(GtkToolbar* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkToolbar*       gobj()       { return reinterpret_cast<GtkToolbar*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkToolbar* gobj() const { return reinterpret_cast<GtkToolbar*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_orientation_changed(Orientation orientation);
  virtual void on_toolbar_style_changed(ToolbarStyle style);
  virtual bool on_popup_context_menu(int x, int y, int button_number);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:
  Toolbar();

  
  /** Insert a Gtk::ToolItem into the toolbar at position @a pos. If @a pos is
   * 0 the item is prepended to the start of the toolbar. If @a pos is
   * negative, the item is appended to the end of the toolbar.
   * 
   * @newin{2,4}
   * @param item A Gtk::ToolItem.
   * @param pos The position of the new item.
   */
  void insert(ToolItem& item, int pos);
  void insert(ToolButton& item, int pos, const sigc::slot<void>& clicked_slot);
  void insert(ToggleToolButton& item, int pos, const sigc::slot<void>& toggled_slot);

  void append(ToolItem& item);
  void append(ToolButton& item, const sigc::slot<void>& clicked_slot);
  void append(ToggleToolButton& item, const sigc::slot<void>& toggled_slot);

  void prepend(ToolItem& item);
  void prepend(ToolButton& item, const sigc::slot<void>& clicked_slot);
  void prepend(ToggleToolButton& item, const sigc::slot<void>& toggled_slot);

  
  /** Return value: the position of item on the toolbar.
   * @param item A Gtk::ToolItem that is a child of @a toolbar.
   * @return The position of item on the toolbar.
   * 
   * @newin{2,4}.
   */
  int get_item_index(const ToolItem& item) const;
  
  /** Return value: the number of items on the toolbar
   * @return The number of items on the toolbar
   * 
   * @newin{2,4}.
   */
  int get_n_items() const;
  
  /** Return value: The @a n<!-- -->'th Gtk::ToolItem on @a toolbar, or <tt>0</tt> if there
   * @param n A position on the toolbar.
   * @return The @a n<!-- -->'th Gtk::ToolItem on @a toolbar, or <tt>0</tt> if there
   * isn't an @a n<!-- -->'th item.
   * 
   * @newin{2,4}.
   */
  ToolItem* get_nth_item(int n);
  
  /** Return value: The @a n<!-- -->'th Gtk::ToolItem on @a toolbar, or <tt>0</tt> if there
   * @param n A position on the toolbar.
   * @return The @a n<!-- -->'th Gtk::ToolItem on @a toolbar, or <tt>0</tt> if there
   * isn't an @a n<!-- -->'th item.
   * 
   * @newin{2,4}.
   */
  const ToolItem* get_nth_item(int n) const;
  
  /** Return value: <tt>true</tt> if the toolbar has an overflow menu.
   * @return <tt>true</tt> if the toolbar has an overflow menu.
   * 
   * @newin{2,4}.
   */
  bool get_show_arrow() const;
  
  /** Sets whether to show an overflow menu when
   *  @a toolbar doesn't have room for all items on it. If <tt>true</tt>,
   * items that there are not room are available through an
   * overflow menu.
   * 
   * @newin{2,4}
   * @param show_arrow Whether to show an overflow menu.
   */
  void set_show_arrow(bool show_arrow = true);

/* Style methods */

  // TODO: Remove these when we derive from ToolShell, which has the same methods:
  
  /** Sets whether a toolbar should appear horizontally or vertically.
   * 
   * Deprecated: 2.16: Use Gtk::Orientable::set_orientation() instead.
   * @param orientation A new Gtk::Orientation.
   */
  void set_orientation(Orientation orientation);
  
  /** Retrieves the current orientation of the toolbar. See
   * set_orientation().
   * @return The orientation
   * 
   * Deprecated: 2.16: Use Gtk::Orientable::get_orientation() instead.
   */
  Orientation get_orientation() const;

  
  /** Alters the view of @a toolbar to display either icons only, text only, or both.
   * @param style The new style for @a toolbar.
   */
  void set_toolbar_style(ToolbarStyle style);
  
  /** Retrieves whether the toolbar has text, icons, or both . See
   * set_style().
   * @return The current style of @a toolbar.
   */
  ToolbarStyle get_toolbar_style() const;

  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Sets if the tooltips of a toolbar should be active or not.
   * 
   * Deprecated: 2.14: The toolkit-wide Gtk::Settings:gtk-enable-tooltips property
   * is now used instead.
   * @deprecated Use The toolkit-wide Gtk::Settings::property_gtk_enable_tooltips instead
   * @param enable Set to <tt>false</tt> to disable the tooltips, or <tt>true</tt> to enable them.
   */
  void set_tooltips(bool enable = true);
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

  /** Retrieves whether tooltips are enabled. See
   * set_tooltips().
   * @deprecated Use The toolkit-wide Gtk::Settings::property_gtk_enable_tooltips instead
   * @return <tt>true</tt> if tooltips are enabled
   * 
   * Deprecated: 2.14: The toolkit-wide Gtk::Settings:gtk-enable-tooltips property
   * is now used instead.
   */
  bool get_tooltips() const;
#endif // GTKMM_DISABLE_DEPRECATED


  /** Unsets a toolbar style set with set_style(), so that
   * user preferences will be used to determine the toolbar style.
   */
  void unset_toolbar_style();

  //Note that gtk_toolbar_set_icon_size() and gtk_toolbar_unset_icon_size() were
  //deprecated sometime before GTK+ 2.4, but were undeprecated in GTK+ 2.12.
  
  /** This function sets the size of stock icons in the toolbar. You
   * can call it both before you add the icons and after they've been
   * added. The size you set will override user preferences for the default
   * icon size.
   * 
   * This should only be used for special-purpose toolbars, normal
   * application toolbars should respect the user preferences for the
   * size of icons.
   * 
   * @newin{2,12}
   * @param icon_size The Gtk::IconSize that stock icons in the toolbar shall have.
   */
  void set_icon_size(IconSize icon_size);
  
  /** Unsets toolbar icon size set with set_icon_size(), so that
   * user preferences will be used to determine the icon size.
   * 
   * @newin{2,12}
   */
  void unset_icon_size();

  
  /** Retrieves the icon size for the toolbar. See set_icon_size().
   * @return (type int): the current icon size for the icons on
   * the toolbar.
   */
  IconSize get_icon_size() const;

  
  /** Return value: The relief style of buttons on @a toolbar.
   * @return The relief style of buttons on @a toolbar.
   * 
   * @newin{2,4}.
   */
  ReliefStyle get_relief_style() const;
  
  /** Return value: The position corresponding to the point ( @a x, @a y) on the toolbar.
   * @param x X coordinate of a point on the toolbar.
   * @param y Y coordinate of a point on the toolbar.
   * @return The position corresponding to the point ( @a x, @a y) on the toolbar.
   * 
   * @newin{2,4}.
   */
  int get_drop_index(int x, int y) const;
  
  /** Highlights @a toolbar to give an idea of what it would look like
   * if @a item was added to @a toolbar at the position indicated by @a index.
   * If @a item is <tt>0</tt>, highlighting is turned off. In that case @a index 
   * is ignored.
   * 
   * The @a tool_item passed to this function must not be part of any widget
   * hierarchy. When an item is set as drop highlight item it can not
   * added to any widget hierarchy or used as highlight item for another
   * toolbar.
   * 
   * @newin{2,4}
   * @param tool_item (allow-none): a Gtk::ToolItem, or <tt>0</tt> to turn of highlighting.
   * @param index A position on @a toolbar.
   */
  void set_drop_highlight_item(ToolItem& tool_item, int index);
  void unset_drop_highlight_item();

  /** Emitted when the orientation of the toolbar changes.
   *
   * @param orientation The new Orientation of the toolbar.
   *
   * @par Prototype:
   * <tt>void on_my_%orientation_changed(Orientation orientation)</tt>
   */

  Glib::SignalProxy1< void,Orientation > signal_orientation_changed();


  /** Emitted when the style of the toolbar changes.
   *
   * @param @style The new ToolbarStyle of the toolbar.
   *
   * @par Prototype:
   * <tt>void on_my_%toolbar_style_changed(ToolbarStyle style)</tt>
   */

  Glib::SignalProxy1< void,ToolbarStyle > signal_toolbar_style_changed();


  /** Emitted when the user right-clicks the toolbar or uses the
   * keybinding to display a popup menu.
   *
   * Application developers should handle this signal if they want
   * to display a context menu on the toolbar. The context-menu should
   * appear at the coordinates given by @a x and @a y. The mouse button
   * number is given by the @a button parameter. If the menu was popped
   * up using the keybaord, @a button is -1.
   *
   * @param x The x coordinate of the point where the menu should appear.
   * @param y The y coordinate of the point where the menu should appear.
   * @param button The mouse button the user pressed, or -1
   * @resultt true if the signal was handled, false if not.
   *
   * @par Prototype:
   * <tt>bool on_my_%popup_context_menu(int x, int y, int button_number)</tt>
   */

  Glib::SignalProxy3< bool,int,int,int > signal_popup_context_menu();


  #ifndef GTKMM_DISABLE_DEPRECATED
  //This was called get_tooltips_object() to avoid a clash with get_tooltips(), which just says whether they are enabled.
  ///@deprecated Use the Gtk::Tooltip API instead.
  Tooltips* get_tooltips_object() const;
  #endif //GTKMM_DISABLE_DEPRECATED

  //This is probably the same as Container::children().size(), which is deprecated anyway?
  //_MEMBER_GET(num_children, num_children, int, gint)

  //There is already set/get_orientation():
  //_MEMBER_GET(orientation, orientation, GtkOrientation, Orientation)

  //There is already set/get_toolbar_style():
  //_MEMBER_GET(style, style, GtkToolbarStyle, ToolbarStyle)

  //There is already set/get_icon_size():
  //_MEMBER_GET(icon_size, icon_size, int, gint)

  //Ignore deprecated GtkToolbarAPI:
  //Normally we just deprecate it in gtkmm too,
  //but the GtkToolbar compatibility system is particularly unpleasant, so we just removed it in gtkmm 2.4. murrayc.
  

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The orientation of the orientable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Orientation> property_orientation() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The orientation of the orientable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Orientation> property_orientation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** How to draw the toolbar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<ToolbarStyle> property_toolbar_style() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** How to draw the toolbar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ToolbarStyle> property_toolbar_style() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If an arrow should be shown if the toolbar doesn't fit.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_arrow() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If an arrow should be shown if the toolbar doesn't fit.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_arrow() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Toolbar
   */
  Gtk::Toolbar* wrap(GtkToolbar* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_TOOLBAR_H */

