// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_WIDGET_H
#define _GTKMM_WIDGET_H


#include <glibmm.h>

/* $Id: widget.hg,v 1.48 2006/09/19 20:08:42 murrayc Exp $ */

/* Copyright (C) 2002, 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include <pangomm/context.h>
#include <pangomm/layout.h>

#include <gtkmmconfig.h> //For GTKMM_ATKMM_ENABLED
#ifdef GTKMM_ATKMM_ENABLED
#include <atkmm/object.h>
#include <atkmm/implementor.h>
#endif //GTKMM_ATKMM_ENABLED

#include <gdkmm/event.h>
#include <gdkmm/types.h>
#include <gdkmm/window.h>
#include <gdkmm/dragcontext.h>
#include <gdkmm/pixbuf.h>
#include <gdkmm/screen.h>
#include <gtkmm/enums.h>
#include <gdkmm/display.h>
//#include <gtkmm/style.h>
#include <gtkmm/targetlist.h>
#include <gtkmm/rc.h>
#include <gtkmm/object.h>
#include <gtkmm/clipboard.h>
//#include <gtkmm/action.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C"
{
typedef struct _GtkTargetEntry GtkTargetEntry;
}

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkWidget GtkWidget;
typedef struct _GtkWidgetClass GtkWidgetClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Widget_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%DestDefaults operator|(DestDefaults, DestDefaults)</tt><br>
 * <tt>%DestDefaults operator&(DestDefaults, DestDefaults)</tt><br>
 * <tt>%DestDefaults operator^(DestDefaults, DestDefaults)</tt><br>
 * <tt>%DestDefaults operator~(DestDefaults)</tt><br>
 * <tt>%DestDefaults& operator|=(DestDefaults&, DestDefaults)</tt><br>
 * <tt>%DestDefaults& operator&=(DestDefaults&, DestDefaults)</tt><br>
 * <tt>%DestDefaults& operator^=(DestDefaults&, DestDefaults)</tt><br>
 */
enum DestDefaults
{
  DEST_DEFAULT_MOTION = 1 << 0,
  DEST_DEFAULT_HIGHLIGHT = 1 << 1,
  DEST_DEFAULT_DROP = 1 << 2,
  DEST_DEFAULT_ALL = 0x07
};

/** @ingroup gtkmmEnums */
inline DestDefaults operator|(DestDefaults lhs, DestDefaults rhs)
  { return static_cast<DestDefaults>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline DestDefaults operator&(DestDefaults lhs, DestDefaults rhs)
  { return static_cast<DestDefaults>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline DestDefaults operator^(DestDefaults lhs, DestDefaults rhs)
  { return static_cast<DestDefaults>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline DestDefaults operator~(DestDefaults flags)
  { return static_cast<DestDefaults>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline DestDefaults& operator|=(DestDefaults& lhs, DestDefaults rhs)
  { return (lhs = static_cast<DestDefaults>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline DestDefaults& operator&=(DestDefaults& lhs, DestDefaults rhs)
  { return (lhs = static_cast<DestDefaults>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline DestDefaults& operator^=(DestDefaults& lhs, DestDefaults rhs)
  { return (lhs = static_cast<DestDefaults>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::DestDefaults> : public Glib::Value_Flags<Gtk::DestDefaults>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%WidgetFlags operator|(WidgetFlags, WidgetFlags)</tt><br>
 * <tt>%WidgetFlags operator&(WidgetFlags, WidgetFlags)</tt><br>
 * <tt>%WidgetFlags operator^(WidgetFlags, WidgetFlags)</tt><br>
 * <tt>%WidgetFlags operator~(WidgetFlags)</tt><br>
 * <tt>%WidgetFlags& operator|=(WidgetFlags&, WidgetFlags)</tt><br>
 * <tt>%WidgetFlags& operator&=(WidgetFlags&, WidgetFlags)</tt><br>
 * <tt>%WidgetFlags& operator^=(WidgetFlags&, WidgetFlags)</tt><br>
 */
enum WidgetFlags
{
  TOPLEVEL = 1 << 4,
  NO_WINDOW = 1 << 5,
  REALIZED = 1 << 6,
  MAPPED = 1 << 7,
  VISIBLE = 1 << 8,
  SENSITIVE = 1 << 9,
  PARENT_SENSITIVE = 1 << 10,
  CAN_FOCUS = 1 << 11,
  HAS_FOCUS = 1 << 12,
  CAN_DEFAULT = 1 << 13,
  HAS_DEFAULT = 1 << 14,
  HAS_GRAB = 1 << 15,
  RC_STYLE = 1 << 16,
  COMPOSITE_CHILD = 1 << 17,
  NO_REPARENT = 1 << 18,
  APP_PAINTABLE = 1 << 19,
  RECEIVES_DEFAULT = 1 << 20,
  DOUBLE_BUFFERED = 1 << 21,
  NO_SHOW_ALL = 1 << 22
};

/** @ingroup gtkmmEnums */
inline WidgetFlags operator|(WidgetFlags lhs, WidgetFlags rhs)
  { return static_cast<WidgetFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline WidgetFlags operator&(WidgetFlags lhs, WidgetFlags rhs)
  { return static_cast<WidgetFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline WidgetFlags operator^(WidgetFlags lhs, WidgetFlags rhs)
  { return static_cast<WidgetFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline WidgetFlags operator~(WidgetFlags flags)
  { return static_cast<WidgetFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline WidgetFlags& operator|=(WidgetFlags& lhs, WidgetFlags rhs)
  { return (lhs = static_cast<WidgetFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline WidgetFlags& operator&=(WidgetFlags& lhs, WidgetFlags rhs)
  { return (lhs = static_cast<WidgetFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline WidgetFlags& operator^=(WidgetFlags& lhs, WidgetFlags rhs)
  { return (lhs = static_cast<WidgetFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::WidgetFlags> : public Glib::Value_Flags<Gtk::WidgetFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum WidgetHelpType
{
  WIDGET_HELP_TOOLTIP,
  WIDGET_HELP_WHATS_THIS
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::WidgetHelpType> : public Glib::Value_Enum<Gtk::WidgetHelpType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


class Action;
class Style;
class AccelGroup;
class Adjustment;
class Window;
class Container;
class Settings;

typedef GtkRequisition Requisition;

// Gtk::Allocation is a typedef of Gdk::Rectangle because GtkAllocation is
// a typedef of GdkRectangle.
typedef Gdk::Rectangle Allocation;


/** @defgroup Widgets Widgets
 */

/** Abstract Widget (Base class for all widgets)
 *
 * As the base class of all widgets this contains all of the properties
 * and methods common to all widgets.  It is an abstract class that
 * can not be instantiated.
 *
 * Important part of widgets are the *_event signals and virtual methods
 * that every widget have. Those are events coming directly from gdk and
 * thus also from XLib. By overriding those virtual methods you can
 * trap everything a widget can ever do.
 * In order to capture events from a widget, the event mask must
 * first be set with ().
 *
 * Only widgets with a Gdk::Window on the server side are allowed to
 * capture events.  Widgets in the Gtk::Misc group for example lack
 * a Gdk::Window.
 */

class Widget
: public Object
#ifdef GTKMM_ATKMM_ENABLED
  ,public Atk::Implementor
#endif //GTKMM_ATKMM_ENABLED
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Widget CppObjectType;
  typedef Widget_Class CppClassType;
  typedef GtkWidget BaseObjectType;
  typedef GtkWidgetClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Widget();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Widget_Class;
  static CppClassType widget_class_;

  // noncopyable
  Widget(const Widget&);
  Widget& operator=(const Widget&);

protected:
  explicit Widget(const Glib::ConstructParams& construct_params);
  explicit Widget(GtkWidget* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkWidget*       gobj()       { return reinterpret_cast<GtkWidget*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkWidget* gobj() const { return reinterpret_cast<GtkWidget*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_show();
  virtual void on_hide();
  virtual void on_map();
  virtual void on_unmap();
  virtual void on_realize();
  virtual void on_unrealize();
  virtual void on_size_request(Requisition* requisition);
  virtual void on_size_allocate(Allocation& allocation);
  virtual void on_state_changed(Gtk::StateType previous_state);
  virtual void on_parent_changed(Widget* previous_parent);
  virtual void on_hierarchy_changed(Widget* previous_toplevel);
  virtual void on_style_changed(const Glib::RefPtr<Style>& previous_style);
  virtual void on_direction_changed(TextDirection direction);
  virtual void on_grab_notify(bool was_grabbed);
  virtual void on_child_notify(GParamSpec* pspec);
  virtual bool on_mnemonic_activate(bool group_cycling);
  virtual void on_grab_focus();
  virtual bool on_focus(DirectionType direction);
  virtual bool on_event(GdkEvent* event);
  virtual bool on_button_press_event(GdkEventButton* event);
  virtual bool on_button_release_event(GdkEventButton* event);
  virtual bool on_scroll_event(GdkEventScroll* event);
  virtual bool on_motion_notify_event(GdkEventMotion* event);
  virtual bool on_delete_event(GdkEventAny* event);
  virtual bool on_expose_event(GdkEventExpose* event);
  virtual bool on_key_press_event(GdkEventKey* event);
  virtual bool on_key_release_event(GdkEventKey* event);
  virtual bool on_enter_notify_event(GdkEventCrossing* event);
  virtual bool on_leave_notify_event(GdkEventCrossing* event);
  virtual bool on_configure_event(GdkEventConfigure* event);
  virtual bool on_focus_in_event(GdkEventFocus* event);
  virtual bool on_focus_out_event(GdkEventFocus* event);
  virtual bool on_map_event(GdkEventAny* event);
  virtual bool on_unmap_event(GdkEventAny* event);
  virtual bool on_property_notify_event(GdkEventProperty* event);
  virtual bool on_selection_clear_event(GdkEventSelection* event);
  virtual bool on_selection_request_event(GdkEventSelection* event);
  virtual bool on_selection_notify_event(GdkEventSelection* event);
  virtual bool on_proximity_in_event(GdkEventProximity* event);
  virtual bool on_proximity_out_event(GdkEventProximity* event);
  virtual bool on_visibility_notify_event(GdkEventVisibility* event);
  virtual bool on_client_event(GdkEventClient* event);
  virtual bool on_no_expose_event(GdkEventAny* event);
  virtual bool on_window_state_event(GdkEventWindowState* event);
  virtual void on_selection_get(SelectionData& selection_data, guint info, guint time);
  virtual void on_selection_received(const SelectionData& selection_data, guint time);
  virtual void on_drag_begin(const Glib::RefPtr<Gdk::DragContext>& context);
  virtual void on_drag_end(const Glib::RefPtr<Gdk::DragContext>& context);
  virtual void on_drag_data_get(const Glib::RefPtr<Gdk::DragContext>& context, SelectionData& selection_data, guint info, guint time);
  virtual void on_drag_data_delete(const Glib::RefPtr<Gdk::DragContext>& context);
  virtual void on_drag_leave(const Glib::RefPtr<Gdk::DragContext>& context, guint time);
  virtual bool on_drag_motion(const Glib::RefPtr<Gdk::DragContext>& context, int x, int y, guint time);
  virtual bool on_drag_drop(const Glib::RefPtr<Gdk::DragContext>& context, int x, int y, guint time);
  virtual void on_drag_data_received(const Glib::RefPtr<Gdk::DragContext>& context, int x, int y, const SelectionData& selection_data, guint info, guint time);
#ifdef GTKMM_ATKMM_ENABLED
  virtual Glib::RefPtr<Atk::Object> on_get_accessible();
#endif // GTKMM_ATKMM_ENABLED
  virtual void on_screen_changed(const Glib::RefPtr<Gdk::Screen>& previous_screen);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

  
public:
  friend class Main;
  

  /** For widgets that support scrolling, sets the scroll adjustments and
   * returns <tt>true</tt>.  For widgets that don't support scrolling, does
   * nothing and returns <tt>false</tt>. Widgets that don't support scrolling
   * can be scrolled by placing them in a Gtk::Viewport, which does
   * support scrolling.
   * @param hadjustment An adjustment for horizontal scrolling, or <tt>0</tt>.
   * @param vadjustment An adjustment for vertical scrolling, or <tt>0</tt>.
   * @return <tt>true</tt> if the widget supports scrolling.
   */
  bool set_scroll_adjustments(Adjustment& hadjustment, Adjustment& vadjustment);

  
  /** Flags a widget to be displayed. Any widget that isn't shown will
   * not appear on the screen. If you want to show all the widgets in a
   * container, it's easier to call show_all() on the
   * container, instead of individually showing the widgets.
   * 
   * Remember that you have to show the containers containing a widget,
   * in addition to the widget itself, before it will appear onscreen.
   * 
   * When a toplevel container is shown, it is immediately realized and
   * mapped; other shown widgets are realized and mapped when their
   * toplevel container is realized and mapped.
   */
  void show();
  
  /** Shows a widget. If the widget is an unmapped toplevel widget
   * (i.e. a Gtk::Window that has not yet been shown), enter the main
   * loop and wait for the window to actually be mapped. Be careful;
   * because the main loop is running, anything can happen during
   * this function.
   */
  void show_now();
  
  /** Reverses the effects of show(), causing the widget to be
   * hidden (invisible to the user).
   */
  void hide();

  
  /** Recursively shows a widget, and any child widgets (if the widget is
   * a container).
   */
  void show_all();

  
  /** Recursively hides a widget and any child widgets.
   */
  void hide_all();


/* QUEUE DRAWS */

  
  /** Equivalent to calling queue_draw_area() for the
   * entire area of a widget.
   */
  void queue_draw();
  
  /** Invalidates the rectangular area of @a widget  defined by @a x , @a y ,
   *  @a width  and @a height  by calling gdk_window_invalidate_rect() on the
   * widget's window and all its child windows.  Once the main loop
   * becomes idle (after the current batch of events has been processed,
   * roughly), the window will receive expose events for the union of
   * all regions that have been invalidated.
   * 
   * Normally you would only use this function in widget
   * implementations. You might also use it, or
   * gdk_window_invalidate_rect() directly, to schedule a redraw of a
   * Gtk::DrawingArea or some portion thereof.
   * 
   * Frequently you can just call gdk_window_invalidate_rect() or
   * gdk_window_invalidate_region() instead of this function. Those
   * functions will invalidate only a single window, instead of the
   * widget and all its children.
   * 
   * The advantage of adding to the invalidated region compared to
   * simply drawing immediately is efficiency; using an invalid region
   * ensures that you only have to redraw one time.
   * @param x X coordinate of upper-left corner of rectangle to redraw.
   * @param y Y coordinate of upper-left corner of rectangle to redraw.
   * @param width Width of region to draw.
   * @param height Height of region to draw.
   */
  void queue_draw_area(int x, int y, int width, int height);
  
  /** This function is only for use in widget implementations.
   * Flags a widget to have its size renegotiated; should
   * be called when a widget for some reason has a new size request.
   * For example, when you change the text in a Gtk::Label, Gtk::Label
   * queues a resize to ensure there's enough space for the new text.
   */
  void queue_resize();

  /** This function is typically used when implementing a Gtk::Container
   * subclass.  Obtains the preferred size of a widget. The container
   * uses this information to arrange its child widgets and decide what
   * size allocations to give them with size_allocate().
   * 
   * You can also call this function from an application, with some
   * caveats. Most notably, getting a size request requires the widget
   * to be associated with a screen, because font information may be
   * needed. Multihead-aware applications should keep this in mind.
   * 
   * Also remember that the size request is not necessarily the size
   * a widget will actually be allocated.
   * 
   * See also get_child_requisition().
   * @result A Gtk::Requisition.
   */
  Requisition size_request() const;
  

#ifndef GTKMM_DISABLE_DEPRECATED

  /** This function is typically used when implementing a Gtk::Container
   * subclass.  Obtains the preferred size of a widget. The container
   * uses this information to arrange its child widgets and decide what
   * size allocations to give them with size_allocate().
   * 
   * You can also call this function from an application, with some
   * caveats. Most notably, getting a size request requires the widget
   * to be associated with a screen, because font information may be
   * needed. Multihead-aware applications should keep this in mind.
   * 
   * Also remember that the size request is not necessarily the size
   * a widget will actually be allocated.
   * 
   * See also get_child_requisition().
   * @deprecated Use size_request() const.
   * @param requisition A Gtk::Requisition to be filled in.
   */
  void size_request(const Requisition& requisition);
#endif // GTKMM_DISABLE_DEPRECATED


  /** This function is only used by Gtk::Container subclasses, to assign a size
   * and position to their child widgets.
   * @param allocation Position and size to be allocated to @a widget .
   */
  void size_allocate(const Allocation& allocation);


  /** Installs an accelerator for this @a widget  in @a accel_group  that causes
   *  @a accel_signal  to be emitted if the accelerator is activated.
   * The @a accel_group  needs to be added to the widget's toplevel via
   * Gtk::Window::add_accel_group(), and the signal must be of type G::RUN_ACTION.
   * Accelerators added through this function are not user changeable during
   * runtime. If you want to support accelerators that can be changed by the
   * user, use gtk_accel_map_add_entry() and set_accel_path() or
   * Gtk::MenuItem::set_accel_path() instead.
   * @param accel_signal Widget signal to emit on accelerator activation.
   * @param accel_group Accel group for this widget, added to its toplevel.
   * @param accel_key GDK keyval of the accelerator.
   * @param accel_mods Modifier key combination of the accelerator.
   * @param accel_flags Flag accelerators, e.g. Gtk::ACCEL_VISIBLE.
   */
  void add_accelerator(const Glib::ustring& accel_signal, const Glib::RefPtr<AccelGroup>& accel_group,
               guint accel_key, Gdk::ModifierType accel_mods, AccelFlags accel_flags);

  
  /** Removes an accelerator from @a widget , previously installed with
   * add_accelerator().
   * @param accel_group Accel group for this widget.
   * @param accel_key GDK keyval of the accelerator.
   * @param accel_mods Modifier key combination of the accelerator.
   * @return Whether an accelerator was installed and could be removed.
   */
  bool remove_accelerator(const Glib::RefPtr<AccelGroup>& accel_group,
               guint accel_key, Gdk::ModifierType accel_mods);
  
  /** Given an accelerator group, @a accel_group , and an accelerator path,
   *  @a accel_path , sets up an accelerator in @a accel_group  so whenever the
   * key binding that is defined for @a accel_path  is pressed, @a widget 
   * will be activated.  This removes any accelerators (for any
   * accelerator group) installed by previous calls to
   * set_accel_path(). Associating accelerators with
   * paths allows them to be modified by the user and the modifications
   * to be saved for future use. (See gtk_accel_map_save().)
   * 
   * This function is a low level function that would most likely
   * be used by a menu creation system like Gtk::ItemFactory. If you
   * use Gtk::ItemFactory, setting up accelerator paths will be done
   * automatically.
   * 
   * Even when you you aren't using Gtk::ItemFactory, if you only want to
   * set up accelerators on menu items Gtk::MenuItem::set_accel_path()
   * provides a somewhat more convenient interface.
   * @param accel_path Path used to look up the accelerator.
   * @param accel_group A Gtk::AccelGroup.
   */
  void set_accel_path(const Glib::ustring& accel_path,
                                   const Glib::RefPtr<AccelGroup>& accel_group);

  //GList* gtk_widget_list_accel_closures();

  //TODO: Or maybe it is useless: gboolean gtk_widget_can_activate_accel(GtkWidget *widget, guint signal_id)
  
  
  bool mnemonic_activate(bool group_cycling);

  //TODO: Use C++ type
  
  /** Rarely-used function. This function is used to emit
   * the event signals on a widget (those signals should never
   * be emitted without using this function to do so).
   * If you want to synthesize an event though, don't use this function;
   * instead, use gtk_main_do_event() so the event will behave as if
   * it were in the event queue. Don't synthesize expose events; instead,
   * use gdk_window_invalidate_rect() to invalidate a region of the
   * window.
   * @param event A Gdk::Event.
   * @return Return from the event signal emission (<tt>true</tt> if the event was handled).
   */
  bool event(GdkEvent* event);
  
  /** Very rarely-used function. This function is used to emit
   * an expose event signals on a widget. This function is not
   * normally used directly. The only time it is used is when
   * propagating an expose event to a child NO_WINDOW widget, and
   * that is normally done using Gtk::Container::propagate_expose().
   * 
   * If you want to force an area of a window to be redrawn, 
   * use gdk_window_invalidate_rect() or gdk_window_invalidate_region().
   * To cause the redraw to be done immediately, follow that call
   * with a call to gdk_window_process_updates().
   * @param event A expose Gdk::Event.
   * @return Return from the event signal emission (<tt>true</tt> if the event was handled).
   */
  int send_expose(GdkEvent* event);
  
  /** For widgets that can be "activated" (buttons, menu items, etc.)
   * this function activates them. Activation is what happens when you
   * press Enter on a widget during key navigation. If @a widget  isn't 
   * activatable, the function returns <tt>false</tt>.
   * @return <tt>true</tt> if the widget was activatable.
   */
  bool activate();

  
  /** Moves a widget from one Gtk::Container to another, handling reference
   * count issues to avoid destroying the widget.
   * @param new_parent A Gtk::Container to move the widget into.
   */
  void reparent(Widget & new_parent);

  bool intersect(const Gdk::Rectangle& area) const;
  
  /** Computes the intersection of a @a widget 's area and @a area , storing
   * the intersection in @a intersection , and returns <tt>true</tt> if there was
   * an intersection.  @a intersection  may be <tt>0</tt> if you're only
   * interested in whether there was an intersection.
   * @param area A rectangle.
   * @param intersection Rectangle to store intersection of @a widget  and @a area .
   * @return <tt>true</tt> if there was an intersection.
   */
  bool intersect(const Gdk::Rectangle& area, Gdk::Rectangle& intersection) const;

  
  /** Computes the intersection of a @a widget 's area and @a region , returning
   * the intersection. The result may be empty, use gdk_region_empty() to
   * check.
   * @param region A Gdk::Region, in the same coordinate system as 
   *  @a widget -&gt;allocation. That is, relative to @a widget -&gt;window
   * for NO_WINDOW widgets; relative to the parent window
   * of @a widget -&gt;window for widgets with their own window.
   * @return A newly allocated region holding the intersection of @a widget 
   * and @a region . The coordinates of the return value are
   * relative to @a widget -&gt;window for NO_WINDOW widgets, and
   * relative to the parent window of @a widget -&gt;window for
   * widgets with their own window.
   */
  Gdk::Region region_intersect(const Gdk::Region& region) const;

  
  /** Stops emission of "child-notify" signals on @a widget . The signals are
   * queued until thaw_child_notify() is called on @a widget . 
   * 
   * This is the analogue of Glib::object_freeze_notify() for child properties.
   */
  void freeze_child_notify();
  
  /** Emits a "child-notify" signal for the 
   * child property @a child_property  
   * on @a widget .
   * 
   * This is the analogue of Glib::object_notify() for child properties.
   * @param child_property The name of a child property installed on the 
   * class of @a widget &lt;!-- --&gt;'s parent.
   */
  void	child_notify(const Glib::ustring& child_property);
  
  /** Reverts the effect of a previous call to freeze_child_notify().
   * This causes all queued "child-notify" signals on @a widget  to be emitted.
   */
  void	thaw_child_notify();

  
  /** Determines if the widget is the focus widget within its
   * toplevel. (This does not mean that the HAS_FOCUS flag is
   * necessarily set; HAS_FOCUS will only be set if the
   * toplevel widget additionally has the global input focus.)
   * @return <tt>true</tt> if the widget is the focus widget.
   */
  bool is_focus() const;
  
  /** Causes @a widget  to have the keyboard focus for the Gtk::Window it's
   * inside. @a widget  must be a focusable widget, such as a Gtk::Entry;
   * something like Gtk::Frame won't work. (More precisely, it must have the
   * Gtk::CAN_FOCUS flag set.)
   */
  void	grab_focus();
  
  /** Causes @a widget  to become the default widget. @a widget  must have the
   * Gtk::CAN_DEFAULT flag set; typically you have to set this flag
   * yourself by calling <tt>GTK_WIDGET_SET_FLAGS ( @a widget ,
   * GTK_CAN_DEFAULT)</tt>.  The default widget is activated when the user
   * presses Enter in a window.  Default widgets must be activatable,
   * that is, activate() should affect them.
   */
  void	grab_default();

  /** Block events to everything else than this widget and its children. This
   * way you can get modal behaviour (usually not recommended). One practical
   * example could be when implementing a key-binding widget that needs
   * exclusive access to the key combination that the user presses next.
   *
   * Calls to add_modal_grab should be paired with calls to remove_modal_grab.
   */
  void add_modal_grab();

  /** Remove the modal grab of the widget in case it was previously grabbed.
   */
  void remove_modal_grab();

  /** Retrieve the widget which is currently grabbing all events.
   */
  static Widget* get_current_modal_grab();

  
  /** Widgets can be named, which allows you to refer to them from a
   * gtkrc file. You can apply a style to widgets with a particular name
   * in the gtkrc file. See the documentation for gtkrc files (on the
   * same page as the docs for Gtk::RcStyle).
   * 
   * Note that widget names are separated by periods in paths (see 
   * path()), so names with embedded periods may cause confusion.
   * @param name Name for the widget.
   */
  void set_name(const Glib::ustring& name);
  void unset_name();
  
  /** Retrieves the name of a widget. See set_name() for the
   * significance of widget names.
   * @return Name of the widget. This string is owned by GTK+ and
   * should not be modified or freed.
   */
  Glib::ustring get_name() const;

  
  /** This function is for use in widget implementations. Sets the state
   * of a widget (insensitive, prelighted, etc.) Usually you should set
   * the state using wrapper functions such as set_sensitive().
   * @param state New state for @a widget .
   */
  void set_state(Gtk::StateType state);
  
  /** Sets the sensitivity of a widget. A widget is sensitive if the user
   * can interact with it. Insensitive widgets are "grayed out" and the
   * user can't interact with them. Insensitive widgets are known as
   * "inactive", "disabled", or "ghosted" in some other toolkits.
   * @param sensitive <tt>true</tt> to make the widget sensitive.
   */
  void set_sensitive(bool sensitive = true);
  
  /** Sets whether the application intends to draw on the widget in
   * an ::expose-event handler. 
   * 
   * This is a hint to the widget and does not affect the behavior of 
   * the GTK+ core; many widgets ignore this flag entirely. For widgets 
   * that do pay attention to the flag, such as Gtk::EventBox and Gtk::Window, 
   * the effect is to suppress default themed drawing of the widget's 
   * background. (Children of the widget will still be drawn.) The application 
   * is then entirely responsible for drawing the widget background.
   * @param app_paintable <tt>true</tt> if the application will paint on the widget.
   */
  void set_app_paintable(bool app_paintable = true);
  
  /** Widgets are double buffered by default; you can use this function
   * to turn off the buffering. "Double buffered" simply means that
   * gdk_window_begin_paint_region() and gdk_window_end_paint() are called
   * automatically around expose events sent to the
   * widget. gdk_window_begin_paint() diverts all drawing to a widget's
   * window to an offscreen buffer, and gdk_window_end_paint() draws the
   * buffer to the screen. The result is that users see the window
   * update in one smooth step, and don't see individual graphics
   * primitives being rendered.
   * 
   * In very simple terms, double buffered widgets don't flicker,
   * so you would only use this function to turn off double buffering
   * if you had special needs and really knew what you were doing.
   * 
   * @note if you turn off double-buffering, you have to handle
   * expose events, since even the clearing to the background color or 
   * pixmap will not happen automatically (as it is done in 
   * gdk_window_begin_paint()).
   * @param double_buffered <tt>true</tt> to double-buffer a widget.
   */
  void set_double_buffered(bool double_buffered = true);

  
  /** Sets whether the entire widget is queued for drawing when its size 
   * allocation changes. By default, this setting is <tt>true</tt> and
   * the entire widget is redrawn on every size change. If your widget
   * leaves the upper left unchanged when made bigger, turning this
   * setting on will improve performance.
   * 
   * Note that for NO_WINDOW widgets setting this flag to <tt>false</tt> turns
   * off all allocation on resizing: the widget will not even redraw if
   * its position changes; this is to allow containers that don't draw
   * anything to avoid excess invalidations. If you set this flag on a
   * NO_WINDOW widget that <em>does</em> draw on @a widget -&gt;window, 
   * you are responsible for invalidating both the old and new allocation 
   * of the widget when the widget is moved and responsible for invalidating
   * regions newly when the widget increases size.
   * @param redraw_on_allocate If <tt>true</tt>, the entire widget will be redrawn
   * when it is allocated to a new size. Otherwise, only the
   * new portion of the widget will be redrawn.
   */
  void set_redraw_on_allocate(bool redraw_on_allocate = true);

  
  /** Sets whether @a widget  should be mapped along with its when its parent
   * is mapped and @a widget  has been shown with show(). 
   * 
   * The child visibility can be set for widget before it is added to
   * a container with set_parent(), to avoid mapping
   * children unnecessary before immediately unmapping them. However
   * it will be reset to its default state of <tt>true</tt> when the widget
   * is removed from a container.
   * 
   * Note that changing the child visibility of a widget does not
   * queue a resize on the widget. Most of the time, the size of
   * a widget is computed from all visible children, whether or
   * not they are mapped. If this is not the case, the container
   * can queue a resize itself.
   * 
   * This function is only useful for container implementations and
   * never should be called by an application.
   * @param is_visible If <tt>true</tt>, @a widget  should be mapped along with its parent.
   */
  void set_child_visible(bool is_visible = true);
  
  /** Gets the value set with set_child_visible().
   * If you feel a need to use this function, your code probably
   * needs reorganization. 
   * 
   * This function is only useful for container implementations and
   * never should be called by an application.
   * @return <tt>true</tt> if the widget is mapped with the parent.
   */
  bool get_child_visible() const;

  
  /** Returns the parent container of @a widget .
   * @return The parent container of @a widget , or <tt>0</tt>.
   */
  Container* get_parent();
  
  /** Returns the parent container of @a widget .
   * @return The parent container of @a widget , or <tt>0</tt>.
   */
  const Container* get_parent() const;

  
  /** Gets @a widget 's parent window.
   * @return The parent window of @a widget .
   */
  Glib::RefPtr<Gdk::Window> get_parent_window();
  
  /** Gets @a widget 's parent window.
   * @return The parent window of @a widget .
   */
  Glib::RefPtr<const Gdk::Window> get_parent_window() const;
  
  /** Sets a non default parent window for @a widget .
   * @param parent_window The new parent window.
   */
  void set_parent_window(const Glib::RefPtr<const Gdk::Window>& parent_window);

  
  /** This function is used by custom widget implementations; if you're
   * writing an app, you'd use grab_focus() to move the focus
   * to a particular widget, and Gtk::Container::set_focus_chain() to
   * change the focus tab order. So you may want to investigate those
   * functions instead.
   * 
   * child_focus() is called by containers as the user moves
   * around the window using keyboard shortcuts. @a direction  indicates
   * what kind of motion is taking place (up, down, left, right, tab
   * forward, tab backward).  child_focus() invokes the
   * "focus" signal on Gtk::Widget; widgets override the default handler
   * for this signal in order to implement appropriate focus behavior.
   * 
   * The "focus" default handler for a widget should return <tt>true</tt> if
   * moving in @a direction  left the focus on a focusable location inside
   * that widget, and <tt>false</tt> if moving in @a direction  moved the focus
   * outside the widget. If returning <tt>true</tt>, widgets normally
   * call grab_focus() to place the focus accordingly;
   * if returning <tt>false</tt>, they don't modify the current focus location.
   * 
   * This function replaces gtk_container_focus() from GTK+ 1.2.  It was
   * necessary to check that the child was visible, sensitive, and
   * focusable before calling
   * gtk_container_focus(). child_focus() returns <tt>false</tt> if
   * the widget is not currently in a focusable state, so there's no
   * need for those checks.
   * @param direction Direction of focus movement.
   * @return <tt>true</tt> if focus ended up inside @a widget .
   */
  bool child_focus(DirectionType direction);

  
  /** Sets the minimum size of a widget; that is, the widget's size
   * request will be @a width  by @a height . You can use this function to
   * force a widget to be either larger or smaller than it normally
   * would be.
   * 
   * In most cases, Gtk::Window::set_default_size() is a better choice for
   * toplevel windows than this function; setting the default size will
   * still allow users to shrink the window. Setting the size request
   * will force them to leave the window at least as large as the size
   * request. When dealing with window sizes,
   * Gtk::Window::set_geometry_hints() can be a useful function as well.
   * 
   * Note the inherent danger of setting any fixed size - themes,
   * translations into other languages, different fonts, and user action
   * can all change the appropriate size for a given widget. So, it's
   * basically impossible to hardcode a size that will always be
   * correct.
   * 
   * The size request of a widget is the smallest size a widget can
   * accept while still functioning well and drawing itself correctly.
   * However in some strange cases a widget may be allocated less than
   * its requested size, and in many cases a widget may be allocated more
   * space than it requested.
   * 
   * If the size request in a given direction is -1 (unset), then
   * the "natural" size request of the widget will be used instead.
   * 
   * Widgets can't actually be allocated a size less than 1 by 1, but
   * you can pass 0,0 to this function to mean "as small as possible."
   * @param width Width @a widget  should request, or -1 to unset.
   * @param height Height @a widget  should request, or -1 to unset.
   */
  void set_size_request(int width = -1, int  height = -1);
  
  /** Gets the size request that was explicitly set for the widget using
   * set_size_request().  A value of -1 stored in @a width  or
   *  @a height  indicates that that dimension has not been set explicitly
   * and the natural requisition of the widget will be used intead. See
   * set_size_request(). To get the size a widget will
   * actually use, call size_request() instead of
   * this function.
   * @param width Return location for width, or <tt>0</tt>.
   * @param height Return location for height, or <tt>0</tt>.
   */
  void get_size_request(int& width, int& height) const;

  
  /** Sets the event mask (see Gdk::EventMask) for a widget. The event
   * mask determines which events a widget will receive. Keep in mind
   * that different widgets have different default event masks, and by
   * changing the event mask you may disrupt a widget's functionality,
   * so be careful. This function must be called while a widget is
   * unrealized. Consider add_events() for widgets that are
   * already realized, or if you want to preserve the existing event
   * mask. This function can't be used with Gtk::NO_WINDOW widgets;
   * to get events on those widgets, place them inside a Gtk::EventBox
   * and receive events on the event box.
   * @param events Event mask.
   */
  void set_events(Gdk::EventMask events);
  
  /** Adds the events in the bitfield @a events  to the event mask for
   *  @a widget . See set_events() for details.
   * @param events An event mask, see Gdk::EventMask.
   */
  void add_events(Gdk::EventMask events);
  
  /** Sets the extension events mask to @a mode . See Gdk::ExtensionMode
   * and gdk_input_set_extension_events().
   * @param mode Bitfield of extension events to receive.
   */
  void set_extension_events(Gdk::ExtensionMode mode);

  
  /** Retrieves the extension events the widget will receive; see
   * gdk_input_set_extension_events().
   * @return Extension events for @a widget .
   */
  Gdk::ExtensionMode get_extension_events() const;

  
  /** This function returns the topmost widget in the container hierarchy
   *  @a widget  is a part of. If @a widget  has no parent widgets, it will be
   * returned as the topmost widget. No reference will be added to the
   * returned widget; it should not be unreferenced.
   * 
   * Note the difference in behavior vs. get_ancestor();
   * <tt>gtk_widget_get_ancestor (widget, GTK_TYPE_WINDOW)</tt> 
   * would return
   * <tt>0</tt> if @a widget  wasn't inside a toplevel window, and if the
   * window was inside a Gtk::Window-derived widget which was in turn
   * inside the toplevel Gtk::Window. While the second case may
   * seem unlikely, it actually happens when a Gtk::Plug is embedded
   * inside a Gtk::Socket within the same application.
   * 
   * To reliably find the toplevel Gtk::Window, use
   * get_toplevel() and check if the T::OPLEVEL flags
   * is set on the result.
   * @code
   * GtkWidget *toplevel = gtk_widget_get_toplevel (widget);
   * if (GTK_WIDGET_TOPLEVEL (toplevel))
   * {
   * [ Perform action on toplevel. ]
   * }
   * @endcode
   * @return The topmost ancestor of @a widget , or @a widget  itself if there's no ancestor.
   */
  Container* get_toplevel();
  
  /** This function returns the topmost widget in the container hierarchy
   *  @a widget  is a part of. If @a widget  has no parent widgets, it will be
   * returned as the topmost widget. No reference will be added to the
   * returned widget; it should not be unreferenced.
   * 
   * Note the difference in behavior vs. get_ancestor();
   * <tt>gtk_widget_get_ancestor (widget, GTK_TYPE_WINDOW)</tt> 
   * would return
   * <tt>0</tt> if @a widget  wasn't inside a toplevel window, and if the
   * window was inside a Gtk::Window-derived widget which was in turn
   * inside the toplevel Gtk::Window. While the second case may
   * seem unlikely, it actually happens when a Gtk::Plug is embedded
   * inside a Gtk::Socket within the same application.
   * 
   * To reliably find the toplevel Gtk::Window, use
   * get_toplevel() and check if the T::OPLEVEL flags
   * is set on the result.
   * @code
   * GtkWidget *toplevel = gtk_widget_get_toplevel (widget);
   * if (GTK_WIDGET_TOPLEVEL (toplevel))
   * {
   * [ Perform action on toplevel. ]
   * }
   * @endcode
   * @return The topmost ancestor of @a widget , or @a widget  itself if there's no ancestor.
   */
  const Container* get_toplevel() const;

  
  /** Gets the first ancestor of @a widget  with type @a widget_type . For example,
   * <tt>gtk_widget_get_ancestor (widget, GTK_TYPE_BOX)</tt> gets the 
   * first Gtk::Box that's
   * an ancestor of @a widget . No reference will be added to the returned widget;
   * it should not be unreferenced. See note about checking for a toplevel
   * Gtk::Window in the docs for get_toplevel().
   * 
   * Note that unlike is_ancestor(), get_ancestor() 
   * considers @a widget  to be an ancestor of itself.
   * @param widget_type Ancestor type.
   * @return The ancestor widget, or <tt>0</tt> if not found.
   */
  Widget* get_ancestor(GType widget_type);
  
  /** Gets the first ancestor of @a widget  with type @a widget_type . For example,
   * <tt>gtk_widget_get_ancestor (widget, GTK_TYPE_BOX)</tt> gets the 
   * first Gtk::Box that's
   * an ancestor of @a widget . No reference will be added to the returned widget;
   * it should not be unreferenced. See note about checking for a toplevel
   * Gtk::Window in the docs for get_toplevel().
   * 
   * Note that unlike is_ancestor(), get_ancestor() 
   * considers @a widget  to be an ancestor of itself.
   * @param widget_type Ancestor type.
   * @return The ancestor widget, or <tt>0</tt> if not found.
   */
  const Widget* get_ancestor(GType widget_type) const;

  
  /** Gets the colormap that will be used to render @a widget . No reference will
   * be added to the returned colormap; it should not be unreferenced.
   * @return The colormap used by @a widget .
   */
  Glib::RefPtr<Gdk::Colormap> get_colormap();

  
  /** Gets the visual that will be used to render @a widget .
   * @return The visual for @a widget .
   */
  Glib::RefPtr<Gdk::Visual> get_visual();

  
  /** Get the Gdk::Screen from the toplevel window associated with
   * this widget. This function can only be called after the widget
   * has been added to a widget hierarchy with a Gtk::Window
   * at the top.
   * 
   * In general, you should only create screen specific
   * resources when a widget has been realized, and you should
   * free those resources when the widget is unrealized.
   * @return The Gdk::Screen for the toplevel for this widget.
   * 
   * @newin2p2.
   */
  Glib::RefPtr<Gdk::Screen> get_screen();
  
  /** Get the Gdk::Screen from the toplevel window associated with
   * this widget. This function can only be called after the widget
   * has been added to a widget hierarchy with a Gtk::Window
   * at the top.
   * 
   * In general, you should only create screen specific
   * resources when a widget has been realized, and you should
   * free those resources when the widget is unrealized.
   * @return The Gdk::Screen for the toplevel for this widget.
   * 
   * @newin2p2.
   */
  Glib::RefPtr<const Gdk::Screen> get_screen() const;

  
  /** Checks whether there is a Gdk::Screen is associated with
   * this widget. All toplevel widgets have an associated
   * screen, and all widgets added into a heirarchy with a toplevel
   * window at the top.
   * @return <tt>true</tt> if there is a Gdk::Screen associcated
   * with the widget.
   * 
   * @newin2p2.
   */
  bool has_screen() const;

  
  /** Get the Gdk::Display for the toplevel window associated with
   * this widget. This function can only be called after the widget
   * has been added to a widget hierarchy with a Gtk::Window at the top.
   * 
   * In general, you should only create display specific
   * resources when a widget has been realized, and you should
   * free those resources when the widget is unrealized.
   * @return The Gdk::Display for the toplevel for this widget.
   * 
   * @newin2p2.
   */
  Glib::RefPtr<Gdk::Display> get_display();
  
  /** Get the Gdk::Display for the toplevel window associated with
   * this widget. This function can only be called after the widget
   * has been added to a widget hierarchy with a Gtk::Window at the top.
   * 
   * In general, you should only create display specific
   * resources when a widget has been realized, and you should
   * free those resources when the widget is unrealized.
   * @return The Gdk::Display for the toplevel for this widget.
   * 
   * @newin2p2.
   */
  Glib::RefPtr<const Gdk::Display> get_display() const;

  
  /** Get the root window where this widget is located. This function can
   * only be called after the widget has been added to a widget
   * heirarchy with Gtk::Window at the top.
   * 
   * The root window is useful for such purposes as creating a popup
   * Gdk::Window associated with the window. In general, you should only
   * create display specific resources when a widget has been realized,
   * and you should free those resources when the widget is unrealized.
   * @return The Gdk::Window root window for the toplevel for this widget.
   * 
   * @newin2p2.
   */
  Glib::RefPtr<Gdk::Window> get_root_window();
  
  /** Get the root window where this widget is located. This function can
   * only be called after the widget has been added to a widget
   * heirarchy with Gtk::Window at the top.
   * 
   * The root window is useful for such purposes as creating a popup
   * Gdk::Window associated with the window. In general, you should only
   * create display specific resources when a widget has been realized,
   * and you should free those resources when the widget is unrealized.
   * @return The Gdk::Window root window for the toplevel for this widget.
   * 
   * @newin2p2.
   */
  Glib::RefPtr<const Gdk::Window> get_root_window() const;
  
  
  /** Gets the settings object holding the settings (global property
   * settings, RC file information, etc) used for this widget.
   * 
   * Note that this function can only be called when the Gtk::Widget
   * is attached to a toplevel, since the settings object is specific
   * to a particular Gdk::Screen.
   * @return The relevant Gtk::Settings object.
   */
  Glib::RefPtr<Settings> get_settings();

  
  /** Returns the clipboard object for the given selection to
   * be used with @a widget . @a widget  must have a Gdk::Display
   * associated with it, so must be attached to a toplevel
   * window.
   * @param selection A Gdk::Atom which identifies the clipboard
   * to use. Gdk::SELECTION_CLIPBOARD gives the
   * default clipboard. Another common value
   * is Gdk::SELECTION_PRIMARY, which gives
   * the primary X selection.
   * @return The appropriate clipboard object. If no
   * clipboard already exists, a new one will
   * be created. Once a clipboard object has
   * been created, it is persistent for all time.
   * 
   * @newin2p2.
   */
  Glib::RefPtr<Clipboard> get_clipboard(const Glib::ustring& selection);
  
  /** Returns the clipboard object for the given selection to
   * be used with @a widget . @a widget  must have a Gdk::Display
   * associated with it, so must be attached to a toplevel
   * window.
   * @param selection A Gdk::Atom which identifies the clipboard
   * to use. Gdk::SELECTION_CLIPBOARD gives the
   * default clipboard. Another common value
   * is Gdk::SELECTION_PRIMARY, which gives
   * the primary X selection.
   * @return The appropriate clipboard object. If no
   * clipboard already exists, a new one will
   * be created. Once a clipboard object has
   * been created, it is persistent for all time.
   * 
   * @newin2p2.
   */
  Glib::RefPtr<const Clipboard> get_clipboard(const Glib::ustring& selection) const;

  //TODO: This probably needs a special conversion to do an extra ref (take_copy=true) for the returned instance:
  
  /** Returns the accessible object that describes the widget to an
   * assistive technology. 
   * 
   * If no accessibility library is loaded (i.e. no ATK implementation library is 
   * loaded via &lt;envar&gt;GTK_MODULES&lt;/envar&gt; or via another application library, 
   * such as libgnome), then this Atk::Object instance may be a no-op. Likewise, 
   * if no class-specific Atk::Object implementation is available for the widget 
   * instance in question, it will inherit an Atk::Object implementation from the 
   * first ancestor class for which such an implementation is defined.
   * 
   * The documentation of the ATK
   * library contains more information about accessible objects and their uses.
   * @return The Atk::Object associated with @a widget .
   */

#ifdef  GTKMM_ATKMM_ENABLED
  Glib::RefPtr<Atk::Object> get_accessible();
#endif //  GTKMM_ATKMM_ENABLED


  /** Sets the colormap for the widget to the given value. Widget must not
   * have been previously realized. This probably should only be used
   * from an <tt>init()</tt> function (i.e. from the constructor 
   * for the widget).
   * @param colormap A colormap.
   */
  void set_colormap(const Glib::RefPtr<const Gdk::Colormap> &colormap);
  
  /** Returns the event mask for the widget (a bitfield containing flags
   * from the Gdk::EventMask enumeration). These are the events that the widget
   * will receive.
   * @return Event mask for @a widget .
   */
  Gdk::EventMask get_events() const;
  
  /** Obtains the location of the mouse pointer in widget coordinates.
   * Widget coordinates are a bit odd; for historical reasons, they are
   * defined as @a widget -&gt;window coordinates for widgets that are not
   * Gtk::NO_WINDOW widgets, and are relative to @a widget -&gt;allocation.x,
   *  @a widget -&gt;allocation.y for widgets that are Gtk::NO_WINDOW widgets.
   * @param x Return location for the X coordinate, or <tt>0</tt>.
   * @param y Return location for the Y coordinate, or <tt>0</tt>.
   */
  void get_pointer(int &x, int &y) const;
  
  /** Determines whether @a widget  is somewhere inside @a ancestor , possibly with
   * intermediate containers.
   * @param ancestor Another Gtk::Widget.
   * @return <tt>true</tt> if @a ancestor  contains @a widget  as a child, grandchild, great grandchild, etc.
   */
  bool is_ancestor(Widget &ancestor) const;

  
  /** Translate coordinates relative to @a src_widget 's allocation to coordinates
   * relative to @a dest_widget 's allocations. In order to perform this
   * operation, both widgets must be realized, and must share a common
   * toplevel.
   * @param dest_widget A Gtk::Widget.
   * @param src_x X position relative to @a src_widget .
   * @param src_y Y position relative to @a src_widget .
   * @param dest_x Location to store X position relative to @a dest_widget .
   * @param dest_y Location to store Y position relative to @a dest_widget .
   * @return <tt>false</tt> if either widget was not realized, or there
   * was no common ancestor. In this case, nothing is stored in
   * * @a dest_x  and * @a dest_y . Otherwise <tt>true</tt>.
   */
  bool translate_coordinates(Widget& dest_widget,
					       int src_x, int src_y,
					       int& dest_x, int& dest_y);

/* STYLE */
  
  /** Sets the Gtk::Style for a widget ( @a widget -&gt;style). You probably don't
   * want to use this function; it interacts badly with themes, because
   * themes work by replacing the Gtk::Style. Instead, use
   * modify_style().
   * @param style A Gtk::Style.
   */
  void set_style(const Glib::RefPtr<Style>& style);
  void unset_style();

  
  /** Ensures that @a widget  has a style ( @a widget -&gt;style). Not a very useful
   * function; most of the time, if you want the style, the widget is
   * realized, and realized widgets are guaranteed to have a style
   * already.
   */
  void ensure_style();
  
  /** Simply an accessor function that returns @a widget -&gt;style.
   * @return The widget's Gtk::Style.
   */
  Glib::RefPtr<Style> get_style();
  
  /** Simply an accessor function that returns @a widget -&gt;style.
   * @return The widget's Gtk::Style.
   */
  Glib::RefPtr<const Style> get_style() const;
  
  /** Modifies style values on the widget. Modifications made using this
   * technique take precedence over style values set via an RC file,
   * however, they will be overriden if a style is explicitely set on
   * the widget using set_style(). The Gtk::RcStyle structure
   * is designed so each field can either be set or unset, so it is
   * possible, using this function, to modify some style values and
   * leave the others unchanged.
   * 
   * Note that modifications made with this function are not cumulative
   * with previous calls to modify_style() or with such
   * functions as modify_fg(). If you wish to retain
   * previous values, you must first call get_modifier_style(),
   * make your modifications to the returned style, then call
   * modify_style() with that style. On the other hand,
   * if you first call modify_style(), subsequent calls
   * to such functions modify_fg() will have a cumulative
   * effect with the initial modifications.
   * @param style The Gtk::RcStyle holding the style modifications.
   */
  void modify_style(const Glib::RefPtr<RcStyle>& style);
  
  /** Returns the current modifier style for the widget. (As set by
   * modify_style().) If no style has previously set, a new
   * Gtk::RcStyle will be created with all values unset, and set as the
   * modifier style for the widget. If you make changes to this rc
   * style, you must call modify_style(), passing in the
   * returned rc style, to make sure that your changes take effect.
   * 
   * Caution: passing the style back to modify_style() will
   * normally end up destroying it, because modify_style() copies
   * the passed-in style and sets the copy as the new modifier style,
   * thus dropping any reference to the old modifier style. Add a reference
   * to the modifier style if you want to keep it alive.
   * @return The modifier style for the widget. This rc style is
   * owned by the widget. If you want to keep a pointer to value this
   * around, you must add a refcount using Gtk::RcStyle::ref().
   */
  Glib::RefPtr<RcStyle> get_modifier_style();
  
  /** Returns the current modifier style for the widget. (As set by
   * modify_style().) If no style has previously set, a new
   * Gtk::RcStyle will be created with all values unset, and set as the
   * modifier style for the widget. If you make changes to this rc
   * style, you must call modify_style(), passing in the
   * returned rc style, to make sure that your changes take effect.
   * 
   * Caution: passing the style back to modify_style() will
   * normally end up destroying it, because modify_style() copies
   * the passed-in style and sets the copy as the new modifier style,
   * thus dropping any reference to the old modifier style. Add a reference
   * to the modifier style if you want to keep it alive.
   * @return The modifier style for the widget. This rc style is
   * owned by the widget. If you want to keep a pointer to value this
   * around, you must add a refcount using Gtk::RcStyle::ref().
   */
  Glib::RefPtr<const RcStyle> get_modifier_style() const;

  // we need custom documentation because modify_* can take a NULL pointer
  // (which we wrap with unset_*)
  /** Sets the foreground color for a widget in a particular state.
   * All other style values are left untouched. See also modify_style() and
   * unset_fg().
   *
   * @param state The state for which to set the foreground color.
   * @param color The color to assign (does not need to be allocated).
   */
  
  /** Sets the foreground color for a widget in a particular state.  All
   * other style values are left untouched. See also
   * modify_style().
   * @param state The state for which to set the foreground color.
   * @param color The color to assign (does not need to be allocated).
   */
  void modify_fg(StateType state, const Gdk::Color& color);


  /** Sets the background color for a widget in a particular state.
   * All other style values are left untouched. See also modify_style() and
   * unset_bg().
   *
   * @param state The state for which to set the background color.
   * @param color The color to assign (does not need to be allocated).
   */
  
  /** Sets the background color for a widget in a particular state.  All
   * other style values are left untouched. See also
   * modify_style().
   * @param state The state for which to set the background color.
   * @param color The color to assign (does not need to be allocated).
   */
  void modify_bg(StateType state, const Gdk::Color& color);

  // TODO: Document this, and perhaps add unset_bg_pixmap
  void modify_bg_pixmap(StateType state, const Glib::ustring& pixmap_name);

  /** Sets the text color for a widget in a particular state.
   * All other style values are left untouched. The text color is the
   * foreground color used along with the base color (see modify_base() ) for
   * widgets such as Gtk::Entry and Gtk::TextView. See also modify_style() and
   * unset_text().
   *
   * @param state The state for which to set the text color.
   * @param color The color to assign (does not need to be allocated).
   */
  
  /** Sets the text color for a widget in a particular state.  All other
   * style values are left untouched. The text color is the foreground
   * color used along with the base color (see modify_base())
   * for widgets such as Gtk::Entry and Gtk::TextView. See also
   * modify_style().
   * @param state The state for which to set the text color.
   * @param color The color to assign (does not need to be allocated).
   */
  void modify_text(StateType state, const Gdk::Color& color);

  /** Sets the base color for a widget in a particular state.
   * All other style values are left untouched. The base color is the
   * background color used along with the text color (see modify_text() ) for
   * widgets such as Gtk::Entry and Gtk::TextView. See also modify_style() and
   * unset_base().
   *
   * @param state The state for which to set the text color.
   * @param color The color to assign (does not need to be allocated).
   */
  
  /** Sets the base color for a widget in a particular state.
   * All other style values are left untouched. The base color
   * is the background color used along with the text color
   * (see modify_text()) for widgets such as Gtk::Entry
   * and Gtk::TextView. See also modify_style().
   * @param state The state for which to set the base color.
   * @param color The color to assign (does not need to be allocated).
   */
  void modify_base(StateType state, const Gdk::Color& color);

  /** Sets the font to use for a widget.
   * All other style values are left untouched. See also modify_style() and
   * unset_font().
   */
  
  /** Sets the font to use for a widget.  All other style values are left
   * untouched. See also modify_style().
   * @param font_desc The font description to use.
   */
  void modify_font(const Pango::FontDescription& font_desc);

  /** Undo the effect of previous calls to modify_fg() for a particular state.
   * All other style values are left untouched. See also modify_style().
   */
  void unset_fg(StateType state);
  
  /** Undo the effect of previous calls to modify_bg() for a particular state.
   * All other style values are left untouched. See also modify_style().
   */
  void unset_bg(StateType state);

  /** Undo the effect of previous calls to modify_text() for a particular state.
   * All other style values are left untouched. See also modify_style().
   */
  void unset_text(StateType state);

  /** Undo the effect of previous calls to modify_base() for a particular state.
   * All other style values are left untouched. See also modify_style().
   */
  void unset_base(StateType state);

  /** Undo the effect of previous calls to modify_font() for a particular state.
   * All other style values are left untouched. See also modify_style().
   */
  void unset_font();

  //The parameter name is "the_property_name" to avoid a warning because there is a method with the "property_name" name.
  template <class PropertyType>
  void get_style_property(const Glib::ustring& the_property_name, PropertyType& value) const;

  
  /** Creates a new Pango::Context with the appropriate colormap,
   * font description, and base direction for drawing text for
   * this widget. See also get_pango_context().
   * @return The new Pango::Context.
   */
  Glib::RefPtr<Pango::Context> create_pango_context();
  
  /** Gets a Pango::Context with the appropriate colormap, font description
   * and base direction for this widget. Unlike the context returned
   * by create_pango_context(), this context is owned by
   * the widget (it can be used until the screen for the widget changes
   * or the widget is removed from its toplevel), and will be updated to
   * match any changes to the widget's attributes.
   * 
   * If you create and keep a Pango::Layout using this context, you must
   * deal with changes to the context by calling pango_layout_context_changed()
   * on the layout in response to the ::style-set and ::direction-changed signals
   * for the widget.
   * @return The Pango::Context for the widget.
   */
  Glib::RefPtr<Pango::Context> get_pango_context();
  
  /** Creates a new Pango::Layout with the appropriate colormap,
   * font description, and base direction for drawing text for
   * this widget.
   * 
   * If you keep a Pango::Layout created in this way around, in order
   * notify the layout of changes to the base direction or font of this
   * widget, you must call pango_layout_context_changed() in response to
   * the ::style-set and ::direction-changed signals for the widget.
   * @param text Text to set on the layout (can be <tt>0</tt>).
   * @return The new Pango::Layout.
   */
  Glib::RefPtr<Pango::Layout> create_pango_layout(const Glib::ustring& text);

  
  /** A convenience function that uses the theme engine and RC file
   * settings for the widget to look up @a stock_id  and render it to
   * a pixbuf. @a stock_id  should be a stock icon ID such as
   * Gtk::STOCK_OPEN or Gtk::STOCK_OK. @a size  should be a size
   * such as Gtk::ICON_SIZE_MENU. @a detail  should be a string that
   * identifies the widget or code doing the rendering, so that
   * theme engines can special-case rendering for that widget or code.
   * 
   * The pixels in the returned Gdk::Pixbuf are shared with the rest of
   * the application and should not be modified. The pixbuf should be freed
   * after use with Glib::object_unref().
   * @param stock_id A stock ID.
   * @param size A stock size. A size of (GtkIconSize)-1 means render at 
   * the size of the source and don't scale (if there are multiple 
   * source sizes, GTK+ picks one of the available sizes).
   * @param detail Render detail to pass to theme engine.
   * @return A new pixbuf if the stock ID was known.
   */
  Glib::RefPtr<Gdk::Pixbuf> render_icon(const StockID& stock_id, IconSize size, const Glib::ustring& detail = Glib::ustring());

  
  /** Sets a widgets composite name. The widget must be
   * a composite child of its parent; see push_composite_child().
   * @param name The name to set.
   */
  void set_composite_name(const Glib::ustring& name);
  void unset_composite_name();
  
  /** Obtains the composite name of a widget.
   * @return The composite name of @a widget , or <tt>0</tt> if @a widget  is not
   * a composite child. The string should not be freed when it is no 
   * longer needed.
   */
  Glib::ustring get_composite_name() const;

  
  void reset_rc_styles();


  // PUSH/POP - these are used to create widgets.  Hidden arguments to override the defaults.
  
  /** Pushes @a cmap  onto a global stack of colormaps; the topmost
   * colormap on the stack will be used to create all widgets.
   * Remove @a cmap  with pop_colormap(). There's little
   * reason to use this function.
   * @param cmap A Gdk::Colormap.
   */
  static void push_colormap(const Glib::RefPtr<const Gdk::Colormap>& cmap);
  
  /** Removes a colormap pushed with push_colormap().
   */
  static void pop_colormap();

  
  /** Makes all newly-created widgets as composite children until
   * the corresponding pop_composite_child() call.
   * 
   * A composite child is a child that's an implementation detail of the
   * container it's inside and should not be visible to people using the
   * container. Composite children aren't treated differently by GTK (but
   * see Gtk::Container::foreach() vs. Gtk::Container::forall()), but e.g. GUI 
   * builders might want to treat them in a different way.
   * 
   * Here is a simple example:
   * @code
   * gtk_widget_push_composite_child (&lt;!-- --&gt;);
   * scrolled_window->hscrollbar = gtk_hscrollbar_new (hadjustment);
   * gtk_widget_set_composite_name (scrolled_window->hscrollbar, "hscrollbar");
   * gtk_widget_pop_composite_child (&lt;!-- --&gt;);
   * gtk_widget_set_parent (scrolled_window->hscrollbar, 
   * GTK_WIDGET (scrolled_window));
   * g_object_ref (scrolled_window->hscrollbar);
   * @endcode
   */
  static void push_composite_child();
  
  /** Cancels the effect of a previous call to push_composite_child().
   */
  static void pop_composite_child();


/* DEFAULTS */

  
  /** Sets the default colormap to use when creating widgets.
   * push_colormap() is a better function to use if
   * you only want to affect a few widgets, rather than all widgets.
   * @param colormap A Gdk::Colormap.
   */
  static void set_default_colormap(const Glib::RefPtr<const Gdk::Colormap>& colormap);
  
  /** Returns the default style used by all widgets initially.
   * @return The default style. This Gtk::Style object is owned by GTK+ and
   * should not be modified or freed.
   */
  static Glib::RefPtr<Style> get_default_style();
  
  /** Obtains the default colormap used to create widgets.
   * @return Default widget colormap.
   */
  static Glib::RefPtr<Gdk::Colormap> get_default_colormap();
  
  /** Obtains the visual of the default colormap. Not really useful;
   * used to be useful before gdk_colormap_get_visual() existed.
   * @return Visual of the default colormap.
   */
  static Glib::RefPtr<Gdk::Visual> get_default_visual();


/* Directionality of Text */

  
  /** Sets the reading direction on a particular widget. This direction
   * controls the primary direction for widgets containing text,
   * and also the direction in which the children of a container are
   * packed. The ability to set the direction is present in order
   * so that correct localization into languages with right-to-left
   * reading directions can be done. Generally, applications will
   * let the default reading direction present, except for containers
   * where the containers are arranged in an order that is explicitely
   * visual rather than logical (such as buttons for text justification).
   * 
   * If the direction is set to Gtk::TEXT_DIR_NONE, then the value
   * set by set_default_direction() will be used.
   * @param dir The new direction.
   */
  void set_direction(TextDirection dir);
  
  /** Gets the reading direction for a particular widget. See
   * set_direction().
   * @return The reading direction for the widget.
   */
  TextDirection get_direction();
  
  /** Sets the default reading direction for widgets where the
   * direction has not been explicitly set by set_direction().
   * @param dir The new default direction. This cannot be
   * Gtk::TEXT_DIR_NONE.
   */
  static void set_default_direction(TextDirection dir);
  
  /** Obtains the current default reading direction. See
   * set_default_direction().
   * @return The current default direction.
   */
  static TextDirection get_default_direction();


/* Shape masking */
  
  /** Sets a shape for this widget's GDK window. This allows for
   * transparent windows etc., see gdk_window_shape_combine_mask()
   * for more information.
   * @param shape_mask Shape to be added.
   * @param offset_x X position of shape mask with respect to @a window .
   * @param offset_y Y position of shape mask with respect to @a window .
   */
  void shape_combine_mask(const Glib::RefPtr<const Gdk::Bitmap>& shape_mask, int offset_x, int offset_y);
  void unset_shape_combine_mask();
  
  void input_shape_combine_mask(const Glib::RefPtr<const Gdk::Bitmap>& shape_mask, int offset_x, int offset_y);
  void unset_input_shape_combine_mask();


  // must be realized 
  
  /** Recursively resets the shape on this widget and its descendants.
   */
  void reset_shapes();

/* Paths */
  /// Compute a widget's path of the form "GtkWindow.MyLabel"
  void path(Glib::ustring& path, Glib::ustring& path_reversed);
  void class_path(Glib::ustring& path, Glib::ustring& path_reversed);
  

  /** Returns a newly allocated list of the widgets, normally labels, for 
   * which this widget is a the target of a mnemonic (see for example, 
   * Gtk::Label::set_mnemonic_widget()).
   * 
   * The widgets in the list are not individually referenced. If you
   * want to iterate through the list and perform actions involving
   * callbacks that might destroy the widgets, you
   * <em>must</em> call <tt>g_list_foreach (result,
   * (GFunc)g_object_ref, <tt>0</tt>)</tt> first, and then unref all the
   * widgets afterwards.
   * @return The list of mnemonic labels; free this list
   * with Glib::list_free() when you are done with it.
   * 
   * @newin2p4.
   */
  Glib::ListHandle<Widget*> list_mnemonic_labels();
 
  /** Returns a newly allocated list of the widgets, normally labels, for 
   * which this widget is a the target of a mnemonic (see for example, 
   * Gtk::Label::set_mnemonic_widget()).
   * 
   * The widgets in the list are not individually referenced. If you
   * want to iterate through the list and perform actions involving
   * callbacks that might destroy the widgets, you
   * <em>must</em> call <tt>g_list_foreach (result,
   * (GFunc)g_object_ref, <tt>0</tt>)</tt> first, and then unref all the
   * widgets afterwards.
   * @return The list of mnemonic labels; free this list
   * with Glib::list_free() when you are done with it.
   * 
   * @newin2p4.
   */
  Glib::ListHandle<const Widget*> list_mnemonic_labels() const;
 
  /** Adds a widget to the list of mnemonic labels for
   * this widget. (See list_mnemonic_labels()). Note the
   * list of mnemonic labels for the widget is cleared when the
   * widget is destroyed, so the caller must make sure to update
   * its internal state at this point as well.
   * 
   * @newin2p4
   * @param label A Gtk::Widget that acts as a mnemonic label for @a widget .
   */
  void add_mnemonic_label(Widget& label);
 
  /** Removes a widget from the list of mnemonic labels for
   * this widget. (See list_mnemonic_labels()). The widget
   * must have previously been added to the list with
   * add_mnemonic_label().
   * 
   * @newin2p4
   * @param label A Gtk::Widget that was previously set as a mnemnic label for
   *  @a widget  with add_mnemonic_label().
   */
  void remove_mnemonic_label(Widget& label);
           

  //TODO: Should drag_get_data() be const?
  
  void drag_get_data(const Glib::RefPtr<Gdk::DragContext>& context, Glib::ustring& target, guint32 time);		
  
  void drag_highlight();
  
  void drag_unhighlight();

  void drag_dest_set(DestDefaults flags = DestDefaults(0), Gdk::DragAction actions = Gdk::DragAction(0));
  void drag_dest_set(const ArrayHandle_TargetEntry& targets, DestDefaults flags = DEST_DEFAULT_ALL, Gdk::DragAction actions = Gdk::ACTION_COPY);
  

  void drag_dest_set_proxy(const Glib::RefPtr<Gdk::Window>& proxy_window, Gdk::DragProtocol protocol, bool use_coordinates);
  
  void drag_dest_unset();
  
  /** Looks for a match between @a context -&gt;targets and the
   *  @a dest_target_list , returning the first matching target, otherwise
   * returning Gdk::NONE. @a dest_target_list  should usually be the return
   * value from gtk_drag_dest_get_target_list(), but some widgets may
   * have different valid targets for different parts of the widget; in
   * that case, they will have to implement a drag_motion handler that
   * passes the correct target list to this function.
   * @param context Drag context.
   * @param target_list List of droppable targets.
   * @return First target that the source offers and the dest can accept, or Gdk::NONE.
   */
  Glib::ustring drag_dest_find_target(const Glib::RefPtr<Gdk::DragContext>& context, const Glib::RefPtr<TargetList>& target_list) const;
  Glib::ustring drag_dest_find_target(const Glib::RefPtr<Gdk::DragContext>& context) const;

  
  /** Returns the list of targets this widget can accept from
   * drag-and-drop.
   * @return The Gtk::TargetList, or <tt>0</tt> if none.
   */
  Glib::RefPtr<TargetList> drag_dest_get_target_list();
  
  /** Returns the list of targets this widget can accept from
   * drag-and-drop.
   * @return The Gtk::TargetList, or <tt>0</tt> if none.
   */
  Glib::RefPtr<const TargetList> drag_dest_get_target_list() const;
  
  /** Sets the target types that this widget can accept from drag-and-drop.
   * The widget must first be made into a drag destination with
   * gtk_drag_dest_set().
   * @param target_list List of droppable targets, or <tt>0</tt> for none.
   */
  void drag_dest_set_target_list(const Glib::RefPtr<TargetList>& target_list);

  
  /** Add the text targets supported by Gtk::Selection to
   * the target list of the drag destination. The targets
   * are added with @a info  = 0. If you need another value, 
   * use gtk_target_list_add_text_targets() and
   * gtk_drag_dest_set_target_list().
   * 
   * @newin2p6
   * @param widget A Gtk::Widget that's a drag destination.
   */
  void drag_dest_add_text_targets();  
  
  /** Add the image targets supported by Gtk::Selection to
   * the target list of the drag destination. The targets
   * are added with @a info  = 0. If you need another value, 
   * use gtk_target_list_add_image_targets() and
   * gtk_drag_dest_set_target_list().
   * 
   * @newin2p6
   * @param widget A Gtk::Widget that's a drag destination.
   */
  void drag_dest_add_image_targets();
  
  /** Add the URI targets supported by Gtk::Selection to
   * the target list of the drag destination. The targets
   * are added with @a info  = 0. If you need another value, 
   * use gtk_target_list_add_uri_targets() and
   * gtk_drag_dest_set_target_list().
   * 
   * @newin2p6
   * @param widget A Gtk::Widget that's a drag destination.
   */
  void drag_dest_add_uri_targets();
 
  void drag_source_set(const ArrayHandle_TargetEntry& targets, Gdk::ModifierType start_button_mask = Gdk::MODIFIER_MASK, Gdk::DragAction actions = Gdk::ACTION_COPY);
  

  void drag_source_unset();

  
  /** Sets the icon that will be used for drags from a particular widget
   * from a pixmap/mask. GTK+ retains references for the arguments, and 
   * will release them when they are no longer needed.
   * Use gtk_drag_source_set_icon_pixbuf() instead.
   * @param colormap The colormap of the icon.
   * @param pixmap The image data for the icon.
   * @param mask The transparency mask for an image.
   */
  void drag_source_set_icon(const Glib::RefPtr<Gdk::Colormap>& colormap, const Glib::RefPtr<Gdk::Pixmap>& pixmap, const Glib::RefPtr<Gdk::Bitmap>& mask);
  
  /** Sets the icon that will be used for drags from a particular widget
   * from a Gdk::Pixbuf. GTK+ retains a reference for @a pixbuf  and will 
   * release it when it is no longer needed.
   * @param pixbuf The Gdk::Pixbuf for the drag icon.
   */
  void drag_source_set_icon(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  
  /** Sets the icon that will be used for drags from a particular source
   * to a stock icon.
   * @param stock_id The ID of the stock icon to use.
   */
  void drag_source_set_icon(const StockID& stock_id);
  
  /** Sets the icon that will be used for drags from a particular source
   * to a themed icon. See the docs for Gtk::IconTheme for more details.
   * 
   * @newin2p8
   * @param widget A Gtk::Widget.
   * @param icon_name Name of icon to use.
   */
  void drag_source_set_icon(const Glib::ustring& icon_name);

  
  /** Add the text targets supported by Gtk::Selection to
   * the target list of the drag source.  The targets
   * are added with @a info  = 0. If you need another value, 
   * use gtk_target_list_add_text_targets() and
   * gtk_drag_source_set_target_list().
   * 
   * @newin2p6
   * @param widget A Gtk::Widget that's is a drag source.
   */
  void drag_source_add_text_targets();
  
  /** Add the URI targets supported by Gtk::Selection to
   * the target list of the drag source.  The targets
   * are added with @a info  = 0. If you need another value, 
   * use gtk_target_list_add_uri_targets() and
   * gtk_drag_source_set_target_list().
   * 
   * @newin2p6
   * @param widget A Gtk::Widget that's is a drag source.
   */
  void drag_source_add_uri_targets();
  
  /** Add the writable image targets supported by Gtk::Selection to
   * the target list of the drag source. The targets
   * are added with @a info  = 0. If you need another value, 
   * use gtk_target_list_add_image_targets() and
   * gtk_drag_source_set_target_list().
   * 
   * @newin2p6
   * @param widget A Gtk::Widget that's is a drag source.
   */
  void drag_source_add_image_targets();
  
  
  /** Initiates a drag on the source side. The function
   * only needs to be used when the application is
   * starting drags itself, and is not needed when
   * gtk_drag_source_set() is used.
   * @param targets The targets (data formats) in which the
   * source can provide the data.
   * @param actions A bitmask of the allowed drag actions for this drag.
   * @param button The button the user clicked to start the drag.
   * @param event The event that triggered the start of the drag.
   * @return The context for this drag.
   */
  Glib::RefPtr<Gdk::DragContext> drag_begin(const Glib::RefPtr<TargetList>& targets, Gdk::DragAction actions, int button, GdkEvent* event);
  
  /** Checks to see if a mouse drag starting at ( @a start_x , @a start_y ) and ending
   * at ( @a current_x , @a current_y ) has passed the GTK+ drag threshold, and thus
   * should trigger the beginning of a drag-and-drop operation.
   * @param start_x X coordinate of start of drag.
   * @param start_y Y coordinate of start of drag.
   * @param current_x Current X coordinate.
   * @param current_y Current Y coordinate.
   * @return <tt>true</tt> if the drag threshold has been passed.
   */
  bool drag_check_threshold(int start_x, int start_y, int current_x, int current_y);
  

  //These should be a method of Gdk::DragContext, but gdkmm can't depend on gtkmm.
  static Widget* drag_get_source_widget(const Glib::RefPtr<Gdk::DragContext>& context);
  void drag_set_as_icon(const Glib::RefPtr<Gdk::DragContext>& context, int hot_x, int hot_y);
  
  
  /** This function works like queue_resize(), except that the
   * widget is not invalidated.
   * 
   * @newin2p4
   */
  void queue_resize_no_redraw();
  
  /** Returns the current value of the "no_show_all" property, which determines
   * whether calls to show_all() and hide_all() 
   * will affect this widget.
   * @return The current value of the "no_show_all" property.
   * 
   * @newin2p4.
   */
  bool get_no_show_all() const;
  
  /** Sets the "no_show_all" property, which determines whether calls to 
   * show_all() and hide_all() will affect this widget. 
   * 
   * This is mostly for use in constructing widget hierarchies with externally
   * controlled visibility, see Gtk::UIManager.
   * 
   * @newin2p4
   * @param no_show_all The new value for the "no_show_all" property.
   */
  void set_no_show_all(bool no_show_all = true);

  //Used when implementing containers:
  
  /** This function is useful only when implementing subclasses of Gtk::Container.
   * Sets the container as the parent of @a widget , and takes care of
   * some details such as updating the state and style of the child
   * to reflect its new location. The opposite function is
   * unparent().
   * @param parent Parent container.
   */
  void set_parent(Widget& parent);
  
  /** This function is only for use in widget implementations.
   * Should be called by implementations of the remove method
   * on Gtk::Container, to dissociate a child from the container.
   */
  void unparent();

  //TODO: When exactly do we need to custom containers need to call map() on the child widgets?
  //Most containers that derive from GtkContainer do not need to, but GtkNotebook does.
  
  /** This function is only for use in widget implementations. Causes
   * a widget to be mapped if it isn't already.
   */
  void map();
  
  /** This function is only for use in widget implementations. Causes
   * a widget to be unmapped if it's currently mapped.
   */
  void unmap();

  //TODO: The drawable should be passed by reference, when we can break API/ABI, but it's not the end of the world. murrayc.
  void draw_insertion_cursor(Glib::RefPtr<Gdk::Drawable> drawable, const Gdk::Rectangle& area, const Gdk::Rectangle& location, bool is_primary, TextDirection direction, bool draw_arrow = true);
  
         
  /* FLAGS */

  //: Returns property {flags.toplevel}.
  bool is_toplevel() const;

  //: Returns property {flags.nowindow}.
  bool has_no_window() const;

  //: Returns property {flags.realized}.
  bool is_realized() const;

  //: Returns property {flags.mapped}.
  bool is_mapped() const;

  //: Returns property {flags.visible}.
  bool is_visible() const; 

  //: Returns if the widget is ready to be drawn to.
  // Checks to see if the widget is both visible and mapped which
  // makes it possible to perform drawing commands on.
  bool is_drawable() const;
  
  //: Returns property {flags.sensitive}. You might want to check
  // is_sensitive instead.
  bool sensitive() const;

  bool parent_sensitive() const;
  bool is_sensitive() const;
  bool can_focus() const;
  bool has_focus() const;
  bool can_default() const;
  bool has_default() const;
  bool has_grab() const;
  bool rc_style() const;
  bool is_composite_child() const;
  bool app_paintable() const;
  bool receives_default() const;
  bool double_buffered() const;

  WidgetFlags get_flags() const;
  void set_flags(WidgetFlags flags);
  void unset_flags(WidgetFlags flags);

  int get_width() const;
  int get_height() const;

  
  bool is_composited() const;

  //From gtkaction.h:
  
  Glib::RefPtr<Action> get_action();
  
  Glib::RefPtr<const Action> get_action() const;

   Gtk::StateType get_state() const;
    Gtk::StateType get_saved_state() const;
    Requisition get_requisition() const;
    Allocation get_allocation() const;
    Glib::RefPtr<Gdk::Window> get_window();
  Glib::RefPtr<const Gdk::Window> get_window() const;
 

/**
   * @par Prototype:
   * <tt>void %show()</tt>
   */

  Glib::SignalProxy0< void > signal_show();

  
/**
   * @par Prototype:
   * <tt>void %hide()</tt>
   */

  Glib::SignalProxy0< void > signal_hide();


  //: Emitted on mapping of a widget to the screen.
  //- See {flags.mapped}.
  
/**
   * @par Prototype:
   * <tt>void %map()</tt>
   */

  Glib::SignalProxy0< void > signal_map();


  //- See {flags.mapped}.
  
/**
   * @par Prototype:
   * <tt>void %unmap()</tt>
   */

  Glib::SignalProxy0< void > signal_unmap();


  //: Emitted on realization of a widget.
  //- See {flags.realized}.  This is also responsible for
  //- setting {flags.realized} when it is done.  Therefore, 
  //- when overriding the impl method, you should call the 
  //- default realize method.
  
/**
   * @par Prototype:
   * <tt>void %realize()</tt>
   */

  Glib::SignalProxy0< void > signal_realize();


  //- See {flags.realized}.  This should not be called by the user.
  //__WRAP(meth|sig|impl,void unrealize_(),gtk_widget_unrealize,"unrealize")
  
/**
   * @par Prototype:
   * <tt>void %unrealize()</tt>
   */

  Glib::SignalProxy0< void > signal_unrealize();


/**
   * @par Prototype:
   * <tt>void %size_request(Requisition* requisition)</tt>
   */

  Glib::SignalProxy1< void,Requisition* > signal_size_request();

  
/**
   * @par Prototype:
   * <tt>void %size_allocate(Allocation& allocation)</tt>
   */

  Glib::SignalProxy1< void,Allocation& > signal_size_allocate();


// Changed signals -- inform widget of internal changes.
// We rename parent_set => parent_changed 
//  and      style_set  => style_changed 
//  to avoid confusion with set_parent and set_style.

  
/**
   * @par Prototype:
   * <tt>void %state_changed(Gtk::StateType previous_state)</tt>
   */

  Glib::SignalProxy1< void,Gtk::StateType > signal_state_changed();


  //: Informs objects that their parent changed.
  //- The widget passed is the former parent, which may be 0 if 
  //- there was no parent. (was parent_set in GTK+)
  
/**
   * @par Prototype:
   * <tt>void %parent_changed(Widget* previous_parent)</tt>
   */

  Glib::SignalProxy1< void,Widget* > signal_parent_changed();


/**
   * @par Prototype:
   * <tt>void %hierarchy_changed(Widget* previous_toplevel)</tt>
   */

  Glib::SignalProxy1< void,Widget* > signal_hierarchy_changed();


  /** The style-set signal is emitted when a new style has been set 
   * on a widget. Note that style-modifying functions like 
   * modify_base() also cause this signal to be emitted.
   *
   * @param previous_style  the previous style, or an empty RefPtr if the widget 
   * just got its initial style. 
   */
  
/**
   * @par Prototype:
   * <tt>void %style_changed(const Glib::RefPtr<Style>& previous_style)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Style>& > signal_style_changed();


/**
   * @par Prototype:
   * <tt>void %direction_changed(TextDirection direction)</tt>
   */

  Glib::SignalProxy1< void,TextDirection > signal_direction_changed();


/**
   * @par Prototype:
   * <tt>void %grab_notify(bool was_grabbed)</tt>
   */

  Glib::SignalProxy1< void,bool > signal_grab_notify();


 /** The ::child-notify signal is emitted for each child property that has 
  * changed on an object. The signal's detail holds the property name. 
  *
  * @param pspec The GParamSpec of the changed child property.
  */
  
/**
   * @par Prototype:
   * <tt>void %child_notify(GParamSpec* pspec)</tt>
   */

  Glib::SignalProxy1< void,GParamSpec* > signal_child_notify();


  //_WRAP_SIGNAL(void add_accelerator(guint, GtkAccelGroup*, guint accel_key, Gdk::ModifierType, AccelFlags), "add-accelerator")
  //_WRAP_SIGNAL(void remove_accelerator(GtkAccelGroup* accel_group, guint, Gdk::ModifierType), "remove-accelerator")
  
/**
   * @par Prototype:
   * <tt>bool %mnemonic_activate(bool group_cycling)</tt>
   */

  Glib::SignalProxy1< bool,bool > signal_mnemonic_activate();

  
/**
   * @par Prototype:
   * <tt>void %grab_focus()</tt>
   */

  Glib::SignalProxy0< void > signal_grab_focus();

  
/**
   * @par Prototype:
   * <tt>bool %focus(DirectionType direction)</tt>
   */

  Glib::SignalProxy1< bool,DirectionType > signal_focus();

  
/**
   * @par Prototype:
   * <tt>bool %event(GdkEvent* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEvent* > signal_event();

  
/**
   * @par Prototype:
   * <tt>void %event_after(GdkEvent* event)</tt>
   */

  Glib::SignalProxy1< void,GdkEvent* > signal_event_after();


  //: Event triggered by user pressing button.
  
/**
   * @par Prototype:
   * <tt>bool %button_press_event(GdkEventButton* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventButton* > signal_button_press_event();


  //: Event triggered by user releasing button.
  
/**
   * @par Prototype:
   * <tt>bool %button_release_event(GdkEventButton* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventButton* > signal_button_release_event();


/**
   * @par Prototype:
   * <tt>bool %scroll_event(GdkEventScroll* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventScroll* > signal_scroll_event();


  //: Event triggered by user moving pointer.
  
/**
   * @par Prototype:
   * <tt>bool %motion_notify_event(GdkEventMotion* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventMotion* > signal_motion_notify_event();


 /** The delete_event signal is emitted if a user requests that
  * a toplevel window is closed. The default handler for this signal
  * hides the window.
  *
  * @param event the event which triggered this signal.
  * @result true to stop other handlers from being invoked for the event, 
  * or false to propagate the event. further.
  */
  
/**
   * @par Prototype:
   * <tt>bool %delete_event(GdkEventAny* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventAny* > signal_delete_event();


  //: Event triggered by window requiring a refresh.
  //- Expose events cover a rectangular area that was covered
  //- or obscured by another window.  That area is now exposed
  //- and thus is needs to be redrawn.  
  //-
  //- If the application is not capable of redrawing sections
  //- it should watch the count field and only draw on the last
  //- even indicated.  This is important for things such as 
  //- Gtk::DrawingArea. 
  
/**
   * @par Prototype:
   * <tt>bool %expose_event(GdkEventExpose* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventExpose* > signal_expose_event();


  //: Event triggered by a key press will widget has focus.
  
/**
   * @par Prototype:
   * <tt>bool %key_press_event(GdkEventKey* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventKey* > signal_key_press_event();


  //: Event triggered by a key release will widget has focus.
  
/**
   * @par Prototype:
   * <tt>bool %key_release_event(GdkEventKey* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventKey* > signal_key_release_event();


  //: Event triggered by pointer entering widget area.
  
/**
   * @par Prototype:
   * <tt>bool %enter_notify_event(GdkEventCrossing* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventCrossing* > signal_enter_notify_event();


  //: Event triggered by pointer leaving widget area.
  
/**
   * @par Prototype:
   * <tt>bool %leave_notify_event(GdkEventCrossing* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventCrossing* > signal_leave_notify_event();

 
  //: Event triggered by a window resizing.
  
/**
   * @par Prototype:
   * <tt>bool %configure_event(GdkEventConfigure* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventConfigure* > signal_configure_event();

  
/**
   * @par Prototype:
   * <tt>bool %focus_in_event(GdkEventFocus* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventFocus* > signal_focus_in_event();

  
/**
   * @par Prototype:
   * <tt>bool %focus_out_event(GdkEventFocus* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventFocus* > signal_focus_out_event();

  
/**
   * @par Prototype:
   * <tt>bool %map_event(GdkEventAny* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventAny* > signal_map_event();

  
/**
   * @par Prototype:
   * <tt>bool %unmap_event(GdkEventAny* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventAny* > signal_unmap_event();

  
/**
   * @par Prototype:
   * <tt>bool %property_notify_event(GdkEventProperty* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventProperty* > signal_property_notify_event();

  
/**
   * @par Prototype:
   * <tt>bool %selection_clear_event(GdkEventSelection* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventSelection* > signal_selection_clear_event();

  
/**
   * @par Prototype:
   * <tt>bool %selection_request_event(GdkEventSelection* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventSelection* > signal_selection_request_event();

  
/**
   * @par Prototype:
   * <tt>bool %selection_notify_event(GdkEventSelection* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventSelection* > signal_selection_notify_event();

  
/**
   * @par Prototype:
   * <tt>bool %proximity_in_event(GdkEventProximity* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventProximity* > signal_proximity_in_event();

  
/**
   * @par Prototype:
   * <tt>bool %proximity_out_event(GdkEventProximity* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventProximity* > signal_proximity_out_event();

  
/**
   * @par Prototype:
   * <tt>bool %visibility_notify_event(GdkEventVisibility* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventVisibility* > signal_visibility_notify_event();

  
/**
   * @par Prototype:
   * <tt>bool %client_event(GdkEventClient* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventClient* > signal_client_event();

  
/**
   * @par Prototype:
   * <tt>bool %no_expose_event(GdkEventAny* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventAny* > signal_no_expose_event();

  
/**
   * @par Prototype:
   * <tt>bool %window_state_event(GdkEventWindowState* event)</tt>
   */

  Glib::SignalProxy1< bool,GdkEventWindowState* > signal_window_state_event();


  //We use the optional custom_c_callback parameter with _WRAP_SIGNAL() for some of these,
  //so that we can write special code to wrap the non-const SelectionData& output parameters:
  
/**
   * @par Prototype:
   * <tt>void %selection_get(SelectionData& selection_data, guint info, guint time)</tt>
   */

  Glib::SignalProxy3< void,SelectionData&,guint,guint > signal_selection_get();

  
/**
   * @par Prototype:
   * <tt>void %selection_received(const SelectionData& selection_data, guint time)</tt>
   */

  Glib::SignalProxy2< void,const SelectionData&,guint > signal_selection_received();

  
  /** THe drag_begin signal is emitted on the drag source when a drag is started. 
   * A typical reason to connect to this signal is to set up a custom drag icon with
   * drag_source_set_icon().
   *
   * @param context the drag context
   */
  
/**
   * @par Prototype:
   * <tt>void %drag_begin(const Glib::RefPtr<Gdk::DragContext>& context)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Gdk::DragContext>& > signal_drag_begin();

  
  /** The drag_end signal is emitted on the drag source when a drag is finished. 
   * A typical reason to connect to this signal is to undo things done in the drag-begin 
   * signal handler.
   *
   * @param context the drag context.
   */
  
/**
   * @par Prototype:
   * <tt>void %drag_end(const Glib::RefPtr<Gdk::DragContext>& context)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Gdk::DragContext>& > signal_drag_end();


  /** The drag_data_get signal is emitted on the drag source when the drop site requests
   * the data which is dragged. It is the responsibility of the signal handler to fill @a data
   * with the data in the format which is indicated by @a info. See SelectionData::set() and 
   * SelectionData::set_text().
   *
   * @param context: the drag context.
   * @param selection_data the SelectionData to be filled with the dragged data.
   * @param info the info that has been registered with the target in the TargetList.
   * @param time the timestamp at which the data was requested.
   */
  
/**
   * @par Prototype:
   * <tt>void %drag_data_get(const Glib::RefPtr<Gdk::DragContext>& context, SelectionData& selection_data, guint info, guint time)</tt>
   */

  Glib::SignalProxy4< void,const Glib::RefPtr<Gdk::DragContext>&,SelectionData&,guint,guint > signal_drag_data_get();

  
  /**  The drag_data_delete signal is emitted on the drag source when a drag with the action
   * Gdk::ACTION_MOVE is successfully completed. The signal handler is responsible for deleting
   * the data that has been dropped. What "delete" means, depends on the context of the drag
   * operation. 
   *
   * @param context the drag context.
   */
  
/**
   * @par Prototype:
   * <tt>void %drag_data_delete(const Glib::RefPtr<Gdk::DragContext>& context)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Gdk::DragContext>& > signal_drag_data_delete();

  
  /**  The drag_leave signal is emitted on the drop site when the cursor leaves the widget.
   * A typical reason to connect to this signal is to undo things done in the drag_motion signal handler, 
   *  e.g. undo highlighting with drag_unhighlight().
   *
   * @param context the drag context.
   * @param time the timestamp of the motion event.
   */
  
/**
   * @par Prototype:
   * <tt>void %drag_leave(const Glib::RefPtr<Gdk::DragContext>& context, guint time)</tt>
   */

  Glib::SignalProxy2< void,const Glib::RefPtr<Gdk::DragContext>&,guint > signal_drag_leave();

  
  /** The drag_motion signal is emitted on the drop site when the user moves the cursor over
   * the widget during a drag. The signal handler must determine whether the cursor position is in 
   * a drop zone or not. If it is not in a drop zone, it returns false and no further processing is
   * necessary. Otherwise, the handler returns true. In this case, the handler is responsible for
   * providing the necessary information for displaying feedback to the user, by calling
   * drag_status(). If the decision whether the drop will be accepted or rejected can't be made
   * based solely on the cursor position and the type of the data, the handler may inspect the dragged 
   * data by calling drag_get_data() and defer the drag_status() call to the drag_data_received 
   * handler. 
   *
   * Note that there is no drag_enter signal. The drag receiver has to keep track of whether
   * he has received any drag_motion signals since the last drag_leave and if not, treat the
   * drag_motion signal as an "enter" signal. Upon an "enter", the handler will typically highlight 
   * the drop site with drag_highlight().
   * 
   * @param context the drag context.
   * @param x the x coordinate of the current cursor position.
   * @param y the y coordinate of the current cursor position.
   * @param time the timestamp of the motion event.
   * @result whether the cursor position is in a drop zone.
   */
  
/**
   * @par Prototype:
   * <tt>bool %drag_motion(const Glib::RefPtr<Gdk::DragContext>& context, int x, int y, guint time)</tt>
   */

  Glib::SignalProxy4< bool,const Glib::RefPtr<Gdk::DragContext>&,int,int,guint > signal_drag_motion();

  
  /** The drag_drop signal is emitted on the drop site when the user drops the data
   * onto the widget. The signal handler must determine whether the cursor position is in 
   * a drop zone or not. If it is not in a drop zone, it returns false and no further 
   * processing is necessary. Otherwise, the handler returns true. In this case, the handler 
   * must ensure that gtk_drag_finish() is called to let the source know that the drop is done.
   * The call to gtk_drag_finish() can be done either directly or in a drag_data_received handler
   * which gets triggered by calling drop_get_data() to receive the data for one or more of the 
   * supported targets.
   *
   * @param context the drag context.
   * @param x the x coordinate of the current cursor position.
   * @param y the y coordinate of the current cursor position.
   * @param time: the timestamp of the motion event.
   * @result whether the cursor position is in a drop zone
   */
  
/**
   * @par Prototype:
   * <tt>bool %drag_drop(const Glib::RefPtr<Gdk::DragContext>& context, int x, int y, guint time)</tt>
   */

  Glib::SignalProxy4< bool,const Glib::RefPtr<Gdk::DragContext>&,int,int,guint > signal_drag_drop();

  
  /** The drag_data_received signal is emitted on the drop site when the dragged data has been 
   * received. If the data was received in order to determine whether the drop will be accepted, 
   * the handler is expected to call drag_status() and <emphasis>not</emphasis> finish the drag. 
   * If the data was received in response to a drag_drop signal (and this is the last target to be 
   * received), the handler for this signal is expected to process the received data and then call 
   * drag_finish(), setting the @a success parameter depending on whether the data was processed 
   * successfully.
   *
   * The handler may inspect and modify @drag_context->action before calling gtk_drag_finish(), 
   * e.g. to implement %Gdk::ACTION_ASK.
   *
   * @param drag_context the drag context
   * @param x where the drop happened
   * @param y where the drop happened
   * @param data the received data
   * @param info the info that has been registered with the target in the TargetList.
   * @param time the timestamp at which the data was received.
   */
  
/**
   * @par Prototype:
   * <tt>void %drag_data_received(const Glib::RefPtr<Gdk::DragContext>& context, int x, int y, const SelectionData& selection_data, guint info, guint time)</tt>
   */

  Glib::SignalProxy6< void,const Glib::RefPtr<Gdk::DragContext>&,int,int,const SelectionData&,guint,guint > signal_drag_data_received();


  //Note that the deprecated keyword has no effect on _WRAP_SIGNAL() yet.
  //It doesn't seem like a good idea to put virtual functions in #ifdefs, because that would change the size of the class instances.
  /** @deprecated This should never have been in the API. It was never meaningful.
   */
  
/**
   * @par Prototype:
   * <tt>Glib::RefPtr<Atk::Object> %get_accessible()</tt>
   */

#ifdef GTKMM_ATKMM_ENABLED
  Glib::SignalProxy0< Glib::RefPtr<Atk::Object> > signal_get_accessible();
#endif // GTKMM_ATKMM_ENABLED

  
/**
   * @par Prototype:
   * <tt>void %screen_changed(const Glib::RefPtr<Gdk::Screen>& previous_screen)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Gdk::Screen>& > signal_screen_changed();


/**
   * @par Prototype:
   * <tt>void %composited_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_composited_changed();


//TODO: The signal_id is very C-like here:                                                                          
  //_WRAP_SIGNAL(bool can_activate_accel(guint signal_id), "can_activate_accel")
  
  //Keybinding signals:
   //TODO: This might actually be useful. See the C docs.
  

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The parent widget of this widget. Must be a Container widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Container*> property_parent() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The parent widget of this widget. Must be a Container widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Container*> property_parent() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Override for width request of the widget
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_width_request() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Override for width request of the widget
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_width_request() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Override for height request of the widget
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_height_request() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Override for height request of the widget
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_height_request() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the widget is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_visible() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the widget is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_visible() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the widget responds to input.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_sensitive() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the widget responds to input.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_sensitive() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the application will paint directly on the widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_app_paintable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the application will paint directly on the widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_app_paintable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the widget can accept the input focus.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_can_focus() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the widget can accept the input focus.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_can_focus() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the widget has the input focus.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_has_focus() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the widget has the input focus.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_has_focus() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the widget can be the default widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_can_default() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the widget can be the default widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_can_default() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the widget is the default widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_has_default() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the widget is the default widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_has_default() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_receives_default() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_receives_default() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the widget is part of a composite widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_composite_child() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The style of the widget
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Style> > property_style() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The style of the widget
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Style> > property_style() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The event mask that decides what kind of GdkEvents this widget gets.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gdk::EventMask> property_events() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The event mask that decides what kind of GdkEvents this widget gets.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gdk::EventMask> property_events() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The mask that decides what kind of extension events this widget gets.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gdk::ExtensionMode> property_extension_events() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The mask that decides what kind of extension events this widget gets.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gdk::ExtensionMode> property_extension_events() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:
  //comment in GTK+ header: "seldomly overidden"
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void dispatch_child_properties_changed_vfunc(guint p1, GParamSpec** p2);
#endif //GLIBMM_VFUNCS_ENABLED


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void show_all_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void hide_all_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED


  #ifdef GLIBMM_VFUNCS_ENABLED

#ifdef  GTKMM_ATKMM_ENABLED
  virtual Glib::RefPtr<Atk::Object> get_accessible_vfunc();

#endif //  GTKMM_ATKMM_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


protected:
  Widget();

  
  /** Creates the GDK (windowing system) resources associated with a
   * widget.  For example, @a widget -&gt;window will be created when a widget
   * is realized.  Normally realization happens implicitly; if you show
   * a widget and all its parent containers, then the widget will be
   * realized and mapped automatically.
   * 
   * Realizing a widget requires all
   * the widget's parent widgets to be realized; calling
   * realize() realizes the widget's parents in addition to
   *  @a widget  itself. If a widget is not yet inside a toplevel window
   * when you realize it, bad things will happen.
   * 
   * This function is primarily used in widget implementations, and
   * isn't very useful otherwise. Many times when you think you might
   * need it, a better approach is to connect to a signal that will be
   * called after the widget is realized automatically, such as
   * "expose_event". Or simply Glib::signal_connect_after() to the
   * "realize" signal.
   */
  void realize();
  
  /** This function is only useful in widget implementations.
   * Causes a widget to be unrealized (frees all GDK resources
   * associated with the widget, such as @a widget -&gt;window).
   */
  void unrealize();

  
  /** This function is only for use in widget implementations. Obtains
   *  @a widget -&gt;requisition, unless someone has forced a particular
   * geometry on the widget (e.g. with set_usize()), in which
   * case it returns that geometry instead of the widget's requisition.
   * 
   * This function differs from size_request() in that
   * it retrieves the last size request value from @a widget -&gt;requisition,
   * while size_request() actually calls the "size_request" method
   * on @a widget  to compute the size request and fill in @a widget -&gt;requisition,
   * and only then returns @a widget -&gt;requisition.
   * 
   * Because this function does not call the "size_request" method, it
   * can only be used when you know that @a widget -&gt;requisition is
   * up-to-date, that is, size_request() has been called
   * since the last time a resize was queued. In general, only container
   * implementations have this information; applications should use
   * size_request().
   * @param requisition A Gtk::Requisition to be filled in.
   */
  void get_child_requisition(Requisition& requisition) const;

  //The parameter name is "the_property_name" to avoid a warning because there is a method with the "property_name" name.
  
  /** Gets the value of a style property of @a widget .
   * @param the_property_name The name of a style property.
   * @param value Location to return the property value.
   */
  void get_style_property_value(
                   const Glib::ustring& the_property_name, Glib::ValueBase& value) const;

  void realize_if_needed();

   void set_allocation(const Allocation& value);
    void set_window(const Glib::RefPtr<Gdk::Window>& value);
 

};


#ifndef DOXYGEN_SHOULD_SKIP_THIS

//The parameter name is "the_property_name" to avoid a warning because there is a method with the "property_name" name.
template <class PropertyType>
void Widget::get_style_property(const Glib::ustring& the_property_name, PropertyType& value) const
{
  Glib::Value<PropertyType> property_value;
  property_value.init(Glib::Value<PropertyType>::value_type());

  this->get_style_property_value(the_property_name, property_value);

  value = property_value.get();
}

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::Widget
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Gtk::Widget* wrap(GtkWidget* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_WIDGET_H */

