/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;

import org.gnu.glib.Handle;
import org.gnu.glib.Boxed;

/**
 * Represents attributes which are languages.
 */
public class AttrLanguage extends Attribute {
    /**
     * Returns the value of the object.
     */
    public Language getValue() {
        Handle hndl = getValue(getHandle());
        if (hndl != null) {
            Boxed box = Boxed.getBoxedFromHandle(hndl);
            if (box != null) {
                return (Language) box;
            } else {
                return new Language(hndl);
            }
        }
        return null;
    }

    native static final protected Handle getValue(Handle obj);
}
