/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2006 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.glib;

/**
 * Represents a particular type of an event. Each event has an associated type.
 */
public class EventType {
    /** Event type identifier */
    private int id;

    /**
     * Name for the event type. This is used in the event#toString method.
     */
    private String name;

    /**
     */
    public int getID() {
        return id;
    }

    /**
     */
    public String getName() {
        return name;
    }

    /**
     * Constructs a new event type
     * 
     * @param typeID
     *            Type Identifier
     * @param typeName
     *            String to be displayed as part of the event.toString method.
     */
    public EventType(int typeID, String typeName) {
        id = typeID;
        name = typeName;
    }
}
