/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * A DataRow is simply a list of data, which represent a row that can be added
 * to store components, such as {@link org.gnu.gtk.ListStore} and
 * {@link org.gnu.gtk.TreeStore}.
 * </p>
 * <p>
 * To create a DataRow and add it to a store is pretty straight forward:
 * </p>
 * <p>
 * <code>store.addRow(new DataRow() .add(name) .add(type) .add(icon));</code>
 * </p>
 */
public class DataRow {

    private List items = new ArrayList();

    /**
     * Get the data at column <code>aCol</code>
     * 
     * @param aCol
     *            the column number, starting from 0.
     * @return the data at that column
     */
    public Object get(int aCol) {
        return items.get(aCol);
    }

    /**
     * Get all data in this row.
     * 
     * @return a List, with the data of each row.
     */
    public List getAll() {
        return items;
    }

    /**
     * Adds a data to this row. This will fill the columns of the row
     * sequentially: the first call is the first column, and so it goes.
     * 
     * @param aData
     *            a data to be added to the row
     * @return this DataRow. The reason why it returns this object is so you can
     *         make useful constructions, such as:
     *         <code>new DataRow() .add(name) .add(type) .add(icon)</code>
     */
    public DataRow add(Object aData) {
        items.add(aData);

        return this;
    }
}
