// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_MESSAGEDIALOG_H
#define _GTKMM_MESSAGEDIALOG_H


#include <glibmm.h>

/* $Id: messagedialog.hg,v 1.14 2006/02/25 12:38:11 murrayc Exp $ */

/* messagedialog.h
 *
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/dialog.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkMessageDialog GtkMessageDialog;
typedef struct _GtkMessageDialogClass GtkMessageDialogClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class MessageDialog_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum MessageType
{
  MESSAGE_INFO,
  MESSAGE_WARNING,
  MESSAGE_QUESTION,
  MESSAGE_ERROR
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::MessageType> : public Glib::Value_Enum<Gtk::MessageType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum ButtonsType
{
  BUTTONS_NONE,
  BUTTONS_OK,
  BUTTONS_CLOSE,
  BUTTONS_CANCEL,
  BUTTONS_YES_NO,
  BUTTONS_OK_CANCEL
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ButtonsType> : public Glib::Value_Enum<Gtk::ButtonsType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** Convenient message window.
 *
 * Gtk::MessageDialog presents a dialog with an image representing the type
 * of message (Error, Question, etc.) alongside some message text. It's
 * simply a convenience widget; you could construct the equivalent of
 * Gtk::MessageDialog from Gtk::Dialog without too much effort, but
 * Gtk::MessageDialog saves typing. 
 *
 * @ingroup Dialogs
 */

class MessageDialog : public Dialog
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef MessageDialog CppObjectType;
  typedef MessageDialog_Class CppClassType;
  typedef GtkMessageDialog BaseObjectType;
  typedef GtkMessageDialogClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~MessageDialog();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class MessageDialog_Class;
  static CppClassType messagedialog_class_;

  // noncopyable
  MessageDialog(const MessageDialog&);
  MessageDialog& operator=(const MessageDialog&);

protected:
  explicit MessageDialog(const Glib::ConstructParams& construct_params);
  explicit MessageDialog(GtkMessageDialog* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkMessageDialog*       gobj()       { return reinterpret_cast<GtkMessageDialog*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkMessageDialog* gobj() const { return reinterpret_cast<GtkMessageDialog*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::


private:

  
public:
  explicit MessageDialog(const Glib::ustring& message, bool use_markup = false, MessageType type = MESSAGE_INFO, ButtonsType buttons = BUTTONS_OK, bool modal = false);
  MessageDialog(Gtk::Window& parent, const Glib::ustring& message, bool use_markup = false, MessageType type = MESSAGE_INFO, ButtonsType buttons = BUTTONS_OK, bool modal = false);
  

#ifndef GTKMM_DISABLE_DEPRECATED

  /** Sets the text of the message dialog to be @a str , which is marked
   * up with the Pango text markup
   * language.
   * 
   * @newin2p4
   * @deprecated Use set_message(string, true).
   * @param str Markup string (see Pango markup format).
   */
  void set_markup(const Glib::ustring& str);
#endif // GTKMM_DISABLE_DEPRECATED


  /** Sets the primary text of the message dialog.
   *
   * @param text The message.
   * @param use_markup Whether @a message contains pango markup.
   */
  void set_message(const Glib::ustring& message, bool use_markup = false);
  
  
  /** Sets the secondary text of the message dialog.
   * Note that setting a secondary text makes the primary text become bold, unless you have provided explicit markup.
   *
   * @newin2p6.
   *
   * @param text The message.
   * @param use_markup Whether @a message contains pango markup.
   */
  void set_secondary_text(const Glib::ustring& text, bool use_markup = false);
  

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The type of message.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<MessageType> property_message_type() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The type of message.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<MessageType> property_message_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The buttons shown in the message dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ButtonsType> property_buttons() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The primary text of the message dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_text() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The primary text of the message dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_text() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The primary text of the title includes Pango markup.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_use_markup() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The primary text of the title includes Pango markup.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_use_markup() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The secondary text of the message dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_secondary_text() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The secondary text of the message dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_secondary_text() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The secondary text includes Pango markup.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_secondary_use_markup() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The secondary text includes Pango markup.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_secondary_use_markup() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::MessageDialog
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Gtk::MessageDialog* wrap(GtkMessageDialog* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_MESSAGEDIALOG_H */

