/*
 * Java-Gnome Bindings Library
 *
 * * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

import org.gnu.glib.EventType;


/**
 * An event representing a request for formatting information for the label of 
 * a scale widget
 * @see ScaleListener
 * @see org.gnu.gtk.Scale
 */
public class ScaleEvent extends GtkEvent {

	public static class Type extends EventType{
		private Type(int id, String name){
			super(id, name);
		}

		/**
		 * This event indicates that the menu item has been activated.
		 */
		public static final Type FORMAT_VALUE = new Type(1, "FORMAT_VALUE");
	}

	/**
	 * Creates a new Scale Event. This is used internally by java-gnome. Users
	 * only have to deal with listeners.
	 */
	public ScaleEvent(Object source) {
		super(source, Type.FORMAT_VALUE);
	}

	public boolean equals(ScaleEvent event2){
		return true;
	}


}
