// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GCONFMM_ENTRY_H
#define _GCONFMM_ENTRY_H

#include <glibmm.h>

// -*- Mode: C++; c-basic-offset: 4  -*-
/* $Id: entry.hg,v 1.4 2002/12/10 23:26:01 murrayc Exp $ */

/* entry.hg
 * 
 * Copyright (C) 2000-2002 GConfmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gconfmm/value.h>
#include <gconfmm/schema.h>


extern "C" {
  typedef struct _GConfEntry GConfEntry;
}

namespace Gnome
{

namespace Conf
{

/** An Entry stores an entry from a GConf "directory", including a 
 * key-value pair, the name of the Schema applicable to this entry, 
 * whether the value is a default value, and whether GConf can write 
 * a new value at this key. The key should be an absolute key, not a relative key.
 */
class Entry
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Entry CppObjectType;
  typedef GConfEntry BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Entry();

  // Use make_a_copy=true when getting it directly from a struct.
  explicit Entry(GConfEntry* castitem, bool make_a_copy = false);

  Entry(const Entry& src);
  Entry& operator=(const Entry& src);

  ~Entry();

  GConfEntry*       gobj()       { return gobject_; }
  const GConfEntry* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GConfEntry* gobj_copy() const;

protected:
  GConfEntry* gobject_;

private:

  
public:
  /** Construct an Entry with the given @p key and @p value */
  Entry(const Glib::ustring& key, const Value& value);

  /** Set the Value of the entry. */
  
  void set_value(const Value& val);

  /** Set the Schema name of the entry. */
  
  void set_schema_name(const Glib::ustring& val);

  /** Set whether the value has orginated from the default given in the Schema */
  
  void set_is_default(bool is_default = true);

  /** Set whether the given configuration key iw writeable. */
  
  void set_is_writable(bool is_writable = true);

  /** Retrieve the value of the entry.
   * @return a copy the entry's value. */
  Value get_value() const;
  

  /** Retrieve the Schema name associated with the given entry */
  
  Glib::ustring get_schema_name() const;

  /* Retrieve the configuration key this entry points to */
  
  Glib::ustring get_key() const;

  /* Retrieve wether this Entry contains the default value, as defined in the Schema. */
  
  bool get_is_default() const;

  /* Get the writeable status of the configuration key of this entry. */
  
  bool get_is_writable() const;

private:
  static GConfEntry* entry_copy(const GConfEntry*);


};

} /* namespace Conf */
} /* namespace Gnome */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{
namespace Container_Helpers
{

template<>
struct TypeTraits<Gnome::Conf::Entry> 
{
    typedef Gnome::Conf::Entry CppType;
    typedef const GConfEntry* CType;
    typedef GConfEntry* CTypeNonConst;
    
    static CType   to_c_type      (const CppType& item) { return item.gobj(); }
    static CType   to_c_type      (const CType&   item) { return item; }
    static CppType to_cpp_type    (const CType&   item) { return Gnome::Conf::Entry(const_cast<CTypeNonConst>(item)); }
    static void    release_c_type (const CType&)        {}
};

} // Namespace Container_Helpers
} // namespace Glib
#endif // DOXYGEN_SHOULD_SKIP_THIS


namespace Glib
{

  /** @relates Gnome::Conf::Entry
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
Gnome::Conf::Entry wrap(GConfEntry* object, bool take_copy = false);

} // namespace Glib

#endif /* _GCONFMM_ENTRY_H */

