/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome;

import org.gnu.glib.GObject;
import org.gnu.gtk.AccelGroup;
import org.gnu.gtk.Menu;
import org.gnu.gtk.Widget;
import org.gnu.javagnome.Handle;

/**
 * @deprecated
 */
public class PopupMenu extends Menu {
	
	/**
	 * Construct a new PopupMenu object.
	 */
	public PopupMenu(UIInfo [] uiinfos) {
		super(init1(uiinfos));
	}
	
	private static Handle init1(UIInfo[] uiinfos) {
		Handle [] hndls= new Handle[uiinfos.length];
		for (int i = 0; i < uiinfos.length; i++) {
			hndls[i] = uiinfos[i].getHandle();
		}
		return gnome_popup_menu_new(hndls);
	}
	
	/**
	 * Construct a new PopupMenu object.
	 */
	public PopupMenu(UIInfo [] uiinfos, AccelGroup accelGroup) {
		super(init2(uiinfos, accelGroup));
	}
	
	private static Handle init2(UIInfo [] uiinfos, AccelGroup accelGroup) {
		Handle [] hndls= new Handle[uiinfos.length];
		for (int i = 0; i < uiinfos.length; i++) {
			hndls[i] = uiinfos[i].getHandle();
		}
		return gnome_popup_menu_new_with_accelgroup(hndls, accelGroup.getHandle());
	}
	
	/**
	 * Return the AccelGroup associated with this PopupMenu.
	 */
	public AccelGroup getAccelGroup() {
		Handle hndl = gnome_popup_menu_get_accel_group(getHandle());
		GObject obj = getGObjectFromHandle(hndl);
		if (null != obj)
			return (AccelGroup)obj;
		return new AccelGroup(hndl);
	}
	
	/**
	 * Attach this menu to a Widget.
	 */
	public void attach(Widget widget) {
		gnome_popup_menu_attach(getHandle(), widget.getHandle(), null);
	}
	
	/**
	 * Append new menu items to the PopupMenu.
	 */
	public void append(UIInfo [] uiinfos) {
		Handle [] hndls= new Handle[uiinfos.length];
		for (int i = 0; i < uiinfos.length; i++) {
			hndls[i] = uiinfos[i].getHandle();
		}
		gnome_popup_menu_append(getHandle(), hndls);
	}


	native static final protected Handle gnome_popup_menu_new(Handle[] uiinfo);
	native static final protected Handle gnome_popup_menu_new_with_accelgroup(Handle[] uiinfo, Handle accelgroup);
    native static final protected Handle gnome_popup_menu_get_accel_group (Handle menu);
    native static final protected void gnome_popup_menu_attach (Handle menu, Handle widget, Object userData);
    native static final protected void gnome_popup_menu_append (Handle menu, Handle [] uiinfo);

}
