/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif


GdkEventType GdkEventNoExpose_get_type (GdkEventNoExpose * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventNoExpose
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventNoExpose_getType (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventNoExpose *obj_g = (GdkEventNoExpose *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventNoExpose_get_type (obj_g));
}

GdkWindow * GdkEventNoExpose_get_window (GdkEventNoExpose * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventNoExpose
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventNoExpose_getWindow (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventNoExpose *obj_g = (GdkEventNoExpose *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventNoExpose_get_window (obj_g));
}

gboolean GdkEventNoExpose_get_send_event (GdkEventNoExpose * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventNoExpose
 * Method:    getSendEvent
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventNoExpose_getSendEvent (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventNoExpose *obj_g = (GdkEventNoExpose *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkEventNoExpose_get_send_event (obj_g));
}


#ifdef __cplusplus
}

#endif
