/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <glib.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif
gpointer GList_get_data (GList * cptr) 
{
    return cptr->data;
}

/*
 * Class:     org.gnu.glib.List
 * Method:    getData
 * Signature: (Lorg/gnu/glib/Handle;)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_List_getData (JNIEnv *env, jclass cls, jobject obj) 
{
    GList *obj_g = (GList *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GList_get_data (obj_g));
}

/*
 * Class:     org.gnu.glib.List
 * Method:    g_list_append
 * Signature: (Lorg/gnu/glib/Handle;I)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_List_g_1list_1append (JNIEnv *env, jclass cls, jobject 
    list, jint data) 
{
    GList *list_g = (GList *)getPointerFromHandle(env, list);
    gpointer *data_g = (gpointer *)data;
    return getHandleFromPointer(env, g_list_append (list_g, data_g));
}

/*
 * Class:     org.gnu.glib.List
 * Method:    g_list_prepend
 * Signature: (Lorg/gnu/glib/Handle;I)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_List_g_1list_1prepend (JNIEnv *env, jclass cls, jobject 
    list, jint data) 
{
    GList *list_g = (GList *)getPointerFromHandle(env, list);
    gpointer *data_g = (gpointer *)data;
    return getHandleFromPointer(env, g_list_prepend (list_g, data_g));
}

/*
 * Class:     org.gnu.glib.List
 * Method:    g_list_insert
 * Signature: (Lorg/gnu/glib/Handle;II)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_List_g_1list_1insert (JNIEnv *env, jclass cls, jobject 
    list, jint data, jint position) 
{
    GList *list_g = (GList *)getPointerFromHandle(env, list);
    gpointer *data_g = (gpointer *)data;
    gint32 position_g = (gint32) position;
    return getHandleFromPointer(env, g_list_insert (list_g, data_g, position_g));
}

/*
 * Class:     org.gnu.glib.List
 * Method:    g_list_remove
 * Signature: (Lorg/gnu/glib/Handle;I)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_List_g_1list_1remove (JNIEnv *env, jclass cls, jobject 
    list, jint data) 
{
    GList *list_g = (GList *)getPointerFromHandle(env, list);
    gpointer *data_g = (gpointer *)data;
    return getHandleFromPointer(env, g_list_remove (list_g, data_g));
}

/*
 * Class:     org.gnu.glib.List
 * Method:    g_list_remove_all
 * Signature: (Lorg/gnu/glib/Handle;I)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_List_g_1list_1remove_1all (JNIEnv *env, jclass cls, 
    jobject list, jint data) 
{
    GList *list_g = (GList *)getPointerFromHandle(env, list);
    gpointer *data_g = (gpointer *)data;
    return getHandleFromPointer(env, g_list_remove_all (list_g, data_g));
}

/*
 * Class:     org.gnu.glib.List
 * Method:    g_list_free
 * Signature: (Lorg/gnu/glib/Handle;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_glib_List_g_1list_1free (JNIEnv *env, jclass cls, jobject list)
{
    GList *list_g = (GList *)getPointerFromHandle(env, list);
    g_list_free (list_g);
}

/*
 * Class:     org.gnu.glib.List
 * Method:    g_list_alloc
 * Signature: ()Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_List_g_1list_1alloc (JNIEnv *env, jclass cls) 
{
    return getHandleFromPointer(env, g_list_alloc ());
}

/*
 * Class:     org.gnu.glib.List
 * Method:    g_list_length
 * Signature: (Lorg/gnu/glib/Handle;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_glib_List_g_1list_1length (JNIEnv *env, jclass cls, jobject list) 
{
    GList *list_g = (GList *)getPointerFromHandle(env, list);
    return g_list_length (list_g);
}

/*
 * Class:     org.gnu.glib.List
 * Method:    g_list_first
 * Signature: (Lorg/gnu/glib/Handle;)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_List_g_1list_1first (JNIEnv *env, jclass cls, jobject list) 
{
    GList *list_g = (GList *)getPointerFromHandle(env, list);
    return getHandleFromPointer(env, g_list_first (list_g));
}

/*
 * Class:     org.gnu.glib.List
 * Method:    g_list_last
 * Signature: (Lorg/gnu/glib/Handle;)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_List_g_1list_1last (JNIEnv *env, jclass cls, jobject list)
{
    GList *list_g = (GList *)getPointerFromHandle(env, list);
    return getHandleFromPointer(env, g_list_last (list_g));
}

/*
 * Class:     org.gnu.glib.List
 * Method:    g_list_previous
 * Signature: (Lorg/gnu/glib/Handle;)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_List_g_1list_1previous (JNIEnv *env, jclass cls, jobject list) 
{
    GList *list_g = (GList *)getPointerFromHandle(env, list);
    return getHandleFromPointer(env, g_list_previous (list_g));
}

/*
 * Class:     org.gnu.glib.List
 * Method:    g_list_next
 * Signature: (Lorg/gnu/glib/Handle;)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_List_g_1list_1next (JNIEnv *env, jclass cls, jobject list)
{
    GList *list_g = (GList *)getPointerFromHandle(env, list);
    return getHandleFromPointer(env, g_list_next (list_g));
}


#ifdef __cplusplus
}

#endif
