/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <glib.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.glib.Quark
 * Method:    g_quark_from_string
 * Signature: (java.lang.String)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_Quark_g_1quark_1from_1string (JNIEnv *env, jclass cls, 
    jstring str) 
{
    const gchar* str_g = (*env)->GetStringUTFChars(env, str, 0);
    jobject quark = getHandleFromPointer(env, (void*)g_quark_from_string (str_g));
    (*env)->ReleaseStringUTFChars(env, str, str_g);
    return quark;
}

/*
 * Class:     org.gnu.glib.Quark
 * Method:    g_quark_try_string
 * Signature: (java.lang.String)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_gnu_glib_Quark_g_1quark_1try_1string (JNIEnv *env, jclass cls, 
    jstring str) 
{
    const gchar* str_g = (*env)->GetStringUTFChars(env, str, 0);
    jobject quark = getHandleFromPointer(env, (void*)g_quark_try_string (str_g));
    (*env)->ReleaseStringUTFChars(env, str, str_g);
    return quark;
}

/*
 * Class:     org.gnu.glib.Quark
 * Method:    g_quark_to_string
 * Signature: (Lorg/gnu/glib/Handle;)java.lang.String
 */
JNIEXPORT jstring JNICALL Java_org_gnu_glib_Quark_g_1quark_1to_1string (JNIEnv *env, jclass 
    cls, jobject quark) 
{
    GQuark quark_g = (GQuark)getPointerFromHandle(env, quark);
	return (*env)->NewStringUTF(env, g_quark_to_string (quark_g));
}


#ifdef __cplusplus
}

#endif
