# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=atk
VER=1.22.0
REV=1
ARCH=win64

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usestable
usemingw64
usemsvs9x64

(

set -x

DEPS=`/devel/src/tml/latest-win64.sh glib`

for D in $DEPS; do
    PKG_CONFIG_PATH=/devel/dist/win64/$D/lib/pkgconfig:$PKG_CONFIG_PATH
done

# Don't do any relinking crap in libtool.

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I can only
# do this if you have shared version of the library, which you do not
# appear to have." Screw libtool. I know what I am doing. Yes, I do
# want to link with a static libintl now. (The proxy-libintl libintl
# wrapper.) (Although Pango as such doesn't use any functions from
# libintl, the glib pc file insists on specifying -lintl on its Libs
# line, so libtool needs to find libintl.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

# Fix problems with libtool and Win64

sed -e 's!file format pe-i386!file format pe-!' <ltmain.sh >ltmain.sh.temp && mv ltmain.sh.temp ltmain.sh &&
sed -e 's!file_magic file format pei\*-i386!file_magic file format pei*-!' <configure >configure.temp && mv configure.temp configure &&

patch -p0 <<\EOF &&
--- atk/Makefile.in
+++ atk/Makefile.in
@@ -723,7 +723,7 @@
 @MS_LIB_AVAILABLE_FALSE@uninstall-ms-lib:
 
 atk-$(ATK_API_VERSION).lib: libatk-$(ATK_API_VERSION).la atk.def
-	lib -name:libatk-$(ATK_API_VERSION)-$(LT_CURRENT_MINUS_AGE).dll -def:atk.def -out:$@
+	lib -machine:X64 -name:libatk-$(ATK_API_VERSION)-$(LT_CURRENT_MINUS_AGE).dll -def:atk.def -out:$@
 
 distclean-local:
 	if test $(srcdir) = .; then :; else \
EOF

CC='x86_64-pc-mingw32-gcc' CPPFLAGS='-I/opt/proxy-libintl/include' LDFLAGS='-L/opt/proxy-libintl/lib64 -Wl,--exclude-libs=libintl.a -Wl,--enable-auto-image-base' CFLAGS=-O2 ./configure --host=x86_64-pc-mingw32 --disable-gtk-doc --disable-static --prefix=c:/devel/target/$HEX

libtoolcacheize
(cd atk; make atkmarshal.h atkmarshal.c) &&
make install &&

./atk-zip.sh &&

mv /tmp/atk-$VER.zip /tmp/$RUNZIP &&
mv /tmp/atk-dev-$VER.zip /tmp/$DEVZIP

) 2>&1 | tee /devel/src/tml/make/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/make/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
