# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=pango
VER=1.20.2
THIS=$MOD-$VER
HEX=`echo $THIS | md5sum | cut -d' ' -f1`

DEPS=`/devel/src/tml/latest.sh glib pixman cairo`

# Don't do any relinking crap in libtool.

sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I can only
# do this if you have shared version of the library, which you do not
# appear to have." Screw libtool. I know what I am doing. Yes, I do
# want to link with a static libintl now. (The proxy-libintl libintl
# wrapper.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure

usedev
usemsvs6

MY_PKG_CONFIG_PATH=""
for D in $DEPS; do
    PATH=/devel/dist/$D/bin:$PATH
    MY_PKG_CONFIG_PATH=/devel/dist/$D/lib/pkgconfig:$MY_PKG_CONFIG_PATH
done
PKG_CONFIG_PATH=$MY_PKG_CONFIG_PATH:$PKG_CONFIG_PATH CC='gcc -mtune=pentium3 -mthreads' LDFLAGS='-L/opt/proxy-libintl/lib -Wl,--enable-auto-image-base' CFLAGS=-O2 ./configure --enable-debug=yes --disable-gtk-doc --without-x --prefix=c:/devel/target/$HEX  --enable-explicit-deps=no --with-included-modules=yes &&
libtoolcacheize &&
unset MY_PKG_CONFIG_PATH &&
PATH=/devel/target/$HEX/bin:.libs:$PATH make -j3 install &&
./pango-zip.sh &&
(cd /devel/src/tml && zip /tmp/$MOD-dev-$VER.zip make/$THIS.sh) &&
manifestify /tmp/$MOD*-$VER.zip
