# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=libbzip2
VER=1.0.5
REV=2
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev

(

set -x

mkdir bin include lib $TARGET

# Produce same name for DLL bzip2.dll as gnuwin32. Also, export the
# functions with the stdcall decoration like they do.

# Note that this is not the normal procedure. At least Microsoft's
# DLLs with stdcall functions export undecorated names. And most Open
# Source libraries I have buil just use the default cdecl calling
# convention, not stdcall.

# Use a .def file to just export the actual API functions, not
# private symbols.

# Note that the libbz2.def in the official sources indicates that the
# desired name for the DLL would be libbz2.dll, and the exported
# functions uncodorated? But that libbzip2.def is probably quite old,
# the manual.html talks about it being contributed by somebody using
# Visual C++ 5.0...

# As a sidenote, the bzip2 DLL in the openSUSE cross-compilation
# project is called bz2-1.dll, which seems to indicate that they use
# libtool to build it. No libtool support in the official sources
# though.

# Maybe it would make more sense to ignore ABI compatibility with the
# gnuwin32 build and just call the DLL libbz2.dll, and then also patch
# out the WINAPI calling convention from bzlib.h and just use the
# default cdecl?

cat >bzip2.def <<EOF
LIBRARY bzip2.dll
EXPORTS
BZ2_bzBuffToBuffCompress@28
BZ2_bzBuffToBuffDecompress@24
BZ2_bzCompress@8
BZ2_bzCompressEnd@4
BZ2_bzCompressInit@16
BZ2_bzDecompress@4
BZ2_bzDecompressEnd@4
BZ2_bzDecompressInit@12
BZ2_bzRead@16
BZ2_bzReadClose@8
BZ2_bzReadGetUnused@16
BZ2_bzReadOpen@24
BZ2_bzWrite@16
BZ2_bzWriteClose64@28
BZ2_bzWriteClose@20
BZ2_bzWriteOpen@20
BZ2_bzclose@4
BZ2_bzdopen@8
BZ2_bzerror@8
BZ2_bzflush@4
BZ2_bzlibVersion@0
BZ2_bzopen@8
BZ2_bzread@12
BZ2_bzwrite@12
EOF

gcc -Wall -O2 -shared -o bin/bzip2.dll bzip2.def blocksort.c huffman.c crctable.c randtable.c compress.c decompress.c bzlib.c -Wl,--out-implib,lib/libbz2.dll.a

gcc -Wall -O2 -o bin/bzip2.exe bzip2.c -Llib -lbz2

cp bzlib.h include

zip /tmp/$RUNZIP bin/bzip2.dll
zip /tmp/$DEVZIP lib/libbz2.dll.a include/bzlib.h bin/bzip2.exe

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
